---
title: v1.0.0-beta.1
tag_name: v1.0.0-beta.1
link: https://github.com/phenomic/phenomic/releases/tag/v1.0.0-beta.1
author: MoOx
prerelease: true
---

This release might include breaking changes for you.

This is one of the final step before stable 1.0.0! The breaking changes included
in this release are for the best. We have worked hard so you can be able to use
simple options for plugins, exactly like babel. More on this below.

**If you use `@phenomic/preset-react-app` without any customisation, you are
probably all good**

- Just be careful if you where using JSON
- If you code was working without any warning, you don’t have anything to do
  except looking for `hasNextPage` & `hasPreviousPage`. If you were still using
  those, just replace your test with the presence of next`or`previous` directly.

**If your are using custom plugins, you will have to update some signatures.**

## 🚨Breaking changes

[🚨 Remove deprecated attributes for pagination and routes](https://github.com/phenomic/phenomic/commit/fe68e8c94db3054d68582f4cbb68b86e63eb6b2c)
by @MoOx

[🐛 🚨 `@phenomic/plugin-transform-json`: support array by passing all js on as data (+use a partial version is accessible)](https://github.com/phenomic/phenomic/commit/84e3abd928779a734779e1b6a61eb9006cb28e05)
by @MoOx

Previously, using JSON files that were array was broken. We were spreading JSON
like if it was an object. We adjusted the behavior that might affect `partial`
(when you fetch list via queries) if you had a "partial" entry in your JSON
(edge case). Reach us on our community tools if you struggle updating.

[🚨 `@phenomic/plugin-transform-markdown`: upgrade to gray-matter@3](https://github.com/phenomic/phenomic/commit/cba0e43521c98d7bf789e7bf472abb141c1f84e1)
by @MoOx

If you are using something else than JSON, YAML of JavaScript in your
front-matter, please open an issue so we can improve the situation so we can
work on allowing `engine` option
https://www.npmjs.com/package/gray-matter#optionsengines

[🚨 `@phenomic/core`: `collect` method for plugin should now be `collectFile`.](https://github.com/phenomic/phenomic/commit/2d2f806cfee35aa6fa21d88ba5465bb37dad8119)
by @MoOx

[🚨 `@phenomic/core`: many plugin methods have their signature that have been updated](https://github.com/phenomic/phenomic/commit/2d2f806cfee35aa6fa21d88ba5465bb37dad8119)
by @MoOx

Please check flow definitions until docs is online (major change is that config
is not send since plugin receive it when it's created). All signatures for
plugin have been adjusted. Please take a look if you are a plugin author. See
https://github.com/phenomic/phenomic/blob/954fbe16f20a51af90cbd6a25502da1426e4bdc5/flow-typed/phenomic.js#L159-L202

## ✨ New features and improvements

[✨ `@phenomic/*`: we can now configure every plugins from phenomic config.](https://github.com/phenomic/phenomic/commit/2d2f806cfee35aa6fa21d88ba5465bb37dad8119)
by @MoOx

See last item of this list to see an example ;)

[✨ `@phenomic/core`: support `baseUrl` option in configuration](https://github.com/phenomic/phenomic/commit/edfefa9488c656a21a01d7c691bd9629de975449)
by @MoOx

You can now send a baseUrl in phenomic configuration. This allow website to work
at a folder level of a domain (eg: http://domain.tld/root/).

```json
{
  "baseUrl": "http://mydomain.com/root-of-my-site/“,
  "presets": ["@phenomic/preset-react-app"]
}
```

**Note that this will directly be reflected during development for your mental
health! This means you will have to open
`http://localhost:3333/root-of-my-site/`**

[✨ `@phenomic/core`: support .env(.\_)? files for PHENOMIC\_\_ env vars](https://github.com/phenomic/phenomic/commit/62378ca14bc87365b5b2b0448254b64acdce1944)
by @MoOx

Like CRA support `REACT_APP_*` env var to be passed over to your JavaScript
during compilation, you will have access to `PHENOMIC_*` var that you can define
from .env files. We are using https://github.com/motdotla/dotenv hunder the
hood.

[✨ `@phenomic/core`: we added a new plugin api so any plugin can add static or dynamic url on runtime (`resolveURLs`)](https://github.com/phenomic/phenomic/commit/2d2f806cfee35aa6fa21d88ba5465bb37dad8119)
by @MoOx

[✨ `@phenomic/core`: `renderStatic` is now not limited to a single plugin. Multiples plugins (those that have a `resolveURLs` can now render static files).](https://github.com/phenomic/phenomic/commit/2d2f806cfee35aa6fa21d88ba5465bb37dad8119)
by @MoOx

[✨ `@phenomic/api-client`: `import fetchRestApi from "@phenomic/api-client/lib/fetch";` to fetch phenomic api directly.](https://github.com/phenomic/phenomic/commit/2d2f806cfee35aa6fa21d88ba5465bb37dad8119)
by @MoOx

This method is mostly for plugin developers. Calling this method should be made
with `import query from "@phenomic/api-client/lib/query”;`. Be careful to use
this method wisely as it won’t be magically pre-rendered for all end point
unless a plugin handle the static rendering of the resource.

[✨ `@phenomic/plugin-bundler-webpack`: respect `baseUrl` option](https://github.com/phenomic/phenomic/commit/edfefa9488c656a21a01d7c691bd9629de975449)
by @MoOx

[✨ `@phenomic/plugin-bundler-webpack`: inject NODE*ENV + PHENOMIC*\* env var (PHENOMIC_ENV & PHENOMIC_APP_BASENAME for now)](https://github.com/phenomic/phenomic/commit/edfefa9488c656a21a01d7c691bd9629de975449)
by @MoOx

[✨ `@phenomic/plugin-renderer-react`: expose enhanced Link component that respect `baseUrl` option](https://github.com/phenomic/phenomic/commit/edfefa9488c656a21a01d7c691bd9629de975449)
by @MoOx

[✨ `@phenomic/plugin-rss-feed`: this is now a thing and can generate multiples feed](https://github.com/phenomic/phenomic/commit/4584963559c0ef9e71612e709b14b9006085ffed)
by @MoOx

Example of the config for Phenomic website

```json
{
  "baseUrl": "http://phenomic.io/",
  "presets": ["@phenomic/preset-react-app"],
  "plugins": [
    [
      "@phenomic/plugin-rss-feed",
      {
        "feeds": {
          "feed.xml": {
            "feedOptions": {
              "title": "Phenomic.io",
              "description": "Phenomic news"
            },
            "query": { "path": "news", "limit": 20 }
          }
        }
      }
    ]
  ]
}
```

📝 Various minor docs improvements by @getDanArias
