---
title: v1.0.0-alpha.6
tag_name: v1.0.0-alpha.6
link: https://github.com/phenomic/phenomic/releases/tag/v1.0.0-alpha.6
author: MoOx
prerelease: true
---

We have made some tiny breaking changes (easy to update) for a better future (to
give you more power (eg: query for sub-folder & choice for whatever css-in-js
solution you want :)

We have added plenty of
[examples](https://github.com/phenomic/phenomic/tree/master/examples). Be sure
to take a look!

FYI, those examples will always be up to date with Phenomic API as those are
automatically tested in our full test suit (with some assertions to check the
result)!

# tl;dr

## 💥 **Breaking change**

- `collection` concept has been replaced by a simple `path`.
- Html component must be in its own file & offers controls for rendering of the
  HTML (eg: for CSS-in-JS static rendering), see details below.
- Some change simple have been made for API of render plugins (if you wrote one,
  let us know!).

## ✨ New features

- JS/CSS now have hashes in the filename to avoid caching issues.
- CSS files can now be easily injected in the Html.
- Some enhancements on webpack default config.
- React plugin now exports a function to render content as raw text (handy for
  meta description & similar)

---

## Details

### `@phenomic/core`

- 💥 **Breaking change** we changed a little renderer plugin API:
  - `renderServer` becomes `renderStatic`
  - `renderHTML` is now hidden and replaced by `renderDevServer` method that
    accept assets (key: array of filenames) returned by build or injected by
    `addDevServerMiddlewares` in res.locals.assets (@MoOx)
- 💥 **Breaking change** `collection` concept has been replaced by a simple
  `path`. You can just replace all `collection` in your query by `path` and it
  should work. What you are winning here is the ability to query using a
  sub-folder.

### `@phenomic/plugin-bundler-webpack`

- Upgrade to webpack@^3.0.0. It's a bit faster on our website (28s vs 24s -
  Phenomic part is > 2s).
  ([#1137](https://github.com/phenomic/phenomic/pull/1137) - @MoOx)
- Properly pass assets to the core (so CSS and JS files are known) (@MoOx)

### `@phenomic/plugin-renderer-react` & `@phenomic/preset-react-app`

- 💥 **Breaking change** props passed to Html components are now components to
  render & not string. This will allow people to wrap rendering (eg: so they can
  use whatever CSS-in-JS solutions).

Previously, a minimal `Html` component was like

```js
const Html = props => (
  <html>
    <head>
      <meta charSet="utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1" />
    </head>
    <body className="wrapper">
      {props.body}
      {props.state}
      {props.script}
    </body>
  </html>
);
```

Now it should be

```js
const Html = ({ App, render }) => {
  const { Main, State, Script, Style } = render(<App />);
  // you have also an `assets` object if you want more control to renders js/css files
  return (
    <html>
      <head>
        <meta charSet="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <Style />
      </head>
      <body className="wrapper">
        <Main />
        <State />
        <Script />
      </body>
    </html>
  );
```

([#1094](https://github.com/phenomic/phenomic/issues/1094) - @MoOx)

- A new `textRenderer` to convert page content to raw text is now export.

```js
import {
  createApp,
  createContainer,
  query,
  BodyRenderer,
  /***** I AM NEW *****/
  textRenderer,
  /********************/
} from "@phenomic/preset-react-app/lib/client";
// also available from "@phenomic/plugin-renderer-react/lib/client"

const BlogPost = ({ isLoading, page }) => (
  <div>
    {isLoading && "Loading..."}
    {!isLoading &&
      page.node && (
        <article>
          <Head>
            <title>{page.node.title}</title>
            /***** TRY ME *****/
            <meta
              name="description"
              content={textRenderer(page.node.body).slice(0, 150) + "…"}
            />
            /******************/
          </Head>
          <h1>{page.node.title}</h1>
          <BodyRenderer>{page.node.body}</BodyRenderer>
        </article>
      )}
    {/* ... */}
  </div>
);
```

([#1084](https://github.com/phenomic/phenomic/issues/1084) - @MoOx)
