# Building your app as static HTML files

A single command to build your site into a `dist` folder

```console
npm run build
```

⚠️ **Note that this folder need to be served from a real web server.** You
cannot just open an `index.html` and expect the client code to work correctly.
If you want to run the built project locally, you can run it with these commands

```console
npm install -g serve
serve dist
```

This will install a small web server and launch your project from `dist`.

## Debugging static build

During the static build, you might get some different kinds of errors

### `Invariant Violation`

```
Invariant Violation: Minified React error #61; visit http://facebook.github.io/react/docs/error-decoder.html?invariant=61 for the full message or use the non-minified dev environment for full errors and additional helpful warnings.
```

By default, the static build has `process.env.NODE_ENV` set to `production`. You
can start the static build like this

```console
NODE_ENV=development npm run build
```

Then you can return to the console and you should have a more explicit error.

### Debugging Phenomic core

Phenomic uses [debug](https://github.com/visionmedia/debug) under the hood, so
it's pretty easy to get a very verbose output in your terminal. You can start or
build your project by prefixing your command with the `DEBUG` environment
variable set to `phenomic:*`

```console
NODE_ENV=development DEBUG=phenomic:* npm run build
```

Depending on what you want to view/filter, you can use a more spefic value for
`DEBUG` (eg: `DEBUG=phenomic:core:*`).

## Deploying static build

You can deploy the `dist` folder to any kind of static hosting. Nothing special
is supposed to be done!

---

Congratulations! You successfully followed our tutorial. You can find the source
in
[phenomic/examples/react-app-getting-started](https://github.com/phenomic/phenomic/tree/master/examples/react-app-getting-started)
