# Hot loading

You might be interested by hot loading, which allow you to edit your code and
get instant feedback in your browser. By default, CSS changes will already be
instantly hot loaded, like the content. But you might also want to tweak your
React components in real time. In order to do that, you have to edit a little
your `App.js`:

Replace this

```js
import { createApp } from "@phenomic/preset-react-app/lib/client";

// ...

export default createApp(() => (
  <Router history={browserHistory}>{/* ... */}</Router>
));
```

By the following code:

```js
import { createApp, renderApp } from "@phenomic/preset-react-app/lib/client";

// ...

const routes = () => <Router history={browserHistory}>{/* ... */}</Router>;

export default createApp(routes);

if (module.hot) {
  module.hot.accept(() => renderApp(routes));
}
```

This will re-render your app as soon as an update in your code is received.

---

→ [Continue tutorial](09.md)
