# Adding a page from markdown file

One homepage is cool, but we might want to add more content. Let's create a
markdown file in our `content` folder.

Place the content below in a new file `content/posts/first-post.md`.

```md
# This is a [Markdown](https://en.wikipedia.org/wiki/Markdown#Example) file

If you are new to Markdown, you might want to check those links:

- [What is Markdown?](http://whatismarkdown.com/)
- [Mastering Markdown, a GitHub guide](https://guides.github.com/features/mastering-markdown/)
- [wikipedia.org/wiki/Markdown](https://en.wikipedia.org/wiki/Markdown#Example)
- [masteringmarkdown.com](http://masteringmarkdown.com/)
```

Now let's add a simple route to our `App.js`

```js
export default createApp(() => (
  <Router history={browserHistory}>
    <Route path="/" component={Home} />
    <Route path="/blog/*" component={BlogPostContainer} />
  </Router>
));
```

We also need to create a `BlogPostContainer` component to render the posts.

```js
import { Router, Route, browserHistory, Link } from "react-router";
import {
  createApp,
  withPhenomicApi,
  query,
  BodyRenderer
} from "@phenomic/preset-react-app/lib/client";

// ...

const BlogPost = ({ isLoading, page }) => (
  <div>
    {isLoading && "Loading..."}
    {!isLoading &&
      page.node && (
        <article>
          <h1>{page.node.title}</h1>
          <BodyRenderer>{page.node.body}</BodyRenderer>
        </article>
      )}
    <footer>
      <Link to="/">Go to home</Link>
    </footer>
  </div>
);

const BlogPostContainer = withPhenomicApi(BlogPost, props => ({
  page: query({ path: "content/posts", id: props.params.splat })
}));

// ...
export default createApp(() => (
  // ...
))
```

In our example above, we are doing a `query` on the path `content/posts`. We are using
the `id` to find a single item. `id` is the filename, in our case
`first-post` (the .md extension is ignored, and `stuff/index.md` being
considered as `stuff`).

## Accessing the markdown page

We just created a route and a component to retrieve the markdown file. Now we
can access our post by accessing directly
[http://localhost:3333/blog/first-post/](http://localhost:3333/blog/first-post/).

---

→ [Continue tutorial](04.md)
