# Your first page

Now we will need to create the entry point of your website/app. Let's create a
file `App.js`, placing it on the root directory of your project (sibling to
`package.json`).

```js
import React from "react";
import { Router, Route, browserHistory } from "react-router";
import { createApp } from "@phenomic/preset-react-app/lib/client";

const Home = () => (
  <div>
    <p>This is a homepage</p>
  </div>
);

export default createApp(() => (
  <Router history={browserHistory}>
    <Route path="/" component={Home} />
  </Router>
));
```

Here we defined a router with one route that will be the homepage. Let's check
this page in a browser.

## Starting the development server

Phenomic CLI have 2 commands: `start` (development server) and `build` (to
generate static build).

Let's add this commands into some scripts of the `package.json`

```json
{
  "...": "...",
  "scripts": {
    "start": "phenomic start",
    "build": "phenomic build"
  }
}
```

<details>
<summary>See complete <code>package.json</code></summary>

```json
{
  "private": true,
  "devDependencies": {
    "@phenomic/core": "^1.0.0-alpha.1",
    "@phenomic/cli": "^1.0.0-alpha.1",
    "@phenomic/preset-react-app": "^1.0.0-alpha.1",
    "react": "^16.8.0",
    "react-dom": "^16.8.0",
    "react-router": "^3.2.0"
  },
  "phenomic": {
    "presets": ["@phenomic/preset-react-app"]
  },
  "scripts": {
    "start": "phenomic start",
    "build": "phenomic build"
  }
}
```

</details>

Now we can use `npm start` to start the website/app. Website/app should be
accessible via [http://localhost:3333](http://localhost:3333).

Enjoy your hello world!

---

→ [Continue tutorial](03.md)
