# Installation

The react preset we are going to use will work with React and Webpack.

```console
npm install --save-dev react react-dom react-router@^3.2.0
npm install --save-dev @phenomic/core @phenomic/cli @phenomic/preset-react-app
```

These lines will install Phenomic and its
[react app preset](https://github.com/phenomic/phenomic/tree/master/packages/preset-react-app).

⚠️ _If you don't have a `package.json` you can do this simple command to get a
valid one:_

```console
echo '{"private":true}' > package.json
```

---

The react preset will allow you to consume Markdown and JSON files as data
resources to generate your website/app.

<details>
<summary>See complete <code>package.json</code></summary>
(versions might be more recent)

```json
{
  "private": true,
  "devDependencies": {
    "@phenomic/core": "^1.0.0-alpha.1",
    "@phenomic/cli": "^1.0.0-alpha.1",
    "@phenomic/preset-react-app": "^1.0.0-alpha.1",
    "react": "^16.8.0",
    "react-dom": "^16.8.0",
    "react-router": "^3.2.0"
  }
}
```

</details>

## Configuration

Here we going to tell Phenomic the plugins we want to use via the preset. To do
so, we are going to add a `phenomic` section in our `package.json`

```json
{
  "...": "...",
  "phenomic": {
    "presets": ["@phenomic/preset-react-app"]
  }
}
```

<details>
<summary>See complete <code>package.json</code></summary>

```json
{
  "private": true,
  "devDependencies": {
    "@phenomic/core": "^1.0.0-alpha.1",
    "@phenomic/cli": "^1.0.0-alpha.1",
    "@phenomic/preset-react-app": "^1.0.0-alpha.1",
    "react": "^16.8.0",
    "react-dom": "^16.8.0",
    "react-router": "^3.2.0"
  },
  "phenomic": {
    "presets": ["@phenomic/preset-react-app"]
  }
}
```

</details>

---

→ [Continue tutorial](02.md)
