---
title: Introduction
priority: 1
---

Phenomic is a modular website compiler that helps you build static websites
optimised for SEO and UX with a modern approach: you can **build your website
the same way you build an app**.

Phenomic differs from other SSGs by allowing you to pick the technologies,
libraries, and frameworks of your choice and build your website with them. You
can decide which renderer you want to use (such as _React_), which bundler (such
as _Webpack_) and so on. If the solution you want is not implemented yet,
**Phenomic accepts plugins** so you can bring your own flavor!

What Phenomic produces is simple: **static files** that you can deploy on any
static hosting system (HTML, CSS, JavaScript, images etc). This means the server
where you deploy your website doesn't require a runtime. The result served will
be **an SEO friendly website** (all pages are pre-built and can be served as
HTML files) that is **optimised for fast browsing** (after the first HTML page,
JavaScript files will handle client side navigation and only download what is
necessary without full page reloads).

You can thus offer the **best user experience** by immediately serving
pre-generated HTML for first visits (or all pages, for search engine bots and
browsers that don't interpret JavaScript) and then using the power of JavaScript
to **avoid full page reloads** by only downloading small chunks of data for each
additional page & interaction.
