"""archive columns

Revision ID: 0006
Revises: 0005
Create Date: 2025-01-21 18:55:17.314161

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "0006"
down_revision: str | None = "0005"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("generations", schema=None) as batch_op:
        batch_op.add_column(sa.Column("archived", sa.DateTime(), nullable=True))
        batch_op.create_index(
            batch_op.f("generations_archived_idx"), ["archived"], unique=False
        )

    with op.batch_alter_table("prompts", schema=None) as batch_op:
        batch_op.add_column(sa.Column("archived", sa.DateTime(), nullable=True))
        batch_op.create_index(
            batch_op.f("prompts_archived_idx"), ["archived"], unique=False
        )

    with op.batch_alter_table("spans", schema=None) as batch_op:
        batch_op.drop_constraint("spans_parent_span_id_spans_fkey", type_="foreignkey")
        batch_op.create_foreign_key(
            batch_op.f("spans_parent_span_id_spans_fkey"),
            "spans",
            ["parent_span_id"],
            ["span_id"],
            ondelete="CASCADE",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("spans", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("spans_parent_span_id_spans_fkey"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            "spans_parent_span_id_spans_fkey", "spans", ["parent_span_id"], ["span_id"]
        )

    with op.batch_alter_table("prompts", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("prompts_archived_idx"))
        batch_op.drop_column("archived")

    with op.batch_alter_table("generations", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("generations_archived_idx"))
        batch_op.drop_column("archived")

    # ### end Alembic commands ###
