"""first migration

Revision ID: 0001
Revises:
Create Date: 2024-12-18 20:26:39.034946

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op
from sqlmodel.sql.sqltypes import AutoString

from lilypad.server.models.base_sql_model import JSONTypeDecorator

# revision identifiers, used by Alembic.
revision: str = "0001"
down_revision: str | None = None
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "device_codes",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("id", AutoString(), nullable=False),
        sa.Column("token", AutoString(), nullable=False),
        sa.PrimaryKeyConstraint("uuid", "id", name=op.f("device_codes_pkey")),
    )
    op.create_table(
        "organizations",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("name", AutoString(), nullable=False),
        sa.PrimaryKeyConstraint("uuid", name=op.f("organizations_pkey")),
    )
    op.create_table(
        "users",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("first_name", AutoString(), nullable=False),
        sa.Column("last_name", AutoString(), nullable=True),
        sa.Column("email", AutoString(), nullable=False),
        sa.Column("active_organization_uuid", sa.Uuid(), nullable=True),
        sa.Column(
            "keys",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("users_pkey")),
    )
    op.create_index(op.f("users_email_idx"), "users", ["email"], unique=False)
    op.create_table(
        "projects",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("organization_uuid", sa.Uuid(), nullable=False),
        sa.Column("name", AutoString(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_uuid"],
            ["organizations.uuid"],
            name=op.f("projects_organization_uuid_organizations_fkey"),
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("projects_pkey")),
        sa.UniqueConstraint("name", name=op.f("projects_name_key")),
    )
    op.create_index(
        op.f("projects_organization_uuid_idx"),
        "projects",
        ["organization_uuid"],
        unique=False,
    )
    op.create_table(
        "user_organizations",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("organization_uuid", sa.Uuid(), nullable=False),
        sa.Column("role", sa.Enum("ADMIN", "MEMBER", name="userrole"), nullable=False),
        sa.Column("user_uuid", sa.Uuid(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_uuid"],
            ["organizations.uuid"],
            name=op.f("user_organizations_organization_uuid_organizations_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["user_uuid"],
            ["users.uuid"],
            name=op.f("user_organizations_user_uuid_users_fkey"),
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("user_organizations_pkey")),
    )
    op.create_index(
        op.f("user_organizations_organization_uuid_idx"),
        "user_organizations",
        ["organization_uuid"],
        unique=False,
    )
    op.create_index(
        op.f("user_organizations_user_uuid_idx"),
        "user_organizations",
        ["user_uuid"],
        unique=False,
    )
    op.create_table(
        "prompts",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("organization_uuid", sa.Uuid(), nullable=False),
        sa.Column("project_uuid", sa.Uuid(), nullable=True),
        sa.Column("version_num", sa.Integer(), nullable=True),
        sa.Column("name", AutoString(), nullable=False),
        sa.Column("signature", AutoString(), nullable=False),
        sa.Column("code", AutoString(), nullable=False),
        sa.Column("hash", AutoString(), nullable=False),
        sa.Column(
            "dependencies",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.Column("template", AutoString(), nullable=False),
        sa.Column("is_default", sa.Boolean(), nullable=False),
        sa.Column(
            "call_params",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.Column(
            "arg_types",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["organization_uuid"],
            ["organizations.uuid"],
            name=op.f("prompts_organization_uuid_organizations_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["project_uuid"],
            ["projects.uuid"],
            name=op.f("prompts_project_uuid_projects_fkey"),
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("prompts_pkey")),
    )
    op.create_index(op.f("prompts_hash_idx"), "prompts", ["hash"], unique=False)
    op.create_index(op.f("prompts_name_idx"), "prompts", ["name"], unique=False)
    op.create_index(
        op.f("prompts_organization_uuid_idx"),
        "prompts",
        ["organization_uuid"],
        unique=False,
    )
    op.create_table(
        "response_models",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("organization_uuid", sa.Uuid(), nullable=False),
        sa.Column("project_uuid", sa.Uuid(), nullable=True),
        sa.Column("name", AutoString(), nullable=False),
        sa.Column("signature", AutoString(), nullable=False),
        sa.Column("code", AutoString(), nullable=False),
        sa.Column("hash", AutoString(), nullable=False),
        sa.Column(
            "dependencies",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.Column(
            "schema_data",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.Column(
            "examples",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_uuid"],
            ["organizations.uuid"],
            name=op.f("response_models_organization_uuid_organizations_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["project_uuid"],
            ["projects.uuid"],
            name=op.f("response_models_project_uuid_projects_fkey"),
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("response_models_pkey")),
    )
    op.create_index(
        op.f("response_models_hash_idx"), "response_models", ["hash"], unique=False
    )
    op.create_index(
        op.f("response_models_name_idx"), "response_models", ["name"], unique=False
    )
    op.create_index(
        op.f("response_models_organization_uuid_idx"),
        "response_models",
        ["organization_uuid"],
        unique=False,
    )
    op.create_table(
        "generations",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("organization_uuid", sa.Uuid(), nullable=False),
        sa.Column("project_uuid", sa.Uuid(), nullable=True),
        sa.Column("prompt_uuid", sa.Uuid(), nullable=True),
        sa.Column("response_model_uuid", sa.Uuid(), nullable=True),
        sa.Column("version_num", sa.Integer(), nullable=True),
        sa.Column("name", AutoString(), nullable=False),
        sa.Column("signature", AutoString(), nullable=False),
        sa.Column("code", AutoString(), nullable=False),
        sa.Column("hash", AutoString(), nullable=False),
        sa.Column(
            "dependencies",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.Column(
            "arg_types",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["organization_uuid"],
            ["organizations.uuid"],
            name=op.f("generations_organization_uuid_organizations_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["project_uuid"],
            ["projects.uuid"],
            name=op.f("generations_project_uuid_projects_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["prompt_uuid"],
            ["prompts.uuid"],
            name=op.f("generations_prompt_uuid_prompts_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["response_model_uuid"],
            ["response_models.uuid"],
            name=op.f("generations_response_model_uuid_response_models_fkey"),
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("generations_pkey")),
    )
    op.create_index(op.f("generations_hash_idx"), "generations", ["hash"], unique=True)
    op.create_index(op.f("generations_name_idx"), "generations", ["name"], unique=False)
    op.create_index(
        op.f("generations_organization_uuid_idx"),
        "generations",
        ["organization_uuid"],
        unique=False,
    )
    op.create_table(
        "spans",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("organization_uuid", sa.Uuid(), nullable=False),
        sa.Column("span_id", AutoString(), nullable=False),
        sa.Column("project_uuid", sa.Uuid(), nullable=True),
        sa.Column("generation_uuid", sa.Uuid(), nullable=True),
        sa.Column("prompt_uuid", sa.Uuid(), nullable=True),
        sa.Column("response_model_uuid", sa.Uuid(), nullable=True),
        sa.Column(
            "type", sa.Enum("GENERATION", "PROMPT", name="spantype"), nullable=True
        ),
        sa.Column("cost", sa.Float(), nullable=True),
        sa.Column("scope", sa.Enum("LILYPAD", "LLM", name="scope"), nullable=False),
        sa.Column(
            "data",
            JSONTypeDecorator(),
            nullable=True,
        ),
        sa.Column("parent_span_id", AutoString(), nullable=True),
        sa.ForeignKeyConstraint(
            ["generation_uuid"],
            ["generations.uuid"],
            name=op.f("spans_generation_uuid_generations_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["organization_uuid"],
            ["organizations.uuid"],
            name=op.f("spans_organization_uuid_organizations_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["parent_span_id"],
            ["spans.span_id"],
            name=op.f("spans_parent_span_id_spans_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["project_uuid"],
            ["projects.uuid"],
            name=op.f("spans_project_uuid_projects_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["prompt_uuid"],
            ["prompts.uuid"],
            name=op.f("spans_prompt_uuid_prompts_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["response_model_uuid"],
            ["response_models.uuid"],
            name=op.f("spans_response_model_uuid_response_models_fkey"),
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("spans_pkey")),
        sa.UniqueConstraint("span_id", name=op.f("spans_span_id_key")),
    )
    op.create_index("ix_spans_span_id", "spans", ["span_id"], unique=False)
    op.create_index(
        op.f("spans_organization_uuid_idx"),
        "spans",
        ["organization_uuid"],
        unique=False,
    )
    op.create_index(op.f("spans_span_id_idx"), "spans", ["span_id"], unique=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("spans_span_id_idx"), table_name="spans")
    op.drop_index(op.f("spans_organization_uuid_idx"), table_name="spans")
    op.drop_index("ix_spans_span_id", table_name="spans")
    op.drop_table("spans")
    op.drop_index(op.f("generations_organization_uuid_idx"), table_name="generations")
    op.drop_index(op.f("generations_name_idx"), table_name="generations")
    op.drop_index(op.f("generations_hash_idx"), table_name="generations")
    op.drop_table("generations")
    op.drop_index(
        op.f("response_models_organization_uuid_idx"), table_name="response_models"
    )
    op.drop_index(op.f("response_models_name_idx"), table_name="response_models")
    op.drop_index(op.f("response_models_hash_idx"), table_name="response_models")
    op.drop_table("response_models")
    op.drop_index(op.f("prompts_organization_uuid_idx"), table_name="prompts")
    op.drop_index(op.f("prompts_name_idx"), table_name="prompts")
    op.drop_index(op.f("prompts_hash_idx"), table_name="prompts")
    op.drop_table("prompts")
    op.drop_index(
        op.f("user_organizations_user_uuid_idx"), table_name="user_organizations"
    )
    op.drop_index(
        op.f("user_organizations_organization_uuid_idx"),
        table_name="user_organizations",
    )
    op.drop_table("user_organizations")
    op.drop_index(op.f("projects_organization_uuid_idx"), table_name="projects")
    op.drop_table("projects")
    op.drop_index(op.f("users_email_idx"), table_name="users")
    op.drop_table("users")
    op.drop_table("organizations")
    op.drop_table("device_codes")
    sa.Enum(name="userrole").drop(op.get_bind(), checkfirst=False)
    sa.Enum(name="spantype").drop(op.get_bind(), checkfirst=False)
    sa.Enum(name="scope").drop(op.get_bind(), checkfirst=False)
    # ### end Alembic commands ###
