# DeepSeek_Prompt_Engineering
## Introduction

随着人工智能的快速发展，掌握如何使用人工智能已经成为必不可少的一门技能，而 Prompt Engineering （提示工程）是初学者最好入门的人工智能技术之一。而 DeepSeek 作为现如今性价比最高的模型，我们决定调用其 API，从而可以在尽可能花费更低成本的情况下学习 Prompt Engineering 技术。

该教程会一步一步指导你进入 Prompt Engineering 的世界，通过本教程你可以收获到：

- 📚 从初级到高级的 Prompt Engineering 技术
- 🛠️ 快速构建 Prompt 的实用模板
- 🧠 进一步探索 LLM 技术的基础

------

## Contents

1. [Basic of Prompt Engineering](https://github.com/Minghao-Liang/DeepSeek_Prompt_Engineering/blob/main/1-basic.ipynb)

   介绍如何调用 DeepSeek 的 API，以及通过基础的提示词来与模型进行交互。

2. [Multi-turn prompts in conversations](https://github.com/Minghao-Liang/DeepSeek_Prompt_Engineering/blob/main/2-multi_turn_prompts.ipynb)

   使用 LangChain，构建多轮对话的问答，并且在多轮对话中可以保存上下文的 prompts，进行多轮对话中的提示。

3. [Few-shot Learning](https://github.com/Minghao-Liang/DeepSeek_Prompt_Engineering/blob/main/3-few_shot_learning.ipynb)

   探索 few-shot prompt 如何让模型生成你想要的输出，并了解如何编写高质量的 few-shot prompt 以最大限度提升模型的性能。

4. [Chain of Thought Prompting](https://github.com/Minghao-Liang/DeepSeek_Prompt_Engineering/blob/main/4-chain_of_thought.ipynb)

   了解 Chain of Thought 的能力，学习如何引导模型用逐步推理的能力去回答问题，可以展示模型回答问题的思维过程。

------

## Reference

- [Prompt Engineering Guide](https://www.promptingguide.ai)
- [Prompt Engineering. Lil’Log.](https://lilianweng.github.io/posts/2023-03-15-prompt-engineering/)
- [Prompt_Engineering](https://github.com/NirDiamant/Prompt_Engineering?tab=readme-ov-file)
