package com.java110.user.dao;


import com.java110.utils.exception.DAOException;


import java.util.List;
import java.util.Map;

/**
 * 用户联系地址组件内部之间使用，没有给外围系统提供服务能力
 * 用户联系地址服务接口类，要求全部以字符串传输，方便微服务化
 * 新建客户，修改客户，删除客户，查询客户等功能
 *
 * Created by wuxw on 2016/12/27.
 */
public interface IUserAddressServiceDao {


    /**
     * 保存 用户联系地址信息
     * @param info
     * @throws DAOException DAO异常
     */
    void saveUserAddressInfo(Map info) throws DAOException;




    /**
     * 查询用户联系地址信息（instance过程）
     * 根据bId 查询用户联系地址信息
     * @param info bId 信息
     * @return 用户联系地址信息
     * @throws DAOException DAO异常
     */
    List<Map> getUserAddressInfo(Map info) throws DAOException;



    /**
     * 修改用户联系地址信息
     * @param info 修改信息
     * @throws DAOException DAO异常
     */
    void updateUserAddressInfo(Map info) throws DAOException;


    /**
     * 查询用户联系地址总数
     *
     * @param info 用户联系地址信息
     * @return 用户联系地址数量
     */
    int queryUserAddresssCount(Map info);

}
