package com.java110.store.dao.impl;

import com.alibaba.fastjson.JSONObject;
import com.java110.core.base.dao.BaseServiceDao;
import com.java110.store.dao.IUserStorehouseServiceDao;
import com.java110.utils.constant.ResponseConstant;
import com.java110.utils.exception.DAOException;
import com.java110.utils.util.DateUtil;
import org.slf4j.Logger;
import com.java110.core.log.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 个人物品服务 与数据库交互
 * Created by wuxw on 2017/4/5.
 */
@Service("userStorehouseServiceDaoImpl")
//@Transactional
public class UserStorehouseServiceDaoImpl extends BaseServiceDao implements IUserStorehouseServiceDao {

    private static Logger logger = LoggerFactory.getLogger(UserStorehouseServiceDaoImpl.class);

    /**
     * 个人物品信息封装
     *
     * @param businessUserStorehouseInfo 个人物品信息 封装
     * @throws DAOException DAO异常
     */
    @Override
    public void saveBusinessUserStorehouseInfo(Map businessUserStorehouseInfo) throws DAOException {
        businessUserStorehouseInfo.put("month", DateUtil.getCurrentMonth());
        // 查询business_user 数据是否已经存在
        logger.debug("保存个人物品信息 入参 businessUserStorehouseInfo : {}", businessUserStorehouseInfo);
        int saveFlag = sqlSessionTemplate.insert("userStorehouseServiceDaoImpl.saveBusinessUserStorehouseInfo", businessUserStorehouseInfo);

        if (saveFlag < 1) {
            throw new DAOException(ResponseConstant.RESULT_PARAM_ERROR, "保存个人物品数据失败：" + JSONObject.toJSONString(businessUserStorehouseInfo));
        }
    }


    /**
     * 查询个人物品信息
     *
     * @param info bId 信息
     * @return 个人物品信息
     * @throws DAOException DAO异常
     */
    @Override
    public List<Map> getBusinessUserStorehouseInfo(Map info) throws DAOException {

        logger.debug("查询个人物品信息 入参 info : {}", info);

        List<Map> businessUserStorehouseInfos = sqlSessionTemplate.selectList("userStorehouseServiceDaoImpl.getBusinessUserStorehouseInfo", info);

        return businessUserStorehouseInfos;
    }


    /**
     * 保存个人物品信息 到 instance
     *
     * @param info bId 信息
     * @throws DAOException DAO异常
     */
    @Override
    public void saveUserStorehouseInfoInstance(Map info) throws DAOException {
        logger.debug("保存个人物品信息Instance 入参 info : {}", info);

        int saveFlag = sqlSessionTemplate.insert("userStorehouseServiceDaoImpl.saveUserStorehouseInfoInstance", info);

        if (saveFlag < 1) {
            throw new DAOException(ResponseConstant.RESULT_PARAM_ERROR, "保存个人物品信息Instance数据失败：" + JSONObject.toJSONString(info));
        }
    }


    /**
     * 查询个人物品信息（instance）
     *
     * @param info bId 信息
     * @return List<Map>
     * @throws DAOException DAO异常
     */
    @Override
    public List<Map> getUserStorehouseInfo(Map info) throws DAOException {
        logger.debug("查询个人物品信息 入参 info : {}", info);

        List<Map> businessUserStorehouseInfos = sqlSessionTemplate.selectList("userStorehouseServiceDaoImpl.getUserStorehouseInfo", info);

        return businessUserStorehouseInfos;
    }


    /**
     * 修改个人物品信息
     *
     * @param info 修改信息
     * @throws DAOException DAO异常
     */
    @Override
    public void updateUserStorehouseInfoInstance(Map info) throws DAOException {
        logger.debug("修改个人物品信息Instance 入参 info : {}", info);

        int saveFlag = sqlSessionTemplate.update("userStorehouseServiceDaoImpl.updateUserStorehouseInfoInstance", info);

        if (saveFlag < 1) {
            throw new DAOException(ResponseConstant.RESULT_PARAM_ERROR, "修改个人物品信息Instance数据失败：" + JSONObject.toJSONString(info));
        }
    }

    /**
     * 查询个人物品数量
     *
     * @param info 个人物品信息
     * @return 个人物品数量
     */
    @Override
    public int queryUserStorehousesCount(Map info) {
        logger.debug("查询个人物品数据 入参 info : {}", info);

        List<Map> businessUserStorehouseInfos = sqlSessionTemplate.selectList("userStorehouseServiceDaoImpl.queryUserStorehousesCount", info);
        if (businessUserStorehouseInfos.size() < 1) {
            return 0;
        }

        return Integer.parseInt(businessUserStorehouseInfos.get(0).get("count").toString());
    }

    @Override
    public int saveUserStorehouses(Map info) {
        logger.debug("保存个人物品信息Instance 入参 info : {}", info);

        int saveFlag = sqlSessionTemplate.insert("userStorehouseServiceDaoImpl.saveUserStorehouses", info);

        return saveFlag;
    }




}
