/*
 * Copyright 2017-2020 吴学文 and java110 team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.java110.store.cmd.reserveOrder;

import com.alibaba.fastjson.JSONObject;
import com.java110.core.annotation.Java110Cmd;
import com.java110.core.context.ICmdDataFlowContext;
import com.java110.core.event.cmd.Cmd;
import com.java110.core.event.cmd.CmdEvent;
import com.java110.dto.reserve.ReserveGoodsOrderDto;
import com.java110.dto.reserve.ReserveGoodsOrderTimeDto;
import com.java110.dto.user.UserDto;
import com.java110.intf.store.IReserveGoodsOrderTimeV1InnerServiceSMO;
import com.java110.intf.store.IReserveGoodsOrderV1InnerServiceSMO;
import com.java110.intf.user.IUserInnerServiceSMO;
import com.java110.utils.exception.CmdException;
import com.java110.utils.util.Assert;
import com.java110.utils.util.BeanConvertUtil;
import com.java110.vo.ResultVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import java.util.ArrayList;
import java.util.List;


/**
 * 类表述：查询
 * 服务编码：reserveGoodsOrder.listReserveGoodsOrder
 * 请求路劲：/app/reserveGoodsOrder.ListReserveGoodsOrder
 * add by 吴学文 at 2022-12-06 10:58:18 mail: 928255095@qq.com
 * open source address: https://gitee.com/wuxw7/MicroCommunity
 * 官网：http://www.homecommunity.cn
 * 温馨提示：如果您对此文件进行修改 请不要删除原有作者及注释信息，请补充您的 修改的原因以及联系邮箱如下
 * // modify by 张三 at 2021-09-12 第10行在某种场景下存在某种bug 需要修复，注释10至20行 加入 20行至30行
 */
@Java110Cmd(serviceCode = "reserveOrder.listMyReserveGoodsOrderTime")
public class ListMyReserveGoodsOrderTimeCmd extends Cmd {

    private static Logger logger = LoggerFactory.getLogger(ListMyReserveGoodsOrderTimeCmd.class);
    @Autowired
    private IReserveGoodsOrderV1InnerServiceSMO reserveGoodsOrderV1InnerServiceSMOImpl;

    @Autowired
    private IUserInnerServiceSMO userInnerServiceSMOImpl;

    @Autowired
    private IReserveGoodsOrderTimeV1InnerServiceSMO reserveGoodsOrderTimeV1InnerServiceSMOImpl;

    @Override
    public void validate(CmdEvent event, ICmdDataFlowContext cmdDataFlowContext, JSONObject reqJson) {
        super.validatePageInfo(reqJson);
    }

    @Override
    public void doCmd(CmdEvent event, ICmdDataFlowContext cmdDataFlowContext, JSONObject reqJson) throws CmdException {

        String userId = cmdDataFlowContext.getReqHeaders().get("user-id");

        UserDto userDto = new UserDto();
        userDto.setUserId(userId);
        List<UserDto> userDtos = userInnerServiceSMOImpl.getUsers(userDto);

        Assert.listOnlyOne(userDtos,"用户不存在");

        ReserveGoodsOrderTimeDto reserveGoodsOrderTimeDto = BeanConvertUtil.covertBean(reqJson, ReserveGoodsOrderTimeDto.class);
        reserveGoodsOrderTimeDto.setPersonTel(userDtos.get(0).getTel());

        int count = reserveGoodsOrderTimeV1InnerServiceSMOImpl.queryReserveGoodsOrderTimesCount(reserveGoodsOrderTimeDto);

        List<ReserveGoodsOrderTimeDto> reserveGoodsOrderTimeDtos = null;

        if (count > 0) {
            reserveGoodsOrderTimeDtos = reserveGoodsOrderTimeV1InnerServiceSMOImpl.queryReserveGoodsOrderTimes(reserveGoodsOrderTimeDto);
        } else {
            reserveGoodsOrderTimeDtos = new ArrayList<>();
        }

        ResultVo resultVo = new ResultVo((int) Math.ceil((double) count / (double) reqJson.getInteger("row")), count, reserveGoodsOrderTimeDtos);

        ResponseEntity<String> responseEntity = new ResponseEntity<String>(resultVo.toString(), HttpStatus.OK);

        cmdDataFlowContext.setResponseEntity(responseEntity);
    }

    /**
     * 刷入时间
     *
     * @param reserveGoodsOrderDtos
     */
    private void freshTimes(List<ReserveGoodsOrderDto> reserveGoodsOrderDtos) {
        if (reserveGoodsOrderDtos == null || reserveGoodsOrderDtos.size() < 1) {
            return;
        }
        List<String> goodsIds = new ArrayList<>();
        for (ReserveGoodsOrderDto reserveGoodsOrderDto : reserveGoodsOrderDtos) {
            goodsIds.add(reserveGoodsOrderDto.getGoodsId());
        }

        ReserveGoodsOrderTimeDto reserveGoodsOrderTimeDto = new ReserveGoodsOrderTimeDto();
        reserveGoodsOrderTimeDto.setGoodsIds(goodsIds.toArray(new String[goodsIds.size()]));
        List<ReserveGoodsOrderTimeDto> reserveGoodsOrderTimeDtos
                = reserveGoodsOrderTimeV1InnerServiceSMOImpl.queryReserveGoodsOrderTimes(reserveGoodsOrderTimeDto);
        List<ReserveGoodsOrderTimeDto> times = null;
        for (ReserveGoodsOrderDto reserveGoodsOrderDto : reserveGoodsOrderDtos) {
            times = new ArrayList<>();
            for (ReserveGoodsOrderTimeDto tmpReserveGoodsOrderTimeDto : reserveGoodsOrderTimeDtos) {
                if (reserveGoodsOrderDto.getGoodsId().equals(tmpReserveGoodsOrderTimeDto.getGoodsId())) {
                    times.add(tmpReserveGoodsOrderTimeDto);
                }
            }
            reserveGoodsOrderDto.setTimes(times);
        }
    }
}
