package com.java110.community.dao;


import com.java110.utils.exception.DAOException;


import java.util.List;
import java.util.Map;

/**
 * 活动组件内部之间使用，没有给外围系统提供服务能力
 * 活动服务接口类，要求全部以字符串传输，方便微服务化
 * 新建客户，修改客户，删除客户，查询客户等功能
 *
 * Created by wuxw on 2016/12/27.
 */
public interface IInspectionTaskServiceDao {

    /**
     * 保存 活动信息
     * @param businessInspectionTaskInfo 活动信息 封装
     * @throws DAOException 操作数据库异常
     */
    void saveBusinessInspectionTaskInfo(Map businessInspectionTaskInfo) throws DAOException;



    /**
     * 查询活动信息（business过程）
     * 根据bId 查询活动信息
     * @param info bId 信息
     * @return 活动信息
     * @throws DAOException DAO异常
     */
    List<Map> getBusinessInspectionTaskInfo(Map info) throws DAOException;




    /**
     * 保存 活动信息 Business数据到 Instance中
     * @param info
     * @throws DAOException DAO异常
     */
    void saveInspectionTaskInfoInstance(Map info) throws DAOException;




    /**
     * 查询活动信息（instance过程）
     * 根据bId 查询活动信息
     * @param info bId 信息
     * @return 活动信息
     * @throws DAOException DAO异常
     */
    List<Map> getInspectionTaskInfo(Map info) throws DAOException;



    /**
     * 修改活动信息
     * @param info 修改信息
     * @throws DAOException DAO异常
     */
    void updateInspectionTaskInfoInstance(Map info) throws DAOException;


    /**
     * 查询活动总数
     *
     * @param info 活动信息
     * @return 活动数量
     */
    int queryInspectionTasksCount(Map info);

    /**
     * 查询今天巡检计划信息
     * @return
     */
    List<Map> queryTodayInspectionPlan(Map info);

    /**
     * 生成巡检任务信息
     * @return
     */
     int insertInspectionTask(Map info);

    /**
     * 生成巡检任务明细信息
     * @return
     */
    int insertInspectionTaskDetail(Map info);

}
