/*
 * Copyright 2017-2020 吴学文 and java110 team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.java110.common.dao.impl;

import com.java110.common.dao.IEquipmentAccountV1ServiceDao;
import com.java110.core.base.dao.BaseServiceDao;
import com.java110.utils.exception.DAOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 类表述：
 * add by 吴学文 at 2022-09-10 20:37:25 mail: 928255095@qq.com
 * open source address: https://gitee.com/wuxw7/MicroCommunity
 * 官网：http://www.homecommunity.cn
 * 温馨提示：如果您对此文件进行修改 请不要删除原有作者及注释信息，请补充您的 修改的原因以及联系邮箱如下
 * // modify by 张三 at 2021-09-12 第10行在某种场景下存在某种bug 需要修复，注释10至20行 加入 20行至30行
 */
@Service("equipmentAccountV1ServiceDaoImpl")
public class EquipmentAccountV1ServiceDaoImpl extends BaseServiceDao implements IEquipmentAccountV1ServiceDao {

    private static Logger logger = LoggerFactory.getLogger(EquipmentAccountV1ServiceDaoImpl.class);

    /**
     * 保存设备台账信息 到 instance
     * @param info   bId 信息
     * @throws DAOException DAO异常
     */
    @Override
    public int saveEquipmentAccountInfo(Map info) throws DAOException {
        logger.debug("保存 saveEquipmentAccountInfo 入参 info : {}",info);

        int saveFlag = sqlSessionTemplate.insert("equipmentAccountV1ServiceDaoImpl.saveEquipmentAccountInfo",info);

        return saveFlag;
    }

    @Override
    public int saveEquipmentAccountInfoSelective(Map info) throws DAOException {
        logger.debug("保存 saveEquipmentAccountSelective 入参 info : {}",info);
        return sqlSessionTemplate.insert("equipmentAccountV1ServiceDaoImpl.saveEquipmentAccountInfoSelective",info);
    }


    /**
     * 查询设备台账信息（instance）
     * @param info bId 信息
     * @return List<Map>
     * @throws DAOException DAO异常
     */
    @Override
    public List<Map> getEquipmentAccountInfo(Map info) throws DAOException {
        logger.debug("查询 getEquipmentAccountInfo 入参 info : {}",info);

        List<Map> businessEquipmentAccountInfos = sqlSessionTemplate.selectList("equipmentAccountV1ServiceDaoImpl.getEquipmentAccountInfo",info);

        return businessEquipmentAccountInfos;
    }


    /**
     * 修改设备台账信息
     * @param info 修改信息
     * @throws DAOException DAO异常
     */
    @Override
    public int updateEquipmentAccountInfo(Map info) throws DAOException {
        logger.debug("修改 updateEquipmentAccountInfo 入参 info : {}",info);

        int saveFlag = sqlSessionTemplate.update("equipmentAccountV1ServiceDaoImpl.updateEquipmentAccountInfo",info);

        return saveFlag;
    }

     /**
     * 查询设备台账数量
     * @param info 设备台账信息
     * @return 设备台账数量
     */
    @Override
    public int queryEquipmentAccountsCount(Map info) {
        logger.debug("查询 queryEquipmentAccountsCount 入参 info : {}",info);

        List<Map> businessEquipmentAccountInfos = sqlSessionTemplate.selectList("equipmentAccountV1ServiceDaoImpl.queryEquipmentAccountsCount", info);
        if (businessEquipmentAccountInfos.size() < 1) {
            return 0;
        }

        return Integer.parseInt(businessEquipmentAccountInfos.get(0).get("count").toString());
    }


}
