package com.java110.api.components.serviceProvide;

import com.java110.core.context.IPageData;
import com.java110.api.smo.service.IEditServiceProvideSMO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * 编辑小区组件
 */
@Component("editServiceProvide")
public class EditServiceProvideComponent {

    @Autowired
    private IEditServiceProvideSMO editServiceProvideSMOImpl;

    /**
     * 添加小区数据
     * @param pd 页面数据封装
     * @return ResponseEntity 对象
     */
    public ResponseEntity<String> update(IPageData pd){
        return editServiceProvideSMOImpl.updateServiceProvide(pd);
    }

    public IEditServiceProvideSMO getEditServiceProvideSMOImpl() {
        return editServiceProvideSMOImpl;
    }

    public void setEditServiceProvideSMOImpl(IEditServiceProvideSMO editServiceProvideSMOImpl) {
        this.editServiceProvideSMOImpl = editServiceProvideSMOImpl;
    }
}
