package com.java110.api.bmo.resourceStoreUseRecord;

import com.alibaba.fastjson.JSONObject;
import com.java110.api.bmo.IApiBaseBMO;
import com.java110.core.context.DataFlowContext;

public interface IResourceStoreUseRecordBMO extends IApiBaseBMO {


    /**
     * 添加物品使用记录
     *
     * @param paramInJson
     * @param dataFlowContext
     * @return
     */
    void addResourceStoreUseRecord(JSONObject paramInJson, DataFlowContext dataFlowContext);

    /**
     * 添加物品使用记录信息
     *
     * @param paramInJson     接口调用放传入入参
     * @param dataFlowContext 数据上下文
     * @return 订单服务能够接受的报文
     */
    void updateResourceStoreUseRecord(JSONObject paramInJson, DataFlowContext dataFlowContext);

    /**
     * 删除物品使用记录
     *
     * @param paramInJson     接口调用放传入入参
     * @param dataFlowContext 数据上下文
     * @return 订单服务能够接受的报文
     */
    void deleteResourceStoreUseRecord(JSONObject paramInJson, DataFlowContext dataFlowContext);


}
