/*
Navicat MySQL Data Transfer

Source Server         : tt_dev
Source Server Version : 80021
Source Host           : 192.168.100.108:3306
Source Database       : TT

Target Server Type    : MYSQL
Target Server Version : 80021
File Encoding         : 65001

Date: 2024-03-23 12:16:58
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for access_control_white
-- ----------------------------
DROP TABLE IF EXISTS `access_control_white`;
CREATE TABLE `access_control_white` (
  `acw_id` varchar(30) NOT NULL COMMENT '白名单ID',
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `person_id` varchar(30) NOT NULL COMMENT '用户ID',
  `person_name` varchar(64) NOT NULL COMMENT '用户名称',
  `tel` varchar(11) NOT NULL COMMENT '手机号',
  `id_card` varchar(64) DEFAULT NULL COMMENT '身份证号',
  `person_type` varchar(12) NOT NULL DEFAULT '4004' COMMENT '人员类别 1001 员工 , 2002 外卖人员, 3003 快递人员，4004 其他人员',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `access_control_key` varchar(64) DEFAULT NULL COMMENT '门禁钥匙',
  `third_id` varchar(64) DEFAULT NULL COMMENT '三方ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`acw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of access_control_white
-- ----------------------------
INSERT INTO `access_control_white` VALUES ('102023012400840017', '102023012407190005', '2022121921870161', '302022101738360013', '吴学文', '18909711443', '', '2002', '2023-01-03 02:10:00', '2023-01-28 07:35:00', '', null, '2023-01-24 02:23:02', '1');
INSERT INTO `access_control_white` VALUES ('102023012463760003', '102023012407190005', '2022121921870161', '302023012452030004', '张快递', '18909714562', '', '3003', '2023-01-05 02:10:00', '2023-02-08 02:10:00', '', null, '2023-01-24 03:29:23', '0');
INSERT INTO `access_control_white` VALUES ('102023012465380033', '102023012407190005', '2022121921870161', '302023012495700039', '张发发', '18909711445', '', '2002', '2023-01-24 02:10:00', '2023-01-26 02:10:00', '123123', null, '2023-01-24 02:31:32', '0');
INSERT INTO `access_control_white` VALUES ('102023012469550011', '102023012407190005', '2022121921870161', '302023012491240012', '张贝贝', '18909711458', '', '4004', '2023-01-24 12:08:48', '2023-01-26 06:30:00', null, '112023012420860005', '2023-01-24 12:09:29', '0');
INSERT INTO `access_control_white` VALUES ('102023012474810027', '102023012407190005', '2022121921870161', '302022101738360013', '张爸爸', '18909711443', '', '2002', '2023-01-24 02:25:00', '2023-02-08 02:10:00', '123456', null, '2023-01-24 02:29:55', '0');
INSERT INTO `access_control_white` VALUES ('102023012477050021', '102023012407190005', '2022121921870161', '302022101738360013', '张三三', '18909711443', '3345345', '2002', '2023-01-24 02:25:00', '2023-02-08 02:10:00', '12462', null, '2023-01-24 02:28:17', '1');
INSERT INTO `access_control_white` VALUES ('102023012488500023', '102023012407190005', '2022121921870161', '302023012462650024', '测试流程审批', '18909711446', '', '4004', '2023-01-24 18:14:02', '2023-01-26 10:50:00', null, '112023012417380010', '2023-01-24 18:16:13', '0');
INSERT INTO `access_control_white` VALUES ('102023022136590002', '-1', '2023013154290059', '302023022149800003', '张三', '18909711423', '', '1001', '2023-02-01 00:00:00', '2023-07-21 11:55:00', '', null, '2023-02-21 11:08:21', '0');

-- ----------------------------
-- Table structure for access_control_white_auth
-- ----------------------------
DROP TABLE IF EXISTS `access_control_white_auth`;
CREATE TABLE `access_control_white_auth` (
  `acwa_id` varchar(30) NOT NULL COMMENT '授权ID',
  `acw_id` varchar(30) NOT NULL COMMENT '白名单ID',
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`acwa_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of access_control_white_auth
-- ----------------------------
INSERT INTO `access_control_white_auth` VALUES ('102023022136360006', '102023022136590002', '102023022153850078', '2023013154290059', '2023-02-21 11:08:21', '1');
INSERT INTO `access_control_white_auth` VALUES ('102023022145790002', '102023022136590002', '102023022153850078', '2023013154290059', '2023-02-21 11:20:52', '0');

-- ----------------------------
-- Table structure for account
-- ----------------------------
DROP TABLE IF EXISTS `account`;
CREATE TABLE `account` (
  `acct_id` varchar(30) NOT NULL COMMENT '账户ID',
  `acct_name` varchar(128) NOT NULL COMMENT '账户名称',
  `acct_type` varchar(12) NOT NULL COMMENT '账户类型，2003 现金账户 2004 积分账户 2005 优惠券账户',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `obj_type` varchar(12) NOT NULL COMMENT '对象类型，6006 个人 7007 商户',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `part_id` varchar(30) DEFAULT NULL COMMENT '局部ID',
  `link` varchar(11) DEFAULT NULL COMMENT '账户手机号',
  PRIMARY KEY (`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of account
-- ----------------------------

-- ----------------------------
-- Table structure for account_bank
-- ----------------------------
DROP TABLE IF EXISTS `account_bank`;
CREATE TABLE `account_bank` (
  `bank_id` varchar(30) NOT NULL COMMENT '银行ID',
  `bank_code` varchar(64) NOT NULL COMMENT '账号',
  `person_name` varchar(64) NOT NULL COMMENT '持卡人',
  `person_tel` varchar(11) DEFAULT NULL COMMENT '手机号',
  `bank_name` varchar(128) NOT NULL COMMENT '开户行',
  `shop_id` varchar(30) NOT NULL COMMENT '商铺ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of account_bank
-- ----------------------------
INSERT INTO `account_bank` VALUES ('742021062128170006', '青海银行', '诗诗', '15309714587', '698745632145498465', '502021052279460001', '2021-06-21 18:03:32', '0');
INSERT INTO `account_bank` VALUES ('742021062118260007', '123', '1231', '15326984569', '123', '502021052279460001', '2021-06-21 18:04:00', '1');
INSERT INTO `account_bank` VALUES ('742021063056150003', '622312341234', '李大彪', '13312341234', '大家发银行', '502021051970730004', '2021-06-30 21:52:12', '0');
INSERT INTO `account_bank` VALUES ('742021072842690002', '213232134343', '吴', '15000000000', '建行', '502021072868980001', '2021-07-28 17:11:22', '0');
INSERT INTO `account_bank` VALUES ('742021102599250012', '31823912378123781', '张三', '17123409870', '兴业银行', '502021080429730002', '2021-10-25 16:22:30', '0');
INSERT INTO `account_bank` VALUES ('742021121868440051', '42000000000', '潘念念', '13487144430', '农业银行', '502021102727680001', '2021-12-18 09:59:20', '0');
INSERT INTO `account_bank` VALUES ('742022022183660095', '6965986523564561', '小焦', '15720052356', '光大银行', '502021080429730002', '2022-02-21 20:33:55', '0');
INSERT INTO `account_bank` VALUES ('742022031080770024', '3646741122333322', '格林城持卡人', '13311111111', '中国银行格林城支行', '502021080429730002', '2022-03-10 15:16:03', '0');
INSERT INTO `account_bank` VALUES ('742023010610580093', '12312334234234', '张三', '15666666666', '中国银行', '502022122703470035', '2023-01-06 20:17:47', '0');

-- ----------------------------
-- Table structure for account_bond
-- ----------------------------
DROP TABLE IF EXISTS `account_bond`;
CREATE TABLE `account_bond` (
  `bond_id` varchar(30) NOT NULL COMMENT '保证金ID',
  `bond_name` varchar(128) NOT NULL COMMENT '保证金名称',
  `bond_type` varchar(12) NOT NULL COMMENT '保证金类型 6006 店铺类型',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID，6006时为店铺类型ID',
  `remark` varchar(1024) DEFAULT NULL COMMENT '保证金描述',
  `bond_month` int NOT NULL DEFAULT '12' COMMENT '保证月份，只有满足保证月份后才能退',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`bond_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of account_bond
-- ----------------------------
INSERT INTO `account_bond` VALUES ('762021062836740002', '饭店', '6006', '0.00', '1012021061598680003', '饭店保证金缴费日起12个月后可退还', '12', '2021-06-28 15:51:58', '1');
INSERT INTO `account_bond` VALUES ('762021062859420001', '饭店', '6006', '10000.00', '1012021061598680003', '', '24', '2021-06-28 15:49:39', '1');
INSERT INTO `account_bond` VALUES ('762021062899500003', '藥店', '6006', '30000.00', '1012021061558150004', '饭店保证金缴费日起24个月后可退还', '24', '2021-06-28 16:02:59', '1');
INSERT INTO `account_bond` VALUES ('762021063003480001', '测试', '6006', '0.00', '1012021062382340009', '', '12', '2021-06-30 14:31:07', '1');
INSERT INTO `account_bond` VALUES ('762021071063470002', '小超市', '6006', '0.00', '1012021070202890002', 'www', '24', '2021-07-10 13:31:04', '0');
INSERT INTO `account_bond` VALUES ('762021071072610001', '常用', '6006', '100.00', '1012021070278390001', 'ee', '20', '2021-07-10 13:16:56', '0');
INSERT INTO `account_bond` VALUES ('762021081056550001', '超市类', '6006', '0.00', '1012021081065510005', '', '24', '2021-08-10 09:46:55', '0');
INSERT INTO `account_bond` VALUES ('762021083076760004', '炸鸡店', '6006', '0.00', '1012021083033210014', '', '24', '2021-08-30 14:40:48', '0');
INSERT INTO `account_bond` VALUES ('762021090681700001', '水果店', '6006', '0.00', '1012021090668600090', '12', '12', '2021-09-06 18:23:41', '0');
INSERT INTO `account_bond` VALUES ('762021102514380011', '测试', '6006', '100.00', '1012021062382340009', '', '12', '2021-10-25 14:52:55', '1');
INSERT INTO `account_bond` VALUES ('762022021591580022', '超市类', '6006', '100.00', '1012022021584030029', '', '12', '2022-02-15 09:56:02', '0');

-- ----------------------------
-- Table structure for account_bond_obj
-- ----------------------------
DROP TABLE IF EXISTS `account_bond_obj`;
CREATE TABLE `account_bond_obj` (
  `bobj_id` varchar(30) NOT NULL COMMENT '保证金对象ID',
  `bond_id` varchar(30) NOT NULL COMMENT '保证金ID',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID，店铺ID',
  `obj_name` varchar(25) NOT NULL COMMENT '对象名称',
  `bond_type` varchar(12) NOT NULL COMMENT '保证金类型 6006 店铺类型',
  `receivable_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应收金额',
  `received_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '实收金额',
  `state` varchar(12) NOT NULL COMMENT '状态 1001 待支付  2002 支付完成 3003 支付失败 4004 已退',
  `remark` varchar(1024) DEFAULT NULL COMMENT '描述',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`bobj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of account_bond_obj
-- ----------------------------

-- ----------------------------
-- Table structure for account_bond_obj_detail
-- ----------------------------
DROP TABLE IF EXISTS `account_bond_obj_detail`;
CREATE TABLE `account_bond_obj_detail` (
  `detail_id` varchar(30) NOT NULL COMMENT '保证金ID',
  `bobj_id` varchar(30) NOT NULL COMMENT '保证金对象ID',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID，店铺ID',
  `bond_type` varchar(12) NOT NULL COMMENT '保证金类型 6006 店铺类型',
  `receivable_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应收金额',
  `received_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '实收金额',
  `state` varchar(12) NOT NULL COMMENT '状态 3308 交保证金  3309 退保证金',
  `remark` varchar(1024) DEFAULT NULL COMMENT '描述',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `obj_name` varchar(25) NOT NULL COMMENT '对象名称',
  PRIMARY KEY (`detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of account_bond_obj_detail
-- ----------------------------

-- ----------------------------
-- Table structure for account_detail
-- ----------------------------
DROP TABLE IF EXISTS `account_detail`;
CREATE TABLE `account_detail` (
  `detail_id` varchar(30) NOT NULL COMMENT '明细ID',
  `acct_id` varchar(30) NOT NULL COMMENT '账户ID',
  `detail_type` varchar(128) NOT NULL COMMENT '类型，1001 转入 2002 转出',
  `rel_acct_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '关联账户',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `obj_type` varchar(12) NOT NULL COMMENT '对象类型，6006 个人 7007 商户',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID',
  `order_id` varchar(30) NOT NULL COMMENT '交易单号',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `remark` varchar(1024) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of account_detail
-- ----------------------------

-- ----------------------------
-- Table structure for account_receipt
-- ----------------------------
DROP TABLE IF EXISTS `account_receipt`;
CREATE TABLE `account_receipt` (
  `ar_id` varchar(30) NOT NULL COMMENT '收据Id',
  `acct_id` varchar(30) NOT NULL COMMENT '账户ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `link` varchar(11) NOT NULL COMMENT '账户手机号',
  `owner_id` varchar(30) NOT NULL COMMENT '业主ID',
  `owner_name` varchar(64) NOT NULL COMMENT '业主名称',
  `prime_rate` varchar(12) NOT NULL COMMENT '支付方式',
  `receivable_amount` decimal(10,2) NOT NULL COMMENT '应收金额',
  `received_amount` decimal(10,2) NOT NULL COMMENT '实收金额',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `remark` varchar(512) DEFAULT NULL COMMENT '说明',
  PRIMARY KEY (`ar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of account_receipt
-- ----------------------------

-- ----------------------------
-- Table structure for account_withdrawal_apply
-- ----------------------------
DROP TABLE IF EXISTS `account_withdrawal_apply`;
CREATE TABLE `account_withdrawal_apply` (
  `apply_id` varchar(30) NOT NULL COMMENT '申请ID',
  `acct_id` varchar(30) NOT NULL COMMENT '账户ID',
  `amount` decimal(10,2) NOT NULL COMMENT '提现金额',
  `apply_user_id` varchar(30) NOT NULL COMMENT '申请人',
  `apply_user_name` varchar(64) NOT NULL COMMENT '申请人',
  `apply_user_tel` varchar(11) NOT NULL COMMENT '申请人电话',
  `context` varchar(512) NOT NULL COMMENT '申请说明',
  `state` varchar(12) NOT NULL DEFAULT '486' COMMENT '486 申请 586 审核通过 587 审核不通过 686 付款成功 687 付款失败',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `bank_id` varchar(30) NOT NULL COMMENT '银行ID',
  `obj_id` varchar(30) NOT NULL COMMENT '商铺ID 或者 代理商ID ',
  PRIMARY KEY (`apply_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of account_withdrawal_apply
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_EVT_LOG
-- ----------------------------
DROP TABLE IF EXISTS `ACT_EVT_LOG`;
CREATE TABLE `ACT_EVT_LOG` (
  `LOG_NR_` bigint NOT NULL AUTO_INCREMENT,
  `TYPE_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TIME_STAMP_` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DATA_` longblob,
  `LOCK_OWNER_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `LOCK_TIME_` timestamp(3) NULL DEFAULT NULL,
  `IS_PROCESSED_` tinyint DEFAULT '0',
  PRIMARY KEY (`LOG_NR_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_EVT_LOG
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_GE_BYTEARRAY
-- ----------------------------
DROP TABLE IF EXISTS `ACT_GE_BYTEARRAY`;
CREATE TABLE `ACT_GE_BYTEARRAY` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `REV_` int DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DEPLOYMENT_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `BYTES_` longblob,
  `GENERATED_` tinyint DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_BYTEARR_DEPL` (`DEPLOYMENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_GE_BYTEARRAY_ibfk_1` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `ACT_RE_DEPLOYMENT` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_GE_BYTEARRAY
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_GE_PROPERTY
-- ----------------------------
DROP TABLE IF EXISTS `ACT_GE_PROPERTY`;
CREATE TABLE `ACT_GE_PROPERTY` (
  `NAME_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `VALUE_` varchar(300) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `REV_` int DEFAULT NULL,
  PRIMARY KEY (`NAME_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_GE_PROPERTY
-- ----------------------------
INSERT INTO `ACT_GE_PROPERTY` VALUES ('cfg.execution-related-entities-count', 'false', '1');
INSERT INTO `ACT_GE_PROPERTY` VALUES ('next.dbid', '1190001', '477');
INSERT INTO `ACT_GE_PROPERTY` VALUES ('schema.history', 'create(6.0.0.4)', '1');
INSERT INTO `ACT_GE_PROPERTY` VALUES ('schema.version', '6.0.0.4', '1');

-- ----------------------------
-- Table structure for ACT_HI_ACTINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_ACTINST`;
CREATE TABLE `ACT_HI_ACTINST` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CALL_PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ACT_NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ACT_TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `ASSIGNEE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `START_TIME_` datetime(3) NOT NULL,
  `END_TIME_` datetime(3) DEFAULT NULL,
  `DURATION_` bigint DEFAULT NULL,
  `DELETE_REASON_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_ACT_INST_START` (`START_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_END` (`END_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_PROCINST` (`PROC_INST_ID_`,`ACT_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_EXEC` (`EXECUTION_ID_`,`ACT_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_HI_ACTINST
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_HI_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_ATTACHMENT`;
CREATE TABLE `ACT_HI_ATTACHMENT` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DESCRIPTION_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `URL_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CONTENT_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TIME_` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_HI_ATTACHMENT
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_HI_COMMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_COMMENT`;
CREATE TABLE `ACT_HI_COMMENT` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TIME_` datetime(3) NOT NULL,
  `USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ACTION_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `MESSAGE_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `FULL_MSG_` longblob,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_HI_COMMENT
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_HI_DETAIL
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_DETAIL`;
CREATE TABLE `ACT_HI_DETAIL` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ACT_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `VAR_TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `REV_` int DEFAULT NULL,
  `TIME_` datetime(3) NOT NULL,
  `BYTEARRAY_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DOUBLE_` double DEFAULT NULL,
  `LONG_` bigint DEFAULT NULL,
  `TEXT_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TEXT2_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_DETAIL_PROC_INST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_ACT_INST` (`ACT_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_TIME` (`TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_NAME` (`NAME_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_TASK_ID` (`TASK_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_HI_DETAIL
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_HI_IDENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_IDENTITYLINK`;
CREATE TABLE `ACT_HI_IDENTITYLINK` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `GROUP_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_IDENT_LNK_USER` (`USER_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_TASK` (`TASK_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_PROCINST` (`PROC_INST_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_HI_IDENTITYLINK
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_HI_PROCINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_PROCINST`;
CREATE TABLE `ACT_HI_PROCINST` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `BUSINESS_KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `START_TIME_` datetime(3) NOT NULL,
  `END_TIME_` datetime(3) DEFAULT NULL,
  `DURATION_` bigint DEFAULT NULL,
  `START_USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `START_ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `END_ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `SUPER_PROCESS_INSTANCE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DELETE_REASON_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  UNIQUE KEY `PROC_INST_ID_` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PRO_INST_END` (`END_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_PRO_I_BUSKEY` (`BUSINESS_KEY_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_HI_PROCINST
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_HI_TASKINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_TASKINST`;
CREATE TABLE `ACT_HI_TASKINST` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_DEF_KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PARENT_TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DESCRIPTION_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `OWNER_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ASSIGNEE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `START_TIME_` datetime(3) NOT NULL,
  `CLAIM_TIME_` datetime(3) DEFAULT NULL,
  `END_TIME_` datetime(3) DEFAULT NULL,
  `DURATION_` bigint DEFAULT NULL,
  `DELETE_REASON_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PRIORITY_` int DEFAULT NULL,
  `DUE_DATE_` datetime(3) DEFAULT NULL,
  `FORM_KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CATEGORY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_TASK_INST_PROCINST` (`PROC_INST_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_HI_TASKINST
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_HI_VARINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_VARINST`;
CREATE TABLE `ACT_HI_VARINST` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `VAR_TYPE_` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `REV_` int DEFAULT NULL,
  `BYTEARRAY_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DOUBLE_` double DEFAULT NULL,
  `LONG_` bigint DEFAULT NULL,
  `TEXT_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TEXT2_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CREATE_TIME_` datetime(3) DEFAULT NULL,
  `LAST_UPDATED_TIME_` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_PROCVAR_PROC_INST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_NAME_TYPE` (`NAME_`,`VAR_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_TASK_ID` (`TASK_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_HI_VARINST
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_ID_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_GROUP`;
CREATE TABLE `ACT_ID_GROUP` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `REV_` int DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_ID_GROUP
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_ID_INFO
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_INFO`;
CREATE TABLE `ACT_ID_INFO` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `REV_` int DEFAULT NULL,
  `USER_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `VALUE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PASSWORD_` longblob,
  `PARENT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_ID_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_ID_MEMBERSHIP
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_MEMBERSHIP`;
CREATE TABLE `ACT_ID_MEMBERSHIP` (
  `USER_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `GROUP_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`USER_ID_`,`GROUP_ID_`),
  KEY `ACT_FK_MEMB_GROUP` (`GROUP_ID_`) USING BTREE,
  CONSTRAINT `ACT_ID_MEMBERSHIP_ibfk_1` FOREIGN KEY (`GROUP_ID_`) REFERENCES `ACT_ID_GROUP` (`ID_`),
  CONSTRAINT `ACT_ID_MEMBERSHIP_ibfk_2` FOREIGN KEY (`USER_ID_`) REFERENCES `ACT_ID_USER` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_ID_MEMBERSHIP
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_ID_USER
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_USER`;
CREATE TABLE `ACT_ID_USER` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `REV_` int DEFAULT NULL,
  `FIRST_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `LAST_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EMAIL_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PWD_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PICTURE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_ID_USER
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_PROCDEF_INFO
-- ----------------------------
DROP TABLE IF EXISTS `ACT_PROCDEF_INFO`;
CREATE TABLE `ACT_PROCDEF_INFO` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `INFO_JSON_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  UNIQUE KEY `ACT_UNIQ_INFO_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_INFO_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_INFO_JSON_BA` (`INFO_JSON_ID_`) USING BTREE,
  KEY `ACT_IDX_INFO_PROCDEF_ACT_PROCDEF_INFO` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_PROCDEF_INFO_ibfk_1` FOREIGN KEY (`INFO_JSON_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_PROCDEF_INFO_ibfk_2` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_PROCDEF_INFO
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RE_DEPLOYMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_DEPLOYMENT`;
CREATE TABLE `ACT_RE_DEPLOYMENT` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CATEGORY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  `DEPLOY_TIME_` timestamp(3) NULL DEFAULT NULL,
  `ENGINE_VERSION_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RE_DEPLOYMENT
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RE_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_MODEL`;
CREATE TABLE `ACT_RE_MODEL` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CATEGORY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CREATE_TIME_` timestamp(3) NULL DEFAULT NULL,
  `LAST_UPDATE_TIME_` timestamp(3) NULL DEFAULT NULL,
  `VERSION_` int DEFAULT NULL,
  `META_INFO_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DEPLOYMENT_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EDITOR_SOURCE_VALUE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EDITOR_SOURCE_EXTRA_VALUE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_MODEL_SOURCE` (`EDITOR_SOURCE_VALUE_ID_`) USING BTREE,
  KEY `ACT_FK_MODEL_SOURCE_EXTRA` (`EDITOR_SOURCE_EXTRA_VALUE_ID_`) USING BTREE,
  KEY `ACT_FK_MODEL_DEPLOYMENT` (`DEPLOYMENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_RE_MODEL_ibfk_1` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `ACT_RE_DEPLOYMENT` (`ID_`),
  CONSTRAINT `ACT_RE_MODEL_ibfk_2` FOREIGN KEY (`EDITOR_SOURCE_VALUE_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_RE_MODEL_ibfk_3` FOREIGN KEY (`EDITOR_SOURCE_EXTRA_VALUE_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RE_MODEL
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RE_PROCDEF
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_PROCDEF`;
CREATE TABLE `ACT_RE_PROCDEF` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `CATEGORY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `VERSION_` int NOT NULL,
  `DEPLOYMENT_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `RESOURCE_NAME_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DGRM_RESOURCE_NAME_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DESCRIPTION_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HAS_START_FORM_KEY_` tinyint DEFAULT NULL,
  `HAS_GRAPHICAL_NOTATION_` tinyint DEFAULT NULL,
  `SUSPENSION_STATE_` int DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  `ENGINE_VERSION_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  UNIQUE KEY `ACT_UNIQ_PROCDEF` (`KEY_`,`VERSION_`,`TENANT_ID_`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RE_PROCDEF
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_DEADLETTER_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_DEADLETTER_JOB`;
CREATE TABLE `ACT_RU_DEADLETTER_JOB` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `EXCLUSIVE_` tinyint(1) DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROCESS_INSTANCE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXCEPTION_STACK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXCEPTION_MSG_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DUEDATE_` timestamp(3) NULL DEFAULT NULL,
  `REPEAT_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_CFG_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_DEADLETTER_JOB_EXECUTION` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_DEADLETTER_JOB_PROCESS_INSTANCE` (`PROCESS_INSTANCE_ID_`) USING BTREE,
  KEY `ACT_FK_DEADLETTER_JOB_PROC_DEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_DEADLETTER_JOB_EXCEPTION` (`EXCEPTION_STACK_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_DEADLETTER_JOB_ibfk_1` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_RU_DEADLETTER_JOB_ibfk_2` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_DEADLETTER_JOB_ibfk_3` FOREIGN KEY (`PROCESS_INSTANCE_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_DEADLETTER_JOB_ibfk_4` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_DEADLETTER_JOB
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_EVENT_SUBSCR
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_EVENT_SUBSCR`;
CREATE TABLE `ACT_RU_EVENT_SUBSCR` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `EVENT_TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `EVENT_NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ACTIVITY_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CONFIGURATION_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CREATED_` timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_EVENT_SUBSCR_CONFIG_` (`CONFIGURATION_`) USING BTREE,
  KEY `ACT_FK_EVENT_EXEC` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_IDX_EVENT_SUBSCR_CONFIG__ACT_RU_EVENT_SUBSCR` (`CONFIGURATION_`) USING BTREE,
  CONSTRAINT `ACT_RU_EVENT_SUBSCR_ibfk_1` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_EVENT_SUBSCR
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_EXECUTION
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_EXECUTION`;
CREATE TABLE `ACT_RU_EXECUTION` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `REV_` int DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `BUSINESS_KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PARENT_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `SUPER_EXEC_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ROOT_PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ACT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `IS_ACTIVE_` tinyint DEFAULT NULL,
  `IS_CONCURRENT_` tinyint DEFAULT NULL,
  `IS_SCOPE_` tinyint DEFAULT NULL,
  `IS_EVENT_SCOPE_` tinyint DEFAULT NULL,
  `IS_MI_ROOT_` tinyint DEFAULT NULL,
  `SUSPENSION_STATE_` int DEFAULT NULL,
  `CACHED_ENT_STATE_` int DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `START_TIME_` datetime(3) DEFAULT NULL,
  `START_USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `LOCK_TIME_` timestamp(3) NULL DEFAULT NULL,
  `IS_COUNT_ENABLED_` tinyint DEFAULT NULL,
  `EVT_SUBSCR_COUNT_` int DEFAULT NULL,
  `TASK_COUNT_` int DEFAULT NULL,
  `JOB_COUNT_` int DEFAULT NULL,
  `TIMER_JOB_COUNT_` int DEFAULT NULL,
  `SUSP_JOB_COUNT_` int DEFAULT NULL,
  `DEADLETTER_JOB_COUNT_` int DEFAULT NULL,
  `VAR_COUNT_` int DEFAULT NULL,
  `ID_LINK_COUNT_` int DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_EXEC_BUSKEY` (`BUSINESS_KEY_`) USING BTREE,
  KEY `ACT_IDC_EXEC_ROOT` (`ROOT_PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_EXE_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_EXE_PARENT` (`PARENT_ID_`) USING BTREE,
  KEY `ACT_FK_EXE_SUPER` (`SUPER_EXEC_`) USING BTREE,
  KEY `ACT_FK_EXE_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_EXEC_BUSKEY_ACT_RU_EXECUTION` (`BUSINESS_KEY_`) USING BTREE,
  KEY `ACT_IDC_EXEC_ROOT_ACT_RU_EXECUTION` (`ROOT_PROC_INST_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_EXECUTION_ibfk_1` FOREIGN KEY (`PARENT_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`) ON DELETE CASCADE,
  CONSTRAINT `ACT_RU_EXECUTION_ibfk_2` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_RU_EXECUTION_ibfk_3` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ACT_RU_EXECUTION_ibfk_4` FOREIGN KEY (`SUPER_EXEC_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_EXECUTION
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_IDENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_IDENTITYLINK`;
CREATE TABLE `ACT_RU_IDENTITYLINK` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `REV_` int DEFAULT NULL,
  `GROUP_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `USER_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_IDENT_LNK_USER` (`USER_ID_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_GROUP` (`GROUP_ID_`) USING BTREE,
  KEY `ACT_IDX_ATHRZ_PROCEDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_TSKASS_TASK` (`TASK_ID_`) USING BTREE,
  KEY `ACT_FK_IDL_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_USER_ACT_RU_IDENTITYLINK` (`USER_ID_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_GROUP_ACT_RU_IDENTITYLINK` (`GROUP_ID_`) USING BTREE,
  KEY `ACT_IDX_ATHRZ_PROCEDEF_ACT_RU_IDENTITYLINK` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_IDENTITYLINK_ibfk_1` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_RU_IDENTITYLINK_ibfk_2` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_IDENTITYLINK_ibfk_3` FOREIGN KEY (`TASK_ID_`) REFERENCES `ACT_RU_TASK` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_IDENTITYLINK
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_JOB`;
CREATE TABLE `ACT_RU_JOB` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `LOCK_EXP_TIME_` timestamp(3) NULL DEFAULT NULL,
  `LOCK_OWNER_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXCLUSIVE_` tinyint(1) DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROCESS_INSTANCE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `RETRIES_` int DEFAULT NULL,
  `EXCEPTION_STACK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXCEPTION_MSG_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DUEDATE_` timestamp(3) NULL DEFAULT NULL,
  `REPEAT_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_CFG_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_JOB_EXECUTION` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_JOB_PROCESS_INSTANCE` (`PROCESS_INSTANCE_ID_`) USING BTREE,
  KEY `ACT_FK_JOB_PROC_DEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_JOB_EXCEPTION` (`EXCEPTION_STACK_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_JOB_ibfk_1` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_RU_JOB_ibfk_2` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_JOB_ibfk_3` FOREIGN KEY (`PROCESS_INSTANCE_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_JOB_ibfk_4` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_JOB
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_SUSPENDED_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_SUSPENDED_JOB`;
CREATE TABLE `ACT_RU_SUSPENDED_JOB` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `EXCLUSIVE_` tinyint(1) DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROCESS_INSTANCE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `RETRIES_` int DEFAULT NULL,
  `EXCEPTION_STACK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXCEPTION_MSG_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DUEDATE_` timestamp(3) NULL DEFAULT NULL,
  `REPEAT_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_CFG_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_SUSPENDED_JOB_EXECUTION` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_SUSPENDED_JOB_PROCESS_INSTANCE` (`PROCESS_INSTANCE_ID_`) USING BTREE,
  KEY `ACT_FK_SUSPENDED_JOB_PROC_DEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_SUSPENDED_JOB_EXCEPTION` (`EXCEPTION_STACK_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_SUSPENDED_JOB_ibfk_1` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_RU_SUSPENDED_JOB_ibfk_2` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_SUSPENDED_JOB_ibfk_3` FOREIGN KEY (`PROCESS_INSTANCE_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_SUSPENDED_JOB_ibfk_4` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_SUSPENDED_JOB
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_TASK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_TASK`;
CREATE TABLE `ACT_RU_TASK` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `REV_` int DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PARENT_TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DESCRIPTION_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_DEF_KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `OWNER_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `ASSIGNEE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DELEGATION_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PRIORITY_` int DEFAULT NULL,
  `CREATE_TIME_` timestamp(3) NULL DEFAULT NULL,
  `DUE_DATE_` datetime(3) DEFAULT NULL,
  `CATEGORY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `SUSPENSION_STATE_` int DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  `FORM_KEY_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `CLAIM_TIME_` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_TASK_CREATE` (`CREATE_TIME_`) USING BTREE,
  KEY `ACT_FK_TASK_EXE` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_TASK_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_TASK_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_TASK_CREATE_ACT_RU_TASK` (`CREATE_TIME_`) USING BTREE,
  CONSTRAINT `ACT_RU_TASK_ibfk_1` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_TASK_ibfk_2` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_RU_TASK_ibfk_3` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_TIMER_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_TIMER_JOB`;
CREATE TABLE `ACT_RU_TIMER_JOB` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `LOCK_EXP_TIME_` timestamp(3) NULL DEFAULT NULL,
  `LOCK_OWNER_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXCLUSIVE_` tinyint(1) DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROCESS_INSTANCE_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `RETRIES_` int DEFAULT NULL,
  `EXCEPTION_STACK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `EXCEPTION_MSG_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DUEDATE_` timestamp(3) NULL DEFAULT NULL,
  `REPEAT_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_CFG_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_TIMER_JOB_EXECUTION` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_TIMER_JOB_PROCESS_INSTANCE` (`PROCESS_INSTANCE_ID_`) USING BTREE,
  KEY `ACT_FK_TIMER_JOB_PROC_DEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_TIMER_JOB_EXCEPTION` (`EXCEPTION_STACK_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_TIMER_JOB_ibfk_1` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_RU_TIMER_JOB_ibfk_2` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_TIMER_JOB_ibfk_3` FOREIGN KEY (`PROCESS_INSTANCE_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_TIMER_JOB_ibfk_4` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_TIMER_JOB
-- ----------------------------

-- ----------------------------
-- Table structure for ACT_RU_VARIABLE
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_VARIABLE`;
CREATE TABLE `ACT_RU_VARIABLE` (
  `ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `REV_` int DEFAULT NULL,
  `TYPE_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `NAME_` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `EXECUTION_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `BYTEARRAY_ID_` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `DOUBLE_` double DEFAULT NULL,
  `LONG_` bigint DEFAULT NULL,
  `TEXT_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `TEXT2_` varchar(4000) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_VARIABLE_TASK_ID` (`TASK_ID_`) USING BTREE,
  KEY `ACT_FK_VAR_EXE` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_VAR_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_VAR_BYTEARRAY` (`BYTEARRAY_ID_`) USING BTREE,
  KEY `ACT_IDX_VARIABLE_TASK_ID_ACT_RU_VARIABLE` (`TASK_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_VARIABLE_ibfk_1` FOREIGN KEY (`BYTEARRAY_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_RU_VARIABLE_ibfk_2` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_VARIABLE_ibfk_3` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of ACT_RU_VARIABLE
-- ----------------------------

-- ----------------------------
-- Table structure for activities
-- ----------------------------
DROP TABLE IF EXISTS `activities`;
CREATE TABLE `activities` (
  `activities_id` varchar(30) NOT NULL COMMENT '活动ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `title` varchar(200) NOT NULL COMMENT '活动标题',
  `type_cd` varchar(30) NOT NULL COMMENT '文章类型',
  `header_img` varchar(200) NOT NULL COMMENT '头部照片,照片名称',
  `context` longtext NOT NULL COMMENT '活动内容',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `read_count` int NOT NULL DEFAULT '0' COMMENT '阅读数',
  `like_count` int NOT NULL DEFAULT '0' COMMENT '点赞数',
  `collect_count` int NOT NULL DEFAULT '0' COMMENT '收藏数',
  `user_id` varchar(30) NOT NULL COMMENT '创建用户Id',
  `user_name` varchar(30) NOT NULL COMMENT '创建用户名称',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `state` varchar(12) NOT NULL DEFAULT '10000' COMMENT '审核状态，10000 待审核 ，11000 审核完成 12000 审核失败',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  UNIQUE KEY `activities_id` (`activities_id`) USING BTREE,
  UNIQUE KEY `idx_activities_id` (`activities_id`) USING BTREE,
  KEY `idx_activities_b_id` (`b_id`) USING BTREE,
  KEY `a_type_cd` (`type_cd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of activities
-- ----------------------------
INSERT INTO `activities` VALUES ('992024021971982710', '-1', '111', '852024021968262705', 'img/20240219/0fe5cbb0-bd53-42e6-90a3-d034b24894f0.jpg', '<p>瑞特我tert</p>', '2023052267100146', '0', '0', '0', '30202305221014327189000174', 'HC演示物业2', '2024-02-19 09:15:00', '2024-02-19 09:13:16', '11000', '2024-02-19 09:13:46', '0');
INSERT INTO `activities` VALUES ('992024022034985931', '-1', '信息发布', '852024022066635109', 'img/20240220/9e65c5df-f734-440f-9592-cbfc0fc98d94.jpg', '<p>这里是 信息发布</p>', '2023052267100146', '0', '0', '0', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 15:32:22', '2024-02-28 15:30:00', '11000', '2024-02-20 15:33:05', '0');
INSERT INTO `activities` VALUES ('992024022060725093', '-1', '这里是信息发布', '852024021968262705', 'img/20240220/b642bbb7-57ce-4c25-8cc4-b68a8ecbd536.jpg', '<p>信息和公告有啥区别</p>', '2023052267100146', '0', '0', '0', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 11:29:14', '2024-02-29 23:55:00', '11000', '2024-02-20 11:30:20', '0');
INSERT INTO `activities` VALUES ('992024022065856162', '-1', '活动2', '852024022066635109', 'img/20240220/f7623f13-3e19-4280-944b-773d71860dae.jpg', '<p>第二个活动</p>', '2023052267100146', '0', '0', '0', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 17:11:09', '2024-02-29 21:10:00', '11000', '2024-02-20 17:11:43', '0');

-- ----------------------------
-- Table structure for activities_beautiful_staff
-- ----------------------------
DROP TABLE IF EXISTS `activities_beautiful_staff`;
CREATE TABLE `activities_beautiful_staff` (
  `be_id` varchar(30) NOT NULL COMMENT '主键ID',
  `rule_id` varchar(30) NOT NULL COMMENT '规则ID',
  `staff_id` varchar(30) NOT NULL COMMENT '员工ID',
  `activities_num` int NOT NULL COMMENT '编号',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `work_content` longtext NOT NULL COMMENT '工作+感动故事+服务格言',
  `poll` bigint NOT NULL DEFAULT '0' COMMENT '投票数',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`be_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of activities_beautiful_staff
-- ----------------------------
INSERT INTO `activities_beautiful_staff` VALUES ('222021020865210001', '142021020732440002', '302021012825820303', '1', '402019032924930007', '<p>测试测试123</p>', '0', '2021-02-08 10:38:38', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021030439430046', '142021030421600045', '302021030207990637', '10', '402021030295380622', '<p>啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊<br></p>', '0', '2021-03-04 16:58:39', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021031616450013', '142021020732440002', '302021031506420013', '12', '402019032924930007', '<p>hbhb</p>', '0', '2021-03-16 14:11:24', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021070561280006', '142021020732440002', '302021062800830044', '100', '402019032924930007', '<p>啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧啊吧<br></p>', '0', '2021-07-05 11:14:09', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021070593660018', '142021020732440002', '302021031106740024', '5', '402019032924930007', '<p>救命啊</p>', '0', '2021-07-05 17:38:12', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021070608540024', '142021070665210023', '302021070498680275', '123', '402021070433360261', '<p><font style=\"vertical-align: inherit;\"><font style=\"vertical-align: inherit;\">1321312312321321312</font></font></p>', '0', '2021-07-06 09:47:32', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021070958010007', '142021020732440002', '302021032498340106', '123', '402019032924930007', '<p>123</p>', '0', '2021-07-09 21:00:59', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021073018060016', '142021020732440002', '302021072614970290', '9', '402019032924930007', '本周最美员工', '0', '2021-07-30 11:08:44', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021080628310033', '142021080666270032', '302021080510130021', '123', '402021080402040153', '<p>123123123</p>', '0', '2021-08-06 14:10:52', '0');
INSERT INTO `activities_beautiful_staff` VALUES ('222021081713400008', '142021081295330044', '302021080470230222', '452356', '402021080402040153', '<p>346436</p>', '0', '2021-08-17 20:24:21', '0');

-- ----------------------------
-- Table structure for activities_event
-- ----------------------------
DROP TABLE IF EXISTS `activities_event`;
CREATE TABLE `activities_event` (
  `event_id` varchar(30) NOT NULL COMMENT '事件ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `activities_id` varchar(30) NOT NULL COMMENT '活动ID',
  `event_type_cd` varchar(12) NOT NULL COMMENT '事件类型，999999阅读，888888 收藏 777777 点赞',
  `user_id` varchar(30) NOT NULL COMMENT '人员ID',
  `user_name` varchar(30) NOT NULL COMMENT '人员名称',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  KEY `idx_act_event_id` (`event_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of activities_event
-- ----------------------------

-- ----------------------------
-- Table structure for activities_rule
-- ----------------------------
DROP TABLE IF EXISTS `activities_rule`;
CREATE TABLE `activities_rule` (
  `rule_id` varchar(30) NOT NULL COMMENT '规则ID',
  `rule_name` varchar(128) NOT NULL COMMENT '规则名称',
  `rule_type` varchar(12) NOT NULL COMMENT '规则类型 最美员工：6666',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `activities_obj` varchar(12) NOT NULL COMMENT '活动对象 2222 大众，3333 业主 4444 员工',
  `obj_type` varchar(12) NOT NULL DEFAULT '3306' COMMENT '3306 是小区，3307 是商户',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID',
  `remark` longtext COMMENT '规则说明',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of activities_rule
-- ----------------------------
INSERT INTO `activities_rule` VALUES ('142021020732440002', '2021年度最美员工1', '6666', '2021-02-07 21:55:32', '2021-03-02 00:00:32', '4444', '3307', '402019032924930007', '测试最美员工1', '2021-02-07 22:01:53', '0');
INSERT INTO `activities_rule` VALUES ('142021030421600045', '自己喜欢的员工投票', '6666', '2021-02-01 00:00:58', '2021-03-01 00:00:58', '2222', '3306', '2021030221420610', '得票最高当选', '2021-03-04 16:58:12', '0');
INSERT INTO `activities_rule` VALUES ('142021031791630038', '游戏', '6666', '2021-03-17 17:10:53', '2021-03-18 17:50:53', '2222', '3306', '2021031730860239', '暂无', '2021-03-17 17:14:42', '0');
INSERT INTO `activities_rule` VALUES ('142021040227780007', 'DD', '6666', '2021-04-02 00:00:55', '2021-04-30 23:55:55', '2222', '3306', '2021031851920041', 'DDDDDDDDDDDDD', '2021-04-02 11:08:23', '0');
INSERT INTO `activities_rule` VALUES ('142021070665210023', '123', '6666', '2021-07-06 09:00:54', '2021-07-08 09:00:54', '4444', '3307', '402021070433360261', '1111111', '2021-07-06 09:47:06', '0');
INSERT INTO `activities_rule` VALUES ('142021071018220010', '发送到发送到', '6666', '2021-07-07 02:10:17', '2021-07-23 17:55:17', '3333', '3306', '7020181217000001', '二位', '2021-07-10 17:28:32', '0');
INSERT INTO `activities_rule` VALUES ('142021080666270032', '123', '6666', '2021-08-06 14:10:30', '2021-08-06 14:10:22', '3333', '3306', '2021080591220015', '123', '2021-08-06 14:10:04', '0');
INSERT INTO `activities_rule` VALUES ('142021081295330044', '123', '6666', '2021-08-12 09:39:18', '2021-08-21 09:35:08', '4444', '3307', '402021080402040153', '123', '2021-08-12 09:39:21', '0');
INSERT INTO `activities_rule` VALUES ('142021081883990010', '月度评优', '6666', '2021-08-01 00:00:26', '2021-12-31 23:00:16', '2222', '3307', '402021080402040153', '评出一名最美员工', '2021-08-18 15:43:23', '0');
INSERT INTO `activities_rule` VALUES ('142021082145550002', '4224', '6666', '2021-08-09 09:25:25', '2021-08-21 10:56:36', '2222', '3306', '2021081177860471', '424242', '2021-08-21 10:56:07', '0');
INSERT INTO `activities_rule` VALUES ('142021083030400148', '789', '6666', '2021-08-05 06:35:58', '2021-08-05 19:30:58', '4444', '3307', '402021080402040153', '789王企鹅', '2021-08-30 19:28:50', '0');
INSERT INTO `activities_rule` VALUES ('142021092394970236', 'test', '6666', '2021-09-22 00:03:00', '2021-09-22 00:00:00', '2222', '3306', '2021080494780158', 'testssssss', '2021-09-23 19:22:54', '0');
INSERT INTO `activities_rule` VALUES ('142021101483760032', '最美员工', '6666', '2021-10-14 16:49:30', '2021-10-15 17:45:15', '4444', '3307', '402021101415210377', '最美员工', '2021-10-14 16:49:56', '0');
INSERT INTO `activities_rule` VALUES ('142021110315062121', '奥视达', '6666', '2021-11-17 22:50:23', '2021-11-27 23:55:23', '2222', '3306', '2021081177860471', '是的', '2021-11-03 22:53:08', '0');
INSERT INTO `activities_rule` VALUES ('142021111274380491', '12', '6666', '2021-11-01 00:00:16', '2021-11-30 23:55:16', '4444', '3307', '400000000000000001', '12', '2021-11-12 09:23:05', '0');
INSERT INTO `activities_rule` VALUES ('142022050656260009', '水电费', '6666', '2022-05-01 04:20:53', '2022-05-31 14:25:53', '2222', '3306', '2022022584520644', '水电费', '2022-05-06 14:23:14', '0');
INSERT INTO `activities_rule` VALUES ('142022122263331288', 'HGF', '6666', '2022-12-22 17:06:13', '2022-12-23 11:30:05', '2222', '3306', '2022120695590004', 'HGF', '2022-12-22 17:06:19', '0');

-- ----------------------------
-- Table structure for activities_type
-- ----------------------------
DROP TABLE IF EXISTS `activities_type`;
CREATE TABLE `activities_type` (
  `type_cd` varchar(30) NOT NULL COMMENT '文章类型',
  `type_name` varchar(100) NOT NULL COMMENT '类型名称',
  `type_desc` varchar(500) DEFAULT NULL COMMENT '类型描述',
  `seq` int NOT NULL COMMENT '顺序',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `defalut_show` varchar(12) NOT NULL DEFAULT 'Y' COMMENT '小程序是否显示，Y 显示 N 不显示',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  PRIMARY KEY (`type_cd`),
  KEY `at_type_cd` (`type_cd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of activities_type
-- ----------------------------

-- ----------------------------
-- Table structure for advert
-- ----------------------------
DROP TABLE IF EXISTS `advert`;
CREATE TABLE `advert` (
  `advert_id` varchar(30) NOT NULL COMMENT '广告ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `ad_name` varchar(200) NOT NULL COMMENT '广告名称',
  `ad_type_cd` varchar(12) NOT NULL COMMENT '广告类型,门禁机 10000',
  `classify` varchar(12) NOT NULL COMMENT '广告分类 9001 物流 9002 餐饮 9003 旅游 9004 酒店 9005 教育 9006 互联网',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID,主要用来做分片',
  `location_type_cd` varchar(12) NOT NULL DEFAULT '1000' COMMENT '位置类型，1000 大门 2000 单元门 3000 房屋门 4000 楼栋',
  `location_obj_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '对象ID，大门时小区ID，单元门 时单元ID 房屋时房屋ID，楼栋时 楼栋ID',
  `state` varchar(12) NOT NULL DEFAULT '1000' COMMENT '广告状态，1000 未审核 2000 审核通过 3000 审核拒绝 4000 未播放 5000 播放中',
  `seq` int NOT NULL DEFAULT '1' COMMENT '播放顺序',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  `view_type` varchar(12) NOT NULL COMMENT '广告类型 8888 图片 9999 视频',
  `advert_type` varchar(2) DEFAULT '3' COMMENT '发布类型\r\n1站内\r\n2站外\r\n3不跳转',
  `page_url` varchar(200) DEFAULT NULL COMMENT '路径',
  KEY `idx_advert_id` (`advert_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of advert
-- ----------------------------

-- ----------------------------
-- Table structure for advert_item
-- ----------------------------
DROP TABLE IF EXISTS `advert_item`;
CREATE TABLE `advert_item` (
  `advert_item_id` varchar(30) NOT NULL COMMENT '广告ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `advert_id` varchar(200) NOT NULL COMMENT '广告名称',
  `item_type_cd` varchar(12) NOT NULL COMMENT '8888 图片 9999 视频',
  `url` varchar(200) NOT NULL COMMENT '图片或视频地址',
  `community_id` varchar(30) DEFAULT NULL COMMENT '小区ID,主要用来做分片',
  `seq` int NOT NULL DEFAULT '1' COMMENT '播放顺序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  KEY `idx_advert_item` (`advert_item_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of advert_item
-- ----------------------------

-- ----------------------------
-- Table structure for allocation_storehouse
-- ----------------------------
DROP TABLE IF EXISTS `allocation_storehouse`;
CREATE TABLE `allocation_storehouse` (
  `as_id` varchar(30) NOT NULL COMMENT '调拨ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务Id',
  `sh_id_a` varchar(30) NOT NULL COMMENT '前仓库ID',
  `sh_id_z` varchar(30) NOT NULL COMMENT '后仓库ID',
  `res_id` varchar(30) NOT NULL COMMENT '物品ID',
  `res_name` varchar(100) NOT NULL COMMENT '物品名称',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `stock` varchar(100) DEFAULT NULL COMMENT '库存数',
  `start_user_id` varchar(30) NOT NULL COMMENT '申请人',
  `start_user_name` varchar(64) NOT NULL COMMENT '申请人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  `remark` varchar(1024) DEFAULT NULL COMMENT '调拨说明',
  `apply_id` varchar(30) NOT NULL COMMENT '申请ID',
  `original_stock` varchar(100) DEFAULT NULL COMMENT '原有库存',
  `times_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '物品timesId',
  PRIMARY KEY (`as_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of allocation_storehouse
-- ----------------------------
INSERT INTO `allocation_storehouse` VALUES ('262021040847940001', '202021040876841697', '252021040723070003', '252021040786640001', '852020110101150256', '扫把 - 带刮刀', '402019032924930007', '5', '30518940136629616640', 'wuxw', '2021-04-08 15:15:19', '0', '调拨申请', '', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021040854130001', '202021040866671391', '252021040723070003', '252021040786640001', '852020110101150256', '扫把 - 带刮刀', '402019032924930007', '5', '30518940136629616640', 'wuxw', '2021-04-08 01:40:28', '0', '请领导审批', '', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021040881850004', '202021040896921852', '252021040723070003', '252021040786640001', '852020110101150256', '扫把 - 带刮刀', '402019032924930007', '6', '30518940136629616640', 'wuxw', '2021-04-08 16:13:56', '0', '调拨申请', '', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021040892980010', '202021040809961849', '252021040723070003', '252021040786640001', '852020110101150256', '扫把 - 带刮刀', '402019032924930007', '3', '30518940136629616640', 'wuxw', '2021-04-08 16:29:07', '0', '测试调拨', '', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021040898690001', '202021040850041904', '252021040723070003', '252021040786640001', '852020110101150256', '扫把 - 带刮刀', '402019032924930007', '5', '30518940136629616640', 'wuxw', '2021-04-08 17:30:12', '0', '测试调拨', '', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021042910700007', '202021042990643825', '252021040723070003', '252021040786640001', '852021040112530007', '测试物品', '402019032924930007', '1', '30518940136629616640', 'wuxw', '2021-04-29 23:25:47', '0', '测试调拨', '292021042993600006', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021042921250003', '202021042913643821', '252021040723070003', '252021042956100002', '852021040887540011', '扫把 - 带刮刀', '402019032924930007', '2', '30518940136629616640', 'wuxw', '2021-04-29 23:05:42', '0', '测试', '292021042908970001', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021042952170008', '202021042990643825', '252021040723070003', '252021041271240005', '852020110101150256', '扫把 - 带刮刀', '402019032924930007', '2', '30518940136629616640', 'wuxw', '2021-04-29 23:25:47', '0', '测试调拨', '292021042993600006', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021042957750001', '202021042987873817', '252021040723070003', '252021042956100002', '852021040112530007', '测试物品', '402019032924930007', '1', '30518940136629616640', 'wuxw', '2021-04-29 21:57:34', '1', '测试', '29', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021042997030002', '202021042913643821', '252021040786640001', '252021042956100002', '852021040863010002', '扫把 - 带刮刀', '402019032924930007', '4', '30518940136629616640', 'wuxw', '2021-04-29 23:05:42', '0', '测试', '292021042908970001', null, null);
INSERT INTO `allocation_storehouse` VALUES ('262021052679820549', '202021052675817846', '252021040723070003', '252021042956100002', '852021052472440005', '苹果', '402019032924930007', '5', '30518940136629616640', 'wuxw', '2021-05-26 15:51:21', '0', '调拨申请', '292021052635130548', '225', null);
INSERT INTO `allocation_storehouse` VALUES ('262021052767860124', '202021052793939808', '252021052770610007', '252021052712840009', '852021052770420122', '中性笔', '402021052437100417', '50', '302021052485270016', 'yunshangwuye', '2021-05-27 20:19:32', '0', '调拨给乐安小区', '292021052735410123', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262021062905920289', '202021062965180846', '252021040723070003', '252021042956100002', '852021052472440005', '苹果', '402019032924930007', '1', '30518940136629616640', 'wuxw', '2021-06-29 17:55:40', '0', 'aaaaa', '292021062981240288', '232', null);
INSERT INTO `allocation_storehouse` VALUES ('262021070115850663', '202021070169031851', '252021040723070003', '252021042956100002', '852021062887730046', '21', '402019032924930007', '3', '30518940136629616640', 'wuxw', '2021-07-01 14:38:58', '0', '测试', '292021070152560662', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262021070152160659', '202021070161711841', '252021040723070003', '252021042956100002', '852021062887730046', '21', '402019032924930007', '3', '30518940136629616640', 'wuxw', '2021-07-01 14:38:51', '0', '测试', '292021070196570658', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262021070162350661', '202021070131771845', '252021040723070003', '252021042956100002', '852021062887730046', '21', '402019032924930007', '3', '30518940136629616640', 'wuxw', '2021-07-01 14:38:53', '0', '测试', '292021070196740660', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262021070183270657', '202021070107231837', '252021040723070003', '252021042956100002', '852021062887730046', '21', '402019032924930007', '3', '30518940136629616640', 'wuxw', '2021-07-01 14:38:44', '0', '测试', '292021070167490656', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262021081869390025', '202021081826580044', '252021081866300001', '252021081816400001', '852021081822890013', '水泥', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-08-18 16:39:04', '0', '物品调整', '292021081807710024', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021081881140023', '202021081802660039', '252021081866300001', '252021080952420023', '852021081822890013', '水泥', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-08-18 16:38:53', '0', '物品调整', '292021081869830022', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021081886360011', '-1', '252021080952420023', '252021081866300001', '852021081808370014', '水泥', '402021080402040153', '10', '302021080447630001', 'wuxw', '2021-08-18 16:38:04', '0', '紧急采购入库并调拨', '292021081837350012', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021081964740005', '202021101322680069', '252021081866300001', '252021081838890002', '852021081822890013', '水泥', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-08-19 09:49:41', '1', 'fasfadfsdf', '292021081961420004', '9', null);
INSERT INTO `allocation_storehouse` VALUES ('262021082131850114', '202021082395130043', '252021081866300001', '252021081838890002', '852021081822890013', '水泥', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-08-21 21:38:23', '1', 'ggh', '292021082156710113', '4', null);
INSERT INTO `allocation_storehouse` VALUES ('262021082190260112', '202021082103730217', '252021081866300001', '252021081838890002', '852021081822890013', '水泥', '402021080402040153', '2', '302021080447630001', 'wuxw', '2021-08-21 21:38:19', '0', 'ggh', '292021082177570111', '4', null);
INSERT INTO `allocation_storehouse` VALUES ('262021090313741036', '202021090342672063', '252021090392270082', '252021090371160078', '852021090308041008', '桂花酿-双瓶', '402021090318140703', '1', '302021090331850026', 'kimio', '2021-09-03 15:11:53', '1', '测试', '292021090388481035', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262021090350431038', '202021090388962059', '252021090392270082', '252021090371160078', '852021090308041008', '桂花酿-双瓶', '402021090318140703', '1', '302021090331850026', 'kimio', '2021-09-03 15:12:05', '1', '测试', '292021090379931037', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262021090383461042', '202021090395002055', '252021090392270082', '252021090320350087', '852021090308041008', '桂花酿-双瓶', '402021090318140703', '1', '302021090331850026', 'kimio', '2021-09-03 15:13:35', '1', '测试', '292021090387681041', '95', null);
INSERT INTO `allocation_storehouse` VALUES ('262021090738860729', '202021090784981953', '252021080952420023', '252021090373500111', '852021082914280959', '测试物料DEMO', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-07 14:29:29', '0', '123123', '292021090757170728', '2', null);
INSERT INTO `allocation_storehouse` VALUES ('262021090763130043', '-1', '252021090323360068', '252021090766000022', '852021090795950288', '光缆', '402021080402040153', '5', '302021080447630001', 'wuxw', '2021-09-07 10:25:20', '0', '紧急采购入库并调拨', '292021090780890044', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021090787330302', '202021090799171100', '252021090323360068', '252021090766000022', '852021090795950288', '光缆', '402021080402040153', '10', '302021080447630001', 'wuxw', '2021-09-07 09:51:00', '0', '运维', '292021090761660301', '15', null);
INSERT INTO `allocation_storehouse` VALUES ('262021091874240005', '202021101319520052', '252021080952420023', '252021090766000022', '852021081808370014', '水泥', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-18 09:15:34', '1', '2111', '292021091886880004', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262021091892460007', '202021101221250010', '252021080952420023', '252021090766000022', '852021081808370014', '水泥', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-18 09:15:39', '1', '2111', '292021091825060006', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092217680029', '-1', '252021080952420023', '252021090750650047', '852021082914280959', '测试物料DEMO', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-22 12:23:23', '0', '紧急采购入库并调拨', '292021092281280030', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092222700034', '-1', '252021092232750024', '252021090750650047', '852021092228500248', '水泥1111', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-22 13:09:08', '0', '紧急采购入库并调拨', '292021092231430035', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092315270028', '-1', '252021092232750024', '252021090750650047', '852021092245270036', '水泥1111', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-23 11:31:30', '0', '紧急采购入库并调拨', '292021092336100029', '13', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092325340270', '202021092480000033', '252021090750650047', '252021090766000022', '852021092327710011', '光缆', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-23 22:14:04', '1', '1', '292021092355760269', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092336880009', '-1', '252021090323360068', '252021090750650047', '852021090795950288', '光缆', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-23 11:22:25', '0', '紧急采购入库并调拨', '292021092361820010', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092346890024', '-1', '252021092232750024', '252021090750650047', '852021092245270036', '水泥1111', '402021080402040153', '11', '302021080447630001', 'wuxw', '2021-09-23 11:31:03', '0', '紧急采购入库并调拨', '292021092365870025', '2', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092389000014', '-1', '252021092232750024', '252021090750650047', '852021092245270036', '水泥1111', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-23 11:25:44', '0', '紧急采购入库并调拨', '292021092347180015', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092392450032', '-1', '252021092232750024', '252021090750650047', '852021092245270036', '水泥1111', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-23 11:32:58', '0', '紧急采购入库并调拨', '292021092343250033', '14', null);
INSERT INTO `allocation_storehouse` VALUES ('262021092736120018', '-1', '252021092232750024', '252021090750650047', '852021092245270036', '水泥1111', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-09-27 18:28:24', '0', '紧急采购入库并调拨', '292021092780130019', '15', null);
INSERT INTO `allocation_storehouse` VALUES ('262021100615471074', '202021100635073246', '252021090750650047', '252021090766000022', '852021092276830031', '测试物料DEMO', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-06 18:31:35', '0', 'Asaa', '292021100677531071', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021100619971073', '202021100602853243', '252021090750650047', '252021090766000022', '852021092245270036', '水泥1111', '402021080402040153', '5', '302021080447630001', 'wuxw', '2021-10-06 18:31:35', '0', 'Asaa', '292021100677531071', '16', null);
INSERT INTO `allocation_storehouse` VALUES ('262021100626281075', '202021100659833249', '252021092232750024', '252021090766000022', '852021092228500248', '水泥1111', '402021080402040153', '8', '302021080447630001', 'wuxw', '2021-10-06 18:31:35', '0', 'Asaa', '292021100677531071', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021100658341079', '202021100662433259', '252021090750650047', '252021090766000022', '852021092245270036', '水泥1111', '402021080402040153', '5', '302021080447630001', 'wuxw', '2021-10-06 18:32:04', '0', 'Asaa', '292021100667551078', '16', null);
INSERT INTO `allocation_storehouse` VALUES ('262021100692991077', '202021100644213254', '252021090750650047', '252021090766000022', '852021092245270036', '水泥1111', '402021080402040153', '5', '302021080447630001', 'wuxw', '2021-10-06 18:32:02', '0', 'Asaa', '292021100627931076', '16', null);
INSERT INTO `allocation_storehouse` VALUES ('262021100698661072', '202021100688273240', '252021090750650047', '252021090766000022', '852021092327710011', '光缆', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-06 18:31:34', '0', 'Asaa', '292021100677531071', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021101359350083', '202021101729150099', '252021090750650047', '252021090246120021', '852021092245270036', '水泥1111', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-13 16:07:45', '1', '王', '292021101329350082', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021101717430006', '202021101775390105', '252021090323360068', '252021092232750024', '852021090795950288', '光缆', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-17 16:56:52', '0', '需要', '292021101784730005', '108', null);
INSERT INTO `allocation_storehouse` VALUES ('262021101725580008', '202021101767960110', '252021090323360068', '252021092232750024', '852021090795950288', '光缆', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-17 16:56:56', '0', '需要', '292021101766850007', '108', null);
INSERT INTO `allocation_storehouse` VALUES ('262021101759090010', '202021101797120115', '252021090323360068', '252021092232750024', '852021090795950288', '光缆', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-17 16:57:00', '0', '需要', '292021101761240009', '108', null);
INSERT INTO `allocation_storehouse` VALUES ('262021101775500012', '202021101798600120', '252021090323360068', '252021092232750024', '852021090795950288', '光缆', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-17 16:57:01', '0', '需要', '292021101787970011', '108', null);
INSERT INTO `allocation_storehouse` VALUES ('262021101843730133', '202021101827090308', '252021090323360068', '252021091034940001', '852021090795950288', '光缆', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-18 15:41:24', '0', '你呢', '292021101870920132', '107', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102207180058', '-1', '252021102279260043', '252021102080530011', '852021102220800048', '饮用水-物业测试', '402021080402040153', '5', '302021102280150618', '物业测试', '2021-10-22 16:12:41', '0', '紧急采购入库并调拨', '292021102213700059', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102222690617', '202021102221991815', '252021101655700004', '252021101695880001', '852021101690950008', '铅笔', '402021100552781023', '1', '302021100583731027', '刘天明', '2021-10-22 13:43:06', '0', '123', '292021102271400616', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102240420046', '-1', '252021102279260043', '252021102080530011', '852021102223360621', '饮用水-物业测试', '402021080402040153', '11', '302021102280150618', '物业测试', '2021-10-22 13:54:39', '0', '紧急采购入库并调拨', '292021102259300047', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102240760611', '202021102268021811', '252021101655700004', '252021101695880001', '852021101690950008', '铅笔', '402021100552781023', '1', '302021100583731027', '刘天明', '2021-10-22 13:39:15', '1', '维修使用', '292021102220940610', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102256360038', '-1', '252021101655700004', '252021101695880001', '852021101690950008', '铅笔', '402021100552781023', '1', '302021100583731027', '刘天明', '2021-10-22 13:47:48', '0', '紧急采购入库并调拨', '292021102227280039', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102260430657', '202021102262302092', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-22 16:11:10', '0', '1', '292021102239010656', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102268370655', '202021102204892087', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-10-22 16:11:04', '0', '1', '292021102248470654', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102293350624', '202021102230021849', '302021100583731027', '252021101695880001', '852021102238540040', '铅笔', '402021100552781023', '1', '302021100583731027', '刘天明', '2021-10-22 14:16:38', '0', '123', '292021102235220623', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021102294300613', '202021102214661807', '252021101655700004', '252021101695880001', '852021101690950008', '铅笔', '402021100552781023', '1', '302021100583731027', '刘天明', '2021-10-22 13:39:19', '1', '维修使用', '292021102221480612', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110202201362', '202021110252335160', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 22:56:39', '0', '买东西', '292021110244351361', '15', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110228411370', '202021110207115188', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '10', '302021080447630001', 'wuxw', '2021-11-02 23:17:05', '0', '大大方方', '292021110208691369', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110239941372', '202021110209765193', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 23:17:24', '0', '大大方方', '292021110202161371', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110242311376', '202021110211905203', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 23:18:43', '0', '大大方方', '292021110204631375', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110254541382', '202021110248475231', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 23:32:47', '0', '飞飞飞', '292021110265091381', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110263721380', '202021110235905213', '252021102279260043', '252021102080530011', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 23:24:35', '0', '讲话稿', '292021110261491379', '22', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110265211364', '202021110294495165', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 22:56:45', '0', '买东西', '292021110214291363', '15', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110275281366', '202021110228385170', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '2', '302021080447630001', 'wuxw', '2021-11-02 22:56:55', '0', '买东西', '292021110223671365', '15', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110276051374', '202021110206085198', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 23:17:47', '0', '大大方方', '292021110232341373', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110297211384', '202021110239475236', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 23:32:50', '0', '飞飞飞', '292021110239101383', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110299751378', '202021110276825208', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-02 23:22:26', '0', '大大方方', '292021110203061377', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110315421691', '202021110385326475', '252021102279260043', '252021102080530011', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-03 16:22:55', '0', '接口健康久久', '292021110323051690', '21', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110340811693', '2020211106144312088', '252021102279260043', '252021102080530011', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-03 16:22:59', '1', '接口健康久久', '292021110374561692', '21', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110354400104', '-1', '252021102279260043', '252021102080530011', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-03 16:35:49', '0', '紧急采购入库并调拨', '292021110356990105', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110389651689', '202021110372076470', '252021102279260043', '252021102080530011', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-03 16:22:31', '0', '接口健康久久', '292021110395671688', '21', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110390720100', '-1', '252021102279260043', '252021102080530011', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-03 16:35:23', '0', '紧急采购入库并调拨', '292021110360900101', '9', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110403411946', '202021110909120181', '252021102279260043', '252021102080530011', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-04 14:52:48', '1', '花花', '292021110496841945', '20', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110404820133', '-1', '252021102279260043', '252021102080530011', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-04 14:45:54', '0', '紧急采购入库并调拨', '292021110424270134', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110476261959', '202021110568988815', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-04 15:38:41', '1', '就觉得后方可', '292021110455421958', '12', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110477200160', '-1', '252021102279260043', '252021102080530011', '852021102220800048', '饮用水-物业测试', '402021080402040153', '6', '302021080447630001', 'wuxw', '2021-11-04 19:34:04', '0', '紧急采购入库并调拨', '292021110436560161', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110727000031', '202021110722430126', '252021102279260043', '252021102080530011', '852021110645373019', '1.5米拖把', '402021080402040153', '20', '302021080447630001', 'wuxw', '2021-11-07 20:43:36', '0', '测试调拨物品', '292021110790110030', '50', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110785640033', '202021110706000136', '252021102279260043', '252021102080530011', '852021110645373019', '1.5米拖把', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-07 20:43:47', '1', '测试调拨物品', '292021110788010032', '50', null);
INSERT INTO `allocation_storehouse` VALUES ('262021110900280042', '202021110928900176', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '12', '302021080447630001', 'wuxw', '2021-11-09 05:41:11', '0', '34', '292021110973930041', '18', null);
INSERT INTO `allocation_storehouse` VALUES ('262021111529780014', '-1', '252021102279260043', '252021111553840011', '852021110645373019', '1.5米拖把', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-15 11:01:19', '0', '紧急采购入库并调拨', '292021111508350015', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021111597250031', '202021111561690160', '252021111553840011', '252021102279260043', '852021111593520016', '1.5米拖把', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-15 11:07:43', '0', '地方干部VS豆腐干士大夫', '292021111573000030', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021112331960474', '202021112393741188', '252021080952420023', '252021102279260043', '852021080913590208', '发过的', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-23 09:50:50', '1', '调出', '292021112304940472', '154', null);
INSERT INTO `allocation_storehouse` VALUES ('262021112397460473', '202021112393741188', '252021080952420023', '252021102279260043', '852021081144980470', '123', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-23 09:50:50', '1', '调出', '292021112304940472', '17', null);
INSERT INTO `allocation_storehouse` VALUES ('262021112586360070', '202021112511810109', '252021102080530011', '252021102279260043', '852021102220800048', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-25 18:51:21', '0', '1', '292021112540630069', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021113040160270', '202021113061650957', '252021102279260043', '252021113042180026', '852021113000560251', '运动城工程图纸1-001', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-30 10:59:54', '0', '2', '292021113095510269', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021113099680277', '202021120370920925', '252021102279260043', '252021113042180026', '852021113000560251', '运动城工程图纸1-001', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-11-30 11:11:05', '1', '3', '292021113089080276', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021120220080157', '202021120248560514', '252021102279260043', '252021113042180026', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-02 10:06:25', '0', '渝', '292021120213450156', '24', null);
INSERT INTO `allocation_storehouse` VALUES ('262021120228470161', '202021120271110524', '252021102279260043', '252021113042180026', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-02 10:06:29', '0', '渝', '292021120292510160', '24', null);
INSERT INTO `allocation_storehouse` VALUES ('262021120278170155', '202021120272980509', '252021102279260043', '252021113042180026', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-02 10:06:22', '0', '渝', '292021120242750154', '24', null);
INSERT INTO `allocation_storehouse` VALUES ('262021120280290159', '202021120276920519', '252021102279260043', '252021113042180026', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-02 10:06:28', '0', '渝', '292021120234220158', '24', null);
INSERT INTO `allocation_storehouse` VALUES ('262021120393270056', '-1', '252021102279260043', '252021120263040012', '852021113000560251', '运动城工程图纸1-001', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-03 17:39:40', '0', '紧急采购入库并调拨', '292021120382550057', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021120639480015', '-1', '252021102279260043', '252021120263040012', '852021111651470374', '方形电脑桌', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-06 10:09:07', '0', '紧急采购入库并调拨', '292021120642450016', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021120814380053', '202021120834730685', '252021120263040012', '252021102279260043', '852021120604950017', '方形电脑桌', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-08 10:05:35', '0', '111', '292021120875330052', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021120861420014', '-1', '252021102279260043', '252021120263040012', '852021112333200588', '手机', '402021080402040153', '20', '302021080447630001', 'wuxw', '2021-12-08 22:09:30', '0', '紧急采购入库并调拨', '292021120879490015', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121063051206', '202021121029223769', '252021102279260043', '252021120263040012', '852021102223360621', '饮用水-物业测试', '402021080402040153', '22', '302021080447630001', 'wuxw', '2021-12-10 09:56:11', '0', '11', '292021121089121205', '23', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121091041208', '202021121056603775', '252021090750650047', '252021120263040012', '852021092245270036', '水泥1111', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-10 09:56:12', '0', '11', '292021121089121205', '11', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121095421207', '202021121036713772', '252021080952420023', '252021101924150053', '852021092895920312', 'fsf', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-10 09:56:12', '0', '11', '292021121089121205', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121332330131', '202021121330350482', '252021120263040012', '252021113042180026', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-13 16:58:04', '0', 'kkk ', '292021121302370130', '20', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121342680133', '202021122860442779', '252021120263040012', '252021102279260043', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-13 16:58:12', '1', 'kkk ', '292021121366320132', '20', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121443800030', '2020211217665110296', '252021102279260043', '252021120263040012', '852021110645373019', '1.5米拖把', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-14 08:49:20', '1', '法國電視', '292021121463060029', '70', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121460020032', '2020211217183110288', '252021102279260043', '252021120263040012', '852021110645373019', '1.5米拖把', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-14 08:49:41', '1', '法國電視', '292021121473890031', '70', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121489780028', '202021121418060952', '252021102279260043', '252021113042180026', '852021102223360621', '饮用水-物业测试', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-14 08:46:55', '0', '法國電視', '292021121410550027', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121705803969', '2020211217024710345', '252021120263040012', '252021102279260043', '852021120307270058', '运动城工程图纸1-001', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-17 14:33:25', '0', ',', '292021121708123967', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121710793962', '2020211217310210338', '252021120263040012', '252021102279260043', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-17 14:32:21', '1', '11111', '292021121728903961', '19', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121711573958', '2020211217503310305', '252021120263040012', '252021113042180026', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-17 14:32:08', '0', '11111', '292021121795443957', '19', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121713543964', '2020211217378810334', '252021120263040012', '252021102279260043', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-17 14:32:24', '1', '11111', '292021121727083963', '19', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121738933960', '2020211217806910310', '252021120263040012', '252021113042180026', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-17 14:32:12', '0', '11111', '292021121773443959', '19', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121765873956', '2020211217872610300', '252021120263040012', '252021113042180026', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-17 14:32:05', '0', '11111', '292021121754143955', '19', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121772013968', '2020211217092910342', '252021120263040012', '252021102279260043', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-17 14:33:24', '0', ',', '292021121708123967', '21', null);
INSERT INTO `allocation_storehouse` VALUES ('262021121785853966', '2020211217603710330', '252021120263040012', '252021102279260043', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2021-12-17 14:32:30', '1', '11111', '292021121702323965', '19', null);
INSERT INTO `allocation_storehouse` VALUES ('262021122873310011', '202021122892280027', '252021102279260043', '252021092232750024', '852021113000560251', '运动城工程图纸1-001', '402021080402040153', '8', '302021080447630001', 'wuxw', '2021-12-28 21:35:03', '0', '666', '292021122858480010', '51', null);
INSERT INTO `allocation_storehouse` VALUES ('262022010339100358', '202022010351121088', '252021102279260043', '252021123058420011', '852021112333200588', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-03 16:17:00', '0', '三国杀', '292022010362560357', '18', null);
INSERT INTO `allocation_storehouse` VALUES ('262022010354550356', '202022010378181083', '252021102279260043', '252021123058420011', '852021112333200588', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-03 16:16:46', '0', '三国杀', '292022010315760355', '18', null);
INSERT INTO `allocation_storehouse` VALUES ('262022010606680103', '202022012100071500', '252021120263040012', '252021123051010014', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-06 14:45:24', '1', '123', '292022010679660102', '21', null);
INSERT INTO `allocation_storehouse` VALUES ('262022010612050105', '2020220116562216862', '252021102279260043', '252021123051010014', '852021111651470374', '方形电脑桌', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-06 14:45:51', '1', '122', '292022010643570104', '119', null);
INSERT INTO `allocation_storehouse` VALUES ('262022010613870099', '202022010611940928', '252021120263040012', '252021123051010014', '852021120876730016', '手机', '402021080402040153', '5', '302021080447630001', 'wuxw', '2022-01-06 14:45:09', '0', '123', '292022010641540098', '21', null);
INSERT INTO `allocation_storehouse` VALUES ('262022010622280101', '202022012422423659', '252021120263040012', '252021123051010014', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-06 14:45:16', '1', '123', '292022010696850100', '21', null);
INSERT INTO `allocation_storehouse` VALUES ('262022010642640108', '202022010724351682', '252021102279260043', '252021123051010014', '852021111651470374', '方形电脑桌', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-06 14:46:16', '1', '122', '292022010672720107', '119', null);
INSERT INTO `allocation_storehouse` VALUES ('262022010816401321', '2020220114987311568', '252021120263040012', '252021123058420011', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-08 23:31:50', '1', '城市', '292022010897711320', '16', null);
INSERT INTO `allocation_storehouse` VALUES ('262022011914330017', '202022011940550027', '252021120263040012', '252021113042180026', '852021120876730016', '手机', '402021080402040153', '2', '302021080447630001', 'wuxw', '2022-01-19 11:29:38', '0', '废物', '292022011914670016', '16', null);
INSERT INTO `allocation_storehouse` VALUES ('262022011939170019', '202022011912380032', '252021120263040012', '252021113042180026', '852021120876730016', '手机', '402021080402040153', '2', '302021080447630001', 'wuxw', '2022-01-19 11:29:41', '0', '废物', '292022011904160018', '16', null);
INSERT INTO `allocation_storehouse` VALUES ('262022011941970023', '202022011932050042', '252021120263040012', '252021113042180026', '852021120876730016', '手机', '402021080402040153', '2', '302021080447630001', 'wuxw', '2022-01-19 11:29:55', '0', '废物', '292022011936500022', '16', null);
INSERT INTO `allocation_storehouse` VALUES ('262022011971920021', '202022011931480037', '252021120263040012', '252021113042180026', '852021120876730016', '手机', '402021080402040153', '2', '302021080447630001', 'wuxw', '2022-01-19 11:29:43', '0', '废物', '292022011906220020', '16', null);
INSERT INTO `allocation_storehouse` VALUES ('262022012919251065', '202022012959547602', '252022012934940094', '252022012982020116', '852022012949971063', '手套', '402022012945120857', '100', '302022012942821590', 'fengyang', '2022-01-29 15:53:41', '0', '2我', '292022012964621064', '1000', null);
INSERT INTO `allocation_storehouse` VALUES ('262022012925581073', '202022012952217626', '252022012982020116', '252022012934940094', '852022012978421071', '帽子', '402022012945120857', '100', '302022012942821590', 'fengyang', '2022-01-29 16:03:08', '0', '11', '292022012907271072', '1000', null);
INSERT INTO `allocation_storehouse` VALUES ('262022012932541067', '202022012966247607', '252022012934940094', '252022012982020116', '852022012949971063', '手套', '402022012945120857', '100', '302022012942821590', 'fengyang', '2022-01-29 15:53:52', '0', '申请说明\n', '292022012921831066', '1000', null);
INSERT INTO `allocation_storehouse` VALUES ('262022012973020104', '-1', '252022012934940094', '252022012902040089', '852022012911581010', '口罩', '402022012945120857', '1000', '302022012942821590', 'fengyang', '2022-01-29 15:25:04', '0', '紧急采购入库并调拨', '292022012936510105', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022013013021264', '202022013013238294', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-30 21:41:13', '1', '申请从A仓库调拨50套樱桃小灯到B仓库', '292022013066081263', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022013020741273', '202022013096398316', '252022013078590159', '252022013049170153', '852022013080071258', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-30 23:30:43', '1', '1111', '292022013067221272', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022013037221269', '202022013023008307', '252022013078590159', '252022013049170153', '852022013080071258', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-30 23:29:29', '1', '1222', '292022013086171268', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022013068011260', '202022013004518279', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-30 21:40:39', '1', '申请从A仓库调拨50套樱桃小灯到B仓库', '292022013022071259', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022013077011262', '202022013037928290', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-01-30 21:40:46', '1', '申请从A仓库调拨50套樱桃小灯到B仓库', '292022013056211261', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020807021715', '202022020886569774', '252022020845130230', '252022020808270213', '852022020817421688', '测试110001', '402022012945120857', '80', '302022012942821590', 'fengyang', '2022-02-08 16:41:28', '0', '测试', '292022020829771714', '2000', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020808961640', '202022020844339471', '252022020836640193', '252022012982020116', '852022020800680205', '测试444', '402022012945120857', '5', '302022012942821590', 'fengyang', '2022-02-08 09:52:56', '0', '测试', '292022020845771639', '196', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020809320223', '-1', '252022012982020116', '252022020836640193', '852022020800680205', '测试444', '402022012945120857', '111', '302022012942821590', 'fengyang', '2022-02-08 10:11:39', '0', '紧急采购入库并调拨', '292022020878900224', '118', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020809841638', '202022020889729454', '252022020836640193', '252022012982020116', '852022020800680205', '测试444', '402022012945120857', '2', '302022012942821590', 'fengyang', '2022-02-08 09:44:55', '0', '测试', '292022020829671637', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020823651697', '202022021126641421', '252022020883480248', '252021123051010014', '852022020860691695', '消防用具', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-08 15:07:57', '1', '测试', '292022020827911696', '1000', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020825141706', '202022020840339724', '252022020836640193', '252022020808270213', '852022020807910241', '测试12222', '402022012945120857', '2', '302022012942821590', 'fengyang', '2022-02-08 15:55:36', '0', '测试', '292022020857681705', '2000', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020826081642', '202022020865499476', '252022020836640193', '252022012934940094', '852022020800680205', '测试444', '402022012945120857', '20', '302022012942821590', 'fengyang', '2022-02-08 09:53:39', '0', '测试', '292022020819891641', '191', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020833790203', '-1', '252022012982020116', '252022020836640193', '852022020883111621', '测试444', '402022012945120857', '200', '302022012942821590', 'fengyang', '2022-02-08 09:43:14', '0', '紧急采购入库并调拨', '292022020803600204', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020833790257', '-1', '252022020883480248', '252022012712310074', '852022020860691695', '消防用具', '402021080402040153', '20', '302021080447630001', 'wuxw', '2022-02-08 15:10:54', '0', '紧急采购入库并调拨', '292022020811000258', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020835621699', '2020220209537210474', '252022020883480248', '252021123051010014', '852022020860691695', '消防用具', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-08 15:08:09', '1', '测试', '292022020842591698', '1000', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020850811636', '202022020867289446', '252022020836640193', '252022012982020116', '852022020800680205', '测试444', '402022012945120857', '20', '302022012942821590', 'fengyang', '2022-02-08 09:44:44', '0', '测试', '292022020808641635', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020862251722', '202022020876779810', '252022020845130230', '252022020808270213', '852022020817421688', '测试110001', '402022012945120857', '80', '302022012942821590', 'fengyang', '2022-02-08 17:12:04', '0', '测试', '292022020869181721', '1920', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020868041634', '202022020822309441', '252022020836640193', '252022012982020116', '852022020800680205', '测试444', '402022012945120857', '20', '302022012942821590', 'fengyang', '2022-02-08 09:44:34', '0', '测试', '292022020820931633', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020883100239', '-1', '252022020808270213', '252022020836640193', '852022020804581648', '测试12222', '402022012945120857', '2000', '302022012942821590', 'fengyang', '2022-02-08 14:43:03', '0', '紧急采购入库并调拨', '292022020821060240', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020895581644', '202022020811799486', '252022020836640193', '252022020808270213', '852022020800680205', '测试444', '402022012945120857', '20', '302022012942821590', 'fengyang', '2022-02-08 10:00:39', '0', '测试', '292022020803341643', '171', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020905921940', '2020220209146510763', '252022020969530277', '252022020909200283', '852022020910151925', '0209物品', '402022012945120857', '10', '302022012942821590', 'fengyang', '2022-02-09 14:35:07', '0', '111', '292022020964791939', '260', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020911971927', '2020220209586710725', '252022020969530277', '252022020836640193', '852022020910151925', '0209物品', '402022012945120857', '50', '302022012942821590', 'fengyang', '2022-02-09 13:58:16', '0', '1111', '292022020939071926', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020918601837', '2020220209737510356', '252022020845130230', '252022020808270213', '852022020902611835', 'TEST-001', '402022012945120857', '50', '302022012942821590', 'fengyang', '2022-02-09 10:52:33', '0', '1231231', '292022020934631836', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020949111839', '2020220209284910362', '252022020845130230', '252022020808270213', '852022020902611835', 'TEST-001', '402022012945120857', '50', '302022012942821590', 'fengyang', '2022-02-09 10:52:39', '0', '1231231', '292022020906451838', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020952411803', '2020220209923410221', '252022020836640193', '252022020808270213', '852022020807910241', '测试12222', '402022012945120857', '111', '302022012942821590', 'fengyang', '2022-02-09 09:14:09', '0', '测试', '292022020990641802', '1998', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020958401931', '2020220209614110735', '252022020969530277', '252022020836640193', '852022020910151925', '0209物品', '402022012945120857', '50', '302022012942821590', 'fengyang', '2022-02-09 13:58:22', '0', '1111', '292022020916901930', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020962801805', '2020220209548910226', '252022020836640193', '252022020808270213', '852022020807910241', '测试12222', '402022012945120857', '20', '302022012942821590', 'fengyang', '2022-02-09 09:15:08', '0', '紧急调拨', '292022020984831804', '1887', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020966841841', '2020220209937310367', '252022020845130230', '252022020808270213', '852022020902611835', 'TEST-001', '402022012945120857', '50', '302022012942821590', 'fengyang', '2022-02-09 10:53:01', '0', '1231231', '292022020942171840', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020972091929', '2020220209379910730', '252022020969530277', '252022020836640193', '852022020910151925', '0209物品', '402022012945120857', '50', '302022012942821590', 'fengyang', '2022-02-09 13:58:19', '0', '1111', '292022020983211928', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022020990871843', '2020220209027110374', '252022020845130230', '252022020808270213', '852022020902611835', 'TEST-001', '402022012945120857', '45', '302022012942821590', 'fengyang', '2022-02-09 10:53:16', '0', '1231231', '292022020992901842', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021111380025', '-1', '252021123058420011', '252022012712310074', '852022012189400451', '11', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-11 15:25:22', '0', '紧急采购入库并调拨', '292022021140660026', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021115840585', '202022021154741483', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-11 15:35:43', '1', '刚刚好', '292022021189230584', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021124020590', '202022021177211461', '252021120263040012', '252021123058420011', '852021120876730016', '手机', '402021080402040153', '22', '302021080447630001', 'wuxw', '2022-02-11 15:40:44', '0', '过年家里人多，需要手机', '292022021189110589', '24', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021136470604', '202022021145451527', '252021123058420011', '252021102279260043', '852022012189400451', '11', '402021080402040153', '13', '302021080447630001', 'wuxw', '2022-02-11 15:47:45', '0', '你真的很是男是女', '292022021127150603', '133', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021138810583', '202022021132951686', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-11 15:35:42', '1', '刚刚好', '292022021154210582', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021141160598', '202022021150381512', '252021123058420011', '252021102279260043', '852022012189400451', '11', '402021080402040153', '13', '302021080447630001', 'wuxw', '2022-02-11 15:47:36', '0', '你真的很是男是女', '292022021115440597', '133', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021142180602', '202022021145501522', '252021123058420011', '252021102279260043', '852022012189400451', '11', '402021080402040153', '13', '302021080447630001', 'wuxw', '2022-02-11 15:47:43', '0', '你真的很是男是女', '292022021101750601', '133', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021146680579', '202022021181721457', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-11 15:35:39', '1', '刚刚好', '292022021186830578', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021155940078', '-1', '252021123058420011', '252022012712310074', '852022021101340027', '11', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-11 15:51:36', '0', '紧急采购入库并调拨', '292022021134620079', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021157220600', '202022021133551517', '252021123058420011', '252021102279260043', '852022012189400451', '11', '402021080402040153', '13', '302021080447630001', 'wuxw', '2022-02-11 15:47:42', '0', '你真的很是男是女', '292022021159080599', '133', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021161120021', '-1', '252022020883480248', '252022012712310074', '852022020847910259', '消防用具', '402021080402040153', '2', '302021080447630001', 'wuxw', '2022-02-11 15:23:06', '0', '紧急采购入库并调拨', '292022021101190022', '20', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021167310081', '-1', '252021102279260043', '252022012712310074', '852021112333200588', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-11 15:51:37', '0', '紧急采购入库并调拨', '292022021150020082', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021180000581', '202022021138111690', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-11 15:35:41', '1', '刚刚好', '292022021103480580', '200', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021186220606', '202022021175601532', '252021123058420011', '252021102279260043', '852022012189400451', '11', '402021080402040153', '13', '302021080447630001', 'wuxw', '2022-02-11 15:47:46', '0', '你真的很是男是女', '292022021183330605', '133', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021200840131', '-1', '252022020883480248', '252022012712310074', '852022020847910259', '消防用具', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-12 16:37:44', '0', '紧急采购入库并调拨', '292022021286900132', '22', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021208481361', '202022021203473655', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:08', '0', 'BB', '292022021215561360', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021211181359', '202022021207713650', '252022013078590159', '252022013049170153', '852022013080071258', '樱桃小灯', '402021080402040153', '100', '302021080447630001', 'wuxw', '2022-02-12 16:47:53', '0', 'BB', '292022021294291358', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021212841369', '202022021233273675', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:13', '0', 'BB', '292022021263261368', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021233481365', '202022021295773665', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:11', '0', 'BB', '292022021256191364', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021249161308', '202022021252153339', '252021120263040012', '252022013078590159', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-12 10:53:16', '0', '他的回复', '292022021255931307', '2', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021251520135', '-1', '252022020883480248', '252022012712310074', '852022020847910259', '消防用具', '402021080402040153', '100000', '302021080447630001', 'wuxw', '2022-02-12 16:40:08', '0', '紧急采购入库并调拨', '292022021203710136', '23', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021252761377', '202022021239603695', '252022013049170153', '252022020883480248', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:54', '0', 'BB', '292022021200721376', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021259151367', '202022021263853670', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:12', '0', 'BB', '292022021229111366', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021262001363', '202022021256953660', '252022013049170153', '252022013078590159', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:10', '0', 'BB', '292022021240121362', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021266351305', '202022021268743332', '252021120263040012', '252022013078590159', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-12 10:52:53', '0', '他的回复', '292022021260681304', '2', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021273401371', '202022021283923680', '252022013049170153', '252022020883480248', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:26', '0', 'BB', '292022021278731370', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021277601310', '202022021271213346', '252021120263040012', '252022013078590159', '852021120876730016', '手机', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-12 10:53:17', '0', '他的回复', '292022021299151309', '2', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021278411373', '202022021289033685', '252022013049170153', '252022020883480248', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:27', '0', 'BB', '292022021264551372', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022021298721375', '202022021295553690', '252022013049170153', '252022020883480248', '852022013035551257', '樱桃小灯', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-12 16:50:52', '0', 'BB', '292022021262251374', '203', null);
INSERT INTO `allocation_storehouse` VALUES ('262022022109210018', '202022022132839485', '252022020883480248', '252022013049170153', '852022020860691695', '消防用具', '402021080402040153', '10', '302021080447630001', 'wuxw', '2022-02-21 19:03:08', '0', 'x', '292022022128840017', '1020', null);
INSERT INTO `allocation_storehouse` VALUES ('262022022274450064', '202022022294759700', '252022020883480248', '252022022186950277', '852022020860691695', '消防用具', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-02-22 09:54:34', '0', 'cs', '292022022257180063', '1010', null);
INSERT INTO `allocation_storehouse` VALUES ('262022030150910202', '202022030979232192', '252022022186950277', '252022030131360072', '852022022316840195', 'aaaaaaa', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-03-01 09:30:24', '1', '11', '292022030182920201', '4', null);
INSERT INTO `allocation_storehouse` VALUES ('262022030950360690', '202022032800000017', '252022030131360072', '252022030945970105', '852022030105590409', 'LED灯泡', '402021080402040153', '1', '302021080447630001', 'wuxw', '2022-03-09 23:15:54', '1', '111', '292022030971370689', '111', null);
INSERT INTO `allocation_storehouse` VALUES ('262022032823230002', '202022032968120128', '252022032425390038', '252022032825370001', '852022032469890013', '123', '102022032498540001', '1', '302022032401850009', '方三三', '2022-03-28 15:01:28', '1', '物品调拨', '292022032882380001', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022032911150004', '-1', '252022032425390038', '252022032825370001', '852022032469890013', '123', '102022032498540001', '1', '302022032401850009', '方三三', '2022-03-29 11:46:18', '0', '123123', '292022032933310003', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022032975180006', '-1', '252022032425390038', '252022032825370001', '852022032469890013', '123', '102022032498540001', '1', '302022032401850009', '方三三', '2022-03-29 12:06:11', '0', '123', '292022032962740005', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022033048930018', '-1', '252022032425390038', '252022032825370001', '852022032436050012', '口罩', '102022032498540001', '1', '302022032401850009', '方三三', '2022-03-30 12:02:51', '0', '123', '292022033091660017', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022033066030025', '-1', '252022032425390038', '252022032825370001', '852022032436050012', '口罩', '102022032498540001', '1', '302022032401850009', '方三三', '2022-03-30 12:19:35', '0', '123', '292022033005670024', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262022033088450016', '202022033062620773', '252022032425390038', '252022032825370001', '852022032436050012', '口罩', '102022032498540001', '1', '302022032401850009', '方三三', '2022-03-30 12:01:50', '1', '1212', '292022033046910015', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022081360700021', '-1', '102022081328410426', '102022081372140421', '852022081336260014', '测试4', '102022080999350002', '1', '302022080912070008', 'boot测试物业', '2022-08-13 23:53:42', '0', '紧急采购入库并调拨', '292022081329810022', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022081807970035', '-1', '102022081835900028', '102022081881170017', '852022081874600031', '打印机', '102022081507340423', '1', '302022081574590429', 'wuxw', '2022-08-18 12:41:42', '0', '1', '292022081805580034', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022081808260084', '-1', '102022081835900028', '102022081881170017', '852022081874600031', '打印机', '102022081507340423', '10', '302022081574590429', 'wuxw', '2022-08-18 12:48:08', '0', '123', '292022081887020083', '1000', null);
INSERT INTO `allocation_storehouse` VALUES ('262022081811660073', '-1', '102022081835900028', '102022081881170017', '852022081841170058', '可乐', '102022081507340423', '20', '302022081574590429', 'wuxw', '2022-08-18 14:05:53', '0', '122', '292022081870480072', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022081821890098', '-1', '102022081835900028', '102022081881170017', '852022081874600031', '打印机', '102022081507340423', '1', '302022081574590429', 'wuxw', '2022-08-18 12:55:14', '0', '1', '292022081815810097', '990', null);
INSERT INTO `allocation_storehouse` VALUES ('262022081850160003', '-1', '102022081835900028', '102022081881170017', '852022081874600031', '打印机', '102022081507340423', '10', '302022081574590429', 'wuxw', '2022-08-18 13:07:53', '0', '123', '292022081814600002', '989', null);
INSERT INTO `allocation_storehouse` VALUES ('262022081877420052', '-1', '302022081574590429', '102022081881170017', '852022081874600031', '打印机', '102022081507340423', '1', '302022081574590429', 'wuxw', '2022-08-18 14:02:23', '0', '1', '292022081810510051', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022112803600005', '-1', '102022083017550150', '102022083017550150', '852022112882540018', '娃哈哈', '102022083062960025', '3', '302022083031660031', 'wuxw', '2022-11-28 14:26:35', '0', '紧急采购入库并调拨', '292022112840020006', '110', null);
INSERT INTO `allocation_storehouse` VALUES ('262022112820610021', '-1', '102022083017550150', '102022112854910015', '852022112882540018', '娃哈哈', '102022083062960025', '100', '302022083031660031', 'wuxw', '2022-11-28 14:42:28', '0', '紧急采购入库并调拨', '292022112867590022', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022112822300022', '-1', '102022083017550150', '102022083017550150', '852022112882540018', '娃哈哈', '102022083062960025', '100', '302022083031660031', 'wuxw', '2022-11-28 14:00:58', '0', '紧急采购入库并调拨', '292022112866180023', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022112899910029', '-1', '102022083017550150', '102022083017550150', '852022112882540018', '娃哈哈', '102022083062960025', '10', '302022083031660031', 'wuxw', '2022-11-28 14:08:12', '0', '紧急采购入库并调拨', '292022112824220030', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120541320290', '-1', '102022120334840119', '102022120334840119', '852022120505260226', '娃哈哈', '102022083062960025', '66', '302022083031660031', 'wuxw', '2022-12-05 17:25:17', '0', '紧急采购入库并调拨', '292022120545960291', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120541840224', '-1', '102022083017550150', '102022120334840119', '852022112882540018', '娃哈哈', '102022083062960025', '10', '302022083031660031', 'wuxw', '2022-12-05 09:39:24', '0', '紧急采购入库并调拨', '292022120560390225', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120596250295', '-1', '102022120334840119', '102022120334840119', '852022120505260226', '娃哈哈', '102022083062960025', '66', '302022083031660031', 'wuxw', '2022-12-05 17:25:18', '0', '紧急采购入库并调拨', '292022120505660296', '76', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120619170481', '-1', '102022120334840119', '102022120669470457', '852022120505260226', '娃哈哈', '102022083062960025', '1', '302022083031660031', 'wuxw', '2022-12-06 10:54:08', '0', '紧急采购入库并调拨', '292022120685590482', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120638600501', '-1', '102022120669470457', '102022083017550150', '852022120636560383', '惠普笔记本电脑', '102022083062960025', '50', '302022083031660031', 'wuxw', '2022-12-06 11:02:59', '0', '紧急采购入库并调拨', '292022120694600502', '15', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120644230486', '-1', '102022083017550150', '102022120669470457', '852022120636560383', '惠普笔记本电脑', '102022083062960025', '1', '302022083031660031', 'wuxw', '2022-12-06 10:54:08', '0', '紧急采购入库并调拨', '292022120602620487', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120650980492', '-1', '102022120669470457', '102022083017550150', '852022112882540018', '娃哈哈', '102022083062960025', '5', '302022083031660031', 'wuxw', '2022-12-06 10:56:12', '0', '紧急采购入库并调拨', '292022120695990493', '113', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120670600496', '-1', '102022120669470457', '102022083017550150', '852022120636560383', '惠普笔记本电脑', '102022083062960025', '5', '302022083031660031', 'wuxw', '2022-12-06 10:56:13', '0', '紧急采购入库并调拨', '292022120652970497', '10', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120728270650', '-1', '102022120669470457', '102022120669470457', '852022120612130488', '惠普笔记本电脑21', '102022083062960025', '5', '302022083031660031', 'wuxw', '2022-12-07 09:35:45', '0', '紧急采购入库并调拨', '292022120737970651', '1', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120900450947', '-1', '102022120669470457', '102022120814440766', '852022120715480670', '电脑', '102022083062960025', '8', '302022083031660031', 'wuxw', '2022-12-09 09:39:04', '0', '紧急采购入库并调拨', '292022120919620948', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120927950937', '-1', '102022083017550150', '102022120669470457', '852022120620870483', 'HP电脑', '102022083062960025', '12', '302022083031660031', 'wuxw', '2022-12-09 09:36:31', '0', '紧急采购入库并调拨', '292022120903040938', '51', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120934360982', '-1', '102022120814440766', '102022083017550150', '852022120951300918', '12312', '102022083062960025', '12', '302022083031660031', 'wuxw', '2022-12-09 10:25:38', '0', '紧急采购入库并调拨', '292022120985370983', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022120959780963', '-1', '102022083017550150', '102022120814440766', '852022120951300918', '12312', '102022083062960025', '99', '302022083031660031', 'wuxw', '2022-12-09 09:46:55', '0', '紧急采购入库并调拨', '292022120932910964', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262022122714610513', '-1', '102022120814440766', '102022120814440766', '852022120940950949', '电脑', '102022083062960025', '2', '302022083031660031', 'wuxw', '2022-12-27 17:11:46', '0', '紧急采购入库并调拨', '292022122770910514', '6', null);
INSERT INTO `allocation_storehouse` VALUES ('262023042395742027', '-1', '102023042375762001', '102023042375762001', '852023042319912010', '111', '102023013170370081', '1', '302023013185270087', '0131演示物业', '2023-04-23 09:52:37', '0', '紧急采购入库并调拨', '292023042363462028', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262023083003710006', '-1', '102023082412640003', '102023082412640003', '852023082533060002', '钢笔', '10202305221014329108000168', '10', '30202305221014327189000174', 'HC演示物业', '2023-08-30 09:14:02', '0', '紧急采购入库并调拨', '292023083092010007', '122', null);
INSERT INTO `allocation_storehouse` VALUES ('262023083054590003', '-1', '102023082412640003', '102023083071300036', '852023082533060002', '钢笔', '10202305221014329108000168', '10', '30202305221014327189000174', 'HC演示物业', '2023-08-30 18:50:37', '0', '调拨测试', '292023083016760002', '121.0', '112023082573090004');
INSERT INTO `allocation_storehouse` VALUES ('262023083055530022', '-1', '102023082412640003', '102023083071300036', '852023082566570007', '电动车', '10202305221014329108000168', '2', '30202305221014327189000174', 'HC演示物业', '2023-08-30 21:33:46', '0', '测试代码', '292023083071330021', '105.0', '112023082517890009');
INSERT INTO `allocation_storehouse` VALUES ('262023083100800011', '-1', '102023082412640003', '102023083071300036', '852023082566570007', '电动车', '10202305221014329108000168', '6', '30202305221014327189000174', 'HC演示物业', '2023-08-31 10:30:05', '0', '测试修改调拨', '292023083141490003', '78.0', '112023082517890009');
INSERT INTO `allocation_storehouse` VALUES ('262023083111720006', '-1', '102023082412640003', '102023083071300036', '852023082566570007', '电动车', '10202305221014329108000168', '6', '30202305221014327189000174', 'HC演示物业', '2023-08-31 11:52:38', '0', '测试调拨', '292023083105120003', '71.0', '112023082517890009');
INSERT INTO `allocation_storehouse` VALUES ('262023083126610004', '-1', '102023082412640003', '102023083071300036', '852023082566570007', '电动车', '10202305221014329108000168', '6', '30202305221014327189000174', 'HC演示物业', '2023-08-31 12:03:10', '0', '测试调拨最后一遍', '292023083162340003', '63.0', '112023082517890009');
INSERT INTO `allocation_storehouse` VALUES ('262023083140590006', '-1', '102023082412640003', '102023083071300036', '852023082659040002', 'mac', '10202305221014329108000168', '4', '30202305221014327189000174', 'HC演示物业', '2023-08-31 12:03:10', '0', '测试调拨最后一遍', '292023083162340003', '12.0', '112023082620470009');
INSERT INTO `allocation_storehouse` VALUES ('262023083154690013', '-1', '102023082412640003', '102023083071300036', '852023082566570007', '电动车', '10202305221014329108000168', '3', '30202305221014327189000174', 'HC演示物业', '2023-08-31 01:09:49', '0', '测试', '292023083171220012', '88.0', '112023082517890009');
INSERT INTO `allocation_storehouse` VALUES ('262023083163270004', '-1', '102023082412640003', '102023083071300036', '852023082659040002', 'mac', '10202305221014329108000168', '4', '30202305221014327189000174', 'HC演示物业', '2023-08-31 11:52:38', '0', '测试调拨', '292023083105120003', '12.0', '112023082620470009');
INSERT INTO `allocation_storehouse` VALUES ('262023083173520013', '-1', '102023082412640003', '102023083071300036', '852023082659040002', 'mac', '10202305221014329108000168', '3', '30202305221014327189000174', 'HC演示物业', '2023-08-31 10:30:05', '0', '测试修改调拨', '292023083141490003', '4', '112023082620470009');
INSERT INTO `allocation_storehouse` VALUES ('262023083179030022', '-1', '102023082412640003', '102023082412640003', '852023082533060002', '钢笔', '10202305221014329108000168', '10', '30202305221014327189000174', 'HC演示物业', '2023-08-31 16:01:21', '0', '紧急采购入库并调拨', '292023083163380023', '87', null);
INSERT INTO `allocation_storehouse` VALUES ('262023083183260004', '-1', '102023082412640003', '102023083071300036', '852023082566570007', '电动车', '10202305221014329108000168', '5', '30202305221014327189000174', 'HC演示物业', '2023-08-31 01:21:14', '0', '测试', '292023083192120003', '84.0', '112023082517890009');
INSERT INTO `allocation_storehouse` VALUES ('262023083185920004', '-1', '102023082412640003', '102023083071300036', '852023082659040002', 'mac', '10202305221014329108000168', '4', '30202305221014327189000174', 'HC演示物业', '2023-08-31 09:23:44', '1', '测试修改调拨', '292023083141490003', '12.0', '112023082620470009');
INSERT INTO `allocation_storehouse` VALUES ('262023083188000004', '-1', '102023082412640003', '102023083071300036', '852023082566570007', '电动车', '10202305221014329108000168', '3', '30202305221014327189000174', 'HC演示物业', '2023-08-31 01:35:04', '0', '测试', '292023083186850003', '81.0', '112023082517890009');
INSERT INTO `allocation_storehouse` VALUES ('262023090213660003', '-1', '102023082412640003', '102023083071300036', '852023082533060002', '钢笔', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业', '2023-09-02 17:38:42', '0', '试试', '292023090225200002', '147.0', '112023083184230020');
INSERT INTO `allocation_storehouse` VALUES ('262023091309360058', '-1', '102023082412640003', '102023083157950002', '852023082533060002', '钢笔', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业', '2023-09-13 13:38:16', '1', '订单', '292023091322500057', '142.0', '112023083184230020');
INSERT INTO `allocation_storehouse` VALUES ('262023091983170066', '-1', '102023082412640003', '102023091421820075', '852023082533060002', '钢笔', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业', '2023-09-19 16:33:40', '0', '123', '292023091973290065', '142.0', '112023083184230020');
INSERT INTO `allocation_storehouse` VALUES ('262024021811502137', '-1', '102023083071300036', '102023091421820075', '112024021819081644', '电动车', '10202305221014329108000168', '10', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 21:31:56', '0', '紧急采购入库并调拨', '292024021874742138', '1.0', null);
INSERT INTO `allocation_storehouse` VALUES ('262024021821162094', '-1', '102023083157950002', '102023083071300036', '112024021817921650', '钢笔', '10202305221014329108000168', '0', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 21:22:01', '1', 'hahaha', '292024021881872093', '1.0', '112024021812551652');
INSERT INTO `allocation_storehouse` VALUES ('262024021821921743', '-1', '102023082412640003', '102023091421820075', '852023082566570007', '电动车', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 16:50:46', '1', 'k', '292024021839221736', '58.0', '112024021812531608');
INSERT INTO `allocation_storehouse` VALUES ('262024021824541610', '-1', '102023082412640003', '102023082412640003', '852023082566570007', '电动车', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:51:35', '0', '紧急采购入库并调拨', '292024021858841611', '81', null);
INSERT INTO `allocation_storehouse` VALUES ('262024021828771637', '-1', '102023083071300036', '102023091421820075', '112023083118030017', '电动车', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:57:47', '0', '7', '292024021832001634', '39.0', '112023083114880018');
INSERT INTO `allocation_storehouse` VALUES ('262024021830501666', '-1', '102023083157950002', '102023082412640003', '112024021817921650', '钢笔', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:58:58', '1', '[p', '292024021878181665', '1.0', '112024021812551652');
INSERT INTO `allocation_storehouse` VALUES ('262024021833571639', '-1', '102023083071300036', '102023083157950002', '112023083044990008', '钢笔', '10202305221014329108000168', '10', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:57:47', '0', '7', '292024021832001634', '10.0', '112023090456870001');
INSERT INTO `allocation_storehouse` VALUES ('262024021836531580', '-1', '102023082412640003', '102023082412640003', '852023083102010003', '茶壶', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:51:33', '0', '紧急采购入库并调拨', '292024021883361581', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262024021838321724', '-1', '102023091421820075', '102023091421820075', '112024021851231656', 'mac', '10202305221014329108000168', '12', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 16:43:44', '0', '紧急采购入库并调拨', '292024021838621725', '10.0', null);
INSERT INTO `allocation_storehouse` VALUES ('262024021839701741', '-1', '102023082412640003', '102023083071300036', '852023082659040002', 'mac', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 16:50:46', '1', 'k', '292024021839221736', '9.0', '112024021865311598');
INSERT INTO `allocation_storehouse` VALUES ('262024021842251619', '-1', '102023082412640003', '102023082412640003', '852023082533060002', '钢笔', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:51:36', '0', '紧急采购入库并调拨', '292024021888231620', '119', null);
INSERT INTO `allocation_storehouse` VALUES ('262024021851621600', '-1', '102023082412640003', '102023082412640003', '852023082659040002', 'mac', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:51:35', '0', '紧急采购入库并调拨', '292024021894501601', '88', null);
INSERT INTO `allocation_storehouse` VALUES ('262024021864361739', '-1', '102023082412640003', '102023091421820075', '852023083194930002', '杯子', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 16:50:46', '1', 'k', '292024021839221736', '101.0', '112024021883181588');
INSERT INTO `allocation_storehouse` VALUES ('262024021876211745', '-1', '102023082412640003', '102023091421820075', '852023082533060002', '钢笔', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 16:50:46', '1', 'k', '292024021839221736', '144.0', '112023083184230020');
INSERT INTO `allocation_storehouse` VALUES ('262024021876411737', '-1', '102023082412640003', '102023091421820075', '852023083102010003', '茶壶', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 16:50:45', '1', 'k', '292024021839221736', '101.0', '112024021851031578');
INSERT INTO `allocation_storehouse` VALUES ('262024021879111590', '-1', '102023082412640003', '102023082412640003', '852023083194930002', '杯子', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:51:34', '0', '紧急采购入库并调拨', '292024021863031591', '100', null);
INSERT INTO `allocation_storehouse` VALUES ('262024021888041635', '-1', '102023083071300036', '102023091421820075', '112023083109720019', 'mac', '10202305221014329108000168', '10', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 15:57:47', '0', '7', '292024021832001634', '15.0', '112023083135320020');
INSERT INTO `allocation_storehouse` VALUES ('262024021954622835', '-1', '102023082412640003', '102023091421820075', '852023083194930002', '杯子', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-19 09:55:40', '0', '紧急采购入库并调拨', '292024021985742836', '0', null);
INSERT INTO `allocation_storehouse` VALUES ('262024022601530801', '-1', '30202305221014327189000174', '102023083157950002', '112023083044990008', '钢笔', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-26 12:43:53', '0', '退还', '292024022631990800', '10', '');
INSERT INTO `allocation_storehouse` VALUES ('262024022733340417', '-1', '30202305221014327189000174', '102023083157950002', '112023083044990008', '钢笔', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-27 09:34:17', '0', '洒洒水', '292024022746740407', '7', '');
INSERT INTO `allocation_storehouse` VALUES ('262024022760820408', '-1', '30202305221014327189000174', '102023091421820075', '112023083109720019', 'mac', '10202305221014329108000168', '1', '30202305221014327189000174', 'HC演示物业2', '2024-02-27 09:34:17', '0', '洒洒水', '292024022746740407', '4', '112023082620470009');
INSERT INTO `allocation_storehouse` VALUES ('262024022773420354', '-1', '30202305221014327189000174', '102023083157950002', '112023083044990008', '钢笔', '10202305221014329108000168', '2', '30202305221014327189000174', 'HC演示物业2', '2024-02-27 09:32:13', '0', '333', '292024022794540353', '9', '');
INSERT INTO `allocation_storehouse` VALUES ('262024022785430159', '-1', '102023083157950002', '102023083071300036', '112024021817921650', '钢笔', '10202305221014329108000168', '2', '30202305221014327189000174', 'HC演示物业2', '2024-02-27 08:29:38', '0', '测试数据', '292024022744790158', '2.0', '112024022695130807');

-- ----------------------------
-- Table structure for allocation_storehouse_apply
-- ----------------------------
DROP TABLE IF EXISTS `allocation_storehouse_apply`;
CREATE TABLE `allocation_storehouse_apply` (
  `apply_id` varchar(30) NOT NULL COMMENT '主键ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务Id',
  `start_user_id` varchar(30) NOT NULL COMMENT '申请人',
  `start_user_name` varchar(64) NOT NULL COMMENT '申请人',
  `remark` varchar(1024) NOT NULL COMMENT '申请说明',
  `apply_count` varchar(100) NOT NULL DEFAULT '1' COMMENT '调拨数量',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  `state` varchar(12) NOT NULL COMMENT '状态，1201 调拨审核 1202 调拨完成 1202 调拨失败',
  `apply_type` varchar(8) DEFAULT NULL COMMENT '调拨返还类型 10000 调拨 20000 返还 在t_dict表查看',
  `community_id` varchar(200) NOT NULL COMMENT '申请人小区id',
  PRIMARY KEY (`apply_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of allocation_storehouse_apply
-- ----------------------------
INSERT INTO `allocation_storehouse_apply` VALUES ('29', '202021042938403819', '30518940136629616640', 'wuxw', '测试', '1', '402019032924930007', '2021-04-29 21:57:34', '1', '1201', null, '');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021042908970001', '202021042992273823', '30518940136629616640', 'wuxw', '测试', '6', '402019032924930007', '2021-04-29 23:05:42', '0', '1201', null, '');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021042993600006', '202021042939413827', '30518940136629616640', 'wuxw', '测试调拨', '3', '402019032924930007', '2021-04-29 23:25:47', '0', '1201', null, '');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021052635130548', '202021052620397848', '30518940136629616640', 'wuxw', '调拨申请', '5', '402019032924930007', '2021-05-26 15:51:21', '0', '1200', null, '');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021052735410123', '202021052740549810', '302021052485270016', 'yunshangwuye', '调拨给乐安小区', '50', '402021052437100417', '2021-05-27 20:19:32', '0', '1200', null, '');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021062981240288', '202021062967970848', '30518940136629616640', 'wuxw', 'aaaaa', '1', '402019032924930007', '2021-06-29 17:55:47', '0', '1200', '10000', '7020181217000001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021070152560662', '202021070161731853', '30518940136629616640', 'wuxw', '测试', '3', '402019032924930007', '2021-07-01 14:39:14', '0', '1200', '10000', '7020181217000001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021070167490656', '202021070189991839', '30518940136629616640', 'wuxw', '测试', '3', '402019032924930007', '2021-07-01 14:38:59', '0', '1200', '10000', '7020181217000001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021070196570658', '202021070140511843', '30518940136629616640', 'wuxw', '测试', '3', '402019032924930007', '2021-07-01 14:39:07', '0', '1200', '10000', '7020181217000001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021070196740660', '202021070105341847', '30518940136629616640', 'wuxw', '测试', '3', '402019032924930007', '2021-07-01 14:39:09', '0', '1200', '10000', '7020181217000001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021081807710024', '202021081890270047', '302021080447630001', 'wuxw', '物品调整', '1', '402021080402040153', '2021-08-18 16:39:38', '0', '1200', '10000', '2021081028000020');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021081837350012', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '10', '402021080402040153', '2021-08-18 16:38:04', '0', '1202', '30000', '2021081028000020');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021081869830022', '202021081848980042', '302021080447630001', 'wuxw', '物品调整', '1', '402021080402040153', '2021-08-18 16:39:27', '0', '1200', '10000', '2021081028000020');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021081961420004', '202021101387700071', '302021080447630001', 'wuxw', 'fasfadfsdf', '5', '402021080402040153', '2021-08-19 09:50:12', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021082156710113', '202021082361830045', '302021080447630001', 'wuxw', 'ggh', '2', '402021080402040153', '2021-08-21 21:38:58', '1', '1200', '10000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021082177570111', '202021082107740220', '302021080447630001', 'wuxw', 'ggh', '2', '402021080402040153', '2021-08-21 21:38:54', '0', '1200', '10000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021090379931037', '202021090372862061', '302021090331850026', 'kimio', '测试', '5', '402021090318140703', '2021-09-03 15:12:46', '1', '1200', '10000', '2021090308590708');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021090387681041', '202021090349332057', '302021090331850026', 'kimio', '测试', '10', '402021090318140703', '2021-09-03 15:14:16', '1', '1200', '10000', '2021090308590708');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021090388481035', '202021090310532065', '302021090331850026', 'kimio', '测试', '10', '402021090318140703', '2021-09-03 15:12:33', '1', '1200', '10000', '2021090308590708');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021090757170728', '202021090757491956', '302021080447630001', 'wuxw', '123123', '1', '402021080402040153', '2021-09-07 14:30:12', '0', '1200', '10000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021090761660301', '202021090734931103', '302021080447630001', 'wuxw', '运维', '10', '402021080402040153', '2021-09-07 09:51:42', '0', '1200', '10000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021090780890044', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '5', '402021080402040153', '2021-09-07 10:25:20', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021091825060006', '202021101274780012', '302021080447630001', 'wuxw', '2111', '5', '402021080402040153', '2021-09-18 09:15:42', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021091886880004', '202021101311970054', '302021080447630001', 'wuxw', '2111', '5', '402021080402040153', '2021-09-18 09:15:35', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092231430035', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-09-22 13:09:08', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092281280030', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-09-22 12:23:23', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092336100029', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-09-23 11:31:30', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092343250033', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-09-23 11:32:58', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092347180015', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-09-23 11:25:45', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092355760269', '202021092437010035', '302021080447630001', 'wuxw', '1', '1', '402021080402040153', '2021-09-23 22:14:09', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092361820010', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-09-23 11:22:25', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092365870025', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '11', '402021080402040153', '2021-09-23 11:31:04', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021092780130019', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-09-27 18:28:24', '0', '1202', '30000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021100627931076', '202021100680023257', '302021080447630001', 'wuxw', 'Asaa', '5', '402021080402040153', '2021-10-06 18:32:13', '0', '1200', '10000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021100667551078', '202021100628843262', '302021080447630001', 'wuxw', 'Asaa', '5', '402021080402040153', '2021-10-06 18:32:14', '0', '1200', '10000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021100677531071', '202021100613613252', '302021080447630001', 'wuxw', 'Asaa', '15', '402021080402040153', '2021-10-06 18:31:44', '0', '1200', '10000', '2021080494780158');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021101329350082', '202021101762110101', '302021080447630001', 'wuxw', '王', '10', '402021080402040153', '2021-10-13 16:07:57', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021101761240009', '202021101771200118', '302021080447630001', 'wuxw', '需要', '1', '402021080402040153', '2021-10-17 16:57:15', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021101766850007', '202021101723110113', '302021080447630001', 'wuxw', '需要', '1', '402021080402040153', '2021-10-17 16:57:11', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021101784730005', '202021101727700108', '302021080447630001', 'wuxw', '需要', '1', '402021080402040153', '2021-10-17 16:57:07', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021101787970011', '202021101717180123', '302021080447630001', 'wuxw', '需要', '1', '402021080402040153', '2021-10-17 16:57:16', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021101870920132', '202021101806980311', '302021080447630001', 'wuxw', '你呢', '1', '402021080402040153', '2021-10-18 15:41:38', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102213700059', '-1', '302021102280150618', '物业测试', '紧急采购入库并调拨', '5', '402021080402040153', '2021-10-22 16:12:41', '0', '1202', '30000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102220940610', '202021102279961813', '302021100583731027', '刘天明', '维修使用', '1', '402021100552781023', '2021-10-22 13:39:32', '1', '1200', '10000', '2021100580500107');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102221480612', '202021102290741809', '302021100583731027', '刘天明', '维修使用', '1', '402021100552781023', '2021-10-22 13:39:36', '1', '1200', '10000', '2021100580500107');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102227280039', '-1', '302021100583731027', '刘天明', '紧急采购入库并调拨', '1', '402021100552781023', '2021-10-22 13:47:48', '0', '1202', '30000', '2021100580500107');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102235220623', '202021102297681852', '302021100583731027', '刘天明', '123', '1', '402021100552781023', '2021-10-22 14:16:55', '0', '1205', '20000', '2021100580500107');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102239010656', '202021102285562095', '302021080447630001', 'wuxw', '1', '1', '402021080402040153', '2021-10-22 16:11:27', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102248470654', '202021102205982090', '302021080447630001', 'wuxw', '1', '1', '402021080402040153', '2021-10-22 16:11:21', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102259300047', '-1', '302021102280150618', '物业测试', '紧急采购入库并调拨', '11', '402021080402040153', '2021-10-22 13:54:39', '0', '1202', '30000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021102271400616', '202021102202091820', '302021100583731027', '刘天明', '123', '1', '402021100552781023', '2021-10-22 13:43:22', '0', '1203', '10000', '2021100580500107');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110202161371', '202021110235335196', '302021080447630001', 'wuxw', '大大方方', '1', '402021080402040153', '2021-11-02 23:17:46', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110203061377', '202021110202755211', '302021080447630001', 'wuxw', '大大方方', '1', '402021080402040153', '2021-11-02 23:22:48', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110204631375', '202021110246365206', '302021080447630001', 'wuxw', '大大方方', '1', '402021080402040153', '2021-11-02 23:19:05', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110208691369', '202021110288465191', '302021080447630001', 'wuxw', '大大方方', '10', '402021080402040153', '2021-11-02 23:17:27', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110214291363', '202021110274065168', '302021080447630001', 'wuxw', '买东西', '1', '402021080402040153', '2021-11-02 22:57:07', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110223671365', '202021110238795173', '302021080447630001', 'wuxw', '买东西', '2', '402021080402040153', '2021-11-02 22:57:17', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110232341373', '202021110262745201', '302021080447630001', 'wuxw', '大大方方', '1', '402021080402040153', '2021-11-02 23:18:09', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110239101383', '202021110217575239', '302021080447630001', 'wuxw', '飞飞飞', '1', '402021080402040153', '2021-11-02 23:33:12', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110244351361', '202021110222665163', '302021080447630001', 'wuxw', '买东西', '1', '402021080402040153', '2021-11-02 22:57:01', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110261491379', '202021110277915216', '302021080447630001', 'wuxw', '讲话稿', '1', '402021080402040153', '2021-11-02 23:24:57', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110265091381', '202021110202825234', '302021080447630001', 'wuxw', '飞飞飞', '1', '402021080402040153', '2021-11-02 23:33:09', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110323051690', '202021110323636478', '302021080447630001', 'wuxw', '接口健康久久', '1', '402021080402040153', '2021-11-03 16:23:17', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110356990105', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-11-03 16:35:49', '0', '1202', '30000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110360900101', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-11-03 16:35:23', '0', '1202', '30000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110374561692', '2020211106701912090', '302021080447630001', 'wuxw', '接口健康久久', '1', '402021080402040153', '2021-11-03 16:23:21', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110395671688', '202021110387986473', '302021080447630001', 'wuxw', '接口健康久久', '1', '402021080402040153', '2021-11-03 16:22:54', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110424270134', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-11-04 14:45:54', '0', '1202', '30000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110436560161', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '6', '402021080402040153', '2021-11-04 19:34:04', '0', '1202', '30000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110455421958', '202021110588158817', '302021080447630001', 'wuxw', '就觉得后方可', '1', '402021080402040153', '2021-11-04 15:39:03', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110496841945', '202021110951620183', '302021080447630001', 'wuxw', '花花', '1', '402021080402040153', '2021-11-04 14:53:11', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110788010032', '202021110744880138', '302021080447630001', 'wuxw', '测试调拨物品', '20', '402021080402040153', '2021-11-07 20:44:11', '1', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110790110030', '202021110765070129', '302021080447630001', 'wuxw', '测试调拨物品', '20', '402021080402040153', '2021-11-07 20:43:59', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021110973930041', '202021110916970179', '302021080447630001', 'wuxw', '34', '12', '402021080402040153', '2021-11-09 05:41:35', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021111508350015', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-11-15 11:01:19', '0', '1202', '30000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021111573000030', '202021111539720163', '302021080447630001', 'wuxw', '地方干部VS豆腐干士大夫', '1', '402021080402040153', '2021-11-15 11:08:10', '0', '1200', '10000', '2021081177860471');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021112304940472', '202021112381001190', '302021080447630001', 'wuxw', '调出', '2', '402021080402040153', '2021-11-23 09:51:20', '1', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021112540630069', '202021112573250112', '302021080447630001', 'wuxw', '1', '1', '402021080402040153', '2021-11-25 18:51:51', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021113089080276', '202021120346330927', '302021080447630001', 'wuxw', '3', '1', '402021080402040153', '2021-11-30 11:11:38', '1', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021113095510269', '202021113044040960', '302021080447630001', 'wuxw', '2', '1', '402021080402040153', '2021-11-30 11:00:27', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021120213450156', '202021120222930517', '302021080447630001', 'wuxw', '渝', '1', '402021080402040153', '2021-12-02 10:06:59', '0', '1200', '10000', '2021101301480018');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021120234220158', '202021120269800522', '302021080447630001', 'wuxw', '渝', '1', '402021080402040153', '2021-12-02 10:07:02', '0', '1200', '10000', '2021101301480018');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021120242750154', '202021120201740512', '302021080447630001', 'wuxw', '渝', '1', '402021080402040153', '2021-12-02 10:06:56', '0', '1200', '10000', '2021101301480018');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021120292510160', '202021120246180527', '302021080447630001', 'wuxw', '渝', '1', '402021080402040153', '2021-12-02 10:07:03', '0', '1200', '10000', '2021101301480018');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021120382550057', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-12-03 17:39:40', '0', '1202', '30000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021120642450016', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2021-12-06 10:09:07', '0', '1202', '30000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021120875330052', '202021120860930688', '302021080447630001', 'wuxw', '111', '1', '402021080402040153', '2021-12-08 10:06:11', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021120879490015', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '20', '402021080402040153', '2021-12-08 22:09:30', '0', '1202', '30000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121089121205', '202021121005633778', '302021080447630001', 'wuxw', '11', '24', '402021080402040153', '2021-12-10 09:56:48', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121302370130', '202021121310350485', '302021080447630001', 'wuxw', 'kkk ', '1', '402021080402040153', '2021-12-13 16:58:04', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121366320132', '202021122827502781', '302021080447630001', 'wuxw', 'kkk ', '1', '402021080402040153', '2021-12-13 16:58:12', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121410550027', '202021121463160955', '302021080447630001', 'wuxw', '法國電視', '1', '402021080402040153', '2021-12-14 08:46:55', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121463060029', '2020211217889910298', '302021080447630001', 'wuxw', '法國電視', '10', '402021080402040153', '2021-12-14 08:49:20', '1', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121473890031', '2020211217689810290', '302021080447630001', 'wuxw', '法國電視', '10', '402021080402040153', '2021-12-14 08:49:42', '1', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121702323965', '2020211217206110332', '302021080447630001', 'wuxw', '11111', '3', '402021080402040153', '2021-12-17 14:32:32', '1', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121708123967', '2020211217562110348', '302021080447630001', 'wuxw', ',', '2', '402021080402040153', '2021-12-17 14:33:27', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121727083963', '2020211217258510336', '302021080447630001', 'wuxw', '11111', '1', '402021080402040153', '2021-12-17 14:32:26', '1', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121728903961', '2020211217174710340', '302021080447630001', 'wuxw', '11111', '1', '402021080402040153', '2021-12-17 14:32:23', '1', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121754143955', '2020211217108210303', '302021080447630001', 'wuxw', '11111', '1', '402021080402040153', '2021-12-17 14:32:07', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121773443959', '2020211217536510313', '302021080447630001', 'wuxw', '11111', '1', '402021080402040153', '2021-12-17 14:32:15', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021121795443957', '2020211217678910308', '302021080447630001', 'wuxw', '11111', '1', '402021080402040153', '2021-12-17 14:32:11', '0', '1200', '10000', '2021082568430029');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021122673786909', '202021122863812783', '302021080447630001', 'wuxw', '333', '2', '402021080402040153', '2021-12-26 21:42:23', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292021122858480010', '202021122877800030', '302021080447630001', 'wuxw', '666', '8', '402021080402040153', '2021-12-28 21:35:09', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022010315760355', '202022010346521086', '302021080447630001', 'wuxw', '三国杀', '1', '402021080402040153', '2022-01-03 16:16:56', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022010362560357', '202022010348961091', '302021080447630001', 'wuxw', '三国杀', '1', '402021080402040153', '2022-01-03 16:17:10', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022010641540098', '202022010650050931', '302021080447630001', 'wuxw', '123', '5', '402021080402040153', '2022-01-06 14:45:20', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022010643570104', '2020220116943716864', '302021080447630001', 'wuxw', '122', '12', '402021080402040153', '2022-01-06 14:46:03', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022010672720107', '202022010751851684', '302021080447630001', 'wuxw', '122', '12', '402021080402040153', '2022-01-06 14:46:27', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022010679660102', '202022012145281502', '302021080447630001', 'wuxw', '123', '5', '402021080402040153', '2022-01-06 14:45:36', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022010696850100', '202022012494273661', '302021080447630001', 'wuxw', '123', '5', '402021080402040153', '2022-01-06 14:45:28', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022010897711320', '2020220114735411570', '302021080447630001', 'wuxw', '城市', '12', '402021080402040153', '2022-01-08 23:32:02', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022011904160018', '202022011919760035', '302021080447630001', 'wuxw', '废物', '2', '402021080402040153', '2022-01-19 11:29:59', '0', '1200', '10000', '2022010568300641');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022011906220020', '202022011974630040', '302021080447630001', 'wuxw', '废物', '2', '402021080402040153', '2022-01-19 11:30:01', '0', '1200', '10000', '2022010568300641');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022011914670016', '202022011913550030', '302021080447630001', 'wuxw', '废物', '2', '402021080402040153', '2022-01-19 11:29:55', '0', '1200', '10000', '2022010568300641');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022011936500022', '202022011935590045', '302021080447630001', 'wuxw', '废物', '2', '402021080402040153', '2022-01-19 11:30:13', '0', '1200', '10000', '2022010568300641');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022012907271072', '202022012956507629', '302022012942821590', 'fengyang', '11', '100', '402022012945120857', '2022-01-29 16:03:30', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022012921831066', '202022012978767610', '302022012942821590', 'fengyang', '申请说明\n', '100', '402022012945120857', '2022-01-29 15:54:15', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022012936510105', '-1', '302022012942821590', 'fengyang', '紧急采购入库并调拨', '1000', '402022012945120857', '2022-01-29 15:25:04', '0', '1202', '30000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022012964621064', '202022012982887605', '302022012942821590', 'fengyang', '2我', '100', '402022012945120857', '2022-01-29 15:54:04', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022013022071259', '202022013060548281', '302021080447630001', 'wuxw', '申请从A仓库调拨50套樱桃小灯到B仓库', '50', '402021080402040153', '2022-01-30 21:41:02', '1', '1200', '10000', '2022010664700304');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022013056211261', '202022013069068292', '302021080447630001', 'wuxw', '申请从A仓库调拨50套樱桃小灯到B仓库', '50', '402021080402040153', '2022-01-30 21:41:09', '1', '1200', '10000', '2022010664700304');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022013066081263', '202022013065388296', '302021080447630001', 'wuxw', '申请从A仓库调拨50套樱桃小灯到B仓库', '50', '402021080402040153', '2022-01-30 21:41:36', '1', '1200', '10000', '2022010664700304');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022013067221272', '202022013018978318', '302021080447630001', 'wuxw', '1111', '10', '402021080402040153', '2022-01-30 23:31:06', '1', '1200', '10000', '2022010664700304');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022013086171268', '202022013020498309', '302021080447630001', 'wuxw', '1222', '10', '402021080402040153', '2022-01-30 23:29:52', '1', '1200', '10000', '2022010664700304');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020803341643', '202022020805379489', '302022012942821590', 'fengyang', '测试', '20', '402022012945120857', '2022-02-08 10:01:06', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020803600204', '-1', '302022012942821590', 'fengyang', '紧急采购入库并调拨', '200', '402022012945120857', '2022-02-08 09:43:14', '0', '1202', '30000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020808641635', '202022020839889449', '302022012942821590', 'fengyang', '测试', '20', '402022012945120857', '2022-02-08 09:45:11', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020811000258', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '20', '402021080402040153', '2022-02-08 15:10:54', '0', '1202', '30000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020819891641', '202022020824359479', '302022012942821590', 'fengyang', '测试', '20', '402022012945120857', '2022-02-08 09:54:06', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020820931633', '202022020866439444', '302022012942821590', 'fengyang', '测试', '20', '402022012945120857', '2022-02-08 09:45:01', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020821060240', '-1', '302022012942821590', 'fengyang', '紧急采购入库并调拨', '2000', '402022012945120857', '2022-02-08 14:43:03', '0', '1202', '30000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020827911696', '202022021118391423', '302021080447630001', 'wuxw', '测试', '20', '402021080402040153', '2022-02-08 15:08:24', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020829671637', '202022020869159457', '302022012942821590', 'fengyang', '测试', '2', '402022012945120857', '2022-02-08 09:45:22', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020829771714', '202022020898469777', '302022012942821590', 'fengyang', '测试', '80', '402022012945120857', '2022-02-08 16:41:55', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020842591698', '2020220209752210476', '302021080447630001', 'wuxw', '测试', '20', '402021080402040153', '2022-02-08 15:08:36', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020845771639', '202022020850559474', '302022012942821590', 'fengyang', '测试', '5', '402022012945120857', '2022-02-08 09:53:23', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020857681705', '202022020811889727', '302022012942821590', 'fengyang', '测试', '2', '402022012945120857', '2022-02-08 15:56:03', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020869181721', '202022020832469813', '302022012942821590', 'fengyang', '测试', '80', '402022012945120857', '2022-02-08 17:12:31', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020878900224', '-1', '302022012942821590', 'fengyang', '紧急采购入库并调拨', '111', '402022012945120857', '2022-02-08 10:11:39', '0', '1202', '30000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020906451838', '2020220209447810365', '302022012942821590', 'fengyang', '1231231', '50', '402022012945120857', '2022-02-09 10:53:06', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020916901930', '2020220209188910738', '302022012942821590', 'fengyang', '1111', '50', '402022012945120857', '2022-02-09 13:58:50', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020934631836', '2020220209350610359', '302022012942821590', 'fengyang', '1231231', '50', '402022012945120857', '2022-02-09 10:53:01', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020939071926', '2020220209269710728', '302022012942821590', 'fengyang', '1111', '50', '402022012945120857', '2022-02-09 13:58:44', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020942171840', '2020220209754710370', '302022012942821590', 'fengyang', '1231231', '50', '402022012945120857', '2022-02-09 10:53:28', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020964791939', '2020220209768910766', '302022012942821590', 'fengyang', '111', '10', '402022012945120857', '2022-02-09 14:35:34', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020983211928', '2020220209472810733', '302022012942821590', 'fengyang', '1111', '50', '402022012945120857', '2022-02-09 13:58:47', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020984831804', '2020220209715310229', '302022012942821590', 'fengyang', '紧急调拨', '20', '402022012945120857', '2022-02-09 09:15:35', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020990641802', '2020220209314110224', '302022012942821590', 'fengyang', '测试', '111', '402022012945120857', '2022-02-09 09:14:36', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022020992901842', '2020220209045710377', '302022012942821590', 'fengyang', '1231231', '45', '402022012945120857', '2022-02-09 10:53:44', '0', '1200', '10000', '2022012983420596');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021101190022', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '2', '402021080402040153', '2022-02-11 15:23:06', '0', '1202', '30000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021101750601', '202022021146591525', '302021080447630001', 'wuxw', '你真的很是男是女', '13', '402021080402040153', '2022-02-11 15:47:44', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021103480580', '202022021134551692', '302021080447630001', 'wuxw', '刚刚好', '1', '402021080402040153', '2022-02-11 15:35:41', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021115440597', '202022021101451515', '302021080447630001', 'wuxw', '你真的很是男是女', '13', '402021080402040153', '2022-02-11 15:47:36', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021127150603', '202022021179611530', '302021080447630001', 'wuxw', '你真的很是男是女', '13', '402021080402040153', '2022-02-11 15:47:45', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021134620079', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2022-02-11 15:51:36', '0', '1202', '30000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021140660026', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2022-02-11 15:25:22', '0', '1202', '30000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021150020082', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2022-02-11 15:51:37', '0', '1202', '30000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021154210582', '202022021106931688', '302021080447630001', 'wuxw', '刚刚好', '1', '402021080402040153', '2022-02-11 15:35:43', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021159080599', '202022021120561520', '302021080447630001', 'wuxw', '你真的很是男是女', '13', '402021080402040153', '2022-02-11 15:47:42', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021183330605', '202022021186021535', '302021080447630001', 'wuxw', '你真的很是男是女', '13', '402021080402040153', '2022-02-11 15:47:47', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021186830578', '202022021186821459', '302021080447630001', 'wuxw', '刚刚好', '1', '402021080402040153', '2022-02-11 15:35:39', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021189110589', '202022021110911464', '302021080447630001', 'wuxw', '过年家里人多，需要手机', '22', '402021080402040153', '2022-02-11 15:40:45', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021189230584', '202022021141841485', '302021080447630001', 'wuxw', '刚刚好', '1', '402021080402040153', '2022-02-11 15:35:44', '1', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021200721376', '202022021290083698', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:55', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021203710136', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '100000', '402021080402040153', '2022-02-12 16:40:08', '0', '1202', '30000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021215561360', '202022021244043658', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:09', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021229111366', '202022021290823673', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:13', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021240121362', '202022021266663663', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:11', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021255931307', '202022021282723342', '302021080447630001', 'wuxw', '他的回复', '1', '402021080402040153', '2022-02-12 10:53:17', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021256191364', '202022021223703668', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:12', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021260681304', '202022021204883335', '302021080447630001', 'wuxw', '他的回复', '1', '402021080402040153', '2022-02-12 10:52:54', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021262251374', '202022021211283693', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:53', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021263261368', '202022021265733678', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:14', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021264551372', '202022021243713688', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:29', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021278731370', '202022021254013683', '302021080447630001', 'wuxw', 'BB', '10', '402021080402040153', '2022-02-12 16:50:27', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021286900132', '-1', '302021080447630001', 'wuxw', '紧急采购入库并调拨', '1', '402021080402040153', '2022-02-12 16:37:44', '0', '1202', '30000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021294291358', '202022021211513653', '302021080447630001', 'wuxw', 'BB', '100', '402021080402040153', '2022-02-12 16:47:54', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022021299151309', '202022021277883349', '302021080447630001', 'wuxw', '他的回复', '1', '402021080402040153', '2022-02-12 10:53:18', '0', '1200', '10000', '2021091071090320');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022022128840017', '202022022162489488', '302021080447630001', 'wuxw', 'x', '10', '402021080402040153', '2022-02-21 19:03:13', '0', '1200', '10000', '2021090298220120');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022022257180063', '202022022242339705', '302021080447630001', 'wuxw', 'cs', '1', '402021080402040153', '2022-02-22 09:54:40', '0', '1200', '10000', '2021082661900033');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022030182920201', '202022030928602194', '302021080447630001', 'wuxw', '11', '1', '402021080402040153', '2022-03-01 09:30:33', '1', '1200', '10000', '2022022584520644');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022030971370689', '202022032846440019', '302021080447630001', 'wuxw', '111', '11', '402021080402040153', '2022-03-09 23:16:07', '1', '1200', '10000', '2022022584520644');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022032882380001', '202022032940310130', '302022032401850009', '方三三', '物品调拨', '1', '102022032498540001', '2022-03-28 23:01:27', '1', '1200', '10000', '2022031594770001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022032933310003', '202022032971090177', '302022032401850009', '方三三', '123123', '1', '102022032498540001', '2022-03-29 11:46:18', '0', '1203', '10000', '2022031594770001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022032962740005', '202022032968220193', '302022032401850009', '方三三', '123', '1', '102022032498540001', '2022-03-29 12:06:11', '0', '1202', '10000', '2022031594770001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022033005670024', '202022033062510851', '302022032401850009', '方三三', '123', '1', '102022032498540001', '2022-03-30 12:19:35', '0', '1202', '10000', '2022031594770001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022033046910015', '202022033052160775', '302022032401850009', '方三三', '1212', '1', '102022032498540001', '2022-03-30 12:01:50', '1', '1200', '10000', '2022031594770001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022033091660017', '202022033064040785', '302022032401850009', '方三三', '123', '1', '102022032498540001', '2022-03-30 12:02:51', '0', '1202', '10000', '2022031594770001');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022081329810022', '-1', '302022080912070008', 'boot测试物业', '紧急采购入库并调拨', '1', '102022080999350002', '2022-08-13 23:53:42', '0', '1202', '30000', '2022080904060004');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022081805580034', '-1', '302022081574590429', 'wuxw', '1', '1', '102022081507340423', '2022-08-18 12:41:43', '0', '1201', '10000', '2022081539020475');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022081810510051', '-1', '302022081574590429', 'wuxw', '1', '1', '102022081507340423', '2022-08-18 14:02:23', '0', '1205', '20000', '2022081539020475');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022081814600002', '-1', '302022081574590429', 'wuxw', '123', '10', '102022081507340423', '2022-08-18 13:07:53', '0', '1202', '10000', '2022081539020475');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022081815810097', '-1', '302022081574590429', 'wuxw', '1', '1', '102022081507340423', '2022-08-18 12:55:14', '0', '1201', '10000', '2022081539020475');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022081870480072', '-1', '302022081574590429', 'wuxw', '122', '20', '102022081507340423', '2022-08-18 14:05:53', '0', '1202', '10000', '2022081539020475');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022081887020083', '-1', '302022081574590429', 'wuxw', '123', '10', '102022081507340423', '2022-08-18 12:48:08', '0', '1201', '10000', '2022081539020475');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022112824220030', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '10', '102022083062960025', '2022-11-28 14:08:12', '0', '1202', '30000', '2022112555490011');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022112840020006', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '3', '102022083062960025', '2022-11-28 14:26:36', '0', '1202', '30000', '2022112555490011');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022112866180023', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '100', '102022083062960025', '2022-11-28 14:00:58', '0', '1202', '30000', '2022112555490011');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022112867590022', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '100', '102022083062960025', '2022-11-28 14:42:28', '0', '1202', '30000', '2022112555490011');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120505660296', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '66', '102022083062960025', '2022-12-05 17:25:19', '0', '1202', '30000', '2022120203810096');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120545960291', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '66', '102022083062960025', '2022-12-05 17:25:17', '0', '1202', '30000', '2022120203810096');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120560390225', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '10', '102022083062960025', '2022-12-05 09:39:24', '0', '1202', '30000', '2022120203810096');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120602620487', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '1', '102022083062960025', '2022-12-06 10:54:09', '0', '1202', '30000', '2022120203810096');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120652970497', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '5', '102022083062960025', '2022-12-06 10:56:13', '0', '1202', '30000', '2022120203810096');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120685590482', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '1', '102022083062960025', '2022-12-06 10:54:08', '0', '1202', '30000', '2022120203810096');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120694600502', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '50', '102022083062960025', '2022-12-06 11:02:59', '0', '1202', '30000', '2022120203810096');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120695990493', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '5', '102022083062960025', '2022-12-06 10:56:12', '0', '1202', '30000', '2022120203810096');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120737970651', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '5', '102022083062960025', '2022-12-07 09:35:45', '0', '1202', '30000', '2022120695590004');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120903040938', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '12', '102022083062960025', '2022-12-09 09:36:32', '0', '1202', '30000', '2022120695590004');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120919620948', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '8', '102022083062960025', '2022-12-09 09:39:04', '0', '1202', '30000', '2022120695590004');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120932910964', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '99', '102022083062960025', '2022-12-09 09:46:55', '0', '1202', '30000', '2022120695590004');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022120985370983', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '12', '102022083062960025', '2022-12-09 10:25:39', '0', '1202', '30000', '2022120695590004');
INSERT INTO `allocation_storehouse_apply` VALUES ('292022122770910514', '-1', '302022083031660031', 'wuxw', '紧急采购入库并调拨', '2', '102022083062960025', '2022-12-27 17:11:46', '0', '1202', '30000', '2022120695590004');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023042363462028', '-1', '302023013185270087', '0131演示物业', '紧急采购入库并调拨', '1', '102023013170370081', '2023-04-23 09:52:37', '0', '1202', '30000', '2023013154290059');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083016760002', '-1', '30202305221014327189000174', 'HC演示物业', '调拨测试', '0', '10202305221014329108000168', '2023-08-30 18:50:37', '0', '1200', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083071330021', '-1', '30202305221014327189000174', 'HC演示物业', '测试代码', '0', '10202305221014329108000168', '2023-08-30 21:33:46', '0', '1202', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083092010007', '-1', '30202305221014327189000174', 'HC演示物业', '紧急采购入库并调拨', '10', '10202305221014329108000168', '2023-08-30 09:14:03', '0', '1202', '30000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083105120003', '-1', '30202305221014327189000174', 'HC演示物业', '测试调拨', '10', '10202305221014329108000168', '2023-08-31 11:52:38', '0', '1202', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083141490003', '-1', '30202305221014327189000174', 'HC演示物业', '测试修改调拨', '9', '10202305221014329108000168', '2023-08-31 09:23:44', '0', '1202', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083162340003', '-1', '30202305221014327189000174', 'HC演示物业', '测试调拨最后一遍', '10', '10202305221014329108000168', '2023-08-31 12:03:10', '0', '1202', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083163380023', '-1', '30202305221014327189000174', 'HC演示物业', '紧急采购入库并调拨', '10', '10202305221014329108000168', '2023-08-31 16:01:20', '0', '1202', '30000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083171220012', '-1', '30202305221014327189000174', 'HC演示物业', '测试', '0', '10202305221014329108000168', '2023-08-31 01:09:49', '0', '1202', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083186850003', '-1', '30202305221014327189000174', 'HC演示物业', '测试', '0', '10202305221014329108000168', '2023-08-31 01:35:04', '0', '1202', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023083192120003', '-1', '30202305221014327189000174', 'HC演示物业', '测试', '0', '10202305221014329108000168', '2023-08-31 01:21:14', '0', '1202', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023090225200002', '-1', '30202305221014327189000174', 'HC演示物业', '试试', '1', '10202305221014329108000168', '2023-09-02 17:38:43', '0', '1202', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023091322500057', '-1', '30202305221014327189000174', 'HC演示物业', '订单', '1', '10202305221014329108000168', '2023-09-13 13:38:16', '1', '1200', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292023091973290065', '-1', '30202305221014327189000174', 'HC演示物业', '123', '1', '10202305221014329108000168', '2023-09-19 16:33:41', '0', '1200', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021832001634', '-1', '30202305221014327189000174', 'HC演示物业2', '7', '21.0', '10202305221014329108000168', '2024-02-18 15:57:47', '0', '1201', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021838621725', '-1', '30202305221014327189000174', 'HC演示物业2', '紧急采购入库并调拨', '12', '10202305221014329108000168', '2024-02-18 16:43:44', '0', '1202', '30000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021839221736', '-1', '30202305221014327189000174', 'HC演示物业2', 'k', '5.0', '10202305221014329108000168', '2024-02-18 16:50:46', '1', '1200', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021858841611', '-1', '30202305221014327189000174', 'HC演示物业2', '紧急采购入库并调拨', '1', '10202305221014329108000168', '2024-02-18 15:51:35', '0', '1202', '30000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021863031591', '-1', '30202305221014327189000174', 'HC演示物业2', '紧急采购入库并调拨', '1', '10202305221014329108000168', '2024-02-18 15:51:34', '0', '1202', '30000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021878181665', '-1', '30202305221014327189000174', 'HC演示物业2', '[p', '1.0', '10202305221014329108000168', '2024-02-18 15:58:58', '1', '1200', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021881872093', '-1', '30202305221014327189000174', 'HC演示物业2', 'hahaha', '0.0', '10202305221014329108000168', '2024-02-18 21:22:01', '1', '1200', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021883361581', '-1', '30202305221014327189000174', 'HC演示物业2', '紧急采购入库并调拨', '1', '10202305221014329108000168', '2024-02-18 15:51:33', '0', '1202', '30000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021888231620', '-1', '30202305221014327189000174', 'HC演示物业2', '紧急采购入库并调拨', '1', '10202305221014329108000168', '2024-02-18 15:51:35', '0', '1202', '30000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024021894501601', '-1', '30202305221014327189000174', 'HC演示物业2', '紧急采购入库并调拨', '1', '10202305221014329108000168', '2024-02-18 15:51:34', '0', '1202', '30000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024022631990800', '-1', '30202305221014327189000174', 'HC演示物业2', '退还', '1', '10202305221014329108000168', '2024-02-26 12:43:54', '0', '1205', '20000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024022744790158', '-1', '30202305221014327189000174', 'HC演示物业2', '测试数据', '2.0', '10202305221014329108000168', '2024-02-27 08:29:38', '0', '1200', '10000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024022746740407', '-1', '30202305221014327189000174', 'HC演示物业2', '洒洒水', '1', '10202305221014329108000168', '2024-02-27 09:34:18', '0', '1205', '20000', '2023052267100146');
INSERT INTO `allocation_storehouse_apply` VALUES ('292024022794540353', '-1', '30202305221014327189000174', 'HC演示物业2', '333', '2', '10202305221014329108000168', '2024-02-27 09:32:14', '0', '1205', '20000', '2023052267100146');

-- ----------------------------
-- Table structure for allocation_user_storehouse
-- ----------------------------
DROP TABLE IF EXISTS `allocation_user_storehouse`;
CREATE TABLE `allocation_user_storehouse` (
  `aus_id` varchar(30) NOT NULL COMMENT '转增ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `res_id` varchar(30) NOT NULL COMMENT '资源ID',
  `res_name` varchar(100) NOT NULL COMMENT '物品名称',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `stock` varchar(100) NOT NULL COMMENT '现有库存数',
  `give_quantity` varchar(100) NOT NULL COMMENT '转赠数量',
  `start_user_id` varchar(30) NOT NULL COMMENT '申请人userId',
  `start_user_name` varchar(64) NOT NULL COMMENT '申请人用户名',
  `accept_user_id` varchar(30) NOT NULL COMMENT '接受人userId',
  `accept_user_name` varchar(64) NOT NULL COMMENT '接受人用户名',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  `remark` varchar(512) DEFAULT NULL COMMENT '转增说明'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of allocation_user_storehouse
-- ----------------------------
INSERT INTO `allocation_user_storehouse` VALUES ('292022081878860001', '-1', '852022081874600031', '打印机', '102022081507340423', '1', '1', '302022081574590429', 'wuxw', '302022081815350036', 'money', '2022-08-18 13:27:33', '0', '23');
INSERT INTO `allocation_user_storehouse` VALUES ('292022081882960015', '-1', '852022081874600031', '打印机', '102022081507340423', '2', '1', '302022081574590429', 'wuxw', '302022081815350036', 'money', '2022-08-18 13:39:29', '0', '1');
INSERT INTO `allocation_user_storehouse` VALUES ('292024021972712395', '-1', '112023083109720019', 'mac', '10202305221014329108000168', '9', '1', '30202305221014327189000174', 'HC演示物业2', '302024021861111923', 'aaaaa', '2024-02-19 04:12:15', '0', '1');
INSERT INTO `allocation_user_storehouse` VALUES ('292024021989462423', '-1', '112023083109720019', 'mac', '10202305221014329108000168', '8', '8', '30202305221014327189000174', 'HC演示物业2', '302023071089700002', 'ddysdd', '2024-02-19 04:33:28', '0', '1');
INSERT INTO `allocation_user_storehouse` VALUES ('292024021933842428', '-1', '112023083044990008', '钢笔', '10202305221014329108000168', '13', '1', '30202305221014327189000174', 'HC演示物业2', '302023071089700002', 'ddysdd', '2024-02-19 04:33:29', '0', '1');

-- ----------------------------
-- Table structure for application_key
-- ----------------------------
DROP TABLE IF EXISTS `application_key`;
CREATE TABLE `application_key` (
  `application_key_id` varchar(30) NOT NULL COMMENT '申请ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `type_cd` varchar(12) NOT NULL COMMENT '类型，10001 保洁 10002 保安 10003 其他人员，详情查看t_dict表',
  `name` varchar(64) NOT NULL COMMENT '申请人名称',
  `tel` varchar(12) NOT NULL COMMENT '申请人手机号码',
  `sex` varchar(2) NOT NULL COMMENT '申请人男女 0男 1女',
  `age` int NOT NULL COMMENT '申请人年龄',
  `id_card` varchar(20) NOT NULL COMMENT '申请人身份证号',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `state` varchar(8) NOT NULL COMMENT '状态，10002 未审核,10001 完成审核 10003 审核拒绝',
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '开始时间',
  `end_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `type_flag` varchar(12) NOT NULL COMMENT '人脸申请1100101 固定密码申请 1100102 临时密码 1100103',
  `pwd` varchar(12) NOT NULL COMMENT '密码',
  UNIQUE KEY `application_key_id` (`application_key_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of application_key
-- ----------------------------

-- ----------------------------
-- Table structure for apply_room_discount
-- ----------------------------
DROP TABLE IF EXISTS `apply_room_discount`;
CREATE TABLE `apply_room_discount` (
  `ard_id` varchar(30) NOT NULL COMMENT '主键ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `room_id` varchar(30) NOT NULL COMMENT '房屋id',
  `room_name` varchar(64) NOT NULL COMMENT '房屋名称',
  `discount_id` varchar(30) DEFAULT NULL COMMENT '折扣id',
  `apply_type` varchar(30) NOT NULL COMMENT '申请类型',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_user_name` varchar(64) NOT NULL COMMENT '创建人',
  `create_user_tel` varchar(11) NOT NULL COMMENT '创建手机号',
  `check_user_id` varchar(30) DEFAULT NULL COMMENT '验房人',
  `review_user_id` varchar(30) DEFAULT NULL COMMENT '通过人',
  `state` varchar(12) NOT NULL DEFAULT '0' COMMENT '审核状态: 1申请验房2验房通过3验房不通过 4审批通过5审批不通过',
  `create_remark` varchar(512) DEFAULT NULL COMMENT '申请信息',
  `check_remark` varchar(512) DEFAULT NULL COMMENT '验房备注信息',
  `review_remark` varchar(512) DEFAULT NULL COMMENT '通过备注信息',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态0正常1失效',
  `in_use` varchar(2) NOT NULL COMMENT '是否可用 0表示可用；1表示不可用',
  `b_id` varchar(30) DEFAULT NULL COMMENT '业务Id',
  `fee_id` varchar(30) DEFAULT NULL,
  `return_way` varchar(4) DEFAULT NULL COMMENT '返还方式1001折扣1002账户余额',
  `return_amount` varchar(255) DEFAULT NULL COMMENT '返还金额',
  PRIMARY KEY (`ard_id`),
  KEY `community_id` (`community_id`) USING BTREE,
  KEY `room_id` (`room_id`) USING BTREE,
  KEY `state` (`state`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of apply_room_discount
-- ----------------------------
INSERT INTO `apply_room_discount` VALUES ('142020122252320001', '7020181217000001', '752020082615958134', '88-1-202', null, '3333', '2020-12-01 00:00:53', '2021-01-01 00:00:53', 'lbwnb', '15332877834', null, null, '1', '没住着', null, null, '2020-12-22 23:50:26', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142020122380540006', '7020181217000001', '752020082615958134', '88-1-202', '132021030499380001', '152020122379340001', '2020-12-01 01:00:36', '2020-02-01 01:00:36', 'lbwnb', '15332877834', '30518940136629616640', '30518940136629616640', '4', '没住着', '1', 'tg', '2020-12-23 01:11:38', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142020122435420252', '2020121177440140', '752020121123140101', '1-1-1021', null, '152020122493070251', '2020-12-24 00:00:20', '2020-12-31 00:00:20', '张三4', '18999999994', null, null, '1', '1111111111111111111', null, null, '2020-12-24 10:33:54', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142020122893120390', '2020122877240881', '752020122839010900', '1-1-110', null, '152020122804290389', '2020-12-01 11:55:06', '2020-12-09 12:35:06', '杨大站', '15907078222', null, null, '1', '5656+', null, null, '2020-12-28 12:07:51', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142020123077190091', '2020122471920846', '752020123037230597', '1111-2222-1605', null, '152020123050900090', '2020-12-08 05:25:31', '2020-12-08 05:25:31', '刘文军', '15838995173', null, null, '1', '111', null, null, '2020-12-30 16:33:31', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021011905340154', '2020121792640104', '752020122766840715', '00001-6-501', '132021011878920070', '152021011780040036', '2021-01-19 00:00:38', '2021-01-19 23:00:38', 'wxw', '13454543434', '30518940136629616640', '30518940136629616640', '4', '1111', '1111', '11111', '2021-01-19 17:00:57', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021012218740662', '7020181217000001', '752020091237800114', '1-1-1021', '132021030499380001', '152020122370460003', '2021-01-27 00:00:00', '2021-04-01 00:00:00', 'test001', '18909711443', '30518940136629616640', '30518940136629616640', '4', '空置房申请', '1', '烦烦烦', '2021-01-22 15:52:38', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021012631620895', '2021012222523156', '752021012250133223', '88-3-802', '132021012699780896', '152021012261070677', '2021-01-26 11:25:14', '2021-01-27 11:25:14', '张三水', '15835356767', '302021012190350087', '302021012190350087', '4', '优秀人才福利', '验房没问题', '同意', '2021-01-26 11:31:22', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021012699500899', '2021012222523156', '752021012212443221', '88-3-901', '132021012699780896', '152021012261070677', '2021-01-26 11:35:48', '2021-01-27 11:35:48', '李敬臣', '15834562345', '302021012190350087', '302021012190350087', '4', '优秀人才福利', '验房没问题', '同意', '2021-01-26 11:37:43', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021012805940942', '2021012115732778', '752021012260620213', '11-1-111401', '132021012844000943', '152021012886100941', '2020-01-01 00:00:16', '2022-01-01 00:00:16', '张三18', '18999999994', '302021012191590092', '302021012191590092', '4', 'aaaa', 'aaaaa', 'aaaaa', '2021-01-28 16:53:00', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021012854070946', '2021012115732778', '752021012260620213', '11-1-111401', '132021012844000943', '152021012886100941', '2022-01-02 00:00:00', '2023-01-02 00:00:00', '张三18', '18999999994', '302021012191590092', '302021012191590092', '4', '空置房申请', 'aaaa', 'aaaa', '2021-01-28 17:24:51', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021012883320940', '2020121530990123', '752021012579820037', '15-2-PA001', null, '152021012897040939', '2021-01-28 16:45:54', '2021-04-28 16:45:54', '杨测试', '18824674978', '30518940136629616640', null, '2', '水电费', 'aaa', null, '2021-01-28 16:48:13', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021020282320032', '2021012115732778', '752021012259750195', '1-1-11101', null, '152021012886100941', '2021-02-01 00:00:26', '2021-03-01 00:00:26', '陈美宝', '18999999999', null, null, '1', 'aaaa', null, null, '2021-02-02 00:16:04', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021020290890035', '7020181217000001', '752020091237800114', '1-1-1021', '132021020974380577', '152020122379340001', '2029-02-02 00:00:00', '2029-02-05 00:00:00', 'test001', '18909711443', '30518940136629616640', '30518940136629616640', '4', '空置房申请', '1', '1', '2021-02-02 12:37:55', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021020683590005', '2020121530990123', '752021012579820037', '15-2-PA001', null, '152021012897040939', '2025-01-28 09:35:11', '2029-08-24 11:55:11', '杨测试', '18824674978', '30518940136629616640', null, '2', 'test', '1', null, '2021-02-06 18:02:13', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021020691880004', '2020121530990123', '752021012579820037', '15-2-PA001', null, '152021012897040939', '2021-05-06 06:30:56', '2021-09-24 17:50:11', '杨测试', '18824674978', '30518940136629616640', null, '2', 'TEST', 'TEST', null, '2021-02-06 18:00:08', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021020945540573', '7020181217000001', '752020091278580065', '11-1-0903', '132021020969820574', '152020122370460003', '2021-02-09 15:20:22', '2021-02-26 15:20:22', '孙开心', '13987654321', '30518940136629616640', '30518940136629616640', '4', '123', '123', '123', '2021-02-09 15:23:43', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021022012090038', '2021012122242316', '752021022090100226', '1-1-11', '132021020927210570', '152021022061670037', '2021-02-20 17:15:52', '2021-03-31 23:55:52', '王二', '18149530235', '30518940136629616640', '30518940136629616640', '4', '测试测试', '验房通过', '审核通过', '2021-02-20 17:20:27', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021022074770047', '7020181217000001', '752020091237800114', '1-1-1021', null, '152020122379340001', '2033-03-20 00:00:00', '2038-05-21 00:00:00', 'test001', '18909711443', null, null, '1', '空置房申请', null, null, '2021-02-20 18:07:57', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030126930004', '7020181217000001', '752020120955470296', '1-1-10', '132021020974380577', '152020122379340001', '2021-03-01 00:00:43', '2021-07-31 23:35:43', '京东母婴', '18722081900', '30518940136629616640', '30518940136629616640', '4', '123', '123', '123', '2021-03-01 10:37:52', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030478690122', '2021030221420610', '752021030414040580', '1-1-1001', null, '152021030477230121', '2021-01-01 00:00:11', '2022-12-01 00:00:11', '测试', '15500000006', null, null, '1', '房屋未入住申请打折', null, null, '2021-03-04 16:38:54', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030503830053', '2021030162070337', '752021030317660701', '1-1-1011', '132021030597430050', '152021030580290045', '2020-12-31 00:00:27', '2022-01-02 00:00:27', '31yezhu', '18909715555', '302021030108720020', '302021030108720020', '4', '申请空置房', '情况属实', '通过', '2021-03-05 18:40:13', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030526630003', '7020181217000001', '752020101795600338', '1-1-1011', '132021020969820574', '152020122311690002', '2021-01-01 00:00:15', '2021-02-28 23:55:15', '林先生', '18999999999', '30518940136629616640', '30518940136629616640', '4', '1', '同意', '1', '2021-03-05 19:04:56', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030529100049', '2021030162070337', '752021030317660701', '1-1-1011', '132021030545170046', '152021030580290045', '2021-03-01 00:00:31', '2022-03-01 00:00:31', '31yezhu', '18909715555', '302021030108720020', '302021030108720020', '4', '空置房测试', '情况属实', '情况属实', '2021-03-05 18:15:59', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030592130057', '2021012653560025', '752021030579880222', '1-1-1011', null, '152021030516800011', '2021-01-01 00:00:29', '2021-02-28 23:55:29', '吴学文', '18999999999', null, null, '1', '1', null, null, '2021-03-05 18:54:31', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030813930038', '7020181217000001', '752020120908950287', '1-1-1', '132021020969820574', '152020122379340001', '2021-01-01 00:00:02', '2021-04-01 01:00:02', '腾达窗帘', '13687094569', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-08 17:05:17', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030817310031', '7020181217000001', '752020120908950287', '1-1-1', '132021020969820574', '152020122379340001', '2021-02-01 00:00:03', '2021-03-31 23:55:03', '腾达窗帘', '13687094569', '30518940136629616640', '30518940136629616640', '4', '11', '1', '1', '2021-03-08 16:41:23', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030824000030', '2021012714410004', '752021030864990103', '1-1-601', '132021030884240012', '152021030823410020', '2021-08-31 00:00:19', '2021-10-01 00:00:19', 'lrx', '15111111111', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-08 16:31:09', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030827330021', '2021012714410004', '752021030864990103', '1-1-601', '132021030884240012', '152021030823410020', '2020-02-01 00:00:59', '2021-07-01 00:00:59', 'lrx', '15111111111', '30518940136629616640', '30518940136629616640', '4', '没人', '1', '1', '2021-03-08 15:29:33', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030828310032', '7020181217000001', '752020120908950287', '1-1-1', '132021020969820574', '152020122379340001', '2021-01-31 23:55:30', '2021-03-31 23:55:30', '腾达窗帘', '13687094569', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-08 16:43:07', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030832000024', '2021012714410004', '752021030864990103', '1-1-601', '132021030884240012', '152021030823410020', '2020-10-01 00:00:51', '2020-12-01 00:00:51', 'lrx', '15111111111', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-08 16:13:31', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030871190034', '7020181217000001', '752020120908950287', '1-1-1', '132021020969820574', '152020122379340001', '2021-01-01 00:00:43', '2021-12-02 00:00:43', '腾达窗帘', '13687094569', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-08 16:59:13', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030879440015', '7020181217000001', '752020120807580152', '01-01-01', '132021020974380577', '152020122379340001', '2021-03-01 11:00:46', '2021-03-17 11:25:46', 'chen', '18811120172', '30518940136629616640', '30518940136629616640', '4', '等待', 'ii', '；；', '2021-03-08 11:02:22', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030881600022', '7020181217000001', '752020120908950287', '1-1-1', '132021020969820574', '152020122379340001', '2021-03-08 00:00:47', '2021-03-31 23:55:47', '腾达窗帘', '13687094569', '30518940136629616640', '30518940136629616640', '4', 'SDDD', 'dddd', 'ddd', '2021-03-08 15:34:16', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030889010033', '7020181217000001', '752020120908950287', '1-1-1', '132021020969820574', '152020122379340001', '2020-12-31 00:00:41', '2022-01-01 00:00:41', '腾达窗帘', '13687094569', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-08 16:53:23', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021030910350048', '7020181217000001', '752020120955470296', '1-1-10', '132021020969820574', '152020122379340001', '2021-03-01 00:00:34', '2021-05-01 00:00:34', '京东母婴', '18722081900', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-09 16:49:58', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031004710063', '7020181217000001', '752020091237800114', '1-1-1021', '132021020974380577', '152020122379340001', '2045-07-12 11:20:42', '2065-07-08 11:20:42', 'test001', '18909711443', '30518940136629616640', '30518940136629616640', '5', '生气', '不生气', '32', '2021-03-10 11:24:34', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031030280083', '2021012739890133', '752021031036270178', '1-1-101', '132021031079210077', '152021031043410080', '2020-12-31 23:55:59', '2021-02-01 01:00:59', '测试', '15111111111', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-10 19:16:45', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031083560068', '7020181217000001', '752020120908950287', '1-1-1', '132021031049450065', '152020122379340001', '2022-03-17 16:40:17', '2022-07-06 16:40:17', '腾达窗帘', '13687094569', '30518940136629616640', '30518940136629616640', '4', 'okoko', '没问题', '大师的撒', '2021-03-10 16:45:30', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031085150081', '2021012739890133', '752021031036270178', '1-1-101', '132021031079210077', '152021031043410080', '2021-01-01 00:00:45', '2021-02-01 01:00:45', '测试', '15111111111', '30518940136629616640', '30518940136629616640', '4', '1', '1', '1', '2021-03-10 19:07:36', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031086480062', '7020181217000001', '752020120955470296', '1-1-10', '132021031001730059', '152020122379340001', '2021-06-18 15:05:40', '2021-10-07 11:05:40', 'xueyu', '18722081900', '30518940136629616640', '30518940136629616640', '4', '通过一下', '没问题', '审批通过', '2021-03-10 11:09:42', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031093480064', '7020181217000001', '752020120955470296', '1-1-10', '132021031049450065', '152020122379340001', '2024-03-06 13:45:25', '2026-03-12 13:45:25', '京东母婴', '18722081900', '30518940136629616640', '30518940136629616640', '4', '申请1', 'okook', '2222', '2021-03-10 13:48:48', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031186700084', '2021012739890133', '752021030894870218', '1002-12-1', null, '152021031043410080', '2021-03-01 00:00:45', '2021-04-01 01:00:45', '1323', '13899999999', null, null, '1', '1', null, null, '2021-03-11 10:09:00', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031213262251', '7020181217000001', '752021031242320069', '39-1-101', '132021031049450065', '152020122379340001', '2021-03-01 00:00:14', '2021-03-31 23:55:14', 'TATEST', '15666666666', '30518940136629616640', '30518940136629616640', '4', 'sssss', 'ddddd', 'dddd', '2021-03-12 15:51:34', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031634000147', '2021031132160233', '752021031559790153', '1-1-1011', '132021031611360074', '152021031674690073', '2021-12-31 00:00:05', '2022-01-02 00:00:05', '吴学文', '18999999999', '302021031232220041', '302021031232220041', '4', '情况属实', '情况属实', '舒适', '2021-03-16 14:31:34', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031666550078', '2021031132160233', '752021031546780155', '1-1-1013', '132021031611360074', '152021031674690073', '2021-03-01 00:00:46', '2021-12-01 00:00:46', '张三2', '18999999992', '302021031232220041', '302021031232220041', '4', '空置房', '情况属实', '情况属实', '2021-03-16 14:15:14', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021031761240310', '2020121527920100', '752021020102120058', '1-1-1011', null, '152020122474120263', '2021-01-01 00:00:04', '2021-03-01 00:00:04', '吴学文', '18999999999', '30518940136629616640', null, '3', '你好', '没问题', null, '2021-03-17 13:52:29', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021032076070495', '2020121527920100', '752021020102120058', '1-1-1011', null, '152020122474120263', '2021-03-01 00:00:28', '2021-03-31 23:55:28', '吴学文', '18999999999', null, null, '1', '1', null, null, '2021-03-20 18:43:49', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021040232140005', '2021031851920041', '752021040299450047', '1-1-101', null, '152021033186740120', '2021-04-24 00:00:00', '2021-04-28 00:00:00', 'fddfb', '15678976543', '30518940136629616640', null, '2', '饿饿饿', '通过', null, '2021-04-02 13:25:52', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021041507690587', '2021031851920041', '752021040299450047', '1-1-101	', '132021041545360613', '152021033186740120', '2021-05-01 01:00:08', '2026-01-01 00:00:08', 'fddfb', '15678976543', '30518940136629616640', '30518940136629616640', '4', '123', '测试', '审批通过', '2021-04-15 10:12:20', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021041508700621', '2021031851920041', '752021040299450047', '1-1-101', '132021041545360613', '152021041554000620', '2021-06-01 00:00:00', '2021-06-30 00:00:00', 'fddfb', '15678976543', '30518940136629616640', '30518940136629616640', '4', '1-1-101', '123', '通过', '2021-04-15 16:37:58', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021051264995717', '7020181217000001', '752020091278580065', '11-1-0903', '132021031049450065', '152020122370460003', '2021-05-05 00:00:00', '2021-05-13 00:00:00', '萨阿丹是', '18878415521', '30518940136629616640', '30518940136629616640', '4', '撒旦水水', '通过', '通过', '2021-05-12 17:14:12', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021051726770502', '7020181217000001', '752020091278580065', '11-1-0903', '132021030499380001', '152020122311690002', '2021-05-18 07:00:29', '2021-05-30 12:55:29', 'aa', '18049530235', '30518940136629616640', '30518940136629616640', '4', 'ssssss', 'ddd', 'ddsd', '2021-05-17 17:01:30', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021052444151186', '7020181217000001', '752020120801510026', '09-1-1', null, '152020122379340001', '2021-05-25 05:45:41', '2021-06-06 08:55:41', 'test', '13712345678', '30518940136629616640', null, '2', '00', '1', null, '2021-05-24 16:48:24', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021052453471181', '7020181217000001', '752020120294990250', '09-1-202020', null, '152020122370460003', '2021-05-25 05:40:54', '2021-05-30 04:55:54', '蔡万成', '18911544225', '30518940136629616640', null, '3', '111', 'ww', null, '2021-05-24 16:42:10', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021052532921211', '7020181217000001', '752020101795600338', '1-1-1011', '132021052468181182', '152020122379340001', '2021-05-20 02:30:12', '2021-05-29 06:55:12', '林先生', '18999999999', '30518940136629616640', '30518940136629616640', '4', '111222', '1', '通过', '2021-05-25 11:35:28', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021052745501102', '7020181217000001', '752021032424650030', '1-1-102', '132021052468181182', '152020122370460003', '2021-05-28 13:00:00', '2021-05-31 13:00:00', '南', '18999999991', '30518940136629616640', '30518940136629616640', '4', '申请', '通过', '10', '2021-05-27 14:49:15', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021052813301127', '7020181217000001', '752021032424650030', '1-1-102', null, '152021052874481124', '2021-08-05 00:00:00', '2021-12-31 00:00:00', '南', '18999999991', '30518940136629616640', null, '2', '11', '哈哈哈', null, '2021-05-28 13:41:35', '1', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021060152363487', '7020181217000001', '752020101795600338', '1-1-1011', '132021052468181182', '152020122370460003', '2021-06-01 00:00:00', '2021-07-01 00:00:00', '林先生', '18999999999', '30518940136629616640', '30518940136629616640', '4', 'ceshi', '通过', 'OK', '2021-06-01 19:31:08', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021070197950924', '7020181217000001', '752021032424650030', '1-1-102', '132021031049450065', '152021052874481124', '2021-08-01 00:00:02', '2021-08-31 23:55:02', '南', '18999999991', '30518940136629616640', '30518940136629616640', '4', '1', 'dddd', '淡淡炒', '2021-07-01 16:54:13', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021070537130994', '2021051447480021', '752021060149790768', '1-1-101', null, '152021070526510993', '2021-07-05 00:00:43', '2022-03-01 00:30:43', '范先生', '13333333333', null, null, '1', '····', null, null, '2021-07-05 20:32:47', '0', '', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021081148000022', '2021080494780158', '752021080499320033', '1-1-1023', '132021080518390002', '152021081187000021', '2021-08-11 00:00:00', '2021-08-13 23:59:59', 'test001', '18909710004', '302021080447630001', '302021080447630001', '4', '大撒大撒', '萨达撒', '123', '2021-08-11 14:37:26', '0', '0', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021082770100229', '2021080494780158', '752021080443110032', '22栋-一-1022', '132021080518390002', '152021081187000021', '2021-08-27 00:00:00', '2023-11-30 23:59:59', 'test001', '18909710004', '302021080447630001', '302021080447630001', '4', '空置房申请', '可以', '从', '2021-08-27 14:59:54', '0', '0', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021090776340052', '2021082665540071', '752021082769030023', '1-1-1', null, '152021082749130024', '2021-09-01 00:00:00', '2021-09-30 23:59:59', '李四', '13213075980', null, null, '1', '太穷，求减免', null, null, '2021-09-07 15:07:43', '0', '0', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021092356110513', '2021080494780158', '752021090641280039', '0235-1-101', null, '152021090196640032', '2021-09-23 00:00:00', '2021-09-30 23:59:59', '张三', '13111111111', '302021080447630001', null, '2', 'test', '1', null, '2021-09-23 16:05:22', '0', '0', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021101361840028', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021090196640032', '2021-10-15 00:00:00', '2021-10-17 23:59:59', 'test001', '18909710004', null, null, '1', '空置房申请', null, null, '2021-10-13 16:02:00', '0', '0', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021101574870027', '2021100580500107', '752021100834150049', '1-1-0102', '132021101598650006', '152021101546850009', '2022-01-01 00:00:00', '2022-12-31 23:59:59', '张三', '13111111111', '302021100511531143', '302021100511531143', '4', '空房申请优惠', '通过', '通过', '2021-10-15 20:34:22', '0', '0', null, '902021101030820045', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142021101906220001', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021090196640032', '2022-09-01 00:00:00', '2026-12-23 23:59:59', 'test001', '18909710004', null, null, '1', '空置房申请', null, null, '2021-10-19 11:58:29', '0', '0', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021101922700055', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021090196640032', '2021-10-19 00:00:00', '2021-10-25 23:59:59', 'test001', '18909710004', null, null, '1', '空置房申请', null, null, '2021-10-19 09:27:39', '0', '0', null, null, null, null);
INSERT INTO `apply_room_discount` VALUES ('142021110399190789', '2021081177860471', '752021102932770121', '2-1-151', '132021082463560353', '152021102279530422', '2021-11-01 00:00:00', '2021-11-19 23:59:59', '袁建军', '17601861883', '302021080447630001', '302021080447630001', '4', 'ooo', 'ooo', 'pp', '2021-11-03 20:52:24', '0', '0', null, '902021110303201527', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142021110905660019', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021090196640032', '2021-11-09 00:00:00', '2021-11-13 23:59:59', 'test001', '18909710004', null, null, '1', '申请费用', null, null, '2021-11-09 11:15:37', '0', '0', null, '902021090239080093', null, null);
INSERT INTO `apply_room_discount` VALUES ('142021110907920013', '2021081177860471', '752021102932770121', '2-1-151', '132021082463560353', '152021102279530422', '2021-11-16 00:00:00', '2021-11-19 23:59:59', '袁建军', '17601861883', '302021080447630001', '302021080447630001', '4', '888', '99', '99', '2021-11-09 08:59:31', '0', '0', null, '902021110859570019', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142021110923840006', '2021080494780158', '752021080443110032', '22栋-一-1022', null, '152021082064430001', '2021-11-09 00:00:00', '2022-11-09 23:59:59', 'test001', '18909710004', null, null, '1', '屋', null, null, '2021-11-09 05:20:30', '0', '0', null, '902021092857700446', null, null);
INSERT INTO `apply_room_discount` VALUES ('142021111196750023', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021090196640032', '2021-11-11 00:00:00', '2021-12-11 23:59:59', 'test001', '18909710004', null, null, '1', '家中无人', null, null, '2021-11-11 11:29:55', '0', '0', null, '902021091558120006', null, null);
INSERT INTO `apply_room_discount` VALUES ('142021120385660047', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021082064430001', '2021-12-03 00:00:00', '2021-12-05 23:59:59', 'test001', '18909710004', null, null, '1', '无', null, null, '2021-12-03 21:27:27', '0', '0', null, '902021083105381011', null, null);
INSERT INTO `apply_room_discount` VALUES ('142021120730950054', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021090196640032', '2021-12-07 00:00:00', '2021-12-17 23:59:59', 'test001', '18909710004', null, null, '1', '天后宫唱歌', null, null, '2021-12-07 10:56:47', '0', '0', null, '902021081073820259', null, null);
INSERT INTO `apply_room_discount` VALUES ('142021120733290014', '2021113067120009', '752021113062290038', '1-1-1014', '132021120749120015', '152021120751660013', '2021-01-01 00:00:00', '2021-12-31 23:59:59', '张三3', '18999999993', '302021113055320045', '302021113055320045', '4', '空置', '属实', '同意', '2021-12-07 09:32:26', '0', '0', null, '902021120122530018', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142021120752270032', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021090196640032', '2021-12-07 00:00:00', '2026-09-01 23:59:59', 'test001', '18909710004', null, null, '1', '试试水', null, null, '2021-12-07 10:34:35', '0', '0', null, '902021090239080093', null, null);
INSERT INTO `apply_room_discount` VALUES ('142021120752280083', '2021080494780158', '752021080443110032', '22栋-一-1022', null, '152021090196640032', '2021-12-07 00:00:00', '2021-12-08 23:59:59', 'test001', '18909710004', null, null, '1', 'm', null, null, '2021-12-07 11:32:43', '0', '0', null, '902021093043650676', null, null);
INSERT INTO `apply_room_discount` VALUES ('142021121036260857', '2021080494780158', '752021080443110032', '22栋-一-1022', null, '152021082064430001', '2021-12-10 00:00:00', '2021-12-31 23:59:59', 'test001', '18909710004', null, null, '1', '445', null, null, '2021-12-10 10:55:21', '0', '0', null, '902021093043650676', null, null);
INSERT INTO `apply_room_discount` VALUES ('142021122771760008', '2021082661900033', '752021122406070906', '1-1-1011', '132021122911800032', '152021122735375880', '2021-12-27 00:00:00', '2022-07-28 00:00:00', '吴学文', '18999999999', '302021080447630001', '302021080447630001', '4', '2345', '空置房', 'kkl', '2021-12-27 15:36:21', '0', '0', null, '902021122413966667', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142021122924330035', '2021082661900033', '752021122406070906', '1-1-1011', '132021122911800032', '152021122735375880', '2021-12-28 00:00:00', '2022-06-28 23:59:59', '吴学文', '18999999999', '302021080447630001', '302021080447630001', '4', '1', '1', '1', '2021-12-29 14:44:24', '1', '0', null, '902021122971010107', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142021122998420039', '2021082661900033', '752021122406070906', '1-1-1011', '132021122911800032', '152021122735375880', '2021-12-28 00:00:00', '2022-06-28 23:59:59', '吴学文', '18999999999', '302021080447630001', '302021080447630001', '4', '1', '1', '1', '2021-12-29 14:47:32', '0', '1', null, '902021122460646665', '1002', '1372.11');
INSERT INTO `apply_room_discount` VALUES ('142022010748380440', '2021080494780158', '752021080499320033', '22栋-一-1023', null, '152021090196640032', '2022-01-07 00:00:00', '2022-01-12 23:59:59', 'test001', '18909710004', null, null, '1', 'rrrr', null, null, '2022-01-07 11:00:05', '0', '0', null, '902021091558120006', null, null);
INSERT INTO `apply_room_discount` VALUES ('142022022265550534', '2021082661900033', '752022010996770595', '1-1-1004', null, '152022022060911059', '2022-02-01 00:00:00', '2022-03-31 23:59:59', '张三3', '18999999993', '302021080447630001', null, '2', '123', '123', null, '2022-02-22 14:38:03', '0', '0', null, '902022012912440828', null, null);
INSERT INTO `apply_room_discount` VALUES ('142022022328480044', '2021082661900033', '752022011257381117', '1-1-1011', '132021122911800032', '152021122735375880', '2022-02-23 00:00:00', '2022-03-22 23:59:59', '张正', '15136172116', '302021080447630001', '302021080447630001', '4', '1', '1', '1', '2022-02-23 10:17:02', '0', '1', null, '902022022301810039', '1002', '100.00');
INSERT INTO `apply_room_discount` VALUES ('142022022352290027', '2021082661900033', '752022011257381117', '1-1-1011', null, '152021122735375880', '2022-02-23 00:00:00', '2022-03-26 23:59:59', '张正', '15136172116', '302021080447630001', null, '2', '1', '1', null, '2022-02-23 10:10:24', '1', '0', null, '902022012983340831', null, null);
INSERT INTO `apply_room_discount` VALUES ('142022022396190034', '2021082661900033', '752022011257381117', '1-1-1011', '132021122911800032', '152021122735375880', '2022-02-23 00:00:00', '2022-03-22 23:59:59', '张正', '15136172116', '302021080447630001', '302021080447630001', '4', '1', '1', '1', '2022-02-23 10:13:49', '0', '0', null, '902022022398360029', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142022022802823895', '2021081177860471', '752022022531690643', '1-1-1011', null, '152021102279530422', '2021-01-31 00:00:00', '2022-02-28 23:59:59', '王五', '18999999999', '302021080447630001', null, '2', '1', '1', null, '2022-02-28 08:53:34', '0', '0', null, '902022022692773781', null, null);
INSERT INTO `apply_room_discount` VALUES ('142022022883204086', '2021081177860471', '752022022531690643', '1-1-1011', null, '152021111995230001', '2022-02-28 00:00:00', '2022-07-29 00:00:00', '王五', '18999999999', '302021080447630001', null, '2', '11', '验房通过', null, '2022-02-28 16:33:18', '0', '0', null, '902022022849564006', null, null);
INSERT INTO `apply_room_discount` VALUES ('142022030143714852', '2022022584520644', '752022030114280205', '3-1-123456', null, '152022030116604719', '2022-03-09 18:55:00', '2022-03-02 23:59:59', 'NICHI2', '18815539853', '302021080447630001', null, '3', 'te', '1', null, '2022-03-01 14:21:13', '0', '0', null, '902022030131100316', null, null);
INSERT INTO `apply_room_discount` VALUES ('142022033136030060', '2022022584520644', '752022033061430043', '1-1-1001', null, '152022030116604719', '2020-09-02 00:00:00', '2022-03-31 23:59:59', '段好金', '13763413312', null, null, '1', '空置房申请', null, null, '2022-03-31 13:38:39', '0', '0', null, '902022033013810063', null, null);
INSERT INTO `apply_room_discount` VALUES ('142022071844380172', '2022022584520644', '752022033061430043', '1-1-1001', null, '152022071819250171', '2022-07-17 00:00:00', '2022-07-19 23:59:59', '段好金', '13763413312', '302021080447630001', null, '3', '而非热热', '8888', null, '2022-07-18 14:35:59', '0', '0', null, '902022071887930126', null, null);
INSERT INTO `apply_room_discount` VALUES ('142022071877820169', '2022022584520644', '752022033061430043', '1-1-1001', '132022030185504802', '152022030199044904', '2022-07-10 00:00:00', '2022-07-20 23:59:59', '段好金', '13763413312', '302021080447630001', '302021080447630001', '4', '水电费', '2323', '333', '2022-07-18 14:34:19', '1', '0', null, '902022071804170087', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142022081191080189', '2022080904060004', '752022080900270009', '1-1-1001', '132022081172270196', '152022081106770187', '2022-07-31 00:00:00', '2022-10-03 23:59:59', '张飞', '18909711445', '302022080912070008', '302022080912070008', '4', '123', '水电费', '水电费', '2022-08-11 00:54:55', '0', '1', null, '902022081032060560', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142022101205510096', '2022081539020475', '752022090378570014', 'D-1-1003', '132022101253920087', '152022092024360083', '2021-12-31 00:00:00', '2023-01-02 23:59:59', 'test', '13569665801', '302022081574590429', '302022081574590429', '4', '水电费', '水电费', '水电费', '2022-10-12 16:12:46', '0', '0', null, '902022101247580015', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142023013155470369', '2023013154290059', '752023013149020175', '1-1-1001', '132023013127520357', '152023013169180354', '2023-01-01 00:00:00', '2023-12-31 23:59:59', '李四', '18909723333', '302023013185270087', '302023013185270087', '4', '空置房申请', '确实空值', '同意', '2023-01-31 16:22:56', '1', '1', null, '902023013149750364', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142023020871120063', '2023013154290059', '752023013149020175', '1-1-1001', '132023020885250057', '152023013169180354', '2025-01-01 00:00:00', '2026-01-01 23:59:59', '李四1', '18909723333', '302023013185270087', '302023013185270087', '4', '免单测试', '免单', '统一', '2023-02-08 15:08:22', '1', '0', null, '902023013149750364', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142023030630590014', '2023013154290059', '752023013149020175', '1-1-1001', '132023020885250057', '152023013169180354', '2023-05-01 00:00:00', '2023-12-31 23:59:59', '李四1', '18909723333', '302023013185270087', '302023013185270087', '4', '试试', 'dd', 'ss', '2023-03-06 18:35:45', '0', '0', null, '902023013149750364', '1001', null);
INSERT INTO `apply_room_discount` VALUES ('142024022043244739', '2023052267100146', '752024021954542993', '1-1-2', null, '152024022000404736', '2024-02-19 00:00:00', '2024-02-20 23:59:59', '测试', '18049392222', '30202305221014327189000174', '30202305221014327189000174', '5', '优惠5毛钱', '验房通过，玛卡巴卡', '审批不通过', '2024-02-20 10:46:18', '0', '0', null, '902024022063964705', null, null);

-- ----------------------------
-- Table structure for apply_room_discount_record
-- ----------------------------
DROP TABLE IF EXISTS `apply_room_discount_record`;
CREATE TABLE `apply_room_discount_record` (
  `ardr_id` varchar(30) NOT NULL COMMENT '空置房验房跟踪记录id',
  `ard_id` varchar(30) NOT NULL COMMENT '空置房申请id',
  `b_id` varchar(30) NOT NULL COMMENT '业务id',
  `community_id` varchar(30) NOT NULL COMMENT '小区id',
  `status_cd` varchar(2) NOT NULL COMMENT '数据状态，0, 在用 1失效',
  `create_user_id` varchar(30) NOT NULL COMMENT '创建用户的id',
  `create_user_name` varchar(255) NOT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `is_true` varchar(10) NOT NULL COMMENT '是否违规  true 是   false 否',
  `state` varchar(12) NOT NULL DEFAULT '0' COMMENT '''审核状态: 1申请验房2验房通过3验房不通过 4审批通过5审批不通过''',
  PRIMARY KEY (`ardr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of apply_room_discount_record
-- ----------------------------
INSERT INTO `apply_room_discount_record` VALUES ('352021122824440111', '142021122771760008', '-1', '2021082661900033', '0', '302021080447630001', 'wuxw', '2021-12-28 17:59:32', '123', 'false', '2');
INSERT INTO `apply_room_discount_record` VALUES ('352022021133770055', '142021122998420039', '-1', '2021082661900033', '1', '302021080447630001', 'wuxw', '2022-02-11 14:58:46', '1111', 'false', '4');
INSERT INTO `apply_room_discount_record` VALUES ('352022021200070135', '142021122998420039', '-1', '2021082661900033', '0', '302021080447630001', 'wuxw', '2022-02-12 16:02:30', '该喝喝', 'true', '4');
INSERT INTO `apply_room_discount_record` VALUES ('352022021203780137', '142021122998420039', '-1', '2021082661900033', '0', '302021080447630001', 'wuxw', '2022-02-12 16:06:06', '不可以', 'true', '4');
INSERT INTO `apply_room_discount_record` VALUES ('352022021206370133', '142021122998420039', '-1', '2021082661900033', '0', '302021080447630001', 'wuxw', '2022-02-12 16:00:54', '你你你', 'true', '4');
INSERT INTO `apply_room_discount_record` VALUES ('352022030162740861', '142022030143714852', '-1', '2022022584520644', '0', '302021080447630001', 'wuxw', '2022-03-01 14:22:17', 'q', 'true', '1');
INSERT INTO `apply_room_discount_record` VALUES ('352022030412650015', '142022022883204086', '-1', '2021081177860471', '0', '302021080447630001', 'wuxw', '2022-03-04 14:24:51', '111', 'true', '2');
INSERT INTO `apply_room_discount_record` VALUES ('352022071863510011', '142022071844380172', '-1', '2022022584520644', '0', '302021080447630001', 'wuxw', '2022-07-18 14:36:35', '555', 'true', '3');
INSERT INTO `apply_room_discount_record` VALUES ('352024022005714746', '142024022043244739', '-1', '2023052267100146', '0', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 10:47:33', '这是跟尊记录', 'false', '2');

-- ----------------------------
-- Table structure for apply_room_discount_type
-- ----------------------------
DROP TABLE IF EXISTS `apply_room_discount_type`;
CREATE TABLE `apply_room_discount_type` (
  `apply_type` varchar(30) NOT NULL COMMENT '类型ID',
  `type_name` varchar(64) NOT NULL COMMENT '类型名称',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `type_desc` varchar(512) DEFAULT NULL COMMENT '类型说明',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态0正常1失效',
  PRIMARY KEY (`apply_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of apply_room_discount_type
-- ----------------------------
INSERT INTO `apply_room_discount_type` VALUES ('152020122311690002', '采暖不热', '7020181217000001', '采暖不热优惠', '2020-12-23 00:59:44', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020122312160005', '1', '7020181217000001', '1', '2020-12-23 01:10:32', '1');
INSERT INTO `apply_room_discount_type` VALUES ('152020122328750004', '嘻嘻嘻', '7020181217000001', '嘻嘻嘻', '2020-12-23 01:00:23', '1');
INSERT INTO `apply_room_discount_type` VALUES ('152020122370460003', '房屋质量问题', '7020181217000001', '房屋质量有问题优惠', '2020-12-23 01:00:12', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020122379340001', '空置房', '7020181217000001', '空置房', '2020-12-23 00:58:10', '1');
INSERT INTO `apply_room_discount_type` VALUES ('152020122380370001', '<{=．．．．(嘎~嘎~嘎~)', '2020121177440140', '柔柔弱弱', '2020-12-23 08:06:30', '1');
INSERT INTO `apply_room_discount_type` VALUES ('152020122474120263', '11', '2020121527920100', '222', '2020-12-24 14:52:06', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020122493070251', '111', '2020121177440140', '1111656', '2020-12-24 10:33:19', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020122804290389', '22', '2020122877240881', '', '2020-12-28 12:04:03', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020123050900090', '7折折扣', '2020122471920846', '', '2020-12-30 16:20:03', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020123052510089', '5折折扣', '2020122471920846', '', '2020-12-30 16:19:52', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020123061470092', '1折', '2020122471920846', '打骨折', '2020-12-30 16:43:03', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020123117260011', 'sys', '2020122471920846', 'sy', '2020-12-31 09:54:07', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020123128610038', '543', '2020122471920846', '45354321', '2020-12-31 15:07:47', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152020123137380010', 'sy', '2020122471920846', 'sy', '2020-12-31 09:53:44', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021011780040036', '房屋漏水', '2020121792640104', '', '2021-01-17 16:50:34', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021011949340153', '空置房', '2020121792640104', '', '2021-01-19 17:00:15', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021012249830676', '低保优惠', '2021012222523156', '低保人员实行优惠政策', '2021-01-22 18:53:16', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021012261070677', '减免优惠', '2021012222523156', '优秀家庭进行减免优惠', '2021-01-22 18:53:42', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021012886100941', '物业优惠测试', '2021012115732778', 'aaaa', '2021-01-28 16:49:56', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021012897040939', '空置房', '2020121530990123', '空置房', '2021-01-28 16:47:54', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021022061670037', '测试类型', '2021012122242316', '测试', '2021-02-20 17:18:46', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021030477230121', '未入住打折', '2021030221420610', '未入住打折', '2021-03-04 16:38:07', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021030516800011', '费用优惠申请类型1', '2021012653560025', '', '2021-03-05 13:44:57', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021030580290045', '空置房', '2021030162070337', '', '2021-03-05 18:12:54', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021030823410020', '物业费减免', '2021012714410004', '1', '2021-03-08 15:28:34', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021031043410080', '打折', '2021012739890133', '', '2021-03-10 19:06:36', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021031674690073', '空置房优惠', '2021031132160233', '', '2021-03-16 14:01:31', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021031734720413', '端午节优惠', '2021031730860239', '临近端午', '2021-03-17 16:25:01', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021031737620415', '植树节', '2021031730860239', '植树节优惠', '2021-03-17 16:28:33', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021031782690414', '国庆节优惠', '2021031730860239', '临近国庆', '2021-03-17 16:26:28', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021033186740120', '预交费', '2021031851920041', '预交费3年优惠', '2021-03-31 14:13:15', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021041022260086', '领导特批优惠', '2021040903330084', '领导特批优惠', '2021-04-10 11:27:19', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021041554000620', '付物业费', '2021031851920041', '', '2021-04-15 16:36:45', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021042199490019', '活动打折', '2021042084880069', '活动打折', '2021-04-21 11:04:11', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021043069630083', '满五免一', '2021042996780878', '住满五年免一年费用\n', '2021-04-30 17:01:55', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021051084635035', '优惠1', '2021051033790693', '', '2021-05-10 18:51:25', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021051960630011', '活动', '2021031688280334', 'vv', '2021-05-19 10:55:19', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021052874481124', '11', '7020181217000001', '111', '2021-05-28 13:37:12', '1');
INSERT INTO `apply_room_discount_type` VALUES ('152021070526510993', '物业费年交优惠', '2021051447480021', '', '2021-07-05 20:31:18', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021080334710111', '空置房优惠', '2021051173621015', '', '2021-08-03 16:44:44', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021080929820001', '招商优惠', '2021080562380002', '', '2021-08-09 14:41:14', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021081187000021', '打折', '2021080494780158', '', '2021-08-11 14:36:13', '1');
INSERT INTO `apply_room_discount_type` VALUES ('152021082064430001', '满减', '2021080494780158', '', '2021-08-20 10:11:07', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021082616840029', '水费优惠', '2021081736770075', '优惠1块钱', '2021-08-26 09:37:32', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021082675410077', '测试优惠类型', '2021082481300662', '', '2021-08-26 23:02:03', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021082711970257', '积分抵扣物业费', '2021082665540071', '积分抵扣物业费', '2021-08-27 15:33:43', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021082749130024', '物业费优惠', '2021082665540071', '物业费打八折', '2021-08-27 11:12:09', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021090196640032', '满减', '2021080494780158', '满减', '2021-09-01 10:30:52', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021101546850009', '优惠类型1', '2021100580500107', '', '2021-10-15 12:02:23', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021102279530422', '测试', '2021081177860471', '1111', '2021-10-22 10:36:53', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021110983420014', '优惠类型', '2021081177860471', '优惠类型', '2021-11-09 09:02:05', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021111995230001', '优惠卷', '2021081177860471', '', '2021-11-19 16:15:54', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021112319830151', '类型名称', '2021082568430029', '类型描述', '2021-11-23 16:16:42', '1');
INSERT INTO `apply_room_discount_type` VALUES ('152021112952140970', '123', '2021082568430029', '123333', '2021-11-29 15:59:34', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021120751660013', '空置房优惠', '2021113067120009', '空置房优惠', '2021-12-07 09:31:34', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021122051064001', '打折', '2021121607770147', '5折', '2021-12-20 15:49:27', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152021122735375880', '流氓申请免单', '2021082661900033', '124', '2021-12-27 00:23:09', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022010820062302', 'scssc', '2021082661900033', 'scssssssssssssssssss', '2022-01-08 22:14:25', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022012473271752', '长期不居住', '2021120856720023', '', '2022-01-24 15:28:50', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022020983252226', '物业费打折', '2022020461330699', '物业费打折', '2022-02-09 15:19:56', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022021167950006', '1', '2021082661900033', '1', '2022-02-11 00:41:32', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022022060911059', '222', '2021082661900033', '123', '2022-02-20 10:43:18', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022030116604719', '空置房', '2022022584520644', '111', '2022-03-01 09:55:18', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022030199044904', '12', '2022022584520644', '', '2022-03-01 19:13:45', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022071819250171', '测试优惠类型', '2022022584520644', '额鹅鹅鹅', '2022-07-18 14:35:34', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022081106770187', '空置房', '2022080904060004', '', '2022-08-11 00:53:10', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022092024360083', '疫情', '2022081539020475', '', '2022-09-20 09:43:38', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022120883310473', '1', '2022120695590004', '1', '2022-12-08 22:42:37', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022120887850474', '111', '2022120695590004', '', '2022-12-08 22:42:48', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152022121684784163', '空置房打折', '2022120695590004', '', '2022-12-16 14:48:09', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152023013169180354', '空置房', '2023013154290059', '空置房', '2023-01-31 16:20:42', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152024022000404736', '优惠', '2023052267100146', '优惠啊', '2024-02-20 10:45:22', '0');
INSERT INTO `apply_room_discount_type` VALUES ('152024022097465704', '水费优惠1', '2023052267100146', '水费优惠1', '2024-02-20 14:49:18', '0');

-- ----------------------------
-- Table structure for appraise
-- ----------------------------
DROP TABLE IF EXISTS `appraise`;
CREATE TABLE `appraise` (
  `appraise_id` varchar(30) NOT NULL COMMENT '评价ID',
  `appraise_score` int NOT NULL DEFAULT '0' COMMENT '评价得分',
  `appraise_type` varchar(12) NOT NULL DEFAULT '10000' COMMENT '评价类型，10000 普通类型',
  `context` varchar(500) DEFAULT NULL COMMENT '评论内容',
  `parent_appraise_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '父级评价ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表',
  `appraise_user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `appraise_user_name` varchar(64) NOT NULL COMMENT '用户名称',
  `obj_type` varchar(12) NOT NULL COMMENT '评论对象类型，t_dict表',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID',
  `door_speed_score` int NOT NULL DEFAULT '0' COMMENT '上门速度评分',
  `repairman_service_score` int NOT NULL DEFAULT '0' COMMENT '维修员服务评分',
  KEY `index_a_obj_id` (`obj_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of appraise
-- ----------------------------
INSERT INTO `appraise` VALUES ('802020070832960001', '4', '10000', '不错', '-1', '2020-07-08 15:02:18', '0', '302020060163780031', 'test001', '10001', '822020070575740016', '0', '0');
INSERT INTO `appraise` VALUES ('802020080271320003', '4', '10000', '终于可以了', '-1', '2020-08-02 18:13:56', '0', '302020060163780031', 'test001', '10001', '822020080222190031', '0', '0');
INSERT INTO `appraise` VALUES ('8020201126174613149', '4', '10000', '。。。。', '-1', '2020-11-26 11:26:54', '0', '302020060163780031', 'test001', '10001', '822020112653360125', '0', '0');
INSERT INTO `appraise` VALUES ('802020112684049989', '5', '10000', '很好', '-1', '2020-11-26 16:49:34', '0', '302020060163780031', 'test001', '10001', '8220201126176015111', '0', '0');
INSERT INTO `appraise` VALUES ('802020120134764256', '5', '10000', '用美颜相机', '-1', '2020-12-01 10:52:03', '0', '302020060163780031', 'test001', '10001', '822020120188400069', '0', '0');
INSERT INTO `appraise` VALUES ('80202012020521-26899', '5', '10000', '不错', '-1', '2020-12-02 11:46:46', '0', '302020060163780031', 'test001', '10001', '822020120248500076', '0', '0');
INSERT INTO `appraise` VALUES ('80202012025018-19097', '5', '10000', '可以', '-1', '2020-12-02 14:47:09', '0', '302020060163780031', 'test001', '10001', '822020110566530285', '0', '0');
INSERT INTO `appraise` VALUES ('802020120845341829', '5', '10000', '完美', '-1', '2020-12-08 16:35:32', '0', '302020120859100031', 'test', '10001', '822020120824780033', '0', '0');
INSERT INTO `appraise` VALUES ('8020201218884031759', '5', '10000', '1', '-1', '2020-12-18 17:27:51', '0', '302020060163780031', 'test001', '10001', '822020121865610310', '0', '0');
INSERT INTO `appraise` VALUES ('80202101220551-24880', '5', '10000', '666', '-1', '2021-01-22 12:35:43', '0', '302020060163780031', 'test001', '10001', '822020123002550347', '0', '0');
INSERT INTO `appraise` VALUES ('802021090176134661', '5', '10000', '非常满意哦', '-1', '2021-09-01 10:54:54', '0', '302021082882270695', '小刘', '10001', '822021082881570763', '5', '5');
INSERT INTO `appraise` VALUES ('8020210902605425346', '1', '10000', '不满意', '-1', '2021-09-02 16:42:40', '0', '302021090151340056', '王五', '10001', '822021090244370557', '1', '1');
INSERT INTO `appraise` VALUES ('80202110226278-17388', '5', '10000', '香蕉炖牛奶', '-1', '2021-10-22 14:20:29', '0', '302021101500300003', '李四', '10001', '822021102206700593', '5', '5');
INSERT INTO `appraise` VALUES ('802022012436962424', '5', '10000', '服务挺好的', '-1', '2022-01-24 16:36:34', '0', '302022012406710250', '刘先生', '10001', '822022012489080425', '5', '5');
INSERT INTO `appraise` VALUES ('802023020195010700', '5', '10000', '维修师傅很热情', '-1', '2023-02-01 16:18:48', '0', '302023013174200192', '李四', '10001', '822023020125950634', '5', '5');
INSERT INTO `appraise` VALUES ('802024022751570049', '4', '10000', '不错', '-1', '2024-02-27 17:47:29', '0', '302024020242040322', '张飞3', '10001', '822024022794890018', '4', '4');

-- ----------------------------
-- Table structure for asset
-- ----------------------------
DROP TABLE IF EXISTS `asset`;
CREATE TABLE `asset` (
  `asset_id` varchar(30) NOT NULL COMMENT '资产ID',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `asset_type_id` varchar(30) NOT NULL COMMENT '资产类别ID',
  `asset_name` varchar(200) NOT NULL COMMENT '资产名称',
  `asset_code` varchar(30) DEFAULT NULL COMMENT '资产编码',
  `asset_site` varchar(200) DEFAULT NULL COMMENT '资产位置',
  `asset_summary` varchar(500) DEFAULT NULL COMMENT '资产介绍',
  `contacts` varchar(64) DEFAULT NULL COMMENT '联系人',
  `tel` varchar(11) DEFAULT NULL COMMENT '联系电话',
  `worth_price` decimal(10,2) DEFAULT NULL COMMENT '资产价值',
  `evaluated_price` decimal(10,2) DEFAULT NULL COMMENT '评估价',
  `final_price` decimal(10,2) DEFAULT NULL COMMENT '最终核定价',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  KEY `idx_asset_id` (`asset_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='资产管理';

-- ----------------------------
-- Records of asset
-- ----------------------------
INSERT INTO `asset` VALUES ('1012021041972570001', '402019032924930007', '1022021041958540003', '换电站', 'CDX584646', '西门哪里哪里', '这是换点用的', '', '', '77.00', '77.00', '777.00', '2021-04-19 03:49:56', '1');
INSERT INTO `asset` VALUES ('1012021041969200004', '402019032924930007', '1022021041941690001', '777', '7777', '', '', '', '', '1.00', '1.00', '1.00', '2021-04-19 06:04:25', '1');
INSERT INTO `asset` VALUES ('1012021041947370006', '402019032924930007', '1022021041941690001', '777', '7777', '', '', '', '', '1.00', '1.00', '1.00', '2021-04-19 06:05:44', '1');
INSERT INTO `asset` VALUES ('1012021041956800008', '402019032924930007', '1022021041941690001', '777', '7777', '', '', '', '', '55.00', '55.00', '55.00', '2021-04-19 06:06:02', '0');

-- ----------------------------
-- Table structure for asset_import_log
-- ----------------------------
DROP TABLE IF EXISTS `asset_import_log`;
CREATE TABLE `asset_import_log` (
  `log_id` varchar(30) NOT NULL COMMENT '日志ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `log_type` varchar(128) NOT NULL COMMENT '导入类型 1001 资产导入 2002 缴费历史导入',
  `success_count` bigint NOT NULL COMMENT '成功条数',
  `error_count` bigint NOT NULL COMMENT '失败条数',
  `remark` varchar(512) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '异常时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `state` varchar(12) NOT NULL DEFAULT 'W' COMMENT '状态 W 待处理 D 处理中 C 处理完成',
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of asset_import_log
-- ----------------------------

-- ----------------------------
-- Table structure for asset_import_log_detail
-- ----------------------------
DROP TABLE IF EXISTS `asset_import_log_detail`;
CREATE TABLE `asset_import_log_detail` (
  `detail_id` varchar(30) NOT NULL COMMENT '明细ID',
  `log_id` varchar(30) NOT NULL COMMENT '日志ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `content` longtext NOT NULL COMMENT '导入每行数据内容，一般为JSON',
  `state` varchar(12) NOT NULL COMMENT '状态 C 成功 F失败',
  `message` longtext NOT NULL COMMENT '描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '异常时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  PRIMARY KEY (`detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of asset_import_log_detail
-- ----------------------------

-- ----------------------------
-- Table structure for asset_import_log_type
-- ----------------------------
DROP TABLE IF EXISTS `asset_import_log_type`;
CREATE TABLE `asset_import_log_type` (
  `type_id` varchar(30) NOT NULL COMMENT '类型ID',
  `log_type` varchar(128) NOT NULL COMMENT '导入类型',
  `log_column` varchar(64) NOT NULL COMMENT 'excel字段',
  `log_property` varchar(64) NOT NULL COMMENT 'json属性',
  `remark` varchar(512) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '异常时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of asset_import_log_type
-- ----------------------------
INSERT INTO `asset_import_log_type` VALUES ('1', 'importRoomOwner', '楼号', 'floorNum', null, '2023-06-19 12:53:34', '0');
INSERT INTO `asset_import_log_type` VALUES ('10', 'importRoomOwner', '室内面积', 'roomArea', null, '2023-06-19 12:57:45', '0');
INSERT INTO `asset_import_log_type` VALUES ('11', 'importRoomOwner', '租金', 'roomRent', null, '2023-06-19 12:58:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('12', 'importRoomOwner', '房屋状态', 'roomState', null, '2023-06-19 12:58:20', '0');
INSERT INTO `asset_import_log_type` VALUES ('13', 'importRoomOwner', '业主名称', 'ownerName', null, '2023-06-19 12:58:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('14', 'importRoomOwner', '性别', 'sex', null, '2023-06-19 12:59:05', '0');
INSERT INTO `asset_import_log_type` VALUES ('15', 'importRoomOwner', '手机号', 'tel', null, '2023-06-19 12:59:41', '0');
INSERT INTO `asset_import_log_type` VALUES ('16', 'importRoomOwner', '身份证号', 'idCard', null, '2023-06-19 12:59:58', '0');
INSERT INTO `asset_import_log_type` VALUES ('17', 'importRoomOwner', '业主类型', 'ownerTypeCd', null, '2023-06-19 13:00:19', '0');
INSERT INTO `asset_import_log_type` VALUES ('18', 'importRoomHistoryFeeDetail', '楼栋', 'floorNum', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('19', 'importRoomHistoryFeeDetail', '单元', 'unitNum', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('2', 'importRoomOwner', '单元', 'unitNum', null, '2023-06-19 12:54:45', '0');
INSERT INTO `asset_import_log_type` VALUES ('20', 'importRoomHistoryFeeDetail', '房屋', 'roomNum', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('21', 'importRoomHistoryFeeDetail', '收费项目', 'feeName', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('22', 'importRoomHistoryFeeDetail', '缴费周期', 'cycle', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('23', 'importRoomHistoryFeeDetail', '开始时间', 'startTime', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('24', 'importRoomHistoryFeeDetail', '结束时间', 'endTime', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('25', 'importRoomHistoryFeeDetail', '缴费时间', 'createTime', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('26', 'importRoomHistoryFeeDetail', '缴费金额', 'amount', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('27', 'importRoomHistoryFeeDetail', '备注', 'remark', null, '2023-06-19 16:13:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('28', 'importCarHistoryFeeDetail', '车牌号', 'carNum', null, '2023-06-19 16:14:38', '0');
INSERT INTO `asset_import_log_type` VALUES ('29', 'importCarHistoryFeeDetail', '收费项目', 'feeName', null, '2023-06-19 16:14:38', '0');
INSERT INTO `asset_import_log_type` VALUES ('3', 'importRoomOwner', '房间', 'roomNum', null, '2023-06-19 12:55:03', '0');
INSERT INTO `asset_import_log_type` VALUES ('30', 'importCarHistoryFeeDetail', '缴费周期', 'cycle', null, '2023-06-19 16:14:38', '0');
INSERT INTO `asset_import_log_type` VALUES ('31', 'importCarHistoryFeeDetail', '开始时间', 'startTime', null, '2023-06-19 16:14:38', '0');
INSERT INTO `asset_import_log_type` VALUES ('32', 'importCarHistoryFeeDetail', '结束时间', 'endTime', null, '2023-06-19 16:14:38', '0');
INSERT INTO `asset_import_log_type` VALUES ('33', 'importCarHistoryFeeDetail', '缴费时间', 'createTime', null, '2023-06-19 16:14:38', '0');
INSERT INTO `asset_import_log_type` VALUES ('34', 'importCarHistoryFeeDetail', '缴费金额', 'amount', null, '2023-06-19 16:14:38', '0');
INSERT INTO `asset_import_log_type` VALUES ('35', 'importCarHistoryFeeDetail', '备注', 'remark', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('36', 'importMeterMachine', '名称', 'machineName', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('37', 'importMeterMachine', '表号', 'address', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('38', 'importMeterMachine', '表类型', 'meterType', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('39', 'importMeterMachine', '模式', 'machineModel', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('4', 'importRoomOwner', '楼层', 'layer', null, '2023-06-19 12:55:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('40', 'importMeterMachine', '房屋', 'roomName', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('41', 'importMeterMachine', '费用项', 'feeName', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('42', 'importMeterMachine', '厂家', 'implBean', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('43', 'importMeterMachine', '采集器ID', 'value1', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('44', 'importMeterWaterFee', '楼栋编号', 'floorNum', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('45', 'importMeterWaterFee', '单元编号', 'unitNum', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('46', 'importMeterWaterFee', '房屋编码', 'roomNum', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('47', 'importMeterWaterFee', '上期度数', 'preDegrees', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('48', 'importMeterWaterFee', '上期读表时间', 'preReadingTime', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('49', 'importMeterWaterFee', '本期度数', 'curDegrees', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('5', 'importRoomOwner', '总楼层', 'layerCount', null, '2023-06-19 12:55:54', '0');
INSERT INTO `asset_import_log_type` VALUES ('50', 'importMeterWaterFee', '本期读表时间', 'curReadingTime', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('51', 'importMeterWaterFee', '备注', 'remark', null, '2023-06-19 16:14:39', '0');
INSERT INTO `asset_import_log_type` VALUES ('52', 'importCustomFee', '房号', 'objName', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('53', 'importCustomFee', '类型', 'objType', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('54', 'importCustomFee', '费用项ID', 'configId', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('55', 'importCustomFee', '收费项目', 'configName', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('56', 'importCustomFee', '建账时间', 'createTime', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('57', 'importCustomFee', '计费起始时间', 'startTime', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('58', 'importCustomFee', '计费结束时间', 'endTime', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('59', 'importRoomFee', '房号/车辆', 'payerObjName', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('6', 'importRoomOwner', '是否有电梯', 'lift', null, '2023-06-19 12:56:21', '0');
INSERT INTO `asset_import_log_type` VALUES ('60', 'importRoomFee', '费用名称', 'feeName', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('61', 'importRoomFee', '开始时间', 'startTime', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('62', 'importRoomFee', '结束时间', 'endTime', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('63', 'importRoomFee', '收费金额', 'amount', null, '2023-09-26 14:10:02', '0');
INSERT INTO `asset_import_log_type` VALUES ('7', 'importRoomOwner', '房屋类型', 'roomSubType', null, '2023-06-19 12:56:47', '0');
INSERT INTO `asset_import_log_type` VALUES ('8', 'importRoomOwner', '房屋户型', 'section', null, '2023-06-19 12:57:06', '0');
INSERT INTO `asset_import_log_type` VALUES ('9', 'importRoomOwner', '建筑面积', 'builtUpArea', null, '2023-06-19 12:57:24', '0');

-- ----------------------------
-- Table structure for asset_inventory
-- ----------------------------
DROP TABLE IF EXISTS `asset_inventory`;
CREATE TABLE `asset_inventory` (
  `ai_id` varchar(30) NOT NULL COMMENT '盘点ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `code` varchar(32) DEFAULT NULL COMMENT '盘点编码',
  `name` varchar(64) NOT NULL COMMENT '盘点名称',
  `inv_time` datetime NOT NULL COMMENT '盘点日期',
  `staff_id` varchar(30) NOT NULL COMMENT '盘点人id',
  `staff_name` varchar(64) NOT NULL COMMENT '盘点人',
  `sh_id` varchar(30) NOT NULL COMMENT '仓库ID',
  `sh_name` varchar(128) NOT NULL COMMENT '仓库名称',
  `state` varchar(12) DEFAULT '2000' COMMENT '状态 1000【待申请】、2000【审核中】、3000【审核未通过】、4000【审核通过】',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '有效标识',
  `remark` varchar(512) DEFAULT NULL COMMENT '备注',
  `audit_id` varchar(30) DEFAULT NULL COMMENT '审核人id',
  `audit_name` varchar(64) DEFAULT NULL COMMENT '审核人',
  `audit_tel` varchar(30) DEFAULT NULL COMMENT '审核人电话',
  `opinion` varchar(512) DEFAULT NULL COMMENT '审核意见',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  PRIMARY KEY (`ai_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of asset_inventory
-- ----------------------------
INSERT INTO `asset_inventory` VALUES ('102022111457970002', '2022110264250009', null, '测试盘点', '2022-11-14 01:05:00', '302022081574590429', '吴学文', '102022081835900028', '集团仓库', '4000', '2022-11-14 22:48:24', '0', '水电费', '302022081574590429', 'wuxw', '18909711443', '不错', '2022-11-14 22:48:39');
INSERT INTO `asset_inventory` VALUES ('102022120586460313', '2022120203810096', null, 'f', '2022-12-05 17:45:49', '302022083031660031', 'f', '102022120334840119', '顼龙研发仓库', '4000', '2022-12-05 17:46:26', '0', 'fdg', '302022083031660031', 'wuxw', '18909715555', '12', '2022-12-05 17:48:05');
INSERT INTO `asset_inventory` VALUES ('102022120818710693', '2022120695590004', null, '', '2022-12-08 09:19:30', '302022083031660031', '二ER', '102022120836910689', '小区仓库', '4000', '2022-12-08 09:21:34', '0', 'SSDS', '302022083031660031', 'wuxw', '18909715555', null, '2022-12-08 09:24:05');
INSERT INTO `asset_inventory` VALUES ('102022121004431043', '2022120695590004', null, '520', '2022-12-10 09:45:53', '302022083031660031', '123', '102022120669470457', '1号仓库', '4000', '2022-12-10 09:46:33', '0', '33', '302022083031660031', 'wuxw', '18909715555', null, '2022-12-10 09:47:00');
INSERT INTO `asset_inventory` VALUES ('102022121571730018', '2022120695590004', null, '123', '2022-12-15 02:10:00', '302022083031660031', '123', '102022120836910689', '小区仓库', '1000', '2022-12-15 17:46:15', '0', '123', null, null, null, null, null);
INSERT INTO `asset_inventory` VALUES ('102023082683830040', '2023052267100146', null, '物品盘点', '2023-08-01 00:00:00', '30202305221014327189000174', '张三', '102023082412640003', 'A仓库', '4000', '2023-08-26 15:06:51', '0', '我要盘点', '30202305221014327189000174', 'HC演示物业', '18909711443', null, '2023-08-26 15:06:58');
INSERT INTO `asset_inventory` VALUES ('102024021771541210', '2023052267100146', null, '测试', '2024-02-17 09:45:00', '30202305221014327189000174', '飒飒', '102023083157950002', 'C仓库', '1000', '2024-02-17 18:20:26', '0', '啊啊啊', null, null, null, null, null);

-- ----------------------------
-- Table structure for asset_inventory_detail
-- ----------------------------
DROP TABLE IF EXISTS `asset_inventory_detail`;
CREATE TABLE `asset_inventory_detail` (
  `id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '主键ID',
  `res_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '资源ID',
  `apply_order_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '盘点id',
  `quantity` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '盘点后数量',
  `remark` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '备注',
  `status_cd` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0',
  `rs_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '供应商id',
  `original_stock` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '原有库存',
  `state` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '4488' COMMENT '状态备用',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `times_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '物品timesId',
  KEY `idx_apply_detail_id` (`apply_order_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of asset_inventory_detail
-- ----------------------------
INSERT INTO `asset_inventory_detail` VALUES ('102022111430790003', '852022111240140002', '102022111457970002', '10', '1', '0', '', '10', null, '2022-11-14 22:48:24', null);
INSERT INTO `asset_inventory_detail` VALUES ('102022120588490314', '852022112806610025', '102022120586460313', '1', '10 100 1 ', '1', '', '100', null, '2022-12-05 17:46:26', null);
INSERT INTO `asset_inventory_detail` VALUES ('102022120526850315', '852022112806610025', '102022120586460313', '1', '10 100 1 ', '0', null, '100', null, '2022-12-05 17:47:45', null);
INSERT INTO `asset_inventory_detail` VALUES ('102022120865240694', '852022120715480670', '102022120818710693', '40', 'DFDSSD', '1', '', '50', null, '2022-12-08 09:21:34', null);
INSERT INTO `asset_inventory_detail` VALUES ('102022120876700695', '852022120715480670', '102022120818710693', '40', 'DFDSSD', '0', null, '50', null, '2022-12-08 09:23:31', null);
INSERT INTO `asset_inventory_detail` VALUES ('102022121053591044', '852022120988810965', '102022121004431043', '11', '', '0', '', '99', null, '2022-12-10 09:46:32', null);
INSERT INTO `asset_inventory_detail` VALUES ('102022121003681045', '852022120940950949', '102022121004431043', '11', '', '0', '', '18', null, '2022-12-10 09:46:32', null);
INSERT INTO `asset_inventory_detail` VALUES ('102022121049231046', '852022120951300918', '102022121004431043', '11', '', '0', '', '12', null, '2022-12-10 09:46:33', null);
INSERT INTO `asset_inventory_detail` VALUES ('102022121575830019', '852022120988810965', '102022121571730018', '11', '11', '0', '', '11', null, '2022-12-15 17:46:15', null);
INSERT INTO `asset_inventory_detail` VALUES ('102023082664400041', '852023082533060002', '102023082683830040', '20', '', '0', '', '100.0', null, '2023-08-26 15:06:51', '112023082620470009');
INSERT INTO `asset_inventory_detail` VALUES ('102024021708231211', '112023083044990008', '102024021771541210', '9', '无', '1', '', '10.0', null, '2024-02-17 18:20:26', '112023083005730010');
INSERT INTO `asset_inventory_detail` VALUES ('102024021927382809', '112024021817921650', '102024021771541210', '1', 'wu', '1', '', '1.0', null, '2024-02-19 09:51:13', '112024021812551652');
INSERT INTO `asset_inventory_detail` VALUES ('102024021973412820', '112023083109720019', '102024021771541210', '1', '', '0', '', '6.0', null, '2024-02-19 09:53:23', '112023083135320020');
INSERT INTO `asset_inventory_detail` VALUES ('102024021949192822', '112023083118030017', '102024021771541210', '1', '', '0', '', '38.0', null, '2024-02-19 09:53:23', '112023083114880018');
INSERT INTO `asset_inventory_detail` VALUES ('102024021936672824', '112024021817921650', '102024021771541210', '1', 'wu', '0', null, '1.0', null, '2024-02-19 09:53:23', '112024021812551652');

-- ----------------------------
-- Table structure for asset_type
-- ----------------------------
DROP TABLE IF EXISTS `asset_type`;
CREATE TABLE `asset_type` (
  `asset_type_id` varchar(30) NOT NULL COMMENT '资产类别ID',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `type_name` varchar(200) NOT NULL COMMENT '类别名称',
  `type_desc` varchar(500) DEFAULT NULL COMMENT '类型描述',
  `seq` int NOT NULL COMMENT '顺序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  KEY `idx_asset_type_id` (`asset_type_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='资产 类别属性';

-- ----------------------------
-- Records of asset_type
-- ----------------------------
INSERT INTO `asset_type` VALUES ('1022021041941690001', '402019032924930007', '电表箱', '电力设备', '1', '2021-04-19 02:49:42', '0');
INSERT INTO `asset_type` VALUES ('1022021041921200002', '402019032924930007', '水表1', '水设备', '21', '2021-04-19 02:50:05', '1');
INSERT INTO `asset_type` VALUES ('1022021041958540003', '402019032924930007', '水表箱', '', '2', '2021-04-19 02:52:57', '0');
INSERT INTO `asset_type` VALUES ('1022021041994840003', '402019032924930007', '7777', '77', '777', '2021-04-19 05:50:35', '0');

-- ----------------------------
-- Table structure for asset_worth
-- ----------------------------
DROP TABLE IF EXISTS `asset_worth`;
CREATE TABLE `asset_worth` (
  `asset_worth_id` varchar(30) NOT NULL COMMENT '资产评估ID',
  `asset_id` varchar(30) NOT NULL COMMENT '资产ID',
  `asset_worth_name` varchar(200) DEFAULT NULL COMMENT '资产评估名称',
  `worth_price` decimal(10,2) DEFAULT NULL COMMENT '资产价值',
  `evaluated_price` decimal(10,2) DEFAULT NULL COMMENT '评估价',
  `final_price` decimal(10,2) DEFAULT NULL COMMENT '最终核定价',
  `worth_time` datetime DEFAULT NULL COMMENT '评估时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  KEY `idx_asset_worth_id` (`asset_worth_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='资产评估';

-- ----------------------------
-- Records of asset_worth
-- ----------------------------
INSERT INTO `asset_worth` VALUES ('1032021041900590001', '', '好的好的', '50.00', '6660.00', '50.00', '2021-04-19 05:47:00', '2021-04-19 05:47:05', '0');
INSERT INTO `asset_worth` VALUES ('1032021041901630002', '', '777', '77.00', '77.00', '777.00', '2021-04-19 05:48:04', '2021-04-19 05:48:07', '0');
INSERT INTO `asset_worth` VALUES ('1032021041911180009', '1012021041956800008', null, '1.00', '1.00', '1.00', null, '2021-04-19 06:06:02', '0');
INSERT INTO `asset_worth` VALUES ('1032021041984800001', '1012021041956800008', '8974561', '55.00', '55.00', '55.00', '2021-04-19 06:18:25', '2021-04-19 06:18:29', '0');

-- ----------------------------
-- Table structure for attendance_classes
-- ----------------------------
DROP TABLE IF EXISTS `attendance_classes`;
CREATE TABLE `attendance_classes` (
  `classes_id` varchar(30) NOT NULL COMMENT '班次ID',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `classes_name` varchar(100) NOT NULL COMMENT '班级名称',
  `time_offset` int NOT NULL COMMENT '允许打卡范围，单位为分钟',
  `clock_count` int NOT NULL DEFAULT '2' COMMENT '打卡次数 默认为 2 次 4 次 6次',
  `clock_type` varchar(12) NOT NULL DEFAULT '1001' COMMENT '打卡类型，1001 每天打卡 1002 隔天打卡 1003 自定义',
  `clock_type_value` varchar(12) NOT NULL COMMENT '打卡规则，* 每天打卡 ? 隔天打卡 0-6组成逗号分隔 自定义',
  `late_offset` int NOT NULL DEFAULT '60' COMMENT '迟到时间范围，超过改时间即为旷工',
  `leave_offset` int NOT NULL DEFAULT '60' COMMENT '早退时间范围，超过改时间即为旷工',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `max_last_offset` int NOT NULL DEFAULT '180' COMMENT '当天下班正常考勤范围，超过改时间即为旷工',
  PRIMARY KEY (`classes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of attendance_classes
-- ----------------------------
INSERT INTO `attendance_classes` VALUES ('102023022206160030', '102023013170370081', '-1', '考勤班组B', '60', '2', '1001', '*', '30', '30', '2023-02-22 00:23:14', '0', '180');
INSERT INTO `attendance_classes` VALUES ('102023022264870002', '102023013170370081', '-1', 'A班考勤', '30', '2', '1001', '*', '15', '30', '2023-02-22 00:22:17', '1', '180');
INSERT INTO `attendance_classes` VALUES ('102023022613720003', '102023013170370081', '-1', 'xx1', '60', '2', '1001', '*', '60', '60', '2023-02-26 01:30:09', '1', '481');
INSERT INTO `attendance_classes` VALUES ('102024012453700053', '102024012228150026', '-1', '1', '30', '2', '1001', '*', '15', '15', '2024-01-24 12:44:21', '0', '480');
INSERT INTO `attendance_classes` VALUES ('102024022674610540', '10202305221014329108000168', '-1', '晚班', '30', '2', '1001', '*', '20', '20', '2024-02-26 10:18:56', '0', '10');
INSERT INTO `attendance_classes` VALUES ('102024022690370514', '10202305221014329108000168', '-1', '巡检早班', '0', '2', '1001', '*', '10', '10', '2024-02-26 10:17:02', '0', '10');

-- ----------------------------
-- Table structure for attendance_classes_attr
-- ----------------------------
DROP TABLE IF EXISTS `attendance_classes_attr`;
CREATE TABLE `attendance_classes_attr` (
  `attr_id` varchar(64) NOT NULL COMMENT '班次属性',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `classes_id` varchar(64) NOT NULL COMMENT '班次ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '班次规格ID',
  `value` varchar(100) NOT NULL COMMENT '班次值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`attr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of attendance_classes_attr
-- ----------------------------
INSERT INTO `attendance_classes_attr` VALUES ('102022072927490004', '402021080402040153', '-1', '', '20000', '08:30', '2022-07-29 13:34:51', '0');
INSERT INTO `attendance_classes_attr` VALUES ('102022072990620003', '402021080402040153', '-1', '', '10000', '08:00', '2022-07-29 13:34:51', '0');
INSERT INTO `attendance_classes_attr` VALUES ('102022081223490007', '102022080999350002', '-1', '102022081213270006', '10000', '01:00', '2022-08-12 23:03:14', '0');
INSERT INTO `attendance_classes_attr` VALUES ('102022081277780009', '102022080999350002', '-1', '102022081213270006', '20000', '10:05', '2022-08-12 23:03:14', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012302590209', '402019032924930007', '202021012359555041', '162021012315620004', '20000', '18:00', '2021-01-23 16:02:25', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012305150207', '402019032924930007', '202021012359555041', '162021012315620004', '11000', '12:00', '2021-01-23 16:02:25', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012308530198', '402019032924930007', '202021012317015038', '162021012315620004', '11000', '12:00', '2021-01-23 16:02:05', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012323260208', '402019032924930007', '202021012359555041', '162021012315620004', '21000', '14:30', '2021-01-23 16:02:25', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012329020171', '402019032924930007', '202021012348595032', '162021012315620004', '21000', '14:30', '2021-01-23 15:17:56', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012330740169', '402019032924930007', '202021012348595032', '162021012315620004', '10000', '08:35', '2021-01-23 15:17:56', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012332320206', '402019032924930007', '202021012359555041', '162021012315620004', '10000', '08:40', '2021-01-23 16:02:25', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012332770115', '402019032924930007', '202021012473875206', '162021012344310003', '10000', '08:40', '2021-01-23 15:11:35', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012334180170', '402019032924930007', '202021012348595032', '162021012315620004', '11000', '12:00', '2021-01-23 15:17:56', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012344930116', '402019032924930007', '202021012473875206', '162021012344310003', '20000', '18:00', '2021-01-23 15:11:35', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012349690200', '402019032924930007', '202021012317015038', '162021012315620004', '20000', '18:00', '2021-01-23 16:02:05', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012353320197', '402019032924930007', '202021012317015038', '162021012315620004', '10000', '08:30', '2021-01-23 16:02:05', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012379550172', '402019032924930007', '202021012348595032', '162021012315620004', '20000', '18:00', '2021-01-23 15:17:56', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021012398520199', '402019032924930007', '202021012317015038', '162021012315620004', '21000', '14:30', '2021-01-23 16:02:05', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124079712505', '402019032924930007', '202021012470495203', '162021012455360073', '10000', '08:30', '2021-01-24 18:04:20', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124099912703', '402019032924930007', '202021012413845226', '162021012495450077', '10000', '08:00', '2021-01-24 18:28:50', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124117012441', '402019032924930007', '202021012422525192', '162021012492160071', '20000', '18:00', '2021-01-24 18:00:41', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124136512804', '402019032924930007', '202021012472665236', '162021012440360080', '10000', '08:00', '2021-01-24 18:40:03', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124188112616', '402019032924930007', '202021012401605214', '162021012409610075', '20000', '18:00', '2021-01-24 18:18:16', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124196712594', '402019032924930007', '202021012434085254', '162021012440360080', '20000', '18:00', '2021-01-24 18:16:26', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124272412593', '402019032924930007', '202021012434085254', '162021012440360080', '10000', '08:26', '2021-01-24 18:16:26', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124280212506', '402019032924930007', '202021012470495203', '162021012455360073', '20000', '18:00', '2021-01-24 18:04:20', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124323612704', '402019032924930007', '202021012413845226', '162021012495450077', '20000', '18:00', '2021-01-24 18:28:50', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124612912768', '402019032924930007', '202021012467685231', '162021012412630079', '10000', '08:00', '2021-01-24 18:35:58', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124662512805', '402019032924930007', '202021012472665236', '162021012440360080', '20000', '18:00', '2021-01-24 18:40:03', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124695912677', '402019032924930007', '202021012462385219', '162021012411570076', '20000', '18:00', '2021-01-24 18:26:20', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124750612769', '402019032924930007', '202021012467685231', '162021012412630079', '20000', '18:00', '2021-01-24 18:35:58', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124806312440', '402019032924930007', '202021012422525192', '162021012492160071', '10000', '08:30', '2021-01-24 18:00:41', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124924812676', '402019032924930007', '202021012462385219', '162021012411570076', '10000', '08:00', '2021-01-24 18:26:20', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210124999812615', '402019032924930007', '202021012401605214', '162021012409610075', '10000', '08:30', '2021-01-24 18:18:16', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210127289331921', '402019032924930007', '202021012772947291', '162021012749890209', '11000', '12:00', '2021-01-27 23:47:44', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210127958331920', '402019032924930007', '202021012772947291', '162021012749890209', '10000', '08:30', '2021-01-27 23:47:44', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210127963831923', '402019032924930007', '202021012772947291', '162021012749890209', '20000', '18:00', '2021-01-27 23:47:44', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210127979631922', '402019032924930007', '202021012772947291', '162021012749890209', '21000', '14:30', '2021-01-27 23:47:44', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210128063932044', '402019032924930007', '202021012829167303', '162021012804210211', '20000', '18:00', '2021-01-28 00:09:30', '0');
INSERT INTO `attendance_classes_attr` VALUES ('11202101281105-30806', '402019032924930007', '202021012823577327', '162021012856220226', '10000', '08:30', '2021-01-28 09:05:15', '0');
INSERT INTO `attendance_classes_attr` VALUES ('11202101281996-30805', '402019032924930007', '202021012823577327', '162021012856220226', '20000', '18:00', '2021-01-28 09:05:15', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210128557532043', '402019032924930007', '202021012829167303', '162021012804210211', '10000', '08:30', '2021-01-28 00:09:30', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210128720732003', '402019032924930007', '202021012843487298', '162021012876570210', '20000', '18:00', '2021-01-28 00:01:18', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210128747832002', '402019032924930007', '202021012843487298', '162021012876570210', '10000', '08:30', '2021-01-28 00:01:18', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021020117211663', '402019032924930007', '202021052187913502', '162021051741580842', '20000', '18:00', '2021-02-01 14:16:09', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021020153351662', '402019032924930007', '202021052187913502', '162021051741580842', '10000', '08:30', '2021-02-01 14:16:09', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210223130318408', '402019032924930007', '202021022363741672', '162021022375820782', '20000', '13:30', '2021-02-23 17:59:20', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210223242619019', '402019032924930007', '202021022329191683', '162021022336690789', '20000', '01:50', '2021-02-23 19:04:37', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210223314718407', '402019032924930007', '202021022363741672', '162021022375820782', '10000', '09:00', '2021-02-23 17:59:20', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210223398819018', '402019032924930007', '202021022329191683', '162021022336690789', '10000', '00:10', '2021-02-23 19:04:37', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210304228731169', '402021030295380622', '202021030465696148', '162021030455810647', '10000', '08:00', '2021-03-04 16:52:58', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210304633131170', '402021030295380622', '202021030465696148', '162021030455810647', '20000', '18:00', '2021-03-04 16:52:58', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021031607991295', '402019032924930007', '202021072721082046', '162021072155030527', '10000', '10:00', '2021-03-16 10:59:15', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021031675141296', '402019032924930007', '202021072721082046', '162021072155030527', '20000', '18:00', '2021-03-16 10:59:15', '0');
INSERT INTO `attendance_classes_attr` VALUES ('11202103170539-28511', '402021031779540228', '202021031711912183', '162021031777530867', '20000', '06:00', '2021-03-17 17:10:54', '0');
INSERT INTO `attendance_classes_attr` VALUES ('11202103171559-28512', '402021031779540228', '202021031711912183', '162021031777530867', '10000', '08:00', '2021-03-17 17:10:54', '0');
INSERT INTO `attendance_classes_attr` VALUES ('11202103175536-31109', '402021031272750040', '202021031764882103', '162021031747020730', '20000', '18:00', '2021-03-17 15:59:35', '0');
INSERT INTO `attendance_classes_attr` VALUES ('11202103177999-31110', '402021031272750040', '202021031764882103', '162021031747020730', '10000', '08:30', '2021-03-17 15:59:35', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210415374914999', '402019032924930007', '202021041537844730', '162021041562500548', '20000', '18:00', '2021-04-15 17:07:22', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210415377214998', '402019032924930007', '202021041537844730', '162021041562500548', '10000', '09:00', '2021-04-15 17:07:22', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210506656527019', '402021042943610896', '202021050635078186', '162021050662150789', '10000', '09:00', '2021-05-06 11:02:31', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210506730327020', '402021042943610896', '202021050635078186', '162021050662150789', '20000', '17:00', '2021-05-06 11:02:31', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210517185524881', '402019032924930007', '202021051710011674', '162021051741580842', '10000', '10:30', '2021-05-17 16:34:40', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210517219724882', '402019032924930007', '202021051710011674', '162021051741580842', '20000', '16:30', '2021-05-17 16:34:40', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210706580725773', '402021070433360261', '202021070610673206', '162021070681981090', '10000', '08:30', '2021-07-06 09:44:46', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210706765925774', '402021070433360261', '202021070610673206', '162021070681981090', '20000', '06:00', '2021-07-06 09:44:46', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021070807242041', '402019032924930007', '202021070838130094', '162021070812210064', '20000', '16:00', '2021-07-08 09:48:22', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021070809122043', '402019032924930007', '202021070838130094', '162021070812210064', '22000', '21:00', '2021-07-08 09:48:22', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021070834322040', '402019032924930007', '202021070838130094', '162021070812210064', '21000', '14:00', '2021-07-08 09:48:22', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021070870892039', '402019032924930007', '202021070838130094', '162021070812210064', '11000', '12:00', '2021-07-08 09:48:22', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021070871192038', '402019032924930007', '202021070838130094', '162021070812210064', '10000', '09:00', '2021-07-08 09:48:22', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021070892022042', '402019032924930007', '202021070838130094', '162021070812210064', '12000', '19:00', '2021-07-08 09:48:22', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210721856125567', '402019032924930007', '202021072169830573', '162021072155030527', '20000', '16:01', '2021-07-21 16:01:36', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120210721931725565', '402019032924930007', '202021072169830573', '162021072155030527', '10000', '16:01', '2021-07-21 16:01:36', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021080605500071', '402021080402040153', '202021080600140009', '162021080681120003', '10000', '08:10', '2021-08-06 08:14:37', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021080627160072', '402021080402040153', '202021080600140009', '162021080681120003', '20000', '06:10', '2021-08-06 08:14:37', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021081423680178', '402021080402040153', '2020220227788712808', '162021112280590310', '20000', '21:40', '2021-08-14 17:50:03', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021081433250177', '402021080402040153', '2020220227788712808', '162021112280590310', '10000', '22:40', '2021-08-14 17:50:03', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021081500827787', '402021080402040153', '202021082093830194', '162021081521370249', '21000', '', '2021-08-15 23:43:50', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021081531657786', '402021080402040153', '202021082093830194', '162021081521370249', '11000', '23:50', '2021-08-15 23:43:50', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021081541287788', '402021080402040153', '202021081567200633', '162021081521370249', '20000', '', '2021-08-15 23:43:50', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021081582217785', '402021080402040153', '202021081567200633', '162021081521370249', '10000', '23:44', '2021-08-15 23:43:50', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021082022289826', '402021080402040153', '202021082073980216', '162021082015090225', '20000', '18:00', '2021-08-20 16:22:25', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021082050039825', '402021080402040153', '202021082073980216', '162021082015090225', '10000', '09:00', '2021-08-20 16:22:25', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021090122317425', '402021082795580012', '202021090178290385', '162021090198550241', '10000', '09:00', '2021-09-01 17:13:54', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021090146397426', '402021082795580012', '202021090178290385', '162021090198550241', '20000', '17:10', '2021-09-01 17:13:54', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021091240999422', '402021080402040153', '202021091286030242', '162021091212370216', '10000', '', '2021-09-12 17:06:09', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112021091288909423', '402021080402040153', '202021091286030242', '162021091212370216', '20000', '', '2021-09-12 17:06:09', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120211027504516023', '402021080402040153', '202021102728220341', '162021102764620118', '20000', '18:00', '2021-10-27 15:37:40', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120211027721016022', '402021080402040153', '202021102728220341', '162021102764620118', '10000', '09:30', '2021-10-27 15:37:40', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120211122330223857', '402021080402040153', '202021112285040725', '162021112280590310', '10000', '09:00', '2021-11-22 10:05:58', '0');
INSERT INTO `attendance_classes_attr` VALUES ('1120211122481723858', '402021080402040153', '202021112285040725', '162021112280590310', '20000', '18:00', '2021-11-22 10:05:58', '0');
INSERT INTO `attendance_classes_attr` VALUES ('11202201291894-11830', '402022012945120857', '202022012981477709', '162022012911821090', '20000', '17:30', '2022-01-29 16:39:08', '0');
INSERT INTO `attendance_classes_attr` VALUES ('11202201294075-11831', '402022012945120857', '202022012981477709', '162022012911821090', '10000', '09:00', '2022-01-29 16:39:08', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112022110409750012', '102022081507340423', '-1', '102022110491120003', '10000', '', '2022-11-04 00:27:52', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112022110496120014', '102022081507340423', '-1', '102022110491120003', '20000', '', '2022-11-04 00:27:52', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112023022258700008', '102023013170370081', '-1', '102023022264870002', '20000', '', '2023-02-22 00:22:47', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112023022274840006', '102023013170370081', '-1', '102023022264870002', '10000', '', '2023-02-22 00:22:47', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112023022646860005', '102023013170370081', '-1', '102023022613720003', '20000', '', '2023-02-26 01:36:04', '0');
INSERT INTO `attendance_classes_attr` VALUES ('112023022647220003', '102023013170370081', '-1', '102023022613720003', '10000', '', '2023-02-26 01:36:04', '0');

-- ----------------------------
-- Table structure for attendance_classes_staff
-- ----------------------------
DROP TABLE IF EXISTS `attendance_classes_staff`;
CREATE TABLE `attendance_classes_staff` (
  `cs_id` varchar(64) NOT NULL COMMENT '班次员工ID',
  `classes_id` varchar(64) NOT NULL COMMENT '班次ID',
  `staff_id` varchar(64) NOT NULL COMMENT '员工ID',
  `staff_name` varchar(200) NOT NULL COMMENT '员工名称',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of attendance_classes_staff
-- ----------------------------
INSERT INTO `attendance_classes_staff` VALUES ('102023022214210002', '102023022206160030', '302023013182560147', 'abc', '102023013170370081', '2023-02-22 01:08:15', '1');
INSERT INTO `attendance_classes_staff` VALUES ('102023022275090012', '102023022206160030', '302023013182560147', 'abc', '102023013170370081', '2023-02-22 01:10:30', '0');
INSERT INTO `attendance_classes_staff` VALUES ('102024022641170531', '102024022690370514', '302024022107117014', '阿姨', '10202305221014329108000168', '2024-02-26 10:18:19', '0');

-- ----------------------------
-- Table structure for attendance_classes_task
-- ----------------------------
DROP TABLE IF EXISTS `attendance_classes_task`;
CREATE TABLE `attendance_classes_task` (
  `task_id` varchar(64) NOT NULL COMMENT '打卡任务ID',
  `class_id` varchar(64) NOT NULL COMMENT '班次ID',
  `staff_id` varchar(64) NOT NULL COMMENT '员工ID',
  `task_year` int NOT NULL COMMENT '年份',
  `task_month` int NOT NULL COMMENT '月份',
  `task_day` int NOT NULL COMMENT '日',
  `state` varchar(12) NOT NULL DEFAULT '10000' COMMENT '考勤状态，10000未考勤 20000 考勤中 30000考勤完成',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `staff_name` varchar(64) NOT NULL COMMENT '员工名称',
  PRIMARY KEY (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of attendance_classes_task
-- ----------------------------
INSERT INTO `attendance_classes_task` VALUES ('112023022519470004', '102023022206160030', '302023013182560147', '2023', '2', '25', '30000', '2023-02-25 12:45:00', '0', '102023013170370081', 'abc');
INSERT INTO `attendance_classes_task` VALUES ('112023022730260018', '102023022206160030', '302023013182560147', '2023', '2', '27', '10000', '2023-02-27 00:00:00', '0', '102023013170370081', 'abc');
INSERT INTO `attendance_classes_task` VALUES ('112023030120120003', '102023022206160030', '302023013182560147', '2023', '3', '1', '10000', '2023-03-01 00:00:00', '0', '102023013170370081', 'abc');
INSERT INTO `attendance_classes_task` VALUES ('112023030378090010', '102023022206160030', '302023013182560147', '2023', '3', '3', '10000', '2023-03-03 00:00:00', '0', '102023013170370081', 'abc');
INSERT INTO `attendance_classes_task` VALUES ('112023030501170025', '102023022206160030', '302023013182560147', '2023', '3', '5', '10000', '2023-03-05 00:00:00', '0', '102023013170370081', 'abc');
INSERT INTO `attendance_classes_task` VALUES ('1473e6a9-831c-4d1e-92d2-076940eb0b30', '162021020144770930', '302021012752050205', '2021', '2', '10', '10000', '2021-02-10 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('1fd89f1f-7e57-436a-a416-275b51f338e0', '162021020144770930', '302021012752050205', '2021', '2', '4', '10000', '2021-02-04 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('20f855b0-1da8-4803-9a31-1aff23475c98', '162021020144770930', '302021012752050205', '2021', '2', '6', '10000', '2021-02-06 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('2314fdf2-a727-435e-b42e-02b7aa2ff6e7', '162021020144770930', '21d9fb5d-c99c-4f2d-a907-f3b82cc76811', '2021', '2', '2', '10000', '2021-02-02 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('2e966a6d-6853-4af7-a7d6-e7f79937c528', '162021020144770930', '302021012752050205', '2021', '2', '3', '10000', '2021-02-03 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('36fceffb-9615-4f74-9eb9-eed99056fc20', '162021020144770930', '302021012825820303', '2021', '2', '3', '10000', '2021-02-03 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('5686e148-3cd5-47cb-8376-592b1a66354f', '162021020144770930', '21d9fb5d-c99c-4f2d-a907-f3b82cc76811', '2021', '2', '1', '10000', '2021-02-01 14:56:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('6c3b2791-859d-44df-9486-b47120483e05', '162021020144770930', '302021012825820303', '2021', '2', '7', '10000', '2021-02-07 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('7e292811-bd03-4078-b923-2d4a7b43f3e9', '162021020144770930', '302021012825820303', '2021', '2', '10', '10000', '2021-02-10 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('95f789d8-4357-411c-867b-c5ceef7353eb', '162021020144770930', '302021012825820303', '2021', '2', '4', '10000', '2021-02-04 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('96685c53-cba0-49b7-bfb4-45c12015a5dd', '162021020144770930', '302021012752050205', '2021', '2', '7', '10000', '2021-02-07 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('99d47cc1-8e04-4302-8328-90fb78077179', '162021020144770930', '302021012752050205', '2021', '2', '8', '10000', '2021-02-08 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('adc5d909-bb2a-4546-9515-4950a7bed350', '162021020144770930', '8470c64e-4a1e-441a-bf0b-1f85eb18669b', '2021', '2', '1', '10000', '2021-02-01 14:56:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('b65f2ec5-b7af-493b-910b-cef7e5c7da75', '162021020144770930', '302021012752050205', '2021', '2', '5', '10000', '2021-02-05 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('bd1a77f8-7d97-4816-b49d-634d9487e5f1', '162021020144770930', '302021012825820303', '2021', '2', '6', '10000', '2021-02-06 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('c246771e-474b-48f6-afbc-2928977cca34', '162021020144770930', '302021012825820303', '2021', '2', '5', '10000', '2021-02-05 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('c390ee62-ff59-4f69-9d22-776a691ae8a3', '162021020144770930', '302021012825820303', '2021', '2', '8', '10000', '2021-02-08 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('d5a2775c-2f6b-40a4-a64e-ea8f7801b40f', '162021020144770930', '8470c64e-4a1e-441a-bf0b-1f85eb18669b', '2021', '2', '2', '10000', '2021-02-02 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('db8a39e3-3e7a-45be-8801-de0c6d33d4bb', '162021020144770930', '302021012752050205', '2021', '2', '9', '10000', '2021-02-09 00:00:00', '0', '402019032924930007', '');
INSERT INTO `attendance_classes_task` VALUES ('e7e338df-e793-4e79-bcc3-28f71e8d2212', '162021020144770930', '302021012825820303', '2021', '2', '9', '10000', '2021-02-09 00:00:00', '0', '402019032924930007', '');

-- ----------------------------
-- Table structure for attendance_classes_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `attendance_classes_task_detail`;
CREATE TABLE `attendance_classes_task_detail` (
  `detail_id` varchar(64) NOT NULL COMMENT '打卡记录表',
  `task_id` varchar(64) NOT NULL COMMENT '打卡任务ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '打卡时间段',
  `value` varchar(32) NOT NULL COMMENT '希望打卡时间',
  `check_time` datetime DEFAULT NULL COMMENT '实际打卡时间',
  `state` varchar(12) NOT NULL COMMENT '打卡状态 10000未考勤  30000正常考勤 40000 迟到 50000早退 60000 免考勤',
  `face_path` varchar(200) DEFAULT NULL COMMENT '打卡抓拍人脸',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注字段',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `leave_value` varchar(32) NOT NULL COMMENT '正常或者早退时间，spec_cd 1001 是正常考勤 2002 是早退时间',
  `late_value` varchar(32) NOT NULL COMMENT '正常或者早退时间，spec_cd 1001 是迟到 2002 是正常时间',
  PRIMARY KEY (`detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of attendance_classes_task_detail
-- ----------------------------
INSERT INTO `attendance_classes_task_detail` VALUES ('122023022502540006', '112023022519470004', '2002', '2023-02-25 17:30:00', null, '70000', null, '2023-02-25 12:45:00', '0', 'xxx', '102023013170370081', '2023-02-25 17:00:00', '2023-02-25 18:30:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023022531800005', '112023022519470004', '1001', '2023-02-25 08:30:00', '2023-02-25 08:30:00', '30000', null, '2023-02-25 12:45:00', '0', null, '102023013170370081', '2023-02-25 07:30:00', '2023-02-25 09:00:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023022743490020', '112023022730260018', '2002', '2023-02-27 17:30:00', null, '10000', null, '2023-02-27 00:00:00', '0', null, '102023013170370081', '2023-02-27 17:00:00', '2023-02-27 20:30:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023022765690019', '112023022730260018', '1001', '2023-02-27 08:30:00', null, '10000', null, '2023-02-27 00:00:00', '0', null, '102023013170370081', '2023-02-27 07:30:00', '2023-02-27 09:00:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023030173650005', '112023030120120003', '2002', '2023-03-01 17:30:00', null, '10000', null, '2023-03-01 00:00:00', '0', null, '102023013170370081', '2023-03-01 17:00:00', '2023-03-01 20:30:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023030179050004', '112023030120120003', '1001', '2023-03-01 08:30:00', null, '10000', null, '2023-03-01 00:00:00', '0', null, '102023013170370081', '2023-03-01 07:30:00', '2023-03-01 09:00:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023030390130011', '112023030378090010', '1001', '2023-03-03 08:30:00', null, '10000', null, '2023-03-03 00:00:00', '0', null, '102023013170370081', '2023-03-03 07:30:00', '2023-03-03 09:00:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023030391780012', '112023030378090010', '2002', '2023-03-03 17:30:00', null, '10000', null, '2023-03-03 00:00:00', '0', null, '102023013170370081', '2023-03-03 17:00:00', '2023-03-03 20:30:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023030502850027', '112023030501170025', '2002', '2023-03-05 17:30:00', null, '10000', null, '2023-03-05 00:00:00', '0', null, '102023013170370081', '2023-03-05 17:00:00', '2023-03-05 20:30:00');
INSERT INTO `attendance_classes_task_detail` VALUES ('122023030563930026', '112023030501170025', '1001', '2023-03-05 08:30:00', null, '10000', null, '2023-03-05 00:00:00', '0', null, '102023013170370081', '2023-03-05 07:30:00', '2023-03-05 09:00:00');

-- ----------------------------
-- Table structure for attendance_log
-- ----------------------------
DROP TABLE IF EXISTS `attendance_log`;
CREATE TABLE `attendance_log` (
  `log_id` varchar(64) NOT NULL COMMENT '员工考勤日志表',
  `staff_id` varchar(64) NOT NULL COMMENT '员工ID',
  `staff_name` varchar(128) NOT NULL COMMENT '员工名称',
  `department_id` varchar(30) DEFAULT NULL COMMENT '考勤部门',
  `department_name` varchar(128) DEFAULT NULL COMMENT '考勤部门',
  `clock_time` datetime NOT NULL COMMENT '设备考勤时间',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `face_path` varchar(200) DEFAULT NULL COMMENT '打卡抓拍人脸',
  `remark` varchar(1024) DEFAULT NULL COMMENT '说明',
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of attendance_log
-- ----------------------------
INSERT INTO `attendance_log` VALUES ('102021020323281871', '302021012752050205', '张爸爸', '842021012771500063', '考勤测试部', '2021-02-03 12:25:23', '402019032924930007', '2021-02-03 12:25:07', '0', null, null);
INSERT INTO `attendance_log` VALUES ('102021020335900384', '302021012752050205', '张爸爸', '842021012771500063', '考勤测试部', '2021-02-03 10:38:29', '402019032924930007', '2021-02-03 10:38:13', '0', null, null);
INSERT INTO `attendance_log` VALUES ('102021020357680324', '302021012752050205', '张爸爸', '842021012771500063', '842021012771500063', '2021-02-03 10:35:08', '402019032924930007', '2021-02-03 10:34:53', '0', null, null);
INSERT INTO `attendance_log` VALUES ('102021020372770376', '302021012752050205', '张爸爸', '842021012771500063', '考勤测试部', '2021-02-03 10:38:16', '402019032924930007', '2021-02-03 10:38:03', '0', null, null);
INSERT INTO `attendance_log` VALUES ('10202102222169-7125', '302021012752050205', '张爸爸', '842021012771500063', '考勤测试部', '2021-02-22 10:45:38', '402019032924930007', '2021-02-22 10:45:38', '0', null, null);

-- ----------------------------
-- Table structure for attr_spec
-- ----------------------------
DROP TABLE IF EXISTS `attr_spec`;
CREATE TABLE `attr_spec` (
  `spec_cd` varchar(12) NOT NULL COMMENT '规格ID',
  `table_name` varchar(50) NOT NULL COMMENT '表名',
  `spec_name` varchar(100) NOT NULL COMMENT '规格名称',
  `spec_holdplace` varchar(100) NOT NULL COMMENT '字段填写说明',
  `required` varchar(2) NOT NULL COMMENT '是否必填 Y 必填，N非必填',
  `spec_show` varchar(2) NOT NULL COMMENT '是否展示',
  `spec_value_type` varchar(12) NOT NULL COMMENT '1001 字符串 2002 整数 3003 金额 4004 日期 5005 时间',
  `spec_type` varchar(12) NOT NULL COMMENT '2233 input 3344 select 4455 日期',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `list_show` varchar(2) NOT NULL COMMENT '是否展示在list页面 Y 是 N 不是',
  `domain` varchar(64) NOT NULL COMMENT '域',
  `spec_id` varchar(30) NOT NULL COMMENT '主键ID',
  PRIMARY KEY (`spec_id`),
  KEY `i_as_table_name` (`table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of attr_spec
-- ----------------------------
INSERT INTO `attr_spec` VALUES ('081442370001', 'building_room_attr', '测试属性1', '必填，请填写测试属性1', 'N', 'Y', '1001', '2233', '2020-08-14 23:24:40', '1', 'Y', 'COMMON', '081442370001');
INSERT INTO `attr_spec` VALUES ('081475250002', 'building_room_attr', '商品房', '必填，请选择房屋类型', 'Y', 'Y', '1001', '3344', '2020-08-14 23:45:45', '1', 'Y', 'COMMON', '081475250002');
INSERT INTO `attr_spec` VALUES ('081606740011', 'building_owner_attr', '门禁钥匙', '选填，请填写门禁钥匙', 'N', 'Y', '1001', '2233', '2020-08-16 12:58:29', '0', 'Y', 'COMMON', '081606740011');
INSERT INTO `attr_spec` VALUES ('081623050012', 'building_owner_attr', '爱好', '选填', 'N', 'Y', '1001', '3344', '2020-08-16 12:59:02', '1', 'Y', 'COMMON', '081623050012');
INSERT INTO `attr_spec` VALUES ('081623500015', 'building_room_attr', '商品房', '必填，请填写是否为商品房', 'Y', 'Y', '1001', '3344', '2020-08-16 16:50:41', '1', 'Y', 'COMMON', '081623500015');
INSERT INTO `attr_spec` VALUES ('081681590010', 'building_owner_attr', 'QQ', '选填，请填写QQ', 'N', 'Y', '1001', '2233', '2020-08-16 12:41:07', '1', 'Y', 'COMMON', '081681590010');
INSERT INTO `attr_spec` VALUES ('081688940018', 'building_room_attr', '商铺', '选填，是否为商铺', 'N', 'Y', '1001', '3344', '2020-08-16 16:51:41', '1', 'Y', 'COMMON', '081688940018');
INSERT INTO `attr_spec` VALUES ('082999830016', 'building_owner_attr', '是否业主', '是否业主', 'N', 'Y', '1001', '3344', '2020-08-29 11:39:43', '1', 'Y', 'COMMON', '082999830016');
INSERT INTO `attr_spec` VALUES ('7127015495', 'machine_attr', '门禁协议', '必填请选择厂家协议', 'Y', 'Y', '1001', '3344', '2022-07-22 14:43:28', '0', 'Y', 'ACCESS_CONTROL', '112022072211740001');
INSERT INTO `attr_spec` VALUES ('7127015495', 'machine_attr', '道闸协议', '必填，请填写道闸协议', 'Y', 'Y', '1001', '3344', '2022-07-28 11:33:59', '0', 'Y', 'BARRIER_GATE', '112022072835550002');
INSERT INTO `attr_spec` VALUES ('2000908', 'building_room_attr', '是否商铺', '必填，是否为商铺', 'Y', 'Y', '1001', '3344', '2020-08-13 21:33:03', '1', 'Y', 'COMMON', '2000908');
INSERT INTO `attr_spec` VALUES ('6185-17861', 'parking_area_attr', '外部编码', '选填，请填写外部编码 一般为第三方停车场系统ID', 'N', 'Y', '1001', '2233', '2021-03-18 12:20:26', '0', 'Y', 'COMMON', '6185-17861');
INSERT INTO `attr_spec` VALUES ('6443000036', 'owner_car_attr', '业主车辆', '业主车辆', 'N', 'Y', '1001', '3344', '2022-03-15 17:47:11', '0', 'Y', 'COMMON', '6443000036');
INSERT INTO `attr_spec` VALUES ('7127015495', 'machine_attr', '厂家协议', '必填，请填写厂家协议', 'Y', 'Y', '1001', '3344', '2020-12-09 22:10:05', '1', 'Y', 'COMMON', '7127015495');
INSERT INTO `attr_spec` VALUES ('7127015495', 'machine_attr', '考勤机协议', '必填，请填写厂家协议', 'Y', 'Y', '1001', '3344', '2022-07-22 12:52:23', '0', 'Y', 'ATTENDANCE', '71270154951');
INSERT INTO `attr_spec` VALUES ('9035007248', 'building_room_attr', '精装修', '是否精装修', 'N', 'Y', '1001', '2233', '2021-09-14 00:42:21', '1', 'Y', 'COMMON', '9035007248');
INSERT INTO `attr_spec` VALUES ('9329000004', 'building_community_attr', '社区编码', '必填，请填写社区编码', 'Y', 'Y', '1001', '2233', '2020-11-27 11:13:30', '0', 'Y', 'COMMON', '9329000004');

-- ----------------------------
-- Table structure for attr_value
-- ----------------------------
DROP TABLE IF EXISTS `attr_value`;
CREATE TABLE `attr_value` (
  `value_id` varchar(30) NOT NULL COMMENT '值ID',
  `spec_id` varchar(30) NOT NULL COMMENT '规格ID',
  `value` varchar(200) NOT NULL COMMENT '值',
  `value_name` varchar(200) NOT NULL COMMENT '值名称，前台显示用',
  `value_show` varchar(2) NOT NULL COMMENT '选择时，是否显示在前台 Y显示 N不显示',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  UNIQUE KEY `value_id` (`value_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of attr_value
-- ----------------------------
INSERT INTO `attr_value` VALUES ('1', '2000908', '1', '是', 'Y', '2020-08-14 09:33:32', '1');
INSERT INTO `attr_value` VALUES ('112020081400390004', '081475250002', '2', '否', 'Y', '2020-08-14 23:46:09', '1');
INSERT INTO `attr_value` VALUES ('112020081440200001', '081442370001', '3', '否', 'Y', '2020-08-14 23:35:53', '1');
INSERT INTO `attr_value` VALUES ('112020081441490003', '081475250002', '1', '是', 'Y', '2020-08-14 23:46:02', '1');
INSERT INTO `attr_value` VALUES ('112020081471550002', '081442370001', '1', '是', 'Y', '2020-08-14 23:25:01', '1');
INSERT INTO `attr_value` VALUES ('112020081602340014', '081623050012', '2', '篮球', 'Y', '2020-08-16 12:59:28', '1');
INSERT INTO `attr_value` VALUES ('112020081602700016', '081623500015', '1', '是', 'Y', '2020-08-16 16:50:54', '0');
INSERT INTO `attr_value` VALUES ('112020081615120017', '081623500015', '2', '否', 'Y', '2020-08-16 16:51:01', '0');
INSERT INTO `attr_value` VALUES ('112020081622380013', '081623050012', '1', '女人', 'Y', '2020-08-16 12:59:16', '1');
INSERT INTO `attr_value` VALUES ('112020081668020020', '081688940018', '2', '否', 'Y', '2020-08-16 16:51:59', '0');
INSERT INTO `attr_value` VALUES ('112020081699120019', '081688940018', '1', '是', 'Y', '2020-08-16 16:51:52', '0');
INSERT INTO `attr_value` VALUES ('112020082947120018', '082999830016', '2', '否', 'Y', '2020-08-29 11:40:48', '1');
INSERT INTO `attr_value` VALUES ('112020082963920017', '082999830016', '1', '是', 'Y', '2020-08-29 11:40:35', '1');
INSERT INTO `attr_value` VALUES ('11202012203752-6440', '112022072211740001', '3', '伊兰度mqtt协议', 'Y', '2020-12-20 12:37:57', '0');
INSERT INTO `attr_value` VALUES ('11202012205775-6457', '7127015495', '1', 'HC测试协议', 'Y', '2020-12-20 12:34:30', '0');
INSERT INTO `attr_value` VALUES ('11202012205936-6435', '112022072211740001', '4', '宇泛协议', 'Y', '2020-12-20 12:38:08', '0');
INSERT INTO `attr_value` VALUES ('11202012249350-13198', '112022072211740001', '5', '德安门禁', 'Y', '2020-12-24 15:25:09', '0');
INSERT INTO `attr_value` VALUES ('1120201225281514184', '112022072211740001', '6', '德安门禁mqtt', 'Y', '2020-12-25 15:51:40', '0');
INSERT INTO `attr_value` VALUES ('1120210105901626818', '112022072835550002', '7', '臻识道闸Tcp协议', 'Y', '2021-01-05 13:55:50', '0');
INSERT INTO `attr_value` VALUES ('1120210109643418450', '112022072835550002', '8', '臻识道闸Tcp协议(第三方平台)', 'Y', '2021-01-09 01:38:07', '0');
INSERT INTO `attr_value` VALUES ('1120210317174832184', '112022072211740001', '10', '百胜智能门禁协议', 'Y', '2021-03-17 15:04:59', '0');
INSERT INTO `attr_value` VALUES ('11202103192806-4642', '112022072835550002', '11', '百胜智能道闸(第三方平台)', 'Y', '2021-03-19 10:24:39', '0');
INSERT INTO `attr_value` VALUES ('112021041610511585', '112022072835550002', '12', '云盟道闸(第三方平台)', 'Y', '2021-04-16 17:51:13', '0');
INSERT INTO `attr_value` VALUES ('112021041691292415', '112022072835550002', '13', '零壹道闸(第三方平台)', 'Y', '2021-04-16 18:13:13', '0');
INSERT INTO `attr_value` VALUES ('112021051889380884', '112022072835550002', '14', '陶格斯道闸(第三方平台)', 'Y', '2021-05-18 09:25:11', '0');
INSERT INTO `attr_value` VALUES ('1120210622106031136', '112022072835550002', '15', '道闸通用适配器', 'Y', '2021-06-22 11:37:39', '0');
INSERT INTO `attr_value` VALUES ('1120210721078917842', '112022072211740001', '16', '海康门禁协议', 'Y', '2021-07-21 09:25:16', '0');
INSERT INTO `attr_value` VALUES ('1120210911411729899', '1785029891', '8329000004', '秘钥', 'Y', '2021-09-11 12:37:14', '1');
INSERT INTO `attr_value` VALUES ('112021091484557255', '9035007248', '2', '否', 'Y', '2021-09-14 00:42:48', '0');
INSERT INTO `attr_value` VALUES ('112021091495637252', '9035007248', '1', '是', 'Y', '2021-09-14 00:42:38', '0');
INSERT INTO `attr_value` VALUES ('1120211011732217384', '112022072835550002', '17', '臻识道闸Mqtt协议', 'Y', '2021-10-11 16:19:49', '0');
INSERT INTO `attr_value` VALUES ('1120211213539016683', '7127015495', '999', '123123', 'Y', '2021-12-13 19:11:53', '1');
INSERT INTO `attr_value` VALUES ('1120211213721416665', '7127015495', '999', '123', 'Y', '2021-12-13 19:11:01', '1');
INSERT INTO `attr_value` VALUES ('112022031502670160', '6443000036', 'true', '是', 'Y', '2022-03-15 21:19:14', '0');
INSERT INTO `attr_value` VALUES ('112022031522890163', '6443000036', 'false', '否', 'Y', '2022-03-15 21:19:27', '0');
INSERT INTO `attr_value` VALUES ('112022072277540001', '71270154951', '21', '厂拍考勤机', 'Y', '2022-07-22 14:04:19', '0');
INSERT INTO `attr_value` VALUES ('112022072501650001', '71270154951', '18', '中控考勤机', 'Y', '2022-07-25 13:10:07', '0');
INSERT INTO `attr_value` VALUES ('112022090291000003', '112022072211740001', '19', '神行门禁协议', 'Y', '2022-09-02 23:47:15', '0');
INSERT INTO `attr_value` VALUES ('112022121465930330', '112022072211740001', '20', '大华门禁协议', 'Y', '2022-12-14 16:13:27', '0');
INSERT INTO `attr_value` VALUES ('112023042394952230', '112022072211740001', '22', '厂拍门禁协议', 'Y', '2023-04-23 18:57:46', '0');
INSERT INTO `attr_value` VALUES ('2', '2000908', '2', '否', 'Y', '2020-08-14 09:33:46', '1');

-- ----------------------------
-- Table structure for audit_user
-- ----------------------------
DROP TABLE IF EXISTS `audit_user`;
CREATE TABLE `audit_user` (
  `audit_user_id` varchar(30) NOT NULL COMMENT '审核ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID,用来做分区',
  `user_id` varchar(100) NOT NULL COMMENT '审核用户ID',
  `user_name` varchar(100) NOT NULL COMMENT '审核用户名称',
  `audit_link` varchar(64) NOT NULL COMMENT '审核环节，建t_dict表 如部门经理审核 ， 财务审核 ，采购人员采购',
  `obj_code` varchar(64) NOT NULL COMMENT '流程对象编码,如采购申请 resource_enter',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  KEY `idx_audit_user_id` (`audit_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of audit_user
-- ----------------------------

-- ----------------------------
-- Table structure for bill
-- ----------------------------
DROP TABLE IF EXISTS `bill`;
CREATE TABLE `bill` (
  `bill_id` varchar(30) NOT NULL COMMENT '账单主键ID',
  `bill_name` varchar(200) NOT NULL COMMENT '账单名称',
  `receivable` decimal(10,2) NOT NULL COMMENT '应收金额',
  `receipts` decimal(10,2) NOT NULL COMMENT '实收金额',
  `bill_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '账单日期',
  `community_id` varchar(30) NOT NULL COMMENT '小区分片字段',
  `config_id` varchar(30) NOT NULL COMMENT '收费项目ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `remark` varchar(200) NOT NULL COMMENT '备注',
  `cur_bill` varchar(12) NOT NULL DEFAULT 'T' COMMENT 'T为当前有效账单，F为历史账单',
  `cur_receivable` decimal(10,2) DEFAULT NULL COMMENT '当期应收金额'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bill
-- ----------------------------

-- ----------------------------
-- Table structure for bill_owe_fee
-- ----------------------------
DROP TABLE IF EXISTS `bill_owe_fee`;
CREATE TABLE `bill_owe_fee` (
  `owe_id` varchar(30) NOT NULL COMMENT '欠费主键',
  `bill_id` varchar(30) NOT NULL COMMENT '账单ID',
  `fee_id` varchar(30) NOT NULL COMMENT '费用ID',
  `bill_amount_owed` decimal(10,2) NOT NULL COMMENT '账期欠费金额',
  `amount_owed` decimal(10,2) NOT NULL COMMENT '当前欠费金额',
  `fee_end_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '费用结束时间，当时跑账单时的费用结束时间',
  `owner_id` varchar(30) NOT NULL COMMENT '业主ID',
  `owner_name` varchar(100) NOT NULL COMMENT '业主名称',
  `owner_tel` varchar(11) NOT NULL COMMENT '业主联系电话',
  `payer_obj_name` varchar(100) NOT NULL COMMENT '付费对象名称 如 1栋1单元1室 或者 1号停车场1号车位',
  `payer_obj_type` varchar(12) NOT NULL COMMENT '付费对象类型 3333 房屋 6666 是车位',
  `community_id` varchar(30) NOT NULL COMMENT '分片键，小区ID',
  `state` varchar(12) NOT NULL DEFAULT '1000' COMMENT '状态 1000 未交费，2000 已缴费',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `deadline_time` timestamp NULL DEFAULT NULL COMMENT '截止时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bill_owe_fee
-- ----------------------------

-- ----------------------------
-- Table structure for building_owner
-- ----------------------------
DROP TABLE IF EXISTS `building_owner`;
CREATE TABLE `building_owner` (
  `member_id` varchar(30) NOT NULL COMMENT '业主成员ID',
  `owner_id` varchar(30) NOT NULL COMMENT '业主ID',
  `b_id` varchar(30) DEFAULT NULL COMMENT '业务ID',
  `name` varchar(64) NOT NULL COMMENT '业主名称',
  `sex` varchar(12) NOT NULL COMMENT '性别',
  `age` varchar(12) DEFAULT NULL COMMENT '年龄',
  `link` varchar(11) NOT NULL COMMENT '联系人手机号',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，0, 在用 1失效',
  `owner_type_cd` varchar(4) NOT NULL DEFAULT '1001' COMMENT '1001 业主本人 1002 家庭成员',
  `community_id` varchar(30) DEFAULT NULL COMMENT '小区ID',
  `id_card` varchar(18) DEFAULT '-1' COMMENT '身份证号码',
  `state` varchar(12) NOT NULL DEFAULT '2000' COMMENT '业主 成员状态 1000 表示待审核，2000 审核完成  3000 拒绝审核 ',
  `owner_flag` varchar(12) NOT NULL DEFAULT 'T' COMMENT '业主标识 T是真实业主 F 是虚拟业主',
  `address` varchar(255) DEFAULT NULL COMMENT '家庭住址',
  UNIQUE KEY `member_id` (`member_id`) USING BTREE,
  UNIQUE KEY `idx_owner_id` (`member_id`) USING BTREE,
  KEY `idx_owner_b_id` (`b_id`) USING BTREE,
  KEY `i_bo_owner_id` (`owner_id`) USING BTREE,
  KEY `i_bo_owner_type_cd` (`owner_type_cd`),
  KEY `i_bo_community_id` (`community_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of building_owner
-- ----------------------------
INSERT INTO `building_owner` VALUES ('112024032207740008', '772024021975893605', '202024032262930009', '张三', '0', null, '17709711234', '30202305221014327189000174', '业主认证，审核添加', '2024-03-22 16:27:04', '0', '1002', '2023052267100146', null, '2000', 'T', '无');
INSERT INTO `building_owner` VALUES ('112024032266750002', '772024021903822961', '202024032224570003', '老吴', '0', null, '17709711234', '30202305221014327189000174', '业主认证，审核添加', '2024-03-22 13:43:31', '0', '1002', '2023052267100146', null, '2000', 'T', '无');
INSERT INTO `building_owner` VALUES ('772023120586090338', '772023120586090338', '202023120535210339', '吴学文', '0', null, '18109711443', '30202305221014327189000174', '', '2023-12-05 18:18:03', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024012272180002', '772024012272180002', '202024012254710003', '死三八1', '0', null, '15666665556', '302024012264900032', '', '2024-01-22 23:27:20', '1', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024012292610085', '772024012292610085', '202024012290330086', '同步业主', '0', null, '18975756565', '302024012264900032', '', '2024-01-22 15:08:26', '0', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024012296540095', '772024012296540095', '202024012263960096', '死三八1', '0', null, '15666665555', '302024012264900032', '', '2024-01-22 23:18:19', '0', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024012299410005', '772024012299410005', '202024012299290006', '张飞3', '0', null, '18922224444', '302024012264900032', '', '2024-01-22 22:42:01', '0', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024020516840034', '772024012296540095', '202024020573570035', '成员张三', '0', null, '18909714523', '302024012264900032', '', '2024-02-05 23:36:50', '0', '1002', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024020882790038', '772024020882790038', '202024020842430039', '123', '0', null, '15696522323', '302024012264900032', '', '2024-02-08 02:03:12', '0', '1001', '2023062100700008', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021624210722', '772024021624210722', '202024021666020723', '李丽', '1', null, '13111111111', '30202305221014327189000174', '', '2024-02-16 16:50:21', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021697820551', '772024021697820551', null, '嘀嘀嘀', '1', '1', '19173406232', '-1', '', '2024-02-16 10:56:47', '0', '1001', '2023052267100146', '', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024021865421354', '772024021624210722', '202024021841141355', '测试1', '0', null, '18900000000', '30202305221014327189000174', '', '2024-02-18 08:50:02', '0', '1002', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021878531367', '772024021624210722', '202024021832481368', '测试2', '0', null, '18900000002', '30202305221014327189000174', '', '2024-02-18 08:50:17', '0', '1003', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021903822961', '772024021903822961', '202024021979162962', '测试', '0', null, '18049392222', '30202305221014327189000174', '', '2024-02-19 10:33:00', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021942673049', '772024021988183022', '202024021941103050', 'haha', '0', null, '18511112222', '30202305221014327189000174', '', '2024-02-19 10:58:34', '0', '1002', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021952223083', '772024021952223083', '202024021950203084', 'yyanz', '1', null, '18512341234', '30202305221014327189000174', '', '2024-02-19 11:02:19', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021975172442', '772024021975172442', '202024021983262443', '张三', '0', null, '15395136032', '30202305221014327189000174', '', '2024-02-19 06:39:47', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021975863681', '772024021975863681', '202024021974963682', 'Mei001', '1', null, '13782790901', '30202305221014327189000174', '', '2024-02-19 16:53:23', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021975893605', '772024021975893605', '202024021990763606', '测试222', '0', null, '13154831191', '30202305221014327189000174', '', '2024-02-19 16:32:25', '0', '1001', '2023052267100146', '15211111111111111', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021984292637', '772024021985712625', '202024021978642638', '李四', '1', null, '18856065616', '302024021945972511', '', '2024-02-19 07:19:31', '0', '1002', '2024021911282483', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021985712625', '772024021985712625', '202024021943992626', '张三', '0', null, '15395136032', '302024021945972511', '', '2024-02-19 07:18:48', '0', '1001', '2024021911282483', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024021988183022', '772024021988183022', null, '吴学文', '0', '1', '18909711443', '30202305221014327189000174', '房产导入', '2024-02-19 10:47:07', '0', '1001', '2023052267100146', '632126199109162056', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024021994213006', '772024021994213006', '202024021984423007', '赵子龙', '0', null, '13800138001', '30202305221014327189000174', '', '2024-02-19 10:46:38', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024022014786019', '772024022014786019', '202024022042576020', 'manman', '1', null, '18523030594', '30202305221014327189000174', '', '2024-02-20 16:14:20', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024022015804609', '772024022015804609', '202024022031354610', '啧啧啧', '0', null, '18234905095', '30202305221014327189000174', '', '2024-02-20 10:13:29', '0', '1001', '2023052267100146', '', '2000', 'T', '1');
INSERT INTO `building_owner` VALUES ('772024022036744590', '772024022036744590', '202024022077974591', '啧啧啧', '0', null, '18888888888', '30202305221014327189000174', '', '2024-02-20 10:11:53', '0', '1001', '2023052267100146', '', '2000', 'T', '1');
INSERT INTO `building_owner` VALUES ('772024022127837095', '772024022127837095', '202024022194507096', '钵钵鸡', '0', null, '18048902312', '30202305221014327189000174', '', '2024-02-21 10:43:22', '0', '1001', '2023052267100146', '', '2000', 'T', '桥洞');
INSERT INTO `building_owner` VALUES ('772024022167516578', '772024022167516578', '202024022154516579', '请1', '0', null, '13095005341', '30202305221014327189000174', '', '2024-02-21 01:39:58', '0', '1001', '2023052267100146', '13095005341', '2000', 'T', '34');
INSERT INTO `building_owner` VALUES ('772024022183707296', '772024022183707296', '202024022147037297', '成龙', '0', null, '13345674567', '30202305221014327189000174', '', '2024-02-21 11:41:31', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024022314930896', '772024022337840891', null, '孙孙', '0', '1', '13100131003', '302024022327600354', '房产导入', '2024-02-23 10:08:25', '0', '1002', '2024022327180323', '111111111111111111', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024022337840891', '772024022337840891', null, '孙权', '0', '1', '13100131002', '302024022327600354', '房产导入', '2024-02-23 10:08:24', '0', '1001', '2024022327180323', '111111111111111111', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024022347790899', '772024022347790899', null, '张飞', '0', '1', '13100131004', '302024022327600354', '房产导入', '2024-02-23 10:08:25', '0', '1001', '2024022327180323', '111111111111111111', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024022363092065', '772024022363092065', '202024022398342066', '陈某人', '0', null, '17317539405', '30202305221014327189000174', '', '2024-02-23 14:03:14', '0', '1001', '2023052267100146', '430281199810137811', '2000', 'T', '株洲');
INSERT INTO `building_owner` VALUES ('772024022364020904', '772024022347790899', null, '赵云', '0', '1', '13100131005', '302024022327600354', '房产导入', '2024-02-23 10:08:25', '0', '1003', '2024022327180323', '111111111111111111', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024022368090883', '772024022368090883', null, '刘备', '0', '1', '13100131000', '302024022327600354', '房产导入', '2024-02-23 10:08:24', '0', '1001', '2024022327180323', '111111111111111111', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024022372580888', '772024022368090883', null, '孙尚香', '1', '1', '13100131001', '302024022327600354', '房产导入', '2024-02-23 10:08:24', '0', '1002', '2024022327180323', '111111111111111111', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024022485623473', '772024022485623473', '202024022483473474', 'zkl', '0', null, '18142583965', '30202305221014327189000174', '', '2024-02-24 10:32:36', '0', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024022624100162', '772024022624100162', '202024022661420163', '孙悟空', '0', null, '13111011002', '302024022634540081', '', '2024-02-26 14:10:30', '0', '1001', '2024022647620054', '111111111111111111', '2000', 'T', '');
INSERT INTO `building_owner` VALUES ('772024022641420195', '772024022641420195', null, '一刀', '0', '1', '15044108708', '302024022695990095', '房产导入', '2024-02-26 14:30:05', '0', '1001', '2024022643710121', '111111111111111111', '2000', 'T', null);
INSERT INTO `building_owner` VALUES ('772024022672020208', '772024022672020208', null, '孙营', '1', '1', '13394444692', '30202305221014327189000174', '房产导入', '2024-02-26 14:14:59', '0', '1001', '2023052267100146', '220381199009196600', '2000', 'T', null);

-- ----------------------------
-- Table structure for building_owner_attr
-- ----------------------------
DROP TABLE IF EXISTS `building_owner_attr`;
CREATE TABLE `building_owner_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `member_id` varchar(30) NOT NULL COMMENT '业主ID',
  `spec_cd` varchar(64) NOT NULL COMMENT '规格ID',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID 分片ID',
  UNIQUE KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of building_owner_attr
-- ----------------------------
INSERT INTO `building_owner_attr` VALUES ('-1', '11202305221015443324000238', '77202305221015438237000234', '081606740011', '', '2023-05-22 10:15:44', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112023063020860072', '772023061990824972', '081606740011', '', '2023-06-30 21:35:45', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112023070643180006', '772023070698490004', '081606740011', 'xx', '2023-07-06 23:04:49', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112023072444300010', '772023063013350054', '081606740011', '', '2023-07-24 11:54:27', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112023073002450014', '772023073065690010', '081606740011', '', '2023-07-30 21:07:24', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112023081951120006', '772023081937110002', '081606740011', '', '2023-08-19 16:03:42', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112023120578390342', '772023120586090338', '081606740011', '', '2023-12-05 18:18:03', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024012224030099', '772024012296540095', '081606740011', '1231256', '2024-01-22 23:18:20', '0', '2024012252790005');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024012244890089', '772024012292610085', '081606740011', '556667788', '2024-01-22 15:08:27', '0', '2024012252790005');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024012259430006', '772024012272180002', '081606740011', '', '2024-01-22 23:27:21', '1', '2024012252790005');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024012287520009', '772024012299410005', '081606740011', '55556667', '2024-01-22 22:42:01', '0', '2024012252790005');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024020561220040', '772024020516840034', '081606740011', '', '2024-02-05 23:36:50', '0', '2024012252790005');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024020893870042', '772024020882790038', '081606740011', '', '2024-02-08 02:03:13', '0', '2023062100700008');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021643710726', '772024021624210722', '081606740011', '', '2024-02-16 16:50:21', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021812371358', '772024021865421354', '081606740011', '', '2024-02-18 08:50:03', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021892511371', '772024021878531367', '081606740011', '', '2024-02-18 08:50:18', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021900993685', '772024021975863681', '081606740011', '2把', '2024-02-19 16:53:23', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021916992965', '772024021903822961', '081606740011', '', '2024-02-19 10:33:00', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021919633053', '772024021942673049', '081606740011', '', '2024-02-19 10:58:34', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021921582629', '772024021985712625', '081606740011', '', '2024-02-19 07:18:48', '0', '2024021911282483');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021929453609', '772024021975893605', '081606740011', '', '2024-02-19 16:32:25', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021957282641', '772024021984292637', '081606740011', '', '2024-02-19 07:19:31', '0', '2024021911282483');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021973452446', '772024021975172442', '081606740011', '', '2024-02-19 06:39:47', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021978863010', '772024021994213006', '081606740011', '', '2024-02-19 10:46:38', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024021984483087', '772024021952223083', '081606740011', '', '2024-02-19 11:02:19', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022004546023', '772024022014786019', '081606740011', '', '2024-02-20 16:14:21', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022016604613', '772024022015804609', '081606740011', '', '2024-02-20 10:13:29', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022067734594', '772024022036744590', '081606740011', '1', '2024-02-20 10:11:54', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022165787300', '772024022183707296', '081606740011', '', '2024-02-21 11:41:31', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022172016582', '772024022167516578', '081606740011', '34', '2024-02-21 01:39:58', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022196847099', '772024022127837095', '081606740011', '', '2024-02-21 10:43:22', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022303242069', '772024022363092065', '081606740011', '', '2024-02-23 14:03:14', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022434683477', '772024022485623473', '081606740011', '', '2024-02-24 10:32:36', '0', '2023052267100146');
INSERT INTO `building_owner_attr` VALUES ('-1', '112024022605810166', '772024022624100162', '081606740011', '', '2024-02-26 14:10:30', '0', '2024022647620054');

-- ----------------------------
-- Table structure for building_owner_room_rel
-- ----------------------------
DROP TABLE IF EXISTS `building_owner_room_rel`;
CREATE TABLE `building_owner_room_rel` (
  `rel_id` varchar(30) NOT NULL COMMENT '关系ID',
  `owner_id` varchar(30) NOT NULL COMMENT '业主ID',
  `room_id` varchar(30) NOT NULL COMMENT '房间ID',
  `b_id` varchar(30) DEFAULT NULL COMMENT '业务ID',
  `state` varchar(4) NOT NULL COMMENT '业务状态 2001 业主未迁入 2002 业主迁入 2003 业主迁出',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，0, 在用 1失效',
  `start_time` datetime NOT NULL COMMENT '起租时间',
  `end_time` datetime NOT NULL COMMENT '起租时间',
  UNIQUE KEY `rel_id` (`rel_id`) USING BTREE,
  UNIQUE KEY `idx_borr_rel_id` (`rel_id`) USING BTREE,
  UNIQUE KEY `idx_orr_rel_id` (`rel_id`) USING BTREE,
  KEY `idx_borr_b_id` (`b_id`) USING BTREE,
  KEY `idx_orr_b_id` (`b_id`) USING BTREE,
  KEY `i_borr_owner_id` (`owner_id`) USING BTREE,
  KEY `i_borr_room_id` (`room_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of building_owner_room_rel
-- ----------------------------
INSERT INTO `building_owner_room_rel` VALUES ('842023120587760351', '772023120586090338', '752023120523340349', '202024021566360445', '2001', '-1', '添加房屋直接绑定', '2023-12-05 18:18:25', '1', '2023-12-05 18:18:25', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024010426520022', '772023120586090338', '752024010438310020', '202024010401030023', '2001', '-1', '添加房屋直接绑定', '2024-01-04 12:50:43', '0', '2024-01-04 12:50:43', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024012231230021', '772024012299410005', '752024012283880019', '202024012239340022', '2001', '-1', '添加房屋直接绑定', '2024-01-22 22:44:49', '0', '2024-01-22 22:44:49', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024012270120095', '772024012292610085', '752024012295280082', '202024012219280097', '2001', '-1', null, '2024-01-22 15:08:44', '0', '2024-01-22 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021626610618', '772024021697820551', '752024021610450528', '202024021640220677', '2001', '-1', 'dd', '2024-02-16 11:57:30', '1', '2024-02-16 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021654810553', '772024021697820551', '752024021610450528', '202024021670630560', '2001', '-1', '', '2024-02-16 10:56:47', '1', '2024-02-16 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021659420718', '772023120586090338', '752024021696970716', '202024021840162074', '2001', '-1', '添加房屋直接绑定', '2024-02-16 16:49:55', '1', '2024-02-16 16:49:55', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021687130678', '772024021697820551', '752024021610450528', '202024021658750680', '2001', '-1', '啊啊啊', '2024-02-16 15:16:17', '0', '2024-02-16 00:00:00', '2024-02-23 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021730461036', '772024021697820551', '752024021691280708', '202024021906663038', '2001', '-1', '', '2024-02-17 13:37:02', '1', '2024-02-17 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021754241039', '772024021697820551', '752024021686490709', '202024021916733036', '2001', '-1', '', '2024-02-17 13:40:39', '1', '2024-02-17 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021803852291', '772024021697820551', '752024021619860527', '202024021849222293', '2001', '-1', null, '2024-02-18 22:22:34', '0', '2024-02-18 22:22:34', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021806082070', '772024021624210722', '752024021696970716', '202024021872002116', '2001', '-1', '签订合同自动绑定', '2024-02-18 21:13:26', '1', '2024-02-18 00:00:00', '2024-02-21 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021815972282', '772024021624210722', '752024021570130194', '202024021858002284', '2001', '-1', null, '2024-02-18 22:20:23', '0', '2024-02-18 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021875682285', '772024021624210722', '752024021696970716', '202024021802072287', '2001', '-1', null, '2024-02-18 22:21:23', '0', '2024-02-18 22:21:23', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021881702288', '772024021697820551', '752023120523340349', '202024021839992290', '2001', '-1', null, '2024-02-18 22:21:59', '0', '2024-02-18 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021911583026', '772024021988183022', '752023120523340349', null, '2001', '30202305221014327189000174', null, '2024-02-19 10:47:07', '0', '2024-02-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021916683742', '772024021975863681', '752024021996573669', '202024021904533744', '2001', '-1', null, '2024-02-19 17:05:45', '0', '2024-02-19 17:05:45', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021923533031', '772024021994213006', '752024021992183029', '202024021900193032', '2001', '-1', '添加房屋直接绑定', '2024-02-19 10:47:57', '0', '2024-02-19 10:47:57', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021924172649', '772024021985712625', '752024021954392622', '202024021911742651', '2001', '-1', null, '2024-02-19 07:20:02', '0', '2024-02-19 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021929954184', '772024021988183022', '752024021996923125', '202024021945804186', '2001', '-1', 'www', '2024-02-19 22:35:51', '0', '2024-02-19 00:00:00', '2024-02-29 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021932582995', '772024021903822961', '752024021954542993', '202024021959952996', '2001', '-1', '添加房屋直接绑定', '2024-02-19 10:44:58', '0', '2024-02-19 10:44:58', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021938943041', '772024021988183022', '752024021963592858', '202024021974743043', '2001', '-1', null, '2024-02-19 10:55:43', '1', '2024-02-19 10:55:43', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021963043629', '772024021975893605', '752024021967653523', '202024021926263631', '2001', '-1', null, '2024-02-19 16:38:12', '0', '2024-02-19 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021963722459', '772024021975172442', '752024021972102457', '202024021941402460', '2001', '-1', '添加房屋直接绑定', '2024-02-19 06:43:17', '0', '2024-02-19 06:43:17', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021980454187', '772024021988183022', '752024021990734183', '202024021914014197', '2001', '-1', 'wwwww', '2024-02-19 22:36:04', '1', '2024-02-19 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024021981774190', '772024021697820551', '752024021686490709', '202024021995184192', '2001', '-1', null, '2024-02-19 22:39:08', '1', '2024-02-19 22:39:08', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022036716531', '772024022014786019', '752024022078176031', '202024022096786533', '2001', '-1', null, '2024-02-20 23:40:29', '1', '2024-02-20 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022053534622', '772024022015804609', '752024021963592858', '202024022000034624', '2001', '-1', null, '2024-02-20 10:15:18', '0', '2024-02-20 10:15:18', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022056714947', '772024022015804609', '752024021990734183', '202024022002954949', '2001', '-1', null, '2024-02-20 11:15:37', '0', '2024-02-20 11:15:37', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022090946033', '772024022014786019', '752024022078176031', '202024022059596530', '2001', '-1', '添加房屋直接绑定', '2024-02-20 16:15:49', '1', '2024-02-20 16:15:49', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022147377307', '772024022183707296', '752024022169007291', '202024022128287309', '2001', '-1', null, '2024-02-21 11:42:16', '0', '2024-02-21 11:42:16', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022192170243', '772024021988183022', '752024022197670241', '202024022113670244', '2001', '-1', '添加房屋直接绑定', '2024-02-21 16:44:40', '0', '2024-02-21 16:44:40', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022192357110', '772024022127837095', '752024022122117085', '202024022183527112', '2001', '-1', null, '2024-02-21 10:43:50', '1', '2024-02-21 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022307860895', '772024022337840891', '752024022320900890', null, '2001', '302024022327600354', null, '2024-02-23 10:08:25', '0', '2024-02-23 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022345600887', '772024022368090883', '752024022347260882', null, '2001', '302024022327600354', null, '2024-02-23 10:08:24', '0', '2024-02-23 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022350812078', '772024022363092065', '752024022240580266', '202024022366552080', '2001', '-1', null, '2024-02-23 14:03:45', '1', '2024-02-23 14:03:45', '2037-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022398220903', '772024022347790899', '752024022397100898', null, '2001', '302024022327600354', null, '2024-02-23 10:08:25', '0', '2024-02-23 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022625730199', '772024022641420195', '752024022663290194', null, '2001', '302024022695990095', null, '2024-02-26 14:30:06', '0', '2024-02-26 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022643440212', '772024022672020208', '752024022665470207', null, '2001', '30202305221014327189000174', null, '2024-02-26 14:15:00', '0', '2024-02-26 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `building_owner_room_rel` VALUES ('842024022733250560', '772024022672020208', '752024022767530558', '202024022783820561', '2001', '-1', '添加房屋直接绑定', '2024-02-27 09:54:56', '0', '2024-02-27 09:54:56', '2037-01-01 00:00:00');

-- ----------------------------
-- Table structure for building_room
-- ----------------------------
DROP TABLE IF EXISTS `building_room`;
CREATE TABLE `building_room` (
  `room_id` varchar(30) NOT NULL COMMENT '房屋ID',
  `b_id` varchar(30) DEFAULT NULL COMMENT '业务ID',
  `room_num` varchar(64) NOT NULL COMMENT '房屋编号',
  `unit_id` varchar(30) NOT NULL COMMENT '单元ID',
  `layer` varchar(12) NOT NULL COMMENT '层数',
  `section` int DEFAULT NULL COMMENT '室',
  `apartment` varchar(20) NOT NULL COMMENT '户型',
  `built_up_area` decimal(12,2) NOT NULL COMMENT '建筑面积',
  `fee_coefficient` decimal(12,2) NOT NULL DEFAULT '1.00' COMMENT '算费系数',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `state` varchar(4) NOT NULL COMMENT '房屋状态，如房屋出售等，请查看state 表',
  `community_id` varchar(30) DEFAULT NULL COMMENT '小区ID',
  `room_type` varchar(12) NOT NULL DEFAULT '1010301' COMMENT '房屋类型',
  `room_sub_type` varchar(12) NOT NULL DEFAULT '110' COMMENT '房屋类型 110 住宅房屋，119 办公室 120 宿舍',
  `room_area` decimal(6,2) NOT NULL COMMENT '室内面积',
  `room_rent` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '租金',
  UNIQUE KEY `room_id` (`room_id`) USING BTREE,
  UNIQUE KEY `idx_room_id` (`room_id`) USING BTREE,
  KEY `idx_room_b_id` (`b_id`) USING BTREE,
  KEY `i_br_unit_id` (`unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of building_room
-- ----------------------------
INSERT INTO `building_room` VALUES ('752023120523340349', '202023120545630350', '1001', '742023120517690335', '1', '1', '10102', '94.56', '1.00', '30202305221014327189000174', '房产导入', '2023-12-05 18:18:25', '0', '2001', '2023052267100146', '1010301', '110', '94.56', '0.00');
INSERT INTO `building_room` VALUES ('752024010438310020', '202024021682610547', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-01-04 12:50:43', '0', '2009', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `building_room` VALUES ('752024012283880019', '202024012210160020', '2003', '742024012295860079', '12', '0', '10102', '100.00', '1.00', '302024012264900032', '', '2024-01-22 22:44:49', '0', '2001', '2024012252790005', '1010301', '110', '100.00', '0.00');
INSERT INTO `building_room` VALUES ('752024012295280082', '202024012207350083', '9009', '742024012295860079', '1', '0', '10102', '100.00', '1.00', '-1', '', '2024-01-22 15:07:45', '0', '2001', '2024012252790005', '1010301', '110', '100.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021561360191', '202024021525530192', '1', '', '1', '0', '10102', '12.00', '1.00', '30202305221014327189000174', '', '2024-02-15 00:57:17', '0', '2002', '2023052267100146', '1010301', '110', '12.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021570130194', '202024021588220195', '3', '742024021514140188', '12', '0', '10102', '121.00', '1.00', '-1', '', '2024-02-15 00:58:09', '0', '2001', '2023052267100146', '1010301', '110', '12.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021610450528', null, '201', '742024021630480526', '2', '1', '10101', '200.00', '1.00', '-1', '啊啊啊', '2024-02-16 09:25:07', '0', '2006', '2023052267100146', '2020602', '120', '190.00', '2000.00');
INSERT INTO `building_room` VALUES ('752024021619860527', null, '101', '742024021630480526', '1', '1', '10101', '200.00', '1.00', '-1', '', '2024-02-16 09:24:53', '0', '2001', '2023052267100146', '2020602', '120', '190.00', '2000.00');
INSERT INTO `building_room` VALUES ('752024021686490709', null, '3-201', '742024021624070707', '2', '1', '10101', '200.00', '1.00', '30202305221014327189000174', '', '2024-02-16 16:22:28', '0', '2008', '2023052267100146', '2020602', '120', '190.00', '2000.00');
INSERT INTO `building_room` VALUES ('752024021691280708', null, '201', '742024021624070707', '2', '1', '10101', '200.00', '1.00', '30202305221014327189000174', '', '2024-02-16 16:22:17', '0', '2008', '2023052267100146', '2020602', '120', '190.00', '2000.00');
INSERT INTO `building_room` VALUES ('752024021696970716', '202024021838912118', '102', '742023120517690335', '1', '0', '10102', '121.56', '0.90', '-1', '', '2024-02-16 16:49:55', '0', '2001', '2023052267100146', '1010301', '110', '121.56', '0.00');
INSERT INTO `building_room` VALUES ('752024021941922619', '202024021990122620', '101', '742024021969492613', '1', '0', '10102', '98.00', '1.00', '302024021945972511', '', '2024-02-19 07:17:49', '0', '2002', '2024021911282483', '1010301', '110', '73.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021954392622', '202024021996972623', '102', '742024021969492613', '1', '0', '10102', '112.00', '1.00', '-1', '', '2024-02-19 07:18:20', '0', '2001', '2024021911282483', '1010301', '110', '96.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021954542993', '202024021938472994', '2', '742023120517690335', '20', '0', '10102', '80.00', '1.00', '30202305221014327189000174', '狗狗2只，中型犬', '2024-02-19 10:44:58', '0', '2001', '2023052267100146', '1010301', '110', '70.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021963592858', null, '110', '742024021974112857', '10', '1', '10101', '120.00', '1.00', '-1', '', '2024-02-19 10:05:35', '0', '2001', '2023052267100146', '2020602', '120', '200.00', '10.00');
INSERT INTO `building_room` VALUES ('752024021967653523', '202024021915153524', '888', '742023120517690335', '1', '0', '10102', '11.00', '1.00', '-1', '', '2024-02-19 16:25:18', '0', '2001', '2023052267100146', '1010301', '110', '11.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021972102457', '202024022086685968', '408', '742024021514140188', '4', '1', '10102', '118.00', '1.00', '30202305221014327189000174', '', '2024-02-19 06:43:16', '0', '2005', '2023052267100146', '1010301', '110', '94.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021990734183', null, '110', '742024021974112857', '6', '1', '10101', '1000.00', '1.00', '-1', 'wwwww', '2024-02-19 22:32:36', '0', '2001', '2023052267100146', '2020602', '120', '500.00', '200.00');
INSERT INTO `building_room` VALUES ('752024021992183029', '202024021977653030', '001', '742023120517690335', '6', '0', '10102', '230.00', '1.00', '30202305221014327189000174', '', '2024-02-19 10:47:57', '0', '2003', '2023052267100146', '1010301', '110', '196.50', '0.00');
INSERT INTO `building_room` VALUES ('752024021996573669', '202024021926523670', '101', '742024021987493003', '1', '0', '10102', '120.00', '1.00', '-1', '', '2024-02-19 16:51:21', '0', '2001', '2023052267100146', '1010301', '110', '110.00', '0.00');
INSERT INTO `building_room` VALUES ('752024021996923125', null, '12345', '742024021974112857', '1', '1', '10101', '1.00', '1.00', '-1', 'www', '2024-02-19 11:04:14', '0', '2006', '2023052267100146', '2020602', '120', '1.00', '1.00');
INSERT INTO `building_room` VALUES ('752024022023145370', null, 'shangpu0001', '742024021630480526', '1', '1', '10101', '80.00', '1.00', '-1', '这是一个测试商铺解绑的小区\n\n', '2024-02-20 14:02:23', '0', '2008', '2023052267100146', '2020602', '120', '80.00', '2000.00');
INSERT INTO `building_room` VALUES ('752024022078176031', '202024022098556032', '20', '742023120517690335', '20', '0', '10102', '120.00', '1.00', '30202305221014327189000174', '', '2024-02-20 16:15:49', '0', '2002', '2023052267100146', '1010301', '110', '110.00', '0.00');
INSERT INTO `building_room` VALUES ('752024022122117085', '202024022599424223', '606', '742023120517690335', '6', '1', '10102', '120.00', '1.00', '30202305221014327189000174', '备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容', '2024-02-21 10:41:47', '0', '2002', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `building_room` VALUES ('752024022169007291', '202024022424053447', '1-1-1', '742024021514140188', '3', '2', '20103', '90.00', '1.00', '30202305221014327189000174', '', '2024-02-21 11:40:50', '0', '2004', '2023052267100146', '1010301', '110', '90.00', '0.00');
INSERT INTO `building_room` VALUES ('752024022175940107', '202024022117890108', '44', '742024022102450236', '8', '0', '10102', '90.00', '1.00', '30202305221014327189000174', '', '2024-02-21 21:41:01', '0', '2002', '2023052267100146', '1010301', '110', '89.00', '0.00');
INSERT INTO `building_room` VALUES ('752024022197670241', '202024022170790242', '101', '742024022102450236', '11', '0', '10102', '111.00', '1.00', '30202305221014327189000174', '', '2024-02-21 16:44:40', '0', '2001', '2023052267100146', '1010301', '110', '111.00', '0.00');
INSERT INTO `building_room` VALUES ('752024022240580266', '202024022208610016', '103', '742024022251010259', '12', '1', '10102', '222.00', '1.00', '30202305221014327189000174', '', '2024-02-22 10:02:39', '0', '2002', '2023052267100146', '1010301', '110', '222.00', '0.00');
INSERT INTO `building_room` VALUES ('752024022246330013', '202024022246930014', '111', '742024022102450236', '12', '0', '10102', '200.00', '1.00', '30202305221014327189000174', '', '2024-02-22 15:26:55', '0', '2002', '2023052267100146', '1010301', '110', '200.00', '0.00');
INSERT INTO `building_room` VALUES ('752024022320900890', null, '1002', '742024022393780881', '1', '1', '10102', '94.56', '1.00', '302024022327600354', '房产导入', '2024-02-23 10:08:24', '0', '2001', '2024022327180323', '1010301', '110', '94.56', '0.00');
INSERT INTO `building_room` VALUES ('752024022347260882', null, '1001', '742024022393780881', '1', '1', '10102', '94.56', '1.00', '302024022327600354', '房产导入', '2024-02-23 10:08:24', '0', '2001', '2024022327180323', '1010301', '110', '94.56', '0.00');
INSERT INTO `building_room` VALUES ('752024022397100898', null, '1011', '742024022393780881', '2', '1', '10102', '94.56', '1.00', '302024022327600354', '房产导入', '2024-02-23 10:08:25', '0', '2001', '2024022327180323', '1010301', '110', '94.56', '0.00');
INSERT INTO `building_room` VALUES ('752024022421753449', '202024022467863450', '301', '742023120517690335', '6', '0', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-24 10:26:07', '0', '2002', '2023052267100146', '1010301', '110', '90.00', '0.00');
INSERT INTO `building_room` VALUES ('752024022663290194', null, '1001', '742024022643970193', '1', '1', '10102', '94.56', '1.00', '302024022695990095', '房产导入', '2024-02-26 14:30:05', '0', '2001', '2024022643710121', '1010301', '110', '94.56', '0.00');
INSERT INTO `building_room` VALUES ('752024022665470207', null, '605', '742024022609170206', '6', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '房产导入', '2024-02-26 14:14:59', '0', '2001', '2023052267100146', '1010301', '110', '94.56', '0.00');
INSERT INTO `building_room` VALUES ('752024022767530558', '202024031154200212', '001', '742024022745010554', '1', '1', '10102', '125.00', '1.00', '30202305221014327189000174', '', '2024-02-27 09:54:56', '0', '2001', '2023052267100146', '1010301', '120', '124.00', '1000.00');
INSERT INTO `building_room` VALUES ('752024022793420263', null, '10-110', '742024021630480526', '12', '1', '10101', '1000.00', '1.00', '-1', 'xxxxx', '2024-02-27 09:09:36', '0', '2008', '2023052267100146', '2020602', '120', '500.00', '600.00');

-- ----------------------------
-- Table structure for building_room_attr
-- ----------------------------
DROP TABLE IF EXISTS `building_room_attr`;
CREATE TABLE `building_room_attr` (
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `room_id` varchar(30) NOT NULL COMMENT '房屋ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  UNIQUE KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `idx_b_attr_b_id` (`b_id`) USING BTREE,
  KEY `idx_attr_room_id` (`room_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of building_room_attr
-- ----------------------------

-- ----------------------------
-- Table structure for building_unit
-- ----------------------------
DROP TABLE IF EXISTS `building_unit`;
CREATE TABLE `building_unit` (
  `unit_id` varchar(30) NOT NULL COMMENT '单元ID',
  `b_id` varchar(30) DEFAULT NULL COMMENT '业务ID',
  `unit_num` varchar(12) NOT NULL COMMENT '单元编号',
  `floor_id` varchar(30) NOT NULL COMMENT '楼ID',
  `layer_count` int NOT NULL COMMENT '总层数',
  `lift` varchar(4) NOT NULL COMMENT '是否有电梯 1010有 2020 无',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  `unit_area` decimal(10,2) NOT NULL COMMENT '单元面积',
  UNIQUE KEY `unit_id` (`unit_id`) USING BTREE,
  UNIQUE KEY `idx_unit_id` (`unit_id`) USING BTREE,
  UNIQUE KEY `unit_id_2` (`unit_id`),
  KEY `idx_unit_b_id` (`b_id`) USING BTREE,
  KEY `i_bu_floor_id` (`floor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of building_unit
-- ----------------------------
INSERT INTO `building_unit` VALUES ('742023120517690335', null, '1', '732023120568080332', '33', '1010', '30202305221014327189000174', '房产导入', '2023-12-05 18:17:45', '0', '1.00');
INSERT INTO `building_unit` VALUES ('742024012295860079', null, '3', '732024012265490076', '33', '1010', '302024012264900032', '', '2024-01-22 15:07:18', '0', '1000.00');
INSERT INTO `building_unit` VALUES ('742024021514140188', null, '2', '732023120568080332', '11', '1010', '30202305221014327189000174', '', '2024-02-15 00:55:20', '0', '12.00');
INSERT INTO `building_unit` VALUES ('742024021624070707', null, '0', '732024021543990184', '31', '0', '-1', '系统创建', '2024-02-16 16:22:17', '0', '1.00');
INSERT INTO `building_unit` VALUES ('742024021630480526', null, '0', '732023120568080332', '31', '0', '-1', '系统创建', '2024-02-16 09:24:53', '0', '1.00');
INSERT INTO `building_unit` VALUES ('742024021933922616', null, '2', '732024021926182608', '34', '1010', '302024021945972511', '', '2024-02-19 07:16:39', '0', '123000.00');
INSERT INTO `building_unit` VALUES ('742024021969492613', null, '1', '732024021926182608', '34', '1010', '302024021945972511', '', '2024-02-19 07:16:25', '0', '12300.00');
INSERT INTO `building_unit` VALUES ('742024021974112857', null, '0', '732024021518860179', '31', '0', '-1', '系统创建', '2024-02-19 10:05:35', '0', '1.00');
INSERT INTO `building_unit` VALUES ('742024021987493003', null, '3', '732023120568080332', '64', '1010', '30202305221014327189000174', '', '2024-02-19 10:46:06', '0', '1111.00');
INSERT INTO `building_unit` VALUES ('742024022102450236', null, '1', '732024021518860179', '11', '1010', '30202305221014327189000174', '', '2024-02-21 16:43:48', '0', '111.00');
INSERT INTO `building_unit` VALUES ('742024022154957660', null, '555', '732023120568080332', '10', '1010', '30202305221014327189000174', '随便添加一个', '2024-02-21 14:50:49', '1', '500.00');
INSERT INTO `building_unit` VALUES ('742024022251010259', null, '1', '732024022269670256', '27', '1010', '30202305221014327189000174', '', '2024-02-22 10:02:17', '0', '500.00');
INSERT INTO `building_unit` VALUES ('742024022393780881', null, '1', '732024022342800880', '10', '1010', '302024022327600354', '房产导入', '2024-02-23 10:08:23', '0', '1.00');
INSERT INTO `building_unit` VALUES ('742024022609170206', null, '3', '732024022624170205', '11', '1010', '30202305221014327189000174', '房产导入', '2024-02-26 14:14:59', '0', '1.00');
INSERT INTO `building_unit` VALUES ('742024022643970193', null, '1', '732024022672450192', '33', '1010', '302024022695990095', '房产导入', '2024-02-26 14:30:04', '0', '1.00');
INSERT INTO `building_unit` VALUES ('742024022745010554', null, '001', '732024022724560551', '10', '1010', '30202305221014327189000174', '', '2024-02-27 09:53:34', '0', '10424.00');

-- ----------------------------
-- Table structure for building_unit_attr
-- ----------------------------
DROP TABLE IF EXISTS `building_unit_attr`;
CREATE TABLE `building_unit_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `unit_id` varchar(30) NOT NULL COMMENT '房屋ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，S 保存，0, 在用 1失效',
  PRIMARY KEY (`attr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of building_unit_attr
-- ----------------------------

-- ----------------------------
-- Table structure for buiness_small_wechat
-- ----------------------------
DROP TABLE IF EXISTS `buiness_small_wechat`;
CREATE TABLE `buiness_small_wechat` (
  `wechat_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '微信ID',
  `b_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '业务ID',
  `store_Id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '商户ID',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '小程序名称',
  `appId` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '小程序appid',
  `appSecret` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '应用密钥',
  `pay_password` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '支付密码',
  `remarks` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `obj_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `obj_type` varchar(4) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `mch_id` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `wechat_type` varchar(4) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `cert_path` varchar(512) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '证书地址',
  `mch_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '无' COMMENT '商户名称'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of buiness_small_wechat
-- ----------------------------

-- ----------------------------
-- Table structure for business_account
-- ----------------------------
DROP TABLE IF EXISTS `business_account`;
CREATE TABLE `business_account` (
  `acct_id` varchar(30) NOT NULL COMMENT '账户ID',
  `acct_name` varchar(128) NOT NULL COMMENT '账户名称',
  `acct_type` varchar(12) NOT NULL COMMENT '账户类型，2003 现金账户 2004 积分账户 2005 优惠券账户',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `obj_type` varchar(12) NOT NULL COMMENT '对象类型，6006 个人 7007 商户',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `part_id` varchar(30) DEFAULT NULL COMMENT '局部ID',
  `link` varchar(11) DEFAULT NULL COMMENT '账户手机号'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_account
-- ----------------------------

-- ----------------------------
-- Table structure for business_account_detail
-- ----------------------------
DROP TABLE IF EXISTS `business_account_detail`;
CREATE TABLE `business_account_detail` (
  `detail_id` varchar(30) NOT NULL COMMENT '明细ID',
  `acct_id` varchar(30) NOT NULL COMMENT '账户ID',
  `detail_type` varchar(128) NOT NULL COMMENT '类型，1001 转入 2002 转出',
  `rel_acct_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '关联账户',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `obj_type` varchar(12) NOT NULL COMMENT '对象类型，6006 个人 7007 商户',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID',
  `order_id` varchar(30) NOT NULL COMMENT '交易单号',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `remark` varchar(1024) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_account_detail
-- ----------------------------

-- ----------------------------
-- Table structure for business_activities
-- ----------------------------
DROP TABLE IF EXISTS `business_activities`;
CREATE TABLE `business_activities` (
  `activities_id` varchar(30) NOT NULL COMMENT '活动ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `title` varchar(200) NOT NULL COMMENT '活动标题',
  `type_cd` varchar(30) NOT NULL COMMENT '文章类型',
  `header_img` varchar(200) NOT NULL COMMENT '头部照片,照片名称',
  `context` longtext NOT NULL COMMENT '活动内容',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `read_count` int NOT NULL DEFAULT '0' COMMENT '阅读数',
  `like_count` int NOT NULL DEFAULT '0' COMMENT '点赞数',
  `collect_count` int NOT NULL DEFAULT '0' COMMENT '收藏数',
  `user_id` varchar(30) NOT NULL COMMENT '创建用户Id',
  `user_name` varchar(30) NOT NULL COMMENT '创建用户名称',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `state` varchar(12) NOT NULL DEFAULT '10000' COMMENT '审核状态，10000 待审核 ，11000 审核完成 12000 审核失败',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_activities_id` (`activities_id`) USING BTREE,
  KEY `idx_business_activities_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_activities
-- ----------------------------

-- ----------------------------
-- Table structure for business_activities_event
-- ----------------------------
DROP TABLE IF EXISTS `business_activities_event`;
CREATE TABLE `business_activities_event` (
  `event_id` varchar(30) NOT NULL COMMENT '事件ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `activities_id` varchar(30) NOT NULL COMMENT '活动ID',
  `event_type_cd` varchar(12) NOT NULL COMMENT '事件类型，999999阅读，888888 收藏 777777 点赞',
  `user_id` varchar(30) NOT NULL COMMENT '人员ID',
  `user_name` varchar(30) NOT NULL COMMENT '人员名称',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_activities_event
-- ----------------------------

-- ----------------------------
-- Table structure for business_advert
-- ----------------------------
DROP TABLE IF EXISTS `business_advert`;
CREATE TABLE `business_advert` (
  `advert_id` varchar(30) NOT NULL COMMENT '广告ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `ad_name` varchar(200) NOT NULL COMMENT '广告名称',
  `ad_type_cd` varchar(12) NOT NULL COMMENT '广告类型,门禁机 10000',
  `classify` varchar(12) NOT NULL COMMENT '广告分类 9001 物流 9002 餐饮 9003 旅游 9004 酒店 9005 教育 9006 互联网',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID,主要用来做分片',
  `location_type_cd` varchar(12) NOT NULL DEFAULT '1000' COMMENT '位置类型，1000 大门 2000 单元门 3000 房屋门 4000 楼栋',
  `location_obj_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '对象ID，大门时小区ID，单元门 时单元ID 房屋时房屋ID，楼栋时 楼栋ID',
  `state` varchar(12) NOT NULL DEFAULT '1000' COMMENT '广告状态，1000 未审核 2000 审核通过 3000 审核拒绝 4000 未播放 5000 播放中',
  `seq` int NOT NULL DEFAULT '1' COMMENT '播放顺序',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `view_type` varchar(12) NOT NULL COMMENT '广告类型 8888 图片 9999 视频',
  `advert_type` varchar(2) DEFAULT '3' COMMENT '发布类型\r\n1站内\r\n2站外\r\n3不跳转',
  `page_url` varchar(200) DEFAULT NULL COMMENT '路径'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_advert
-- ----------------------------

-- ----------------------------
-- Table structure for business_advert_item
-- ----------------------------
DROP TABLE IF EXISTS `business_advert_item`;
CREATE TABLE `business_advert_item` (
  `advert_item_id` varchar(30) NOT NULL COMMENT '广告ID',
  `b_id` varchar(30) DEFAULT '-1' COMMENT '业务ID',
  `advert_id` varchar(200) NOT NULL COMMENT '广告名称',
  `item_type_cd` varchar(12) NOT NULL COMMENT '8888 图片 9999 视频',
  `url` varchar(200) NOT NULL COMMENT '图片或视频地址',
  `community_id` varchar(30) DEFAULT NULL COMMENT '小区ID,主要用来做分片',
  `seq` int NOT NULL DEFAULT '1' COMMENT '播放顺序',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_advert_item
-- ----------------------------

-- ----------------------------
-- Table structure for business_allocation_storehouse
-- ----------------------------
DROP TABLE IF EXISTS `business_allocation_storehouse`;
CREATE TABLE `business_allocation_storehouse` (
  `as_id` varchar(30) NOT NULL COMMENT '调拨ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `sh_id_a` varchar(30) NOT NULL COMMENT '前仓库ID',
  `sh_id_z` varchar(30) NOT NULL COMMENT '后仓库ID',
  `res_id` varchar(30) NOT NULL COMMENT '物品ID',
  `res_name` varchar(100) NOT NULL COMMENT '物品名称',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `stock` varchar(100) DEFAULT NULL COMMENT '库存数',
  `start_user_id` varchar(30) NOT NULL COMMENT '申请人',
  `start_user_name` varchar(64) NOT NULL COMMENT '申请人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `remark` varchar(1024) DEFAULT NULL COMMENT '调拨说明',
  `apply_id` varchar(30) NOT NULL COMMENT '申请ID',
  `original_stock` varchar(100) DEFAULT NULL COMMENT '原有库存'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_allocation_storehouse
-- ----------------------------

-- ----------------------------
-- Table structure for business_allocation_storehouse_apply
-- ----------------------------
DROP TABLE IF EXISTS `business_allocation_storehouse_apply`;
CREATE TABLE `business_allocation_storehouse_apply` (
  `apply_id` varchar(30) NOT NULL COMMENT '主键ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `start_user_id` varchar(30) NOT NULL COMMENT '申请人',
  `start_user_name` varchar(64) NOT NULL COMMENT '申请人',
  `remark` varchar(1024) NOT NULL COMMENT '申请说明',
  `apply_count` varchar(100) NOT NULL DEFAULT '1' COMMENT '调拨数量',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `state` varchar(12) NOT NULL COMMENT '状态',
  `apply_type` varchar(8) DEFAULT NULL COMMENT '调拨返还类型 10000 调拨 20000 返还 在t_dict表查看',
  `community_id` varchar(200) NOT NULL COMMENT '申请人小区id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_allocation_storehouse_apply
-- ----------------------------

-- ----------------------------
-- Table structure for business_allocation_user_storehouse
-- ----------------------------
DROP TABLE IF EXISTS `business_allocation_user_storehouse`;
CREATE TABLE `business_allocation_user_storehouse` (
  `aus_id` varchar(30) NOT NULL COMMENT '转增ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `res_id` varchar(30) NOT NULL COMMENT '资源ID',
  `res_name` varchar(100) NOT NULL COMMENT '物品名称',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `stock` varchar(100) NOT NULL COMMENT '现有库存数',
  `give_quantity` varchar(100) NOT NULL COMMENT '转赠数量',
  `start_user_id` varchar(30) NOT NULL COMMENT '申请人userId',
  `start_user_name` varchar(64) NOT NULL COMMENT '申请人用户名',
  `accept_user_id` varchar(30) NOT NULL COMMENT '接受人userId',
  `accept_user_name` varchar(64) NOT NULL COMMENT '接受人用户名',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  `remark` varchar(512) DEFAULT NULL COMMENT '转增说明',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_allocation_user_storehouse
-- ----------------------------

-- ----------------------------
-- Table structure for business_application_key
-- ----------------------------
DROP TABLE IF EXISTS `business_application_key`;
CREATE TABLE `business_application_key` (
  `application_key_id` varchar(30) NOT NULL COMMENT '申请ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `type_cd` varchar(12) NOT NULL COMMENT '类型，10001 保洁 10002 保安 10003 其他人员，详情查看t_dict表',
  `name` varchar(64) NOT NULL COMMENT '申请人名称',
  `tel` varchar(12) NOT NULL COMMENT '申请人手机号码',
  `sex` varchar(12) NOT NULL COMMENT '申请人男女  0男 1女',
  `age` int NOT NULL COMMENT '申请人年龄',
  `id_card` varchar(20) NOT NULL COMMENT '申请人身份证号',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `state` varchar(8) NOT NULL COMMENT '状态，10002 未审核,10001 完成审核 10003 审核拒绝',
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '开始时间',
  `end_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `type_flag` varchar(12) NOT NULL COMMENT '人脸申请1100101 固定密码申请 1100102 临时密码 1100103',
  `pwd` varchar(12) NOT NULL COMMENT '密码'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_application_key
-- ----------------------------

-- ----------------------------
-- Table structure for business_apply_room_discount
-- ----------------------------
DROP TABLE IF EXISTS `business_apply_room_discount`;
CREATE TABLE `business_apply_room_discount` (
  `ard_id` varchar(30) NOT NULL COMMENT '主键ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `room_id` varchar(30) NOT NULL COMMENT '房屋id',
  `room_name` varchar(64) NOT NULL COMMENT '房屋名称',
  `discount_id` varchar(30) DEFAULT NULL COMMENT '折扣id',
  `apply_type` varchar(30) NOT NULL COMMENT '申请类型',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_user_name` varchar(64) NOT NULL COMMENT '创建人',
  `create_user_tel` varchar(11) NOT NULL COMMENT '创建手机号',
  `check_user_id` varchar(30) DEFAULT NULL COMMENT '验房人',
  `review_user_id` varchar(30) DEFAULT NULL COMMENT '通过人',
  `state` varchar(12) NOT NULL DEFAULT '0' COMMENT '审核状态: 1申请验房2验房通过3验房不通过 4审批通过5审批不通过',
  `create_remark` varchar(512) DEFAULT NULL COMMENT '申请信息',
  `check_remark` varchar(512) DEFAULT NULL COMMENT '验房备注信息',
  `review_remark` varchar(512) DEFAULT NULL COMMENT '通过备注信息',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态0正常1失效',
  `in_use` varchar(2) NOT NULL COMMENT '是否可用 0表示可用；1表示不可用',
  `operate` varchar(4) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `fee_id` varchar(30) DEFAULT NULL,
  `return_way` varchar(4) DEFAULT NULL COMMENT '返还方式1001折扣1002账户余额',
  `return_amount` varchar(255) DEFAULT NULL COMMENT '返还金额',
  PRIMARY KEY (`ard_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_apply_room_discount
-- ----------------------------

-- ----------------------------
-- Table structure for business_apply_room_discount_record
-- ----------------------------
DROP TABLE IF EXISTS `business_apply_room_discount_record`;
CREATE TABLE `business_apply_room_discount_record` (
  `ardr_id` varchar(30) NOT NULL COMMENT '空置房验房跟踪记录id',
  `ard_id` varchar(30) NOT NULL COMMENT '空置房申请id',
  `b_id` varchar(30) NOT NULL COMMENT '业务id',
  `community_id` varchar(30) NOT NULL COMMENT '小区id',
  `status_cd` varchar(2) NOT NULL COMMENT '数据状态，0, 在用 1失效',
  `create_user_id` varchar(30) NOT NULL COMMENT '创建用户的id',
  `create_user_name` varchar(255) NOT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `is_true` varchar(10) NOT NULL COMMENT '是否违规  true 是   false 否',
  `state` varchar(12) NOT NULL DEFAULT '0' COMMENT '''审核状态: 1申请验房2验房通过3验房不通过 4审批通过5审批不通过''',
  PRIMARY KEY (`ardr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_apply_room_discount_record
-- ----------------------------

-- ----------------------------
-- Table structure for business_attendance_classes
-- ----------------------------
DROP TABLE IF EXISTS `business_attendance_classes`;
CREATE TABLE `business_attendance_classes` (
  `classes_id` varchar(30) NOT NULL COMMENT '班次ID',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `classes_name` varchar(100) NOT NULL COMMENT '班级名称',
  `time_offset` int NOT NULL COMMENT '允许打卡范围，单位为分钟',
  `clock_count` int NOT NULL DEFAULT '2' COMMENT '打卡次数 默认为 2 次 4 次 6次',
  `clock_type` varchar(12) NOT NULL DEFAULT '1001' COMMENT '打卡类型，1001 每天打卡 1002 隔天打卡 1003 自定义',
  `clock_type_value` varchar(12) NOT NULL COMMENT '打卡规则，* 每天打卡 ? 隔天打卡 0-6组成逗号分隔 自定义',
  `late_offset` int NOT NULL DEFAULT '60' COMMENT '迟到时间范围，超过改时间即为旷工',
  `leave_offset` int NOT NULL DEFAULT '60' COMMENT '早退时间范围，超过改时间即为旷工',
  `classes_obj_type` varchar(12) NOT NULL COMMENT '考勤对象类型，1001 集团公司 1002 分公司 1003 部门 1004 个人',
  `classes_obj_id` varchar(30) NOT NULL COMMENT '考勤对象ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `classes_obj_name` varchar(64) NOT NULL COMMENT '考勤对象名称'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_attendance_classes
-- ----------------------------

-- ----------------------------
-- Table structure for business_attendance_classes_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_attendance_classes_attr`;
CREATE TABLE `business_attendance_classes_attr` (
  `attr_id` varchar(64) NOT NULL COMMENT '班次属性',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `classes_id` varchar(64) NOT NULL COMMENT '班次ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '班次规格ID',
  `value` varchar(100) NOT NULL COMMENT '班次值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_attendance_classes_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_audit_user
-- ----------------------------
DROP TABLE IF EXISTS `business_audit_user`;
CREATE TABLE `business_audit_user` (
  `audit_user_id` varchar(30) NOT NULL COMMENT '审核ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID,用来做分区',
  `user_id` varchar(100) NOT NULL COMMENT '审核用户ID',
  `user_name` varchar(100) NOT NULL COMMENT '审核用户名称',
  `audit_link` varchar(64) NOT NULL COMMENT '审核环节，建t_dict表 如部门经理审核 ， 财务审核 ，采购人员采购',
  `obj_code` varchar(64) NOT NULL COMMENT '流程对象编码,如采购申请 resource_enter',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_audit_user
-- ----------------------------

-- ----------------------------
-- Table structure for business_building_owner
-- ----------------------------
DROP TABLE IF EXISTS `business_building_owner`;
CREATE TABLE `business_building_owner` (
  `member_id` varchar(30) NOT NULL COMMENT '业主成员ID',
  `owner_id` varchar(30) NOT NULL COMMENT '业主ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `name` varchar(64) NOT NULL COMMENT '业主名称',
  `sex` varchar(12) NOT NULL COMMENT '性别',
  `age` varchar(12) DEFAULT NULL COMMENT '年龄',
  `link` varchar(11) NOT NULL COMMENT '联系人手机号',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `owner_type_cd` varchar(4) NOT NULL DEFAULT '1001' COMMENT '1001 业主本人 1002 家庭成员',
  `community_id` varchar(30) DEFAULT NULL COMMENT '小区ID',
  `id_card` varchar(18) DEFAULT '-1' COMMENT '身份证号码',
  `state` varchar(12) NOT NULL DEFAULT '2000' COMMENT '业主 成员状态 1000 表示待审核，2000 审核完成  3000 拒绝审核 ',
  `owner_flag` varchar(12) NOT NULL DEFAULT 'T' COMMENT '业主标识 T是真实业主 F 是虚拟业主',
  `address` varchar(255) DEFAULT NULL COMMENT '家庭住址',
  KEY `idx_business_owner_id` (`member_id`) USING BTREE,
  KEY `idx_business_owner_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_building_owner
-- ----------------------------
INSERT INTO `business_building_owner` VALUES ('77202305221015438237000234', '77202305221015438237000234', '202023052220830235', '张三', '0', null, '18909714526', '30202305221014327189000174', null, '2023-05-22 10:15:43', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772023061990824972', '772023061990824972', '202023063039480071', '吴学文30', '0', '1', '18909711472', '30202305221014327189000174', '房产导入', '2023-06-30 21:35:44', 'DEL', '1001', '2023052267100146', '632126199109162057', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023061990824972', '772023061990824972', '202023063039480071', '吴学文30', '0', '1', '18909711472', '30202305221014327189000174', '房产导入', '2023-06-30 21:35:44', 'ADD', '1001', '2023052267100146', '632126199109162033', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023063013350054', '772023063013350054', '202023072415190007', 'qq1', '0', '1', '18109711443', '30202305221014327189000174', '房产导入', '2023-07-24 11:54:26', 'DEL', '1001', '2023052267100146', '632136199109162056', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023063013350054', '772023063013350054', '202023072415190007', 'qq2', '0', '1', '18109711443', '30202305221014327189000174', '房产导入', '2023-07-24 11:54:26', 'ADD', '1001', '2023052267100146', '632136199109162056', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023073065690010', '772023073065690010', '202023073034290011', 'xx', '0', null, '18909715252', '30202305221014327189000174', null, '2023-07-30 21:07:24', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772023073065690010', '772023073065690010', '202023073020260022', 'xx', '0', '', '18909715252', '30202305221014327189000174', '', '2023-07-30 21:07:39', 'DEL', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023073065690010', '772023073065690010', '202023073020260022', 'xx2', '0', '', '18909715252', '30202305221014327189000174', '', '2023-07-30 21:07:39', 'ADD', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023081937110002', '772023073065690010', '202023081903390003', 'rr', '0', null, '18909714569', '30202305221014327189000174', null, '2023-08-19 16:03:42', 'ADD', '1002', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772023091790110005', '77202305221015438237000234', '202023091733350006', '娃哈哈', '0', null, '18909711235', '30202305221014327189000174', '测试', '2023-09-17 12:23:36', 'ADD', '1002', '2023052267100146', '-1', '2000', 'T', '中国');
INSERT INTO `business_building_owner` VALUES ('772023081937110002', '772023073065690010', '202023091713620006', 'rr', '0', '', '18909714569', '30202305221014327189000174', '', '2023-09-17 12:44:52', 'DEL', '1002', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023081937110002', '772023073065690010', '202023091713620006', 'rr', '0', '', '18909714569', '30202305221014327189000174', '', '2023-09-17 12:44:52', 'ADD', '1002', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '77202305221015438237000234', '202023091882950011', '张贝贝', '0', null, '18909714586', '30202305221014327189000174', null, '2023-09-18 23:56:08', 'ADD', '1002', '2023052267100146', '-1', '2000', 'T', '测试');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '77202305221015438237000234', '202023091941590025', '张贝贝', '0', '', '18909714586', '30202305221014327189000174', '', '2023-09-19 00:04:55', 'DEL', '1002', '2023052267100146', '', '2000', 'T', '测试');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '772023091853820010', '202023091941590025', '张贝贝1', '0', '', '18909714589', '30202305221014327189000174', '', '2023-09-19 00:04:55', 'ADD', '1002', '2023052267100146', '', '2000', 'T', '测试');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '772023091853820010', '202023091920840030', '张贝贝1', '0', '', '18909714589', '30202305221014327189000174', '', '2023-09-19 00:05:33', 'DEL', '1002', '2023052267100146', '', '2000', 'T', '测试');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '772023091853820010', '202023091920840030', '张贝贝1', '0', '', '18909714589', '30202305221014327189000174', '', '2023-09-19 00:05:33', 'ADD', '1002', '2023052267100146', '', '2000', 'T', '测试');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '772023091853820010', '202023091948260034', '张贝贝1', '0', '', '18909714589', '30202305221014327189000174', '', '2023-09-19 00:05:45', 'DEL', '1002', '2023052267100146', '', '2000', 'T', '测试');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '772023091853820010', '202023091948260034', '张贝贝1', '0', '', '18909714586', '30202305221014327189000174', '', '2023-09-19 00:05:45', 'ADD', '1002', '2023052267100146', '', '2000', 'T', '测试');
INSERT INTO `business_building_owner` VALUES ('772023073065690010', '772023073065690010', '202023092828480011', 'xx2', '0', '', '18909715252', '30202305221014327189000174', '', '2023-09-28 05:34:19', 'DEL', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023073065690010', '772023073065690010', '202023092828480011', 'xx24', '0', '', '18909715252', '30202305221014327189000174', '', '2023-09-28 05:34:19', 'ADD', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023102094720002', '772023063013350054', '202023102050400003', '张菲菲', '0', '10', '18909714523', '302023101689730005', null, '2023-10-20 09:18:24', 'ADD', '1002', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772023102094720002', '772023063013350054', '202023102001980002', '张菲菲', '0', '10', '18909714523', '302023101689730005', '', '2023-10-20 09:39:18', 'DEL', '1002', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023102094720002', '772023063013350054', '202023102001980002', '张菲菲', '0', '10', '18909714523', '302023101689730005', '', '2023-10-20 09:39:18', 'ADD', '1002', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023073065690010', '772023073065690010', '202023111408130496', 'xx24', '0', '', '18909715252', '30202305221014327189000174', '', '2023-11-14 14:45:08', 'DEL', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772023073065690010', '772023073065690010', '202023111408130496', 'xx24', '0', '', '18909715252', '30202305221014327189000174', '', '2023-11-14 14:45:08', 'ADD', '1001', '2023052267100146', '632126199109162011', '2000', 'T', '无');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '772023091853820010', '202023111482140499', '张贝贝1', '0', '', '18909714586', '30202305221014327189000174', '', '2023-11-14 14:55:52', 'DEL', '1002', '2023052267100146', '', '2000', 'T', '测试');
INSERT INTO `business_building_owner` VALUES ('772023091853820010', '772023091853820010', '202023111482140499', '张贝贝1', '0', '', '18909714586', '30202305221014327189000174', '', '2023-11-14 14:55:52', 'ADD', '1002', '2023052267100146', '', '2000', 'T', '测试2');
INSERT INTO `business_building_owner` VALUES ('772023091790110005', '77202305221015438237000234', '202023111440930502', '娃哈哈', '0', '', '18909711235', '30202305221014327189000174', '测试', '2023-11-14 15:05:42', 'DEL', '1002', '2023052267100146', '', '2000', 'T', '中国');
INSERT INTO `business_building_owner` VALUES ('772023091790110005', '77202305221015438237000234', '202023111440930502', '娃哈哈', '0', '', '18909711235', '30202305221014327189000174', '测试', '2023-11-14 15:05:42', 'ADD', '1002', '2023052267100146', '', '2000', 'T', '中国1');
INSERT INTO `business_building_owner` VALUES ('772023120586090338', '772023120586090338', '202023120535210339', '吴学文', '0', null, '18109711443', '30202305221014327189000174', null, '2023-12-05 18:18:03', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024012292610085', '772024012292610085', '202024012290330086', '同步业主', '0', null, '18975756565', '302024012264900032', null, '2024-01-22 15:08:26', 'ADD', '1001', '2024012252790005', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024012299290006', '张飞', '0', null, '18922224444', '302024012264900032', null, '2024-01-22 22:42:01', 'ADD', '1001', '2024012252790005', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024012291010025', '张飞', '0', '', '18922224444', '302024012264900032', '', '2024-01-22 22:45:16', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024012291010025', '张飞1', '0', '', '18922224444', '302024012264900032', '', '2024-01-22 22:45:16', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024012263960096', '死三八', '0', null, '15666665555', '302024012264900032', null, '2024-01-22 23:18:19', 'ADD', '1001', '2024012252790005', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024012249360108', '死三八', '0', '', '15666665555', '302024012264900032', '', '2024-01-22 23:18:39', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024012249360108', '死三八', '0', '', '15666665555', '302024012264900032', '', '2024-01-22 23:18:39', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024012299180113', '死三八', '0', '', '15666665555', '302024012264900032', '', '2024-01-22 23:18:51', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024012299180113', '死三八', '0', '', '15666665555', '302024012264900032', '', '2024-01-22 23:18:51', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012272180002', '772024012272180002', '202024012254710003', '死三八1', '0', null, '15666665556', '302024012264900032', null, '2024-01-22 23:27:20', 'ADD', '1001', '2024012252790005', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024012272180002', '772024012272180002', '202024012262040014', '死三八1', '0', '', '15666665556', '302024012264900032', '', '2024-01-22 23:27:39', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012272180002', '772024012272180002', '202024012262040014', '死三八1', '0', '', '15666665556', '302024012264900032', '', '2024-01-22 23:27:39', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012272180002', '772024012272180002', '202024012212520002', '死三八1', '0', '', '15666665556', '302024012264900032', '', '2024-01-22 23:39:01', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012272180002', '772024012272180002', '202024012212520002', '死三八1', '0', '', '15666665556', '302024012264900032', '', '2024-01-22 23:39:01', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024012304070003', '张飞1', '0', '', '18922224444', '302024012264900032', '', '2024-01-23 00:17:39', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024012304070003', '张飞2', '0', '', '18922224444', '302024012264900032', '', '2024-01-23 00:17:39', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024012317050002', '死三八', '0', '', '15666665555', '302024012264900032', '', '2024-01-23 00:29:00', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024012317050002', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-01-23 00:29:00', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024012384510014', '张飞2', '0', '', '18922224444', '302024012264900032', '', '2024-01-23 00:33:04', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024012384510014', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-01-23 00:33:04', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020513730055', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-05 15:39:52', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020513730055', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-05 15:39:52', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020557840067', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-05 15:47:49', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020557840067', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-05 15:47:49', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020527150003', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-05 16:05:20', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020527150003', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-05 16:05:20', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024020519640022', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-02-05 22:06:54', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024020519640022', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-02-05 22:06:54', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024020516840034', '772024012296540095', '202024020573570035', '成员张三', '0', null, '18909714523', '302024012264900032', null, '2024-02-05 23:36:50', 'ADD', '1002', '2024012252790005', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024020516840034', '772024012296540095', '202024020520790002', '成员张三', '0', '', '18909714523', '302024012264900032', '', '2024-02-05 23:50:26', 'DEL', '1002', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024020516840034', '772024012296540095', '202024020520790002', '成员张三', '0', '', '18909714523', '302024012264900032', '', '2024-02-05 23:50:26', 'ADD', '1002', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020677860016', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-06 00:36:27', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020677860016', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-06 00:36:27', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024020629310026', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-02-06 00:36:35', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024020629310026', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-02-06 00:36:35', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024020653000037', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-02-06 00:37:20', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024020653000037', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-02-06 00:37:20', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020656220048', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-06 00:42:10', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020656220048', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-06 00:42:10', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024020613270058', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-02-06 01:02:38', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012299410005', '772024012299410005', '202024020613270058', '张飞3', '0', '', '18922224444', '302024012264900032', '', '2024-02-06 01:02:38', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020669980003', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-06 02:21:10', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012296540095', '772024012296540095', '202024020669980003', '死三八1', '0', '', '15666665555', '302024012264900032', '', '2024-02-06 02:21:10', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012292610085', '772024012292610085', '202024020674280017', '同步业主', '0', '', '18975756565', '302024012264900032', '', '2024-02-06 02:22:56', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012292610085', '772024012292610085', '202024020674280017', '同步业主', '0', '', '18975756565', '302024012264900032', '', '2024-02-06 02:22:56', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012292610085', '772024012292610085', '202024020606890032', '同步业主', '0', '', '18975756565', '302024012264900032', '', '2024-02-06 11:24:58', 'DEL', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024012292610085', '772024012292610085', '202024020606890032', '同步业主', '0', '', '18975756565', '302024012264900032', '', '2024-02-06 11:24:58', 'ADD', '1001', '2024012252790005', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024020882790038', '772024020882790038', '202024020842430039', '123', '0', null, '15696522323', '302024012264900032', null, '2024-02-08 02:03:12', 'ADD', '1001', '2023062100700008', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021624210722', '772024021624210722', '202024021666020723', '李春丽', '1', null, '13111111111', '30202305221014327189000174', null, '2024-02-16 16:50:21', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021624210722', '772024021624210722', '202024021647120738', '李春丽', '1', '', '13111111111', '30202305221014327189000174', '', '2024-02-16 16:51:54', 'DEL', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024021624210722', '772024021624210722', '202024021647120738', '李丽', '1', '', '13111111111', '30202305221014327189000174', '', '2024-02-16 16:51:54', 'ADD', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024021865421354', '772024021624210722', '202024021841141355', '测试1', '0', null, '18900000000', '30202305221014327189000174', null, '2024-02-18 08:50:02', 'ADD', '1002', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021878531367', '772024021624210722', '202024021832481368', '测试2', '0', null, '18900000002', '30202305221014327189000174', null, '2024-02-18 08:50:17', 'ADD', '1003', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021975172442', '772024021975172442', '202024021983262443', '张三', '0', null, '15395136032', '30202305221014327189000174', null, '2024-02-19 06:39:47', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021985712625', '772024021985712625', '202024021943992626', '张三', '0', null, '15395136032', '302024021945972511', null, '2024-02-19 07:18:48', 'ADD', '1001', '2024021911282483', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021984292637', '772024021985712625', '202024021978642638', '李四', '1', null, '18856065616', '302024021945972511', null, '2024-02-19 07:19:31', 'ADD', '1002', '2024021911282483', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021903822961', '772024021903822961', '202024021979162962', '测试', '0', null, '18049392222', '30202305221014327189000174', null, '2024-02-19 10:33:00', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021994213006', '772024021994213006', '202024021984423007', '赵子龙', '0', null, '13800138001', '30202305221014327189000174', null, '2024-02-19 10:46:38', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021942673049', '772024021988183022', '202024021941103050', 'haha', '0', null, '18511112222', '30202305221014327189000174', null, '2024-02-19 10:58:34', 'ADD', '1002', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021994213006', '772024021994213006', '202024021941623065', '赵子龙', '0', '', '13800138001', '30202305221014327189000174', '', '2024-02-19 10:59:33', 'DEL', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024021994213006', '772024021994213006', '202024021941623065', '赵子龙', '0', '', '15876141451', '30202305221014327189000174', '', '2024-02-19 10:59:33', 'ADD', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024021952223083', '772024021952223083', '202024021950203084', 'yyanz', '1', null, '18512341234', '30202305221014327189000174', null, '2024-02-19 11:02:19', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021994213006', '772024021994213006', '202024021977243106', '赵子龙', '0', '', '15876141451', '30202305221014327189000174', '', '2024-02-19 11:02:34', 'DEL', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024021994213006', '772024021994213006', '202024021977243106', '赵子龙', '0', '', '13800138001', '30202305221014327189000174', '', '2024-02-19 11:02:34', 'ADD', '1001', '2023052267100146', '', '2000', 'T', '');
INSERT INTO `business_building_owner` VALUES ('772024021975893605', '772024021975893605', '202024021990763606', '测试222', '0', null, '13154831191', '30202305221014327189000174', null, '2024-02-19 16:32:25', 'ADD', '1001', '2023052267100146', '15211111111111111', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024021975863681', '772024021975863681', '202024021974963682', 'Mei001', '1', null, '13782790901', '30202305221014327189000174', null, '2024-02-19 16:53:23', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024022036744590', '772024022036744590', '202024022077974591', '啧啧啧', '0', null, '18888888888', '30202305221014327189000174', null, '2024-02-20 10:11:53', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', '1');
INSERT INTO `business_building_owner` VALUES ('772024022015804609', '772024022015804609', '202024022031354610', '啧啧啧', '0', null, '18234905095', '30202305221014327189000174', null, '2024-02-20 10:13:29', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', '1');
INSERT INTO `business_building_owner` VALUES ('772024022014786019', '772024022014786019', '202024022042576020', 'manman', '1', null, '18523030594', '30202305221014327189000174', null, '2024-02-20 16:14:20', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024022167516578', '772024022167516578', '202024022154516579', '请1', '0', null, '13095005341', '30202305221014327189000174', null, '2024-02-21 01:39:58', 'ADD', '1001', '2023052267100146', '13095005341', '2000', 'T', '34');
INSERT INTO `business_building_owner` VALUES ('772024022127837095', '772024022127837095', '202024022194507096', '钵钵鸡', '0', null, '18048902312', '30202305221014327189000174', null, '2024-02-21 10:43:22', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', '桥洞');
INSERT INTO `business_building_owner` VALUES ('772024022183707296', '772024022183707296', '202024022147037297', '成龙', '0', null, '13345674567', '30202305221014327189000174', null, '2024-02-21 11:41:31', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024022363092065', '772024022363092065', '202024022398342066', '陈某人', '0', null, '17317539405', '30202305221014327189000174', null, '2024-02-23 14:03:14', 'ADD', '1001', '2023052267100146', '430281199810137811', '2000', 'T', '株洲');
INSERT INTO `business_building_owner` VALUES ('772024022485623473', '772024022485623473', '202024022483473474', 'zkl', '0', null, '18142583965', '30202305221014327189000174', null, '2024-02-24 10:32:36', 'ADD', '1001', '2023052267100146', '-1', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('772024022624100162', '772024022624100162', '202024022661420163', '孙悟空', '0', null, '13111011002', '302024022634540081', null, '2024-02-26 14:10:30', 'ADD', '1001', '2024022647620054', '111111111111111111', '2000', 'T', null);
INSERT INTO `business_building_owner` VALUES ('112024032266750002', '772024021903822961', '202024032224570003', '老吴', '0', null, '17709711234', '30202305221014327189000174', '业主认证，审核添加', '2024-03-22 13:43:31', 'ADD', '1002', '2023052267100146', '-1', '2000', 'T', '无');
INSERT INTO `business_building_owner` VALUES ('112024032207740008', '772024021975893605', '202024032262930009', '张三', '0', null, '17709711234', '30202305221014327189000174', '业主认证，审核添加', '2024-03-22 16:27:04', 'ADD', '1002', '2023052267100146', '-1', '2000', 'T', '无');

-- ----------------------------
-- Table structure for business_building_owner_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_building_owner_attr`;
CREATE TABLE `business_building_owner_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `member_id` varchar(30) NOT NULL COMMENT '业主ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID 分片ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_building_owner_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_building_owner_room_rel
-- ----------------------------
DROP TABLE IF EXISTS `business_building_owner_room_rel`;
CREATE TABLE `business_building_owner_room_rel` (
  `rel_id` varchar(30) NOT NULL COMMENT '关系ID',
  `owner_id` varchar(30) NOT NULL COMMENT '业主ID',
  `room_id` varchar(30) NOT NULL COMMENT '房间ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `state` varchar(4) NOT NULL COMMENT '业务状态  2001 业主未迁入 2002 业主迁入 2003 业主迁出',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `start_time` datetime NOT NULL COMMENT '起租时间',
  `end_time` datetime NOT NULL COMMENT '起租时间',
  KEY `idx_bborrl_owner_id` (`rel_id`) USING BTREE,
  KEY `idx_bborrl_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_building_owner_room_rel
-- ----------------------------
INSERT INTO `business_building_owner_room_rel` VALUES ('84202305221015559469000240', '77202305221015438237000234', '75202305221015270788000231', '202023052239830242', '2001', '-1', null, '2023-05-22 10:15:55', 'ADD', '2023-05-22 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061999000006', '772023061953870004', '752023061949680005', '202023061923450002', '2001', '30202305221014327189000174', '', '2023-06-19 14:49:42', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061999000006', '772023061953870004', '752023061949680005', '202023061923450002', '2001', '30202305221014327189000174', '', '2023-06-19 14:49:42', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061945264522', '772023061940494520', '752023061910064519', '202023063051360090', '2001', '30202305221014327189000174', '', '2023-06-30 16:04:17', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061945264522', '772023061940494520', '752023061910064519', '202023063051360090', '2001', '30202305221014327189000174', '', '2023-06-30 16:04:17', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061979224602', '772023061927204600', '752023061998834599', '202023063062780141', '2001', '30202305221014327189000174', '', '2023-06-30 16:09:43', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061979224602', '772023061927204600', '752023061998834599', '202023063062780141', '2001', '30202305221014327189000174', '', '2023-06-30 16:09:43', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061995214434', '772023061984654432', '752023061948794431', '202023063034930144', '2001', '30202305221014327189000174', '', '2023-06-30 16:17:59', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061995214434', '772023061984654432', '752023061948794431', '202023063034930144', '2001', '30202305221014327189000174', '', '2023-06-30 16:17:59', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061986164558', '772023061990434556', '752023061933264555', '202023063021200052', '2001', '30202305221014327189000174', '', '2023-06-30 19:36:39', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061986164558', '772023061990434556', '752023061933264555', '202023063021200052', '2001', '30202305221014327189000174', '', '2023-06-30 19:36:39', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061986464566', '772023061990104564', '752023061909604563', '202023063049830073', '2001', '30202305221014327189000174', '', '2023-06-30 19:39:19', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061986464566', '772023061990104564', '752023061909604563', '202023063049830073', '2001', '30202305221014327189000174', '', '2023-06-30 19:39:19', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061935074502', '772023061951464500', '752023061908944499', '202023063018530051', '2001', '30202305221014327189000174', '', '2023-06-30 20:18:43', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061935074502', '772023061951464500', '752023061908944499', '202023063018530051', '2001', '30202305221014327189000174', '', '2023-06-30 20:18:43', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061935074502', '772023061951464500', '752023061908944499', '202023063060340003', '2001', '30202305221014327189000174', '', '2023-06-30 20:26:42', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061935074502', '772023061951464500', '752023061908944499', '202023063060340003', '2001', '30202305221014327189000174', '', '2023-06-30 20:26:42', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061992024390', '772023061977324388', '752023061915954387', '202023063039070054', '2001', '30202305221014327189000174', '', '2023-06-30 20:30:31', 'DEL', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023061992024390', '772023061977324388', '752023061915954387', '202023063039070054', '2001', '30202305221014327189000174', '', '2023-06-30 20:30:31', 'ADD', '2023-06-19 00:00:00', '2038-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023092002780007', '772023061940494520', '752023091657590002', '202023092001960009', '2001', '-1', null, '2023-09-20 11:34:13', 'ADD', '2023-03-01 00:00:00', '2027-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023120587760351', '772023120586090338', '752023120523340349', '202023120576320352', '2001', '-1', '添加房屋直接绑定', '2023-12-05 18:18:25', 'ADD', '2023-12-05 18:18:25', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024010426520022', '772023120586090338', '752024010438310020', '202024010401030023', '2001', '-1', '添加房屋直接绑定', '2024-01-04 12:50:43', 'ADD', '2024-01-04 12:50:43', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024012270120095', '772024012292610085', '752024012295280082', '202024012219280097', '2001', '-1', null, '2024-01-22 15:08:44', 'ADD', '2024-01-22 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024012231230021', '772024012299410005', '752024012283880019', '202024012239340022', '2001', '-1', '添加房屋直接绑定', '2024-01-22 22:44:49', 'ADD', '2024-01-22 22:44:49', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023120587760351', '772023120586090338', '752023120523340349', '202024021566360445', '2001', '-1', '添加房屋直接绑定', '2024-02-15 20:42:34', 'DEL', '2023-12-05 18:18:25', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842023120587760351', '772023120586090338', '752023120523340349', '202024021566360445', '2001', '-1', '添加房屋直接绑定', '2024-02-15 20:42:34', 'ADD', '2023-12-05 18:18:25', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021654810553', '772024021697820551', '752024021610450528', '202024021668770555', '2001', '-1', null, '2024-02-16 10:56:47', 'ADD', '2024-02-16 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021654810553', '772024021697820551', '752024021610450528', '202024021670630560', '2001', '-1', '', '2024-02-16 10:57:44', 'DEL', '2024-02-16 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021654810553', '772024021697820551', '752024021610450528', '202024021670630560', '2001', '-1', '', '2024-02-16 10:57:44', 'ADD', '2024-02-16 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021626610618', '772024021697820551', '752024021610450528', '202024021603980620', '2001', '-1', 'dd', '2024-02-16 11:57:30', 'ADD', '2024-02-16 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021626610618', '772024021697820551', '752024021610450528', '202024021640220677', '2001', '-1', 'dd', '2024-02-16 15:15:55', 'DEL', '2024-02-16 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021626610618', '772024021697820551', '752024021610450528', '202024021640220677', '2001', '-1', 'dd', '2024-02-16 15:15:55', 'ADD', '2024-02-16 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021687130678', '772024021697820551', '752024021610450528', '202024021658750680', '2001', '-1', '啊啊啊', '2024-02-16 15:16:17', 'ADD', '2024-02-16 00:00:00', '2024-02-23 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021659420718', '772023120586090338', '752024021696970716', '202024021699060719', '2001', '-1', '添加房屋直接绑定', '2024-02-16 16:49:55', 'ADD', '2024-02-16 16:49:55', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021730461036', '772024021697820551', '752024021691280708', '202024021788751038', '2001', '-1', null, '2024-02-17 13:37:02', 'ADD', '2024-02-17 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021754241039', '772024021697820551', '752024021686490709', '202024021759831041', '2001', '-1', null, '2024-02-17 13:40:39', 'ADD', '2024-02-17 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021806082070', '772024021624210722', '752024021696970716', '-1', '2001', '-1', '签订合同自动绑定', '2024-02-18 21:13:26', 'ADD', '2024-02-18 00:00:00', '2024-02-21 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021659420718', '772023120586090338', '752024021696970716', '202024021840162074', '2001', '-1', '添加房屋直接绑定', '2024-02-18 21:13:26', 'DEL', '2024-02-16 16:49:55', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021659420718', '772023120586090338', '752024021696970716', '202024021840162074', '2001', '-1', '添加房屋直接绑定', '2024-02-18 21:13:26', 'ADD', '2024-02-16 16:49:55', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021659420718', '772023120586090338', '752024021696970716', '-1', '2001', '-1', '添加房屋直接绑定', '2024-02-18 21:13:26', 'DEL', '2024-02-16 16:49:55', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021806082070', '772024021624210722', '752024021696970716', '202024021872002116', '2001', '-1', '签订合同自动绑定', '2024-02-18 21:26:55', 'DEL', '2024-02-18 00:00:00', '2024-02-21 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021806082070', '772024021624210722', '752024021696970716', '202024021872002116', '2001', '-1', '签订合同自动绑定', '2024-02-18 21:26:55', 'ADD', '2024-02-18 00:00:00', '2024-02-21 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021806082070', '772024021624210722', '752024021696970716', '-1', '2001', '-1', '签订合同自动绑定', '2024-02-18 21:26:55', 'DEL', '2024-02-18 00:00:00', '2024-02-21 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021815972282', '772024021624210722', '752024021570130194', '202024021858002284', '2001', '-1', null, '2024-02-18 22:20:23', 'ADD', '2024-02-18 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021875682285', '772024021624210722', '752024021696970716', '202024021802072287', '2001', '-1', null, '2024-02-18 22:21:23', 'ADD', '2024-02-18 22:21:23', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021881702288', '772024021697820551', '752023120523340349', '202024021839992290', '2001', '-1', null, '2024-02-18 22:21:59', 'ADD', '2024-02-18 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021803852291', '772024021697820551', '752024021619860527', '202024021849222293', '2001', '-1', null, '2024-02-18 22:22:34', 'ADD', '2024-02-18 22:22:34', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021963722459', '772024021975172442', '752024021972102457', '202024021941402460', '2001', '-1', '添加房屋直接绑定', '2024-02-19 06:43:17', 'ADD', '2024-02-19 06:43:17', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021924172649', '772024021985712625', '752024021954392622', '202024021911742651', '2001', '-1', null, '2024-02-19 07:20:02', 'ADD', '2024-02-19 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021932582995', '772024021903822961', '752024021954542993', '202024021959952996', '2001', '-1', '添加房屋直接绑定', '2024-02-19 10:44:58', 'ADD', '2024-02-19 10:44:58', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021923533031', '772024021994213006', '752024021992183029', '202024021900193032', '2001', '-1', '添加房屋直接绑定', '2024-02-19 10:47:57', 'ADD', '2024-02-19 10:47:57', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021754241039', '772024021697820551', '752024021686490709', '202024021916733036', '2001', '-1', '', '2024-02-19 10:53:10', 'DEL', '2024-02-17 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021754241039', '772024021697820551', '752024021686490709', '202024021916733036', '2001', '-1', '', '2024-02-19 10:53:10', 'ADD', '2024-02-17 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021730461036', '772024021697820551', '752024021691280708', '202024021906663038', '2001', '-1', '', '2024-02-19 10:54:04', 'DEL', '2024-02-17 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021730461036', '772024021697820551', '752024021691280708', '202024021906663038', '2001', '-1', '', '2024-02-19 10:54:04', 'ADD', '2024-02-17 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021938943041', '772024021988183022', '752024021963592858', '202024021974743043', '2001', '-1', null, '2024-02-19 10:55:43', 'ADD', '2024-02-19 10:55:43', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021963043629', '772024021975893605', '752024021967653523', '202024021926263631', '2001', '-1', null, '2024-02-19 16:38:12', 'ADD', '2024-02-19 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021916683742', '772024021975863681', '752024021996573669', '202024021904533744', '2001', '-1', null, '2024-02-19 17:05:45', 'ADD', '2024-02-19 17:05:45', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021929954184', '772024021988183022', '752024021996923125', '202024021945804186', '2001', '-1', 'www', '2024-02-19 22:35:51', 'ADD', '2024-02-19 00:00:00', '2024-02-29 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021980454187', '772024021988183022', '752024021990734183', '202024021927044189', '2001', '-1', 'wwwww', '2024-02-19 22:36:04', 'ADD', '2024-02-19 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021981774190', '772024021697820551', '752024021686490709', '202024021995184192', '2001', '-1', null, '2024-02-19 22:39:08', 'ADD', '2024-02-19 22:39:08', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021981774190', '772024021697820551', '752024021686490709', '202024021916684195', '2001', '-1', '', '2024-02-19 22:40:16', 'DEL', '2024-02-19 22:39:08', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021981774190', '772024021697820551', '752024021686490709', '202024021916684195', '2001', '-1', '', '2024-02-19 22:40:16', 'ADD', '2024-02-19 22:39:08', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021980454187', '772024021988183022', '752024021990734183', '202024021914014197', '2001', '-1', 'wwwww', '2024-02-19 22:40:47', 'DEL', '2024-02-19 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021980454187', '772024021988183022', '752024021990734183', '202024021914014197', '2001', '-1', 'wwwww', '2024-02-19 22:40:47', 'ADD', '2024-02-19 00:00:00', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021938943041', '772024021988183022', '752024021963592858', '202024021926254201', '2001', '-1', '', '2024-02-19 22:41:04', 'DEL', '2024-02-19 10:55:43', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024021938943041', '772024021988183022', '752024021963592858', '202024021926254201', '2001', '-1', '', '2024-02-19 22:41:04', 'ADD', '2024-02-19 10:55:43', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022053534622', '772024022015804609', '752024021963592858', '202024022000034624', '2001', '-1', null, '2024-02-20 10:15:18', 'ADD', '2024-02-20 10:15:18', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022056714947', '772024022015804609', '752024021990734183', '202024022002954949', '2001', '-1', null, '2024-02-20 11:15:37', 'ADD', '2024-02-20 11:15:37', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022090946033', '772024022014786019', '752024022078176031', '202024022032486034', '2001', '-1', '添加房屋直接绑定', '2024-02-20 16:15:49', 'ADD', '2024-02-20 16:15:49', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022090946033', '772024022014786019', '752024022078176031', '202024022059596530', '2001', '-1', '添加房屋直接绑定', '2024-02-20 23:40:08', 'DEL', '2024-02-20 16:15:49', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022090946033', '772024022014786019', '752024022078176031', '202024022059596530', '2001', '-1', '添加房屋直接绑定', '2024-02-20 23:40:08', 'ADD', '2024-02-20 16:15:49', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022036716531', '772024022014786019', '752024022078176031', '202024022096786533', '2001', '-1', null, '2024-02-20 23:40:29', 'ADD', '2024-02-20 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022192357110', '772024022127837095', '752024022122117085', '202024022183527112', '2001', '-1', null, '2024-02-21 10:43:50', 'ADD', '2024-02-21 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022147377307', '772024022183707296', '752024022169007291', '202024022128287309', '2001', '-1', null, '2024-02-21 11:42:16', 'ADD', '2024-02-21 11:42:16', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022192170243', '772024021988183022', '752024022197670241', '202024022113670244', '2001', '-1', '添加房屋直接绑定', '2024-02-21 16:44:40', 'ADD', '2024-02-21 16:44:40', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022350812078', '772024022363092065', '752024022240580266', '202024022366552080', '2001', '-1', null, '2024-02-23 14:03:45', 'ADD', '2024-02-23 14:03:45', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022192357110', '772024022127837095', '752024022122117085', '202024022672920677', '2001', '-1', '', '2024-02-26 11:15:42', 'DEL', '2024-02-21 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022192357110', '772024022127837095', '752024022122117085', '202024022672920677', '2001', '-1', '', '2024-02-26 11:15:42', 'ADD', '2024-02-21 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022036716531', '772024022014786019', '752024022078176031', '202024022612733143', '2001', '-1', '', '2024-02-26 15:48:59', 'DEL', '2024-02-20 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022036716531', '772024022014786019', '752024022078176031', '202024022612733143', '2001', '-1', '', '2024-02-26 15:48:59', 'ADD', '2024-02-20 00:00:00', '2050-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022350812078', '772024022363092065', '752024022240580266', '202024022625970295', '2001', '-1', '', '2024-02-26 17:51:08', 'DEL', '2024-02-23 14:03:45', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022350812078', '772024022363092065', '752024022240580266', '202024022625970295', '2001', '-1', '', '2024-02-26 17:51:08', 'ADD', '2024-02-23 14:03:45', '2037-01-01 00:00:00');
INSERT INTO `business_building_owner_room_rel` VALUES ('842024022733250560', '772024022672020208', '752024022767530558', '202024022783820561', '2001', '-1', '添加房屋直接绑定', '2024-02-27 09:54:56', 'ADD', '2024-02-27 09:54:56', '2037-01-01 00:00:00');

-- ----------------------------
-- Table structure for business_building_room
-- ----------------------------
DROP TABLE IF EXISTS `business_building_room`;
CREATE TABLE `business_building_room` (
  `room_id` varchar(30) NOT NULL COMMENT '房屋ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `room_num` varchar(64) NOT NULL COMMENT '房屋编号',
  `unit_id` varchar(30) NOT NULL COMMENT '单元ID',
  `layer` varchar(12) NOT NULL COMMENT '层数',
  `section` int DEFAULT NULL COMMENT '室',
  `apartment` varchar(20) NOT NULL COMMENT '户型',
  `built_up_area` decimal(12,2) NOT NULL COMMENT '建筑面积',
  `fee_coefficient` decimal(12,2) NOT NULL DEFAULT '1.00' COMMENT '算费系数',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `state` varchar(4) NOT NULL COMMENT '房屋状态，如房屋出售等，请查看state 表',
  `community_id` varchar(30) DEFAULT NULL COMMENT '小区ID',
  `room_type` varchar(12) NOT NULL DEFAULT '1010301' COMMENT '房屋类型',
  `room_sub_type` varchar(12) NOT NULL DEFAULT '110' COMMENT '房屋类型 110 住宅房屋，119 办公室 120 宿舍',
  `room_area` decimal(6,2) NOT NULL COMMENT '室内面积',
  `room_rent` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '租金',
  KEY `idx_business_room_id` (`room_id`) USING BTREE,
  KEY `idx_business_room_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_building_room
-- ----------------------------
INSERT INTO `business_building_room` VALUES ('752023063035460053', '202023081166540016', 'q002', '74202305221015116483000228', '1', '1', '10102', '94.56', '1.00', '30202305221014327189000174', '房产导入', '2023-08-11 00:10:33', 'DEL', '2001', '2023052267100146', '1010301', '110', '94.56', '0.00');
INSERT INTO `business_building_room` VALUES ('752023063035460053', '202023081166540016', 'q002', '74202305221015116483000228', '1', '1', '10102', '94.57', '1.00', '30202305221014327189000174', '房产导入', '2023-08-11 00:10:33', 'ADD', '2001', '2023052267100146', '1010301', '110', '94.56', '0.00');
INSERT INTO `business_building_room` VALUES ('752023091657590002', '202023092013840011', '1001', '742023091627160001', '12', '1', '10101', '12.00', '1.00', '-1', '12', '2023-09-20 11:34:29', 'DEL', '2006', '2023052267100146', '2020602', '120', '12.00', '12.00');
INSERT INTO `business_building_room` VALUES ('752023091657590002', '202023092013840011', '1001', '742023091627160001', '12', '1', '10101', '12.00', '1.00', '30202305221014327189000174', '12', '2023-09-20 11:34:29', 'ADD', '2006', '2023052267100146', '2020602', '120', '12.00', '2300.00');
INSERT INTO `business_building_room` VALUES ('752023120523340349', '202023120545630350', '1001', '742023120517690335', '12', '0', '10102', '100.00', '1.00', '30202305221014327189000174', null, '2023-12-05 18:18:25', 'ADD', '2001', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024010486130021', '1002', '742023120517690335', '1', '0', '10102', '100.00', '1.00', '30202305221014327189000174', null, '2024-01-04 12:50:43', 'ADD', '2001', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024011678260042', '1002', '742023120517690335', '1', '0', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-01-16 17:45:57', 'DEL', '2001', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024011678260042', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-01-16 17:45:57', 'ADD', '2001', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024012295280082', '202024012207350083', '9009', '742024012295860079', '1', '0', '10102', '100.00', '1.00', '302024012264900032', null, '2024-01-22 15:07:45', 'ADD', '2002', '2024012252790005', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024012283880019', '202024012210160020', '2003', '742024012295860079', '12', '0', '10102', '100.00', '1.00', '302024012264900032', null, '2024-01-22 22:44:49', 'ADD', '2001', '2024012252790005', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021570130194', '202024021588220195', '3', '742024021514140188', '12', '0', '10102', '121.00', '1.00', '30202305221014327189000174', null, '2024-02-15 00:58:09', 'ADD', '2002', '2023052267100146', '1010301', '110', '12.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024021519240374', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-15 16:04:05', 'DEL', '2009', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024021519240374', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-15 16:04:05', 'ADD', '2005', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024021586830385', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-15 16:20:45', 'DEL', '2009', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024021586830385', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-15 16:20:45', 'ADD', '2005', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024021543910407', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-15 16:31:36', 'DEL', '2009', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024021543910407', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-15 16:31:36', 'ADD', '2005', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024021682610547', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-16 10:45:59', 'DEL', '2009', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024010438310020', '202024021682610547', '1002', '742023120517690335', '1', '1', '10102', '100.00', '1.00', '30202305221014327189000174', '', '2024-02-16 10:45:59', 'ADD', '2005', '2023052267100146', '1010301', '120', '100.00', '23000.00');
INSERT INTO `business_building_room` VALUES ('752024021696970716', '202024021645510717', '102', '742023120517690335', '1', '0', '10102', '121.56', '0.90', '30202305221014327189000174', null, '2024-02-16 16:49:55', 'ADD', '2001', '2023052267100146', '1010301', '110', '121.56', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021696970716', '202024021846642073', '102', '742023120517690335', '1', '0', '10102', '121.56', '0.90', '30202305221014327189000174', '', '2024-02-18 21:13:26', 'DEL', '2001', '2023052267100146', '1010301', '110', '121.56', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021696970716', '202024021846642073', '102', '742023120517690335', '1', '0', '10102', '121.56', '0.90', '30202305221014327189000174', '', '2024-02-18 21:13:26', 'ADD', '2001', '2023052267100146', '1010301', '110', '121.56', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021696970716', '202024021838912118', '102', '742023120517690335', '1', '0', '10102', '121.56', '0.90', '30202305221014327189000174', '', '2024-02-18 21:26:55', 'DEL', '2001', '2023052267100146', '1010301', '110', '121.56', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021696970716', '202024021838912118', '102', '742023120517690335', '1', '0', '10102', '121.56', '0.90', '30202305221014327189000174', '', '2024-02-18 21:26:55', 'ADD', '2002', '2023052267100146', '1010301', '110', '121.56', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021972102457', '202024021925872458', '408', '742024021514140188', '4', '0', '10102', '118.00', '1.00', '30202305221014327189000174', null, '2024-02-19 06:43:17', 'ADD', '2001', '2023052267100146', '1010301', '110', '94.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021941922619', '202024021990122620', '101', '742024021969492613', '1', '0', '10102', '98.00', '1.00', '302024021945972511', null, '2024-02-19 07:17:49', 'ADD', '2002', '2024021911282483', '1010301', '110', '73.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021954392622', '202024021996972623', '102', '742024021969492613', '1', '0', '10102', '112.00', '1.00', '302024021945972511', null, '2024-02-19 07:18:20', 'ADD', '2002', '2024021911282483', '1010301', '110', '96.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021954542993', '202024021938472994', '2', '742023120517690335', '20', '0', '10102', '80.00', '1.00', '30202305221014327189000174', '狗狗2只，中型犬', '2024-02-19 10:44:58', 'ADD', '2001', '2023052267100146', '1010301', '110', '70.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021992183029', '202024021977653030', '001', '742023120517690335', '6', '0', '10102', '230.00', '1.00', '30202305221014327189000174', null, '2024-02-19 10:47:57', 'ADD', '2003', '2023052267100146', '1010301', '110', '196.50', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021967653523', '202024021915153524', '888', '742023120517690335', '1', '0', '10102', '11.00', '1.00', '30202305221014327189000174', null, '2024-02-19 16:25:18', 'ADD', '2002', '2023052267100146', '1010301', '110', '11.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021996573669', '202024021926523670', '101', '742024021987493003', '1', '0', '10102', '120.00', '1.00', '30202305221014327189000174', null, '2024-02-19 16:51:21', 'ADD', '2002', '2023052267100146', '1010301', '110', '110.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021972102457', '202024022086685968', '408', '742024021514140188', '4', '0', '10102', '118.00', '1.00', '30202305221014327189000174', '', '2024-02-20 15:58:54', 'DEL', '2001', '2023052267100146', '1010301', '110', '94.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024021972102457', '202024022086685968', '408', '742024021514140188', '4', '1', '10102', '118.00', '1.00', '30202305221014327189000174', '', '2024-02-20 15:58:54', 'ADD', '2005', '2023052267100146', '1010301', '110', '94.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022078176031', '202024022098556032', '20', '742023120517690335', '20', '0', '10102', '120.00', '1.00', '30202305221014327189000174', null, '2024-02-20 16:15:49', 'ADD', '2001', '2023052267100146', '1010301', '110', '110.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022122117085', '202024022101757086', '1-1-666', '742023120517690335', '6', '0', '10102', '120.00', '1.00', '30202305221014327189000174', null, '2024-02-21 10:41:47', 'ADD', '2002', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022122117085', '202024022119637114', '1-1-666', '742023120517690335', '6', '0', '10102', '120.00', '1.00', '-1', '', '2024-02-21 10:44:23', 'DEL', '2001', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022122117085', '202024022119637114', '606', '742023120517690335', '6', '1', '10102', '120.00', '1.00', '30202305221014327189000174', '', '2024-02-21 10:44:23', 'ADD', '2001', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022169007291', '202024022185727292', '1-1-1', '742023120517690335', '3', '0', '10102', '90.00', '1.00', '30202305221014327189000174', null, '2024-02-21 11:40:50', 'ADD', '2002', '2023052267100146', '1010301', '110', '90.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022197670241', '202024022170790242', '101', '742024022102450236', '11', '0', '10102', '111.00', '1.00', '30202305221014327189000174', null, '2024-02-21 16:44:40', 'ADD', '2001', '2023052267100146', '1010301', '110', '111.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022175940107', '202024022117890108', '44', '742024022102450236', '8', '0', '10102', '90.00', '1.00', '30202305221014327189000174', null, '2024-02-21 21:41:01', 'ADD', '2002', '2023052267100146', '1010301', '110', '89.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022240580266', '202024022274730267', '123', '742024022251010259', '123', '0', '10102', '222.00', '1.00', '30202305221014327189000174', null, '2024-02-22 10:02:39', 'ADD', '2002', '2023052267100146', '1010301', '110', '222.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022246330013', '202024022246930014', '111', '742024022102450236', '12', '0', '10102', '200.00', '1.00', '30202305221014327189000174', null, '2024-02-22 15:26:55', 'ADD', '2002', '2023052267100146', '1010301', '110', '200.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022240580266', '202024022208610016', '123', '742024022251010259', '123', '0', '10102', '222.00', '1.00', '30202305221014327189000174', '', '2024-02-22 15:28:04', 'DEL', '2002', '2023052267100146', '1010301', '110', '222.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022240580266', '202024022208610016', '103', '742024022251010259', '12', '1', '10102', '222.00', '1.00', '30202305221014327189000174', '', '2024-02-22 15:28:04', 'ADD', '2002', '2023052267100146', '1010301', '110', '222.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022344022579', '202024022381132580', '1层', '742024022102450236', '1', '0', '10102', '100.00', '1.00', '30202305221014327189000174', null, '2024-02-23 16:10:47', 'ADD', '2009', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022389522583', '202024022382002584', '1层', '742024022102450236', '1', '0', '10102', '100.00', '1.00', '30202305221014327189000174', null, '2024-02-23 16:10:50', 'ADD', '2009', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022169007291', '202024022300542592', '1-1-1', '742023120517690335', '3', '0', '10102', '90.00', '1.00', '-1', '', '2024-02-23 16:12:09', 'DEL', '2001', '2023052267100146', '1010301', '110', '90.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022169007291', '202024022300542592', '1-1-1', '742024021514140188', '3', '2', '20103', '90.00', '1.00', '30202305221014327189000174', '', '2024-02-23 16:12:09', 'ADD', '2003', '2023052267100146', '1010301', '110', '90.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022169007291', '202024022424053447', '1-1-1', '742024021514140188', '3', '2', '20103', '90.00', '1.00', '30202305221014327189000174', '', '2024-02-24 10:25:02', 'DEL', '2003', '2023052267100146', '1010301', '110', '90.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022169007291', '202024022424053447', '1-1-1', '742024021514140188', '3', '2', '20103', '90.00', '1.00', '30202305221014327189000174', '', '2024-02-24 10:25:02', 'ADD', '2004', '2023052267100146', '1010301', '110', '90.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022421753449', '202024022467863450', '301', '742023120517690335', '6', '0', '10102', '100.00', '1.00', '30202305221014327189000174', null, '2024-02-24 10:26:07', 'ADD', '2002', '2023052267100146', '1010301', '110', '90.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022122117085', '202024022599424223', '606', '742023120517690335', '6', '1', '10102', '120.00', '1.00', '30202305221014327189000174', '', '2024-02-25 15:04:40', 'DEL', '2001', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022122117085', '202024022599424223', '606', '742023120517690335', '6', '1', '10102', '120.00', '1.00', '30202305221014327189000174', '备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容备注内容', '2024-02-25 15:04:40', 'ADD', '2001', '2023052267100146', '1010301', '110', '100.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022767530558', '202024022792950559', '001', '742024022745010554', '1', '0', '10102', '125.00', '1.00', '30202305221014327189000174', null, '2024-02-27 09:54:56', 'ADD', '2001', '2023052267100146', '1010301', '110', '124.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022767530558', '202024031154200212', '001', '742024022745010554', '1', '0', '10102', '125.00', '1.00', '30202305221014327189000174', '', '2024-03-11 10:24:42', 'DEL', '2001', '2023052267100146', '1010301', '110', '124.00', '0.00');
INSERT INTO `business_building_room` VALUES ('752024022767530558', '202024031154200212', '001', '742024022745010554', '1', '1', '10102', '125.00', '1.00', '30202305221014327189000174', '', '2024-03-11 10:24:42', 'ADD', '2001', '2023052267100146', '1010301', '120', '124.00', '1000.00');

-- ----------------------------
-- Table structure for business_building_room_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_building_room_attr`;
CREATE TABLE `business_building_room_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `room_id` varchar(30) NOT NULL COMMENT '用户ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_b_room_attr` (`room_id`) USING BTREE,
  KEY `idx_business_b_room_attr_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_building_room_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_building_unit
-- ----------------------------
DROP TABLE IF EXISTS `business_building_unit`;
CREATE TABLE `business_building_unit` (
  `unit_id` varchar(30) NOT NULL COMMENT '单元ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `unit_num` varchar(12) NOT NULL COMMENT '单元编号',
  `floor_id` varchar(30) NOT NULL COMMENT '楼ID',
  `layer_count` int NOT NULL COMMENT '总层数',
  `lift` varchar(4) NOT NULL COMMENT '是否有电梯 1010有 2020 无',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `unit_area` decimal(10,2) NOT NULL COMMENT '单元面积',
  KEY `idx_business_unit_id` (`unit_id`) USING BTREE,
  KEY `idx_business_unit_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_building_unit
-- ----------------------------

-- ----------------------------
-- Table structure for business_building_unit_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_building_unit_attr`;
CREATE TABLE `business_building_unit_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `unit_id` varchar(30) NOT NULL COMMENT '房屋ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  PRIMARY KEY (`attr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_building_unit_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_bus
-- ----------------------------
DROP TABLE IF EXISTS `business_bus`;
CREATE TABLE `business_bus` (
  `id` varchar(30) NOT NULL COMMENT '服务ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `business_type_cd` varchar(20) NOT NULL COMMENT '服务编码',
  `name` varchar(20) NOT NULL COMMENT '服务名称',
  `description` varchar(20) NOT NULL COMMENT '服务描述',
  `user_id` varchar(30) NOT NULL COMMENT '创建用户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_bus
-- ----------------------------

-- ----------------------------
-- Table structure for business_car_black_white
-- ----------------------------
DROP TABLE IF EXISTS `business_car_black_white`;
CREATE TABLE `business_car_black_white` (
  `bw_id` varchar(30) NOT NULL COMMENT '黑白名单ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `black_white` varchar(12) NOT NULL COMMENT '黑白名单标识 1111 黑名单 2222 白名单',
  `car_num` varchar(12) NOT NULL COMMENT '车牌号',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `pa_id` varchar(30) NOT NULL COMMENT '停车场ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_car_black_white
-- ----------------------------

-- ----------------------------
-- Table structure for business_car_inout
-- ----------------------------
DROP TABLE IF EXISTS `business_car_inout`;
CREATE TABLE `business_car_inout` (
  `inout_id` varchar(30) NOT NULL COMMENT '进出ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `car_num` varchar(12) NOT NULL COMMENT '车牌号',
  `state` varchar(12) NOT NULL COMMENT '状态，100300 进场状态 100400 支付完成 100500 离场状态 100600 支付超时重新支付',
  `in_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '进场时间',
  `out_time` timestamp NULL DEFAULT NULL COMMENT '离场时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `pa_id` varchar(30) NOT NULL DEFAULT '停车场ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_car_inout
-- ----------------------------

-- ----------------------------
-- Table structure for business_car_inout_detail
-- ----------------------------
DROP TABLE IF EXISTS `business_car_inout_detail`;
CREATE TABLE `business_car_inout_detail` (
  `detail_id` varchar(30) NOT NULL COMMENT '详情ID',
  `inout_id` varchar(30) NOT NULL COMMENT '进出ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `machine_code` varchar(30) NOT NULL COMMENT '设备编码',
  `car_inout` varchar(12) NOT NULL COMMENT '3306 进场 3307 出场',
  `car_num` varchar(12) NOT NULL COMMENT '车牌号',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `pa_id` varchar(30) NOT NULL DEFAULT '停车场ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_car_inout_detail
-- ----------------------------

-- ----------------------------
-- Table structure for business_community
-- ----------------------------
DROP TABLE IF EXISTS `business_community`;
CREATE TABLE `business_community` (
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `name` varchar(100) NOT NULL COMMENT '小区名称',
  `address` varchar(200) NOT NULL COMMENT '小区地址',
  `city_code` varchar(12) NOT NULL COMMENT '根据定位获取城市编码',
  `nearby_landmarks` varchar(200) DEFAULT NULL COMMENT '地标，如王府井北60米',
  `map_x` varchar(20) NOT NULL COMMENT '地区 x坐标',
  `map_y` varchar(20) NOT NULL COMMENT '地区 y坐标',
  `month` int NOT NULL DEFAULT '0' COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `state` varchar(4) DEFAULT '1000' COMMENT '''业务状态 1000 为待审核 1200审核拒绝''',
  `community_area` decimal(10,2) DEFAULT '0.00' COMMENT '小区面积',
  `tel` varchar(200) DEFAULT NULL COMMENT '联系方式',
  `pay_fee_month` bigint NOT NULL DEFAULT '12' COMMENT '缴费周期',
  `fee_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '缴费周期',
  `qr_code` varchar(512) DEFAULT NULL COMMENT '客服二维码',
  KEY `idx_business_community_id` (`community_id`) USING BTREE,
  KEY `idx_business_community_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_community
-- ----------------------------
INSERT INTO `business_community` VALUES ('2024012252790005', '202024012217270006', '物联网同步小区', '河北省秦皇岛市北戴河区无', '130304', '无', '101.33', '101.33', '0', '2024-01-22 15:06:00', 'ADD', '1100', '0.00', '18966665555', '12', '0.00', null);
INSERT INTO `business_community` VALUES ('2024021911282483', '202024021981642484', '万科森林公园', '安徽省合肥市庐阳区安徽省合肥市四里河路', '340103', '森林公园', '101.33', '101.33', '0', '2024-02-19 07:07:50', 'ADD', '1100', '0.00', '117232353', '12', '3.40', null);
INSERT INTO `business_community` VALUES ('2024021966222555', '202024021965932556', '万科蓝山', '安徽省合肥市包河区安徽省合肥市滨湖', '340111', '万科蓝山', '101.33', '101.33', '0', '2024-02-19 07:10:48', 'ADD', '1100', '0.00', '117232353', '12', '3.40', null);
INSERT INTO `business_community` VALUES ('2024021966222555', '202024021928003751', '万科蓝山', '安徽省合肥市包河区安徽省合肥市滨湖', '340111', '万科蓝山', '101.33', '101.33', '0', '2024-02-19 17:07:06', 'DEL', '1100', '0.00', '117232353', '12', '3.40', '');
INSERT INTO `business_community` VALUES ('2024021966222555', '202024021928003751', '万科蓝山', '安徽省合肥市包河区安徽省合肥市滨湖', '340111', '万科蓝山', '101.33', '101.33', '0', '2024-02-19 17:07:06', 'ADD', '1100', '0.00', '117232353', '12', '0.00', '');
INSERT INTO `business_community` VALUES ('2024022327180323', '202024022398690324', '三国小区', '广东省汕头市龙湖区三国小区', '440507', '三国小区', '101.33', '101.33', '0', '2024-02-23 09:58:05', 'ADD', '1100', '0.00', '075486165888', '12', '0.00', null);
INSERT INTO `business_community` VALUES ('2024022315302909', '202024022301112910', '中航AFC', '四川省成都市锦江区中航AFC', '510104', '中航AFC', '101.33', '101.33', '0', '2024-02-23 17:29:22', 'ADD', '1100', '0.00', '13700000000', '12', '0.00', null);
INSERT INTO `business_community` VALUES ('2024022643710121', '202024022637620122', '一刀测试', '吉林省长春市朝阳区测试', '220104', '测试', '101.33', '101.33', '0', '2024-02-26 14:27:51', 'ADD', '1100', '0.00', '测试', '12', '0.00', null);

-- ----------------------------
-- Table structure for business_community_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_community_attr`;
CREATE TABLE `business_community_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `community_id` varchar(30) NOT NULL COMMENT '用户ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_attr_community_id` (`community_id`) USING BTREE,
  KEY `idx_business_community_attr_b_id` (`b_id`) USING BTREE,
  KEY `idx_business_b_room_attr_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_community_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_community_location
-- ----------------------------
DROP TABLE IF EXISTS `business_community_location`;
CREATE TABLE `business_community_location` (
  `location_id` varchar(30) NOT NULL COMMENT '位置ID',
  `location_name` varchar(100) NOT NULL COMMENT '位置名称',
  `location_type` varchar(12) NOT NULL COMMENT '位置类型 1000 小区 2000 单元 3000 房屋, t_dict 表',
  `b_id` varchar(30) NOT NULL COMMENT '业务ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `community_id` varchar(30) NOT NULL COMMENT '小区位置'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_community_location
-- ----------------------------

-- ----------------------------
-- Table structure for business_community_location_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_community_location_attr`;
CREATE TABLE `business_community_location_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `location_id` varchar(30) NOT NULL COMMENT '位置ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  PRIMARY KEY (`attr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_community_location_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_community_member
-- ----------------------------
DROP TABLE IF EXISTS `business_community_member`;
CREATE TABLE `business_community_member` (
  `community_member_id` varchar(30) NOT NULL COMMENT 'ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `member_id` varchar(50) NOT NULL COMMENT '成员ID',
  `member_type_cd` varchar(12) NOT NULL COMMENT '成员类型见 community_member_type表',
  `month` int NOT NULL DEFAULT '0' COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `audit_status_cd` varchar(4) NOT NULL DEFAULT '0000' COMMENT '审核状态',
  `start_time` datetime NOT NULL COMMENT '起租时间',
  `end_time` datetime NOT NULL COMMENT '截租时间',
  KEY `idx_business_member_community_id` (`community_id`) USING BTREE,
  KEY `idx_business_community_member_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_community_member
-- ----------------------------
INSERT INTO `business_community_member` VALUES ('722024012236710007', '202024012220200008', '2024012252790005', '400000000000000001', '390001200000', '0', '2024-01-22 15:06:00', 'ADD', '1100', '2024-01-22 15:06:00', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('722024012212610009', '202024012238210010', '2024012252790005', '400000000000000002', '390001200005', '0', '2024-01-22 15:06:01', 'ADD', '1100', '2024-01-22 15:06:01', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('102024012292920046', '202024012271040047', '2024012252790005', '102024012228150026', '390001200002', '0', '2024-01-22 15:06:31', 'ADD', '1100', '2024-01-22 15:06:31', '2025-01-22 15:06:31');
INSERT INTO `business_community_member` VALUES ('722024021959912485', '202024021903882486', '2024021911282483', '400000000000000001', '390001200000', '0', '2024-02-19 07:07:51', 'ADD', '1100', '2024-02-19 07:07:50', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('722024021941702487', '202024021980742488', '2024021911282483', '400000000000000002', '390001200005', '0', '2024-02-19 07:07:51', 'ADD', '1100', '2024-02-19 07:07:51', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('102024021998592525', '202024021963832526', '2024021911282483', '102024021989652505', '390001200002', '0', '2024-02-19 07:09:14', 'ADD', '1100', '2024-02-19 07:09:14', '2025-02-19 07:09:14');
INSERT INTO `business_community_member` VALUES ('722024021996682557', '202024021953292558', '2024021966222555', '400000000000000001', '390001200000', '0', '2024-02-19 07:10:48', 'ADD', '1100', '2024-02-19 07:10:48', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('722024021998482559', '202024021994692560', '2024021966222555', '400000000000000002', '390001200005', '0', '2024-02-19 07:10:48', 'ADD', '1100', '2024-02-19 07:10:48', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('102024021927922579', '202024021946982580', '2024021966222555', '102024021989652505', '390001200002', '0', '2024-02-19 07:13:17', 'ADD', '1100', '2024-02-19 07:13:17', '2025-02-19 07:13:17');
INSERT INTO `business_community_member` VALUES ('722024022307740325', '202024022351040326', '2024022327180323', '400000000000000001', '390001200000', '0', '2024-02-23 09:58:05', 'ADD', '1100', '2024-02-23 09:58:05', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('722024022338010327', '202024022315110328', '2024022327180323', '400000000000000002', '390001200005', '0', '2024-02-23 09:58:05', 'ADD', '1100', '2024-02-23 09:58:05', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('102024022307690368', '202024022379700369', '2024022327180323', '102024022393920348', '390001200002', '0', '2024-02-23 09:58:57', 'ADD', '1100', '2024-02-23 09:58:57', '2025-02-23 09:58:57');
INSERT INTO `business_community_member` VALUES ('722024022382112911', '202024022310412912', '2024022315302909', '400000000000000001', '390001200000', '0', '2024-02-23 17:29:23', 'ADD', '1100', '2024-02-23 17:29:22', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('722024022349732913', '202024022321032914', '2024022315302909', '400000000000000002', '390001200005', '0', '2024-02-23 17:29:23', 'ADD', '1100', '2024-02-23 17:29:23', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('102024022349982951', '202024022337172952', '2024022315302909', '102024022305732931', '390001200002', '0', '2024-02-23 17:31:45', 'ADD', '1100', '2024-02-23 17:31:45', '2025-02-23 17:31:45');
INSERT INTO `business_community_member` VALUES ('722024022620400123', '202024022604880124', '2024022643710121', '400000000000000001', '390001200000', '0', '2024-02-26 14:27:51', 'ADD', '1100', '2024-02-26 14:27:51', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('722024022687850125', '202024022688480126', '2024022643710121', '400000000000000002', '390001200005', '0', '2024-02-26 14:27:51', 'ADD', '1100', '2024-02-26 14:27:51', '2038-01-01 00:00:00');
INSERT INTO `business_community_member` VALUES ('102024022646380156', '202024022683530157', '2024022643710121', '102024022665340089', '390001200002', '0', '2024-02-26 14:28:06', 'ADD', '1100', '2024-02-26 14:28:06', '2025-02-26 14:28:06');

-- ----------------------------
-- Table structure for business_community_photo
-- ----------------------------
DROP TABLE IF EXISTS `business_community_photo`;
CREATE TABLE `business_community_photo` (
  `community_photo_id` varchar(30) NOT NULL COMMENT '商户照片ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `community_photo_type_cd` varchar(12) NOT NULL COMMENT '商户照片类型,T 门头照 I 内景照',
  `photo` varchar(100) NOT NULL COMMENT '照片',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_photo_community_id` (`community_id`) USING BTREE,
  KEY `idx_business_community_photo_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_community_photo
-- ----------------------------

-- ----------------------------
-- Table structure for business_complaint
-- ----------------------------
DROP TABLE IF EXISTS `business_complaint`;
CREATE TABLE `business_complaint` (
  `complaint_id` varchar(30) NOT NULL COMMENT '投诉ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `type_cd` varchar(30) NOT NULL COMMENT '投诉类型，见t_dict表',
  `room_id` varchar(100) NOT NULL COMMENT '房间ID',
  `complaint_name` varchar(30) NOT NULL COMMENT '投诉人',
  `tel` varchar(11) NOT NULL COMMENT '投诉人联系方式',
  `context` longtext NOT NULL COMMENT '投诉内容',
  `state` varchar(12) NOT NULL COMMENT '投诉处理状态，见 t_dict表',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID，分片键',
  `start_user_id` varchar(30) NOT NULL COMMENT '投诉人ID',
  KEY `idx_b_complaint_complaint_id` (`complaint_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_complaint
-- ----------------------------

-- ----------------------------
-- Table structure for business_demo
-- ----------------------------
DROP TABLE IF EXISTS `business_demo`;
CREATE TABLE `business_demo` (
  `demo_id` varchar(30) NOT NULL COMMENT '费用ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `demo_name` varchar(20) NOT NULL COMMENT '用例名称',
  `demo_value` varchar(20) NOT NULL COMMENT '用例值',
  `demo_remark` varchar(20) NOT NULL COMMENT '用例描述',
  `user_id` varchar(30) NOT NULL COMMENT '创建用户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_demo
-- ----------------------------

-- ----------------------------
-- Table structure for business_file_rel
-- ----------------------------
DROP TABLE IF EXISTS `business_file_rel`;
CREATE TABLE `business_file_rel` (
  `file_rel_id` varchar(30) NOT NULL COMMENT '文件关系ID，主键',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `rel_type_cd` varchar(30) NOT NULL COMMENT '文件类型,用来做分区,业主照片，商户照片，具体查看t_dict表',
  `save_way` varchar(12) NOT NULL COMMENT '存放方式，ftp table,fastdfs 具体查看t_dict表',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID，及说明这个文件归宿于谁，业主则填写业主ID',
  `file_real_name` varchar(200) NOT NULL COMMENT '文件真实名称',
  `file_save_name` varchar(200) NOT NULL COMMENT '文件存储名称',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_file_rel
-- ----------------------------

-- ----------------------------
-- Table structure for business_floor
-- ----------------------------
DROP TABLE IF EXISTS `business_floor`;
CREATE TABLE `business_floor` (
  `floor_id` varchar(30) NOT NULL COMMENT '楼ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `floor_num` varchar(64) NOT NULL COMMENT '楼编号',
  `name` varchar(100) NOT NULL COMMENT '小区楼名称',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `community_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '小区ID',
  `floor_area` decimal(10,2) NOT NULL COMMENT '建筑面积',
  `seq` int NOT NULL DEFAULT '1' COMMENT '楼栋加入排序',
  KEY `idx_business_floor_id` (`floor_id`) USING BTREE,
  KEY `idx_business_floor_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_floor
-- ----------------------------
INSERT INTO `business_floor` VALUES ('73202305221014587647000225', '202023052210620226', '1', '1号楼', '30202305221014327189000174', null, '2023-05-22 10:14:58', 'ADD', '2023052267100146', '100.00', '1');
INSERT INTO `business_floor` VALUES ('732023120568080332', '202023120535660333', '1', '1号楼', '30202305221014327189000174', null, '2023-12-05 18:17:36', 'ADD', '2023052267100146', '100.00', '1');
INSERT INTO `business_floor` VALUES ('732024012265490076', '202024012214870077', '22', '22号楼', '302024012264900032', null, '2024-01-22 15:07:03', 'ADD', '2024012252790005', '1000.00', '1');
INSERT INTO `business_floor` VALUES ('732024021518860179', '202024021578890180', '2', '2号楼', '30202305221014327189000174', '1', '2024-02-15 00:54:33', 'ADD', '2023052267100146', '11.00', '1');
INSERT INTO `business_floor` VALUES ('732024021543990184', '202024021583780185', '3', '3号楼', '30202305221014327189000174', '2', '2024-02-15 00:54:59', 'ADD', '2023052267100146', '22.00', '2');
INSERT INTO `business_floor` VALUES ('732024021926182608', '202024021917502609', '朗庭', '朗庭', '302024021945972511', null, '2024-02-19 07:14:55', 'ADD', '2024021911282483', '230000.00', '1');
INSERT INTO `business_floor` VALUES ('732024021926182608', '202024021915452611', '朗庭', '朗庭', '302024021945972511', '', '2024-02-19 07:15:57', 'DEL', '2024021911282483', '230000.00', '1');
INSERT INTO `business_floor` VALUES ('732024021926182608', '202024021915452611', '24', '24号楼', '302024021945972511', '', '2024-02-19 07:15:57', 'ADD', '2024021911282483', '230000.00', '1');
INSERT INTO `business_floor` VALUES ('732024021974592926', '202024021994002927', '120', '120号楼', '30202305221014327189000174', '0', '2024-02-19 10:24:50', 'ADD', '2023052267100146', '130.00', '2');
INSERT INTO `business_floor` VALUES ('732024021990293300', '202024021981813301', '123', '123号楼', '30202305221014327189000174', 'AAAAA', '2024-02-19 15:03:56', 'ADD', '2023052267100146', '130.00', '1');
INSERT INTO `business_floor` VALUES ('732024022269670256', '202024022285780257', '1232', '1232号楼', '30202305221014327189000174', null, '2024-02-22 10:02:00', 'ADD', '2023052267100146', '123.00', '1');
INSERT INTO `business_floor` VALUES ('732024022698820627', '202024022682840628', '商务办公区A区', '商务办公区A区号楼', '30202305221014327189000174', null, '2024-02-26 10:42:03', 'ADD', '2023052267100146', '2222.00', '2');
INSERT INTO `business_floor` VALUES ('732024022676630659', '202024022688410660', '12', '12号楼', '30202305221014327189000174', null, '2024-02-26 11:14:05', 'ADD', '2023052267100146', '123.00', '1');
INSERT INTO `business_floor` VALUES ('732024022724560551', '202024022775550552', '001', '001号楼', '30202305221014327189000174', null, '2024-02-27 09:53:07', 'ADD', '2023052267100146', '12423.00', '1');

-- ----------------------------
-- Table structure for business_floor_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_floor_attr`;
CREATE TABLE `business_floor_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `floor_id` varchar(30) NOT NULL COMMENT '房屋ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_floor_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_inspection_plan
-- ----------------------------
DROP TABLE IF EXISTS `business_inspection_plan`;
CREATE TABLE `business_inspection_plan` (
  `inspection_plan_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '巡检计划ID',
  `b_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '业务Id',
  `inspection_plan_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '巡检计划名称',
  `inspection_route_id` varchar(300) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '巡检路线ID',
  `community_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '小区ID',
  `start_date` datetime NOT NULL COMMENT '开始日期',
  `end_date` datetime NOT NULL COMMENT '结束日期',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `inspection_plan_period` varchar(12) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '执行周期',
  `sign_type` varchar(12) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '签到方式',
  `state` varchar(12) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '当前状态',
  `remark` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '备注说明',
  `create_user_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '制定人员ID',
  `create_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '制定人员姓名',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `before_time` varchar(12) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '30' COMMENT '任务提前',
  `inspection_month` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '月份',
  `inspection_day` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '天',
  `inspection_workday` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '周',
  `can_reexamine` varchar(4) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '允许补检  1000不允许  2000允许',
  `operate` varchar(4) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of business_inspection_plan
-- ----------------------------

-- ----------------------------
-- Table structure for business_inspection_plan_staff
-- ----------------------------
DROP TABLE IF EXISTS `business_inspection_plan_staff`;
CREATE TABLE `business_inspection_plan_staff` (
  `ip_staff_id` varchar(30) NOT NULL COMMENT '主键ID',
  `inspection_plan_id` varchar(30) NOT NULL COMMENT '巡检计划ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `staff_id` varchar(30) NOT NULL COMMENT '巡检人',
  `staff_name` varchar(200) NOT NULL COMMENT '巡检人名称',
  `start_time` varchar(20) NOT NULL COMMENT '开始时间',
  `end_time` varchar(20) NOT NULL COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_inspection_plan_staff
-- ----------------------------

-- ----------------------------
-- Table structure for business_inspection_point
-- ----------------------------
DROP TABLE IF EXISTS `business_inspection_point`;
CREATE TABLE `business_inspection_point` (
  `inspection_id` varchar(30) NOT NULL COMMENT 'ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `inspection_name` varchar(100) NOT NULL COMMENT '巡检名称',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注说明',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `point_obj_type` varchar(12) NOT NULL COMMENT '1001 设备巡检，2002 环境巡检',
  `point_obj_id` varchar(30) NOT NULL COMMENT '对象ID，环境时写-1，设备时写设备ID',
  `point_obj_name` varchar(200) NOT NULL COMMENT '对象名称',
  `item_id` varchar(30) NOT NULL COMMENT '巡检项目',
  `nfc_code` varchar(64) DEFAULT NULL COMMENT 'nfc编码'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_inspection_point
-- ----------------------------

-- ----------------------------
-- Table structure for business_inspection_route
-- ----------------------------
DROP TABLE IF EXISTS `business_inspection_route`;
CREATE TABLE `business_inspection_route` (
  `inspection_route_id` varchar(30) NOT NULL COMMENT 'Route_ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `route_name` varchar(100) NOT NULL COMMENT '路线名称',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `seq` varchar(100) NOT NULL COMMENT '路线顺序',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注说明',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_inspection_route
-- ----------------------------

-- ----------------------------
-- Table structure for business_inspection_route_point_rel
-- ----------------------------
DROP TABLE IF EXISTS `business_inspection_route_point_rel`;
CREATE TABLE `business_inspection_route_point_rel` (
  `irp_rel_id` varchar(30) NOT NULL COMMENT 'inspection_route and point relation ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `inspection_route_id` varchar(30) NOT NULL COMMENT '路线ID',
  `inspection_id` varchar(30) NOT NULL COMMENT '巡检点ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `point_start_time` varchar(20) DEFAULT NULL COMMENT '巡检点开始时间',
  `point_end_time` varchar(20) DEFAULT NULL COMMENT '巡检点结束时间',
  `sort_number` int DEFAULT NULL COMMENT '排序'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_inspection_route_point_rel
-- ----------------------------

-- ----------------------------
-- Table structure for business_inspection_task
-- ----------------------------
DROP TABLE IF EXISTS `business_inspection_task`;
CREATE TABLE `business_inspection_task` (
  `task_id` varchar(30) NOT NULL COMMENT '任务编码',
  `b_id` varchar(30) NOT NULL COMMENT '订单id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `inspection_plan_id` varchar(30) NOT NULL COMMENT '计划ID',
  `plan_ins_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '计划巡检时间',
  `act_ins_time` datetime DEFAULT NULL COMMENT '实际巡检时间',
  `plan_user_id` varchar(60) NOT NULL COMMENT '计划巡检人员id',
  `plan_user_name` varchar(60) DEFAULT NULL COMMENT '计划巡检人员姓名',
  `act_user_id` varchar(30) DEFAULT NULL COMMENT '实际巡检人员id',
  `act_user_name` varchar(60) DEFAULT NULL COMMENT '实际巡检人员姓名',
  `sign_type` varchar(200) NOT NULL COMMENT '实际巡检方式',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `state` varchar(12) NOT NULL DEFAULT '20200405' COMMENT '巡检状态',
  `original_plan_user_id` varchar(60) DEFAULT NULL COMMENT '原计划巡检人userId',
  `original_plan_user_name` varchar(60) DEFAULT NULL COMMENT '原计划巡检人名称',
  `transfer_desc` varchar(255) DEFAULT NULL COMMENT '转移说明',
  `task_type` varchar(255) DEFAULT NULL COMMENT '任务类型 1000日常巡检任务 2000流转巡检任务',
  `plan_end_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '计划巡检结束时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_inspection_task
-- ----------------------------

-- ----------------------------
-- Table structure for business_inspection_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `business_inspection_task_detail`;
CREATE TABLE `business_inspection_task_detail` (
  `task_detail_id` varchar(30) NOT NULL COMMENT '任务明细编码',
  `b_id` varchar(30) NOT NULL COMMENT '业务id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `task_id` varchar(30) NOT NULL COMMENT '任务ID',
  `inspection_id` varchar(30) NOT NULL COMMENT '巡检点ID',
  `inspection_name` varchar(100) NOT NULL COMMENT '巡检点名称',
  `state` varchar(12) NOT NULL COMMENT '巡检点状态',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `patrol_type` varchar(12) DEFAULT NULL COMMENT '巡检情况',
  `description` varchar(1000) DEFAULT NULL COMMENT '巡检说明',
  `longitude` varchar(255) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(255) DEFAULT NULL COMMENT '纬度',
  `inspection_state` varchar(12) DEFAULT NULL COMMENT '签到状态',
  `inspection_time` timestamp NULL DEFAULT NULL COMMENT '巡检点打卡时间',
  `point_start_time` varchar(20) DEFAULT NULL COMMENT '巡检点开始时间',
  `point_end_time` varchar(20) DEFAULT NULL COMMENT '巡检点结束时间',
  `sort_number` int DEFAULT NULL COMMENT '排序',
  `act_user_id` varchar(30) DEFAULT NULL COMMENT '实际巡检人员id',
  `act_user_name` varchar(60) DEFAULT NULL COMMENT '实际巡检人员姓名',
  `send_flag` varchar(12) DEFAULT 'N' COMMENT '巡检提醒标记'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_inspection_task_detail
-- ----------------------------

-- ----------------------------
-- Table structure for business_junk_requirement
-- ----------------------------
DROP TABLE IF EXISTS `business_junk_requirement`;
CREATE TABLE `business_junk_requirement` (
  `junk_requirement_id` varchar(30) NOT NULL COMMENT 'ID编码',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `type_cd` varchar(12) NOT NULL COMMENT '类型 旧货还是需求 旧货 222222 需求 333333',
  `classification` varchar(12) NOT NULL COMMENT '类别，具体查看t_dict 表',
  `context` varchar(200) NOT NULL COMMENT '内容',
  `reference_price` decimal(12,2) NOT NULL COMMENT '参考价格',
  `publish_user_id` varchar(30) NOT NULL COMMENT '发布用户ID',
  `publish_user_name` varchar(30) NOT NULL COMMENT '发布用户名称',
  `publish_user_link` varchar(11) NOT NULL COMMENT '联系电话',
  `state` varchar(12) NOT NULL COMMENT '状态，12001 未审核 13001 审核通过 14001 审核失败  15001 处理完成',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_junk_requirement
-- ----------------------------

-- ----------------------------
-- Table structure for business_machine
-- ----------------------------
DROP TABLE IF EXISTS `business_machine`;
CREATE TABLE `business_machine` (
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `machine_code` varchar(30) NOT NULL COMMENT '设备编码',
  `machine_version` varchar(30) NOT NULL COMMENT '设备版本',
  `machine_type_cd` varchar(30) NOT NULL COMMENT '设备类型 门禁9999 详情查看t_dict 表',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `machine_name` varchar(200) NOT NULL COMMENT '设备名称',
  `auth_code` varchar(64) NOT NULL COMMENT '授权码',
  `machine_ip` varchar(64) DEFAULT NULL COMMENT '设备IP',
  `machine_mac` varchar(64) DEFAULT NULL COMMENT '设备mac',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `location_type_cd` varchar(30) NOT NULL COMMENT '位置ID,请查看 community_location',
  `location_obj_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '对象ID，大门时小区ID，单元门 时单元ID 房屋时房屋ID',
  `state` varchar(12) NOT NULL DEFAULT '1000' COMMENT '设备状态，设备配置同步状态 1000 未同步 1100 同步中 1200 已同步',
  `direction` varchar(12) NOT NULL DEFAULT '3306' COMMENT '设备方向进出，3306 进 3307 出',
  `heartbeat_time` datetime NOT NULL COMMENT '设备心跳时间',
  `type_id` varchar(30) NOT NULL COMMENT '设备类型ID',
  KEY `idx_bm_machine_id` (`machine_id`) USING BTREE,
  KEY `idx_bm_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_machine
-- ----------------------------
INSERT INTO `business_machine` VALUES ('102023091837260050', '202023091898950060', '001', 'v300', '9996', '2023052267100146', '进场', '未知', '192.168.100.109', '', '2023-09-18 02:38:00', 'DEL', '102023091856350047', '102023061679340015', '1200', '3306', '2023-09-18 02:33:51', '');
INSERT INTO `business_machine` VALUES ('102023091837260050', '202023091898950060', '001', 'v300', '9996', '2023052267100146', '进场', '未知', '192.168.100.109', '', '2023-09-18 02:38:00', 'ADD', '102023091856350047', '102023061679340015', '1200', '3306', '2023-09-18 02:33:51', '');

-- ----------------------------
-- Table structure for business_machine_attrs
-- ----------------------------
DROP TABLE IF EXISTS `business_machine_attrs`;
CREATE TABLE `business_machine_attrs` (
  `machine_id` varchar(30) NOT NULL COMMENT '费用ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(128) NOT NULL COMMENT '属性值',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_bma_machine_id` (`machine_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_machine_attrs
-- ----------------------------

-- ----------------------------
-- Table structure for business_machine_auth
-- ----------------------------
DROP TABLE IF EXISTS `business_machine_auth`;
CREATE TABLE `business_machine_auth` (
  `auth_id` varchar(30) NOT NULL COMMENT '授权ID',
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `person_id` varchar(30) NOT NULL COMMENT '用户ID',
  `person_name` varchar(64) NOT NULL COMMENT '用户名称',
  `person_type` varchar(12) NOT NULL DEFAULT '1001' COMMENT '用户类别 1001 员工',
  `state` varchar(12) NOT NULL DEFAULT '1030' COMMENT '状态 待审核 10301 审核通过10302 审核不通10303',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  PRIMARY KEY (`auth_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_machine_auth
-- ----------------------------

-- ----------------------------
-- Table structure for business_machine_record
-- ----------------------------
DROP TABLE IF EXISTS `business_machine_record`;
CREATE TABLE `business_machine_record` (
  `machine_record_id` varchar(30) NOT NULL COMMENT '记录ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `machine_code` varchar(30) NOT NULL COMMENT '设备编码',
  `name` varchar(30) NOT NULL COMMENT '用户名称',
  `open_type_cd` varchar(12) NOT NULL COMMENT '开门方式，1000 人脸开门 2000 钥匙开门',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `tel` varchar(11) NOT NULL COMMENT '手机号',
  `id_card` varchar(20) NOT NULL COMMENT '用户身份证',
  `record_type_cd` varchar(12) NOT NULL COMMENT '记录类型，8888 开门记录 6666 访客留影',
  `file_id` varchar(64) DEFAULT NULL COMMENT '文件ID',
  `file_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '文件生成时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `similar` varchar(12) DEFAULT '1.0' COMMENT '相似度'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_machine_record
-- ----------------------------

-- ----------------------------
-- Table structure for business_machine_translate
-- ----------------------------
DROP TABLE IF EXISTS `business_machine_translate`;
CREATE TABLE `business_machine_translate` (
  `machine_translate_id` varchar(30) NOT NULL COMMENT '设备同步ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `machine_id` varchar(30) NOT NULL COMMENT '设备ID',
  `machine_code` varchar(30) NOT NULL COMMENT '设备编码',
  `type_cd` varchar(30) NOT NULL COMMENT '类型，是同步业主还是同步小区信息，详情查看t_dict表',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID 业主时，业主ID，小区是小区ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `obj_name` varchar(200) NOT NULL COMMENT '对象名称，业主时业主名称，小区时小区名称',
  `state` varchar(8) NOT NULL COMMENT '状态，10000 初始状态,20000 同步完成',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '二次同步时间',
  `machine_cmd` varchar(12) NOT NULL DEFAULT '999' COMMENT '设备指令 详见 t_dict',
  `obj_b_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '业务ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注字段'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_machine_translate
-- ----------------------------

-- ----------------------------
-- Table structure for business_member_store
-- ----------------------------
DROP TABLE IF EXISTS `business_member_store`;
CREATE TABLE `business_member_store` (
  `member_store_id` varchar(30) NOT NULL COMMENT 'ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商店ID',
  `member_id` varchar(50) NOT NULL COMMENT '商户成员ID',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_member_store_store_id` (`store_id`) USING BTREE,
  KEY `idx_business_member_store_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_member_store
-- ----------------------------

-- ----------------------------
-- Table structure for business_meter_water
-- ----------------------------
DROP TABLE IF EXISTS `business_meter_water`;
CREATE TABLE `business_meter_water` (
  `water_id` varchar(30) NOT NULL COMMENT '主键ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `meter_type` varchar(30) NOT NULL COMMENT '抄表类型',
  `obj_type` varchar(12) NOT NULL COMMENT '类型 1001 房屋 2002 车位',
  `obj_id` varchar(30) NOT NULL COMMENT '对象ID，1001 是房屋 2002 是车位',
  `pre_degrees` decimal(10,2) NOT NULL COMMENT '上期度数',
  `cur_degrees` decimal(10,2) NOT NULL COMMENT '本期度数',
  `pre_reading_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '上期读表时间',
  `cur_reading_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '本期读表时间',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `remark` varchar(200) DEFAULT NULL COMMENT '度表署名',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `fee_id` varchar(30) NOT NULL COMMENT '费用ID',
  `obj_name` varchar(200) DEFAULT NULL COMMENT '对象名称',
  `price` decimal(10,2) DEFAULT NULL COMMENT '抄表单价'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_meter_water
-- ----------------------------

-- ----------------------------
-- Table structure for business_msg
-- ----------------------------
DROP TABLE IF EXISTS `business_msg`;
CREATE TABLE `business_msg` (
  `msg_id` varchar(30) NOT NULL COMMENT '消息ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `msg_type` varchar(12) NOT NULL COMMENT '消息类型 10001 公告，10002 钥匙审核，10003 小区入驻审核，10004 小区添加审核',
  `title` varchar(30) NOT NULL COMMENT '消息标题',
  `url` varchar(100) NOT NULL COMMENT '消息路径',
  `view_type_cd` varchar(100) NOT NULL COMMENT '受众类型，10000 系统内消息，20000 小区内消息， 30000 商户内， 40000 员工ID（userId）',
  `view_obj_id` varchar(64) NOT NULL COMMENT '对象ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_msg
-- ----------------------------

-- ----------------------------
-- Table structure for business_msg_read
-- ----------------------------
DROP TABLE IF EXISTS `business_msg_read`;
CREATE TABLE `business_msg_read` (
  `msg_read_id` varchar(30) NOT NULL COMMENT '消息阅读ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `msg_id` varchar(30) NOT NULL COMMENT '消息ID',
  `user_id` varchar(30) NOT NULL COMMENT '阅读者',
  `user_name` varchar(30) NOT NULL COMMENT '阅读者姓名',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_msg_read
-- ----------------------------

-- ----------------------------
-- Table structure for business_notice
-- ----------------------------
DROP TABLE IF EXISTS `business_notice`;
CREATE TABLE `business_notice` (
  `notice_id` varchar(30) NOT NULL COMMENT '通知ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `title` varchar(100) NOT NULL COMMENT '通知标题',
  `notice_type_cd` varchar(4) NOT NULL COMMENT '类型 1000 业主通知，1001员工通知，1002小区通知',
  `context` longtext NOT NULL COMMENT '通知内容',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `obj_type` varchar(12) NOT NULL DEFAULT '9999' COMMENT '对象类型',
  `obj_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '对象ID',
  `state` varchar(12) NOT NULL DEFAULT '3000' COMMENT '状态 1000 待通知 2000 通知中  3000 通知完成'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_notice
-- ----------------------------
INSERT INTO `business_notice` VALUES ('102024021965403127', '202024021947133128', 'a', '1000', '<p>aa</p>', '2023052267100146', '30202305221014327189000174', '2024-02-19 11:02:49', '2024-02-19 11:04:20', 'ADD', '2024-02-21 15:55:00', '001', '2023052267100146', '3000');
INSERT INTO `business_notice` VALUES ('102024022080196075', '202024022078086076', '物业公告', '1002', '<p>这是公告</p>', '2023052267100146', '30202305221014327189000174', '2024-02-20 16:38:42', '2024-02-20 16:39:14', 'ADD', '2024-02-28 17:35:00', '001', '2023052267100146', '3000');
INSERT INTO `business_notice` VALUES ('102024022092366123', '202024022004506124', '答复', '1000', '<p>递归算法撒大哥</p>', '2024021966222555', '30518939884421922816', '2024-02-20 16:49:40', '2024-02-20 16:50:35', 'ADD', '2024-02-20 16:50:30', '001', '2024021966222555', '3000');
INSERT INTO `business_notice` VALUES ('102024022068636125', '202024022000066126', '答复', '1000', '<p>递归算法撒大哥</p>', '2024021911282483', '30518939884421922816', '2024-02-20 16:49:40', '2024-02-20 16:50:35', 'ADD', '2024-02-20 16:50:30', '001', '2024021911282483', '3000');
INSERT INTO `business_notice` VALUES ('102024022096286127', '202024022086176128', '答复', '1000', '<p>递归算法撒大哥</p>', '2024021684170596', '30518939884421922816', '2024-02-20 16:49:40', '2024-02-20 16:50:35', 'ADD', '2024-02-20 16:50:30', '001', '2024021684170596', '3000');
INSERT INTO `business_notice` VALUES ('102024022074936129', '202024022039826130', '答复', '1000', '<p>递归算法撒大哥</p>', '2024021698390574', '30518939884421922816', '2024-02-20 16:49:40', '2024-02-20 16:50:35', 'ADD', '2024-02-20 16:50:30', '001', '2024021698390574', '3000');
INSERT INTO `business_notice` VALUES ('102024022042146131', '202024022067176132', '答复', '1000', '<p>递归算法撒大哥</p>', '2024012252790005', '30518939884421922816', '2024-02-20 16:49:40', '2024-02-20 16:50:36', 'ADD', '2024-02-20 16:50:30', '001', '2024012252790005', '3000');
INSERT INTO `business_notice` VALUES ('102024022074756133', '202024022067426134', '答复', '1000', '<p>递归算法撒大哥</p>', '2023062100700008', '30518939884421922816', '2024-02-20 16:49:40', '2024-02-20 16:50:36', 'ADD', '2024-02-20 16:50:30', '001', '2023062100700008', '3000');
INSERT INTO `business_notice` VALUES ('102024022094256135', '202024022096406136', '答复', '1000', '<p>递归算法撒大哥</p>', '2023052267100146', '30518939884421922816', '2024-02-20 16:49:40', '2024-02-20 16:50:36', 'ADD', '2024-02-20 16:50:30', '001', '2023052267100146', '3000');

-- ----------------------------
-- Table structure for business_org
-- ----------------------------
DROP TABLE IF EXISTS `business_org`;
CREATE TABLE `business_org` (
  `org_id` varchar(30) NOT NULL COMMENT '组织ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `org_name` varchar(200) NOT NULL COMMENT '组织名称',
  `org_level` varchar(10) NOT NULL COMMENT '组织级别1 公司级 2 分公司级，3 部门级 查看t_dict表',
  `parent_org_id` varchar(30) NOT NULL COMMENT '上级组织ID，一级时填写org_id',
  `description` varchar(200) DEFAULT NULL COMMENT '组织描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `belong_community_id` varchar(30) NOT NULL COMMENT '归属小区，9999 归属于入驻的所有小区，否则是为小区ID',
  `allow_operation` varchar(12) NOT NULL DEFAULT 'T' COMMENT '允许前台操作数据，T可以，F不可以'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_org
-- ----------------------------

-- ----------------------------
-- Table structure for business_org_community
-- ----------------------------
DROP TABLE IF EXISTS `business_org_community`;
CREATE TABLE `business_org_community` (
  `org_community_id` varchar(30) NOT NULL COMMENT '组织ID',
  `org_id` varchar(30) NOT NULL COMMENT '组织ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `community_name` varchar(200) NOT NULL COMMENT '小区名称',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `org_name` varchar(200) NOT NULL COMMENT '组织名称',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_org_community
-- ----------------------------

-- ----------------------------
-- Table structure for business_org_staff_rel
-- ----------------------------
DROP TABLE IF EXISTS `business_org_staff_rel`;
CREATE TABLE `business_org_staff_rel` (
  `rel_id` varchar(30) NOT NULL COMMENT '组织员工ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `org_id` varchar(30) NOT NULL COMMENT '组织ID',
  `staff_id` varchar(30) NOT NULL COMMENT '员工ID',
  `rel_cd` varchar(30) NOT NULL COMMENT '关系角色，10000 普通员工， 20000部门经理 查看t_dict表',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_org_staff_rel
-- ----------------------------

-- ----------------------------
-- Table structure for business_owner_app_user
-- ----------------------------
DROP TABLE IF EXISTS `business_owner_app_user`;
CREATE TABLE `business_owner_app_user` (
  `app_user_id` varchar(30) NOT NULL COMMENT 'app用户ID',
  `member_id` varchar(30) NOT NULL COMMENT '业主成员ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区Id',
  `community_name` varchar(100) NOT NULL COMMENT '小区名称',
  `app_user_name` varchar(100) NOT NULL COMMENT 'app用户名称',
  `id_card` varchar(20) NOT NULL COMMENT '身份证号',
  `link` varchar(11) NOT NULL COMMENT '联系人手机号',
  `open_id` varchar(30) NOT NULL COMMENT 'app 开放ID',
  `app_type_cd` varchar(12) NOT NULL COMMENT '应用类型 10010 微信小程序',
  `state` varchar(12) NOT NULL COMMENT '状态类型，10000 审核中，12000 审核成功，13000 审核失败',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `user_id` varchar(30) DEFAULT NULL COMMENT '用户ID',
  `app_type` varchar(12) NOT NULL DEFAULT 'APP' COMMENT '绑定业主手机端类型',
  `nickname` varchar(255) DEFAULT NULL COMMENT '昵称',
  `headimgurl` varchar(255) DEFAULT NULL COMMENT '微信头像',
  KEY `idx_b_owner_app_app_user_id` (`app_user_id`) USING BTREE,
  KEY `idx_b_owner_app_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_owner_app_user
-- ----------------------------

-- ----------------------------
-- Table structure for business_owner_car
-- ----------------------------
DROP TABLE IF EXISTS `business_owner_car`;
CREATE TABLE `business_owner_car` (
  `car_id` varchar(30) NOT NULL COMMENT '汽车ID',
  `owner_id` varchar(30) NOT NULL COMMENT '业主ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `car_num` varchar(12) NOT NULL COMMENT '车牌号',
  `car_brand` varchar(50) DEFAULT NULL COMMENT '汽车品牌',
  `car_type` varchar(4) NOT NULL COMMENT '9901 家用小汽车，9902 客车，9903 货车',
  `car_color` varchar(12) DEFAULT NULL COMMENT '颜色',
  `ps_id` varchar(30) NOT NULL COMMENT '车位ID',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `start_time` datetime NOT NULL COMMENT '起租时间',
  `end_time` datetime NOT NULL COMMENT '结租时间',
  `state` varchar(12) NOT NULL COMMENT '状态，1001 正常状态，2002 车位释放欠费状态  3003 车位释放',
  `car_type_cd` varchar(4) NOT NULL DEFAULT '1001' COMMENT '1001 主车辆 1002 成员车辆',
  `member_id` varchar(30) NOT NULL COMMENT '成员ID',
  `lease_type` varchar(12) NOT NULL DEFAULT 'H' COMMENT '租赁类型，H 月租车 S 出售车 I 内部车 NM 免费车',
  KEY `idx_boc_car_id` (`car_id`) USING BTREE,
  KEY `idx_boc_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_owner_car
-- ----------------------------
INSERT INTO `business_owner_car` VALUES ('802023061661080002', '77202305221015438237000234', '202023061615440004', '青A45645', '特斯拉', '9901', 'base', '792023061646480001', '-1', null, '2023-06-16 17:13:26', 'ADD', '2023052267100146', '2023-01-01 00:00:00', '2023-08-09 00:00:00', '1001', '1001', '802023061661080002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063013040002', '772023061990824972', '202023063070810005', '青A88567', '长安', '9901', '黑色', '792023061609950024', '30202305221014327189000174', null, '2023-06-30 21:12:12', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-06-01 00:00:00', '1001', '1001', '802023063013040002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063013040002', '772023061990824972', '202023063000330021', '青A88567', '长安', '9901', '黑色', '792023061609950024', '30202305221014327189000174', '', '2023-06-30 21:13:18', 'DEL', '2023052267100146', '2023-06-01 00:00:00', '2023-06-01 00:00:00', '1001', '1001', '802023063013040002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063013040002', '772023061990824972', '202023063000330021', '青A88567', '长安', '9901', '黑色', '792023061609950024', '30202305221014327189000174', '', '2023-06-30 21:13:18', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063013040002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063013040002', '772023061990824972', '202023063050280032', '青A88567', '长安', '9901', '黑色', '792023061609950024', '30202305221014327189000174', '', '2023-06-30 21:14:27', 'DEL', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063013040002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063013040002', '772023061990824972', '202023063050280032', '青A88567', '长安', '9901', '黑色', '792023061609950024', '30202305221014327189000174', '', '2023-06-30 21:14:27', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063013040002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063039280043', '772023061990824972', '202023063028600046', '青A67876', '娃哈哈', '9901', null, '792023061604680033', '30202305221014327189000174', null, '2023-06-30 21:23:37', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-06-30 00:00:00', '1001', '1001', '802023063039280043', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063039280043', '772023061990824972', '202023063036670012', '青A67876', '娃哈哈', '9901', '', '792023061604680033', '30202305221014327189000174', '', '2023-06-30 21:49:25', 'DEL', '2023052267100146', '2023-06-01 00:00:00', '2023-06-30 00:00:00', '1001', '1001', '802023063039280043', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063039280043', '772023061990824972', '202023063036670012', '青A67876', '娃哈哈', '9901', '', '792023061604680033', '30202305221014327189000174', '', '2023-06-30 21:49:25', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063039280043', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063039280043', '772023061990824972', '202023063051070036', '青A67876', '娃哈哈', '9901', '', '792023061604680033', '30202305221014327189000174', '', '2023-06-30 21:52:29', 'DEL', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063039280043', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063039280043', '772023061990824972', '202023063051070036', '青A67876', '娃哈哈', '9901', '', '792023061604680033', '30202305221014327189000174', '', '2023-06-30 21:52:29', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063039280043', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063046960002', '772023061990824972', '202023063060260005', '青N88488', '传祺', '9901', '白色', '792023061609020032', '30202305221014327189000174', null, '2023-06-30 22:21:53', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-06-30 00:00:00', '1001', '1001', '802023063046960002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063046960002', '772023061990824972', '202023063048240022', '青N88488', '传祺', '9901', '白色', '792023061609020032', '30202305221014327189000174', '', '2023-06-30 22:22:22', 'DEL', '2023052267100146', '2023-06-01 00:00:00', '2023-06-30 00:00:00', '1001', '1001', '802023063046960002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063046960002', '772023061990824972', '202023063048240022', '青N88488', '传祺', '9901', '白色', '792023061609020032', '30202305221014327189000174', '', '2023-06-30 22:22:22', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063046960002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063046960002', '772023061990824972', '202023063084310032', '青N88488', '传祺', '9901', '白色', '792023061609020032', '30202305221014327189000174', '', '2023-06-30 22:23:12', 'DEL', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063046960002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023063046960002', '772023061990824972', '202023063084310032', '青N88488', '传祺', '9901', '白色', '792023061609020032', '30202305221014327189000174', '', '2023-06-30 22:23:12', 'ADD', '2023052267100146', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '1001', '1001', '802023063046960002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023061661080002', '77202305221015438237000234', '202023072673120064', '青C88488', '创奇', '9901', '白色', '792023061646480001', '30202305221014327189000174', null, '2023-07-26 17:25:07', 'ADD', '2023052267100146', '2023-01-01 00:00:00', '2023-08-09 00:00:00', '1001', '1002', '802023072600380011', 'H');
INSERT INTO `business_owner_car` VALUES ('802023061661080002', '77202305221015438237000234', '202023072686180066', '青C88488', '创奇', '9901', '白色', '792023061646480001', '30202305221014327189000174', '', '2023-07-26 17:25:30', 'DEL', '2023052267100146', '2023-01-01 00:00:00', '2023-08-09 00:00:00', '1001', '1002', '802023072600380011', 'H');
INSERT INTO `business_owner_car` VALUES ('802023061661080002', '77202305221015438237000234', '202023072686180066', '青C88488', '创奇', '9901', '白色', '792023061646480001', '30202305221014327189000174', '', '2023-07-26 17:25:30', 'ADD', '2023052267100146', '2023-01-01 00:00:00', '2023-08-09 00:00:00', '1001', '1002', '802023072600380011', 'H');
INSERT INTO `business_owner_car` VALUES ('802023061661080002', '77202305221015438237000234', '202023073008680026', '青A45645', '特斯拉', '9901', 'base', '792023061646480001', '-1', '', '2023-07-30 21:10:36', 'DEL', '2023052267100146', '2023-01-01 00:00:00', '2023-08-09 00:00:00', '1001', '1001', '802023061661080002', 'H');
INSERT INTO `business_owner_car` VALUES ('802023061661080002', '77202305221015438237000234', '202023073008680026', '青A45645', '特斯拉1', '9901', 'base', '792023061646480001', '30202305221014327189000174', '', '2023-07-30 21:10:36', 'ADD', '2023052267100146', '2023-01-01 00:00:00', '2023-08-09 00:00:00', '1001', '1001', '802023061661080002', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012291950112', '青A99099', null, '9901', null, '792024012295340107', '302024012264900032', null, '2024-01-22 15:10:25', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012291360034', '772024012299410005', '202024012236760037', '青ACC123', null, '9901', null, '792024012254910032', '302024012264900032', null, '2024-01-22 22:46:47', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2027-12-01 00:00:00', '1001', '1001', '802024012291360034', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012291360034', '772024012299410005', '202024012275150041', '青ACC123', '', '9901', '', '792024012254910032', '302024012264900032', '', '2024-01-22 22:47:43', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2027-12-01 00:00:00', '1001', '1001', '802024012291360034', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012291360034', '772024012299410005', '202024012275150041', '青ACC123', '', '9901', '', '792024012254910032', '302024012264900032', '', '2024-01-22 22:47:43', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2027-12-01 00:00:00', '1001', '1001', '802024012291360034', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012201170046', '772024012299410005', '202024012284070049', '青A88188', null, '9901', null, '792024012215330044', '302024012264900032', null, '2024-01-22 22:49:14', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '1001', '1001', '802024012201170046', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012201170046', '772024012299410005', '202024012266000053', '青A88188', '', '9901', '', '792024012215330044', '302024012264900032', '', '2024-01-22 22:49:34', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '1001', '1001', '802024012201170046', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012201170046', '772024012299410005', '202024012266000053', '青A88188', '', '9901', '', '792024012215330044', '302024012264900032', '', '2024-01-22 22:49:34', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-02-29 00:00:00', '1001', '1001', '802024012201170046', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012201170046', '772024012299410005', '202024012294240056', '青A88188', '', '9901', '', '792024012215330044', '302024012264900032', '', '2024-01-22 22:49:54', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2024-02-29 00:00:00', '1001', '1001', '802024012201170046', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012201170046', '772024012299410005', '202024012294240056', '青A88188', '', '9901', '', '792024012215330044', '302024012264900032', '', '2024-01-22 22:49:54', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-02-29 00:00:00', '1001', '1001', '802024012201170046', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012202210061', '772024012299410005', '202024012204220064', '青A55454', null, '9901', null, '792024012264060059', '302024012264900032', null, '2024-01-22 22:56:13', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '1001', '1001', '802024012202210061', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012202210061', '772024012299410005', '202024012209480068', '青A55454', '', '9901', '', '792024012264060059', '302024012264900032', '', '2024-01-22 22:56:27', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '1001', '1001', '802024012202210061', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012202210061', '772024012299410005', '202024012209480068', '青A55454', '', '9901', '', '792024012264060059', '302024012264900032', '', '2024-01-22 22:56:27', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '1001', '1001', '802024012202210061', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012211050073', '772024012299410005', '202024012204640076', '青ACC123', null, '9901', null, '792024012283080071', '302024012264900032', null, '2024-01-22 22:59:19', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '1001', '1001', '802024012211050073', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012211050073', '772024012299410005', '202024012276970080', '青ACC123', '', '9901', '', '792024012283080071', '302024012264900032', '', '2024-01-22 22:59:34', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '1001', '1001', '802024012211050073', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012211050073', '772024012299410005', '202024012276970080', '青ACC123', '', '9901', '', '792024012283080071', '302024012264900032', '', '2024-01-22 22:59:34', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '1001', '1001', '802024012211050073', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012290390084', '772024012299410005', '202024012210100087', '青AGK617', null, '9901', null, '792024012283080071', '302024012264900032', null, '2024-01-22 23:04:16', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-02-01 00:00:00', '1001', '1001', '802024012290390084', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012290390084', '772024012299410005', '202024012255690091', '青AGK617', '', '9901', '', '792024012283080071', '302024012264900032', '', '2024-01-22 23:04:39', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2024-02-01 00:00:00', '1001', '1001', '802024012290390084', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012290390084', '772024012299410005', '202024012255690091', '青AGK617', '', '9901', '', '792024012283080071', '302024012264900032', '', '2024-01-22 23:04:39', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-02-01 00:00:00', '1001', '1001', '802024012290390084', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012390740013', '青A99099', '', '9901', '', '792024012295340107', '302024012264900032', '', '2024-01-23 00:18:42', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012390740013', '青A99099', '', '9901', '', '792024012295340107', '302024012264900032', '', '2024-01-23 00:18:42', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012341610017', '青A99099', '', '9901', '', '792024012295340107', '302024012264900032', '', '2024-01-23 00:19:52', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012341610017', '青A99099', '', '9901', '', '792024012295340107', '302024012264900032', '', '2024-01-23 00:19:52', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2025-01-01 00:00:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012364770021', '青A99099', '', '9901', '', '792024012295340107', '302024012264900032', '', '2024-01-23 00:22:27', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2025-01-01 00:00:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012364770021', '青A99099', '', '9901', '', '792024012295340107', '302024012264900032', '', '2024-01-23 00:22:27', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2025-01-01 00:00:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012381500023', '青A99099', '', '9901', '', '792024012295340107', '302024012264900032', '', '2024-01-23 00:34:30', 'DEL', '2024012252790005', '2024-01-01 00:00:00', '2025-01-01 00:00:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024012232990109', '772024012292610085', '202024012381500023', '青A99099', '', '9901', '', '792024012295340107', '302024012264900032', '', '2024-01-23 00:34:30', 'ADD', '2024012252790005', '2024-01-01 00:00:00', '2025-01-02 01:05:00', '1001', '1001', '802024012232990109', 'H');
INSERT INTO `business_owner_car` VALUES ('802024020813920105', '772024020882790038', '202024020899700108', '121231', null, '9901', null, '792024020895880103', '302024012264900032', null, '2024-02-08 02:09:57', 'ADD', '2023062100700008', '2024-02-01 00:00:00', '2027-01-01 00:00:00', '1001', '1001', '802024020813920105', 'H');
INSERT INTO `business_owner_car` VALUES ('802024021570000420', '772023120586090338', '202024021590020423', '4561', null, '9902', null, '792023061609020032', '30202305221014327189000174', null, '2024-02-15 16:47:05', 'ADD', '2023052267100146', '2024-02-13 00:00:00', '2024-02-22 00:00:00', '1001', '1001', '802024021570000420', 'H');
INSERT INTO `business_owner_car` VALUES ('802024021884632269', '772024021624210722', '202024021869552272', 'A10', 'fdg', '9901', 'yhdh', '792023061679330031', '30202305221014327189000174', '2222', '2024-02-18 22:18:48', 'ADD', '2023052267100146', '2024-02-18 00:00:00', '2024-02-28 00:00:00', '1001', '1001', '802024021884632269', 'H');
INSERT INTO `business_owner_car` VALUES ('802024021975262462', '772024021975172442', '202024021937332465', '皖a12345', null, '9901', null, '792024021873182265', '30202305221014327189000174', null, '2024-02-19 06:45:06', 'ADD', '2023052267100146', '2024-02-19 00:00:00', '2025-02-19 00:00:00', '1001', '1001', '802024021975262462', 'H');
INSERT INTO `business_owner_car` VALUES ('802024022058015127', '772023120586090338', '202024022047115130', '予A12123', null, '9901', null, '792024021810422264', '30202305221014327189000174', null, '2024-02-20 11:36:38', 'ADD', '2023052267100146', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '1001', '1001', '802024022058015127', 'H');
INSERT INTO `business_owner_car` VALUES ('102024022034585148', '772024021988183022', '202024022033365149', '渝A12112', '大众', '9901', '黑色', '792024021869862263', '30202305221014327189000174', '车位申请，系统自动写入', '2024-02-20 11:40:31', 'ADD', '2023052267100146', '2024-01-01 00:00:00', '2024-12-31 23:55:00', '1001', '1001', '102024022034585148', 'H');
INSERT INTO `business_owner_car` VALUES ('802024022098145612', '772024021697820551', '202024022010865615', '渝a13111', '老头乐', '9901', '白色', '792024021833322262', '30202305221014327189000174', null, '2024-02-20 14:26:59', 'ADD', '2023052267100146', '2024-02-01 00:00:00', '2025-01-31 00:00:00', '1001', '1001', '802024022098145612', 'H');
INSERT INTO `business_owner_car` VALUES ('102024022037065824', '772024022015804609', '202024022069965825', '苏A3W352', 'A', '9901', '啊', '792024021837202261', '30202305221014327189000174', '车位申请，系统自动写入', '2024-02-20 15:26:22', 'ADD', '2023052267100146', '2024-02-01 06:50:00', '2024-02-20 15:25:00', '1001', '1001', '102024022037065824', 'H');
INSERT INTO `business_owner_car` VALUES ('802024022527393986', '772024022485623473', '202024022554373989', '123', '21', '9901', '123', '792024021833322262', '30202305221014327189000174', null, '2024-02-25 02:15:06', 'ADD', '2023052267100146', '2024-02-25 00:00:00', '2050-01-01 00:00:00', '1001', '1001', '802024022527393986', 'H');
INSERT INTO `business_owner_car` VALUES ('102024022757920459', '772024022183707296', '202024022714240460', '黑AR7970', '23', '9901', '3', '792024022159440213', '30202305221014327189000174', '车位申请，系统自动写入', '2024-02-27 09:35:48', 'ADD', '2023052267100146', '2024-02-22 11:25:00', '2025-01-17 11:55:00', '1001', '1001', '102024022757920459', 'H');

-- ----------------------------
-- Table structure for business_owner_car_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_owner_car_attr`;
CREATE TABLE `business_owner_car_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `car_id` varchar(30) NOT NULL COMMENT '车辆ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  PRIMARY KEY (`attr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_owner_car_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_parking_area
-- ----------------------------
DROP TABLE IF EXISTS `business_parking_area`;
CREATE TABLE `business_parking_area` (
  `pa_id` varchar(30) NOT NULL COMMENT '停车场ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `num` varchar(12) NOT NULL COMMENT '停车场编号',
  `type_cd` varchar(12) NOT NULL COMMENT '停车场类型，1001 地上停车场 2001 地下停车场',
  `remark` varchar(300) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_parking_area
-- ----------------------------
INSERT INTO `business_parking_area` VALUES ('102023061679340015', '202023061681210016', '2023052267100146', '1', '1001', '1', '2023-06-16 10:28:01', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024012226070099', '202024012260890100', '2024012252790005', 'A1', '1001', null, '2024-01-22 15:09:11', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024020823240095', '202024020835460096', '2023062100700008', '111', '1001', null, '2024-02-08 02:09:23', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024021954382896', '202024021943872897', '2023052267100146', '2', '1001', null, '2024-02-19 10:16:51', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024022007985114', '202024022019515115', '2023052267100146', '3', '1001', '地面漏天', '2024-02-20 11:33:32', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024022124196600', '202024022192746601', '2023052267100146', '52', '1001', '25', '2024-02-21 02:06:22', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102023061679340015', '202024022160010117', '2023052267100146', '1', '1001', '1', '2024-02-21 21:46:03', 'DEL');
INSERT INTO `business_parking_area` VALUES ('102023061679340015', '202024022160010117', '2023052267100146', '1', '1001', '1', '2024-02-21 21:46:03', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024022319742390', '202024022395932391', '2023052267100146', '1008611', '1001', 'asdda', '2024-02-23 14:57:35', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024022519834045', '202024022543654046', '2023052267100146', '01', '2001', null, '2024-02-25 09:01:54', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024022519834045', '202024022570214054', '2023052267100146', '01', '2001', '', '2024-02-25 09:02:08', 'DEL');
INSERT INTO `business_parking_area` VALUES ('102024022519834045', '202024022570214054', '2023052267100146', '01', '2001', '', '2024-02-25 09:02:08', 'ADD');
INSERT INTO `business_parking_area` VALUES ('102024022646150111', '202024022657060112', '2024022647620054', '0001', '1001', null, '2024-02-26 14:27:40', 'ADD');

-- ----------------------------
-- Table structure for business_parking_area_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_parking_area_attr`;
CREATE TABLE `business_parking_area_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `pa_id` varchar(30) NOT NULL COMMENT '停车场ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_parking_area_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_parking_space
-- ----------------------------
DROP TABLE IF EXISTS `business_parking_space`;
CREATE TABLE `business_parking_space` (
  `ps_id` varchar(30) NOT NULL COMMENT '车位ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `num` varchar(12) NOT NULL COMMENT '车位编号',
  `pa_id` varchar(30) NOT NULL COMMENT '停车场ID',
  `state` varchar(4) NOT NULL COMMENT '车位状态 出售 S，出租 H ，空闲 F',
  `area` decimal(7,2) NOT NULL COMMENT '车位面积',
  `remark` varchar(300) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `parking_type` varchar(3) NOT NULL DEFAULT '1' COMMENT '1：普通车位  2：子母车位  3：豪华车位'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_parking_space
-- ----------------------------

-- ----------------------------
-- Table structure for business_parking_space_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_parking_space_attr`;
CREATE TABLE `business_parking_space_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `ps_id` varchar(30) NOT NULL COMMENT '车位ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  PRIMARY KEY (`attr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_parking_space_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_pay_fee
-- ----------------------------
DROP TABLE IF EXISTS `business_pay_fee`;
CREATE TABLE `business_pay_fee` (
  `fee_id` varchar(30) NOT NULL COMMENT '费用ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `fee_type_cd` varchar(12) NOT NULL COMMENT '费用类型，物业费，停车费',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `payer_obj_id` varchar(30) NOT NULL COMMENT '付款方ID',
  `income_obj_id` varchar(30) NOT NULL COMMENT '收款方ID',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `amount` decimal(10,2) NOT NULL DEFAULT '-1.00' COMMENT '总金额，如物业费，停车费等没有总金额的，填写为-1.00',
  `user_id` varchar(30) NOT NULL COMMENT '创建用户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `fee_flag` varchar(12) NOT NULL DEFAULT '1003006' COMMENT '费用标识 1003006 为周期性费用 2006012 为一次性费用',
  `state` varchar(12) NOT NULL DEFAULT '2008001' COMMENT '状态 2007001收费未开始 2008001 收费中状态 2009001 收费结束',
  `config_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '费用项ID',
  `payer_obj_type` varchar(12) NOT NULL DEFAULT '3333' COMMENT '付费对象类型 3333 房屋 6666 是车位',
  `batch_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '批次ID',
  KEY `idx_bpf_fee_id` (`fee_id`) USING BTREE,
  KEY `idx_bpf_b_id` (`b_id`) USING BTREE,
  KEY `idx_pf_fee_id` (`fee_id`) USING BTREE,
  KEY `idx_pf_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_pay_fee
-- ----------------------------

-- ----------------------------
-- Table structure for business_pay_fee_attrs
-- ----------------------------
DROP TABLE IF EXISTS `business_pay_fee_attrs`;
CREATE TABLE `business_pay_fee_attrs` (
  `fee_id` varchar(30) NOT NULL COMMENT '费用ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(500) NOT NULL COMMENT '属性值',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_bpfa_fee_id` (`fee_id`) USING BTREE,
  KEY `idx_bpfa_b_id` (`b_id`) USING BTREE,
  KEY `idx_pfa_fee_id` (`fee_id`) USING BTREE,
  KEY `idx_pfa_b_id` (`b_id`) USING BTREE,
  KEY `idx_bma_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_pay_fee_attrs
-- ----------------------------

-- ----------------------------
-- Table structure for business_pay_fee_config
-- ----------------------------
DROP TABLE IF EXISTS `business_pay_fee_config`;
CREATE TABLE `business_pay_fee_config` (
  `config_id` varchar(30) NOT NULL COMMENT '费用ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `fee_type_cd` varchar(12) NOT NULL COMMENT '费用类型，物业费，停车费',
  `square_price` decimal(12,4) NOT NULL COMMENT '每平米收取的单价',
  `additional_amount` decimal(12,4) NOT NULL COMMENT '附加费用',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `is_default` varchar(12) NOT NULL DEFAULT 'F' COMMENT '默认费用 只能修改 不能做删除 T 标识是默认 F 不是默认',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `fee_flag` varchar(12) NOT NULL DEFAULT '1003006' COMMENT '费用标识 1003006 为周期性费用 2006012 为一次性费用',
  `fee_name` varchar(100) NOT NULL DEFAULT '未知' COMMENT '费用项名称',
  `computing_formula` varchar(12) NOT NULL DEFAULT '1001' COMMENT '计算公式 1001 面积*单价+附加费 2002 固定费用',
  `bill_type` varchar(12) NOT NULL DEFAULT '004' COMMENT '出账类型',
  `payment_cycle` varchar(12) NOT NULL DEFAULT '1' COMMENT '缴费周期',
  `payment_cd` varchar(12) NOT NULL DEFAULT '1200' COMMENT '付费类型',
  `computing_formula_text` longtext COMMENT '自定义公式内容',
  `deduct_from` varchar(1) NOT NULL DEFAULT 'Y' COMMENT '是否账户抵扣, Y 默认,是 N 否',
  `units` varchar(12) NOT NULL DEFAULT '元' COMMENT '单位 默认元',
  `decimal_place` int NOT NULL DEFAULT '2' COMMENT '小数点位数，0-4位',
  `scale` varchar(12) NOT NULL DEFAULT '1' COMMENT '进位 ',
  `pay_online` varchar(12) NOT NULL DEFAULT 'Y' COMMENT '是否线上缴费 Y 是 N 否',
  `prepayment_period` varchar(40) DEFAULT NULL COMMENT '预付期，单位为天',
  KEY `idx_bpfc_config_id` (`config_id`) USING BTREE,
  KEY `idx_bpfc_b_id` (`b_id`) USING BTREE,
  KEY `idx_pfc_config_id` (`config_id`) USING BTREE,
  KEY `idx_pfc_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_pay_fee_config
-- ----------------------------
INSERT INTO `business_pay_fee_config` VALUES ('92202305221013595234000152', '202023052237940153', '2023052267100146', '888800010012', '0.0000', '0.0000', '2023-05-22 10:14:00', 'ADD', 'T', '2023-05-22 10:13:59', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('92202305221014004890000154', '202023052296490155', '2023052267100146', '888800010007', '0.0000', '0.0000', '2023-05-22 10:14:00', 'ADD', 'T', '2023-05-22 10:14:00', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023062136510014', '202023062104390015', '2023062100700008', '888800010012', '0.0000', '0.0000', '2023-06-21 14:35:28', 'ADD', 'T', '2023-06-21 14:35:27', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023062157540016', '202023062140340017', '2023062100700008', '888800010007', '0.0000', '0.0000', '2023-06-21 14:35:28', 'ADD', 'T', '2023-06-21 14:35:28', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023071686730002', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-16 12:11:26', 'DEL', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvv', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023071686730002', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-16 12:11:26', 'ADD', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023072434910002', '202023072449190003', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-24 08:47:51', 'ADD', 'F', '2023-07-24 00:00:00', '2050-01-01 00:00:00', '1003006', 'xx', '1001', '002', '12', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023072434910002', '202023072495640005', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-24 08:48:05', 'DEL', 'F', '2023-07-24 00:00:00', '2050-01-01 00:00:00', '1003006', 'xx', '1001', '002', '12', '1200', '', 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023072434910002', '202023072495640005', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-24 08:48:05', 'ADD', 'F', '2023-07-24 00:00:00', '2050-01-01 00:00:00', '1003006', 'xx', '1001', '002', '12', '1200', '', 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023061961640009', '202023072408410004', '2023052267100146', '888800010008', '0.0000', '80.0000', '2023-07-24 08:59:36', 'DEL', 'F', '2023-06-19 00:00:00', '2050-01-01 00:00:00', '1003006', '月租费', '2002', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023061961640009', '202023072408410004', '2023052267100146', '888800010008', '0.0000', '80.0000', '2023-07-24 08:59:36', 'ADD', 'F', '2023-06-19 00:00:00', '2050-01-01 00:00:00', '1003006', '月租费', '2002', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023072697490003', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-26 10:39:22', 'DEL', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023072697490003', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-26 10:39:22', 'ADD', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '20');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023072627670002', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-26 11:49:47', 'DEL', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '20');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023072627670002', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-26 11:49:47', 'ADD', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '2');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023072600770004', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-26 11:50:07', 'DEL', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '2');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023072600770004', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-07-26 11:50:07', 'ADD', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '20');
INSERT INTO `business_pay_fee_config` VALUES ('922023080815810005', '202023080820380006', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-08-08 10:58:52', 'ADD', 'F', '2023-08-08 00:00:00', '2050-01-01 00:00:00', '1003006', '车位管理费', '4004', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023082341140027', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-08-23 01:02:48', 'DEL', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '20');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023082341140027', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-08-23 01:02:48', 'ADD', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '12', '1200', '', 'Y', '元', '2', '1', 'Y', '20');
INSERT INTO `business_pay_fee_config` VALUES ('922023082666590012', '202023082640420013', '2023052267100146', '888800010006', '0.0000', '1000.0000', '2023-08-26 09:27:57', 'ADD', 'F', '2023-08-26 00:00:00', '2050-01-01 00:00:00', '2006012', '装修押金', '2002', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023090469640007', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-09-04 17:45:28', 'DEL', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '12', '1200', '', 'Y', '元', '2', '1', 'Y', '20');
INSERT INTO `business_pay_fee_config` VALUES ('922023071621950002', '202023090469640007', '2023052267100146', '888800010001', '1.2000', '0.0000', '2023-09-04 17:45:28', 'ADD', 'F', '2023-07-16 00:00:00', '2050-01-01 00:00:00', '1003006', 'vvvb', '1001', '002', '12', '1200', '', 'Y', '元', '0', '1', 'Y', '20');
INSERT INTO `business_pay_fee_config` VALUES ('922023092080800003', '202023092036800004', '2023052267100146', '888800010018', '0.0000', '0.0000', '2023-09-20 11:32:07', 'ADD', 'F', '2010-01-01 00:00:00', '2050-01-01 00:00:00', '1003006', '租金D', '1102', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922023092657850002', '202023092632560003', '2023052267100146', '888800010001', '0.0000', '0.0000', '2023-09-26 17:15:35', 'ADD', 'F', '2023-09-26 00:00:00', '2050-01-01 00:00:00', '2006012', '测试导入费用', '4004', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922023101890350003', '202023101881610004', '2023052267100146', '888800010001', '1.3000', '0.0000', '2023-10-18 11:29:59', 'ADD', 'F', '2023-10-18 00:00:00', '2050-01-01 00:00:00', '2006012', '一次性物业费', '1001', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922023101890350003', '202023102406860002', '2023052267100146', '888800010001', '1.3000', '0.0000', '2023-10-24 17:08:59', 'DEL', 'F', '2023-10-18 00:00:00', '2050-01-01 00:00:00', '2006012', '一次性物业费', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922023101890350003', '202023102406860002', '2023052267100146', '888800010001', '1.3000', '0.0000', '2023-10-24 17:08:59', 'ADD', 'F', '2023-10-18 00:00:00', '2050-01-01 00:00:00', '2006012', '一次性物业费', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120907590396', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:23:18', 'ADD', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', null, 'N', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120903530412', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:23:24', 'DEL', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', '', 'N', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120903530412', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:23:24', 'ADD', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', '', 'N', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120954000428', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:24:22', 'DEL', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', '', 'N', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120954000428', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:24:22', 'ADD', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', '', 'N', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120979880444', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:24:28', 'DEL', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', '', 'N', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120979880444', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:24:28', 'ADD', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', '', 'N', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120920440460', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:25:14', 'DEL', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', '', 'N', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922023120908580375', '202023120920440460', '2023052267100146', '888800010008', '0.0000', '0.0000', '2023-12-09 15:25:14', 'ADD', 'T', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2006012', '1', '4004', '001', '1', '1200', '', 'N', '元', '2', '1', 'Y', '');
INSERT INTO `business_pay_fee_config` VALUES ('922024011673750045', '202024011653820046', '2023052267100146', '888800010018', '0.0000', '0.0000', '2024-01-16 17:46:45', 'ADD', 'F', '2024-01-16 00:00:00', '2050-01-01 00:00:00', '4012024', '租金E', '1102', '002', '12', '1200', null, 'Y', '元', '2', '1', 'Y', '60');
INSERT INTO `business_pay_fee_config` VALUES ('922024011673750045', '202024011654610083', '2023052267100146', '888800010018', '0.0000', '0.0000', '2024-01-16 17:48:48', 'DEL', 'F', '2024-01-16 00:00:00', '2050-01-01 00:00:00', '4012024', '租金E', '1102', '002', '12', '1200', '', 'Y', '元', '2', '1', 'Y', '60');
INSERT INTO `business_pay_fee_config` VALUES ('922024011673750045', '202024011654610083', '2023052267100146', '888800010018', '0.0000', '0.0000', '2024-01-16 17:48:48', 'ADD', 'F', '2024-01-16 00:00:00', '2050-01-01 00:00:00', '4012024', '租金E', '1102', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '60');
INSERT INTO `business_pay_fee_config` VALUES ('922024011673750045', '202024011616630012', '2023052267100146', '888800010018', '0.0000', '0.0000', '2024-01-16 19:12:06', 'DEL', 'F', '2024-01-16 00:00:00', '2050-01-01 00:00:00', '4012024', '租金E', '1102', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '60');
INSERT INTO `business_pay_fee_config` VALUES ('922024011673750045', '202024011616630012', '2023052267100146', '888800010018', '0.0000', '0.0000', '2024-01-16 19:12:06', 'ADD', 'F', '2024-01-16 00:00:00', '2050-01-01 00:00:00', '4012024', '租金E', '1102', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024012266810011', '202024012253660012', '2024012252790005', '888800010012', '0.0000', '0.0000', '2024-01-22 15:06:01', 'ADD', 'T', '2024-01-22 15:06:01', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024012258650013', '202024012220970014', '2024012252790005', '888800010007', '0.0000', '0.0000', '2024-01-22 15:06:01', 'ADD', 'T', '2024-01-22 15:06:01', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024021637470580', '202024021689860581', '2024021698390574', '888800010012', '0.0000', '0.0000', '2024-02-16 11:38:19', 'ADD', 'T', '2024-02-16 11:38:19', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024021642890582', '202024021644600583', '2024021698390574', '888800010007', '0.0000', '0.0000', '2024-02-16 11:38:19', 'ADD', 'T', '2024-02-16 11:38:19', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024021636350602', '202024021644460603', '2024021684170596', '888800010012', '0.0000', '0.0000', '2024-02-16 11:40:25', 'ADD', 'T', '2024-02-16 11:40:25', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024021689200604', '202024021684780605', '2024021684170596', '888800010007', '0.0000', '0.0000', '2024-02-16 11:40:25', 'ADD', 'T', '2024-02-16 11:40:25', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922023101890350003', '202024021675680747', '2023052267100146', '888800010001', '1.3000', '0.0000', '2024-02-16 16:52:55', 'DEL', 'F', '2023-10-18 00:00:00', '2050-01-01 00:00:00', '2006012', '一次性物业费', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922023101890350003', '202024021675680747', '2023052267100146', '888800010001', '0.9000', '0.0000', '2024-02-16 16:52:55', 'ADD', 'F', '2023-10-18 00:00:00', '2050-01-01 00:00:00', '2006012', '一次性物业费', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024021963772489', '202024021907582490', '2024021911282483', '888800010012', '0.0000', '0.0000', '2024-02-19 07:07:51', 'ADD', 'T', '2024-02-19 07:07:51', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024021985592491', '202024021921932492', '2024021911282483', '888800010007', '0.0000', '0.0000', '2024-02-19 07:07:51', 'ADD', 'T', '2024-02-19 07:07:51', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024021985562561', '202024021940322562', '2024021966222555', '888800010012', '0.0000', '0.0000', '2024-02-19 07:10:48', 'ADD', 'T', '2024-02-19 07:10:48', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024021938972563', '202024021970272564', '2024021966222555', '888800010007', '0.0000', '0.0000', '2024-02-19 07:10:48', 'ADD', 'T', '2024-02-19 07:10:48', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024021961362653', '202024021911442654', '2024021911282483', '888800010001', '3.4000', '0.0000', '2024-02-19 07:21:43', 'ADD', 'F', '2024-02-19 00:00:00', '2025-02-19 00:00:00', '1003006', '物业费', '1001', '002', '12', '1200', null, 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024021979023774', '202024021985263775', '2023052267100146', '888800010016', '0.9000', '0.0000', '2024-02-19 17:10:25', 'ADD', 'F', '2024-02-19 00:00:00', '2050-01-01 00:00:00', '1003006', '电费试收费', '5005', '002', '1', '2100', null, 'Y', '元', '2', '1', 'Y', '0');
INSERT INTO `business_pay_fee_config` VALUES ('922024021977073823', '202024021938763824', '2023052267100146', '888800010001', '1.0000', '1.0000', '2024-02-19 17:26:01', 'ADD', 'F', '2024-02-19 00:00:00', '2050-01-01 00:00:00', '1003006', 'aaa', '1001', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '2');
INSERT INTO `business_pay_fee_config` VALUES ('922024021977733847', '202024021912593848', '2023052267100146', '888800010001', '1.0000', '1.0000', '2024-02-19 17:26:43', 'ADD', 'F', '2024-02-19 00:00:00', '2050-01-01 00:00:00', '1003006', 'vv', '1001', '002', '2', '1200', null, 'Y', '元', '2', '1', 'Y', '2');
INSERT INTO `business_pay_fee_config` VALUES ('922024021900914114', '202024021971064115', '2023052267100146', '888800010013', '0.0000', '0.0000', '2024-02-19 21:15:51', 'ADD', 'F', '2024-02-19 00:00:00', '2050-01-01 00:00:00', '1003006', '333', '7007', '002', '1', '1200', '(L-5)*5 + 10 ', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022030234422', '202024022017134423', '2023052267100146', '888800010001', '1.0000', '1.0000', '2024-02-20 09:42:33', 'ADD', 'F', '2024-02-20 00:00:00', '2050-01-01 00:00:00', '2006012', '100', '1001', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022004004531', '202024022028404532', '2023052267100146', '888800010001', '11.0000', '11.0000', '2024-02-20 10:07:33', 'ADD', 'F', '2024-02-20 00:00:00', '2050-01-01 00:00:00', '2006012', '11', '1001', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022020705056', '202024022000995057', '2023052267100146', '888800010015', '2.5000', '0.0000', '2024-02-20 11:27:15', 'ADD', 'F', '2024-02-20 00:00:00', '2050-01-01 00:00:00', '2006012', '水费后付费', '5005', '002', '1', '2100', null, 'N', '元', '2', '1', 'Y', '0');
INSERT INTO `business_pay_fee_config` VALUES ('922024022160586954', '202024022193566955', '2024022154856948', '888800010012', '0.0000', '0.0000', '2024-02-21 10:18:35', 'ADD', 'T', '2024-02-21 10:18:35', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022179466956', '202024022100916957', '2024022154856948', '888800010007', '0.0000', '0.0000', '2024-02-21 10:18:35', 'ADD', 'T', '2024-02-21 10:18:35', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022167857548', '202024022158477549', '2023052267100146', '888800010015', '2.0000', '0.0000', '2024-02-21 14:07:03', 'ADD', 'F', '2024-02-21 00:00:00', '2050-01-01 00:00:00', '2006012', '住宅用水', '6006', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022167857548', '202024022124140472', '2023052267100146', '888800010015', '2.0000', '0.0000', '2024-02-21 17:40:36', 'DEL', 'F', '2024-02-21 00:00:00', '2050-01-01 00:00:00', '2006012', '住宅用水', '6006', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022167857548', '202024022124140472', '2023052267100146', '888800010015', '0.5000', '0.0000', '2024-02-21 17:40:36', 'ADD', 'F', '2024-02-21 00:00:00', '2050-01-01 00:00:00', '1003006', '住宅用水', '6006', '002', '12', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022328250329', '202024022350740330', '2024022327180323', '888800010012', '0.0000', '0.0000', '2024-02-23 09:58:05', 'ADD', 'T', '2024-02-23 09:58:05', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022330790331', '202024022352590332', '2024022327180323', '888800010007', '0.0000', '0.0000', '2024-02-23 09:58:06', 'ADD', 'T', '2024-02-23 09:58:06', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022390630345', '202024022315600346', '2023052267100146', '888800010014', '0.0000', '0.0000', '2024-02-23 09:58:32', 'ADD', 'F', '2024-02-23 00:00:00', '2050-01-01 00:00:00', '2006012', '电卡充值', '2002', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022390630345', '202024022305030453', '2023052267100146', '888800010014', '0.0000', '0.0000', '2024-02-23 10:01:01', 'DEL', 'F', '2024-02-23 00:00:00', '2050-01-01 00:00:00', '2006012', '电卡充值', '2002', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022390630345', '202024022305030453', '2023052267100146', '888800010014', '0.0000', '0.0000', '2024-02-23 10:01:01', 'ADD', 'F', '2024-02-23 00:00:00', '2050-01-01 00:00:00', '2006012', '电卡充值', '4004', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022368692915', '202024022313102916', '2024022315302909', '888800010012', '0.0000', '0.0000', '2024-02-23 17:29:23', 'ADD', 'T', '2024-02-23 17:29:23', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022347062917', '202024022328822918', '2024022315302909', '888800010007', '0.0000', '0.0000', '2024-02-23 17:29:23', 'ADD', 'T', '2024-02-23 17:29:23', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022649680410', '202024022648550411', '2024022655510404', '888800010012', '0.0000', '0.0000', '2024-02-26 10:03:10', 'ADD', 'T', '2024-02-26 10:03:09', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022661440412', '202024022651740413', '2024022655510404', '888800010007', '0.0000', '0.0000', '2024-02-26 10:03:10', 'ADD', 'T', '2024-02-26 10:03:10', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022649680060', '202024022658710061', '2024022647620054', '888800010012', '0.0000', '0.0000', '2024-02-26 13:55:09', 'ADD', 'T', '2024-02-26 13:55:09', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022679910062', '202024022611750063', '2024022647620054', '888800010007', '0.0000', '0.0000', '2024-02-26 13:55:09', 'ADD', 'T', '2024-02-26 13:55:09', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022676520127', '202024022691070128', '2024022643710121', '888800010012', '0.0000', '0.0000', '2024-02-26 14:27:51', 'ADD', 'T', '2024-02-26 14:27:51', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022690920129', '202024022636180130', '2024022643710121', '888800010007', '0.0000', '0.0000', '2024-02-26 14:27:52', 'ADD', 'T', '2024-02-26 14:27:51', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022004004531', '202024022640240189', '2023052267100146', '888800010001', '11.0000', '11.0000', '2024-02-26 14:29:53', 'DEL', 'F', '2024-02-20 00:00:00', '2050-01-01 00:00:00', '2006012', '11', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024022004004531', '202024022640240189', '2023052267100146', '888800010001', '0.5000', '50.0000', '2024-02-26 14:29:53', 'ADD', 'F', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '2006012', '11', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024022618600003', '202024022626720004', '2023052267100146', '888800010001', '0.5000', '50.0000', '2024-02-26 14:33:39', 'ADD', 'F', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '2006012', '鑫鑫家园', '1001', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024022618600003', '202024022647290008', '2023052267100146', '888800010001', '0.5000', '50.0000', '2024-02-26 14:34:19', 'DEL', 'F', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '2006012', '鑫鑫家园', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024022618600003', '202024022647290008', '2023052267100146', '888800010001', '0.5000', '50.0000', '2024-02-26 14:34:19', 'ADD', 'F', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '2006012', '鑫鑫家园物业费', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024022618600003', '202024022601120069', '2023052267100146', '888800010001', '0.5000', '50.0000', '2024-02-26 14:46:30', 'DEL', 'F', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '2006012', '鑫鑫家园物业费', '1001', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024022618600003', '202024022601120069', '2023052267100146', '888800010001', '0.0000', '0.0000', '2024-02-26 14:46:30', 'ADD', 'F', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '2006012', '鑫鑫家园物业费', '7007', '002', '1', '1200', '房屋面积*0.5*12', 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024022618600003', '202024022633000071', '2023052267100146', '888800010001', '0.0000', '0.0000', '2024-02-26 14:49:02', 'DEL', 'F', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '2006012', '鑫鑫家园物业费', '7007', '002', '1', '1200', '房屋面积*0.5*12', 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024022618600003', '202024022633000071', '2023052267100146', '888800010001', '0.5000', '50.0000', '2024-02-26 14:49:02', 'ADD', 'F', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '2006012', '鑫鑫家园物业费', '1001', '002', '1', '1200', '房屋面积*0.5*12', 'Y', '元', '2', '1', 'Y', '365');
INSERT INTO `business_pay_fee_config` VALUES ('922024022695650522', '202024022605070523', '2024022692080516', '888800010012', '0.0000', '0.0000', '2024-02-26 21:02:44', 'ADD', 'T', '2024-02-26 21:02:44', '2038-01-01 00:00:00', '2006012', '报修费[系统默认]', '4004', '003', '1', '2100', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024022653010524', '202024022680800525', '2024022692080516', '888800010007', '0.0000', '0.0000', '2024-02-26 21:02:44', 'ADD', 'T', '2024-02-26 21:02:44', '2038-01-01 00:00:00', '2006012', '临时车费用[系统默认]', '3003', '004', '1', '1200', null, 'Y', '元', '2', '1', 'Y', null);
INSERT INTO `business_pay_fee_config` VALUES ('922024031120830207', '202024031152700208', '2023052267100146', '888800010018', '0.0000', '0.0000', '2024-03-11 10:23:40', 'ADD', 'F', '2024-03-11 00:00:00', '2050-01-01 00:00:00', '1003006', '租金递增', '1101', '002', '1', '1200', null, 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024031120830207', '202024031157960210', '2023052267100146', '888800010018', '0.0000', '0.0000', '2024-03-11 10:23:50', 'DEL', 'F', '2024-03-11 00:00:00', '2050-01-01 00:00:00', '1003006', '租金递增', '1101', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');
INSERT INTO `business_pay_fee_config` VALUES ('922024031120830207', '202024031157960210', '2023052267100146', '888800010018', '0.0000', '0.0000', '2024-03-11 10:23:50', 'ADD', 'F', '2024-03-11 00:00:00', '2050-01-01 00:00:00', '1003006', '租金递增', '1102', '002', '1', '1200', '', 'Y', '元', '2', '1', 'Y', '1');

-- ----------------------------
-- Table structure for business_pay_fee_detail
-- ----------------------------
DROP TABLE IF EXISTS `business_pay_fee_detail`;
CREATE TABLE `business_pay_fee_detail` (
  `detail_id` varchar(30) NOT NULL COMMENT '费用明细ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `fee_id` varchar(30) NOT NULL COMMENT '费用ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `cycles` decimal(9,2) NOT NULL COMMENT '周期，以月为单位',
  `receivable_amount` decimal(10,2) NOT NULL COMMENT '应收金额',
  `received_amount` decimal(10,2) NOT NULL COMMENT '应收金额',
  `prime_rate` decimal(3,2) NOT NULL COMMENT '打折率',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `state` varchar(4) DEFAULT '1400' COMMENT '用于退费状态参考字典表',
  `start_time` datetime DEFAULT NULL COMMENT '费用开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '费用结束时间',
  `payable_amount` decimal(10,2) NOT NULL COMMENT '应缴金额',
  `pay_order_id` varchar(30) DEFAULT NULL COMMENT '支付订单ID',
  `cashier_id` varchar(30) DEFAULT NULL COMMENT '收银员ID，员工ID',
  `cashier_name` varchar(30) DEFAULT NULL COMMENT '收银员,员工',
  `open_invoice` varchar(12) DEFAULT 'N' COMMENT '是否开票 Y 已开票 N 未开票',
  `acct_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '账户抵扣金额',
  `discount_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '优惠打折金额',
  `deduction_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '优惠减免金额',
  `late_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '滞纳金',
  `gift_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '赠送金额',
  KEY `idx_bpfd_detail_id` (`detail_id`) USING BTREE,
  KEY `idx_bpfd_b_id` (`b_id`) USING BTREE,
  KEY `idx_pfd_detail_id` (`detail_id`) USING BTREE,
  KEY `idx_pfd_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_pay_fee_detail
-- ----------------------------
INSERT INTO `business_pay_fee_detail` VALUES ('912023053114720003', '202023053106310004', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '130.00', '1.00', null, '2023-05-31 23:12:56', 'ADD', '1400', '2023-05-01 00:00:00', '2023-06-01 00:00:00', '130.00', '102023053130920002', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023061725140003', '202023061705850004', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '130.00', '1.00', null, '2023-06-17 09:14:56', 'ADD', '1400', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '130.00', '102023061783120002', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023062164060005', '202023062196120006', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '130.00', '1.00', null, '2023-06-21 00:43:15', 'ADD', '1400', '2023-07-01 00:00:00', '2023-08-01 00:00:00', '130.00', '102023062157710004', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063021920020', '202023063094800021', '902023063069140002', '2023052267100146', '12.00', '1475.14', '1475.14', '1.00', null, '2023-06-30 15:30:21', 'ADD', '1400', '2023-06-01 00:00:00', '2024-06-01 00:00:00', '1475.14', '102023063019140019', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063037720059', '202023063012620060', '902023063069140002', '2023052267100146', '-12.00', '-1475.14', '-1475.14', '7.00', null, '2023-06-30 15:33:10', 'ADD', '1300', '2023-06-01 00:00:00', '2024-06-01 00:00:00', '0.00', '102023063019140019', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063003070110', '202023063018450111', '902023063069660092', '2023052267100146', '12.00', '1475.14', '1475.14', '1.00', null, '2023-06-30 16:08:25', 'ADD', '1400', '2023-06-01 00:00:00', '2024-06-01 00:00:00', '1475.14', '102023063041970109', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063054540021', '202023063024150022', '902023063058940003', '2023052267100146', '12.00', '1475.14', '1475.14', '1.00', 'sss', '2023-06-30 19:36:12', 'ADD', '1400', '2023-06-01 00:00:00', '2024-06-01 00:00:00', '1475.14', '102023063008200020', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063064250020', '202023063054470021', '902023063013840002', '2023052267100146', '12.00', '1475.14', '1475.14', '1.00', null, '2023-06-30 20:18:10', 'ADD', '1400', '2023-06-01 00:00:00', '2024-06-01 00:00:00', '1475.14', '102023063042010019', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063004970023', '202023063080900024', '902023063063470005', '2023052267100146', '12.00', '1475.14', '1475.14', '1.00', null, '2023-06-30 20:29:59', 'ADD', '1400', '2023-06-01 00:00:00', '2024-06-01 00:00:00', '1475.14', '102023063056860022', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063016620018', '202023063098790019', '902023063030180012', '2023052267100146', '1.00', '80.00', '80.00', '1.00', null, '2023-06-30 21:13:18', 'ADD', '1400', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '80.00', '102023063045140017', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063049650009', '202023063022990010', '902023063020170060', '2023052267100146', '1.00', '80.00', '80.00', '1.00', null, '2023-06-30 21:49:25', 'ADD', '1400', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '80.00', '102023063008240008', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063001350027', '202023063024680028', '902023063020170060', '2023052267100146', '-1.00', '-80.00', '-80.00', '7.00', null, '2023-06-30 21:50:14', 'ADD', '1300', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '0.00', '102023063008240008', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023063007210019', '202023063033170020', '902023063050050012', '2023052267100146', '1.00', '80.00', '80.00', '1.00', null, '2023-06-30 22:22:22', 'ADD', '1400', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '80.00', '102023063074170018', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071029970002', '202023071076400003', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:37', 'ADD', '1400', '2023-06-01 00:00:00', '2023-07-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071007910005', '202023071019550006', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:38', 'ADD', '1400', '2023-07-01 00:00:00', '2023-08-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071013050008', '202023071070530009', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:38', 'ADD', '1400', '2023-08-01 00:00:00', '2023-09-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071090170011', '202023071089730012', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:39', 'ADD', '1400', '2023-09-01 00:00:00', '2023-10-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071060030014', '202023071048990015', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:39', 'ADD', '1400', '2023-10-01 00:00:00', '2023-11-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071086060017', '202023071088690018', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:40', 'ADD', '1400', '2023-11-01 00:00:00', '2023-12-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071041280020', '202023071080320021', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:40', 'ADD', '1400', '2023-12-01 00:00:00', '2024-01-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071016910023', '202023071049920024', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:40', 'ADD', '1400', '2024-01-01 00:00:00', '2024-02-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071005190026', '202023071099460027', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:41', 'ADD', '1400', '2024-02-01 00:00:00', '2024-03-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071081770029', '202023071000370030', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:41', 'ADD', '1400', '2024-03-01 00:00:00', '2024-04-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071084350032', '202023071052260033', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '0.00', '1.00', '测试', '2023-07-10 02:01:41', 'ADD', '1400', '2024-04-01 00:00:00', '2024-05-01 00:00:00', '130.00', '102023071055850001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071029400002', '202023071015350003', '90202305221016304946000245', '2023052267100146', '2.00', '260.00', '260.00', '1.00', '测试自定义时间段', '2023-07-10 11:49:55', 'ADD', '1400', '2023-07-01 00:00:00', '2023-09-02 00:00:00', '260.00', '102023071022920001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071029080002', '202023071013540003', '90202305221016304946000245', '2023052267100146', '2.00', '260.00', '260.00', '1.00', '测试自定义时间段', '2023-07-10 12:23:41', 'ADD', '1400', '2023-07-01 00:00:00', '2023-09-02 00:00:00', '260.00', '102023071053440001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071014820005', '202023071021680006', '90202305221016304946000245', '2023052267100146', '0.00', '0.00', '0.00', '1.00', '按缴费时间段缴费,这部分费用按欠费的方式重新生成，请在房屋上查看', '2023-07-10 12:23:42', 'ADD', '1400', '2023-05-01 00:00:00', '2023-07-01 00:00:00', '0.00', '102023071053440001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023071305710009', '202023071337640010', '902023071339960002', '2023052267100146', '1.00', '80.00', '80.00', '1.00', '测试缴费', '2023-07-13 11:17:08', 'ADD', '1400', '2023-07-01 00:00:00', '2023-08-01 00:00:00', '80.00', '102023071364200008', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072579350003', '202023072505110004', '90202305221016304946000245', '2023052267100146', '12.00', '1560.00', '1560.00', '1.00', 'xx', '2023-07-25 09:38:36', 'ADD', '1400', '2023-09-01 00:00:00', '2024-09-01 00:00:00', '1560.00', '102023072514240001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072558540003', '202023072518530004', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '130.00', '1.00', 'xx', '2023-07-25 10:14:31', 'ADD', '1400', '2024-09-01 00:00:00', '2024-10-01 00:00:00', '130.00', '102023072544610001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072525990011', '202023072502260012', '90202305221016304946000245', '2023052267100146', '1.00', '130.00', '130.00', '1.00', null, '2023-07-25 10:15:32', 'ADD', '1400', '2024-10-01 00:00:00', '2024-11-01 00:00:00', '130.00', '102023072537790009', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072523940019', '202023072520600020', '90202307140014433124000014', '2023052267100146', '1.00', '164.90', '164.90', '1.00', null, '2023-07-25 10:23:04', 'ADD', '1400', '2023-07-16 00:00:00', '2023-07-30 00:00:00', '164.90', '102023072564290017', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072545880022', '202023072570960023', '90202307132336312667000006', '2023052267100146', '1.00', '133.90', '133.90', '1.00', null, '2023-07-25 10:23:04', 'ADD', '1400', '2023-07-13 00:00:00', '2023-07-16 00:00:00', '133.90', '102023072564290017', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072569130025', '202023072532250026', '902023071095410007', '2023052267100146', '12.00', '1560.00', '1560.00', '1.00', null, '2023-07-25 10:23:05', 'ADD', '1400', '2023-05-01 00:00:00', '2023-07-01 00:00:00', '1560.00', '102023072564290017', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072507110031', '202023072528600032', '90202307140014438586000021', '2023052267100146', '1.00', '156.80', '156.80', '1.00', null, '2023-07-25 10:42:32', 'ADD', '1400', '2023-07-16 00:00:00', '2023-07-30 00:00:00', '156.80', '102023072507870029', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072558060034', '202023072540500035', '90202307132336312482000018', '2023052267100146', '1.00', '132.60', '132.60', '1.00', null, '2023-07-25 10:42:32', 'ADD', '1400', '2023-07-13 00:00:00', '2023-07-16 00:00:00', '132.60', '102023072507870029', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072561800011', '202023072563890012', '90202305221016304946000245', '2023052267100146', '-1.00', '-130.00', '-130.00', '7.00', null, '2023-07-25 22:53:13', 'ADD', '1300', '2024-10-01 00:00:00', '2024-11-01 00:00:00', '0.00', '102023072537790009', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072521870023', '202023072557620024', '90202305221016304946000245', '2023052267100146', '-1.00', '-130.00', '-130.00', '7.00', 'xx', '2023-07-25 22:54:28', 'ADD', '1300', '2024-09-01 00:00:00', '2024-10-01 00:00:00', '0.00', '102023072544610001', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072674900023', '202023072646150024', '902023072644010004', '2023052267100146', '1.00', '130.00', '130.00', '1.00', '缴费', '2023-07-26 18:34:21', 'ADD', '1400', '2023-09-23 07:35:00', '2023-11-30 02:10:00', '130.00', '102023072660700021', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023072624130021', '202023072668630022', '902023072675470004', '2023052267100146', '1.00', '130.00', '130.00', '1.00', null, '2023-07-26 19:12:20', 'ADD', '1400', '2024-02-01 02:10:00', '2024-03-01 18:35:00', '130.00', '102023072695520019', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023080330990004', '202023080358420005', '902023072638800023', '2023052267100146', '1.00', '130.00', '130.00', '1.00', '测试收据', '2023-08-03 17:53:22', 'ADD', '1400', '2024-01-12 00:00:00', '2024-02-03 00:00:00', '130.00', '102023080309570002', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023080383420014', '202023080389180015', '902023072672550004', '2023052267100146', '1.00', '130.00', '130.00', '1.00', '测试清理浏览器缓存', '2023-08-03 17:56:33', 'ADD', '1400', '2023-12-14 19:35:00', '2024-01-12 07:35:00', '130.00', '102023080331440012', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023081853100004', '202023081828250005', '902023072612320005', '2023052267100146', '1.00', '113.48', '113.48', '1.00', null, '2023-08-18 08:32:21', 'ADD', '1400', '2023-08-01 00:00:00', '2023-09-01 00:00:00', '113.48', '102023081821510002', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023082397350030', '202023082355110031', '902023072612320005', '2023052267100146', '12.00', '1361.81', '1225.63', '1.00', null, '2023-08-23 01:03:18', 'ADD', '1400', '2023-01-01 00:00:00', '2024-01-01 00:00:00', '1361.81', '102023082320550028', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023082674670025', '202023082655870026', '902023082601430015', '2023052267100146', '1.00', '1000.00', '1000.00', '1.00', null, '2023-08-26 09:33:08', 'ADD', '1400', '2023-08-26 00:00:00', '2023-09-27 00:00:00', '1000.00', '102023082692430023', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023090807260004', '202023090810170005', '90202307140014426123000007', '2023052267100146', '1.00', '148.50', '0.00', '1.00', 'ces', '2023-09-08 10:03:39', 'ADD', '1400', '2023-07-16 00:00:00', '2023-08-16 00:00:00', '148.50', '102023090840560002', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023090873900031', '202023090894710032', '902023090872590011', '2023052267100146', '1.00', '113.48', '0.00', '1.00', '优化', '2023-09-08 10:12:07', 'ADD', '1400', '2023-09-01 00:00:00', '2023-10-01 00:00:00', '113.48', '102023090890120029', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023091880980006', '202023091874270007', '902023072685890035', '2023052267100146', '1.00', '130.00', '130.00', '1.00', '优化代码', '2023-09-18 16:42:14', 'ADD', '1400', '2023-11-30 02:10:00', '2023-12-14 19:35:00', '130.00', '102023091804090004', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023092611920025', '202023092640730026', '90202309261758278865000005', '2023052267100146', '1.00', '-1.00', '-1.00', '1.00', null, '2023-09-26 18:05:03', 'ADD', '1400', '2023-11-01 00:00:00', '2023-11-30 00:00:00', '-1.00', '102023092697580023', '30202305221014327189000174', 'HC演示物业', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023100774400005', '202023100759770006', '90202309261758287176000014', '2023052267100146', '1.00', '-1.00', '-1.00', '1.00', null, '2023-10-07 23:01:17', 'ADD', '1400', '2023-11-01 00:00:00', '2023-11-30 00:00:00', '-1.00', '102023100720770003', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023100821150010', '202023100820260011', '902023092822910037', '2023052267100146', '1.00', '130.00', '130.00', '1.00', null, '2023-10-08 01:23:54', 'ADD', '1400', '2023-09-01 00:00:00', '2023-09-30 02:10:00', '130.00', '102023100864360008', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023100800130019', '202023100833810020', '90202309261448421857000011', '2023052267100146', '12.00', '1475.29', '1475.29', '1.00', null, '2023-10-08 01:25:40', 'ADD', '1400', '2023-11-01 00:00:00', '2024-11-01 00:00:00', '1475.29', '102023100895840017', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023100842400003', '202023100831400004', '902023092043940024', '2023052267100146', '12.00', '1362.00', '1362.00', '1.00', '测试', '2023-10-08 01:40:28', 'ADD', '1400', '2023-10-01 00:00:00', '2024-10-01 00:00:00', '1362.00', '102023100893760001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023100882500081', '202023100807680082', '902023092043940024', '2023052267100146', '12.00', '1362.00', '1362.00', '1.00', '测试', '2023-10-08 01:43:42', 'ADD', '1400', '2023-10-01 00:00:00', '2024-10-01 00:00:00', '1362.00', '102023100824740079', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023100879060155', '202023100835360156', '902023092043940024', '2023052267100146', '12.00', '1362.00', '1362.00', '1.00', '测试', '2023-10-08 01:44:55', 'ADD', '1400', '2023-10-01 00:00:00', '2024-10-01 00:00:00', '1362.00', '102023100871300153', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102413300013', '202023102445780014', '902023102341720002', '2023052267100146', '1.00', '15.60', '15.60', '1.00', null, '2023-10-24 14:00:29', 'ADD', '1400', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '15.60', '102023102441540011', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102525670003', '202023102564030004', '902023102520400067', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:55', 'ADD', '1400', '2024-07-01 00:00:00', '2024-07-31 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102528310007', '202023102597950008', '902023102540140060', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:55', 'ADD', '1400', '2024-06-01 00:00:00', '2024-06-30 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102511490011', '202023102515230012', '902023102596810053', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:56', 'ADD', '1400', '2024-05-01 00:00:00', '2024-05-31 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102564230015', '202023102507140016', '902023102516570046', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:56', 'ADD', '1400', '2024-04-01 00:00:00', '2024-04-30 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102592670019', '202023102587000020', '902023102511160039', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:56', 'ADD', '1400', '2024-03-01 00:00:00', '2024-03-31 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102525400023', '202023102506810024', '902023102538060032', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:57', 'ADD', '1400', '2024-02-01 00:00:00', '2024-02-29 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102585760027', '202023102584020028', '902023102540950025', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:57', 'ADD', '1400', '2024-01-01 00:00:00', '2024-01-31 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102547670031', '202023102513500032', '902023102514830018', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:57', 'ADD', '1400', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102529040035', '202023102551270036', '902023102340700021', '2023052267100146', '12.01', '173.00', '173.00', '1.00', '测试缴费', '2023-10-25 03:36:58', 'ADD', '1400', '2023-10-01 00:00:00', '2024-10-01 00:00:00', '173.00', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102505820039', '202023102518540040', '902023101868160006', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:58', 'ADD', '1400', '2023-10-01 00:00:00', '2023-10-31 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102502900043', '202023102525070044', '902023102523530011', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:58', 'ADD', '1400', '2023-11-01 00:00:00', '2023-11-30 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102534450047', '202023102538640048', '902023102514910004', '2023052267100146', '1.00', '15.60', '15.60', '1.00', '测试缴费', '2023-10-25 03:36:59', 'ADD', '1400', '2023-10-01 00:00:00', '2023-10-31 00:00:00', '15.60', '102023102544310001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102527030111', '202023102581230112', '902023102564970081', '2023052267100146', '12.00', '187.20', '15.60', '1.00', null, '2023-10-25 03:38:59', 'ADD', '1400', '2024-09-01 00:00:00', '2024-09-30 00:00:00', '187.20', '102023102552080109', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912023102560510114', '202023102528990115', '902023102552770074', '2023052267100146', '12.00', '187.20', '15.60', '1.00', null, '2023-10-25 03:39:00', 'ADD', '1400', '2024-08-01 00:00:00', '2024-08-31 00:00:00', '187.20', '102023102552080109', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024021759210970', '202024021748270971', '902024021625600935', '2023052267100146', '1.00', '-1.00', '-1.00', '1.00', null, '2024-02-17 09:59:35', 'ADD', '1400', '2024-02-16 00:00:00', '2024-03-16 00:00:00', '-1.00', '102024021728910968', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024021700150973', '202024021777250974', '902024021627450791', '2023052267100146', '1.00', '100.00', '100.00', '1.00', null, '2024-02-17 09:59:36', 'ADD', '1400', '2024-02-13 00:00:00', '2024-03-13 00:00:00', '100.00', '102024021728910968', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024021757490976', '202024021713420977', '902024021641080781', '2023052267100146', '1.00', '1000.00', '1000.00', '1.00', null, '2024-02-17 09:59:36', 'ADD', '1400', '2024-02-16 00:00:00', '2024-03-16 00:00:00', '1000.00', '102024021728910968', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024021871951815', '202024021812641816', '902024021842021797', '2023052267100146', '1.00', '13.00', '13.00', '1.00', null, '2024-02-18 17:43:11', 'ADD', '1400', '2024-02-18 17:42:18', '2024-02-18 17:42:32', '13.00', '102024021860331813', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022008114801', '202024022014054802', '902024022010534758', '2023052267100146', '12.00', '3120.00', '3120.00', '3.00', null, '2024-02-20 10:52:34', 'ADD', '1400', '2024-01-22 00:00:00', '2025-01-22 00:00:00', '3120.00', '102024022038334799', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022037354804', '202024022035114805', '902024022075964538', '2023052267100146', '12.00', '3120.00', '3120.00', '3.00', null, '2024-02-20 10:52:35', 'ADD', '1400', '2024-02-01 00:00:00', '2025-02-01 00:00:00', '3120.00', '102024022038334799', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022013824807', '202024022030944808', '902024021764830992', '2023052267100146', '1.00', '1000.00', '1000.00', '3.00', null, '2024-02-20 10:52:35', 'ADD', '1400', '2024-02-17 00:00:00', '2024-03-17 00:00:00', '1000.00', '102024022038334799', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022030784810', '202024022086434811', '902024021624140758', '2023052267100146', '1.00', '45.00', '45.00', '3.00', null, '2024-02-20 10:52:35', 'ADD', '1400', '2024-02-19 00:00:00', '2024-03-19 00:00:00', '45.00', '102024022038334799', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022067834997', '202024022028244998', '902024022096624954', '2023052267100146', '1.00', '234.00', '234.00', '2.00', null, '2024-02-20 11:19:58', 'ADD', '1400', '2024-02-18 17:42:32', '2024-02-20 11:16:50', '234.00', '102024022008184995', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022090845000', '202024022055875001', '902024022095134877', '2023052267100146', '12.00', '3120.00', '3120.00', '2.00', null, '2024-02-20 11:19:58', 'ADD', '1400', '2023-12-04 00:00:00', '2024-12-04 00:00:00', '3120.00', '102024022008184995', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022048795099', '202024022045305100', '902024022069355073', '2023052267100146', '1.00', '75.00', '75.00', '1.00', null, '2024-02-20 11:30:45', 'ADD', '1400', '2024-02-19 00:00:00', '2024-02-20 11:00:00', '75.00', '102024022094925097', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022055875339', '202024022056035340', '902024022012455302', '2023052267100146', '1.00', '2211.00', '2211.00', '1.00', null, '2024-02-20 14:01:29', 'ADD', '1400', '2024-02-01 00:00:00', '2024-02-20 00:00:00', '2211.00', '102024022002675337', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022042725342', '202024022079135343', '902024022028204673', '2023052267100146', '1.00', '201.00', '201.00', '1.00', null, '2024-02-20 14:01:29', 'ADD', '1400', '2024-02-21 00:00:00', '2024-02-24 00:00:00', '201.00', '102024022002675337', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022038265345', '202024022099475346', '902024022005454571', '2023052267100146', '1.00', '117.00', '117.00', '1.00', null, '2024-02-20 14:01:29', 'ADD', '1400', '2024-01-01 10:10:00', '2024-02-01 10:10:00', '117.00', '102024022002675337', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022078945348', '202024022037835349', '902024022028324557', '2023052267100146', '1.00', '201.00', '201.00', '1.00', null, '2024-02-20 14:01:30', 'ADD', '1400', '2024-02-01 00:00:00', '2024-02-11 00:00:00', '201.00', '102024022002675337', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022041045568', '202024022041995569', '902024022074115557', '2023052267100146', '0.97', '251.03', '251.03', '1.00', null, '2024-02-20 14:23:17', 'ADD', '1400', '2024-02-01 00:00:00', '2024-02-29 00:00:00', '251.03', '102024022031045566', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022057685571', '202024022066725572', '902024022011205546', '2023052267100146', '1.00', '2211.00', '2211.00', '1.00', null, '2024-02-20 14:23:18', 'ADD', '1400', '2024-02-20 00:00:00', '2024-02-21 00:00:00', '2211.00', '102024022031045566', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022074195574', '202024022089455575', '902024022073355529', '2023052267100146', '1.00', '39.00', '39.00', '1.00', null, '2024-02-20 14:23:18', 'ADD', '1400', '2024-02-20 11:16:50', '2024-02-20 14:22:14', '39.00', '102024022031045566', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022130257176', '202024022164387177', '902024022155547128', '2023052267100146', '12.00', '1872.00', '1872.00', '1.00', '现金收费', '2024-02-21 10:55:51', 'ADD', '1400', '2024-02-21 00:00:00', '2025-02-21 00:00:00', '1872.00', '102024022144777174', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022189830273', '202024022140850274', '902024022100820249', '2023052267100146', '1.00', '13.00', '13.00', '3.00', null, '2024-02-21 16:47:16', 'ADD', '1400', '2024-02-21 16:45:01', '2024-02-21 16:50:00', '13.00', '102024022146300271', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022128460482', '202024022152170483', '902024022069105893', '2023052267100146', '12.00', '1475.14', '1475.14', '2.00', null, '2024-02-21 17:41:36', 'ADD', '1400', '2024-02-21 00:00:00', '2025-02-21 00:00:00', '1475.14', '102024022122100480', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022169460485', '202024022121020486', '902023120515420354', '2023052267100146', '5.00', '567.00', '567.00', '2.00', null, '2024-02-21 17:41:37', 'ADD', '1400', '2024-07-01 00:00:00', '2024-12-01 00:00:00', '567.00', '102024022122100480', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022199310754', '202024022189030755', '902024022028915878', '2023052267100146', '12.00', '3120.00', '3120.00', '3.00', null, '2024-02-21 19:48:02', 'ADD', '1400', '2024-02-21 00:00:00', '2025-02-21 00:00:00', '3120.00', '102024022198490752', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022215180163', '202024022204530164', '902024022174527567', '2023052267100146', '1.00', '85.50', '85.50', '1.00', null, '2024-02-22 10:01:11', 'ADD', '1400', '2024-01-03 14:05:00', '2024-02-21 14:05:00', '85.50', '102024022269320161', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022244570166', '202024022202180167', '902024022144097552', '2023052267100146', '12.00', '1440.00', '1440.00', '1.00', null, '2024-02-22 10:01:11', 'ADD', '1400', '2024-02-21 00:00:00', '2025-02-21 00:00:00', '1440.00', '102024022269320161', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022291560169', '202024022276250170', '902024022130327337', '2023052267100146', '1.00', '1000.00', '1000.00', '1.00', null, '2024-02-22 10:01:11', 'ADD', '1400', '2024-01-01 00:00:00', '2024-02-10 00:00:00', '1000.00', '102024022269320161', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022294910172', '202024022250220173', '902024022166067317', '2023052267100146', '12.00', '1404.00', '1404.00', '1.00', null, '2024-02-22 10:01:12', 'ADD', '1400', '2024-01-01 00:00:00', '2025-01-01 00:00:00', '1404.00', '102024022269320161', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022327691366', '202024022304041367', '902024022374401360', '2023052267100146', '1.00', '150.00', '150.00', '3.00', null, '2024-02-23 13:51:43', 'ADD', '1400', '2024-02-23 00:00:00', '2024-03-23 00:00:00', '150.00', '102024022352811364', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022396041369', '202024022352121370', '902024022395140470', '2023052267100146', '1.00', '1000.00', '1000.00', '3.00', null, '2024-02-23 13:51:44', 'ADD', '1400', '2024-02-23 00:00:00', '2050-01-01 00:00:00', '1000.00', '102024022352811364', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022335741372', '202024022351151373', '902024022247370485', '2023052267100146', '1.00', '891.00', '891.00', '3.00', null, '2024-02-23 13:51:44', 'ADD', '1400', '2024-02-01 00:00:00', '2050-01-01 00:00:00', '891.00', '102024022352811364', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022388811375', '202024022336931376', '902024022263260387', '2023052267100146', '1.00', '0.50', '0.50', '3.00', null, '2024-02-23 13:51:44', 'ADD', '1400', '2024-02-22 00:00:00', '2024-03-22 00:00:00', '0.50', '102024022352811364', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022305172562', '202024022361102563', '902024022196947590', '2023052267100146', '1.00', '1.00', '1.00', '3.00', null, '2024-02-23 16:10:04', 'ADD', '1400', '2024-02-23 00:00:00', '2024-02-28 00:00:00', '1.00', '102024022346052560', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022584824392', '202024022528774393', '902024022545514027', '2023052267100146', '12.00', '1248.00', '1248.00', '1.00', null, '2024-02-25 18:57:51', 'ADD', '1400', '2024-02-25 00:00:00', '2025-02-25 00:00:00', '1248.00', '102024022515194390', '30202305221014327189000174', null, 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022656410003', '202024022609580004', '902024022028915878', '2023052267100146', '1.00', '260.00', '260.00', '1.00', null, '2024-02-26 02:37:23', 'ADD', '1400', '2025-02-21 00:00:00', '2025-03-21 00:00:00', '260.00', '102024022687240001', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022608340014', '202024022641390017', '902024022028915878', '2023052267100146', '1.00', '260.00', '0.00', '1.00', null, '2024-02-26 02:38:00', 'ADD', '1400', '2025-03-21 00:00:00', '2025-04-21 00:00:00', '260.00', '102024022649260012', '30202305221014327189000174', 'HC演示物业2', 'N', '260.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022673220186', '202024022604860187', '902024022129070360', '2023052267100146', '1.00', '781.30', '781.30', '7.00', null, '2024-02-26 09:47:09', 'ADD', '1400', '2024-02-21 16:00:00', '2024-02-21 16:50:00', '781.30', '102024022656530184', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022612180585', '202024022670140586', '902024022509734436', '2023052267100146', '1.00', '5.00', '5.00', '1.00', null, '2024-02-26 10:26:40', 'ADD', '1400', '2024-02-25 00:00:00', '2024-03-25 00:00:00', '5.00', '102024022665720583', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022634001640', '202024022649581641', '902024022604320140', '2023052267100146', '2.00', '2.00', '2.00', '3.00', null, '2024-02-26 15:48:12', 'ADD', '1400', '1899-12-01 00:00:00', '1900-02-01 00:00:00', '2.00', '102024022623321638', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022648960117', '202024022631310118', '902024022367010399', '2023052267100146', '1.00', '-1.00', '100.00', '1.00', null, '2024-02-26 17:03:52', 'ADD', '1400', '2024-02-23 00:00:00', '2024-03-23 00:00:00', '-1.00', '102024022682790115', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022628010150', '202024022617510151', '902024022545514027', '2023052267100146', '12.00', '1248.00', '1248.00', '1.00', null, '2024-02-26 17:18:01', 'ADD', '1400', '2025-02-25 00:00:00', '2026-02-25 00:00:00', '1248.00', '102024022653070148', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022690300505', '202024022675810506', '902024022673660499', '2023052267100146', '1.00', '50.00', '50.00', '1.00', null, '2024-02-26 21:01:42', 'ADD', '1400', '2024-02-26 00:00:00', '2024-03-26 00:00:00', '50.00', '102024022611940503', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024022676600538', '202024022621010539', '902024022659540158', '2023052267100146', '1.00', '150.00', '150.00', '1.00', null, '2024-02-26 21:02:48', 'ADD', '1400', '2024-02-26 00:00:00', '2025-01-01 00:00:00', '150.00', '102024022608390536', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024031030650095', '202024031095620096', '902024031031800075', '2023052267100146', '1.00', '0.00', '0.00', '1.00', null, '2024-03-10 21:09:39', 'ADD', '1400', '2024-03-31 23:55:00', '2024-04-10 01:05:00', '0.00', '102024031049680093', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024031086610098', '202024031027790099', '902024031038920055', '2023052267100146', '12.00', '-12.00', '-1.00', '1.00', null, '2024-03-10 21:09:40', 'ADD', '1400', '2024-03-10 21:06:01', '2024-03-31 23:55:00', '-12.00', '102024031049680093', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024031011790101', '202024031097560102', '902024022016455868', '2023052267100146', '12.00', '1896.34', '1896.34', '1.00', null, '2024-03-10 21:09:40', 'ADD', '1400', '2024-02-21 00:00:00', '2025-02-21 00:00:00', '1896.34', '102024031049680093', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024031096650104', '202024031053860105', '902024022280241116', '2023052267100146', '1.00', '108.90', '108.90', '1.00', null, '2024-03-10 21:09:41', 'ADD', '1400', '2024-01-01 00:00:00', '2024-12-31 00:00:00', '108.90', '102024031049680093', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024031020350107', '202024031069960108', '902024022068855883', '2023052267100146', '12.00', '1887.60', '1887.60', '1.00', null, '2024-03-10 21:09:41', 'ADD', '1400', '2024-02-21 00:00:00', '2025-02-21 00:00:00', '1887.60', '102024031049680093', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024031805310020', '202024031821730021', '902024031845670011', '2023052267100146', '1.00', '100.00', '100.00', '1.00', null, '2024-03-18 17:28:58', 'ADD', '1400', '2024-03-18 00:00:00', '2024-04-18 00:00:00', '100.00', '102024031817330018', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `business_pay_fee_detail` VALUES ('912024032266730022', '202024032255150023', '902024031238340008', '2023052267100146', '1.00', '126.00', '126.00', '1.00', null, '2024-03-22 23:01:37', 'ADD', '1400', '2024-03-01 00:00:00', '2024-03-31 00:00:00', '126.00', '102024032227410020', '30202305221014327189000174', 'HC演示物业2', 'N', '0.00', '0.00', '0.00', '0.00', '0.00');

-- ----------------------------
-- Table structure for business_pay_fee_detail_discount
-- ----------------------------
DROP TABLE IF EXISTS `business_pay_fee_detail_discount`;
CREATE TABLE `business_pay_fee_detail_discount` (
  `detail_discount_id` varchar(30) NOT NULL COMMENT '明细优惠',
  `b_id` varchar(30) NOT NULL COMMENT '业务ID',
  `fee_id` varchar(30) NOT NULL COMMENT '费用ID',
  `detail_id` varchar(30) NOT NULL COMMENT '费用明细ID',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `discount_id` varchar(30) NOT NULL COMMENT '折扣ID',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '折扣金额',
  `remark` varchar(512) DEFAULT NULL COMMENT '优惠说明',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  PRIMARY KEY (`detail_discount_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_pay_fee_detail_discount
-- ----------------------------

-- ----------------------------
-- Table structure for business_property_right_registration
-- ----------------------------
DROP TABLE IF EXISTS `business_property_right_registration`;
CREATE TABLE `business_property_right_registration` (
  `prr_id` varchar(30) NOT NULL COMMENT '主键id',
  `b_id` varchar(30) NOT NULL,
  `room_id` varchar(30) NOT NULL COMMENT '房屋id',
  `name` varchar(255) NOT NULL COMMENT '姓名',
  `link` varchar(255) NOT NULL COMMENT '联系方式',
  `id_card` varchar(255) NOT NULL COMMENT '身份证号',
  `address` varchar(255) NOT NULL COMMENT '地址',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_user` varchar(255) NOT NULL COMMENT '创建人',
  `status_cd` varchar(255) NOT NULL DEFAULT '0',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `state` varchar(10) NOT NULL DEFAULT '0' COMMENT '审核状态  0 未审核  1 审核通过  2 审核拒绝',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_property_right_registration
-- ----------------------------
INSERT INTO `business_property_right_registration` VALUES ('102022120950003973', '202022120934865948', '752022120981943969', '1234', '13762785750', '430626199803456092', 'ce', '2022-12-09 21:21:44', '-1', '0', 'ADD', '0', null, '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022120950003973', '202022120975695954', '752022120981943969', '1234', '13762785750', '430626199803456092', 'ce', '2022-12-09 21:22:08', '-1', '0', 'DEL', '0', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022120950003973', '202022120975695954', '752022120981943969', '1234', '13762785750', '430626199803456092', 'ce', '2022-12-09 21:22:08', '-1', '0', 'ADD', '1', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022120950003973', '202022121727400296', '752022120981943969', '1234', '13762785750', '430626199803456092', 'ce', '2022-12-17 22:18:04', '-1', '0', 'DEL', '1', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022120950003973', '202022121727400296', '752022120981943969', '1234', '13762785750', '430626199803456092', 'ce', '2022-12-17 22:18:04', '-1', '0', 'ADD', '0', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022120950003973', '202022122137381415', '752022120981943969', '1234', '13762785750', '430626199803456092', 'ce', '2022-12-21 11:52:52', '-1', '0', 'DEL', '0', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022120950003973', '202022122137381415', '752022120981943969', '1234', '13762785750', '430626199803456092', 'ce', '2022-12-21 11:52:52', '-1', '0', 'ADD', '1', '1', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022122178660544', '202022122180601507', '752022122067940530', '吴学文', '18909711443', '431081198903125666', 'sdf', '2022-12-21 14:10:28', '-1', '0', 'ADD', '0', null, '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022122141530547', '202022122133721516', '752022122067940530', '吴学文', '18909711443', '431081198903125666', 'sdf', '2022-12-21 14:12:08', '-1', '0', 'ADD', '0', null, '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022122430650861', '202022122467272429', '752022121911900401', '啊吧啊吧', '18947314754', '768681189007243679', '啊啊啊', '2022-12-24 16:16:44', '-1', '0', 'ADD', '0', null, '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022122430650861', '2020230107674618096', '752022121911900401', '啊吧啊吧', '18947314754', '768681189007243679', '啊啊啊', '2023-01-07 11:47:02', '-1', '0', 'DEL', '0', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022122430650861', '2020230107674618096', '752022121911900401', '啊吧啊吧', '18947314754', '768681189007243679', '啊啊啊', '2023-01-07 11:47:02', '-1', '0', 'ADD', '1', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022122430650861', '2020230107443318098', '752022121911900401', '啊吧啊吧', '18947314754', '768681189007243679', '啊啊啊', '2023-01-07 11:47:08', '-1', '0', 'DEL', '1', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102022122430650861', '2020230107443318098', '752022121911900401', '啊吧啊吧', '18947314754', '768681189007243679', '啊啊啊', '2023-01-07 11:47:08', '-1', '0', 'ADD', '0', '', '2022120695590004');
INSERT INTO `business_property_right_registration` VALUES ('102024021639850893', '202024021602670894', '752024021610450528', '小雪雪', '13344556677', '430224200008031212', '出租车自行车', '2024-02-16 22:00:07', '-1', '0', 'ADD', '0', null, '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024021639850893', '202024021819732185', '752024021610450528', '小雪雪', '13344556677', '430224200008031212', '出租车自行车', '2024-02-18 21:49:55', '-1', '0', 'DEL', '0', '', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024021639850893', '202024021819732185', '752024021610450528', '小雪雪', '13344556677', '430224200008031212', '出租车自行车', '2024-02-18 21:49:55', '-1', '0', 'ADD', '1', '零零零零', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024021834232199', '202024021836242200', '752024021619860527', '张三', '17645686258', '465256522252456545', '张三', '2024-02-18 21:52:54', '-1', '0', 'ADD', '0', null, '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024021834232199', '202024021856052221', '752024021619860527', '张三', '17645686258', '465256522252456545', '张三', '2024-02-18 21:53:36', '-1', '0', 'DEL', '0', '', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024021834232199', '202024021856052221', '752024021619860527', '张三', '17645686258', '465256522252456545', '张三', '2024-02-18 21:53:36', '-1', '0', 'ADD', '2', '搜索', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024021834232199', '202024021970122438', '752024021619860527', '张三', '17645686258', '465256522252456545', '张三', '2024-02-19 06:28:56', '-1', '0', 'DEL', '2', '搜索', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024021834232199', '202024021970122438', '752024021619860527', '张三', '17645686258', '465256522252456545', '张三', '2024-02-19 06:28:56', '-1', '0', 'ADD', '1', '搜索', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024022019845984', '202024022021295985', '752024021990734183', '张三', '17645686258', '465255566645621526', '1233', '2024-02-20 16:06:57', '-1', '0', 'ADD', '0', null, '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024022019845984', '202024022076666412', '752024021990734183', '张三', '17645686258', '465255566645621526', '1233', '2024-02-20 21:40:02', '-1', '0', 'DEL', '0', '', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024022019845984', '202024022076666412', '752024021996923125', '张三', '17645686258', '465255566645621526', '1233', '2024-02-20 21:40:02', '-1', '0', 'ADD', '0', '', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024022019845984', '202024022066606414', '752024021996923125', '张三', '17645686258', '465255566645621526', '1233', '2024-02-20 21:40:17', '-1', '0', 'DEL', '0', '', '2023052267100146');
INSERT INTO `business_property_right_registration` VALUES ('102024022019845984', '202024022066606414', '752024021990734183', '张三', '17645686258', '465255566645621526', '1233', '2024-02-20 21:40:17', '-1', '0', 'ADD', '0', '', '2023052267100146');

-- ----------------------------
-- Table structure for business_property_right_registration_detail
-- ----------------------------
DROP TABLE IF EXISTS `business_property_right_registration_detail`;
CREATE TABLE `business_property_right_registration_detail` (
  `prrd_id` varchar(30) NOT NULL COMMENT '主键id',
  `prr_id` varchar(30) NOT NULL COMMENT '产权登记id',
  `securities` varchar(255) NOT NULL COMMENT '材料类型   001身份证   002购房合同   003维修基金   004契税',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_user` varchar(255) NOT NULL COMMENT '创建人',
  `operate` varchar(3) NOT NULL DEFAULT '0' COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `is_true` varchar(20) NOT NULL COMMENT '是否缴费  ture 是   false 否'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_property_right_registration_detail
-- ----------------------------

-- ----------------------------
-- Table structure for business_purchase_apply
-- ----------------------------
DROP TABLE IF EXISTS `business_purchase_apply`;
CREATE TABLE `business_purchase_apply` (
  `apply_order_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '订单号',
  `b_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '商户ID',
  `user_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '申请人id',
  `user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '申请人姓名',
  `description` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '申请说明',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `res_order_type` varchar(8) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '出库类型 10000 入库 20000 出库 在t_dict表查看',
  `state` varchar(12) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '申请状态',
  `status_cd` varchar(2) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  `operate` varchar(4) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `end_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '无' COMMENT '物品使用人',
  `end_user_tel` varchar(11) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '无' COMMENT '物品使用人电话',
  `community_id` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '申请人小区id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of business_purchase_apply
-- ----------------------------

-- ----------------------------
-- Table structure for business_purchase_apply_detail
-- ----------------------------
DROP TABLE IF EXISTS `business_purchase_apply_detail`;
CREATE TABLE `business_purchase_apply_detail` (
  `apply_order_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '订单号',
  `b_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '业务ID',
  `res_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '资源ID',
  `quantity` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '数量',
  `remark` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '备注',
  `operate` varchar(4) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `status_cd` varchar(2) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `price` decimal(9,2) DEFAULT NULL COMMENT '采购单价',
  `purchase_quantity` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '采购数量',
  `purchase_remark` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '采购说明',
  `id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '主键ID',
  `rs_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '供应商id',
  `original_stock` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '原有库存',
  KEY `idx_apply_detail_id` (`apply_order_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of business_purchase_apply_detail
-- ----------------------------

-- ----------------------------
-- Table structure for business_repair_pool
-- ----------------------------
DROP TABLE IF EXISTS `business_repair_pool`;
CREATE TABLE `business_repair_pool` (
  `repair_id` varchar(30) NOT NULL COMMENT '报修ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `repair_type` varchar(30) NOT NULL COMMENT '报修类型',
  `repair_name` varchar(30) NOT NULL COMMENT '报修人姓名',
  `tel` varchar(11) NOT NULL COMMENT '手机号',
  `appointment_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '预约时间',
  `context` longtext NOT NULL COMMENT '报修内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `state` varchar(4) NOT NULL COMMENT '报修状态，请查看state 表',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `repair_obj_type` varchar(12) NOT NULL COMMENT '报修对象类型 001 小区 002 楼栋 003 单元 004 房屋',
  `repair_obj_id` varchar(30) NOT NULL COMMENT '报修对象ID',
  `repair_obj_name` varchar(30) NOT NULL COMMENT '报修对象名称',
  `maintenance_type` varchar(10) DEFAULT NULL COMMENT '维修类型  1001有偿服务  1002无偿服务',
  `repair_channel` varchar(2) DEFAULT NULL COMMENT '报修渠道  D员工代客报修  T电话报修 Z业主自主保修',
  `repair_materials` varchar(255) DEFAULT NULL COMMENT '维修物料',
  `repair_fee` varchar(255) DEFAULT NULL COMMENT '费用明细：单价*数量=总价',
  `pay_type` varchar(255) DEFAULT NULL COMMENT '支付方式1、现金2、微信转账3、微信公众号4支付宝'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_repair_pool
-- ----------------------------
INSERT INTO `business_repair_pool` VALUES ('822023053180260013', '202023053119420014', '2023052267100146', '102023053136440010', '张三', '18909711442', '2023-05-31 23:17:45', 'sss', '2023-05-31 23:18:02', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822023080286180037', '202023080275980038', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 13:15:00', '测试', '2023-08-02 13:15:58', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822023080286180037', '202023080252750054', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 13:15:00', '测试', '2023-08-02 13:18:48', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080286180037', '202023080252750054', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 13:15:00', '测试', '2023-08-02 13:18:48', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080286180037', '202023080281290072', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 13:15:00', '测试', '2023-08-02 13:20:54', '1100', 'DEL', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080286180037', '202023080281290072', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 13:15:00', '测试', '2023-08-02 13:20:54', '1700', 'ADD', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080286180037', '202023080251920006', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 13:15:00', '测试', '2023-08-02 15:17:30', '1700', 'DEL', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080286180037', '202023080251920006', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 13:15:00', '测试', '2023-08-02 15:17:30', '1200', 'ADD', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080295130004', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 15:52:16', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080207040013', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 16:10:58', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080207040013', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 16:10:58', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080237160024', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 16:14:13', '1100', 'DEL', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080237160024', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 16:14:13', '1700', 'ADD', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080246110029', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 16:14:36', '1700', 'DEL', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080246110029', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 16:14:36', '1200', 'ADD', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080288880040', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 16:15:12', '1200', 'DEL', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023080257540003', '202023080288880040', '2023052267100146', '102023053136440010', 'qq1', '18109711443', '2023-08-02 15:52:00', '水电费', '2023-08-02 16:15:12', '1700', 'ADD', '001', '2023052267100146', 'HC演示小区', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023053180260013', '202023090837810014', '2023052267100146', '102023053136440010', '张三', '18909711442', '2023-05-31 23:17:45', 'sss', '2023-09-08 16:05:21', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023053180260013', '202023090837810014', '2023052267100146', '102023053136440010', '张三', '18909711442', '2023-05-31 23:17:45', 'sss', '2023-09-08 16:05:21', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023101999700015', '202023101973560016', '2023052267100146', '102023053136440010', 'qq2', '18109711443', '2023-10-19 16:56:00', '水电费', '2023-10-19 16:57:07', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024010871860031', '202024010844000032', '2023052267100146', '102023053136440010', '吴学文', '18109711443', '2024-01-08 16:37:00', '123', '2024-01-08 16:37:19', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021578840256', '202024021593920257', '2023052267100146', '102023053136440010', '今天', '13612213663', '2024-02-15 13:26:00', '测试', '2024-02-15 13:27:51', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'D', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021578840256', '202024021639910804', '2023052267100146', '102023053136440010', '今天', '13612213663', '2024-02-15 13:26:00', '测试', '2024-02-16 19:09:59', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'D', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021578840256', '202024021639910804', '2023052267100146', '102023053136440010', '今天', '13612213663', '2024-02-15 13:26:00', '测试', '2024-02-16 19:09:59', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'D', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024010871860031', '202024021615270833', '2023052267100146', '102023053136440010', '吴学文', '18109711443', '2024-01-08 16:37:00', '123', '2024-02-16 21:05:06', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024010871860031', '202024021615270833', '2023052267100146', '102023053136440010', '吴学文', '18109711443', '2024-01-08 16:37:00', '123', '2024-02-16 21:05:06', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023101999700015', '202024021761671275', '2023052267100146', '102023053136440010', 'qq2', '18109711443', '2023-10-19 16:56:00', '水电费', '2024-02-17 21:20:10', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822023101999700015', '202024021761671275', '2023052267100146', '102023053136440010', 'qq2', '18109711443', '2023-10-19 16:56:00', '水电费', '2024-02-17 21:20:10', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021727861281', '202024021797621282', '2023052267100146', '102023053136440010', '123', '18735172233', '2024-02-17 21:22:35', '123', '2024-02-17 21:23:09', '1000', 'ADD', '002', '732024021518860179', '2栋', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021727861281', '202024021814451384', '2023052267100146', '102023053136440010', '123', '18735172233', '2024-02-17 21:22:35', '123', '2024-02-18 08:51:30', '1000', 'DEL', '002', '732024021518860179', '2栋', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021727861281', '202024021814451384', '2023052267100146', '102023053136440010', '123', '18735172233', '2024-02-17 21:22:35', '123', '2024-02-18 08:51:30', '1100', 'ADD', '002', '732024021518860179', '2栋', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021898611465', '202024021839671466', '2023052267100146', '102023053136440010', '11', '17606527952', '2024-02-18 11:26:07', '11', '2024-02-18 11:26:56', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021898611465', '202024021828541474', '2023052267100146', '102023053136440010', '11', '17606527952', '2024-02-18 11:26:07', '11', '2024-02-18 11:27:17', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021898611465', '202024021828541474', '2023052267100146', '102023053136440010', '11', '17606527952', '2024-02-18 11:26:07', '11', '2024-02-18 11:27:17', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021838981480', '202024021893991481', '2023052267100146', '102023053136440010', '111', '17609528951', '2024-02-18 11:27:04', '11', '2024-02-18 11:27:49', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021838981480', '202024021809951905', '2023052267100146', '102023053136440010', '111', '17609528951', '2024-02-18 11:27:04', '11', '2024-02-18 20:10:41', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021838981480', '202024021809951905', '2023052267100146', '102023053136440010', '111', '17609528951', '2024-02-18 11:27:04', '11', '2024-02-18 20:10:41', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021856891935', '202024021830711936', '2023052267100146', '102024021885971825', '嘀嘀嘀', '19173406232', '2024-02-18 20:19:25', 'aaa', '2024-02-18 20:20:00', '1000', 'ADD', '004', '752024021686490709', '3栋0单元3-201室', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021856891935', '202024021840431951', '2023052267100146', '102024021885971825', '嘀嘀嘀', '19173406232', '2024-02-18 20:19:25', 'aaa', '2024-02-18 20:20:47', '1000', 'DEL', '004', '752024021686490709', '3栋0单元3-201室', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021856891935', '202024021840431951', '2023052267100146', '102024021885971825', '嘀嘀嘀', '19173406232', '2024-02-18 20:19:25', 'aaa', '2024-02-18 20:20:47', '1100', 'ADD', '004', '752024021686490709', '3栋0单元3-201室', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021881941972', '202024021810191973', '2023052267100146', '102023053136440010', '定jjj', '15245896525', '2024-02-18 20:31:20', 'hhhh', '2024-02-18 20:32:08', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021881941972', '202024021853301981', '2023052267100146', '102023053136440010', '定jjj', '15245896525', '2024-02-18 20:31:20', 'hhhh', '2024-02-18 20:32:25', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021881941972', '202024021853301981', '2023052267100146', '102023053136440010', '定jjj', '15245896525', '2024-02-18 20:31:20', 'hhhh', '2024-02-18 20:32:25', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021881941972', '202024021821342233', '2023052267100146', '102023053136440010', '定jjj', '15245896525', '2024-02-18 20:31:20', 'hhhh', '2024-02-18 21:55:00', '1100', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021881941972', '202024021821342233', '2023052267100146', '102023053136440010', '定jjj', '15245896525', '2024-02-18 20:31:20', 'hhhh', '2024-02-18 21:55:00', '1800', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021993402417', '202024021994332418', '2023052267100146', '102024021885971825', '吴学文', '18109711443', '2024-02-19 04:10:23', '测试数据', '2024-02-19 04:13:55', '1000', 'ADD', '004', '752024010438310020', '1-1-1002', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021993402417', '202024021972362917', '2023052267100146', '102024021885971825', '吴学文', '18109711443', '2024-02-19 04:10:23', '测试数据', '2024-02-19 10:23:18', '1000', 'DEL', '004', '752024010438310020', '1-1-1002', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021993402417', '202024021972362917', '2023052267100146', '102024021885971825', '吴学文', '18109711443', '2024-02-19 04:10:23', '测试数据', '2024-02-19 10:23:18', '1100', 'ADD', '004', '752024010438310020', '1-1-1002', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021994403916', '202024021948533917', '2023052267100146', '102023053136440010', '111', '13510421231', '2024-02-19 18:01:14', '111', '2024-02-19 18:01:35', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024021994403916', '202024021995693925', '2023052267100146', '102023053136440010', '111', '13510421231', '2024-02-19 18:01:14', '111', '2024-02-19 18:01:53', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024021994403916', '202024021995693925', '2023052267100146', '102023053136440010', '111', '13510421231', '2024-02-19 18:01:14', '111', '2024-02-19 18:01:53', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022047255287', '202024022021805288', '2023052267100146', '102024021885971825', '测试2222222', '18049392222', '2024-02-20 13:50:10', '222222', '2024-02-20 13:50:53', '1000', 'ADD', '004', '752024021954542993', '1栋1单元2室', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022047255287', '202024022003865296', '2023052267100146', '102024021885971825', '测试2222222', '18049392222', '2024-02-20 13:50:10', '222222', '2024-02-20 13:51:44', '1000', 'DEL', '004', '752024021954542993', '1栋1单元2室', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022047255287', '202024022003865296', '2023052267100146', '102024021885971825', '测试2222222', '18049392222', '2024-02-20 13:50:10', '222222', '2024-02-20 13:51:44', '1100', 'ADD', '004', '752024021954542993', '1栋1单元2室', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022050325373', '202024022097725374', '2023052267100146', '102024022016205365', '是的', '13312341234', '2024-02-20 14:02:05', '地方', '2024-02-20 14:02:29', '1000', 'ADD', '003', '742023120517690335', '1栋1单元', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022050325373', '202024022089005382', '2023052267100146', '102024022016205365', '是的', '13312341234', '2024-02-20 14:02:05', '地方', '2024-02-20 14:02:53', '1000', 'DEL', '003', '742023120517690335', '1栋1单元', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022050325373', '202024022089005382', '2023052267100146', '102024022016205365', '是的', '13312341234', '2024-02-20 14:02:05', '地方', '2024-02-20 14:02:53', '1100', 'ADD', '003', '742023120517690335', '1栋1单元', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022050325373', '202024022052855401', '2023052267100146', '102024022016205365', '是的', '13312341234', '2024-02-20 14:02:05', '地方', '2024-02-20 14:04:39', '1100', 'DEL', '003', '742023120517690335', '1栋1单元', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022050325373', '202024022052855401', '2023052267100146', '102024022016205365', '是的', '13312341234', '2024-02-20 14:02:05', '地方', '2024-02-20 14:04:39', '1800', 'ADD', '003', '742023120517690335', '1栋1单元', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022044165442', '202024022005475443', '2023052267100146', '102024022016205365', '游客', '13105086216', '2024-02-20 14:08:00', '1', '2024-02-20 14:08:31', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022044165442', '202024022079545636', '2023052267100146', '102024022016205365', '游客', '13105086216', '2024-02-20 14:08:00', '1', '2024-02-20 14:28:24', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022044165442', '202024022079545636', '2023052267100146', '102024022016205365', '游客', '13105086216', '2024-02-20 14:08:00', '1', '2024-02-20 14:28:24', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022039155647', '202024022051745648', '2023052267100146', '102024021885971825', '试试', '13312341111', '2024-02-20 14:30:51', '叔叔都是', '2024-02-20 14:31:10', '1000', 'ADD', '004', '752024021610450528', '1栋0单元201室', null, null, null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022039155647', '202024022067715692', '2023052267100146', '102024021885971825', '试试', '13312341111', '2024-02-20 14:30:51', '叔叔都是', '2024-02-20 14:48:34', '1000', 'DEL', '004', '752024021610450528', '1栋0单元201室', '', '', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022039155647', '202024022067715692', '2023052267100146', '102024021885971825', '试试', '13312341111', '2024-02-20 14:30:51', '叔叔都是', '2024-02-20 14:48:34', '1100', 'ADD', '004', '752024021610450528', '1栋0单元201室', '', '', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022064715720', '202024022058325721', '2023052267100146', '102024022016205365', '1', '18909711443', '2024-02-20 14:50:00', '1', '2024-02-20 14:51:32', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'D', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022064715720', '202024022022535729', '2023052267100146', '102024022016205365', '1', '18909711443', '2024-02-20 14:50:00', '1', '2024-02-20 14:51:49', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'D', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022064715720', '202024022022535729', '2023052267100146', '102024022016205365', '1', '18909711443', '2024-02-20 14:50:00', '1', '2024-02-20 14:51:49', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'D', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022098366078', '202024022053536079', '2023052267100146', '102024021885971825', '啧啧啧', '18234905095', '2024-02-20 16:41:07', '没有今', '2024-02-20 16:41:34', '1000', 'ADD', '004', '752024021990734183', '2栋0单元110室', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022098366078', '202024022091066087', '2023052267100146', '102024021885971825', '啧啧啧', '18234905095', '2024-02-20 16:41:07', '没有今', '2024-02-20 16:42:00', '1000', 'DEL', '004', '752024021990734183', '2栋0单元110室', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022098366078', '202024022091066087', '2023052267100146', '102024021885971825', '啧啧啧', '18234905095', '2024-02-20 16:41:07', '没有今', '2024-02-20 16:42:00', '1100', 'ADD', '004', '752024021990734183', '2栋0单元110室', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022113356750', '202024022148666751', '2023052267100146', '102024022016205365', '游客', '15702460746', '2024-02-21 09:07:00', '1', '2024-02-21 09:07:43', '1000', 'ADD', '002', '732024021990293300', '123栋', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022174617154', '202024022153557155', '2023052267100146', '102024022016205365', '赵子龙', '13800138001', '2024-02-21 14:40:00', '换灯', '2024-02-21 10:49:32', '1000', 'ADD', '003', '742023120517690335', '1栋1单元', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022174617154', '202024022211750150', '2023052267100146', '102024022016205365', '赵子龙', '13800138001', '2024-02-21 14:40:00', '换灯', '2024-02-22 16:22:34', '1000', 'DEL', '003', '742023120517690335', '1栋1单元', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022174617154', '202024022211750150', '2023052267100146', '102024022016205365', '赵子龙', '13800138001', '2024-02-21 14:40:00', '换灯', '2024-02-22 16:22:34', '1100', 'ADD', '003', '742023120517690335', '1栋1单元', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022174617154', '202024022220630164', '2023052267100146', '102024022016205365', '赵子龙', '13800138001', '2024-02-21 14:40:00', '换灯', '2024-02-22 16:24:55', '1100', 'DEL', '003', '742023120517690335', '1栋1单元', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022174617154', '202024022220630164', '2023052267100146', '102024022016205365', '赵子龙', '13800138001', '2024-02-21 14:40:00', '换灯', '2024-02-22 16:24:55', '1800', 'ADD', '003', '742023120517690335', '1栋1单元', '1004', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022369452088', '202024022364692089', '2023052267100146', '102024021885971825', '陈某人', '17317539405', '2024-02-23 14:04:00', '风格', '2024-02-23 14:04:37', '1000', 'ADD', '004', '752024022240580266', '1232号楼1单元103室', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022461353798', '202024022401893799', '2023052267100146', '102023053136440010', '11', '18765498976', '2024-02-24 21:15:30', 'w', '2024-02-24 21:15:58', '1000', 'ADD', '001', '2023052267100146', 'HC演示小区3', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022461353798', '202024022512404354', '2023052267100146', '102023053136440010', '11', '18765498976', '2024-02-24 21:15:30', 'w', '2024-02-25 18:54:21', '1000', 'DEL', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022461353798', '202024022512404354', '2023052267100146', '102023053136440010', '11', '18765498976', '2024-02-24 21:15:30', 'w', '2024-02-25 18:54:21', '1100', 'ADD', '001', '2023052267100146', 'HC演示小区3', '', 'T', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022369452088', '202024022569534364', '2023052267100146', '102024021885971825', '陈某人', '17317539405', '2024-02-23 14:04:00', '风格', '2024-02-25 18:54:39', '1000', 'DEL', '004', '752024022240580266', '1232号楼1单元103室', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022369452088', '202024022569534364', '2023052267100146', '102024021885971825', '陈某人', '17317539405', '2024-02-23 14:04:00', '风格', '2024-02-25 18:54:39', '1100', 'ADD', '004', '752024022240580266', '1232号楼1单元103室', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022113356750', '202024022513774374', '2023052267100146', '102024022016205365', '游客', '15702460746', '2024-02-21 09:07:00', '1', '2024-02-25 18:54:49', '1000', 'DEL', '002', '732024021990293300', '123栋', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022113356750', '202024022513774374', '2023052267100146', '102024022016205365', '游客', '15702460746', '2024-02-21 09:07:00', '1', '2024-02-25 18:54:49', '1100', 'ADD', '002', '732024021990293300', '123栋', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022663000249', '202024022655180250', '2023052267100146', '102024021885971825', 'UBUHU', '19212535322', '2024-02-26 17:35:51', '疏通下水道', '2024-02-26 17:36:54', '1000', 'ADD', '004', '752024022246330013', '2栋1单元111室', null, 'T', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022733680019', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 14:27:09', '1000', 'ADD', '004', '752024012283880019', '22号楼3单元2003室', null, 'Z', null, null, null);
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022739890027', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 14:27:50', '1000', 'DEL', '004', '752024012283880019', '22号楼3单元2003室', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022739890027', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 14:27:50', '1100', 'ADD', '004', '752024012283880019', '22号楼3单元2003室', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022745750044', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 17:46:03', '1100', 'DEL', '004', '752024012283880019', '22号楼3单元2003室', '', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022745750044', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 17:46:03', '1100', 'ADD', '004', '752024012283880019', '22号楼3单元2003室', '1002', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022729210045', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 17:46:03', '1100', 'DEL', '004', '752024012283880019', '22号楼3单元2003室', '1002', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022729210045', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 17:46:03', '1700', 'ADD', '004', '752024012283880019', '22号楼3单元2003室', '1002', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022741510048', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 17:47:28', '1700', 'DEL', '004', '752024012283880019', '22号楼3单元2003室', '1002', 'Z', '', '', '');
INSERT INTO `business_repair_pool` VALUES ('822024022794890018', '202024022741510048', '2024012252790005', '102024022738800012', '张飞3', '18922224444', '2024-02-27 14:09:00', '测试完成', '2024-02-27 17:47:28', '1800', 'ADD', '004', '752024012283880019', '22号楼3单元2003室', '1002', 'Z', '', '', '');

-- ----------------------------
-- Table structure for business_repair_setting
-- ----------------------------
DROP TABLE IF EXISTS `business_repair_setting`;
CREATE TABLE `business_repair_setting` (
  `setting_id` varchar(30) NOT NULL COMMENT '工单设置ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务ID',
  `repair_type` varchar(30) NOT NULL COMMENT '报修类型',
  `repair_type_name` varchar(200) NOT NULL COMMENT '报修类型名称',
  `repair_way` varchar(12) NOT NULL COMMENT '派单方式 t_dict 100 抢单 200 指派 300 轮训',
  `community_id` varchar(30) NOT NULL COMMENT '小区分片ID',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `public_area` varchar(12) NOT NULL DEFAULT 'F' COMMENT '是否为公共区域',
  `pay_fee_flag` varchar(12) NOT NULL DEFAULT 'F' COMMENT '是否收费 T为是 F为否',
  `price_scope` varchar(12) DEFAULT '0元' COMMENT '收费范围，如30元至50元',
  `return_visit_flag` varchar(12) NOT NULL DEFAULT '001' COMMENT '回访标识 001 都不回访 002 已评价不回访 003 都回访',
  `repair_setting_type` varchar(30) DEFAULT NULL COMMENT '报修设置类型',
  `is_show` varchar(12) NOT NULL COMMENT '业主端是否展示  Y 是  N 否',
  `notify_way` varchar(12) NOT NULL COMMENT '通知方式，SMS 短信 WECHAT 微信'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_repair_setting
-- ----------------------------

-- ----------------------------
-- Table structure for business_repair_type_user
-- ----------------------------
DROP TABLE IF EXISTS `business_repair_type_user`;
CREATE TABLE `business_repair_type_user` (
  `type_user_id` varchar(30) NOT NULL COMMENT '工单设置ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务ID',
  `repair_type` varchar(30) NOT NULL COMMENT '报修类型',
  `staff_id` varchar(30) NOT NULL COMMENT '员工ID',
  `staff_name` varchar(30) NOT NULL COMMENT '员工名称',
  `community_id` varchar(30) NOT NULL COMMENT '小区分片ID',
  `state` varchar(12) NOT NULL DEFAULT '9999' COMMENT '状态 9999 在线 8888 离线 t_dict 表',
  `remark` varchar(500) DEFAULT NULL COMMENT '描述，一般为状态变更描述',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_repair_type_user
-- ----------------------------

-- ----------------------------
-- Table structure for business_repair_user
-- ----------------------------
DROP TABLE IF EXISTS `business_repair_user`;
CREATE TABLE `business_repair_user` (
  `ru_id` varchar(30) NOT NULL COMMENT '报修派单ID',
  `repair_id` varchar(30) NOT NULL COMMENT '报修ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `state` varchar(8) NOT NULL COMMENT '员工处理状态，请查看t_dict 表',
  `context` longtext COMMENT '报修内容',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `staff_id` varchar(30) NOT NULL COMMENT '当前处理员工',
  `staff_name` varchar(64) NOT NULL COMMENT '当前处理员工名称',
  `pre_staff_id` varchar(30) NOT NULL COMMENT '上一节点处理员工',
  `pre_staff_name` varchar(64) NOT NULL COMMENT '上一节点处理员工名称',
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '开始时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '结束时间',
  `repair_event` varchar(12) NOT NULL COMMENT '事件，startUser 开始用户 auditUser 审核处理员工',
  `pre_ru_id` varchar(30) NOT NULL COMMENT '上一节点处理ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_repair_user
-- ----------------------------
INSERT INTO `business_repair_user` VALUES ('832023053118940015', '822023053180260013', '202023053100950016', '2023052267100146', '2023-05-31 23:18:02', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业', '-1', '-1', '2023-05-31 23:18:02', '2023-05-31 23:18:02', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832023080286570039', '822023080286180037', '202023080278260040', '2023052267100146', '2023-08-02 13:15:58', '10005', '订单提交', 'ADD', '302023063083030056', 'qq1', '-1', '-1', '2023-08-02 13:15:58', '2023-08-02 13:15:58', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832023080272840050', '822023080286180037', '202023080257710051', '2023052267100146', '2023-08-02 13:18:47', '10006', '请师傅处理', 'ADD', '30202305221014327189000174', 'HC演示物业', '302023063083030056', 'qq1', '2023-08-02 13:18:47', '2023-08-02 13:18:47', 'auditUser', '832023080286570039');
INSERT INTO `business_repair_user` VALUES ('832023080225200052', '822023080286180037', '202023080214980053', '2023052267100146', '2023-08-02 13:18:47', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业', '2023-08-02 13:19:17', null, 'auditUser', '832023080272840050');
INSERT INTO `business_repair_user` VALUES ('832023080225200052', '822023080286180037', '202023080280410066', '2023052267100146', '2023-08-02 13:20:54', '10002', '感谢', 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业', '2023-08-02 13:19:17', '2023-08-02 13:20:53', 'auditUser', '832023080272840050');
INSERT INTO `business_repair_user` VALUES ('-1', '822023080286180037', '202023080204500067', '2023052267100146', '2023-08-02 13:20:54', '11000', '待评价', 'ADD', '302023063083030056', 'qq1', '302023063083030056', 'qq1', '2023-08-02 13:20:54', null, 'payUser', '832023080286570039');
INSERT INTO `business_repair_user` VALUES ('-1', '822023080286180037', '202023080218940003', '2023052267100146', '2023-08-02 15:17:30', '10003', '测试退费', 'ADD', '302023063083030056', 'qq1', '302023063083030056', 'qq1', '2023-08-02 13:20:54', '2023-08-02 15:17:30', 'payUser', '832023080286570039');
INSERT INTO `business_repair_user` VALUES ('832023080234550004', '822023080286180037', '202023080270660005', '2023052267100146', '2023-08-02 15:17:30', '10001', null, 'ADD', '302023063083030056', 'qq1', '302023063083030056', 'qq1', '2023-08-02 15:17:30', null, 'auditUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832023080283160005', '822023080257540003', '202023080286260006', '2023052267100146', '2023-08-02 15:52:16', '10005', '订单提交', 'ADD', '302023063083030056', 'qq1', '-1', '-1', '2023-08-02 15:52:16', '2023-08-02 15:52:16', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832023080202870009', '822023080257540003', '202023080274140010', '2023052267100146', '2023-08-02 16:10:57', '10006', '张三', 'ADD', '30202305221014327189000174', 'HC演示物业', '302023063083030056', 'qq1', '2023-08-02 16:10:57', '2023-08-02 16:10:57', 'auditUser', '832023080283160005');
INSERT INTO `business_repair_user` VALUES ('832023080268820011', '822023080257540003', '202023080215730012', '2023052267100146', '2023-08-02 16:10:58', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业', '2023-08-02 16:11:28', null, 'auditUser', '832023080202870009');
INSERT INTO `business_repair_user` VALUES ('832023080268820011', '822023080257540003', '202023080286950017', '2023052267100146', '2023-08-02 16:14:13', '10002', 'xx', 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业', '2023-08-02 16:11:28', '2023-08-02 16:14:13', 'auditUser', '832023080202870009');
INSERT INTO `business_repair_user` VALUES ('832023080261890018', '822023080257540003', '202023080214680019', '2023052267100146', '2023-08-02 16:14:13', '11000', '待评价', 'ADD', '302023063083030056', 'qq1', '302023071089700002', 'ddysdd', '2023-08-02 16:14:13', null, 'payUser', '832023080268820011');
INSERT INTO `business_repair_user` VALUES ('832023080261890018', '822023080257540003', '202023080273120026', '2023052267100146', '2023-08-02 16:14:35', '10003', '测试退回', 'ADD', '302023063083030056', 'qq1', '302023071089700002', 'ddysdd', '2023-08-02 16:14:13', '2023-08-02 16:14:35', 'payUser', '832023080268820011');
INSERT INTO `business_repair_user` VALUES ('832023080236100027', '822023080257540003', '202023080220730028', '2023052267100146', '2023-08-02 16:14:36', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '302023063083030056', 'qq1', '2023-08-02 16:14:36', null, 'auditUser', '832023080261890018');
INSERT INTO `business_repair_user` VALUES ('832023080236100027', '822023080257540003', '202023080268810033', '2023052267100146', '2023-08-02 16:15:11', '10002', 'xx', 'ADD', '302023071089700002', 'ddysdd', '302023063083030056', 'qq1', '2023-08-02 16:14:36', '2023-08-02 16:15:11', 'auditUser', '832023080261890018');
INSERT INTO `business_repair_user` VALUES ('832023080259580034', '822023080257540003', '202023080222400035', '2023052267100146', '2023-08-02 16:15:12', '11000', '待评价', 'ADD', '302023063083030056', 'qq1', '302023071089700002', 'ddysdd', '2023-08-02 16:15:11', null, 'payUser', '832023080236100027');
INSERT INTO `business_repair_user` VALUES ('832023090896210010', '822023053180260013', '202023090886030011', '2023052267100146', '2023-09-08 16:05:20', '10006', '试试', 'ADD', '30202305221014327189000174', 'HC演示物业', '30202305221014327189000174', 'HC演示物业', '2023-09-08 16:05:20', '2023-09-08 16:05:20', 'auditUser', '832023053118940015');
INSERT INTO `business_repair_user` VALUES ('832023090845790012', '822023053180260013', '202023090846480013', '2023052267100146', '2023-09-08 16:05:20', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业', '2023-09-08 16:05:50', null, 'auditUser', '832023090896210010');
INSERT INTO `business_repair_user` VALUES ('832023101901530017', '822023101999700015', '202023101971210018', '2023052267100146', '2023-10-19 16:57:07', '10005', '订单提交', 'ADD', '302023101689730005', 'qq2', '-1', '-1', '2023-10-19 16:57:07', '2023-10-19 16:57:07', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024010872820033', '822024010871860031', '202024010894840034', '2023052267100146', '2024-01-08 16:37:19', '10005', '订单提交', 'ADD', '302024010816960022', '吴学文', '-1', '-1', '2024-01-08 16:37:19', '2024-01-08 16:37:19', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021557980258', '822024021578840256', '202024021552700259', '2023052267100146', '2024-02-15 13:27:51', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-15 13:27:51', '2024-02-15 13:27:51', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021684070800', '822024021578840256', '202024021655480801', '2023052267100146', '2024-02-16 19:09:59', '10006', '1', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-16 19:09:58', '2024-02-16 19:09:58', 'auditUser', '832024021557980258');
INSERT INTO `business_repair_user` VALUES ('832024021610490802', '822024021578840256', '202024021659680803', '2023052267100146', '2024-02-16 19:09:59', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业2', '2024-02-16 19:10:29', null, 'auditUser', '832024021684070800');
INSERT INTO `business_repair_user` VALUES ('832024021600130829', '822024010871860031', '202024021643720830', '2023052267100146', '2024-02-16 21:05:06', '10006', '3333', 'ADD', '30202305221014327189000174', 'HC演示物业2', '302024010816960022', '吴学文', '2024-02-16 21:05:05', '2024-02-16 21:05:05', 'auditUser', '832024010872820033');
INSERT INTO `business_repair_user` VALUES ('832024021661790831', '822024010871860031', '202024021601440832', '2023052267100146', '2024-02-16 21:05:06', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业2', '2024-02-16 21:05:36', null, 'auditUser', '832024021600130829');
INSERT INTO `business_repair_user` VALUES ('832024021775191271', '822023101999700015', '202024021725371272', '2023052267100146', '2024-02-17 21:20:10', '10006', '123', 'ADD', '30202305221014327189000174', 'HC演示物业2', '302023101689730005', 'qq2', '2024-02-17 21:20:10', '2024-02-17 21:20:10', 'auditUser', '832023101901530017');
INSERT INTO `business_repair_user` VALUES ('832024021725981273', '822023101999700015', '202024021792451274', '2023052267100146', '2024-02-17 21:20:10', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业2', '2024-02-17 21:20:40', null, 'auditUser', '832024021775191271');
INSERT INTO `business_repair_user` VALUES ('832024021706121283', '822024021727861281', '202024021766031284', '2023052267100146', '2024-02-17 21:23:09', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-17 21:23:09', '2024-02-17 21:23:09', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021805351380', '822024021727861281', '202024021878551381', '2023052267100146', '2024-02-18 08:51:29', '10006', '尽快上门维修', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 08:51:29', '2024-02-18 08:51:29', 'auditUser', '832024021706121283');
INSERT INTO `business_repair_user` VALUES ('832024021841421382', '822024021727861281', '202024021895141383', '2023052267100146', '2024-02-18 08:51:29', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 08:51:59', null, 'auditUser', '832024021805351380');
INSERT INTO `business_repair_user` VALUES ('832024021810471467', '822024021898611465', '202024021830191468', '2023052267100146', '2024-02-18 11:26:57', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-18 11:26:56', '2024-02-18 11:26:56', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021860721470', '822024021898611465', '202024021855861471', '2023052267100146', '2024-02-18 11:27:16', '10006', '4111', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 11:27:16', '2024-02-18 11:27:16', 'auditUser', '832024021810471467');
INSERT INTO `business_repair_user` VALUES ('832024021885371472', '822024021898611465', '202024021883331473', '2023052267100146', '2024-02-18 11:27:17', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 11:27:46', null, 'auditUser', '832024021860721470');
INSERT INTO `business_repair_user` VALUES ('832024021861291482', '822024021838981480', '202024021863221483', '2023052267100146', '2024-02-18 11:27:49', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-18 11:27:49', '2024-02-18 11:27:49', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021844821901', '822024021838981480', '202024021848671902', '2023052267100146', '2024-02-18 20:10:41', '10006', '..', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 20:10:41', '2024-02-18 20:10:41', 'auditUser', '832024021861291482');
INSERT INTO `business_repair_user` VALUES ('832024021864791903', '822024021838981480', '202024021811101904', '2023052267100146', '2024-02-18 20:10:41', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 20:11:11', null, 'auditUser', '832024021844821901');
INSERT INTO `business_repair_user` VALUES ('832024021873791937', '822024021856891935', '202024021818501938', '2023052267100146', '2024-02-18 20:20:00', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-18 20:20:00', '2024-02-18 20:20:00', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021869551947', '822024021856891935', '202024021845881948', '2023052267100146', '2024-02-18 20:20:47', '10006', '。。。。', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 20:20:47', '2024-02-18 20:20:47', 'auditUser', '832024021873791937');
INSERT INTO `business_repair_user` VALUES ('832024021880691949', '822024021856891935', '202024021817371950', '2023052267100146', '2024-02-18 20:20:47', '10001', null, 'ADD', '302024021861111923', 'aaaaa', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 20:21:17', null, 'auditUser', '832024021869551947');
INSERT INTO `business_repair_user` VALUES ('832024021889881974', '822024021881941972', '202024021898581975', '2023052267100146', '2024-02-18 20:32:08', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-18 20:32:08', '2024-02-18 20:32:08', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021850061977', '822024021881941972', '202024021881941978', '2023052267100146', '2024-02-18 20:32:24', '10006', 'hhhh', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 20:32:24', '2024-02-18 20:32:24', 'auditUser', '832024021889881974');
INSERT INTO `business_repair_user` VALUES ('832024021807131979', '822024021881941972', '202024021811581980', '2023052267100146', '2024-02-18 20:32:24', '10001', null, 'ADD', '302024021861111923', 'aaaaa', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 20:32:54', null, 'auditUser', '832024021850061977');
INSERT INTO `business_repair_user` VALUES ('832024021807131979', '822024021881941972', '202024021838512228', '2023052267100146', '2024-02-18 21:55:00', '10002', 'hhh', 'ADD', '302024021861111923', 'aaaaa', '30202305221014327189000174', 'HC演示物业2', '2024-02-18 20:32:54', '2024-02-18 21:55:00', 'auditUser', '832024021850061977');
INSERT INTO `business_repair_user` VALUES ('832024021963022419', '822024021993402417', '202024021976002420', '2023052267100146', '2024-02-19 04:13:55', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-19 04:13:55', '2024-02-19 04:13:55', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021922422913', '822024021993402417', '202024021989152914', '2023052267100146', '2024-02-19 10:23:18', '10006', 'qq', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-19 10:23:18', '2024-02-19 10:23:18', 'auditUser', '832024021963022419');
INSERT INTO `business_repair_user` VALUES ('832024021948252915', '822024021993402417', '202024021940722916', '2023052267100146', '2024-02-19 10:23:18', '10001', null, 'ADD', '302024021861111923', 'aaaaa', '30202305221014327189000174', 'HC演示物业2', '2024-02-19 10:23:48', null, 'auditUser', '832024021922422913');
INSERT INTO `business_repair_user` VALUES ('832024021978033918', '822024021994403916', '202024021983373919', '2023052267100146', '2024-02-19 18:01:35', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-19 18:01:35', '2024-02-19 18:01:35', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024021987133921', '822024021994403916', '202024021945633922', '2023052267100146', '2024-02-19 18:01:53', '10006', '东方闪电', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-19 18:01:53', '2024-02-19 18:01:53', 'auditUser', '832024021978033918');
INSERT INTO `business_repair_user` VALUES ('832024021999363923', '822024021994403916', '202024021964053924', '2023052267100146', '2024-02-19 18:01:53', '10001', null, 'ADD', '302024021861111923', 'aaaaa', '30202305221014327189000174', 'HC演示物业2', '2024-02-19 18:02:23', null, 'auditUser', '832024021987133921');
INSERT INTO `business_repair_user` VALUES ('832024022034845289', '822024022047255287', '202024022025735290', '2023052267100146', '2024-02-20 13:50:53', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-20 13:50:53', '2024-02-20 13:50:53', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022005435292', '822024022047255287', '202024022030075293', '2023052267100146', '2024-02-20 13:51:44', '10006', '京津冀', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 13:51:44', '2024-02-20 13:51:44', 'auditUser', '832024022034845289');
INSERT INTO `business_repair_user` VALUES ('832024022083785294', '822024022047255287', '202024022061745295', '2023052267100146', '2024-02-20 13:51:44', '10001', null, 'ADD', '302024021861111923', 'aaaaa', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 13:52:14', null, 'auditUser', '832024022005435292');
INSERT INTO `business_repair_user` VALUES ('832024022022025375', '822024022050325373', '202024022020025376', '2023052267100146', '2024-02-20 14:02:29', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-20 14:02:29', '2024-02-20 14:02:29', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022082815378', '822024022050325373', '202024022082185379', '2023052267100146', '2024-02-20 14:02:53', '10006', '地方', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 14:02:53', '2024-02-20 14:02:53', 'auditUser', '832024022022025375');
INSERT INTO `business_repair_user` VALUES ('832024022059155380', '822024022050325373', '202024022061525381', '2023052267100146', '2024-02-20 14:02:53', '10001', null, 'ADD', '302024022077105316', '维修师傅', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 14:03:23', null, 'auditUser', '832024022082815378');
INSERT INTO `business_repair_user` VALUES ('832024022059155380', '822024022050325373', '202024022011455396', '2023052267100146', '2024-02-20 14:04:39', '10002', '是的痘痘痘痘', 'ADD', '302024022077105316', '维修师傅', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 14:03:23', '2024-02-20 14:04:39', 'auditUser', '832024022082815378');
INSERT INTO `business_repair_user` VALUES ('832024022015985444', '822024022044165442', '202024022009575445', '2023052267100146', '2024-02-20 14:08:31', '10005', '订单提交', 'ADD', '302024022056495428', '13105086216', '-1', '-1', '2024-02-20 14:08:31', '2024-02-20 14:08:31', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022077355632', '822024022044165442', '202024022086865633', '2023052267100146', '2024-02-20 14:28:24', '10006', '222', 'ADD', '30202305221014327189000174', 'HC演示物业2', '302024022056495428', '13105086216', '2024-02-20 14:28:24', '2024-02-20 14:28:24', 'auditUser', '832024022015985444');
INSERT INTO `business_repair_user` VALUES ('832024022073495634', '822024022044165442', '202024022086925635', '2023052267100146', '2024-02-20 14:28:24', '10001', null, 'ADD', '302024022077105316', '维修师傅', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 14:28:54', null, 'auditUser', '832024022077355632');
INSERT INTO `business_repair_user` VALUES ('832024022062365649', '822024022039155647', '202024022043985650', '2023052267100146', '2024-02-20 14:31:10', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-20 14:31:10', '2024-02-20 14:31:10', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022025795688', '822024022039155647', '202024022075765689', '2023052267100146', '2024-02-20 14:48:33', '10006', '1', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 14:48:33', '2024-02-20 14:48:33', 'auditUser', '832024022062365649');
INSERT INTO `business_repair_user` VALUES ('832024022087695690', '822024022039155647', '202024022048995691', '2023052267100146', '2024-02-20 14:48:33', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 14:49:03', null, 'auditUser', '832024022025795688');
INSERT INTO `business_repair_user` VALUES ('832024022010435722', '822024022064715720', '202024022067505723', '2023052267100146', '2024-02-20 14:51:33', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-20 14:51:32', '2024-02-20 14:51:32', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022047115725', '822024022064715720', '202024022092145726', '2023052267100146', '2024-02-20 14:51:49', '10006', '1', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 14:51:49', '2024-02-20 14:51:49', 'auditUser', '832024022010435722');
INSERT INTO `business_repair_user` VALUES ('832024022052465727', '822024022064715720', '202024022011975728', '2023052267100146', '2024-02-20 14:51:49', '10001', null, 'ADD', '302024022077105316', '维修师傅', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 14:52:19', null, 'auditUser', '832024022047115725');
INSERT INTO `business_repair_user` VALUES ('832024022057846080', '822024022098366078', '202024022050866081', '2023052267100146', '2024-02-20 16:41:34', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-20 16:41:34', '2024-02-20 16:41:34', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022026876083', '822024022098366078', '202024022016386084', '2023052267100146', '2024-02-20 16:42:00', '10006', '规划年会', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 16:42:00', '2024-02-20 16:42:00', 'auditUser', '832024022057846080');
INSERT INTO `business_repair_user` VALUES ('832024022089096085', '822024022098366078', '202024022013206086', '2023052267100146', '2024-02-20 16:42:00', '10001', null, 'ADD', '302024021861111923', 'aaaaa', '30202305221014327189000174', 'HC演示物业2', '2024-02-20 16:42:30', null, 'auditUser', '832024022026876083');
INSERT INTO `business_repair_user` VALUES ('832024022135396752', '822024022113356750', '202024022130846753', '2023052267100146', '2024-02-21 09:07:43', '10005', '订单提交', 'ADD', '302024022192586740', '15702460746', '-1', '-1', '2024-02-21 09:07:43', '2024-02-21 09:07:43', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022136117156', '822024022174617154', '202024022186007157', '2023052267100146', '2024-02-21 10:49:32', '10005', '订单提交', 'ADD', '302024021954963012', '赵子龙', '-1', '-1', '2024-02-21 10:49:32', '2024-02-21 10:49:32', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022266950146', '822024022174617154', '202024022255140147', '2023052267100146', '2024-02-22 16:22:34', '10006', '111', 'ADD', '30202305221014327189000174', 'HC演示物业2', '302024021954963012', '赵子龙', '2024-02-22 16:22:34', '2024-02-22 16:22:34', 'auditUser', '832024022136117156');
INSERT INTO `business_repair_user` VALUES ('832024022200570148', '822024022174617154', '202024022242840149', '2023052267100146', '2024-02-22 16:22:34', '10001', null, 'ADD', '302024022077105316', '维修师傅', '30202305221014327189000174', 'HC演示物业2', '2024-02-22 16:23:04', null, 'auditUser', '832024022266950146');
INSERT INTO `business_repair_user` VALUES ('832024022200570148', '822024022174617154', '202024022251150161', '2023052267100146', '2024-02-22 16:24:55', '10002', 'HC演示物业2 强制回单', 'ADD', '302024022077105316', '维修师傅', '30202305221014327189000174', 'HC演示物业2', '2024-02-22 16:23:04', '2024-02-22 16:24:55', 'auditUser', '832024022266950146');
INSERT INTO `business_repair_user` VALUES ('832024022272940162', '822024022174617154', '202024022220150163', '2023052267100146', '2024-02-22 16:24:55', '10002', '9o', 'ADD', '30202305221014327189000174', 'HC演示物业2', '302024022077105316', '维修师傅', '2024-02-22 16:24:55', '2024-02-22 16:24:55', 'auditUser', '832024022200570148');
INSERT INTO `business_repair_user` VALUES ('832024022392192090', '822024022369452088', '202024022352782091', '2023052267100146', '2024-02-23 14:04:37', '10005', '订单提交', 'ADD', '302024022311802044', '17317539405', '-1', '-1', '2024-02-23 14:04:37', '2024-02-23 14:04:37', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022466893800', '822024022461353798', '202024022447993801', '2023052267100146', '2024-02-24 21:15:58', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-24 21:15:58', '2024-02-24 21:15:58', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022506704350', '822024022461353798', '202024022565844351', '2023052267100146', '2024-02-25 18:54:21', '10006', '焯', 'ADD', '30202305221014327189000174', 'HC演示物业2', '30202305221014327189000174', 'HC演示物业2', '2024-02-25 18:54:21', '2024-02-25 18:54:21', 'auditUser', '832024022466893800');
INSERT INTO `business_repair_user` VALUES ('832024022551744352', '822024022461353798', '202024022509634353', '2023052267100146', '2024-02-25 18:54:21', '10001', null, 'ADD', '302024021861111923', 'aaaaa', '30202305221014327189000174', 'HC演示物业2', '2024-02-25 18:54:51', null, 'auditUser', '832024022506704350');
INSERT INTO `business_repair_user` VALUES ('832024022503644360', '822024022369452088', '202024022519254361', '2023052267100146', '2024-02-25 18:54:39', '10006', '焯', 'ADD', '30202305221014327189000174', 'HC演示物业2', '302024022311802044', '17317539405', '2024-02-25 18:54:38', '2024-02-25 18:54:38', 'auditUser', '832024022392192090');
INSERT INTO `business_repair_user` VALUES ('832024022568024362', '822024022369452088', '202024022554714363', '2023052267100146', '2024-02-25 18:54:39', '10001', null, 'ADD', '302023071089700002', 'ddysdd', '30202305221014327189000174', 'HC演示物业2', '2024-02-25 18:55:09', null, 'auditUser', '832024022503644360');
INSERT INTO `business_repair_user` VALUES ('832024022541344370', '822024022113356750', '202024022557744371', '2023052267100146', '2024-02-25 18:54:49', '10006', '焯', 'ADD', '30202305221014327189000174', 'HC演示物业2', '302024022192586740', '15702460746', '2024-02-25 18:54:49', '2024-02-25 18:54:49', 'auditUser', '832024022135396752');
INSERT INTO `business_repair_user` VALUES ('832024022505764372', '822024022113356750', '202024022590564373', '2023052267100146', '2024-02-25 18:54:49', '10001', null, 'ADD', '302024022077105316', '维修师傅', '30202305221014327189000174', 'HC演示物业2', '2024-02-25 18:55:19', null, 'auditUser', '832024022541344370');
INSERT INTO `business_repair_user` VALUES ('832024022682660251', '822024022663000249', '202024022609660252', '2023052267100146', '2024-02-26 17:36:54', '10005', '订单提交', 'ADD', '30202305221014327189000174', 'HC演示物业2', '-1', '-1', '2024-02-26 17:36:54', '2024-02-26 17:36:54', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022715370020', '822024022794890018', '202024022739750021', '2024012252790005', '2024-02-27 14:27:09', '10005', '订单提交', 'ADD', '302024020242040322', '张飞3', '-1', '-1', '2024-02-27 14:27:09', '2024-02-27 14:27:09', 'startUser', '-1');
INSERT INTO `business_repair_user` VALUES ('832024022776040023', '822024022794890018', '202024022743240024', '2024012252790005', '2024-02-27 14:27:50', '10006', '请处理', 'ADD', '302024012264900032', '物联网同步物业', '302024020242040322', '张飞3', '2024-02-27 14:27:49', '2024-02-27 14:27:49', 'auditUser', '832024022715370020');
INSERT INTO `business_repair_user` VALUES ('832024022760440025', '822024022794890018', '202024022703220026', '2024012252790005', '2024-02-27 14:27:50', '10001', null, 'ADD', '302024020663670065', 'bbbb', '302024012264900032', '物联网同步物业', '2024-02-27 14:28:20', null, 'auditUser', '832024022776040023');
INSERT INTO `business_repair_user` VALUES ('832024022760440025', '822024022794890018', '202024022701770037', '2024012252790005', '2024-02-27 17:46:02', '10002', '处理', 'ADD', '302024020663670065', 'bbbb', '302024012264900032', '物联网同步物业', '2024-02-27 14:28:20', '2024-02-27 17:46:02', 'auditUser', '832024022776040023');
INSERT INTO `business_repair_user` VALUES ('832024022702260038', '822024022794890018', '202024022765190039', '2024012252790005', '2024-02-27 17:46:03', '11000', '待评价', 'ADD', '302024020242040322', '张飞3', '302024020663670065', 'bbbb', '2024-02-27 17:46:03', null, 'payUser', '832024022760440025');
INSERT INTO `business_repair_user` VALUES ('832024022702260038', '822024022794890018', '202024022725110047', '2024012252790005', '2024-02-27 17:47:28', '10007', '不错', 'ADD', '302024020242040322', '张飞3', '302024020663670065', 'bbbb', '2024-02-27 17:46:03', '2024-02-27 17:47:28', 'payUser', '832024022760440025');

-- ----------------------------
-- Table structure for business_resource_item
-- ----------------------------
DROP TABLE IF EXISTS `business_resource_item`;
CREATE TABLE `business_resource_item` (
  `res_item_id` varchar(30) NOT NULL COMMENT '订单项ID',
  `res_order_id` varchar(30) NOT NULL COMMENT '订单ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `res_id` varchar(30) NOT NULL COMMENT '资源ID',
  `res_count` int DEFAULT NULL COMMENT '数量',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_resource_item
-- ----------------------------

-- ----------------------------
-- Table structure for business_resource_order
-- ----------------------------
DROP TABLE IF EXISTS `business_resource_order`;
CREATE TABLE `business_resource_order` (
  `res_order_id` varchar(30) NOT NULL COMMENT '订单ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `res_order_type` varchar(8) NOT NULL COMMENT '出库类型 10000 入库 20000 出库 在t_dict表查看',
  `state` varchar(8) NOT NULL COMMENT '审核状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_resource_order
-- ----------------------------

-- ----------------------------
-- Table structure for business_resource_store
-- ----------------------------
DROP TABLE IF EXISTS `business_resource_store`;
CREATE TABLE `business_resource_store` (
  `res_id` varchar(30) NOT NULL COMMENT '资源ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `res_name` varchar(100) NOT NULL COMMENT '资源名称',
  `res_code` varchar(50) NOT NULL COMMENT '资源编码，如终端串码',
  `description` varchar(11) NOT NULL COMMENT '资源描述',
  `price` decimal(9,2) NOT NULL COMMENT '资源单价',
  `stock` varchar(100) DEFAULT NULL COMMENT '库存数',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `unit_code` int DEFAULT NULL COMMENT '单位详细见字典表',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `out_low_price` decimal(10,2) NOT NULL COMMENT '对外最低售价',
  `out_high_price` decimal(10,2) NOT NULL COMMENT '对外最高售价',
  `show_mobile` varchar(2) DEFAULT NULL COMMENT '是否在手机端显示 N不显示 Y显示',
  `sh_id` varchar(30) NOT NULL COMMENT '仓库ID',
  `warning_stock` int DEFAULT NULL COMMENT '警告库存',
  `average_price` decimal(10,2) DEFAULT NULL COMMENT '均价',
  `rss_id` varchar(30) DEFAULT NULL COMMENT '规格id',
  `rst_id` varchar(30) DEFAULT NULL COMMENT '类型id',
  `mini_unit_code` int DEFAULT NULL COMMENT '最小计量单位',
  `mini_unit_stock` int DEFAULT NULL COMMENT '最小计量单位数量',
  `mini_stock` varchar(100) DEFAULT NULL COMMENT '最小计量总数',
  `parent_rst_id` varchar(30) DEFAULT NULL COMMENT '一级分类',
  `is_fixed` varchar(30) NOT NULL COMMENT '是--- 否是固定物品  Y是 N否 T通用',
  KEY `idx_b_res_res_id` (`res_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_resource_store
-- ----------------------------

-- ----------------------------
-- Table structure for business_resource_store_specification
-- ----------------------------
DROP TABLE IF EXISTS `business_resource_store_specification`;
CREATE TABLE `business_resource_store_specification` (
  `rss_id` varchar(30) NOT NULL COMMENT '主键id',
  `spec_name` varchar(255) NOT NULL COMMENT '规格名称',
  `rst_id` varchar(30) NOT NULL COMMENT '商品类型',
  `b_id` varchar(255) NOT NULL COMMENT '业务Id',
  `store_id` varchar(255) NOT NULL COMMENT '商户ID',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，0在用 1失效',
  `parent_rst_id` varchar(30) DEFAULT NULL COMMENT '一级分类'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_resource_store_specification
-- ----------------------------

-- ----------------------------
-- Table structure for business_resource_store_type
-- ----------------------------
DROP TABLE IF EXISTS `business_resource_store_type`;
CREATE TABLE `business_resource_store_type` (
  `rst_id` varchar(30) NOT NULL COMMENT '主键ID',
  `name` varchar(255) NOT NULL COMMENT '物品类型名称',
  `b_id` varchar(255) NOT NULL COMMENT '业务Id',
  `store_id` varchar(255) NOT NULL COMMENT '商户ID',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `parent_id` varchar(30) NOT NULL DEFAULT '0' COMMENT '父级ID，默认为0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_resource_store_type
-- ----------------------------

-- ----------------------------
-- Table structure for business_resource_store_use_record
-- ----------------------------
DROP TABLE IF EXISTS `business_resource_store_use_record`;
CREATE TABLE `business_resource_store_use_record` (
  `rsur_id` varchar(30) NOT NULL COMMENT '使用记录id',
  `repair_id` varchar(30) NOT NULL COMMENT '报修id',
  `res_id` varchar(30) NOT NULL COMMENT '物品资源id',
  `b_id` varchar(30) NOT NULL COMMENT '业务id',
  `community_id` varchar(30) NOT NULL COMMENT '小区id',
  `store_id` varchar(30) NOT NULL COMMENT '商户id',
  `quantity` varchar(100) NOT NULL COMMENT '数量',
  `unit_price` decimal(10,2) DEFAULT NULL COMMENT '单价',
  `create_user_id` varchar(30) NOT NULL COMMENT '创建用户的id',
  `create_user_name` varchar(255) NOT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `resource_store_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `state` varchar(30) DEFAULT NULL COMMENT '物品使用类型  1001 报废回收   2002 工单损耗   3003 公用损耗 '
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_resource_store_use_record
-- ----------------------------

-- ----------------------------
-- Table structure for business_resource_supplier
-- ----------------------------
DROP TABLE IF EXISTS `business_resource_supplier`;
CREATE TABLE `business_resource_supplier` (
  `rs_id` varchar(30) NOT NULL COMMENT '主键ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `supplier_name` varchar(255) NOT NULL COMMENT '供应商名称',
  `address` varchar(255) NOT NULL COMMENT '供应商地址',
  `tel` varchar(20) NOT NULL COMMENT '供应商联系方式',
  `contact_name` varchar(255) DEFAULT NULL COMMENT '联系人姓名',
  `account_bank` varchar(255) DEFAULT NULL COMMENT '开户行',
  `bank_account_number` varchar(255) DEFAULT NULL COMMENT '开户行账号',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考t_dict表，0, 在用 1失效',
  `create_user_id` varchar(30) DEFAULT NULL COMMENT '创建人userId',
  `create_user_name` varchar(64) NOT NULL COMMENT '创建人',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `remark` varchar(512) DEFAULT NULL COMMENT '备注',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_resource_supplier
-- ----------------------------

-- ----------------------------
-- Table structure for business_return_pay_fee
-- ----------------------------
DROP TABLE IF EXISTS `business_return_pay_fee`;
CREATE TABLE `business_return_pay_fee` (
  `return_fee_id` varchar(30) NOT NULL COMMENT '退费id',
  `community_id` varchar(30) NOT NULL COMMENT '小区id',
  `b_id` varchar(30) NOT NULL COMMENT '业务id',
  `config_id` varchar(30) NOT NULL COMMENT '费用项id',
  `fee_id` varchar(30) NOT NULL COMMENT '费用id',
  `fee_type_cd` varchar(30) NOT NULL COMMENT '费用类型',
  `detail_id` varchar(30) NOT NULL COMMENT '缴费id',
  `cycles` decimal(9,2) DEFAULT NULL COMMENT '周期',
  `receivable_amount` decimal(10,2) DEFAULT NULL COMMENT '应收金额',
  `received_amount` decimal(10,2) DEFAULT NULL COMMENT '实收金额',
  `prime_rate` decimal(3,2) DEFAULT NULL COMMENT '打折率',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `operate` varchar(4) DEFAULT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `state` varchar(4) NOT NULL COMMENT '审核状态：1000待审核1001审核通过10002审核不通过',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '申请退费时间',
  `pay_time` datetime NOT NULL COMMENT '缴费时间',
  `reason` varchar(200) NOT NULL COMMENT '退费原因'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='退费表';

-- ----------------------------
-- Records of business_return_pay_fee
-- ----------------------------

-- ----------------------------
-- Table structure for business_shop
-- ----------------------------
DROP TABLE IF EXISTS `business_shop`;
CREATE TABLE `business_shop` (
  `shop_id` varchar(30) NOT NULL COMMENT '商品ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `catalog_id` varchar(30) NOT NULL COMMENT '目录ID',
  `store_id` varchar(30) NOT NULL COMMENT '商店ID',
  `name` varchar(100) NOT NULL COMMENT '商品名称',
  `hot_buy` varchar(2) NOT NULL DEFAULT 'N' COMMENT '是否热卖 Y是 N否',
  `sale_price` decimal(10,2) NOT NULL COMMENT '商品销售价,再没有打折情况下显示',
  `open_shop_count` varchar(2) NOT NULL DEFAULT 'N' COMMENT '是否开启库存管理，默认N Y开启，N关闭，开启后界面显示数量，如果为0 则下架',
  `shop_count` decimal(10,0) NOT NULL DEFAULT '10000' COMMENT '商品库存',
  `start_date` date NOT NULL COMMENT '商品开始时间',
  `end_date` date NOT NULL COMMENT '商品结束时间',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_shop_shop_id` (`shop_id`) USING BTREE,
  KEY `idx_business_shop_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_shop
-- ----------------------------

-- ----------------------------
-- Table structure for business_shop_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_shop_attr`;
CREATE TABLE `business_shop_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `shop_id` varchar(30) NOT NULL COMMENT '商品ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_shop_attr_shop_id` (`shop_id`) USING BTREE,
  KEY `idx_business_shop_attr_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_shop_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_shop_attr_param
-- ----------------------------
DROP TABLE IF EXISTS `business_shop_attr_param`;
CREATE TABLE `business_shop_attr_param` (
  `attr_param_id` varchar(30) NOT NULL COMMENT '商品属性参数ID',
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `shop_id` varchar(30) NOT NULL COMMENT '商品ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `param` varchar(50) NOT NULL COMMENT '参数值',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_shop_attr_param_shop_id` (`shop_id`) USING BTREE,
  KEY `idx_business_shop_attr_param_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_shop_attr_param
-- ----------------------------

-- ----------------------------
-- Table structure for business_shop_catalog
-- ----------------------------
DROP TABLE IF EXISTS `business_shop_catalog`;
CREATE TABLE `business_shop_catalog` (
  `catalog_id` varchar(30) NOT NULL COMMENT '目录ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商店ID',
  `name` varchar(100) NOT NULL COMMENT '目录名称',
  `level` varchar(2) NOT NULL COMMENT '目录等级',
  `parent_catalog_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '父目录ID，一级目录则写-1',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_shop_catalog_store_id` (`store_id`) USING BTREE,
  KEY `idx_business_shop_catalog_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_shop_catalog
-- ----------------------------

-- ----------------------------
-- Table structure for business_shop_desc
-- ----------------------------
DROP TABLE IF EXISTS `business_shop_desc`;
CREATE TABLE `business_shop_desc` (
  `shop_desc_id` varchar(30) NOT NULL COMMENT '商品描述ID',
  `shop_id` varchar(30) NOT NULL COMMENT '商品ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `shop_describe` longtext NOT NULL COMMENT '商品描述',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_shop_desc_shop_id` (`shop_id`) USING BTREE,
  KEY `idx_business_shop_desc_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_shop_desc
-- ----------------------------

-- ----------------------------
-- Table structure for business_shop_photo
-- ----------------------------
DROP TABLE IF EXISTS `business_shop_photo`;
CREATE TABLE `business_shop_photo` (
  `shop_photo_id` varchar(30) NOT NULL COMMENT '商品照片ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `shop_id` varchar(30) NOT NULL COMMENT '商店ID',
  `shop_photo_type_cd` varchar(12) NOT NULL COMMENT '商品照片类型,L logo O 其他照片',
  `photo` varchar(100) NOT NULL COMMENT '照片',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_shop_photo_shop_id` (`shop_id`) USING BTREE,
  KEY `idx_business_shop_photo_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_shop_photo
-- ----------------------------

-- ----------------------------
-- Table structure for business_shop_preferential
-- ----------------------------
DROP TABLE IF EXISTS `business_shop_preferential`;
CREATE TABLE `business_shop_preferential` (
  `shop_preferential_id` varchar(30) NOT NULL COMMENT '商品ID',
  `shop_id` varchar(30) NOT NULL COMMENT '商品ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `original_price` decimal(10,2) NOT NULL COMMENT '商品销售价，再没有优惠的情况下和售价是一致的',
  `discount_rate` decimal(3,2) NOT NULL DEFAULT '1.00' COMMENT '商品打折率',
  `show_original_price` varchar(2) NOT NULL DEFAULT 'N' COMMENT '是否显示原价，Y显示，N 不显示',
  `preferential_start_date` date NOT NULL COMMENT '商品优惠开始时间',
  `preferential_end_date` date NOT NULL COMMENT '商品优惠结束时间',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_shop_preferential_shop_id` (`shop_id`) USING BTREE,
  KEY `idx_business_shop_preferential_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_shop_preferential
-- ----------------------------

-- ----------------------------
-- Table structure for business_small_wechat_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_small_wechat_attr`;
CREATE TABLE `business_small_wechat_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `wechat_id` varchar(30) NOT NULL COMMENT '微信ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考t_dict',
  `value` varchar(500) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `community_id` varchar(30) NOT NULL COMMENT '分片字段'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_small_wechat_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_store
-- ----------------------------
DROP TABLE IF EXISTS `business_store`;
CREATE TABLE `business_store` (
  `store_id` varchar(30) NOT NULL COMMENT '商店ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `name` varchar(100) NOT NULL COMMENT '店铺名称',
  `address` varchar(200) NOT NULL COMMENT '店铺地址',
  `tel` varchar(11) NOT NULL COMMENT '电话',
  `store_type_cd` varchar(12) DEFAULT NULL,
  `nearby_landmarks` varchar(200) DEFAULT NULL COMMENT '地标，如王府井北60米',
  `map_x` varchar(20) NOT NULL COMMENT '地区 x坐标',
  `map_y` varchar(20) NOT NULL COMMENT '地区 y坐标',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `state` varchar(12) NOT NULL DEFAULT '48001' COMMENT '48001 商户正常状态 48002 限制商户登录',
  KEY `idx_business_store_store_id` (`store_id`) USING BTREE,
  KEY `idx_business_store_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_store
-- ----------------------------

-- ----------------------------
-- Table structure for business_store_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_store_attr`;
CREATE TABLE `business_store_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `store_id` varchar(30) NOT NULL COMMENT '用户ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_store_attr_store_id` (`store_id`) USING BTREE,
  KEY `idx_business_store_attr_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_store_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_store_cerdentials
-- ----------------------------
DROP TABLE IF EXISTS `business_store_cerdentials`;
CREATE TABLE `business_store_cerdentials` (
  `store_cerdentials_id` varchar(30) NOT NULL COMMENT '商户证件ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商店ID',
  `credentials_cd` varchar(12) NOT NULL COMMENT '证件类型，对应于 credentials表',
  `value` varchar(50) NOT NULL COMMENT '证件号码',
  `validity_period` date NOT NULL COMMENT '有效期，如果是长期有效 写成 3000/1/1',
  `positive_photo` varchar(100) DEFAULT NULL COMMENT '正面照片',
  `negative_photo` varchar(100) DEFAULT NULL COMMENT '反面照片',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_store_cerdentials_store_id` (`store_id`) USING BTREE,
  KEY `idx_business_store_cerdentials_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_store_cerdentials
-- ----------------------------

-- ----------------------------
-- Table structure for business_store_photo
-- ----------------------------
DROP TABLE IF EXISTS `business_store_photo`;
CREATE TABLE `business_store_photo` (
  `store_photo_id` varchar(30) NOT NULL COMMENT '商户照片ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商店ID',
  `store_photo_type_cd` varchar(12) NOT NULL COMMENT '商户照片类型,T 门头照 I 内景照',
  `photo` varchar(100) NOT NULL COMMENT '照片',
  `month` int NOT NULL COMMENT '月份',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `idx_business_store_photo_store_id` (`store_id`) USING BTREE,
  KEY `idx_business_store_photo_b_id` (`b_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_store_photo
-- ----------------------------

-- ----------------------------
-- Table structure for business_store_user
-- ----------------------------
DROP TABLE IF EXISTS `business_store_user`;
CREATE TABLE `business_store_user` (
  `store_user_id` varchar(30) NOT NULL COMMENT '代理商用户ID',
  `store_id` varchar(30) NOT NULL COMMENT '代理商ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `rel_cd` varchar(30) NOT NULL COMMENT '用户和代理商关系 详情查看 agent_user_rel表',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_store_user
-- ----------------------------
INSERT INTO `business_store_user` VALUES ('102024012278110034', '102024012228150026', '202024012297610035', '302024012264900032', '600311000001', '2024-01-22 15:06:30', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012412720035', '102024012228150026', '202024012494420036', '302024012463110033', '1000', '2024-01-24 09:53:13', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012412720035', '102024012228150026', '202024012467740055', '302024012463110033', '1000', '2024-01-24 10:19:08', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024012412720035', '102024012228150026', '202024012467740055', '302024012463110033', '1000', '2024-01-24 10:19:08', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012405960005', '302024012497590002', '1000', '2024-01-24 11:09:38', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012456930004', '302024012497590002', '1000', '2024-01-24 11:24:55', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012456930004', '302024012497590002', '1000', '2024-01-24 11:24:55', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012407060016', '302024012497590002', '1000', '2024-01-24 11:46:12', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012407060016', '302024012497590002', '1000', '2024-01-24 11:46:12', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012420800025', '302024012497590002', '1000', '2024-01-24 11:46:42', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012420800025', '302024012497590002', '1000', '2024-01-24 11:46:42', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012418170033', '302024012497590002', '1000', '2024-01-24 11:58:39', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012418170033', '302024012497590002', '1000', '2024-01-24 11:58:39', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012421750037', '302024012497590002', '1000', '2024-01-24 11:59:06', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024012440650004', '102024012228150026', '202024012421750037', '302024012497590002', '1000', '2024-01-24 11:59:06', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012433540042', '102024012228150026', '202024012429600043', '302024012404270040', '1000', '2024-01-24 12:01:02', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024012433540042', '102024012228150026', '202024012429390049', '302024012404270040', '1000', '2024-01-24 12:01:30', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024012433540042', '102024012228150026', '202024012429390049', '302024012404270040', '1000', '2024-01-24 12:01:30', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024020608230044', '102024012228150026', '202024020601440045', '302024020685720042', '1000', '2024-02-06 14:56:06', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024020608230044', '102024012228150026', '202024020672630054', '302024020685720042', '1000', '2024-02-06 14:57:31', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024020608230044', '102024012228150026', '202024020672630054', '302024020685720042', '1000', '2024-02-06 14:57:31', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024020608230044', '102024012228150026', '202024020666770061', '302024020685720042', '1000', '2024-02-06 15:03:44', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024020608230044', '102024012228150026', '202024020666770061', '302024020685720042', '1000', '2024-02-06 15:03:44', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024020612100067', '102024012228150026', '202024020659840068', '302024020663670065', '1000', '2024-02-06 15:04:57', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024021546570326', '400000000000000001', '202024021563120327', '302024021564470324', '8000', '2024-02-15 15:50:53', 'ADD');
INSERT INTO `business_store_user` VALUES ('452023071064690004', '10202305221014329108000168', '202024021573690437', '302023071089700002', '1000', '2024-02-15 20:11:15', 'DEL');
INSERT INTO `business_store_user` VALUES ('452023071064690004', '10202305221014329108000168', '202024021573690437', '302023071089700002', '8000', '2024-02-15 20:11:15', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024021838411925', '10202305221014329108000168', '202024021812441926', '302024021861111923', '1000', '2024-02-18 20:18:46', 'ADD');
INSERT INTO `business_store_user` VALUES ('102024021997222513', '102024021989652505', '202024021907772514', '302024021945972511', '600311000001', '2024-02-19 07:09:13', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024021956243248', '400000000000000001', '202024021971723249', '302024021914113246', '2000', '2024-02-19 14:20:30', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022032075318', '10202305221014329108000168', '202024022027425319', '302024022077105316', '4000', '2024-02-20 13:54:26', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022032075318', '10202305221014329108000168', '202024022008665795', '302024022077105316', '4000', '2024-02-20 15:20:47', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024022032075318', '10202305221014329108000168', '202024022008665795', '302024022077105316', '4000', '2024-02-20 15:20:47', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022045835949', '10202305221014329108000168', '202024022079085950', '302024022059245947', '1000', '2024-02-20 15:40:31', 'ADD');
INSERT INTO `business_store_user` VALUES ('102024022189736889', '102024022134146881', '202024022179746890', '302024022107986887', '600311000001', '2024-02-21 10:15:17', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022159126998', '400000000000000001', '202024022139766999', '302024022170156996', '1000', '2024-02-21 10:19:51', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022152817016', '10202305221014329108000168', '202024022111427017', '302024022107117014', '4000', '2024-02-21 10:20:25', 'ADD');
INSERT INTO `business_store_user` VALUES ('102024022332620356', '102024022393920348', '202024022332110357', '302024022327600354', '600311000001', '2024-02-23 09:58:56', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022356600789', '102024022393920348', '202024022388840790', '302024022380750787', '9000', '2024-02-23 10:02:07', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022316580999', '10202305221014329108000168', '202024022361961000', '302024022367830997', '2000', '2024-02-23 10:40:05', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022152817016', '10202305221014329108000168', '202024022390531225', '302024022107117014', '4000', '2024-02-23 11:45:30', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024022152817016', '10202305221014329108000168', '202024022390531225', '302024022107117014', '4000', '2024-02-23 11:45:30', 'ADD');
INSERT INTO `business_store_user` VALUES ('102024022339702939', '102024022305732931', '202024022382352940', '302024022392812937', '600311000001', '2024-02-23 17:31:44', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024021546570326', '400000000000000001', '202024022483233340', '302024021564470324', '8000', '2024-02-24 08:46:59', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024021546570326', '400000000000000001', '202024022483233340', '302024021564470324', '8000', '2024-02-24 08:46:59', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024021546570326', '400000000000000001', '202024022490893350', '302024021564470324', '8000', '2024-02-24 08:47:32', 'DEL');
INSERT INTO `business_store_user` VALUES ('452024021546570326', '400000000000000001', '202024022490893350', '302024021564470324', '8000', '2024-02-24 08:47:32', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022400213357', '400000000000000001', '202024022469263358', '302024022434513355', '8000', '2024-02-24 08:48:28', 'ADD');
INSERT INTO `business_store_user` VALUES ('102024022600790245', '102024022637410237', '202024022619350246', '302024022667390243', '600311000001', '2024-02-26 09:55:09', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022646950714', '10202305221014329108000168', '202024022662310715', '302024022671240712', '2000', '2024-02-26 11:27:01', 'ADD');
INSERT INTO `business_store_user` VALUES ('102024022674460083', '102024022603910075', '202024022613240084', '302024022634540081', '600311000001', '2024-02-26 13:56:10', 'ADD');
INSERT INTO `business_store_user` VALUES ('102024022615170097', '102024022665340089', '202024022603180098', '302024022695990095', '600311000001', '2024-02-26 14:27:22', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022655240219', '10202305221014329108000168', '202024022627200220', '302024022607020217', '8000', '2024-02-26 17:30:06', 'ADD');
INSERT INTO `business_store_user` VALUES ('102024022641050421', '102024022691780413', '202024022659150422', '302024022652140419', '600311000001', '2024-02-26 19:42:18', 'ADD');
INSERT INTO `business_store_user` VALUES ('452024022774070309', '102024022691780413', '202024022775480310', '302024022721000307', '1000', '2024-02-27 09:21:13', 'ADD');

-- ----------------------------
-- Table structure for business_storehouse
-- ----------------------------
DROP TABLE IF EXISTS `business_storehouse`;
CREATE TABLE `business_storehouse` (
  `sh_id` varchar(30) NOT NULL COMMENT '仓库ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `sh_name` varchar(64) NOT NULL COMMENT '仓库名称',
  `sh_desc` varchar(64) NOT NULL COMMENT '仓库描述',
  `sh_type` varchar(12) NOT NULL COMMENT '仓库类型 2806 集团仓库 2807 项目仓库',
  `sh_obj_id` varchar(30) NOT NULL COMMENT '归宿对象ID,项目时写小区ID，集团时写物业商户ID',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `is_show` varchar(20) NOT NULL DEFAULT '' COMMENT '仓库是否对外开放    true 是   false 否'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_storehouse
-- ----------------------------

-- ----------------------------
-- Table structure for business_task
-- ----------------------------
DROP TABLE IF EXISTS `business_task`;
CREATE TABLE `business_task` (
  `task_id` varchar(30) NOT NULL COMMENT '任务ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `task_name` varchar(100) NOT NULL COMMENT '任务名称',
  `template_id` varchar(30) NOT NULL COMMENT '模板ID',
  `task_cron` varchar(50) NOT NULL COMMENT '定时时间',
  `state` varchar(12) NOT NULL COMMENT '状态 001 停止 002 运行 ',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_task
-- ----------------------------

-- ----------------------------
-- Table structure for business_task_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_task_attr`;
CREATE TABLE `business_task_attr` (
  `task_id` varchar(30) NOT NULL COMMENT '任务ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考task_template_spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_task_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_temp_car_fee_config
-- ----------------------------
DROP TABLE IF EXISTS `business_temp_car_fee_config`;
CREATE TABLE `business_temp_car_fee_config` (
  `config_id` varchar(30) NOT NULL COMMENT '临时车收费标准ID',
  `fee_name` varchar(64) NOT NULL COMMENT '收费标准名称',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `pa_id` varchar(30) NOT NULL COMMENT '停车场ID',
  `area_num` varchar(30) NOT NULL COMMENT '停车场编码',
  `car_type` varchar(12) NOT NULL COMMENT '车辆类型',
  `rule_id` varchar(30) NOT NULL COMMENT '收费规则',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `fee_config_id` varchar(30) NOT NULL COMMENT '费用项配置ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_temp_car_fee_config
-- ----------------------------
INSERT INTO `business_temp_car_fee_config` VALUES ('922022082476740006', '1', '202022082452090007', '102022082382290048', '1', '9901', '6700012001', '2022081539020475', '2022-08-01 00:00:00', '2022-10-31 00:00:00', '2022-08-24 23:12:14', 'ADD', '922022082440300005');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022082415710003', '3', '202022082452510022', '102022082382290048', '1', '9901', '6700012001', '2022081539020475', '2022-08-01 00:00:00', '2022-11-30 00:00:00', '2022-08-24 23:14:39', 'ADD', '922022082408140002');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022082403790029', '4', '202022082481870048', '102022082382290048', '1', '9901', '6700012001', '2022081539020475', '2022-08-01 00:00:00', '2022-09-10 00:00:00', '2022-08-24 23:19:21', 'ADD', '922022082408350028');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022082403790029', '4', '202022101183160041', '102022082382290048', '1', '9901', '6700012001', '2022081539020475', '2022-08-01 00:00:00', '2022-09-10 00:00:00', '2022-10-11 17:04:59', 'DEL', '922022082408350028');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022082403790029', '4', '202022101183160041', '102022082382290048', '1', '9901', '6700012001', '2022081539020475', '2022-08-01 00:00:00', '2022-09-10 00:00:00', '2022-10-11 17:04:59', 'ADD', '922022082408350028');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022082403790029', '4', '202022101120660056', '102022082382290048', '1', '9901', '6700012001', '2022081539020475', '2022-08-01 00:00:00', '2022-09-10 00:00:00', '2022-10-11 17:05:24', 'DEL', '922022082408350028');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022082403790029', '4', '202022101120660056', '102022082382290048', '1', '9901', '6700012001', '2022081539020475', '2022-08-01 00:00:00', '2022-09-10 00:00:00', '2022-10-11 17:05:24', 'ADD', '922022082408350028');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022101125010063', '123213123', '202022101161090064', '102022092098640117', '199', '9901', '6700012002', '2022081539020475', '1899-11-01 00:00:00', '2022-10-20 00:00:00', '2022-10-11 17:20:08', 'ADD', '922022101173280062');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022101734250067', '8008', '202022101753450086', '102022101773780027', '8008', '9901', '6700012001', '2022081539020475', '2022-10-01 00:00:00', '2028-01-01 00:00:00', '2022-10-17 17:47:08', 'ADD', '922022101782680066');
INSERT INTO `business_temp_car_fee_config` VALUES ('922022121719450125', 'dsfdsf', '202022121705340289', '102022120898183896', '大米面粉', '9902', '6700012002', '2022120695590004', '2022-12-17 00:00:00', '2022-12-17 00:00:00', '2022-12-17 20:31:36', 'ADD', '922022121719900124');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023013129520562', '临时车收费规则', '202023013144890581', '102023013140260490', 'A001', '9901', '6700012001', '2023013154290059', '2023-01-01 00:00:00', '2031-01-31 00:00:00', '2023-01-31 18:37:45', 'ADD', '922023013141080561');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120942500395', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:23:18', 'ADD', '922023120908580375');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120914340411', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:23:24', 'DEL', '922023120908580375');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120914340411', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:23:24', 'ADD', '922023120908580375');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120999600427', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:24:22', 'DEL', '922023120908580375');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120999600427', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:24:22', 'ADD', '922023120908580375');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120944380443', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:24:28', 'DEL', '922023120908580375');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120944380443', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:24:28', 'ADD', '922023120908580375');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120934910459', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:25:14', 'DEL', '922023120908580375');
INSERT INTO `business_temp_car_fee_config` VALUES ('922023120921730376', '1', '202023120934910459', '102023061679340015', '1', '9901', '6700012001', '2023052267100146', '2023-12-01 00:00:00', '2023-12-31 00:00:00', '2023-12-09 15:25:14', 'ADD', '922023120908580375');

-- ----------------------------
-- Table structure for business_temp_car_fee_config_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_temp_car_fee_config_attr`;
CREATE TABLE `business_temp_car_fee_config_attr` (
  `config_id` varchar(30) NOT NULL COMMENT '标准ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id',
  `value` varchar(500) NOT NULL COMMENT '属性值',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_temp_car_fee_config_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_user
-- ----------------------------
DROP TABLE IF EXISTS `business_user`;
CREATE TABLE `business_user` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `email` varchar(30) DEFAULT NULL COMMENT '邮箱地址',
  `address` varchar(200) DEFAULT NULL COMMENT '现居住地址',
  `password` varchar(128) DEFAULT NULL COMMENT '用户密码，加密过后',
  `location_cd` varchar(8) DEFAULT NULL COMMENT '用户地区，编码详见 u_location',
  `age` int DEFAULT NULL COMMENT '用户年龄',
  `sex` varchar(1) DEFAULT NULL COMMENT '性别，0表示男孩 1表示女孩',
  `tel` varchar(11) NOT NULL,
  `level_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '用户级别,关联user_level',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_user
-- ----------------------------

-- ----------------------------
-- Table structure for business_user_attr
-- ----------------------------
DROP TABLE IF EXISTS `business_user_attr`;
CREATE TABLE `business_user_attr` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  KEY `i_attr_id` (`attr_id`),
  KEY `i_user_id` (`user_id`),
  KEY `i_b_id` (`b_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_user_attr
-- ----------------------------

-- ----------------------------
-- Table structure for business_user_credentials
-- ----------------------------
DROP TABLE IF EXISTS `business_user_credentials`;
CREATE TABLE `business_user_credentials` (
  `credentials_id` varchar(30) NOT NULL COMMENT '证件ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `credentials_cd` varchar(12) NOT NULL COMMENT '证件类型',
  `value` varchar(50) NOT NULL COMMENT '证件号码',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_user_credentials
-- ----------------------------

-- ----------------------------
-- Table structure for business_user_storehouse
-- ----------------------------
DROP TABLE IF EXISTS `business_user_storehouse`;
CREATE TABLE `business_user_storehouse` (
  `us_id` varchar(30) NOT NULL COMMENT '主键ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `res_id` varchar(30) NOT NULL COMMENT '资源ID',
  `res_name` varchar(100) NOT NULL COMMENT '资源名称',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID',
  `stock` varchar(100) DEFAULT NULL COMMENT '库存数',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `mini_stock` varchar(100) DEFAULT NULL COMMENT '最小计量总数',
  `res_code` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_user_storehouse
-- ----------------------------

-- ----------------------------
-- Table structure for business_user_tag
-- ----------------------------
DROP TABLE IF EXISTS `business_user_tag`;
CREATE TABLE `business_user_tag` (
  `tag_id` varchar(30) NOT NULL COMMENT '打标ID',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `tag_cd` varchar(12) NOT NULL COMMENT '标签编码,参考tag表',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(3) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_user_tag
-- ----------------------------

-- ----------------------------
-- Table structure for business_visit_info
-- ----------------------------
DROP TABLE IF EXISTS `business_visit_info`;
CREATE TABLE `business_visit_info` (
  `v_id` varchar(30) NOT NULL COMMENT '记录主键ID',
  `v_name` varchar(255) NOT NULL COMMENT '访客姓名',
  `visit_gender` varchar(1) NOT NULL COMMENT '访客性别',
  `phone_number` varchar(11) NOT NULL COMMENT '访客电话号码',
  `community_id` varchar(30) DEFAULT NULL COMMENT '小区ID',
  `owner_id` varchar(30) DEFAULT NULL COMMENT '访客目标业主',
  `visit_case` varchar(255) DEFAULT NULL COMMENT '拜访事由',
  `visit_time` datetime DEFAULT NULL COMMENT '拜访时间',
  `departure_time` datetime DEFAULT NULL COMMENT '访客离开时间',
  `b_id` varchar(30) NOT NULL COMMENT '业务ID',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `user_id` varchar(30) DEFAULT NULL,
  `reason_type` varchar(12) DEFAULT NULL COMMENT '事由类型',
  `car_num` varchar(255) DEFAULT NULL COMMENT '车牌号',
  `entourage` int DEFAULT NULL COMMENT '随行人数',
  `state` varchar(10) NOT NULL COMMENT '审核状态 0表示未审核；1表示审核通过；2表示审核拒绝',
  `state_remark` varchar(255) DEFAULT NULL COMMENT '审核备注',
  `ps_id` varchar(30) DEFAULT NULL COMMENT '车位ID',
  `free_time` datetime DEFAULT NULL COMMENT '预约车免费时间',
  `record_state` int DEFAULT NULL COMMENT '预约状态 0表示有效 1表示无效',
  `car_state` varchar(10) DEFAULT NULL COMMENT '车辆审核状态 0表示未审核；1表示审核通过；2表示审核拒绝',
  `car_remark` varchar(255) DEFAULT NULL COMMENT '车辆审核备注',
  `room_id` varchar(30) DEFAULT NULL COMMENT '房屋id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_visit_info
-- ----------------------------

-- ----------------------------
-- Table structure for business_wechat_menu
-- ----------------------------
DROP TABLE IF EXISTS `business_wechat_menu`;
CREATE TABLE `business_wechat_menu` (
  `wechat_menu_id` varchar(30) NOT NULL COMMENT '微信菜单ID',
  `menu_name` varchar(50) NOT NULL COMMENT '菜单名称',
  `menu_type` varchar(64) NOT NULL COMMENT '菜单类型 click 点击 view url 具体查看t_dict表',
  `menu_value` varchar(200) DEFAULT NULL COMMENT '菜单内容',
  `menu_level` varchar(12) NOT NULL COMMENT '菜单级别 101 一级 菜单 202 二级菜单',
  `app_id` varchar(64) DEFAULT NULL COMMENT '只有 菜单类型为miniprogram时有用',
  `pagepath` varchar(200) DEFAULT NULL COMMENT '小程序地址 只有 菜单类型为miniprogram时有用',
  `b_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID 分片字段',
  `parent_menu_id` varchar(30) NOT NULL DEFAULT '-1' COMMENT '上级菜单',
  `seq` varchar(12) NOT NULL COMMENT '菜单顺序'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_wechat_menu
-- ----------------------------

-- ----------------------------
-- Table structure for business_workflow
-- ----------------------------
DROP TABLE IF EXISTS `business_workflow`;
CREATE TABLE `business_workflow` (
  `flow_id` varchar(30) NOT NULL COMMENT '流程ID',
  `flow_name` varchar(200) NOT NULL COMMENT '流程名称',
  `describle` longtext COMMENT '描述',
  `skip_level` varchar(12) NOT NULL COMMENT '跳过',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID，分片',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID,用来做分区',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `flow_type` varchar(12) NOT NULL COMMENT '流程类型，10001 投诉建议 20002 报修 30003 采购',
  `process_definition_key` varchar(64) DEFAULT NULL COMMENT '工作流部署ID',
  `start_node_finish` varchar(12) NOT NULL DEFAULT 'N' COMMENT '首节点是否需要审核'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_workflow
-- ----------------------------

-- ----------------------------
-- Table structure for business_workflow_step
-- ----------------------------
DROP TABLE IF EXISTS `business_workflow_step`;
CREATE TABLE `business_workflow_step` (
  `step_id` varchar(30) NOT NULL COMMENT '节点ID',
  `flow_id` varchar(30) NOT NULL COMMENT '流程ID',
  `type` varchar(12) NOT NULL COMMENT '类型 1 会签 2 普通 3 或签',
  `seq` int NOT NULL DEFAULT '1' COMMENT '序列',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID，分片',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `store_id` varchar(30) NOT NULL COMMENT '商户ID,用来做分区',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_workflow_step
-- ----------------------------

-- ----------------------------
-- Table structure for business_workflow_step_staff
-- ----------------------------
DROP TABLE IF EXISTS `business_workflow_step_staff`;
CREATE TABLE `business_workflow_step_staff` (
  `step_id` varchar(30) NOT NULL COMMENT '节点ID',
  `staff_id` varchar(30) NOT NULL COMMENT '处理员工ID',
  `staff_name` varchar(100) NOT NULL COMMENT '员工名称',
  `community_id` varchar(30) NOT NULL COMMENT '小区ID，分片',
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `operate` varchar(4) NOT NULL COMMENT '数据状态，添加ADD，修改MOD 删除DEL',
  `wss_id` varchar(30) NOT NULL COMMENT '主键',
  `staff_role` varchar(12) NOT NULL DEFAULT '1001' COMMENT ' 员工角色 1001 普通角色 2002 采购人员',
  `flow_type` varchar(12) DEFAULT NULL COMMENT '流程类型',
  `fee_id` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of business_workflow_step_staff
-- ----------------------------

-- ----------------------------
-- Table structure for c_app
-- ----------------------------
DROP TABLE IF EXISTS `c_app`;
CREATE TABLE `c_app` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `app_id` varchar(30) NOT NULL COMMENT '应用ID',
  `name` varchar(50) NOT NULL COMMENT '名称 对应系统名称',
  `security_code` varchar(64) DEFAULT NULL COMMENT '签名码 sign签名时用',
  `while_list_ip` varchar(200) DEFAULT NULL COMMENT '白名单ip 多个之间用;隔开',
  `black_list_ip` varchar(200) DEFAULT NULL COMMENT '黑名单ip 多个之间用;隔开',
  `remark` varchar(200) DEFAULT NULL COMMENT '描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，0在用，1失效',
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_app
-- ----------------------------
INSERT INTO `c_app` VALUES ('2', '8000418002', '控制中心应用', '', null, null, '控制中心应用', '2018-11-14 13:28:44', '0');
INSERT INTO `c_app` VALUES ('3', '8000418003', '用户管理应用', 'WEBURFPKIFJUHNCJUEIKMKJUJHULSMNCHDY89KMC', null, null, '用户管理应用', '2018-11-14 13:28:44', '0');
INSERT INTO `c_app` VALUES ('4', '8000418004', '小区管理系统web端', '', null, null, '小区管理系统web端', '2023-03-20 03:36:21', '0');
INSERT INTO `c_app` VALUES ('10', '992019111758490006', '业主小程序', 'whoisyoudad!!!', '', '', '业主小程序', '2023-03-17 13:13:44', '0');
INSERT INTO `c_app` VALUES ('12', '992020011134400001', '微信支付', '', '', '', '微信支付', '2020-01-11 20:03:21', '0');
INSERT INTO `c_app` VALUES ('13', '992020012671060001', '车辆道闸', '', '', '', '', '2020-01-26 12:08:39', '0');
INSERT INTO `c_app` VALUES ('14', '992020022270580001', 'HC掌上物业', '', '', '', '物业APP', '2023-02-22 16:57:07', '0');
INSERT INTO `c_app` VALUES ('16', '992020051967020024', 'HC小区物联网平台', 'g3kE9ggkM4Jqrs576rJS0CYg7dbtMXPT', '', '', 'HC小区物联网平台', '2023-01-05 10:13:11', '0');
INSERT INTO `c_app` VALUES ('17', '992020061452450002', '业主公众号', 'whoisyoudad!!!', '', '', '业主公众号', '2023-01-14 20:55:38', '0');
INSERT INTO `c_app` VALUES ('18', '992020061440050003', '业主App', '', '', '', '业主App', '2020-06-14 20:56:00', '0');
INSERT INTO `c_app` VALUES ('19', '992021030901240071', 'HC小区商城系统', '', '', '', 'HC小区商城系统', '2021-03-09 11:43:42', '0');
INSERT INTO `c_app` VALUES ('20', '992021051843980190', '商城手机版', '', '', '', '商城手机版', '2021-05-18 16:19:51', '0');
INSERT INTO `c_app` VALUES ('22', '992021101256130050', '商城商家版', '', null, null, '商城商家版', '2021-10-13 10:24:48', '0');
INSERT INTO `c_app` VALUES ('23', '992021061746360004', '定时任务服务', '', null, null, '定时任务服务', '2019-10-13 10:25:37', '0');
INSERT INTO `c_app` VALUES ('24', '992022082855370008', '支付宝支付', '', '', '', '', '2019-08-28 11:41:10', '0');

-- ----------------------------
-- Table structure for c_business
-- ----------------------------
DROP TABLE IF EXISTS `c_business`;
CREATE TABLE `c_business` (
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `o_id` varchar(30) NOT NULL COMMENT '订单ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `business_type_cd` varchar(12) DEFAULT NULL,
  `finish_time` date DEFAULT NULL COMMENT '完成时间',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `status_cd` varchar(2) NOT NULL COMMENT '数据状态，详细参考c_status表',
  UNIQUE KEY `b_id` (`b_id`) USING BTREE,
  KEY `i_cb_o_id` (`o_id`) USING BTREE,
  KEY `i_b_business_type_cd` (`business_type_cd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_business
-- ----------------------------
INSERT INTO `c_business` VALUES ('202024032231180024', '102024032227410020', '2024-03-22 23:01:37', '600100040001', '2024-03-22', '', 'C');
INSERT INTO `c_business` VALUES ('202024032255150023', '102024032227410020', '2024-03-22 23:01:37', '610100030001', '2024-03-22', '', 'C');

-- ----------------------------
-- Table structure for c_business_attrs
-- ----------------------------
DROP TABLE IF EXISTS `c_business_attrs`;
CREATE TABLE `c_business_attrs` (
  `b_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_business_attrs
-- ----------------------------

-- ----------------------------
-- Table structure for c_business_databus
-- ----------------------------
DROP TABLE IF EXISTS `c_business_databus`;
CREATE TABLE `c_business_databus` (
  `databus_id` varchar(30) NOT NULL COMMENT 'databus ID',
  `databus_name` varchar(128) NOT NULL COMMENT '名称',
  `business_type_cd` varchar(255) NOT NULL COMMENT '业务类型',
  `bean_name` varchar(256) NOT NULL COMMENT '适配器',
  `seq` int NOT NULL DEFAULT '1' COMMENT '顺序',
  `state` varchar(12) NOT NULL DEFAULT '1001' COMMENT '1001 代表在用 2002 表示停用',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  PRIMARY KEY (`databus_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_business_databus
-- ----------------------------
INSERT INTO `c_business_databus` VALUES ('122020120728820001', '设备同步IOT', '200200030001', 'addMachineToIotAdapt', '1', '1001', '2020-12-07 18:55:27', '1');
INSERT INTO `c_business_databus` VALUES ('122020121429450120', '缴费通知管理员', '610100030001', 'machinePaymentNoticeAdapt', '2', '1001', '2020-12-14 23:43:51', '0');
INSERT INTO `c_business_databus` VALUES ('1220201219186718545', '删除小区同步IOT', '500100050001', 'deleteCommunityToIotAdapt', '5', '1001', '2020-12-19 16:50:44', '0');
INSERT INTO `c_business_databus` VALUES ('1220201219749918544', '修改小区同步IOT', '500100040001', 'editCommunityToIotAdapt', '4', '1001', '2020-12-19 16:49:13', '0');
INSERT INTO `c_business_databus` VALUES ('1220201219902118543', '添加小区同步IOT', '500100030001', 'addCommunityToIotAdapt', '3', '1001', '2020-12-19 16:43:02', '0');
INSERT INTO `c_business_databus` VALUES ('1220201220009025464', '保存设备同步IOT', '200200030001', 'addMachineToIotAdapt', '6', '1001', '2020-12-20 17:53:23', '0');
INSERT INTO `c_business_databus` VALUES ('1220201220026525466', '删除设备同步IOT', '200200050001', 'deleteMachineToIotAdapt', '8', '1001', '2020-12-20 17:54:25', '0');
INSERT INTO `c_business_databus` VALUES ('1220201220173925468', '修改业主同步IOT', '110100040001', 'sendOwnerDataToIotAdapt', '10', '1001', '2020-12-20 17:55:34', '0');
INSERT INTO `c_business_databus` VALUES ('1220201220221125470', '业主绑定房屋同步IOT', '111100030001', 'ownerBindRoomToIotAdapt', '12', '1001', '2020-12-20 17:58:49', '0');
INSERT INTO `c_business_databus` VALUES ('1220201220315925469', '删除业主同步IOT', '110100050001', 'sendDeleteOwnerDataToIotAdapt', '11', '1001', '2020-12-20 17:56:08', '0');
INSERT INTO `c_business_databus` VALUES ('1220201220549125467', '添加业主同步IOT', '110100030001', 'sendOwnerDataToIotAdapt', '9', '1001', '2020-12-20 17:55:03', '0');
INSERT INTO `c_business_databus` VALUES ('1220201220731525660', '业主解绑房屋同步IOT', '111100050001', 'ownerUnBindRoomToIotAdapt', '13', '1001', '2020-12-20 18:00:27', '0');
INSERT INTO `c_business_databus` VALUES ('1220201220965925465', '修改设备同步IOT', '200200040001', 'modifyMachineToIotAdapt', '7', '1001', '2020-12-20 17:53:52', '0');
INSERT INTO `c_business_databus` VALUES ('122021010556900111', '删除停车场同步IOT', '541100050001', 'deleteParkingAreaToIotAdapt', '16', '1001', '2021-01-05 13:48:39', '0');
INSERT INTO `c_business_databus` VALUES ('122021010587490110', '修改停车场同步IOT', '541100040001', 'modifyParkingAreaToIotAdapt', '15', '1001', '2021-01-05 13:48:12', '0');
INSERT INTO `c_business_databus` VALUES ('122021010599260109', '添加停车场同步IOT', '541100030001', 'addParkingAreaToIotAdapt', '14', '1001', '2021-01-05 13:47:40', '0');
INSERT INTO `c_business_databus` VALUES ('122021010662740004', '添加车辆', '111200030001', 'sendCarDataToIotAdapt', '17', '1001', '2021-01-06 10:14:20', '0');
INSERT INTO `c_business_databus` VALUES ('122021010675610006', '删除车辆', '111200050001', 'sendDeleteCarDataToIotAdapt', '19', '1001', '2021-01-06 10:15:15', '0');
INSERT INTO `c_business_databus` VALUES ('122021010678880005', '修改车辆', '111200040001', 'sendCarDataToIotAdapt', '18', '1001', '2021-01-06 10:14:46', '0');
INSERT INTO `c_business_databus` VALUES ('122021010759420001', '空置房申请通知管理员', '/applyRoomDiscount/saveApplyRoomDiscount', 'machineApplyRoomDiscountAdapt', '4', '1001', '2021-01-07 17:38:07', '0');
INSERT INTO `c_business_databus` VALUES ('122021011129450001', '空置房验房通知管理员', '/applyRoomDiscount/updateApplyRoomDiscount', 'machineAdoptApplyRoomDiscountAdapt', '5', '1001', '2021-01-11 11:21:50', '0');
INSERT INTO `c_business_databus` VALUES ('122021011194520001', '空置房审批通知管理员', '/applyRoomDiscount/updateReviewApplyRoomDiscount', 'machineApprovalApplyRoomDiscountAdapt', '6', '1001', '2021-01-11 15:26:41', '0');
INSERT INTO `c_business_databus` VALUES ('122021011289880001', '登记报修通知管理员', '130100030001', 'machineAddOwnerRepairAdapt', '7', '1001', '2021-01-12 11:41:45', '0');
INSERT INTO `c_business_databus` VALUES ('122021011300970001', '报修派单通知', '130200030001', 'machineDistributeLeaflets', '8', '1001', '2021-01-13 13:51:26', '0');
INSERT INTO `c_business_databus` VALUES ('122021011302020013', '添加车辆黑白名单同步IOT', '112200030001', 'addCarBlackWhiteToIotAdapt', '20', '1001', '2021-01-13 00:40:52', '0');
INSERT INTO `c_business_databus` VALUES ('122021011366610014', '删除车辆黑白名单同步IOT', '112200050001', 'deleteCarBlackWhiteToIotAdapt', '21', '1001', '2021-01-13 00:41:44', '0');
INSERT INTO `c_business_databus` VALUES ('122021011817180045', '删除临时车标准同步IOT', '651100050001', 'deleteTempCarFeeConfigToIotAdapt', '24', '1001', '2021-01-18 10:29:15', '0');
INSERT INTO `c_business_databus` VALUES ('122021011857070001', '报修退单通知', '130200040001', 'machineReturnRepairAdapt', '9', '1001', '2021-01-18 10:10:48', '0');
INSERT INTO `c_business_databus` VALUES ('122021011866860044', '修改临时车标准同步IOT', '651100040001', 'modifyTempCarFeeConfigToIotAdapt', '23', '1001', '2021-01-18 10:28:36', '0');
INSERT INTO `c_business_databus` VALUES ('122021011873070043', '添加临时车标准同步IOT', '651100030001', 'addTempCarFeeConfigToIotAdapt', '22', '1001', '2021-01-18 10:28:05', '0');
INSERT INTO `c_business_databus` VALUES ('122021012421610003', '删除考勤班组同步IOT', '651100050003', 'deleteAttendanceToIotAdapt', '27', '1001', '2021-01-24 18:03:18', '0');
INSERT INTO `c_business_databus` VALUES ('122021012452170002', '修改考勤班组同步IOT', '651100040003', 'updateAttendanceToIotAdapt', '26', '1001', '2021-01-24 18:02:46', '0');
INSERT INTO `c_business_databus` VALUES ('122021012461280001', '添加考勤班组同步IOT', '651100030003', 'addAttendanceToIotAdapt', '25', '1001', '2021-01-24 14:48:34', '0');
INSERT INTO `c_business_databus` VALUES ('122021012800120099', '添加员工同步IOT', '200100060001', 'addStaffToIotAdapt', '28', '1001', '2021-01-28 10:59:24', '1');
INSERT INTO `c_business_databus` VALUES ('122021012861670100', '删除员工同步IOT', '200100070001', 'deleteStaffToIotAdapt', '29', '1001', '2021-01-28 11:01:14', '0');
INSERT INTO `c_business_databus` VALUES ('122021022243550001', '房屋装修申请通知', '/roomRenovation/saveRoomRenovation', 'machineSaveRoomRenovation', '10', '1001', '2021-02-22 11:42:59', '0');
INSERT INTO `c_business_databus` VALUES ('122021022701070001', '房屋装修审核通知', '/roomRenovation/updateRoomToExamine', 'machineRoomToExamine', '11', '1001', '2021-02-27 17:30:11', '0');
INSERT INTO `c_business_databus` VALUES ('122021030136310001', '房屋装修验收通知', '/roomRenovation/saveRoomRenovationDetail', 'machineRoomRenovationDetail', '12', '1001', '2021-03-01 12:00:55', '0');
INSERT INTO `c_business_databus` VALUES ('122021030236020001', '房屋装修完成通知', '/roomRenovation/updateRoomRenovationState', 'machineRoomRenovationCompleted', '13', '1001', '2021-03-02 09:20:05', '0');
INSERT INTO `c_business_databus` VALUES ('122021032654880001', '打印收据', '610100030001', 'payFeeReceiptAdapt', '30', '1001', '2021-03-26 16:22:17', '0');
INSERT INTO `c_business_databus` VALUES ('122021041053260001', '装修跟踪通知', '/roomRenovation/updateRoomDecorationRecord', 'machineRoomRenovation', '31', '1001', '2021-04-10 14:23:49', '0');
INSERT INTO `c_business_databus` VALUES ('122021052901980216', '添加车辆业主同步IOT', '111200030001', 'addCarOwnerToIotAdapt', '35', '1001', '2021-05-29 00:05:45', '0');
INSERT INTO `c_business_databus` VALUES ('122021052925950213', '添加业主（存在车辆）同步IOT', '110100030001', 'addOwnerHasCarToIotAdapt', '32', '1001', '2021-05-29 00:03:11', '0');
INSERT INTO `c_business_databus` VALUES ('122021052929340215', '删除业主（存在车辆）同步IOT', '110100050001', 'deleteOwnerHasCarToIotAdapt', '34', '1001', '2021-05-29 00:04:39', '0');
INSERT INTO `c_business_databus` VALUES ('122021052938570218', '删除车辆业主同步IOT', '111200050001', 'deleteCarOwnerToIotAdapt', '37', '1001', '2021-05-29 00:07:06', '0');
INSERT INTO `c_business_databus` VALUES ('122021052942660214', '修改业主（存在车辆）同步IOT', '110100040001', 'editOwnerHasCarToIotAdapt', '33', '1001', '2021-05-29 00:04:06', '0');
INSERT INTO `c_business_databus` VALUES ('122021052952740217', '修改车辆业主同步IOT', '111200040001', 'modifyCarOwnerToIotAdapt', '36', '1001', '2021-05-29 00:06:20', '0');
INSERT INTO `c_business_databus` VALUES ('122021060304740001', '物品采购、领用申请通知', '/purchase/purchaseApply', 'machinePurchaseApplyAdapt', '35', '1001', '2021-06-03 17:35:10', '0');
INSERT INTO `c_business_databus` VALUES ('122021060766670021', '物品调拨申请通知', '671100030005', 'machineAllocationStorehouse', '36', '1001', '2021-06-07 14:29:52', '0');
INSERT INTO `c_business_databus` VALUES ('122021062858820001', '删除报表数据', '600100050001', 'deleteFeeRefreshReportAdapt', '37', '1001', '2021-06-28 18:48:10', '0');
INSERT INTO `c_business_databus` VALUES ('122021081649150001', '缴费离散到月', '610100030001', 'payFeeDetailToMonthAdapt', '38', '1001', '2021-08-16 01:05:47', '0');
INSERT INTO `c_business_databus` VALUES ('122021081920490002', '退费申请通知', '621100030001', 'returnPayFeeAdapt', '38', '1001', '2021-08-19 10:08:54', '0');
INSERT INTO `c_business_databus` VALUES ('122021083172490001', '政务系统推送添加楼栋', '510100030001', 'addFloorToHcGovAdapt', '39', '1001', '2021-08-31 19:06:42', '0');
INSERT INTO `c_business_databus` VALUES ('122021090125040001', '政务系统推送修改楼栋', '510100040001', 'editFloorToHcGovAdapt', '40', '1001', '2021-09-01 18:03:37', '0');
INSERT INTO `c_business_databus` VALUES ('122021090551210002', '政务系统推送修改位置', '570100040001', 'editLocationToHcGovAdapt', '42', '1001', '2021-09-05 18:24:14', '0');
INSERT INTO `c_business_databus` VALUES ('122021090562830001', '政务系统推送添加位置', '570100030001', 'addLocationToHcGovAdapt', '41', '1001', '2021-09-05 18:23:45', '0');
INSERT INTO `c_business_databus` VALUES ('122021090641920012', '政务系统推送修改房屋', '530100040001', 'editRoomToHcGovAdapt', '44', '1001', '2021-09-06 17:10:18', '0');
INSERT INTO `c_business_databus` VALUES ('122021090669330078', '政务系统推送房屋', '530100030001', 'addRoomToHcGovAdapt', '43', '1001', '2021-09-06 13:27:02', '0');
INSERT INTO `c_business_databus` VALUES ('122021090767380001', '政务系统推送业主信息', '111100030001', 'addOwnerToHcGovAdapt', '45', '1001', '2021-09-07 17:07:22', '0');
INSERT INTO `c_business_databus` VALUES ('122021090902620084', '修改业主成员推送政务', '110100040001', 'editOwnerToHcGovAdapt', '47', '1001', '2021-09-09 10:38:12', '0');
INSERT INTO `c_business_databus` VALUES ('122021090977680083', '添加业主成员推送政务', '110100030001', 'addOwnerToHcGovAdapt', '46', '1001', '2021-09-09 10:37:30', '0');
INSERT INTO `c_business_databus` VALUES ('122021091120530128', '添加员工推送商户及用户信息', '100100030001', 'addStaffToHcGovAdapt', '48', '1001', '2021-09-11 12:30:16', '0');
INSERT INTO `c_business_databus` VALUES ('122021091817391984', '添加停车场同步政务', '541100030001', 'addParkingAreaToHcGovAdapt', '49', '1001', '2021-09-18 00:28:38', '0');
INSERT INTO `c_business_databus` VALUES ('122021091888921985', '修改停车场同步政务', '541100040001', 'editParkingAreaToHcGovAdapt', '50', '1001', '2021-09-18 00:29:16', '0');
INSERT INTO `c_business_databus` VALUES ('122021091912612996', '修改车辆同步政务', '111200040001', 'editCarToHcGovAdapt', '52', '1001', '2021-09-19 11:29:17', '0');
INSERT INTO `c_business_databus` VALUES ('122021091948812995', '保存车辆同步政务', '111200030001', 'addCarToHcGovAdapt', '51', '1001', '2021-09-19 11:28:38', '0');
INSERT INTO `c_business_databus` VALUES ('122021092445871641', '添加问候语同步IOT', '541100030003', 'addParkingAreaTextToIotAdapt', '53', '1001', '2021-09-24 12:57:20', '0');
INSERT INTO `c_business_databus` VALUES ('122021092499431642', '编辑问候语同步IOT', '541100040003', 'addParkingAreaTextToIotAdapt', '54', '1001', '2021-09-24 12:57:48', '0');
INSERT INTO `c_business_databus` VALUES ('122021100776610082', '修改业主信息', '110100040001', 'updateFeeOwnerInfoAdapt', '55', '1001', '2021-10-07 21:17:32', '0');
INSERT INTO `c_business_databus` VALUES ('122021101996755646', '添加岗亭同步IOT', '541100030004', 'addParkingBoxToIotAdapt', '56', '1001', '2021-10-19 10:20:15', '0');
INSERT INTO `c_business_databus` VALUES ('122021102051730012', '房屋产权登记通知', '671100030012', 'machinePropertyRightRegistration', '53', '1001', '2021-10-20 10:33:28', '0');
INSERT INTO `c_business_databus` VALUES ('122021102322670004', '房屋产权修改通知', '671100040012', 'machineEditPropertyRightRegistration', '56', '1001', '2021-10-23 10:25:00', '0');
INSERT INTO `c_business_databus` VALUES ('122021110929583196', '业主缴费报表生成', '610100030001', 'reportOwnerPayFeeAdapt', '57', '1001', '2021-11-09 10:59:14', '0');
INSERT INTO `c_business_databus` VALUES ('122021120217030032', '添加业主处理', '110100030001', 'updateFeeOwnerInfoAdapt', '56', '1001', '2021-12-02 10:00:33', '0');
INSERT INTO `c_business_databus` VALUES ('122021120287110098', 'OA工单通知', '551100030004', 'oaWorkflowDistributeOrder', '58', '1001', '2021-12-02 17:25:07', '0');
INSERT INTO `c_business_databus` VALUES ('122021123110630056', '退费处理', '561100030004', 'returnPayFeeMoneyAdapt', '59', '1001', '2021-12-31 18:19:09', '0');
INSERT INTO `c_business_databus` VALUES ('122022072992520042', '修改员工同步IOT', '200100080001', 'updateStaffToIotAdapt', '55', '1001', '2022-07-29 11:01:52', '1');
INSERT INTO `c_business_databus` VALUES ('122022072996190043', '删除员工同步IOT', '200100070001', 'deleteStaffToIotAdapt', '56', '1001', '2022-07-29 11:03:03', '1');
INSERT INTO `c_business_databus` VALUES ('122022082624530020', '修改岗亭同步IOT', '541100040004', 'modifyParkingBoxToIotAdapt', '57', '1001', '2022-08-26 16:31:49', '0');
INSERT INTO `c_business_databus` VALUES ('122022082640230023', '删除岗亭同步IOT', '541100050004', 'deleteParkingBoxToIotAdapt', '58', '1001', '2022-08-26 16:32:20', '0');
INSERT INTO `c_business_databus` VALUES ('122022101563250010', '添加停车劵', '541130030001', 'addParkingCouponCarToIotAdapt', '59', '1001', '2022-10-15 12:28:55', '0');
INSERT INTO `c_business_databus` VALUES ('122022101569230003', '发布公告推送消息', '550100030001', 'machineNoticeAdapt', '68', '1001', '2022-10-15 13:44:57', '0');
INSERT INTO `c_business_databus` VALUES ('122022101586880013', '删除停车劵', '541130050001', 'deleteParkingCouponCarToIotAdapt', '60', '1001', '2022-10-15 12:29:26', '0');
INSERT INTO `c_business_databus` VALUES ('122022102754310014', '门禁开门发送营销信息', '230200030001', 'personInSendMarketInfoAdapt', '61', '1001', '2022-10-27 15:22:44', '0');
INSERT INTO `c_business_databus` VALUES ('122022102841460008', '车辆开门发送营销信息', '541120030001', 'carInSendMarketInfoAdapt', '62', '1001', '2022-10-28 01:00:56', '0');
INSERT INTO `c_business_databus` VALUES ('122022112479910003', '缴费赠送优惠券', '610100030001', 'payFeeGiftCouponAdapt', '63', '1001', '2022-11-24 02:24:34', '0');
INSERT INTO `c_business_databus` VALUES ('122022121331151159', '缴费赠送积分', '610100030001', 'payFeeGiftIntegralAdapt', '64', '1001', '2022-12-13 17:59:10', '0');
INSERT INTO `c_business_databus` VALUES ('122023012415610020', '删除门禁白名单送IOT', '551130050001', 'deleteAccessControlWhiteAuthToIotAdapt', '67', '1001', '2023-01-24 11:53:55', '0');
INSERT INTO `c_business_databus` VALUES ('122023012436400017', '修改门禁白名单送IOT', '551130040001', 'editAccessControlWhiteToIotAdapt', '66', '1001', '2023-01-24 11:53:13', '0');
INSERT INTO `c_business_databus` VALUES ('122023012490630014', '添加门禁白名单送IOT', '551130030001', 'addAccessControlWhiteAuthToIotAdapt', '65', '1001', '2023-01-24 11:52:41', '0');
INSERT INTO `c_business_databus` VALUES ('122023020513640003', '车辆出厂通知', '541120030001', 'carOutParkingAreaAdapt', '68', '1001', '2023-02-05 13:35:05', '0');
INSERT INTO `c_business_databus` VALUES ('122023022212000022', '添加考勤人员同步iot', '651130030001', 'sendAttendanceStaffDataToIotAdapt', '69', '1001', '2023-02-22 02:02:32', '0');
INSERT INTO `c_business_databus` VALUES ('122023022238120025', '删除考勤人员同步IOT', '651130050001', 'sendDeleteAttendanceStaffDataToIotAdapt', '70', '1001', '2023-02-22 02:03:03', '0');
INSERT INTO `c_business_databus` VALUES ('122023022337420010', '水电费缴费智能表充值', '610100030001', 'smartMeterAdapt', '71', '2002', '2023-02-23 19:33:08', '0');
INSERT INTO `c_business_databus` VALUES ('122023030848110035', '修改车辆黑白名单同步IOT', '112200040001', 'updateCarBlackWhiteToIotAdapt', '81', '1001', '2023-03-08 10:03:43', '0');
INSERT INTO `c_business_databus` VALUES ('122023082220610010', '欠费催缴', 'oweFeeCallable', 'oweFeeCallableAdapt', '82', '1001', '2023-08-22 08:41:26', '0');
INSERT INTO `c_business_databus` VALUES ('122023101826740004', '房屋批量创建费用', 'roomCreatePayFee', 'roomCreatePayFeeAdapt', '83', '1001', '2023-10-18 23:32:48', '0');
INSERT INTO `c_business_databus` VALUES ('122024010233810003', '工作单通知员工', 'oaWorkTaskToStaff', 'oaWorkTaskToStaffAdapt', '84', '1001', '2024-01-02 21:31:31', '0');
INSERT INTO `c_business_databus` VALUES ('122024011962250033', '小区信息数据同步物联网', 'sendCommunityDataToIot', 'sendCommunityDataToIotAdapt', '85', '1001', '2024-01-19 16:27:53', '0');
INSERT INTO `c_business_databus` VALUES ('122024012289710005', '添加业主同步到新版物联网', '110100030001', 'sendOwnerDataToIotAdapt', '87', '1001', '2024-01-22 22:16:29', '1');
INSERT INTO `c_business_databus` VALUES ('122024012427170044', '添加员工同步物联网', '200100060001', 'sendStaffDataToIotAdapt', '86', '1001', '2024-01-24 10:06:48', '0');
INSERT INTO `c_business_databus` VALUES ('122024012440540050', '删除员工同步物联网', '200100070001', 'sendDeleteStaffDataToIotAdapt', '88', '1001', '2024-01-24 10:18:19', '0');
INSERT INTO `c_business_databus` VALUES ('122024012450990047', '修改员工同步物联网', '200100080001', 'sendStaffDataToIotAdapt', '87', '1001', '2024-01-24 10:07:13', '0');
INSERT INTO `c_business_databus` VALUES ('122024022606010324', '投诉通知处理人', 'sendComplaintNotifyStaff', 'sendComplaintNotifyStaffAdapt', '89', '1001', '2024-02-26 18:06:02', '0');

-- ----------------------------
-- Table structure for c_business_table_his
-- ----------------------------
DROP TABLE IF EXISTS `c_business_table_his`;
CREATE TABLE `c_business_table_his` (
  `his_id` varchar(30) NOT NULL COMMENT '历史ID',
  `action` varchar(12) DEFAULT NULL COMMENT '动作表，ADD 添加记录 MOD 修改记录 DEL删除记录',
  `action_obj` varchar(64) NOT NULL COMMENT '动作对象，一般为表名',
  `action_obj_his` varchar(64) NOT NULL COMMENT 'his表',
  `business_type_cd` varchar(64) NOT NULL COMMENT '业务动作',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表',
  UNIQUE KEY `his_id` (`his_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_business_table_his
-- ----------------------------
INSERT INTO `c_business_table_his` VALUES ('102021091307480005', 'ADD', 'f_floor', 'business_floor', '510100030001', '测试楼栋', '2021-09-13 17:17:08', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091339040007', 'DEL', 'f_floor', 'business_floor', '510100050001', '测试删除', '2021-09-13 17:19:36', '1');
INSERT INTO `c_business_table_his` VALUES ('102021091367820006', 'MOD', 'f_floor', 'business_floor', '510100040001', '测试', '2021-09-13 17:18:56', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091382890008', 'DEL', 'f_floor', 'business_floor', '510100050001', '', '2021-09-13 17:20:14', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091812780001', 'ADD', 's_community', 'business_community', '500100030001', '添加小区', '2021-09-18 14:55:57', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091817250004', 'ADD', 's_community_member', 'business_community_member', '500100030002', '成员加入', '2021-09-18 15:01:28', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091845550002', 'MOD', 's_community', 'business_community', '500100040001', '修改小区信息', '2021-09-18 14:57:05', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091856610005', 'DEL', 's_community_member', 'business_community_member', '500100040002', '成员退出', '2021-09-18 15:02:33', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091860470008', 'DEL', 'pay_fee_config', 'business_pay_fee_config', '620100050001', '删除费用项', '2021-09-18 15:12:54', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091870440007', 'MOD', 'pay_fee_config', 'business_pay_fee_config', '620100040001', '修改费用项', '2021-09-18 15:12:25', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091879960003', 'DEL', 's_community', 'business_community', '500100050001', '删除小区', '2021-09-18 14:57:31', '0');
INSERT INTO `c_business_table_his` VALUES ('102021091882120006', 'ADD', 'pay_fee_config', 'business_pay_fee_config', '620100030001', '添加费用项', '2021-09-18 15:12:01', '0');
INSERT INTO `c_business_table_his` VALUES ('102021092432060001', 'ADD', 'parking_area_text', 'NO', '541100030003', '', '2021-09-24 09:54:33', '0');
INSERT INTO `c_business_table_his` VALUES ('102021092456890002', 'MOD', 'parking_area_text', 'NO', '541100040003', '', '2021-09-24 09:54:58', '0');
INSERT INTO `c_business_table_his` VALUES ('102021100901700001', 'ADD', 'property_right_registration', 'business_property_right_registration', '671100030012', '添加产权登记', '2021-10-09 17:16:42', '0');
INSERT INTO `c_business_table_his` VALUES ('102021100902130003', 'DEL', 'property_right_registration', 'business_property_right_registration', '671100050012', '删除产权登记', '2021-10-09 17:24:37', '0');
INSERT INTO `c_business_table_his` VALUES ('102021100910090002', 'MOD', 'property_right_registration', 'business_property_right_registration', '671100040012', '修改产权登记', '2021-10-09 17:24:00', '0');
INSERT INTO `c_business_table_his` VALUES ('102021101476020003', 'DEL', 'pay_fee', 'business_pay_fee', '600100050001', '删除费用', '2021-10-14 19:00:27', '0');
INSERT INTO `c_business_table_his` VALUES ('102021101496000001', 'ADD', 'pay_fee', 'business_pay_fee', '600100030001', '添加费用时', '2021-10-14 18:59:04', '0');
INSERT INTO `c_business_table_his` VALUES ('102021101499520002', 'MOD', 'pay_fee', 'business_pay_fee', '600100040001', '修改', '2021-10-14 18:59:29', '0');
INSERT INTO `c_business_table_his` VALUES ('102021101966920001', 'ADD', 'parking_box', 'NO', '541100030004', '', '2021-10-19 10:19:22', '0');
INSERT INTO `c_business_table_his` VALUES ('102021111090500001', 'ADD', 'machine', 'business_machine', '200200030001', '添加设备', '2021-11-10 10:56:08', '0');
INSERT INTO `c_business_table_his` VALUES ('102021120265160001', 'ADD', 'oa_workflow_data', 'NO', '551100030004', '', '2021-12-02 17:21:47', '0');
INSERT INTO `c_business_table_his` VALUES ('102021123162290001', 'MOD', 'online_pay', 'NO', '561100030004', '', '2021-12-31 18:18:28', '0');
INSERT INTO `c_business_table_his` VALUES ('102022031097790001', 'ADD', 'pay_fee_detail', 'business_pay_fee_detail', '610100030001', '', '2022-03-10 15:56:45', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060809190005', 'MOD', 'owner_car', 'business_owner_car', '111200040001', '修改车辆', '2022-06-08 10:44:04', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060816130007', 'ADD', 'building_owner', 'business_building_owner', '110100030001', '', '2022-06-08 10:45:15', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060828290003', 'DEL', 'parking_area', 'business_parking_area', '541100050001', '删除停车场', '2022-06-08 10:42:13', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060831580009', 'DEL', 'building_owner', 'business_building_owner', '110100050001', '', '2022-06-08 10:45:53', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060840310002', 'MOD', 'parking_area', 'business_parking_area', '541100040001', '修改停车场', '2022-06-08 10:41:45', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060865520001', 'ADD', 'parking_area', 'business_parking_area', '541100030001', '添加停车场', '2022-06-08 10:40:32', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060875330004', 'ADD', 'owner_car', 'business_owner_car', '111200030001', '添加车辆', '2022-06-08 10:43:41', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060880330006', 'DEL', 'owner_car', 'business_owner_car', '111200050001', '删除车辆', '2022-06-08 10:44:27', '0');
INSERT INTO `c_business_table_his` VALUES ('102022060886340008', 'MOD', 'building_owner', 'business_building_owner', '110100040001', '', '2022-06-08 10:45:35', '0');
INSERT INTO `c_business_table_his` VALUES ('102022061024770002', 'DEL', 'building_owner_room_rel', 'business_building_owner_room_rel', '111100050001', '', '2022-06-10 11:54:30', '0');
INSERT INTO `c_business_table_his` VALUES ('102022061080030001', 'ADD', 'building_owner_room_rel', 'business_building_owner_room_rel', '111100030001', '房屋绑定', '2022-06-10 11:54:02', '0');
INSERT INTO `c_business_table_his` VALUES ('102022072904930025', 'DEL', 's_store_user', 'business_store_user', '200100070001', '', '2022-07-29 11:02:17', '0');
INSERT INTO `c_business_table_his` VALUES ('102022072907450024', 'MOD', 's_store_user', 'business_store_user', '200100080001', '', '2022-07-29 11:01:04', '0');
INSERT INTO `c_business_table_his` VALUES ('102022072970500023', 'ADD', 's_store_user', 'business_store_user', '200100060001', '', '2022-07-29 10:54:48', '0');
INSERT INTO `c_business_table_his` VALUES ('102022080440800044', 'DEL', 'attendance_classes', 'NO', '651100050003', '', '2022-08-04 10:42:41', '0');
INSERT INTO `c_business_table_his` VALUES ('102022080464280043', 'MOD', 'attendance_classes', 'NO', '651100040003', '', '2022-08-04 10:42:23', '0');
INSERT INTO `c_business_table_his` VALUES ('102022080495330042', 'ADD', 'attendance_classes', 'NO', '651100030003', '', '2022-08-04 10:41:56', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082427670087', 'DEL', 'temp_car_fee_config', 'business_temp_car_fee_config', '651100050001', '删除', '2022-08-24 00:07:22', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082429670081', 'ADD', 'temp_car_fee_config', 'business_temp_car_fee_config', '651100030001', '添加', '2022-08-24 00:06:24', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082494470084', 'MOD', 'temp_car_fee_config', 'business_temp_car_fee_config', '651100040001', '修改', '2022-08-24 00:06:50', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082547510004', 'ADD', 'car_black_white', 'NO', '112200030001', '', '2022-08-25 22:47:15', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082549710006', 'DEL', 'car_black_white', 'NO', '112200050001', '', '2022-08-25 22:48:04', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082583800005', 'MOD', 'car_black_white', 'NO', '112200040001', '', '2022-08-25 22:47:43', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082603590017', 'DEL', 'parking_box', 'NO', '541100050004', '', '2022-08-26 16:17:35', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082626850009', 'DEL', 'machine', 'business_machine', '200200050001', '', '2022-08-26 16:04:06', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082629430006', 'MOD', 'machine', 'business_machine', '200200040001', '', '2022-08-26 16:03:45', '0');
INSERT INTO `c_business_table_his` VALUES ('102022082666000014', 'MOD', 'parking_box', 'NO', '541100040004', '', '2022-08-26 16:17:16', '0');
INSERT INTO `c_business_table_his` VALUES ('102022092606760020', 'DEL', 'r_repair_user', 'business_repair_user', '130200050001', '', '2022-09-26 12:16:02', '0');
INSERT INTO `c_business_table_his` VALUES ('102022092615420017', 'MOD', 'r_repair_user', 'business_repair_user', '130200040001', '', '2022-09-26 12:15:40', '0');
INSERT INTO `c_business_table_his` VALUES ('102022092624520008', 'MOD', 'r_repair_pool', 'business_repair_pool', '130100040001', '', '2022-09-26 12:13:01', '0');
INSERT INTO `c_business_table_his` VALUES ('102022092625130004', 'ADD', 'r_repair_pool', 'business_repair_pool', '130100030001', '报修登记', '2022-09-26 10:28:41', '0');
INSERT INTO `c_business_table_his` VALUES ('102022092634950014', 'ADD', 'r_repair_user', 'business_repair_user', '130200030001', '', '2022-09-26 12:15:17', '0');
INSERT INTO `c_business_table_his` VALUES ('102022092659570011', 'DEL', 'r_repair_pool', 'business_repair_pool', '130100050001', '', '2022-09-26 12:13:22', '0');
INSERT INTO `c_business_table_his` VALUES ('102022101238330002', 'MOD', 's_visit_info', 'NO', '120100040001', '修改访客登记', '2022-10-12 17:53:50', '0');
INSERT INTO `c_business_table_his` VALUES ('102022101288560001', 'ADD', 's_visit_info', 'NO', '120100030001', '访客登记', '2022-10-12 17:52:27', '0');
INSERT INTO `c_business_table_his` VALUES ('102022101568500001', 'ADD', 'n_notice', 'business_notice', '550100030001', '添加公告', '2022-10-15 14:22:29', '0');
INSERT INTO `c_business_table_his` VALUES ('102022101589660004', 'ADD', 'parking_coupon_car', 'NO', '541130030001', '添加停车劵', '2022-10-15 12:27:42', '0');
INSERT INTO `c_business_table_his` VALUES ('102022101595720007', 'DEL', 'parking_coupon_car', 'NO', '541130050001', '删除停车劵', '2022-10-15 12:28:15', '0');
INSERT INTO `c_business_table_his` VALUES ('102022102739650011', 'ADD', 'machine_record', 'NO', '230200030001', '开门记录', '2022-10-27 15:20:00', '0');
INSERT INTO `c_business_table_his` VALUES ('102022102877000003', 'ADD', 'car_inout_detail', 'NO', '541120030001', '车辆进场', '2022-10-28 00:58:35', '0');
INSERT INTO `c_business_table_his` VALUES ('102023012450710005', 'ADD', 'access_control_white_auth', 'NO', '551130030001', '添加门禁白名单', '2023-01-24 11:51:03', '0');
INSERT INTO `c_business_table_his` VALUES ('102023012469170008', 'MOD', 'access_control_white', 'NO', '551130040001', '', '2023-01-24 11:51:22', '0');
INSERT INTO `c_business_table_his` VALUES ('102023012485440011', 'DEL', 'access_control_white_auth', 'NO', '551130050001', '删除门禁白名单', '2023-01-24 11:51:52', '0');
INSERT INTO `c_business_table_his` VALUES ('102023022261870019', 'DEL', 'attendance_classes_staff', 'NO', '651130050001', '删除考勤人员', '2023-02-22 02:01:46', '0');
INSERT INTO `c_business_table_his` VALUES ('102023022288320016', 'ADD', 'attendance_classes_staff', 'NO', '651130030001', '添加考勤人员', '2023-02-22 02:01:15', '0');
INSERT INTO `c_business_table_his` VALUES ('102023081125600004', 'ADD', 'building_room', 'business_building_room', '530100030001', '添加房屋', '2023-08-11 00:07:27', '0');
INSERT INTO `c_business_table_his` VALUES ('102023081137470007', 'MOD', 'building_room', 'business_building_room', '530100040001', '', '2023-08-11 00:08:20', '0');
INSERT INTO `c_business_table_his` VALUES ('102023081141370010', 'DEL', 'building_room', 'business_building_room', '530100050001', '', '2023-08-11 00:08:43', '0');

-- ----------------------------
-- Table structure for c_business_type
-- ----------------------------
DROP TABLE IF EXISTS `c_business_type`;
CREATE TABLE `c_business_type` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `business_type_cd` varchar(12) NOT NULL COMMENT '业务项类型',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `description` varchar(200) DEFAULT NULL COMMENT '描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `business_type_cd` (`business_type_cd`) USING BTREE,
  UNIQUE KEY `business_type_cd_2` (`business_type_cd`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=294 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_business_type
-- ----------------------------
INSERT INTO `c_business_type` VALUES ('1', 'DO', '撤单', '作废订单', '2019-02-07 17:04:21');
INSERT INTO `c_business_type` VALUES ('3', '100100030001', '保存用户信息', '保存用户信息', '2019-02-07 17:05:15');
INSERT INTO `c_business_type` VALUES ('4', '100100030002', '保存用户地址信息', '保存用户地址信息', '2019-02-07 17:05:47');
INSERT INTO `c_business_type` VALUES ('6', '100100030003', '用户打标', '用户打标', '2019-02-07 17:20:49');
INSERT INTO `c_business_type` VALUES ('7', '100100030004', '用户证件', '保存用户地址信息', '2019-02-07 17:20:49');
INSERT INTO `c_business_type` VALUES ('8', '100100040001', '修改用户信息', '修改用户信息', '2019-02-07 17:21:08');
INSERT INTO `c_business_type` VALUES ('9', '100100040002', '停用用户信息', '停用用户信息', '2019-02-07 17:21:08');
INSERT INTO `c_business_type` VALUES ('10', '100100040003', '恢复用户信息', '恢复用户信息', '2019-02-07 17:21:08');
INSERT INTO `c_business_type` VALUES ('11', '200100030001', '保存商户信息', '保存商户信息', '2019-02-07 17:21:08');
INSERT INTO `c_business_type` VALUES ('12', '200100030002', '商户成员加入信息', '商户成员加入信息', '2019-02-07 17:21:08');
INSERT INTO `c_business_type` VALUES ('13', '200100040001', '修改商户信息', '修改商户信息', '2019-02-07 17:21:08');
INSERT INTO `c_business_type` VALUES ('14', '200100040002', '商户成员退出信息', '商户成员退出信息', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('15', '200100050001', '删除商户信息', '删除商户信息', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('16', '300100030001', '保存商品信息', '保存商品信息', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('17', '300100030002', '购买商品', '购买商品', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('18', '300100030003', '保存商品目录', '保存商品目录', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('19', '300100040001', '修改商品信息', '修改商品信息', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('20', '300100040002', '修改商品目录', '修改商品目录', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('21', '300100050001', '删除商品信息', '删除商品信息', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('22', '300100050002', '修改商品目录', '修改商品目录', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('23', '400100030001', '保存评论', '保存评论', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('24', '400100050001', '删除评论', '删除评论', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('25', '500100030001', '保存小区信息', '保存小区信息', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('26', '500100030002', '小区成员加入信息', '小区成员加入信息', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('27', '500100040001', '修改小区信息', '修改商户信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('28', '500100040002', '小区成员退出信息', '小区成员退出信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('29', '500100050001', '删除小区信息', '删除商户信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('30', '610100030001', '保存费用明细信息', '保存费用明细信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('31', '610100040001', '修改费用明细信息', '修改费用明细信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('32', '610100050001', '删除费用明细信息', '删除费用明细信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('33', '620100030001', '保存费用配置', '保存费用配置', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('34', '620100040001', '修改费用配置', '修改费用配置', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('35', '620100050001', '删除费用配置', '删除费用配置', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('36', '600100030001', '保存费用信息', '保存费用信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('37', '600100040001', '修改费用信息', '修改费用信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('38', '600100050001', '删除费用信息', '删除费用信息', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('45', '700100030001', '保存代理商信息', '保存代理商信息', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('46', '700100030002', '保存代理商照片', '保存代理商照片', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('47', '700100030003', '保存代理商证件', '保存代理商证件', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('48', '700100030004', '添加代理商员工', '添加代理商员工', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('49', '700100040001', '修改代理商信息', '修改代理商信息', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('50', '700100040002', '修改代理商照片', '修改代理商照片', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('51', '700100040003', '修改代理商证件', '修改代理商证件', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('52', '700100050001', '删除代理商属性', '删除代理商属性', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('53', '700100050002', '删除代理商照片', '删除代理商照片', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('54', '700100050003', '删除代理商证件', '删除代理商证件', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('55', '700100050004', '删除代理商员工', '删除代理商员工', '2019-02-07 17:21:11');
INSERT INTO `c_business_type` VALUES ('56', '200100060001', '添加商户员工', '添加商户员工', '2019-03-30 03:17:24');
INSERT INTO `c_business_type` VALUES ('57', '200100070001', '删除商户员工', '删除商户员工', '2019-03-30 03:17:52');
INSERT INTO `c_business_type` VALUES ('58', '510100030001', '保存小区楼', '保存小区楼', '2019-04-21 09:05:20');
INSERT INTO `c_business_type` VALUES ('59', '510100040001', '修改小区楼', '修改小区楼', '2019-04-21 09:05:57');
INSERT INTO `c_business_type` VALUES ('60', '510100050001', '删除小区楼', '删除小区楼', '2019-04-21 09:06:15');
INSERT INTO `c_business_type` VALUES ('61', '520100030001', '保存小区单元', '保存小区单元', '2019-04-21 09:05:20');
INSERT INTO `c_business_type` VALUES ('62', '520100040001', '修改小区单元', '修改小区单元', '2019-04-21 09:05:57');
INSERT INTO `c_business_type` VALUES ('63', '520100050001', '删除小区单元', '删除小区单元', '2019-04-21 09:06:15');
INSERT INTO `c_business_type` VALUES ('64', '530100030001', '保存房屋信息', '保存房屋信息', '2019-05-08 10:46:47');
INSERT INTO `c_business_type` VALUES ('65', '530100040001', '修改房屋信息', '修改房屋信息', '2019-05-08 10:47:04');
INSERT INTO `c_business_type` VALUES ('66', '530100050001', '删除房屋信息', '删除房屋信息', '2019-05-08 10:47:17');
INSERT INTO `c_business_type` VALUES ('67', '540100030001', '保存停车位信息', '保存停车位信息', '2019-05-08 10:46:47');
INSERT INTO `c_business_type` VALUES ('68', '540100040001', '修改停车位信息', '修改停车位信息', '2019-05-08 10:47:04');
INSERT INTO `c_business_type` VALUES ('69', '540100050001', '删除停车位信息', '删除停车位信息', '2019-05-08 10:47:17');
INSERT INTO `c_business_type` VALUES ('70', '111200030001', '保存业主车辆', '保存业主车辆', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('71', '111200050001', '删除业主车辆', '删除业主车辆', '2019-02-07 17:21:09');
INSERT INTO `c_business_type` VALUES ('72', '111200040001', '修改业主车辆', '修改业主车辆', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('73', '900100030001', '保存DEMO', '保存DEMO', '2019-02-07 17:21:10');
INSERT INTO `c_business_type` VALUES ('74', '550100030001', '保存公告信息', '保存公告信息', '2019-05-08 10:46:47');
INSERT INTO `c_business_type` VALUES ('75', '550100040001', '修改公告信息', '修改公告信息', '2019-05-08 10:47:04');
INSERT INTO `c_business_type` VALUES ('76', '550100050001', '删除公告信息', '删除公告信息', '2019-05-08 10:47:17');
INSERT INTO `c_business_type` VALUES ('78', '123456', '业务测试', 'yewuceshi ', '2019-08-18 14:58:20');
INSERT INTO `c_business_type` VALUES ('79', '1234567', '业务测试3', 'yewuceshi3', '2019-08-18 14:58:55');
INSERT INTO `c_business_type` VALUES ('82', '110100030001', '添加业主', '添加业主', '2019-09-11 02:08:52');
INSERT INTO `c_business_type` VALUES ('83', '110100040001', '编辑业主', '编辑业主', '2019-09-13 08:22:53');
INSERT INTO `c_business_type` VALUES ('84', '110100050001', '删除业主', '删除业主', '2019-09-13 08:24:33');
INSERT INTO `c_business_type` VALUES ('85', '120100030001', '访客登记', '访客登记', '2019-09-13 08:25:53');
INSERT INTO `c_business_type` VALUES ('86', '120100040001', '访客信息修改', '访客信息修改', '2019-09-20 08:24:54');
INSERT INTO `c_business_type` VALUES ('87', '500100040003', '审核小区成员状态', '审核小区成员状态', '2019-09-20 15:14:32');
INSERT INTO `c_business_type` VALUES ('88', '130100030001', '登记报修信息', '登记报修', '2019-10-05 02:00:31');
INSERT INTO `c_business_type` VALUES ('89', '130100040001', '修改报修信息', '', '2019-10-05 02:07:14');
INSERT INTO `c_business_type` VALUES ('90', '130100050001', '删除报修信息', '', '2019-10-05 02:07:49');
INSERT INTO `c_business_type` VALUES ('91', '130200030001', '报修派单信息', '', '2019-10-05 02:08:58');
INSERT INTO `c_business_type` VALUES ('92', '130200040001', '报修派单变更', '', '2019-10-05 02:09:28');
INSERT INTO `c_business_type` VALUES ('93', '130200050001', '作废报修派单信息', '', '2019-10-05 02:10:03');
INSERT INTO `c_business_type` VALUES ('94', '140100030001', '保存组织信息', '', '2019-10-07 02:11:35');
INSERT INTO `c_business_type` VALUES ('95', '140100040001', '修改组织信息', '', '2019-10-07 02:12:16');
INSERT INTO `c_business_type` VALUES ('96', '140100050001', '删除组织信息', '', '2019-10-07 02:12:51');
INSERT INTO `c_business_type` VALUES ('97', '140200030001', '添加组织员工关系', '', '2019-10-16 23:31:55');
INSERT INTO `c_business_type` VALUES ('98', '140200050001', '删除员工组织关系', '', '2019-10-16 23:32:24');
INSERT INTO `c_business_type` VALUES ('99', '150200030001', '保存资源', '', '2019-10-21 20:04:50');
INSERT INTO `c_business_type` VALUES ('100', '150200040001', '修改资源', '', '2019-10-21 20:05:19');
INSERT INTO `c_business_type` VALUES ('101', '150200050001', '删除资源', '', '2019-10-21 20:05:50');
INSERT INTO `c_business_type` VALUES ('102', '160200030001', '保存审核人员', '', '2019-10-26 10:12:46');
INSERT INTO `c_business_type` VALUES ('103', '160200050001', '删除审核人员', '', '2019-10-26 10:13:55');
INSERT INTO `c_business_type` VALUES ('104', '190200030001', '保存投诉建议', '', '2019-10-31 23:19:52');
INSERT INTO `c_business_type` VALUES ('105', '190200040001', '修改投诉建议', '', '2019-10-31 23:20:25');
INSERT INTO `c_business_type` VALUES ('106', '190200050001', '删除投诉建议', '', '2019-10-31 23:20:59');
INSERT INTO `c_business_type` VALUES ('107', '200200030001', '保存设备', '', '2019-11-08 23:39:28');
INSERT INTO `c_business_type` VALUES ('108', '200200040001', '修改设备', '', '2019-11-08 23:40:24');
INSERT INTO `c_business_type` VALUES ('109', '200200050001', '删除设备', '', '2019-11-08 23:41:08');
INSERT INTO `c_business_type` VALUES ('110', '210200030001', '保存设备同步', '', '2019-11-10 18:52:00');
INSERT INTO `c_business_type` VALUES ('111', '210200040001', '修改设备同步', '', '2019-11-10 18:52:36');
INSERT INTO `c_business_type` VALUES ('112', '210200050001', '删除设备同步', '', '2019-11-10 18:53:11');
INSERT INTO `c_business_type` VALUES ('113', '220200030001', '保存 文件保存关系', '', '2019-11-11 22:02:47');
INSERT INTO `c_business_type` VALUES ('114', '220200040001', '修改 文件保存关系', '', '2019-11-11 22:03:08');
INSERT INTO `c_business_type` VALUES ('115', '220200050001', '删除 文件保存关系', '', '2019-11-11 22:03:30');
INSERT INTO `c_business_type` VALUES ('116', '230200030001', '保存开门记录', '', '2019-11-26 23:02:26');
INSERT INTO `c_business_type` VALUES ('117', '230200050001', '删除开门记录', '', '2019-11-26 23:02:57');
INSERT INTO `c_business_type` VALUES ('118', '240200030001', '申请钥匙', '', '2019-12-01 23:28:08');
INSERT INTO `c_business_type` VALUES ('119', '240200040001', '修改申请钥匙', '', '2019-12-01 23:28:45');
INSERT INTO `c_business_type` VALUES ('120', '240200050001', '删除申请钥匙', '', '2019-12-01 23:29:12');
INSERT INTO `c_business_type` VALUES ('121', '250200030001', '保存消息', '', '2019-12-04 21:01:12');
INSERT INTO `c_business_type` VALUES ('122', '250200040001', '修改消息', '', '2019-12-04 21:01:41');
INSERT INTO `c_business_type` VALUES ('123', '250200050001', '删除消息', '', '2019-12-04 21:02:02');
INSERT INTO `c_business_type` VALUES ('124', '260200030001', '消息阅读', '', '2019-12-05 21:32:58');
INSERT INTO `c_business_type` VALUES ('125', '270200030001', '保存广告', '', '2019-12-07 15:15:22');
INSERT INTO `c_business_type` VALUES ('126', '270200040001', '修改广告', '', '2019-12-07 15:15:55');
INSERT INTO `c_business_type` VALUES ('127', '270200050001', '删除广告', '', '2019-12-07 15:16:23');
INSERT INTO `c_business_type` VALUES ('128', '271200030001', '保存广告内容', '', '2019-12-07 15:17:01');
INSERT INTO `c_business_type` VALUES ('129', '271200040001', '修改广告内容', '', '2019-12-07 15:17:23');
INSERT INTO `c_business_type` VALUES ('130', '271200050001', '删除广告内容', '', '2019-12-07 15:17:45');
INSERT INTO `c_business_type` VALUES ('131', '111100030001', '房屋购买', '房屋购买', '2019-12-15 12:19:42');
INSERT INTO `c_business_type` VALUES ('132', '111100040001', '房屋状态变更', '房屋状态变更', '2019-12-15 12:20:01');
INSERT INTO `c_business_type` VALUES ('133', '111100050001', '退房', '退房', '2019-12-15 12:20:19');
INSERT INTO `c_business_type` VALUES ('134', '280200030001', '业主绑定', '', '2019-12-29 13:40:13');
INSERT INTO `c_business_type` VALUES ('135', '280200040001', '审核业主绑定', '', '2019-12-29 13:40:49');
INSERT INTO `c_business_type` VALUES ('136', '280200050001', '解绑业主', '', '2019-12-29 13:41:15');
INSERT INTO `c_business_type` VALUES ('137', '290200030001', '保存活动', '', '2020-01-13 19:34:54');
INSERT INTO `c_business_type` VALUES ('138', '290200040001', '修改活动', '', '2020-01-13 19:35:18');
INSERT INTO `c_business_type` VALUES ('139', '290200050001', '删除活动', '', '2020-01-13 19:35:43');
INSERT INTO `c_business_type` VALUES ('140', '541100030001', '保存停车场', '', '2020-01-23 00:43:03');
INSERT INTO `c_business_type` VALUES ('141', '541100040001', '修改停车场', '', '2020-01-23 00:43:31');
INSERT INTO `c_business_type` VALUES ('142', '541100050001', '删除停车场', '', '2020-01-23 00:44:09');
INSERT INTO `c_business_type` VALUES ('143', '112200030001', '保存车辆黑白名单', '', '2020-01-23 12:36:33');
INSERT INTO `c_business_type` VALUES ('144', '112200040001', '修改黑白名单', '', '2020-01-23 12:36:58');
INSERT INTO `c_business_type` VALUES ('145', '112200050001', '删除黑白名单', '', '2020-01-23 12:37:23');
INSERT INTO `c_business_type` VALUES ('146', '541110030001', '添加车辆进出场', '', '2020-01-23 22:15:12');
INSERT INTO `c_business_type` VALUES ('147', '541110040001', '修改车辆进出场', '', '2020-01-23 22:15:46');
INSERT INTO `c_business_type` VALUES ('148', '541120030001', '添加进场记录详情', '', '2020-01-25 23:47:04');
INSERT INTO `c_business_type` VALUES ('149', '541120040001', '修改进场记录详情', '', '2020-01-25 23:47:46');
INSERT INTO `c_business_type` VALUES ('150', '541120050001', '删除进场记录详情', '', '2020-01-25 23:48:24');
INSERT INTO `c_business_type` VALUES ('151', '300200030001', '保存巡检点', '', '2020-02-06 12:16:31');
INSERT INTO `c_business_type` VALUES ('152', '300200040001', '修改巡检点', '', '2020-02-06 12:17:50');
INSERT INTO `c_business_type` VALUES ('153', '300200050001', '删除巡检点', '', '2020-02-06 12:18:22');
INSERT INTO `c_business_type` VALUES ('154', '500200030001', '保存巡检路线', '', '2020-02-10 15:01:48');
INSERT INTO `c_business_type` VALUES ('155', '500200040001', '修改巡检路线', '', '2020-02-10 15:02:42');
INSERT INTO `c_business_type` VALUES ('156', '500200050001', '删除巡检路线', '', '2020-02-10 15:03:16');
INSERT INTO `c_business_type` VALUES ('157', '510200030001', '保存巡检点', '', '2020-02-10 16:35:03');
INSERT INTO `c_business_type` VALUES ('158', '510200040001', '修改巡检点', '', '2020-02-10 16:35:30');
INSERT INTO `c_business_type` VALUES ('159', '510200050001', '删除巡检点', '', '2020-02-10 16:35:50');
INSERT INTO `c_business_type` VALUES ('160', '140300030001', '添加隶属小区', '', '2020-02-14 18:02:02');
INSERT INTO `c_business_type` VALUES ('161', '140300050001', '删除隶属小区', '', '2020-02-14 18:02:38');
INSERT INTO `c_business_type` VALUES ('162', '520200030001', '保存巡检计划', '', '2020-02-17 19:14:23');
INSERT INTO `c_business_type` VALUES ('163', '520200040001', '修改巡检计划', '', '2020-02-17 19:14:59');
INSERT INTO `c_business_type` VALUES ('164', '520200050001', '删除巡检计划', '', '2020-02-17 19:15:25');
INSERT INTO `c_business_type` VALUES ('165', '530200030001', '保存巡检任务', '', '2020-02-19 21:39:00');
INSERT INTO `c_business_type` VALUES ('166', '530200040001', '修改巡检任务', '', '2020-02-19 21:39:42');
INSERT INTO `c_business_type` VALUES ('167', '530200050001', '删除巡检任务', '', '2020-02-19 21:40:20');
INSERT INTO `c_business_type` VALUES ('168', '210100040001', '编辑采购申请', '', '2020-02-26 16:09:42');
INSERT INTO `c_business_type` VALUES ('169', '210100050001', '删除采购申请', '', '2020-02-26 16:10:03');
INSERT INTO `c_business_type` VALUES ('170', '210100030001', '保存采购申请', '', '2020-03-05 10:13:51');
INSERT INTO `c_business_type` VALUES ('171', '500200030002', '保存巡检路线巡检点关系', '', '2020-03-28 23:09:56');
INSERT INTO `c_business_type` VALUES ('172', '500200050002', '删除巡检线路巡检点关系', '', '2020-03-28 23:10:31');
INSERT INTO `c_business_type` VALUES ('173', '540200030001', '保存巡检任务明细', '', '2020-04-05 15:07:41');
INSERT INTO `c_business_type` VALUES ('174', '540200040001', '修改巡检任务明细', '', '2020-04-05 15:08:16');
INSERT INTO `c_business_type` VALUES ('175', '210100080001', '订单(采购/申请)删除', '', '2020-04-11 18:25:01');
INSERT INTO `c_business_type` VALUES ('176', '550200030001', '保存旧货市场', '', '2020-04-18 17:11:58');
INSERT INTO `c_business_type` VALUES ('177', '550200040001', '修改旧货市场', '', '2020-04-18 17:12:25');
INSERT INTO `c_business_type` VALUES ('178', '550200050001', '删除旧货市场', '', '2020-04-18 17:12:50');
INSERT INTO `c_business_type` VALUES ('179', '保存商品规格', 'productDoodsDetail.saveProductDoodsDetail', '保存商品规格', '2020-04-19 20:27:04');
INSERT INTO `c_business_type` VALUES ('180', '200100040003', '修改商户信息', '', '2020-04-26 21:32:51');
INSERT INTO `c_business_type` VALUES ('181', '520300030001', '保存巡检计划人', '', '2020-05-05 22:30:08');
INSERT INTO `c_business_type` VALUES ('182', '520300050001', '删除巡检计划人', '', '2020-05-05 22:30:41');
INSERT INTO `c_business_type` VALUES ('183', '621100030001', '退费申请', '', '2020-05-11 16:56:28');
INSERT INTO `c_business_type` VALUES ('184', '621100040001', '修改退费申请', '', '2020-05-11 16:56:53');
INSERT INTO `c_business_type` VALUES ('185', '621100050001', '删除退费申请', '', '2020-05-11 16:57:20');
INSERT INTO `c_business_type` VALUES ('186', '210200060001', '保存小程序配置', '', '2020-05-16 17:11:02');
INSERT INTO `c_business_type` VALUES ('187', '210200070001', '修改小程序配置', '', '2020-05-16 17:11:22');
INSERT INTO `c_business_type` VALUES ('188', '210200080001', '删除小程序配置', '', '2020-05-16 17:11:42');
INSERT INTO `c_business_type` VALUES ('189', '560200030001', '添加定时任务', '', '2020-06-02 13:05:15');
INSERT INTO `c_business_type` VALUES ('190', '560200040001', '修改定时任务', '', '2020-06-02 13:07:06');
INSERT INTO `c_business_type` VALUES ('191', '560200050001', '删除任务属性', '', '2020-06-02 13:07:31');
INSERT INTO `c_business_type` VALUES ('192', '560300030001', '添加任务属性', '', '2020-06-02 13:07:58');
INSERT INTO `c_business_type` VALUES ('193', '560300040001', '修改任务属性', '', '2020-06-02 13:08:36');
INSERT INTO `c_business_type` VALUES ('194', '560300050001', '删除任务属性', '', '2020-06-02 13:08:59');
INSERT INTO `c_business_type` VALUES ('195', '570100030001', '保存小区位置', '', '2020-06-04 18:36:15');
INSERT INTO `c_business_type` VALUES ('196', '570100040001', '修改小区位置', '', '2020-06-04 18:36:40');
INSERT INTO `c_business_type` VALUES ('197', '570100050001', '删除小区位置', '', '2020-06-04 18:37:02');
INSERT INTO `c_business_type` VALUES ('198', '100200030001', '保存用户属性', '', '2020-06-11 22:18:04');
INSERT INTO `c_business_type` VALUES ('199', '100200040001', '修改用户属性', '', '2020-06-11 22:18:42');
INSERT INTO `c_business_type` VALUES ('200', '100200050001', '删除用户属性', '', '2020-06-11 22:19:12');
INSERT INTO `c_business_type` VALUES ('201', '580100030001', '保存工作流', '', '2020-06-17 22:29:41');
INSERT INTO `c_business_type` VALUES ('202', '580100040001', '修改工作流', '', '2020-06-17 22:30:12');
INSERT INTO `c_business_type` VALUES ('203', '580100050001', '删除工作流', '', '2020-06-17 22:30:39');
INSERT INTO `c_business_type` VALUES ('204', '580200030001', '添加工作流节点', '', '2020-06-17 22:31:23');
INSERT INTO `c_business_type` VALUES ('205', '580200040001', '修改工作流节点', '', '2020-06-17 22:31:53');
INSERT INTO `c_business_type` VALUES ('206', '580200050001', '删除工作流节点', '', '2020-06-17 22:32:25');
INSERT INTO `c_business_type` VALUES ('207', '580300030001', '添加工作流节点员工', '', '2020-06-17 22:33:48');
INSERT INTO `c_business_type` VALUES ('208', '580300040001', '编辑工作流节点员工', '', '2020-06-17 22:34:34');
INSERT INTO `c_business_type` VALUES ('209', '580300050001', '删除工作流节点员工', '', '2020-06-17 22:35:29');
INSERT INTO `c_business_type` VALUES ('210', '221200030001', '添加微信属性', '', '2020-06-22 12:02:02');
INSERT INTO `c_business_type` VALUES ('211', '221200040001', '修改微信属性', '', '2020-06-22 12:02:25');
INSERT INTO `c_business_type` VALUES ('212', '221200050001', '删除微信属性', '', '2020-06-22 12:02:47');
INSERT INTO `c_business_type` VALUES ('213', '221300030001', '保存公众号菜单', '', '2020-06-22 21:03:51');
INSERT INTO `c_business_type` VALUES ('214', '221300040001', '修改公众号菜单', '', '2020-06-22 21:04:21');
INSERT INTO `c_business_type` VALUES ('215', '221300050001', '删除公众号菜单', '', '2020-06-22 21:04:55');
INSERT INTO `c_business_type` VALUES ('216', '131100030001', '添加报修设置', '', '2020-06-28 16:15:58');
INSERT INTO `c_business_type` VALUES ('217', '131100040001', '修改报修设置', '', '2020-06-28 16:16:28');
INSERT INTO `c_business_type` VALUES ('218', '131100050001', '删除报修设置', '', '2020-06-28 16:16:50');
INSERT INTO `c_business_type` VALUES ('219', '132100030001', '报错报修类型用户', '', '2020-06-28 16:17:31');
INSERT INTO `c_business_type` VALUES ('220', '132100040001', '修改报修用户', '', '2020-06-28 16:17:56');
INSERT INTO `c_business_type` VALUES ('221', '132100050001', '删除报修用户', '', '2020-06-28 16:18:26');
INSERT INTO `c_business_type` VALUES ('222', '631100030001', '保存水电费', '', '2020-06-29 11:21:51');
INSERT INTO `c_business_type` VALUES ('223', '631100040001', '修改水电费', '', '2020-06-29 11:23:46');
INSERT INTO `c_business_type` VALUES ('224', '631100050001', '删除水电费', '', '2020-06-29 11:24:11');
INSERT INTO `c_business_type` VALUES ('225', '110200030001', '增加业主属性', '', '2020-08-15 18:28:21');
INSERT INTO `c_business_type` VALUES ('226', '110200040001', '修改业主属性', '', '2020-08-15 18:28:49');
INSERT INTO `c_business_type` VALUES ('227', '110200050001', '删除业主属性', '', '2020-08-15 18:29:26');
INSERT INTO `c_business_type` VALUES ('228', '600100040002', '费用变更', '', '2020-09-04 16:57:54');
INSERT INTO `c_business_type` VALUES ('229', '641100030001', '保存优惠', '', '2020-11-29 19:11:26');
INSERT INTO `c_business_type` VALUES ('231', '651100030001', '添加临时车标准', '', '2021-01-16 17:50:42');
INSERT INTO `c_business_type` VALUES ('232', '651100040001', '修改临时车标准', '', '2021-01-16 17:51:08');
INSERT INTO `c_business_type` VALUES ('233', '651100050001', '删除临时车标准', '', '2021-01-16 17:51:36');
INSERT INTO `c_business_type` VALUES ('234', '651100030002', '添加临时车标准属性', '', '2021-01-16 17:52:26');
INSERT INTO `c_business_type` VALUES ('235', '651100040002', '修改临时车标准属性', '', '2021-01-16 17:52:50');
INSERT INTO `c_business_type` VALUES ('236', '651100050002', '删除临时车标准属性', '', '2021-01-16 17:53:25');
INSERT INTO `c_business_type` VALUES ('237', '651100030003', '添加考勤班组', '', '2021-01-22 15:29:43');
INSERT INTO `c_business_type` VALUES ('238', '651100040003', '修改考勤班组', '', '2021-01-22 15:30:12');
INSERT INTO `c_business_type` VALUES ('239', '651100050003', '删除考勤班组', '', '2021-01-22 15:30:38');
INSERT INTO `c_business_type` VALUES ('240', '651100030004', '保存考勤班组属性', '', '2021-01-23 15:10:13');
INSERT INTO `c_business_type` VALUES ('241', '651100040004', '编辑考勤班组属性', '', '2021-01-23 15:10:37');
INSERT INTO `c_business_type` VALUES ('242', '651100050004', '删除考勤班组属性', '', '2021-01-23 15:11:16');
INSERT INTO `c_business_type` VALUES ('243', '541100030002', '添加停车场属性', '', '2021-03-18 12:36:18');
INSERT INTO `c_business_type` VALUES ('244', '541100040002', '修改停车场属性', '', '2021-03-18 12:36:42');
INSERT INTO `c_business_type` VALUES ('245', '541100050002', '删除停车场', '', '2021-03-18 12:43:49');
INSERT INTO `c_business_type` VALUES ('246', '671100030004', '保存仓库', '', '2021-04-07 21:26:23');
INSERT INTO `c_business_type` VALUES ('247', '671100040004', '修改仓库', '', '2021-04-07 21:26:52');
INSERT INTO `c_business_type` VALUES ('248', '671100050004', '删除仓库', '', '2021-04-07 21:27:15');
INSERT INTO `c_business_type` VALUES ('249', '671100030005', '保存物品调拨', '', '2021-04-08 01:32:01');
INSERT INTO `c_business_type` VALUES ('250', '671100040005', '修改调拨', '', '2021-04-08 15:28:00');
INSERT INTO `c_business_type` VALUES ('251', '671100050005', '取消调拨', '取消调拨', '2021-04-19 10:11:21');
INSERT INTO `c_business_type` VALUES ('252', '671100040006', '修改我的物品库存', '修改我的物品库存', '2021-04-19 10:12:03');
INSERT INTO `c_business_type` VALUES ('253', '140200040001', '修改员工岗位关系', '修改员工岗位关系', '2021-04-19 10:12:36');
INSERT INTO `c_business_type` VALUES ('254', '671100050007', '删除物品类型', '', '2021-04-20 11:32:10');
INSERT INTO `c_business_type` VALUES ('255', '671100040007', '更新物品类型', '', '2021-04-20 11:31:18');
INSERT INTO `c_business_type` VALUES ('256', '671100030007', '添加物品类型', '', '2021-04-20 11:30:07');
INSERT INTO `c_business_type` VALUES ('257', '671100030010', '保存物品使用记录', '保存物品使用记录', '2021-04-28 17:41:56');
INSERT INTO `c_business_type` VALUES ('258', '671100050006', '删除我的物品', '删除我的物品', '2021-04-25 10:52:53');
INSERT INTO `c_business_type` VALUES ('259', '671100030006', '保存我的物品', '保存我的物品信息', '2021-04-25 10:49:54');
INSERT INTO `c_business_type` VALUES ('260', '671100030009', '保存物品转增记录', '保存我的物品转增记录', '2021-04-23 15:49:35');
INSERT INTO `c_business_type` VALUES ('261', '671100050008', '删除物品供应商', '删除物品资源供应商', '2021-04-23 10:52:53');
INSERT INTO `c_business_type` VALUES ('262', '671100040008', '修改物品供应商', '修改物品资源供应商', '2021-04-23 10:51:55');
INSERT INTO `c_business_type` VALUES ('263', '671100030008', '保存物品供应商', '保存物品资源供应商', '2021-04-23 10:50:48');
INSERT INTO `c_business_type` VALUES ('264', '681100030006', '添加调拨申请', '', '2021-04-29 19:38:15');
INSERT INTO `c_business_type` VALUES ('265', '681100040006', '修改调拨申请', '', '2021-04-29 19:38:41');
INSERT INTO `c_business_type` VALUES ('266', '681100050006', '删除调拨申请', '', '2021-04-29 19:39:04');
INSERT INTO `c_business_type` VALUES ('267', '121100030001', '保存账户', '', '2021-05-05 15:56:23');
INSERT INTO `c_business_type` VALUES ('268', '121100040001', '修改账户信息', '', '2021-05-05 15:57:07');
INSERT INTO `c_business_type` VALUES ('269', '121100030002', '保存账户明细', '', '2021-05-05 15:57:41');
INSERT INTO `c_business_type` VALUES ('270', '671100050011', '删除物品规格', '删除物品规格', '2021-05-12 11:08:48');
INSERT INTO `c_business_type` VALUES ('271', '671100040011', '修改物品规格', '修改物品规格', '2021-05-12 11:07:52');
INSERT INTO `c_business_type` VALUES ('272', '671100030011', '添加物品规格', '添加物品规格', '2021-05-12 10:49:12');
INSERT INTO `c_business_type` VALUES ('273', '500200040002', '修改巡检路线巡检点关系', '修改巡检路线巡检点关系', '2021-06-09 16:03:02');
INSERT INTO `c_business_type` VALUES ('274', '671200050011', '删除空置房验房记录', '删除空置房验房记录', '2021-08-31 08:54:34');
INSERT INTO `c_business_type` VALUES ('275', '671200040011', '修改空置房验房记录', '修改空置房验房记录', '2021-08-31 08:53:38');
INSERT INTO `c_business_type` VALUES ('276', '671200030011', '添加空置房验房记录', '添加空置房验房记录', '2021-08-31 08:52:41');
INSERT INTO `c_business_type` VALUES ('277', '541100030003', '添加问候语', '', '2021-09-24 09:52:32');
INSERT INTO `c_business_type` VALUES ('278', '541100040003', '修改问候语', '', '2021-09-24 09:53:24');
INSERT INTO `c_business_type` VALUES ('279', '541100030004', '添加岗亭', '', '2021-10-19 10:18:03');
INSERT INTO `c_business_type` VALUES ('280', '541100040004', '修改岗亭', '', '2021-10-19 10:18:19');
INSERT INTO `c_business_type` VALUES ('281', '541100050004', '删除岗亭', '', '2021-10-19 10:18:34');
INSERT INTO `c_business_type` VALUES ('282', '551100030004', 'OA派单动作', '', '2021-12-02 17:21:19');
INSERT INTO `c_business_type` VALUES ('283', '561100030004', '退费业务动作', '', '2021-12-31 18:17:38');
INSERT INTO `c_business_type` VALUES ('284', '120100050001', '访客信息删除', '访客信息删除', '2022-02-08 17:47:18');
INSERT INTO `c_business_type` VALUES ('285', '200100080001', '修改商户员工', '', '2022-07-29 11:00:32');
INSERT INTO `c_business_type` VALUES ('286', '541130030001', '添加停车劵', '', '2022-10-15 12:25:12');
INSERT INTO `c_business_type` VALUES ('287', '541130040001', '修改停车劵', '', '2022-10-15 12:25:28');
INSERT INTO `c_business_type` VALUES ('288', '541130050001', '删除停车劵', '', '2022-10-15 12:25:47');
INSERT INTO `c_business_type` VALUES ('289', '551130030001', '添加门禁白名单', '', '2023-01-24 11:48:50');
INSERT INTO `c_business_type` VALUES ('290', '551130040001', '修改门禁白名单', '', '2023-01-24 11:49:29');
INSERT INTO `c_business_type` VALUES ('291', '551130050001', '删除门禁白名单', '', '2023-01-24 11:49:57');
INSERT INTO `c_business_type` VALUES ('292', '651130030001', '添加考勤员工', '', '2023-02-22 02:00:10');
INSERT INTO `c_business_type` VALUES ('293', '651130050001', '删除考勤员工', '', '2023-02-22 02:00:33');

-- ----------------------------
-- Table structure for c_cache
-- ----------------------------
DROP TABLE IF EXISTS `c_cache`;
CREATE TABLE `c_cache` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '缓存ID',
  `cache_code` varchar(10) NOT NULL COMMENT '缓存编码 开始于1001',
  `service_code` varchar(50) NOT NULL COMMENT '调用服务编码 对应 c_service',
  `name` varchar(50) NOT NULL COMMENT '前台显示名称',
  `seq` int NOT NULL COMMENT '列顺序',
  `group` varchar(10) NOT NULL DEFAULT 'COMMON' COMMENT '组，缓存属于哪个组',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，0在用，1失效',
  `url` varchar(500) NOT NULL COMMENT '地址',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cache_code` (`cache_code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_cache
-- ----------------------------
INSERT INTO `c_cache` VALUES ('1', '1001', 'flush.center.cache', '映射缓存（c_mapping表）', '1', 'COMMON', '2018-11-14 13:28:51', '0', 'flush.center.cache?cache=MAPPING');
INSERT INTO `c_cache` VALUES ('2', '1002', 'flush.center.cache', '业务配置缓存（c_app,c_service,c_route表）', '2', 'COMMON', '2018-11-14 13:28:51', '0', 'flush.center.cache?cache=APP_ROUTE_SERVICE');
INSERT INTO `c_cache` VALUES ('3', '1003', 'flush.center.cache', '公用服务缓存（c_service_sql表）', '3', 'COMMON', '2018-11-14 13:28:51', '0', 'flush.center.cache?cache=SERVICE_SQL');
INSERT INTO `c_cache` VALUES ('4', '1004', 'flush.center.cache', '刷新所有缓存（ALL）', '7', 'COMMON', '2019-08-11 05:44:40', '0', 'flush.center.cache?cache=All');
INSERT INTO `c_cache` VALUES ('5', '1005', 'flush.center.cache', '服务业务信息（c_service_business）', '5', 'COMMON', '2019-08-11 06:00:23', '0', 'flush.center.cache?cache=SERVICE_BUSINESS');
INSERT INTO `c_cache` VALUES ('6', '1006', 'flush.center.cache', '基础权限信息（p_privilege）', '6', 'COMMON', '2019-08-11 06:00:23', '0', 'flush.center.cache?cache=PRIVILEGE');
INSERT INTO `c_cache` VALUES ('7', '1007', 'flush.center.cache', 'Databus（business_databus）', '4', 'COMMON', '2019-08-11 06:00:23', '0', 'flush.center.cache?cache=DATABUS');

-- ----------------------------
-- Table structure for c_cache_2_user
-- ----------------------------
DROP TABLE IF EXISTS `c_cache_2_user`;
CREATE TABLE `c_cache_2_user` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '缓存用户ID',
  `cache_code` int NOT NULL COMMENT '缓存编码',
  `user_id` varchar(30) NOT NULL COMMENT '用户id',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，0在用，1失效',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_cache_2_user
-- ----------------------------
INSERT INTO `c_cache_2_user` VALUES ('1', '1001', '10001', '2018-11-14 13:28:51', '0');
INSERT INTO `c_cache_2_user` VALUES ('2', '1002', '10001', '2018-11-14 13:28:51', '0');
INSERT INTO `c_cache_2_user` VALUES ('3', '1003', '10001', '2018-11-14 13:28:51', '0');

-- ----------------------------
-- Table structure for c_mapping
-- ----------------------------
DROP TABLE IF EXISTS `c_mapping`;
CREATE TABLE `c_mapping` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `domain` varchar(50) NOT NULL COMMENT '域',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `key` varchar(100) NOT NULL COMMENT 'key',
  `value` varchar(1000) NOT NULL COMMENT 'value',
  `remark` longtext COMMENT '描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，0在用，1失效',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_mapping
-- ----------------------------
INSERT INTO `c_mapping` VALUES ('1', 'SYSTEM_SWITCH', '日志开关', 'LOG_ON_OFF', 'OFF', '日志开关', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('2', 'SYSTEM_SWITCH', '耗时开关', 'COST_TIME_ON_OFF', 'OFF', '耗时开关', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('3', 'DOMAIN.COMMON', '规则开关', 'RULE_ON_OFF', 'OFF', '规则开关', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('4', 'DOMAIN.COMMON', '不调规则服务的订单类型', 'NO_NEED_RULE_VALDATE_ORDER', 'Q', '不调规则服务的订单类型', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('5', 'DOMAIN.COMMON', '不保存订单信息', 'NO_SAVE_ORDER', 'Q,T', '不保存订单信息', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('6', 'DOMAIN.COMMON', '不用调用 下游系统的配置', 'NO_INVOKE_BUSINESS_SYSTEM', 'Q', '不用调用 下游系统的配置(一般不存在这种情况，这里主要是在没有下游系统的情况下测试中心服务用)', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('7', 'DOMAIN.COMMON', '不用调用 作废下游系统的配置', 'NO_INVALID_BUSINESS_SYSTEM', 'Q', '不用调用 作废下游系统的配置 (一般不存在这种情况，这里主要是在没有下游系统的情况下测试中心服务用)', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('8', 'DOMAIN.COMMON', '需要调用服务生成各个ID', 'NEED_INVOKE_SERVICE_GENERATE_ID', 'OFF', '需要调用服务生成各个ID', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('9', 'DOMAIN.COMMON', '公钥', 'PUBLIC_STRING', 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDloKXSBA5+tP39uS8yi5RZOs6Jdrt0znRQetyXX2l/IUCi1x1QAMgoZbnEavmdZ5jOZN/T1WYFbt/VomXEHaTdStAiYm3DCnxxy5CMMyRKai0+6n4lLJQpUmnAQPFENrOV8b70gBSBVjUXksImgui5qYaNqX90pjEzcyq+6CugBwIDAQAB', '公钥', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('10', 'DOMAIN.COMMON', '私钥', 'PRIVATE_STRING', 'MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJbtQYV+VpWZvifoc0R11MyAfIyMGoJKHDrWQau7oxLHotDDJM80o7ea7oL2onaHWOXaybpUp5FpZgjuixYMhlQOA/VXosrJOGJhgNv0dAL6VVXxmjlg2UWqIEoyTS7IzF3BuQCqy2k9aT7mGiC0RYRpndTuwe/0DKwFx70dIIIrAgMBAAECgYBMNMHnqLIJWZa1Sd6hy6lGFP5ObROZg9gbMUH5d4XQnrKsHEyCvz6HH5ic0fGYTaDqdn1zMvllJ8XYbrIV0P8lvHr9/LCnoXessmf61hKZyTKi5ycNkiPHTjmJZCoVTQFprcNgYeVX4cvNsqB2zWwzoAk8bbdWY6X5jB6YEpfBmQJBANiO9GiBtw+T9h60MpyV1xhJKsx0eCvxRZcsDB1OLZvQ7dHnsHmh0xUBL2MraHKnQyxOlrIzOtyttxSTrQzwcM0CQQCyajkzxpF6EjrXWHYVHb3AXFSoz5krjOkLEHegYlGhx0gtytBNVwftCn6hqtaxCxKMp00ZJoXIxo8d9tQy4N7XAkBljnTT5bEBnzPWpk7t298pRnbJtvz8LoOiJ0fvHlCJN+uvemXqRJeGzC165kpvKj14M8q7+wZpoxWukqqe3MspAkAuFYHw/blV7p+EQDU//w6kQTUc5YKK3TrUwMwlgT/UqcTbDyf+0hwZ/jv3RkluMY35Br3DYU/tLFyLQNZOzgbBAkEApWARXVlleEYbv8dPUL+56S0ky1hZSuPfVOBda4V3p0q18LjcHIyYcVhKGqkpii5JgblaYyjUriNDisFalCp8jQ==', '私钥', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('11', 'DOMAIN.COMMON', '外部应用公钥', 'PUBLIC_STRING', 'MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCW7UGFflaVmb4n6HNEddTMgHyMjBqCShw61kGru6MSx6LQwyTPNKO3mu6C9qJ2h1jl2sm6VKeRaWYI7osWDIZUDgP1V6LKyThiYYDb9HQC+lVV8Zo5YNlFqiBKMk0uyMxdwbkAqstpPWk+5hogtEWEaZ3U7sHv9AysBce9HSCCKwIDAQAB', '外部应用公钥', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('12', 'DOMAIN.COMMON', '外部应用私钥', 'PRIVATE_STRING', 'MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAOWgpdIEDn60/f25LzKLlFk6zol2u3TOdFB63JdfaX8hQKLXHVAAyChlucRq+Z1nmM5k39PVZgVu39WiZcQdpN1K0CJibcMKfHHLkIwzJEpqLT7qfiUslClSacBA8UQ2s5XxvvSAFIFWNReSwiaC6Lmpho2pf3SmMTNzKr7oK6AHAgMBAAECgYEAlfR5FVNM2/X6QC0k408/i53Zru94r2j7kGsLj1bhoAHpIe502AAKtkboL5rkc6Rpp688dCvRug6T4gFxj8cEF7rOOU4CHqVCHUHa4sWSDL2Rg7pMbQOVB7PGmM4C/hEgXcwM6tmLiU3xkkQDrpgT1bPpAm7iwDx4HkZBv1naYnECQQDyk40+KDvyUgp/r1tKbkMLoQOAfTZPXy+HgeAkU3PCUTFQlvn2OU6Fsl3Yjlp6utxPVnd00DoPZ8qvx1falaeLAkEA8lWoIDgyYwnibv2fr3A715PkieJ0exKfLb5lSD9UIfGJ9s7oTcltl7pprykfSP46heWjScS7YJRZHPfqb1/Y9QJAJNUQqjJzv7yDSZX3t5p8ZaSiIn1gpLagQeQPg5SETCoF4eW6uI9FA/nsU/hxdpcu4oEPjFYdqr8owH31MgRtNwJAaE+6qPPHrJ3qnAAMJoZXG/qLG1cg8IEZh6U3D5xC6MGBs31ovWMBC5iwOTeoQdE8+7nXSb+nMHFq0m9cuEg3qQJAH4caPSQ9RjVOP9on+niy9b1mATbvurepIB95KUtaHLz1hpihCLR7dTwrz8JOitgFE75Wzt4a00GZYxnaq3jsjA==', '外部应用私钥', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('13', 'DOMAIN.COMMON', '默认KEY_SIZE', 'DEFAULT_DECRYPT_KEY_SIZE', '2048', '默认KEY_SIZE', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('14', 'DOMAIN.COMMON', '中心服务地址', 'CENTER_SERVICE_URL', 'http://center-service/httpApi/service', '中心服务地址', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('15', 'DOMAIN.COMMON', '控制中心APP_ID', 'CONSOLE_SERVICE_APP_ID', '8000418002', '控制中心APP_ID', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('16', 'DOMAIN.COMMON', '控制服务加密开关', 'KEY_CONSOLE_SERVICE_SECURITY_ON_OFF', 'ON', '控制服务加密开关', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('17', 'DOMAIN.COMMON', '控制服务鉴权秘钥', 'CONSOLE_SECURITY_CODE', 'WEBURFPKIFJUHNCJUEIKMKJUJHULSMNCHDY89KMC', '控制服务鉴权秘钥', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('18', 'DOMAIN.COMMON', '编码生成服务地址', 'CODE_PATH', 'http://code-service/codeApi/generate', '编码生成服务地址', '2018-11-14 13:28:44', '0');
INSERT INTO `c_mapping` VALUES ('19', 'DOMAIN.COMMON', 'API服务地址', 'API_SERVICE_URL', 'http://api-service/api/#serviceCode#', 'API服务地址', '2018-11-18 07:35:03', '0');
INSERT INTO `c_mapping` VALUES ('20', 'DOMAIN.COMMON', '员工默认密码', 'STAFF_DEFAULT_PASSWORD', '123456', '员工默认密码', '2018-12-08 16:33:14', '0');
INSERT INTO `c_mapping` VALUES ('21', 'DOMAIN.COMMON', '用户服务地址', 'ORDER_USER_SERVICE_URL', 'http://user-service/userApi/service', '用户服务地址', '2019-02-08 13:51:33', '0');
INSERT INTO `c_mapping` VALUES ('22', 'DOMAIN.COMMON', '商户服务地址', 'ORDER_STORE_SERVICE_URL', 'http://store-service/storeApi/service', '商户服务地址', '2019-02-08 13:54:53', '0');
INSERT INTO `c_mapping` VALUES ('23', 'DOMAIN.COMMON', '商品服务地址', 'ORDER_SHOP_SERVICE_URL', 'http://shop-service/shopApi/service', '商品服务地址', '2019-02-08 13:57:57', '0');
INSERT INTO `c_mapping` VALUES ('24', 'DOMAIN.COMMON', '评价服务地址', 'ORDER_COMMENT_SERVICE_URL', 'http://comment-service/commentApi/service', '评价服务地址', '2019-02-08 14:00:56', '0');
INSERT INTO `c_mapping` VALUES ('25', 'DOMAIN.COMMON', '小区服务地址', 'ORDER_COMMUNITY_SERVICE_URL', 'http://community-service/communityApi/service', '小区服务地址', '2019-02-08 14:04:28', '0');
INSERT INTO `c_mapping` VALUES ('26', 'DOMAIN.COMMON', '费用服务地址', 'ORDER_FEE_SERVICE_URL', 'http://fee-service/feeApi/service', '费用服务地址', '2019-02-08 14:07:09', '0');
INSERT INTO `c_mapping` VALUES ('27', 'DOMAIN.COMMON', '代理商服务地址', 'ORDER_AGENT_SERVICE_URL', 'http://agent-service/agentApi/service', '代理商服务地址', '2019-02-08 14:10:14', '0');
INSERT INTO `c_mapping` VALUES ('28', 'DEFAULT_PRIVILEGE_ADMIN', '物业对应的管理员权限组', '800900000003', '600201904002', '物业对应的管理员权限组', '2019-04-01 12:24:36', '0');
INSERT INTO `c_mapping` VALUES ('29', 'DEFAULT_PRIVILEGE', '物业对应的员工权限组', '800900000003', '600201904001', '物业对应的员工权限组', '2019-04-02 10:55:53', '0');
INSERT INTO `c_mapping` VALUES ('30', 'STORE_TYPE_2_COMMUNITY_MEMBER_TYPE', '商户类型对应小区成员类型映射', '800900000003', '390001200002', '商户类型对应小区成员类型映射', '2019-04-15 02:49:43', '0');
INSERT INTO `c_mapping` VALUES ('31', 'COMMUNITY_MEMBER_AUDIT', '物业入驻小区需要审核', '390001200002', '1000', '物业入驻小区需要审核', '2019-04-26 16:35:39', '0');
INSERT INTO `c_mapping` VALUES ('32', 'COMMUNITY_MEMBER_AUDIT', '物业入驻商户需要审核', '390001200001', '1000', '物业入驻商户需要审核', '2019-04-26 16:35:49', '0');
INSERT INTO `c_mapping` VALUES ('33', 'STORE_TYPE_2_COMMUNITY_MEMBER_TYPE', '小区和HC小区运营团队关系', '800900000001', '390001200000', '小区和HC小区运营团队关系', '2019-04-15 02:49:43', '0');
INSERT INTO `c_mapping` VALUES ('34', 'DEFAULT_PRIVILEGE_ADMIN', '运营团队对应的管理员权限组', '800900000001', '600201906005', '运营团队对应的管理员权限组', '2019-04-01 12:24:36', '0');
INSERT INTO `c_mapping` VALUES ('35', 'DEFAULT_PRIVILEGE', '运营团队对应的员工权限组', '800900000001', '600201906006', '运营团队对应的员工权限组', '2019-04-02 10:55:53', '0');
INSERT INTO `c_mapping` VALUES ('36', 'STORE_TYPE_2_COMMUNITY_MEMBER_TYPE', '小区和HC小区开发团队关系', '800900000000', '390001200005', '小区和HC小区开发团队关系', '2019-04-15 02:49:43', '0');
INSERT INTO `c_mapping` VALUES ('37', 'DEFAULT_PRIVILEGE_ADMIN', '开发团队对应的管理员权限组', '800900000000', '600201906007', '开发团队对应的管理员权限组', '2019-04-01 12:24:36', '0');
INSERT INTO `c_mapping` VALUES ('38', 'DEFAULT_PRIVILEGE', '开发团队对应的员工权限组', '800900000000', '600201906008', '开发团队对应的员工权限组', '2019-04-02 10:55:53', '0');
INSERT INTO `c_mapping` VALUES ('39', 'STORE_TYPE_2_COMMUNITY_MEMBER_TYPE', '小区和HC小区代理商团队关系', '800900000002', '390001200003', '小区和HC小区运营团队关系', '2019-04-15 02:49:43', '0');
INSERT INTO `c_mapping` VALUES ('40', 'DEFAULT_PRIVILEGE_ADMIN', '运营团队对应的管理员权限组', '800900000002', '600201904003', '运营团队对应的管理员权限组', '2019-04-01 12:24:36', '0');
INSERT INTO `c_mapping` VALUES ('41', 'DEFAULT_PRIVILEGE', '运营团队对应的员工权限组', '800900000002', '600201904004', '运营团队对应的员工权限组', '2019-04-02 10:55:53', '0');
INSERT INTO `c_mapping` VALUES ('42', 'DOMAIN.COMMON', '测试', 'test_wuxw', '1', '测试', '2019-07-08 14:40:37', '1');
INSERT INTO `c_mapping` VALUES ('43', 'DOMAIN.COMMON', 'test_key2', 'test_key2', '12', '12', '2019-07-08 15:06:18', '1');
INSERT INTO `c_mapping` VALUES ('44', 'DOMAIN.COMMON', 'test_key', '1', '1', 'test_key', '2019-07-08 16:40:30', '1');
INSERT INTO `c_mapping` VALUES ('45', 'DOMAIN.COMMON', 'test_key', '1', '1', 'test_key', '2019-07-08 16:53:33', '1');
INSERT INTO `c_mapping` VALUES ('46', 'DOMAIN.COMMON', 'test_key_123', '1234', '1234', '1234', '2019-07-08 17:02:25', '1');
INSERT INTO `c_mapping` VALUES ('47', 'ENV_DOMAIN', '系统版本', 'java110_hc_version', 'v1.7', '系统版本', '2019-08-01 02:33:01', '0');
INSERT INTO `c_mapping` VALUES ('48', 'SMS_DOMAIN', '验证码开关', 'SMS_SEND_SWITCH', 'OFF', '验证码发送开关 ON 开启 OFF 关闭', '2019-09-16 11:56:44', '0');
INSERT INTO `c_mapping` VALUES ('49', 'DOMAIN.COMMON', '户型类别', '10', '一室', '', '2019-10-15 15:54:42', '0');
INSERT INTO `c_mapping` VALUES ('50', 'DOMAIN.COMMON', '户型类别', '20', '两室', '', '2019-10-15 15:54:55', '0');
INSERT INTO `c_mapping` VALUES ('51', 'DOMAIN.COMMON', '户型类别', '30', '三室', '', '2019-10-15 15:56:32', '0');
INSERT INTO `c_mapping` VALUES ('52', 'DOMAIN.COMMON', '户型类别', '40', '四室', '', '2019-10-15 15:56:49', '0');
INSERT INTO `c_mapping` VALUES ('53', 'DOMAIN.COMMON', '户型类别', '50', '五室', '', '2019-10-15 15:57:01', '0');
INSERT INTO `c_mapping` VALUES ('54', 'DOMAIN.COMMON', '户型类别', '60', '六室', '', '2019-10-15 15:57:17', '0');
INSERT INTO `c_mapping` VALUES ('55', 'DOMAIN.COMMON', '户型类别', '70', '七室', '', '2019-10-15 15:57:32', '0');
INSERT INTO `c_mapping` VALUES ('56', 'DOMAIN.COMMON', '户型类别', '80', '八室', '', '2019-10-15 15:57:46', '0');
INSERT INTO `c_mapping` VALUES ('57', 'DOMAIN.COMMON', '户型类别', '101', '一厅', '', '2019-10-15 15:58:41', '0');
INSERT INTO `c_mapping` VALUES ('58', 'DOMAIN.COMMON', '户型类别', '102', '两厅', '', '2019-10-15 15:58:55', '0');
INSERT INTO `c_mapping` VALUES ('59', 'DOMAIN.COMMON', '户型类别', '103', '三厅', '', '2019-10-15 15:59:25', '0');
INSERT INTO `c_mapping` VALUES ('60', 'DOMAIN.COMMON', '户型类别', '104', '四厅', '', '2019-10-15 15:59:39', '0');
INSERT INTO `c_mapping` VALUES ('61', 'DOMAIN.COMMON', '户型类别', '105', '五厅', '', '2019-10-15 15:59:51', '0');
INSERT INTO `c_mapping` VALUES ('62', 'DOMAIN.COMMON', '户型类别', '106', '六厅', '', '2019-10-15 16:00:05', '0');
INSERT INTO `c_mapping` VALUES ('63', 'DOMAIN.COMMON', '户型类别', '107', '七厅', '', '2019-10-15 16:00:16', '0');
INSERT INTO `c_mapping` VALUES ('64', 'DOMAIN.COMMON', '户型类别', '108', '八厅', '', '2019-10-15 16:00:29', '0');
INSERT INTO `c_mapping` VALUES ('65', 'DOMAIN.COMMON', '公共服务地址', 'ORDER_COMMON_SERVICE_URL', 'http://common-service/commonApi/service', '', '2019-10-26 10:16:06', '0');
INSERT INTO `c_mapping` VALUES ('66', 'DOMAIN.COMMON', '硬件服务地址', 'ORDER_HARDWARE_ADAPATION_SERVICE_URL', 'http://hardwareadapation-service/hardwareAdapationApi/service', '', '2019-11-08 23:38:31', '0');
INSERT INTO `c_mapping` VALUES ('67', 'DOMAIN.COMMON', '用户信息同步设备标志', 'SAVE_MACHINE_TRANSLATE_FLAG', 'ON', '', '2019-11-10 11:59:22', '0');
INSERT INTO `c_mapping` VALUES ('73', 'URL_DOMAIN', 'API地址', 'SYS_API_URL', 'http://demo.homecommunity.cn', '', '2020-01-29 00:19:59', '0');
INSERT INTO `c_mapping` VALUES ('74', 'TENCENT_SMS', '模板ID', 'TemplateID', '532465', '', '2020-02-10 17:55:27', '0');
INSERT INTO `c_mapping` VALUES ('75', 'TENCENT_SMS', '短信签名', 'Sign', '吴学文小区技术', '', '2020-02-10 17:57:40', '0');
INSERT INTO `c_mapping` VALUES ('76', 'TENCENT_SMS', '应用ID', 'SmsSdkAppid', '1400312716', '', '2020-02-10 18:00:42', '0');
INSERT INTO `c_mapping` VALUES ('77', 'DOMAIN.COMMON', '用户绑定业主验证码验证开关', 'APP_USER_BINDING_OWNER_SMS', 'ON', '', '2020-02-10 18:01:32', '0');
INSERT INTO `c_mapping` VALUES ('78', 'TENCENT_SMS', 'secretId', 'secretId', 'xx', '', '2020-02-10 18:29:28', '0');
INSERT INTO `c_mapping` VALUES ('79', 'TENCENT_SMS', 'secretKey', 'secretKey', 'xx', '', '2020-02-10 18:30:29', '0');
INSERT INTO `c_mapping` VALUES ('80', 'TENCENT_SMS', '产品区域', 'region', 'ap-chongqing', '', '2020-02-10 18:44:57', '0');
INSERT INTO `c_mapping` VALUES ('81', 'ENV_DOMAIN', '环境标识', 'HC_ENV', 'DEV', 'DEV 演示环境 PROD 生产环境', '2020-02-10 23:15:29', '0');
INSERT INTO `c_mapping` VALUES ('82', 'DOMAIN.COMMON', '定时任务服务地址', 'ORDER_JOB_SERVICE_URL', 'http://job-service/jobApi/service', '定时任务服务地址', '2020-06-02 12:59:28', '0');
INSERT INTO `c_mapping` VALUES ('83', 'WECHAT_PAY', '服务商支付开关', 'WECHAT_SERVICE_PAY_SWITCH', 'OFF', '服务商支付 开关', '2020-06-12 10:31:39', '0');
INSERT INTO `c_mapping` VALUES ('84', 'WECHAT_PAY', '服务商APP_ID', 'SERVICE_APP_ID', '这里填写服务商APP_ID', '', '2020-06-12 10:32:04', '0');
INSERT INTO `c_mapping` VALUES ('85', 'WECHAT_PAY', '服务商商户ID', 'SERVICE_MCH_ID', '这里填写服务商商户ID', '', '2020-06-12 10:32:41', '0');
INSERT INTO `c_mapping` VALUES ('86', 'WECHAT', '和微信对接token', 'TOKEN', 'java110', '', '2020-06-14 12:09:47', '0');
INSERT INTO `c_mapping` VALUES ('87', 'WECHAT', '统一欢迎语', 'WELCOME', 'HC小区物业管理系统欢迎您', 'HC小区物业管理系统是由java110团队于2017年4月份发起的前后端分离、分布式架构开源项目，目前我们的代码开源在github 和gitee上，开源项目由HC小区管理系统后端，HC小区管理系统前端，HC小区管理系统业主手机版和HC小区管理系统物业手机版，业务技术交流群：827669685', '2020-06-14 12:13:11', '0');
INSERT INTO `c_mapping` VALUES ('88', 'ALI_SMS', '区域', 'region', 'cn-hangzhou', '', '2020-06-29 09:08:57', '0');
INSERT INTO `c_mapping` VALUES ('89', 'ALI_SMS', 'accessKeyId', 'accessKeyId', 'xxx', '', '2020-06-29 09:09:26', '0');
INSERT INTO `c_mapping` VALUES ('90', 'ALI_SMS', '访问秘钥', 'accessSecret', 'xxx', '', '2020-06-29 09:09:49', '0');
INSERT INTO `c_mapping` VALUES ('91', 'ALI_SMS', '短信签名', 'signName', 'xxx', '', '2020-06-29 09:10:28', '0');
INSERT INTO `c_mapping` VALUES ('92', 'SMS_DOMAIN', '短信服务商', 'SMS_COMPANY', 'TENCENT', '阿里为 ALI 腾讯为TENCENT', '2020-06-29 09:11:51', '0');
INSERT INTO `c_mapping` VALUES ('93', 'ALI_SMS', '模板编码', 'TemplateCode', 'xxx', '', '2020-06-29 10:16:15', '0');
INSERT INTO `c_mapping` VALUES ('94', 'URL_DOMAIN', '业主公众号地址', 'OWNER_WECHAT_URL', 'http://owner.homecommunity.cn', '公众号时写 公众号域名\n\n小程序时写 小程序appId', '2020-07-20 14:59:38', '0');
INSERT INTO `c_mapping` VALUES ('95', 'WECHAT', '微信支付商品名称', 'PAY_GOOD_NAME', 'HC智慧家园-', '', '2020-08-14 15:54:03', '0');
INSERT INTO `c_mapping` VALUES ('96', 'WECHAT', '欠费推送页面', 'OWE_FEE_PAGE', '/#/pages/fee/oweFee?roomId=', '公众号时 配置 https://owner.demo.winqi.cn/#/pages/oweFee/oweFee?wAppId=wx43458162e3c31d92&roomId=\n\n小程序时 配置\nwxf83d66b0e9f5964d@@/pages/oweFee/oweFee?roomId=', '2020-10-13 17:24:30', '0');
INSERT INTO `c_mapping` VALUES ('97', 'SYSTEM_SWITCH', 'api接口日志开关', 'LOG_SERVICE_CODE', 'OFF', 'ALL 标识记录所有，单个服务接口记录直接写 serviceCode 多个时用 | 分隔', '2020-11-16 00:22:35', '0');
INSERT INTO `c_mapping` VALUES ('98', 'DOMAIN.COMMON', '打折取整方式', 'DISCOUNT_MODE', '1', '1表示向下取整；2表示正常显示；3表示向上取整', '2020-12-10 10:31:12', '0');
INSERT INTO `c_mapping` VALUES ('99', 'DOMAIN.COMMON', '应收款取值', 'TOTAL_FEE_PRICE', '1', '1表示四舍五入后保留小数点后两位；2表示四舍五入后保留小数点后一位；3表示向上取整；4 表示向下取整；5表示 四舍五入后取整 其他情况默认四舍五入后保留小数点后两位。', '2020-12-11 08:36:41', '0');
INSERT INTO `c_mapping` VALUES ('100', 'DOMAIN.COMMON', '身份证开关', 'ID_CARD_SWITCH', '1', '0是关闭身份证查询,1是开启身份证查询', '2020-12-15 12:12:51', '0');
INSERT INTO `c_mapping` VALUES ('101', 'ALI_SMS', '缴费成功通知模板编码', 'PayFeeCode', '缴费成功阿里云短信编码', '缴费成功提示模板编码', '2020-12-18 08:18:44', '1');
INSERT INTO `c_mapping` VALUES ('102', 'DOMAIN.COMMON', '实收款开关', 'RECEIVED_AMOUNT_SWITCH', '1', '是否禁用实收款输入框 2禁用，1开启', '2020-12-19 08:38:49', '0');
INSERT INTO `c_mapping` VALUES ('103', 'IOT', '物联网接口地址', 'IOT_URL', 'http://192.168.1.108:9999', 'http://proxy.homecommunity.cn:9006/\n', '2020-12-24 12:50:15', '0');
INSERT INTO `c_mapping` VALUES ('104', 'IOT', '应用ID', 'APP_ID', '992024012179880001', '', '2020-12-24 12:50:38', '0');
INSERT INTO `c_mapping` VALUES ('105', 'IOT', '应用秘钥', 'APP_SECRET', 'localhost', '', '2020-12-24 12:51:04', '0');
INSERT INTO `c_mapping` VALUES ('106', 'DOMAIN.COMMON', 'DATABUS开关', 'DATABUS_SWITCH', 'ON', 'ON 开启 OFF 关闭', '2020-12-24 13:00:36', '0');
INSERT INTO `c_mapping` VALUES ('107', 'OSS', 'endpoint', 'endpoint', 'http://oss-cn-beijing.aliyuncs.com', '', '2020-12-24 17:04:40', '0');
INSERT INTO `c_mapping` VALUES ('108', 'OSS', 'accessKeyId', 'accessKeyId', 'xx', '', '2020-12-24 17:05:57', '0');
INSERT INTO `c_mapping` VALUES ('109', 'OSS', 'accessKeySecret', 'accessKeySecret', 'xx', '', '2020-12-24 17:08:15', '0');
INSERT INTO `c_mapping` VALUES ('110', 'FILE_DOMAIN', '文件存储开关', 'OSS_SWITCH', 'OSS', 'OSS 配置https://blog.csdn.net/zhuralll112/article/details/89494726?utm_medium=distribute.pc_relevant.none-task-blog-baidujs_title-2&spm=1001.2101.3001.4242', '2020-12-24 17:09:17', '0');
INSERT INTO `c_mapping` VALUES ('111', 'OSS', 'bucket', 'bucketName', 'java110', '', '2021-01-28 10:29:11', '0');
INSERT INTO `c_mapping` VALUES ('112', 'DOMAIN.COMMON', '费用到期提醒黑名单', 'blacklist', '在备注里填写，用英文逗号隔开', '2020121246190011,2020121452010877,2020122491900009,7020181217000001,2020121494070868', '2021-01-23 15:57:04', '0');
INSERT INTO `c_mapping` VALUES ('113', 'DOMAIN.COMMON', '费用提前到期提醒天数', 'feeDueReminderDays', '3', '费用提前到期提醒天数', '2021-01-23 15:59:48', '0');
INSERT INTO `c_mapping` VALUES ('114', 'ALI_SMS', '费用到期提醒短信模板', 'FEE_DUE_REMINDER_CODE', '1123', '费用到期提醒模板编码（若发送费用到期提醒短信请在此处写入编码SMS_210079733）\n\n', '2021-01-27 10:49:05', '1');
INSERT INTO `c_mapping` VALUES ('115', 'WECHAT', '欠费车辆推送页面', 'OWE_CAR_FEE_PAGE', '/#/pages/fee/oweFee?carId=', '公众号时 配置 https://owner.demo.winqi.cn/#/pages/oweFee/oweFee?wAppId=wx43458162e3c31d92&carId=\n\n小程序时 配置\nwxf83d66b0e9f5964d@@/pages/oweFee/oweFee?carId=', '2021-01-30 21:36:59', '0');
INSERT INTO `c_mapping` VALUES ('116', 'DEFAULT_PRIVILEGE_ADMIN', '商家对应的管理员权限组', '800900000005', '600201906009', '商家对应的管理员权限组', '2019-04-01 12:24:36', '0');
INSERT INTO `c_mapping` VALUES ('117', 'FILE_DOMAIN', '静态资源域名', 'IMG_PATH', 'https://java110.oss-cn-beijing.aliyuncs.com/hc/', '静态资源路劲\n\n本地\nhttps://hc.demo.winqi.cn/\"/callComponent/download/getFile/file?communityId=-1&fileId=\"', '2021-03-10 17:22:58', '0');
INSERT INTO `c_mapping` VALUES ('118', 'SYSTEM_SWITCH', '页面水印', 'watermark', 'false', '页面水印 true 系统有水印 false 没有水印', '2021-04-17 01:31:53', '0');
INSERT INTO `c_mapping` VALUES ('119', 'DOMAIN.COMMON', '账户服务URL', 'ORDER_ACCT_SERVICE_URL', 'http://acct-service/acctApi/service', '', '2021-05-05 15:54:34', '0');
INSERT INTO `c_mapping` VALUES ('120', 'STORE.CONTRACT', '甲方', 'partyA', 'partyA', '', '2021-05-18 13:19:34', '0');
INSERT INTO `c_mapping` VALUES ('121', 'STORE.CONTRACT', '乙方', 'partyB', 'partyB', '', '2021-05-18 13:23:03', '0');
INSERT INTO `c_mapping` VALUES ('122', 'STORE.CONTRACT', '合同名称', 'contractName', 'contractName', '', '2021-05-18 13:24:44', '0');
INSERT INTO `c_mapping` VALUES ('123', 'STORE.CONTRACT', '合同编号', 'contractCode', 'contractCode', '', '2021-05-18 13:25:24', '0');
INSERT INTO `c_mapping` VALUES ('124', 'STORE.CONTRACT', '甲方联系电话', 'aLink', 'aLink', '', '2021-05-18 13:26:59', '0');
INSERT INTO `c_mapping` VALUES ('125', 'STORE.CONTRACT', '乙方联系电话', 'bLink', 'bLink', '', '2021-05-18 13:27:28', '0');
INSERT INTO `c_mapping` VALUES ('126', 'STORE.CONTRACT', '甲方联系人', 'aContacts', 'aContacts', '', '2021-05-18 13:29:52', '0');
INSERT INTO `c_mapping` VALUES ('127', 'STORE.CONTRACT', '乙方联系人', 'bContacts', 'bContacts', '', '2021-05-18 13:30:14', '0');
INSERT INTO `c_mapping` VALUES ('128', 'STORE.CONTRACT', '经办人', 'operator', 'operator', '', '2021-05-18 13:30:33', '0');
INSERT INTO `c_mapping` VALUES ('129', 'STORE.CONTRACT', '联系电话', 'operatorLink', 'operatorLink', '', '2021-05-18 13:30:51', '0');
INSERT INTO `c_mapping` VALUES ('130', 'STORE.CONTRACT', '合同金额', 'amount', 'amount', '', '2021-05-18 13:31:09', '0');
INSERT INTO `c_mapping` VALUES ('131', 'STORE.CONTRACT', '开始时间', 'startTime', 'startTime', '', '2021-05-18 13:31:25', '0');
INSERT INTO `c_mapping` VALUES ('132', 'STORE.CONTRACT', '结束时间', 'endTime', 'endTime', '', '2021-05-18 13:31:38', '0');
INSERT INTO `c_mapping` VALUES ('133', 'STORE.CONTRACT', '签订时间', 'signingTime', 'signingTime', '', '2021-05-18 13:31:59', '0');
INSERT INTO `c_mapping` VALUES ('134', 'DOMAIN.COMMON', '水费黑名单', 'WATER_BLACK_LIST', '在备注里填写，用英文逗号隔开', '', '2021-05-07 10:36:30', '0');
INSERT INTO `c_mapping` VALUES ('135', 'DOMAIN.COMMON', '电费黑名单', 'ELECTRIC_BLACK_LIST', '在备注里填写，用英文逗号隔开', '', '2021-05-07 10:38:14', '0');
INSERT INTO `c_mapping` VALUES ('136', 'DOMAIN.COMMON', '嵌套商城的系统地址', 'MALL_IFRAME_URL', '/#/pages/hcWebView/hcWebView', '', '2021-06-25 18:09:22', '0');
INSERT INTO `c_mapping` VALUES ('137', 'URL_DOMAIN', '商城url', 'MALL_URL', 'http://mallapp.homecommunity.cn/', '', '2021-06-25 19:36:05', '0');
INSERT INTO `c_mapping` VALUES ('138', 'DOMAIN.COMMON', '导出最大限制条数', 'EXPORT_NUMBER', '10000', '导出最大限制条数', '2021-06-24 09:10:06', '0');
INSERT INTO `c_mapping` VALUES ('139', 'WECHAT', '绑定业主', 'NO_BIND_OWNER', '1', '亲，您还没有绑定业主请先 <a href=\"https://owner.homecommunity.cn/#/pages/login/login\">绑定</a>', '2020-12-09 18:58:10', '0');
INSERT INTO `c_mapping` VALUES ('140', 'DOMAIN.COMMON', '紧急采购次数', 'URGRNT_NUMBER', '100000', '紧急采购次数', '2021-07-10 11:41:13', '0');
INSERT INTO `c_mapping` VALUES ('141', 'DOMAIN.COMMON', '操作系统区分', 'LINUX_OR_WINDOWS', '2', '1表示windows系统；2表示linux系统', '2021-08-05 14:56:52', '1');
INSERT INTO `c_mapping` VALUES ('142', 'DOMAIN.COMMON', '备份数据库存储位置', 'FILE_LOCATION', '/home/hc/mysqlBackUp/', '备份的数据库文件存储位置', '2021-08-05 11:38:24', '0');
INSERT INTO `c_mapping` VALUES ('143', 'DOMAIN.COMMON', 'hc_community库备份数据库数据库信息', 'HC_COMMUNITY_BACKUP_DATABASE', 'hc_community&hc_community@12345678&hc_community&127.0.0.1', 'hc_community库备份数据库数据库信息: 用户名&密码&数据库名称&数据库IP地址', '2021-08-05 11:15:35', '1');
INSERT INTO `c_mapping` VALUES ('144', 'DOMAIN.COMMON', 'tt库备份数据库数据库信息', 'TT_BACKUP_DATABASE', 'TT&TT@12345678&tt&127.0.0.1', 'tt库备份数据库数据库信息: 用户名&密码&数据库名称&数据库IP地址', '2021-08-05 08:46:39', '1');
INSERT INTO `c_mapping` VALUES ('145', 'DOMAIN.COMMON', '员工公众号地址', 'STAFF_WECHAT_URL', 'http://property.homecommunity.cn/#/', '员工端公众号地址', '2021-08-04 09:29:54', '1');
INSERT INTO `c_mapping` VALUES ('146', 'REPAIR_DOMAIN', '自动评价时间限制(小时)', 'autoEvaluateHour', '48', '48小时', '2021-08-09 14:56:52', '0');
INSERT INTO `c_mapping` VALUES ('147', 'FTP_DOMAIN', 'FTP服务器地址', 'FTP_SERVER', '127.0.0.1', '', '2021-08-27 12:34:37', '0');
INSERT INTO `c_mapping` VALUES ('148', 'FTP_DOMAIN', 'FTP端口', 'FTP_PORT', '21', '', '2021-08-27 12:34:57', '0');
INSERT INTO `c_mapping` VALUES ('149', 'FTP_DOMAIN', 'FTP用户名', 'FTP_USERNAME', 'root', '', '2021-08-27 12:35:16', '0');
INSERT INTO `c_mapping` VALUES ('150', 'FTP_DOMAIN', 'FTP密码', 'FTP_USERPASSWORD', '123456', '', '2021-08-27 12:35:37', '0');
INSERT INTO `c_mapping` VALUES ('151', 'FTP_DOMAIN', 'FTP地址(这个不用修改)', 'FTP_PATH', 'hc/', '', '2021-08-27 12:36:06', '0');
INSERT INTO `c_mapping` VALUES ('152', 'DOMAIN_GOV', '楼栋类型', 'FLOOR_TYPE', '612021083132790001', '政务系统612021083132790001住宅类型', '2021-08-31 09:51:47', '0');
INSERT INTO `c_mapping` VALUES ('153', 'DOMAIN_GOV', '小区密钥', 'COMMUNITY_SECURE', '978984641654', '政务系统小区密钥', '2021-08-31 10:40:53', '1');
INSERT INTO `c_mapping` VALUES ('154', 'DOMAIN_GOV', '推送政务系统开关', 'GOV_SWITCH', 'FALSE', '推送政务系统开关', '2021-09-01 14:12:08', '0');
INSERT INTO `c_mapping` VALUES ('155', 'REPAIR_DOMAIN', '是否让管理员看到所有工单', 'VIEW_LIST_STAFF_REPAIRS', 'OFF', '是否让管理员看到所有工单ON 开 OFF关', '2021-08-26 16:55:07', '0');
INSERT INTO `c_mapping` VALUES ('156', 'DOMAIN.COMMON', '业主及成员验证', 'USER_VALIDATE', 'ON', 'ON表示开启；OFF 表示关闭', '2022-04-25 09:29:35', '0');
INSERT INTO `c_mapping` VALUES ('157', 'REPAIR_DOMAIN', '报修业主未处理费用条数', 'REPAIR_FEE_NUMBER', '2', '报修业主未处理费用条数，请填写数字。', '2021-08-28 15:27:17', '0');
INSERT INTO `c_mapping` VALUES ('158', 'DEFAULT_PRIVILEGE_ADMIN', '跑腿对应的管理员权限组', '800900000006', '600201906009', '', '2021-09-28 18:18:04', '0');
INSERT INTO `c_mapping` VALUES ('159', 'MALL', '政务固定商铺ID', 'SHOP_ID', '502021090678430072', '', '2021-10-09 16:39:50', '0');
INSERT INTO `c_mapping` VALUES ('160', 'MALL', '政务固定商户ID', 'STORE_ID', '402021080419640017', '', '2021-10-09 16:43:38', '0');
INSERT INTO `c_mapping` VALUES ('161', 'MALL', '网格人员默认组织', 'ORG_ID', '842021080423380020', '', '2021-10-09 16:46:42', '0');
INSERT INTO `c_mapping` VALUES ('162', 'REPAIR_DOMAIN', '维修师傅未处理最大单数', 'REPAIR_NUMBER', '10', '', '2021-10-11 11:19:53', '0');
INSERT INTO `c_mapping` VALUES ('163', 'MALL', '配送方式类型', 'FEE_MODE_TYPE', 'M', 'T 为时间，M为金钱', '2021-10-21 15:37:08', '0');
INSERT INTO `c_mapping` VALUES ('164', 'DOMAIN.COMMON', '操作系统区分', 'LINUX_OR_WINDOWS', '2', '1表示windows系统；2表示linux系统', '2021-08-05 14:56:52', '0');
INSERT INTO `c_mapping` VALUES ('165', 'DOMAIN.COMMON', '备份数据库存储位置', 'FILE_LOCATION', '/home/hc/mysqlBackUp/', '备份的数据库文件存储位置', '2021-08-05 11:38:24', '1');
INSERT INTO `c_mapping` VALUES ('166', 'DOMAIN.COMMON', 'hc_community库备份数据库数据库信息', 'HC_COMMUNITY_BACKUP_DATABASE', 'hc_community&hc_community@12345678&hc_community&127.0.0.1', 'hc_community库备份数据库数据库信息: 用户名&密码&数据库名称&数据库IP地址', '2021-08-05 11:15:35', '0');
INSERT INTO `c_mapping` VALUES ('167', 'DOMAIN.COMMON', 'tt库备份数据库数据库信息', 'TT_BACKUP_DATABASE', 'TT&TT@12345678&tt&127.0.0.1', 'tt库备份数据库数据库信息: 用户名&密码&数据库名称&数据库IP地址', '2021-08-05 08:46:39', '0');
INSERT INTO `c_mapping` VALUES ('168', 'URL_DOMAIN', '员工H5地址', 'STAFF_WECHAT_URL', 'http://property.homecommunity.cn/#/', '员工端公众号/H5地址', '2021-08-04 09:29:54', '0');
INSERT INTO `c_mapping` VALUES ('169', 'DOMAIN.COMMON', '自动评价时间限制(小时)', 'autoEvaluateHour', '48', '48小时', '2021-08-09 14:56:52', '1');
INSERT INTO `c_mapping` VALUES ('170', 'WECHAT', '普通缴费下单回调地址', 'wxNotifyUrl', '/app/payment/notify', '', '2021-12-24 00:59:51', '0');
INSERT INTO `c_mapping` VALUES ('171', 'WECHAT', '房屋租金回调', 'rentingNotifyUrl', '/app/payment/rentingNotify', '', '2021-12-24 01:01:11', '0');
INSERT INTO `c_mapping` VALUES ('172', 'WECHAT', '商品购买回调地址', 'goodsNotifyUrl', '/app/goods/notify', '', '2021-12-24 01:01:35', '0');
INSERT INTO `c_mapping` VALUES ('173', 'WECHAT', '欠费缴费通知地址', 'oweFeeNotifyUrl', '/app/payment/oweFeeNotify', '', '2021-12-24 01:01:52', '0');
INSERT INTO `c_mapping` VALUES ('174', 'WECHAT', '临时车缴费回调', 'tempCarFeeNotifyUrl', '/app/payment/tempCarFeeNotifyUrl', '', '2021-12-24 01:02:08', '0');
INSERT INTO `c_mapping` VALUES ('175', 'WECHAT', '金币支付回调地址', 'goldNotifyUrl', '/app/paymentGold/goldNotify', '', '2021-12-27 12:04:03', '0');
INSERT INTO `c_mapping` VALUES ('176', 'WECHAT', '家政支付回调地址', 'servFeeNotifyUrl', '/app/payment/servFeeNotify', '', '2021-12-27 12:04:23', '0');
INSERT INTO `c_mapping` VALUES ('177', 'WECHAT', '保证金支付回调路径', 'bondFeeNotifyUrl', '/app/payment/bondFeeNotify', '', '2021-12-27 12:04:40', '0');
INSERT INTO `c_mapping` VALUES ('178', 'WECHAT', '全局小程序AppId', 'appId', 'xx', 'WECHAT', '2022-01-06 10:50:28', '0');
INSERT INTO `c_mapping` VALUES ('179', 'WECHAT', '全局小程序appSecret', 'appSecret', 'xx', 'appSecret', '2022-01-06 10:50:57', '0');
INSERT INTO `c_mapping` VALUES ('180', 'WECHAT_STORE', '微信商户支付秘钥（v2）', 'key', 'xx', 'key', '2022-01-06 10:51:25', '0');
INSERT INTO `c_mapping` VALUES ('181', 'WECHAT_STORE', '微信商户ID', 'mchId', 'xx', 'WECHAT', '2022-01-06 10:51:49', '0');
INSERT INTO `c_mapping` VALUES ('182', 'MALL_WECHAT', '公众号AppId', 'wechatAppId', 'xx', 'wechatAppId', '2022-01-06 10:55:00', '0');
INSERT INTO `c_mapping` VALUES ('183', 'MALL_WECHAT', '公众号AppSecret', 'wechatAppSecret', 'xx', 'wechatAppSecret', '2022-01-06 10:55:24', '0');
INSERT INTO `c_mapping` VALUES ('184', 'COS', 'endpoint', 'endpoint', '', 'COS的入口,COS 地域的简称请参照 https://cloud.tencent.com/document/product/436/6224', '2022-03-23 09:37:56', '0');
INSERT INTO `c_mapping` VALUES ('185', 'COS', 'accessKeyId', 'accessKeyId', '', 'SECRETID和SECRETKEY请登录访问管理控制台 https://console.cloud.tencent.com/cam/capi 进行查看和管理', '2022-03-23 09:37:57', '0');
INSERT INTO `c_mapping` VALUES ('186', 'COS', 'accessKeySecret', 'accessKeySecret', '', 'SECRETID和SECRETKEY请登录访问管理控制台 https://console.cloud.tencent.com/cam/capi 进行查看和管理', '2022-03-23 09:37:57', '0');
INSERT INTO `c_mapping` VALUES ('187', 'COS', 'bucket', 'bucketName', '存储桶名称，格式：BucketName-APPID', '存储桶名称，格式：BucketName-APPID', '2022-03-23 09:37:57', '0');
INSERT INTO `c_mapping` VALUES ('188', 'COS', 'region', 'regionName', '所属地域:广州 （中国）（ap-guangzhou）', '所属地域:广州 （中国）（ap-guangzhou）', '2022-03-23 09:37:57', '0');
INSERT INTO `c_mapping` VALUES ('189', 'WECHAT', '运营mchId', 'adminMchId', '1562146141', 'adminMchId', '2022-05-23 14:07:24', '1');
INSERT INTO `c_mapping` VALUES ('190', 'WECHAT', '运营key', 'adminKey', 'adminKey', '', '2022-05-23 14:08:14', '1');
INSERT INTO `c_mapping` VALUES ('191', 'WECHAT_PAY', '服务商商户名称', 'SERVICE_MCH_NAME', '这里填写服务商名称', '', '2022-06-18 23:58:00', '0');
INSERT INTO `c_mapping` VALUES ('192', 'WECHAT_STORE', '微信商户名称', 'mchName', '商户名称', '', '2022-06-18 23:59:21', '0');
INSERT INTO `c_mapping` VALUES ('193', 'DOMAIN.COMMON', '业主抵扣金', 'OWNER_DEDUCTION', 'ACCT', 'ACCT 表示 进账户\nCOUPON 表示转换为优惠券', '2022-07-18 11:11:38', '0');
INSERT INTO `c_mapping` VALUES ('194', 'SYSTEM_SWITCH', '调用外部系统记录日志', 'CALL_OUT_LOG', 'ON', 'ON 调用外系统记录日志 OFF不记录日志\n日志表为 transaction_out_log', '2022-10-24 00:26:08', '0');
INSERT INTO `c_mapping` VALUES ('195', 'SYSTEM_SWITCH', '商家停车劵赠送动态二维码开关', 'CHECK_PARKING_COUPON_QRCODE_CODE', 'ON', '主要 有些物业感觉 领劵二维码 动态不方便，但是我们考虑静态有安全风险 所以加入开关ON 表示 二维码动态 OFF 二维码静态', '2022-11-23 01:24:10', '0');
INSERT INTO `c_mapping` VALUES ('196', 'MALL', '商城是否按小区查询', 'QUERY_BY_COMMUNITY', 'OFF', 'ON 表示按小区查询 OFF 表示 全系统查询 ', '2022-12-02 10:16:25', '0');
INSERT INTO `c_mapping` VALUES ('197', 'DOMAIN.COMMON', 'payFeeDetailToMonth', 'payFeeDetailToMonth', 'bailefu', '', '2023-01-07 21:59:36', '1');
INSERT INTO `c_mapping` VALUES ('198', 'SYSTEM_SWITCH', '添加业主自动生成登录账号', 'AUTO_GENERATOR_OWNER_USER', 'ON', '登录账号密码都是手机号 ON 生成登录账号 OFF 不生成登录账号', '2023-01-25 23:47:40', '0');
INSERT INTO `c_mapping` VALUES ('199', 'YIDONG_SMS', '集团客户名称', 'ecName', 'xx', '', '2023-02-03 11:52:40', '0');
INSERT INTO `c_mapping` VALUES ('200', 'YIDONG_SMS', '用户名', 'apId', 'xx', '', '2023-02-03 11:52:58', '0');
INSERT INTO `c_mapping` VALUES ('201', 'YIDONG_SMS', '密码', 'secretKey', 'xx', '', '2023-02-03 11:53:16', '0');
INSERT INTO `c_mapping` VALUES ('202', 'YIDONG_SMS', '网关签名编码', 'sign', 'xx', 'xx', '2023-02-03 11:53:47', '0');
INSERT INTO `c_mapping` VALUES ('203', 'YIDONG_SMS', '扩展码', 'addSerial', 'xx', '', '2023-02-03 11:54:06', '0');
INSERT INTO `c_mapping` VALUES ('204', 'YIDONG_SMS', '模版ID', 'templateId', 'xx', '', '2023-02-03 11:54:34', '0');
INSERT INTO `c_mapping` VALUES ('205', 'YIDONG_SMS', '移动短信地址', 'yidong_url', 'http://112.35.10.201:1999/smsservice', '这个一般不用动 除非 移动换地址了', '2023-02-03 11:59:32', '0');
INSERT INTO `c_mapping` VALUES ('206', 'FEIE_DOMAIN', '用户名', 'user', 'xx', '', '2023-02-18 18:46:54', '0');
INSERT INTO `c_mapping` VALUES ('207', 'FEIE_DOMAIN', 'ukey', 'ukey', 'xx', '', '2023-02-18 18:47:14', '0');
INSERT INTO `c_mapping` VALUES ('208', 'DING_DING_CHARGE', '应用ID', 'APP_ID', 'ss', '', '2023-03-17 12:17:38', '0');
INSERT INTO `c_mapping` VALUES ('209', 'DING_DING_CHARGE', '应用秘钥', 'APP_SECURE', 'ss', '', '2023-03-17 12:18:06', '0');
INSERT INTO `c_mapping` VALUES ('210', 'WECHAT_STORE', '退款证书地址', 'cert', '1', '这里改成文件系统存放地址 /hc/xx/xx.p12', '2023-03-29 13:32:24', '0');
INSERT INTO `c_mapping` VALUES ('211', 'SYSTEM_SWITCH', '单点登录开关', 'SSO_SWITCH', 'ON', '单点登录开关 ON 开启 OFF 关闭', '2023-04-25 23:30:08', '0');
INSERT INTO `c_mapping` VALUES ('212', 'WECHAT_STORE', '商家支付到平台', 'PAY_PLATFORM', 'ON', '支付到平台，商家配置支付信息没有用', '2023-04-28 00:28:48', '0');
INSERT INTO `c_mapping` VALUES ('213', 'WECHAT', '办公系统流程审批通知', '33006', '43258', '', '2023-08-04 15:38:57', '0');
INSERT INTO `c_mapping` VALUES ('214', 'WECHAT', '缴费账单生成提醒', '33002', '43167', '', '2023-08-04 16:06:38', '0');
INSERT INTO `c_mapping` VALUES ('215', 'WECHAT', '缴费成功通知', '33004', '43535', '', '2023-08-04 16:50:27', '0');
INSERT INTO `c_mapping` VALUES ('216', 'WECHAT', '新报修单提醒', '33008', '44774', '', '2023-08-06 23:05:08', '0');
INSERT INTO `c_mapping` VALUES ('217', 'WECHAT', '维修工单派单通知', '33009', '50162', '', '2023-08-06 23:30:12', '0');
INSERT INTO `c_mapping` VALUES ('218', 'WECHAT', '报障受理通知', '33010', '43170', '', '2023-08-06 23:53:25', '0');
INSERT INTO `c_mapping` VALUES ('219', 'WECHAT', '报修完成通知', '33011', '43375', '', '2023-08-07 00:14:06', '0');
INSERT INTO `c_mapping` VALUES ('220', 'WECHAT', '办公系统流程审批通知', '33017', '43258', '', '2023-08-07 01:08:52', '0');
INSERT INTO `c_mapping` VALUES ('221', 'WECHAT', '办公系统流程审批通知', '33018', '43258', '', '2023-08-07 01:24:13', '0');
INSERT INTO `c_mapping` VALUES ('222', 'ENV_DOMAIN', '消息推送方式', 'DEFAULT_MSG_NOTIFY_WAY', 'WECHAT', '消息通知 目前支持 微信（WECHAT）和 阿里云短信(ALI)', '2023-08-26 11:02:21', '0');
INSERT INTO `c_mapping` VALUES ('223', 'IOT', '物联网用户名', 'IOT_USERNAME', 'admin', '', '2024-01-21 15:51:56', '0');
INSERT INTO `c_mapping` VALUES ('224', 'IOT', '物联网密码', 'IOT_PASSWORD', 'admin', '', '2024-01-21 15:52:18', '0');
INSERT INTO `c_mapping` VALUES ('225', 'URL_DOMAIN', '物联网地址', 'IOT_URL', 'http://iot.homecommunity.cn', '', '2024-01-25 20:42:14', '0');
INSERT INTO `c_mapping` VALUES ('226', 'IOT', '物联网开关', 'IOT_SWITCH', 'ON', '物联网开关 ON 打开 OFF 关闭', '2024-01-25 21:26:22', '0');

-- ----------------------------
-- Table structure for c_mapping_domain
-- ----------------------------
DROP TABLE IF EXISTS `c_mapping_domain`;
CREATE TABLE `c_mapping_domain` (
  `id` varchar(30) NOT NULL COMMENT 'id',
  `domain` varchar(50) NOT NULL COMMENT '域',
  `domain_name` varchar(64) NOT NULL COMMENT '配置项',
  `seq` int NOT NULL COMMENT '排序',
  `remark` longtext COMMENT '描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，0在用，1失效',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_mapping_domain
-- ----------------------------
INSERT INTO `c_mapping_domain` VALUES ('102023012925250008', 'SYSTEM_SWITCH', '系统开关', '3', '系统相关开关，比如日志开关，耗时开关等', '2023-01-29 16:03:33', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023012984550002', 'OSS', '阿里云OSS', '11', '主要用于系统图片等存储使用，请您购买阿里云OSS，获取一下参数配置，请注意前后空格，并且阿里云OSS账户授权oss存储权限', '2023-01-29 15:11:36', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023012997730005', 'DOMAIN.COMMON', '通用配置', '21', '通用配置，一般不推荐配置此下面，其他开发人员不知道怎么配置', '2023-01-29 16:00:00', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013002730013', 'REPAIR_DOMAIN', '工单配置', '16', '用于工单配置，一般不用改动，除非是专业维护人员或者开发人员', '2023-01-30 14:38:57', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013008810003', 'WECHAT_STORE', '微信商户', '14', '微信支付商户配置，是全局配置，比如物业系统或者商城系统中的钱全部要支付到平台上时，才需要配置，否则不用配置，到小区或者店铺配置', '2023-01-30 13:24:39', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013018460044', 'FILE_DOMAIN', '存储配置', '9', '系统存储配置，IMG_PATH 配置，如果是ftp 时 则配置Nginx代理ftp 静态文件访问地址，如果是阿里云OSS 配置 ，配置阿里云OSS图片访问地址，可以登录OSS在后台查看，OSS_SWITCH 为文件存储方式 FTP 为FTP存储（需要自己搭建ftp服务器） OSS 为阿里云OSS存储 需要阿里云购买OSS', '2023-01-30 00:55:56', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013026820018', 'ENV_DOMAIN', '环境配置', '1', '环境相关配置，如演示环境 生产环境 切换', '2023-01-30 14:46:43', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013029370059', 'WECHAT_PAY', '微信服务商', '13', '微信服务商配置时，给个小区公众号或者小程序配置时的商户支付秘钥为服务商秘钥，不是商户的支付秘钥', '2023-01-30 02:14:53', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013033010027', 'ALI_SMS', '阿里短信配置', '6', '腾讯短信配置 开启验证码功能，搜索键为SMS_SEND_SWITCH的记录将值OFF改为ON 键为 SMS_COMPANY 的值 阿里为ALI', '2023-01-30 00:14:24', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013034940056', 'URL_DOMAIN', '平台地址', '12', '物业手机端，业主端，商城手机端等地址配置', '2023-01-30 01:33:57', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013042670041', 'IOT', '物联网配置', '8', '用于和HC小区物联网系统配置，这里是配置HC物业系统调用HC物联网系统信息，只需要关注物联网平台地址（IOT_URL），和物联网平台调用HC小区管理系统配置，需要修改物联网库中c_app_attr 中value中 所有地址修改为物业系统地址 比如修改为 http://192.168.1.16:8008', '2023-01-30 00:53:53', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013044910053', 'FTP_DOMAIN', 'FTP', '10', 'FTP相关配置', '2023-01-30 01:06:20', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013062160008', 'MALL_WECHAT', '商城公众号', '15', '商城公众号配置，商城系统只有一个公众号配置，各个店铺只需要配置微信商户支付信息即可', '2023-01-30 13:45:25', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013081180032', 'SMS_DOMAIN', '短信配置', '4', '主要设置采用阿里云短信或者腾讯云服务商，阿里为 ALI 腾讯为TENCENT', '2023-01-30 00:20:29', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023013087180022', 'TENCENT_SMS', '腾讯短信配置', '5', '腾讯短信配置\n开启验证码功能，搜索键为SMS_SEND_SWITCH的记录将值OFF改为ON\n键为 SMS_COMPANY 的值 腾讯为TENCENT', '2023-01-30 00:12:54', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023020300601955', 'YIDONG_SMS', '移动短信配置', '7', '移动短信发送配置\nhttp://mas.10086.cn/login\n协议地址：http://112.35.10.201:1999/smsservice?wsdl', '2023-02-03 11:50:18', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023021806400028', 'FEIE_DOMAIN', '飞蛾小票机', '19', '飞蛾小票机配置，user 和 ukey 找飞蛾厂家获取，厂家官网购买 http://www.feieyun.com/index.html', '2023-02-18 18:46:22', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023031780750014', 'DING_DING_CHARGE', '钉钉充电桩', '20', '钉钉充电桩厂家充电桩', '2023-03-17 12:16:59', '0');
INSERT INTO `c_mapping_domain` VALUES ('102023080415020024', 'WECHAT', '微信常规配置', '22', '微信常规配置', '2023-08-04 15:38:11', '0');

-- ----------------------------
-- Table structure for c_order_item
-- ----------------------------
DROP TABLE IF EXISTS `c_order_item`;
CREATE TABLE `c_order_item` (
  `b_id` varchar(30) NOT NULL COMMENT '业务Id',
  `o_id` varchar(30) NOT NULL COMMENT '订单ID',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `action` varchar(12) DEFAULT NULL COMMENT '动作表，ADD 添加记录 MOD 修改记录 DEL删除记录',
  `action_obj` varchar(64) NOT NULL COMMENT '动作对象，一般为表名',
  `finish_time` datetime DEFAULT NULL COMMENT '完成时间',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `status_cd` varchar(2) NOT NULL COMMENT '数据状态，详细参考c_status表',
  UNIQUE KEY `b_id` (`b_id`) USING BTREE,
  KEY `i_oi_o_id` (`o_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_order_item
-- ----------------------------
INSERT INTO `c_order_item` VALUES ('202024032220990035', '102024032250750032', '2024-03-22 23:01:53', 'MOD', 'pay_fee_detail', '2024-03-22 23:01:53', null, 'C');
INSERT INTO `c_order_item` VALUES ('202024032231180024', '102024032227410020', '2024-03-22 23:01:37', 'MOD', 'pay_fee', '2024-03-22 23:01:37', null, 'C');
INSERT INTO `c_order_item` VALUES ('202024032251500034', '102024032250750032', '2024-03-22 23:01:53', 'ADD', 'return_pay_fee', '2024-03-22 23:01:53', null, 'C');
INSERT INTO `c_order_item` VALUES ('202024032252030021', '102024032227410020', '2024-03-22 23:01:36', 'MOD', 'community_setting', '2024-03-22 23:01:37', null, 'C');
INSERT INTO `c_order_item` VALUES ('202024032255150023', '102024032227410020', '2024-03-22 23:01:37', 'ADD', 'pay_fee_detail', '2024-03-22 23:01:37', null, 'C');

-- ----------------------------
-- Table structure for c_order_type
-- ----------------------------
DROP TABLE IF EXISTS `c_order_type`;
CREATE TABLE `c_order_type` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `order_type_cd` varchar(4) NOT NULL COMMENT '订单类型',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `description` varchar(200) DEFAULT NULL COMMENT '描述',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_type_cd` (`order_type_cd`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_order_type
-- ----------------------------
INSERT INTO `c_order_type` VALUES ('1', 'Q', '查询单', '查询单', '2018-11-14 13:28:44');
INSERT INTO `c_order_type` VALUES ('2', 'D', '受理单', '受理单', '2018-11-14 13:28:44');

-- ----------------------------
-- Table structure for c_orders
-- ----------------------------
DROP TABLE IF EXISTS `c_orders`;
CREATE TABLE `c_orders` (
  `o_id` varchar(30) NOT NULL COMMENT '订单ID',
  `app_id` varchar(30) NOT NULL COMMENT '应用ID',
  `ext_transaction_id` varchar(36) DEFAULT NULL,
  `user_id` varchar(30) NOT NULL COMMENT '用户ID',
  `request_time` varchar(16) NOT NULL COMMENT '外部系统请求时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `order_type_cd` varchar(4) NOT NULL COMMENT '订单类型，参考c_order_type表',
  `finish_time` date DEFAULT NULL COMMENT '订单完成时间',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `status_cd` varchar(2) NOT NULL COMMENT '数据状态，详细参考c_status表',
  UNIQUE KEY `o_id` (`o_id`) USING BTREE,
  UNIQUE KEY `o_id_2` (`o_id`) USING BTREE,
  KEY `i_co_app_id` (`app_id`),
  KEY `i_co_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_orders
-- ----------------------------
INSERT INTO `c_orders` VALUES ('102024032227410020', '8000418004', '50291272-06e9-4d2c-9796-8ec5d5899b41', '30202305221014327189000174', '20240322230135', '2024-03-22 23:01:36', 'D', '2024-03-22', null, 'C');
INSERT INTO `c_orders` VALUES ('102024032250750032', '8000418004', 'dcead2e3-9d4d-43f2-8dee-cffc50f1cd3c', '30202305221014327189000174', '20240322230152', '2024-03-22 23:01:53', 'D', '2024-03-22', null, 'C');

-- ----------------------------
-- Table structure for c_orders_attrs
-- ----------------------------
DROP TABLE IF EXISTS `c_orders_attrs`;
CREATE TABLE `c_orders_attrs` (
  `o_id` varchar(30) NOT NULL COMMENT '订单ID',
  `attr_id` varchar(30) NOT NULL COMMENT '属性id',
  `spec_cd` varchar(12) NOT NULL COMMENT '规格id,参考spec表',
  `value` varchar(50) NOT NULL COMMENT '属性值'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_orders_attrs
-- ----------------------------

-- ----------------------------
-- Table structure for c_route
-- ----------------------------
DROP TABLE IF EXISTS `c_route`;
CREATE TABLE `c_route` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `app_id` varchar(30) NOT NULL COMMENT '应用ID',
  `service_id` varchar(30) NOT NULL COMMENT '服务ID',
  `order_type_cd` varchar(4) NOT NULL COMMENT '订单类型，参考c_order_type表',
  `invoke_limit_times` int DEFAULT NULL COMMENT '接口调用一分钟调用次数',
  `invoke_model` varchar(1) NOT NULL COMMENT '1-同步方式 2-异步方式',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status_cd` varchar(2) NOT NULL DEFAULT '0' COMMENT '数据状态，详细参考c_status表，0在用，1失效，2 表示下线（当组件调用服务超过限制时自动下线）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2814 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of c_route
-- ----------------------------
INSERT INTO `c_route` VALUES ('1', '8000418001', '1', 'Q', '1001', 'S', '2018-11-14 13:28:44', '1');
INSERT INTO `c_route` VALUES ('2', '8000418001', '3', 'Q', null, 'S', '2018-11-14 13:28:44', '1');
INSERT INTO `c_route` VALUES ('3', '8000418002', '3', 'Q', null, 'S', '2018-11-14 13:28:44', '1');
INSERT INTO `c_route` VALUES ('4', '8000418002', '4', 'Q', null, 'S', '2018-11-14 13:28:44', '1');
INSERT INTO `c_route` VALUES ('5', '8000418002', '5', 'Q', null, 'S', '2018-11-14 13:28:44', '1');
INSERT INTO `c_route` VALUES ('6', '8000418002', '6', 'Q', null, 'S', '2018-11-14 13:28:44', '0');
INSERT INTO `c_route` VALUES ('7', '8000418002', '7', 'Q', null, 'S', '2018-11-14 13:28:44', '0');
INSERT INTO `c_route` VALUES ('8', '8000418002', '8', 'Q', null, 'S', '2018-11-14 13:28:44', '0');
INSERT INTO `c_route` VALUES ('9', '8000418002', '9', 'Q', null, 'S', '2018-11-14 13:28:44', '0');
INSERT INTO `c_route` VALUES ('10', '8000418002', '10', 'Q', null, 'S', '2018-11-14 13:28:44', '0');
INSERT INTO `c_route` VALUES ('11', '8000418002', '11', 'Q', null, 'S', '2018-11-14 13:28:44', '0');
INSERT INTO `c_route` VALUES ('12', '8000418002', '12', 'Q', null, 'S', '2018-11-14 13:28:44', '0');
INSERT INTO `c_route` VALUES ('13', '8000418002', '13', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('14', '8000418002', '14', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('15', '8000418002', '15', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('16', '8000418002', '16', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('17', '8000418002', '17', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('18', '8000418001', '21', 'Q', null, 'S', '2018-11-14 13:28:45', '1');
INSERT INTO `c_route` VALUES ('19', '8000418001', '22', 'Q', null, 'S', '2018-11-14 13:28:45', '1');
INSERT INTO `c_route` VALUES ('20', '8000418001', '23', 'Q', null, 'S', '2018-11-14 13:28:45', '1');
INSERT INTO `c_route` VALUES ('21', '8000418001', '24', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('22', '8000418001', '25', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('23', '8000418001', '26', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('24', '8000418001', '27', 'Q', null, 'S', '2018-11-14 13:28:45', '0');
INSERT INTO `c_route` VALUES ('25', '8000418001', '33', 'Q', null, 'S', '2018-11-15 13:46:45', '0');
INSERT INTO `c_route` VALUES ('26', '8000418001', '34', 'Q', null, 'S', '2018-11-16 15:31:35', '0');
INSERT INTO `c_route` VALUES ('27', '8000418002', '36', 'Q', null, 'S', '2018-11-24 17:01:47', '1');
INSERT INTO `c_route` VALUES ('28', '8000418002', '37', 'Q', null, 'S', '2018-11-24 17:23:47', '1');
INSERT INTO `c_route` VALUES ('29', '8000418002', '38', 'Q', null, 'S', '2018-11-27 16:22:58', '1');
INSERT INTO `c_route` VALUES ('30', '8000418002', '39', 'Q', null, 'S', '2018-11-27 16:22:58', '1');
INSERT INTO `c_route` VALUES ('31', '8000418002', '40', 'D', null, 'S', '2018-12-08 16:15:22', '0');
INSERT INTO `c_route` VALUES ('32', '8000418002', '41', 'D', null, 'S', '2018-12-08 16:15:42', '0');
INSERT INTO `c_route` VALUES ('33', '8000418002', '42', 'D', null, 'S', '2018-12-08 16:15:50', '0');
INSERT INTO `c_route` VALUES ('34', '8000418002', '43', 'D', null, 'S', '2018-12-08 16:15:57', '0');
INSERT INTO `c_route` VALUES ('35', '8000418002', '44', 'D', null, 'S', '2018-12-08 16:16:04', '0');
INSERT INTO `c_route` VALUES ('36', '8000418002', '45', 'D', null, 'S', '2018-12-08 16:16:09', '0');
INSERT INTO `c_route` VALUES ('37', '8000418002', '46', 'Q', null, 'S', '2018-12-09 07:36:00', '0');
INSERT INTO `c_route` VALUES ('38', '8000418002', '47', 'Q', null, 'S', '2018-12-12 10:23:04', '0');
INSERT INTO `c_route` VALUES ('39', '8000418002', '48', 'Q', null, 'S', '2018-12-12 14:24:12', '0');
INSERT INTO `c_route` VALUES ('40', '8000418002', '49', 'Q', null, 'S', '2018-12-12 14:56:54', '0');
INSERT INTO `c_route` VALUES ('41', '8000418002', '50', 'D', null, 'S', '2018-12-17 15:29:11', '0');
INSERT INTO `c_route` VALUES ('42', '8000418002', '51', 'D', null, 'S', '2018-12-17 15:29:11', '0');
INSERT INTO `c_route` VALUES ('43', '8000418002', '52', 'D', null, 'S', '2018-12-17 15:29:11', '0');
INSERT INTO `c_route` VALUES ('44', '8000418002', '53', 'D', null, 'S', '2018-12-17 15:29:11', '0');
INSERT INTO `c_route` VALUES ('45', '8000418002', '54', 'Q', null, 'S', '2018-12-17 15:29:11', '0');
INSERT INTO `c_route` VALUES ('46', '8000418002', '55', 'Q', null, 'S', '2019-02-17 14:24:15', '0');
INSERT INTO `c_route` VALUES ('47', '8000418004', '38', 'Q', null, 'S', '2019-03-20 06:24:10', '0');
INSERT INTO `c_route` VALUES ('48', '8000418004', '37', 'Q', null, 'S', '2019-03-20 09:00:29', '0');
INSERT INTO `c_route` VALUES ('49', '8000418004', '4', 'Q', null, 'S', '2019-03-20 09:02:19', '0');
INSERT INTO `c_route` VALUES ('50', '8000418004', '36', 'Q', null, 'S', '2019-03-25 08:21:53', '0');
INSERT INTO `c_route` VALUES ('51', '8000418004', '56', 'Q', null, 'S', '2019-02-17 14:24:15', '0');
INSERT INTO `c_route` VALUES ('52', '8000418004', '57', 'Q', null, 'S', '2019-03-27 13:28:00', '0');
INSERT INTO `c_route` VALUES ('53', '8000418004', '58', 'Q', null, 'S', '2019-03-28 03:24:20', '0');
INSERT INTO `c_route` VALUES ('54', '8000418004', '18', 'D', null, 'S', '2019-03-29 13:46:24', '0');
INSERT INTO `c_route` VALUES ('55', '8000418004', '59', 'Q', null, 'S', '2019-04-01 03:07:03', '0');
INSERT INTO `c_route` VALUES ('56', '8000418004', '3', 'Q', null, 'S', '2019-04-01 03:33:22', '0');
INSERT INTO `c_route` VALUES ('57', '8000418004', '39', 'Q', null, 'S', '2019-04-01 11:17:12', '0');
INSERT INTO `c_route` VALUES ('58', '8000418004', '1', 'Q', null, 'S', '2019-04-01 11:47:02', '0');
INSERT INTO `c_route` VALUES ('59', '8000418004', '60', 'D', null, 'S', '2019-04-01 16:19:18', '0');
INSERT INTO `c_route` VALUES ('60', '8000418004', '40', 'D', null, 'S', '2019-04-02 11:31:01', '0');
INSERT INTO `c_route` VALUES ('61', '8000418004', '61', 'Q', null, 'S', '2019-04-02 12:03:33', '0');
INSERT INTO `c_route` VALUES ('62', '8000418004', '46', 'Q', null, 'S', '2019-04-03 01:27:28', '0');
INSERT INTO `c_route` VALUES ('63', '8000418004', '62', 'D', null, 'S', '2019-04-03 07:42:46', '0');
INSERT INTO `c_route` VALUES ('64', '8000418004', '63', 'D', null, 'S', '2019-04-04 03:55:20', '0');
INSERT INTO `c_route` VALUES ('65', '8000418004', '64', 'D', null, 'S', '2019-04-04 08:24:57', '0');
INSERT INTO `c_route` VALUES ('66', '8000418004', '65', 'Q', null, 'S', '2019-04-05 15:55:43', '0');
INSERT INTO `c_route` VALUES ('67', '8000418004', '66', 'Q', null, 'S', '2019-04-07 10:33:37', '0');
INSERT INTO `c_route` VALUES ('68', '8000418004', '67', 'Q', null, 'S', '2019-04-08 07:54:56', '0');
INSERT INTO `c_route` VALUES ('69', '8000418004', '68', 'Q', null, 'S', '2019-04-08 10:01:12', '0');
INSERT INTO `c_route` VALUES ('70', '8000418004', '69', 'Q', null, 'S', '2019-04-08 14:26:08', '0');
INSERT INTO `c_route` VALUES ('71', '8000418004', '70', 'Q', null, 'S', '2019-04-08 16:00:27', '0');
INSERT INTO `c_route` VALUES ('72', '8000418004', '71', 'Q', null, 'S', '2019-04-09 06:44:17', '0');
INSERT INTO `c_route` VALUES ('73', '8000418004', '72', 'Q', null, 'S', '2019-04-10 06:07:01', '0');
INSERT INTO `c_route` VALUES ('74', '8000418004', '73', 'Q', null, 'S', '2019-04-11 01:15:53', '0');
INSERT INTO `c_route` VALUES ('75', '8000418004', '74', 'Q', null, 'S', '2019-04-11 02:09:23', '0');
INSERT INTO `c_route` VALUES ('76', '8000418004', '75', 'Q', null, 'S', '2019-04-13 03:43:22', '0');
INSERT INTO `c_route` VALUES ('77', '8000418004', '76', 'Q', null, 'S', '2019-04-13 05:25:17', '0');
INSERT INTO `c_route` VALUES ('78', '8000418004', '77', 'Q', null, 'S', '2019-04-13 06:41:18', '0');
INSERT INTO `c_route` VALUES ('79', '8000418004', '78', 'Q', null, 'S', '2019-04-14 16:37:35', '0');
INSERT INTO `c_route` VALUES ('80', '8000418004', '79', 'Q', null, 'S', '2019-04-15 03:29:51', '0');
INSERT INTO `c_route` VALUES ('81', '8000418004', '80', 'Q', null, 'S', '2019-04-15 14:40:47', '0');
INSERT INTO `c_route` VALUES ('82', '8000418004', '81', 'Q', null, 'S', '2019-04-16 01:04:53', '0');
INSERT INTO `c_route` VALUES ('83', '8000418004', '82', 'Q', null, 'S', '2019-04-18 01:25:37', '0');
INSERT INTO `c_route` VALUES ('84', '8000418004', '52', 'D', null, 'S', '2019-04-18 03:45:23', '0');
INSERT INTO `c_route` VALUES ('85', '8000418004', '53', 'D', null, 'S', '2019-04-18 12:49:14', '0');
INSERT INTO `c_route` VALUES ('86', '8000418004', '83', 'Q', null, 'S', '2019-04-24 09:07:10', '0');
INSERT INTO `c_route` VALUES ('87', '8000418004', '84', 'Q', null, 'S', '2019-04-26 07:41:08', '0');
INSERT INTO `c_route` VALUES ('88', '8000418004', '85', 'Q', null, 'S', '2019-04-28 09:30:19', '0');
INSERT INTO `c_route` VALUES ('89', '8000418004', '86', 'Q', null, 'S', '2019-04-28 15:41:11', '0');
INSERT INTO `c_route` VALUES ('90', '8000418004', '87', 'Q', null, 'S', '2019-05-02 13:23:26', '0');
INSERT INTO `c_route` VALUES ('91', '8000418004', '88', 'Q', null, 'S', '2019-05-03 04:08:13', '0');
INSERT INTO `c_route` VALUES ('92', '8000418004', '89', 'Q', null, 'S', '2019-05-03 10:35:00', '0');
INSERT INTO `c_route` VALUES ('93', '8000418004', '90', 'Q', null, 'S', '2019-05-04 13:24:13', '0');
INSERT INTO `c_route` VALUES ('94', '8000418004', '91', 'Q', null, 'S', '2019-05-07 09:08:57', '0');
INSERT INTO `c_route` VALUES ('95', '8000418004', '92', 'Q', null, 'S', '2019-05-07 17:09:34', '0');
INSERT INTO `c_route` VALUES ('96', '8000418004', '93', 'Q', null, 'S', '2019-05-08 09:53:30', '0');
INSERT INTO `c_route` VALUES ('97', '8000418004', '94', 'Q', null, 'S', '2019-05-08 10:33:40', '0');
INSERT INTO `c_route` VALUES ('98', '8000418004', '95', 'Q', null, 'S', '2019-05-16 08:21:58', '0');
INSERT INTO `c_route` VALUES ('99', '8000418004', '96', 'Q', null, 'S', '2019-05-16 15:17:44', '0');
INSERT INTO `c_route` VALUES ('100', '8000418004', '97', 'Q', null, 'S', '2019-05-17 15:09:39', '0');
INSERT INTO `c_route` VALUES ('101', '8000418004', '98', 'Q', null, 'S', '2019-05-17 15:10:11', '0');
INSERT INTO `c_route` VALUES ('102', '8000418004', '99', 'Q', null, 'S', '2019-05-18 07:04:51', '0');
INSERT INTO `c_route` VALUES ('103', '8000418004', '100', 'Q', null, 'S', '2019-05-21 06:47:25', '0');
INSERT INTO `c_route` VALUES ('104', '8000418004', '101', 'Q', null, 'S', '2019-05-21 13:44:57', '0');
INSERT INTO `c_route` VALUES ('105', '8000418004', '102', 'Q', null, 'S', '2019-05-22 01:57:32', '0');
INSERT INTO `c_route` VALUES ('106', '8000418004', '103', 'Q', null, 'S', '2019-05-22 14:31:20', '0');
INSERT INTO `c_route` VALUES ('107', '8000418004', '104', 'Q', null, 'S', '2019-06-01 12:12:02', '0');
INSERT INTO `c_route` VALUES ('108', '8000418004', '105', 'Q', null, 'S', '2019-06-01 13:13:44', '0');
INSERT INTO `c_route` VALUES ('109', '8000418004', '106', 'Q', null, 'S', '2019-06-01 13:13:49', '0');
INSERT INTO `c_route` VALUES ('110', '8000418004', '107', 'Q', null, 'S', '2019-06-02 12:13:26', '0');
INSERT INTO `c_route` VALUES ('111', '8000418004', '108', 'Q', null, 'S', '2019-06-02 12:26:22', '0');
INSERT INTO `c_route` VALUES ('112', '8000418004', '109', 'Q', null, 'S', '2019-06-02 14:32:57', '0');
INSERT INTO `c_route` VALUES ('113', '8000418004', '110', 'Q', null, 'S', '2019-06-03 07:30:01', '0');
INSERT INTO `c_route` VALUES ('114', '8000418004', '111', 'Q', null, 'S', '2019-06-04 15:41:42', '0');
INSERT INTO `c_route` VALUES ('115', '8000418004', '112', 'Q', null, 'S', '2019-06-04 15:41:48', '0');
INSERT INTO `c_route` VALUES ('116', '8000418004', '113', 'Q', null, 'S', '2019-06-04 15:41:52', '0');
INSERT INTO `c_route` VALUES ('117', '8000418004', '114', 'Q', null, 'S', '2019-06-04 15:41:56', '0');
INSERT INTO `c_route` VALUES ('118', '8000418004', '115', 'Q', null, 'S', '2019-06-04 15:41:56', '0');
INSERT INTO `c_route` VALUES ('119', '8000418004', '116', 'Q', null, 'S', '2019-06-04 15:41:56', '0');
INSERT INTO `c_route` VALUES ('120', '8000418004', '117', 'Q', null, 'S', '2019-06-04 15:41:56', '0');
INSERT INTO `c_route` VALUES ('121', '8000418004', '118', 'Q', null, 'S', '2019-06-12 14:17:40', '0');
INSERT INTO `c_route` VALUES ('122', '8000418004', '119', 'Q', null, 'S', '2019-06-18 09:51:54', '0');
INSERT INTO `c_route` VALUES ('123', '8000418004', '120', 'Q', null, 'S', '2019-06-18 09:51:54', '0');
INSERT INTO `c_route` VALUES ('124', '8000418004', '121', 'Q', null, 'S', '2019-06-18 09:51:54', '0');
INSERT INTO `c_route` VALUES ('125', '8000418004', '122', 'Q', null, 'S', '2019-06-18 09:51:54', '0');
INSERT INTO `c_route` VALUES ('126', '8000418004', '123', 'Q', null, 'S', '2019-07-03 15:34:07', '0');
INSERT INTO `c_route` VALUES ('127', '8000418004', '124', 'Q', null, 'S', '2019-07-03 15:34:10', '0');
INSERT INTO `c_route` VALUES ('128', '8000418004', '125', 'Q', null, 'S', '2019-07-03 15:34:13', '0');
INSERT INTO `c_route` VALUES ('129', '8000418004', '126', 'Q', null, 'S', '2019-07-03 15:34:18', '0');
INSERT INTO `c_route` VALUES ('130', '8000418004', '127', 'Q', null, 'S', '2019-07-03 15:34:07', '0');
INSERT INTO `c_route` VALUES ('131', '8000418004', '128', 'Q', null, 'S', '2019-07-03 15:34:10', '0');
INSERT INTO `c_route` VALUES ('132', '8000418004', '129', 'Q', null, 'S', '2019-07-03 15:34:13', '0');
INSERT INTO `c_route` VALUES ('133', '8000418004', '130', 'Q', null, 'S', '2019-07-03 15:34:18', '0');
INSERT INTO `c_route` VALUES ('134', '8000418004', '131', 'Q', null, 'S', '2019-07-03 15:34:07', '0');
INSERT INTO `c_route` VALUES ('135', '8000418004', '132', 'Q', null, 'S', '2019-07-03 15:34:10', '0');
INSERT INTO `c_route` VALUES ('136', '8000418004', '133', 'Q', null, 'S', '2019-07-03 15:34:13', '0');
INSERT INTO `c_route` VALUES ('137', '8000418004', '134', 'Q', null, 'S', '2019-07-03 15:34:18', '0');
INSERT INTO `c_route` VALUES ('138', '8000418004', '135', 'Q', null, 'S', '2019-07-03 15:34:07', '0');
INSERT INTO `c_route` VALUES ('139', '8000418004', '136', 'Q', null, 'S', '2019-07-03 15:34:10', '0');
INSERT INTO `c_route` VALUES ('140', '8000418004', '137', 'Q', null, 'S', '2019-07-03 15:34:13', '0');
INSERT INTO `c_route` VALUES ('141', '8000418004', '138', 'Q', null, 'S', '2019-07-03 15:34:18', '0');
INSERT INTO `c_route` VALUES ('142', '8000418004', '140', 'Q', null, 'S', '2019-06-18 09:51:54', '0');
INSERT INTO `c_route` VALUES ('143', '8000418004', '982019070786650004', 'Q', null, 'S', '2019-07-03 15:34:10', '0');
INSERT INTO `c_route` VALUES ('144', '8000418004', '982019070731810003', 'Q', null, 'S', '2019-07-03 15:34:13', '0');
INSERT INTO `c_route` VALUES ('145', '8000418004', '982019070720300002', 'Q', null, 'S', '2019-07-03 15:34:18', '0');
INSERT INTO `c_route` VALUES ('146', '8000418004', '982019070760660001', 'Q', null, 'S', '2019-06-18 09:51:54', '0');
INSERT INTO `c_route` VALUES ('147', '8000418004', '982019072291810001', 'Q', null, 'S', '2019-07-22 12:23:34', '0');
INSERT INTO `c_route` VALUES ('148', '8000418001', '982019072291810001', 'Q', '1000', 'S', '2019-07-24 07:06:28', '0');
INSERT INTO `c_route` VALUES ('149', '8000418001', '140', 'Q', '1000', 'S', '2019-07-24 14:13:53', '0');
INSERT INTO `c_route` VALUES ('150', '8000418004', '982019080178500001', 'Q', '1000', 'S', '2019-08-01 08:56:18', '0');
INSERT INTO `c_route` VALUES ('151', '8000418001', '130', 'Q', '1000', 'S', '2019-08-09 14:31:21', '0');
INSERT INTO `c_route` VALUES ('152', '8000418001', '140', 'Q', '1000', 'S', '2019-08-09 14:33:15', '0');
INSERT INTO `c_route` VALUES ('153', '8000418001', '140', 'Q', '1000', 'S', '2019-08-09 14:45:36', '0');
INSERT INTO `c_route` VALUES ('154', '8000418001', '982019070720300002', 'Q', '1000', 'S', '2019-08-09 14:57:11', '0');
INSERT INTO `c_route` VALUES ('155', '8000418002', '982019072291810001', 'Q', '1000', 'S', '2019-08-09 15:03:14', '0');
INSERT INTO `c_route` VALUES ('156', '8000418004', '134', 'Q', '1000', 'S', '2019-08-10 09:05:35', '0');
INSERT INTO `c_route` VALUES ('157', '8000418004', '982019081035140007', 'Q', '1000', 'S', '2019-08-10 10:42:23', '0');
INSERT INTO `c_route` VALUES ('158', '8000418004', '982019081066170001', 'D', '1000', 'S', '2019-08-10 14:34:20', '0');
INSERT INTO `c_route` VALUES ('159', '8000418004', '982019081145400004', 'D', '1000', 'S', '2019-08-11 05:14:31', '0');
INSERT INTO `c_route` VALUES ('160', '8000418004', '36', 'D', '1000', 'S', '2019-08-11 05:27:33', '0');
INSERT INTO `c_route` VALUES ('161', '8000418004', '12', 'Q', '1000', 'S', '2019-08-13 05:49:27', '0');
INSERT INTO `c_route` VALUES ('162', '8000418004', '13', 'Q', '1000', 'S', '2019-08-13 05:49:57', '0');
INSERT INTO `c_route` VALUES ('163', '8000418004', '11', 'Q', '1000', 'S', '2019-08-13 06:00:05', '0');
INSERT INTO `c_route` VALUES ('164', '8000418004', '982019081775940001', 'D', '1000', 'S', '2019-08-17 13:50:25', '0');
INSERT INTO `c_route` VALUES ('165', '8000418004', '982019081711920002', 'D', '1000', 'S', '2019-08-17 13:51:19', '0');
INSERT INTO `c_route` VALUES ('166', '8000418004', '982019081766040003', 'D', '1000', 'S', '2019-08-17 13:52:03', '0');
INSERT INTO `c_route` VALUES ('167', '8000418004', '982019081763000004', 'Q', '1000', 'S', '2019-08-17 13:53:04', '0');
INSERT INTO `c_route` VALUES ('168', '8000418004', '982019081906810001', 'Q', '1000', 'S', '2019-08-19 12:23:16', '0');
INSERT INTO `c_route` VALUES ('169', '8000418004', '982019081932600002', 'D', '1000', 'S', '2019-08-19 12:26:19', '0');
INSERT INTO `c_route` VALUES ('170', '8000418004', '982019081941790003', 'D', '1000', 'S', '2019-08-19 12:27:05', '0');
INSERT INTO `c_route` VALUES ('171', '8000418004', '982019081991740004', 'D', '1000', 'S', '2019-08-19 12:27:46', '0');
INSERT INTO `c_route` VALUES ('172', '8000418004', '982019082019910001', 'D', '1000', 'S', '2019-08-20 12:57:59', '0');
INSERT INTO `c_route` VALUES ('173', '8000418004', '982019082089020002', 'D', '1000', 'S', '2019-08-20 12:58:53', '0');
INSERT INTO `c_route` VALUES ('174', '8000418004', '982019082024840003', 'D', '1000', 'S', '2019-08-20 12:59:47', '0');
INSERT INTO `c_route` VALUES ('175', '8000418004', '982019082025850004', 'Q', '1000', 'S', '2019-08-20 13:00:36', '0');
INSERT INTO `c_route` VALUES ('176', '8000418004', '982019082430870002', 'Q', '1000', 'S', '2019-08-25 07:47:47', '0');
INSERT INTO `c_route` VALUES ('177', '8000418004', '982019082512410001', 'Q', '1000', 'S', '2019-08-25 10:28:42', '0');
INSERT INTO `c_route` VALUES ('178', '8000418004', '982019082547440002', 'D', '1000', 'S', '2019-08-25 10:33:20', '0');
INSERT INTO `c_route` VALUES ('179', '8000418004', '982019082548630003', 'D', '1000', 'S', '2019-08-25 10:34:20', '0');
INSERT INTO `c_route` VALUES ('180', '8000418004', '982019083142520002', 'D', '1000', 'S', '2019-08-31 15:02:38', '0');
INSERT INTO `c_route` VALUES ('181', '8000418004', '982019090195030007', 'D', '1000', 'S', '2019-09-01 14:17:37', '0');
INSERT INTO `c_route` VALUES ('182', '8000418004', '982019090124280008', 'D', '1000', 'S', '2019-09-01 14:18:42', '0');
INSERT INTO `c_route` VALUES ('183', '8000418004', '982019090123100009', 'D', '1000', 'S', '2019-09-01 14:19:43', '0');
INSERT INTO `c_route` VALUES ('184', '8000418004', '982019090157620010', 'Q', '1000', 'S', '2019-09-01 14:20:33', '0');
INSERT INTO `c_route` VALUES ('185', '8000418001', '982019090883380001', 'Q', '1000', 'S', '2019-09-08 02:56:26', '0');
INSERT INTO `c_route` VALUES ('186', '8000418001', '982019090820960001', 'Q', '1000', 'S', '2019-09-08 06:06:48', '0');
INSERT INTO `c_route` VALUES ('187', '8000418004', '982019091191110001', 'D', '1000', 'S', '2019-09-11 01:02:47', '0');
INSERT INTO `c_route` VALUES ('188', '8000418004', '982019091199500002', 'D', '1000', 'S', '2019-09-11 01:03:52', '0');
INSERT INTO `c_route` VALUES ('189', '8000418004', '982019091865310001', 'D', '1000', 'S', '2019-09-18 12:22:59', '0');
INSERT INTO `c_route` VALUES ('190', '8000418004', '982019092001850001', 'Q', '1000', 'S', '2019-09-20 07:34:48', '0');
INSERT INTO `c_route` VALUES ('191', '8000418004', '982019092003950001', 'D', '1000', 'S', '2019-09-20 15:29:08', '0');
INSERT INTO `c_route` VALUES ('192', '8000418004', '982019100159270001', 'Q', '1000', 'S', '2019-10-01 04:41:22', '0');
INSERT INTO `c_route` VALUES ('193', '8000418004', '982019100152250002', 'D', '1000', 'S', '2019-10-01 04:42:26', '0');
INSERT INTO `c_route` VALUES ('194', '992019100160410003', '982019100166890004', 'Q', '1000', 'S', '2019-10-01 09:27:21', '0');
INSERT INTO `c_route` VALUES ('195', '8000418004', '982019100547970001', 'Q', '1000', 'S', '2019-10-05 01:15:52', '0');
INSERT INTO `c_route` VALUES ('196', '8000418004', '982019100526010002', 'D', '1000', 'S', '2019-10-05 01:26:28', '0');
INSERT INTO `c_route` VALUES ('197', '8000418004', '982019100580330003', 'D', '1000', 'S', '2019-10-05 01:27:21', '0');
INSERT INTO `c_route` VALUES ('198', '8000418004', '982019100575550004', 'D', '1000', 'S', '2019-10-05 01:28:10', '0');
INSERT INTO `c_route` VALUES ('199', '8000418004', '982019100734770001', 'D', '1000', 'S', '2019-10-07 08:29:00', '0');
INSERT INTO `c_route` VALUES ('200', '8000418004', '982019100760070002', 'D', '1000', 'S', '2019-10-07 08:30:02', '0');
INSERT INTO `c_route` VALUES ('201', '8000418004', '982019100722040003', 'D', '1000', 'S', '2019-10-07 08:31:09', '0');
INSERT INTO `c_route` VALUES ('202', '8000418004', '982019100759020004', 'Q', '1000', 'S', '2019-10-07 08:44:44', '0');
INSERT INTO `c_route` VALUES ('203', '8000418004', '982019101387930004', 'Q', '1000', 'S', '2019-10-13 23:20:36', '0');
INSERT INTO `c_route` VALUES ('204', '8000418004', '982019101896450007', 'D', '1000', 'S', '2019-10-18 23:10:34', '0');
INSERT INTO `c_route` VALUES ('205', '8000418004', '982019101864500008', 'D', '1000', 'S', '2019-10-18 23:11:09', '0');
INSERT INTO `c_route` VALUES ('206', '8000418004', '982019101921630001', 'D', '1000', 'S', '2019-10-19 23:25:46', '0');
INSERT INTO `c_route` VALUES ('207', '8000418004', '982019102018840001', 'D', '1000', 'S', '2019-10-20 21:43:59', '0');
INSERT INTO `c_route` VALUES ('208', '8000418004', '982019102170190006', 'D', '1000', 'S', '2019-10-21 21:55:49', '0');
INSERT INTO `c_route` VALUES ('209', '8000418004', '982019102153330007', 'D', '1000', 'S', '2019-10-21 21:56:28', '0');
INSERT INTO `c_route` VALUES ('210', '8000418004', '982019102139830008', 'D', '1000', 'S', '2019-10-21 21:57:02', '0');
INSERT INTO `c_route` VALUES ('211', '8000418004', '982019102188520009', 'Q', '1000', 'S', '2019-10-21 21:57:40', '0');
INSERT INTO `c_route` VALUES ('212', '8000418004', '982019102688000003', 'D', '1000', 'S', '2019-10-26 23:07:27', '0');
INSERT INTO `c_route` VALUES ('213', '8000418004', '982019102621210004', 'D', '1000', 'S', '2019-10-26 23:08:15', '0');
INSERT INTO `c_route` VALUES ('214', '8000418004', '982019102685750005', 'Q', '1000', 'S', '2019-10-26 23:10:05', '0');
INSERT INTO `c_route` VALUES ('215', '8000418004', '982019102933370001', 'Q', '1000', 'S', '2019-10-29 21:32:00', '0');
INSERT INTO `c_route` VALUES ('216', '8000418004', '982019103069090008', 'Q', '1000', 'S', '2019-10-30 21:58:27', '0');
INSERT INTO `c_route` VALUES ('217', '8000418004', '982019103127420012', 'Q', '1000', 'S', '2019-10-31 13:17:29', '0');
INSERT INTO `c_route` VALUES ('218', '8000418004', '982019103172080001', 'Q', '1000', 'S', '2019-10-31 14:09:29', '0');
INSERT INTO `c_route` VALUES ('219', '8000418004', '982019103160520014', 'D', '1000', 'S', '2019-10-31 23:22:30', '0');
INSERT INTO `c_route` VALUES ('220', '8000418004', '982019103170230015', 'D', '1000', 'S', '2019-10-31 23:23:07', '0');
INSERT INTO `c_route` VALUES ('221', '8000418004', '982019103116860016', 'D', '1000', 'S', '2019-10-31 23:23:55', '0');
INSERT INTO `c_route` VALUES ('222', '8000418004', '982019103184550017', 'Q', '1000', 'S', '2019-10-31 23:24:51', '0');
INSERT INTO `c_route` VALUES ('223', '8000418004', '982019110104600006', 'Q', '1000', 'S', '2019-11-01 13:54:58', '0');
INSERT INTO `c_route` VALUES ('224', '8000418004', '982019110370410008', 'Q', '1000', 'S', '2019-11-03 18:47:28', '0');
INSERT INTO `c_route` VALUES ('225', '8000418004', '982019110412600001', 'D', '1000', 'S', '2019-11-04 22:43:12', '0');
INSERT INTO `c_route` VALUES ('226', '8000418004', '982019110547690008', 'Q', '1000', 'S', '2019-11-05 09:17:10', '0');
INSERT INTO `c_route` VALUES ('227', '8000418004', '982019110870570039', 'D', '1000', 'S', '2019-11-08 23:42:12', '0');
INSERT INTO `c_route` VALUES ('228', '8000418004', '982019110867720040', 'D', '1000', 'S', '2019-11-08 23:42:41', '0');
INSERT INTO `c_route` VALUES ('229', '8000418004', '982019110832920041', 'D', '1000', 'S', '2019-11-08 23:43:09', '0');
INSERT INTO `c_route` VALUES ('230', '8000418004', '982019110811240042', 'Q', '1000', 'S', '2019-11-08 23:43:42', '0');
INSERT INTO `c_route` VALUES ('231', '8000418004', '982019111044340048', 'D', '1000', 'S', '2019-11-10 13:24:46', '0');
INSERT INTO `c_route` VALUES ('232', '8000418004', '982019111054410049', 'D', '1000', 'S', '2019-11-10 13:25:27', '0');
INSERT INTO `c_route` VALUES ('233', '8000418004', '982019111005820050', 'D', '1000', 'S', '2019-11-10 13:26:09', '0');
INSERT INTO `c_route` VALUES ('234', '8000418004', '982019111001650051', 'D', '1000', 'S', '2019-11-10 13:26:45', '0');
INSERT INTO `c_route` VALUES ('235', '992019111002270001', '982019111053970002', 'Q', '1000', 'S', '2019-11-10 23:13:35', '0');
INSERT INTO `c_route` VALUES ('236', '8000418004', '982019111199670010', 'Q', '1000', 'S', '2019-11-11 22:47:44', '0');
INSERT INTO `c_route` VALUES ('237', '992019111002270001', '982019111229390016', 'Q', '1000', 'S', '2019-11-12 00:32:22', '0');
INSERT INTO `c_route` VALUES ('238', '992019111002270001', '982019111283640001', 'Q', '1000', 'S', '2019-11-12 13:41:47', '0');
INSERT INTO `c_route` VALUES ('239', '992019111002270001', '982019111207790002', 'Q', '1000', 'S', '2019-11-12 13:42:57', '0');
INSERT INTO `c_route` VALUES ('240', '992019111758490006', '127', 'Q', '1000', 'S', '2019-11-18 17:30:57', '0');
INSERT INTO `c_route` VALUES ('241', '992019111758490006', '36', 'Q', '1000', 'S', '2019-11-18 23:18:45', '0');
INSERT INTO `c_route` VALUES ('242', '992019111758490006', '982019111845380001', 'Q', '1000', 'S', '2019-11-18 23:22:40', '0');
INSERT INTO `c_route` VALUES ('243', '992019111758490006', '982019111845380001', 'Q', '1000', 'S', '2019-11-23 16:47:05', '0');
INSERT INTO `c_route` VALUES ('244', '992019111758490006', '982019112482610001', 'Q', '1000', 'S', '2019-11-24 13:50:45', '0');
INSERT INTO `c_route` VALUES ('245', '8000418004', '982019112636050002', 'Q', '1000', 'S', '2019-11-26 23:22:02', '0');
INSERT INTO `c_route` VALUES ('246', '992019112621360001', '982019112637880003', 'D', '1000', 'S', '2019-11-26 23:22:39', '0');
INSERT INTO `c_route` VALUES ('247', '8000418004', '982019120144860003', 'Q', '1000', 'S', '2019-12-01 15:04:11', '0');
INSERT INTO `c_route` VALUES ('248', '8000418004', '982019120136950001', 'D', '1000', 'S', '2019-12-01 23:31:10', '0');
INSERT INTO `c_route` VALUES ('249', '8000418004', '982019120199870002', 'D', '1000', 'S', '2019-12-01 23:31:50', '0');
INSERT INTO `c_route` VALUES ('250', '8000418004', '982019120183700003', 'D', '1000', 'S', '2019-12-01 23:32:28', '0');
INSERT INTO `c_route` VALUES ('251', '8000418004', '982019120114520004', 'Q', '1000', 'S', '2019-12-01 23:33:08', '0');
INSERT INTO `c_route` VALUES ('252', '8000418004', '982019120478690001', 'D', '1000', 'S', '2019-12-04 00:27:53', '0');
INSERT INTO `c_route` VALUES ('253', '8000418004', '982019120492710001', 'Q', '1000', 'S', '2019-12-04 21:02:51', '0');
INSERT INTO `c_route` VALUES ('254', '8000418004', '982019120413900003', 'Q', '1000', 'S', '2019-12-04 23:19:09', '0');
INSERT INTO `c_route` VALUES ('255', '8000418004', '982019120569550003', 'Q', '1000', 'S', '2019-12-05 01:10:56', '0');
INSERT INTO `c_route` VALUES ('256', '8000418004', '982019120571920002', 'D', '1000', 'S', '2019-12-05 21:33:48', '0');
INSERT INTO `c_route` VALUES ('257', '8000418004', '982019120759250001', 'D', '1000', 'S', '2019-12-07 15:18:40', '0');
INSERT INTO `c_route` VALUES ('258', '8000418004', '982019120704480002', 'D', '1000', 'S', '2019-12-07 15:19:13', '0');
INSERT INTO `c_route` VALUES ('259', '8000418004', '982019120716100003', 'D', '1000', 'S', '2019-12-07 15:19:42', '0');
INSERT INTO `c_route` VALUES ('260', '8000418004', '982019120737560004', 'Q', '1000', 'S', '2019-12-07 15:20:25', '0');
INSERT INTO `c_route` VALUES ('261', '8000418004', '982019120814410004', 'Q', '1000', 'S', '2019-12-08 23:39:15', '0');
INSERT INTO `c_route` VALUES ('262', '8000418004', '982019121458240001', 'Q', '1000', 'S', '2019-12-14 14:02:42', '0');
INSERT INTO `c_route` VALUES ('263', '992019111758490006', '982019100547970001', 'Q', '1000', 'S', '2019-12-17 14:40:24', '0');
INSERT INTO `c_route` VALUES ('264', '992019111758490006', '982019100526010002', 'D', '1000', 'S', '2019-12-17 14:41:30', '0');
INSERT INTO `c_route` VALUES ('265', '8000418004', '982019112482610001', 'Q', '1000', 'S', '2019-12-20 10:06:39', '0');
INSERT INTO `c_route` VALUES ('266', '8000418004', '982019122295940001', 'Q', '1000', 'S', '2019-12-22 01:48:20', '0');
INSERT INTO `c_route` VALUES ('267', '992019111758490006', '982019090883380001', 'Q', '1000', 'S', '2019-12-22 19:30:10', '0');
INSERT INTO `c_route` VALUES ('268', '992019111758490006', '99', 'Q', '1000', 'S', '2019-12-25 13:59:46', '0');
INSERT INTO `c_route` VALUES ('269', '992019111758490006', '982019122942410024', 'D', '1000', 'S', '2019-12-29 11:58:30', '0');
INSERT INTO `c_route` VALUES ('270', '8000418004', '982019122944790001', 'Q', '1000', 'S', '2019-12-29 12:27:53', '0');
INSERT INTO `c_route` VALUES ('271', '992019111758490006', '982019122944790001', 'Q', '1000', 'S', '2019-12-29 21:48:48', '0');
INSERT INTO `c_route` VALUES ('272', '8000418004', '982019122966570001', 'Q', '1000', 'S', '2019-12-29 22:20:33', '0');
INSERT INTO `c_route` VALUES ('273', '8000418004', '982019123041610001', 'D', '1000', 'S', '2019-12-30 00:31:21', '0');
INSERT INTO `c_route` VALUES ('274', '992019111758490006', '982019123059890001', 'D', '1000', 'S', '2019-12-30 20:55:16', '0');
INSERT INTO `c_route` VALUES ('275', '992019111758490006', '982019103184550017', 'Q', '1000', 'S', '2019-12-31 11:04:37', '0');
INSERT INTO `c_route` VALUES ('276', '992019111758490006', '982019100526010002', 'D', '1000', 'S', '2019-12-31 11:16:49', '0');
INSERT INTO `c_route` VALUES ('277', '992019111758490006', '96', 'D', '1000', 'S', '2019-12-31 11:34:04', '0');
INSERT INTO `c_route` VALUES ('278', '992019111758490006', '982019103160520014', 'D', '1000', 'S', '2019-12-31 11:35:20', '0');
INSERT INTO `c_route` VALUES ('279', '992019111758490006', '982019103116860016', 'D', '1000', 'S', '2019-12-31 11:35:58', '0');
INSERT INTO `c_route` VALUES ('280', '992019111758490006', '982019103170230015', 'D', '1000', 'S', '2019-12-31 11:37:11', '0');
INSERT INTO `c_route` VALUES ('281', '992019111758490006', '982020010139630001', 'Q', '1000', 'S', '2020-01-01 00:00:06', '0');
INSERT INTO `c_route` VALUES ('282', '992019111758490006', '982020010266790002', 'D', '1000', 'S', '2020-01-02 21:32:52', '0');
INSERT INTO `c_route` VALUES ('283', '992019111758490006', '982019120114520004', 'Q', '1000', 'S', '2020-01-02 21:59:14', '0');
INSERT INTO `c_route` VALUES ('284', '992019111758490006', '982020010587990008', 'D', '1000', 'S', '2020-01-05 20:15:12', '0');
INSERT INTO `c_route` VALUES ('285', '992019111758490006', '982020010765690001', 'D', '1000', 'S', '2020-01-07 00:09:43', '0');
INSERT INTO `c_route` VALUES ('286', '992019111758490006', '102', 'Q', '1000', 'S', '2020-01-08 13:18:09', '0');
INSERT INTO `c_route` VALUES ('287', '992019111758490006', '982020010826510027', 'Q', '1000', 'S', '2020-01-08 21:25:21', '0');
INSERT INTO `c_route` VALUES ('288', '992019111758490006', '116', 'Q', '1000', 'S', '2020-01-08 23:51:43', '0');
INSERT INTO `c_route` VALUES ('289', '992019111758490006', '118', 'Q', '1000', 'S', '2020-01-09 00:31:59', '0');
INSERT INTO `c_route` VALUES ('290', '992020011134400001', '982020011157250002', 'D', '1000', 'S', '2020-01-11 20:04:45', '0');
INSERT INTO `c_route` VALUES ('291', '992019111758490006', '982020011118310003', 'D', '1000', 'S', '2020-01-11 20:05:40', '0');
INSERT INTO `c_route` VALUES ('292', '992020011134400001', '982019111845380001', 'Q', '1000', 'S', '2020-01-11 22:30:25', '0');
INSERT INTO `c_route` VALUES ('293', '992019111758490006', '123', 'Q', '1000', 'S', '2020-01-12 01:19:00', '0');
INSERT INTO `c_route` VALUES ('294', '8000418004', '982020011307990048', 'D', '1000', 'S', '2020-01-13 19:37:09', '0');
INSERT INTO `c_route` VALUES ('295', '8000418004', '982020011309050049', 'Q', '1000', 'S', '2020-01-13 19:37:56', '0');
INSERT INTO `c_route` VALUES ('296', '8000418004', '982020011379430050', 'D', '1000', 'S', '2020-01-13 19:38:29', '0');
INSERT INTO `c_route` VALUES ('297', '8000418004', '982020011397920051', 'D', '1000', 'S', '2020-01-13 19:39:04', '0');
INSERT INTO `c_route` VALUES ('298', '992019111758490006', '982020011309050049', 'Q', '1000', 'S', '2020-01-14 22:28:35', '0');
INSERT INTO `c_route` VALUES ('299', '992019111758490006', '108', 'Q', '1000', 'S', '2020-01-15 22:53:56', '0');
INSERT INTO `c_route` VALUES ('300', '992019111758490006', '982020011648620031', 'Q', '1000', 'S', '2020-01-16 23:48:14', '0');
INSERT INTO `c_route` VALUES ('301', '8000418004', '982020012324680231', 'D', '1000', 'S', '2020-01-23 00:45:21', '0');
INSERT INTO `c_route` VALUES ('302', '8000418004', '982020012307880232', 'D', '1000', 'S', '2020-01-23 00:45:50', '0');
INSERT INTO `c_route` VALUES ('303', '8000418004', '982020012361920233', 'D', '1000', 'S', '2020-01-23 00:46:16', '0');
INSERT INTO `c_route` VALUES ('304', '8000418004', '982020012340430234', 'Q', '1000', 'S', '2020-01-23 00:46:48', '0');
INSERT INTO `c_route` VALUES ('305', '8000418004', '982020012335770001', 'D', '1000', 'S', '2020-01-23 12:47:57', '0');
INSERT INTO `c_route` VALUES ('306', '8000418004', '982020012357060002', 'D', '1000', 'S', '2020-01-23 12:49:08', '0');
INSERT INTO `c_route` VALUES ('307', '8000418004', '982020012317780003', 'D', '1000', 'S', '2020-01-23 12:49:40', '0');
INSERT INTO `c_route` VALUES ('308', '8000418004', '982020012383330004', 'Q', '1000', 'S', '2020-01-23 12:50:11', '0');
INSERT INTO `c_route` VALUES ('309', '8000418004', '982020012378650005', 'D', '1000', 'S', '2020-01-23 22:12:30', '0');
INSERT INTO `c_route` VALUES ('310', '8000418004', '982020012385650006', 'Q', '1000', 'S', '2020-01-23 22:13:17', '0');
INSERT INTO `c_route` VALUES ('311', '992020012671060001', '982020012655230002', 'D', '1000', 'S', '2020-01-26 12:09:56', '0');
INSERT INTO `c_route` VALUES ('312', '992019111758490006', '982020012385650006', 'Q', '1000', 'S', '2020-01-26 18:58:09', '0');
INSERT INTO `c_route` VALUES ('313', '992019111758490006', '104', 'Q', '1000', 'S', '2020-01-26 21:31:44', '0');
INSERT INTO `c_route` VALUES ('314', '992019111758490006', '982020012700400002', 'Q', '1000', 'S', '2020-01-27 13:37:16', '0');
INSERT INTO `c_route` VALUES ('315', '992019111758490006', '982020012770640001', 'D', '1000', 'S', '2020-01-27 19:02:30', '0');
INSERT INTO `c_route` VALUES ('316', '8000418004', '982020012794540003', 'Q', '1000', 'S', '2020-01-27 21:37:07', '0');
INSERT INTO `c_route` VALUES ('317', '992020012671060001', '982020012837020001', 'Q', '1000', 'S', '2020-01-28 21:57:44', '0');
INSERT INTO `c_route` VALUES ('318', '8000418004', '982020012837020001', 'Q', '1000', 'S', '2020-01-28 23:50:54', '0');
INSERT INTO `c_route` VALUES ('319', '8000418004', '982020013027672996', 'D', '1000', 'S', '2020-01-30 15:07:20', '0');
INSERT INTO `c_route` VALUES ('320', '8000418004', '982020013076830001', 'Q', '1000', 'S', '2020-01-30 22:51:28', '0');
INSERT INTO `c_route` VALUES ('321', '8000418004', '982020020135223988', 'Q', '1000', 'S', '2020-02-01 16:08:53', '0');
INSERT INTO `c_route` VALUES ('322', '8000418004', '9820200201471911930', 'D', '1000', 'S', '2020-02-01 23:45:33', '0');
INSERT INTO `c_route` VALUES ('323', '8000418004', '982020020230730001', 'Q', '1000', 'S', '2020-02-02 12:15:31', '0');
INSERT INTO `c_route` VALUES ('324', '8000418004', '9820200203366831759', 'Q', '1000', 'S', '2020-02-03 16:24:17', '0');
INSERT INTO `c_route` VALUES ('325', '992019111758490006', '982020020135223988', 'Q', '1000', 'S', '2020-02-05 16:01:43', '0');
INSERT INTO `c_route` VALUES ('326', '992019111758490006', '109', 'Q', '1000', 'S', '2020-02-05 23:23:58', '0');
INSERT INTO `c_route` VALUES ('327', '8000418004', '982020020845600001', 'D', '1000', 'S', '2020-02-08 16:35:51', '0');
INSERT INTO `c_route` VALUES ('328', '8000418004', '982020020983490028', 'D', '1000', 'S', '2020-02-09 18:58:02', '0');
INSERT INTO `c_route` VALUES ('329', '8000418004', '982020021078860002', 'D', '1000', 'S', '2020-02-10 14:36:38', '0');
INSERT INTO `c_route` VALUES ('330', '8000418004', '982020021097260003', 'D', '1000', 'S', '2020-02-10 14:57:24', '0');
INSERT INTO `c_route` VALUES ('331', '8000418004', '982020021003280004', 'D', '1000', 'S', '2020-02-10 14:57:58', '0');
INSERT INTO `c_route` VALUES ('332', '8000418004', '982020021099120005', 'Q', '1000', 'S', '2020-02-10 14:59:31', '0');
INSERT INTO `c_route` VALUES ('333', '8000418004', '982020021061150006', 'D', '1000', 'S', '2020-02-10 15:00:06', '0');
INSERT INTO `c_route` VALUES ('334', '992019111758490006', '982020021078860002', 'D', '1000', 'S', '2020-02-10 17:26:40', '0');
INSERT INTO `c_route` VALUES ('335', '8000418004', '982020021172910054', 'Q', '1000', 'S', '2020-02-11 23:43:52', '0');
INSERT INTO `c_route` VALUES ('336', '8000418004', '982020021123890053', 'D', '1000', 'S', '2020-02-11 23:46:21', '0');
INSERT INTO `c_route` VALUES ('337', '8000418004', '982020021180440052', 'D', '1000', 'S', '2020-02-11 23:46:37', '0');
INSERT INTO `c_route` VALUES ('338', '8000418004', '982020021100650051', 'D', '1000', 'S', '2020-02-11 23:46:57', '0');
INSERT INTO `c_route` VALUES ('339', '8000418004', '982020021585730105', 'Q', '1000', 'S', '2020-02-15 10:32:36', '0');
INSERT INTO `c_route` VALUES ('340', '8000418004', '982020021683900002', 'D', '1000', 'S', '2020-02-16 19:47:42', '0');
INSERT INTO `c_route` VALUES ('341', '8000418004', '982020021676290014', 'D', '1000', 'S', '2020-02-16 22:53:46', '0');
INSERT INTO `c_route` VALUES ('342', '8000418004', '982020021653190015', 'D', '1000', 'S', '2020-02-16 22:54:24', '0');
INSERT INTO `c_route` VALUES ('343', '8000418004', '982020021657110016', 'D', '1000', 'S', '2020-02-16 22:55:00', '0');
INSERT INTO `c_route` VALUES ('344', '8000418004', '982020021723950047', 'D', '1000', 'S', '2020-02-17 19:16:30', '0');
INSERT INTO `c_route` VALUES ('345', '8000418004', '982020021758320049', 'D', '1000', 'S', '2020-02-17 19:16:59', '0');
INSERT INTO `c_route` VALUES ('346', '8000418004', '982020021742980050', 'D', '1000', 'S', '2020-02-17 19:17:28', '0');
INSERT INTO `c_route` VALUES ('347', '8000418004', '982020021710420051', 'Q', '1000', 'S', '2020-02-17 19:17:59', '0');
INSERT INTO `c_route` VALUES ('348', '8000418004', '982020021775350054', 'Q', '1000', 'S', '2020-02-17 22:07:26', '0');
INSERT INTO `c_route` VALUES ('349', '8000418004', '982020021805260006', 'D', '1000', 'S', '2020-02-18 13:00:49', '0');
INSERT INTO `c_route` VALUES ('350', '8000418004', '982020021883560007', 'D', '1000', 'S', '2020-02-18 13:02:58', '0');
INSERT INTO `c_route` VALUES ('351', '8000418004', '982020021819460013', 'D', '1000', 'S', '2020-02-18 14:54:57', '0');
INSERT INTO `c_route` VALUES ('352', '8000418004', '982020021988840012', 'D', '1000', 'S', '2020-02-19 21:45:23', '0');
INSERT INTO `c_route` VALUES ('353', '8000418004', '982020021912230013', 'D', '1000', 'S', '2020-02-19 21:46:47', '0');
INSERT INTO `c_route` VALUES ('354', '8000418004', '982020021904760014', 'D', '1000', 'A', '2020-02-19 21:48:23', '0');
INSERT INTO `c_route` VALUES ('355', '8000418004', '982020021924890015', 'Q', '1000', 'S', '2020-02-19 21:49:45', '0');
INSERT INTO `c_route` VALUES ('356', '992020022270580001', '37', 'Q', '1000', 'S', '2020-02-23 00:02:48', '0');
INSERT INTO `c_route` VALUES ('357', '992020022270580001', '56', 'Q', '1000', 'S', '2020-02-23 00:03:26', '0');
INSERT INTO `c_route` VALUES ('358', '992020022270580001', '4', 'Q', '1000', 'S', '2020-02-23 00:47:21', '0');
INSERT INTO `c_route` VALUES ('359', '992020022270580001', '982019122295940001', 'Q', '1000', 'S', '2020-02-23 12:02:18', '0');
INSERT INTO `c_route` VALUES ('360', '992020022270580001', '982020011648620031', 'Q', '1000', 'S', '2020-02-23 15:04:17', '0');
INSERT INTO `c_route` VALUES ('361', '992020022270580001', '982020011309050049', 'Q', '1000', 'S', '2020-02-23 18:57:43', '0');
INSERT INTO `c_route` VALUES ('362', '992020022270580001', '46', 'Q', '1000', 'S', '2020-02-24 13:53:41', '0');
INSERT INTO `c_route` VALUES ('363', '992019111758490006', '37', 'Q', '1000', 'S', '2020-02-25 22:12:44', '0');
INSERT INTO `c_route` VALUES ('364', '992019111758490006', '4', 'Q', '1000', 'S', '2020-02-25 22:13:54', '0');
INSERT INTO `c_route` VALUES ('365', '8000418004', '982020022678740017', 'D', '1000', 'S', '2020-02-26 16:12:40', '0');
INSERT INTO `c_route` VALUES ('366', '8000418004', '982020022643970018', 'D', '1000', 'S', '2020-02-26 16:13:12', '0');
INSERT INTO `c_route` VALUES ('367', '8000418004', '982020022683180019', 'D', '1000', 'S', '2020-02-26 16:13:49', '0');
INSERT INTO `c_route` VALUES ('368', '8000418004', '982020022603770020', 'Q', '1000', 'S', '2020-02-26 16:14:21', '0');
INSERT INTO `c_route` VALUES ('369', '992020022270580001', '982019090883380001', 'Q', '1000', 'S', '2020-02-26 22:26:45', '0');
INSERT INTO `c_route` VALUES ('370', '992020022270580001', '982020020845600001', 'D', '1000', 'S', '2020-02-26 22:53:05', '0');
INSERT INTO `c_route` VALUES ('371', '992020022270580001', '39', 'D', '1000', 'S', '2020-02-27 20:19:15', '0');
INSERT INTO `c_route` VALUES ('372', '992020022270580001', '982019110370410008', 'Q', '1000', 'S', '2020-02-28 22:56:24', '0');
INSERT INTO `c_route` VALUES ('373', '992020022270580001', '982019110547690008', 'Q', '1000', 'S', '2020-02-29 00:03:48', '0');
INSERT INTO `c_route` VALUES ('374', '992020022270580001', '982019110412600001', 'D', '1000', 'S', '2020-02-29 12:23:58', '0');
INSERT INTO `c_route` VALUES ('375', '992020022270580001', '83', 'Q', '1000', 'S', '2020-02-29 23:15:11', '0');
INSERT INTO `c_route` VALUES ('376', '992020022270580001', '87', 'Q', '1000', 'S', '2020-03-01 00:10:11', '0');
INSERT INTO `c_route` VALUES ('377', '992020022270580001', '92', 'Q', '1000', 'S', '2020-03-01 00:24:20', '0');
INSERT INTO `c_route` VALUES ('378', '992020022270580001', '982020010826510027', 'Q', '1000', 'S', '2020-03-01 01:08:29', '0');
INSERT INTO `c_route` VALUES ('379', '992020022270580001', '982019103160520014', 'D', '1000', 'S', '2020-03-01 01:09:13', '0');
INSERT INTO `c_route` VALUES ('380', '8000418004', '982020032249770028', 'Q', '1000', 'S', '2020-03-22 12:46:10', '0');
INSERT INTO `c_route` VALUES ('381', '992020022270580001', '982019100547970001', 'Q', '1000', 'S', '2020-03-23 22:51:47', '0');
INSERT INTO `c_route` VALUES ('382', '8000418004', '982020032817140005', 'Q', '1000', 'S', '2020-03-28 13:46:36', '0');
INSERT INTO `c_route` VALUES ('383', '8000418004', '982020032832700001', 'D', '1000', 'S', '2020-03-28 23:05:38', '0');
INSERT INTO `c_route` VALUES ('384', '8000418004', '982020032934060001', 'D', '1000', 'S', '2020-03-29 01:10:02', '0');
INSERT INTO `c_route` VALUES ('385', '8000418004', '982020040531370006', 'Q', '1000', 'S', '2020-04-05 15:10:12', '0');
INSERT INTO `c_route` VALUES ('386', '992020022270580001', '982020040531370006', 'Q', '1000', 'S', '2020-04-05 15:10:29', '0');
INSERT INTO `c_route` VALUES ('387', '992020022270580001', '982020021924890015', 'Q', '1000', 'S', '2020-04-05 15:32:34', '0');
INSERT INTO `c_route` VALUES ('388', '992019111758490006', '39', 'D', '1000', 'S', '2020-04-06 15:15:53', '0');
INSERT INTO `c_route` VALUES ('389', '992019111758490006', '982020040724360001', 'D', '1000', 'S', '2020-04-07 22:50:04', '0');
INSERT INTO `c_route` VALUES ('390', '8000418004', '982020041835100001', 'D', '1000', 'S', '2020-04-18 17:14:55', '0');
INSERT INTO `c_route` VALUES ('391', '8000418004', '982020041879610002', 'D', '1000', 'S', '2020-04-18 17:15:39', '0');
INSERT INTO `c_route` VALUES ('392', '8000418004', '982020041854560003', 'D', '1000', 'S', '2020-04-18 17:16:24', '0');
INSERT INTO `c_route` VALUES ('393', '8000418004', '982020041846530004', 'Q', '1000', 'S', '2020-04-18 17:17:45', '0');
INSERT INTO `c_route` VALUES ('394', '992019111758490006', '982020041846530004', 'Q', '1000', 'S', '2020-04-18 17:18:13', '0');
INSERT INTO `c_route` VALUES ('395', '992019111758490006', '982020041854560003', 'D', '1000', 'S', '2020-04-18 17:18:31', '0');
INSERT INTO `c_route` VALUES ('396', '992019111758490006', '982020041835100001', 'D', '1000', 'S', '2020-04-18 17:18:51', '0');
INSERT INTO `c_route` VALUES ('397', '8000418002', '982020041912510068', 'D', '1000', 'S', '2020-04-19 19:38:55', '0');
INSERT INTO `c_route` VALUES ('398', '8000418002', '982020041919150067', 'D', '1000', 'S', '2020-04-19 19:41:55', '0');
INSERT INTO `c_route` VALUES ('399', '8000418002', '982020041936590066', 'D', '1000', 'S', '2020-04-19 19:42:35', '0');
INSERT INTO `c_route` VALUES ('400', '8000418002', '982020041994600076', 'Q', '1000', 'S', '2020-04-19 19:46:32', '0');
INSERT INTO `c_route` VALUES ('401', '992019111758490006', '982020041879610002', 'D', '1000', 'S', '2020-04-21 00:13:09', '0');
INSERT INTO `c_route` VALUES ('402', '8000418004', '982020042542900001', 'D', '1000', 'S', '2020-04-25 23:25:28', '0');
INSERT INTO `c_route` VALUES ('403', '992020022270580001', '982019100526010002', 'D', '1000', 'S', '2020-04-26 20:27:35', '0');
INSERT INTO `c_route` VALUES ('404', '8000418004', '982020042654380012', 'D', '1000', 'S', '2020-04-26 21:32:04', '0');
INSERT INTO `c_route` VALUES ('405', '992020022270580001', '127', 'Q', '1000', 'S', '2020-04-28 23:58:55', '0');
INSERT INTO `c_route` VALUES ('406', '992020022270580001', '982019102188520009', 'Q', '1000', 'S', '2020-04-29 22:07:28', '0');
INSERT INTO `c_route` VALUES ('407', '992020022270580001', '982020022678740017', 'D', '1000', 'S', '2020-04-29 22:09:01', '0');
INSERT INTO `c_route` VALUES ('408', '992020022270580001', '982020050465320001', 'D', '1000', 'S', '2020-05-04 21:42:01', '0');
INSERT INTO `c_route` VALUES ('409', '8000418004', '982020050559120011', 'D', '1000', 'S', '2020-05-05 22:31:54', '0');
INSERT INTO `c_route` VALUES ('410', '8000418004', '982020050516580012', 'D', '1000', 'S', '2020-05-05 22:50:03', '0');
INSERT INTO `c_route` VALUES ('411', '8000418004', '982020050519280013', 'Q', '1000', 'S', '2020-05-05 22:50:54', '0');
INSERT INTO `c_route` VALUES ('412', '8000418004', '982020050910650001', 'D', '1000', 'S', '2020-05-09 23:47:35', '0');
INSERT INTO `c_route` VALUES ('413', '8000418004', '982020051103890153', 'D', '1000', 'S', '2020-05-11 16:54:18', '0');
INSERT INTO `c_route` VALUES ('414', '8000418004', '982020051112250154', 'D', '1000', 'S', '2020-05-11 16:54:52', '0');
INSERT INTO `c_route` VALUES ('415', '8000418004', '982020051116150155', 'D', '1000', 'S', '2020-05-11 16:55:15', '0');
INSERT INTO `c_route` VALUES ('416', '8000418004', '982020051166580156', 'Q', '1000', 'S', '2020-05-11 16:55:41', '0');
INSERT INTO `c_route` VALUES ('417', '8000418004', '982020051627210083', 'D', '1000', 'S', '2020-05-16 17:12:28', '0');
INSERT INTO `c_route` VALUES ('418', '8000418004', '982020051652420084', 'D', '1000', 'S', '2020-05-16 17:12:50', '0');
INSERT INTO `c_route` VALUES ('419', '8000418004', '982020051698360085', 'D', '1000', 'S', '2020-05-16 17:13:17', '0');
INSERT INTO `c_route` VALUES ('420', '8000418004', '982020051629810086', 'Q', '1000', 'S', '2020-05-16 17:13:48', '0');
INSERT INTO `c_route` VALUES ('421', '992020051967020024', '123', 'Q', '1000', 'S', '2020-05-19 10:55:54', '0');
INSERT INTO `c_route` VALUES ('422', '992020051967020024', '982019110811240042', 'Q', '1000', 'S', '2020-05-19 13:43:29', '0');
INSERT INTO `c_route` VALUES ('423', '992020051967020024', '982019110870570039', 'D', '1000', 'S', '2020-05-19 15:52:37', '0');
INSERT INTO `c_route` VALUES ('424', '992020051967020024', '982019111053970002', 'D', '1000', 'S', '2020-05-19 17:10:59', '0');
INSERT INTO `c_route` VALUES ('425', '992020051967020024', '982019111229390016', 'D', '1000', 'S', '2020-05-19 17:48:38', '0');
INSERT INTO `c_route` VALUES ('426', '992020051967020024', '102', 'Q', '1000', 'S', '2020-05-25 18:17:36', '0');
INSERT INTO `c_route` VALUES ('427', '992020051967020024', '982020020135223988', 'Q', '1000', 'S', '2020-05-25 18:27:34', '0');
INSERT INTO `c_route` VALUES ('428', '992020051967020024', '982019111283640001', 'D', '1000', 'S', '2020-05-27 09:13:03', '0');
INSERT INTO `c_route` VALUES ('429', '8000418004', '982020060103930030', 'Q', '1000', 'S', '2020-06-01 17:56:24', '0');
INSERT INTO `c_route` VALUES ('430', '8000418004', '982020060218850037', 'D', '1000', 'S', '2020-06-02 13:10:45', '0');
INSERT INTO `c_route` VALUES ('431', '8000418004', '982020060291870038', 'D', '1000', 'S', '2020-06-02 13:11:19', '0');
INSERT INTO `c_route` VALUES ('432', '8000418004', '982020060250920039', 'D', '1000', 'S', '2020-06-02 13:11:45', '0');
INSERT INTO `c_route` VALUES ('433', '8000418004', '982020060252710040', 'Q', '1000', 'S', '2020-06-02 13:12:14', '0');
INSERT INTO `c_route` VALUES ('434', '8000418004', '982020060342910001', 'Q', '1000', 'S', '2020-06-03 09:28:46', '0');
INSERT INTO `c_route` VALUES ('435', '8000418004', '982020060362940002', 'Q', '1000', 'S', '2020-06-03 09:29:16', '0');
INSERT INTO `c_route` VALUES ('436', '8000418004', '982020060389780001', 'D', '1000', 'S', '2020-06-03 22:47:00', '0');
INSERT INTO `c_route` VALUES ('437', '8000418004', '982020060364910002', 'D', '1000', 'S', '2020-06-03 22:47:31', '0');
INSERT INTO `c_route` VALUES ('438', '8000418004', '982020060447020001', 'D', '1000', 'S', '2020-06-04 18:33:40', '0');
INSERT INTO `c_route` VALUES ('439', '8000418004', '982020060429110002', 'D', '1000', 'S', '2020-06-04 18:34:11', '0');
INSERT INTO `c_route` VALUES ('440', '8000418004', '982020060400010003', 'D', '1000', 'S', '2020-06-04 18:34:41', '0');
INSERT INTO `c_route` VALUES ('441', '8000418004', '982020060408150004', 'Q', '1000', 'S', '2020-06-04 18:35:09', '0');
INSERT INTO `c_route` VALUES ('442', '992019111758490006', '982020061191360011', 'D', '1000', 'S', '2020-06-11 22:20:45', '0');
INSERT INTO `c_route` VALUES ('443', '992019111758490006', '982020051629810086', 'Q', '1000', 'S', '2020-06-11 22:42:08', '0');
INSERT INTO `c_route` VALUES ('444', '992020061452450002', '127', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('445', '992020061452450002', '36', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('446', '992020061452450002', '982019111845380001', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('447', '992020061452450002', '982019111845380001', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('448', '992020061452450002', '982019112482610001', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('449', '992020061452450002', '982019100547970001', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('450', '992020061452450002', '982019100526010002', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('451', '992020061452450002', '982019090883380001', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('452', '992020061452450002', '99', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('453', '992020061452450002', '982019122942410024', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('454', '992020061452450002', '982019122944790001', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('455', '992020061452450002', '982019123059890001', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('456', '992020061452450002', '982019103184550017', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('457', '992020061452450002', '982019100526010002', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('458', '992020061452450002', '96', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('459', '992020061452450002', '982019103160520014', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('460', '992020061452450002', '982019103116860016', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('461', '992020061452450002', '982019103170230015', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('462', '992020061452450002', '982020010139630001', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('463', '992020061452450002', '982020010266790002', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('464', '992020061452450002', '982019120114520004', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('465', '992020061452450002', '982020010587990008', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('466', '992020061452450002', '982020010765690001', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('467', '992020061452450002', '102', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('468', '992020061452450002', '982020010826510027', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('469', '992020061452450002', '116', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('470', '992020061452450002', '118', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('471', '992020061452450002', '982020011118310003', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('472', '992020061452450002', '123', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('473', '992020061452450002', '982020011309050049', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('474', '992020061452450002', '108', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('475', '992020061452450002', '982020011648620031', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('476', '992020061452450002', '982020012385650006', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('477', '992020061452450002', '104', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('478', '992020061452450002', '982020012700400002', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('479', '992020061452450002', '982020012770640001', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('480', '992020061452450002', '982020020135223988', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('481', '992020061452450002', '109', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('482', '992020061452450002', '982020021078860002', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('483', '992020061452450002', '37', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('484', '992020061452450002', '4', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('485', '992020061452450002', '39', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('486', '992020061452450002', '982020040724360001', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('487', '992020061452450002', '982020041846530004', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('488', '992020061452450002', '982020041854560003', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('489', '992020061452450002', '982020041835100001', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('490', '992020061452450002', '982020041879610002', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('491', '992020061452450002', '982020061191360011', 'D', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('492', '992020061452450002', '982020051629810086', 'Q', '1000', 'S', '2020-06-14 22:05:54', '0');
INSERT INTO `c_route` VALUES ('507', '992020061440050003', '127', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('508', '992020061440050003', '36', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('509', '992020061440050003', '982019111845380001', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('510', '992020061440050003', '982019111845380001', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('511', '992020061440050003', '982019112482610001', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('512', '992020061440050003', '982019100547970001', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('513', '992020061440050003', '982019100526010002', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('514', '992020061440050003', '982019090883380001', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('515', '992020061440050003', '99', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('516', '992020061440050003', '982019122942410024', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('517', '992020061440050003', '982019122944790001', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('518', '992020061440050003', '982019123059890001', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('519', '992020061440050003', '982019103184550017', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('520', '992020061440050003', '982019100526010002', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('521', '992020061440050003', '96', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('522', '992020061440050003', '982019103160520014', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('523', '992020061440050003', '982019103116860016', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('524', '992020061440050003', '982019103170230015', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('525', '992020061440050003', '982020010139630001', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('526', '992020061440050003', '982020010266790002', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('527', '992020061440050003', '982019120114520004', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('528', '992020061440050003', '982020010587990008', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('529', '992020061440050003', '982020010765690001', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('530', '992020061440050003', '102', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('531', '992020061440050003', '982020010826510027', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('532', '992020061440050003', '116', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('533', '992020061440050003', '118', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('534', '992020061440050003', '982020011118310003', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('535', '992020061440050003', '123', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('536', '992020061440050003', '982020011309050049', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('537', '992020061440050003', '108', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('538', '992020061440050003', '982020011648620031', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('539', '992020061440050003', '982020012385650006', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('540', '992020061440050003', '104', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('541', '992020061440050003', '982020012700400002', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('542', '992020061440050003', '982020012770640001', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('543', '992020061440050003', '982020020135223988', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('544', '992020061440050003', '109', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('545', '992020061440050003', '982020021078860002', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('546', '992020061440050003', '37', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('547', '992020061440050003', '4', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('548', '992020061440050003', '39', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('549', '992020061440050003', '982020040724360001', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('550', '992020061440050003', '982020041846530004', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('551', '992020061440050003', '982020041854560003', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('552', '992020061440050003', '982020041835100001', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('553', '992020061440050003', '982020041879610002', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('554', '992020061440050003', '982020061191360011', 'D', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('555', '992020061440050003', '982020051629810086', 'Q', '1000', 'S', '2020-06-14 22:06:37', '0');
INSERT INTO `c_route` VALUES ('570', '992019111758490006', '982020061576260098', 'D', '1000', 'S', '2020-06-15 14:10:58', '0');
INSERT INTO `c_route` VALUES ('571', '992020061452450002', '982020061576260098', 'D', '1000', 'S', '2020-06-15 18:59:49', '0');
INSERT INTO `c_route` VALUES ('572', '992020061452450002', '982020061683430001', 'Q', '1000', 'S', '2020-06-16 14:15:44', '0');
INSERT INTO `c_route` VALUES ('573', '992020061452450002', '982020061677230002', 'D', '1000', 'S', '2020-06-16 14:16:45', '0');
INSERT INTO `c_route` VALUES ('574', '992020061440050003', '982020061683430001', 'Q', '1000', 'S', '2020-06-16 14:17:22', '0');
INSERT INTO `c_route` VALUES ('575', '992020061440050003', '982020061677230002', 'D', '1000', 'S', '2020-06-16 14:17:49', '0');
INSERT INTO `c_route` VALUES ('576', '992019111758490006', '982020061677230002', 'D', '1000', 'S', '2020-06-17 12:40:55', '0');
INSERT INTO `c_route` VALUES ('577', '992019111758490006', '982020061683430001', 'Q', '1000', 'S', '2020-06-17 12:42:24', '0');
INSERT INTO `c_route` VALUES ('578', '8000418004', '982020061707940005', 'Q', '1000', 'S', '2020-06-17 22:44:06', '0');
INSERT INTO `c_route` VALUES ('579', '992020011134400001', '982019122944790001', 'Q', '1000', 'S', '2020-06-18 09:38:32', '0');
INSERT INTO `c_route` VALUES ('580', '8000418004', '982020062041650001', 'D', '1000', 'S', '2020-06-20 15:57:26', '0');
INSERT INTO `c_route` VALUES ('581', '8000418004', '982020062092160052', 'Q', '1000', 'S', '2020-06-20 16:57:24', '0');
INSERT INTO `c_route` VALUES ('582', '8000418004', '982020062093440142', 'Q', '1000', 'S', '2020-06-20 22:56:41', '0');
INSERT INTO `c_route` VALUES ('583', '8000418004', '982020062138880050', 'Q', '1000', 'S', '2020-06-21 19:45:12', '0');
INSERT INTO `c_route` VALUES ('584', '8000418004', '982020062137880007', 'Q', '1000', 'S', '2020-06-21 22:54:41', '0');
INSERT INTO `c_route` VALUES ('585', '8000418004', '982020062202400019', 'Q', '1000', 'S', '2020-06-22 12:03:43', '0');
INSERT INTO `c_route` VALUES ('586', '8000418004', '982020062213250020', 'D', '1000', 'S', '2020-06-22 12:04:15', '0');
INSERT INTO `c_route` VALUES ('587', '8000418004', '982020062254970005', 'D', '1000', 'S', '2020-06-22 21:07:22', '0');
INSERT INTO `c_route` VALUES ('588', '8000418004', '982020062280640006', 'D', '1000', 'S', '2020-06-22 21:07:53', '0');
INSERT INTO `c_route` VALUES ('589', '8000418004', '982020062285120007', 'D', '1000', 'S', '2020-06-22 21:08:24', '0');
INSERT INTO `c_route` VALUES ('590', '8000418004', '982020062257430008', 'Q', '1000', 'S', '2020-06-22 21:09:00', '0');
INSERT INTO `c_route` VALUES ('591', '992020061452450002', '982020062213250020', 'Q', '1000', 'S', '2020-06-23 12:13:56', '0');
INSERT INTO `c_route` VALUES ('592', '992020061452450002', '982020062202400019', 'Q', '1000', 'S', '2020-06-23 12:15:40', '0');
INSERT INTO `c_route` VALUES ('593', '8000418004', '982020062326160530', 'D', '1000', 'S', '2020-06-23 12:25:03', '0');
INSERT INTO `c_route` VALUES ('594', '8000418004', '982020062418200007', 'Q', '1000', 'S', '2020-06-24 19:11:10', '0');
INSERT INTO `c_route` VALUES ('595', '8000418004', '982020062850670014', 'D', '1000', 'S', '2020-06-28 16:19:26', '0');
INSERT INTO `c_route` VALUES ('596', '8000418004', '982020062804280015', 'D', '1000', 'S', '2020-06-28 16:20:00', '0');
INSERT INTO `c_route` VALUES ('597', '8000418004', '982020062873770016', 'D', '1000', 'S', '2020-06-28 16:20:24', '0');
INSERT INTO `c_route` VALUES ('598', '8000418004', '982020062815890017', 'Q', '1000', 'S', '2020-06-28 16:20:50', '0');
INSERT INTO `c_route` VALUES ('599', '8000418004', '982020062879450018', 'D', '1000', 'S', '2020-06-28 16:24:20', '0');
INSERT INTO `c_route` VALUES ('600', '8000418004', '982020062878480019', 'D', '1000', 'S', '2020-06-28 16:25:37', '0');
INSERT INTO `c_route` VALUES ('601', '8000418004', '982020062855740020', 'Q', '1000', 'S', '2020-06-28 16:26:04', '0');
INSERT INTO `c_route` VALUES ('602', '8000418004', '982020062976500015', 'D', '1000', 'S', '2020-06-29 11:25:46', '0');
INSERT INTO `c_route` VALUES ('603', '8000418004', '982020062907450016', 'D', '1000', 'S', '2020-06-29 11:26:26', '0');
INSERT INTO `c_route` VALUES ('604', '8000418004', '982020062997070017', 'D', '1000', 'S', '2020-06-29 11:26:51', '0');
INSERT INTO `c_route` VALUES ('605', '8000418004', '982020062987550018', 'Q', '1000', 'S', '2020-06-29 11:27:16', '0');
INSERT INTO `c_route` VALUES ('606', '8000418004', '982020062925080023', 'D', '1000', 'S', '2020-06-29 12:51:31', '0');
INSERT INTO `c_route` VALUES ('607', '8000418004', '982020063065710018', 'Q', '1000', 'S', '2020-06-30 10:57:59', '0');
INSERT INTO `c_route` VALUES ('608', '8000418004', '982020063055530079', 'Q', '1000', 'S', '2020-06-30 18:31:26', '0');
INSERT INTO `c_route` VALUES ('609', '8000418004', '982020063008480001', 'D', '1000', 'S', '2020-06-30 23:21:51', '0');
INSERT INTO `c_route` VALUES ('610', '8000418004', '982020070110680002', 'Q', '1000', 'S', '2020-07-01 09:16:16', '0');
INSERT INTO `c_route` VALUES ('611', '8000418004', '982020070115850003', 'Q', '1000', 'S', '2020-07-01 09:27:33', '0');
INSERT INTO `c_route` VALUES ('612', '8000418004', '9820200701981412368', 'D', '1000', 'S', '2020-07-01 11:49:55', '0');
INSERT INTO `c_route` VALUES ('613', '8000418004', '9820200701134712400', 'Q', '1000', 'S', '2020-07-01 18:49:18', '0');
INSERT INTO `c_route` VALUES ('614', '8000418004', '982020070298920030', 'D', '1000', 'S', '2020-07-02 13:33:53', '0');
INSERT INTO `c_route` VALUES ('615', '992019111758490006', '83', 'Q', '1000', 'S', '2020-07-03 14:31:34', '0');
INSERT INTO `c_route` VALUES ('616', '992019111758490006', '87', 'Q', '1000', 'S', '2020-07-04 14:04:18', '0');
INSERT INTO `c_route` VALUES ('617', '992019111758490006', '982020062815890017', 'Q', '1000', 'S', '2020-07-04 14:45:18', '0');
INSERT INTO `c_route` VALUES ('618', '992019111758490006', '982020070110680002', 'Q', '1000', 'S', '2020-07-04 17:06:29', '0');
INSERT INTO `c_route` VALUES ('619', '992019111758490006', '982020070115850003', 'Q', '1000', 'S', '2020-07-04 17:06:49', '0');
INSERT INTO `c_route` VALUES ('620', '992019111758490006', '982020063055530079', 'Q', '1000', 'S', '2020-07-04 19:25:09', '0');
INSERT INTO `c_route` VALUES ('621', '992019111758490006', '982019100575550004', 'D', '1000', 'S', '2020-07-04 20:21:07', '0');
INSERT INTO `c_route` VALUES ('622', '992019111758490006', '982020063008480001', 'D', '1000', 'S', '2020-07-05 15:34:38', '0');
INSERT INTO `c_route` VALUES ('623', '992020011134400001', '982020051629810086', 'Q', '1000', 'S', '2020-07-05 16:44:13', '0');
INSERT INTO `c_route` VALUES ('624', '992019111758490006', '982020070818830001', 'D', '1000', 'S', '2020-07-08 13:38:12', '0');
INSERT INTO `c_route` VALUES ('625', '8000418004', '982019123059890001', 'D', '1000', 'S', '2020-07-09 09:10:59', '0');
INSERT INTO `c_route` VALUES ('626', '8000418004', '982020071343700060', 'Q', '1000', 'S', '2020-07-13 09:22:04', '0');
INSERT INTO `c_route` VALUES ('627', '8000418004', '982020071336500122', 'D', '1000', 'S', '2020-07-13 13:17:48', '0');
INSERT INTO `c_route` VALUES ('628', '8000418004', '982020071597810027', 'Q', '1000', 'S', '2020-07-15 13:11:53', '0');
INSERT INTO `c_route` VALUES ('629', '8000418004', '982020071505280046', 'D', '1000', 'S', '2020-07-15 16:44:36', '0');
INSERT INTO `c_route` VALUES ('630', '992020061452450002', '982020062815890017', 'Q', '1000', 'S', '2020-07-15 18:03:33', '0');
INSERT INTO `c_route` VALUES ('631', '992020061440050003', '982020062815890017', 'Q', '1000', 'S', '2020-07-15 18:04:55', '0');
INSERT INTO `c_route` VALUES ('632', '8000418004', '982020071566010006', 'Q', '1000', 'S', '2020-07-15 19:00:28', '0');
INSERT INTO `c_route` VALUES ('633', '8000418004', '982020071641600010', 'D', '1000', 'S', '2020-07-16 10:50:49', '0');
INSERT INTO `c_route` VALUES ('634', '8000418004', '982020071660960016', 'Q', '1000', 'S', '2020-07-16 12:17:26', '0');
INSERT INTO `c_route` VALUES ('635', '8000418004', '982020071675380019', 'D', '1000', 'S', '2020-07-16 13:37:42', '0');
INSERT INTO `c_route` VALUES ('636', '8000418004', '982020071634270045', 'Q', '1000', 'S', '2020-07-16 17:14:42', '0');
INSERT INTO `c_route` VALUES ('637', '8000418004', '982020071796830006', 'D', '1000', 'S', '2020-07-17 09:42:46', '0');
INSERT INTO `c_route` VALUES ('638', '8000418004', '982020071797180007', 'D', '1000', 'S', '2020-07-17 09:43:31', '0');
INSERT INTO `c_route` VALUES ('639', '8000418004', '982020071786710008', 'D', '1000', 'S', '2020-07-17 09:44:18', '0');
INSERT INTO `c_route` VALUES ('640', '8000418004', '982020071766110009', 'Q', '1000', 'S', '2020-07-17 09:45:27', '0');
INSERT INTO `c_route` VALUES ('641', '992020061452450002', '982020070115850003', 'Q', '1000', 'S', '2020-07-25 10:51:43', '0');
INSERT INTO `c_route` VALUES ('642', '992020061452450002', '982020063055530079', 'Q', '1000', 'S', '2020-07-25 10:52:44', '0');
INSERT INTO `c_route` VALUES ('643', '992020022270580001', '982020063055530079', 'Q', '1000', 'S', '2020-07-25 11:00:49', '0');
INSERT INTO `c_route` VALUES ('644', '992020022270580001', '982020070110680002', 'Q', '1000', 'S', '2020-07-25 12:57:46', '0');
INSERT INTO `c_route` VALUES ('645', '992020022270580001', '982020070115850003', 'Q', '1000', 'S', '2020-07-25 18:27:08', '0');
INSERT INTO `c_route` VALUES ('646', '992020022270580001', '982020062855740020', 'Q', '1000', 'S', '2020-07-25 22:15:09', '0');
INSERT INTO `c_route` VALUES ('647', '992020022270580001', '982020063008480001', 'D', '1000', 'S', '2020-07-25 23:10:36', '0');
INSERT INTO `c_route` VALUES ('648', '992020022270580001', '9820200701981412368', 'D', '1000', 'S', '2020-07-27 08:49:34', '0');
INSERT INTO `c_route` VALUES ('649', '992020022270580001', '982020070818830001', 'D', '1000', 'S', '2020-07-27 09:20:34', '0');
INSERT INTO `c_route` VALUES ('650', '992020022270580001', '982020013076830001', 'Q', '1000', 'S', '2020-07-28 00:30:45', '0');
INSERT INTO `c_route` VALUES ('651', '992020022270580001', '982020020135223988', 'Q', '1000', 'S', '2020-07-28 00:42:40', '0');
INSERT INTO `c_route` VALUES ('652', '992020022270580001', '109', 'Q', '1000', 'S', '2020-07-28 01:18:43', '0');
INSERT INTO `c_route` VALUES ('653', '992019111758490006', '982020062137880007', 'Q', '1000', 'S', '2020-07-31 23:12:23', '0');
INSERT INTO `c_route` VALUES ('654', '992020022270580001', '982020062137880007', 'Q', '1000', 'S', '2020-07-31 23:12:50', '0');
INSERT INTO `c_route` VALUES ('655', '992020061452450002', '982020062137880007', 'Q', '1000', 'S', '2020-07-31 23:13:32', '0');
INSERT INTO `c_route` VALUES ('656', '992020061440050003', '982020062137880007', 'Q', '1000', 'S', '2020-07-31 23:13:58', '0');
INSERT INTO `c_route` VALUES ('657', '992019111758490006', '982019110370410008', 'Q', '1000', 'S', '2020-08-01 00:43:41', '0');
INSERT INTO `c_route` VALUES ('658', '992020061452450002', '982019110370410008', 'Q', '1000', 'S', '2020-08-01 00:44:11', '0');
INSERT INTO `c_route` VALUES ('659', '992020061440050003', '982019110370410008', 'Q', '1000', 'S', '2020-08-01 00:44:41', '0');
INSERT INTO `c_route` VALUES ('660', '992019111758490006', '982019110412600001', 'D', '1000', 'S', '2020-08-01 01:11:42', '0');
INSERT INTO `c_route` VALUES ('661', '992020061452450002', '982019110412600001', 'D', '1000', 'S', '2020-08-01 01:12:09', '0');
INSERT INTO `c_route` VALUES ('662', '992020061440050003', '982019110412600001', 'D', '1000', 'S', '2020-08-01 01:12:37', '0');
INSERT INTO `c_route` VALUES ('663', '992019111758490006', '982020080286050033', 'Q', '1000', 'S', '2020-08-02 16:07:46', '0');
INSERT INTO `c_route` VALUES ('664', '992020061452450002', '982020080286050033', 'Q', '1000', 'S', '2020-08-02 16:08:12', '0');
INSERT INTO `c_route` VALUES ('665', '992020061440050003', '982020080286050033', 'Q', '1000', 'S', '2020-08-02 16:08:31', '0');
INSERT INTO `c_route` VALUES ('666', '8000418004', '982020080367760044', 'Q', '1000', 'S', '2020-08-03 16:05:16', '0');
INSERT INTO `c_route` VALUES ('667', '8000418004', '982020080449680142', 'D', '1000', 'S', '2020-08-04 21:11:30', '0');
INSERT INTO `c_route` VALUES ('668', '8000418004', '982020080770360040', 'D', '1000', 'S', '2020-08-07 15:37:52', '0');
INSERT INTO `c_route` VALUES ('669', '8000418004', '982020080806890065', 'Q', '1000', 'S', '2020-08-08 14:16:42', '0');
INSERT INTO `c_route` VALUES ('670', '8000418004', '982020080820520066', 'Q', '1000', 'S', '2020-08-08 14:21:57', '0');
INSERT INTO `c_route` VALUES ('671', '8000418004', '982020081053370103', 'Q', '1000', 'S', '2020-08-10 16:48:35', '0');
INSERT INTO `c_route` VALUES ('672', '8000418004', '982020081030740105', 'Q', '1000', 'S', '2020-08-10 16:58:13', '0');
INSERT INTO `c_route` VALUES ('673', '8000418004', '982020081044700106', 'Q', '1000', 'S', '2020-08-10 16:59:30', '0');
INSERT INTO `c_route` VALUES ('674', '8000418004', '982020081062200107', 'Q', '1000', 'S', '2020-08-10 17:00:13', '0');
INSERT INTO `c_route` VALUES ('675', '8000418004', '982020081006890108', 'Q', '1000', 'S', '2020-08-10 17:00:53', '0');
INSERT INTO `c_route` VALUES ('676', '8000418004', '982020081085070002', 'Q', '1000', 'S', '2020-08-10 19:05:57', '0');
INSERT INTO `c_route` VALUES ('677', '992019111758490006', '982020020845600001', 'D', '1000', 'S', '2020-08-13 12:23:16', '0');
INSERT INTO `c_route` VALUES ('678', '992020061452450002', '982020020845600001', 'D', '1000', 'S', '2020-08-13 12:24:07', '0');
INSERT INTO `c_route` VALUES ('679', '992020061440050003', '982020020845600001', 'D', '1000', 'S', '2020-08-13 12:24:49', '0');
INSERT INTO `c_route` VALUES ('680', '8000418004', '982020081389290288', 'Q', '1000', 'S', '2020-08-13 21:41:38', '0');
INSERT INTO `c_route` VALUES ('681', '8000418004', '982020081389290288', 'Q', '1000', 'S', '2020-08-14 22:25:11', '0');
INSERT INTO `c_route` VALUES ('682', '8000418004', '982020081454600213', 'D', '1000', 'S', '2020-08-14 22:29:14', '0');
INSERT INTO `c_route` VALUES ('683', '8000418004', '982020081477550214', 'D', '1000', 'S', '2020-08-14 22:29:46', '0');
INSERT INTO `c_route` VALUES ('684', '8000418004', '982020081471410215', 'D', '1000', 'S', '2020-08-14 22:30:23', '0');
INSERT INTO `c_route` VALUES ('685', '8000418004', '982020081445150216', 'D', '1000', 'S', '2020-08-14 23:20:25', '0');
INSERT INTO `c_route` VALUES ('686', '8000418004', '982020081400430217', 'D', '1000', 'S', '2020-08-14 23:20:58', '0');
INSERT INTO `c_route` VALUES ('687', '8000418004', '982020081481790218', 'D', '1000', 'S', '2020-08-14 23:21:25', '0');
INSERT INTO `c_route` VALUES ('688', '8000418004', '982020081440160221', 'Q', '1000', 'S', '2020-08-14 23:30:03', '0');
INSERT INTO `c_route` VALUES ('689', '992019111758490006', '982020081652980249', 'D', '1000', 'S', '2020-08-16 22:16:46', '0');
INSERT INTO `c_route` VALUES ('690', '8000418004', '982020082117774014', 'Q', '1000', 'S', '2020-08-21 21:50:57', '0');
INSERT INTO `c_route` VALUES ('691', '8000418004', '982020082335720069', 'Q', '1000', 'S', '2020-08-23 13:46:17', '0');
INSERT INTO `c_route` VALUES ('692', '8000418004', '982020082519578065', 'Q', '1000', 'S', '2020-08-25 11:39:53', '0');
INSERT INTO `c_route` VALUES ('693', '8000418004', '982020082562868066', 'D', '1000', 'S', '2020-08-25 11:43:04', '0');
INSERT INTO `c_route` VALUES ('694', '8000418004', '982020082573308067', 'D', '1000', 'S', '2020-08-25 11:43:56', '0');
INSERT INTO `c_route` VALUES ('695', '8000418004', '982020082515698068', 'D', '1000', 'S', '2020-08-25 11:44:29', '0');
INSERT INTO `c_route` VALUES ('696', '8000418004', '982020082763340009', 'Q', '1000', 'S', '2020-08-27 15:28:50', '0');
INSERT INTO `c_route` VALUES ('697', '8000418004', '982020082757960010', 'D', '1000', 'S', '2020-08-27 15:30:30', '0');
INSERT INTO `c_route` VALUES ('698', '8000418004', '982020082710220011', 'D', '1000', 'S', '2020-08-27 15:31:17', '0');
INSERT INTO `c_route` VALUES ('699', '8000418004', '982020082812820070', 'Q', '1000', 'S', '2020-08-28 15:28:45', '0');
INSERT INTO `c_route` VALUES ('700', '8000418004', '982020082842860079', 'D', '1000', 'S', '2020-08-28 16:53:20', '0');
INSERT INTO `c_route` VALUES ('701', '8000418004', '982020082948620007', 'D', '1000', 'S', '2020-08-29 15:00:13', '0');
INSERT INTO `c_route` VALUES ('702', '8000418004', '982020082951720004', 'D', '1000', 'S', '2020-08-29 16:49:17', '0');
INSERT INTO `c_route` VALUES ('703', '8000418004', '982020082959340001', 'D', '1000', 'S', '2020-08-29 17:43:55', '0');
INSERT INTO `c_route` VALUES ('704', '8000418004', '982020082928580003', 'D', '1000', 'S', '2020-08-29 18:59:25', '0');
INSERT INTO `c_route` VALUES ('705', '8000418004', '982020090469850050', 'D', '1000', 'S', '2020-09-04 16:45:48', '0');
INSERT INTO `c_route` VALUES ('706', '8000418004', '982020090626360033', 'Q', '1000', 'S', '2020-09-06 20:17:06', '0');
INSERT INTO `c_route` VALUES ('707', '992019111758490006', '982020082519578065', 'Q', '1000', 'S', '2020-09-08 23:28:59', '0');
INSERT INTO `c_route` VALUES ('708', '992020061440050003', '982020082519578065', 'Q', '1000', 'S', '2020-09-08 23:29:25', '0');
INSERT INTO `c_route` VALUES ('709', '992020061452450002', '982020082519578065', 'Q', '1000', 'S', '2020-09-08 23:29:44', '0');
INSERT INTO `c_route` VALUES ('710', '992019111758490006', '982020082757960010', 'D', '1000', 'S', '2020-09-09 09:14:17', '0');
INSERT INTO `c_route` VALUES ('711', '992020061440050003', '982020082757960010', 'D', '1000', 'S', '2020-09-09 09:14:37', '0');
INSERT INTO `c_route` VALUES ('712', '992020061452450002', '982020082757960010', 'D', '1000', 'S', '2020-09-09 09:14:55', '0');
INSERT INTO `c_route` VALUES ('713', '8000418004', '982020090946460048', 'D', '1000', 'S', '2020-09-09 16:38:36', '0');
INSERT INTO `c_route` VALUES ('714', '8000418004', '982020091083540011', 'D', '1000', 'S', '2020-09-10 14:04:17', '0');
INSERT INTO `c_route` VALUES ('715', '8000418004', '982020091052290012', 'D', '1000', 'S', '2020-09-10 14:05:18', '0');
INSERT INTO `c_route` VALUES ('716', '8000418004', '982020091094380013', 'D', '1000', 'S', '2020-09-10 14:05:45', '0');
INSERT INTO `c_route` VALUES ('717', '8000418004', '982020091010110014', 'D', '1000', 'S', '2020-09-10 14:06:17', '0');
INSERT INTO `c_route` VALUES ('718', '8000418004', '982020091018130070', 'D', '1000', 'S', '2020-09-10 23:31:19', '0');
INSERT INTO `c_route` VALUES ('719', '8000418004', '982020091281310069', 'D', '1000', 'S', '2020-09-12 17:09:53', '0');
INSERT INTO `c_route` VALUES ('720', '8000418004', '982020091313660093', 'D', '1000', 'S', '2020-09-13 13:20:59', '0');
INSERT INTO `c_route` VALUES ('721', '8000418004', '982020091364000094', 'D', '1000', 'S', '2020-09-13 13:21:35', '0');
INSERT INTO `c_route` VALUES ('722', '8000418004', '982020091338000095', 'D', '1000', 'S', '2020-09-13 13:22:04', '0');
INSERT INTO `c_route` VALUES ('723', '8000418004', '982020091385930096', 'Q', '1000', 'S', '2020-09-13 13:22:42', '0');
INSERT INTO `c_route` VALUES ('724', '8000418004', '982020091370130001', 'D', '1000', 'S', '2020-09-13 20:07:22', '0');
INSERT INTO `c_route` VALUES ('725', '8000418004', '982020091328710002', 'D', '1000', 'S', '2020-09-13 20:07:59', '0');
INSERT INTO `c_route` VALUES ('726', '8000418004', '982020091383110003', 'Q', '1000', 'S', '2020-09-13 20:08:49', '0');
INSERT INTO `c_route` VALUES ('727', '8000418004', '982020091501250101', 'D', '1000', 'S', '2020-09-15 16:51:07', '0');
INSERT INTO `c_route` VALUES ('728', '992019111758490006', '982020082763340009', 'Q', '1000', 'S', '2020-09-17 10:33:20', '0');
INSERT INTO `c_route` VALUES ('729', '992020011134400001', '982020091745210059', 'D', '1000', 'S', '2020-09-17 10:57:09', '0');
INSERT INTO `c_route` VALUES ('730', '8000418004', '982020091840960068', 'D', '1000', 'S', '2020-09-18 15:58:33', '0');
INSERT INTO `c_route` VALUES ('731', '8000418004', '982020091888140069', 'D', '1000', 'S', '2020-09-18 15:59:05', '0');
INSERT INTO `c_route` VALUES ('732', '8000418004', '982020091880820070', 'D', '1000', 'S', '2020-09-18 15:59:40', '0');
INSERT INTO `c_route` VALUES ('733', '8000418004', '982020091851340071', 'D', '1000', 'S', '2020-09-18 16:00:14', '0');
INSERT INTO `c_route` VALUES ('734', '8000418004', '982020091886840072', 'D', '1000', 'S', '2020-09-18 16:00:48', '0');
INSERT INTO `c_route` VALUES ('735', '8000418004', '982020091836100073', 'D', '1000', 'S', '2020-09-18 16:01:16', '0');
INSERT INTO `c_route` VALUES ('736', '8000418004', '982020091834890074', 'D', '1000', 'S', '2020-09-18 16:01:41', '0');
INSERT INTO `c_route` VALUES ('737', '8000418004', '982020091855050075', 'Q', '1000', 'S', '2020-09-18 16:02:09', '0');
INSERT INTO `c_route` VALUES ('738', '8000418004', '982020091893060082', 'D', '1000', 'S', '2020-09-18 20:33:12', '0');
INSERT INTO `c_route` VALUES ('739', '8000418004', '982020091870840083', 'D', '1000', 'S', '2020-09-18 20:33:51', '0');
INSERT INTO `c_route` VALUES ('740', '8000418004', '982020091805300084', 'D', '1000', 'S', '2020-09-18 20:34:28', '0');
INSERT INTO `c_route` VALUES ('741', '8000418004', '982020091891800085', 'Q', '1000', 'S', '2020-09-18 20:36:05', '0');
INSERT INTO `c_route` VALUES ('742', '992020061452450002', '982020070818830001', 'D', '1000', 'S', '2020-09-18 22:51:12', '0');
INSERT INTO `c_route` VALUES ('743', '8000418004', '982020092075060020', 'Q', '1000', 'S', '2020-09-20 10:07:15', '0');
INSERT INTO `c_route` VALUES ('744', '8000418004', '982020092166010445', 'D', '1000', 'S', '2020-09-21 17:56:28', '0');
INSERT INTO `c_route` VALUES ('745', '8000418004', '982020092127990484', 'Q', '1000', 'S', '2020-09-21 21:50:40', '0');
INSERT INTO `c_route` VALUES ('746', '8000418004', '982020092188940485', 'D', '1000', 'S', '2020-09-21 21:51:20', '0');
INSERT INTO `c_route` VALUES ('747', '8000418004', '982020092165420486', 'D', '1000', 'S', '2020-09-21 21:51:51', '0');
INSERT INTO `c_route` VALUES ('748', '8000418004', '982020092228410736', 'D', '1000', 'S', '2020-09-22 16:35:37', '0');
INSERT INTO `c_route` VALUES ('749', '8000418004', '982020092292090737', 'D', '1000', 'S', '2020-09-22 16:36:16', '0');
INSERT INTO `c_route` VALUES ('750', '8000418004', '982020092243490738', 'D', '1000', 'S', '2020-09-22 16:36:46', '0');
INSERT INTO `c_route` VALUES ('751', '8000418004', '982020092287640739', 'Q', '1000', 'S', '2020-09-22 16:37:14', '0');
INSERT INTO `c_route` VALUES ('752', '8000418004', '982020092304237360', 'D', '1000', 'S', '2020-09-23 15:47:01', '0');
INSERT INTO `c_route` VALUES ('753', '8000418004', '982020092358777361', 'Q', '1000', 'S', '2020-09-23 15:49:28', '0');
INSERT INTO `c_route` VALUES ('754', '992019111758490006', '111', 'Q', '1000', 'S', '2020-09-23 20:33:06', '0');
INSERT INTO `c_route` VALUES ('755', '8000418004', '982020092405950345', 'D', '1000', 'S', '2020-09-24 16:17:10', '0');
INSERT INTO `c_route` VALUES ('756', '8000418004', '982020092497550347', 'Q', '1000', 'S', '2020-09-24 16:17:57', '0');
INSERT INTO `c_route` VALUES ('757', '8000418004', '982020092423290368', 'Q', '1000', 'S', '2020-09-24 17:16:23', '0');
INSERT INTO `c_route` VALUES ('758', '8000418004', '982020092435760379', 'D', '1000', 'S', '2020-09-24 18:00:07', '0');
INSERT INTO `c_route` VALUES ('759', '8000418004', '982020092442770389', 'D', '1000', 'S', '2020-09-24 18:27:28', '0');
INSERT INTO `c_route` VALUES ('760', '8000418004', '982020092433790462', 'Q', '1000', 'S', '2020-09-24 23:56:45', '0');
INSERT INTO `c_route` VALUES ('761', '992019111758490006', '982020080367760044', 'Q', '1000', 'S', '2020-09-25 09:31:00', '0');
INSERT INTO `c_route` VALUES ('762', '992020061440050003', '982020080367760044', 'Q', '1000', 'S', '2020-09-25 09:31:25', '0');
INSERT INTO `c_route` VALUES ('763', '992020061452450002', '982020080367760044', 'Q', '1000', 'S', '2020-09-25 09:31:46', '0');
INSERT INTO `c_route` VALUES ('764', '992019111758490006', '982020082948620007', 'Q', '1000', 'S', '2020-09-25 10:24:55', '0');
INSERT INTO `c_route` VALUES ('765', '992020011134400001', '982020080449680142', 'D', '1000', 'S', '2020-09-25 12:13:51', '0');
INSERT INTO `c_route` VALUES ('766', '992020022270580001', '982020080367760044', 'Q', '1000', 'S', '2020-09-25 15:28:22', '0');
INSERT INTO `c_route` VALUES ('767', '992019111758490006', '982020082812820070', 'Q', '1000', 'S', '2020-09-25 16:28:53', '0');
INSERT INTO `c_route` VALUES ('768', '8000418004', '982020092653090917', 'Q', '1000', 'S', '2020-09-26 18:47:39', '0');
INSERT INTO `c_route` VALUES ('769', '8000418004', '982020092739440134', 'D', '1000', 'S', '2020-09-27 15:46:58', '0');
INSERT INTO `c_route` VALUES ('770', '992019111758490006', '982020091313660093', 'D', '1000', 'S', '2020-09-29 10:18:55', '0');
INSERT INTO `c_route` VALUES ('771', '992020061452450002', '982020091313660093', 'D', '1000', 'S', '2020-09-29 10:19:20', '0');
INSERT INTO `c_route` VALUES ('772', '992020061440050003', '982020091313660093', 'D', '1000', 'S', '2020-09-29 10:19:40', '0');
INSERT INTO `c_route` VALUES ('773', '992020022270580001', '982020062987550018', 'Q', '1000', 'S', '2020-09-30 13:46:49', '0');
INSERT INTO `c_route` VALUES ('774', '8000418004', '982020093025850723', 'Q', '1000', 'S', '2020-09-30 17:28:31', '0');
INSERT INTO `c_route` VALUES ('775', '992020061452450002', '982020082763340009', 'Q', '1000', 'S', '2020-09-30 22:04:38', '0');
INSERT INTO `c_route` VALUES ('776', '8000418004', '982020100126360810', 'D', '1000', 'S', '2020-10-01 12:10:06', '0');
INSERT INTO `c_route` VALUES ('777', '8000418004', '982020100411170125', 'Q', '1000', 'S', '2020-10-04 13:12:42', '0');
INSERT INTO `c_route` VALUES ('778', '8000418004', '982020100497190126', 'D', '1000', 'S', '2020-10-04 13:13:30', '0');
INSERT INTO `c_route` VALUES ('779', '8000418004', '982020100434530127', 'D', '1000', 'S', '2020-10-04 13:14:13', '0');
INSERT INTO `c_route` VALUES ('780', '8000418004', '982020100475670128', 'D', '1000', 'S', '2020-10-04 13:14:52', '0');
INSERT INTO `c_route` VALUES ('781', '992019111758490006', '982020100411170125', 'Q', '1000', 'S', '2020-10-04 21:56:39', '0');
INSERT INTO `c_route` VALUES ('782', '992020061452450002', '982020100411170125', 'Q', '1000', 'S', '2020-10-04 21:57:09', '0');
INSERT INTO `c_route` VALUES ('783', '992020061440050003', '982020100411170125', 'Q', '1000', 'S', '2020-10-04 21:57:40', '0');
INSERT INTO `c_route` VALUES ('784', '8000418004', '982020100429730043', 'Q', '1000', 'S', '2020-10-04 23:23:07', '0');
INSERT INTO `c_route` VALUES ('785', '8000418004', '982020100435160044', 'D', '1000', 'S', '2020-10-04 23:23:50', '0');
INSERT INTO `c_route` VALUES ('786', '8000418004', '982020100429370045', 'D', '1000', 'S', '2020-10-04 23:24:22', '0');
INSERT INTO `c_route` VALUES ('787', '8000418004', '982020100421040046', 'D', '1000', 'S', '2020-10-04 23:25:04', '0');
INSERT INTO `c_route` VALUES ('788', '8000418004', '982020101081480186', 'Q', '1000', 'S', '2020-10-10 00:04:00', '0');
INSERT INTO `c_route` VALUES ('789', '8000418004', '982020101061440187', 'D', '1000', 'S', '2020-10-10 00:05:43', '0');
INSERT INTO `c_route` VALUES ('790', '8000418004', '982020101054670194', 'D', '1000', 'S', '2020-10-10 00:59:10', '0');
INSERT INTO `c_route` VALUES ('791', '8000418004', '982020101074420195', 'D', '1000', 'S', '2020-10-10 00:59:45', '0');
INSERT INTO `c_route` VALUES ('792', '8000418004', '982020101083710196', 'D', '1000', 'S', '2020-10-10 01:00:55', '0');
INSERT INTO `c_route` VALUES ('793', '8000418004', '982020101082160197', 'D', '1000', 'S', '2020-10-10 01:01:21', '0');
INSERT INTO `c_route` VALUES ('794', '8000418004', '982020101022330198', 'D', '1000', 'S', '2020-10-10 01:01:47', '0');
INSERT INTO `c_route` VALUES ('795', '8000418004', '982020101035970199', 'Q', '1000', 'S', '2020-10-10 01:02:13', '0');
INSERT INTO `c_route` VALUES ('796', '8000418004', '982020101015720457', 'Q', '1000', 'S', '2020-10-10 19:31:08', '0');
INSERT INTO `c_route` VALUES ('797', '8000418004', '982020101083790462', 'D', '1000', 'S', '2020-10-10 19:42:00', '0');
INSERT INTO `c_route` VALUES ('798', '8000418004', '982020101013520464', 'D', '1000', 'S', '2020-10-10 19:42:37', '0');
INSERT INTO `c_route` VALUES ('799', '8000418004', '982020101055900465', 'D', '1000', 'S', '2020-10-10 19:43:07', '0');
INSERT INTO `c_route` VALUES ('800', '8000418004', '982020101347900319', 'D', '1000', 'S', '2020-10-13 18:35:24', '0');
INSERT INTO `c_route` VALUES ('801', '8000418004', '982020101496180168', 'D', '1000', 'S', '2020-10-14 21:11:06', '0');
INSERT INTO `c_route` VALUES ('802', '8000418004', '982020101498870169', 'D', '1000', 'S', '2020-10-14 21:12:54', '0');
INSERT INTO `c_route` VALUES ('803', '8000418004', '982020101467460172', 'Q', '1000', 'S', '2020-10-14 21:15:21', '0');
INSERT INTO `c_route` VALUES ('804', '8000418004', '982020101772490255', 'Q', '1000', 'S', '2020-10-17 11:56:58', '0');
INSERT INTO `c_route` VALUES ('805', '8000418004', '982020101749080330', 'Q', '1000', 'S', '2020-10-17 17:59:11', '0');
INSERT INTO `c_route` VALUES ('806', '8000418004', '982020101781320337', 'Q', '1000', 'S', '2020-10-17 18:22:20', '0');
INSERT INTO `c_route` VALUES ('807', '8000418004', '982020101734620341', 'Q', '1000', 'S', '2020-10-17 18:42:30', '0');
INSERT INTO `c_route` VALUES ('808', '8000418004', '982020101823470460', 'Q', '1000', 'S', '2020-10-18 15:01:42', '0');
INSERT INTO `c_route` VALUES ('809', '8000418004', '982020101932980694', 'Q', '1000', 'S', '2020-10-19 13:50:10', '0');
INSERT INTO `c_route` VALUES ('810', '8000418004', '982020101960770760', 'Q', '1000', 'S', '2020-10-19 15:22:23', '0');
INSERT INTO `c_route` VALUES ('811', '8000418004', '982020101944670826', 'Q', '1000', 'S', '2020-10-19 16:46:20', '0');
INSERT INTO `c_route` VALUES ('812', '8000418004', '982020102035331080', 'Q', '1000', 'S', '2020-10-20 14:42:58', '0');
INSERT INTO `c_route` VALUES ('813', '8000418004', '982020102030491116', 'D', '1000', 'S', '2020-10-20 15:23:47', '0');
INSERT INTO `c_route` VALUES ('814', '8000418004', '982020102028171129', 'Q', '1000', 'S', '2020-10-20 15:35:57', '0');
INSERT INTO `c_route` VALUES ('815', '8000418004', '982020102010111219', 'Q', '1000', 'S', '2020-10-20 17:53:11', '0');
INSERT INTO `c_route` VALUES ('816', '8000418004', '982020102107710025', 'Q', '1000', 'S', '2020-10-21 13:58:12', '0');
INSERT INTO `c_route` VALUES ('817', '8000418004', '982020102141090102', 'D', '1000', 'S', '2020-10-21 15:33:16', '0');
INSERT INTO `c_route` VALUES ('818', '992019111758490006', '56', 'Q', '1000', 'S', '2020-10-24 09:43:02', '0');
INSERT INTO `c_route` VALUES ('819', '8000418004', '982020102413010403', 'D', '1000', 'S', '2020-10-24 18:39:19', '0');
INSERT INTO `c_route` VALUES ('820', '8000418004', '982020102480700405', 'D', '1000', 'S', '2020-10-24 18:54:45', '0');
INSERT INTO `c_route` VALUES ('821', '8000418004', '982020102496170427', 'Q', '1000', 'S', '2020-10-24 22:45:29', '0');
INSERT INTO `c_route` VALUES ('822', '8000418004', '982020102516180473', 'Q', '1000', 'S', '2020-10-25 10:42:40', '0');
INSERT INTO `c_route` VALUES ('823', '8000418004', '982020102749940089', 'Q', '1000', 'S', '2020-10-27 18:00:28', '0');
INSERT INTO `c_route` VALUES ('824', '8000418004', '982020102876990281', 'D', '1000', 'S', '2020-10-28 11:40:29', '0');
INSERT INTO `c_route` VALUES ('825', '8000418004', '982020102807810286', 'D', '1000', 'S', '2020-10-28 11:52:31', '0');
INSERT INTO `c_route` VALUES ('826', '992019111758490006', '982020102749940089', 'Q', '1000', 'S', '2020-10-28 12:27:51', '0');
INSERT INTO `c_route` VALUES ('827', '992020061452450002', '982020102749940089', 'Q', '1000', 'S', '2020-10-28 12:28:27', '0');
INSERT INTO `c_route` VALUES ('828', '992020061440050003', '982020102749940089', 'Q', '1000', 'S', '2020-10-28 12:28:49', '0');
INSERT INTO `c_route` VALUES ('829', '992019111758490006', '982020102107710025', 'Q', '1000', 'S', '2020-10-28 14:42:31', '0');
INSERT INTO `c_route` VALUES ('830', '992020061452450002', '982020102107710025', 'Q', '1000', 'S', '2020-10-28 14:42:58', '0');
INSERT INTO `c_route` VALUES ('831', '992020061440050003', '982020102107710025', 'Q', '1000', 'S', '2020-10-28 14:43:18', '0');
INSERT INTO `c_route` VALUES ('832', '8000418004', '982020101015720457', 'Q', '1000', 'S', '2020-10-28 22:04:39', '0');
INSERT INTO `c_route` VALUES ('833', '992019111758490006', '982020101015720457', 'Q', '1000', 'S', '2020-10-28 22:05:19', '0');
INSERT INTO `c_route` VALUES ('834', '992020061452450002', '982020101015720457', 'Q', '1000', 'S', '2020-10-28 22:05:48', '0');
INSERT INTO `c_route` VALUES ('835', '992020061440050003', '982020101015720457', 'Q', '1000', 'S', '2020-10-28 22:06:07', '0');
INSERT INTO `c_route` VALUES ('836', '992020061452450002', '83', 'Q', '1000', 'S', '2020-10-29 10:24:47', '0');
INSERT INTO `c_route` VALUES ('837', '992020061440050003', '83', 'Q', '1000', 'S', '2020-10-29 10:25:08', '0');
INSERT INTO `c_route` VALUES ('838', '992020061452450002', '56', 'Q', '1000', 'S', '2020-11-03 09:06:57', '0');
INSERT INTO `c_route` VALUES ('839', '992020061440050003', '56', 'Q', '1000', 'S', '2020-11-03 09:07:20', '0');
INSERT INTO `c_route` VALUES ('840', '992020061452450002', '982020082812820070', 'Q', '1000', 'S', '2020-11-03 09:08:30', '0');
INSERT INTO `c_route` VALUES ('841', '992020061440050003', '982020082812820070', 'Q', '1000', 'S', '2020-11-03 09:08:48', '0');
INSERT INTO `c_route` VALUES ('842', '992019111758490006', '982020110300660945', 'D', '1000', 'S', '2020-11-03 16:27:05', '0');
INSERT INTO `c_route` VALUES ('843', '992020061452450002', '982020110300660945', 'D', '1000', 'S', '2020-11-03 16:39:07', '0');
INSERT INTO `c_route` VALUES ('844', '992020061440050003', '982020110300660945', 'D', '1000', 'S', '2020-11-03 16:39:24', '0');
INSERT INTO `c_route` VALUES ('845', '992020051967020024', '982020110461001391', 'D', '1000', 'S', '2020-11-04 17:40:10', '0');
INSERT INTO `c_route` VALUES ('846', '992019111758490006', '982020110691880475', 'Q', '1000', 'S', '2020-11-06 10:13:59', '0');
INSERT INTO `c_route` VALUES ('847', '992020061452450002', '982020110691880475', 'Q', '1000', 'S', '2020-11-06 10:14:37', '0');
INSERT INTO `c_route` VALUES ('848', '992020061440050003', '982020110691880475', 'Q', '1000', 'S', '2020-11-06 10:14:55', '0');
INSERT INTO `c_route` VALUES ('849', '992019111758490006', '982020110981670058', 'Q', '1000', 'S', '2020-11-09 09:59:56', '0');
INSERT INTO `c_route` VALUES ('850', '992020061452450002', '982020110981670058', 'Q', '1000', 'S', '2020-11-09 10:00:15', '0');
INSERT INTO `c_route` VALUES ('851', '992020061440050003', '982020110981670058', 'Q', '1000', 'S', '2020-11-09 10:00:31', '0');
INSERT INTO `c_route` VALUES ('852', '992019111758490006', '982020111098910871', 'D', '1000', 'S', '2020-11-10 21:10:48', '0');
INSERT INTO `c_route` VALUES ('853', '992020061452450002', '982020111098910871', 'D', '1000', 'S', '2020-11-10 21:11:12', '0');
INSERT INTO `c_route` VALUES ('854', '992020061440050003', '982020111098910871', 'D', '1000', 'S', '2020-11-10 21:11:30', '0');
INSERT INTO `c_route` VALUES ('855', '992019111758490006', '982020111025290007', 'D', '1000', 'S', '2020-11-10 22:24:04', '0');
INSERT INTO `c_route` VALUES ('856', '992020061452450002', '982020111025290007', 'D', '1000', 'S', '2020-11-10 22:24:31', '0');
INSERT INTO `c_route` VALUES ('857', '992020061440050003', '982020111025290007', 'D', '1000', 'S', '2020-11-10 22:24:51', '0');
INSERT INTO `c_route` VALUES ('858', '992019111758490006', '982020111218170241', 'D', '1000', 'S', '2020-11-12 09:12:43', '0');
INSERT INTO `c_route` VALUES ('859', '992020061452450002', '982020111218170241', 'D', '1000', 'S', '2020-11-12 09:13:00', '0');
INSERT INTO `c_route` VALUES ('860', '992020061440050003', '982020111218170241', 'D', '1000', 'S', '2020-11-12 09:13:16', '0');
INSERT INTO `c_route` VALUES ('861', '992020011134400001', '982020111276490242', 'D', '1000', 'S', '2020-11-12 09:14:11', '0');
INSERT INTO `c_route` VALUES ('862', '992020011134400001', '982020111371280077', 'D', '1000', 'S', '2020-11-13 09:53:51', '0');
INSERT INTO `c_route` VALUES ('863', '992019111758490006', '982020111370530283', 'Q', '1000', 'S', '2020-11-13 18:14:01', '0');
INSERT INTO `c_route` VALUES ('864', '8000418004', '982020111370530283', 'Q', '1000', 'S', '2020-11-13 18:30:13', '0');
INSERT INTO `c_route` VALUES ('865', '992020061452450002', '982020111370530283', 'Q', '1000', 'S', '2020-11-13 18:32:21', '0');
INSERT INTO `c_route` VALUES ('866', '992020061440050003', '982020111370530283', 'Q', '1000', 'S', '2020-11-13 18:32:49', '0');
INSERT INTO `c_route` VALUES ('867', '8000418004', '982020111691430002', 'Q', '1000', 'S', '2020-11-16 01:06:07', '0');
INSERT INTO `c_route` VALUES ('868', '8000418004', '982020111666330003', 'Q', '1000', 'S', '2020-11-16 01:06:40', '0');
INSERT INTO `c_route` VALUES ('869', '8000418004', '982020111617130011', 'Q', '1000', 'S', '2020-11-16 23:24:45', '0');
INSERT INTO `c_route` VALUES ('870', '8000418004', '982020111705800015', 'Q', '1000', 'S', '2020-11-17 00:26:22', '0');
INSERT INTO `c_route` VALUES ('871', '8000418004', '982020111761530052', 'D', '1000', 'S', '2020-11-17 09:45:58', '0');
INSERT INTO `c_route` VALUES ('872', '8000418004', '982020111755740368', 'Q', '1000', 'S', '2020-11-17 17:25:56', '0');
INSERT INTO `c_route` VALUES ('873', '8000418004', '982020112000191505', 'Q', '1000', 'S', '2020-11-20 10:45:18', '0');
INSERT INTO `c_route` VALUES ('874', '8000418004', '982020112274422065', 'Q', '1000', 'S', '2020-11-22 15:27:01', '0');
INSERT INTO `c_route` VALUES ('875', '8000418004', '982020112293702104', 'D', '1000', 'S', '2020-11-22 18:10:23', '0');
INSERT INTO `c_route` VALUES ('876', '8000418004', '982020112486830458', 'Q', '1000', 'S', '2020-11-24 23:55:27', '0');
INSERT INTO `c_route` VALUES ('877', '8000418004', '982020112463750460', 'D', '1000', 'S', '2020-11-24 23:59:58', '0');
INSERT INTO `c_route` VALUES ('878', '8000418004', '982020112506770461', 'Q', '1000', 'S', '2020-11-25 00:04:28', '0');
INSERT INTO `c_route` VALUES ('879', '8000418004', '982020112570560464', 'D', '1000', 'S', '2020-11-25 01:13:17', '0');
INSERT INTO `c_route` VALUES ('880', '8000418004', '982020112572920465', 'D', '1000', 'S', '2020-11-25 01:27:09', '0');
INSERT INTO `c_route` VALUES ('881', '8000418004', '982020112511740794', 'D', '1000', 'S', '2020-11-25 17:44:33', '0');
INSERT INTO `c_route` VALUES ('882', '8000418004', '982020112504460799', 'Q', '1000', 'S', '2020-11-25 18:02:03', '0');
INSERT INTO `c_route` VALUES ('883', '8000418004', '982020112570770804', 'D', '1000', 'S', '2020-11-25 18:15:32', '0');
INSERT INTO `c_route` VALUES ('884', '8000418004', '982020112910080366', 'Q', '1000', 'S', '2020-11-29 13:47:34', '0');
INSERT INTO `c_route` VALUES ('885', '8000418004', '982020113030800062', 'Q', '1000', 'S', '2020-11-30 00:55:53', '0');
INSERT INTO `c_route` VALUES ('886', '8000418004', '982020113043460231', 'Q', '1000', 'S', '2020-11-30 11:42:16', '0');
INSERT INTO `c_route` VALUES ('887', '8000418004', '982020113094680493', 'Q', '1000', 'S', '2020-11-30 16:45:07', '0');
INSERT INTO `c_route` VALUES ('888', '992019111758490006', '98', 'D', '1000', 'S', '2020-12-01 18:08:24', '0');
INSERT INTO `c_route` VALUES ('889', '992020061452450002', '98', 'D', '1000', 'S', '2020-12-01 18:08:43', '0');
INSERT INTO `c_route` VALUES ('890', '992020061440050003', '98', 'D', '1000', 'S', '2020-12-01 18:08:59', '0');
INSERT INTO `c_route` VALUES ('891', '992020022270580001', '79', 'Q', '1000', 'S', '2020-12-03 10:37:25', '0');
INSERT INTO `c_route` VALUES ('892', '992019111758490006', '982020112910080366', 'Q', '1000', 'S', '2020-12-03 17:14:32', '0');
INSERT INTO `c_route` VALUES ('893', '992020061452450002', '982020112910080366', 'Q', '1000', 'S', '2020-12-03 17:14:55', '0');
INSERT INTO `c_route` VALUES ('894', '992020061440050003', '982020112910080366', 'Q', '1000', 'S', '2020-12-03 17:15:15', '0');
INSERT INTO `c_route` VALUES ('895', '8000418004', '982020120750000300', 'D', '1000', 'S', '2020-12-07 18:17:37', '0');
INSERT INTO `c_route` VALUES ('896', '8000418004', '982020120771190301', 'Q', '1000', 'S', '2020-12-07 18:20:07', '0');
INSERT INTO `c_route` VALUES ('897', '8000418004', '982020120754400302', 'D', '1000', 'S', '2020-12-07 18:21:33', '0');
INSERT INTO `c_route` VALUES ('898', '8000418004', '982020120752450305', 'D', '1000', 'S', '2020-12-07 18:30:54', '0');
INSERT INTO `c_route` VALUES ('899', '8000418004', '982020121049180195', 'Q', '1000', 'S', '2020-12-10 23:35:01', '0');
INSERT INTO `c_route` VALUES ('900', '8000418004', '982020121117680196', 'Q', '1000', 'S', '2020-12-11 00:18:50', '0');
INSERT INTO `c_route` VALUES ('901', '992020061452450002', '982020121120770227', 'D', '1000', 'S', '2020-12-11 09:16:56', '0');
INSERT INTO `c_route` VALUES ('902', '8000418004', '982020121555380166', 'D', '1000', 'S', '2020-12-15 18:13:04', '0');
INSERT INTO `c_route` VALUES ('903', '992019111758490006', '982020121555380166', 'D', '1000', 'S', '2020-12-15 23:24:56', '0');
INSERT INTO `c_route` VALUES ('904', '992020061452450002', '982020121555380166', 'D', '1000', 'S', '2020-12-15 23:25:21', '0');
INSERT INTO `c_route` VALUES ('905', '992020061440050003', '982020121555380166', 'D', '1000', 'S', '2020-12-15 23:25:46', '0');
INSERT INTO `c_route` VALUES ('906', '8000418004', '982020122118081089', 'D', '1000', 'S', '2020-12-21 18:09:17', '0');
INSERT INTO `c_route` VALUES ('907', '8000418004', '982020122160851090', 'D', '1000', 'S', '2020-12-21 18:09:46', '0');
INSERT INTO `c_route` VALUES ('908', '8000418004', '982020122238830014', 'D', '1000', 'S', '2020-12-22 23:39:40', '0');
INSERT INTO `c_route` VALUES ('909', '8000418004', '982020122212680015', 'D', '1000', 'S', '2020-12-22 23:40:12', '0');
INSERT INTO `c_route` VALUES ('910', '8000418004', '982020122209060017', 'D', '1000', 'S', '2020-12-22 23:41:19', '0');
INSERT INTO `c_route` VALUES ('911', '8000418004', '982020122229670030', 'Q', '1000', 'S', '2020-12-22 23:48:02', '0');
INSERT INTO `c_route` VALUES ('912', '8000418004', '982020122215940031', 'D', '1000', 'S', '2020-12-22 23:48:42', '0');
INSERT INTO `c_route` VALUES ('913', '8000418004', '982020122364210039', 'Q', '1000', 'S', '2020-12-23 00:50:51', '0');
INSERT INTO `c_route` VALUES ('914', '8000418004', '982020122368080040', 'D', '1000', 'S', '2020-12-23 00:52:04', '0');
INSERT INTO `c_route` VALUES ('915', '8000418004', '982020122372000041', 'D', '1000', 'S', '2020-12-23 00:53:18', '0');
INSERT INTO `c_route` VALUES ('916', '8000418004', '982020122329120042', 'D', '1000', 'S', '2020-12-23 00:53:56', '0');
INSERT INTO `c_route` VALUES ('917', '992020011134400001', '982020121555380166', 'D', '1000', 'S', '2020-12-23 09:16:44', '0');
INSERT INTO `c_route` VALUES ('918', '8000418004', '982020122343930168', 'Q', '1000', 'S', '2020-12-23 10:19:15', '0');
INSERT INTO `c_route` VALUES ('919', '8000418004', '982020122613830498', 'D', '1000', 'S', '2020-12-26 14:12:15', '0');
INSERT INTO `c_route` VALUES ('920', '992020051967020024', '982020122792270770', 'D', '1000', 'S', '2020-12-27 23:55:42', '0');
INSERT INTO `c_route` VALUES ('921', '992020051967020024', '982020122888190775', 'D', '1000', 'S', '2020-12-28 01:01:20', '0');
INSERT INTO `c_route` VALUES ('922', '8000418004', '982020122406010007', 'Q', '1000', 'S', '2020-12-24 13:58:47', '0');
INSERT INTO `c_route` VALUES ('923', '8000418004', '982020123078510811', 'D', '1000', 'S', '2020-12-30 22:57:26', '0');
INSERT INTO `c_route` VALUES ('924', '8000418004', '982020123119670980', 'D', '1000', 'S', '2020-12-31 11:58:05', '0');
INSERT INTO `c_route` VALUES ('925', '992020051967020024', '982020123119670980', 'D', '1000', 'S', '2020-12-31 13:42:03', '0');
INSERT INTO `c_route` VALUES ('926', '992019111758490006', '982020122118081089', 'D', '1000', 'S', '2020-12-31 17:38:12', '0');
INSERT INTO `c_route` VALUES ('927', '992020061452450002', '982020122118081089', 'D', '1000', 'S', '2020-12-31 17:38:33', '0');
INSERT INTO `c_route` VALUES ('928', '992020061440050003', '982020122118081089', 'D', '1000', 'S', '2020-12-31 17:38:51', '0');
INSERT INTO `c_route` VALUES ('929', '8000418004', '982021010355250150', 'Q', '1000', 'S', '2021-01-03 00:17:13', '0');
INSERT INTO `c_route` VALUES ('930', '8000418004', '982021010332700003', 'D', '1000', 'S', '2021-01-03 13:05:40', '0');
INSERT INTO `c_route` VALUES ('931', '8000418004', '982021010355230042', 'D', '1000', 'S', '2021-01-03 15:59:27', '0');
INSERT INTO `c_route` VALUES ('932', '992020061452450002', '87', 'Q', '1000', 'S', '2021-01-08 15:58:54', '0');
INSERT INTO `c_route` VALUES ('933', '992020061440050003', '87', 'Q', '1000', 'S', '2021-01-08 15:59:13', '0');
INSERT INTO `c_route` VALUES ('934', '992020022270580001', '982020051629810086', 'Q', '1000', 'S', '2021-01-11 10:41:28', '0');
INSERT INTO `c_route` VALUES ('935', '8000418004', '982021011182450309', 'D', '1000', 'S', '2021-01-11 18:01:17', '0');
INSERT INTO `c_route` VALUES ('936', '8000418004', '982021011173980030', 'D', '1000', 'S', '2021-01-11 23:20:28', '0');
INSERT INTO `c_route` VALUES ('937', '8000418004', '982021011308880206', 'Q', '1000', 'S', '2021-01-13 18:06:29', '0');
INSERT INTO `c_route` VALUES ('938', '992020022270580001', '982020122343930168', 'Q', '1000', 'S', '2021-01-13 23:02:02', '0');
INSERT INTO `c_route` VALUES ('939', '8000418004', '982021011420930161', 'Q', '1000', 'S', '2021-01-14 15:56:31', '0');
INSERT INTO `c_route` VALUES ('940', '8000418004', '982021010526710010', 'D', '1000', 'S', '2021-01-05 13:53:47', '0');
INSERT INTO `c_route` VALUES ('941', '992020022270580001', '982020122229670030', 'Q', '1000', 'S', '2021-01-11 16:41:48', '0');
INSERT INTO `c_route` VALUES ('942', '992019111758490006', '982020122364210039', 'Q', '1000', 'S', '2021-01-12 10:09:07', '0');
INSERT INTO `c_route` VALUES ('943', '992019111758490006', '982020122215940031', 'Q', '1000', 'S', '2021-01-12 11:24:07', '0');
INSERT INTO `c_route` VALUES ('944', '992020022270580001', '982020112486830458', 'Q', '1000', 'S', '2021-01-13 15:44:33', '0');
INSERT INTO `c_route` VALUES ('945', '992020022270580001', '982020122238830014', 'Q', '1000', 'S', '2021-01-13 16:26:30', '0');
INSERT INTO `c_route` VALUES ('946', '992020022270580001', '982021010526710010', 'Q', '1000', 'S', '2021-01-13 16:27:33', '0');
INSERT INTO `c_route` VALUES ('947', '992020061452450002', '982020122364210039', 'Q', '1000', 'S', '2021-01-14 08:06:42', '0');
INSERT INTO `c_route` VALUES ('948', '992020061452450002', '982020122215940031', 'Q', '1000', 'S', '2021-01-14 08:30:46', '0');
INSERT INTO `c_route` VALUES ('949', '992020022270580001', '982020122343930168', 'Q', '1000', 'S', '2021-01-15 11:40:31', '0');
INSERT INTO `c_route` VALUES ('950', '8000418004', '982021011606420032', 'Q', '1000', 'S', '2021-01-16 15:43:58', '0');
INSERT INTO `c_route` VALUES ('951', '8000418004', '982021011656040046', 'Q', '1000', 'S', '2021-01-16 16:01:27', '0');
INSERT INTO `c_route` VALUES ('952', '8000418004', '982021011639110001', 'D', '1000', 'S', '2021-01-16 17:45:26', '0');
INSERT INTO `c_route` VALUES ('953', '8000418004', '982021011717480281', 'D', '1000', 'S', '2021-01-17 11:29:43', '0');
INSERT INTO `c_route` VALUES ('954', '8000418004', '982021011705910020', 'D', '1000', 'S', '2021-01-17 15:41:58', '0');
INSERT INTO `c_route` VALUES ('955', '992019111758490006', '982021011928230052', 'Q', '1000', 'S', '2021-01-19 10:44:32', '0');
INSERT INTO `c_route` VALUES ('956', '992020061452450002', '982021011928230052', 'Q', '1000', 'S', '2021-01-19 10:45:04', '0');
INSERT INTO `c_route` VALUES ('957', '8000418004', '982021012226573248', 'Q', '1000', 'S', '2021-01-22 16:00:36', '0');
INSERT INTO `c_route` VALUES ('958', '8000418004', '982021012221083250', 'D', '1000', 'S', '2021-01-22 16:01:23', '0');
INSERT INTO `c_route` VALUES ('959', '8000418004', '982021012253103251', 'D', '1000', 'S', '2021-01-22 16:01:56', '0');
INSERT INTO `c_route` VALUES ('960', '8000418004', '982021012237543252', 'D', '1000', 'S', '2021-01-22 16:02:28', '0');
INSERT INTO `c_route` VALUES ('961', '992020022270580001', '3', 'Q', '1000', 'S', '2021-01-25 23:26:06', '0');
INSERT INTO `c_route` VALUES ('962', '992020022270580001', '59', 'Q', '1000', 'S', '2021-01-26 00:25:41', '0');
INSERT INTO `c_route` VALUES ('963', '8000418004', '982021012631490035', 'D', '1000', 'S', '2021-01-26 21:26:00', '0');
INSERT INTO `c_route` VALUES ('964', '8000418004', '982021012650800036', 'D', '1000', 'S', '2021-01-26 21:26:43', '0');
INSERT INTO `c_route` VALUES ('965', '8000418004', '982021012689690037', 'D', '1000', 'S', '2021-01-26 21:27:20', '0');
INSERT INTO `c_route` VALUES ('966', '8000418004', '982021012676620038', 'Q', '1000', 'S', '2021-01-26 21:27:53', '0');
INSERT INTO `c_route` VALUES ('967', '8000418004', '982021012687930055', 'D', '1000', 'S', '2021-01-26 22:48:34', '0');
INSERT INTO `c_route` VALUES ('968', '8000418004', '982021012631990056', 'Q', '1000', 'S', '2021-01-26 22:49:08', '0');
INSERT INTO `c_route` VALUES ('969', '992020022270580001', '982020070298920030', 'Q', '1000', 'S', '2020-12-31 15:56:51', '0');
INSERT INTO `c_route` VALUES ('970', '8000418004', '982021020193110885', 'D', '1000', 'S', '2021-02-01 11:52:35', '0');
INSERT INTO `c_route` VALUES ('971', '8000418004', '982021020184280890', 'D', '1000', 'S', '2021-02-01 12:55:40', '0');
INSERT INTO `c_route` VALUES ('972', '992020051967020024', '982021020193110885', 'D', '1000', 'S', '2021-02-01 14:42:01', '0');
INSERT INTO `c_route` VALUES ('973', '992020051967020024', '982021020184280890', 'D', '1000', 'S', '2021-02-01 14:42:43', '0');
INSERT INTO `c_route` VALUES ('974', '8000418004', '982021020148871006', 'Q', '1000', 'S', '2021-02-01 17:31:20', '0');
INSERT INTO `c_route` VALUES ('975', '8000418004', '982021020228831133', 'Q', '1000', 'S', '2021-02-02 13:14:47', '0');
INSERT INTO `c_route` VALUES ('976', '8000418004', '982021020369330024', 'Q', '1000', 'S', '2021-02-03 09:47:07', '0');
INSERT INTO `c_route` VALUES ('977', '992020051967020024', '982021020339880025', 'D', '1000', 'S', '2021-02-03 09:53:03', '0');
INSERT INTO `c_route` VALUES ('978', '8000418004', '982021013069630007', 'Q', '1000', 'S', '2021-01-30 15:44:22', '0');
INSERT INTO `c_route` VALUES ('979', '8000418004', '982021020570510086', 'D', '1000', 'S', '2021-02-05 17:47:05', '0');
INSERT INTO `c_route` VALUES ('980', '8000418004', '982021020524480087', 'D', '1000', 'S', '2021-02-05 17:47:32', '0');
INSERT INTO `c_route` VALUES ('981', '8000418004', '982021020580380088', 'D', '1000', 'S', '2021-02-05 17:47:59', '0');
INSERT INTO `c_route` VALUES ('982', '8000418004', '982021020595830089', 'Q', '1000', 'S', '2021-02-05 17:48:28', '0');
INSERT INTO `c_route` VALUES ('983', '8000418004', '982021020687730144', 'D', '1000', 'S', '2021-02-06 12:22:35', '0');
INSERT INTO `c_route` VALUES ('984', '8000418004', '982021020650180145', 'D', '1000', 'S', '2021-02-06 12:23:10', '0');
INSERT INTO `c_route` VALUES ('985', '8000418004', '982021020661640146', 'D', '1000', 'S', '2021-02-06 12:23:44', '0');
INSERT INTO `c_route` VALUES ('986', '8000418004', '982021020620240147', 'Q', '1000', 'S', '2021-02-06 12:24:31', '0');
INSERT INTO `c_route` VALUES ('987', '8000418004', '982021020705750224', 'Q', '1000', 'S', '2021-02-07 12:16:11', '0');
INSERT INTO `c_route` VALUES ('988', '8000418004', '982021020713130239', 'D', '1000', 'S', '2021-02-07 15:42:45', '0');
INSERT INTO `c_route` VALUES ('989', '8000418004', '982021020725440278', 'Q', '1000', 'S', '2021-02-07 21:49:32', '0');
INSERT INTO `c_route` VALUES ('990', '8000418004', '982021020784070279', 'D', '1000', 'S', '2021-02-07 21:50:06', '0');
INSERT INTO `c_route` VALUES ('991', '8000418004', '982021020745870280', 'D', '1000', 'S', '2021-02-07 21:50:36', '0');
INSERT INTO `c_route` VALUES ('992', '8000418004', '982021020731680281', 'D', '1000', 'S', '2021-02-07 21:51:08', '0');
INSERT INTO `c_route` VALUES ('993', '8000418004', '982021020833860316', 'D', '1000', 'S', '2021-02-08 10:27:03', '0');
INSERT INTO `c_route` VALUES ('994', '8000418004', '982021020841210317', 'D', '1000', 'S', '2021-02-08 10:29:55', '0');
INSERT INTO `c_route` VALUES ('995', '8000418004', '982021020814500318', 'D', '1000', 'S', '2021-02-08 10:30:36', '0');
INSERT INTO `c_route` VALUES ('996', '8000418004', '982021020856330319', 'Q', '1000', 'S', '2021-02-08 10:31:09', '0');
INSERT INTO `c_route` VALUES ('997', '8000418004', '982021022528820998', 'Q', '1000', 'S', '2021-02-25 10:07:15', '0');
INSERT INTO `c_route` VALUES ('998', '8000418004', '982021022544710112', 'Q', '1000', 'S', '2021-02-25 15:42:32', '0');
INSERT INTO `c_route` VALUES ('999', '8000418004', '982021022790380017', 'D', '1000', 'S', '2021-02-27 22:15:27', '0');
INSERT INTO `c_route` VALUES ('1000', '8000418004', '982021021824370003', 'D', '1000', 'S', '2021-02-18 14:33:38', '0');
INSERT INTO `c_route` VALUES ('1001', '8000418004', '982021022282310004', 'D', '1000', 'S', '2021-02-22 08:41:03', '0');
INSERT INTO `c_route` VALUES ('1002', '8000418004', '982021022357960003', 'D', '1000', 'S', '2021-02-23 10:59:04', '0');
INSERT INTO `c_route` VALUES ('1003', '8000418004', '982021022582250005', 'D', '1000', 'S', '2021-02-25 17:43:51', '0');
INSERT INTO `c_route` VALUES ('1004', '8000418004', '982021022756160004', 'D', '1000', 'S', '2021-02-27 11:47:09', '0');
INSERT INTO `c_route` VALUES ('1005', '8000418004', '982021030240790008', 'D', '1000', 'S', '2021-03-02 16:32:52', '0');
INSERT INTO `c_route` VALUES ('1006', '992021030901240071', '982021030904320079', 'D', '1000', 'S', '2021-03-09 12:06:34', '0');
INSERT INTO `c_route` VALUES ('1007', '992021030901240071', '982021030948210081', 'D', '1000', 'S', '2021-03-09 12:07:08', '0');
INSERT INTO `c_route` VALUES ('1008', '992021030901240071', '982021030923610082', 'Q', '1000', 'S', '2021-03-09 12:10:52', '0');
INSERT INTO `c_route` VALUES ('1009', '992021030901240071', '37', 'Q', '1000', 'S', '2021-03-09 12:19:47', '0');
INSERT INTO `c_route` VALUES ('1010', '992021030901240071', '36', 'D', '1000', 'S', '2021-03-09 12:20:28', '0');
INSERT INTO `c_route` VALUES ('1011', '992021030901240071', '4', 'Q', '1000', 'S', '2021-03-09 12:33:32', '0');
INSERT INTO `c_route` VALUES ('1012', '992021030901240071', '982019112482610001', 'Q', '1000', 'S', '2021-03-09 12:50:00', '0');
INSERT INTO `c_route` VALUES ('1013', '992021030901240071', '56', 'Q', '1000', 'S', '2021-03-09 12:53:00', '0');
INSERT INTO `c_route` VALUES ('1014', '992021030901240071', '39', 'D', '1000', 'S', '2021-03-09 13:10:34', '0');
INSERT INTO `c_route` VALUES ('1015', '992021030901240071', '1', 'Q', '1000', 'S', '2021-03-09 13:11:16', '0');
INSERT INTO `c_route` VALUES ('1016', '992021030901240071', '3', 'Q', '1000', 'S', '2021-03-09 13:11:54', '0');
INSERT INTO `c_route` VALUES ('1017', '992021030901240071', '59', 'Q', '1000', 'S', '2021-03-09 13:38:14', '0');
INSERT INTO `c_route` VALUES ('1018', '992021030901240071', '982020101035970199', 'Q', '1000', 'S', '2021-03-09 13:48:01', '0');
INSERT INTO `c_route` VALUES ('1019', '992021030901240071', '982020101083710196', 'D', '1000', 'S', '2021-03-09 13:48:53', '0');
INSERT INTO `c_route` VALUES ('1020', '992021030901240071', '982020101082160197', 'D', '1000', 'S', '2021-03-09 13:49:17', '0');
INSERT INTO `c_route` VALUES ('1021', '992021030901240071', '982020101022330198', 'D', '1000', 'S', '2021-03-09 13:49:43', '0');
INSERT INTO `c_route` VALUES ('1022', '992021030901240071', '982020101074420195', 'D', '1000', 'S', '2021-03-09 13:52:50', '0');
INSERT INTO `c_route` VALUES ('1023', '992021030901240071', '982020101054670194', 'D', '1000', 'S', '2021-03-09 13:53:17', '0');
INSERT INTO `c_route` VALUES ('1024', '992021030901240071', '982020101061440187', 'D', '1000', 'S', '2021-03-09 13:53:39', '0');
INSERT INTO `c_route` VALUES ('1025', '992021030901240071', '982020101081480186', 'Q', '1000', 'S', '2021-03-09 13:54:00', '0');
INSERT INTO `c_route` VALUES ('1026', '992021030901240071', '982020101015720457', 'Q', '1000', 'S', '2021-03-09 13:54:44', '0');
INSERT INTO `c_route` VALUES ('1027', '992021030901240071', '982020101055900465', 'D', '1000', 'S', '2021-03-09 13:55:10', '0');
INSERT INTO `c_route` VALUES ('1028', '992021030901240071', '982020101013520464', 'D', '1000', 'S', '2021-03-09 13:55:31', '0');
INSERT INTO `c_route` VALUES ('1029', '992021030901240071', '982020101083790462', 'D', '1000', 'S', '2021-03-09 13:55:53', '0');
INSERT INTO `c_route` VALUES ('1030', '992021030901240071', '57', 'Q', '1000', 'S', '2021-03-10 15:09:14', '0');
INSERT INTO `c_route` VALUES ('1031', '992021030901240071', '18', 'D', '1000', 'S', '2021-03-10 15:16:03', '0');
INSERT INTO `c_route` VALUES ('1032', '992021030901240071', '60', 'D', '1000', 'S', '2021-03-10 15:21:24', '0');
INSERT INTO `c_route` VALUES ('1033', '8000418004', '982021031100310305', 'D', '1000', 'S', '2021-03-11 18:44:17', '0');
INSERT INTO `c_route` VALUES ('1034', '8000418004', '982021032400120073', 'Q', '1000', 'S', '2021-03-24 11:30:34', '0');
INSERT INTO `c_route` VALUES ('1035', '8000418004', '982021032529790315', 'D', '1000', 'S', '2021-03-25 10:55:10', '0');
INSERT INTO `c_route` VALUES ('1036', '8000418004', '982021032550230035', 'Q', '1000', 'S', '2021-03-25 13:20:15', '0');
INSERT INTO `c_route` VALUES ('1037', '8000418004', '982021033060180301', 'Q', '1000', 'S', '2021-03-30 23:58:21', '0');
INSERT INTO `c_route` VALUES ('1038', '8000418004', '982021033165270001', 'D', '1000', 'S', '2021-03-31 01:12:02', '0');
INSERT INTO `c_route` VALUES ('1039', '8000418004', '982021033191950037', 'Q', '1000', 'S', '2021-03-31 09:40:42', '0');
INSERT INTO `c_route` VALUES ('1040', '8000418004', '982021033140400385', 'D', '1000', 'S', '2021-03-31 22:04:54', '0');
INSERT INTO `c_route` VALUES ('1041', '8000418004', '982021040148740426', 'Q', '1000', 'S', '2021-04-01 10:02:34', '0');
INSERT INTO `c_route` VALUES ('1042', '992020061452450002', '982021012631490035', 'D', '1000', 'S', '2021-03-11 16:36:08', '0');
INSERT INTO `c_route` VALUES ('1043', '992019111758490006', '982021012631490035', 'D', '1000', 'S', '2021-03-11 16:56:02', '0');
INSERT INTO `c_route` VALUES ('1044', '992020061452450002', '982021012676620038', 'Q', '1000', 'S', '2021-03-12 10:07:57', '0');
INSERT INTO `c_route` VALUES ('1045', '992019111758490006', '982021012676620038', 'Q', '1000', 'S', '2021-03-12 10:12:52', '0');
INSERT INTO `c_route` VALUES ('1046', '992020061452450002', '982021021824370003', 'D', '1000', 'S', '2021-03-12 11:20:29', '0');
INSERT INTO `c_route` VALUES ('1047', '992019111758490006', '982021021824370003', 'D', '1000', 'S', '2021-03-12 11:20:45', '0');
INSERT INTO `c_route` VALUES ('1048', '992020022270580001', '982021012676620038', 'Q', '1000', 'S', '2021-03-12 14:49:42', '0');
INSERT INTO `c_route` VALUES ('1049', '992020022270580001', '982021022282310004', 'D', '1000', 'S', '2021-03-12 16:23:21', '0');
INSERT INTO `c_route` VALUES ('1050', '992020022270580001', '982021012687930055', 'D', '1000', 'S', '2021-03-12 16:26:14', '0');
INSERT INTO `c_route` VALUES ('1051', '992020022270580001', '982021022582250005', 'D', '1000', 'S', '2021-03-13 11:07:08', '0');
INSERT INTO `c_route` VALUES ('1052', '992020022270580001', '982021022357960003', 'D', '1000', 'S', '2021-03-15 08:42:37', '0');
INSERT INTO `c_route` VALUES ('1053', '992020022270580001', '982021030240790008', 'Q', '1000', 'S', '2021-03-15 09:23:36', '0');
INSERT INTO `c_route` VALUES ('1054', '8000418004', '982021031756520010', 'Q', '1000', 'S', '2021-03-17 10:54:57', '0');
INSERT INTO `c_route` VALUES ('1055', '8000418004', '982021031788490010', 'Q', '1000', 'S', '2021-03-17 15:38:24', '0');
INSERT INTO `c_route` VALUES ('1056', '992020022270580001', '982021031756520010', 'Q', '1000', 'S', '2021-03-24 11:05:40', '0');
INSERT INTO `c_route` VALUES ('1057', '992020022270580001', '982021031788490010', 'Q', '1000', 'S', '2021-03-24 11:06:48', '0');
INSERT INTO `c_route` VALUES ('1058', '992020022270580001', '982019103127420012', 'Q', '1000', 'S', '2021-03-24 13:49:03', '0');
INSERT INTO `c_route` VALUES ('1059', '992020022270580001', '982020062815890017', 'Q', '1000', 'S', '2021-03-25 09:05:31', '0');
INSERT INTO `c_route` VALUES ('1060', '992020022270580001', '9820200701134712400', 'D', '1000', 'S', '2021-04-01 09:05:31', '0');
INSERT INTO `c_route` VALUES ('1061', '992019111758490006', '982021022582250005', 'Q', '1000', 'S', '2021-04-01 10:14:21', '0');
INSERT INTO `c_route` VALUES ('1062', '992020061452450002', '982021022582250005', 'Q', '1000', 'S', '2021-04-01 10:14:52', '0');
INSERT INTO `c_route` VALUES ('1063', '992019111758490006', '982021030240790008', 'Q', '1000', 'S', '2021-04-01 10:15:42', '0');
INSERT INTO `c_route` VALUES ('1064', '992020061452450002', '982021030240790008', 'Q', '1000', 'S', '2021-04-01 10:16:00', '0');
INSERT INTO `c_route` VALUES ('1065', '8000418004', '982021040107370031', 'Q', '1000', 'S', '2021-04-01 22:46:34', '0');
INSERT INTO `c_route` VALUES ('1066', '8000418004', '982021040620510381', 'Q', '1000', 'S', '2021-04-06 09:20:42', '0');
INSERT INTO `c_route` VALUES ('1067', '8000418004', '982021040664560026', 'D', '1000', 'S', '2021-04-06 11:18:30', '0');
INSERT INTO `c_route` VALUES ('1068', '8000418004', '982021040687830013', 'D', '1000', 'S', '2021-04-06 13:42:37', '0');
INSERT INTO `c_route` VALUES ('1069', '8000418004', '982021040697730003', 'D', '1000', 'S', '2021-04-06 16:17:55', '0');
INSERT INTO `c_route` VALUES ('1070', '8000418004', '982021040621720029', 'Q', '1000', 'S', '2021-04-06 17:01:27', '0');
INSERT INTO `c_route` VALUES ('1071', '8000418004', '982021040794440205', 'D', '1000', 'S', '2021-04-07 12:08:24', '0');
INSERT INTO `c_route` VALUES ('1072', '8000418004', '982021040719990212', 'Q', '1000', 'S', '2021-04-07 12:42:10', '0');
INSERT INTO `c_route` VALUES ('1073', '8000418004', '982021040772630226', 'Q', '1000', 'S', '2021-04-07 13:37:53', '0');
INSERT INTO `c_route` VALUES ('1074', '8000418004', '982021040706440024', 'D', '1000', 'S', '2021-04-07 14:29:04', '0');
INSERT INTO `c_route` VALUES ('1075', '8000418004', '982021040756200152', 'D', '1000', 'S', '2021-04-07 21:28:18', '0');
INSERT INTO `c_route` VALUES ('1076', '8000418004', '982021040762340154', 'D', '1000', 'S', '2021-04-07 21:28:54', '0');
INSERT INTO `c_route` VALUES ('1077', '8000418004', '982021040790760155', 'D', '1000', 'S', '2021-04-07 21:29:45', '0');
INSERT INTO `c_route` VALUES ('1078', '8000418004', '982021040788900156', 'Q', '1000', 'S', '2021-04-07 21:30:17', '0');
INSERT INTO `c_route` VALUES ('1079', '8000418004', '982021040818520005', 'Q', '1000', 'S', '2021-04-08 01:01:23', '0');
INSERT INTO `c_route` VALUES ('1080', '8000418004', '982021040850290006', 'D', '1000', 'S', '2021-04-08 01:04:24', '0');
INSERT INTO `c_route` VALUES ('1081', '8000418004', '982021040875240071', 'Q', '1000', 'S', '2021-04-08 14:49:37', '0');
INSERT INTO `c_route` VALUES ('1082', '8000418004', '982021040844720023', 'D', '1000', 'S', '2021-04-08 15:29:15', '0');
INSERT INTO `c_route` VALUES ('1083', '8000418004', '982021040886530018', 'Q', '1000', 'S', '2021-04-08 15:55:26', '0');
INSERT INTO `c_route` VALUES ('1084', '8000418004', '982021040870440021', 'Q', '1000', 'S', '2021-04-08 21:05:23', '0');
INSERT INTO `c_route` VALUES ('1085', '992020022270580001', '104', 'Q', '1000', 'S', '2021-04-08 17:45:07', '0');
INSERT INTO `c_route` VALUES ('1086', '992020022270580001', '982020090626360033', 'Q', '1000', 'S', '2021-04-09 08:55:34', '0');
INSERT INTO `c_route` VALUES ('1087', '992020022270580001', '982020062976500015', 'D', '1000', 'S', '2021-04-09 10:06:41', '0');
INSERT INTO `c_route` VALUES ('1088', '8000418004', '982021041319720168', 'Q', '1000', 'S', '2021-04-13 23:13:40', '0');
INSERT INTO `c_route` VALUES ('1089', '8000418004', '982021041300780169', 'D', '1000', 'S', '2021-04-13 23:15:02', '0');
INSERT INTO `c_route` VALUES ('1090', '8000418004', '982021041339340170', 'D', '1000', 'S', '2021-04-13 23:17:35', '0');
INSERT INTO `c_route` VALUES ('1091', '8000418004', '982021041315340171', 'D', '1000', 'S', '2021-04-13 23:38:52', '0');
INSERT INTO `c_route` VALUES ('1092', '8000418004', '982021041430450178', 'Q', '1000', 'S', '2021-04-14 00:58:16', '0');
INSERT INTO `c_route` VALUES ('1093', '8000418004', '982021041422620179', 'D', '1000', 'S', '2021-04-14 00:58:58', '0');
INSERT INTO `c_route` VALUES ('1094', '8000418004', '982021041424480180', 'D', '1000', 'S', '2021-04-14 00:59:25', '0');
INSERT INTO `c_route` VALUES ('1095', '8000418004', '982021041400790181', 'D', '1000', 'S', '2021-04-14 00:59:55', '0');
INSERT INTO `c_route` VALUES ('1096', '992021030901240071', '982021041882150004', 'Q', '1000', 'S', '2021-04-18 00:51:36', '0');
INSERT INTO `c_route` VALUES ('1097', '992021030901240071', '982021041814170005', 'Q', '1000', 'S', '2021-04-18 01:02:08', '0');
INSERT INTO `c_route` VALUES ('1098', '992021030901240071', '982021041800760006', 'D', '1000', 'S', '2021-04-18 01:14:26', '0');
INSERT INTO `c_route` VALUES ('1099', '8000418004', '982021041882150004', 'Q', '1000', 'S', '2021-04-19 00:08:25', '0');
INSERT INTO `c_route` VALUES ('1100', '8000418004', '982021041902470064', 'D', '1000', 'S', '2021-04-19 00:44:14', '0');
INSERT INTO `c_route` VALUES ('1101', '992021030901240071', '982019100759020004', 'Q', '1000', 'S', '2021-04-19 01:20:26', '0');
INSERT INTO `c_route` VALUES ('1102', '992021030901240071', '982020020845600001', 'D', '1000', 'S', '2021-04-19 01:25:23', '0');
INSERT INTO `c_route` VALUES ('1103', '992021030901240071', '982021042054280077', 'D', '1000', 'S', '2021-04-20 00:43:31', '0');
INSERT INTO `c_route` VALUES ('1104', '992021030901240071', '982021042005150078', 'D', '1000', 'S', '2021-04-20 00:44:01', '0');
INSERT INTO `c_route` VALUES ('1105', '992021030901240071', '982021042079990079', 'D', '1000', 'S', '2021-04-20 00:44:34', '0');
INSERT INTO `c_route` VALUES ('1106', '992021030901240071', '982021042039260080', 'Q', '1000', 'S', '2021-04-20 00:45:07', '0');
INSERT INTO `c_route` VALUES ('1107', '8000418004', '982021041414100002', 'D', '1000', 'S', '2021-04-14 14:58:06', '0');
INSERT INTO `c_route` VALUES ('1108', '992020061452450002', '982019100575550004', 'D', '1000', 'S', '2021-04-21 17:38:16', '0');
INSERT INTO `c_route` VALUES ('1109', '8000418004', '982021042201270311', 'D', '1000', 'S', '2021-04-22 15:42:56', '0');
INSERT INTO `c_route` VALUES ('1110', '8000418004', '982021042221290312', 'D', '1000', 'S', '2021-04-22 15:43:23', '0');
INSERT INTO `c_route` VALUES ('1111', '8000418004', '982021042294720313', 'D', '1000', 'S', '2021-04-22 15:43:52', '0');
INSERT INTO `c_route` VALUES ('1112', '8000418004', '982021042235760314', 'Q', '1000', 'S', '2021-04-22 15:44:18', '0');
INSERT INTO `c_route` VALUES ('1113', '8000418004', '982021042304110399', 'Q', '1000', 'S', '2021-04-23 10:50:06', '0');
INSERT INTO `c_route` VALUES ('1114', '8000418004', '982021042304260400', 'Q', '1000', 'S', '2021-04-23 10:50:46', '0');
INSERT INTO `c_route` VALUES ('1115', '8000418004', '982021042371920462', 'D', '1000', 'S', '2021-04-23 14:09:06', '0');
INSERT INTO `c_route` VALUES ('1116', '8000418004', '982021042157170002', 'D', '1000', 'S', '2021-04-21 17:49:38', '0');
INSERT INTO `c_route` VALUES ('1117', '8000418004', '982021042132480002', 'D', '1000', 'S', '2021-04-21 15:00:49', '0');
INSERT INTO `c_route` VALUES ('1118', '8000418004', '982021042168000012', 'Q', '1000', 'S', '2021-04-21 09:05:09', '0');
INSERT INTO `c_route` VALUES ('1119', '8000418004', '982021042102420011', 'D', '1000', 'S', '2021-04-21 09:03:52', '0');
INSERT INTO `c_route` VALUES ('1120', '8000418004', '982021042155960010', 'D', '1000', 'S', '2021-04-21 09:02:18', '0');
INSERT INTO `c_route` VALUES ('1121', '8000418004', '982021042173320006', 'D', '1000', 'S', '2021-04-21 08:56:30', '0');
INSERT INTO `c_route` VALUES ('1122', '992020022270580001', '982021040870440021', 'Q', '1000', 'S', '2021-04-22 15:49:09', '0');
INSERT INTO `c_route` VALUES ('1123', '992020022270580001', '982021042168000012', 'Q', '1000', 'S', '2021-04-22 15:40:09', '0');
INSERT INTO `c_route` VALUES ('1124', '8000418004', '982021042886050059', 'D', '1000', 'S', '2021-04-28 17:44:17', '0');
INSERT INTO `c_route` VALUES ('1125', '8000418004', '982021042861780005', 'Q', '1000', 'S', '2021-04-28 17:46:19', '0');
INSERT INTO `c_route` VALUES ('1126', '8000418004', '982021042836920004', 'D', '1000', 'S', '2021-04-28 17:44:48', '0');
INSERT INTO `c_route` VALUES ('1127', '8000418004', '982021042591610004', 'Q', '1000', 'S', '2021-04-25 16:12:20', '0');
INSERT INTO `c_route` VALUES ('1128', '8000418004', '982021042433520003', 'D', '1000', 'S', '2021-04-24 14:57:17', '0');
INSERT INTO `c_route` VALUES ('1129', '8000418004', '982021042350820006', 'D', '1000', 'S', '2021-04-23 14:13:04', '0');
INSERT INTO `c_route` VALUES ('1130', '8000418004', '982021042342580005', 'D', '1000', 'S', '2021-04-23 14:11:29', '0');
INSERT INTO `c_route` VALUES ('1131', '8000418004', '982021042314660004', 'D', '1000', 'S', '2021-04-23 14:09:31', '0');
INSERT INTO `c_route` VALUES ('1132', '8000418004', '982021042381210005', 'Q', '1000', 'S', '2021-04-23 10:59:00', '0');
INSERT INTO `c_route` VALUES ('1133', '8000418004', '982021042223630004', 'Q', '1000', 'S', '2021-04-22 16:45:27', '0');
INSERT INTO `c_route` VALUES ('1134', '8000418004', '982021042975180005', 'Q', '1000', 'S', '2021-04-29 22:13:59', '0');
INSERT INTO `c_route` VALUES ('1135', '992019111758490006', '982020091851340071', 'Q', '1000', 'S', '2021-04-30 09:13:22', '0');
INSERT INTO `c_route` VALUES ('1136', '992020061452450002', '982020091851340071', 'Q', '1000', 'S', '2021-04-30 10:59:16', '0');
INSERT INTO `c_route` VALUES ('1137', '992021030901240071', '982021050274070611', 'D', '1000', 'S', '2021-05-02 16:22:00', '0');
INSERT INTO `c_route` VALUES ('1138', '992021030901240071', '982021050298020612', 'D', '1000', 'S', '2021-05-02 16:22:34', '0');
INSERT INTO `c_route` VALUES ('1139', '992021030901240071', '982021050279280613', 'D', '1000', 'S', '2021-05-02 16:23:03', '0');
INSERT INTO `c_route` VALUES ('1140', '992021030901240071', '982021050218900614', 'Q', '1000', 'S', '2021-05-02 16:23:32', '0');
INSERT INTO `c_route` VALUES ('1141', '8000418004', '982021050277160634', 'Q', '1000', 'S', '2021-05-02 23:32:06', '0');
INSERT INTO `c_route` VALUES ('1142', '8000418004', '982021050293410635', 'D', '1000', 'S', '2021-05-02 23:32:36', '0');
INSERT INTO `c_route` VALUES ('1143', '8000418004', '982021050365770197', 'Q', '1000', 'S', '2021-05-03 17:34:32', '0');
INSERT INTO `c_route` VALUES ('1144', '8000418004', '982021050433570220', 'Q', '1000', 'S', '2021-05-04 02:05:27', '0');
INSERT INTO `c_route` VALUES ('1145', '992021030901240071', '982021050546580309', 'Q', '1000', 'S', '2021-05-05 11:45:32', '0');
INSERT INTO `c_route` VALUES ('1146', '992021030901240071', '982021050529640534', 'Q', '1000', 'S', '2021-05-05 13:19:01', '0');
INSERT INTO `c_route` VALUES ('1147', '992021030901240071', '982021050365770197', 'Q', '1000', 'S', '2021-05-05 22:55:07', '0');
INSERT INTO `c_route` VALUES ('1148', '992021030901240071', '982021050277160634', 'Q', '1000', 'S', '2021-05-06 20:14:28', '0');
INSERT INTO `c_route` VALUES ('1149', '992021030901240071', '982021050786040073', 'Q', '1000', 'S', '2021-05-07 20:45:27', '0');
INSERT INTO `c_route` VALUES ('1150', '992021030901240071', '982021050789260074', 'D', '1000', 'S', '2021-05-07 20:46:13', '0');
INSERT INTO `c_route` VALUES ('1151', '992021030901240071', '982021050799660075', 'D', '1000', 'S', '2021-05-07 20:46:58', '0');
INSERT INTO `c_route` VALUES ('1152', '992021030901240071', '982021050863250302', 'Q', '1000', 'S', '2021-05-08 22:25:01', '0');
INSERT INTO `c_route` VALUES ('1153', '992021030901240071', '982021050919390367', 'Q', '1000', 'S', '2021-05-09 15:56:58', '0');
INSERT INTO `c_route` VALUES ('1154', '992021030901240071', '982021050947470372', 'Q', '1000', 'S', '2021-05-09 16:51:05', '0');
INSERT INTO `c_route` VALUES ('1155', '992021030901240071', '982021050909630402', 'Q', '1000', 'S', '2021-05-09 23:14:33', '0');
INSERT INTO `c_route` VALUES ('1156', '992021030901240071', '982021051227260214', 'D', '1000', 'S', '2021-05-12 11:39:56', '0');
INSERT INTO `c_route` VALUES ('1157', '992021030901240071', '982020111370530283', 'Q', '1000', 'S', '2021-05-12 14:48:12', '0');
INSERT INTO `c_route` VALUES ('1158', '992021030901240071', '982020111617130011', 'Q', '1000', 'S', '2021-05-12 15:09:55', '0');
INSERT INTO `c_route` VALUES ('1159', '992021030901240071', '982020111705800015', 'Q', '1000', 'S', '2021-05-12 15:11:07', '0');
INSERT INTO `c_route` VALUES ('1160', '992021030901240071', '982020111755740368', 'Q', '1000', 'S', '2021-05-12 18:53:47', '0');
INSERT INTO `c_route` VALUES ('1161', '992021030901240071', '982021051324820500', 'Q', '1000', 'S', '2021-05-13 12:03:41', '0');
INSERT INTO `c_route` VALUES ('1162', '992021030901240071', '982021051337090139', 'Q', '1000', 'S', '2021-05-13 18:01:01', '0');
INSERT INTO `c_route` VALUES ('1163', '992021030901240071', '982021051427940017', 'Q', '1000', 'S', '2021-05-14 10:01:23', '0');
INSERT INTO `c_route` VALUES ('1164', '992021030901240071', '982021051401380194', 'Q', '1000', 'S', '2021-05-14 22:53:38', '0');
INSERT INTO `c_route` VALUES ('1165', '992021030901240071', '982020051629810086', 'Q', '1000', 'S', '2021-05-14 23:38:23', '0');
INSERT INTO `c_route` VALUES ('1166', '992021030901240071', '982019103127420012', 'Q', '1000', 'S', '2021-05-14 23:39:41', '0');
INSERT INTO `c_route` VALUES ('1167', '992021030901240071', '982020051627210083', 'D', '1000', 'S', '2021-05-14 23:41:15', '0');
INSERT INTO `c_route` VALUES ('1168', '992021030901240071', '982020062202400019', 'Q', '1000', 'S', '2021-05-14 23:43:27', '0');
INSERT INTO `c_route` VALUES ('1169', '992021030901240071', '982020051652420084', 'D', '1000', 'S', '2021-05-14 23:45:58', '0');
INSERT INTO `c_route` VALUES ('1170', '992021030901240071', '982020062257430008', 'Q', '1000', 'S', '2021-05-15 00:09:43', '0');
INSERT INTO `c_route` VALUES ('1171', '992021030901240071', '982020062254970005', 'D', '1000', 'S', '2021-05-15 00:14:16', '0');
INSERT INTO `c_route` VALUES ('1172', '992021030901240071', '982020062280640006', 'D', '1000', 'S', '2021-05-15 00:17:16', '0');
INSERT INTO `c_route` VALUES ('117