﻿using System;

namespace MicaForEveryone.Win32.PInvoke
{
    [Flags]
    public enum WINEVENT
    {
        /// <summary>
        /// The DLL that contains the callback function is mapped into the address space of the process that generates the event. With
        /// this flag, the system sends event notifications to the callback function as they occur. The hook function must be in a DLL
        /// when this flag is specified. This flag has no effect when both the calling process and the generating process are not 32-bit
        /// or 64-bit processes, or when the generating process is a console application. For more information, see In-Context Hook Functions.
        /// </summary>
        WINEVENT_INCONTEXT = 4,

        /// <summary>
        /// The callback function is not mapped into the address space of the process that generates the event. Because the hook
        /// function is called across process boundaries, the system must queue events. Although this method is asynchronous, events are
        /// guaranteed to be in sequential order. For more information, see Out-of-Context Hook Functions.
        /// </summary>
        WINEVENT_OUTOFCONTEXT = 0,

        /// <summary>
        /// Prevents this instance of the hook from receiving the events that are generated by threads in this process. This flag does
        /// not prevent threads from generating events.
        /// </summary>
        WINEVENT_SKIPOWNPROCESS = 2,

        /// <summary>
        /// Prevents this instance of the hook from receiving the events that are generated by the thread that is registering this hook.
        /// </summary>
        WINEVENT_SKIPOWNTHREAD = 1,
    }
}
