/*
---

description: The base component for the Meio.Mask plugin.

authors:
 - Fábio Miranda Costa

requires:
 - core/1.2.4: [Class.Extras, Element.Event, Element.Style]
 - more/1.2.4.1: Element.Forms

license: MIT-style license

provides: [Meio.Mask]

...
*/
if(typeof Meio=="undefined"){var Meio={}}$extend(Element.NativeEvents,{"paste":2,"input":2});Element.Events.paste={base:(Browser.Engine.presto||(Browser.Engine.gecko&&Browser.Engine.version<19))?"input":"paste",condition:function(A){this.fireEvent("paste",A,1);return false}};Meio.Mask=new Class({Implements:[Options,Events],options:{selectOnFocus:true,autoTab:false},initialize:function(A){this.setOptions(A);this.ignore=false;this.bound={"focus":0,"blur":0,"keydown":0,"keypress":0,"paste":0}},link:function(A){A=$(A);if(A.get("tag")!="input"||A.get("type")!="text"){return }if(this.element){this.unlink()}this.element=A;return this.attach()},unlink:function(){return this.dettach()},attach:function(){if(this.maxlength==null){this.maxlength=this.element.get("maxLength")}this.element.removeAttribute("maxLength");for(var A in this.bound){this.bound[A]=this.onMask.bindWithEvent(this,this[A]);this.element.addEvent(A,this.bound[A])}var B=this.element.get("value");if(B!=""){this.element.set("value",this.mask(B))}return this},dettach:function(){var B=this.maxlength;if(B!=null){this.element.set("maxlength",B)}for(var A in this.bound){this.element.removeEvent(A,this.bound[A]);this.bound[A]=0}this.element=null;return this},onMask:function(D,B){if(this.element.get("readonly")){return true}var E={},A=D.event,C=(D.type=="paste")?null:A.keyCode;E.range=this.element.getSelectedRange();E.isSelection=(E.range.start!==E.range.end);E.isDelKey=(C==46&&(A.type!="keypress"||((Browser.Engine.gecko||Browser.Engine.presto)&&!A.which)));E.isBksKey=(C==8||(Browser.Platform.ipod&&D.code==127));E.isRemoveKey=(E.isBksKey||E.isDelKey);B&&B.call(this,D,E);return true},keydown:function(B,C){this.ignore=(Meio.Mask.ignoreKeys[B.code]&&!C.isRemoveKey)||B.control||B.meta||B.alt;if(this.ignore||C.isRemoveKey){var A=Meio.Mask.ignoreKeys[B.code]||"";this.fireEvent("valid",[this.element,B.code,A])}return(Browser.Platform.ipod||(Meio.Mask.onlyKeyDownRepeat&&C.isRemoveKey))?this.keypress(B,C):true},keypress:function(B,C){if(this.options.autoTab&&this.shouldFocusNext()){var A=this.getNextInput();if(A){A.focus();if(A.select){A.select()}}}return true},focus:function(B,C){var A=this.element;A.store("meiomask:focusvalue",A.get("value"))},blur:function(B,C){var A=this.element;if(B&&A.retrieve("meiomask:focusvalue")!=A.get("value")){A.fireEvent("change")}},getCurrentState:function(D,E){var B=String.fromCharCode(D.code),C=this.element.get("value");var F=E.range.start,A=E.range.end;if(E.isRemoveKey&&!E.isSelection){E.isDelKey?A++:F--}return{value:C.substring(0,F)+(E.isRemoveKey?"":B)+C.substring(A),_char:B,start:F,end:A}},setSize:function(){if(!this.element.get("size")){this.element.set("size",this.maskArray.length)}},shouldFocusNext:function(){var A=this.options.maxLength;return A&&this.element.get("value").length>=A},getNextInput:function(){var A=$A(this.element.form.elements),D;for(var C=A.indexOf(this.element)+1,B=A.length;C<B;C++){D=A[C];if(this.isFocusableField(D)){return $(D)}}return null},isFocusableField:function(A){return(A.offsetWidth>0||A.offsetHeight>0)&&A.nodeName!="FIELDSET"},isFixedChar:function(A){return !Meio.Mask.matchRules.contains(A)},mask:function(A){return A},unmask:function(A){return A}});Meio.Mask.extend({matchRules:"",rulesRegex:new RegExp(""),rules:{},setRule:function(A,B){this.setRules({ruleKey:B})},setRules:function(A){$extend(this.rules,A);var B=[];for(rule in A){B.push(rule)}this.matchRules+=B.join("");this.recompileRulesRegex()},removeRule:function(A){delete this.rules[A];this.matchRules=this.matchRules.replace(A,"");this.recompileRulesRegex()},removeRules:function(){var A=Array.flatten(arguments);for(var B=A.length;B--;){this.removeRule(A[B])}},recompileRulesRegex:function(){this.rulesRegex.compile("["+this.matchRules.escapeRegExp()+"]","g")},createMasks:function(B,A){B=B.capitalize();for(mask in A){this[B][mask.camelCase().capitalize()]=new Class({Extends:this[B],options:A[mask]})}},upTo:function(A){A=""+A;return function(D,C,B){if(D.charAt(C-1)==A[0]){return(B<=A[1])}return true}},onlyKeyDownRepeat:!!(Browser.Engine.trident||(Browser.Engine.webkit&&Browser.Engine.version>=525))}).extend(function(){var B;var D={8:"backspace",9:"tab",13:"enter",16:"shift",17:"control",18:"alt",27:"esc",33:"page up",34:"page down",35:"end",36:"home",37:"left",38:"up",39:"right",40:"down",45:"insert",46:"delete",224:"command"},C={10:"go",127:"delete"};if(Browser.Platform.ipod){B=C}else{for(var A=1;A<=12;A++){D[111+A]="f"+A}B=D}return{ignoreKeys:B}}()).setRules((function(){var B={"z":{regex:/[a-z]/},"Z":{regex:/[A-Z]/},"a":{regex:/[a-zA-Z]/},"*":{regex:/[0-9a-zA-Z]/},"@":{regex:/[0-9a-zA-ZçáàãâéèêíìóòõôúùüñÇÁÀÃÂÉÈÊÍÌÓÒÕÔÚÙÜÑ]/},"h":{regex:/[0-9]/,check:Meio.Mask.upTo(23)},"d":{regex:/[0-9]/,check:Meio.Mask.upTo(31)},"m":{regex:/[0-9]/,check:Meio.Mask.upTo(12)}};for(var A=0;A<=9;A++){B[A]={regex:new RegExp("[0-"+A+"]")}}return B})());Meio.Mask.Fixed=new Class({Extends:Meio.Mask,options:{autoSetSize:false,placeholder:"_",removeIfInvalid:false,removeInvalidTrailingChars:true},initialize:function(A){this.parent(A);this.maskArray=this.options.mask.split("");this.maskMold=this.options.mask.replace(Meio.Mask.rulesRegex,this.options.placeholder);this.maskMoldArray=this.maskMold.split("");this.validIndexes=[];this.maskArray.each(function(C,B){if(!this.isFixedChar(C)){this.validIndexes.push(B)}},this);this.createUnmaskRegex()},link:function(A){this.parent(A);var B=this.element.get("value");if(B!=""){this.maskMoldArray=this.mask(B).split("")}if(this.options.autoSetSize){this.setSize()}return this},focus:function(A,B){this.element.set("value",this.maskMoldArray.join(""));if(this.options.selectOnFocus&&this.element.select){this.element.select()}this.parent(A,B)},blur:function(A,C){this.parent(A,C);var B=this.element.get("value");if(this.options.removeIfInvalid){if(B.contains(this.options.placeholder)){this.maskMoldArray=this.maskMold.split("");this.element.set("value","")}return true}if(this.options.removeInvalidTrailingChars){this.element.set("value",this.removeInvalidTrailingChars(B))}return true},keypress:function(J,D){if(this.ignore){return true}J.preventDefault();var K=String.fromCharCode(J.code),E=this.maskArray,C,G,B;if(!D.isSelection){var H;if(D.isBksKey){do{C=this.validIndexes.indexOf(--D.range.start)}while(C==-1&&D.range.start>=0);H=this.validIndexes[C]||0}else{do{C=this.validIndexes.indexOf(D.range.start++)}while(C==-1&&D.range.start<E.length);H=(C==-1)?this.maskMoldArray.length:this.validIndexes[C+1]}G=this.validIndexes[C];if(!(B=this.testEvents(G,K,J.code,D.isRemoveKey))){return true}if(typeof B=="string"){K=B}this.maskMoldArray[G]=(D.isRemoveKey)?this.options.placeholder:K;var L=(H==null)?this.maskMoldArray.length:H;this.element.set("value",this.maskMoldArray.join("")).setCaretPosition(L)}else{var A=D.range.start,I=D.range.end,F;do{C=this.validIndexes.indexOf(D.range.start++)}while(C==-1&&D.range.start<E.length);do{F=this.validIndexes.indexOf(D.range.end++)}while(F==-1&&D.range.end<E.length);if(!(F-C)){return true}for(G=A;G<I;G++){this.maskMoldArray[G]=this.maskMold.charAt(G)}if(!D.isRemoveKey){G=this.validIndexes[C];if(!(B=this.testEvents(G,K,J.code,D.isRemoveKey))){return true}if(typeof B=="string"){K=B}this.maskMoldArray[G]=K;C++}this.element.set("value",this.maskMoldArray.join(""));this.element.setCaretPosition(this.validIndexes[C])}return this.parent()},paste:function(B,C){var A=this.applyMask(this.element.get("value"),C.range.start);this.maskMoldArray=A.value;this.element.set("value",this.maskMoldArray.join("")).setCaretPosition(A.rangeStart);return true},removeInvalidTrailingChars:function(E){var B=E.length,D=this.options.placeholder,C=E.length-1,A;while(C>=0){A=false;while(this.isFixedChar(E.charAt(C))&&E.charAt(C)!==D){if(C==0){B=0}A=true;C--}while(E.charAt(C)===D){B=C;A=true;C--}if(!A){break}}return E.substring(0,B)},testEvents:function(D,A,E,G){var C=this.maskArray,F=Meio.Mask.rules[C[D]],H;if(!G){var B=[this.element,E,A];if(!F||!(H=this.testEntry(this.element.get("value"),D,A))){this.fireEvent("invalid",B);return false}this.fireEvent("valid",B)}return(H!=null)?H:true},shouldFocusNext:function(){return this.unmask(this.element.get("value")).length>=this.validIndexes.length},createUnmaskRegex:function(){var A=[].combine(this.options.mask.replace(Meio.Mask.rulesRegex,"").split(""));var B=(A.join("")+this.options.placeholder).escapeRegExp();this.unmaskRegex=B?new RegExp("["+B+"]","g"):null},testEntry:function(F,D,A){var C=this.maskArray,E=Meio.Mask.rules[C[D]],B=(E&&E.regex.test(A));return(E.check&&B)?E.check(F,D,A):B},applyMask:function(H,D){var A=H.split(""),C=this.maskArray,E=this.maskMoldArray,G=Meio.Mask.rules,B=0,F;while(B<E.length){if(!A[B]){A[B]=E[B]}else{if(G[C[B]]){if(!(F=this.testEntry(H,B,A[B]))){A.splice(B,1);continue}else{if(typeof F=="string"){A[B]=F}}newStartRange=B}else{if(C[B]!=A[B]){A.splice(B,0,E[B])}else{A[B]=E[B]}}}B++}return{value:A.slice(0,this.maskMold.length),rangeStart:D+1}},mask:function(A){A=this.applyMask(A).value.join("");if(this.options.removeInvalidTrailingChars){A=this.removeInvalidTrailingChars(A)}return A},unmask:function(A){return this.unmaskRegex?A.replace(this.unmaskRegex,""):A}});Meio.Mask.createMasks("Fixed",{"Phone":{mask:"(99) 9999-9999"},"PhoneUs":{mask:"(999) 999-9999"},"Cpf":{mask:"999.999.999-99"},"Cnpj":{mask:"99.999.999/9999-99"},"Date":{mask:"3d/1m/9999"},"DateUs":{mask:"1m/3d/9999"},"Cep":{mask:"99999-999"},"Time":{mask:"2h:59"},"Cc":{mask:"9999 9999 9999 9999"}});Meio.Mask.Reverse=new Class({Extends:Meio.Mask,options:{autoSetSize:false,autoEmpty:false,alignText:true,symbol:"",precision:2,decimal:",",thousands:".",maxLength:18},initialize:function(A){this.parent(A);var C=this.options.thousands,D=C.escapeRegExp(),B=this.options.decimal.escapeRegExp();this.maxlength=this.options.maxLength;this.reThousands=/(\d+)(\d{3})/;this.reRemoveLeadingZeros=/^0+(.*)$/;this.reDecimalNumber=/^\d$/;this.thousandsReplaceStr="$1"+C+"$2";this.reThousandsReplace=new RegExp(D,"g");this.reCleanup=new RegExp("["+D+B+"]","g");this.reRemoveNonNumbers=new RegExp("[^\\d"+D+B+"]","g")},link:function(A){this.parent(A);if(this.options.alignText){this.element.setStyle("text-align","right")}var B=this.element.get("value");if(B===""&&!this.options.autoEmpty){this.element.set("value",this.forceMask(B,false))}return this},focus:function(C,D){var A=this.element,B=A.get("value");if(this.options.autoEmpty){if(B===""){A.set("value",(B=this.mask(B)))}}else{A.set("value",(B=this.getValue(B,true)))}if(this.options.selectOnFocus){A.selectRange(this.options.symbol.length,B.length)}this.parent(C,D)},blur:function(C,D){this.parent(C,D);var A=this.element,B=this.getValue(A.get("value"));if(this.options.autoEmpty&&this.mask(B)==this.mask()){B=""}A.set("value",B)},keypress:function(B,D){if(this.ignore){return true}B.preventDefault();var A=this.getCurrentState(B,D),C=A.value;if(!this.testEvents(C,A._char,B.code,D.isRemoveKey)){return true}C=this.forceMask(C,true);this.element.set("value",C).setCaretPosition(C.length);return this.parent()},testEvents:function(F,A,C,E){var B=[this.element,C,A];if(!E){var D=this.getValue(F,false).length;if(!(this.reDecimalNumber).test(A)||(this.maxlength&&D>this.maxlength)){this.fireEvent("invalid",B);return false}this.fireEvent("valid",B)}return true},paste:function(B,C){var A=this.element;elValue=A.get("value");A.set("value",(elValue=this.forceMask(elValue,true))).setCaretPosition(elValue.length);return true},forceMask:function(E,D){E=this.cleanup(E);var A=this.options.precision;var B=A+1-E.length;if(B>0){E=this.zeroize(E,B)}if(A){var C=E.length-A;E=E.substring(0,C)+this.options.decimal+E.substring(C)}return this.getValue(this.maskThousands(E),D)},cleanup:function(A){return this.getValue(A.replace(this.reCleanup,"")).replace(this.reRemoveLeadingZeros,"$1")},mask:function(A){A=this.unmask(A||"0").replace(".",this.options.decimal);return this.getValue(this.maskThousands(A),false)},unmask:function(A){return this.toNumber(this.getValue(A))},toNumber:function(B){B=B.replace(this.reRemoveNonNumbers,"");if(!isFinite(B)){if(this.options.thousands){B=B.replace(this.reThousandsReplace,"")}var A=this.options.decimal;if(A){B=B.replace(A,".")}}return B.toFloat().toFixed(this.options.precision)},getValue:function(C,B){var A=this.options.symbol;return(C.substring(0,A.length)===A)?B?C:C.substring(A.length):B?A+C:C},maskThousands:function(A){if(this.options.thousands){while(this.reThousands.test(A)){A=A.replace(this.reThousands,this.thousandsReplaceStr)}}return A},zeroize:function(B,A){while(A--){B="0"+B}return B},shouldFocusNext:function(){return this.getValue(this.element.get("value"),false).length>=this.options.maxLength}});Meio.Mask.createMasks("Reverse",{"Integer":{precision:0,maxLength:18},"Decimal":{},"DecimalUs":{thousands:",",decimal:"."},"Reais":{symbol:"R$ "},"Dollar":{symbol:"US$ ",thousands:",",decimal:"."}});Meio.Mask.Repeat=new Class({Extends:Meio.Mask,options:{mask:"",maxLength:0},keypress:function(D,F){if(this.ignore){return true}D.preventDefault();var C=this.getCurrentState(D,F);var E=Meio.Mask.rules[this.options.mask.charAt(0)].regex;var B=[this.element,C._char,D.code];var A=this.options.maxLength;if((A&&C.value.length>A)||(!E.test(C._char)&&!F.isRemoveKey)){this.fireEvent("invalid",B)}else{this.fireEvent("valid",B);this.element.set("value",C.value).setCaretPosition(C.start+(F.isRemoveKey?0:1))}return this.parent()},paste:function(B,C){var A=this.mask(this.element.get("value"));this.element.set("value",A).setCaretPosition(A.length)},mask:function(E){var B=E.split(""),D=Meio.Mask.rules[this.options.mask.charAt(0)].regex;for(var C=0;C<B.length;C++){if(!D.test(B[C])){B.splice(C,1);C--}}var A=this.options.maxLength;return B.join("").substring(0,A?A:B.length)}});Meio.Mask.Regexp=new Class({Extends:Meio.Mask,options:{regex:null},initialize:function(B,A){this.parent(B,A);this.regex=new RegExp(this.options.regex)},keypress:function(C,D){if(this.ignore){return true}C.preventDefault();var B=this.getCurrentState(C,D);var A=[this.element,B._char,C.code];if(!this.regex.test(B.value)){this.fireEvent("invalid",A)}else{this.element.set("value",B.value).setCaretPosition(B.start+(D.isRemoveKey?0:1));this.fireEvent("valid",A)}return true},paste:function(B,C){var A=this.applyMask(this.element.get("value"),true);this.element.set("value",A.value).setCaretPosition(A.index)},applyMask:function(E,C){var A="",D;for(var B=1;B<=E.length;B++){D=E.substring(0,B);if(!this.regex.test(D)){if(C){this.fireEvent("invalid",[this.element,E.charAt(B),E.charCodeAt(B)])}break}A=D}return{value:A,index:B}},mask:function(A){return this.applyMask(A).value}});Meio.Mask.createMasks("Regexp",{"Ip":{regex:/^(\d{0,3}\.){0,3}(\d{0,3})?$/},"Email":{regex:/^[\w.!#$%&'*+=?~^_`{|}\/-]*@?[.\w-]*$/}});(function(){var D="meiomask";var A=function(F){return F.camelCase().capitalize()};var E=function(H,G,I){var F;if($type(H)=="string"){if($type(G)!="string"){I=G;H=H.split(".");G=H[1];H=H[0]}F=Meio.Mask[A(H)];if(G){F=F[A(G)]}}else{F=H;I=G}return{klass:F,options:I||{}}};var C=function(G,F){co=E.apply(null,F);return new co.klass(co.options)[G](this)};String.implement({meiomask:function(){return C.call(this,"mask",arguments)},meiounmask:function(){return C.call(this,"unmask",arguments)}});Element.Properties.meiomask={set:function(){var G=E.apply(null,arguments),F=this.retrieve(D);if(F){F.unlink();F=null}return this.store(D,new G.klass(G.options).link(this))},get:function(){return this.retrieve(D)},erase:function(){var F=this.retrieve(D);if(F){F.unlink()}return this}};Element.Properties[D+":value"]={set:function(G){var F=this.retrieve(D);if(F){G=F.mask(G)}return this.set("value",G)},get:function(){var F=this.retrieve(D);var G=this.get("value");return(F)?F.unmask(G):G}};Element.implement({meiomask:function(F,H,G){return this.set(D,F,H,G)}});var B=document.createElement("input").getAttribute("maxLength");if(B!=null){Element.Properties.maxlength=Element.Properties.maxLength={get:function(){var F=this.getAttribute("maxLength");return F==B?null:F}}}})()