﻿<%@ page language="C#" masterpagefile="~/Commons/Main.master" autoeventwireup="true" inherits="Trade_RoomEdit, App_Web_uum3qgjl" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cphMain" Runat="Server">

      <script>
          function openSearch() {
              if (document.getElementById('ctl00_cphMain_txtKeyword').value != "") {
                  openFancybox('../Member/Search.aspx?type=1&q=' + document.getElementById('ctl00_cphMain_txtKeyword').value);
              }
              else {
                  openFancybox('../Member/Search.aspx?type=1');
              }
          }
      </script>

      <div class="content-wrapper">

        <section class="content-header">
          <h1>
            <asp:Label ID="lblTitle" runat="server" Text="房台消费"></asp:Label>
          </h1>
          <ol class="breadcrumb">
            <li><a href="../"><i class="fa fa-home"></i> 首页</a></li>
            <li class="active">房台消费</li>
          </ol>
        </section>
          
        <asp:ScriptManager id="ScriptManager1"  runat="server"></asp:ScriptManager>
    
        <asp:UpdatePanel ID="UpdatePanel1" runat="server" UpdateMode="Conditional">
            <ContentTemplate>
        
                <section class="content">

                    <div class="row">

                        <div class="col-md-6">
                    
                            <div class="box">

                                <div class="box-header">
                                    <h3 class="box-title">查找会员</h3>
                                </div>

                                <div class="box-body" style="border-top:solid 1px #eee; overflow:auto;">
                                
                                    <div class="input-group">
                                        <asp:TextBox ID="txtKeyword" runat="server" CssClass="form-control" placeholder="请输入会员姓名/卡号/手机号" AutoComplete="off"></asp:TextBox>
                                        <div class="input-group-btn">
                                            <asp:HyperLink ID="hlSearch" runat="server" CssClass="btn btn-default" onclick="openSearch()"><i class="fa fa-search"></i> 查询</asp:HyperLink>
                                            <asp:Button ID="btnSK" runat="server" Text="散客" CssClass="btn btn-success" OnClick="btnSK_Click"></asp:Button>
                                        </div>
                                    </div>

                                    <div style="display:none">
                                        <asp:TextBox ID="txtCustomerID" runat="server"></asp:TextBox>
                                    </div>

                                    <div style="padding:10px;">
                                        <table style="margin-left:5px;">
                                            <tr>
                                                <td style="width:50px">
                                                    姓名：
                                                </td>
                                                <td style="color:#FF0000; text-align:left; width:150px">
                                                    <asp:TextBox ID="lblFullName" runat="server" Text="XXX" style="color:#FF0000; border:0px; width:120px;" onfocus="this.blur()"></asp:TextBox>
                                                </td>
                                                <td style="width:50px">
                                                    等级：
                                                </td>
                                                <td style="color:#FF0000; text-align:left; width:150px">
                                                    <asp:TextBox ID="lblLevelName" runat="server" Text="XXX" style="color:#FF0000; border:0px; width:120px;" onfocus="this.blur()"></asp:TextBox>
                                                </td>
                                                <td style="width:50px">
                                                    余额：
                                                </td>
                                                <td style="color:#FF0000; text-align:left; width:150px">
                                                    <asp:TextBox ID="lblBalance" runat="server" Text="XXX" style="color:#FF0000; border:0px; width:120px;" onfocus="this.blur()"></asp:TextBox>
                                                </td>
                                                <td style="width:50px">
                                                    积分：
                                                </td>
                                                <td style="color:#FF0000; text-align:left; width:150px">
                                                    <asp:TextBox ID="lblPoints" runat="server" Text="XXX" style="color:#FF0000; border:0px; width:120px;" onfocus="this.blur()"></asp:TextBox>
                                                </td>
                                            </tr>
                                        </table>
                                        <asp:TextBox ID="txtVIPID" runat="server" style="display:none"></asp:TextBox>
                                        <asp:TextBox ID="txtStoreID" runat="server" style="display:none"></asp:TextBox>
                                    </div>

                                </div>

                             </div>
                    
                            <div class="box">

                                <div style="padding:0px 10px; margin-top:10px;">

                                  <div class="row">
                  
                                      <div class="col-md-6 form-group">
                                        <label><asp:Label ID="Label31" runat="server" Text="开始时间"></asp:Label></label>
                                        <asp:TextBox ID="txtStartTime" runat="server" CssClass="form-control" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" AutoComplete="off"></asp:TextBox>
                                      </div>
                  
                                      <div class="col-md-6 form-group">
                                        <label><asp:Label ID="Label32" runat="server" Text="预计结束"></asp:Label></label>
                                        <asp:TextBox ID="txtEndTime" runat="server" CssClass="form-control" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" AutoComplete="off"></asp:TextBox>
                                      </div>
                  
                                      <div class="col-md-12 form-group">
                                        <label><asp:Label ID="Label10" runat="server" Text="备注信息"></asp:Label></label>
                                        <asp:TextBox ID="txtRemark" runat="server" CssClass="form-control" AutoComplete="off" TextMode="MultiLine" Rows="5"></asp:TextBox>
                                      </div>
                  
                                  </div>

                                </div>
                                
                                <div class="box-footer" style="text-align:right">
                                    <asp:Button ID="btnAdd" runat="server" Text="开台" CssClass="btn btn-primary" OnClick="btnAdd_Click"></asp:Button>
                                    <asp:Button ID="btnBack" runat="server" Text="返回" CssClass="btn btn-back" OnClick="btnBack_Click"></asp:Button>
                                </div>

                             </div>

                        </div>
                
                        <div class="col-md-6">
                    
                            <div class="box">

                                <div class="box-header">
                                    <h3 class="box-title">开台记录</h3>
                                </div>
                        
                                <div class="input-group" style="border-top:solid 1px #eee; padding:10px">
                                    <asp:TextBox ID="txtSearch" runat="server" CssClass="form-control" placeholder="请输入会员名称/备注信息" AutoComplete="off"></asp:TextBox>
                                    <div class="input-group-btn">
                                        <asp:LinkButton ID="lnbSearch" runat="server" CssClass="btn btn-default" OnClick="lnbSearch_Click"><i class="fa fa-search"></i> 查询</asp:LinkButton>
                                    </div>
                                </div>

                                <div class="box-body" style=" overflow:auto;">
                                
                                    <asp:GridView ID="GridView2" runat="server" AutoGenerateColumns="False" GridLines="None" BorderWidth="0px" CssClass="table table-hover" OnRowDataBound="GridView2_RowDataBound">
                                        <Columns>
                                            <asp:TemplateField HeaderText="ID" Visible="false">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblID" runat="server" Text='<%# Bind("pk_Room") %>'></asp:Label>
                                                    <asp:Label ID="lblMemberID" runat="server" Text='<%# Bind("fk_Member") %>'></asp:Label>
                                                </ItemTemplate>
                                                <ItemStyle CssClass="id" />
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="会员">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblFullName" runat="server" Text='<%# Bind("FullName") %>'></asp:Label>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="开始时间">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblStartTime" runat="server" Text='<%# Bind("StartTime") %>'></asp:Label>
                                                </ItemTemplate>
                                                <ItemStyle Width="180px" />
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="结束时间">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblEndTime" runat="server" Text='<%# Bind("EndTime") %>'></asp:Label>
                                                </ItemTemplate>
                                                <ItemStyle Width="180px" />
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="备注信息">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblDescription" runat="server" Text='<%# Bind("Description") %>'></asp:Label>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="状态" SortExpression="StatusID">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblStatus" runat="server" Text='<%# Bind("StatusID") %>'></asp:Label>
                                                </ItemTemplate>
                                                <ItemStyle Width="80px" />
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="操作">
                                                <ItemTemplate>
                                                    <asp:HyperLink ID="gvEnd" runat="server" CssClass="fancybox link-black text-sm" NavigateUrl="#MemoDiv" ToolTip="消费结算"><span class="label label-danger"><i class="fa fa-ban"></i> 结束</span></asp:HyperLink>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                        </Columns>
                                    </asp:GridView>
                    
                                    <div id="pager">
                                       <webdiyer:AspNetPager ID="ListPager" runat="server" OnPageChanged="ListPager_PageChanged"></webdiyer:AspNetPager>
                                    </div>
        
                                </div>

                             </div>

                        </div>

                    </div>

                </section>

            </ContentTemplate>
            <Triggers>
               <asp:AsyncPostBackTrigger ControlID="btnOrder" EventName="Click" />
            </Triggers>
        </asp:UpdatePanel>

      </div>
    
      <script type="text/javascript">

          function openPanel(id, memberId, timer, info) {
              document.getElementById("ctl00_cphMain_txtID").value = id;
              document.getElementById("ctl00_cphMain_txtMemberID").value = memberId;
              document.getElementById("ctl00_cphMain_txtTimer").value = timer;
              document.getElementById("ctl00_cphMain_lblMemberInfo").innerHTML = info;
          }

      </script>

      <div id="MemoDiv" style="display:none; width:500px;">
            
          <div class="box-body">
          
                <div class="form-group" style="font-size:11pt; font-weight:700; border-bottom:dashed 1px #ddd; padding-bottom:15px; color:#008000">
                    <asp:Label ID="lblMemberInfo" runat="server"></asp:Label>
                    <asp:TextBox ID="txtID" runat="server" style="display:none;"></asp:TextBox>
                    <asp:TextBox ID="txtMemberID" runat="server" style="display:none;"></asp:TextBox>
                </div>
                  
                <asp:UpdatePanel ID="UpdatePanel2" runat="server" UpdateMode="Conditional">
                    <ContentTemplate>
        
                      <div class="form-group">
                          <label><asp:Label ID="Label5" runat="server" Text="消费时长（分钟）"></asp:Label></label>
                          <asp:TextBox ID="txtTimer" runat="server" CssClass="form-control" AutoComplete="off" onfocus="this.blur()"></asp:TextBox>
                      </div>
                  
                      <div class="form-group">
                          <label><asp:Label ID="Label1" runat="server" Text="应付金额"></asp:Label></label>
                          <asp:TextBox ID="txtYingFu" runat="server" CssClass="form-control" AutoComplete="off" style="font-size:12pt; font-weight:700; color:red" onfocus="select()" AutoPostBack="True" OnTextChanged="ChangePrice_TextChanged"></asp:TextBox>
                      </div>
                  
                      <div class="form-group">
                          <label><asp:Label ID="Label2" runat="server" Text="实收金额"></asp:Label></label>
                          <asp:TextBox ID="txtShiFu" runat="server" CssClass="form-control" AutoComplete="off" style="font-size:12pt; font-weight:700; color:red" onfocus="select()" AutoPostBack="True" OnTextChanged="ChangePrice_TextChanged"></asp:TextBox>
                      </div>
                  
                      <div class="form-group">
                          <label><asp:Label ID="Label3" runat="server" Text="找零金额"></asp:Label></label>
                          <asp:TextBox ID="txtZhaoLing" runat="server" CssClass="form-control" AutoComplete="off" style="font-size:12pt; font-weight:700; color:red" onfocus="this.blur()"></asp:TextBox>
                      </div>
                  
                      <div class="form-group">
                          <label><asp:Label ID="Label4" runat="server" Text="付款方式"></asp:Label></label>
                          <asp:DropDownList ID="ddlPayType" runat="server" CssClass="form-control select2"></asp:DropDownList>
                      </div>
                  
                      <div class="form-group">
                          <label><asp:Label ID="Label6" runat="server" Text="订单备注"></asp:Label></label>
                          <asp:TextBox ID="txtOrderRemark" runat="server" CssClass="form-control" TextMode="MultiLine" Rows="5"></asp:TextBox>
                      </div>
                  
                    </ContentTemplate>
                </asp:UpdatePanel>

              <div class="pull-right">
                  <asp:Button ID="btnOrder" runat="server" Text="结算" CssClass="btn btn-primary" OnClick="btnOrder_Click"></asp:Button>
              </div>

          </div>

      </div>

</asp:Content>