﻿<%@ page language="C#" autoeventwireup="true" inherits="Default_OrderList, App_Web_aa0rsauf" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black" />
    <meta name="format-detection" content="telephone=no" />
    <link rel="shortcut icon" href="../Images/favicon.ico" type="image/x-icon" />
    <%=MainCss%>
    <script src="js/jquery.min.js" type="text/javascript"></script>
    <script src="js/main.js" type="text/javascript"></script>
    
    <script type="text/javascript">

        $(window).scroll(function () {
            var scrolls = $(window).scrollTop()
            if (scrolls > 10) {
                $("#topwrap").addClass("fixed")
            } else {
                $("#topwrap").removeClass("fixed")
            }

            if ($(window).scrollTop() > 200) {
                $('#GoTop').show();
            }
            else {
                $('#GoTop').hide();
            }
        });

        $(document).ready(function () {
            $('#GoTop').click(function () { $('html, body').animate({ scrollTop: 0 }, 'slow'); });
        });

        function getMore()
        {
            __doPostBack('lnbMore','');
        }
        
        function cancelOrder(orderID,orderNum)
        {
            document.getElementById('btn1').style.display = '';
            document.getElementById('EditPanelTitle').innerText = "取消订单";
            document.getElementById('txtTypeID').value = "0";
            document.getElementById('txtOrderID').value = orderID;
            document.getElementById('EditPanel').style.display = '';
            document.getElementById('lblOrderNum').innerText = orderNum;
        }
        
        function completeOrder(orderID,orderNum)
        {
            document.getElementById('btn1').style.display = '';
            document.getElementById('EditPanelTitle').innerText = "确认收货";
            document.getElementById('txtTypeID').value = "1";
            document.getElementById('txtOrderID').value = orderID;
            document.getElementById('EditPanel').style.display = '';
            document.getElementById('lblOrderNum').innerText = orderNum;
        }

        function returnOrder(orderID, orderNum) {
            document.getElementById('btn1').style.display = '';
            document.getElementById('EditPanelTitle').innerText = "退货";
            document.getElementById('txtTypeID').value = "2";
            document.getElementById('txtOrderID').value = orderID;
            document.getElementById('EditPanel').style.display = '';
            document.getElementById('lblOrderNum').innerText = orderNum;
        }

        function completeReturn(orderID, orderNum) {
            document.getElementById('btn1').style.display = '';
            document.getElementById('EditPanelTitle').innerText = "确认退货";
            document.getElementById('txtTypeID').value = "3";
            document.getElementById('txtOrderID').value = orderID;
            document.getElementById('EditPanel').style.display = '';
            document.getElementById('lblOrderNum').innerText = orderNum;
        }

        function resetOrder()
        {
            document.getElementById('txtOrderID').value = '';
            document.getElementById('EditPanel').style.display = 'none';
        }
        
        function sendPush(orderID, orderNum)
        {
            document.getElementById('txtOrderID').value = orderID;
            document.getElementById('txtOrderNum').value = orderNum;
            __doPostBack('lnbSendPush','');
        }

    </script>
    
</head>

<body style="background:#f2f2f2">

<form id="form1" runat="server">

<asp:ScriptManager id="ScriptManager1"  runat="server"></asp:ScriptManager>
    
<header>

    <div class="topbar">
        <a href="Member.aspx" class="back_btn"><i class="icon iconfont">&#xf0115;</i></a>
        <a href="Chat.aspx" class="top_home"><i class="icon iconfont">&#xf0200;</i></a>

        <h1 class="page_title"><asp:Label ID="lblTitle" runat="server"></asp:Label></h1>
    </div>

</header>
    
<asp:UpdatePanel ID="UpdatePanel1" runat="server" UpdateMode="Conditional">
    <ContentTemplate>
        
        <div id="topwrap">
                
            <div class="news_search" style="border-bottom:solid 1px #eee; padding-bottom:10px; background:#fff;">
                <div class="news_search_div">
                    <asp:TextBox ID="txtKeyword" runat="server" placeholder="输入搜索关键字" CssClass="news_search_txt"></asp:TextBox>
                    <asp:LinkButton ID="lnbSearch" runat="server" CssClass="news_search_btn" OnClick="lnbSearch_Click"><i class="icon iconfont">&#xf00a8;</i></asp:LinkButton>
                </div>
            </div>

            <div class="sort">
                <ul>
                    <li><asp:LinkButton ID="lnbSearch1" runat="server" OnClick="lnbSearch1_Click" CssClass="cur"><span>全部</span><small>|</small></asp:LinkButton></li>
                    <li><asp:LinkButton ID="lnbSearch2" runat="server" OnClick="lnbSearch2_Click"><span>新订单</span><small>|</small></asp:LinkButton></li>
                    <li><asp:LinkButton ID="lnbSearch3" runat="server" OnClick="lnbSearch3_Click"><span>进行中</span><small>|</small></asp:LinkButton></li>
                    <li><asp:LinkButton ID="lnbSearch4" runat="server" OnClick="lnbSearch4_Click"><span>已完成</span></asp:LinkButton></li>
                </ul>
            </div>

        </div>

        <div id="ListDiv" runat="server"></div>
        
        <asp:LinkButton ID="lnbMore" runat="server" OnClick="lnbMore_Click"></asp:LinkButton>
        
        <asp:LinkButton ID="lnbSendPush" runat="server" OnClick="lnbSendPush_Click"></asp:LinkButton>
                
        <asp:TextBox ID="txtTypeID" runat="server" style="display:none"></asp:TextBox>
            
        <asp:TextBox ID="txtOrderID" runat="server" style="display:none"></asp:TextBox>
            
        <asp:TextBox ID="txtOrderNum" runat="server" style="display:none"></asp:TextBox>
        
        <div id="EditPanel" style="display:none;">
            <div id="shut" class="edit-shut"></div>
            <div class="edit-wrap" style="top:150px; height:150px;">
                <div id="title" class="edit-title"><asp:Label ID="EditPanelTitle" runat="server"></asp:Label></div>
                <div class="edit-content" style="margin:0; padding:10px;">
                    <div style="text-align:center; padding:5px 0;">订单编号：<asp:Label ID="lblOrderNum" runat="server"></asp:Label></div>
                </div>
                <div id="btn1" class="edit-button">
                    <asp:LinkButton ID="lnbSubmit" runat="server" class="add_cart" style="width:80px; line-height:30px; height:30px; margin:0;" OnClick="lnbSubmit_Click">确定</asp:LinkButton>&nbsp;
                    <a href="javascript:void(0);" onclick="resetOrder();" class="liji_buy" style="width:80px; line-height:30px; height:30px; margin:0; background:#999;">取消</a>
                </div>
            </div>
        </div>
         
        <div id="attention-dialog" class="attention-layout"></div>

        <div id="GoTop"></div>
         
    </ContentTemplate>
</asp:UpdatePanel>

</form>

</body>
</html>