﻿<%@ page language="C#" masterpagefile="../Commons/Main.master" autoeventwireup="true" inherits="Member_List, App_Web_dsihafmx" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cphMain" Runat="Server">

      <div class="content-wrapper">

        <section class="content-header">
          <h1>
            会员管理
          </h1>
          <ol class="breadcrumb">
            <li><a href="../"><i class="fa fa-home"></i> 首页</a></li>
            <li class="active">会员管理</li>
          </ol>
        </section>

        <section class="content">

          <div class="row">
            <div class="col-xs-12">
              <div class="box">

                <div class="box-header">
                  <h3 class="box-title">
                      <asp:HyperLink ID="hlAdd" runat="server"><span class="label label-success"><i class="fa fa-plus"></i> 新增</span></asp:HyperLink>
                      <asp:LinkButton ID="lnbExport" runat="server" OnClick="lnbExport_Click"><span class="label label-success"><i class="fa fa-file-excel-o"></i> 导出</span></asp:LinkButton>
                      <asp:HyperLink ID="hlImport" runat="server" NavigateUrl="#ImportDiv" CssClass="fancybox" ToolTip="导入"><span class="label label-primary"><i class="fa fa-mail-reply"></i> 导入</span></asp:HyperLink>
                      <asp:LinkButton ID="lnbBirthday" runat="server" onclick="lnbBirthday_Click"><span class="label label-warning"><i class="fa fa-birthday-cake"></i> 生日</span></asp:LinkButton>
                  </h3>
                </div>
                  
              <div class="row" style="padding:10px">
                  
                  <div class="col-md-3 form-group">
                    <label><asp:Label ID="Label9" runat="server" Text="卡号/手机/姓名"></asp:Label></label>
                    <asp:TextBox ID="txtKeyword" runat="server" CssClass="form-control" AutoComplete="off"></asp:TextBox>
                  </div>
                  
                  <div class="col-md-3 form-group">
                    <div style="margin-top:25px;">
                        <asp:Button ID="btnSearch" runat="server" Text="搜索" CssClass="btn btn-primary" onclick="btnSearch_Click"></asp:Button>
                        <asp:Button ID="btnClear" runat="server" Text="重置" CssClass="btn btn-success" onclick="btnClear_Click"></asp:Button>
                    </div>
                  </div>
                  
              </div>
              
                <div class="box-body table-responsive no-padding">

                    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" GridLines="None" BorderWidth="0px" CssClass="table table-hover" AllowSorting="True" OnSorting="GridView1_Sorting" OnRowDataBound="GridView1_RowDataBound" OnRowCommand="GridView1_RowCommand" OnRowCreated="GridView1_RowCreated">
                        <Columns>
                            <asp:TemplateField HeaderText="ID" SortExpression="pk_Member" Visible="false">
                                <ItemTemplate>
                                    <asp:Label ID="lblID" runat="server" Text='<%# Bind("pk_Member") %>'></asp:Label>
                                </ItemTemplate>
                                <ItemStyle CssClass="id" />
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="">
                                <ItemTemplate>
                                    <asp:Label ID="lblThumbnail" runat="server" Text='<%# Bind("ImagePath") %>'></asp:Label>
                                </ItemTemplate>
                                <ItemStyle Width="50px" />
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="卡号">
                                <ItemTemplate>
                                    <asp:Label ID="lblUserName" runat="server" Text='<%# Bind("UserName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="手机">
                                <ItemTemplate>
                                    <asp:Label ID="lblPhone1" runat="server" Text='<%# Bind("Phone1") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="姓名">
                                <ItemTemplate>
                                    <asp:Label ID="lblFullName" runat="server" Text='<%# Bind("FullName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="性别">
                                <ItemTemplate>
                                    <asp:Label ID="lblSex" runat="server" Text='<%# Bind("Sex") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="生日">
                                <ItemTemplate>
                                    <asp:Label ID="lblBirthday" runat="server" Text='<%# Bind("Birthday") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="开卡日期">
                                <ItemTemplate>
                                    <asp:Label ID="lblCheckDate" runat="server" Text='<%# Bind("CheckDate") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="锁定">
                                <ItemTemplate>
                                    <asp:CheckBox ID="cbLock" runat="server" Checked='<%# Bind("IsLock") %>' Enabled="False" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="等级" SortExpression="LevelID">
                                <ItemTemplate>
                                    <asp:Label ID="lblLevelID" runat="server" Text='<%# Bind("LevelID") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="余额" SortExpression="Powers">
                                <ItemTemplate>
                                    <asp:Label ID="lblPowers" runat="server" Text='<%# Bind("Powers") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="积分" SortExpression="Point">
                                <ItemTemplate>
                                    <asp:Label ID="lblPoint" runat="server" Text='<%# Bind("Point") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="操作">
                                <ItemTemplate>
                                    <asp:HyperLink ID="gvEdit" runat="server" ToolTip="修改"><span class="label label-primary"><i class="fa fa-edit"></i> 修改</span></asp:HyperLink>
                                    <asp:HyperLink ID="gvMessage" runat="server" ToolTip="消息"><span class="label label-success"><i class="fa fa-envelope-o"></i> 消息</span></asp:HyperLink>
                                    <asp:HyperLink ID="gvSMS" runat="server" ToolTip="短信"><span class="label label-success"><i class="fa fa-paper-plane"></i> 短信</span></asp:HyperLink>
                                    <asp:LinkButton ID="gvDelete" runat="server" ToolTip="删除" CommandName="_delete"><span class="label label-danger"><i class="fa fa-remove"></i> 删除</span></asp:LinkButton>
                                </ItemTemplate>
                                <ItemStyle Width="250px" />
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                    
                    <div id="pager">
                       <webdiyer:AspNetPager ID="ListPager" runat="server" OnPageChanged="ListPager_PageChanged"></webdiyer:AspNetPager>
                    </div>
        
                </div>
                
              </div>
            </div>
          </div>

        </section>

      </div>
    
      <div id="ImportDiv" style="display:none; width:500px;">
            
        <div class="box-body">
            
            <div class="col-md-12 form-group" style="padding:0px 15px">
            <div class="form-group">
                <div class="btn btn-default btn-file">
                    <i class="fa fa-upload"></i> 选择Excel文件
                    <asp:FileUpload ID="fuImport" runat="server" onchange="ChkUpload(this);" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel"></asp:FileUpload>
                    <span id="filepath"></span>
                </div>
            </div>
            </div>
                        
            <div class="pull-right">
                <span class="tips"><a href="../Files/会员信息报表.xls">下载导入模板</a></span>&nbsp;&nbsp;&nbsp;
                <asp:LinkButton ID="lnbImport" runat="server" CssClass="btn btn-primary" onclick="lnbImport_Click" OnClientClick="{return confirm('确定导入吗？');}">导入</asp:LinkButton>
            </div>

        </div>

      </div>
    
</asp:Content>