# ez-vcard

[![npm](https://img.shields.io/npm/v/ez-vcard)](https://www.npmjs.com/package/ez-vcard)

It is a vCard generator written in TypeScript for NodeJS that uses amazing [ez-vcard library written in Java][ez-vcard].
It can read and write vCards in many different formats. The "ez" stands for "easy" because the goal is to create a library that's easy to use.

## Getting started

1. Install JDK
   - Ubuntu / WSL: `sudo apt install default-jdk`
   - Windows: [download][jdk-download] and [install][jdk-install-docs]
1. Install `make` and `g++` on Ubuntu: `sudo apt install build-essential` (to build node-java dependency)
1. Install ez-vcard (this package)
   ```sh
   npm i ez-vcard
   ```

### Usage in NodeJS

```js
const ezVcard = require('ez-vcard').default;
(async () => {
  const vcard = await ezVcard({name: {first: 'Maxim'}});
  console.log(vcard);
})();
```

### Usage in TypeScript

```sh
npm install @types/node typescript
```

_src/vcard.ts_

```ts
import ezVcard from 'ez-vcard';

(async () => {
  const vcard = await ezVcard({name: {first: 'Maxim'}});
  console.log(vcard);
})();
```

_tsconfig.json_

```json
{
  "compilerOptions": {
    "esModuleInterop": true
  }
}
```

and run: `npx ts-node src/vcard.ts` or compile: `npx tsc --outDir dist`.

**Note:** the first run might take a while, because it downloads maven packages required for package to run. Subsequent runs will be much faster than the first one.

## Features

- Status: **It works!**
- [tsJavaModule.ts](src/tsJavaModule.ts) file contains [ez-vcard][ez-vcard] TypeScript type definitions for [node-java][node-java] generated by [Maxim-Mazurok/ez-vcard-ts-java-types][ez-vcard-ts-java-types]
- [index.ts](src/index.ts) exports default function to generate vcard

[node-java]: https://github.com/joeferner/node-java
[ez-vcard]: https://github.com/mangstadt/ez-vcard
[jdk-download]: https://www.oracle.com/java/technologies/javase-downloads.html
[jdk-install-docs]: https://docs.oracle.com/en/java/javase/11/install/installation-jdk-microsoft-windows-platforms.html#GUID-BCE568C9-93D3-49F4-9B0C-9DD4A3419792
[ez-vcard-ts-java-types]: https://github.com/Maxim-Mazurok/ez-vcard-ts-java-types
