import { Icons } from "@/components/Icons";
import { Footer } from "@/components/layout/Footer";
import MainNav from "@/components/layout/MainNav";
import { DocsSearch } from "@/components/search";
import { docsConfig } from "@/config/docs";
import Link from "next/link";
import React from "react";

interface DocsLayoutProps {
  children: React.ReactNode;
}

const DocsLayout = ({ children }: DocsLayoutProps) => {
  return (
    <div className="flex min-h-screen flex-col">
      <header className="sticky top-0 z-40 w-full border-b bg-background">
        <div className="container flex h-16 items-center space-x-4 sm:justify-between sm:space-x-0">
          <MainNav items={docsConfig.mainNav} />
          {/* <DocsSidebarNav items={docsConfig.sidebarNav} /> */}
          {/* </MainNav> */}
          <div className="flex flex-1 items-center space-x-4 sm:justify-end">
            <div className="flex-1 sm:grow-0">
              <DocsSearch />
            </div>
            <nav className="flex space-x-4">
              <Link href="/" target="_blank" rel="noreferrer">
                <Icons.gitHub className="h-7 w-7" />
                <span className="sr-only">GitHub</span>
              </Link>
            </nav>
          </div>
        </div>
      </header>
      <div className="container flex-1">{children}</div>
      <Footer className="border-t" />
    </div>
  );
};

export default DocsLayout;
