# Contributing Guide

## Issues & Pull Requests (not for Profiles)

### Creating an Issue

Before **creating** an Issue for `features`/`bugs`/`improvements` please follow these steps:

1. search existing issues before creating a new issue (has someone raised this already)
1. if it doesn't exist create a new issue giving as much context as possible (please select the correct Issue type, for example `bug` or `feature`)
1. all Issues are automatically given the label `status: waiting for triage`. Please wait until the maintainers review the Issue and update the labels
1. look out for when the Issue label changes to `status: ready for dev`
1. comment on the Issue asking for it to be assigned to you (do not tag maintainers as all maintainers receive your comment notifications)
1. **only** start working on this issue (and open a Pull Request) when it has been assigned to you - this will prevent confusion, multiple people working on the same issue and work not being used.

### Working on an Issue (get it assigned to you)

Before working on an existing Issue please follow these steps:

1. only ask to be assigned 1 issue at a time
1. please do not ask to be assigned an issue that has the label `status: awaiting triage` - this creates more notifications for maintainers and it will not be assigned
1. look out for the Issue label `status: ready for dev` (if it does not have this label, your work might not be accepted)
1. comment asking for the issue to be assigned to you (do not tag any maintainers as all maintainers receive your comment notifications)
1. after the issue is assigned to you, you can start working on it
1. do **not** enable GitHub Actions on your fork
1. reference the Issue in your Pull Request (for example `closes #123`)

> Notes:
> - it is not sustainable for maintainers to review historical comments asking for assignments before the Issue label `status: ready for dev` was added; only requests for assignment of an Issue after this label has been added will be considered
> - any issues that have no activity after 2 weeks will be unassigned and re-assigned to someone else
> - only request to be assigned an issue if you know how to work on it
> - an issue can be assigned to multiple people, if you all agree to collaborate on the issue (the Pull Request can contain commits from different collaborators)
## Reviewing Pull Requests

We welcome everyone to review Pull Requests, it is a great way to learn and network.

### DOs
- be kind and respectful, we use inclusive, gender neutral language (for example `they/them` instead of `guy/man`)
- use inline comments to explain your suggestions
- use inline suggestions to propose changes

### DON'Ts
- don't be rude, disrespectful or aggressive
- do not repeat feedback, this creates more noise than value (check the existing conversation), use GitHub reactions if you agree/disagree with a comment
- do not blindly approve pull requests to improve your GitHub contributors graph

---
