
#author: Mahdi Safsafi.
#Convert gas test to pascal test.

#use: d2p.pl input output log.
#input = gas directory.
#output = pascal directory.
#log = log directory.
use File::Basename;

my %hash=(
		'xmmword'=>'oword',
		'ymmword'=>'yword',
		'zmmword'=>'zword',
		'rip+'=>'rip ',
		);

my $gasdir = $ARGV[0];#gas input directory.
my $pasdir = $ARGV[1];#pascal output directory.
my $logdir = $ARGV[2];#pascal log directory. 
		
sub gen($$$){
  my $input = shift;
  my $output = shift;
  my $cpux = shift;
  print"Working on : $output\n";
  my $id = 0;
  open F,$input;
  my @array=("TestCase.Arch := CPUX$cpux;\n");
  while (<F>) {
	chomp;
	if(s/^\s*\[\s+\]\*.+?\+:\s+?//){
		s/(.+?\s{2,})//;
		my $opcodes = $1;
		s/(^\s+)|(#.+)//g; #white space && comments.
		my $str = $_;
		$str=~s/^\s+|\s+$//g;
		$str=~s/\\//g;
		$opcodes=~s/([0-9a-f]{2})/\$$1/gi;
		my @opcodes = split(' ',$opcodes);
		$opcodes = join(',',@opcodes);
		
		foreach(keys %hash){
		my $v = $hash{$_};
		$str =~s/\Q$_\E/$v/gi;
		}
		$str=~s/ds\:(0x\w+)/ds:\[$1\]/;#encapsulate
		$str=~s/ptr//ig;
		$str=~s/\s+/ /xg;
		$str=~s/(^\w+)\s/$1  /x;
		# gas source uses disp8* N(N = 8) for vpgatherqd instruction,
		# However from Intel documentation N should be 4 (T1S).
		# Probably ,it's a bug. So i will skip this instruction.
		# ---------------------------------
		# gas convert displacement to [riz*x +/- offset] when register index zero.
		# riz*x = 0 ==> displacement = 0 +/- offset.
		# offset may not equal to displacement !
		# So it's useless to compare UnivDisp vs GasDisp.==> Need to implement new routine for that.
		# Temporally, I will skip.
		if($str !~/\b(riz|vpgatherqd)\b/){
		my $s = sprintf("TestCase.testcase(%d, [%-50s] , %-50s );",$id,uc($opcodes),lc("'$str'"));
		push(@array,$s);
		$id++;
		}
	}
}
	close F;
	open F,'>'.$output;
	my $fname = basename( $output, ".pas" );
	my $doc =<<"__@__";
unit $fname;

// This unit was generated by d2p.pl script.
// Source : $input

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('$fname');
  TestCase.Start();	
__@__
    print F "$doc";
	print F "  $_\n"foreach(@array);
	print F "  TestCase.Stop();\n";	
	print F "  TestCase.SaveToFile('$logdir$fname.log');\n";
	print F "end;\n\nend.";
	close F;
}

my @tests;

opendir(DIR, $gasdir) or die $!;
while (my $file = readdir(DIR)) {
    next if ($file =~ m/^\.|\.[^d]$/);#allow only *.d files
	my $pf = $file ; #pascal file name.
	if($pf=~m/\Qx86-64/){$pf=~s/\Qx86-64-/x64\./}else{$pf="x32.$file";}
	$pf=~s/\-/_/g;
	$pf=~s/_intel//g;
	$pf=basename($pf,'.d');
	my $cpux = ($pf=~m/^x64/)? 64: 32;
	gen("$gasdir$file","$pasdir$pf.pas",$cpux);
	push(@tests,"$pf");
    }
closedir(DIR);

@tests = sort @tests;
my $fname = sprintf("%sGlobalTest.pas",$pasdir);
open F,'>'.$fname;
print"Working on : $fname\n";
my @used_units = map{"  $_"}@tests;
my $used_units = join(",\n",@used_units);
my @testsproc = map{"  $_.Test();"}@tests;
my $testsproc = join("\n",@testsproc);
my $doc=<<"__@__";
unit GlobalTest;

// This unit was generated by d2p.pl script.

interface

uses
$used_units;
  
procedure TestAll();

implementation

procedure TestAll();
begin
$testsproc
end;

end.

__@__
print F $doc;
close F;

print"\nDone.\n";
