unit x64.simd;

// This unit was generated by d2p.pl script.
// Source : gas/x86-64-simd-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x64.simd');
  TestCase.Start();	
  TestCase.Arch := CPUX64;

  TestCase.testcase(0, [$F2,$0F,$D0,$0D,$78,$56,$34,$12                   ] , 'addsubps  xmm1,oword [rip 0x12345678]'            );
  TestCase.testcase(1, [$66,$0F,$2F,$0D,$78,$56,$34,$12                   ] , 'comisd  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(2, [$0F,$2F,$0D,$78,$56,$34,$12                       ] , 'comiss  xmm1,dword [rip 0x12345678]'              );
  TestCase.testcase(3, [$F3,$0F,$E6,$0D,$78,$56,$34,$12                   ] , 'cvtdq2pd  xmm1,qword [rip 0x12345678]'            );
  TestCase.testcase(4, [$F2,$0F,$E6,$0D,$78,$56,$34,$12                   ] , 'cvtpd2dq  xmm1,oword [rip 0x12345678]'            );
  TestCase.testcase(5, [$0F,$5A,$0D,$78,$56,$34,$12                       ] , 'cvtps2pd  xmm1,qword [rip 0x12345678]'            );
  TestCase.testcase(6, [$F3,$0F,$5B,$0D,$78,$56,$34,$12                   ] , 'cvttps2dq  xmm1,oword [rip 0x12345678]'           );
  TestCase.testcase(7, [$F3,$0F,$2A,$C8                                   ] , 'cvtsi2ss  xmm1,eax'                               );
  TestCase.testcase(8, [$F2,$0F,$2A,$C8                                   ] , 'cvtsi2sd  xmm1,eax'                               );
  TestCase.testcase(9, [$F3,$0F,$2A,$C8                                   ] , 'cvtsi2ss  xmm1,eax'                               );
  TestCase.testcase(10, [$F2,$0F,$2A,$C8                                   ] , 'cvtsi2sd  xmm1,eax'                               );
  TestCase.testcase(11, [$F3,$48,$0F,$2A,$C8                               ] , 'cvtsi2ss  xmm1,rax'                               );
  TestCase.testcase(12, [$F2,$48,$0F,$2A,$C8                               ] , 'cvtsi2sd  xmm1,rax'                               );
  TestCase.testcase(13, [$F3,$48,$0F,$2A,$C8                               ] , 'cvtsi2ss  xmm1,rax'                               );
  TestCase.testcase(14, [$F2,$48,$0F,$2A,$C8                               ] , 'cvtsi2sd  xmm1,rax'                               );
  TestCase.testcase(15, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [rax]'                       );
  TestCase.testcase(16, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [rax]'                       );
  TestCase.testcase(17, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [rax]'                       );
  TestCase.testcase(18, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [rax]'                       );
  TestCase.testcase(19, [$F3,$48,$0F,$2A,$08                               ] , 'cvtsi2ss  xmm1,qword [rax]'                       );
  TestCase.testcase(20, [$F2,$48,$0F,$2A,$08                               ] , 'cvtsi2sd  xmm1,qword [rax]'                       );
  TestCase.testcase(21, [$F2,$0F,$7C,$0D,$78,$56,$34,$12                   ] , 'haddps  xmm1,oword [rip 0x12345678]'              );
  TestCase.testcase(22, [$F3,$0F,$7F,$0D,$78,$56,$34,$12                   ] , 'movdqu  oword [rip 0x12345678],xmm1'              );
  TestCase.testcase(23, [$F3,$0F,$6F,$0D,$78,$56,$34,$12                   ] , 'movdqu  xmm1,oword [rip 0x12345678]'              );
  TestCase.testcase(24, [$66,$0F,$17,$0D,$78,$56,$34,$12                   ] , 'movhpd  qword [rip 0x12345678],xmm1'              );
  TestCase.testcase(25, [$66,$0F,$16,$0D,$78,$56,$34,$12                   ] , 'movhpd  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(26, [$0F,$17,$0D,$78,$56,$34,$12                       ] , 'movhps  qword [rip 0x12345678],xmm1'              );
  TestCase.testcase(27, [$0F,$16,$0D,$78,$56,$34,$12                       ] , 'movhps  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(28, [$66,$0F,$13,$0D,$78,$56,$34,$12                   ] , 'movlpd  qword [rip 0x12345678],xmm1'              );
  TestCase.testcase(29, [$66,$0F,$12,$0D,$78,$56,$34,$12                   ] , 'movlpd  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(30, [$0F,$13,$0D,$78,$56,$34,$12                       ] , 'movlps  qword [rip 0x12345678],xmm1'              );
  TestCase.testcase(31, [$0F,$12,$0D,$78,$56,$34,$12                       ] , 'movlps  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(32, [$66,$0F,$D6,$0D,$78,$56,$34,$12                   ] , 'movq  qword [rip 0x12345678],xmm1'                );
  TestCase.testcase(33, [$F3,$0F,$7E,$0D,$78,$56,$34,$12                   ] , 'movq  xmm1,qword [rip 0x12345678]'                );
  TestCase.testcase(34, [$F3,$0F,$16,$0D,$78,$56,$34,$12                   ] , 'movshdup  xmm1,oword [rip 0x12345678]'            );
  TestCase.testcase(35, [$F3,$0F,$12,$0D,$78,$56,$34,$12                   ] , 'movsldup  xmm1,oword [rip 0x12345678]'            );
  TestCase.testcase(36, [$F3,$0F,$70,$0D,$78,$56,$34,$12,$90               ] , 'pshufhw  xmm1,oword [rip 0x12345678],0x90'        );
  TestCase.testcase(37, [$F2,$0F,$70,$0D,$78,$56,$34,$12,$90               ] , 'pshuflw  xmm1,oword [rip 0x12345678],0x90'        );
  TestCase.testcase(38, [$0F,$60,$0D,$78,$56,$34,$12                       ] , 'punpcklbw  mm1,dword [rip 0x12345678]'            );
  TestCase.testcase(39, [$0F,$62,$0D,$78,$56,$34,$12                       ] , 'punpckldq  mm1,dword [rip 0x12345678]'            );
  TestCase.testcase(40, [$0F,$61,$0D,$78,$56,$34,$12                       ] , 'punpcklwd  mm1,dword [rip 0x12345678]'            );
  TestCase.testcase(41, [$66,$0F,$60,$0D,$78,$56,$34,$12                   ] , 'punpcklbw  xmm1,oword [rip 0x12345678]'           );
  TestCase.testcase(42, [$66,$0F,$62,$0D,$78,$56,$34,$12                   ] , 'punpckldq  xmm1,oword [rip 0x12345678]'           );
  TestCase.testcase(43, [$66,$0F,$61,$0D,$78,$56,$34,$12                   ] , 'punpcklwd  xmm1,oword [rip 0x12345678]'           );
  TestCase.testcase(44, [$66,$0F,$6C,$0D,$78,$56,$34,$12                   ] , 'punpcklqdq  xmm1,oword [rip 0x12345678]'          );
  TestCase.testcase(45, [$66,$0F,$2E,$0D,$78,$56,$34,$12                   ] , 'ucomisd  xmm1,qword [rip 0x12345678]'             );
  TestCase.testcase(46, [$0F,$2E,$0D,$78,$56,$34,$12                       ] , 'ucomiss  xmm1,dword [rip 0x12345678]'             );
  TestCase.testcase(47, [$F2,$0F,$C2,$00,$00                               ] , 'cmpeqsd  xmm0,qword [rax]'                        );
  TestCase.testcase(48, [$F3,$0F,$C2,$00,$00                               ] , 'cmpeqss  xmm0,dword [rax]'                        );
  TestCase.testcase(49, [$66,$0F,$2A,$00                                   ] , 'cvtpi2pd  xmm0,qword [rax]'                       );
  TestCase.testcase(50, [$0F,$2A,$00                                       ] , 'cvtpi2ps  xmm0,qword [rax]'                       );
  TestCase.testcase(51, [$0F,$2D,$00                                       ] , 'cvtps2pi  mm0,qword [rax]'                        );
  TestCase.testcase(52, [$F2,$0F,$2D,$00                                   ] , 'cvtsd2si  eax,qword [rax]'                        );
  TestCase.testcase(53, [$F2,$48,$0F,$2D,$00                               ] , 'cvtsd2si  rax,qword [rax]'                        );
  TestCase.testcase(54, [$F2,$0F,$2C,$00                                   ] , 'cvttsd2si  eax,qword [rax]'                       );
  TestCase.testcase(55, [$F2,$48,$0F,$2C,$00                               ] , 'cvttsd2si  rax,qword [rax]'                       );
  TestCase.testcase(56, [$F2,$0F,$5A,$00                                   ] , 'cvtsd2ss  xmm0,qword [rax]'                       );
  TestCase.testcase(57, [$F3,$0F,$5A,$00                                   ] , 'cvtss2sd  xmm0,dword [rax]'                       );
  TestCase.testcase(58, [$F3,$0F,$2D,$00                                   ] , 'cvtss2si  eax,dword [rax]'                        );
  TestCase.testcase(59, [$F3,$48,$0F,$2D,$00                               ] , 'cvtss2si  rax,dword [rax]'                        );
  TestCase.testcase(60, [$F3,$0F,$2C,$00                                   ] , 'cvttss2si  eax,dword [rax]'                       );
  TestCase.testcase(61, [$F3,$48,$0F,$2C,$00                               ] , 'cvttss2si  rax,dword [rax]'                       );
  TestCase.testcase(62, [$F2,$0F,$5E,$00                                   ] , 'divsd  xmm0,qword [rax]'                          );
  TestCase.testcase(63, [$F3,$0F,$5E,$00                                   ] , 'divss  xmm0,dword [rax]'                          );
  TestCase.testcase(64, [$F2,$0F,$5F,$00                                   ] , 'maxsd  xmm0,qword [rax]'                          );
  TestCase.testcase(65, [$F3,$0F,$5F,$00                                   ] , 'maxss  xmm0,dword [rax]'                          );
  TestCase.testcase(66, [$F3,$0F,$5D,$00                                   ] , 'minss  xmm0,dword [rax]'                          );
  TestCase.testcase(67, [$F3,$0F,$5D,$00                                   ] , 'minss  xmm0,dword [rax]'                          );
  TestCase.testcase(68, [$F2,$0F,$2B,$00                                   ] , 'movntsd  qword [rax],xmm0'                        );
  TestCase.testcase(69, [$F3,$0F,$2B,$00                                   ] , 'movntss  dword [rax],xmm0'                        );
  TestCase.testcase(70, [$F2,$0F,$10,$00                                   ] , 'movsd  xmm0,qword [rax]'                          );
  TestCase.testcase(71, [$F2,$0F,$11,$00                                   ] , 'movsd  qword [rax],xmm0'                          );
  TestCase.testcase(72, [$F3,$0F,$10,$00                                   ] , 'movss  xmm0,dword [rax]'                          );
  TestCase.testcase(73, [$F3,$0F,$11,$00                                   ] , 'movss  dword [rax],xmm0'                          );
  TestCase.testcase(74, [$F2,$0F,$59,$00                                   ] , 'mulsd  xmm0,qword [rax]'                          );
  TestCase.testcase(75, [$F3,$0F,$59,$00                                   ] , 'mulss  xmm0,dword [rax]'                          );
  TestCase.testcase(76, [$F3,$0F,$53,$00                                   ] , 'rcpss  xmm0,dword [rax]'                          );
  TestCase.testcase(77, [$66,$0F,$3A,$0B,$00,$00                           ] , 'roundsd  xmm0,qword [rax],0x0'                    );
  TestCase.testcase(78, [$66,$0F,$3A,$0A,$00,$00                           ] , 'roundss  xmm0,dword [rax],0x0'                    );
  TestCase.testcase(79, [$F3,$0F,$52,$00                                   ] , 'rsqrtss  xmm0,dword [rax]'                        );
  TestCase.testcase(80, [$F2,$0F,$51,$00                                   ] , 'sqrtsd  xmm0,qword [rax]'                         );
  TestCase.testcase(81, [$F3,$0F,$51,$00                                   ] , 'sqrtss  xmm0,dword [rax]'                         );
  TestCase.testcase(82, [$F2,$0F,$5C,$00                                   ] , 'subsd  xmm0,qword [rax]'                          );
  TestCase.testcase(83, [$F3,$0F,$5C,$00                                   ] , 'subss  xmm0,dword [rax]'                          );
  TestCase.testcase(84, [$66,$0F,$38,$20,$00                               ] , 'pmovsxbw  xmm0,qword [rax]'                       );
  TestCase.testcase(85, [$66,$0F,$38,$21,$00                               ] , 'pmovsxbd  xmm0,dword [rax]'                       );
  TestCase.testcase(86, [$66,$0F,$38,$22,$00                               ] , 'pmovsxbq  xmm0,word [rax]'                        );
  TestCase.testcase(87, [$66,$0F,$38,$23,$00                               ] , 'pmovsxwd  xmm0,qword [rax]'                       );
  TestCase.testcase(88, [$66,$0F,$38,$24,$00                               ] , 'pmovsxwq  xmm0,dword [rax]'                       );
  TestCase.testcase(89, [$66,$0F,$38,$25,$00                               ] , 'pmovsxdq  xmm0,qword [rax]'                       );
  TestCase.testcase(90, [$66,$0F,$38,$30,$00                               ] , 'pmovzxbw  xmm0,qword [rax]'                       );
  TestCase.testcase(91, [$66,$0F,$38,$31,$00                               ] , 'pmovzxbd  xmm0,dword [rax]'                       );
  TestCase.testcase(92, [$66,$0F,$38,$32,$00                               ] , 'pmovzxbq  xmm0,word [rax]'                        );
  TestCase.testcase(93, [$66,$0F,$38,$33,$00                               ] , 'pmovzxwd  xmm0,qword [rax]'                       );
  TestCase.testcase(94, [$66,$0F,$38,$34,$00                               ] , 'pmovzxwq  xmm0,dword [rax]'                       );
  TestCase.testcase(95, [$66,$0F,$38,$35,$00                               ] , 'pmovzxdq  xmm0,qword [rax]'                       );
  TestCase.testcase(96, [$66,$0F,$3A,$21,$00,$00                           ] , 'insertps  xmm0,dword [rax],0x0'                   );
  TestCase.testcase(97, [$66,$0F,$15,$08                                   ] , 'unpckhpd  xmm1,oword [rax]'                       );
  TestCase.testcase(98, [$0F,$15,$08                                       ] , 'unpckhps  xmm1,oword [rax]'                       );
  TestCase.testcase(99, [$66,$0F,$14,$08                                   ] , 'unpcklpd  xmm1,oword [rax]'                       );
  TestCase.testcase(100, [$0F,$14,$08                                       ] , 'unpcklps  xmm1,oword [rax]'                       );
  TestCase.testcase(101, [$F3,$0F,$C2,$F7,$10                               ] , 'cmpss  xmm6,xmm7,0x10'                            );
  TestCase.testcase(102, [$F3,$0F,$C2,$38,$10                               ] , 'cmpss  xmm7,dword [rax],0x10'                     );
  TestCase.testcase(103, [$F2,$0F,$C2,$F7,$10                               ] , 'cmpsd  xmm6,xmm7,0x10'                            );
  TestCase.testcase(104, [$F2,$0F,$C2,$38,$10                               ] , 'cmpsd  xmm7,qword [rax],0x10'                     );
  TestCase.testcase(105, [$0F,$D4,$C1                                       ] , 'paddq  mm0,mm1'                                   );
  TestCase.testcase(106, [$0F,$D4,$00                                       ] , 'paddq  mm0,qword [rax]'                           );
  TestCase.testcase(107, [$66,$0F,$D4,$C1                                   ] , 'paddq  xmm0,xmm1'                                 );
  TestCase.testcase(108, [$66,$0F,$D4,$00                                   ] , 'paddq  xmm0,oword [rax]'                          );
  TestCase.testcase(109, [$0F,$FB,$C1                                       ] , 'psubq  mm0,mm1'                                   );
  TestCase.testcase(110, [$0F,$FB,$00                                       ] , 'psubq  mm0,qword [rax]'                           );
  TestCase.testcase(111, [$66,$0F,$FB,$C1                                   ] , 'psubq  xmm0,xmm1'                                 );
  TestCase.testcase(112, [$66,$0F,$FB,$00                                   ] , 'psubq  xmm0,oword [rax]'                          );
  TestCase.testcase(113, [$0F,$F4,$C1                                       ] , 'pmuludq  mm0,mm1'                                 );
  TestCase.testcase(114, [$0F,$F4,$00                                       ] , 'pmuludq  mm0,qword [rax]'                         );
  TestCase.testcase(115, [$66,$0F,$F4,$C1                                   ] , 'pmuludq  xmm0,xmm1'                               );
  TestCase.testcase(116, [$66,$0F,$F4,$00                                   ] , 'pmuludq  xmm0,oword [rax]'                        );
  TestCase.testcase(117, [$F2,$0F,$D0,$0D,$78,$56,$34,$12                   ] , 'addsubps  xmm1,oword [rip 0x12345678]'            );
  TestCase.testcase(118, [$66,$0F,$2F,$0D,$78,$56,$34,$12                   ] , 'comisd  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(119, [$0F,$2F,$0D,$78,$56,$34,$12                       ] , 'comiss  xmm1,dword [rip 0x12345678]'              );
  TestCase.testcase(120, [$F3,$0F,$E6,$0D,$78,$56,$34,$12                   ] , 'cvtdq2pd  xmm1,qword [rip 0x12345678]'            );
  TestCase.testcase(121, [$F2,$0F,$E6,$0D,$78,$56,$34,$12                   ] , 'cvtpd2dq  xmm1,oword [rip 0x12345678]'            );
  TestCase.testcase(122, [$0F,$5A,$0D,$78,$56,$34,$12                       ] , 'cvtps2pd  xmm1,qword [rip 0x12345678]'            );
  TestCase.testcase(123, [$F3,$0F,$5B,$0D,$78,$56,$34,$12                   ] , 'cvttps2dq  xmm1,oword [rip 0x12345678]'           );
  TestCase.testcase(124, [$F3,$0F,$2A,$C8                                   ] , 'cvtsi2ss  xmm1,eax'                               );
  TestCase.testcase(125, [$F2,$0F,$2A,$C8                                   ] , 'cvtsi2sd  xmm1,eax'                               );
  TestCase.testcase(126, [$F3,$0F,$2A,$C8                                   ] , 'cvtsi2ss  xmm1,eax'                               );
  TestCase.testcase(127, [$F2,$0F,$2A,$C8                                   ] , 'cvtsi2sd  xmm1,eax'                               );
  TestCase.testcase(128, [$F3,$48,$0F,$2A,$C8                               ] , 'cvtsi2ss  xmm1,rax'                               );
  TestCase.testcase(129, [$F2,$48,$0F,$2A,$C8                               ] , 'cvtsi2sd  xmm1,rax'                               );
  TestCase.testcase(130, [$F3,$48,$0F,$2A,$C8                               ] , 'cvtsi2ss  xmm1,rax'                               );
  TestCase.testcase(131, [$F2,$48,$0F,$2A,$C8                               ] , 'cvtsi2sd  xmm1,rax'                               );
  TestCase.testcase(132, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [rax]'                       );
  TestCase.testcase(133, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [rax]'                       );
  TestCase.testcase(134, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [rax]'                       );
  TestCase.testcase(135, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [rax]'                       );
  TestCase.testcase(136, [$F3,$48,$0F,$2A,$08                               ] , 'cvtsi2ss  xmm1,qword [rax]'                       );
  TestCase.testcase(137, [$F2,$48,$0F,$2A,$08                               ] , 'cvtsi2sd  xmm1,qword [rax]'                       );
  TestCase.testcase(138, [$F3,$48,$0F,$2A,$08                               ] , 'cvtsi2ss  xmm1,qword [rax]'                       );
  TestCase.testcase(139, [$F2,$48,$0F,$2A,$08                               ] , 'cvtsi2sd  xmm1,qword [rax]'                       );
  TestCase.testcase(140, [$F2,$0F,$7C,$0D,$78,$56,$34,$12                   ] , 'haddps  xmm1,oword [rip 0x12345678]'              );
  TestCase.testcase(141, [$F3,$0F,$7F,$0D,$78,$56,$34,$12                   ] , 'movdqu  oword [rip 0x12345678],xmm1'              );
  TestCase.testcase(142, [$F3,$0F,$6F,$0D,$78,$56,$34,$12                   ] , 'movdqu  xmm1,oword [rip 0x12345678]'              );
  TestCase.testcase(143, [$66,$0F,$17,$0D,$78,$56,$34,$12                   ] , 'movhpd  qword [rip 0x12345678],xmm1'              );
  TestCase.testcase(144, [$66,$0F,$16,$0D,$78,$56,$34,$12                   ] , 'movhpd  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(145, [$0F,$17,$0D,$78,$56,$34,$12                       ] , 'movhps  qword [rip 0x12345678],xmm1'              );
  TestCase.testcase(146, [$0F,$16,$0D,$78,$56,$34,$12                       ] , 'movhps  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(147, [$66,$0F,$13,$0D,$78,$56,$34,$12                   ] , 'movlpd  qword [rip 0x12345678],xmm1'              );
  TestCase.testcase(148, [$66,$0F,$12,$0D,$78,$56,$34,$12                   ] , 'movlpd  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(149, [$0F,$13,$0D,$78,$56,$34,$12                       ] , 'movlps  qword [rip 0x12345678],xmm1'              );
  TestCase.testcase(150, [$0F,$12,$0D,$78,$56,$34,$12                       ] , 'movlps  xmm1,qword [rip 0x12345678]'              );
  TestCase.testcase(151, [$66,$0F,$D6,$0D,$78,$56,$34,$12                   ] , 'movq  qword [rip 0x12345678],xmm1'                );
  TestCase.testcase(152, [$F3,$0F,$7E,$0D,$78,$56,$34,$12                   ] , 'movq  xmm1,qword [rip 0x12345678]'                );
  TestCase.testcase(153, [$F3,$0F,$16,$0D,$78,$56,$34,$12                   ] , 'movshdup  xmm1,oword [rip 0x12345678]'            );
  TestCase.testcase(154, [$F3,$0F,$12,$0D,$78,$56,$34,$12                   ] , 'movsldup  xmm1,oword [rip 0x12345678]'            );
  TestCase.testcase(155, [$F3,$0F,$70,$0D,$78,$56,$34,$12,$90               ] , 'pshufhw  xmm1,oword [rip 0x12345678],0x90'        );
  TestCase.testcase(156, [$F2,$0F,$70,$0D,$78,$56,$34,$12,$90               ] , 'pshuflw  xmm1,oword [rip 0x12345678],0x90'        );
  TestCase.testcase(157, [$0F,$60,$0D,$78,$56,$34,$12                       ] , 'punpcklbw  mm1,dword [rip 0x12345678]'            );
  TestCase.testcase(158, [$0F,$62,$0D,$78,$56,$34,$12                       ] , 'punpckldq  mm1,dword [rip 0x12345678]'            );
  TestCase.testcase(159, [$0F,$61,$0D,$78,$56,$34,$12                       ] , 'punpcklwd  mm1,dword [rip 0x12345678]'            );
  TestCase.testcase(160, [$66,$0F,$60,$0D,$78,$56,$34,$12                   ] , 'punpcklbw  xmm1,oword [rip 0x12345678]'           );
  TestCase.testcase(161, [$66,$0F,$62,$0D,$78,$56,$34,$12                   ] , 'punpckldq  xmm1,oword [rip 0x12345678]'           );
  TestCase.testcase(162, [$66,$0F,$61,$0D,$78,$56,$34,$12                   ] , 'punpcklwd  xmm1,oword [rip 0x12345678]'           );
  TestCase.testcase(163, [$66,$0F,$6C,$0D,$78,$56,$34,$12                   ] , 'punpcklqdq  xmm1,oword [rip 0x12345678]'          );
  TestCase.testcase(164, [$66,$0F,$2E,$0D,$78,$56,$34,$12                   ] , 'ucomisd  xmm1,qword [rip 0x12345678]'             );
  TestCase.testcase(165, [$0F,$2E,$0D,$78,$56,$34,$12                       ] , 'ucomiss  xmm1,dword [rip 0x12345678]'             );
  TestCase.testcase(166, [$F2,$0F,$C2,$00,$00                               ] , 'cmpeqsd  xmm0,qword [rax]'                        );
  TestCase.testcase(167, [$F3,$0F,$C2,$00,$00                               ] , 'cmpeqss  xmm0,dword [rax]'                        );
  TestCase.testcase(168, [$66,$0F,$2A,$00                                   ] , 'cvtpi2pd  xmm0,qword [rax]'                       );
  TestCase.testcase(169, [$0F,$2A,$00                                       ] , 'cvtpi2ps  xmm0,qword [rax]'                       );
  TestCase.testcase(170, [$0F,$2D,$00                                       ] , 'cvtps2pi  mm0,qword [rax]'                        );
  TestCase.testcase(171, [$F2,$0F,$2D,$00                                   ] , 'cvtsd2si  eax,qword [rax]'                        );
  TestCase.testcase(172, [$F2,$48,$0F,$2D,$00                               ] , 'cvtsd2si  rax,qword [rax]'                        );
  TestCase.testcase(173, [$F2,$0F,$2C,$00                                   ] , 'cvttsd2si  eax,qword [rax]'                       );
  TestCase.testcase(174, [$F2,$48,$0F,$2C,$00                               ] , 'cvttsd2si  rax,qword [rax]'                       );
  TestCase.testcase(175, [$F2,$0F,$5A,$00                                   ] , 'cvtsd2ss  xmm0,qword [rax]'                       );
  TestCase.testcase(176, [$F3,$0F,$5A,$00                                   ] , 'cvtss2sd  xmm0,dword [rax]'                       );
  TestCase.testcase(177, [$F3,$0F,$2D,$00                                   ] , 'cvtss2si  eax,dword [rax]'                        );
  TestCase.testcase(178, [$F3,$48,$0F,$2D,$00                               ] , 'cvtss2si  rax,dword [rax]'                        );
  TestCase.testcase(179, [$F3,$0F,$2C,$00                                   ] , 'cvttss2si  eax,dword [rax]'                       );
  TestCase.testcase(180, [$F3,$48,$0F,$2C,$00                               ] , 'cvttss2si  rax,dword [rax]'                       );
  TestCase.testcase(181, [$F2,$0F,$5E,$00                                   ] , 'divsd  xmm0,qword [rax]'                          );
  TestCase.testcase(182, [$F3,$0F,$5E,$00                                   ] , 'divss  xmm0,dword [rax]'                          );
  TestCase.testcase(183, [$F2,$0F,$5F,$00                                   ] , 'maxsd  xmm0,qword [rax]'                          );
  TestCase.testcase(184, [$F3,$0F,$5F,$00                                   ] , 'maxss  xmm0,dword [rax]'                          );
  TestCase.testcase(185, [$F3,$0F,$5D,$00                                   ] , 'minss  xmm0,dword [rax]'                          );
  TestCase.testcase(186, [$F3,$0F,$5D,$00                                   ] , 'minss  xmm0,dword [rax]'                          );
  TestCase.testcase(187, [$F2,$0F,$2B,$00                                   ] , 'movntsd  qword [rax],xmm0'                        );
  TestCase.testcase(188, [$F3,$0F,$2B,$00                                   ] , 'movntss  dword [rax],xmm0'                        );
  TestCase.testcase(189, [$F2,$0F,$10,$00                                   ] , 'movsd  xmm0,qword [rax]'                          );
  TestCase.testcase(190, [$F2,$0F,$11,$00                                   ] , 'movsd  qword [rax],xmm0'                          );
  TestCase.testcase(191, [$F3,$0F,$10,$00                                   ] , 'movss  xmm0,dword [rax]'                          );
  TestCase.testcase(192, [$F3,$0F,$11,$00                                   ] , 'movss  dword [rax],xmm0'                          );
  TestCase.testcase(193, [$F2,$0F,$59,$00                                   ] , 'mulsd  xmm0,qword [rax]'                          );
  TestCase.testcase(194, [$F3,$0F,$59,$00                                   ] , 'mulss  xmm0,dword [rax]'                          );
  TestCase.testcase(195, [$F3,$0F,$53,$00                                   ] , 'rcpss  xmm0,dword [rax]'                          );
  TestCase.testcase(196, [$66,$0F,$3A,$0B,$00,$00                           ] , 'roundsd  xmm0,qword [rax],0x0'                    );
  TestCase.testcase(197, [$66,$0F,$3A,$0A,$00,$00                           ] , 'roundss  xmm0,dword [rax],0x0'                    );
  TestCase.testcase(198, [$F3,$0F,$52,$00                                   ] , 'rsqrtss  xmm0,dword [rax]'                        );
  TestCase.testcase(199, [$F2,$0F,$51,$00                                   ] , 'sqrtsd  xmm0,qword [rax]'                         );
  TestCase.testcase(200, [$F3,$0F,$51,$00                                   ] , 'sqrtss  xmm0,dword [rax]'                         );
  TestCase.testcase(201, [$F2,$0F,$5C,$00                                   ] , 'subsd  xmm0,qword [rax]'                          );
  TestCase.testcase(202, [$F3,$0F,$5C,$00                                   ] , 'subss  xmm0,dword [rax]'                          );
  TestCase.testcase(203, [$66,$0F,$38,$20,$00                               ] , 'pmovsxbw  xmm0,qword [rax]'                       );
  TestCase.testcase(204, [$66,$0F,$38,$21,$00                               ] , 'pmovsxbd  xmm0,dword [rax]'                       );
  TestCase.testcase(205, [$66,$0F,$38,$22,$00                               ] , 'pmovsxbq  xmm0,word [rax]'                        );
  TestCase.testcase(206, [$66,$0F,$38,$23,$00                               ] , 'pmovsxwd  xmm0,qword [rax]'                       );
  TestCase.testcase(207, [$66,$0F,$38,$24,$00                               ] , 'pmovsxwq  xmm0,dword [rax]'                       );
  TestCase.testcase(208, [$66,$0F,$38,$25,$00                               ] , 'pmovsxdq  xmm0,qword [rax]'                       );
  TestCase.testcase(209, [$66,$0F,$38,$30,$00                               ] , 'pmovzxbw  xmm0,qword [rax]'                       );
  TestCase.testcase(210, [$66,$0F,$38,$31,$00                               ] , 'pmovzxbd  xmm0,dword [rax]'                       );
  TestCase.testcase(211, [$66,$0F,$38,$32,$00                               ] , 'pmovzxbq  xmm0,word [rax]'                        );
  TestCase.testcase(212, [$66,$0F,$38,$33,$00                               ] , 'pmovzxwd  xmm0,qword [rax]'                       );
  TestCase.testcase(213, [$66,$0F,$38,$34,$00                               ] , 'pmovzxwq  xmm0,dword [rax]'                       );
  TestCase.testcase(214, [$66,$0F,$38,$35,$00                               ] , 'pmovzxdq  xmm0,qword [rax]'                       );
  TestCase.testcase(215, [$66,$0F,$3A,$21,$00,$00                           ] , 'insertps  xmm0,dword [rax],0x0'                   );
  TestCase.testcase(216, [$66,$0F,$15,$00                                   ] , 'unpckhpd  xmm0,oword [rax]'                       );
  TestCase.testcase(217, [$0F,$15,$00                                       ] , 'unpckhps  xmm0,oword [rax]'                       );
  TestCase.testcase(218, [$66,$0F,$14,$00                                   ] , 'unpcklpd  xmm0,oword [rax]'                       );
  TestCase.testcase(219, [$0F,$14,$00                                       ] , 'unpcklps  xmm0,oword [rax]'                       );
  TestCase.testcase(220, [$F3,$0F,$C2,$F7,$10                               ] , 'cmpss  xmm6,xmm7,0x10'                            );
  TestCase.testcase(221, [$F3,$0F,$C2,$38,$10                               ] , 'cmpss  xmm7,dword [rax],0x10'                     );
  TestCase.testcase(222, [$F2,$0F,$C2,$F7,$10                               ] , 'cmpsd  xmm6,xmm7,0x10'                            );
  TestCase.testcase(223, [$F2,$0F,$C2,$38,$10                               ] , 'cmpsd  xmm7,qword [rax],0x10'                     );
  TestCase.testcase(224, [$0F,$D4,$08                                       ] , 'paddq  mm1,qword [rax]'                           );
  TestCase.testcase(225, [$0F,$D4,$08                                       ] , 'paddq  mm1,qword [rax]'                           );
  TestCase.testcase(226, [$66,$0F,$D4,$08                                   ] , 'paddq  xmm1,oword [rax]'                          );
  TestCase.testcase(227, [$66,$0F,$D4,$08                                   ] , 'paddq  xmm1,oword [rax]'                          );
  TestCase.testcase(228, [$0F,$FB,$08                                       ] , 'psubq  mm1,qword [rax]'                           );
  TestCase.testcase(229, [$0F,$FB,$08                                       ] , 'psubq  mm1,qword [rax]'                           );
  TestCase.testcase(230, [$66,$0F,$FB,$08                                   ] , 'psubq  xmm1,oword [rax]'                          );
  TestCase.testcase(231, [$66,$0F,$FB,$08                                   ] , 'psubq  xmm1,oword [rax]'                          );
  TestCase.testcase(232, [$0F,$F4,$08                                       ] , 'pmuludq  mm1,qword [rax]'                         );
  TestCase.testcase(233, [$0F,$F4,$08                                       ] , 'pmuludq  mm1,qword [rax]'                         );
  TestCase.testcase(234, [$66,$0F,$F4,$08                                   ] , 'pmuludq  xmm1,oword [rax]'                        );
  TestCase.testcase(235, [$66,$0F,$F4,$08                                   ] , 'pmuludq  xmm1,oword [rax]'                        );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x64.simd.log');
end;

end.