unit x64.evex_lig256;

// This unit was generated by d2p.pl script.
// Source : gas/x86-64-evex-lig256-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x64.evex_lig256');
  TestCase.Start();	
  TestCase.Arch := CPUX64;

  TestCase.testcase(0, [$62,$01,$97,$27,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1, [$62,$01,$97,$A7,$58,$F4                           ] , 'vaddsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(2, [$62,$01,$97,$17,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(3, [$62,$01,$97,$57,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(4, [$62,$01,$97,$37,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(5, [$62,$01,$97,$77,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(6, [$62,$61,$97,$27,$58,$31                           ] , 'vaddsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(7, [$62,$21,$97,$27,$58,$B4,$F0,$23,$01,$00,$00       ] , 'vaddsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(8, [$62,$61,$97,$27,$58,$72,$7F                       ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(9, [$62,$61,$97,$27,$58,$B2,$00,$04,$00,$00           ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(10, [$62,$61,$97,$27,$58,$72,$80                       ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(11, [$62,$61,$97,$27,$58,$B2,$F8,$FB,$FF,$FF           ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(12, [$62,$01,$16,$27,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(13, [$62,$01,$16,$A7,$58,$F4                           ] , 'vaddss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(14, [$62,$01,$16,$17,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(15, [$62,$01,$16,$57,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(16, [$62,$01,$16,$37,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(17, [$62,$01,$16,$77,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(18, [$62,$61,$16,$27,$58,$31                           ] , 'vaddss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(19, [$62,$21,$16,$27,$58,$B4,$F0,$23,$01,$00,$00       ] , 'vaddss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(20, [$62,$61,$16,$27,$58,$72,$7F                       ] , 'vaddss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(21, [$62,$61,$16,$27,$58,$B2,$00,$02,$00,$00           ] , 'vaddss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(22, [$62,$61,$16,$27,$58,$72,$80                       ] , 'vaddss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(23, [$62,$61,$16,$27,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vaddss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(24, [$62,$91,$97,$27,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,0xab'                  );
  TestCase.testcase(25, [$62,$91,$97,$17,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,{sae},0xab'            );
  TestCase.testcase(26, [$62,$91,$97,$27,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,0x7b'                  );
  TestCase.testcase(27, [$62,$91,$97,$17,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,{sae},0x7b'            );
  TestCase.testcase(28, [$62,$F1,$97,$27,$C2,$29,$7B                       ] , 'vcmpsd  k5{k7},xmm29,qword [rcx],0x7b'            );
  TestCase.testcase(29, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vcmpsd  k5{k7},xmm29,qword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(30, [$62,$F1,$97,$27,$C2,$6A,$7F,$7B                   ] , 'vcmpsd  k5{k7},xmm29,qword [rdx+0x3f8],0x7b'      );
  TestCase.testcase(31, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$7B       ] , 'vcmpsd  k5{k7},xmm29,qword [rdx+0x400],0x7b'      );
  TestCase.testcase(32, [$62,$F1,$97,$27,$C2,$6A,$80,$7B                   ] , 'vcmpsd  k5{k7},xmm29,qword [rdx-0x400],0x7b'      );
  TestCase.testcase(33, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vcmpsd  k5{k7},xmm29,qword [rdx-0x408],0x7b'      );
  TestCase.testcase(34, [$62,$91,$97,$27,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(35, [$62,$91,$97,$17,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(36, [$62,$F1,$97,$27,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(37, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(38, [$62,$F1,$97,$27,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(39, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(40, [$62,$F1,$97,$27,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(41, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(42, [$62,$91,$97,$27,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(43, [$62,$91,$97,$17,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(44, [$62,$F1,$97,$27,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(45, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(46, [$62,$F1,$97,$27,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(47, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(48, [$62,$F1,$97,$27,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(49, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(50, [$62,$91,$97,$27,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(51, [$62,$91,$97,$17,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(52, [$62,$F1,$97,$27,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(53, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(54, [$62,$F1,$97,$27,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(55, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(56, [$62,$F1,$97,$27,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(57, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(58, [$62,$91,$97,$27,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(59, [$62,$91,$97,$17,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(60, [$62,$F1,$97,$27,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(61, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(62, [$62,$F1,$97,$27,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(63, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(64, [$62,$F1,$97,$27,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(65, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(66, [$62,$91,$97,$27,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(67, [$62,$91,$97,$17,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(68, [$62,$F1,$97,$27,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(69, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmplesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(70, [$62,$F1,$97,$27,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(71, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(72, [$62,$F1,$97,$27,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(73, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(74, [$62,$91,$97,$27,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(75, [$62,$91,$97,$17,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(76, [$62,$F1,$97,$27,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(77, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmplesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(78, [$62,$F1,$97,$27,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(79, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(80, [$62,$F1,$97,$27,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(81, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(82, [$62,$91,$97,$27,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(83, [$62,$91,$97,$17,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(84, [$62,$F1,$97,$27,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(85, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(86, [$62,$F1,$97,$27,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(87, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(88, [$62,$F1,$97,$27,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(89, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(90, [$62,$91,$97,$27,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(91, [$62,$91,$97,$17,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(92, [$62,$F1,$97,$27,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(93, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(94, [$62,$F1,$97,$27,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(95, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(96, [$62,$F1,$97,$27,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(97, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(98, [$62,$91,$97,$27,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(99, [$62,$91,$97,$17,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(100, [$62,$F1,$97,$27,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(101, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(102, [$62,$F1,$97,$27,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(103, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(104, [$62,$F1,$97,$27,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(105, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(106, [$62,$91,$97,$27,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(107, [$62,$91,$97,$17,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(108, [$62,$F1,$97,$27,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(109, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(110, [$62,$F1,$97,$27,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(111, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(112, [$62,$F1,$97,$27,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(113, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(114, [$62,$91,$97,$27,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(115, [$62,$91,$97,$17,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(116, [$62,$F1,$97,$27,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(117, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(118, [$62,$F1,$97,$27,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(119, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(120, [$62,$F1,$97,$27,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(121, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(122, [$62,$91,$97,$27,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(123, [$62,$91,$97,$17,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(124, [$62,$F1,$97,$27,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(125, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(126, [$62,$F1,$97,$27,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(127, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(128, [$62,$F1,$97,$27,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(129, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(130, [$62,$91,$97,$27,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(131, [$62,$91,$97,$17,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(132, [$62,$F1,$97,$27,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(133, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(134, [$62,$F1,$97,$27,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(135, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(136, [$62,$F1,$97,$27,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(137, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(138, [$62,$91,$97,$27,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(139, [$62,$91,$97,$17,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(140, [$62,$F1,$97,$27,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(141, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(142, [$62,$F1,$97,$27,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(143, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(144, [$62,$F1,$97,$27,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(145, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(146, [$62,$91,$97,$27,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(147, [$62,$91,$97,$17,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(148, [$62,$F1,$97,$27,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(149, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(150, [$62,$F1,$97,$27,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(151, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(152, [$62,$F1,$97,$27,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(153, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(154, [$62,$91,$97,$27,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(155, [$62,$91,$97,$17,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(156, [$62,$F1,$97,$27,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(157, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(158, [$62,$F1,$97,$27,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(159, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(160, [$62,$F1,$97,$27,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(161, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(162, [$62,$91,$97,$27,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(163, [$62,$91,$97,$17,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(164, [$62,$F1,$97,$27,$C2,$29,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(165, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$08   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(166, [$62,$F1,$97,$27,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(167, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(168, [$62,$F1,$97,$27,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(169, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(170, [$62,$91,$97,$27,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(171, [$62,$91,$97,$17,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(172, [$62,$F1,$97,$27,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(173, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(174, [$62,$F1,$97,$27,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(175, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(176, [$62,$F1,$97,$27,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(177, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(178, [$62,$91,$97,$27,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(179, [$62,$91,$97,$17,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(180, [$62,$F1,$97,$27,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(181, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(182, [$62,$F1,$97,$27,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(183, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(184, [$62,$F1,$97,$27,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(185, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(186, [$62,$91,$97,$27,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(187, [$62,$91,$97,$17,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(188, [$62,$F1,$97,$27,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(189, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(190, [$62,$F1,$97,$27,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(191, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(192, [$62,$F1,$97,$27,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(193, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(194, [$62,$91,$97,$27,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(195, [$62,$91,$97,$17,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(196, [$62,$F1,$97,$27,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(197, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(198, [$62,$F1,$97,$27,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(199, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(200, [$62,$F1,$97,$27,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(201, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(202, [$62,$91,$97,$27,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(203, [$62,$91,$97,$17,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(204, [$62,$F1,$97,$27,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(205, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(206, [$62,$F1,$97,$27,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(207, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(208, [$62,$F1,$97,$27,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(209, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(210, [$62,$91,$97,$27,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(211, [$62,$91,$97,$17,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(212, [$62,$F1,$97,$27,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(213, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(214, [$62,$F1,$97,$27,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(215, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(216, [$62,$F1,$97,$27,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(217, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(218, [$62,$91,$97,$27,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(219, [$62,$91,$97,$17,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(220, [$62,$F1,$97,$27,$C2,$29,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(221, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0C   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(222, [$62,$F1,$97,$27,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(223, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(224, [$62,$F1,$97,$27,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(225, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(226, [$62,$91,$97,$27,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(227, [$62,$91,$97,$17,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(228, [$62,$F1,$97,$27,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(229, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(230, [$62,$F1,$97,$27,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(231, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(232, [$62,$F1,$97,$27,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(233, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(234, [$62,$91,$97,$27,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(235, [$62,$91,$97,$17,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(236, [$62,$F1,$97,$27,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(237, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(238, [$62,$F1,$97,$27,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(239, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(240, [$62,$F1,$97,$27,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(241, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(242, [$62,$91,$97,$27,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(243, [$62,$91,$97,$17,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(244, [$62,$F1,$97,$27,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(245, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(246, [$62,$F1,$97,$27,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(247, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(248, [$62,$F1,$97,$27,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(249, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(250, [$62,$91,$97,$27,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(251, [$62,$91,$97,$17,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(252, [$62,$F1,$97,$27,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(253, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(254, [$62,$F1,$97,$27,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(255, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(256, [$62,$F1,$97,$27,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(257, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(258, [$62,$91,$97,$27,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(259, [$62,$91,$97,$17,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(260, [$62,$F1,$97,$27,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm29,qword [rcx]'                );
  TestCase.testcase(261, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'    );
  TestCase.testcase(262, [$62,$F1,$97,$27,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x3f8]'          );
  TestCase.testcase(263, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x400]'          );
  TestCase.testcase(264, [$62,$F1,$97,$27,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x400]'          );
  TestCase.testcase(265, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x408]'          );
  TestCase.testcase(266, [$62,$91,$97,$27,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(267, [$62,$91,$97,$17,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(268, [$62,$F1,$97,$27,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm29,qword [rcx]'                );
  TestCase.testcase(269, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'    );
  TestCase.testcase(270, [$62,$F1,$97,$27,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x3f8]'          );
  TestCase.testcase(271, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x400]'          );
  TestCase.testcase(272, [$62,$F1,$97,$27,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x400]'          );
  TestCase.testcase(273, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x408]'          );
  TestCase.testcase(274, [$62,$91,$97,$27,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(275, [$62,$91,$97,$17,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(276, [$62,$F1,$97,$27,$C2,$29,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(277, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$10   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(278, [$62,$F1,$97,$27,$C2,$6A,$7F,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(279, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$10       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(280, [$62,$F1,$97,$27,$C2,$6A,$80,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(281, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$10       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(282, [$62,$91,$97,$27,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(283, [$62,$91,$97,$17,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(284, [$62,$F1,$97,$27,$C2,$29,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(285, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$11   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(286, [$62,$F1,$97,$27,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(287, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$11       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(288, [$62,$F1,$97,$27,$C2,$6A,$80,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(289, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$11       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(290, [$62,$91,$97,$27,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(291, [$62,$91,$97,$17,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(292, [$62,$F1,$97,$27,$C2,$29,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(293, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$12   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(294, [$62,$F1,$97,$27,$C2,$6A,$7F,$12                   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(295, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$12       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(296, [$62,$F1,$97,$27,$C2,$6A,$80,$12                   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(297, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$12       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(298, [$62,$91,$97,$27,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,xmm28'                );
  TestCase.testcase(299, [$62,$91,$97,$17,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(300, [$62,$F1,$97,$27,$C2,$29,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rcx]'          );
  TestCase.testcase(301, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$13   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(302, [$62,$F1,$97,$27,$C2,$6A,$7F,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx+0x3f8]'    );
  TestCase.testcase(303, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$13       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx+0x400]'    );
  TestCase.testcase(304, [$62,$F1,$97,$27,$C2,$6A,$80,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx-0x400]'    );
  TestCase.testcase(305, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$13       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx-0x408]'    );
  TestCase.testcase(306, [$62,$91,$97,$27,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(307, [$62,$91,$97,$17,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(308, [$62,$F1,$97,$27,$C2,$29,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(309, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$14   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(310, [$62,$F1,$97,$27,$C2,$6A,$7F,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(311, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$14       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(312, [$62,$F1,$97,$27,$C2,$6A,$80,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(313, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$14       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(314, [$62,$91,$97,$27,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(315, [$62,$91,$97,$17,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(316, [$62,$F1,$97,$27,$C2,$29,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(317, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$15   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(318, [$62,$F1,$97,$27,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(319, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(320, [$62,$F1,$97,$27,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(321, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(322, [$62,$91,$97,$27,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(323, [$62,$91,$97,$17,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(324, [$62,$F1,$97,$27,$C2,$29,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(325, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$16   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(326, [$62,$F1,$97,$27,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(327, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(328, [$62,$F1,$97,$27,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(329, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(330, [$62,$91,$97,$27,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(331, [$62,$91,$97,$17,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(332, [$62,$F1,$97,$27,$C2,$29,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(333, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$17   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(334, [$62,$F1,$97,$27,$C2,$6A,$7F,$17                   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(335, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$17       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(336, [$62,$F1,$97,$27,$C2,$6A,$80,$17                   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(337, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$17       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(338, [$62,$91,$97,$27,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(339, [$62,$91,$97,$17,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(340, [$62,$F1,$97,$27,$C2,$29,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(341, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$18   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(342, [$62,$F1,$97,$27,$C2,$6A,$7F,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(343, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$18       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(344, [$62,$F1,$97,$27,$C2,$6A,$80,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(345, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$18       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(346, [$62,$91,$97,$27,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(347, [$62,$91,$97,$17,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(348, [$62,$F1,$97,$27,$C2,$29,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(349, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$19   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(350, [$62,$F1,$97,$27,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(351, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(352, [$62,$F1,$97,$27,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(353, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(354, [$62,$91,$97,$27,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(355, [$62,$91,$97,$17,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(356, [$62,$F1,$97,$27,$C2,$29,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(357, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1A   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(358, [$62,$F1,$97,$27,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(359, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(360, [$62,$F1,$97,$27,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(361, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(362, [$62,$91,$97,$27,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,xmm28'               );
  TestCase.testcase(363, [$62,$91,$97,$17,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,xmm28,{sae}'         );
  TestCase.testcase(364, [$62,$F1,$97,$27,$C2,$29,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(365, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1B   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(366, [$62,$F1,$97,$27,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(367, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(368, [$62,$F1,$97,$27,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(369, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(370, [$62,$91,$97,$27,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(371, [$62,$91,$97,$17,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(372, [$62,$F1,$97,$27,$C2,$29,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(373, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1C   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(374, [$62,$F1,$97,$27,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(375, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(376, [$62,$F1,$97,$27,$C2,$6A,$80,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(377, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(378, [$62,$91,$97,$27,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(379, [$62,$91,$97,$17,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(380, [$62,$F1,$97,$27,$C2,$29,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(381, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1D   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(382, [$62,$F1,$97,$27,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(383, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(384, [$62,$F1,$97,$27,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(385, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(386, [$62,$91,$97,$27,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(387, [$62,$91,$97,$17,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(388, [$62,$F1,$97,$27,$C2,$29,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(389, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1E   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(390, [$62,$F1,$97,$27,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(391, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(392, [$62,$F1,$97,$27,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(393, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(394, [$62,$91,$97,$27,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,xmm28'                   );
  TestCase.testcase(395, [$62,$91,$97,$17,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,xmm28,{sae}'             );
  TestCase.testcase(396, [$62,$F1,$97,$27,$C2,$29,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rcx]'             );
  TestCase.testcase(397, [$62,$B1,$97,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1F   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(398, [$62,$F1,$97,$27,$C2,$6A,$7F,$1F                   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'       );
  TestCase.testcase(399, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1F       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx+0x400]'       );
  TestCase.testcase(400, [$62,$F1,$97,$27,$C2,$6A,$80,$1F                   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx-0x400]'       );
  TestCase.testcase(401, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1F       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx-0x408]'       );
  TestCase.testcase(402, [$62,$91,$16,$27,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm29,xmm28,0xab'                  );
  TestCase.testcase(403, [$62,$91,$16,$17,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm29,xmm28,{sae},0xab'            );
  TestCase.testcase(404, [$62,$91,$16,$27,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm29,xmm28,0x7b'                  );
  TestCase.testcase(405, [$62,$91,$16,$17,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm29,xmm28,{sae},0x7b'            );
  TestCase.testcase(406, [$62,$F1,$16,$27,$C2,$29,$7B                       ] , 'vcmpss  k5{k7},xmm29,dword [rcx],0x7b'            );
  TestCase.testcase(407, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vcmpss  k5{k7},xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(408, [$62,$F1,$16,$27,$C2,$6A,$7F,$7B                   ] , 'vcmpss  k5{k7},xmm29,dword [rdx+0x1fc],0x7b'      );
  TestCase.testcase(409, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$7B       ] , 'vcmpss  k5{k7},xmm29,dword [rdx+0x200],0x7b'      );
  TestCase.testcase(410, [$62,$F1,$16,$27,$C2,$6A,$80,$7B                   ] , 'vcmpss  k5{k7},xmm29,dword [rdx-0x200],0x7b'      );
  TestCase.testcase(411, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vcmpss  k5{k7},xmm29,dword [rdx-0x204],0x7b'      );
  TestCase.testcase(412, [$62,$91,$16,$27,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(413, [$62,$91,$16,$17,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(414, [$62,$F1,$16,$27,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(415, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(416, [$62,$F1,$16,$27,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(417, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(418, [$62,$F1,$16,$27,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(419, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(420, [$62,$91,$16,$27,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(421, [$62,$91,$16,$17,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(422, [$62,$F1,$16,$27,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(423, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(424, [$62,$F1,$16,$27,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(425, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(426, [$62,$F1,$16,$27,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(427, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(428, [$62,$91,$16,$27,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(429, [$62,$91,$16,$17,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(430, [$62,$F1,$16,$27,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(431, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(432, [$62,$F1,$16,$27,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(433, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(434, [$62,$F1,$16,$27,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(435, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(436, [$62,$91,$16,$27,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(437, [$62,$91,$16,$17,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(438, [$62,$F1,$16,$27,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(439, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(440, [$62,$F1,$16,$27,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(441, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(442, [$62,$F1,$16,$27,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(443, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(444, [$62,$91,$16,$27,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(445, [$62,$91,$16,$17,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(446, [$62,$F1,$16,$27,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(447, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmpless  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(448, [$62,$F1,$16,$27,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(449, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(450, [$62,$F1,$16,$27,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(451, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(452, [$62,$91,$16,$27,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(453, [$62,$91,$16,$17,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(454, [$62,$F1,$16,$27,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(455, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmpless  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(456, [$62,$F1,$16,$27,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(457, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(458, [$62,$F1,$16,$27,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(459, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(460, [$62,$91,$16,$27,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(461, [$62,$91,$16,$17,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(462, [$62,$F1,$16,$27,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(463, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(464, [$62,$F1,$16,$27,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(465, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(466, [$62,$F1,$16,$27,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(467, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(468, [$62,$91,$16,$27,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(469, [$62,$91,$16,$17,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(470, [$62,$F1,$16,$27,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(471, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(472, [$62,$F1,$16,$27,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(473, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(474, [$62,$F1,$16,$27,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(475, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(476, [$62,$91,$16,$27,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(477, [$62,$91,$16,$17,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(478, [$62,$F1,$16,$27,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(479, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(480, [$62,$F1,$16,$27,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(481, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(482, [$62,$F1,$16,$27,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(483, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(484, [$62,$91,$16,$27,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(485, [$62,$91,$16,$17,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(486, [$62,$F1,$16,$27,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(487, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(488, [$62,$F1,$16,$27,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(489, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(490, [$62,$F1,$16,$27,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(491, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(492, [$62,$91,$16,$27,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(493, [$62,$91,$16,$17,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(494, [$62,$F1,$16,$27,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(495, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(496, [$62,$F1,$16,$27,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(497, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(498, [$62,$F1,$16,$27,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(499, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(500, [$62,$91,$16,$27,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(501, [$62,$91,$16,$17,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(502, [$62,$F1,$16,$27,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(503, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(504, [$62,$F1,$16,$27,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(505, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(506, [$62,$F1,$16,$27,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(507, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(508, [$62,$91,$16,$27,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(509, [$62,$91,$16,$17,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(510, [$62,$F1,$16,$27,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(511, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnless  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(512, [$62,$F1,$16,$27,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(513, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(514, [$62,$F1,$16,$27,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(515, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(516, [$62,$91,$16,$27,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(517, [$62,$91,$16,$17,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(518, [$62,$F1,$16,$27,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(519, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnless  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(520, [$62,$F1,$16,$27,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(521, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(522, [$62,$F1,$16,$27,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(523, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(524, [$62,$91,$16,$27,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(525, [$62,$91,$16,$17,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(526, [$62,$F1,$16,$27,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(527, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(528, [$62,$F1,$16,$27,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(529, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(530, [$62,$F1,$16,$27,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(531, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(532, [$62,$91,$16,$27,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(533, [$62,$91,$16,$17,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(534, [$62,$F1,$16,$27,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(535, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(536, [$62,$F1,$16,$27,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(537, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(538, [$62,$F1,$16,$27,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(539, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(540, [$62,$91,$16,$27,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(541, [$62,$91,$16,$17,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(542, [$62,$F1,$16,$27,$C2,$29,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(543, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$08   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(544, [$62,$F1,$16,$27,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(545, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$08       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(546, [$62,$F1,$16,$27,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(547, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$08       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(548, [$62,$91,$16,$27,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(549, [$62,$91,$16,$17,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(550, [$62,$F1,$16,$27,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(551, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngess  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(552, [$62,$F1,$16,$27,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(553, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(554, [$62,$F1,$16,$27,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(555, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(556, [$62,$91,$16,$27,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(557, [$62,$91,$16,$17,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(558, [$62,$F1,$16,$27,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(559, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngess  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(560, [$62,$F1,$16,$27,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(561, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(562, [$62,$F1,$16,$27,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(563, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(564, [$62,$91,$16,$27,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(565, [$62,$91,$16,$17,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(566, [$62,$F1,$16,$27,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(567, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(568, [$62,$F1,$16,$27,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(569, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(570, [$62,$F1,$16,$27,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(571, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(572, [$62,$91,$16,$27,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(573, [$62,$91,$16,$17,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(574, [$62,$F1,$16,$27,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(575, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(576, [$62,$F1,$16,$27,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(577, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(578, [$62,$F1,$16,$27,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(579, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(580, [$62,$91,$16,$27,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(581, [$62,$91,$16,$17,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(582, [$62,$F1,$16,$27,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(583, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(584, [$62,$F1,$16,$27,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(585, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(586, [$62,$F1,$16,$27,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(587, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(588, [$62,$91,$16,$27,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(589, [$62,$91,$16,$17,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(590, [$62,$F1,$16,$27,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(591, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(592, [$62,$F1,$16,$27,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(593, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(594, [$62,$F1,$16,$27,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(595, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(596, [$62,$91,$16,$27,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(597, [$62,$91,$16,$17,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(598, [$62,$F1,$16,$27,$C2,$29,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(599, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0C   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(600, [$62,$F1,$16,$27,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(601, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(602, [$62,$F1,$16,$27,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(603, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(604, [$62,$91,$16,$27,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(605, [$62,$91,$16,$17,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(606, [$62,$F1,$16,$27,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(607, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgess  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(608, [$62,$F1,$16,$27,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(609, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(610, [$62,$F1,$16,$27,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(611, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(612, [$62,$91,$16,$27,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(613, [$62,$91,$16,$17,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(614, [$62,$F1,$16,$27,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(615, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgess  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(616, [$62,$F1,$16,$27,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(617, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(618, [$62,$F1,$16,$27,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(619, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(620, [$62,$91,$16,$27,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(621, [$62,$91,$16,$17,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(622, [$62,$F1,$16,$27,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(623, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(624, [$62,$F1,$16,$27,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(625, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(626, [$62,$F1,$16,$27,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(627, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(628, [$62,$91,$16,$27,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(629, [$62,$91,$16,$17,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(630, [$62,$F1,$16,$27,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(631, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(632, [$62,$F1,$16,$27,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(633, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(634, [$62,$F1,$16,$27,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(635, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(636, [$62,$91,$16,$27,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(637, [$62,$91,$16,$17,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(638, [$62,$F1,$16,$27,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm29,dword [rcx]'                );
  TestCase.testcase(639, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuess  k5{k7},xmm29,dword [rax+r14*8+0x123]'    );
  TestCase.testcase(640, [$62,$F1,$16,$27,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x1fc]'          );
  TestCase.testcase(641, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x200]'          );
  TestCase.testcase(642, [$62,$F1,$16,$27,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x200]'          );
  TestCase.testcase(643, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x204]'          );
  TestCase.testcase(644, [$62,$91,$16,$27,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(645, [$62,$91,$16,$17,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(646, [$62,$F1,$16,$27,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm29,dword [rcx]'                );
  TestCase.testcase(647, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuess  k5{k7},xmm29,dword [rax+r14*8+0x123]'    );
  TestCase.testcase(648, [$62,$F1,$16,$27,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x1fc]'          );
  TestCase.testcase(649, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x200]'          );
  TestCase.testcase(650, [$62,$F1,$16,$27,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x200]'          );
  TestCase.testcase(651, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x204]'          );
  TestCase.testcase(652, [$62,$91,$16,$27,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(653, [$62,$91,$16,$17,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(654, [$62,$F1,$16,$27,$C2,$29,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(655, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$10   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(656, [$62,$F1,$16,$27,$C2,$6A,$7F,$10                   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(657, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$10       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(658, [$62,$F1,$16,$27,$C2,$6A,$80,$10                   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(659, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$10       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(660, [$62,$91,$16,$27,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(661, [$62,$91,$16,$17,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(662, [$62,$F1,$16,$27,$C2,$29,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(663, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$11   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(664, [$62,$F1,$16,$27,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(665, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$11       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(666, [$62,$F1,$16,$27,$C2,$6A,$80,$11                   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(667, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$11       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(668, [$62,$91,$16,$27,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(669, [$62,$91,$16,$17,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(670, [$62,$F1,$16,$27,$C2,$29,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(671, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$12   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(672, [$62,$F1,$16,$27,$C2,$6A,$7F,$12                   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(673, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$12       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(674, [$62,$F1,$16,$27,$C2,$6A,$80,$12                   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(675, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$12       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(676, [$62,$91,$16,$27,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,xmm28'                );
  TestCase.testcase(677, [$62,$91,$16,$17,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(678, [$62,$F1,$16,$27,$C2,$29,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rcx]'          );
  TestCase.testcase(679, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$13   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(680, [$62,$F1,$16,$27,$C2,$6A,$7F,$13                   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx+0x1fc]'    );
  TestCase.testcase(681, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$13       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx+0x200]'    );
  TestCase.testcase(682, [$62,$F1,$16,$27,$C2,$6A,$80,$13                   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx-0x200]'    );
  TestCase.testcase(683, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$13       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx-0x204]'    );
  TestCase.testcase(684, [$62,$91,$16,$27,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(685, [$62,$91,$16,$17,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(686, [$62,$F1,$16,$27,$C2,$29,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(687, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$14   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(688, [$62,$F1,$16,$27,$C2,$6A,$7F,$14                   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(689, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$14       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(690, [$62,$F1,$16,$27,$C2,$6A,$80,$14                   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(691, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$14       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(692, [$62,$91,$16,$27,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(693, [$62,$91,$16,$17,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(694, [$62,$F1,$16,$27,$C2,$29,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(695, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$15   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(696, [$62,$F1,$16,$27,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(697, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(698, [$62,$F1,$16,$27,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(699, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(700, [$62,$91,$16,$27,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(701, [$62,$91,$16,$17,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(702, [$62,$F1,$16,$27,$C2,$29,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(703, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$16   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(704, [$62,$F1,$16,$27,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(705, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$16       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(706, [$62,$F1,$16,$27,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(707, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$16       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(708, [$62,$91,$16,$27,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(709, [$62,$91,$16,$17,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(710, [$62,$F1,$16,$27,$C2,$29,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(711, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$17   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(712, [$62,$F1,$16,$27,$C2,$6A,$7F,$17                   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(713, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$17       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(714, [$62,$F1,$16,$27,$C2,$6A,$80,$17                   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(715, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$17       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(716, [$62,$91,$16,$27,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(717, [$62,$91,$16,$17,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(718, [$62,$F1,$16,$27,$C2,$29,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(719, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$18   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(720, [$62,$F1,$16,$27,$C2,$6A,$7F,$18                   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(721, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$18       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(722, [$62,$F1,$16,$27,$C2,$6A,$80,$18                   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(723, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$18       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(724, [$62,$91,$16,$27,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(725, [$62,$91,$16,$17,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(726, [$62,$F1,$16,$27,$C2,$29,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(727, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$19   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(728, [$62,$F1,$16,$27,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(729, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$19       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(730, [$62,$F1,$16,$27,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(731, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$19       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(732, [$62,$91,$16,$27,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(733, [$62,$91,$16,$17,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(734, [$62,$F1,$16,$27,$C2,$29,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(735, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1A   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(736, [$62,$F1,$16,$27,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(737, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(738, [$62,$F1,$16,$27,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(739, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(740, [$62,$91,$16,$27,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,xmm28'               );
  TestCase.testcase(741, [$62,$91,$16,$17,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,xmm28,{sae}'         );
  TestCase.testcase(742, [$62,$F1,$16,$27,$C2,$29,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(743, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1B   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(744, [$62,$F1,$16,$27,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(745, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(746, [$62,$F1,$16,$27,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(747, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(748, [$62,$91,$16,$27,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(749, [$62,$91,$16,$17,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(750, [$62,$F1,$16,$27,$C2,$29,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(751, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1C   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(752, [$62,$F1,$16,$27,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(753, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1C       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(754, [$62,$F1,$16,$27,$C2,$6A,$80,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(755, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1C       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(756, [$62,$91,$16,$27,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(757, [$62,$91,$16,$17,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(758, [$62,$F1,$16,$27,$C2,$29,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(759, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1D   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(760, [$62,$F1,$16,$27,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(761, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1D       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(762, [$62,$F1,$16,$27,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(763, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1D       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(764, [$62,$91,$16,$27,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(765, [$62,$91,$16,$17,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(766, [$62,$F1,$16,$27,$C2,$29,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(767, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1E   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(768, [$62,$F1,$16,$27,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(769, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(770, [$62,$F1,$16,$27,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(771, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(772, [$62,$91,$16,$27,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,xmm28'                   );
  TestCase.testcase(773, [$62,$91,$16,$17,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,xmm28,{sae}'             );
  TestCase.testcase(774, [$62,$F1,$16,$27,$C2,$29,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,dword [rcx]'             );
  TestCase.testcase(775, [$62,$B1,$16,$27,$C2,$AC,$F0,$23,$01,$00,$00,$1F   ] , 'vcmue_usss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(776, [$62,$F1,$16,$27,$C2,$6A,$7F,$1F                   ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx+0x1fc]'       );
  TestCase.testcase(777, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1F       ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx+0x200]'       );
  TestCase.testcase(778, [$62,$F1,$16,$27,$C2,$6A,$80,$1F                   ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx-0x200]'       );
  TestCase.testcase(779, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1F       ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx-0x204]'       );
  TestCase.testcase(780, [$62,$01,$FD,$28,$2F,$F5                           ] , 'vcomisd  xmm30,xmm29'                             );
  TestCase.testcase(781, [$62,$01,$FD,$18,$2F,$F5                           ] , 'vcomisd  xmm30,xmm29,{sae}'                       );
  TestCase.testcase(782, [$62,$61,$FD,$28,$2F,$31                           ] , 'vcomisd  xmm30,qword [rcx]'                       );
  TestCase.testcase(783, [$62,$21,$FD,$28,$2F,$B4,$F0,$23,$01,$00,$00       ] , 'vcomisd  xmm30,qword [rax+r14*8+0x123]'           );
  TestCase.testcase(784, [$62,$61,$FD,$28,$2F,$72,$7F                       ] , 'vcomisd  xmm30,qword [rdx+0x3f8]'                 );
  TestCase.testcase(785, [$62,$61,$FD,$28,$2F,$B2,$00,$04,$00,$00           ] , 'vcomisd  xmm30,qword [rdx+0x400]'                 );
  TestCase.testcase(786, [$62,$61,$FD,$28,$2F,$72,$80                       ] , 'vcomisd  xmm30,qword [rdx-0x400]'                 );
  TestCase.testcase(787, [$62,$61,$FD,$28,$2F,$B2,$F8,$FB,$FF,$FF           ] , 'vcomisd  xmm30,qword [rdx-0x408]'                 );
  TestCase.testcase(788, [$62,$01,$7C,$28,$2F,$F5                           ] , 'vcomiss  xmm30,xmm29'                             );
  TestCase.testcase(789, [$62,$01,$7C,$18,$2F,$F5                           ] , 'vcomiss  xmm30,xmm29,{sae}'                       );
  TestCase.testcase(790, [$62,$61,$7C,$28,$2F,$31                           ] , 'vcomiss  xmm30,dword [rcx]'                       );
  TestCase.testcase(791, [$62,$21,$7C,$28,$2F,$B4,$F0,$23,$01,$00,$00       ] , 'vcomiss  xmm30,dword [rax+r14*8+0x123]'           );
  TestCase.testcase(792, [$62,$61,$7C,$28,$2F,$72,$7F                       ] , 'vcomiss  xmm30,dword [rdx+0x1fc]'                 );
  TestCase.testcase(793, [$62,$61,$7C,$28,$2F,$B2,$00,$02,$00,$00           ] , 'vcomiss  xmm30,dword [rdx+0x200]'                 );
  TestCase.testcase(794, [$62,$61,$7C,$28,$2F,$72,$80                       ] , 'vcomiss  xmm30,dword [rdx-0x200]'                 );
  TestCase.testcase(795, [$62,$61,$7C,$28,$2F,$B2,$FC,$FD,$FF,$FF           ] , 'vcomiss  xmm30,dword [rdx-0x204]'                 );
  TestCase.testcase(796, [$62,$91,$7F,$18,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rn-sae}'                    );
  TestCase.testcase(797, [$62,$91,$7F,$58,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{ru-sae}'                    );
  TestCase.testcase(798, [$62,$91,$7F,$38,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rd-sae}'                    );
  TestCase.testcase(799, [$62,$91,$7F,$78,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rz-sae}'                    );
  TestCase.testcase(800, [$62,$91,$7F,$18,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rn-sae}'                    );
  TestCase.testcase(801, [$62,$91,$7F,$58,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{ru-sae}'                    );
  TestCase.testcase(802, [$62,$91,$7F,$38,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rd-sae}'                    );
  TestCase.testcase(803, [$62,$91,$7F,$78,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rz-sae}'                    );
  TestCase.testcase(804, [$62,$11,$7F,$18,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rn-sae}'                   );
  TestCase.testcase(805, [$62,$11,$7F,$58,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{ru-sae}'                   );
  TestCase.testcase(806, [$62,$11,$7F,$38,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rd-sae}'                   );
  TestCase.testcase(807, [$62,$11,$7F,$78,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rz-sae}'                   );
  TestCase.testcase(808, [$62,$91,$FF,$18,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rn-sae}'                    );
  TestCase.testcase(809, [$62,$91,$FF,$58,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{ru-sae}'                    );
  TestCase.testcase(810, [$62,$91,$FF,$38,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rd-sae}'                    );
  TestCase.testcase(811, [$62,$91,$FF,$78,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rz-sae}'                    );
  TestCase.testcase(812, [$62,$11,$FF,$18,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rn-sae}'                     );
  TestCase.testcase(813, [$62,$11,$FF,$58,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{ru-sae}'                     );
  TestCase.testcase(814, [$62,$11,$FF,$38,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rd-sae}'                     );
  TestCase.testcase(815, [$62,$11,$FF,$78,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rz-sae}'                     );
  TestCase.testcase(816, [$62,$01,$97,$27,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(817, [$62,$01,$97,$A7,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(818, [$62,$01,$97,$17,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(819, [$62,$01,$97,$57,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(820, [$62,$01,$97,$37,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(821, [$62,$01,$97,$77,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(822, [$62,$61,$97,$27,$5A,$31                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(823, [$62,$21,$97,$27,$5A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(824, [$62,$61,$97,$27,$5A,$72,$7F                       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(825, [$62,$61,$97,$27,$5A,$B2,$00,$04,$00,$00           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(826, [$62,$61,$97,$27,$5A,$72,$80                       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(827, [$62,$61,$97,$27,$5A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(828, [$62,$61,$17,$20,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,eax'                       );
  TestCase.testcase(829, [$62,$61,$17,$20,$2A,$F5                           ] , 'vcvtsi2sd  xmm30,xmm29,ebp'                       );
  TestCase.testcase(830, [$62,$41,$17,$20,$2A,$F5                           ] , 'vcvtsi2sd  xmm30,xmm29,r13d'                      );
  TestCase.testcase(831, [$62,$61,$17,$20,$2A,$31                           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rcx]'               );
  TestCase.testcase(832, [$62,$21,$17,$20,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(833, [$62,$61,$17,$20,$2A,$72,$7F                       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(834, [$62,$61,$17,$20,$2A,$B2,$00,$02,$00,$00           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(835, [$62,$61,$17,$20,$2A,$72,$80                       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(836, [$62,$61,$17,$20,$2A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(837, [$62,$61,$97,$20,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,rax'                       );
  TestCase.testcase(838, [$62,$61,$97,$10,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rn-sae},rax'              );
  TestCase.testcase(839, [$62,$61,$97,$50,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{ru-sae},rax'              );
  TestCase.testcase(840, [$62,$61,$97,$30,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rd-sae},rax'              );
  TestCase.testcase(841, [$62,$61,$97,$70,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rz-sae},rax'              );
  TestCase.testcase(842, [$62,$41,$97,$20,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,r8'                        );
  TestCase.testcase(843, [$62,$41,$97,$10,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rn-sae},r8'               );
  TestCase.testcase(844, [$62,$41,$97,$50,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{ru-sae},r8'               );
  TestCase.testcase(845, [$62,$41,$97,$30,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rd-sae},r8'               );
  TestCase.testcase(846, [$62,$41,$97,$70,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rz-sae},r8'               );
  TestCase.testcase(847, [$62,$61,$97,$20,$2A,$31                           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rcx]'               );
  TestCase.testcase(848, [$62,$21,$97,$20,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(849, [$62,$61,$97,$20,$2A,$72,$7F                       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(850, [$62,$61,$97,$20,$2A,$B2,$00,$04,$00,$00           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(851, [$62,$61,$97,$20,$2A,$72,$80                       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(852, [$62,$61,$97,$20,$2A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(853, [$62,$61,$16,$20,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,eax'                       );
  TestCase.testcase(854, [$62,$61,$16,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},eax'              );
  TestCase.testcase(855, [$62,$61,$16,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},eax'              );
  TestCase.testcase(856, [$62,$61,$16,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},eax'              );
  TestCase.testcase(857, [$62,$61,$16,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},eax'              );
  TestCase.testcase(858, [$62,$61,$16,$20,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,ebp'                       );
  TestCase.testcase(859, [$62,$61,$16,$10,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},ebp'              );
  TestCase.testcase(860, [$62,$61,$16,$50,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},ebp'              );
  TestCase.testcase(861, [$62,$61,$16,$30,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},ebp'              );
  TestCase.testcase(862, [$62,$61,$16,$70,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},ebp'              );
  TestCase.testcase(863, [$62,$41,$16,$20,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,r13d'                      );
  TestCase.testcase(864, [$62,$41,$16,$10,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},r13d'             );
  TestCase.testcase(865, [$62,$41,$16,$50,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},r13d'             );
  TestCase.testcase(866, [$62,$41,$16,$30,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},r13d'             );
  TestCase.testcase(867, [$62,$41,$16,$70,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},r13d'             );
  TestCase.testcase(868, [$62,$61,$16,$20,$2A,$31                           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rcx]'               );
  TestCase.testcase(869, [$62,$21,$16,$20,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(870, [$62,$61,$16,$20,$2A,$72,$7F                       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(871, [$62,$61,$16,$20,$2A,$B2,$00,$02,$00,$00           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(872, [$62,$61,$16,$20,$2A,$72,$80                       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(873, [$62,$61,$16,$20,$2A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(874, [$62,$61,$96,$20,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,rax'                       );
  TestCase.testcase(875, [$62,$61,$96,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},rax'              );
  TestCase.testcase(876, [$62,$61,$96,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},rax'              );
  TestCase.testcase(877, [$62,$61,$96,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},rax'              );
  TestCase.testcase(878, [$62,$61,$96,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},rax'              );
  TestCase.testcase(879, [$62,$41,$96,$20,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,r8'                        );
  TestCase.testcase(880, [$62,$41,$96,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},r8'               );
  TestCase.testcase(881, [$62,$41,$96,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},r8'               );
  TestCase.testcase(882, [$62,$41,$96,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},r8'               );
  TestCase.testcase(883, [$62,$41,$96,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},r8'               );
  TestCase.testcase(884, [$62,$61,$96,$20,$2A,$31                           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rcx]'               );
  TestCase.testcase(885, [$62,$21,$96,$20,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(886, [$62,$61,$96,$20,$2A,$72,$7F                       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(887, [$62,$61,$96,$20,$2A,$B2,$00,$04,$00,$00           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(888, [$62,$61,$96,$20,$2A,$72,$80                       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(889, [$62,$61,$96,$20,$2A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(890, [$62,$01,$16,$27,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(891, [$62,$01,$16,$A7,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(892, [$62,$01,$16,$17,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(893, [$62,$61,$16,$27,$5A,$31                           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(894, [$62,$21,$16,$27,$5A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(895, [$62,$61,$16,$27,$5A,$72,$7F                       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(896, [$62,$61,$16,$27,$5A,$B2,$00,$02,$00,$00           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(897, [$62,$61,$16,$27,$5A,$72,$80                       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(898, [$62,$61,$16,$27,$5A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(899, [$62,$91,$7E,$18,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rn-sae}'                    );
  TestCase.testcase(900, [$62,$91,$7E,$58,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{ru-sae}'                    );
  TestCase.testcase(901, [$62,$91,$7E,$38,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rd-sae}'                    );
  TestCase.testcase(902, [$62,$91,$7E,$78,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rz-sae}'                    );
  TestCase.testcase(903, [$62,$91,$7E,$18,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rn-sae}'                    );
  TestCase.testcase(904, [$62,$91,$7E,$58,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{ru-sae}'                    );
  TestCase.testcase(905, [$62,$91,$7E,$38,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rd-sae}'                    );
  TestCase.testcase(906, [$62,$91,$7E,$78,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rz-sae}'                    );
  TestCase.testcase(907, [$62,$11,$7E,$18,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rn-sae}'                   );
  TestCase.testcase(908, [$62,$11,$7E,$58,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{ru-sae}'                   );
  TestCase.testcase(909, [$62,$11,$7E,$38,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rd-sae}'                   );
  TestCase.testcase(910, [$62,$11,$7E,$78,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rz-sae}'                   );
  TestCase.testcase(911, [$62,$91,$FE,$18,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rn-sae}'                    );
  TestCase.testcase(912, [$62,$91,$FE,$58,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{ru-sae}'                    );
  TestCase.testcase(913, [$62,$91,$FE,$38,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rd-sae}'                    );
  TestCase.testcase(914, [$62,$91,$FE,$78,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rz-sae}'                    );
  TestCase.testcase(915, [$62,$11,$FE,$18,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rn-sae}'                     );
  TestCase.testcase(916, [$62,$11,$FE,$58,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{ru-sae}'                     );
  TestCase.testcase(917, [$62,$11,$FE,$38,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rd-sae}'                     );
  TestCase.testcase(918, [$62,$11,$FE,$78,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rz-sae}'                     );
  TestCase.testcase(919, [$62,$91,$7F,$18,$2C,$C6                           ] , 'vcvttsd2si  eax,xmm30,{sae}'                      );
  TestCase.testcase(920, [$62,$91,$7F,$18,$2C,$EE                           ] , 'vcvttsd2si  ebp,xmm30,{sae}'                      );
  TestCase.testcase(921, [$62,$11,$7F,$18,$2C,$EE                           ] , 'vcvttsd2si  r13d,xmm30,{sae}'                     );
  TestCase.testcase(922, [$62,$91,$FF,$18,$2C,$C6                           ] , 'vcvttsd2si  rax,xmm30,{sae}'                      );
  TestCase.testcase(923, [$62,$11,$FF,$18,$2C,$C6                           ] , 'vcvttsd2si  r8,xmm30,{sae}'                       );
  TestCase.testcase(924, [$62,$91,$7E,$18,$2C,$C6                           ] , 'vcvttss2si  eax,xmm30,{sae}'                      );
  TestCase.testcase(925, [$62,$91,$7E,$18,$2C,$EE                           ] , 'vcvttss2si  ebp,xmm30,{sae}'                      );
  TestCase.testcase(926, [$62,$11,$7E,$18,$2C,$EE                           ] , 'vcvttss2si  r13d,xmm30,{sae}'                     );
  TestCase.testcase(927, [$62,$91,$FE,$18,$2C,$C6                           ] , 'vcvttss2si  rax,xmm30,{sae}'                      );
  TestCase.testcase(928, [$62,$11,$FE,$18,$2C,$C6                           ] , 'vcvttss2si  r8,xmm30,{sae}'                       );
  TestCase.testcase(929, [$62,$01,$97,$27,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(930, [$62,$01,$97,$A7,$5E,$F4                           ] , 'vdivsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(931, [$62,$01,$97,$17,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(932, [$62,$01,$97,$57,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(933, [$62,$01,$97,$37,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(934, [$62,$01,$97,$77,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(935, [$62,$61,$97,$27,$5E,$31                           ] , 'vdivsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(936, [$62,$21,$97,$27,$5E,$B4,$F0,$23,$01,$00,$00       ] , 'vdivsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(937, [$62,$61,$97,$27,$5E,$72,$7F                       ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(938, [$62,$61,$97,$27,$5E,$B2,$00,$04,$00,$00           ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(939, [$62,$61,$97,$27,$5E,$72,$80                       ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(940, [$62,$61,$97,$27,$5E,$B2,$F8,$FB,$FF,$FF           ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(941, [$62,$01,$16,$27,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(942, [$62,$01,$16,$A7,$5E,$F4                           ] , 'vdivss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(943, [$62,$01,$16,$17,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(944, [$62,$01,$16,$57,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(945, [$62,$01,$16,$37,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(946, [$62,$01,$16,$77,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(947, [$62,$61,$16,$27,$5E,$31                           ] , 'vdivss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(948, [$62,$21,$16,$27,$5E,$B4,$F0,$23,$01,$00,$00       ] , 'vdivss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(949, [$62,$61,$16,$27,$5E,$72,$7F                       ] , 'vdivss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(950, [$62,$61,$16,$27,$5E,$B2,$00,$02,$00,$00           ] , 'vdivss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(951, [$62,$61,$16,$27,$5E,$72,$80                       ] , 'vdivss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(952, [$62,$61,$16,$27,$5E,$B2,$FC,$FD,$FF,$FF           ] , 'vdivss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(953, [$62,$02,$95,$27,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(954, [$62,$02,$95,$A7,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(955, [$62,$02,$95,$17,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(956, [$62,$02,$95,$57,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(957, [$62,$02,$95,$37,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(958, [$62,$02,$95,$77,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(959, [$62,$62,$95,$27,$99,$31                           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(960, [$62,$22,$95,$27,$99,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(961, [$62,$62,$95,$27,$99,$72,$7F                       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(962, [$62,$62,$95,$27,$99,$B2,$00,$04,$00,$00           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(963, [$62,$62,$95,$27,$99,$72,$80                       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(964, [$62,$62,$95,$27,$99,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(965, [$62,$02,$15,$27,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(966, [$62,$02,$15,$A7,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(967, [$62,$02,$15,$17,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(968, [$62,$02,$15,$57,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(969, [$62,$02,$15,$37,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(970, [$62,$02,$15,$77,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(971, [$62,$62,$15,$27,$99,$31                           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(972, [$62,$22,$15,$27,$99,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(973, [$62,$62,$15,$27,$99,$72,$7F                       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(974, [$62,$62,$15,$27,$99,$B2,$00,$02,$00,$00           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(975, [$62,$62,$15,$27,$99,$72,$80                       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(976, [$62,$62,$15,$27,$99,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(977, [$62,$02,$95,$27,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(978, [$62,$02,$95,$A7,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(979, [$62,$02,$95,$17,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(980, [$62,$02,$95,$57,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(981, [$62,$02,$95,$37,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(982, [$62,$02,$95,$77,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(983, [$62,$62,$95,$27,$A9,$31                           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(984, [$62,$22,$95,$27,$A9,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(985, [$62,$62,$95,$27,$A9,$72,$7F                       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(986, [$62,$62,$95,$27,$A9,$B2,$00,$04,$00,$00           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(987, [$62,$62,$95,$27,$A9,$72,$80                       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(988, [$62,$62,$95,$27,$A9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(989, [$62,$02,$15,$27,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(990, [$62,$02,$15,$A7,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(991, [$62,$02,$15,$17,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(992, [$62,$02,$15,$57,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(993, [$62,$02,$15,$37,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(994, [$62,$02,$15,$77,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(995, [$62,$62,$15,$27,$A9,$31                           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(996, [$62,$22,$15,$27,$A9,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(997, [$62,$62,$15,$27,$A9,$72,$7F                       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(998, [$62,$62,$15,$27,$A9,$B2,$00,$02,$00,$00           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(999, [$62,$62,$15,$27,$A9,$72,$80                       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(1000, [$62,$62,$15,$27,$A9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(1001, [$62,$02,$95,$27,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(1002, [$62,$02,$95,$A7,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(1003, [$62,$02,$95,$17,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(1004, [$62,$02,$95,$57,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(1005, [$62,$02,$95,$37,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(1006, [$62,$02,$95,$77,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(1007, [$62,$62,$95,$27,$B9,$31                           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(1008, [$62,$22,$95,$27,$B9,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1009, [$62,$62,$95,$27,$B9,$72,$7F                       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(1010, [$62,$62,$95,$27,$B9,$B2,$00,$04,$00,$00           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(1011, [$62,$62,$95,$27,$B9,$72,$80                       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(1012, [$62,$62,$95,$27,$B9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(1013, [$62,$02,$15,$27,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(1014, [$62,$02,$15,$A7,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(1015, [$62,$02,$15,$17,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(1016, [$62,$02,$15,$57,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(1017, [$62,$02,$15,$37,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(1018, [$62,$02,$15,$77,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(1019, [$62,$62,$15,$27,$B9,$31                           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(1020, [$62,$22,$15,$27,$B9,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1021, [$62,$62,$15,$27,$B9,$72,$7F                       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(1022, [$62,$62,$15,$27,$B9,$B2,$00,$02,$00,$00           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(1023, [$62,$62,$15,$27,$B9,$72,$80                       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(1024, [$62,$62,$15,$27,$B9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(1025, [$62,$02,$95,$27,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(1026, [$62,$02,$95,$A7,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(1027, [$62,$02,$95,$17,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(1028, [$62,$02,$95,$57,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(1029, [$62,$02,$95,$37,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(1030, [$62,$02,$95,$77,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(1031, [$62,$62,$95,$27,$9B,$31                           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(1032, [$62,$22,$95,$27,$9B,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1033, [$62,$62,$95,$27,$9B,$72,$7F                       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(1034, [$62,$62,$95,$27,$9B,$B2,$00,$04,$00,$00           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(1035, [$62,$62,$95,$27,$9B,$72,$80                       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(1036, [$62,$62,$95,$27,$9B,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(1037, [$62,$02,$15,$27,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(1038, [$62,$02,$15,$A7,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(1039, [$62,$02,$15,$17,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(1040, [$62,$02,$15,$57,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(1041, [$62,$02,$15,$37,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(1042, [$62,$02,$15,$77,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(1043, [$62,$62,$15,$27,$9B,$31                           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(1044, [$62,$22,$15,$27,$9B,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1045, [$62,$62,$15,$27,$9B,$72,$7F                       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(1046, [$62,$62,$15,$27,$9B,$B2,$00,$02,$00,$00           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(1047, [$62,$62,$15,$27,$9B,$72,$80                       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(1048, [$62,$62,$15,$27,$9B,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(1049, [$62,$02,$95,$27,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(1050, [$62,$02,$95,$A7,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(1051, [$62,$02,$95,$17,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(1052, [$62,$02,$95,$57,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(1053, [$62,$02,$95,$37,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(1054, [$62,$02,$95,$77,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(1055, [$62,$62,$95,$27,$AB,$31                           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(1056, [$62,$22,$95,$27,$AB,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1057, [$62,$62,$95,$27,$AB,$72,$7F                       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(1058, [$62,$62,$95,$27,$AB,$B2,$00,$04,$00,$00           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(1059, [$62,$62,$95,$27,$AB,$72,$80                       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(1060, [$62,$62,$95,$27,$AB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(1061, [$62,$02,$15,$27,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(1062, [$62,$02,$15,$A7,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(1063, [$62,$02,$15,$17,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(1064, [$62,$02,$15,$57,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(1065, [$62,$02,$15,$37,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(1066, [$62,$02,$15,$77,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(1067, [$62,$62,$15,$27,$AB,$31                           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(1068, [$62,$22,$15,$27,$AB,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1069, [$62,$62,$15,$27,$AB,$72,$7F                       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(1070, [$62,$62,$15,$27,$AB,$B2,$00,$02,$00,$00           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(1071, [$62,$62,$15,$27,$AB,$72,$80                       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(1072, [$62,$62,$15,$27,$AB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(1073, [$62,$02,$95,$27,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(1074, [$62,$02,$95,$A7,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(1075, [$62,$02,$95,$17,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(1076, [$62,$02,$95,$57,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(1077, [$62,$02,$95,$37,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(1078, [$62,$02,$95,$77,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(1079, [$62,$62,$95,$27,$BB,$31                           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(1080, [$62,$22,$95,$27,$BB,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1081, [$62,$62,$95,$27,$BB,$72,$7F                       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(1082, [$62,$62,$95,$27,$BB,$B2,$00,$04,$00,$00           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(1083, [$62,$62,$95,$27,$BB,$72,$80                       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(1084, [$62,$62,$95,$27,$BB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(1085, [$62,$02,$15,$27,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(1086, [$62,$02,$15,$A7,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(1087, [$62,$02,$15,$17,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(1088, [$62,$02,$15,$57,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(1089, [$62,$02,$15,$37,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(1090, [$62,$02,$15,$77,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(1091, [$62,$62,$15,$27,$BB,$31                           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(1092, [$62,$22,$15,$27,$BB,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1093, [$62,$62,$15,$27,$BB,$72,$7F                       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(1094, [$62,$62,$15,$27,$BB,$B2,$00,$02,$00,$00           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(1095, [$62,$62,$15,$27,$BB,$72,$80                       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(1096, [$62,$62,$15,$27,$BB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(1097, [$62,$02,$95,$27,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1098, [$62,$02,$95,$A7,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1099, [$62,$02,$95,$17,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1100, [$62,$02,$95,$57,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1101, [$62,$02,$95,$37,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1102, [$62,$02,$95,$77,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1103, [$62,$62,$95,$27,$9D,$31                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(1104, [$62,$22,$95,$27,$9D,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1105, [$62,$62,$95,$27,$9D,$72,$7F                       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(1106, [$62,$62,$95,$27,$9D,$B2,$00,$04,$00,$00           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(1107, [$62,$62,$95,$27,$9D,$72,$80                       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(1108, [$62,$62,$95,$27,$9D,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(1109, [$62,$02,$15,$27,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1110, [$62,$02,$15,$A7,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1111, [$62,$02,$15,$17,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1112, [$62,$02,$15,$57,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1113, [$62,$02,$15,$37,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1114, [$62,$02,$15,$77,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1115, [$62,$62,$15,$27,$9D,$31                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(1116, [$62,$22,$15,$27,$9D,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1117, [$62,$62,$15,$27,$9D,$72,$7F                       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(1118, [$62,$62,$15,$27,$9D,$B2,$00,$02,$00,$00           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(1119, [$62,$62,$15,$27,$9D,$72,$80                       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(1120, [$62,$62,$15,$27,$9D,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(1121, [$62,$02,$95,$27,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1122, [$62,$02,$95,$A7,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1123, [$62,$02,$95,$17,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1124, [$62,$02,$95,$57,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1125, [$62,$02,$95,$37,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1126, [$62,$02,$95,$77,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1127, [$62,$62,$95,$27,$AD,$31                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(1128, [$62,$22,$95,$27,$AD,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1129, [$62,$62,$95,$27,$AD,$72,$7F                       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(1130, [$62,$62,$95,$27,$AD,$B2,$00,$04,$00,$00           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(1131, [$62,$62,$95,$27,$AD,$72,$80                       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(1132, [$62,$62,$95,$27,$AD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(1133, [$62,$02,$15,$27,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1134, [$62,$02,$15,$A7,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1135, [$62,$02,$15,$17,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1136, [$62,$02,$15,$57,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1137, [$62,$02,$15,$37,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1138, [$62,$02,$15,$77,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1139, [$62,$62,$15,$27,$AD,$31                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(1140, [$62,$22,$15,$27,$AD,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1141, [$62,$62,$15,$27,$AD,$72,$7F                       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(1142, [$62,$62,$15,$27,$AD,$B2,$00,$02,$00,$00           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(1143, [$62,$62,$15,$27,$AD,$72,$80                       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(1144, [$62,$62,$15,$27,$AD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(1145, [$62,$02,$95,$27,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1146, [$62,$02,$95,$A7,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1147, [$62,$02,$95,$17,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1148, [$62,$02,$95,$57,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1149, [$62,$02,$95,$37,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1150, [$62,$02,$95,$77,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1151, [$62,$62,$95,$27,$BD,$31                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(1152, [$62,$22,$95,$27,$BD,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1153, [$62,$62,$95,$27,$BD,$72,$7F                       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(1154, [$62,$62,$95,$27,$BD,$B2,$00,$04,$00,$00           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(1155, [$62,$62,$95,$27,$BD,$72,$80                       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(1156, [$62,$62,$95,$27,$BD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(1157, [$62,$02,$15,$27,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1158, [$62,$02,$15,$A7,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1159, [$62,$02,$15,$17,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1160, [$62,$02,$15,$57,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1161, [$62,$02,$15,$37,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1162, [$62,$02,$15,$77,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1163, [$62,$62,$15,$27,$BD,$31                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(1164, [$62,$22,$15,$27,$BD,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1165, [$62,$62,$15,$27,$BD,$72,$7F                       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(1166, [$62,$62,$15,$27,$BD,$B2,$00,$02,$00,$00           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(1167, [$62,$62,$15,$27,$BD,$72,$80                       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(1168, [$62,$62,$15,$27,$BD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(1169, [$62,$02,$95,$27,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1170, [$62,$02,$95,$A7,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1171, [$62,$02,$95,$17,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1172, [$62,$02,$95,$57,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1173, [$62,$02,$95,$37,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1174, [$62,$02,$95,$77,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1175, [$62,$62,$95,$27,$9F,$31                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(1176, [$62,$22,$95,$27,$9F,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1177, [$62,$62,$95,$27,$9F,$72,$7F                       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(1178, [$62,$62,$95,$27,$9F,$B2,$00,$04,$00,$00           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(1179, [$62,$62,$95,$27,$9F,$72,$80                       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(1180, [$62,$62,$95,$27,$9F,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(1181, [$62,$02,$15,$27,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1182, [$62,$02,$15,$A7,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1183, [$62,$02,$15,$17,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1184, [$62,$02,$15,$57,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1185, [$62,$02,$15,$37,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1186, [$62,$02,$15,$77,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1187, [$62,$62,$15,$27,$9F,$31                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(1188, [$62,$22,$15,$27,$9F,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1189, [$62,$62,$15,$27,$9F,$72,$7F                       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(1190, [$62,$62,$15,$27,$9F,$B2,$00,$02,$00,$00           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(1191, [$62,$62,$15,$27,$9F,$72,$80                       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(1192, [$62,$62,$15,$27,$9F,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(1193, [$62,$02,$95,$27,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1194, [$62,$02,$95,$A7,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1195, [$62,$02,$95,$17,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1196, [$62,$02,$95,$57,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1197, [$62,$02,$95,$37,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1198, [$62,$02,$95,$77,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1199, [$62,$62,$95,$27,$AF,$31                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(1200, [$62,$22,$95,$27,$AF,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1201, [$62,$62,$95,$27,$AF,$72,$7F                       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(1202, [$62,$62,$95,$27,$AF,$B2,$00,$04,$00,$00           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(1203, [$62,$62,$95,$27,$AF,$72,$80                       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(1204, [$62,$62,$95,$27,$AF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(1205, [$62,$02,$15,$27,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1206, [$62,$02,$15,$A7,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1207, [$62,$02,$15,$17,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1208, [$62,$02,$15,$57,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1209, [$62,$02,$15,$37,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1210, [$62,$02,$15,$77,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1211, [$62,$62,$15,$27,$AF,$31                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(1212, [$62,$22,$15,$27,$AF,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1213, [$62,$62,$15,$27,$AF,$72,$7F                       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(1214, [$62,$62,$15,$27,$AF,$B2,$00,$02,$00,$00           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(1215, [$62,$62,$15,$27,$AF,$72,$80                       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(1216, [$62,$62,$15,$27,$AF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(1217, [$62,$02,$95,$27,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1218, [$62,$02,$95,$A7,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1219, [$62,$02,$95,$17,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1220, [$62,$02,$95,$57,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1221, [$62,$02,$95,$37,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1222, [$62,$02,$95,$77,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1223, [$62,$62,$95,$27,$BF,$31                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(1224, [$62,$22,$95,$27,$BF,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1225, [$62,$62,$95,$27,$BF,$72,$7F                       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(1226, [$62,$62,$95,$27,$BF,$B2,$00,$04,$00,$00           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(1227, [$62,$62,$95,$27,$BF,$72,$80                       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(1228, [$62,$62,$95,$27,$BF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(1229, [$62,$02,$15,$27,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(1230, [$62,$02,$15,$A7,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(1231, [$62,$02,$15,$17,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(1232, [$62,$02,$15,$57,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(1233, [$62,$02,$15,$37,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(1234, [$62,$02,$15,$77,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(1235, [$62,$62,$15,$27,$BF,$31                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(1236, [$62,$22,$15,$27,$BF,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1237, [$62,$62,$15,$27,$BF,$72,$7F                       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(1238, [$62,$62,$15,$27,$BF,$B2,$00,$02,$00,$00           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(1239, [$62,$62,$15,$27,$BF,$72,$80                       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(1240, [$62,$62,$15,$27,$BF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(1241, [$62,$02,$95,$27,$43,$F4                           ] , 'vgetexpsd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(1242, [$62,$02,$95,$A7,$43,$F4                           ] , 'vgetexpsd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(1243, [$62,$02,$95,$17,$43,$F4                           ] , 'vgetexpsd  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1244, [$62,$62,$95,$27,$43,$31                           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1245, [$62,$22,$95,$27,$43,$B4,$F0,$23,$01,$00,$00       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1246, [$62,$62,$95,$27,$43,$72,$7F                       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1247, [$62,$62,$95,$27,$43,$B2,$00,$04,$00,$00           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1248, [$62,$62,$95,$27,$43,$72,$80                       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1249, [$62,$62,$95,$27,$43,$B2,$F8,$FB,$FF,$FF           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1250, [$62,$02,$15,$27,$43,$F4                           ] , 'vgetexpss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(1251, [$62,$02,$15,$A7,$43,$F4                           ] , 'vgetexpss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(1252, [$62,$02,$15,$17,$43,$F4                           ] , 'vgetexpss  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1253, [$62,$62,$15,$27,$43,$31                           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(1254, [$62,$22,$15,$27,$43,$B4,$F0,$23,$01,$00,$00       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1255, [$62,$62,$15,$27,$43,$72,$7F                       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(1256, [$62,$62,$15,$27,$43,$B2,$00,$02,$00,$00           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(1257, [$62,$62,$15,$27,$43,$72,$80                       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(1258, [$62,$62,$15,$27,$43,$B2,$FC,$FD,$FF,$FF           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(1259, [$62,$03,$95,$27,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,0xab'           );
  TestCase.testcase(1260, [$62,$03,$95,$A7,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7}{z},xmm29,xmm28,0xab'        );
  TestCase.testcase(1261, [$62,$03,$95,$17,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,{sae},0xab'     );
  TestCase.testcase(1262, [$62,$03,$95,$27,$27,$F4,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,0x7b'           );
  TestCase.testcase(1263, [$62,$03,$95,$17,$27,$F4,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,{sae},0x7b'     );
  TestCase.testcase(1264, [$62,$63,$95,$27,$27,$31,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rcx],0x7b'     );
  TestCase.testcase(1265, [$62,$23,$95,$27,$27,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(1266, [$62,$63,$95,$27,$27,$72,$7F,$7B                   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(1267, [$62,$63,$95,$27,$27,$B2,$00,$04,$00,$00,$7B       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(1268, [$62,$63,$95,$27,$27,$72,$80,$7B                   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(1269, [$62,$63,$95,$27,$27,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(1270, [$62,$03,$15,$27,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,0xab'           );
  TestCase.testcase(1271, [$62,$03,$15,$A7,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7}{z},xmm29,xmm28,0xab'        );
  TestCase.testcase(1272, [$62,$03,$15,$17,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,{sae},0xab'     );
  TestCase.testcase(1273, [$62,$03,$15,$27,$27,$F4,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,0x7b'           );
  TestCase.testcase(1274, [$62,$03,$15,$17,$27,$F4,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,{sae},0x7b'     );
  TestCase.testcase(1275, [$62,$63,$15,$27,$27,$31,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rcx],0x7b'     );
  TestCase.testcase(1276, [$62,$23,$15,$27,$27,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(1277, [$62,$63,$15,$27,$27,$72,$7F,$7B                   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(1278, [$62,$63,$15,$27,$27,$B2,$00,$02,$00,$00,$7B       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(1279, [$62,$63,$15,$27,$27,$72,$80,$7B                   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(1280, [$62,$63,$15,$27,$27,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.testcase(1281, [$62,$01,$97,$27,$5F,$F4                           ] , 'vmaxsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1282, [$62,$01,$97,$A7,$5F,$F4                           ] , 'vmaxsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1283, [$62,$01,$97,$17,$5F,$F4                           ] , 'vmaxsd  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1284, [$62,$61,$97,$27,$5F,$31                           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1285, [$62,$21,$97,$27,$5F,$B4,$F0,$23,$01,$00,$00       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1286, [$62,$61,$97,$27,$5F,$72,$7F                       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1287, [$62,$61,$97,$27,$5F,$B2,$00,$04,$00,$00           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1288, [$62,$61,$97,$27,$5F,$72,$80                       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1289, [$62,$61,$97,$27,$5F,$B2,$F8,$FB,$FF,$FF           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1290, [$62,$01,$16,$27,$5F,$F4                           ] , 'vmaxss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1291, [$62,$01,$16,$A7,$5F,$F4                           ] , 'vmaxss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1292, [$62,$01,$16,$17,$5F,$F4                           ] , 'vmaxss  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1293, [$62,$61,$16,$27,$5F,$31                           ] , 'vmaxss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1294, [$62,$21,$16,$27,$5F,$B4,$F0,$23,$01,$00,$00       ] , 'vmaxss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1295, [$62,$61,$16,$27,$5F,$72,$7F                       ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1296, [$62,$61,$16,$27,$5F,$B2,$00,$02,$00,$00           ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1297, [$62,$61,$16,$27,$5F,$72,$80                       ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1298, [$62,$61,$16,$27,$5F,$B2,$FC,$FD,$FF,$FF           ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1299, [$62,$01,$97,$27,$5D,$F4                           ] , 'vminsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1300, [$62,$01,$97,$A7,$5D,$F4                           ] , 'vminsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1301, [$62,$01,$97,$17,$5D,$F4                           ] , 'vminsd  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1302, [$62,$61,$97,$27,$5D,$31                           ] , 'vminsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1303, [$62,$21,$97,$27,$5D,$B4,$F0,$23,$01,$00,$00       ] , 'vminsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1304, [$62,$61,$97,$27,$5D,$72,$7F                       ] , 'vminsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1305, [$62,$61,$97,$27,$5D,$B2,$00,$04,$00,$00           ] , 'vminsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1306, [$62,$61,$97,$27,$5D,$72,$80                       ] , 'vminsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1307, [$62,$61,$97,$27,$5D,$B2,$F8,$FB,$FF,$FF           ] , 'vminsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1308, [$62,$01,$16,$27,$5D,$F4                           ] , 'vminss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1309, [$62,$01,$16,$A7,$5D,$F4                           ] , 'vminss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1310, [$62,$01,$16,$17,$5D,$F4                           ] , 'vminss  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1311, [$62,$61,$16,$27,$5D,$31                           ] , 'vminss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1312, [$62,$21,$16,$27,$5D,$B4,$F0,$23,$01,$00,$00       ] , 'vminss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1313, [$62,$61,$16,$27,$5D,$72,$7F                       ] , 'vminss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1314, [$62,$61,$16,$27,$5D,$B2,$00,$02,$00,$00           ] , 'vminss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1315, [$62,$61,$16,$27,$5D,$72,$80                       ] , 'vminss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1316, [$62,$61,$16,$27,$5D,$B2,$FC,$FD,$FF,$FF           ] , 'vminss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1317, [$62,$61,$FF,$2F,$10,$31                           ] , 'vmovsd  xmm30{k7},qword [rcx]'                    );
  TestCase.testcase(1318, [$62,$61,$FF,$AF,$10,$31                           ] , 'vmovsd  xmm30{k7}{z},qword [rcx]'                 );
  TestCase.testcase(1319, [$62,$21,$FF,$2F,$10,$B4,$F0,$23,$01,$00,$00       ] , 'vmovsd  xmm30{k7},qword [rax+r14*8+0x123]'        );
  TestCase.testcase(1320, [$62,$61,$FF,$2F,$10,$72,$7F                       ] , 'vmovsd  xmm30{k7},qword [rdx+0x3f8]'              );
  TestCase.testcase(1321, [$62,$61,$FF,$2F,$10,$B2,$00,$04,$00,$00           ] , 'vmovsd  xmm30{k7},qword [rdx+0x400]'              );
  TestCase.testcase(1322, [$62,$61,$FF,$2F,$10,$72,$80                       ] , 'vmovsd  xmm30{k7},qword [rdx-0x400]'              );
  TestCase.testcase(1323, [$62,$61,$FF,$2F,$10,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  xmm30{k7},qword [rdx-0x408]'              );
  TestCase.testcase(1324, [$62,$61,$FF,$2F,$11,$31                           ] , 'vmovsd  qword [rcx]{k7},xmm30'                    );
  TestCase.testcase(1325, [$62,$21,$FF,$2F,$11,$B4,$F0,$23,$01,$00,$00       ] , 'vmovsd  qword [rax+r14*8+0x123]{k7},xmm30'        );
  TestCase.testcase(1326, [$62,$61,$FF,$2F,$11,$72,$7F                       ] , 'vmovsd  qword [rdx+0x3f8]{k7},xmm30'              );
  TestCase.testcase(1327, [$62,$61,$FF,$2F,$11,$B2,$00,$04,$00,$00           ] , 'vmovsd  qword [rdx+0x400]{k7},xmm30'              );
  TestCase.testcase(1328, [$62,$61,$FF,$2F,$11,$72,$80                       ] , 'vmovsd  qword [rdx-0x400]{k7},xmm30'              );
  TestCase.testcase(1329, [$62,$61,$FF,$2F,$11,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  qword [rdx-0x408]{k7},xmm30'              );
  TestCase.testcase(1330, [$62,$01,$97,$27,$10,$F4                           ] , 'vmovsd  xmm30{k7},xmm29,ymm28'                    );
  TestCase.testcase(1331, [$62,$01,$97,$A7,$10,$F4                           ] , 'vmovsd  xmm30{k7}{z},xmm29,ymm28'                 );
  TestCase.testcase(1332, [$62,$61,$7E,$2F,$10,$31                           ] , 'vmovss  xmm30{k7},dword [rcx]'                    );
  TestCase.testcase(1333, [$62,$61,$7E,$AF,$10,$31                           ] , 'vmovss  xmm30{k7}{z},dword [rcx]'                 );
  TestCase.testcase(1334, [$62,$21,$7E,$2F,$10,$B4,$F0,$23,$01,$00,$00       ] , 'vmovss  xmm30{k7},dword [rax+r14*8+0x123]'        );
  TestCase.testcase(1335, [$62,$61,$7E,$2F,$10,$72,$7F                       ] , 'vmovss  xmm30{k7},dword [rdx+0x1fc]'              );
  TestCase.testcase(1336, [$62,$61,$7E,$2F,$10,$B2,$00,$02,$00,$00           ] , 'vmovss  xmm30{k7},dword [rdx+0x200]'              );
  TestCase.testcase(1337, [$62,$61,$7E,$2F,$10,$72,$80                       ] , 'vmovss  xmm30{k7},dword [rdx-0x200]'              );
  TestCase.testcase(1338, [$62,$61,$7E,$2F,$10,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  xmm30{k7},dword [rdx-0x204]'              );
  TestCase.testcase(1339, [$62,$61,$7E,$2F,$11,$31                           ] , 'vmovss  dword [rcx]{k7},xmm30'                    );
  TestCase.testcase(1340, [$62,$21,$7E,$2F,$11,$B4,$F0,$23,$01,$00,$00       ] , 'vmovss  dword [rax+r14*8+0x123]{k7},xmm30'        );
  TestCase.testcase(1341, [$62,$61,$7E,$2F,$11,$72,$7F                       ] , 'vmovss  dword [rdx+0x1fc]{k7},xmm30'              );
  TestCase.testcase(1342, [$62,$61,$7E,$2F,$11,$B2,$00,$02,$00,$00           ] , 'vmovss  dword [rdx+0x200]{k7},xmm30'              );
  TestCase.testcase(1343, [$62,$61,$7E,$2F,$11,$72,$80                       ] , 'vmovss  dword [rdx-0x200]{k7},xmm30'              );
  TestCase.testcase(1344, [$62,$61,$7E,$2F,$11,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  dword [rdx-0x204]{k7},xmm30'              );
  TestCase.testcase(1345, [$62,$01,$16,$27,$10,$F4                           ] , 'vmovss  xmm30{k7},xmm29,ymm28'                    );
  TestCase.testcase(1346, [$62,$01,$16,$A7,$10,$F4                           ] , 'vmovss  xmm30{k7}{z},xmm29,ymm28'                 );
  TestCase.testcase(1347, [$62,$01,$97,$27,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1348, [$62,$01,$97,$A7,$59,$F4                           ] , 'vmulsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1349, [$62,$01,$97,$17,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(1350, [$62,$01,$97,$57,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(1351, [$62,$01,$97,$37,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(1352, [$62,$01,$97,$77,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(1353, [$62,$61,$97,$27,$59,$31                           ] , 'vmulsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1354, [$62,$21,$97,$27,$59,$B4,$F0,$23,$01,$00,$00       ] , 'vmulsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1355, [$62,$61,$97,$27,$59,$72,$7F                       ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1356, [$62,$61,$97,$27,$59,$B2,$00,$04,$00,$00           ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1357, [$62,$61,$97,$27,$59,$72,$80                       ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1358, [$62,$61,$97,$27,$59,$B2,$F8,$FB,$FF,$FF           ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1359, [$62,$01,$16,$27,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1360, [$62,$01,$16,$A7,$59,$F4                           ] , 'vmulss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1361, [$62,$01,$16,$17,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(1362, [$62,$01,$16,$57,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(1363, [$62,$01,$16,$37,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(1364, [$62,$01,$16,$77,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(1365, [$62,$61,$16,$27,$59,$31                           ] , 'vmulss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1366, [$62,$21,$16,$27,$59,$B4,$F0,$23,$01,$00,$00       ] , 'vmulss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1367, [$62,$61,$16,$27,$59,$72,$7F                       ] , 'vmulss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1368, [$62,$61,$16,$27,$59,$B2,$00,$02,$00,$00           ] , 'vmulss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1369, [$62,$61,$16,$27,$59,$72,$80                       ] , 'vmulss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1370, [$62,$61,$16,$27,$59,$B2,$FC,$FD,$FF,$FF           ] , 'vmulss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1371, [$62,$02,$95,$27,$4D,$F4                           ] , 'vrcp14sd  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(1372, [$62,$02,$95,$A7,$4D,$F4                           ] , 'vrcp14sd  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(1373, [$62,$62,$95,$27,$4D,$31                           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1374, [$62,$22,$95,$27,$4D,$B4,$F0,$23,$01,$00,$00       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1375, [$62,$62,$95,$27,$4D,$72,$7F                       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1376, [$62,$62,$95,$27,$4D,$B2,$00,$04,$00,$00           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1377, [$62,$62,$95,$27,$4D,$72,$80                       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1378, [$62,$62,$95,$27,$4D,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1379, [$62,$02,$15,$27,$4D,$F4                           ] , 'vrcp14ss  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(1380, [$62,$02,$15,$A7,$4D,$F4                           ] , 'vrcp14ss  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(1381, [$62,$62,$15,$27,$4D,$31                           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(1382, [$62,$22,$15,$27,$4D,$B4,$F0,$23,$01,$00,$00       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1383, [$62,$62,$15,$27,$4D,$72,$7F                       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(1384, [$62,$62,$15,$27,$4D,$B2,$00,$02,$00,$00           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(1385, [$62,$62,$15,$27,$4D,$72,$80                       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(1386, [$62,$62,$15,$27,$4D,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(1387, [$62,$02,$15,$27,$CB,$F4                           ] , 'vrcp28ss  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(1388, [$62,$02,$15,$A7,$CB,$F4                           ] , 'vrcp28ss  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(1389, [$62,$02,$15,$17,$CB,$F4                           ] , 'vrcp28ss  xmm30{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1390, [$62,$62,$15,$27,$CB,$31                           ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(1391, [$62,$22,$15,$27,$CB,$B4,$F0,$23,$01,$00,$00       ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1392, [$62,$62,$15,$27,$CB,$72,$7F                       ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(1393, [$62,$62,$15,$27,$CB,$B2,$00,$02,$00,$00           ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(1394, [$62,$62,$15,$27,$CB,$72,$80                       ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(1395, [$62,$62,$15,$27,$CB,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(1396, [$62,$02,$95,$27,$CB,$F4                           ] , 'vrcp28sd  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(1397, [$62,$02,$95,$A7,$CB,$F4                           ] , 'vrcp28sd  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(1398, [$62,$02,$95,$17,$CB,$F4                           ] , 'vrcp28sd  xmm30{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1399, [$62,$62,$95,$27,$CB,$31                           ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1400, [$62,$22,$95,$27,$CB,$B4,$F0,$23,$01,$00,$00       ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1401, [$62,$62,$95,$27,$CB,$72,$7F                       ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1402, [$62,$62,$95,$27,$CB,$B2,$00,$04,$00,$00           ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1403, [$62,$62,$95,$27,$CB,$72,$80                       ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1404, [$62,$62,$95,$27,$CB,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1405, [$62,$02,$95,$27,$4F,$F4                           ] , 'vrsqrt14sd  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(1406, [$62,$02,$95,$A7,$4F,$F4                           ] , 'vrsqrt14sd  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(1407, [$62,$62,$95,$27,$4F,$31                           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rcx]'          );
  TestCase.testcase(1408, [$62,$22,$95,$27,$4F,$B4,$F0,$23,$01,$00,$00       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1409, [$62,$62,$95,$27,$4F,$72,$7F                       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'    );
  TestCase.testcase(1410, [$62,$62,$95,$27,$4F,$B2,$00,$04,$00,$00           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx+0x400]'    );
  TestCase.testcase(1411, [$62,$62,$95,$27,$4F,$72,$80                       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx-0x400]'    );
  TestCase.testcase(1412, [$62,$62,$95,$27,$4F,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx-0x408]'    );
  TestCase.testcase(1413, [$62,$02,$15,$27,$4F,$F4                           ] , 'vrsqrt14ss  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(1414, [$62,$02,$15,$A7,$4F,$F4                           ] , 'vrsqrt14ss  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(1415, [$62,$62,$15,$27,$4F,$31                           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rcx]'          );
  TestCase.testcase(1416, [$62,$22,$15,$27,$4F,$B4,$F0,$23,$01,$00,$00       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1417, [$62,$62,$15,$27,$4F,$72,$7F                       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'    );
  TestCase.testcase(1418, [$62,$62,$15,$27,$4F,$B2,$00,$02,$00,$00           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx+0x200]'    );
  TestCase.testcase(1419, [$62,$62,$15,$27,$4F,$72,$80                       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx-0x200]'    );
  TestCase.testcase(1420, [$62,$62,$15,$27,$4F,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx-0x204]'    );
  TestCase.testcase(1421, [$62,$02,$15,$27,$CD,$F4                           ] , 'vrsqrt28ss  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(1422, [$62,$02,$15,$A7,$CD,$F4                           ] , 'vrsqrt28ss  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(1423, [$62,$02,$15,$17,$CD,$F4                           ] , 'vrsqrt28ss  xmm30{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(1424, [$62,$62,$15,$27,$CD,$31                           ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rcx]'          );
  TestCase.testcase(1425, [$62,$22,$15,$27,$CD,$B4,$F0,$23,$01,$00,$00       ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1426, [$62,$62,$15,$27,$CD,$72,$7F                       ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'    );
  TestCase.testcase(1427, [$62,$62,$15,$27,$CD,$B2,$00,$02,$00,$00           ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rdx+0x200]'    );
  TestCase.testcase(1428, [$62,$62,$15,$27,$CD,$72,$80                       ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rdx-0x200]'    );
  TestCase.testcase(1429, [$62,$62,$15,$27,$CD,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rdx-0x204]'    );
  TestCase.testcase(1430, [$62,$02,$95,$27,$CD,$F4                           ] , 'vrsqrt28sd  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(1431, [$62,$02,$95,$A7,$CD,$F4                           ] , 'vrsqrt28sd  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(1432, [$62,$02,$95,$17,$CD,$F4                           ] , 'vrsqrt28sd  xmm30{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(1433, [$62,$62,$95,$27,$CD,$31                           ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rcx]'          );
  TestCase.testcase(1434, [$62,$22,$95,$27,$CD,$B4,$F0,$23,$01,$00,$00       ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1435, [$62,$62,$95,$27,$CD,$72,$7F                       ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'    );
  TestCase.testcase(1436, [$62,$62,$95,$27,$CD,$B2,$00,$04,$00,$00           ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rdx+0x400]'    );
  TestCase.testcase(1437, [$62,$62,$95,$27,$CD,$72,$80                       ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rdx-0x400]'    );
  TestCase.testcase(1438, [$62,$62,$95,$27,$CD,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rdx-0x408]'    );
  TestCase.testcase(1439, [$62,$01,$97,$27,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28'                   );
  TestCase.testcase(1440, [$62,$01,$97,$A7,$51,$F4                           ] , 'vsqrtsd  xmm30{k7}{z},xmm29,xmm28'                );
  TestCase.testcase(1441, [$62,$01,$97,$17,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rn-sae}'          );
  TestCase.testcase(1442, [$62,$01,$97,$57,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{ru-sae}'          );
  TestCase.testcase(1443, [$62,$01,$97,$37,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rd-sae}'          );
  TestCase.testcase(1444, [$62,$01,$97,$77,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rz-sae}'          );
  TestCase.testcase(1445, [$62,$61,$97,$27,$51,$31                           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rcx]'             );
  TestCase.testcase(1446, [$62,$21,$97,$27,$51,$B4,$F0,$23,$01,$00,$00       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1447, [$62,$61,$97,$27,$51,$72,$7F                       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'       );
  TestCase.testcase(1448, [$62,$61,$97,$27,$51,$B2,$00,$04,$00,$00           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx+0x400]'       );
  TestCase.testcase(1449, [$62,$61,$97,$27,$51,$72,$80                       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx-0x400]'       );
  TestCase.testcase(1450, [$62,$61,$97,$27,$51,$B2,$F8,$FB,$FF,$FF           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx-0x408]'       );
  TestCase.testcase(1451, [$62,$01,$16,$27,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28'                   );
  TestCase.testcase(1452, [$62,$01,$16,$A7,$51,$F4                           ] , 'vsqrtss  xmm30{k7}{z},xmm29,xmm28'                );
  TestCase.testcase(1453, [$62,$01,$16,$17,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rn-sae}'          );
  TestCase.testcase(1454, [$62,$01,$16,$57,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{ru-sae}'          );
  TestCase.testcase(1455, [$62,$01,$16,$37,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rd-sae}'          );
  TestCase.testcase(1456, [$62,$01,$16,$77,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rz-sae}'          );
  TestCase.testcase(1457, [$62,$61,$16,$27,$51,$31                           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rcx]'             );
  TestCase.testcase(1458, [$62,$21,$16,$27,$51,$B4,$F0,$23,$01,$00,$00       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1459, [$62,$61,$16,$27,$51,$72,$7F                       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx+0x1fc]'       );
  TestCase.testcase(1460, [$62,$61,$16,$27,$51,$B2,$00,$02,$00,$00           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx+0x200]'       );
  TestCase.testcase(1461, [$62,$61,$16,$27,$51,$72,$80                       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx-0x200]'       );
  TestCase.testcase(1462, [$62,$61,$16,$27,$51,$B2,$FC,$FD,$FF,$FF           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx-0x204]'       );
  TestCase.testcase(1463, [$62,$01,$97,$27,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1464, [$62,$01,$97,$A7,$5C,$F4                           ] , 'vsubsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1465, [$62,$01,$97,$17,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(1466, [$62,$01,$97,$57,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(1467, [$62,$01,$97,$37,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(1468, [$62,$01,$97,$77,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(1469, [$62,$61,$97,$27,$5C,$31                           ] , 'vsubsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1470, [$62,$21,$97,$27,$5C,$B4,$F0,$23,$01,$00,$00       ] , 'vsubsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1471, [$62,$61,$97,$27,$5C,$72,$7F                       ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1472, [$62,$61,$97,$27,$5C,$B2,$00,$04,$00,$00           ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1473, [$62,$61,$97,$27,$5C,$72,$80                       ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1474, [$62,$61,$97,$27,$5C,$B2,$F8,$FB,$FF,$FF           ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1475, [$62,$01,$16,$27,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1476, [$62,$01,$16,$A7,$5C,$F4                           ] , 'vsubss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1477, [$62,$01,$16,$17,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(1478, [$62,$01,$16,$57,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(1479, [$62,$01,$16,$37,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(1480, [$62,$01,$16,$77,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(1481, [$62,$61,$16,$27,$5C,$31                           ] , 'vsubss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1482, [$62,$21,$16,$27,$5C,$B4,$F0,$23,$01,$00,$00       ] , 'vsubss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1483, [$62,$61,$16,$27,$5C,$72,$7F                       ] , 'vsubss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1484, [$62,$61,$16,$27,$5C,$B2,$00,$02,$00,$00           ] , 'vsubss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1485, [$62,$61,$16,$27,$5C,$72,$80                       ] , 'vsubss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1486, [$62,$61,$16,$27,$5C,$B2,$FC,$FD,$FF,$FF           ] , 'vsubss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1487, [$62,$01,$FD,$28,$2E,$F5                           ] , 'vucomisd  xmm30,xmm29'                            );
  TestCase.testcase(1488, [$62,$01,$FD,$18,$2E,$F5                           ] , 'vucomisd  xmm30,xmm29,{sae}'                      );
  TestCase.testcase(1489, [$62,$61,$FD,$28,$2E,$31                           ] , 'vucomisd  xmm30,qword [rcx]'                      );
  TestCase.testcase(1490, [$62,$21,$FD,$28,$2E,$B4,$F0,$23,$01,$00,$00       ] , 'vucomisd  xmm30,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(1491, [$62,$61,$FD,$28,$2E,$72,$7F                       ] , 'vucomisd  xmm30,qword [rdx+0x3f8]'                );
  TestCase.testcase(1492, [$62,$61,$FD,$28,$2E,$B2,$00,$04,$00,$00           ] , 'vucomisd  xmm30,qword [rdx+0x400]'                );
  TestCase.testcase(1493, [$62,$61,$FD,$28,$2E,$72,$80                       ] , 'vucomisd  xmm30,qword [rdx-0x400]'                );
  TestCase.testcase(1494, [$62,$61,$FD,$28,$2E,$B2,$F8,$FB,$FF,$FF           ] , 'vucomisd  xmm30,qword [rdx-0x408]'                );
  TestCase.testcase(1495, [$62,$01,$7C,$28,$2E,$F5                           ] , 'vucomiss  xmm30,xmm29'                            );
  TestCase.testcase(1496, [$62,$01,$7C,$18,$2E,$F5                           ] , 'vucomiss  xmm30,xmm29,{sae}'                      );
  TestCase.testcase(1497, [$62,$61,$7C,$28,$2E,$31                           ] , 'vucomiss  xmm30,dword [rcx]'                      );
  TestCase.testcase(1498, [$62,$21,$7C,$28,$2E,$B4,$F0,$23,$01,$00,$00       ] , 'vucomiss  xmm30,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(1499, [$62,$61,$7C,$28,$2E,$72,$7F                       ] , 'vucomiss  xmm30,dword [rdx+0x1fc]'                );
  TestCase.testcase(1500, [$62,$61,$7C,$28,$2E,$B2,$00,$02,$00,$00           ] , 'vucomiss  xmm30,dword [rdx+0x200]'                );
  TestCase.testcase(1501, [$62,$61,$7C,$28,$2E,$72,$80                       ] , 'vucomiss  xmm30,dword [rdx-0x200]'                );
  TestCase.testcase(1502, [$62,$61,$7C,$28,$2E,$B2,$FC,$FD,$FF,$FF           ] , 'vucomiss  xmm30,dword [rdx-0x204]'                );
  TestCase.testcase(1503, [$62,$91,$7F,$28,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30'                            );
  TestCase.testcase(1504, [$62,$91,$7F,$18,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rn-sae}'                   );
  TestCase.testcase(1505, [$62,$91,$7F,$58,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{ru-sae}'                   );
  TestCase.testcase(1506, [$62,$91,$7F,$38,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rd-sae}'                   );
  TestCase.testcase(1507, [$62,$91,$7F,$78,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rz-sae}'                   );
  TestCase.testcase(1508, [$62,$F1,$7F,$28,$79,$01                           ] , 'vcvtsd2usi  eax,qword [rcx]'                      );
  TestCase.testcase(1509, [$62,$B1,$7F,$28,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  eax,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(1510, [$62,$F1,$7F,$28,$79,$42,$7F                       ] , 'vcvtsd2usi  eax,qword [rdx+0x3f8]'                );
  TestCase.testcase(1511, [$62,$F1,$7F,$28,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  eax,qword [rdx+0x400]'                );
  TestCase.testcase(1512, [$62,$F1,$7F,$28,$79,$42,$80                       ] , 'vcvtsd2usi  eax,qword [rdx-0x400]'                );
  TestCase.testcase(1513, [$62,$F1,$7F,$28,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  eax,qword [rdx-0x408]'                );
  TestCase.testcase(1514, [$62,$91,$7F,$28,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30'                            );
  TestCase.testcase(1515, [$62,$91,$7F,$18,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rn-sae}'                   );
  TestCase.testcase(1516, [$62,$91,$7F,$58,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{ru-sae}'                   );
  TestCase.testcase(1517, [$62,$91,$7F,$38,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rd-sae}'                   );
  TestCase.testcase(1518, [$62,$91,$7F,$78,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rz-sae}'                   );
  TestCase.testcase(1519, [$62,$F1,$7F,$28,$79,$29                           ] , 'vcvtsd2usi  ebp,qword [rcx]'                      );
  TestCase.testcase(1520, [$62,$B1,$7F,$28,$79,$AC,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  ebp,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(1521, [$62,$F1,$7F,$28,$79,$6A,$7F                       ] , 'vcvtsd2usi  ebp,qword [rdx+0x3f8]'                );
  TestCase.testcase(1522, [$62,$F1,$7F,$28,$79,$AA,$00,$04,$00,$00           ] , 'vcvtsd2usi  ebp,qword [rdx+0x400]'                );
  TestCase.testcase(1523, [$62,$F1,$7F,$28,$79,$6A,$80                       ] , 'vcvtsd2usi  ebp,qword [rdx-0x400]'                );
  TestCase.testcase(1524, [$62,$F1,$7F,$28,$79,$AA,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  ebp,qword [rdx-0x408]'                );
  TestCase.testcase(1525, [$62,$11,$7F,$28,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30'                           );
  TestCase.testcase(1526, [$62,$11,$7F,$18,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rn-sae}'                  );
  TestCase.testcase(1527, [$62,$11,$7F,$58,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{ru-sae}'                  );
  TestCase.testcase(1528, [$62,$11,$7F,$38,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rd-sae}'                  );
  TestCase.testcase(1529, [$62,$11,$7F,$78,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rz-sae}'                  );
  TestCase.testcase(1530, [$62,$71,$7F,$28,$79,$29                           ] , 'vcvtsd2usi  r13d,qword [rcx]'                     );
  TestCase.testcase(1531, [$62,$31,$7F,$28,$79,$AC,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  r13d,qword [rax+r14*8+0x123]'         );
  TestCase.testcase(1532, [$62,$71,$7F,$28,$79,$6A,$7F                       ] , 'vcvtsd2usi  r13d,qword [rdx+0x3f8]'               );
  TestCase.testcase(1533, [$62,$71,$7F,$28,$79,$AA,$00,$04,$00,$00           ] , 'vcvtsd2usi  r13d,qword [rdx+0x400]'               );
  TestCase.testcase(1534, [$62,$71,$7F,$28,$79,$6A,$80                       ] , 'vcvtsd2usi  r13d,qword [rdx-0x400]'               );
  TestCase.testcase(1535, [$62,$71,$7F,$28,$79,$AA,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  r13d,qword [rdx-0x408]'               );
  TestCase.testcase(1536, [$62,$91,$FF,$28,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30'                            );
  TestCase.testcase(1537, [$62,$91,$FF,$18,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rn-sae}'                   );
  TestCase.testcase(1538, [$62,$91,$FF,$58,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{ru-sae}'                   );
  TestCase.testcase(1539, [$62,$91,$FF,$38,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rd-sae}'                   );
  TestCase.testcase(1540, [$62,$91,$FF,$78,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rz-sae}'                   );
  TestCase.testcase(1541, [$62,$F1,$FF,$28,$79,$01                           ] , 'vcvtsd2usi  rax,qword [rcx]'                      );
  TestCase.testcase(1542, [$62,$B1,$FF,$28,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  rax,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(1543, [$62,$F1,$FF,$28,$79,$42,$7F                       ] , 'vcvtsd2usi  rax,qword [rdx+0x3f8]'                );
  TestCase.testcase(1544, [$62,$F1,$FF,$28,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  rax,qword [rdx+0x400]'                );
  TestCase.testcase(1545, [$62,$F1,$FF,$28,$79,$42,$80                       ] , 'vcvtsd2usi  rax,qword [rdx-0x400]'                );
  TestCase.testcase(1546, [$62,$F1,$FF,$28,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  rax,qword [rdx-0x408]'                );
  TestCase.testcase(1547, [$62,$11,$FF,$28,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30'                             );
  TestCase.testcase(1548, [$62,$11,$FF,$18,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rn-sae}'                    );
  TestCase.testcase(1549, [$62,$11,$FF,$58,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{ru-sae}'                    );
  TestCase.testcase(1550, [$62,$11,$FF,$38,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rd-sae}'                    );
  TestCase.testcase(1551, [$62,$11,$FF,$78,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rz-sae}'                    );
  TestCase.testcase(1552, [$62,$71,$FF,$28,$79,$01                           ] , 'vcvtsd2usi  r8,qword [rcx]'                       );
  TestCase.testcase(1553, [$62,$31,$FF,$28,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  r8,qword [rax+r14*8+0x123]'           );
  TestCase.testcase(1554, [$62,$71,$FF,$28,$79,$42,$7F                       ] , 'vcvtsd2usi  r8,qword [rdx+0x3f8]'                 );
  TestCase.testcase(1555, [$62,$71,$FF,$28,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  r8,qword [rdx+0x400]'                 );
  TestCase.testcase(1556, [$62,$71,$FF,$28,$79,$42,$80                       ] , 'vcvtsd2usi  r8,qword [rdx-0x400]'                 );
  TestCase.testcase(1557, [$62,$71,$FF,$28,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  r8,qword [rdx-0x408]'                 );
  TestCase.testcase(1558, [$62,$91,$7E,$28,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30'                            );
  TestCase.testcase(1559, [$62,$91,$7E,$18,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rn-sae}'                   );
  TestCase.testcase(1560, [$62,$91,$7E,$58,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{ru-sae}'                   );
  TestCase.testcase(1561, [$62,$91,$7E,$38,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rd-sae}'                   );
  TestCase.testcase(1562, [$62,$91,$7E,$78,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rz-sae}'                   );
  TestCase.testcase(1563, [$62,$F1,$7E,$28,$79,$01                           ] , 'vcvtss2usi  eax,dword [rcx]'                      );
  TestCase.testcase(1564, [$62,$B1,$7E,$28,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  eax,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(1565, [$62,$F1,$7E,$28,$79,$42,$7F                       ] , 'vcvtss2usi  eax,dword [rdx+0x1fc]'                );
  TestCase.testcase(1566, [$62,$F1,$7E,$28,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  eax,dword [rdx+0x200]'                );
  TestCase.testcase(1567, [$62,$F1,$7E,$28,$79,$42,$80                       ] , 'vcvtss2usi  eax,dword [rdx-0x200]'                );
  TestCase.testcase(1568, [$62,$F1,$7E,$28,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  eax,dword [rdx-0x204]'                );
  TestCase.testcase(1569, [$62,$91,$7E,$28,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30'                            );
  TestCase.testcase(1570, [$62,$91,$7E,$18,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rn-sae}'                   );
  TestCase.testcase(1571, [$62,$91,$7E,$58,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{ru-sae}'                   );
  TestCase.testcase(1572, [$62,$91,$7E,$38,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rd-sae}'                   );
  TestCase.testcase(1573, [$62,$91,$7E,$78,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rz-sae}'                   );
  TestCase.testcase(1574, [$62,$F1,$7E,$28,$79,$29                           ] , 'vcvtss2usi  ebp,dword [rcx]'                      );
  TestCase.testcase(1575, [$62,$B1,$7E,$28,$79,$AC,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  ebp,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(1576, [$62,$F1,$7E,$28,$79,$6A,$7F                       ] , 'vcvtss2usi  ebp,dword [rdx+0x1fc]'                );
  TestCase.testcase(1577, [$62,$F1,$7E,$28,$79,$AA,$00,$02,$00,$00           ] , 'vcvtss2usi  ebp,dword [rdx+0x200]'                );
  TestCase.testcase(1578, [$62,$F1,$7E,$28,$79,$6A,$80                       ] , 'vcvtss2usi  ebp,dword [rdx-0x200]'                );
  TestCase.testcase(1579, [$62,$F1,$7E,$28,$79,$AA,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  ebp,dword [rdx-0x204]'                );
  TestCase.testcase(1580, [$62,$11,$7E,$28,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30'                           );
  TestCase.testcase(1581, [$62,$11,$7E,$18,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rn-sae}'                  );
  TestCase.testcase(1582, [$62,$11,$7E,$58,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{ru-sae}'                  );
  TestCase.testcase(1583, [$62,$11,$7E,$38,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rd-sae}'                  );
  TestCase.testcase(1584, [$62,$11,$7E,$78,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rz-sae}'                  );
  TestCase.testcase(1585, [$62,$71,$7E,$28,$79,$29                           ] , 'vcvtss2usi  r13d,dword [rcx]'                     );
  TestCase.testcase(1586, [$62,$31,$7E,$28,$79,$AC,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  r13d,dword [rax+r14*8+0x123]'         );
  TestCase.testcase(1587, [$62,$71,$7E,$28,$79,$6A,$7F                       ] , 'vcvtss2usi  r13d,dword [rdx+0x1fc]'               );
  TestCase.testcase(1588, [$62,$71,$7E,$28,$79,$AA,$00,$02,$00,$00           ] , 'vcvtss2usi  r13d,dword [rdx+0x200]'               );
  TestCase.testcase(1589, [$62,$71,$7E,$28,$79,$6A,$80                       ] , 'vcvtss2usi  r13d,dword [rdx-0x200]'               );
  TestCase.testcase(1590, [$62,$71,$7E,$28,$79,$AA,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  r13d,dword [rdx-0x204]'               );
  TestCase.testcase(1591, [$62,$91,$FE,$28,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30'                            );
  TestCase.testcase(1592, [$62,$91,$FE,$18,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rn-sae}'                   );
  TestCase.testcase(1593, [$62,$91,$FE,$58,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{ru-sae}'                   );
  TestCase.testcase(1594, [$62,$91,$FE,$38,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rd-sae}'                   );
  TestCase.testcase(1595, [$62,$91,$FE,$78,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rz-sae}'                   );
  TestCase.testcase(1596, [$62,$F1,$FE,$28,$79,$01                           ] , 'vcvtss2usi  rax,dword [rcx]'                      );
  TestCase.testcase(1597, [$62,$B1,$FE,$28,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  rax,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(1598, [$62,$F1,$FE,$28,$79,$42,$7F                       ] , 'vcvtss2usi  rax,dword [rdx+0x1fc]'                );
  TestCase.testcase(1599, [$62,$F1,$FE,$28,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  rax,dword [rdx+0x200]'                );
  TestCase.testcase(1600, [$62,$F1,$FE,$28,$79,$42,$80                       ] , 'vcvtss2usi  rax,dword [rdx-0x200]'                );
  TestCase.testcase(1601, [$62,$F1,$FE,$28,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  rax,dword [rdx-0x204]'                );
  TestCase.testcase(1602, [$62,$11,$FE,$28,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30'                             );
  TestCase.testcase(1603, [$62,$11,$FE,$18,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rn-sae}'                    );
  TestCase.testcase(1604, [$62,$11,$FE,$58,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{ru-sae}'                    );
  TestCase.testcase(1605, [$62,$11,$FE,$38,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rd-sae}'                    );
  TestCase.testcase(1606, [$62,$11,$FE,$78,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rz-sae}'                    );
  TestCase.testcase(1607, [$62,$71,$FE,$28,$79,$01                           ] , 'vcvtss2usi  r8,dword [rcx]'                       );
  TestCase.testcase(1608, [$62,$31,$FE,$28,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  r8,dword [rax+r14*8+0x123]'           );
  TestCase.testcase(1609, [$62,$71,$FE,$28,$79,$42,$7F                       ] , 'vcvtss2usi  r8,dword [rdx+0x1fc]'                 );
  TestCase.testcase(1610, [$62,$71,$FE,$28,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  r8,dword [rdx+0x200]'                 );
  TestCase.testcase(1611, [$62,$71,$FE,$28,$79,$42,$80                       ] , 'vcvtss2usi  r8,dword [rdx-0x200]'                 );
  TestCase.testcase(1612, [$62,$71,$FE,$28,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  r8,dword [rdx-0x204]'                 );
  TestCase.testcase(1613, [$62,$61,$17,$20,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,eax'                      );
  TestCase.testcase(1614, [$62,$61,$17,$20,$7B,$F5                           ] , 'vcvtusi2sd  xmm30,xmm29,ebp'                      );
  TestCase.testcase(1615, [$62,$41,$17,$20,$7B,$F5                           ] , 'vcvtusi2sd  xmm30,xmm29,r13d'                     );
  TestCase.testcase(1616, [$62,$61,$17,$20,$7B,$31                           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rcx]'              );
  TestCase.testcase(1617, [$62,$21,$17,$20,$7B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1618, [$62,$61,$17,$20,$7B,$72,$7F                       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1619, [$62,$61,$17,$20,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1620, [$62,$61,$17,$20,$7B,$72,$80                       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1621, [$62,$61,$17,$20,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1622, [$62,$61,$97,$20,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,rax'                      );
  TestCase.testcase(1623, [$62,$61,$97,$10,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rn-sae},rax'             );
  TestCase.testcase(1624, [$62,$61,$97,$50,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{ru-sae},rax'             );
  TestCase.testcase(1625, [$62,$61,$97,$30,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rd-sae},rax'             );
  TestCase.testcase(1626, [$62,$61,$97,$70,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rz-sae},rax'             );
  TestCase.testcase(1627, [$62,$41,$97,$20,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,r8'                       );
  TestCase.testcase(1628, [$62,$41,$97,$10,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rn-sae},r8'              );
  TestCase.testcase(1629, [$62,$41,$97,$50,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{ru-sae},r8'              );
  TestCase.testcase(1630, [$62,$41,$97,$30,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rd-sae},r8'              );
  TestCase.testcase(1631, [$62,$41,$97,$70,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rz-sae},r8'              );
  TestCase.testcase(1632, [$62,$61,$97,$20,$7B,$31                           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rcx]'              );
  TestCase.testcase(1633, [$62,$21,$97,$20,$7B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1634, [$62,$61,$97,$20,$7B,$72,$7F                       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1635, [$62,$61,$97,$20,$7B,$B2,$00,$04,$00,$00           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1636, [$62,$61,$97,$20,$7B,$72,$80                       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1637, [$62,$61,$97,$20,$7B,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1638, [$62,$61,$16,$20,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,eax'                      );
  TestCase.testcase(1639, [$62,$61,$16,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},eax'             );
  TestCase.testcase(1640, [$62,$61,$16,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},eax'             );
  TestCase.testcase(1641, [$62,$61,$16,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},eax'             );
  TestCase.testcase(1642, [$62,$61,$16,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},eax'             );
  TestCase.testcase(1643, [$62,$61,$16,$20,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,ebp'                      );
  TestCase.testcase(1644, [$62,$61,$16,$10,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},ebp'             );
  TestCase.testcase(1645, [$62,$61,$16,$50,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},ebp'             );
  TestCase.testcase(1646, [$62,$61,$16,$30,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},ebp'             );
  TestCase.testcase(1647, [$62,$61,$16,$70,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},ebp'             );
  TestCase.testcase(1648, [$62,$41,$16,$20,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,r13d'                     );
  TestCase.testcase(1649, [$62,$41,$16,$10,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},r13d'            );
  TestCase.testcase(1650, [$62,$41,$16,$50,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},r13d'            );
  TestCase.testcase(1651, [$62,$41,$16,$30,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},r13d'            );
  TestCase.testcase(1652, [$62,$41,$16,$70,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},r13d'            );
  TestCase.testcase(1653, [$62,$61,$16,$20,$7B,$31                           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rcx]'              );
  TestCase.testcase(1654, [$62,$21,$16,$20,$7B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1655, [$62,$61,$16,$20,$7B,$72,$7F                       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1656, [$62,$61,$16,$20,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1657, [$62,$61,$16,$20,$7B,$72,$80                       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1658, [$62,$61,$16,$20,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1659, [$62,$61,$96,$20,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,rax'                      );
  TestCase.testcase(1660, [$62,$61,$96,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},rax'             );
  TestCase.testcase(1661, [$62,$61,$96,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},rax'             );
  TestCase.testcase(1662, [$62,$61,$96,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},rax'             );
  TestCase.testcase(1663, [$62,$61,$96,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},rax'             );
  TestCase.testcase(1664, [$62,$41,$96,$20,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,r8'                       );
  TestCase.testcase(1665, [$62,$41,$96,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},r8'              );
  TestCase.testcase(1666, [$62,$41,$96,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},r8'              );
  TestCase.testcase(1667, [$62,$41,$96,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},r8'              );
  TestCase.testcase(1668, [$62,$41,$96,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},r8'              );
  TestCase.testcase(1669, [$62,$61,$96,$20,$7B,$31                           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rcx]'              );
  TestCase.testcase(1670, [$62,$21,$96,$20,$7B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1671, [$62,$61,$96,$20,$7B,$72,$7F                       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1672, [$62,$61,$96,$20,$7B,$B2,$00,$04,$00,$00           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1673, [$62,$61,$96,$20,$7B,$72,$80                       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1674, [$62,$61,$96,$20,$7B,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1675, [$62,$02,$95,$27,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(1676, [$62,$02,$95,$A7,$2D,$F4                           ] , 'vscalefsd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(1677, [$62,$02,$95,$17,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(1678, [$62,$02,$95,$57,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(1679, [$62,$02,$95,$37,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(1680, [$62,$02,$95,$77,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(1681, [$62,$62,$95,$27,$2D,$31                           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1682, [$62,$22,$95,$27,$2D,$B4,$F0,$23,$01,$00,$00       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1683, [$62,$62,$95,$27,$2D,$72,$7F                       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1684, [$62,$62,$95,$27,$2D,$B2,$00,$04,$00,$00           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1685, [$62,$62,$95,$27,$2D,$72,$80                       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1686, [$62,$62,$95,$27,$2D,$B2,$F8,$FB,$FF,$FF           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1687, [$62,$02,$15,$27,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(1688, [$62,$02,$15,$A7,$2D,$F4                           ] , 'vscalefss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(1689, [$62,$02,$15,$17,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(1690, [$62,$02,$15,$57,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(1691, [$62,$02,$15,$37,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(1692, [$62,$02,$15,$77,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(1693, [$62,$62,$15,$27,$2D,$31                           ] , 'vscalefss  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(1694, [$62,$22,$15,$27,$2D,$B4,$F0,$23,$01,$00,$00       ] , 'vscalefss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1695, [$62,$62,$15,$27,$2D,$72,$7F                       ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(1696, [$62,$62,$15,$27,$2D,$B2,$00,$02,$00,$00           ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(1697, [$62,$62,$15,$27,$2D,$72,$80                       ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(1698, [$62,$62,$15,$27,$2D,$B2,$FC,$FD,$FF,$FF           ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(1699, [$62,$03,$15,$27,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(1700, [$62,$03,$15,$A7,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(1701, [$62,$03,$15,$17,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(1702, [$62,$03,$15,$27,$55,$F4,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(1703, [$62,$03,$15,$17,$55,$F4,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(1704, [$62,$63,$15,$27,$55,$31,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rcx],0x7b'    );
  TestCase.testcase(1705, [$62,$23,$15,$27,$55,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(1706, [$62,$63,$15,$27,$55,$72,$7F,$7B                   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(1707, [$62,$63,$15,$27,$55,$B2,$00,$02,$00,$00,$7B       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(1708, [$62,$63,$15,$27,$55,$72,$80,$7B                   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(1709, [$62,$63,$15,$27,$55,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.testcase(1710, [$62,$03,$95,$27,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(1711, [$62,$03,$95,$A7,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(1712, [$62,$03,$95,$17,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(1713, [$62,$03,$95,$27,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(1714, [$62,$03,$95,$17,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(1715, [$62,$63,$95,$27,$55,$31,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rcx],0x7b'    );
  TestCase.testcase(1716, [$62,$23,$95,$27,$55,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(1717, [$62,$63,$95,$27,$55,$72,$7F,$7B                   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(1718, [$62,$63,$95,$27,$55,$B2,$00,$04,$00,$00,$7B       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(1719, [$62,$63,$95,$27,$55,$72,$80,$7B                   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(1720, [$62,$63,$95,$27,$55,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(1721, [$62,$03,$95,$27,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(1722, [$62,$03,$95,$A7,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(1723, [$62,$03,$95,$17,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(1724, [$62,$03,$95,$27,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(1725, [$62,$03,$95,$17,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(1726, [$62,$63,$95,$27,$0B,$31,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rcx],0x7b'    );
  TestCase.testcase(1727, [$62,$23,$95,$27,$0B,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(1728, [$62,$63,$95,$27,$0B,$72,$7F,$7B                   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(1729, [$62,$63,$95,$27,$0B,$B2,$00,$04,$00,$00,$7B       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(1730, [$62,$63,$95,$27,$0B,$72,$80,$7B                   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(1731, [$62,$63,$95,$27,$0B,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(1732, [$62,$03,$15,$27,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(1733, [$62,$03,$15,$A7,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(1734, [$62,$03,$15,$17,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(1735, [$62,$03,$15,$27,$0A,$F4,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(1736, [$62,$03,$15,$17,$0A,$F4,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(1737, [$62,$63,$15,$27,$0A,$31,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rcx],0x7b'    );
  TestCase.testcase(1738, [$62,$23,$15,$27,$0A,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(1739, [$62,$63,$15,$27,$0A,$72,$7F,$7B                   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(1740, [$62,$63,$15,$27,$0A,$B2,$00,$02,$00,$00,$7B       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(1741, [$62,$63,$15,$27,$0A,$72,$80,$7B                   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(1742, [$62,$63,$15,$27,$0A,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.testcase(1743, [$62,$01,$97,$27,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1744, [$62,$01,$97,$A7,$58,$F4                           ] , 'vaddsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1745, [$62,$01,$97,$17,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(1746, [$62,$01,$97,$57,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(1747, [$62,$01,$97,$37,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(1748, [$62,$01,$97,$77,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(1749, [$62,$61,$97,$27,$58,$31                           ] , 'vaddsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1750, [$62,$21,$97,$27,$58,$B4,$F0,$34,$12,$00,$00       ] , 'vaddsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1751, [$62,$61,$97,$27,$58,$72,$7F                       ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1752, [$62,$61,$97,$27,$58,$B2,$00,$04,$00,$00           ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1753, [$62,$61,$97,$27,$58,$72,$80                       ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1754, [$62,$61,$97,$27,$58,$B2,$F8,$FB,$FF,$FF           ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1755, [$62,$01,$16,$27,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(1756, [$62,$01,$16,$A7,$58,$F4                           ] , 'vaddss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(1757, [$62,$01,$16,$17,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(1758, [$62,$01,$16,$57,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(1759, [$62,$01,$16,$37,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(1760, [$62,$01,$16,$77,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(1761, [$62,$61,$16,$27,$58,$31                           ] , 'vaddss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1762, [$62,$21,$16,$27,$58,$B4,$F0,$34,$12,$00,$00       ] , 'vaddss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(1763, [$62,$61,$16,$27,$58,$72,$7F                       ] , 'vaddss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1764, [$62,$61,$16,$27,$58,$B2,$00,$02,$00,$00           ] , 'vaddss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1765, [$62,$61,$16,$27,$58,$72,$80                       ] , 'vaddss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1766, [$62,$61,$16,$27,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vaddss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1767, [$62,$91,$97,$27,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,0xab'                  );
  TestCase.testcase(1768, [$62,$91,$97,$17,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,{sae},0xab'            );
  TestCase.testcase(1769, [$62,$91,$97,$27,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,0x7b'                  );
  TestCase.testcase(1770, [$62,$91,$97,$17,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,{sae},0x7b'            );
  TestCase.testcase(1771, [$62,$F1,$97,$27,$C2,$29,$7B                       ] , 'vcmpsd  k5{k7},xmm29,qword [rcx],0x7b'            );
  TestCase.testcase(1772, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$7B   ] , 'vcmpsd  k5{k7},xmm29,qword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(1773, [$62,$F1,$97,$27,$C2,$6A,$7F,$7B                   ] , 'vcmpsd  k5{k7},xmm29,qword [rdx+0x3f8],0x7b'      );
  TestCase.testcase(1774, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$7B       ] , 'vcmpsd  k5{k7},xmm29,qword [rdx+0x400],0x7b'      );
  TestCase.testcase(1775, [$62,$F1,$97,$27,$C2,$6A,$80,$7B                   ] , 'vcmpsd  k5{k7},xmm29,qword [rdx-0x400],0x7b'      );
  TestCase.testcase(1776, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vcmpsd  k5{k7},xmm29,qword [rdx-0x408],0x7b'      );
  TestCase.testcase(1777, [$62,$91,$97,$27,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1778, [$62,$91,$97,$17,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1779, [$62,$F1,$97,$27,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1780, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$00   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1781, [$62,$F1,$97,$27,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1782, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1783, [$62,$F1,$97,$27,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1784, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1785, [$62,$91,$97,$27,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1786, [$62,$91,$97,$17,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1787, [$62,$F1,$97,$27,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1788, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$00   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1789, [$62,$F1,$97,$27,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1790, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1791, [$62,$F1,$97,$27,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1792, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1793, [$62,$91,$97,$27,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1794, [$62,$91,$97,$17,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1795, [$62,$F1,$97,$27,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1796, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$01   ] , 'vcmpltsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1797, [$62,$F1,$97,$27,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1798, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1799, [$62,$F1,$97,$27,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1800, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1801, [$62,$91,$97,$27,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1802, [$62,$91,$97,$17,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1803, [$62,$F1,$97,$27,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1804, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$01   ] , 'vcmpltsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1805, [$62,$F1,$97,$27,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1806, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1807, [$62,$F1,$97,$27,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1808, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1809, [$62,$91,$97,$27,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1810, [$62,$91,$97,$17,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1811, [$62,$F1,$97,$27,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1812, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$02   ] , 'vcmplesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1813, [$62,$F1,$97,$27,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1814, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1815, [$62,$F1,$97,$27,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1816, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1817, [$62,$91,$97,$27,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1818, [$62,$91,$97,$17,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1819, [$62,$F1,$97,$27,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1820, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$02   ] , 'vcmplesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1821, [$62,$F1,$97,$27,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1822, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1823, [$62,$F1,$97,$27,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1824, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1825, [$62,$91,$97,$27,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1826, [$62,$91,$97,$17,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1827, [$62,$F1,$97,$27,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1828, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$03   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1829, [$62,$F1,$97,$27,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1830, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1831, [$62,$F1,$97,$27,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1832, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1833, [$62,$91,$97,$27,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1834, [$62,$91,$97,$17,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1835, [$62,$F1,$97,$27,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1836, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$03   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1837, [$62,$F1,$97,$27,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1838, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1839, [$62,$F1,$97,$27,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1840, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1841, [$62,$91,$97,$27,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1842, [$62,$91,$97,$17,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1843, [$62,$F1,$97,$27,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1844, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$04   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1845, [$62,$F1,$97,$27,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1846, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1847, [$62,$F1,$97,$27,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1848, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1849, [$62,$91,$97,$27,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1850, [$62,$91,$97,$17,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1851, [$62,$F1,$97,$27,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1852, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$04   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1853, [$62,$F1,$97,$27,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1854, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1855, [$62,$F1,$97,$27,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1856, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1857, [$62,$91,$97,$27,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1858, [$62,$91,$97,$17,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1859, [$62,$F1,$97,$27,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1860, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$05   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1861, [$62,$F1,$97,$27,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1862, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1863, [$62,$F1,$97,$27,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1864, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1865, [$62,$91,$97,$27,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1866, [$62,$91,$97,$17,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1867, [$62,$F1,$97,$27,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1868, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$05   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1869, [$62,$F1,$97,$27,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1870, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1871, [$62,$F1,$97,$27,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1872, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1873, [$62,$91,$97,$27,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1874, [$62,$91,$97,$17,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1875, [$62,$F1,$97,$27,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1876, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$06   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1877, [$62,$F1,$97,$27,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1878, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1879, [$62,$F1,$97,$27,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1880, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1881, [$62,$91,$97,$27,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1882, [$62,$91,$97,$17,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1883, [$62,$F1,$97,$27,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1884, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$06   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1885, [$62,$F1,$97,$27,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1886, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1887, [$62,$F1,$97,$27,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1888, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1889, [$62,$91,$97,$27,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1890, [$62,$91,$97,$17,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1891, [$62,$F1,$97,$27,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1892, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$07   ] , 'vcmpordsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1893, [$62,$F1,$97,$27,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1894, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1895, [$62,$F1,$97,$27,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1896, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1897, [$62,$91,$97,$27,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1898, [$62,$91,$97,$17,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1899, [$62,$F1,$97,$27,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1900, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$07   ] , 'vcmpordsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1901, [$62,$F1,$97,$27,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1902, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1903, [$62,$F1,$97,$27,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1904, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1905, [$62,$91,$97,$27,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1906, [$62,$91,$97,$17,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1907, [$62,$F1,$97,$27,$C2,$29,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1908, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$08   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1909, [$62,$F1,$97,$27,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1910, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1911, [$62,$F1,$97,$27,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1912, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1913, [$62,$91,$97,$27,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1914, [$62,$91,$97,$17,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1915, [$62,$F1,$97,$27,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1916, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$09   ] , 'vcmpngesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1917, [$62,$F1,$97,$27,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1918, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1919, [$62,$F1,$97,$27,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1920, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1921, [$62,$91,$97,$27,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1922, [$62,$91,$97,$17,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1923, [$62,$F1,$97,$27,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1924, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$09   ] , 'vcmpngesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1925, [$62,$F1,$97,$27,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1926, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1927, [$62,$F1,$97,$27,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1928, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1929, [$62,$91,$97,$27,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1930, [$62,$91,$97,$17,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1931, [$62,$F1,$97,$27,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1932, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0A   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1933, [$62,$F1,$97,$27,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1934, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1935, [$62,$F1,$97,$27,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1936, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1937, [$62,$91,$97,$27,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1938, [$62,$91,$97,$17,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1939, [$62,$F1,$97,$27,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1940, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0A   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1941, [$62,$F1,$97,$27,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1942, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1943, [$62,$F1,$97,$27,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1944, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1945, [$62,$91,$97,$27,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1946, [$62,$91,$97,$17,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1947, [$62,$F1,$97,$27,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1948, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0B   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1949, [$62,$F1,$97,$27,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1950, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1951, [$62,$F1,$97,$27,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1952, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1953, [$62,$91,$97,$27,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1954, [$62,$91,$97,$17,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1955, [$62,$F1,$97,$27,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1956, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0B   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1957, [$62,$F1,$97,$27,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1958, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1959, [$62,$F1,$97,$27,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1960, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1961, [$62,$91,$97,$27,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(1962, [$62,$91,$97,$17,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1963, [$62,$F1,$97,$27,$C2,$29,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1964, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0C   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(1965, [$62,$F1,$97,$27,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1966, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1967, [$62,$F1,$97,$27,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1968, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1969, [$62,$91,$97,$27,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1970, [$62,$91,$97,$17,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1971, [$62,$F1,$97,$27,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1972, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0D   ] , 'vcmpgesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1973, [$62,$F1,$97,$27,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1974, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1975, [$62,$F1,$97,$27,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1976, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1977, [$62,$91,$97,$27,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1978, [$62,$91,$97,$17,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1979, [$62,$F1,$97,$27,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1980, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0D   ] , 'vcmpgesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1981, [$62,$F1,$97,$27,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1982, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1983, [$62,$F1,$97,$27,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1984, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1985, [$62,$91,$97,$27,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1986, [$62,$91,$97,$17,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1987, [$62,$F1,$97,$27,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1988, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0E   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1989, [$62,$F1,$97,$27,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1990, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1991, [$62,$F1,$97,$27,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1992, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1993, [$62,$91,$97,$27,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1994, [$62,$91,$97,$17,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1995, [$62,$F1,$97,$27,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1996, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0E   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(1997, [$62,$F1,$97,$27,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1998, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1999, [$62,$F1,$97,$27,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(2000, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(2001, [$62,$91,$97,$27,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(2002, [$62,$91,$97,$17,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(2003, [$62,$F1,$97,$27,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm29,qword [rcx]'                );
  TestCase.testcase(2004, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0F   ] , 'vcmuesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'   );
  TestCase.testcase(2005, [$62,$F1,$97,$27,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x3f8]'          );
  TestCase.testcase(2006, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x400]'          );
  TestCase.testcase(2007, [$62,$F1,$97,$27,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x400]'          );
  TestCase.testcase(2008, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x408]'          );
  TestCase.testcase(2009, [$62,$91,$97,$27,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(2010, [$62,$91,$97,$17,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(2011, [$62,$F1,$97,$27,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm29,qword [rcx]'                );
  TestCase.testcase(2012, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0F   ] , 'vcmuesd  k5{k7},xmm29,qword [rax+r14*8+0x1234]'   );
  TestCase.testcase(2013, [$62,$F1,$97,$27,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x3f8]'          );
  TestCase.testcase(2014, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x400]'          );
  TestCase.testcase(2015, [$62,$F1,$97,$27,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x400]'          );
  TestCase.testcase(2016, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x408]'          );
  TestCase.testcase(2017, [$62,$91,$97,$27,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2018, [$62,$91,$97,$17,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2019, [$62,$F1,$97,$27,$C2,$29,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(2020, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$10   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2021, [$62,$F1,$97,$27,$C2,$6A,$7F,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(2022, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$10       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(2023, [$62,$F1,$97,$27,$C2,$6A,$80,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(2024, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$10       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(2025, [$62,$91,$97,$27,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2026, [$62,$91,$97,$17,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2027, [$62,$F1,$97,$27,$C2,$29,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(2028, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$11   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2029, [$62,$F1,$97,$27,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(2030, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$11       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(2031, [$62,$F1,$97,$27,$C2,$6A,$80,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(2032, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$11       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(2033, [$62,$91,$97,$27,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2034, [$62,$91,$97,$17,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2035, [$62,$F1,$97,$27,$C2,$29,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(2036, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$12   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2037, [$62,$F1,$97,$27,$C2,$6A,$7F,$12                   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(2038, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$12       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(2039, [$62,$F1,$97,$27,$C2,$6A,$80,$12                   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(2040, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$12       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(2041, [$62,$91,$97,$27,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,xmm28'                );
  TestCase.testcase(2042, [$62,$91,$97,$17,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(2043, [$62,$F1,$97,$27,$C2,$29,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rcx]'          );
  TestCase.testcase(2044, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$13   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2045, [$62,$F1,$97,$27,$C2,$6A,$7F,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx+0x3f8]'    );
  TestCase.testcase(2046, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$13       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx+0x400]'    );
  TestCase.testcase(2047, [$62,$F1,$97,$27,$C2,$6A,$80,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx-0x400]'    );
  TestCase.testcase(2048, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$13       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx-0x408]'    );
  TestCase.testcase(2049, [$62,$91,$97,$27,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2050, [$62,$91,$97,$17,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2051, [$62,$F1,$97,$27,$C2,$29,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2052, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$14   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2053, [$62,$F1,$97,$27,$C2,$6A,$7F,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2054, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$14       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2055, [$62,$F1,$97,$27,$C2,$6A,$80,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2056, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$14       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2057, [$62,$91,$97,$27,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2058, [$62,$91,$97,$17,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2059, [$62,$F1,$97,$27,$C2,$29,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2060, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$15   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2061, [$62,$F1,$97,$27,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2062, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2063, [$62,$F1,$97,$27,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2064, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2065, [$62,$91,$97,$27,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2066, [$62,$91,$97,$17,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2067, [$62,$F1,$97,$27,$C2,$29,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2068, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$16   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2069, [$62,$F1,$97,$27,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2070, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2071, [$62,$F1,$97,$27,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2072, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2073, [$62,$91,$97,$27,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2074, [$62,$91,$97,$17,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2075, [$62,$F1,$97,$27,$C2,$29,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(2076, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$17   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2077, [$62,$F1,$97,$27,$C2,$6A,$7F,$17                   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(2078, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$17       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(2079, [$62,$F1,$97,$27,$C2,$6A,$80,$17                   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(2080, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$17       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(2081, [$62,$91,$97,$27,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2082, [$62,$91,$97,$17,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2083, [$62,$F1,$97,$27,$C2,$29,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(2084, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$18   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2085, [$62,$F1,$97,$27,$C2,$6A,$7F,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(2086, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$18       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(2087, [$62,$F1,$97,$27,$C2,$6A,$80,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(2088, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$18       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(2089, [$62,$91,$97,$27,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2090, [$62,$91,$97,$17,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2091, [$62,$F1,$97,$27,$C2,$29,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2092, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$19   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2093, [$62,$F1,$97,$27,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2094, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2095, [$62,$F1,$97,$27,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2096, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2097, [$62,$91,$97,$27,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2098, [$62,$91,$97,$17,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2099, [$62,$F1,$97,$27,$C2,$29,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2100, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1A   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2101, [$62,$F1,$97,$27,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2102, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2103, [$62,$F1,$97,$27,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2104, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2105, [$62,$91,$97,$27,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,xmm28'               );
  TestCase.testcase(2106, [$62,$91,$97,$17,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,xmm28,{sae}'         );
  TestCase.testcase(2107, [$62,$F1,$97,$27,$C2,$29,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2108, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1B   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2109, [$62,$F1,$97,$27,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2110, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2111, [$62,$F1,$97,$27,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2112, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2113, [$62,$91,$97,$27,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2114, [$62,$91,$97,$17,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2115, [$62,$F1,$97,$27,$C2,$29,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2116, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1C   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2117, [$62,$F1,$97,$27,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2118, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2119, [$62,$F1,$97,$27,$C2,$6A,$80,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2120, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2121, [$62,$91,$97,$27,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2122, [$62,$91,$97,$17,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2123, [$62,$F1,$97,$27,$C2,$29,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(2124, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1D   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2125, [$62,$F1,$97,$27,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(2126, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(2127, [$62,$F1,$97,$27,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(2128, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(2129, [$62,$91,$97,$27,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2130, [$62,$91,$97,$17,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2131, [$62,$F1,$97,$27,$C2,$29,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(2132, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1E   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2133, [$62,$F1,$97,$27,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(2134, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(2135, [$62,$F1,$97,$27,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(2136, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(2137, [$62,$91,$97,$27,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,xmm28'                   );
  TestCase.testcase(2138, [$62,$91,$97,$17,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,xmm28,{sae}'             );
  TestCase.testcase(2139, [$62,$F1,$97,$27,$C2,$29,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rcx]'             );
  TestCase.testcase(2140, [$62,$B1,$97,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1F   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2141, [$62,$F1,$97,$27,$C2,$6A,$7F,$1F                   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'       );
  TestCase.testcase(2142, [$62,$F1,$97,$27,$C2,$AA,$00,$04,$00,$00,$1F       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx+0x400]'       );
  TestCase.testcase(2143, [$62,$F1,$97,$27,$C2,$6A,$80,$1F                   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx-0x400]'       );
  TestCase.testcase(2144, [$62,$F1,$97,$27,$C2,$AA,$F8,$FB,$FF,$FF,$1F       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx-0x408]'       );
  TestCase.testcase(2145, [$62,$91,$16,$27,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm29,xmm28,0xab'                  );
  TestCase.testcase(2146, [$62,$91,$16,$17,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm29,xmm28,{sae},0xab'            );
  TestCase.testcase(2147, [$62,$91,$16,$27,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm29,xmm28,0x7b'                  );
  TestCase.testcase(2148, [$62,$91,$16,$17,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm29,xmm28,{sae},0x7b'            );
  TestCase.testcase(2149, [$62,$F1,$16,$27,$C2,$29,$7B                       ] , 'vcmpss  k5{k7},xmm29,dword [rcx],0x7b'            );
  TestCase.testcase(2150, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$7B   ] , 'vcmpss  k5{k7},xmm29,dword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(2151, [$62,$F1,$16,$27,$C2,$6A,$7F,$7B                   ] , 'vcmpss  k5{k7},xmm29,dword [rdx+0x1fc],0x7b'      );
  TestCase.testcase(2152, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$7B       ] , 'vcmpss  k5{k7},xmm29,dword [rdx+0x200],0x7b'      );
  TestCase.testcase(2153, [$62,$F1,$16,$27,$C2,$6A,$80,$7B                   ] , 'vcmpss  k5{k7},xmm29,dword [rdx-0x200],0x7b'      );
  TestCase.testcase(2154, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vcmpss  k5{k7},xmm29,dword [rdx-0x204],0x7b'      );
  TestCase.testcase(2155, [$62,$91,$16,$27,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2156, [$62,$91,$16,$17,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2157, [$62,$F1,$16,$27,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2158, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$00   ] , 'vcmpeqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2159, [$62,$F1,$16,$27,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2160, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2161, [$62,$F1,$16,$27,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2162, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2163, [$62,$91,$16,$27,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2164, [$62,$91,$16,$17,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2165, [$62,$F1,$16,$27,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2166, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$00   ] , 'vcmpeqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2167, [$62,$F1,$16,$27,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2168, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2169, [$62,$F1,$16,$27,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2170, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2171, [$62,$91,$16,$27,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2172, [$62,$91,$16,$17,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2173, [$62,$F1,$16,$27,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2174, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$01   ] , 'vcmpltss  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2175, [$62,$F1,$16,$27,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2176, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2177, [$62,$F1,$16,$27,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2178, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2179, [$62,$91,$16,$27,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2180, [$62,$91,$16,$17,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2181, [$62,$F1,$16,$27,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2182, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$01   ] , 'vcmpltss  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2183, [$62,$F1,$16,$27,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2184, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2185, [$62,$F1,$16,$27,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2186, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2187, [$62,$91,$16,$27,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2188, [$62,$91,$16,$17,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2189, [$62,$F1,$16,$27,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2190, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$02   ] , 'vcmpless  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2191, [$62,$F1,$16,$27,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2192, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2193, [$62,$F1,$16,$27,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2194, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2195, [$62,$91,$16,$27,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2196, [$62,$91,$16,$17,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2197, [$62,$F1,$16,$27,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2198, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$02   ] , 'vcmpless  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2199, [$62,$F1,$16,$27,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2200, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2201, [$62,$F1,$16,$27,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2202, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2203, [$62,$91,$16,$27,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2204, [$62,$91,$16,$17,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2205, [$62,$F1,$16,$27,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2206, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$03   ] , 'vcmpunordss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2207, [$62,$F1,$16,$27,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2208, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2209, [$62,$F1,$16,$27,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2210, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2211, [$62,$91,$16,$27,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2212, [$62,$91,$16,$17,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2213, [$62,$F1,$16,$27,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2214, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$03   ] , 'vcmpunordss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2215, [$62,$F1,$16,$27,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2216, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2217, [$62,$F1,$16,$27,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2218, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2219, [$62,$91,$16,$27,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2220, [$62,$91,$16,$17,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2221, [$62,$F1,$16,$27,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2222, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$04   ] , 'vcmpneqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2223, [$62,$F1,$16,$27,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2224, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2225, [$62,$F1,$16,$27,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2226, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2227, [$62,$91,$16,$27,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2228, [$62,$91,$16,$17,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2229, [$62,$F1,$16,$27,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2230, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$04   ] , 'vcmpneqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2231, [$62,$F1,$16,$27,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2232, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2233, [$62,$F1,$16,$27,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2234, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2235, [$62,$91,$16,$27,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2236, [$62,$91,$16,$17,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2237, [$62,$F1,$16,$27,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2238, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$05   ] , 'vcmpnltss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2239, [$62,$F1,$16,$27,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2240, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2241, [$62,$F1,$16,$27,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2242, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2243, [$62,$91,$16,$27,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2244, [$62,$91,$16,$17,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2245, [$62,$F1,$16,$27,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2246, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$05   ] , 'vcmpnltss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2247, [$62,$F1,$16,$27,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2248, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2249, [$62,$F1,$16,$27,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2250, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2251, [$62,$91,$16,$27,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2252, [$62,$91,$16,$17,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2253, [$62,$F1,$16,$27,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2254, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$06   ] , 'vcmpnless  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2255, [$62,$F1,$16,$27,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2256, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2257, [$62,$F1,$16,$27,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2258, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2259, [$62,$91,$16,$27,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2260, [$62,$91,$16,$17,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2261, [$62,$F1,$16,$27,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2262, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$06   ] , 'vcmpnless  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2263, [$62,$F1,$16,$27,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2264, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2265, [$62,$F1,$16,$27,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2266, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2267, [$62,$91,$16,$27,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2268, [$62,$91,$16,$17,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2269, [$62,$F1,$16,$27,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2270, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$07   ] , 'vcmpordss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2271, [$62,$F1,$16,$27,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2272, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2273, [$62,$F1,$16,$27,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2274, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2275, [$62,$91,$16,$27,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2276, [$62,$91,$16,$17,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2277, [$62,$F1,$16,$27,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2278, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$07   ] , 'vcmpordss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2279, [$62,$F1,$16,$27,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2280, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2281, [$62,$F1,$16,$27,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2282, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2283, [$62,$91,$16,$27,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2284, [$62,$91,$16,$17,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2285, [$62,$F1,$16,$27,$C2,$29,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2286, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$08   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2287, [$62,$F1,$16,$27,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2288, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$08       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2289, [$62,$F1,$16,$27,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2290, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$08       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2291, [$62,$91,$16,$27,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2292, [$62,$91,$16,$17,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2293, [$62,$F1,$16,$27,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2294, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$09   ] , 'vcmpngess  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2295, [$62,$F1,$16,$27,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2296, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2297, [$62,$F1,$16,$27,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2298, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2299, [$62,$91,$16,$27,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2300, [$62,$91,$16,$17,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2301, [$62,$F1,$16,$27,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2302, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$09   ] , 'vcmpngess  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2303, [$62,$F1,$16,$27,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2304, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2305, [$62,$F1,$16,$27,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2306, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2307, [$62,$91,$16,$27,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2308, [$62,$91,$16,$17,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2309, [$62,$F1,$16,$27,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2310, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0A   ] , 'vcmpngtss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2311, [$62,$F1,$16,$27,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2312, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2313, [$62,$F1,$16,$27,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2314, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2315, [$62,$91,$16,$27,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2316, [$62,$91,$16,$17,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2317, [$62,$F1,$16,$27,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2318, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0A   ] , 'vcmpngtss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2319, [$62,$F1,$16,$27,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2320, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2321, [$62,$F1,$16,$27,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2322, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2323, [$62,$91,$16,$27,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2324, [$62,$91,$16,$17,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2325, [$62,$F1,$16,$27,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2326, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0B   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2327, [$62,$F1,$16,$27,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2328, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2329, [$62,$F1,$16,$27,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2330, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2331, [$62,$91,$16,$27,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2332, [$62,$91,$16,$17,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2333, [$62,$F1,$16,$27,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2334, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0B   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2335, [$62,$F1,$16,$27,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2336, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2337, [$62,$F1,$16,$27,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2338, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2339, [$62,$91,$16,$27,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2340, [$62,$91,$16,$17,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2341, [$62,$F1,$16,$27,$C2,$29,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2342, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0C   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2343, [$62,$F1,$16,$27,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2344, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2345, [$62,$F1,$16,$27,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2346, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2347, [$62,$91,$16,$27,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2348, [$62,$91,$16,$17,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2349, [$62,$F1,$16,$27,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2350, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0D   ] , 'vcmpgess  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2351, [$62,$F1,$16,$27,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2352, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2353, [$62,$F1,$16,$27,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2354, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2355, [$62,$91,$16,$27,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2356, [$62,$91,$16,$17,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2357, [$62,$F1,$16,$27,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2358, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0D   ] , 'vcmpgess  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2359, [$62,$F1,$16,$27,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2360, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2361, [$62,$F1,$16,$27,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2362, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2363, [$62,$91,$16,$27,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2364, [$62,$91,$16,$17,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2365, [$62,$F1,$16,$27,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2366, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0E   ] , 'vcmpgtss  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2367, [$62,$F1,$16,$27,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2368, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2369, [$62,$F1,$16,$27,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2370, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2371, [$62,$91,$16,$27,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2372, [$62,$91,$16,$17,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2373, [$62,$F1,$16,$27,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2374, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0E   ] , 'vcmpgtss  k5{k7},xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2375, [$62,$F1,$16,$27,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2376, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2377, [$62,$F1,$16,$27,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2378, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2379, [$62,$91,$16,$27,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(2380, [$62,$91,$16,$17,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(2381, [$62,$F1,$16,$27,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm29,dword [rcx]'                );
  TestCase.testcase(2382, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0F   ] , 'vcmuess  k5{k7},xmm29,dword [rax+r14*8+0x1234]'   );
  TestCase.testcase(2383, [$62,$F1,$16,$27,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x1fc]'          );
  TestCase.testcase(2384, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x200]'          );
  TestCase.testcase(2385, [$62,$F1,$16,$27,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x200]'          );
  TestCase.testcase(2386, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x204]'          );
  TestCase.testcase(2387, [$62,$91,$16,$27,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(2388, [$62,$91,$16,$17,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(2389, [$62,$F1,$16,$27,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm29,dword [rcx]'                );
  TestCase.testcase(2390, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$0F   ] , 'vcmuess  k5{k7},xmm29,dword [rax+r14*8+0x1234]'   );
  TestCase.testcase(2391, [$62,$F1,$16,$27,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x1fc]'          );
  TestCase.testcase(2392, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x200]'          );
  TestCase.testcase(2393, [$62,$F1,$16,$27,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x200]'          );
  TestCase.testcase(2394, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x204]'          );
  TestCase.testcase(2395, [$62,$91,$16,$27,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2396, [$62,$91,$16,$17,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2397, [$62,$F1,$16,$27,$C2,$29,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2398, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$10   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2399, [$62,$F1,$16,$27,$C2,$6A,$7F,$10                   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2400, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$10       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2401, [$62,$F1,$16,$27,$C2,$6A,$80,$10                   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2402, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$10       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2403, [$62,$91,$16,$27,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2404, [$62,$91,$16,$17,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2405, [$62,$F1,$16,$27,$C2,$29,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2406, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$11   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2407, [$62,$F1,$16,$27,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2408, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$11       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2409, [$62,$F1,$16,$27,$C2,$6A,$80,$11                   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2410, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$11       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2411, [$62,$91,$16,$27,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2412, [$62,$91,$16,$17,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2413, [$62,$F1,$16,$27,$C2,$29,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2414, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$12   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2415, [$62,$F1,$16,$27,$C2,$6A,$7F,$12                   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2416, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$12       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2417, [$62,$F1,$16,$27,$C2,$6A,$80,$12                   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2418, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$12       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2419, [$62,$91,$16,$27,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,xmm28'                );
  TestCase.testcase(2420, [$62,$91,$16,$17,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(2421, [$62,$F1,$16,$27,$C2,$29,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rcx]'          );
  TestCase.testcase(2422, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$13   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2423, [$62,$F1,$16,$27,$C2,$6A,$7F,$13                   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx+0x1fc]'    );
  TestCase.testcase(2424, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$13       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx+0x200]'    );
  TestCase.testcase(2425, [$62,$F1,$16,$27,$C2,$6A,$80,$13                   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx-0x200]'    );
  TestCase.testcase(2426, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$13       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx-0x204]'    );
  TestCase.testcase(2427, [$62,$91,$16,$27,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2428, [$62,$91,$16,$17,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2429, [$62,$F1,$16,$27,$C2,$29,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2430, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$14   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2431, [$62,$F1,$16,$27,$C2,$6A,$7F,$14                   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2432, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$14       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2433, [$62,$F1,$16,$27,$C2,$6A,$80,$14                   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2434, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$14       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2435, [$62,$91,$16,$27,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2436, [$62,$91,$16,$17,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2437, [$62,$F1,$16,$27,$C2,$29,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2438, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$15   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2439, [$62,$F1,$16,$27,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2440, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2441, [$62,$F1,$16,$27,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2442, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2443, [$62,$91,$16,$27,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2444, [$62,$91,$16,$17,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2445, [$62,$F1,$16,$27,$C2,$29,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2446, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$16   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2447, [$62,$F1,$16,$27,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2448, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$16       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2449, [$62,$F1,$16,$27,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2450, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$16       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2451, [$62,$91,$16,$27,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2452, [$62,$91,$16,$17,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2453, [$62,$F1,$16,$27,$C2,$29,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2454, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$17   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2455, [$62,$F1,$16,$27,$C2,$6A,$7F,$17                   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2456, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$17       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2457, [$62,$F1,$16,$27,$C2,$6A,$80,$17                   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2458, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$17       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2459, [$62,$91,$16,$27,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2460, [$62,$91,$16,$17,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2461, [$62,$F1,$16,$27,$C2,$29,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2462, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$18   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2463, [$62,$F1,$16,$27,$C2,$6A,$7F,$18                   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2464, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$18       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2465, [$62,$F1,$16,$27,$C2,$6A,$80,$18                   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2466, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$18       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2467, [$62,$91,$16,$27,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2468, [$62,$91,$16,$17,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2469, [$62,$F1,$16,$27,$C2,$29,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2470, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$19   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2471, [$62,$F1,$16,$27,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2472, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$19       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2473, [$62,$F1,$16,$27,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2474, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$19       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2475, [$62,$91,$16,$27,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2476, [$62,$91,$16,$17,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2477, [$62,$F1,$16,$27,$C2,$29,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2478, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1A   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2479, [$62,$F1,$16,$27,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2480, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2481, [$62,$F1,$16,$27,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2482, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2483, [$62,$91,$16,$27,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,xmm28'               );
  TestCase.testcase(2484, [$62,$91,$16,$17,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,xmm28,{sae}'         );
  TestCase.testcase(2485, [$62,$F1,$16,$27,$C2,$29,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2486, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1B   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2487, [$62,$F1,$16,$27,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2488, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2489, [$62,$F1,$16,$27,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2490, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2491, [$62,$91,$16,$27,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2492, [$62,$91,$16,$17,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2493, [$62,$F1,$16,$27,$C2,$29,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2494, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1C   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2495, [$62,$F1,$16,$27,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2496, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1C       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2497, [$62,$F1,$16,$27,$C2,$6A,$80,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2498, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1C       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2499, [$62,$91,$16,$27,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2500, [$62,$91,$16,$17,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2501, [$62,$F1,$16,$27,$C2,$29,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2502, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1D   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2503, [$62,$F1,$16,$27,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2504, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1D       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2505, [$62,$F1,$16,$27,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2506, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1D       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2507, [$62,$91,$16,$27,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2508, [$62,$91,$16,$17,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2509, [$62,$F1,$16,$27,$C2,$29,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2510, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1E   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2511, [$62,$F1,$16,$27,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2512, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2513, [$62,$F1,$16,$27,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2514, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2515, [$62,$91,$16,$27,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,xmm28'                   );
  TestCase.testcase(2516, [$62,$91,$16,$17,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,xmm28,{sae}'             );
  TestCase.testcase(2517, [$62,$F1,$16,$27,$C2,$29,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,dword [rcx]'             );
  TestCase.testcase(2518, [$62,$B1,$16,$27,$C2,$AC,$F0,$34,$12,$00,$00,$1F   ] , 'vcmue_usss  k5{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2519, [$62,$F1,$16,$27,$C2,$6A,$7F,$1F                   ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx+0x1fc]'       );
  TestCase.testcase(2520, [$62,$F1,$16,$27,$C2,$AA,$00,$02,$00,$00,$1F       ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx+0x200]'       );
  TestCase.testcase(2521, [$62,$F1,$16,$27,$C2,$6A,$80,$1F                   ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx-0x200]'       );
  TestCase.testcase(2522, [$62,$F1,$16,$27,$C2,$AA,$FC,$FD,$FF,$FF,$1F       ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx-0x204]'       );
  TestCase.testcase(2523, [$62,$01,$FD,$28,$2F,$F5                           ] , 'vcomisd  xmm30,xmm29'                             );
  TestCase.testcase(2524, [$62,$01,$FD,$18,$2F,$F5                           ] , 'vcomisd  xmm30,xmm29,{sae}'                       );
  TestCase.testcase(2525, [$62,$61,$FD,$28,$2F,$31                           ] , 'vcomisd  xmm30,qword [rcx]'                       );
  TestCase.testcase(2526, [$62,$21,$FD,$28,$2F,$B4,$F0,$34,$12,$00,$00       ] , 'vcomisd  xmm30,qword [rax+r14*8+0x1234]'          );
  TestCase.testcase(2527, [$62,$61,$FD,$28,$2F,$72,$7F                       ] , 'vcomisd  xmm30,qword [rdx+0x3f8]'                 );
  TestCase.testcase(2528, [$62,$61,$FD,$28,$2F,$B2,$00,$04,$00,$00           ] , 'vcomisd  xmm30,qword [rdx+0x400]'                 );
  TestCase.testcase(2529, [$62,$61,$FD,$28,$2F,$72,$80                       ] , 'vcomisd  xmm30,qword [rdx-0x400]'                 );
  TestCase.testcase(2530, [$62,$61,$FD,$28,$2F,$B2,$F8,$FB,$FF,$FF           ] , 'vcomisd  xmm30,qword [rdx-0x408]'                 );
  TestCase.testcase(2531, [$62,$01,$7C,$28,$2F,$F5                           ] , 'vcomiss  xmm30,xmm29'                             );
  TestCase.testcase(2532, [$62,$01,$7C,$18,$2F,$F5                           ] , 'vcomiss  xmm30,xmm29,{sae}'                       );
  TestCase.testcase(2533, [$62,$61,$7C,$28,$2F,$31                           ] , 'vcomiss  xmm30,dword [rcx]'                       );
  TestCase.testcase(2534, [$62,$21,$7C,$28,$2F,$B4,$F0,$34,$12,$00,$00       ] , 'vcomiss  xmm30,dword [rax+r14*8+0x1234]'          );
  TestCase.testcase(2535, [$62,$61,$7C,$28,$2F,$72,$7F                       ] , 'vcomiss  xmm30,dword [rdx+0x1fc]'                 );
  TestCase.testcase(2536, [$62,$61,$7C,$28,$2F,$B2,$00,$02,$00,$00           ] , 'vcomiss  xmm30,dword [rdx+0x200]'                 );
  TestCase.testcase(2537, [$62,$61,$7C,$28,$2F,$72,$80                       ] , 'vcomiss  xmm30,dword [rdx-0x200]'                 );
  TestCase.testcase(2538, [$62,$61,$7C,$28,$2F,$B2,$FC,$FD,$FF,$FF           ] , 'vcomiss  xmm30,dword [rdx-0x204]'                 );
  TestCase.testcase(2539, [$62,$91,$7F,$18,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rn-sae}'                    );
  TestCase.testcase(2540, [$62,$91,$7F,$58,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{ru-sae}'                    );
  TestCase.testcase(2541, [$62,$91,$7F,$38,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rd-sae}'                    );
  TestCase.testcase(2542, [$62,$91,$7F,$78,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rz-sae}'                    );
  TestCase.testcase(2543, [$62,$91,$7F,$18,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rn-sae}'                    );
  TestCase.testcase(2544, [$62,$91,$7F,$58,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{ru-sae}'                    );
  TestCase.testcase(2545, [$62,$91,$7F,$38,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rd-sae}'                    );
  TestCase.testcase(2546, [$62,$91,$7F,$78,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rz-sae}'                    );
  TestCase.testcase(2547, [$62,$11,$7F,$18,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rn-sae}'                   );
  TestCase.testcase(2548, [$62,$11,$7F,$58,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{ru-sae}'                   );
  TestCase.testcase(2549, [$62,$11,$7F,$38,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rd-sae}'                   );
  TestCase.testcase(2550, [$62,$11,$7F,$78,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rz-sae}'                   );
  TestCase.testcase(2551, [$62,$91,$FF,$18,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rn-sae}'                    );
  TestCase.testcase(2552, [$62,$91,$FF,$58,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{ru-sae}'                    );
  TestCase.testcase(2553, [$62,$91,$FF,$38,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rd-sae}'                    );
  TestCase.testcase(2554, [$62,$91,$FF,$78,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rz-sae}'                    );
  TestCase.testcase(2555, [$62,$11,$FF,$18,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rn-sae}'                     );
  TestCase.testcase(2556, [$62,$11,$FF,$58,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{ru-sae}'                     );
  TestCase.testcase(2557, [$62,$11,$FF,$38,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rd-sae}'                     );
  TestCase.testcase(2558, [$62,$11,$FF,$78,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rz-sae}'                     );
  TestCase.testcase(2559, [$62,$01,$97,$27,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(2560, [$62,$01,$97,$A7,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(2561, [$62,$01,$97,$17,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(2562, [$62,$01,$97,$57,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(2563, [$62,$01,$97,$37,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(2564, [$62,$01,$97,$77,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(2565, [$62,$61,$97,$27,$5A,$31                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2566, [$62,$21,$97,$27,$5A,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2567, [$62,$61,$97,$27,$5A,$72,$7F                       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2568, [$62,$61,$97,$27,$5A,$B2,$00,$04,$00,$00           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2569, [$62,$61,$97,$27,$5A,$72,$80                       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2570, [$62,$61,$97,$27,$5A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2571, [$62,$61,$17,$20,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,eax'                       );
  TestCase.testcase(2572, [$62,$61,$17,$20,$2A,$F5                           ] , 'vcvtsi2sd  xmm30,xmm29,ebp'                       );
  TestCase.testcase(2573, [$62,$41,$17,$20,$2A,$F5                           ] , 'vcvtsi2sd  xmm30,xmm29,r13d'                      );
  TestCase.testcase(2574, [$62,$61,$17,$20,$2A,$31                           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rcx]'               );
  TestCase.testcase(2575, [$62,$21,$17,$20,$2A,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2576, [$62,$61,$17,$20,$2A,$72,$7F                       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2577, [$62,$61,$17,$20,$2A,$B2,$00,$02,$00,$00           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2578, [$62,$61,$17,$20,$2A,$72,$80                       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2579, [$62,$61,$17,$20,$2A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2580, [$62,$61,$97,$20,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,rax'                       );
  TestCase.testcase(2581, [$62,$61,$97,$10,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rn-sae},rax'              );
  TestCase.testcase(2582, [$62,$61,$97,$50,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{ru-sae},rax'              );
  TestCase.testcase(2583, [$62,$61,$97,$30,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rd-sae},rax'              );
  TestCase.testcase(2584, [$62,$61,$97,$70,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rz-sae},rax'              );
  TestCase.testcase(2585, [$62,$41,$97,$20,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,r8'                        );
  TestCase.testcase(2586, [$62,$41,$97,$10,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rn-sae},r8'               );
  TestCase.testcase(2587, [$62,$41,$97,$50,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{ru-sae},r8'               );
  TestCase.testcase(2588, [$62,$41,$97,$30,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rd-sae},r8'               );
  TestCase.testcase(2589, [$62,$41,$97,$70,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rz-sae},r8'               );
  TestCase.testcase(2590, [$62,$61,$97,$20,$2A,$31                           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rcx]'               );
  TestCase.testcase(2591, [$62,$21,$97,$20,$2A,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2592, [$62,$61,$97,$20,$2A,$72,$7F                       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(2593, [$62,$61,$97,$20,$2A,$B2,$00,$04,$00,$00           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(2594, [$62,$61,$97,$20,$2A,$72,$80                       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(2595, [$62,$61,$97,$20,$2A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(2596, [$62,$61,$16,$20,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,eax'                       );
  TestCase.testcase(2597, [$62,$61,$16,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},eax'              );
  TestCase.testcase(2598, [$62,$61,$16,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},eax'              );
  TestCase.testcase(2599, [$62,$61,$16,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},eax'              );
  TestCase.testcase(2600, [$62,$61,$16,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},eax'              );
  TestCase.testcase(2601, [$62,$61,$16,$20,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,ebp'                       );
  TestCase.testcase(2602, [$62,$61,$16,$10,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},ebp'              );
  TestCase.testcase(2603, [$62,$61,$16,$50,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},ebp'              );
  TestCase.testcase(2604, [$62,$61,$16,$30,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},ebp'              );
  TestCase.testcase(2605, [$62,$61,$16,$70,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},ebp'              );
  TestCase.testcase(2606, [$62,$41,$16,$20,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,r13d'                      );
  TestCase.testcase(2607, [$62,$41,$16,$10,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},r13d'             );
  TestCase.testcase(2608, [$62,$41,$16,$50,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},r13d'             );
  TestCase.testcase(2609, [$62,$41,$16,$30,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},r13d'             );
  TestCase.testcase(2610, [$62,$41,$16,$70,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},r13d'             );
  TestCase.testcase(2611, [$62,$61,$16,$20,$2A,$31                           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rcx]'               );
  TestCase.testcase(2612, [$62,$21,$16,$20,$2A,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2613, [$62,$61,$16,$20,$2A,$72,$7F                       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2614, [$62,$61,$16,$20,$2A,$B2,$00,$02,$00,$00           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2615, [$62,$61,$16,$20,$2A,$72,$80                       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2616, [$62,$61,$16,$20,$2A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2617, [$62,$61,$96,$20,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,rax'                       );
  TestCase.testcase(2618, [$62,$61,$96,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},rax'              );
  TestCase.testcase(2619, [$62,$61,$96,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},rax'              );
  TestCase.testcase(2620, [$62,$61,$96,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},rax'              );
  TestCase.testcase(2621, [$62,$61,$96,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},rax'              );
  TestCase.testcase(2622, [$62,$41,$96,$20,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,r8'                        );
  TestCase.testcase(2623, [$62,$41,$96,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},r8'               );
  TestCase.testcase(2624, [$62,$41,$96,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},r8'               );
  TestCase.testcase(2625, [$62,$41,$96,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},r8'               );
  TestCase.testcase(2626, [$62,$41,$96,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},r8'               );
  TestCase.testcase(2627, [$62,$61,$96,$20,$2A,$31                           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rcx]'               );
  TestCase.testcase(2628, [$62,$21,$96,$20,$2A,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rax+r14*8+0x1234]'  );
  TestCase.testcase(2629, [$62,$61,$96,$20,$2A,$72,$7F                       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(2630, [$62,$61,$96,$20,$2A,$B2,$00,$04,$00,$00           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(2631, [$62,$61,$96,$20,$2A,$72,$80                       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(2632, [$62,$61,$96,$20,$2A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(2633, [$62,$01,$16,$27,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(2634, [$62,$01,$16,$A7,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(2635, [$62,$01,$16,$17,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2636, [$62,$61,$16,$27,$5A,$31                           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2637, [$62,$21,$16,$27,$5A,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2638, [$62,$61,$16,$27,$5A,$72,$7F                       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2639, [$62,$61,$16,$27,$5A,$B2,$00,$02,$00,$00           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2640, [$62,$61,$16,$27,$5A,$72,$80                       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2641, [$62,$61,$16,$27,$5A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2642, [$62,$91,$7E,$18,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rn-sae}'                    );
  TestCase.testcase(2643, [$62,$91,$7E,$58,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{ru-sae}'                    );
  TestCase.testcase(2644, [$62,$91,$7E,$38,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rd-sae}'                    );
  TestCase.testcase(2645, [$62,$91,$7E,$78,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rz-sae}'                    );
  TestCase.testcase(2646, [$62,$91,$7E,$18,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rn-sae}'                    );
  TestCase.testcase(2647, [$62,$91,$7E,$58,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{ru-sae}'                    );
  TestCase.testcase(2648, [$62,$91,$7E,$38,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rd-sae}'                    );
  TestCase.testcase(2649, [$62,$91,$7E,$78,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rz-sae}'                    );
  TestCase.testcase(2650, [$62,$11,$7E,$18,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rn-sae}'                   );
  TestCase.testcase(2651, [$62,$11,$7E,$58,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{ru-sae}'                   );
  TestCase.testcase(2652, [$62,$11,$7E,$38,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rd-sae}'                   );
  TestCase.testcase(2653, [$62,$11,$7E,$78,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rz-sae}'                   );
  TestCase.testcase(2654, [$62,$91,$FE,$18,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rn-sae}'                    );
  TestCase.testcase(2655, [$62,$91,$FE,$58,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{ru-sae}'                    );
  TestCase.testcase(2656, [$62,$91,$FE,$38,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rd-sae}'                    );
  TestCase.testcase(2657, [$62,$91,$FE,$78,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rz-sae}'                    );
  TestCase.testcase(2658, [$62,$11,$FE,$18,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rn-sae}'                     );
  TestCase.testcase(2659, [$62,$11,$FE,$58,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{ru-sae}'                     );
  TestCase.testcase(2660, [$62,$11,$FE,$38,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rd-sae}'                     );
  TestCase.testcase(2661, [$62,$11,$FE,$78,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rz-sae}'                     );
  TestCase.testcase(2662, [$62,$91,$7F,$18,$2C,$C6                           ] , 'vcvttsd2si  eax,xmm30,{sae}'                      );
  TestCase.testcase(2663, [$62,$91,$7F,$18,$2C,$EE                           ] , 'vcvttsd2si  ebp,xmm30,{sae}'                      );
  TestCase.testcase(2664, [$62,$11,$7F,$18,$2C,$EE                           ] , 'vcvttsd2si  r13d,xmm30,{sae}'                     );
  TestCase.testcase(2665, [$62,$91,$FF,$18,$2C,$C6                           ] , 'vcvttsd2si  rax,xmm30,{sae}'                      );
  TestCase.testcase(2666, [$62,$11,$FF,$18,$2C,$C6                           ] , 'vcvttsd2si  r8,xmm30,{sae}'                       );
  TestCase.testcase(2667, [$62,$91,$7E,$18,$2C,$C6                           ] , 'vcvttss2si  eax,xmm30,{sae}'                      );
  TestCase.testcase(2668, [$62,$91,$7E,$18,$2C,$EE                           ] , 'vcvttss2si  ebp,xmm30,{sae}'                      );
  TestCase.testcase(2669, [$62,$11,$7E,$18,$2C,$EE                           ] , 'vcvttss2si  r13d,xmm30,{sae}'                     );
  TestCase.testcase(2670, [$62,$91,$FE,$18,$2C,$C6                           ] , 'vcvttss2si  rax,xmm30,{sae}'                      );
  TestCase.testcase(2671, [$62,$11,$FE,$18,$2C,$C6                           ] , 'vcvttss2si  r8,xmm30,{sae}'                       );
  TestCase.testcase(2672, [$62,$01,$97,$27,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(2673, [$62,$01,$97,$A7,$5E,$F4                           ] , 'vdivsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(2674, [$62,$01,$97,$17,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(2675, [$62,$01,$97,$57,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(2676, [$62,$01,$97,$37,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(2677, [$62,$01,$97,$77,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(2678, [$62,$61,$97,$27,$5E,$31                           ] , 'vdivsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(2679, [$62,$21,$97,$27,$5E,$B4,$F0,$34,$12,$00,$00       ] , 'vdivsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2680, [$62,$61,$97,$27,$5E,$72,$7F                       ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(2681, [$62,$61,$97,$27,$5E,$B2,$00,$04,$00,$00           ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(2682, [$62,$61,$97,$27,$5E,$72,$80                       ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(2683, [$62,$61,$97,$27,$5E,$B2,$F8,$FB,$FF,$FF           ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(2684, [$62,$01,$16,$27,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(2685, [$62,$01,$16,$A7,$5E,$F4                           ] , 'vdivss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(2686, [$62,$01,$16,$17,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(2687, [$62,$01,$16,$57,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(2688, [$62,$01,$16,$37,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(2689, [$62,$01,$16,$77,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(2690, [$62,$61,$16,$27,$5E,$31                           ] , 'vdivss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2691, [$62,$21,$16,$27,$5E,$B4,$F0,$34,$12,$00,$00       ] , 'vdivss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2692, [$62,$61,$16,$27,$5E,$72,$7F                       ] , 'vdivss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2693, [$62,$61,$16,$27,$5E,$B2,$00,$02,$00,$00           ] , 'vdivss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2694, [$62,$61,$16,$27,$5E,$72,$80                       ] , 'vdivss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2695, [$62,$61,$16,$27,$5E,$B2,$FC,$FD,$FF,$FF           ] , 'vdivss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2696, [$62,$02,$95,$27,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2697, [$62,$02,$95,$A7,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2698, [$62,$02,$95,$17,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2699, [$62,$02,$95,$57,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2700, [$62,$02,$95,$37,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2701, [$62,$02,$95,$77,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2702, [$62,$62,$95,$27,$99,$31                           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2703, [$62,$22,$95,$27,$99,$B4,$F0,$34,$12,$00,$00       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2704, [$62,$62,$95,$27,$99,$72,$7F                       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2705, [$62,$62,$95,$27,$99,$B2,$00,$04,$00,$00           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2706, [$62,$62,$95,$27,$99,$72,$80                       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2707, [$62,$62,$95,$27,$99,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2708, [$62,$02,$15,$27,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2709, [$62,$02,$15,$A7,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2710, [$62,$02,$15,$17,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2711, [$62,$02,$15,$57,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2712, [$62,$02,$15,$37,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2713, [$62,$02,$15,$77,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2714, [$62,$62,$15,$27,$99,$31                           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2715, [$62,$22,$15,$27,$99,$B4,$F0,$34,$12,$00,$00       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2716, [$62,$62,$15,$27,$99,$72,$7F                       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2717, [$62,$62,$15,$27,$99,$B2,$00,$02,$00,$00           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2718, [$62,$62,$15,$27,$99,$72,$80                       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2719, [$62,$62,$15,$27,$99,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2720, [$62,$02,$95,$27,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2721, [$62,$02,$95,$A7,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2722, [$62,$02,$95,$17,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2723, [$62,$02,$95,$57,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2724, [$62,$02,$95,$37,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2725, [$62,$02,$95,$77,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2726, [$62,$62,$95,$27,$A9,$31                           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2727, [$62,$22,$95,$27,$A9,$B4,$F0,$34,$12,$00,$00       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2728, [$62,$62,$95,$27,$A9,$72,$7F                       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2729, [$62,$62,$95,$27,$A9,$B2,$00,$04,$00,$00           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2730, [$62,$62,$95,$27,$A9,$72,$80                       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2731, [$62,$62,$95,$27,$A9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2732, [$62,$02,$15,$27,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2733, [$62,$02,$15,$A7,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2734, [$62,$02,$15,$17,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2735, [$62,$02,$15,$57,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2736, [$62,$02,$15,$37,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2737, [$62,$02,$15,$77,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2738, [$62,$62,$15,$27,$A9,$31                           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2739, [$62,$22,$15,$27,$A9,$B4,$F0,$34,$12,$00,$00       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2740, [$62,$62,$15,$27,$A9,$72,$7F                       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2741, [$62,$62,$15,$27,$A9,$B2,$00,$02,$00,$00           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2742, [$62,$62,$15,$27,$A9,$72,$80                       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2743, [$62,$62,$15,$27,$A9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2744, [$62,$02,$95,$27,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2745, [$62,$02,$95,$A7,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2746, [$62,$02,$95,$17,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2747, [$62,$02,$95,$57,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2748, [$62,$02,$95,$37,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2749, [$62,$02,$95,$77,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2750, [$62,$62,$95,$27,$B9,$31                           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2751, [$62,$22,$95,$27,$B9,$B4,$F0,$34,$12,$00,$00       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2752, [$62,$62,$95,$27,$B9,$72,$7F                       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2753, [$62,$62,$95,$27,$B9,$B2,$00,$04,$00,$00           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2754, [$62,$62,$95,$27,$B9,$72,$80                       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2755, [$62,$62,$95,$27,$B9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2756, [$62,$02,$15,$27,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2757, [$62,$02,$15,$A7,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2758, [$62,$02,$15,$17,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2759, [$62,$02,$15,$57,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2760, [$62,$02,$15,$37,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2761, [$62,$02,$15,$77,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2762, [$62,$62,$15,$27,$B9,$31                           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2763, [$62,$22,$15,$27,$B9,$B4,$F0,$34,$12,$00,$00       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2764, [$62,$62,$15,$27,$B9,$72,$7F                       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2765, [$62,$62,$15,$27,$B9,$B2,$00,$02,$00,$00           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2766, [$62,$62,$15,$27,$B9,$72,$80                       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2767, [$62,$62,$15,$27,$B9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2768, [$62,$02,$95,$27,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2769, [$62,$02,$95,$A7,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2770, [$62,$02,$95,$17,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2771, [$62,$02,$95,$57,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2772, [$62,$02,$95,$37,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2773, [$62,$02,$95,$77,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2774, [$62,$62,$95,$27,$9B,$31                           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2775, [$62,$22,$95,$27,$9B,$B4,$F0,$34,$12,$00,$00       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2776, [$62,$62,$95,$27,$9B,$72,$7F                       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2777, [$62,$62,$95,$27,$9B,$B2,$00,$04,$00,$00           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2778, [$62,$62,$95,$27,$9B,$72,$80                       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2779, [$62,$62,$95,$27,$9B,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2780, [$62,$02,$15,$27,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2781, [$62,$02,$15,$A7,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2782, [$62,$02,$15,$17,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2783, [$62,$02,$15,$57,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2784, [$62,$02,$15,$37,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2785, [$62,$02,$15,$77,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2786, [$62,$62,$15,$27,$9B,$31                           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2787, [$62,$22,$15,$27,$9B,$B4,$F0,$34,$12,$00,$00       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2788, [$62,$62,$15,$27,$9B,$72,$7F                       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2789, [$62,$62,$15,$27,$9B,$B2,$00,$02,$00,$00           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2790, [$62,$62,$15,$27,$9B,$72,$80                       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2791, [$62,$62,$15,$27,$9B,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2792, [$62,$02,$95,$27,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2793, [$62,$02,$95,$A7,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2794, [$62,$02,$95,$17,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2795, [$62,$02,$95,$57,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2796, [$62,$02,$95,$37,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2797, [$62,$02,$95,$77,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2798, [$62,$62,$95,$27,$AB,$31                           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2799, [$62,$22,$95,$27,$AB,$B4,$F0,$34,$12,$00,$00       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2800, [$62,$62,$95,$27,$AB,$72,$7F                       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2801, [$62,$62,$95,$27,$AB,$B2,$00,$04,$00,$00           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2802, [$62,$62,$95,$27,$AB,$72,$80                       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2803, [$62,$62,$95,$27,$AB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2804, [$62,$02,$15,$27,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2805, [$62,$02,$15,$A7,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2806, [$62,$02,$15,$17,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2807, [$62,$02,$15,$57,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2808, [$62,$02,$15,$37,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2809, [$62,$02,$15,$77,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2810, [$62,$62,$15,$27,$AB,$31                           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2811, [$62,$22,$15,$27,$AB,$B4,$F0,$34,$12,$00,$00       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2812, [$62,$62,$15,$27,$AB,$72,$7F                       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2813, [$62,$62,$15,$27,$AB,$B2,$00,$02,$00,$00           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2814, [$62,$62,$15,$27,$AB,$72,$80                       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2815, [$62,$62,$15,$27,$AB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2816, [$62,$02,$95,$27,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2817, [$62,$02,$95,$A7,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2818, [$62,$02,$95,$17,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2819, [$62,$02,$95,$57,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2820, [$62,$02,$95,$37,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2821, [$62,$02,$95,$77,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2822, [$62,$62,$95,$27,$BB,$31                           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2823, [$62,$22,$95,$27,$BB,$B4,$F0,$34,$12,$00,$00       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2824, [$62,$62,$95,$27,$BB,$72,$7F                       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2825, [$62,$62,$95,$27,$BB,$B2,$00,$04,$00,$00           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2826, [$62,$62,$95,$27,$BB,$72,$80                       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2827, [$62,$62,$95,$27,$BB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2828, [$62,$02,$15,$27,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2829, [$62,$02,$15,$A7,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2830, [$62,$02,$15,$17,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2831, [$62,$02,$15,$57,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2832, [$62,$02,$15,$37,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2833, [$62,$02,$15,$77,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2834, [$62,$62,$15,$27,$BB,$31                           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2835, [$62,$22,$15,$27,$BB,$B4,$F0,$34,$12,$00,$00       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2836, [$62,$62,$15,$27,$BB,$72,$7F                       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2837, [$62,$62,$15,$27,$BB,$B2,$00,$02,$00,$00           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2838, [$62,$62,$15,$27,$BB,$72,$80                       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2839, [$62,$62,$15,$27,$BB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2840, [$62,$02,$95,$27,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2841, [$62,$02,$95,$A7,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2842, [$62,$02,$95,$17,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2843, [$62,$02,$95,$57,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2844, [$62,$02,$95,$37,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2845, [$62,$02,$95,$77,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2846, [$62,$62,$95,$27,$9D,$31                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(2847, [$62,$22,$95,$27,$9D,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2848, [$62,$62,$95,$27,$9D,$72,$7F                       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(2849, [$62,$62,$95,$27,$9D,$B2,$00,$04,$00,$00           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(2850, [$62,$62,$95,$27,$9D,$72,$80                       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(2851, [$62,$62,$95,$27,$9D,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(2852, [$62,$02,$15,$27,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2853, [$62,$02,$15,$A7,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2854, [$62,$02,$15,$17,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2855, [$62,$02,$15,$57,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2856, [$62,$02,$15,$37,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2857, [$62,$02,$15,$77,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2858, [$62,$62,$15,$27,$9D,$31                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(2859, [$62,$22,$15,$27,$9D,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2860, [$62,$62,$15,$27,$9D,$72,$7F                       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(2861, [$62,$62,$15,$27,$9D,$B2,$00,$02,$00,$00           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(2862, [$62,$62,$15,$27,$9D,$72,$80                       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(2863, [$62,$62,$15,$27,$9D,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(2864, [$62,$02,$95,$27,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2865, [$62,$02,$95,$A7,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2866, [$62,$02,$95,$17,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2867, [$62,$02,$95,$57,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2868, [$62,$02,$95,$37,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2869, [$62,$02,$95,$77,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2870, [$62,$62,$95,$27,$AD,$31                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(2871, [$62,$22,$95,$27,$AD,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2872, [$62,$62,$95,$27,$AD,$72,$7F                       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(2873, [$62,$62,$95,$27,$AD,$B2,$00,$04,$00,$00           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(2874, [$62,$62,$95,$27,$AD,$72,$80                       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(2875, [$62,$62,$95,$27,$AD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(2876, [$62,$02,$15,$27,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2877, [$62,$02,$15,$A7,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2878, [$62,$02,$15,$17,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2879, [$62,$02,$15,$57,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2880, [$62,$02,$15,$37,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2881, [$62,$02,$15,$77,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2882, [$62,$62,$15,$27,$AD,$31                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(2883, [$62,$22,$15,$27,$AD,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2884, [$62,$62,$15,$27,$AD,$72,$7F                       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(2885, [$62,$62,$15,$27,$AD,$B2,$00,$02,$00,$00           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(2886, [$62,$62,$15,$27,$AD,$72,$80                       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(2887, [$62,$62,$15,$27,$AD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(2888, [$62,$02,$95,$27,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2889, [$62,$02,$95,$A7,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2890, [$62,$02,$95,$17,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2891, [$62,$02,$95,$57,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2892, [$62,$02,$95,$37,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2893, [$62,$02,$95,$77,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2894, [$62,$62,$95,$27,$BD,$31                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(2895, [$62,$22,$95,$27,$BD,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2896, [$62,$62,$95,$27,$BD,$72,$7F                       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(2897, [$62,$62,$95,$27,$BD,$B2,$00,$04,$00,$00           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(2898, [$62,$62,$95,$27,$BD,$72,$80                       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(2899, [$62,$62,$95,$27,$BD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(2900, [$62,$02,$15,$27,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2901, [$62,$02,$15,$A7,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2902, [$62,$02,$15,$17,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2903, [$62,$02,$15,$57,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2904, [$62,$02,$15,$37,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2905, [$62,$02,$15,$77,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2906, [$62,$62,$15,$27,$BD,$31                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(2907, [$62,$22,$15,$27,$BD,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2908, [$62,$62,$15,$27,$BD,$72,$7F                       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(2909, [$62,$62,$15,$27,$BD,$B2,$00,$02,$00,$00           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(2910, [$62,$62,$15,$27,$BD,$72,$80                       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(2911, [$62,$62,$15,$27,$BD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(2912, [$62,$02,$95,$27,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2913, [$62,$02,$95,$A7,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2914, [$62,$02,$95,$17,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2915, [$62,$02,$95,$57,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2916, [$62,$02,$95,$37,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2917, [$62,$02,$95,$77,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2918, [$62,$62,$95,$27,$9F,$31                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(2919, [$62,$22,$95,$27,$9F,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2920, [$62,$62,$95,$27,$9F,$72,$7F                       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(2921, [$62,$62,$95,$27,$9F,$B2,$00,$04,$00,$00           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(2922, [$62,$62,$95,$27,$9F,$72,$80                       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(2923, [$62,$62,$95,$27,$9F,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(2924, [$62,$02,$15,$27,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2925, [$62,$02,$15,$A7,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2926, [$62,$02,$15,$17,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2927, [$62,$02,$15,$57,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2928, [$62,$02,$15,$37,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2929, [$62,$02,$15,$77,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2930, [$62,$62,$15,$27,$9F,$31                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(2931, [$62,$22,$15,$27,$9F,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2932, [$62,$62,$15,$27,$9F,$72,$7F                       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(2933, [$62,$62,$15,$27,$9F,$B2,$00,$02,$00,$00           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(2934, [$62,$62,$15,$27,$9F,$72,$80                       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(2935, [$62,$62,$15,$27,$9F,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(2936, [$62,$02,$95,$27,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2937, [$62,$02,$95,$A7,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2938, [$62,$02,$95,$17,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2939, [$62,$02,$95,$57,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2940, [$62,$02,$95,$37,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2941, [$62,$02,$95,$77,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2942, [$62,$62,$95,$27,$AF,$31                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(2943, [$62,$22,$95,$27,$AF,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2944, [$62,$62,$95,$27,$AF,$72,$7F                       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(2945, [$62,$62,$95,$27,$AF,$B2,$00,$04,$00,$00           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(2946, [$62,$62,$95,$27,$AF,$72,$80                       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(2947, [$62,$62,$95,$27,$AF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(2948, [$62,$02,$15,$27,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2949, [$62,$02,$15,$A7,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2950, [$62,$02,$15,$17,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2951, [$62,$02,$15,$57,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2952, [$62,$02,$15,$37,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2953, [$62,$02,$15,$77,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2954, [$62,$62,$15,$27,$AF,$31                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(2955, [$62,$22,$15,$27,$AF,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2956, [$62,$62,$15,$27,$AF,$72,$7F                       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(2957, [$62,$62,$15,$27,$AF,$B2,$00,$02,$00,$00           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(2958, [$62,$62,$15,$27,$AF,$72,$80                       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(2959, [$62,$62,$15,$27,$AF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(2960, [$62,$02,$95,$27,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2961, [$62,$02,$95,$A7,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2962, [$62,$02,$95,$17,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2963, [$62,$02,$95,$57,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2964, [$62,$02,$95,$37,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2965, [$62,$02,$95,$77,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2966, [$62,$62,$95,$27,$BF,$31                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(2967, [$62,$22,$95,$27,$BF,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2968, [$62,$62,$95,$27,$BF,$72,$7F                       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(2969, [$62,$62,$95,$27,$BF,$B2,$00,$04,$00,$00           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(2970, [$62,$62,$95,$27,$BF,$72,$80                       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(2971, [$62,$62,$95,$27,$BF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(2972, [$62,$02,$15,$27,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(2973, [$62,$02,$15,$A7,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(2974, [$62,$02,$15,$17,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(2975, [$62,$02,$15,$57,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(2976, [$62,$02,$15,$37,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(2977, [$62,$02,$15,$77,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(2978, [$62,$62,$15,$27,$BF,$31                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(2979, [$62,$22,$15,$27,$BF,$B4,$F0,$34,$12,$00,$00       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2980, [$62,$62,$15,$27,$BF,$72,$7F                       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(2981, [$62,$62,$15,$27,$BF,$B2,$00,$02,$00,$00           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(2982, [$62,$62,$15,$27,$BF,$72,$80                       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(2983, [$62,$62,$15,$27,$BF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(2984, [$62,$02,$95,$27,$43,$F4                           ] , 'vgetexpsd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(2985, [$62,$02,$95,$A7,$43,$F4                           ] , 'vgetexpsd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(2986, [$62,$02,$95,$17,$43,$F4                           ] , 'vgetexpsd  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2987, [$62,$62,$95,$27,$43,$31                           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2988, [$62,$22,$95,$27,$43,$B4,$F0,$34,$12,$00,$00       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(2989, [$62,$62,$95,$27,$43,$72,$7F                       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2990, [$62,$62,$95,$27,$43,$B2,$00,$04,$00,$00           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2991, [$62,$62,$95,$27,$43,$72,$80                       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2992, [$62,$62,$95,$27,$43,$B2,$F8,$FB,$FF,$FF           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2993, [$62,$02,$15,$27,$43,$F4                           ] , 'vgetexpss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(2994, [$62,$02,$15,$A7,$43,$F4                           ] , 'vgetexpss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(2995, [$62,$02,$15,$17,$43,$F4                           ] , 'vgetexpss  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2996, [$62,$62,$15,$27,$43,$31                           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2997, [$62,$22,$15,$27,$43,$B4,$F0,$34,$12,$00,$00       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(2998, [$62,$62,$15,$27,$43,$72,$7F                       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2999, [$62,$62,$15,$27,$43,$B2,$00,$02,$00,$00           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(3000, [$62,$62,$15,$27,$43,$72,$80                       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(3001, [$62,$62,$15,$27,$43,$B2,$FC,$FD,$FF,$FF           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(3002, [$62,$03,$95,$27,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,0xab'           );
  TestCase.testcase(3003, [$62,$03,$95,$A7,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7}{z},xmm29,xmm28,0xab'        );
  TestCase.testcase(3004, [$62,$03,$95,$17,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,{sae},0xab'     );
  TestCase.testcase(3005, [$62,$03,$95,$27,$27,$F4,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,0x7b'           );
  TestCase.testcase(3006, [$62,$03,$95,$17,$27,$F4,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,{sae},0x7b'     );
  TestCase.testcase(3007, [$62,$63,$95,$27,$27,$31,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rcx],0x7b'     );
  TestCase.testcase(3008, [$62,$23,$95,$27,$27,$B4,$F0,$34,$12,$00,$00,$7B   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(3009, [$62,$63,$95,$27,$27,$72,$7F,$7B                   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(3010, [$62,$63,$95,$27,$27,$B2,$00,$04,$00,$00,$7B       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(3011, [$62,$63,$95,$27,$27,$72,$80,$7B                   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(3012, [$62,$63,$95,$27,$27,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(3013, [$62,$03,$15,$27,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,0xab'           );
  TestCase.testcase(3014, [$62,$03,$15,$A7,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7}{z},xmm29,xmm28,0xab'        );
  TestCase.testcase(3015, [$62,$03,$15,$17,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,{sae},0xab'     );
  TestCase.testcase(3016, [$62,$03,$15,$27,$27,$F4,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,0x7b'           );
  TestCase.testcase(3017, [$62,$03,$15,$17,$27,$F4,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,{sae},0x7b'     );
  TestCase.testcase(3018, [$62,$63,$15,$27,$27,$31,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rcx],0x7b'     );
  TestCase.testcase(3019, [$62,$23,$15,$27,$27,$B4,$F0,$34,$12,$00,$00,$7B   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(3020, [$62,$63,$15,$27,$27,$72,$7F,$7B                   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(3021, [$62,$63,$15,$27,$27,$B2,$00,$02,$00,$00,$7B       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(3022, [$62,$63,$15,$27,$27,$72,$80,$7B                   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(3023, [$62,$63,$15,$27,$27,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.testcase(3024, [$62,$01,$97,$27,$5F,$F4                           ] , 'vmaxsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3025, [$62,$01,$97,$A7,$5F,$F4                           ] , 'vmaxsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3026, [$62,$01,$97,$17,$5F,$F4                           ] , 'vmaxsd  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(3027, [$62,$61,$97,$27,$5F,$31                           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(3028, [$62,$21,$97,$27,$5F,$B4,$F0,$34,$12,$00,$00       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3029, [$62,$61,$97,$27,$5F,$72,$7F                       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(3030, [$62,$61,$97,$27,$5F,$B2,$00,$04,$00,$00           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(3031, [$62,$61,$97,$27,$5F,$72,$80                       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(3032, [$62,$61,$97,$27,$5F,$B2,$F8,$FB,$FF,$FF           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(3033, [$62,$01,$16,$27,$5F,$F4                           ] , 'vmaxss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3034, [$62,$01,$16,$A7,$5F,$F4                           ] , 'vmaxss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3035, [$62,$01,$16,$17,$5F,$F4                           ] , 'vmaxss  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(3036, [$62,$61,$16,$27,$5F,$31                           ] , 'vmaxss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(3037, [$62,$21,$16,$27,$5F,$B4,$F0,$34,$12,$00,$00       ] , 'vmaxss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3038, [$62,$61,$16,$27,$5F,$72,$7F                       ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(3039, [$62,$61,$16,$27,$5F,$B2,$00,$02,$00,$00           ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(3040, [$62,$61,$16,$27,$5F,$72,$80                       ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(3041, [$62,$61,$16,$27,$5F,$B2,$FC,$FD,$FF,$FF           ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(3042, [$62,$01,$97,$27,$5D,$F4                           ] , 'vminsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3043, [$62,$01,$97,$A7,$5D,$F4                           ] , 'vminsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3044, [$62,$01,$97,$17,$5D,$F4                           ] , 'vminsd  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(3045, [$62,$61,$97,$27,$5D,$31                           ] , 'vminsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(3046, [$62,$21,$97,$27,$5D,$B4,$F0,$34,$12,$00,$00       ] , 'vminsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3047, [$62,$61,$97,$27,$5D,$72,$7F                       ] , 'vminsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(3048, [$62,$61,$97,$27,$5D,$B2,$00,$04,$00,$00           ] , 'vminsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(3049, [$62,$61,$97,$27,$5D,$72,$80                       ] , 'vminsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(3050, [$62,$61,$97,$27,$5D,$B2,$F8,$FB,$FF,$FF           ] , 'vminsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(3051, [$62,$01,$16,$27,$5D,$F4                           ] , 'vminss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3052, [$62,$01,$16,$A7,$5D,$F4                           ] , 'vminss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3053, [$62,$01,$16,$17,$5D,$F4                           ] , 'vminss  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(3054, [$62,$61,$16,$27,$5D,$31                           ] , 'vminss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(3055, [$62,$21,$16,$27,$5D,$B4,$F0,$34,$12,$00,$00       ] , 'vminss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3056, [$62,$61,$16,$27,$5D,$72,$7F                       ] , 'vminss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(3057, [$62,$61,$16,$27,$5D,$B2,$00,$02,$00,$00           ] , 'vminss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(3058, [$62,$61,$16,$27,$5D,$72,$80                       ] , 'vminss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(3059, [$62,$61,$16,$27,$5D,$B2,$FC,$FD,$FF,$FF           ] , 'vminss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(3060, [$62,$61,$FF,$2F,$10,$31                           ] , 'vmovsd  xmm30{k7},qword [rcx]'                    );
  TestCase.testcase(3061, [$62,$61,$FF,$AF,$10,$31                           ] , 'vmovsd  xmm30{k7}{z},qword [rcx]'                 );
  TestCase.testcase(3062, [$62,$21,$FF,$2F,$10,$B4,$F0,$34,$12,$00,$00       ] , 'vmovsd  xmm30{k7},qword [rax+r14*8+0x1234]'       );
  TestCase.testcase(3063, [$62,$61,$FF,$2F,$10,$72,$7F                       ] , 'vmovsd  xmm30{k7},qword [rdx+0x3f8]'              );
  TestCase.testcase(3064, [$62,$61,$FF,$2F,$10,$B2,$00,$04,$00,$00           ] , 'vmovsd  xmm30{k7},qword [rdx+0x400]'              );
  TestCase.testcase(3065, [$62,$61,$FF,$2F,$10,$72,$80                       ] , 'vmovsd  xmm30{k7},qword [rdx-0x400]'              );
  TestCase.testcase(3066, [$62,$61,$FF,$2F,$10,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  xmm30{k7},qword [rdx-0x408]'              );
  TestCase.testcase(3067, [$62,$61,$FF,$2F,$11,$31                           ] , 'vmovsd  qword [rcx]{k7},xmm30'                    );
  TestCase.testcase(3068, [$62,$21,$FF,$2F,$11,$B4,$F0,$34,$12,$00,$00       ] , 'vmovsd  qword [rax+r14*8+0x1234]{k7},xmm30'       );
  TestCase.testcase(3069, [$62,$61,$FF,$2F,$11,$72,$7F                       ] , 'vmovsd  qword [rdx+0x3f8]{k7},xmm30'              );
  TestCase.testcase(3070, [$62,$61,$FF,$2F,$11,$B2,$00,$04,$00,$00           ] , 'vmovsd  qword [rdx+0x400]{k7},xmm30'              );
  TestCase.testcase(3071, [$62,$61,$FF,$2F,$11,$72,$80                       ] , 'vmovsd  qword [rdx-0x400]{k7},xmm30'              );
  TestCase.testcase(3072, [$62,$61,$FF,$2F,$11,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  qword [rdx-0x408]{k7},xmm30'              );
  TestCase.testcase(3073, [$62,$01,$97,$27,$10,$F4                           ] , 'vmovsd  xmm30{k7},xmm29,ymm28'                    );
  TestCase.testcase(3074, [$62,$01,$97,$A7,$10,$F4                           ] , 'vmovsd  xmm30{k7}{z},xmm29,ymm28'                 );
  TestCase.testcase(3075, [$62,$61,$7E,$2F,$10,$31                           ] , 'vmovss  xmm30{k7},dword [rcx]'                    );
  TestCase.testcase(3076, [$62,$61,$7E,$AF,$10,$31                           ] , 'vmovss  xmm30{k7}{z},dword [rcx]'                 );
  TestCase.testcase(3077, [$62,$21,$7E,$2F,$10,$B4,$F0,$34,$12,$00,$00       ] , 'vmovss  xmm30{k7},dword [rax+r14*8+0x1234]'       );
  TestCase.testcase(3078, [$62,$61,$7E,$2F,$10,$72,$7F                       ] , 'vmovss  xmm30{k7},dword [rdx+0x1fc]'              );
  TestCase.testcase(3079, [$62,$61,$7E,$2F,$10,$B2,$00,$02,$00,$00           ] , 'vmovss  xmm30{k7},dword [rdx+0x200]'              );
  TestCase.testcase(3080, [$62,$61,$7E,$2F,$10,$72,$80                       ] , 'vmovss  xmm30{k7},dword [rdx-0x200]'              );
  TestCase.testcase(3081, [$62,$61,$7E,$2F,$10,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  xmm30{k7},dword [rdx-0x204]'              );
  TestCase.testcase(3082, [$62,$61,$7E,$2F,$11,$31                           ] , 'vmovss  dword [rcx]{k7},xmm30'                    );
  TestCase.testcase(3083, [$62,$21,$7E,$2F,$11,$B4,$F0,$34,$12,$00,$00       ] , 'vmovss  dword [rax+r14*8+0x1234]{k7},xmm30'       );
  TestCase.testcase(3084, [$62,$61,$7E,$2F,$11,$72,$7F                       ] , 'vmovss  dword [rdx+0x1fc]{k7},xmm30'              );
  TestCase.testcase(3085, [$62,$61,$7E,$2F,$11,$B2,$00,$02,$00,$00           ] , 'vmovss  dword [rdx+0x200]{k7},xmm30'              );
  TestCase.testcase(3086, [$62,$61,$7E,$2F,$11,$72,$80                       ] , 'vmovss  dword [rdx-0x200]{k7},xmm30'              );
  TestCase.testcase(3087, [$62,$61,$7E,$2F,$11,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  dword [rdx-0x204]{k7},xmm30'              );
  TestCase.testcase(3088, [$62,$01,$16,$27,$10,$F4                           ] , 'vmovss  xmm30{k7},xmm29,ymm28'                    );
  TestCase.testcase(3089, [$62,$01,$16,$A7,$10,$F4                           ] , 'vmovss  xmm30{k7}{z},xmm29,ymm28'                 );
  TestCase.testcase(3090, [$62,$01,$97,$27,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3091, [$62,$01,$97,$A7,$59,$F4                           ] , 'vmulsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3092, [$62,$01,$97,$17,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(3093, [$62,$01,$97,$57,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(3094, [$62,$01,$97,$37,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(3095, [$62,$01,$97,$77,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(3096, [$62,$61,$97,$27,$59,$31                           ] , 'vmulsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(3097, [$62,$21,$97,$27,$59,$B4,$F0,$34,$12,$00,$00       ] , 'vmulsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3098, [$62,$61,$97,$27,$59,$72,$7F                       ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(3099, [$62,$61,$97,$27,$59,$B2,$00,$04,$00,$00           ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(3100, [$62,$61,$97,$27,$59,$72,$80                       ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(3101, [$62,$61,$97,$27,$59,$B2,$F8,$FB,$FF,$FF           ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(3102, [$62,$01,$16,$27,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3103, [$62,$01,$16,$A7,$59,$F4                           ] , 'vmulss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3104, [$62,$01,$16,$17,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(3105, [$62,$01,$16,$57,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(3106, [$62,$01,$16,$37,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(3107, [$62,$01,$16,$77,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(3108, [$62,$61,$16,$27,$59,$31                           ] , 'vmulss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(3109, [$62,$21,$16,$27,$59,$B4,$F0,$34,$12,$00,$00       ] , 'vmulss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3110, [$62,$61,$16,$27,$59,$72,$7F                       ] , 'vmulss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(3111, [$62,$61,$16,$27,$59,$B2,$00,$02,$00,$00           ] , 'vmulss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(3112, [$62,$61,$16,$27,$59,$72,$80                       ] , 'vmulss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(3113, [$62,$61,$16,$27,$59,$B2,$FC,$FD,$FF,$FF           ] , 'vmulss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(3114, [$62,$02,$95,$27,$4D,$F4                           ] , 'vrcp14sd  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(3115, [$62,$02,$95,$A7,$4D,$F4                           ] , 'vrcp14sd  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(3116, [$62,$62,$95,$27,$4D,$31                           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(3117, [$62,$22,$95,$27,$4D,$B4,$F0,$34,$12,$00,$00       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3118, [$62,$62,$95,$27,$4D,$72,$7F                       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(3119, [$62,$62,$95,$27,$4D,$B2,$00,$04,$00,$00           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(3120, [$62,$62,$95,$27,$4D,$72,$80                       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(3121, [$62,$62,$95,$27,$4D,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(3122, [$62,$02,$15,$27,$4D,$F4                           ] , 'vrcp14ss  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(3123, [$62,$02,$15,$A7,$4D,$F4                           ] , 'vrcp14ss  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(3124, [$62,$62,$15,$27,$4D,$31                           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(3125, [$62,$22,$15,$27,$4D,$B4,$F0,$34,$12,$00,$00       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3126, [$62,$62,$15,$27,$4D,$72,$7F                       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(3127, [$62,$62,$15,$27,$4D,$B2,$00,$02,$00,$00           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(3128, [$62,$62,$15,$27,$4D,$72,$80                       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(3129, [$62,$62,$15,$27,$4D,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(3130, [$62,$02,$15,$27,$CB,$F4                           ] , 'vrcp28ss  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(3131, [$62,$02,$15,$A7,$CB,$F4                           ] , 'vrcp28ss  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(3132, [$62,$02,$15,$17,$CB,$F4                           ] , 'vrcp28ss  xmm30{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(3133, [$62,$62,$15,$27,$CB,$31                           ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(3134, [$62,$22,$15,$27,$CB,$B4,$F0,$34,$12,$00,$00       ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3135, [$62,$62,$15,$27,$CB,$72,$7F                       ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(3136, [$62,$62,$15,$27,$CB,$B2,$00,$02,$00,$00           ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(3137, [$62,$62,$15,$27,$CB,$72,$80                       ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(3138, [$62,$62,$15,$27,$CB,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp28ss  xmm30{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(3139, [$62,$02,$95,$27,$CB,$F4                           ] , 'vrcp28sd  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(3140, [$62,$02,$95,$A7,$CB,$F4                           ] , 'vrcp28sd  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(3141, [$62,$02,$95,$17,$CB,$F4                           ] , 'vrcp28sd  xmm30{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(3142, [$62,$62,$95,$27,$CB,$31                           ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(3143, [$62,$22,$95,$27,$CB,$B4,$F0,$34,$12,$00,$00       ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3144, [$62,$62,$95,$27,$CB,$72,$7F                       ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(3145, [$62,$62,$95,$27,$CB,$B2,$00,$04,$00,$00           ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(3146, [$62,$62,$95,$27,$CB,$72,$80                       ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(3147, [$62,$62,$95,$27,$CB,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp28sd  xmm30{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(3148, [$62,$02,$95,$27,$4F,$F4                           ] , 'vrsqrt14sd  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(3149, [$62,$02,$95,$A7,$4F,$F4                           ] , 'vrsqrt14sd  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(3150, [$62,$62,$95,$27,$4F,$31                           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rcx]'          );
  TestCase.testcase(3151, [$62,$22,$95,$27,$4F,$B4,$F0,$34,$12,$00,$00       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3152, [$62,$62,$95,$27,$4F,$72,$7F                       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'    );
  TestCase.testcase(3153, [$62,$62,$95,$27,$4F,$B2,$00,$04,$00,$00           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx+0x400]'    );
  TestCase.testcase(3154, [$62,$62,$95,$27,$4F,$72,$80                       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx-0x400]'    );
  TestCase.testcase(3155, [$62,$62,$95,$27,$4F,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx-0x408]'    );
  TestCase.testcase(3156, [$62,$02,$15,$27,$4F,$F4                           ] , 'vrsqrt14ss  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(3157, [$62,$02,$15,$A7,$4F,$F4                           ] , 'vrsqrt14ss  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(3158, [$62,$62,$15,$27,$4F,$31                           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rcx]'          );
  TestCase.testcase(3159, [$62,$22,$15,$27,$4F,$B4,$F0,$34,$12,$00,$00       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3160, [$62,$62,$15,$27,$4F,$72,$7F                       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'    );
  TestCase.testcase(3161, [$62,$62,$15,$27,$4F,$B2,$00,$02,$00,$00           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx+0x200]'    );
  TestCase.testcase(3162, [$62,$62,$15,$27,$4F,$72,$80                       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx-0x200]'    );
  TestCase.testcase(3163, [$62,$62,$15,$27,$4F,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx-0x204]'    );
  TestCase.testcase(3164, [$62,$02,$15,$27,$CD,$F4                           ] , 'vrsqrt28ss  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(3165, [$62,$02,$15,$A7,$CD,$F4                           ] , 'vrsqrt28ss  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(3166, [$62,$02,$15,$17,$CD,$F4                           ] , 'vrsqrt28ss  xmm30{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(3167, [$62,$62,$15,$27,$CD,$31                           ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rcx]'          );
  TestCase.testcase(3168, [$62,$22,$15,$27,$CD,$B4,$F0,$34,$12,$00,$00       ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3169, [$62,$62,$15,$27,$CD,$72,$7F                       ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'    );
  TestCase.testcase(3170, [$62,$62,$15,$27,$CD,$B2,$00,$02,$00,$00           ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rdx+0x200]'    );
  TestCase.testcase(3171, [$62,$62,$15,$27,$CD,$72,$80                       ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rdx-0x200]'    );
  TestCase.testcase(3172, [$62,$62,$15,$27,$CD,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt28ss  xmm30{k7},xmm29,dword [rdx-0x204]'    );
  TestCase.testcase(3173, [$62,$02,$95,$27,$CD,$F4                           ] , 'vrsqrt28sd  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(3174, [$62,$02,$95,$A7,$CD,$F4                           ] , 'vrsqrt28sd  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(3175, [$62,$02,$95,$17,$CD,$F4                           ] , 'vrsqrt28sd  xmm30{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(3176, [$62,$62,$95,$27,$CD,$31                           ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rcx]'          );
  TestCase.testcase(3177, [$62,$22,$95,$27,$CD,$B4,$F0,$34,$12,$00,$00       ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3178, [$62,$62,$95,$27,$CD,$72,$7F                       ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'    );
  TestCase.testcase(3179, [$62,$62,$95,$27,$CD,$B2,$00,$04,$00,$00           ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rdx+0x400]'    );
  TestCase.testcase(3180, [$62,$62,$95,$27,$CD,$72,$80                       ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rdx-0x400]'    );
  TestCase.testcase(3181, [$62,$62,$95,$27,$CD,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt28sd  xmm30{k7},xmm29,qword [rdx-0x408]'    );
  TestCase.testcase(3182, [$62,$01,$97,$27,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28'                   );
  TestCase.testcase(3183, [$62,$01,$97,$A7,$51,$F4                           ] , 'vsqrtsd  xmm30{k7}{z},xmm29,xmm28'                );
  TestCase.testcase(3184, [$62,$01,$97,$17,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rn-sae}'          );
  TestCase.testcase(3185, [$62,$01,$97,$57,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{ru-sae}'          );
  TestCase.testcase(3186, [$62,$01,$97,$37,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rd-sae}'          );
  TestCase.testcase(3187, [$62,$01,$97,$77,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rz-sae}'          );
  TestCase.testcase(3188, [$62,$61,$97,$27,$51,$31                           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rcx]'             );
  TestCase.testcase(3189, [$62,$21,$97,$27,$51,$B4,$F0,$34,$12,$00,$00       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3190, [$62,$61,$97,$27,$51,$72,$7F                       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'       );
  TestCase.testcase(3191, [$62,$61,$97,$27,$51,$B2,$00,$04,$00,$00           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx+0x400]'       );
  TestCase.testcase(3192, [$62,$61,$97,$27,$51,$72,$80                       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx-0x400]'       );
  TestCase.testcase(3193, [$62,$61,$97,$27,$51,$B2,$F8,$FB,$FF,$FF           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx-0x408]'       );
  TestCase.testcase(3194, [$62,$01,$16,$27,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28'                   );
  TestCase.testcase(3195, [$62,$01,$16,$A7,$51,$F4                           ] , 'vsqrtss  xmm30{k7}{z},xmm29,xmm28'                );
  TestCase.testcase(3196, [$62,$01,$16,$17,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rn-sae}'          );
  TestCase.testcase(3197, [$62,$01,$16,$57,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{ru-sae}'          );
  TestCase.testcase(3198, [$62,$01,$16,$37,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rd-sae}'          );
  TestCase.testcase(3199, [$62,$01,$16,$77,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rz-sae}'          );
  TestCase.testcase(3200, [$62,$61,$16,$27,$51,$31                           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rcx]'             );
  TestCase.testcase(3201, [$62,$21,$16,$27,$51,$B4,$F0,$34,$12,$00,$00       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3202, [$62,$61,$16,$27,$51,$72,$7F                       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx+0x1fc]'       );
  TestCase.testcase(3203, [$62,$61,$16,$27,$51,$B2,$00,$02,$00,$00           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx+0x200]'       );
  TestCase.testcase(3204, [$62,$61,$16,$27,$51,$72,$80                       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx-0x200]'       );
  TestCase.testcase(3205, [$62,$61,$16,$27,$51,$B2,$FC,$FD,$FF,$FF           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx-0x204]'       );
  TestCase.testcase(3206, [$62,$01,$97,$27,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3207, [$62,$01,$97,$A7,$5C,$F4                           ] , 'vsubsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3208, [$62,$01,$97,$17,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(3209, [$62,$01,$97,$57,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(3210, [$62,$01,$97,$37,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(3211, [$62,$01,$97,$77,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(3212, [$62,$61,$97,$27,$5C,$31                           ] , 'vsubsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(3213, [$62,$21,$97,$27,$5C,$B4,$F0,$34,$12,$00,$00       ] , 'vsubsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3214, [$62,$61,$97,$27,$5C,$72,$7F                       ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(3215, [$62,$61,$97,$27,$5C,$B2,$00,$04,$00,$00           ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(3216, [$62,$61,$97,$27,$5C,$72,$80                       ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(3217, [$62,$61,$97,$27,$5C,$B2,$F8,$FB,$FF,$FF           ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(3218, [$62,$01,$16,$27,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3219, [$62,$01,$16,$A7,$5C,$F4                           ] , 'vsubss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3220, [$62,$01,$16,$17,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(3221, [$62,$01,$16,$57,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(3222, [$62,$01,$16,$37,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(3223, [$62,$01,$16,$77,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(3224, [$62,$61,$16,$27,$5C,$31                           ] , 'vsubss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(3225, [$62,$21,$16,$27,$5C,$B4,$F0,$34,$12,$00,$00       ] , 'vsubss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3226, [$62,$61,$16,$27,$5C,$72,$7F                       ] , 'vsubss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(3227, [$62,$61,$16,$27,$5C,$B2,$00,$02,$00,$00           ] , 'vsubss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(3228, [$62,$61,$16,$27,$5C,$72,$80                       ] , 'vsubss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(3229, [$62,$61,$16,$27,$5C,$B2,$FC,$FD,$FF,$FF           ] , 'vsubss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(3230, [$62,$01,$FD,$28,$2E,$F5                           ] , 'vucomisd  xmm30,xmm29'                            );
  TestCase.testcase(3231, [$62,$01,$FD,$18,$2E,$F5                           ] , 'vucomisd  xmm30,xmm29,{sae}'                      );
  TestCase.testcase(3232, [$62,$61,$FD,$28,$2E,$31                           ] , 'vucomisd  xmm30,qword [rcx]'                      );
  TestCase.testcase(3233, [$62,$21,$FD,$28,$2E,$B4,$F0,$34,$12,$00,$00       ] , 'vucomisd  xmm30,qword [rax+r14*8+0x1234]'         );
  TestCase.testcase(3234, [$62,$61,$FD,$28,$2E,$72,$7F                       ] , 'vucomisd  xmm30,qword [rdx+0x3f8]'                );
  TestCase.testcase(3235, [$62,$61,$FD,$28,$2E,$B2,$00,$04,$00,$00           ] , 'vucomisd  xmm30,qword [rdx+0x400]'                );
  TestCase.testcase(3236, [$62,$61,$FD,$28,$2E,$72,$80                       ] , 'vucomisd  xmm30,qword [rdx-0x400]'                );
  TestCase.testcase(3237, [$62,$61,$FD,$28,$2E,$B2,$F8,$FB,$FF,$FF           ] , 'vucomisd  xmm30,qword [rdx-0x408]'                );
  TestCase.testcase(3238, [$62,$01,$7C,$28,$2E,$F5                           ] , 'vucomiss  xmm30,xmm29'                            );
  TestCase.testcase(3239, [$62,$01,$7C,$18,$2E,$F5                           ] , 'vucomiss  xmm30,xmm29,{sae}'                      );
  TestCase.testcase(3240, [$62,$61,$7C,$28,$2E,$31                           ] , 'vucomiss  xmm30,dword [rcx]'                      );
  TestCase.testcase(3241, [$62,$21,$7C,$28,$2E,$B4,$F0,$34,$12,$00,$00       ] , 'vucomiss  xmm30,dword [rax+r14*8+0x1234]'         );
  TestCase.testcase(3242, [$62,$61,$7C,$28,$2E,$72,$7F                       ] , 'vucomiss  xmm30,dword [rdx+0x1fc]'                );
  TestCase.testcase(3243, [$62,$61,$7C,$28,$2E,$B2,$00,$02,$00,$00           ] , 'vucomiss  xmm30,dword [rdx+0x200]'                );
  TestCase.testcase(3244, [$62,$61,$7C,$28,$2E,$72,$80                       ] , 'vucomiss  xmm30,dword [rdx-0x200]'                );
  TestCase.testcase(3245, [$62,$61,$7C,$28,$2E,$B2,$FC,$FD,$FF,$FF           ] , 'vucomiss  xmm30,dword [rdx-0x204]'                );
  TestCase.testcase(3246, [$62,$91,$7F,$28,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30'                            );
  TestCase.testcase(3247, [$62,$91,$7F,$18,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rn-sae}'                   );
  TestCase.testcase(3248, [$62,$91,$7F,$58,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{ru-sae}'                   );
  TestCase.testcase(3249, [$62,$91,$7F,$38,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rd-sae}'                   );
  TestCase.testcase(3250, [$62,$91,$7F,$78,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rz-sae}'                   );
  TestCase.testcase(3251, [$62,$F1,$7F,$28,$79,$01                           ] , 'vcvtsd2usi  eax,qword [rcx]'                      );
  TestCase.testcase(3252, [$62,$B1,$7F,$28,$79,$84,$F0,$34,$12,$00,$00       ] , 'vcvtsd2usi  eax,qword [rax+r14*8+0x1234]'         );
  TestCase.testcase(3253, [$62,$F1,$7F,$28,$79,$42,$7F                       ] , 'vcvtsd2usi  eax,qword [rdx+0x3f8]'                );
  TestCase.testcase(3254, [$62,$F1,$7F,$28,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  eax,qword [rdx+0x400]'                );
  TestCase.testcase(3255, [$62,$F1,$7F,$28,$79,$42,$80                       ] , 'vcvtsd2usi  eax,qword [rdx-0x400]'                );
  TestCase.testcase(3256, [$62,$F1,$7F,$28,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  eax,qword [rdx-0x408]'                );
  TestCase.testcase(3257, [$62,$91,$7F,$28,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30'                            );
  TestCase.testcase(3258, [$62,$91,$7F,$18,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rn-sae}'                   );
  TestCase.testcase(3259, [$62,$91,$7F,$58,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{ru-sae}'                   );
  TestCase.testcase(3260, [$62,$91,$7F,$38,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rd-sae}'                   );
  TestCase.testcase(3261, [$62,$91,$7F,$78,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rz-sae}'                   );
  TestCase.testcase(3262, [$62,$F1,$7F,$28,$79,$29                           ] , 'vcvtsd2usi  ebp,qword [rcx]'                      );
  TestCase.testcase(3263, [$62,$B1,$7F,$28,$79,$AC,$F0,$34,$12,$00,$00       ] , 'vcvtsd2usi  ebp,qword [rax+r14*8+0x1234]'         );
  TestCase.testcase(3264, [$62,$F1,$7F,$28,$79,$6A,$7F                       ] , 'vcvtsd2usi  ebp,qword [rdx+0x3f8]'                );
  TestCase.testcase(3265, [$62,$F1,$7F,$28,$79,$AA,$00,$04,$00,$00           ] , 'vcvtsd2usi  ebp,qword [rdx+0x400]'                );
  TestCase.testcase(3266, [$62,$F1,$7F,$28,$79,$6A,$80                       ] , 'vcvtsd2usi  ebp,qword [rdx-0x400]'                );
  TestCase.testcase(3267, [$62,$F1,$7F,$28,$79,$AA,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  ebp,qword [rdx-0x408]'                );
  TestCase.testcase(3268, [$62,$11,$7F,$28,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30'                           );
  TestCase.testcase(3269, [$62,$11,$7F,$18,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rn-sae}'                  );
  TestCase.testcase(3270, [$62,$11,$7F,$58,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{ru-sae}'                  );
  TestCase.testcase(3271, [$62,$11,$7F,$38,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rd-sae}'                  );
  TestCase.testcase(3272, [$62,$11,$7F,$78,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rz-sae}'                  );
  TestCase.testcase(3273, [$62,$71,$7F,$28,$79,$29                           ] , 'vcvtsd2usi  r13d,qword [rcx]'                     );
  TestCase.testcase(3274, [$62,$31,$7F,$28,$79,$AC,$F0,$34,$12,$00,$00       ] , 'vcvtsd2usi  r13d,qword [rax+r14*8+0x1234]'        );
  TestCase.testcase(3275, [$62,$71,$7F,$28,$79,$6A,$7F                       ] , 'vcvtsd2usi  r13d,qword [rdx+0x3f8]'               );
  TestCase.testcase(3276, [$62,$71,$7F,$28,$79,$AA,$00,$04,$00,$00           ] , 'vcvtsd2usi  r13d,qword [rdx+0x400]'               );
  TestCase.testcase(3277, [$62,$71,$7F,$28,$79,$6A,$80                       ] , 'vcvtsd2usi  r13d,qword [rdx-0x400]'               );
  TestCase.testcase(3278, [$62,$71,$7F,$28,$79,$AA,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  r13d,qword [rdx-0x408]'               );
  TestCase.testcase(3279, [$62,$91,$FF,$28,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30'                            );
  TestCase.testcase(3280, [$62,$91,$FF,$18,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rn-sae}'                   );
  TestCase.testcase(3281, [$62,$91,$FF,$58,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{ru-sae}'                   );
  TestCase.testcase(3282, [$62,$91,$FF,$38,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rd-sae}'                   );
  TestCase.testcase(3283, [$62,$91,$FF,$78,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rz-sae}'                   );
  TestCase.testcase(3284, [$62,$F1,$FF,$28,$79,$01                           ] , 'vcvtsd2usi  rax,qword [rcx]'                      );
  TestCase.testcase(3285, [$62,$B1,$FF,$28,$79,$84,$F0,$34,$12,$00,$00       ] , 'vcvtsd2usi  rax,qword [rax+r14*8+0x1234]'         );
  TestCase.testcase(3286, [$62,$F1,$FF,$28,$79,$42,$7F                       ] , 'vcvtsd2usi  rax,qword [rdx+0x3f8]'                );
  TestCase.testcase(3287, [$62,$F1,$FF,$28,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  rax,qword [rdx+0x400]'                );
  TestCase.testcase(3288, [$62,$F1,$FF,$28,$79,$42,$80                       ] , 'vcvtsd2usi  rax,qword [rdx-0x400]'                );
  TestCase.testcase(3289, [$62,$F1,$FF,$28,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  rax,qword [rdx-0x408]'                );
  TestCase.testcase(3290, [$62,$11,$FF,$28,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30'                             );
  TestCase.testcase(3291, [$62,$11,$FF,$18,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rn-sae}'                    );
  TestCase.testcase(3292, [$62,$11,$FF,$58,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{ru-sae}'                    );
  TestCase.testcase(3293, [$62,$11,$FF,$38,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rd-sae}'                    );
  TestCase.testcase(3294, [$62,$11,$FF,$78,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rz-sae}'                    );
  TestCase.testcase(3295, [$62,$71,$FF,$28,$79,$01                           ] , 'vcvtsd2usi  r8,qword [rcx]'                       );
  TestCase.testcase(3296, [$62,$31,$FF,$28,$79,$84,$F0,$34,$12,$00,$00       ] , 'vcvtsd2usi  r8,qword [rax+r14*8+0x1234]'          );
  TestCase.testcase(3297, [$62,$71,$FF,$28,$79,$42,$7F                       ] , 'vcvtsd2usi  r8,qword [rdx+0x3f8]'                 );
  TestCase.testcase(3298, [$62,$71,$FF,$28,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  r8,qword [rdx+0x400]'                 );
  TestCase.testcase(3299, [$62,$71,$FF,$28,$79,$42,$80                       ] , 'vcvtsd2usi  r8,qword [rdx-0x400]'                 );
  TestCase.testcase(3300, [$62,$71,$FF,$28,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  r8,qword [rdx-0x408]'                 );
  TestCase.testcase(3301, [$62,$91,$7E,$28,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30'                            );
  TestCase.testcase(3302, [$62,$91,$7E,$18,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rn-sae}'                   );
  TestCase.testcase(3303, [$62,$91,$7E,$58,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{ru-sae}'                   );
  TestCase.testcase(3304, [$62,$91,$7E,$38,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rd-sae}'                   );
  TestCase.testcase(3305, [$62,$91,$7E,$78,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rz-sae}'                   );
  TestCase.testcase(3306, [$62,$F1,$7E,$28,$79,$01                           ] , 'vcvtss2usi  eax,dword [rcx]'                      );
  TestCase.testcase(3307, [$62,$B1,$7E,$28,$79,$84,$F0,$34,$12,$00,$00       ] , 'vcvtss2usi  eax,dword [rax+r14*8+0x1234]'         );
  TestCase.testcase(3308, [$62,$F1,$7E,$28,$79,$42,$7F                       ] , 'vcvtss2usi  eax,dword [rdx+0x1fc]'                );
  TestCase.testcase(3309, [$62,$F1,$7E,$28,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  eax,dword [rdx+0x200]'                );
  TestCase.testcase(3310, [$62,$F1,$7E,$28,$79,$42,$80                       ] , 'vcvtss2usi  eax,dword [rdx-0x200]'                );
  TestCase.testcase(3311, [$62,$F1,$7E,$28,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  eax,dword [rdx-0x204]'                );
  TestCase.testcase(3312, [$62,$91,$7E,$28,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30'                            );
  TestCase.testcase(3313, [$62,$91,$7E,$18,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rn-sae}'                   );
  TestCase.testcase(3314, [$62,$91,$7E,$58,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{ru-sae}'                   );
  TestCase.testcase(3315, [$62,$91,$7E,$38,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rd-sae}'                   );
  TestCase.testcase(3316, [$62,$91,$7E,$78,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rz-sae}'                   );
  TestCase.testcase(3317, [$62,$F1,$7E,$28,$79,$29                           ] , 'vcvtss2usi  ebp,dword [rcx]'                      );
  TestCase.testcase(3318, [$62,$B1,$7E,$28,$79,$AC,$F0,$34,$12,$00,$00       ] , 'vcvtss2usi  ebp,dword [rax+r14*8+0x1234]'         );
  TestCase.testcase(3319, [$62,$F1,$7E,$28,$79,$6A,$7F                       ] , 'vcvtss2usi  ebp,dword [rdx+0x1fc]'                );
  TestCase.testcase(3320, [$62,$F1,$7E,$28,$79,$AA,$00,$02,$00,$00           ] , 'vcvtss2usi  ebp,dword [rdx+0x200]'                );
  TestCase.testcase(3321, [$62,$F1,$7E,$28,$79,$6A,$80                       ] , 'vcvtss2usi  ebp,dword [rdx-0x200]'                );
  TestCase.testcase(3322, [$62,$F1,$7E,$28,$79,$AA,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  ebp,dword [rdx-0x204]'                );
  TestCase.testcase(3323, [$62,$11,$7E,$28,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30'                           );
  TestCase.testcase(3324, [$62,$11,$7E,$18,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rn-sae}'                  );
  TestCase.testcase(3325, [$62,$11,$7E,$58,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{ru-sae}'                  );
  TestCase.testcase(3326, [$62,$11,$7E,$38,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rd-sae}'                  );
  TestCase.testcase(3327, [$62,$11,$7E,$78,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rz-sae}'                  );
  TestCase.testcase(3328, [$62,$71,$7E,$28,$79,$29                           ] , 'vcvtss2usi  r13d,dword [rcx]'                     );
  TestCase.testcase(3329, [$62,$31,$7E,$28,$79,$AC,$F0,$34,$12,$00,$00       ] , 'vcvtss2usi  r13d,dword [rax+r14*8+0x1234]'        );
  TestCase.testcase(3330, [$62,$71,$7E,$28,$79,$6A,$7F                       ] , 'vcvtss2usi  r13d,dword [rdx+0x1fc]'               );
  TestCase.testcase(3331, [$62,$71,$7E,$28,$79,$AA,$00,$02,$00,$00           ] , 'vcvtss2usi  r13d,dword [rdx+0x200]'               );
  TestCase.testcase(3332, [$62,$71,$7E,$28,$79,$6A,$80                       ] , 'vcvtss2usi  r13d,dword [rdx-0x200]'               );
  TestCase.testcase(3333, [$62,$71,$7E,$28,$79,$AA,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  r13d,dword [rdx-0x204]'               );
  TestCase.testcase(3334, [$62,$91,$FE,$28,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30'                            );
  TestCase.testcase(3335, [$62,$91,$FE,$18,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rn-sae}'                   );
  TestCase.testcase(3336, [$62,$91,$FE,$58,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{ru-sae}'                   );
  TestCase.testcase(3337, [$62,$91,$FE,$38,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rd-sae}'                   );
  TestCase.testcase(3338, [$62,$91,$FE,$78,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rz-sae}'                   );
  TestCase.testcase(3339, [$62,$F1,$FE,$28,$79,$01                           ] , 'vcvtss2usi  rax,dword [rcx]'                      );
  TestCase.testcase(3340, [$62,$B1,$FE,$28,$79,$84,$F0,$34,$12,$00,$00       ] , 'vcvtss2usi  rax,dword [rax+r14*8+0x1234]'         );
  TestCase.testcase(3341, [$62,$F1,$FE,$28,$79,$42,$7F                       ] , 'vcvtss2usi  rax,dword [rdx+0x1fc]'                );
  TestCase.testcase(3342, [$62,$F1,$FE,$28,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  rax,dword [rdx+0x200]'                );
  TestCase.testcase(3343, [$62,$F1,$FE,$28,$79,$42,$80                       ] , 'vcvtss2usi  rax,dword [rdx-0x200]'                );
  TestCase.testcase(3344, [$62,$F1,$FE,$28,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  rax,dword [rdx-0x204]'                );
  TestCase.testcase(3345, [$62,$11,$FE,$28,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30'                             );
  TestCase.testcase(3346, [$62,$11,$FE,$18,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rn-sae}'                    );
  TestCase.testcase(3347, [$62,$11,$FE,$58,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{ru-sae}'                    );
  TestCase.testcase(3348, [$62,$11,$FE,$38,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rd-sae}'                    );
  TestCase.testcase(3349, [$62,$11,$FE,$78,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rz-sae}'                    );
  TestCase.testcase(3350, [$62,$71,$FE,$28,$79,$01                           ] , 'vcvtss2usi  r8,dword [rcx]'                       );
  TestCase.testcase(3351, [$62,$31,$FE,$28,$79,$84,$F0,$34,$12,$00,$00       ] , 'vcvtss2usi  r8,dword [rax+r14*8+0x1234]'          );
  TestCase.testcase(3352, [$62,$71,$FE,$28,$79,$42,$7F                       ] , 'vcvtss2usi  r8,dword [rdx+0x1fc]'                 );
  TestCase.testcase(3353, [$62,$71,$FE,$28,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  r8,dword [rdx+0x200]'                 );
  TestCase.testcase(3354, [$62,$71,$FE,$28,$79,$42,$80                       ] , 'vcvtss2usi  r8,dword [rdx-0x200]'                 );
  TestCase.testcase(3355, [$62,$71,$FE,$28,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  r8,dword [rdx-0x204]'                 );
  TestCase.testcase(3356, [$62,$61,$17,$20,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,eax'                      );
  TestCase.testcase(3357, [$62,$61,$17,$20,$7B,$F5                           ] , 'vcvtusi2sd  xmm30,xmm29,ebp'                      );
  TestCase.testcase(3358, [$62,$41,$17,$20,$7B,$F5                           ] , 'vcvtusi2sd  xmm30,xmm29,r13d'                     );
  TestCase.testcase(3359, [$62,$61,$17,$20,$7B,$31                           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rcx]'              );
  TestCase.testcase(3360, [$62,$21,$17,$20,$7B,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3361, [$62,$61,$17,$20,$7B,$72,$7F                       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(3362, [$62,$61,$17,$20,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(3363, [$62,$61,$17,$20,$7B,$72,$80                       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(3364, [$62,$61,$17,$20,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(3365, [$62,$61,$97,$20,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,rax'                      );
  TestCase.testcase(3366, [$62,$61,$97,$10,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rn-sae},rax'             );
  TestCase.testcase(3367, [$62,$61,$97,$50,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{ru-sae},rax'             );
  TestCase.testcase(3368, [$62,$61,$97,$30,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rd-sae},rax'             );
  TestCase.testcase(3369, [$62,$61,$97,$70,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rz-sae},rax'             );
  TestCase.testcase(3370, [$62,$41,$97,$20,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,r8'                       );
  TestCase.testcase(3371, [$62,$41,$97,$10,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rn-sae},r8'              );
  TestCase.testcase(3372, [$62,$41,$97,$50,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{ru-sae},r8'              );
  TestCase.testcase(3373, [$62,$41,$97,$30,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rd-sae},r8'              );
  TestCase.testcase(3374, [$62,$41,$97,$70,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rz-sae},r8'              );
  TestCase.testcase(3375, [$62,$61,$97,$20,$7B,$31                           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rcx]'              );
  TestCase.testcase(3376, [$62,$21,$97,$20,$7B,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3377, [$62,$61,$97,$20,$7B,$72,$7F                       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(3378, [$62,$61,$97,$20,$7B,$B2,$00,$04,$00,$00           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(3379, [$62,$61,$97,$20,$7B,$72,$80                       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(3380, [$62,$61,$97,$20,$7B,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(3381, [$62,$61,$16,$20,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,eax'                      );
  TestCase.testcase(3382, [$62,$61,$16,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},eax'             );
  TestCase.testcase(3383, [$62,$61,$16,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},eax'             );
  TestCase.testcase(3384, [$62,$61,$16,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},eax'             );
  TestCase.testcase(3385, [$62,$61,$16,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},eax'             );
  TestCase.testcase(3386, [$62,$61,$16,$20,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,ebp'                      );
  TestCase.testcase(3387, [$62,$61,$16,$10,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},ebp'             );
  TestCase.testcase(3388, [$62,$61,$16,$50,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},ebp'             );
  TestCase.testcase(3389, [$62,$61,$16,$30,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},ebp'             );
  TestCase.testcase(3390, [$62,$61,$16,$70,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},ebp'             );
  TestCase.testcase(3391, [$62,$41,$16,$20,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,r13d'                     );
  TestCase.testcase(3392, [$62,$41,$16,$10,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},r13d'            );
  TestCase.testcase(3393, [$62,$41,$16,$50,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},r13d'            );
  TestCase.testcase(3394, [$62,$41,$16,$30,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},r13d'            );
  TestCase.testcase(3395, [$62,$41,$16,$70,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},r13d'            );
  TestCase.testcase(3396, [$62,$61,$16,$20,$7B,$31                           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rcx]'              );
  TestCase.testcase(3397, [$62,$21,$16,$20,$7B,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3398, [$62,$61,$16,$20,$7B,$72,$7F                       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(3399, [$62,$61,$16,$20,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(3400, [$62,$61,$16,$20,$7B,$72,$80                       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(3401, [$62,$61,$16,$20,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(3402, [$62,$61,$96,$20,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,rax'                      );
  TestCase.testcase(3403, [$62,$61,$96,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},rax'             );
  TestCase.testcase(3404, [$62,$61,$96,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},rax'             );
  TestCase.testcase(3405, [$62,$61,$96,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},rax'             );
  TestCase.testcase(3406, [$62,$61,$96,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},rax'             );
  TestCase.testcase(3407, [$62,$41,$96,$20,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,r8'                       );
  TestCase.testcase(3408, [$62,$41,$96,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},r8'              );
  TestCase.testcase(3409, [$62,$41,$96,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},r8'              );
  TestCase.testcase(3410, [$62,$41,$96,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},r8'              );
  TestCase.testcase(3411, [$62,$41,$96,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},r8'              );
  TestCase.testcase(3412, [$62,$61,$96,$20,$7B,$31                           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rcx]'              );
  TestCase.testcase(3413, [$62,$21,$96,$20,$7B,$B4,$F0,$34,$12,$00,$00       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3414, [$62,$61,$96,$20,$7B,$72,$7F                       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(3415, [$62,$61,$96,$20,$7B,$B2,$00,$04,$00,$00           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(3416, [$62,$61,$96,$20,$7B,$72,$80                       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(3417, [$62,$61,$96,$20,$7B,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(3418, [$62,$02,$95,$27,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(3419, [$62,$02,$95,$A7,$2D,$F4                           ] , 'vscalefsd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(3420, [$62,$02,$95,$17,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(3421, [$62,$02,$95,$57,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(3422, [$62,$02,$95,$37,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(3423, [$62,$02,$95,$77,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(3424, [$62,$62,$95,$27,$2D,$31                           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(3425, [$62,$22,$95,$27,$2D,$B4,$F0,$34,$12,$00,$00       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(3426, [$62,$62,$95,$27,$2D,$72,$7F                       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(3427, [$62,$62,$95,$27,$2D,$B2,$00,$04,$00,$00           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(3428, [$62,$62,$95,$27,$2D,$72,$80                       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(3429, [$62,$62,$95,$27,$2D,$B2,$F8,$FB,$FF,$FF           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(3430, [$62,$02,$15,$27,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(3431, [$62,$02,$15,$A7,$2D,$F4                           ] , 'vscalefss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(3432, [$62,$02,$15,$17,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(3433, [$62,$02,$15,$57,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(3434, [$62,$02,$15,$37,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(3435, [$62,$02,$15,$77,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(3436, [$62,$62,$15,$27,$2D,$31                           ] , 'vscalefss  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(3437, [$62,$22,$15,$27,$2D,$B4,$F0,$34,$12,$00,$00       ] , 'vscalefss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(3438, [$62,$62,$15,$27,$2D,$72,$7F                       ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(3439, [$62,$62,$15,$27,$2D,$B2,$00,$02,$00,$00           ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(3440, [$62,$62,$15,$27,$2D,$72,$80                       ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(3441, [$62,$62,$15,$27,$2D,$B2,$FC,$FD,$FF,$FF           ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(3442, [$62,$03,$15,$27,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(3443, [$62,$03,$15,$A7,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(3444, [$62,$03,$15,$17,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(3445, [$62,$03,$15,$27,$55,$F4,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(3446, [$62,$03,$15,$17,$55,$F4,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(3447, [$62,$63,$15,$27,$55,$31,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rcx],0x7b'    );
  TestCase.testcase(3448, [$62,$23,$15,$27,$55,$B4,$F0,$34,$12,$00,$00,$7B   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(3449, [$62,$63,$15,$27,$55,$72,$7F,$7B                   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(3450, [$62,$63,$15,$27,$55,$B2,$00,$02,$00,$00,$7B       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(3451, [$62,$63,$15,$27,$55,$72,$80,$7B                   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(3452, [$62,$63,$15,$27,$55,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.testcase(3453, [$62,$03,$95,$27,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(3454, [$62,$03,$95,$A7,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(3455, [$62,$03,$95,$17,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(3456, [$62,$03,$95,$27,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(3457, [$62,$03,$95,$17,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(3458, [$62,$63,$95,$27,$55,$31,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rcx],0x7b'    );
  TestCase.testcase(3459, [$62,$23,$95,$27,$55,$B4,$F0,$34,$12,$00,$00,$7B   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(3460, [$62,$63,$95,$27,$55,$72,$7F,$7B                   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(3461, [$62,$63,$95,$27,$55,$B2,$00,$04,$00,$00,$7B       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(3462, [$62,$63,$95,$27,$55,$72,$80,$7B                   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(3463, [$62,$63,$95,$27,$55,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(3464, [$62,$03,$95,$27,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(3465, [$62,$03,$95,$A7,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(3466, [$62,$03,$95,$17,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(3467, [$62,$03,$95,$27,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(3468, [$62,$03,$95,$17,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(3469, [$62,$63,$95,$27,$0B,$31,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rcx],0x7b'    );
  TestCase.testcase(3470, [$62,$23,$95,$27,$0B,$B4,$F0,$34,$12,$00,$00,$7B   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(3471, [$62,$63,$95,$27,$0B,$72,$7F,$7B                   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(3472, [$62,$63,$95,$27,$0B,$B2,$00,$04,$00,$00,$7B       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(3473, [$62,$63,$95,$27,$0B,$72,$80,$7B                   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(3474, [$62,$63,$95,$27,$0B,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(3475, [$62,$03,$15,$27,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(3476, [$62,$03,$15,$A7,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(3477, [$62,$03,$15,$17,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(3478, [$62,$03,$15,$27,$0A,$F4,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(3479, [$62,$03,$15,$17,$0A,$F4,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(3480, [$62,$63,$15,$27,$0A,$31,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rcx],0x7b'    );
  TestCase.testcase(3481, [$62,$23,$15,$27,$0A,$B4,$F0,$34,$12,$00,$00,$7B   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(3482, [$62,$63,$15,$27,$0A,$72,$7F,$7B                   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(3483, [$62,$63,$15,$27,$0A,$B2,$00,$02,$00,$00,$7B       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(3484, [$62,$63,$15,$27,$0A,$72,$80,$7B                   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(3485, [$62,$63,$15,$27,$0A,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x64.evex_lig256.log');
end;

end.