unit x64.avx_scalar;

// This unit was generated by d2p.pl script.
// Source : gas/x86-64-avx-scalar-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x64.avx_scalar');
  TestCase.Start();	
  TestCase.Arch := CPUX64;

  TestCase.testcase(0, [$C5,$FD,$2F,$F4                                   ] , 'vcomisd  xmm6,xmm4'                               );
  TestCase.testcase(1, [$C5,$FD,$2F,$21                                   ] , 'vcomisd  xmm4,qword [rcx]'                        );
  TestCase.testcase(2, [$C5,$FD,$2E,$F4                                   ] , 'vucomisd  xmm6,xmm4'                              );
  TestCase.testcase(3, [$C5,$FD,$2E,$21                                   ] , 'vucomisd  xmm4,qword [rcx]'                       );
  TestCase.testcase(4, [$C5,$FF,$10,$21                                   ] , 'vmovsd  xmm4,qword [rcx]'                         );
  TestCase.testcase(5, [$C5,$FF,$11,$21                                   ] , 'vmovsd  qword [rcx],xmm4'                         );
  TestCase.testcase(6, [$C4,$E1,$FD,$7E,$E1                               ] , 'vmovq  rcx,xmm4'                                  );
  TestCase.testcase(7, [$C4,$E1,$FD,$6E,$E1                               ] , 'vmovq  xmm4,rcx'                                  );
  TestCase.testcase(8, [$C4,$E1,$FD,$7E,$E1                               ] , 'vmovq  rcx,xmm4'                                  );
  TestCase.testcase(9, [$C4,$E1,$FD,$6E,$E1                               ] , 'vmovq  xmm4,rcx'                                  );
  TestCase.testcase(10, [$C5,$FD,$D6,$21                                   ] , 'vmovq  qword [rcx],xmm4'                          );
  TestCase.testcase(11, [$C5,$FE,$7E,$21                                   ] , 'vmovq  xmm4,qword [rcx]'                          );
  TestCase.testcase(12, [$C5,$FF,$2D,$CC                                   ] , 'vcvtsd2si  ecx,xmm4'                              );
  TestCase.testcase(13, [$C5,$FF,$2D,$09                                   ] , 'vcvtsd2si  ecx,qword [rcx]'                       );
  TestCase.testcase(14, [$C5,$FF,$2C,$CC                                   ] , 'vcvttsd2si  ecx,xmm4'                             );
  TestCase.testcase(15, [$C5,$FF,$2C,$09                                   ] , 'vcvttsd2si  ecx,qword [rcx]'                      );
  TestCase.testcase(16, [$C4,$E1,$FF,$2D,$CC                               ] , 'vcvtsd2si  rcx,xmm4'                              );
  TestCase.testcase(17, [$C4,$E1,$FF,$2D,$09                               ] , 'vcvtsd2si  rcx,qword [rcx]'                       );
  TestCase.testcase(18, [$C4,$E1,$FF,$2C,$CC                               ] , 'vcvttsd2si  rcx,xmm4'                             );
  TestCase.testcase(19, [$C4,$E1,$FF,$2C,$09                               ] , 'vcvttsd2si  rcx,qword [rcx]'                      );
  TestCase.testcase(20, [$C4,$E1,$DF,$2A,$F1                               ] , 'vcvtsi2sd  xmm6,xmm4,rcx'                         );
  TestCase.testcase(21, [$C4,$E1,$DF,$2A,$31                               ] , 'vcvtsi2sd  xmm6,xmm4,qword [rcx]'                 );
  TestCase.testcase(22, [$C4,$E1,$DE,$2A,$F1                               ] , 'vcvtsi2ss  xmm6,xmm4,rcx'                         );
  TestCase.testcase(23, [$C4,$E1,$DE,$2A,$31                               ] , 'vcvtsi2ss  xmm6,xmm4,qword [rcx]'                 );
  TestCase.testcase(24, [$C5,$CF,$C2,$D4,$07                               ] , 'vcmpordsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(25, [$C5,$CF,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(26, [$C4,$E3,$4D,$0B,$D4,$07                           ] , 'vroundsd  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(27, [$C4,$E3,$4D,$0B,$11,$07                           ] , 'vroundsd  xmm2,xmm6,qword [rcx],0x7'              );
  TestCase.testcase(28, [$C5,$CF,$58,$D4                                   ] , 'vaddsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(29, [$C5,$CF,$58,$11                                   ] , 'vaddsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(30, [$C5,$CF,$5A,$D4                                   ] , 'vcvtsd2ss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(31, [$C5,$CF,$5A,$11                                   ] , 'vcvtsd2ss  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(32, [$C5,$CF,$5E,$D4                                   ] , 'vdivsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(33, [$C5,$CF,$5E,$11                                   ] , 'vdivsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(34, [$C5,$CF,$5F,$D4                                   ] , 'vmaxsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(35, [$C5,$CF,$5F,$11                                   ] , 'vmaxsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(36, [$C5,$CF,$5D,$D4                                   ] , 'vminsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(37, [$C5,$CF,$5D,$11                                   ] , 'vminsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(38, [$C5,$CF,$59,$D4                                   ] , 'vmulsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(39, [$C5,$CF,$59,$11                                   ] , 'vmulsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(40, [$C5,$CF,$51,$D4                                   ] , 'vsqrtsd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(41, [$C5,$CF,$51,$11                                   ] , 'vsqrtsd  xmm2,xmm6,qword [rcx]'                   );
  TestCase.testcase(42, [$C5,$CF,$5C,$D4                                   ] , 'vsubsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(43, [$C5,$CF,$5C,$11                                   ] , 'vsubsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(44, [$C5,$CF,$C2,$D4,$00                               ] , 'vcmpeqsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(45, [$C5,$CF,$C2,$11,$00                               ] , 'vcmpeqsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(46, [$C5,$CF,$C2,$D4,$01                               ] , 'vcmpltsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(47, [$C5,$CF,$C2,$11,$01                               ] , 'vcmpltsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(48, [$C5,$CF,$C2,$D4,$02                               ] , 'vcmplesd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(49, [$C5,$CF,$C2,$11,$02                               ] , 'vcmplesd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(50, [$C5,$CF,$C2,$D4,$03                               ] , 'vcmpunordsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(51, [$C5,$CF,$C2,$11,$03                               ] , 'vcmpunordsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(52, [$C5,$CF,$C2,$D4,$04                               ] , 'vcmpneqsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(53, [$C5,$CF,$C2,$11,$04                               ] , 'vcmpneqsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(54, [$C5,$CF,$C2,$D4,$05                               ] , 'vcmpnltsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(55, [$C5,$CF,$C2,$11,$05                               ] , 'vcmpnltsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(56, [$C5,$CF,$C2,$D4,$06                               ] , 'vcmpnlesd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(57, [$C5,$CF,$C2,$11,$06                               ] , 'vcmpnlesd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(58, [$C5,$CF,$C2,$D4,$07                               ] , 'vcmpordsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(59, [$C5,$CF,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(60, [$C5,$CF,$C2,$D4,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(61, [$C5,$CF,$C2,$11,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(62, [$C5,$CF,$C2,$D4,$09                               ] , 'vcmpngesd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(63, [$C5,$CF,$C2,$11,$09                               ] , 'vcmpngesd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(64, [$C5,$CF,$C2,$D4,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(65, [$C5,$CF,$C2,$11,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(66, [$C5,$CF,$C2,$D4,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(67, [$C5,$CF,$C2,$11,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(68, [$C5,$CF,$C2,$D4,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(69, [$C5,$CF,$C2,$11,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(70, [$C5,$CF,$C2,$D4,$0D                               ] , 'vcmpgesd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(71, [$C5,$CF,$C2,$11,$0D                               ] , 'vcmpgesd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(72, [$C5,$CF,$C2,$D4,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(73, [$C5,$CF,$C2,$11,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(74, [$C5,$CF,$C2,$D4,$0F                               ] , 'vcmuesd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(75, [$C5,$CF,$C2,$11,$0F                               ] , 'vcmuesd  xmm2,xmm6,qword [rcx]'                   );
  TestCase.testcase(76, [$C5,$CF,$C2,$D4,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(77, [$C5,$CF,$C2,$11,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(78, [$C5,$CF,$C2,$D4,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(79, [$C5,$CF,$C2,$11,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(80, [$C5,$CF,$C2,$D4,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(81, [$C5,$CF,$C2,$11,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(82, [$C5,$CF,$C2,$D4,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(83, [$C5,$CF,$C2,$11,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,qword [rcx]'             );
  TestCase.testcase(84, [$C5,$CF,$C2,$D4,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(85, [$C5,$CF,$C2,$11,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(86, [$C5,$CF,$C2,$D4,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(87, [$C5,$CF,$C2,$11,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(88, [$C5,$CF,$C2,$D4,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(89, [$C5,$CF,$C2,$11,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(90, [$C5,$CF,$C2,$D4,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(91, [$C5,$CF,$C2,$11,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(92, [$C5,$CF,$C2,$D4,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(93, [$C5,$CF,$C2,$11,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(94, [$C5,$CF,$C2,$D4,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(95, [$C5,$CF,$C2,$11,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(96, [$C5,$CF,$C2,$D4,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(97, [$C5,$CF,$C2,$11,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(98, [$C5,$CF,$C2,$D4,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(99, [$C5,$CF,$C2,$11,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,qword [rcx]'            );
  TestCase.testcase(100, [$C5,$CF,$C2,$D4,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(101, [$C5,$CF,$C2,$11,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(102, [$C5,$CF,$C2,$D4,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(103, [$C5,$CF,$C2,$11,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(104, [$C5,$CF,$C2,$D4,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(105, [$C5,$CF,$C2,$11,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(106, [$C5,$CF,$C2,$D4,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(107, [$C5,$CF,$C2,$11,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,qword [rcx]'                );
  TestCase.testcase(108, [$C5,$CE,$58,$D4                                   ] , 'vaddss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(109, [$C5,$CE,$58,$11                                   ] , 'vaddss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(110, [$C5,$CE,$5A,$D4                                   ] , 'vcvtss2sd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(111, [$C5,$CE,$5A,$11                                   ] , 'vcvtss2sd  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(112, [$C5,$CE,$5E,$D4                                   ] , 'vdivss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(113, [$C5,$CE,$5E,$11                                   ] , 'vdivss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(114, [$C5,$CE,$5F,$D4                                   ] , 'vmaxss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(115, [$C5,$CE,$5F,$11                                   ] , 'vmaxss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(116, [$C5,$CE,$5D,$D4                                   ] , 'vminss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(117, [$C5,$CE,$5D,$11                                   ] , 'vminss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(118, [$C5,$CE,$59,$D4                                   ] , 'vmulss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(119, [$C5,$CE,$59,$11                                   ] , 'vmulss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(120, [$C5,$CE,$53,$D4                                   ] , 'vrcpss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(121, [$C5,$CE,$53,$11                                   ] , 'vrcpss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(122, [$C5,$CE,$52,$D4                                   ] , 'vrsqrtss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(123, [$C5,$CE,$52,$11                                   ] , 'vrsqrtss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(124, [$C5,$CE,$51,$D4                                   ] , 'vsqrtss  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(125, [$C5,$CE,$51,$11                                   ] , 'vsqrtss  xmm2,xmm6,dword [rcx]'                   );
  TestCase.testcase(126, [$C5,$CE,$5C,$D4                                   ] , 'vsubss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(127, [$C5,$CE,$5C,$11                                   ] , 'vsubss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(128, [$C5,$CE,$C2,$D4,$00                               ] , 'vcmpeqss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(129, [$C5,$CE,$C2,$11,$00                               ] , 'vcmpeqss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(130, [$C5,$CE,$C2,$D4,$01                               ] , 'vcmpltss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(131, [$C5,$CE,$C2,$11,$01                               ] , 'vcmpltss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(132, [$C5,$CE,$C2,$D4,$02                               ] , 'vcmpless  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(133, [$C5,$CE,$C2,$11,$02                               ] , 'vcmpless  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(134, [$C5,$CE,$C2,$D4,$03                               ] , 'vcmpunordss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(135, [$C5,$CE,$C2,$11,$03                               ] , 'vcmpunordss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(136, [$C5,$CE,$C2,$D4,$04                               ] , 'vcmpneqss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(137, [$C5,$CE,$C2,$11,$04                               ] , 'vcmpneqss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(138, [$C5,$CE,$C2,$D4,$05                               ] , 'vcmpnltss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(139, [$C5,$CE,$C2,$11,$05                               ] , 'vcmpnltss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(140, [$C5,$CE,$C2,$D4,$06                               ] , 'vcmpnless  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(141, [$C5,$CE,$C2,$11,$06                               ] , 'vcmpnless  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(142, [$C5,$CE,$C2,$D4,$07                               ] , 'vcmpordss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(143, [$C5,$CE,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(144, [$C5,$CE,$C2,$D4,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(145, [$C5,$CE,$C2,$11,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(146, [$C5,$CE,$C2,$D4,$09                               ] , 'vcmpngess  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(147, [$C5,$CE,$C2,$11,$09                               ] , 'vcmpngess  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(148, [$C5,$CE,$C2,$D4,$0A                               ] , 'vcmpngtss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(149, [$C5,$CE,$C2,$11,$0A                               ] , 'vcmpngtss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(150, [$C5,$CE,$C2,$D4,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(151, [$C5,$CE,$C2,$11,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(152, [$C5,$CE,$C2,$D4,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(153, [$C5,$CE,$C2,$11,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(154, [$C5,$CE,$C2,$D4,$0D                               ] , 'vcmpgess  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(155, [$C5,$CE,$C2,$11,$0D                               ] , 'vcmpgess  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(156, [$C5,$CE,$C2,$D4,$0E                               ] , 'vcmpgtss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(157, [$C5,$CE,$C2,$11,$0E                               ] , 'vcmpgtss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(158, [$C5,$CE,$C2,$D4,$0F                               ] , 'vcmuess  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(159, [$C5,$CE,$C2,$11,$0F                               ] , 'vcmuess  xmm2,xmm6,dword [rcx]'                   );
  TestCase.testcase(160, [$C5,$CE,$C2,$D4,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(161, [$C5,$CE,$C2,$11,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(162, [$C5,$CE,$C2,$D4,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(163, [$C5,$CE,$C2,$11,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(164, [$C5,$CE,$C2,$D4,$12                               ] , 'vcmple_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(165, [$C5,$CE,$C2,$11,$12                               ] , 'vcmple_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(166, [$C5,$CE,$C2,$D4,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(167, [$C5,$CE,$C2,$11,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,dword [rcx]'             );
  TestCase.testcase(168, [$C5,$CE,$C2,$D4,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(169, [$C5,$CE,$C2,$11,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(170, [$C5,$CE,$C2,$D4,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(171, [$C5,$CE,$C2,$11,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(172, [$C5,$CE,$C2,$D4,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(173, [$C5,$CE,$C2,$11,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(174, [$C5,$CE,$C2,$D4,$17                               ] , 'vcmpord_sss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(175, [$C5,$CE,$C2,$11,$17                               ] , 'vcmpord_sss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(176, [$C5,$CE,$C2,$D4,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(177, [$C5,$CE,$C2,$11,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(178, [$C5,$CE,$C2,$D4,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(179, [$C5,$CE,$C2,$11,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(180, [$C5,$CE,$C2,$D4,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(181, [$C5,$CE,$C2,$11,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(182, [$C5,$CE,$C2,$D4,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(183, [$C5,$CE,$C2,$11,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,dword [rcx]'            );
  TestCase.testcase(184, [$C5,$CE,$C2,$D4,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(185, [$C5,$CE,$C2,$11,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(186, [$C5,$CE,$C2,$D4,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(187, [$C5,$CE,$C2,$11,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(188, [$C5,$CE,$C2,$D4,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(189, [$C5,$CE,$C2,$11,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(190, [$C5,$CE,$C2,$D4,$1F                               ] , 'vcmue_usss  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(191, [$C5,$CE,$C2,$11,$1F                               ] , 'vcmue_usss  xmm2,xmm6,dword [rcx]'                );
  TestCase.testcase(192, [$C5,$FC,$2F,$F4                                   ] , 'vcomiss  xmm6,xmm4'                               );
  TestCase.testcase(193, [$C5,$FC,$2F,$21                                   ] , 'vcomiss  xmm4,dword [rcx]'                        );
  TestCase.testcase(194, [$C5,$FC,$2E,$F4                                   ] , 'vucomiss  xmm6,xmm4'                              );
  TestCase.testcase(195, [$C5,$FC,$2E,$21                                   ] , 'vucomiss  xmm4,dword [rcx]'                       );
  TestCase.testcase(196, [$C5,$FE,$10,$21                                   ] , 'vmovss  xmm4,dword [rcx]'                         );
  TestCase.testcase(197, [$C5,$FE,$11,$21                                   ] , 'vmovss  dword [rcx],xmm4'                         );
  TestCase.testcase(198, [$C5,$FD,$7E,$E1                                   ] , 'vmovd  ecx,xmm4'                                  );
  TestCase.testcase(199, [$C5,$FD,$7E,$21                                   ] , 'vmovd  dword [rcx],xmm4'                          );
  TestCase.testcase(200, [$C5,$FD,$6E,$E1                                   ] , 'vmovd  xmm4,ecx'                                  );
  TestCase.testcase(201, [$C5,$FD,$6E,$21                                   ] , 'vmovd  xmm4,dword [rcx]'                          );
  TestCase.testcase(202, [$C5,$FE,$2D,$CC                                   ] , 'vcvtss2si  ecx,xmm4'                              );
  TestCase.testcase(203, [$C5,$FE,$2D,$09                                   ] , 'vcvtss2si  ecx,dword [rcx]'                       );
  TestCase.testcase(204, [$C5,$FE,$2C,$CC                                   ] , 'vcvttss2si  ecx,xmm4'                             );
  TestCase.testcase(205, [$C5,$FE,$2C,$09                                   ] , 'vcvttss2si  ecx,dword [rcx]'                      );
  TestCase.testcase(206, [$C4,$E1,$FE,$2D,$CC                               ] , 'vcvtss2si  rcx,xmm4'                              );
  TestCase.testcase(207, [$C4,$E1,$FE,$2D,$09                               ] , 'vcvtss2si  rcx,dword [rcx]'                       );
  TestCase.testcase(208, [$C4,$E1,$FE,$2C,$CC                               ] , 'vcvttss2si  rcx,xmm4'                             );
  TestCase.testcase(209, [$C4,$E1,$FE,$2C,$09                               ] , 'vcvttss2si  rcx,dword [rcx]'                      );
  TestCase.testcase(210, [$C5,$DF,$2A,$F1                                   ] , 'vcvtsi2sd  xmm6,xmm4,ecx'                         );
  TestCase.testcase(211, [$C5,$DF,$2A,$31                                   ] , 'vcvtsi2sd  xmm6,xmm4,dword [rcx]'                 );
  TestCase.testcase(212, [$C5,$DE,$2A,$F1                                   ] , 'vcvtsi2ss  xmm6,xmm4,ecx'                         );
  TestCase.testcase(213, [$C5,$DE,$2A,$31                                   ] , 'vcvtsi2ss  xmm6,xmm4,dword [rcx]'                 );
  TestCase.testcase(214, [$C5,$CE,$C2,$D4,$07                               ] , 'vcmpordss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(215, [$C5,$CE,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(216, [$C4,$E3,$4D,$0A,$D4,$07                           ] , 'vroundss  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(217, [$C4,$E3,$4D,$0A,$11,$07                           ] , 'vroundss  xmm2,xmm6,dword [rcx],0x7'              );
  TestCase.testcase(218, [$C5,$FE,$7E,$F4                                   ] , 'vmovq  xmm6,xmm4'                                 );
  TestCase.testcase(219, [$C5,$CF,$10,$D4                                   ] , 'vmovsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(220, [$C5,$CE,$10,$D4                                   ] , 'vmovss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(221, [$C5,$7D,$7E,$04,$25,$78,$56,$34,$12               ] , 'vmovd  dword ds:[0x12345678],xmm8'                );
  TestCase.testcase(222, [$C5,$3F,$2A,$3C,$25,$78,$56,$34,$12               ] , 'vcvtsi2sd  xmm15,xmm8,dword ds:[0x12345678]'      );
  TestCase.testcase(223, [$C5,$7D,$7E,$45,$00                               ] , 'vmovd  dword [rbp+0x0],xmm8'                      );
  TestCase.testcase(224, [$C5,$3F,$2A,$7D,$00                               ] , 'vcvtsi2sd  xmm15,xmm8,dword [rbp+0x0]'            );
  TestCase.testcase(225, [$C5,$7D,$7E,$04,$24                               ] , 'vmovd  dword [rsp],xmm8'                          );
  TestCase.testcase(226, [$C5,$3F,$2A,$3C,$24                               ] , 'vcvtsi2sd  xmm15,xmm8,dword [rsp]'                );
  TestCase.testcase(227, [$C5,$7D,$7E,$85,$99,$00,$00,$00                   ] , 'vmovd  dword [rbp+0x99],xmm8'                     );
  TestCase.testcase(228, [$C5,$3F,$2A,$BD,$99,$00,$00,$00                   ] , 'vcvtsi2sd  xmm15,xmm8,dword [rbp+0x99]'           );
  TestCase.testcase(229, [$C4,$41,$7D,$7E,$87,$99,$00,$00,$00               ] , 'vmovd  dword [r15+0x99],xmm8'                     );
  TestCase.testcase(230, [$C4,$41,$3F,$2A,$BF,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm15,xmm8,dword [r15+0x99]'           );
  TestCase.testcase(231, [$C5,$7D,$7E,$05,$99,$00,$00,$00                   ] , 'vmovd  dword [rip 0x99],xmm8'                     );
  TestCase.testcase(232, [$C5,$3F,$2A,$3D,$99,$00,$00,$00                   ] , 'vcvtsi2sd  xmm15,xmm8,dword [rip 0x99]'           );
  TestCase.testcase(233, [$C5,$7D,$7E,$84,$24,$99,$00,$00,$00               ] , 'vmovd  dword [rsp+0x99],xmm8'                     );
  TestCase.testcase(234, [$C5,$3F,$2A,$BC,$24,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm15,xmm8,dword [rsp+0x99]'           );
  TestCase.testcase(235, [$C4,$41,$7D,$7E,$84,$24,$99,$00,$00,$00           ] , 'vmovd  dword [r12+0x99],xmm8'                     );
  TestCase.testcase(236, [$C4,$41,$3F,$2A,$BC,$24,$99,$00,$00,$00           ] , 'vcvtsi2sd  xmm15,xmm8,dword [r12+0x99]'           );
  TestCase.testcase(237, [$C5,$7D,$7E,$04,$25,$67,$FF,$FF,$FF               ] , 'vmovd  dword ds:[0xffffffffffffff67],xmm8'        );
  TestCase.testcase(238, [$C5,$3F,$2A,$3C,$25,$67,$FF,$FF,$FF               ] , 'vcvtsi2sd  xmm15,xmm8,dword ds:[0xffffffffffffff67]' );
  TestCase.testcase(239, [$C4,$01,$7D,$7E,$84,$BC,$67,$FF,$FF,$FF           ] , 'vmovd  dword [r12+r15*4-0x99],xmm8'               );
  TestCase.testcase(240, [$C4,$01,$3F,$2A,$BC,$BC,$67,$FF,$FF,$FF           ] , 'vcvtsi2sd  xmm15,xmm8,dword [r12+r15*4-0x99]'     );
  TestCase.testcase(241, [$C4,$01,$7D,$7E,$84,$F8,$67,$FF,$FF,$FF           ] , 'vmovd  dword [r8+r15*8-0x99],xmm8'                );
  TestCase.testcase(242, [$C4,$01,$3F,$2A,$BC,$F8,$67,$FF,$FF,$FF           ] , 'vcvtsi2sd  xmm15,xmm8,dword [r8+r15*8-0x99]'      );
  TestCase.testcase(243, [$C4,$21,$7D,$7E,$84,$AD,$67,$FF,$FF,$FF           ] , 'vmovd  dword [rbp+r13*4-0x99],xmm8'               );
  TestCase.testcase(244, [$C4,$21,$3F,$2A,$BC,$AD,$67,$FF,$FF,$FF           ] , 'vcvtsi2sd  xmm15,xmm8,dword [rbp+r13*4-0x99]'     );
  TestCase.testcase(245, [$C4,$21,$7D,$7E,$84,$24,$67,$FF,$FF,$FF           ] , 'vmovd  dword [rsp+r12*1-0x99],xmm8'               );
  TestCase.testcase(246, [$C4,$21,$3F,$2A,$BC,$24,$67,$FF,$FF,$FF           ] , 'vcvtsi2sd  xmm15,xmm8,dword [rsp+r12*1-0x99]'     );
  TestCase.testcase(247, [$C4,$41,$7D,$7E,$C0                               ] , 'vmovd  r8d,xmm8'                                  );
  TestCase.testcase(248, [$C4,$41,$7F,$2D,$C0                               ] , 'vcvtsd2si  r8d,xmm8'                              );
  TestCase.testcase(249, [$C4,$41,$3F,$2A,$F8                               ] , 'vcvtsi2sd  xmm15,xmm8,r8d'                        );
  TestCase.testcase(250, [$C4,$61,$FF,$2D,$01                               ] , 'vcvtsd2si  r8,qword [rcx]'                        );
  TestCase.testcase(251, [$C4,$61,$FE,$2D,$01                               ] , 'vcvtss2si  r8,dword [rcx]'                        );
  TestCase.testcase(252, [$C5,$FD,$2F,$F4                                   ] , 'vcomisd  xmm6,xmm4'                               );
  TestCase.testcase(253, [$C5,$FD,$2F,$21                                   ] , 'vcomisd  xmm4,qword [rcx]'                        );
  TestCase.testcase(254, [$C5,$FD,$2F,$21                                   ] , 'vcomisd  xmm4,qword [rcx]'                        );
  TestCase.testcase(255, [$C5,$FD,$2E,$F4                                   ] , 'vucomisd  xmm6,xmm4'                              );
  TestCase.testcase(256, [$C5,$FD,$2E,$21                                   ] , 'vucomisd  xmm4,qword [rcx]'                       );
  TestCase.testcase(257, [$C5,$FD,$2E,$21                                   ] , 'vucomisd  xmm4,qword [rcx]'                       );
  TestCase.testcase(258, [$C5,$FF,$10,$21                                   ] , 'vmovsd  xmm4,qword [rcx]'                         );
  TestCase.testcase(259, [$C5,$FF,$10,$21                                   ] , 'vmovsd  xmm4,qword [rcx]'                         );
  TestCase.testcase(260, [$C5,$FF,$11,$21                                   ] , 'vmovsd  qword [rcx],xmm4'                         );
  TestCase.testcase(261, [$C5,$FF,$11,$21                                   ] , 'vmovsd  qword [rcx],xmm4'                         );
  TestCase.testcase(262, [$C4,$E1,$FD,$7E,$E1                               ] , 'vmovq  rcx,xmm4'                                  );
  TestCase.testcase(263, [$C4,$E1,$FD,$6E,$E1                               ] , 'vmovq  xmm4,rcx'                                  );
  TestCase.testcase(264, [$C5,$FD,$7E,$21                                   ] , 'vmovd  dword [rcx],xmm4'                          );
  TestCase.testcase(265, [$C5,$FD,$6E,$21                                   ] , 'vmovd  xmm4,dword [rcx]'                          );
  TestCase.testcase(266, [$C4,$E1,$FD,$7E,$E1                               ] , 'vmovq  rcx,xmm4'                                  );
  TestCase.testcase(267, [$C4,$E1,$FD,$6E,$E1                               ] , 'vmovq  xmm4,rcx'                                  );
  TestCase.testcase(268, [$C5,$FD,$D6,$21                                   ] , 'vmovq  qword [rcx],xmm4'                          );
  TestCase.testcase(269, [$C5,$FE,$7E,$21                                   ] , 'vmovq  xmm4,qword [rcx]'                          );
  TestCase.testcase(270, [$C5,$FD,$D6,$21                                   ] , 'vmovq  qword [rcx],xmm4'                          );
  TestCase.testcase(271, [$C5,$FE,$7E,$21                                   ] , 'vmovq  xmm4,qword [rcx]'                          );
  TestCase.testcase(272, [$C5,$FF,$2D,$CC                                   ] , 'vcvtsd2si  ecx,xmm4'                              );
  TestCase.testcase(273, [$C5,$FF,$2D,$09                                   ] , 'vcvtsd2si  ecx,qword [rcx]'                       );
  TestCase.testcase(274, [$C5,$FF,$2D,$09                                   ] , 'vcvtsd2si  ecx,qword [rcx]'                       );
  TestCase.testcase(275, [$C5,$FF,$2C,$CC                                   ] , 'vcvttsd2si  ecx,xmm4'                             );
  TestCase.testcase(276, [$C5,$FF,$2C,$09                                   ] , 'vcvttsd2si  ecx,qword [rcx]'                      );
  TestCase.testcase(277, [$C5,$FF,$2C,$09                                   ] , 'vcvttsd2si  ecx,qword [rcx]'                      );
  TestCase.testcase(278, [$C4,$E1,$FF,$2D,$CC                               ] , 'vcvtsd2si  rcx,xmm4'                              );
  TestCase.testcase(279, [$C4,$E1,$FF,$2D,$09                               ] , 'vcvtsd2si  rcx,qword [rcx]'                       );
  TestCase.testcase(280, [$C4,$E1,$FF,$2D,$09                               ] , 'vcvtsd2si  rcx,qword [rcx]'                       );
  TestCase.testcase(281, [$C4,$E1,$FF,$2C,$CC                               ] , 'vcvttsd2si  rcx,xmm4'                             );
  TestCase.testcase(282, [$C4,$E1,$FF,$2C,$09                               ] , 'vcvttsd2si  rcx,qword [rcx]'                      );
  TestCase.testcase(283, [$C4,$E1,$FF,$2C,$09                               ] , 'vcvttsd2si  rcx,qword [rcx]'                      );
  TestCase.testcase(284, [$C4,$E1,$DF,$2A,$F1                               ] , 'vcvtsi2sd  xmm6,xmm4,rcx'                         );
  TestCase.testcase(285, [$C4,$E1,$DF,$2A,$31                               ] , 'vcvtsi2sd  xmm6,xmm4,qword [rcx]'                 );
  TestCase.testcase(286, [$C4,$E1,$DF,$2A,$31                               ] , 'vcvtsi2sd  xmm6,xmm4,qword [rcx]'                 );
  TestCase.testcase(287, [$C4,$E1,$DE,$2A,$F1                               ] , 'vcvtsi2ss  xmm6,xmm4,rcx'                         );
  TestCase.testcase(288, [$C4,$E1,$DE,$2A,$31                               ] , 'vcvtsi2ss  xmm6,xmm4,qword [rcx]'                 );
  TestCase.testcase(289, [$C4,$E1,$DE,$2A,$31                               ] , 'vcvtsi2ss  xmm6,xmm4,qword [rcx]'                 );
  TestCase.testcase(290, [$C5,$CF,$C2,$D4,$07                               ] , 'vcmpordsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(291, [$C5,$CF,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(292, [$C5,$CF,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(293, [$C4,$E3,$4D,$0B,$D4,$07                           ] , 'vroundsd  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(294, [$C4,$E3,$4D,$0B,$11,$07                           ] , 'vroundsd  xmm2,xmm6,qword [rcx],0x7'              );
  TestCase.testcase(295, [$C4,$E3,$4D,$0B,$11,$07                           ] , 'vroundsd  xmm2,xmm6,qword [rcx],0x7'              );
  TestCase.testcase(296, [$C5,$CF,$58,$D4                                   ] , 'vaddsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(297, [$C5,$CF,$58,$11                                   ] , 'vaddsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(298, [$C5,$CF,$58,$11                                   ] , 'vaddsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(299, [$C5,$CF,$5A,$D4                                   ] , 'vcvtsd2ss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(300, [$C5,$CF,$5A,$11                                   ] , 'vcvtsd2ss  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(301, [$C5,$CF,$5A,$11                                   ] , 'vcvtsd2ss  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(302, [$C5,$CF,$5E,$D4                                   ] , 'vdivsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(303, [$C5,$CF,$5E,$11                                   ] , 'vdivsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(304, [$C5,$CF,$5E,$11                                   ] , 'vdivsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(305, [$C5,$CF,$5F,$D4                                   ] , 'vmaxsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(306, [$C5,$CF,$5F,$11                                   ] , 'vmaxsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(307, [$C5,$CF,$5F,$11                                   ] , 'vmaxsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(308, [$C5,$CF,$5D,$D4                                   ] , 'vminsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(309, [$C5,$CF,$5D,$11                                   ] , 'vminsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(310, [$C5,$CF,$5D,$11                                   ] , 'vminsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(311, [$C5,$CF,$59,$D4                                   ] , 'vmulsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(312, [$C5,$CF,$59,$11                                   ] , 'vmulsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(313, [$C5,$CF,$59,$11                                   ] , 'vmulsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(314, [$C5,$CF,$51,$D4                                   ] , 'vsqrtsd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(315, [$C5,$CF,$51,$11                                   ] , 'vsqrtsd  xmm2,xmm6,qword [rcx]'                   );
  TestCase.testcase(316, [$C5,$CF,$51,$11                                   ] , 'vsqrtsd  xmm2,xmm6,qword [rcx]'                   );
  TestCase.testcase(317, [$C5,$CF,$5C,$D4                                   ] , 'vsubsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(318, [$C5,$CF,$5C,$11                                   ] , 'vsubsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(319, [$C5,$CF,$5C,$11                                   ] , 'vsubsd  xmm2,xmm6,qword [rcx]'                    );
  TestCase.testcase(320, [$C5,$CF,$C2,$D4,$00                               ] , 'vcmpeqsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(321, [$C5,$CF,$C2,$11,$00                               ] , 'vcmpeqsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(322, [$C5,$CF,$C2,$11,$00                               ] , 'vcmpeqsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(323, [$C5,$CF,$C2,$D4,$01                               ] , 'vcmpltsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(324, [$C5,$CF,$C2,$11,$01                               ] , 'vcmpltsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(325, [$C5,$CF,$C2,$11,$01                               ] , 'vcmpltsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(326, [$C5,$CF,$C2,$D4,$02                               ] , 'vcmplesd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(327, [$C5,$CF,$C2,$11,$02                               ] , 'vcmplesd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(328, [$C5,$CF,$C2,$11,$02                               ] , 'vcmplesd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(329, [$C5,$CF,$C2,$D4,$03                               ] , 'vcmpunordsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(330, [$C5,$CF,$C2,$11,$03                               ] , 'vcmpunordsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(331, [$C5,$CF,$C2,$11,$03                               ] , 'vcmpunordsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(332, [$C5,$CF,$C2,$D4,$04                               ] , 'vcmpneqsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(333, [$C5,$CF,$C2,$11,$04                               ] , 'vcmpneqsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(334, [$C5,$CF,$C2,$11,$04                               ] , 'vcmpneqsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(335, [$C5,$CF,$C2,$D4,$05                               ] , 'vcmpnltsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(336, [$C5,$CF,$C2,$11,$05                               ] , 'vcmpnltsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(337, [$C5,$CF,$C2,$11,$05                               ] , 'vcmpnltsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(338, [$C5,$CF,$C2,$D4,$06                               ] , 'vcmpnlesd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(339, [$C5,$CF,$C2,$11,$06                               ] , 'vcmpnlesd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(340, [$C5,$CF,$C2,$11,$06                               ] , 'vcmpnlesd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(341, [$C5,$CF,$C2,$D4,$07                               ] , 'vcmpordsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(342, [$C5,$CF,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(343, [$C5,$CF,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(344, [$C5,$CF,$C2,$D4,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(345, [$C5,$CF,$C2,$11,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(346, [$C5,$CF,$C2,$11,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(347, [$C5,$CF,$C2,$D4,$09                               ] , 'vcmpngesd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(348, [$C5,$CF,$C2,$11,$09                               ] , 'vcmpngesd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(349, [$C5,$CF,$C2,$11,$09                               ] , 'vcmpngesd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(350, [$C5,$CF,$C2,$D4,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(351, [$C5,$CF,$C2,$11,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(352, [$C5,$CF,$C2,$11,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,qword [rcx]'                 );
  TestCase.testcase(353, [$C5,$CF,$C2,$D4,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(354, [$C5,$CF,$C2,$11,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(355, [$C5,$CF,$C2,$11,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(356, [$C5,$CF,$C2,$D4,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(357, [$C5,$CF,$C2,$11,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(358, [$C5,$CF,$C2,$11,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(359, [$C5,$CF,$C2,$D4,$0D                               ] , 'vcmpgesd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(360, [$C5,$CF,$C2,$11,$0D                               ] , 'vcmpgesd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(361, [$C5,$CF,$C2,$11,$0D                               ] , 'vcmpgesd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(362, [$C5,$CF,$C2,$D4,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(363, [$C5,$CF,$C2,$11,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(364, [$C5,$CF,$C2,$11,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,qword [rcx]'                  );
  TestCase.testcase(365, [$C5,$CF,$C2,$D4,$0F                               ] , 'vcmuesd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(366, [$C5,$CF,$C2,$11,$0F                               ] , 'vcmuesd  xmm2,xmm6,qword [rcx]'                   );
  TestCase.testcase(367, [$C5,$CF,$C2,$11,$0F                               ] , 'vcmuesd  xmm2,xmm6,qword [rcx]'                   );
  TestCase.testcase(368, [$C5,$CF,$C2,$D4,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(369, [$C5,$CF,$C2,$11,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(370, [$C5,$CF,$C2,$11,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(371, [$C5,$CF,$C2,$D4,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(372, [$C5,$CF,$C2,$11,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(373, [$C5,$CF,$C2,$11,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(374, [$C5,$CF,$C2,$D4,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(375, [$C5,$CF,$C2,$11,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(376, [$C5,$CF,$C2,$11,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(377, [$C5,$CF,$C2,$D4,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(378, [$C5,$CF,$C2,$11,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,qword [rcx]'             );
  TestCase.testcase(379, [$C5,$CF,$C2,$11,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,qword [rcx]'             );
  TestCase.testcase(380, [$C5,$CF,$C2,$D4,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(381, [$C5,$CF,$C2,$11,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(382, [$C5,$CF,$C2,$11,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(383, [$C5,$CF,$C2,$D4,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(384, [$C5,$CF,$C2,$11,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(385, [$C5,$CF,$C2,$11,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(386, [$C5,$CF,$C2,$D4,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(387, [$C5,$CF,$C2,$11,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(388, [$C5,$CF,$C2,$11,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(389, [$C5,$CF,$C2,$D4,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(390, [$C5,$CF,$C2,$11,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(391, [$C5,$CF,$C2,$11,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(392, [$C5,$CF,$C2,$D4,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(393, [$C5,$CF,$C2,$11,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(394, [$C5,$CF,$C2,$11,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(395, [$C5,$CF,$C2,$D4,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(396, [$C5,$CF,$C2,$11,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(397, [$C5,$CF,$C2,$11,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(398, [$C5,$CF,$C2,$D4,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(399, [$C5,$CF,$C2,$11,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(400, [$C5,$CF,$C2,$11,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(401, [$C5,$CF,$C2,$D4,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(402, [$C5,$CF,$C2,$11,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,qword [rcx]'            );
  TestCase.testcase(403, [$C5,$CF,$C2,$11,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,qword [rcx]'            );
  TestCase.testcase(404, [$C5,$CF,$C2,$D4,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(405, [$C5,$CF,$C2,$11,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(406, [$C5,$CF,$C2,$11,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,qword [rcx]'              );
  TestCase.testcase(407, [$C5,$CF,$C2,$D4,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(408, [$C5,$CF,$C2,$11,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(409, [$C5,$CF,$C2,$11,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(410, [$C5,$CF,$C2,$D4,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(411, [$C5,$CF,$C2,$11,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(412, [$C5,$CF,$C2,$11,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,qword [rcx]'               );
  TestCase.testcase(413, [$C5,$CF,$C2,$D4,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(414, [$C5,$CF,$C2,$11,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,qword [rcx]'                );
  TestCase.testcase(415, [$C5,$CF,$C2,$11,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,qword [rcx]'                );
  TestCase.testcase(416, [$C5,$CE,$58,$D4                                   ] , 'vaddss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(417, [$C5,$CE,$58,$11                                   ] , 'vaddss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(418, [$C5,$CE,$58,$11                                   ] , 'vaddss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(419, [$C5,$CE,$5A,$D4                                   ] , 'vcvtss2sd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(420, [$C5,$CE,$5A,$11                                   ] , 'vcvtss2sd  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(421, [$C5,$CE,$5A,$11                                   ] , 'vcvtss2sd  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(422, [$C5,$CE,$5E,$D4                                   ] , 'vdivss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(423, [$C5,$CE,$5E,$11                                   ] , 'vdivss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(424, [$C5,$CE,$5E,$11                                   ] , 'vdivss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(425, [$C5,$CE,$5F,$D4                                   ] , 'vmaxss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(426, [$C5,$CE,$5F,$11                                   ] , 'vmaxss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(427, [$C5,$CE,$5F,$11                                   ] , 'vmaxss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(428, [$C5,$CE,$5D,$D4                                   ] , 'vminss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(429, [$C5,$CE,$5D,$11                                   ] , 'vminss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(430, [$C5,$CE,$5D,$11                                   ] , 'vminss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(431, [$C5,$CE,$59,$D4                                   ] , 'vmulss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(432, [$C5,$CE,$59,$11                                   ] , 'vmulss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(433, [$C5,$CE,$59,$11                                   ] , 'vmulss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(434, [$C5,$CE,$53,$D4                                   ] , 'vrcpss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(435, [$C5,$CE,$53,$11                                   ] , 'vrcpss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(436, [$C5,$CE,$53,$11                                   ] , 'vrcpss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(437, [$C5,$CE,$52,$D4                                   ] , 'vrsqrtss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(438, [$C5,$CE,$52,$11                                   ] , 'vrsqrtss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(439, [$C5,$CE,$52,$11                                   ] , 'vrsqrtss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(440, [$C5,$CE,$51,$D4                                   ] , 'vsqrtss  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(441, [$C5,$CE,$51,$11                                   ] , 'vsqrtss  xmm2,xmm6,dword [rcx]'                   );
  TestCase.testcase(442, [$C5,$CE,$51,$11                                   ] , 'vsqrtss  xmm2,xmm6,dword [rcx]'                   );
  TestCase.testcase(443, [$C5,$CE,$5C,$D4                                   ] , 'vsubss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(444, [$C5,$CE,$5C,$11                                   ] , 'vsubss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(445, [$C5,$CE,$5C,$11                                   ] , 'vsubss  xmm2,xmm6,dword [rcx]'                    );
  TestCase.testcase(446, [$C5,$CE,$C2,$D4,$00                               ] , 'vcmpeqss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(447, [$C5,$CE,$C2,$11,$00                               ] , 'vcmpeqss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(448, [$C5,$CE,$C2,$11,$00                               ] , 'vcmpeqss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(449, [$C5,$CE,$C2,$D4,$01                               ] , 'vcmpltss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(450, [$C5,$CE,$C2,$11,$01                               ] , 'vcmpltss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(451, [$C5,$CE,$C2,$11,$01                               ] , 'vcmpltss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(452, [$C5,$CE,$C2,$D4,$02                               ] , 'vcmpless  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(453, [$C5,$CE,$C2,$11,$02                               ] , 'vcmpless  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(454, [$C5,$CE,$C2,$11,$02                               ] , 'vcmpless  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(455, [$C5,$CE,$C2,$D4,$03                               ] , 'vcmpunordss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(456, [$C5,$CE,$C2,$11,$03                               ] , 'vcmpunordss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(457, [$C5,$CE,$C2,$11,$03                               ] , 'vcmpunordss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(458, [$C5,$CE,$C2,$D4,$04                               ] , 'vcmpneqss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(459, [$C5,$CE,$C2,$11,$04                               ] , 'vcmpneqss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(460, [$C5,$CE,$C2,$11,$04                               ] , 'vcmpneqss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(461, [$C5,$CE,$C2,$D4,$05                               ] , 'vcmpnltss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(462, [$C5,$CE,$C2,$11,$05                               ] , 'vcmpnltss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(463, [$C5,$CE,$C2,$11,$05                               ] , 'vcmpnltss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(464, [$C5,$CE,$C2,$D4,$06                               ] , 'vcmpnless  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(465, [$C5,$CE,$C2,$11,$06                               ] , 'vcmpnless  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(466, [$C5,$CE,$C2,$11,$06                               ] , 'vcmpnless  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(467, [$C5,$CE,$C2,$D4,$07                               ] , 'vcmpordss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(468, [$C5,$CE,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(469, [$C5,$CE,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(470, [$C5,$CE,$C2,$D4,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(471, [$C5,$CE,$C2,$11,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(472, [$C5,$CE,$C2,$11,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(473, [$C5,$CE,$C2,$D4,$09                               ] , 'vcmpngess  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(474, [$C5,$CE,$C2,$11,$09                               ] , 'vcmpngess  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(475, [$C5,$CE,$C2,$11,$09                               ] , 'vcmpngess  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(476, [$C5,$CE,$C2,$D4,$0A                               ] , 'vcmpngtss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(477, [$C5,$CE,$C2,$11,$0A                               ] , 'vcmpngtss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(478, [$C5,$CE,$C2,$11,$0A                               ] , 'vcmpngtss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(479, [$C5,$CE,$C2,$D4,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(480, [$C5,$CE,$C2,$11,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(481, [$C5,$CE,$C2,$11,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(482, [$C5,$CE,$C2,$D4,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(483, [$C5,$CE,$C2,$11,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(484, [$C5,$CE,$C2,$11,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(485, [$C5,$CE,$C2,$D4,$0D                               ] , 'vcmpgess  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(486, [$C5,$CE,$C2,$11,$0D                               ] , 'vcmpgess  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(487, [$C5,$CE,$C2,$11,$0D                               ] , 'vcmpgess  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(488, [$C5,$CE,$C2,$D4,$0E                               ] , 'vcmpgtss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(489, [$C5,$CE,$C2,$11,$0E                               ] , 'vcmpgtss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(490, [$C5,$CE,$C2,$11,$0E                               ] , 'vcmpgtss  xmm2,xmm6,dword [rcx]'                  );
  TestCase.testcase(491, [$C5,$CE,$C2,$D4,$0F                               ] , 'vcmuess  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(492, [$C5,$CE,$C2,$11,$0F                               ] , 'vcmuess  xmm2,xmm6,dword [rcx]'                   );
  TestCase.testcase(493, [$C5,$CE,$C2,$11,$0F                               ] , 'vcmuess  xmm2,xmm6,dword [rcx]'                   );
  TestCase.testcase(494, [$C5,$CE,$C2,$D4,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(495, [$C5,$CE,$C2,$11,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(496, [$C5,$CE,$C2,$11,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(497, [$C5,$CE,$C2,$D4,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(498, [$C5,$CE,$C2,$11,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(499, [$C5,$CE,$C2,$11,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(500, [$C5,$CE,$C2,$D4,$12                               ] , 'vcmple_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(501, [$C5,$CE,$C2,$11,$12                               ] , 'vcmple_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(502, [$C5,$CE,$C2,$11,$12                               ] , 'vcmple_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(503, [$C5,$CE,$C2,$D4,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(504, [$C5,$CE,$C2,$11,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,dword [rcx]'             );
  TestCase.testcase(505, [$C5,$CE,$C2,$11,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,dword [rcx]'             );
  TestCase.testcase(506, [$C5,$CE,$C2,$D4,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(507, [$C5,$CE,$C2,$11,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(508, [$C5,$CE,$C2,$11,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(509, [$C5,$CE,$C2,$D4,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(510, [$C5,$CE,$C2,$11,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(511, [$C5,$CE,$C2,$11,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(512, [$C5,$CE,$C2,$D4,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(513, [$C5,$CE,$C2,$11,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(514, [$C5,$CE,$C2,$11,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(515, [$C5,$CE,$C2,$D4,$17                               ] , 'vcmpord_sss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(516, [$C5,$CE,$C2,$11,$17                               ] , 'vcmpord_sss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(517, [$C5,$CE,$C2,$11,$17                               ] , 'vcmpord_sss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(518, [$C5,$CE,$C2,$D4,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(519, [$C5,$CE,$C2,$11,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(520, [$C5,$CE,$C2,$11,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(521, [$C5,$CE,$C2,$D4,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(522, [$C5,$CE,$C2,$11,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(523, [$C5,$CE,$C2,$11,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(524, [$C5,$CE,$C2,$D4,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(525, [$C5,$CE,$C2,$11,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(526, [$C5,$CE,$C2,$11,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(527, [$C5,$CE,$C2,$D4,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(528, [$C5,$CE,$C2,$11,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,dword [rcx]'            );
  TestCase.testcase(529, [$C5,$CE,$C2,$11,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,dword [rcx]'            );
  TestCase.testcase(530, [$C5,$CE,$C2,$D4,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(531, [$C5,$CE,$C2,$11,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(532, [$C5,$CE,$C2,$11,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,dword [rcx]'              );
  TestCase.testcase(533, [$C5,$CE,$C2,$D4,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(534, [$C5,$CE,$C2,$11,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(535, [$C5,$CE,$C2,$11,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(536, [$C5,$CE,$C2,$D4,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(537, [$C5,$CE,$C2,$11,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(538, [$C5,$CE,$C2,$11,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,dword [rcx]'               );
  TestCase.testcase(539, [$C5,$CE,$C2,$D4,$1F                               ] , 'vcmue_usss  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(540, [$C5,$CE,$C2,$11,$1F                               ] , 'vcmue_usss  xmm2,xmm6,dword [rcx]'                );
  TestCase.testcase(541, [$C5,$CE,$C2,$11,$1F                               ] , 'vcmue_usss  xmm2,xmm6,dword [rcx]'                );
  TestCase.testcase(542, [$C5,$FC,$2F,$F4                                   ] , 'vcomiss  xmm6,xmm4'                               );
  TestCase.testcase(543, [$C5,$FC,$2F,$21                                   ] , 'vcomiss  xmm4,dword [rcx]'                        );
  TestCase.testcase(544, [$C5,$FC,$2F,$21                                   ] , 'vcomiss  xmm4,dword [rcx]'                        );
  TestCase.testcase(545, [$C5,$FC,$2E,$F4                                   ] , 'vucomiss  xmm6,xmm4'                              );
  TestCase.testcase(546, [$C5,$FC,$2E,$21                                   ] , 'vucomiss  xmm4,dword [rcx]'                       );
  TestCase.testcase(547, [$C5,$FC,$2E,$21                                   ] , 'vucomiss  xmm4,dword [rcx]'                       );
  TestCase.testcase(548, [$C5,$FE,$10,$21                                   ] , 'vmovss  xmm4,dword [rcx]'                         );
  TestCase.testcase(549, [$C5,$FE,$10,$21                                   ] , 'vmovss  xmm4,dword [rcx]'                         );
  TestCase.testcase(550, [$C5,$FE,$11,$21                                   ] , 'vmovss  dword [rcx],xmm4'                         );
  TestCase.testcase(551, [$C5,$FE,$11,$21                                   ] , 'vmovss  dword [rcx],xmm4'                         );
  TestCase.testcase(552, [$C5,$FD,$7E,$E1                                   ] , 'vmovd  ecx,xmm4'                                  );
  TestCase.testcase(553, [$C5,$FD,$7E,$21                                   ] , 'vmovd  dword [rcx],xmm4'                          );
  TestCase.testcase(554, [$C5,$FD,$6E,$E1                                   ] , 'vmovd  xmm4,ecx'                                  );
  TestCase.testcase(555, [$C5,$FD,$6E,$21                                   ] , 'vmovd  xmm4,dword [rcx]'                          );
  TestCase.testcase(556, [$C5,$FD,$7E,$21                                   ] , 'vmovd  dword [rcx],xmm4'                          );
  TestCase.testcase(557, [$C5,$FD,$6E,$21                                   ] , 'vmovd  xmm4,dword [rcx]'                          );
  TestCase.testcase(558, [$C5,$FE,$2D,$CC                                   ] , 'vcvtss2si  ecx,xmm4'                              );
  TestCase.testcase(559, [$C5,$FE,$2D,$09                                   ] , 'vcvtss2si  ecx,dword [rcx]'                       );
  TestCase.testcase(560, [$C5,$FE,$2D,$09                                   ] , 'vcvtss2si  ecx,dword [rcx]'                       );
  TestCase.testcase(561, [$C5,$FE,$2C,$CC                                   ] , 'vcvttss2si  ecx,xmm4'                             );
  TestCase.testcase(562, [$C5,$FE,$2C,$09                                   ] , 'vcvttss2si  ecx,dword [rcx]'                      );
  TestCase.testcase(563, [$C5,$FE,$2C,$09                                   ] , 'vcvttss2si  ecx,dword [rcx]'                      );
  TestCase.testcase(564, [$C4,$E1,$FE,$2D,$CC                               ] , 'vcvtss2si  rcx,xmm4'                              );
  TestCase.testcase(565, [$C4,$E1,$FE,$2D,$09                               ] , 'vcvtss2si  rcx,dword [rcx]'                       );
  TestCase.testcase(566, [$C4,$E1,$FE,$2D,$09                               ] , 'vcvtss2si  rcx,dword [rcx]'                       );
  TestCase.testcase(567, [$C4,$E1,$FE,$2C,$CC                               ] , 'vcvttss2si  rcx,xmm4'                             );
  TestCase.testcase(568, [$C4,$E1,$FE,$2C,$09                               ] , 'vcvttss2si  rcx,dword [rcx]'                      );
  TestCase.testcase(569, [$C4,$E1,$FE,$2C,$09                               ] , 'vcvttss2si  rcx,dword [rcx]'                      );
  TestCase.testcase(570, [$C5,$DF,$2A,$F1                                   ] , 'vcvtsi2sd  xmm6,xmm4,ecx'                         );
  TestCase.testcase(571, [$C5,$DF,$2A,$31                                   ] , 'vcvtsi2sd  xmm6,xmm4,dword [rcx]'                 );
  TestCase.testcase(572, [$C5,$DE,$2A,$F1                                   ] , 'vcvtsi2ss  xmm6,xmm4,ecx'                         );
  TestCase.testcase(573, [$C5,$DE,$2A,$31                                   ] , 'vcvtsi2ss  xmm6,xmm4,dword [rcx]'                 );
  TestCase.testcase(574, [$C5,$CE,$C2,$D4,$07                               ] , 'vcmpordss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(575, [$C5,$CE,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(576, [$C5,$CE,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [rcx]'                 );
  TestCase.testcase(577, [$C4,$E3,$4D,$0A,$D4,$07                           ] , 'vroundss  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(578, [$C4,$E3,$4D,$0A,$11,$07                           ] , 'vroundss  xmm2,xmm6,dword [rcx],0x7'              );
  TestCase.testcase(579, [$C4,$E3,$4D,$0A,$11,$07                           ] , 'vroundss  xmm2,xmm6,dword [rcx],0x7'              );
  TestCase.testcase(580, [$C5,$FE,$7E,$F4                                   ] , 'vmovq  xmm6,xmm4'                                 );
  TestCase.testcase(581, [$C5,$CF,$10,$D4                                   ] , 'vmovsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(582, [$C5,$CE,$10,$D4                                   ] , 'vmovss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(583, [$C5,$7D,$7E,$04,$25,$78,$56,$34,$12               ] , 'vmovd  dword ds:[0x12345678],xmm8'                );
  TestCase.testcase(584, [$C5,$3F,$2A,$3C,$25,$78,$56,$34,$12               ] , 'vcvtsi2sd  xmm15,xmm8,dword ds:[0x12345678]'      );
  TestCase.testcase(585, [$C5,$7D,$7E,$45,$00                               ] , 'vmovd  dword [rbp+0x0],xmm8'                      );
  TestCase.testcase(586, [$C5,$3F,$2A,$7D,$00                               ] , 'vcvtsi2sd  xmm15,xmm8,dword [rbp+0x0]'            );
  TestCase.testcase(587, [$C5,$7D,$7E,$85,$99,$00,$00,$00                   ] , 'vmovd  dword [rbp+0x99],xmm8'                     );
  TestCase.testcase(588, [$C5,$3F,$2A,$BD,$99,$00,$00,$00                   ] , 'vcvtsi2sd  xmm15,xmm8,dword [rbp+0x99]'           );
  TestCase.testcase(589, [$C4,$41,$7D,$7E,$87,$99,$00,$00,$00               ] , 'vmovd  dword [r15+0x99],xmm8'                     );
  TestCase.testcase(590, [$C4,$41,$3F,$2A,$BF,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm15,xmm8,dword [r15+0x99]'           );
  TestCase.testcase(591, [$C5,$7D,$7E,$05,$99,$00,$00,$00                   ] , 'vmovd  dword [rip 0x99],xmm8'                     );
  TestCase.testcase(592, [$C5,$3F,$2A,$3D,$99,$00,$00,$00                   ] , 'vcvtsi2sd  xmm15,xmm8,dword [rip 0x99]'           );
  TestCase.testcase(593, [$C5,$7D,$7E,$84,$24,$99,$00,$00,$00               ] , 'vmovd  dword [rsp+0x99],xmm8'                     );
  TestCase.testcase(594, [$C5,$3F,$2A,$BC,$24,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm15,xmm8,dword [rsp+0x99]'           );
  TestCase.testcase(595, [$C4,$41,$7D,$7E,$84,$24,$99,$00,$00,$00           ] , 'vmovd  dword [r12+0x99],xmm8'                     );
  TestCase.testcase(596, [$C4,$41,$3F,$2A,$BC,$24,$99,$00,$00,$00           ] , 'vcvtsi2sd  xmm15,xmm8,dword [r12+0x99]'           );
  TestCase.testcase(597, [$C5,$7D,$7E,$04,$25,$67,$FF,$FF,$FF               ] , 'vmovd  dword ds:[0xffffffffffffff67],xmm8'        );
  TestCase.testcase(598, [$C5,$3F,$2A,$3C,$25,$67,$FF,$FF,$FF               ] , 'vcvtsi2sd  xmm15,xmm8,dword ds:[0xffffffffffffff67]' );
  TestCase.testcase(599, [$C4,$01,$7D,$7E,$84,$BC,$67,$FF,$FF,$FF           ] , 'vmovd  dword [r12+r15*4-0x99],xmm8'               );
  TestCase.testcase(600, [$C4,$01,$3F,$2A,$BC,$BC,$67,$FF,$FF,$FF           ] , 'vcvtsi2sd  xmm15,xmm8,dword [r12+r15*4-0x99]'     );
  TestCase.testcase(601, [$C4,$01,$7D,$7E,$84,$F8,$67,$FF,$FF,$FF           ] , 'vmovd  dword [r8+r15*8-0x99],xmm8'                );
  TestCase.testcase(602, [$C4,$01,$3F,$2A,$BC,$F8,$67,$FF,$FF,$FF           ] , 'vcvtsi2sd  xmm15,xmm8,dword [r8+r15*8-0x99]'      );
  TestCase.testcase(603, [$C4,$21,$7D,$7E,$84,$A5,$67,$FF,$FF,$FF           ] , 'vmovd  dword [rbp+r12*4-0x99],xmm8'               );
  TestCase.testcase(604, [$C4,$21,$3F,$2A,$BC,$A5,$67,$FF,$FF,$FF           ] , 'vcvtsi2sd  xmm15,xmm8,dword [rbp+r12*4-0x99]'     );
  TestCase.testcase(605, [$C4,$21,$7D,$7E,$84,$2C,$67,$FF,$FF,$FF           ] , 'vmovd  dword [rsp+r13*1-0x99],xmm8'               );
  TestCase.testcase(606, [$C4,$21,$3F,$2A,$BC,$2C,$67,$FF,$FF,$FF           ] , 'vcvtsi2sd  xmm15,xmm8,dword [rsp+r13*1-0x99]'     );
  TestCase.testcase(607, [$C4,$41,$7D,$7E,$C0                               ] , 'vmovd  r8d,xmm8'                                  );
  TestCase.testcase(608, [$C4,$41,$7F,$2D,$C0                               ] , 'vcvtsd2si  r8d,xmm8'                              );
  TestCase.testcase(609, [$C4,$41,$3F,$2A,$F8                               ] , 'vcvtsi2sd  xmm15,xmm8,r8d'                        );
  TestCase.testcase(610, [$C4,$61,$FF,$2D,$01                               ] , 'vcvtsd2si  r8,qword [rcx]'                        );
  TestCase.testcase(611, [$C4,$61,$FE,$2D,$01                               ] , 'vcvtss2si  r8,dword [rcx]'                        );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x64.avx_scalar.log');
end;

end.