unit x64.avx512f;

// This unit was generated by d2p.pl script.
// Source : gas/x86-64-avx512f-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x64.avx512f');
  TestCase.Start();	
  TestCase.Arch := CPUX64;

  TestCase.testcase(0, [$62,$01,$95,$40,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(1, [$62,$01,$95,$47,$58,$F4                           ] , 'vaddpd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(2, [$62,$01,$95,$C7,$58,$F4                           ] , 'vaddpd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(3, [$62,$01,$95,$10,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(4, [$62,$01,$95,$50,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(5, [$62,$01,$95,$30,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(6, [$62,$01,$95,$70,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(7, [$62,$61,$95,$40,$58,$31                           ] , 'vaddpd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(8, [$62,$21,$95,$40,$58,$B4,$F0,$23,$01,$00,$00       ] , 'vaddpd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(9, [$62,$61,$95,$50,$58,$31                           ] , 'vaddpd  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(10, [$62,$61,$95,$40,$58,$72,$7F                       ] , 'vaddpd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(11, [$62,$61,$95,$40,$58,$B2,$00,$20,$00,$00           ] , 'vaddpd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(12, [$62,$61,$95,$40,$58,$72,$80                       ] , 'vaddpd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(13, [$62,$61,$95,$40,$58,$B2,$C0,$DF,$FF,$FF           ] , 'vaddpd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(14, [$62,$61,$95,$50,$58,$72,$7F                       ] , 'vaddpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(15, [$62,$61,$95,$50,$58,$B2,$00,$04,$00,$00           ] , 'vaddpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(16, [$62,$61,$95,$50,$58,$72,$80                       ] , 'vaddpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(17, [$62,$61,$95,$50,$58,$B2,$F8,$FB,$FF,$FF           ] , 'vaddpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(18, [$62,$01,$14,$40,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(19, [$62,$01,$14,$47,$58,$F4                           ] , 'vaddps  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(20, [$62,$01,$14,$C7,$58,$F4                           ] , 'vaddps  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(21, [$62,$01,$14,$10,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(22, [$62,$01,$14,$50,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(23, [$62,$01,$14,$30,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(24, [$62,$01,$14,$70,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(25, [$62,$61,$14,$40,$58,$31                           ] , 'vaddps  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(26, [$62,$21,$14,$40,$58,$B4,$F0,$23,$01,$00,$00       ] , 'vaddps  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(27, [$62,$61,$14,$50,$58,$31                           ] , 'vaddps  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(28, [$62,$61,$14,$40,$58,$72,$7F                       ] , 'vaddps  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(29, [$62,$61,$14,$40,$58,$B2,$00,$20,$00,$00           ] , 'vaddps  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(30, [$62,$61,$14,$40,$58,$72,$80                       ] , 'vaddps  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(31, [$62,$61,$14,$40,$58,$B2,$C0,$DF,$FF,$FF           ] , 'vaddps  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(32, [$62,$61,$14,$50,$58,$72,$7F                       ] , 'vaddps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(33, [$62,$61,$14,$50,$58,$B2,$00,$02,$00,$00           ] , 'vaddps  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(34, [$62,$61,$14,$50,$58,$72,$80                       ] , 'vaddps  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(35, [$62,$61,$14,$50,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vaddps  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(36, [$62,$01,$97,$07,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(37, [$62,$01,$97,$87,$58,$F4                           ] , 'vaddsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(38, [$62,$01,$97,$17,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(39, [$62,$01,$97,$57,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(40, [$62,$01,$97,$37,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(41, [$62,$01,$97,$77,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(42, [$62,$61,$97,$07,$58,$31                           ] , 'vaddsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(43, [$62,$21,$97,$07,$58,$B4,$F0,$23,$01,$00,$00       ] , 'vaddsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(44, [$62,$61,$97,$07,$58,$72,$7F                       ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(45, [$62,$61,$97,$07,$58,$B2,$00,$04,$00,$00           ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(46, [$62,$61,$97,$07,$58,$72,$80                       ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(47, [$62,$61,$97,$07,$58,$B2,$F8,$FB,$FF,$FF           ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(48, [$62,$01,$16,$07,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(49, [$62,$01,$16,$87,$58,$F4                           ] , 'vaddss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(50, [$62,$01,$16,$17,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(51, [$62,$01,$16,$57,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(52, [$62,$01,$16,$37,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(53, [$62,$01,$16,$77,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(54, [$62,$61,$16,$07,$58,$31                           ] , 'vaddss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(55, [$62,$21,$16,$07,$58,$B4,$F0,$23,$01,$00,$00       ] , 'vaddss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(56, [$62,$61,$16,$07,$58,$72,$7F                       ] , 'vaddss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(57, [$62,$61,$16,$07,$58,$B2,$00,$02,$00,$00           ] , 'vaddss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(58, [$62,$61,$16,$07,$58,$72,$80                       ] , 'vaddss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(59, [$62,$61,$16,$07,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vaddss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(60, [$62,$03,$15,$40,$03,$F4,$AB                       ] , 'valignd  zmm30,zmm29,zmm28,0xab'                  );
  TestCase.testcase(61, [$62,$03,$15,$47,$03,$F4,$AB                       ] , 'valignd  zmm30{k7},zmm29,zmm28,0xab'              );
  TestCase.testcase(62, [$62,$03,$15,$C7,$03,$F4,$AB                       ] , 'valignd  zmm30{k7}{z},zmm29,zmm28,0xab'           );
  TestCase.testcase(63, [$62,$03,$15,$40,$03,$F4,$7B                       ] , 'valignd  zmm30,zmm29,zmm28,0x7b'                  );
  TestCase.testcase(64, [$62,$63,$15,$40,$03,$31,$7B                       ] , 'valignd  zmm30,zmm29,zword [rcx],0x7b'            );
  TestCase.testcase(65, [$62,$23,$15,$40,$03,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'valignd  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(66, [$62,$63,$15,$50,$03,$31,$7B                       ] , 'valignd  zmm30,zmm29,dword [rcx]{1to16},0x7b'     );
  TestCase.testcase(67, [$62,$63,$15,$40,$03,$72,$7F,$7B                   ] , 'valignd  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'     );
  TestCase.testcase(68, [$62,$63,$15,$40,$03,$B2,$00,$20,$00,$00,$7B       ] , 'valignd  zmm30,zmm29,zword [rdx+0x2000],0x7b'     );
  TestCase.testcase(69, [$62,$63,$15,$40,$03,$72,$80,$7B                   ] , 'valignd  zmm30,zmm29,zword [rdx-0x2000],0x7b'     );
  TestCase.testcase(70, [$62,$63,$15,$40,$03,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'valignd  zmm30,zmm29,zword [rdx-0x2040],0x7b'     );
  TestCase.testcase(71, [$62,$63,$15,$50,$03,$72,$7F,$7B                   ] , 'valignd  zmm30,zmm29,dword [rdx+0x1fc]{1to16},0x7b' );
  TestCase.testcase(72, [$62,$63,$15,$50,$03,$B2,$00,$02,$00,$00,$7B       ] , 'valignd  zmm30,zmm29,dword [rdx+0x200]{1to16},0x7b' );
  TestCase.testcase(73, [$62,$63,$15,$50,$03,$72,$80,$7B                   ] , 'valignd  zmm30,zmm29,dword [rdx-0x200]{1to16},0x7b' );
  TestCase.testcase(74, [$62,$63,$15,$50,$03,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'valignd  zmm30,zmm29,dword [rdx-0x204]{1to16},0x7b' );
  TestCase.testcase(75, [$62,$02,$95,$40,$65,$F4                           ] , 'vblendmpd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(76, [$62,$02,$95,$47,$65,$F4                           ] , 'vblendmpd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(77, [$62,$02,$95,$C7,$65,$F4                           ] , 'vblendmpd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(78, [$62,$62,$95,$40,$65,$31                           ] , 'vblendmpd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(79, [$62,$22,$95,$40,$65,$B4,$F0,$23,$01,$00,$00       ] , 'vblendmpd  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(80, [$62,$62,$95,$50,$65,$31                           ] , 'vblendmpd  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(81, [$62,$62,$95,$40,$65,$72,$7F                       ] , 'vblendmpd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(82, [$62,$62,$95,$40,$65,$B2,$00,$20,$00,$00           ] , 'vblendmpd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(83, [$62,$62,$95,$40,$65,$72,$80                       ] , 'vblendmpd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(84, [$62,$62,$95,$40,$65,$B2,$C0,$DF,$FF,$FF           ] , 'vblendmpd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(85, [$62,$62,$95,$50,$65,$72,$7F                       ] , 'vblendmpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(86, [$62,$62,$95,$50,$65,$B2,$00,$04,$00,$00           ] , 'vblendmpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(87, [$62,$62,$95,$50,$65,$72,$80                       ] , 'vblendmpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(88, [$62,$62,$95,$50,$65,$B2,$F8,$FB,$FF,$FF           ] , 'vblendmpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(89, [$62,$02,$15,$40,$65,$F4                           ] , 'vblendmps  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(90, [$62,$02,$15,$47,$65,$F4                           ] , 'vblendmps  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(91, [$62,$02,$15,$C7,$65,$F4                           ] , 'vblendmps  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(92, [$62,$62,$15,$40,$65,$31                           ] , 'vblendmps  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(93, [$62,$22,$15,$40,$65,$B4,$F0,$23,$01,$00,$00       ] , 'vblendmps  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(94, [$62,$62,$15,$50,$65,$31                           ] , 'vblendmps  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(95, [$62,$62,$15,$40,$65,$72,$7F                       ] , 'vblendmps  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(96, [$62,$62,$15,$40,$65,$B2,$00,$20,$00,$00           ] , 'vblendmps  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(97, [$62,$62,$15,$40,$65,$72,$80                       ] , 'vblendmps  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(98, [$62,$62,$15,$40,$65,$B2,$C0,$DF,$FF,$FF           ] , 'vblendmps  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(99, [$62,$62,$15,$50,$65,$72,$7F                       ] , 'vblendmps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(100, [$62,$62,$15,$50,$65,$B2,$00,$02,$00,$00           ] , 'vblendmps  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(101, [$62,$62,$15,$50,$65,$72,$80                       ] , 'vblendmps  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(102, [$62,$62,$15,$50,$65,$B2,$FC,$FD,$FF,$FF           ] , 'vblendmps  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(103, [$62,$62,$7D,$48,$1A,$31                           ] , 'vbroadcastf32x4  zmm30,oword [rcx]'               );
  TestCase.testcase(104, [$62,$62,$7D,$4F,$1A,$31                           ] , 'vbroadcastf32x4  zmm30{k7},oword [rcx]'           );
  TestCase.testcase(105, [$62,$62,$7D,$CF,$1A,$31                           ] , 'vbroadcastf32x4  zmm30{k7}{z},oword [rcx]'        );
  TestCase.testcase(106, [$62,$22,$7D,$48,$1A,$B4,$F0,$23,$01,$00,$00       ] , 'vbroadcastf32x4  zmm30,oword [rax+r14*8+0x123]'   );
  TestCase.testcase(107, [$62,$62,$7D,$48,$1A,$72,$7F                       ] , 'vbroadcastf32x4  zmm30,oword [rdx+0x7f0]'         );
  TestCase.testcase(108, [$62,$62,$7D,$48,$1A,$B2,$00,$08,$00,$00           ] , 'vbroadcastf32x4  zmm30,oword [rdx+0x800]'         );
  TestCase.testcase(109, [$62,$62,$7D,$48,$1A,$72,$80                       ] , 'vbroadcastf32x4  zmm30,oword [rdx-0x800]'         );
  TestCase.testcase(110, [$62,$62,$7D,$48,$1A,$B2,$F0,$F7,$FF,$FF           ] , 'vbroadcastf32x4  zmm30,oword [rdx-0x810]'         );
  TestCase.testcase(111, [$62,$62,$FD,$48,$1B,$31                           ] , 'vbroadcastf64x4  zmm30,yword [rcx]'               );
  TestCase.testcase(112, [$62,$62,$FD,$4F,$1B,$31                           ] , 'vbroadcastf64x4  zmm30{k7},yword [rcx]'           );
  TestCase.testcase(113, [$62,$62,$FD,$CF,$1B,$31                           ] , 'vbroadcastf64x4  zmm30{k7}{z},yword [rcx]'        );
  TestCase.testcase(114, [$62,$22,$FD,$48,$1B,$B4,$F0,$23,$01,$00,$00       ] , 'vbroadcastf64x4  zmm30,yword [rax+r14*8+0x123]'   );
  TestCase.testcase(115, [$62,$62,$FD,$48,$1B,$72,$7F                       ] , 'vbroadcastf64x4  zmm30,yword [rdx+0xfe0]'         );
  TestCase.testcase(116, [$62,$62,$FD,$48,$1B,$B2,$00,$10,$00,$00           ] , 'vbroadcastf64x4  zmm30,yword [rdx+0x1000]'        );
  TestCase.testcase(117, [$62,$62,$FD,$48,$1B,$72,$80                       ] , 'vbroadcastf64x4  zmm30,yword [rdx-0x1000]'        );
  TestCase.testcase(118, [$62,$62,$FD,$48,$1B,$B2,$E0,$EF,$FF,$FF           ] , 'vbroadcastf64x4  zmm30,yword [rdx-0x1020]'        );
  TestCase.testcase(119, [$62,$62,$7D,$48,$5A,$31                           ] , 'vbroadcasti32x4  zmm30,oword [rcx]'               );
  TestCase.testcase(120, [$62,$62,$7D,$4F,$5A,$31                           ] , 'vbroadcasti32x4  zmm30{k7},oword [rcx]'           );
  TestCase.testcase(121, [$62,$62,$7D,$CF,$5A,$31                           ] , 'vbroadcasti32x4  zmm30{k7}{z},oword [rcx]'        );
  TestCase.testcase(122, [$62,$22,$7D,$48,$5A,$B4,$F0,$23,$01,$00,$00       ] , 'vbroadcasti32x4  zmm30,oword [rax+r14*8+0x123]'   );
  TestCase.testcase(123, [$62,$62,$7D,$48,$5A,$72,$7F                       ] , 'vbroadcasti32x4  zmm30,oword [rdx+0x7f0]'         );
  TestCase.testcase(124, [$62,$62,$7D,$48,$5A,$B2,$00,$08,$00,$00           ] , 'vbroadcasti32x4  zmm30,oword [rdx+0x800]'         );
  TestCase.testcase(125, [$62,$62,$7D,$48,$5A,$72,$80                       ] , 'vbroadcasti32x4  zmm30,oword [rdx-0x800]'         );
  TestCase.testcase(126, [$62,$62,$7D,$48,$5A,$B2,$F0,$F7,$FF,$FF           ] , 'vbroadcasti32x4  zmm30,oword [rdx-0x810]'         );
  TestCase.testcase(127, [$62,$62,$FD,$48,$5B,$31                           ] , 'vbroadcasti64x4  zmm30,yword [rcx]'               );
  TestCase.testcase(128, [$62,$62,$FD,$4F,$5B,$31                           ] , 'vbroadcasti64x4  zmm30{k7},yword [rcx]'           );
  TestCase.testcase(129, [$62,$62,$FD,$CF,$5B,$31                           ] , 'vbroadcasti64x4  zmm30{k7}{z},yword [rcx]'        );
  TestCase.testcase(130, [$62,$22,$FD,$48,$5B,$B4,$F0,$23,$01,$00,$00       ] , 'vbroadcasti64x4  zmm30,yword [rax+r14*8+0x123]'   );
  TestCase.testcase(131, [$62,$62,$FD,$48,$5B,$72,$7F                       ] , 'vbroadcasti64x4  zmm30,yword [rdx+0xfe0]'         );
  TestCase.testcase(132, [$62,$62,$FD,$48,$5B,$B2,$00,$10,$00,$00           ] , 'vbroadcasti64x4  zmm30,yword [rdx+0x1000]'        );
  TestCase.testcase(133, [$62,$62,$FD,$48,$5B,$72,$80                       ] , 'vbroadcasti64x4  zmm30,yword [rdx-0x1000]'        );
  TestCase.testcase(134, [$62,$62,$FD,$48,$5B,$B2,$E0,$EF,$FF,$FF           ] , 'vbroadcasti64x4  zmm30,yword [rdx-0x1020]'        );
  TestCase.testcase(135, [$62,$62,$FD,$48,$19,$31                           ] , 'vbroadcastsd  zmm30,qword [rcx]'                  );
  TestCase.testcase(136, [$62,$62,$FD,$4F,$19,$31                           ] , 'vbroadcastsd  zmm30{k7},qword [rcx]'              );
  TestCase.testcase(137, [$62,$62,$FD,$CF,$19,$31                           ] , 'vbroadcastsd  zmm30{k7}{z},qword [rcx]'           );
  TestCase.testcase(138, [$62,$22,$FD,$48,$19,$B4,$F0,$23,$01,$00,$00       ] , 'vbroadcastsd  zmm30,qword [rax+r14*8+0x123]'      );
  TestCase.testcase(139, [$62,$62,$FD,$48,$19,$72,$7F                       ] , 'vbroadcastsd  zmm30,qword [rdx+0x3f8]'            );
  TestCase.testcase(140, [$62,$62,$FD,$48,$19,$B2,$00,$04,$00,$00           ] , 'vbroadcastsd  zmm30,qword [rdx+0x400]'            );
  TestCase.testcase(141, [$62,$62,$FD,$48,$19,$72,$80                       ] , 'vbroadcastsd  zmm30,qword [rdx-0x400]'            );
  TestCase.testcase(142, [$62,$62,$FD,$48,$19,$B2,$F8,$FB,$FF,$FF           ] , 'vbroadcastsd  zmm30,qword [rdx-0x408]'            );
  TestCase.testcase(143, [$62,$02,$FD,$4F,$19,$F5                           ] , 'vbroadcastsd  zmm30{k7},xmm29'                    );
  TestCase.testcase(144, [$62,$02,$FD,$CF,$19,$F5                           ] , 'vbroadcastsd  zmm30{k7}{z},xmm29'                 );
  TestCase.testcase(145, [$62,$62,$7D,$48,$18,$31                           ] , 'vbroadcastss  zmm30,dword [rcx]'                  );
  TestCase.testcase(146, [$62,$62,$7D,$4F,$18,$31                           ] , 'vbroadcastss  zmm30{k7},dword [rcx]'              );
  TestCase.testcase(147, [$62,$62,$7D,$CF,$18,$31                           ] , 'vbroadcastss  zmm30{k7}{z},dword [rcx]'           );
  TestCase.testcase(148, [$62,$22,$7D,$48,$18,$B4,$F0,$23,$01,$00,$00       ] , 'vbroadcastss  zmm30,dword [rax+r14*8+0x123]'      );
  TestCase.testcase(149, [$62,$62,$7D,$48,$18,$72,$7F                       ] , 'vbroadcastss  zmm30,dword [rdx+0x1fc]'            );
  TestCase.testcase(150, [$62,$62,$7D,$48,$18,$B2,$00,$02,$00,$00           ] , 'vbroadcastss  zmm30,dword [rdx+0x200]'            );
  TestCase.testcase(151, [$62,$62,$7D,$48,$18,$72,$80                       ] , 'vbroadcastss  zmm30,dword [rdx-0x200]'            );
  TestCase.testcase(152, [$62,$62,$7D,$48,$18,$B2,$FC,$FD,$FF,$FF           ] , 'vbroadcastss  zmm30,dword [rdx-0x204]'            );
  TestCase.testcase(153, [$62,$02,$7D,$4F,$18,$F5                           ] , 'vbroadcastss  zmm30{k7},xmm29'                    );
  TestCase.testcase(154, [$62,$02,$7D,$CF,$18,$F5                           ] , 'vbroadcastss  zmm30{k7}{z},xmm29'                 );
  TestCase.testcase(155, [$62,$91,$8D,$40,$C2,$ED,$AB                       ] , 'vcmppd  k5,zmm30,zmm29,0xab'                      );
  TestCase.testcase(156, [$62,$91,$8D,$47,$C2,$ED,$AB                       ] , 'vcmppd  k5{k7},zmm30,zmm29,0xab'                  );
  TestCase.testcase(157, [$62,$91,$8D,$10,$C2,$ED,$AB                       ] , 'vcmppd  k5,zmm30,zmm29,{sae},0xab'                );
  TestCase.testcase(158, [$62,$91,$8D,$40,$C2,$ED,$7B                       ] , 'vcmppd  k5,zmm30,zmm29,0x7b'                      );
  TestCase.testcase(159, [$62,$91,$8D,$10,$C2,$ED,$7B                       ] , 'vcmppd  k5,zmm30,zmm29,{sae},0x7b'                );
  TestCase.testcase(160, [$62,$F1,$8D,$40,$C2,$29,$7B                       ] , 'vcmppd  k5,zmm30,zword [rcx],0x7b'                );
  TestCase.testcase(161, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vcmppd  k5,zmm30,zword [rax+r14*8+0x123],0x7b'    );
  TestCase.testcase(162, [$62,$F1,$8D,$50,$C2,$29,$7B                       ] , 'vcmppd  k5,zmm30,qword [rcx]{1to8},0x7b'          );
  TestCase.testcase(163, [$62,$F1,$8D,$40,$C2,$6A,$7F,$7B                   ] , 'vcmppd  k5,zmm30,zword [rdx+0x1fc0],0x7b'         );
  TestCase.testcase(164, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$7B       ] , 'vcmppd  k5,zmm30,zword [rdx+0x2000],0x7b'         );
  TestCase.testcase(165, [$62,$F1,$8D,$40,$C2,$6A,$80,$7B                   ] , 'vcmppd  k5,zmm30,zword [rdx-0x2000],0x7b'         );
  TestCase.testcase(166, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$7B       ] , 'vcmppd  k5,zmm30,zword [rdx-0x2040],0x7b'         );
  TestCase.testcase(167, [$62,$F1,$8D,$50,$C2,$6A,$7F,$7B                   ] , 'vcmppd  k5,zmm30,qword [rdx+0x3f8]{1to8},0x7b'    );
  TestCase.testcase(168, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$7B       ] , 'vcmppd  k5,zmm30,qword [rdx+0x400]{1to8},0x7b'    );
  TestCase.testcase(169, [$62,$F1,$8D,$50,$C2,$6A,$80,$7B                   ] , 'vcmppd  k5,zmm30,qword [rdx-0x400]{1to8},0x7b'    );
  TestCase.testcase(170, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vcmppd  k5,zmm30,qword [rdx-0x408]{1to8},0x7b'    );
  TestCase.testcase(171, [$62,$91,$8D,$40,$C2,$ED,$00                       ] , 'vcmpeqpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(172, [$62,$91,$8D,$47,$C2,$ED,$00                       ] , 'vcmpeqpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(173, [$62,$91,$8D,$10,$C2,$ED,$00                       ] , 'vcmpeqpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(174, [$62,$F1,$8D,$40,$C2,$29,$00                       ] , 'vcmpeqpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(175, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqpd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(176, [$62,$F1,$8D,$50,$C2,$29,$00                       ] , 'vcmpeqpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(177, [$62,$F1,$8D,$40,$C2,$6A,$7F,$00                   ] , 'vcmpeqpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(178, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$00       ] , 'vcmpeqpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(179, [$62,$F1,$8D,$40,$C2,$6A,$80,$00                   ] , 'vcmpeqpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(180, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$00       ] , 'vcmpeqpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(181, [$62,$F1,$8D,$50,$C2,$6A,$7F,$00                   ] , 'vcmpeqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(182, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(183, [$62,$F1,$8D,$50,$C2,$6A,$80,$00                   ] , 'vcmpeqpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(184, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(185, [$62,$91,$8D,$40,$C2,$ED,$00                       ] , 'vcmpeqpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(186, [$62,$91,$8D,$47,$C2,$ED,$00                       ] , 'vcmpeqpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(187, [$62,$91,$8D,$10,$C2,$ED,$00                       ] , 'vcmpeqpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(188, [$62,$F1,$8D,$40,$C2,$29,$00                       ] , 'vcmpeqpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(189, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqpd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(190, [$62,$F1,$8D,$50,$C2,$29,$00                       ] , 'vcmpeqpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(191, [$62,$F1,$8D,$40,$C2,$6A,$7F,$00                   ] , 'vcmpeqpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(192, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$00       ] , 'vcmpeqpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(193, [$62,$F1,$8D,$40,$C2,$6A,$80,$00                   ] , 'vcmpeqpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(194, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$00       ] , 'vcmpeqpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(195, [$62,$F1,$8D,$50,$C2,$6A,$7F,$00                   ] , 'vcmpeqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(196, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(197, [$62,$F1,$8D,$50,$C2,$6A,$80,$00                   ] , 'vcmpeqpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(198, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(199, [$62,$91,$8D,$40,$C2,$ED,$01                       ] , 'vcmpltpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(200, [$62,$91,$8D,$47,$C2,$ED,$01                       ] , 'vcmpltpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(201, [$62,$91,$8D,$10,$C2,$ED,$01                       ] , 'vcmpltpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(202, [$62,$F1,$8D,$40,$C2,$29,$01                       ] , 'vcmpltpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(203, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltpd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(204, [$62,$F1,$8D,$50,$C2,$29,$01                       ] , 'vcmpltpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(205, [$62,$F1,$8D,$40,$C2,$6A,$7F,$01                   ] , 'vcmpltpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(206, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$01       ] , 'vcmpltpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(207, [$62,$F1,$8D,$40,$C2,$6A,$80,$01                   ] , 'vcmpltpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(208, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vcmpltpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(209, [$62,$F1,$8D,$50,$C2,$6A,$7F,$01                   ] , 'vcmpltpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(210, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(211, [$62,$F1,$8D,$50,$C2,$6A,$80,$01                   ] , 'vcmpltpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(212, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(213, [$62,$91,$8D,$40,$C2,$ED,$01                       ] , 'vcmpltpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(214, [$62,$91,$8D,$47,$C2,$ED,$01                       ] , 'vcmpltpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(215, [$62,$91,$8D,$10,$C2,$ED,$01                       ] , 'vcmpltpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(216, [$62,$F1,$8D,$40,$C2,$29,$01                       ] , 'vcmpltpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(217, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltpd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(218, [$62,$F1,$8D,$50,$C2,$29,$01                       ] , 'vcmpltpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(219, [$62,$F1,$8D,$40,$C2,$6A,$7F,$01                   ] , 'vcmpltpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(220, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$01       ] , 'vcmpltpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(221, [$62,$F1,$8D,$40,$C2,$6A,$80,$01                   ] , 'vcmpltpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(222, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vcmpltpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(223, [$62,$F1,$8D,$50,$C2,$6A,$7F,$01                   ] , 'vcmpltpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(224, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(225, [$62,$F1,$8D,$50,$C2,$6A,$80,$01                   ] , 'vcmpltpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(226, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(227, [$62,$91,$8D,$40,$C2,$ED,$02                       ] , 'vcmplepd  k5,zmm30,zmm29'                         );
  TestCase.testcase(228, [$62,$91,$8D,$47,$C2,$ED,$02                       ] , 'vcmplepd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(229, [$62,$91,$8D,$10,$C2,$ED,$02                       ] , 'vcmplepd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(230, [$62,$F1,$8D,$40,$C2,$29,$02                       ] , 'vcmplepd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(231, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmplepd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(232, [$62,$F1,$8D,$50,$C2,$29,$02                       ] , 'vcmplepd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(233, [$62,$F1,$8D,$40,$C2,$6A,$7F,$02                   ] , 'vcmplepd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(234, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$02       ] , 'vcmplepd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(235, [$62,$F1,$8D,$40,$C2,$6A,$80,$02                   ] , 'vcmplepd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(236, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vcmplepd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(237, [$62,$F1,$8D,$50,$C2,$6A,$7F,$02                   ] , 'vcmplepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(238, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplepd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(239, [$62,$F1,$8D,$50,$C2,$6A,$80,$02                   ] , 'vcmplepd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(240, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplepd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(241, [$62,$91,$8D,$40,$C2,$ED,$02                       ] , 'vcmplepd  k5,zmm30,zmm29'                         );
  TestCase.testcase(242, [$62,$91,$8D,$47,$C2,$ED,$02                       ] , 'vcmplepd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(243, [$62,$91,$8D,$10,$C2,$ED,$02                       ] , 'vcmplepd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(244, [$62,$F1,$8D,$40,$C2,$29,$02                       ] , 'vcmplepd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(245, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmplepd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(246, [$62,$F1,$8D,$50,$C2,$29,$02                       ] , 'vcmplepd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(247, [$62,$F1,$8D,$40,$C2,$6A,$7F,$02                   ] , 'vcmplepd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(248, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$02       ] , 'vcmplepd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(249, [$62,$F1,$8D,$40,$C2,$6A,$80,$02                   ] , 'vcmplepd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(250, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vcmplepd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(251, [$62,$F1,$8D,$50,$C2,$6A,$7F,$02                   ] , 'vcmplepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(252, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplepd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(253, [$62,$F1,$8D,$50,$C2,$6A,$80,$02                   ] , 'vcmplepd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(254, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplepd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(255, [$62,$91,$8D,$40,$C2,$ED,$03                       ] , 'vcmpunordpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(256, [$62,$91,$8D,$47,$C2,$ED,$03                       ] , 'vcmpunordpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(257, [$62,$91,$8D,$10,$C2,$ED,$03                       ] , 'vcmpunordpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(258, [$62,$F1,$8D,$40,$C2,$29,$03                       ] , 'vcmpunordpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(259, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordpd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(260, [$62,$F1,$8D,$50,$C2,$29,$03                       ] , 'vcmpunordpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(261, [$62,$F1,$8D,$40,$C2,$6A,$7F,$03                   ] , 'vcmpunordpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(262, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$03       ] , 'vcmpunordpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(263, [$62,$F1,$8D,$40,$C2,$6A,$80,$03                   ] , 'vcmpunordpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(264, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$03       ] , 'vcmpunordpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(265, [$62,$F1,$8D,$50,$C2,$6A,$7F,$03                   ] , 'vcmpunordpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(266, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(267, [$62,$F1,$8D,$50,$C2,$6A,$80,$03                   ] , 'vcmpunordpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(268, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(269, [$62,$91,$8D,$40,$C2,$ED,$03                       ] , 'vcmpunordpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(270, [$62,$91,$8D,$47,$C2,$ED,$03                       ] , 'vcmpunordpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(271, [$62,$91,$8D,$10,$C2,$ED,$03                       ] , 'vcmpunordpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(272, [$62,$F1,$8D,$40,$C2,$29,$03                       ] , 'vcmpunordpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(273, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordpd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(274, [$62,$F1,$8D,$50,$C2,$29,$03                       ] , 'vcmpunordpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(275, [$62,$F1,$8D,$40,$C2,$6A,$7F,$03                   ] , 'vcmpunordpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(276, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$03       ] , 'vcmpunordpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(277, [$62,$F1,$8D,$40,$C2,$6A,$80,$03                   ] , 'vcmpunordpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(278, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$03       ] , 'vcmpunordpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(279, [$62,$F1,$8D,$50,$C2,$6A,$7F,$03                   ] , 'vcmpunordpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(280, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(281, [$62,$F1,$8D,$50,$C2,$6A,$80,$03                   ] , 'vcmpunordpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(282, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(283, [$62,$91,$8D,$40,$C2,$ED,$04                       ] , 'vcmpneqpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(284, [$62,$91,$8D,$47,$C2,$ED,$04                       ] , 'vcmpneqpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(285, [$62,$91,$8D,$10,$C2,$ED,$04                       ] , 'vcmpneqpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(286, [$62,$F1,$8D,$40,$C2,$29,$04                       ] , 'vcmpneqpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(287, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqpd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(288, [$62,$F1,$8D,$50,$C2,$29,$04                       ] , 'vcmpneqpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(289, [$62,$F1,$8D,$40,$C2,$6A,$7F,$04                   ] , 'vcmpneqpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(290, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$04       ] , 'vcmpneqpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(291, [$62,$F1,$8D,$40,$C2,$6A,$80,$04                   ] , 'vcmpneqpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(292, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vcmpneqpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(293, [$62,$F1,$8D,$50,$C2,$6A,$7F,$04                   ] , 'vcmpneqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(294, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(295, [$62,$F1,$8D,$50,$C2,$6A,$80,$04                   ] , 'vcmpneqpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(296, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(297, [$62,$91,$8D,$40,$C2,$ED,$04                       ] , 'vcmpneqpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(298, [$62,$91,$8D,$47,$C2,$ED,$04                       ] , 'vcmpneqpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(299, [$62,$91,$8D,$10,$C2,$ED,$04                       ] , 'vcmpneqpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(300, [$62,$F1,$8D,$40,$C2,$29,$04                       ] , 'vcmpneqpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(301, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqpd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(302, [$62,$F1,$8D,$50,$C2,$29,$04                       ] , 'vcmpneqpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(303, [$62,$F1,$8D,$40,$C2,$6A,$7F,$04                   ] , 'vcmpneqpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(304, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$04       ] , 'vcmpneqpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(305, [$62,$F1,$8D,$40,$C2,$6A,$80,$04                   ] , 'vcmpneqpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(306, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vcmpneqpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(307, [$62,$F1,$8D,$50,$C2,$6A,$7F,$04                   ] , 'vcmpneqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(308, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(309, [$62,$F1,$8D,$50,$C2,$6A,$80,$04                   ] , 'vcmpneqpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(310, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(311, [$62,$91,$8D,$40,$C2,$ED,$05                       ] , 'vcmpnltpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(312, [$62,$91,$8D,$47,$C2,$ED,$05                       ] , 'vcmpnltpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(313, [$62,$91,$8D,$10,$C2,$ED,$05                       ] , 'vcmpnltpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(314, [$62,$F1,$8D,$40,$C2,$29,$05                       ] , 'vcmpnltpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(315, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltpd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(316, [$62,$F1,$8D,$50,$C2,$29,$05                       ] , 'vcmpnltpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(317, [$62,$F1,$8D,$40,$C2,$6A,$7F,$05                   ] , 'vcmpnltpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(318, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$05       ] , 'vcmpnltpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(319, [$62,$F1,$8D,$40,$C2,$6A,$80,$05                   ] , 'vcmpnltpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(320, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vcmpnltpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(321, [$62,$F1,$8D,$50,$C2,$6A,$7F,$05                   ] , 'vcmpnltpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(322, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(323, [$62,$F1,$8D,$50,$C2,$6A,$80,$05                   ] , 'vcmpnltpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(324, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(325, [$62,$91,$8D,$40,$C2,$ED,$05                       ] , 'vcmpnltpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(326, [$62,$91,$8D,$47,$C2,$ED,$05                       ] , 'vcmpnltpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(327, [$62,$91,$8D,$10,$C2,$ED,$05                       ] , 'vcmpnltpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(328, [$62,$F1,$8D,$40,$C2,$29,$05                       ] , 'vcmpnltpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(329, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltpd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(330, [$62,$F1,$8D,$50,$C2,$29,$05                       ] , 'vcmpnltpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(331, [$62,$F1,$8D,$40,$C2,$6A,$7F,$05                   ] , 'vcmpnltpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(332, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$05       ] , 'vcmpnltpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(333, [$62,$F1,$8D,$40,$C2,$6A,$80,$05                   ] , 'vcmpnltpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(334, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vcmpnltpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(335, [$62,$F1,$8D,$50,$C2,$6A,$7F,$05                   ] , 'vcmpnltpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(336, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(337, [$62,$F1,$8D,$50,$C2,$6A,$80,$05                   ] , 'vcmpnltpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(338, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(339, [$62,$91,$8D,$40,$C2,$ED,$06                       ] , 'vcmpnlepd  k5,zmm30,zmm29'                        );
  TestCase.testcase(340, [$62,$91,$8D,$47,$C2,$ED,$06                       ] , 'vcmpnlepd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(341, [$62,$91,$8D,$10,$C2,$ED,$06                       ] , 'vcmpnlepd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(342, [$62,$F1,$8D,$40,$C2,$29,$06                       ] , 'vcmpnlepd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(343, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnlepd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(344, [$62,$F1,$8D,$50,$C2,$29,$06                       ] , 'vcmpnlepd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(345, [$62,$F1,$8D,$40,$C2,$6A,$7F,$06                   ] , 'vcmpnlepd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(346, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$06       ] , 'vcmpnlepd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(347, [$62,$F1,$8D,$40,$C2,$6A,$80,$06                   ] , 'vcmpnlepd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(348, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vcmpnlepd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(349, [$62,$F1,$8D,$50,$C2,$6A,$7F,$06                   ] , 'vcmpnlepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(350, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlepd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(351, [$62,$F1,$8D,$50,$C2,$6A,$80,$06                   ] , 'vcmpnlepd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(352, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlepd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(353, [$62,$91,$8D,$40,$C2,$ED,$06                       ] , 'vcmpnlepd  k5,zmm30,zmm29'                        );
  TestCase.testcase(354, [$62,$91,$8D,$47,$C2,$ED,$06                       ] , 'vcmpnlepd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(355, [$62,$91,$8D,$10,$C2,$ED,$06                       ] , 'vcmpnlepd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(356, [$62,$F1,$8D,$40,$C2,$29,$06                       ] , 'vcmpnlepd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(357, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnlepd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(358, [$62,$F1,$8D,$50,$C2,$29,$06                       ] , 'vcmpnlepd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(359, [$62,$F1,$8D,$40,$C2,$6A,$7F,$06                   ] , 'vcmpnlepd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(360, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$06       ] , 'vcmpnlepd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(361, [$62,$F1,$8D,$40,$C2,$6A,$80,$06                   ] , 'vcmpnlepd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(362, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vcmpnlepd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(363, [$62,$F1,$8D,$50,$C2,$6A,$7F,$06                   ] , 'vcmpnlepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(364, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlepd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(365, [$62,$F1,$8D,$50,$C2,$6A,$80,$06                   ] , 'vcmpnlepd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(366, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlepd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(367, [$62,$91,$8D,$40,$C2,$ED,$07                       ] , 'vcmpordpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(368, [$62,$91,$8D,$47,$C2,$ED,$07                       ] , 'vcmpordpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(369, [$62,$91,$8D,$10,$C2,$ED,$07                       ] , 'vcmpordpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(370, [$62,$F1,$8D,$40,$C2,$29,$07                       ] , 'vcmpordpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(371, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordpd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(372, [$62,$F1,$8D,$50,$C2,$29,$07                       ] , 'vcmpordpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(373, [$62,$F1,$8D,$40,$C2,$6A,$7F,$07                   ] , 'vcmpordpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(374, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$07       ] , 'vcmpordpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(375, [$62,$F1,$8D,$40,$C2,$6A,$80,$07                   ] , 'vcmpordpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(376, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$07       ] , 'vcmpordpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(377, [$62,$F1,$8D,$50,$C2,$6A,$7F,$07                   ] , 'vcmpordpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(378, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(379, [$62,$F1,$8D,$50,$C2,$6A,$80,$07                   ] , 'vcmpordpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(380, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(381, [$62,$91,$8D,$40,$C2,$ED,$07                       ] , 'vcmpordpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(382, [$62,$91,$8D,$47,$C2,$ED,$07                       ] , 'vcmpordpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(383, [$62,$91,$8D,$10,$C2,$ED,$07                       ] , 'vcmpordpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(384, [$62,$F1,$8D,$40,$C2,$29,$07                       ] , 'vcmpordpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(385, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordpd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(386, [$62,$F1,$8D,$50,$C2,$29,$07                       ] , 'vcmpordpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(387, [$62,$F1,$8D,$40,$C2,$6A,$7F,$07                   ] , 'vcmpordpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(388, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$07       ] , 'vcmpordpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(389, [$62,$F1,$8D,$40,$C2,$6A,$80,$07                   ] , 'vcmpordpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(390, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$07       ] , 'vcmpordpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(391, [$62,$F1,$8D,$50,$C2,$6A,$7F,$07                   ] , 'vcmpordpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(392, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(393, [$62,$F1,$8D,$50,$C2,$6A,$80,$07                   ] , 'vcmpordpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(394, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(395, [$62,$91,$8D,$40,$C2,$ED,$08                       ] , 'vcmpeq_uqpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(396, [$62,$91,$8D,$47,$C2,$ED,$08                       ] , 'vcmpeq_uqpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(397, [$62,$91,$8D,$10,$C2,$ED,$08                       ] , 'vcmpeq_uqpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(398, [$62,$F1,$8D,$40,$C2,$29,$08                       ] , 'vcmpeq_uqpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(399, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$08   ] , 'vcmpeq_uqpd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(400, [$62,$F1,$8D,$50,$C2,$29,$08                       ] , 'vcmpeq_uqpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(401, [$62,$F1,$8D,$40,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(402, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$08       ] , 'vcmpeq_uqpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(403, [$62,$F1,$8D,$40,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(404, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$08       ] , 'vcmpeq_uqpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(405, [$62,$F1,$8D,$50,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(406, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$08       ] , 'vcmpeq_uqpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(407, [$62,$F1,$8D,$50,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(408, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$08       ] , 'vcmpeq_uqpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(409, [$62,$91,$8D,$40,$C2,$ED,$09                       ] , 'vcmpngepd  k5,zmm30,zmm29'                        );
  TestCase.testcase(410, [$62,$91,$8D,$47,$C2,$ED,$09                       ] , 'vcmpngepd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(411, [$62,$91,$8D,$10,$C2,$ED,$09                       ] , 'vcmpngepd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(412, [$62,$F1,$8D,$40,$C2,$29,$09                       ] , 'vcmpngepd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(413, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngepd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(414, [$62,$F1,$8D,$50,$C2,$29,$09                       ] , 'vcmpngepd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(415, [$62,$F1,$8D,$40,$C2,$6A,$7F,$09                   ] , 'vcmpngepd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(416, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$09       ] , 'vcmpngepd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(417, [$62,$F1,$8D,$40,$C2,$6A,$80,$09                   ] , 'vcmpngepd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(418, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$09       ] , 'vcmpngepd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(419, [$62,$F1,$8D,$50,$C2,$6A,$7F,$09                   ] , 'vcmpngepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(420, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngepd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(421, [$62,$F1,$8D,$50,$C2,$6A,$80,$09                   ] , 'vcmpngepd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(422, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngepd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(423, [$62,$91,$8D,$40,$C2,$ED,$09                       ] , 'vcmpngepd  k5,zmm30,zmm29'                        );
  TestCase.testcase(424, [$62,$91,$8D,$47,$C2,$ED,$09                       ] , 'vcmpngepd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(425, [$62,$91,$8D,$10,$C2,$ED,$09                       ] , 'vcmpngepd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(426, [$62,$F1,$8D,$40,$C2,$29,$09                       ] , 'vcmpngepd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(427, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngepd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(428, [$62,$F1,$8D,$50,$C2,$29,$09                       ] , 'vcmpngepd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(429, [$62,$F1,$8D,$40,$C2,$6A,$7F,$09                   ] , 'vcmpngepd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(430, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$09       ] , 'vcmpngepd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(431, [$62,$F1,$8D,$40,$C2,$6A,$80,$09                   ] , 'vcmpngepd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(432, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$09       ] , 'vcmpngepd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(433, [$62,$F1,$8D,$50,$C2,$6A,$7F,$09                   ] , 'vcmpngepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(434, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngepd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(435, [$62,$F1,$8D,$50,$C2,$6A,$80,$09                   ] , 'vcmpngepd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(436, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngepd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(437, [$62,$91,$8D,$40,$C2,$ED,$0A                       ] , 'vcmpngtpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(438, [$62,$91,$8D,$47,$C2,$ED,$0A                       ] , 'vcmpngtpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(439, [$62,$91,$8D,$10,$C2,$ED,$0A                       ] , 'vcmpngtpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(440, [$62,$F1,$8D,$40,$C2,$29,$0A                       ] , 'vcmpngtpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(441, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtpd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(442, [$62,$F1,$8D,$50,$C2,$29,$0A                       ] , 'vcmpngtpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(443, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0A                   ] , 'vcmpngtpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(444, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0A       ] , 'vcmpngtpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(445, [$62,$F1,$8D,$40,$C2,$6A,$80,$0A                   ] , 'vcmpngtpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(446, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0A       ] , 'vcmpngtpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(447, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0A                   ] , 'vcmpngtpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(448, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(449, [$62,$F1,$8D,$50,$C2,$6A,$80,$0A                   ] , 'vcmpngtpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(450, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(451, [$62,$91,$8D,$40,$C2,$ED,$0A                       ] , 'vcmpngtpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(452, [$62,$91,$8D,$47,$C2,$ED,$0A                       ] , 'vcmpngtpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(453, [$62,$91,$8D,$10,$C2,$ED,$0A                       ] , 'vcmpngtpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(454, [$62,$F1,$8D,$40,$C2,$29,$0A                       ] , 'vcmpngtpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(455, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtpd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(456, [$62,$F1,$8D,$50,$C2,$29,$0A                       ] , 'vcmpngtpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(457, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0A                   ] , 'vcmpngtpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(458, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0A       ] , 'vcmpngtpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(459, [$62,$F1,$8D,$40,$C2,$6A,$80,$0A                   ] , 'vcmpngtpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(460, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0A       ] , 'vcmpngtpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(461, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0A                   ] , 'vcmpngtpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(462, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(463, [$62,$F1,$8D,$50,$C2,$6A,$80,$0A                   ] , 'vcmpngtpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(464, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(465, [$62,$91,$8D,$40,$C2,$ED,$0B                       ] , 'vcmpfalsepd  k5,zmm30,zmm29'                      );
  TestCase.testcase(466, [$62,$91,$8D,$47,$C2,$ED,$0B                       ] , 'vcmpfalsepd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(467, [$62,$91,$8D,$10,$C2,$ED,$0B                       ] , 'vcmpfalsepd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(468, [$62,$F1,$8D,$40,$C2,$29,$0B                       ] , 'vcmpfalsepd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(469, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsepd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(470, [$62,$F1,$8D,$50,$C2,$29,$0B                       ] , 'vcmpfalsepd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(471, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsepd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(472, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0B       ] , 'vcmpfalsepd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(473, [$62,$F1,$8D,$40,$C2,$6A,$80,$0B                   ] , 'vcmpfalsepd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(474, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0B       ] , 'vcmpfalsepd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(475, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(476, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsepd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(477, [$62,$F1,$8D,$50,$C2,$6A,$80,$0B                   ] , 'vcmpfalsepd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(478, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsepd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(479, [$62,$91,$8D,$40,$C2,$ED,$0B                       ] , 'vcmpfalsepd  k5,zmm30,zmm29'                      );
  TestCase.testcase(480, [$62,$91,$8D,$47,$C2,$ED,$0B                       ] , 'vcmpfalsepd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(481, [$62,$91,$8D,$10,$C2,$ED,$0B                       ] , 'vcmpfalsepd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(482, [$62,$F1,$8D,$40,$C2,$29,$0B                       ] , 'vcmpfalsepd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(483, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsepd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(484, [$62,$F1,$8D,$50,$C2,$29,$0B                       ] , 'vcmpfalsepd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(485, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsepd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(486, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0B       ] , 'vcmpfalsepd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(487, [$62,$F1,$8D,$40,$C2,$6A,$80,$0B                   ] , 'vcmpfalsepd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(488, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0B       ] , 'vcmpfalsepd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(489, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(490, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsepd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(491, [$62,$F1,$8D,$50,$C2,$6A,$80,$0B                   ] , 'vcmpfalsepd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(492, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsepd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(493, [$62,$91,$8D,$40,$C2,$ED,$0C                       ] , 'vcmpneq_oqpd  k5,zmm30,zmm29'                     );
  TestCase.testcase(494, [$62,$91,$8D,$47,$C2,$ED,$0C                       ] , 'vcmpneq_oqpd  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(495, [$62,$91,$8D,$10,$C2,$ED,$0C                       ] , 'vcmpneq_oqpd  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(496, [$62,$F1,$8D,$40,$C2,$29,$0C                       ] , 'vcmpneq_oqpd  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(497, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0C   ] , 'vcmpneq_oqpd  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(498, [$62,$F1,$8D,$50,$C2,$29,$0C                       ] , 'vcmpneq_oqpd  k5,zmm30,qword [rcx]{1to8}'         );
  TestCase.testcase(499, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqpd  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(500, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0C       ] , 'vcmpneq_oqpd  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(501, [$62,$F1,$8D,$40,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqpd  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(502, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0C       ] , 'vcmpneq_oqpd  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(503, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(504, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0C       ] , 'vcmpneq_oqpd  k5,zmm30,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(505, [$62,$F1,$8D,$50,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqpd  k5,zmm30,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(506, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0C       ] , 'vcmpneq_oqpd  k5,zmm30,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(507, [$62,$91,$8D,$40,$C2,$ED,$0D                       ] , 'vcmpgepd  k5,zmm30,zmm29'                         );
  TestCase.testcase(508, [$62,$91,$8D,$47,$C2,$ED,$0D                       ] , 'vcmpgepd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(509, [$62,$91,$8D,$10,$C2,$ED,$0D                       ] , 'vcmpgepd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(510, [$62,$F1,$8D,$40,$C2,$29,$0D                       ] , 'vcmpgepd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(511, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgepd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(512, [$62,$F1,$8D,$50,$C2,$29,$0D                       ] , 'vcmpgepd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(513, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0D                   ] , 'vcmpgepd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(514, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0D       ] , 'vcmpgepd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(515, [$62,$F1,$8D,$40,$C2,$6A,$80,$0D                   ] , 'vcmpgepd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(516, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0D       ] , 'vcmpgepd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(517, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0D                   ] , 'vcmpgepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(518, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgepd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(519, [$62,$F1,$8D,$50,$C2,$6A,$80,$0D                   ] , 'vcmpgepd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(520, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgepd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(521, [$62,$91,$8D,$40,$C2,$ED,$0D                       ] , 'vcmpgepd  k5,zmm30,zmm29'                         );
  TestCase.testcase(522, [$62,$91,$8D,$47,$C2,$ED,$0D                       ] , 'vcmpgepd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(523, [$62,$91,$8D,$10,$C2,$ED,$0D                       ] , 'vcmpgepd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(524, [$62,$F1,$8D,$40,$C2,$29,$0D                       ] , 'vcmpgepd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(525, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgepd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(526, [$62,$F1,$8D,$50,$C2,$29,$0D                       ] , 'vcmpgepd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(527, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0D                   ] , 'vcmpgepd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(528, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0D       ] , 'vcmpgepd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(529, [$62,$F1,$8D,$40,$C2,$6A,$80,$0D                   ] , 'vcmpgepd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(530, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0D       ] , 'vcmpgepd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(531, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0D                   ] , 'vcmpgepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(532, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgepd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(533, [$62,$F1,$8D,$50,$C2,$6A,$80,$0D                   ] , 'vcmpgepd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(534, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgepd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(535, [$62,$91,$8D,$40,$C2,$ED,$0E                       ] , 'vcmpgtpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(536, [$62,$91,$8D,$47,$C2,$ED,$0E                       ] , 'vcmpgtpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(537, [$62,$91,$8D,$10,$C2,$ED,$0E                       ] , 'vcmpgtpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(538, [$62,$F1,$8D,$40,$C2,$29,$0E                       ] , 'vcmpgtpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(539, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtpd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(540, [$62,$F1,$8D,$50,$C2,$29,$0E                       ] , 'vcmpgtpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(541, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0E                   ] , 'vcmpgtpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(542, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0E       ] , 'vcmpgtpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(543, [$62,$F1,$8D,$40,$C2,$6A,$80,$0E                   ] , 'vcmpgtpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(544, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0E       ] , 'vcmpgtpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(545, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0E                   ] , 'vcmpgtpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(546, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(547, [$62,$F1,$8D,$50,$C2,$6A,$80,$0E                   ] , 'vcmpgtpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(548, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(549, [$62,$91,$8D,$40,$C2,$ED,$0E                       ] , 'vcmpgtpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(550, [$62,$91,$8D,$47,$C2,$ED,$0E                       ] , 'vcmpgtpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(551, [$62,$91,$8D,$10,$C2,$ED,$0E                       ] , 'vcmpgtpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(552, [$62,$F1,$8D,$40,$C2,$29,$0E                       ] , 'vcmpgtpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(553, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtpd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(554, [$62,$F1,$8D,$50,$C2,$29,$0E                       ] , 'vcmpgtpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(555, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0E                   ] , 'vcmpgtpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(556, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0E       ] , 'vcmpgtpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(557, [$62,$F1,$8D,$40,$C2,$6A,$80,$0E                   ] , 'vcmpgtpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(558, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0E       ] , 'vcmpgtpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(559, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0E                   ] , 'vcmpgtpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(560, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(561, [$62,$F1,$8D,$50,$C2,$6A,$80,$0E                   ] , 'vcmpgtpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(562, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(563, [$62,$91,$8D,$40,$C2,$ED,$0F                       ] , 'vcmuepd  k5,zmm30,zmm29'                          );
  TestCase.testcase(564, [$62,$91,$8D,$47,$C2,$ED,$0F                       ] , 'vcmuepd  k5{k7},zmm30,zmm29'                      );
  TestCase.testcase(565, [$62,$91,$8D,$10,$C2,$ED,$0F                       ] , 'vcmuepd  k5,zmm30,zmm29,{sae}'                    );
  TestCase.testcase(566, [$62,$F1,$8D,$40,$C2,$29,$0F                       ] , 'vcmuepd  k5,zmm30,zword [rcx]'                    );
  TestCase.testcase(567, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuepd  k5,zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(568, [$62,$F1,$8D,$50,$C2,$29,$0F                       ] , 'vcmuepd  k5,zmm30,qword [rcx]{1to8}'              );
  TestCase.testcase(569, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0F                   ] , 'vcmuepd  k5,zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(570, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0F       ] , 'vcmuepd  k5,zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(571, [$62,$F1,$8D,$40,$C2,$6A,$80,$0F                   ] , 'vcmuepd  k5,zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(572, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0F       ] , 'vcmuepd  k5,zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(573, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0F                   ] , 'vcmuepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'        );
  TestCase.testcase(574, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuepd  k5,zmm30,qword [rdx+0x400]{1to8}'        );
  TestCase.testcase(575, [$62,$F1,$8D,$50,$C2,$6A,$80,$0F                   ] , 'vcmuepd  k5,zmm30,qword [rdx-0x400]{1to8}'        );
  TestCase.testcase(576, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuepd  k5,zmm30,qword [rdx-0x408]{1to8}'        );
  TestCase.testcase(577, [$62,$91,$8D,$40,$C2,$ED,$0F                       ] , 'vcmuepd  k5,zmm30,zmm29'                          );
  TestCase.testcase(578, [$62,$91,$8D,$47,$C2,$ED,$0F                       ] , 'vcmuepd  k5{k7},zmm30,zmm29'                      );
  TestCase.testcase(579, [$62,$91,$8D,$10,$C2,$ED,$0F                       ] , 'vcmuepd  k5,zmm30,zmm29,{sae}'                    );
  TestCase.testcase(580, [$62,$F1,$8D,$40,$C2,$29,$0F                       ] , 'vcmuepd  k5,zmm30,zword [rcx]'                    );
  TestCase.testcase(581, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuepd  k5,zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(582, [$62,$F1,$8D,$50,$C2,$29,$0F                       ] , 'vcmuepd  k5,zmm30,qword [rcx]{1to8}'              );
  TestCase.testcase(583, [$62,$F1,$8D,$40,$C2,$6A,$7F,$0F                   ] , 'vcmuepd  k5,zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(584, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$0F       ] , 'vcmuepd  k5,zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(585, [$62,$F1,$8D,$40,$C2,$6A,$80,$0F                   ] , 'vcmuepd  k5,zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(586, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0F       ] , 'vcmuepd  k5,zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(587, [$62,$F1,$8D,$50,$C2,$6A,$7F,$0F                   ] , 'vcmuepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'        );
  TestCase.testcase(588, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuepd  k5,zmm30,qword [rdx+0x400]{1to8}'        );
  TestCase.testcase(589, [$62,$F1,$8D,$50,$C2,$6A,$80,$0F                   ] , 'vcmuepd  k5,zmm30,qword [rdx-0x400]{1to8}'        );
  TestCase.testcase(590, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuepd  k5,zmm30,qword [rdx-0x408]{1to8}'        );
  TestCase.testcase(591, [$62,$91,$8D,$40,$C2,$ED,$10                       ] , 'vcmpeq_ospd  k5,zmm30,zmm29'                      );
  TestCase.testcase(592, [$62,$91,$8D,$47,$C2,$ED,$10                       ] , 'vcmpeq_ospd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(593, [$62,$91,$8D,$10,$C2,$ED,$10                       ] , 'vcmpeq_ospd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(594, [$62,$F1,$8D,$40,$C2,$29,$10                       ] , 'vcmpeq_ospd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(595, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$10   ] , 'vcmpeq_ospd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(596, [$62,$F1,$8D,$50,$C2,$29,$10                       ] , 'vcmpeq_ospd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(597, [$62,$F1,$8D,$40,$C2,$6A,$7F,$10                   ] , 'vcmpeq_ospd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(598, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$10       ] , 'vcmpeq_ospd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(599, [$62,$F1,$8D,$40,$C2,$6A,$80,$10                   ] , 'vcmpeq_ospd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(600, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$10       ] , 'vcmpeq_ospd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(601, [$62,$F1,$8D,$50,$C2,$6A,$7F,$10                   ] , 'vcmpeq_ospd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(602, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$10       ] , 'vcmpeq_ospd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(603, [$62,$F1,$8D,$50,$C2,$6A,$80,$10                   ] , 'vcmpeq_ospd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(604, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$10       ] , 'vcmpeq_ospd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(605, [$62,$91,$8D,$40,$C2,$ED,$11                       ] , 'vcmplt_oqpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(606, [$62,$91,$8D,$47,$C2,$ED,$11                       ] , 'vcmplt_oqpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(607, [$62,$91,$8D,$10,$C2,$ED,$11                       ] , 'vcmplt_oqpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(608, [$62,$F1,$8D,$40,$C2,$29,$11                       ] , 'vcmplt_oqpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(609, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$11   ] , 'vcmplt_oqpd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(610, [$62,$F1,$8D,$50,$C2,$29,$11                       ] , 'vcmplt_oqpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(611, [$62,$F1,$8D,$40,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(612, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$11       ] , 'vcmplt_oqpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(613, [$62,$F1,$8D,$40,$C2,$6A,$80,$11                   ] , 'vcmplt_oqpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(614, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$11       ] , 'vcmplt_oqpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(615, [$62,$F1,$8D,$50,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(616, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$11       ] , 'vcmplt_oqpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(617, [$62,$F1,$8D,$50,$C2,$6A,$80,$11                   ] , 'vcmplt_oqpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(618, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$11       ] , 'vcmplt_oqpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(619, [$62,$91,$8D,$40,$C2,$ED,$12                       ] , 'vcmple_oqpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(620, [$62,$91,$8D,$47,$C2,$ED,$12                       ] , 'vcmple_oqpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(621, [$62,$91,$8D,$10,$C2,$ED,$12                       ] , 'vcmple_oqpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(622, [$62,$F1,$8D,$40,$C2,$29,$12                       ] , 'vcmple_oqpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(623, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$12   ] , 'vcmple_oqpd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(624, [$62,$F1,$8D,$50,$C2,$29,$12                       ] , 'vcmple_oqpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(625, [$62,$F1,$8D,$40,$C2,$6A,$7F,$12                   ] , 'vcmple_oqpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(626, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$12       ] , 'vcmple_oqpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(627, [$62,$F1,$8D,$40,$C2,$6A,$80,$12                   ] , 'vcmple_oqpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(628, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$12       ] , 'vcmple_oqpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(629, [$62,$F1,$8D,$50,$C2,$6A,$7F,$12                   ] , 'vcmple_oqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(630, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$12       ] , 'vcmple_oqpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(631, [$62,$F1,$8D,$50,$C2,$6A,$80,$12                   ] , 'vcmple_oqpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(632, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$12       ] , 'vcmple_oqpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(633, [$62,$91,$8D,$40,$C2,$ED,$13                       ] , 'vcmpunord_spd  k5,zmm30,zmm29'                    );
  TestCase.testcase(634, [$62,$91,$8D,$47,$C2,$ED,$13                       ] , 'vcmpunord_spd  k5{k7},zmm30,zmm29'                );
  TestCase.testcase(635, [$62,$91,$8D,$10,$C2,$ED,$13                       ] , 'vcmpunord_spd  k5,zmm30,zmm29,{sae}'              );
  TestCase.testcase(636, [$62,$F1,$8D,$40,$C2,$29,$13                       ] , 'vcmpunord_spd  k5,zmm30,zword [rcx]'              );
  TestCase.testcase(637, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$13   ] , 'vcmpunord_spd  k5,zmm30,zword [rax+r14*8+0x123]'  );
  TestCase.testcase(638, [$62,$F1,$8D,$50,$C2,$29,$13                       ] , 'vcmpunord_spd  k5,zmm30,qword [rcx]{1to8}'        );
  TestCase.testcase(639, [$62,$F1,$8D,$40,$C2,$6A,$7F,$13                   ] , 'vcmpunord_spd  k5,zmm30,zword [rdx+0x1fc0]'       );
  TestCase.testcase(640, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$13       ] , 'vcmpunord_spd  k5,zmm30,zword [rdx+0x2000]'       );
  TestCase.testcase(641, [$62,$F1,$8D,$40,$C2,$6A,$80,$13                   ] , 'vcmpunord_spd  k5,zmm30,zword [rdx-0x2000]'       );
  TestCase.testcase(642, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$13       ] , 'vcmpunord_spd  k5,zmm30,zword [rdx-0x2040]'       );
  TestCase.testcase(643, [$62,$F1,$8D,$50,$C2,$6A,$7F,$13                   ] , 'vcmpunord_spd  k5,zmm30,qword [rdx+0x3f8]{1to8}'  );
  TestCase.testcase(644, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$13       ] , 'vcmpunord_spd  k5,zmm30,qword [rdx+0x400]{1to8}'  );
  TestCase.testcase(645, [$62,$F1,$8D,$50,$C2,$6A,$80,$13                   ] , 'vcmpunord_spd  k5,zmm30,qword [rdx-0x400]{1to8}'  );
  TestCase.testcase(646, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$13       ] , 'vcmpunord_spd  k5,zmm30,qword [rdx-0x408]{1to8}'  );
  TestCase.testcase(647, [$62,$91,$8D,$40,$C2,$ED,$14                       ] , 'vcmpneq_uspd  k5,zmm30,zmm29'                     );
  TestCase.testcase(648, [$62,$91,$8D,$47,$C2,$ED,$14                       ] , 'vcmpneq_uspd  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(649, [$62,$91,$8D,$10,$C2,$ED,$14                       ] , 'vcmpneq_uspd  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(650, [$62,$F1,$8D,$40,$C2,$29,$14                       ] , 'vcmpneq_uspd  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(651, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$14   ] , 'vcmpneq_uspd  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(652, [$62,$F1,$8D,$50,$C2,$29,$14                       ] , 'vcmpneq_uspd  k5,zmm30,qword [rcx]{1to8}'         );
  TestCase.testcase(653, [$62,$F1,$8D,$40,$C2,$6A,$7F,$14                   ] , 'vcmpneq_uspd  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(654, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$14       ] , 'vcmpneq_uspd  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(655, [$62,$F1,$8D,$40,$C2,$6A,$80,$14                   ] , 'vcmpneq_uspd  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(656, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$14       ] , 'vcmpneq_uspd  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(657, [$62,$F1,$8D,$50,$C2,$6A,$7F,$14                   ] , 'vcmpneq_uspd  k5,zmm30,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(658, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$14       ] , 'vcmpneq_uspd  k5,zmm30,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(659, [$62,$F1,$8D,$50,$C2,$6A,$80,$14                   ] , 'vcmpneq_uspd  k5,zmm30,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(660, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$14       ] , 'vcmpneq_uspd  k5,zmm30,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(661, [$62,$91,$8D,$40,$C2,$ED,$15                       ] , 'vcmpnlt_uqpd  k5,zmm30,zmm29'                     );
  TestCase.testcase(662, [$62,$91,$8D,$47,$C2,$ED,$15                       ] , 'vcmpnlt_uqpd  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(663, [$62,$91,$8D,$10,$C2,$ED,$15                       ] , 'vcmpnlt_uqpd  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(664, [$62,$F1,$8D,$40,$C2,$29,$15                       ] , 'vcmpnlt_uqpd  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(665, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$15   ] , 'vcmpnlt_uqpd  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(666, [$62,$F1,$8D,$50,$C2,$29,$15                       ] , 'vcmpnlt_uqpd  k5,zmm30,qword [rcx]{1to8}'         );
  TestCase.testcase(667, [$62,$F1,$8D,$40,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqpd  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(668, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$15       ] , 'vcmpnlt_uqpd  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(669, [$62,$F1,$8D,$40,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqpd  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(670, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$15       ] , 'vcmpnlt_uqpd  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(671, [$62,$F1,$8D,$50,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(672, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$15       ] , 'vcmpnlt_uqpd  k5,zmm30,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(673, [$62,$F1,$8D,$50,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqpd  k5,zmm30,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(674, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$15       ] , 'vcmpnlt_uqpd  k5,zmm30,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(675, [$62,$91,$8D,$40,$C2,$ED,$16                       ] , 'vcmpnle_uqpd  k5,zmm30,zmm29'                     );
  TestCase.testcase(676, [$62,$91,$8D,$47,$C2,$ED,$16                       ] , 'vcmpnle_uqpd  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(677, [$62,$91,$8D,$10,$C2,$ED,$16                       ] , 'vcmpnle_uqpd  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(678, [$62,$F1,$8D,$40,$C2,$29,$16                       ] , 'vcmpnle_uqpd  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(679, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$16   ] , 'vcmpnle_uqpd  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(680, [$62,$F1,$8D,$50,$C2,$29,$16                       ] , 'vcmpnle_uqpd  k5,zmm30,qword [rcx]{1to8}'         );
  TestCase.testcase(681, [$62,$F1,$8D,$40,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqpd  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(682, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$16       ] , 'vcmpnle_uqpd  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(683, [$62,$F1,$8D,$40,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqpd  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(684, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$16       ] , 'vcmpnle_uqpd  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(685, [$62,$F1,$8D,$50,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(686, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$16       ] , 'vcmpnle_uqpd  k5,zmm30,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(687, [$62,$F1,$8D,$50,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqpd  k5,zmm30,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(688, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$16       ] , 'vcmpnle_uqpd  k5,zmm30,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(689, [$62,$91,$8D,$40,$C2,$ED,$17                       ] , 'vcmpord_spd  k5,zmm30,zmm29'                      );
  TestCase.testcase(690, [$62,$91,$8D,$47,$C2,$ED,$17                       ] , 'vcmpord_spd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(691, [$62,$91,$8D,$10,$C2,$ED,$17                       ] , 'vcmpord_spd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(692, [$62,$F1,$8D,$40,$C2,$29,$17                       ] , 'vcmpord_spd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(693, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$17   ] , 'vcmpord_spd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(694, [$62,$F1,$8D,$50,$C2,$29,$17                       ] , 'vcmpord_spd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(695, [$62,$F1,$8D,$40,$C2,$6A,$7F,$17                   ] , 'vcmpord_spd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(696, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$17       ] , 'vcmpord_spd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(697, [$62,$F1,$8D,$40,$C2,$6A,$80,$17                   ] , 'vcmpord_spd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(698, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$17       ] , 'vcmpord_spd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(699, [$62,$F1,$8D,$50,$C2,$6A,$7F,$17                   ] , 'vcmpord_spd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(700, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$17       ] , 'vcmpord_spd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(701, [$62,$F1,$8D,$50,$C2,$6A,$80,$17                   ] , 'vcmpord_spd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(702, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$17       ] , 'vcmpord_spd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(703, [$62,$91,$8D,$40,$C2,$ED,$18                       ] , 'vcmpeq_uspd  k5,zmm30,zmm29'                      );
  TestCase.testcase(704, [$62,$91,$8D,$47,$C2,$ED,$18                       ] , 'vcmpeq_uspd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(705, [$62,$91,$8D,$10,$C2,$ED,$18                       ] , 'vcmpeq_uspd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(706, [$62,$F1,$8D,$40,$C2,$29,$18                       ] , 'vcmpeq_uspd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(707, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$18   ] , 'vcmpeq_uspd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(708, [$62,$F1,$8D,$50,$C2,$29,$18                       ] , 'vcmpeq_uspd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(709, [$62,$F1,$8D,$40,$C2,$6A,$7F,$18                   ] , 'vcmpeq_uspd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(710, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$18       ] , 'vcmpeq_uspd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(711, [$62,$F1,$8D,$40,$C2,$6A,$80,$18                   ] , 'vcmpeq_uspd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(712, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$18       ] , 'vcmpeq_uspd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(713, [$62,$F1,$8D,$50,$C2,$6A,$7F,$18                   ] , 'vcmpeq_uspd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(714, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$18       ] , 'vcmpeq_uspd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(715, [$62,$F1,$8D,$50,$C2,$6A,$80,$18                   ] , 'vcmpeq_uspd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(716, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$18       ] , 'vcmpeq_uspd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(717, [$62,$91,$8D,$40,$C2,$ED,$19                       ] , 'vcmpnge_uqpd  k5,zmm30,zmm29'                     );
  TestCase.testcase(718, [$62,$91,$8D,$47,$C2,$ED,$19                       ] , 'vcmpnge_uqpd  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(719, [$62,$91,$8D,$10,$C2,$ED,$19                       ] , 'vcmpnge_uqpd  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(720, [$62,$F1,$8D,$40,$C2,$29,$19                       ] , 'vcmpnge_uqpd  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(721, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$19   ] , 'vcmpnge_uqpd  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(722, [$62,$F1,$8D,$50,$C2,$29,$19                       ] , 'vcmpnge_uqpd  k5,zmm30,qword [rcx]{1to8}'         );
  TestCase.testcase(723, [$62,$F1,$8D,$40,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqpd  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(724, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$19       ] , 'vcmpnge_uqpd  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(725, [$62,$F1,$8D,$40,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqpd  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(726, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$19       ] , 'vcmpnge_uqpd  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(727, [$62,$F1,$8D,$50,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(728, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$19       ] , 'vcmpnge_uqpd  k5,zmm30,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(729, [$62,$F1,$8D,$50,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqpd  k5,zmm30,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(730, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$19       ] , 'vcmpnge_uqpd  k5,zmm30,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(731, [$62,$91,$8D,$40,$C2,$ED,$1A                       ] , 'vcmpngt_uqpd  k5,zmm30,zmm29'                     );
  TestCase.testcase(732, [$62,$91,$8D,$47,$C2,$ED,$1A                       ] , 'vcmpngt_uqpd  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(733, [$62,$91,$8D,$10,$C2,$ED,$1A                       ] , 'vcmpngt_uqpd  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(734, [$62,$F1,$8D,$40,$C2,$29,$1A                       ] , 'vcmpngt_uqpd  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(735, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1A   ] , 'vcmpngt_uqpd  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(736, [$62,$F1,$8D,$50,$C2,$29,$1A                       ] , 'vcmpngt_uqpd  k5,zmm30,qword [rcx]{1to8}'         );
  TestCase.testcase(737, [$62,$F1,$8D,$40,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqpd  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(738, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$1A       ] , 'vcmpngt_uqpd  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(739, [$62,$F1,$8D,$40,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqpd  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(740, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1A       ] , 'vcmpngt_uqpd  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(741, [$62,$F1,$8D,$50,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(742, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$1A       ] , 'vcmpngt_uqpd  k5,zmm30,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(743, [$62,$F1,$8D,$50,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqpd  k5,zmm30,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(744, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$1A       ] , 'vcmpngt_uqpd  k5,zmm30,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(745, [$62,$91,$8D,$40,$C2,$ED,$1B                       ] , 'vcmpfalse_ospd  k5,zmm30,zmm29'                   );
  TestCase.testcase(746, [$62,$91,$8D,$47,$C2,$ED,$1B                       ] , 'vcmpfalse_ospd  k5{k7},zmm30,zmm29'               );
  TestCase.testcase(747, [$62,$91,$8D,$10,$C2,$ED,$1B                       ] , 'vcmpfalse_ospd  k5,zmm30,zmm29,{sae}'             );
  TestCase.testcase(748, [$62,$F1,$8D,$40,$C2,$29,$1B                       ] , 'vcmpfalse_ospd  k5,zmm30,zword [rcx]'             );
  TestCase.testcase(749, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1B   ] , 'vcmpfalse_ospd  k5,zmm30,zword [rax+r14*8+0x123]' );
  TestCase.testcase(750, [$62,$F1,$8D,$50,$C2,$29,$1B                       ] , 'vcmpfalse_ospd  k5,zmm30,qword [rcx]{1to8}'       );
  TestCase.testcase(751, [$62,$F1,$8D,$40,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_ospd  k5,zmm30,zword [rdx+0x1fc0]'      );
  TestCase.testcase(752, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$1B       ] , 'vcmpfalse_ospd  k5,zmm30,zword [rdx+0x2000]'      );
  TestCase.testcase(753, [$62,$F1,$8D,$40,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_ospd  k5,zmm30,zword [rdx-0x2000]'      );
  TestCase.testcase(754, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1B       ] , 'vcmpfalse_ospd  k5,zmm30,zword [rdx-0x2040]'      );
  TestCase.testcase(755, [$62,$F1,$8D,$50,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_ospd  k5,zmm30,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(756, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$1B       ] , 'vcmpfalse_ospd  k5,zmm30,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(757, [$62,$F1,$8D,$50,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_ospd  k5,zmm30,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(758, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$1B       ] , 'vcmpfalse_ospd  k5,zmm30,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(759, [$62,$91,$8D,$40,$C2,$ED,$1C                       ] , 'vcmpneq_ospd  k5,zmm30,zmm29'                     );
  TestCase.testcase(760, [$62,$91,$8D,$47,$C2,$ED,$1C                       ] , 'vcmpneq_ospd  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(761, [$62,$91,$8D,$10,$C2,$ED,$1C                       ] , 'vcmpneq_ospd  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(762, [$62,$F1,$8D,$40,$C2,$29,$1C                       ] , 'vcmpneq_ospd  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(763, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1C   ] , 'vcmpneq_ospd  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(764, [$62,$F1,$8D,$50,$C2,$29,$1C                       ] , 'vcmpneq_ospd  k5,zmm30,qword [rcx]{1to8}'         );
  TestCase.testcase(765, [$62,$F1,$8D,$40,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_ospd  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(766, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$1C       ] , 'vcmpneq_ospd  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(767, [$62,$F1,$8D,$40,$C2,$6A,$80,$1C                   ] , 'vcmpneq_ospd  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(768, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1C       ] , 'vcmpneq_ospd  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(769, [$62,$F1,$8D,$50,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_ospd  k5,zmm30,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(770, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$1C       ] , 'vcmpneq_ospd  k5,zmm30,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(771, [$62,$F1,$8D,$50,$C2,$6A,$80,$1C                   ] , 'vcmpneq_ospd  k5,zmm30,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(772, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$1C       ] , 'vcmpneq_ospd  k5,zmm30,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(773, [$62,$91,$8D,$40,$C2,$ED,$1D                       ] , 'vcmpge_oqpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(774, [$62,$91,$8D,$47,$C2,$ED,$1D                       ] , 'vcmpge_oqpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(775, [$62,$91,$8D,$10,$C2,$ED,$1D                       ] , 'vcmpge_oqpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(776, [$62,$F1,$8D,$40,$C2,$29,$1D                       ] , 'vcmpge_oqpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(777, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1D   ] , 'vcmpge_oqpd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(778, [$62,$F1,$8D,$50,$C2,$29,$1D                       ] , 'vcmpge_oqpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(779, [$62,$F1,$8D,$40,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(780, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$1D       ] , 'vcmpge_oqpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(781, [$62,$F1,$8D,$40,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(782, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1D       ] , 'vcmpge_oqpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(783, [$62,$F1,$8D,$50,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(784, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$1D       ] , 'vcmpge_oqpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(785, [$62,$F1,$8D,$50,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(786, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$1D       ] , 'vcmpge_oqpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(787, [$62,$91,$8D,$40,$C2,$ED,$1E                       ] , 'vcmpgt_oqpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(788, [$62,$91,$8D,$47,$C2,$ED,$1E                       ] , 'vcmpgt_oqpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(789, [$62,$91,$8D,$10,$C2,$ED,$1E                       ] , 'vcmpgt_oqpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(790, [$62,$F1,$8D,$40,$C2,$29,$1E                       ] , 'vcmpgt_oqpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(791, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1E   ] , 'vcmpgt_oqpd  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(792, [$62,$F1,$8D,$50,$C2,$29,$1E                       ] , 'vcmpgt_oqpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(793, [$62,$F1,$8D,$40,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(794, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$1E       ] , 'vcmpgt_oqpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(795, [$62,$F1,$8D,$40,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(796, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1E       ] , 'vcmpgt_oqpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(797, [$62,$F1,$8D,$50,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(798, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$1E       ] , 'vcmpgt_oqpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(799, [$62,$F1,$8D,$50,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(800, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$1E       ] , 'vcmpgt_oqpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(801, [$62,$91,$8D,$40,$C2,$ED,$1F                       ] , 'vcmue_uspd  k5,zmm30,zmm29'                       );
  TestCase.testcase(802, [$62,$91,$8D,$47,$C2,$ED,$1F                       ] , 'vcmue_uspd  k5{k7},zmm30,zmm29'                   );
  TestCase.testcase(803, [$62,$91,$8D,$10,$C2,$ED,$1F                       ] , 'vcmue_uspd  k5,zmm30,zmm29,{sae}'                 );
  TestCase.testcase(804, [$62,$F1,$8D,$40,$C2,$29,$1F                       ] , 'vcmue_uspd  k5,zmm30,zword [rcx]'                 );
  TestCase.testcase(805, [$62,$B1,$8D,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1F   ] , 'vcmue_uspd  k5,zmm30,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(806, [$62,$F1,$8D,$50,$C2,$29,$1F                       ] , 'vcmue_uspd  k5,zmm30,qword [rcx]{1to8}'           );
  TestCase.testcase(807, [$62,$F1,$8D,$40,$C2,$6A,$7F,$1F                   ] , 'vcmue_uspd  k5,zmm30,zword [rdx+0x1fc0]'          );
  TestCase.testcase(808, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$1F       ] , 'vcmue_uspd  k5,zmm30,zword [rdx+0x2000]'          );
  TestCase.testcase(809, [$62,$F1,$8D,$40,$C2,$6A,$80,$1F                   ] , 'vcmue_uspd  k5,zmm30,zword [rdx-0x2000]'          );
  TestCase.testcase(810, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1F       ] , 'vcmue_uspd  k5,zmm30,zword [rdx-0x2040]'          );
  TestCase.testcase(811, [$62,$F1,$8D,$50,$C2,$6A,$7F,$1F                   ] , 'vcmue_uspd  k5,zmm30,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(812, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$1F       ] , 'vcmue_uspd  k5,zmm30,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(813, [$62,$F1,$8D,$50,$C2,$6A,$80,$1F                   ] , 'vcmue_uspd  k5,zmm30,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(814, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$1F       ] , 'vcmue_uspd  k5,zmm30,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(815, [$62,$91,$0C,$40,$C2,$ED,$AB                       ] , 'vcmpps  k5,zmm30,zmm29,0xab'                      );
  TestCase.testcase(816, [$62,$91,$0C,$47,$C2,$ED,$AB                       ] , 'vcmpps  k5{k7},zmm30,zmm29,0xab'                  );
  TestCase.testcase(817, [$62,$91,$0C,$10,$C2,$ED,$AB                       ] , 'vcmpps  k5,zmm30,zmm29,{sae},0xab'                );
  TestCase.testcase(818, [$62,$91,$0C,$40,$C2,$ED,$7B                       ] , 'vcmpps  k5,zmm30,zmm29,0x7b'                      );
  TestCase.testcase(819, [$62,$91,$0C,$10,$C2,$ED,$7B                       ] , 'vcmpps  k5,zmm30,zmm29,{sae},0x7b'                );
  TestCase.testcase(820, [$62,$F1,$0C,$40,$C2,$29,$7B                       ] , 'vcmpps  k5,zmm30,zword [rcx],0x7b'                );
  TestCase.testcase(821, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vcmpps  k5,zmm30,zword [rax+r14*8+0x123],0x7b'    );
  TestCase.testcase(822, [$62,$F1,$0C,$50,$C2,$29,$7B                       ] , 'vcmpps  k5,zmm30,dword [rcx]{1to16},0x7b'         );
  TestCase.testcase(823, [$62,$F1,$0C,$40,$C2,$6A,$7F,$7B                   ] , 'vcmpps  k5,zmm30,zword [rdx+0x1fc0],0x7b'         );
  TestCase.testcase(824, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$7B       ] , 'vcmpps  k5,zmm30,zword [rdx+0x2000],0x7b'         );
  TestCase.testcase(825, [$62,$F1,$0C,$40,$C2,$6A,$80,$7B                   ] , 'vcmpps  k5,zmm30,zword [rdx-0x2000],0x7b'         );
  TestCase.testcase(826, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$7B       ] , 'vcmpps  k5,zmm30,zword [rdx-0x2040],0x7b'         );
  TestCase.testcase(827, [$62,$F1,$0C,$50,$C2,$6A,$7F,$7B                   ] , 'vcmpps  k5,zmm30,dword [rdx+0x1fc]{1to16},0x7b'   );
  TestCase.testcase(828, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$7B       ] , 'vcmpps  k5,zmm30,dword [rdx+0x200]{1to16},0x7b'   );
  TestCase.testcase(829, [$62,$F1,$0C,$50,$C2,$6A,$80,$7B                   ] , 'vcmpps  k5,zmm30,dword [rdx-0x200]{1to16},0x7b'   );
  TestCase.testcase(830, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vcmpps  k5,zmm30,dword [rdx-0x204]{1to16},0x7b'   );
  TestCase.testcase(831, [$62,$91,$0C,$40,$C2,$ED,$00                       ] , 'vcmpeqps  k5,zmm30,zmm29'                         );
  TestCase.testcase(832, [$62,$91,$0C,$47,$C2,$ED,$00                       ] , 'vcmpeqps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(833, [$62,$91,$0C,$10,$C2,$ED,$00                       ] , 'vcmpeqps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(834, [$62,$F1,$0C,$40,$C2,$29,$00                       ] , 'vcmpeqps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(835, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(836, [$62,$F1,$0C,$50,$C2,$29,$00                       ] , 'vcmpeqps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(837, [$62,$F1,$0C,$40,$C2,$6A,$7F,$00                   ] , 'vcmpeqps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(838, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$00       ] , 'vcmpeqps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(839, [$62,$F1,$0C,$40,$C2,$6A,$80,$00                   ] , 'vcmpeqps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(840, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$00       ] , 'vcmpeqps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(841, [$62,$F1,$0C,$50,$C2,$6A,$7F,$00                   ] , 'vcmpeqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(842, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(843, [$62,$F1,$0C,$50,$C2,$6A,$80,$00                   ] , 'vcmpeqps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(844, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(845, [$62,$91,$0C,$40,$C2,$ED,$00                       ] , 'vcmpeqps  k5,zmm30,zmm29'                         );
  TestCase.testcase(846, [$62,$91,$0C,$47,$C2,$ED,$00                       ] , 'vcmpeqps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(847, [$62,$91,$0C,$10,$C2,$ED,$00                       ] , 'vcmpeqps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(848, [$62,$F1,$0C,$40,$C2,$29,$00                       ] , 'vcmpeqps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(849, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(850, [$62,$F1,$0C,$50,$C2,$29,$00                       ] , 'vcmpeqps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(851, [$62,$F1,$0C,$40,$C2,$6A,$7F,$00                   ] , 'vcmpeqps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(852, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$00       ] , 'vcmpeqps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(853, [$62,$F1,$0C,$40,$C2,$6A,$80,$00                   ] , 'vcmpeqps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(854, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$00       ] , 'vcmpeqps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(855, [$62,$F1,$0C,$50,$C2,$6A,$7F,$00                   ] , 'vcmpeqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(856, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(857, [$62,$F1,$0C,$50,$C2,$6A,$80,$00                   ] , 'vcmpeqps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(858, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(859, [$62,$91,$0C,$40,$C2,$ED,$01                       ] , 'vcmpltps  k5,zmm30,zmm29'                         );
  TestCase.testcase(860, [$62,$91,$0C,$47,$C2,$ED,$01                       ] , 'vcmpltps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(861, [$62,$91,$0C,$10,$C2,$ED,$01                       ] , 'vcmpltps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(862, [$62,$F1,$0C,$40,$C2,$29,$01                       ] , 'vcmpltps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(863, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(864, [$62,$F1,$0C,$50,$C2,$29,$01                       ] , 'vcmpltps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(865, [$62,$F1,$0C,$40,$C2,$6A,$7F,$01                   ] , 'vcmpltps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(866, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$01       ] , 'vcmpltps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(867, [$62,$F1,$0C,$40,$C2,$6A,$80,$01                   ] , 'vcmpltps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(868, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vcmpltps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(869, [$62,$F1,$0C,$50,$C2,$6A,$7F,$01                   ] , 'vcmpltps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(870, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(871, [$62,$F1,$0C,$50,$C2,$6A,$80,$01                   ] , 'vcmpltps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(872, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(873, [$62,$91,$0C,$40,$C2,$ED,$01                       ] , 'vcmpltps  k5,zmm30,zmm29'                         );
  TestCase.testcase(874, [$62,$91,$0C,$47,$C2,$ED,$01                       ] , 'vcmpltps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(875, [$62,$91,$0C,$10,$C2,$ED,$01                       ] , 'vcmpltps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(876, [$62,$F1,$0C,$40,$C2,$29,$01                       ] , 'vcmpltps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(877, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(878, [$62,$F1,$0C,$50,$C2,$29,$01                       ] , 'vcmpltps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(879, [$62,$F1,$0C,$40,$C2,$6A,$7F,$01                   ] , 'vcmpltps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(880, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$01       ] , 'vcmpltps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(881, [$62,$F1,$0C,$40,$C2,$6A,$80,$01                   ] , 'vcmpltps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(882, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vcmpltps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(883, [$62,$F1,$0C,$50,$C2,$6A,$7F,$01                   ] , 'vcmpltps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(884, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(885, [$62,$F1,$0C,$50,$C2,$6A,$80,$01                   ] , 'vcmpltps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(886, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(887, [$62,$91,$0C,$40,$C2,$ED,$02                       ] , 'vcmpleps  k5,zmm30,zmm29'                         );
  TestCase.testcase(888, [$62,$91,$0C,$47,$C2,$ED,$02                       ] , 'vcmpleps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(889, [$62,$91,$0C,$10,$C2,$ED,$02                       ] , 'vcmpleps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(890, [$62,$F1,$0C,$40,$C2,$29,$02                       ] , 'vcmpleps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(891, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmpleps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(892, [$62,$F1,$0C,$50,$C2,$29,$02                       ] , 'vcmpleps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(893, [$62,$F1,$0C,$40,$C2,$6A,$7F,$02                   ] , 'vcmpleps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(894, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$02       ] , 'vcmpleps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(895, [$62,$F1,$0C,$40,$C2,$6A,$80,$02                   ] , 'vcmpleps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(896, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vcmpleps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(897, [$62,$F1,$0C,$50,$C2,$6A,$7F,$02                   ] , 'vcmpleps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(898, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpleps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(899, [$62,$F1,$0C,$50,$C2,$6A,$80,$02                   ] , 'vcmpleps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(900, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpleps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(901, [$62,$91,$0C,$40,$C2,$ED,$02                       ] , 'vcmpleps  k5,zmm30,zmm29'                         );
  TestCase.testcase(902, [$62,$91,$0C,$47,$C2,$ED,$02                       ] , 'vcmpleps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(903, [$62,$91,$0C,$10,$C2,$ED,$02                       ] , 'vcmpleps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(904, [$62,$F1,$0C,$40,$C2,$29,$02                       ] , 'vcmpleps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(905, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmpleps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(906, [$62,$F1,$0C,$50,$C2,$29,$02                       ] , 'vcmpleps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(907, [$62,$F1,$0C,$40,$C2,$6A,$7F,$02                   ] , 'vcmpleps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(908, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$02       ] , 'vcmpleps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(909, [$62,$F1,$0C,$40,$C2,$6A,$80,$02                   ] , 'vcmpleps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(910, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vcmpleps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(911, [$62,$F1,$0C,$50,$C2,$6A,$7F,$02                   ] , 'vcmpleps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(912, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpleps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(913, [$62,$F1,$0C,$50,$C2,$6A,$80,$02                   ] , 'vcmpleps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(914, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpleps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(915, [$62,$91,$0C,$40,$C2,$ED,$03                       ] , 'vcmpunordps  k5,zmm30,zmm29'                      );
  TestCase.testcase(916, [$62,$91,$0C,$47,$C2,$ED,$03                       ] , 'vcmpunordps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(917, [$62,$91,$0C,$10,$C2,$ED,$03                       ] , 'vcmpunordps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(918, [$62,$F1,$0C,$40,$C2,$29,$03                       ] , 'vcmpunordps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(919, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(920, [$62,$F1,$0C,$50,$C2,$29,$03                       ] , 'vcmpunordps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(921, [$62,$F1,$0C,$40,$C2,$6A,$7F,$03                   ] , 'vcmpunordps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(922, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$03       ] , 'vcmpunordps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(923, [$62,$F1,$0C,$40,$C2,$6A,$80,$03                   ] , 'vcmpunordps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(924, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$03       ] , 'vcmpunordps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(925, [$62,$F1,$0C,$50,$C2,$6A,$7F,$03                   ] , 'vcmpunordps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(926, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(927, [$62,$F1,$0C,$50,$C2,$6A,$80,$03                   ] , 'vcmpunordps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(928, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(929, [$62,$91,$0C,$40,$C2,$ED,$03                       ] , 'vcmpunordps  k5,zmm30,zmm29'                      );
  TestCase.testcase(930, [$62,$91,$0C,$47,$C2,$ED,$03                       ] , 'vcmpunordps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(931, [$62,$91,$0C,$10,$C2,$ED,$03                       ] , 'vcmpunordps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(932, [$62,$F1,$0C,$40,$C2,$29,$03                       ] , 'vcmpunordps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(933, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(934, [$62,$F1,$0C,$50,$C2,$29,$03                       ] , 'vcmpunordps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(935, [$62,$F1,$0C,$40,$C2,$6A,$7F,$03                   ] , 'vcmpunordps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(936, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$03       ] , 'vcmpunordps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(937, [$62,$F1,$0C,$40,$C2,$6A,$80,$03                   ] , 'vcmpunordps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(938, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$03       ] , 'vcmpunordps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(939, [$62,$F1,$0C,$50,$C2,$6A,$7F,$03                   ] , 'vcmpunordps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(940, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(941, [$62,$F1,$0C,$50,$C2,$6A,$80,$03                   ] , 'vcmpunordps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(942, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(943, [$62,$91,$0C,$40,$C2,$ED,$04                       ] , 'vcmpneqps  k5,zmm30,zmm29'                        );
  TestCase.testcase(944, [$62,$91,$0C,$47,$C2,$ED,$04                       ] , 'vcmpneqps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(945, [$62,$91,$0C,$10,$C2,$ED,$04                       ] , 'vcmpneqps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(946, [$62,$F1,$0C,$40,$C2,$29,$04                       ] , 'vcmpneqps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(947, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(948, [$62,$F1,$0C,$50,$C2,$29,$04                       ] , 'vcmpneqps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(949, [$62,$F1,$0C,$40,$C2,$6A,$7F,$04                   ] , 'vcmpneqps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(950, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$04       ] , 'vcmpneqps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(951, [$62,$F1,$0C,$40,$C2,$6A,$80,$04                   ] , 'vcmpneqps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(952, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vcmpneqps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(953, [$62,$F1,$0C,$50,$C2,$6A,$7F,$04                   ] , 'vcmpneqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(954, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(955, [$62,$F1,$0C,$50,$C2,$6A,$80,$04                   ] , 'vcmpneqps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(956, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(957, [$62,$91,$0C,$40,$C2,$ED,$04                       ] , 'vcmpneqps  k5,zmm30,zmm29'                        );
  TestCase.testcase(958, [$62,$91,$0C,$47,$C2,$ED,$04                       ] , 'vcmpneqps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(959, [$62,$91,$0C,$10,$C2,$ED,$04                       ] , 'vcmpneqps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(960, [$62,$F1,$0C,$40,$C2,$29,$04                       ] , 'vcmpneqps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(961, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(962, [$62,$F1,$0C,$50,$C2,$29,$04                       ] , 'vcmpneqps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(963, [$62,$F1,$0C,$40,$C2,$6A,$7F,$04                   ] , 'vcmpneqps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(964, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$04       ] , 'vcmpneqps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(965, [$62,$F1,$0C,$40,$C2,$6A,$80,$04                   ] , 'vcmpneqps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(966, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vcmpneqps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(967, [$62,$F1,$0C,$50,$C2,$6A,$7F,$04                   ] , 'vcmpneqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(968, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(969, [$62,$F1,$0C,$50,$C2,$6A,$80,$04                   ] , 'vcmpneqps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(970, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(971, [$62,$91,$0C,$40,$C2,$ED,$05                       ] , 'vcmpnltps  k5,zmm30,zmm29'                        );
  TestCase.testcase(972, [$62,$91,$0C,$47,$C2,$ED,$05                       ] , 'vcmpnltps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(973, [$62,$91,$0C,$10,$C2,$ED,$05                       ] , 'vcmpnltps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(974, [$62,$F1,$0C,$40,$C2,$29,$05                       ] , 'vcmpnltps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(975, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(976, [$62,$F1,$0C,$50,$C2,$29,$05                       ] , 'vcmpnltps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(977, [$62,$F1,$0C,$40,$C2,$6A,$7F,$05                   ] , 'vcmpnltps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(978, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$05       ] , 'vcmpnltps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(979, [$62,$F1,$0C,$40,$C2,$6A,$80,$05                   ] , 'vcmpnltps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(980, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vcmpnltps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(981, [$62,$F1,$0C,$50,$C2,$6A,$7F,$05                   ] , 'vcmpnltps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(982, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(983, [$62,$F1,$0C,$50,$C2,$6A,$80,$05                   ] , 'vcmpnltps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(984, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(985, [$62,$91,$0C,$40,$C2,$ED,$05                       ] , 'vcmpnltps  k5,zmm30,zmm29'                        );
  TestCase.testcase(986, [$62,$91,$0C,$47,$C2,$ED,$05                       ] , 'vcmpnltps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(987, [$62,$91,$0C,$10,$C2,$ED,$05                       ] , 'vcmpnltps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(988, [$62,$F1,$0C,$40,$C2,$29,$05                       ] , 'vcmpnltps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(989, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(990, [$62,$F1,$0C,$50,$C2,$29,$05                       ] , 'vcmpnltps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(991, [$62,$F1,$0C,$40,$C2,$6A,$7F,$05                   ] , 'vcmpnltps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(992, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$05       ] , 'vcmpnltps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(993, [$62,$F1,$0C,$40,$C2,$6A,$80,$05                   ] , 'vcmpnltps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(994, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vcmpnltps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(995, [$62,$F1,$0C,$50,$C2,$6A,$7F,$05                   ] , 'vcmpnltps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(996, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(997, [$62,$F1,$0C,$50,$C2,$6A,$80,$05                   ] , 'vcmpnltps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(998, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(999, [$62,$91,$0C,$40,$C2,$ED,$06                       ] , 'vcmpnleps  k5,zmm30,zmm29'                        );
  TestCase.testcase(1000, [$62,$91,$0C,$47,$C2,$ED,$06                       ] , 'vcmpnleps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(1001, [$62,$91,$0C,$10,$C2,$ED,$06                       ] , 'vcmpnleps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(1002, [$62,$F1,$0C,$40,$C2,$29,$06                       ] , 'vcmpnleps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(1003, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnleps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(1004, [$62,$F1,$0C,$50,$C2,$29,$06                       ] , 'vcmpnleps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(1005, [$62,$F1,$0C,$40,$C2,$6A,$7F,$06                   ] , 'vcmpnleps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(1006, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$06       ] , 'vcmpnleps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(1007, [$62,$F1,$0C,$40,$C2,$6A,$80,$06                   ] , 'vcmpnleps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(1008, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vcmpnleps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(1009, [$62,$F1,$0C,$50,$C2,$6A,$7F,$06                   ] , 'vcmpnleps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(1010, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnleps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(1011, [$62,$F1,$0C,$50,$C2,$6A,$80,$06                   ] , 'vcmpnleps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(1012, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnleps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(1013, [$62,$91,$0C,$40,$C2,$ED,$06                       ] , 'vcmpnleps  k5,zmm30,zmm29'                        );
  TestCase.testcase(1014, [$62,$91,$0C,$47,$C2,$ED,$06                       ] , 'vcmpnleps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(1015, [$62,$91,$0C,$10,$C2,$ED,$06                       ] , 'vcmpnleps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(1016, [$62,$F1,$0C,$40,$C2,$29,$06                       ] , 'vcmpnleps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(1017, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnleps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(1018, [$62,$F1,$0C,$50,$C2,$29,$06                       ] , 'vcmpnleps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(1019, [$62,$F1,$0C,$40,$C2,$6A,$7F,$06                   ] , 'vcmpnleps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(1020, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$06       ] , 'vcmpnleps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(1021, [$62,$F1,$0C,$40,$C2,$6A,$80,$06                   ] , 'vcmpnleps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(1022, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vcmpnleps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(1023, [$62,$F1,$0C,$50,$C2,$6A,$7F,$06                   ] , 'vcmpnleps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(1024, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnleps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(1025, [$62,$F1,$0C,$50,$C2,$6A,$80,$06                   ] , 'vcmpnleps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(1026, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnleps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(1027, [$62,$91,$0C,$40,$C2,$ED,$07                       ] , 'vcmpordps  k5,zmm30,zmm29'                        );
  TestCase.testcase(1028, [$62,$91,$0C,$47,$C2,$ED,$07                       ] , 'vcmpordps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(1029, [$62,$91,$0C,$10,$C2,$ED,$07                       ] , 'vcmpordps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(1030, [$62,$F1,$0C,$40,$C2,$29,$07                       ] , 'vcmpordps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(1031, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(1032, [$62,$F1,$0C,$50,$C2,$29,$07                       ] , 'vcmpordps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(1033, [$62,$F1,$0C,$40,$C2,$6A,$7F,$07                   ] , 'vcmpordps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(1034, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$07       ] , 'vcmpordps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(1035, [$62,$F1,$0C,$40,$C2,$6A,$80,$07                   ] , 'vcmpordps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(1036, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$07       ] , 'vcmpordps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(1037, [$62,$F1,$0C,$50,$C2,$6A,$7F,$07                   ] , 'vcmpordps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(1038, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(1039, [$62,$F1,$0C,$50,$C2,$6A,$80,$07                   ] , 'vcmpordps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(1040, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(1041, [$62,$91,$0C,$40,$C2,$ED,$07                       ] , 'vcmpordps  k5,zmm30,zmm29'                        );
  TestCase.testcase(1042, [$62,$91,$0C,$47,$C2,$ED,$07                       ] , 'vcmpordps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(1043, [$62,$91,$0C,$10,$C2,$ED,$07                       ] , 'vcmpordps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(1044, [$62,$F1,$0C,$40,$C2,$29,$07                       ] , 'vcmpordps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(1045, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(1046, [$62,$F1,$0C,$50,$C2,$29,$07                       ] , 'vcmpordps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(1047, [$62,$F1,$0C,$40,$C2,$6A,$7F,$07                   ] , 'vcmpordps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(1048, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$07       ] , 'vcmpordps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(1049, [$62,$F1,$0C,$40,$C2,$6A,$80,$07                   ] , 'vcmpordps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(1050, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$07       ] , 'vcmpordps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(1051, [$62,$F1,$0C,$50,$C2,$6A,$7F,$07                   ] , 'vcmpordps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(1052, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(1053, [$62,$F1,$0C,$50,$C2,$6A,$80,$07                   ] , 'vcmpordps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(1054, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(1055, [$62,$91,$0C,$40,$C2,$ED,$08                       ] , 'vcmpeq_uqps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1056, [$62,$91,$0C,$47,$C2,$ED,$08                       ] , 'vcmpeq_uqps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1057, [$62,$91,$0C,$10,$C2,$ED,$08                       ] , 'vcmpeq_uqps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1058, [$62,$F1,$0C,$40,$C2,$29,$08                       ] , 'vcmpeq_uqps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1059, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$08   ] , 'vcmpeq_uqps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1060, [$62,$F1,$0C,$50,$C2,$29,$08                       ] , 'vcmpeq_uqps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1061, [$62,$F1,$0C,$40,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1062, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$08       ] , 'vcmpeq_uqps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1063, [$62,$F1,$0C,$40,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1064, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$08       ] , 'vcmpeq_uqps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1065, [$62,$F1,$0C,$50,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1066, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$08       ] , 'vcmpeq_uqps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1067, [$62,$F1,$0C,$50,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1068, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$08       ] , 'vcmpeq_uqps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1069, [$62,$91,$0C,$40,$C2,$ED,$09                       ] , 'vcmpngeps  k5,zmm30,zmm29'                        );
  TestCase.testcase(1070, [$62,$91,$0C,$47,$C2,$ED,$09                       ] , 'vcmpngeps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(1071, [$62,$91,$0C,$10,$C2,$ED,$09                       ] , 'vcmpngeps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(1072, [$62,$F1,$0C,$40,$C2,$29,$09                       ] , 'vcmpngeps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(1073, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngeps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(1074, [$62,$F1,$0C,$50,$C2,$29,$09                       ] , 'vcmpngeps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(1075, [$62,$F1,$0C,$40,$C2,$6A,$7F,$09                   ] , 'vcmpngeps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(1076, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$09       ] , 'vcmpngeps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(1077, [$62,$F1,$0C,$40,$C2,$6A,$80,$09                   ] , 'vcmpngeps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(1078, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$09       ] , 'vcmpngeps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(1079, [$62,$F1,$0C,$50,$C2,$6A,$7F,$09                   ] , 'vcmpngeps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(1080, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngeps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(1081, [$62,$F1,$0C,$50,$C2,$6A,$80,$09                   ] , 'vcmpngeps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(1082, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngeps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(1083, [$62,$91,$0C,$40,$C2,$ED,$09                       ] , 'vcmpngeps  k5,zmm30,zmm29'                        );
  TestCase.testcase(1084, [$62,$91,$0C,$47,$C2,$ED,$09                       ] , 'vcmpngeps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(1085, [$62,$91,$0C,$10,$C2,$ED,$09                       ] , 'vcmpngeps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(1086, [$62,$F1,$0C,$40,$C2,$29,$09                       ] , 'vcmpngeps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(1087, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngeps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(1088, [$62,$F1,$0C,$50,$C2,$29,$09                       ] , 'vcmpngeps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(1089, [$62,$F1,$0C,$40,$C2,$6A,$7F,$09                   ] , 'vcmpngeps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(1090, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$09       ] , 'vcmpngeps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(1091, [$62,$F1,$0C,$40,$C2,$6A,$80,$09                   ] , 'vcmpngeps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(1092, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$09       ] , 'vcmpngeps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(1093, [$62,$F1,$0C,$50,$C2,$6A,$7F,$09                   ] , 'vcmpngeps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(1094, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngeps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(1095, [$62,$F1,$0C,$50,$C2,$6A,$80,$09                   ] , 'vcmpngeps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(1096, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngeps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(1097, [$62,$91,$0C,$40,$C2,$ED,$0A                       ] , 'vcmpngtps  k5,zmm30,zmm29'                        );
  TestCase.testcase(1098, [$62,$91,$0C,$47,$C2,$ED,$0A                       ] , 'vcmpngtps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(1099, [$62,$91,$0C,$10,$C2,$ED,$0A                       ] , 'vcmpngtps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(1100, [$62,$F1,$0C,$40,$C2,$29,$0A                       ] , 'vcmpngtps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(1101, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(1102, [$62,$F1,$0C,$50,$C2,$29,$0A                       ] , 'vcmpngtps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(1103, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0A                   ] , 'vcmpngtps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(1104, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0A       ] , 'vcmpngtps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(1105, [$62,$F1,$0C,$40,$C2,$6A,$80,$0A                   ] , 'vcmpngtps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(1106, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0A       ] , 'vcmpngtps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(1107, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0A                   ] , 'vcmpngtps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(1108, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(1109, [$62,$F1,$0C,$50,$C2,$6A,$80,$0A                   ] , 'vcmpngtps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(1110, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(1111, [$62,$91,$0C,$40,$C2,$ED,$0A                       ] , 'vcmpngtps  k5,zmm30,zmm29'                        );
  TestCase.testcase(1112, [$62,$91,$0C,$47,$C2,$ED,$0A                       ] , 'vcmpngtps  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(1113, [$62,$91,$0C,$10,$C2,$ED,$0A                       ] , 'vcmpngtps  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(1114, [$62,$F1,$0C,$40,$C2,$29,$0A                       ] , 'vcmpngtps  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(1115, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtps  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(1116, [$62,$F1,$0C,$50,$C2,$29,$0A                       ] , 'vcmpngtps  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(1117, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0A                   ] , 'vcmpngtps  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(1118, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0A       ] , 'vcmpngtps  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(1119, [$62,$F1,$0C,$40,$C2,$6A,$80,$0A                   ] , 'vcmpngtps  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(1120, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0A       ] , 'vcmpngtps  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(1121, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0A                   ] , 'vcmpngtps  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(1122, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtps  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(1123, [$62,$F1,$0C,$50,$C2,$6A,$80,$0A                   ] , 'vcmpngtps  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(1124, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtps  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(1125, [$62,$91,$0C,$40,$C2,$ED,$0B                       ] , 'vcmpfalseps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1126, [$62,$91,$0C,$47,$C2,$ED,$0B                       ] , 'vcmpfalseps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1127, [$62,$91,$0C,$10,$C2,$ED,$0B                       ] , 'vcmpfalseps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1128, [$62,$F1,$0C,$40,$C2,$29,$0B                       ] , 'vcmpfalseps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1129, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalseps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1130, [$62,$F1,$0C,$50,$C2,$29,$0B                       ] , 'vcmpfalseps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1131, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0B                   ] , 'vcmpfalseps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1132, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0B       ] , 'vcmpfalseps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1133, [$62,$F1,$0C,$40,$C2,$6A,$80,$0B                   ] , 'vcmpfalseps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1134, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0B       ] , 'vcmpfalseps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1135, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0B                   ] , 'vcmpfalseps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1136, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalseps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1137, [$62,$F1,$0C,$50,$C2,$6A,$80,$0B                   ] , 'vcmpfalseps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1138, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalseps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1139, [$62,$91,$0C,$40,$C2,$ED,$0B                       ] , 'vcmpfalseps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1140, [$62,$91,$0C,$47,$C2,$ED,$0B                       ] , 'vcmpfalseps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1141, [$62,$91,$0C,$10,$C2,$ED,$0B                       ] , 'vcmpfalseps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1142, [$62,$F1,$0C,$40,$C2,$29,$0B                       ] , 'vcmpfalseps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1143, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalseps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1144, [$62,$F1,$0C,$50,$C2,$29,$0B                       ] , 'vcmpfalseps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1145, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0B                   ] , 'vcmpfalseps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1146, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0B       ] , 'vcmpfalseps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1147, [$62,$F1,$0C,$40,$C2,$6A,$80,$0B                   ] , 'vcmpfalseps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1148, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0B       ] , 'vcmpfalseps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1149, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0B                   ] , 'vcmpfalseps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1150, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalseps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1151, [$62,$F1,$0C,$50,$C2,$6A,$80,$0B                   ] , 'vcmpfalseps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1152, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalseps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1153, [$62,$91,$0C,$40,$C2,$ED,$0C                       ] , 'vcmpneq_oqps  k5,zmm30,zmm29'                     );
  TestCase.testcase(1154, [$62,$91,$0C,$47,$C2,$ED,$0C                       ] , 'vcmpneq_oqps  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(1155, [$62,$91,$0C,$10,$C2,$ED,$0C                       ] , 'vcmpneq_oqps  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(1156, [$62,$F1,$0C,$40,$C2,$29,$0C                       ] , 'vcmpneq_oqps  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(1157, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0C   ] , 'vcmpneq_oqps  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(1158, [$62,$F1,$0C,$50,$C2,$29,$0C                       ] , 'vcmpneq_oqps  k5,zmm30,dword [rcx]{1to16}'        );
  TestCase.testcase(1159, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqps  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(1160, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0C       ] , 'vcmpneq_oqps  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(1161, [$62,$F1,$0C,$40,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqps  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(1162, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0C       ] , 'vcmpneq_oqps  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(1163, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(1164, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0C       ] , 'vcmpneq_oqps  k5,zmm30,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(1165, [$62,$F1,$0C,$50,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqps  k5,zmm30,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(1166, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0C       ] , 'vcmpneq_oqps  k5,zmm30,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(1167, [$62,$91,$0C,$40,$C2,$ED,$0D                       ] , 'vcmpgeps  k5,zmm30,zmm29'                         );
  TestCase.testcase(1168, [$62,$91,$0C,$47,$C2,$ED,$0D                       ] , 'vcmpgeps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(1169, [$62,$91,$0C,$10,$C2,$ED,$0D                       ] , 'vcmpgeps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(1170, [$62,$F1,$0C,$40,$C2,$29,$0D                       ] , 'vcmpgeps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(1171, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgeps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(1172, [$62,$F1,$0C,$50,$C2,$29,$0D                       ] , 'vcmpgeps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(1173, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0D                   ] , 'vcmpgeps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(1174, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0D       ] , 'vcmpgeps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(1175, [$62,$F1,$0C,$40,$C2,$6A,$80,$0D                   ] , 'vcmpgeps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(1176, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0D       ] , 'vcmpgeps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(1177, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0D                   ] , 'vcmpgeps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(1178, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgeps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(1179, [$62,$F1,$0C,$50,$C2,$6A,$80,$0D                   ] , 'vcmpgeps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(1180, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgeps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(1181, [$62,$91,$0C,$40,$C2,$ED,$0D                       ] , 'vcmpgeps  k5,zmm30,zmm29'                         );
  TestCase.testcase(1182, [$62,$91,$0C,$47,$C2,$ED,$0D                       ] , 'vcmpgeps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(1183, [$62,$91,$0C,$10,$C2,$ED,$0D                       ] , 'vcmpgeps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(1184, [$62,$F1,$0C,$40,$C2,$29,$0D                       ] , 'vcmpgeps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(1185, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgeps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(1186, [$62,$F1,$0C,$50,$C2,$29,$0D                       ] , 'vcmpgeps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(1187, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0D                   ] , 'vcmpgeps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(1188, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0D       ] , 'vcmpgeps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(1189, [$62,$F1,$0C,$40,$C2,$6A,$80,$0D                   ] , 'vcmpgeps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(1190, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0D       ] , 'vcmpgeps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(1191, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0D                   ] , 'vcmpgeps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(1192, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgeps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(1193, [$62,$F1,$0C,$50,$C2,$6A,$80,$0D                   ] , 'vcmpgeps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(1194, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgeps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(1195, [$62,$91,$0C,$40,$C2,$ED,$0E                       ] , 'vcmpgtps  k5,zmm30,zmm29'                         );
  TestCase.testcase(1196, [$62,$91,$0C,$47,$C2,$ED,$0E                       ] , 'vcmpgtps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(1197, [$62,$91,$0C,$10,$C2,$ED,$0E                       ] , 'vcmpgtps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(1198, [$62,$F1,$0C,$40,$C2,$29,$0E                       ] , 'vcmpgtps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(1199, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(1200, [$62,$F1,$0C,$50,$C2,$29,$0E                       ] , 'vcmpgtps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(1201, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0E                   ] , 'vcmpgtps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(1202, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0E       ] , 'vcmpgtps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(1203, [$62,$F1,$0C,$40,$C2,$6A,$80,$0E                   ] , 'vcmpgtps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(1204, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0E       ] , 'vcmpgtps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(1205, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0E                   ] , 'vcmpgtps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(1206, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(1207, [$62,$F1,$0C,$50,$C2,$6A,$80,$0E                   ] , 'vcmpgtps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(1208, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(1209, [$62,$91,$0C,$40,$C2,$ED,$0E                       ] , 'vcmpgtps  k5,zmm30,zmm29'                         );
  TestCase.testcase(1210, [$62,$91,$0C,$47,$C2,$ED,$0E                       ] , 'vcmpgtps  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(1211, [$62,$91,$0C,$10,$C2,$ED,$0E                       ] , 'vcmpgtps  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(1212, [$62,$F1,$0C,$40,$C2,$29,$0E                       ] , 'vcmpgtps  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(1213, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtps  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(1214, [$62,$F1,$0C,$50,$C2,$29,$0E                       ] , 'vcmpgtps  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(1215, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0E                   ] , 'vcmpgtps  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(1216, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0E       ] , 'vcmpgtps  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(1217, [$62,$F1,$0C,$40,$C2,$6A,$80,$0E                   ] , 'vcmpgtps  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(1218, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0E       ] , 'vcmpgtps  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(1219, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0E                   ] , 'vcmpgtps  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(1220, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtps  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(1221, [$62,$F1,$0C,$50,$C2,$6A,$80,$0E                   ] , 'vcmpgtps  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(1222, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtps  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(1223, [$62,$91,$0C,$40,$C2,$ED,$0F                       ] , 'vcmueps  k5,zmm30,zmm29'                          );
  TestCase.testcase(1224, [$62,$91,$0C,$47,$C2,$ED,$0F                       ] , 'vcmueps  k5{k7},zmm30,zmm29'                      );
  TestCase.testcase(1225, [$62,$91,$0C,$10,$C2,$ED,$0F                       ] , 'vcmueps  k5,zmm30,zmm29,{sae}'                    );
  TestCase.testcase(1226, [$62,$F1,$0C,$40,$C2,$29,$0F                       ] , 'vcmueps  k5,zmm30,zword [rcx]'                    );
  TestCase.testcase(1227, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmueps  k5,zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(1228, [$62,$F1,$0C,$50,$C2,$29,$0F                       ] , 'vcmueps  k5,zmm30,dword [rcx]{1to16}'             );
  TestCase.testcase(1229, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0F                   ] , 'vcmueps  k5,zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(1230, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0F       ] , 'vcmueps  k5,zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(1231, [$62,$F1,$0C,$40,$C2,$6A,$80,$0F                   ] , 'vcmueps  k5,zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(1232, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0F       ] , 'vcmueps  k5,zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(1233, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0F                   ] , 'vcmueps  k5,zmm30,dword [rdx+0x1fc]{1to16}'       );
  TestCase.testcase(1234, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmueps  k5,zmm30,dword [rdx+0x200]{1to16}'       );
  TestCase.testcase(1235, [$62,$F1,$0C,$50,$C2,$6A,$80,$0F                   ] , 'vcmueps  k5,zmm30,dword [rdx-0x200]{1to16}'       );
  TestCase.testcase(1236, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmueps  k5,zmm30,dword [rdx-0x204]{1to16}'       );
  TestCase.testcase(1237, [$62,$91,$0C,$40,$C2,$ED,$0F                       ] , 'vcmueps  k5,zmm30,zmm29'                          );
  TestCase.testcase(1238, [$62,$91,$0C,$47,$C2,$ED,$0F                       ] , 'vcmueps  k5{k7},zmm30,zmm29'                      );
  TestCase.testcase(1239, [$62,$91,$0C,$10,$C2,$ED,$0F                       ] , 'vcmueps  k5,zmm30,zmm29,{sae}'                    );
  TestCase.testcase(1240, [$62,$F1,$0C,$40,$C2,$29,$0F                       ] , 'vcmueps  k5,zmm30,zword [rcx]'                    );
  TestCase.testcase(1241, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmueps  k5,zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(1242, [$62,$F1,$0C,$50,$C2,$29,$0F                       ] , 'vcmueps  k5,zmm30,dword [rcx]{1to16}'             );
  TestCase.testcase(1243, [$62,$F1,$0C,$40,$C2,$6A,$7F,$0F                   ] , 'vcmueps  k5,zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(1244, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$0F       ] , 'vcmueps  k5,zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(1245, [$62,$F1,$0C,$40,$C2,$6A,$80,$0F                   ] , 'vcmueps  k5,zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(1246, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$0F       ] , 'vcmueps  k5,zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(1247, [$62,$F1,$0C,$50,$C2,$6A,$7F,$0F                   ] , 'vcmueps  k5,zmm30,dword [rdx+0x1fc]{1to16}'       );
  TestCase.testcase(1248, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmueps  k5,zmm30,dword [rdx+0x200]{1to16}'       );
  TestCase.testcase(1249, [$62,$F1,$0C,$50,$C2,$6A,$80,$0F                   ] , 'vcmueps  k5,zmm30,dword [rdx-0x200]{1to16}'       );
  TestCase.testcase(1250, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmueps  k5,zmm30,dword [rdx-0x204]{1to16}'       );
  TestCase.testcase(1251, [$62,$91,$0C,$40,$C2,$ED,$10                       ] , 'vcmpeq_osps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1252, [$62,$91,$0C,$47,$C2,$ED,$10                       ] , 'vcmpeq_osps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1253, [$62,$91,$0C,$10,$C2,$ED,$10                       ] , 'vcmpeq_osps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1254, [$62,$F1,$0C,$40,$C2,$29,$10                       ] , 'vcmpeq_osps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1255, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$10   ] , 'vcmpeq_osps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1256, [$62,$F1,$0C,$50,$C2,$29,$10                       ] , 'vcmpeq_osps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1257, [$62,$F1,$0C,$40,$C2,$6A,$7F,$10                   ] , 'vcmpeq_osps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1258, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$10       ] , 'vcmpeq_osps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1259, [$62,$F1,$0C,$40,$C2,$6A,$80,$10                   ] , 'vcmpeq_osps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1260, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$10       ] , 'vcmpeq_osps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1261, [$62,$F1,$0C,$50,$C2,$6A,$7F,$10                   ] , 'vcmpeq_osps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1262, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$10       ] , 'vcmpeq_osps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1263, [$62,$F1,$0C,$50,$C2,$6A,$80,$10                   ] , 'vcmpeq_osps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1264, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$10       ] , 'vcmpeq_osps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1265, [$62,$91,$0C,$40,$C2,$ED,$11                       ] , 'vcmplt_oqps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1266, [$62,$91,$0C,$47,$C2,$ED,$11                       ] , 'vcmplt_oqps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1267, [$62,$91,$0C,$10,$C2,$ED,$11                       ] , 'vcmplt_oqps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1268, [$62,$F1,$0C,$40,$C2,$29,$11                       ] , 'vcmplt_oqps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1269, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$11   ] , 'vcmplt_oqps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1270, [$62,$F1,$0C,$50,$C2,$29,$11                       ] , 'vcmplt_oqps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1271, [$62,$F1,$0C,$40,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1272, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$11       ] , 'vcmplt_oqps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1273, [$62,$F1,$0C,$40,$C2,$6A,$80,$11                   ] , 'vcmplt_oqps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1274, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$11       ] , 'vcmplt_oqps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1275, [$62,$F1,$0C,$50,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1276, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$11       ] , 'vcmplt_oqps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1277, [$62,$F1,$0C,$50,$C2,$6A,$80,$11                   ] , 'vcmplt_oqps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1278, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$11       ] , 'vcmplt_oqps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1279, [$62,$91,$0C,$40,$C2,$ED,$12                       ] , 'vcmple_oqps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1280, [$62,$91,$0C,$47,$C2,$ED,$12                       ] , 'vcmple_oqps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1281, [$62,$91,$0C,$10,$C2,$ED,$12                       ] , 'vcmple_oqps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1282, [$62,$F1,$0C,$40,$C2,$29,$12                       ] , 'vcmple_oqps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1283, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$12   ] , 'vcmple_oqps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1284, [$62,$F1,$0C,$50,$C2,$29,$12                       ] , 'vcmple_oqps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1285, [$62,$F1,$0C,$40,$C2,$6A,$7F,$12                   ] , 'vcmple_oqps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1286, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$12       ] , 'vcmple_oqps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1287, [$62,$F1,$0C,$40,$C2,$6A,$80,$12                   ] , 'vcmple_oqps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1288, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$12       ] , 'vcmple_oqps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1289, [$62,$F1,$0C,$50,$C2,$6A,$7F,$12                   ] , 'vcmple_oqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1290, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$12       ] , 'vcmple_oqps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1291, [$62,$F1,$0C,$50,$C2,$6A,$80,$12                   ] , 'vcmple_oqps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1292, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$12       ] , 'vcmple_oqps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1293, [$62,$91,$0C,$40,$C2,$ED,$13                       ] , 'vcmpunord_sps  k5,zmm30,zmm29'                    );
  TestCase.testcase(1294, [$62,$91,$0C,$47,$C2,$ED,$13                       ] , 'vcmpunord_sps  k5{k7},zmm30,zmm29'                );
  TestCase.testcase(1295, [$62,$91,$0C,$10,$C2,$ED,$13                       ] , 'vcmpunord_sps  k5,zmm30,zmm29,{sae}'              );
  TestCase.testcase(1296, [$62,$F1,$0C,$40,$C2,$29,$13                       ] , 'vcmpunord_sps  k5,zmm30,zword [rcx]'              );
  TestCase.testcase(1297, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$13   ] , 'vcmpunord_sps  k5,zmm30,zword [rax+r14*8+0x123]'  );
  TestCase.testcase(1298, [$62,$F1,$0C,$50,$C2,$29,$13                       ] , 'vcmpunord_sps  k5,zmm30,dword [rcx]{1to16}'       );
  TestCase.testcase(1299, [$62,$F1,$0C,$40,$C2,$6A,$7F,$13                   ] , 'vcmpunord_sps  k5,zmm30,zword [rdx+0x1fc0]'       );
  TestCase.testcase(1300, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$13       ] , 'vcmpunord_sps  k5,zmm30,zword [rdx+0x2000]'       );
  TestCase.testcase(1301, [$62,$F1,$0C,$40,$C2,$6A,$80,$13                   ] , 'vcmpunord_sps  k5,zmm30,zword [rdx-0x2000]'       );
  TestCase.testcase(1302, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$13       ] , 'vcmpunord_sps  k5,zmm30,zword [rdx-0x2040]'       );
  TestCase.testcase(1303, [$62,$F1,$0C,$50,$C2,$6A,$7F,$13                   ] , 'vcmpunord_sps  k5,zmm30,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(1304, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$13       ] , 'vcmpunord_sps  k5,zmm30,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(1305, [$62,$F1,$0C,$50,$C2,$6A,$80,$13                   ] , 'vcmpunord_sps  k5,zmm30,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(1306, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$13       ] , 'vcmpunord_sps  k5,zmm30,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(1307, [$62,$91,$0C,$40,$C2,$ED,$14                       ] , 'vcmpneq_usps  k5,zmm30,zmm29'                     );
  TestCase.testcase(1308, [$62,$91,$0C,$47,$C2,$ED,$14                       ] , 'vcmpneq_usps  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(1309, [$62,$91,$0C,$10,$C2,$ED,$14                       ] , 'vcmpneq_usps  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(1310, [$62,$F1,$0C,$40,$C2,$29,$14                       ] , 'vcmpneq_usps  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(1311, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$14   ] , 'vcmpneq_usps  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(1312, [$62,$F1,$0C,$50,$C2,$29,$14                       ] , 'vcmpneq_usps  k5,zmm30,dword [rcx]{1to16}'        );
  TestCase.testcase(1313, [$62,$F1,$0C,$40,$C2,$6A,$7F,$14                   ] , 'vcmpneq_usps  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(1314, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$14       ] , 'vcmpneq_usps  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(1315, [$62,$F1,$0C,$40,$C2,$6A,$80,$14                   ] , 'vcmpneq_usps  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(1316, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$14       ] , 'vcmpneq_usps  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(1317, [$62,$F1,$0C,$50,$C2,$6A,$7F,$14                   ] , 'vcmpneq_usps  k5,zmm30,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(1318, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$14       ] , 'vcmpneq_usps  k5,zmm30,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(1319, [$62,$F1,$0C,$50,$C2,$6A,$80,$14                   ] , 'vcmpneq_usps  k5,zmm30,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(1320, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$14       ] , 'vcmpneq_usps  k5,zmm30,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(1321, [$62,$91,$0C,$40,$C2,$ED,$15                       ] , 'vcmpnlt_uqps  k5,zmm30,zmm29'                     );
  TestCase.testcase(1322, [$62,$91,$0C,$47,$C2,$ED,$15                       ] , 'vcmpnlt_uqps  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(1323, [$62,$91,$0C,$10,$C2,$ED,$15                       ] , 'vcmpnlt_uqps  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(1324, [$62,$F1,$0C,$40,$C2,$29,$15                       ] , 'vcmpnlt_uqps  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(1325, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$15   ] , 'vcmpnlt_uqps  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(1326, [$62,$F1,$0C,$50,$C2,$29,$15                       ] , 'vcmpnlt_uqps  k5,zmm30,dword [rcx]{1to16}'        );
  TestCase.testcase(1327, [$62,$F1,$0C,$40,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqps  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(1328, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$15       ] , 'vcmpnlt_uqps  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(1329, [$62,$F1,$0C,$40,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqps  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(1330, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$15       ] , 'vcmpnlt_uqps  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(1331, [$62,$F1,$0C,$50,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(1332, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$15       ] , 'vcmpnlt_uqps  k5,zmm30,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(1333, [$62,$F1,$0C,$50,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqps  k5,zmm30,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(1334, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$15       ] , 'vcmpnlt_uqps  k5,zmm30,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(1335, [$62,$91,$0C,$40,$C2,$ED,$16                       ] , 'vcmpnle_uqps  k5,zmm30,zmm29'                     );
  TestCase.testcase(1336, [$62,$91,$0C,$47,$C2,$ED,$16                       ] , 'vcmpnle_uqps  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(1337, [$62,$91,$0C,$10,$C2,$ED,$16                       ] , 'vcmpnle_uqps  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(1338, [$62,$F1,$0C,$40,$C2,$29,$16                       ] , 'vcmpnle_uqps  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(1339, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$16   ] , 'vcmpnle_uqps  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(1340, [$62,$F1,$0C,$50,$C2,$29,$16                       ] , 'vcmpnle_uqps  k5,zmm30,dword [rcx]{1to16}'        );
  TestCase.testcase(1341, [$62,$F1,$0C,$40,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqps  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(1342, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$16       ] , 'vcmpnle_uqps  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(1343, [$62,$F1,$0C,$40,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqps  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(1344, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$16       ] , 'vcmpnle_uqps  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(1345, [$62,$F1,$0C,$50,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(1346, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$16       ] , 'vcmpnle_uqps  k5,zmm30,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(1347, [$62,$F1,$0C,$50,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqps  k5,zmm30,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(1348, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$16       ] , 'vcmpnle_uqps  k5,zmm30,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(1349, [$62,$91,$0C,$40,$C2,$ED,$17                       ] , 'vcmpord_sps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1350, [$62,$91,$0C,$47,$C2,$ED,$17                       ] , 'vcmpord_sps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1351, [$62,$91,$0C,$10,$C2,$ED,$17                       ] , 'vcmpord_sps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1352, [$62,$F1,$0C,$40,$C2,$29,$17                       ] , 'vcmpord_sps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1353, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$17   ] , 'vcmpord_sps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1354, [$62,$F1,$0C,$50,$C2,$29,$17                       ] , 'vcmpord_sps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1355, [$62,$F1,$0C,$40,$C2,$6A,$7F,$17                   ] , 'vcmpord_sps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1356, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$17       ] , 'vcmpord_sps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1357, [$62,$F1,$0C,$40,$C2,$6A,$80,$17                   ] , 'vcmpord_sps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1358, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$17       ] , 'vcmpord_sps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1359, [$62,$F1,$0C,$50,$C2,$6A,$7F,$17                   ] , 'vcmpord_sps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1360, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$17       ] , 'vcmpord_sps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1361, [$62,$F1,$0C,$50,$C2,$6A,$80,$17                   ] , 'vcmpord_sps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1362, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$17       ] , 'vcmpord_sps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1363, [$62,$91,$0C,$40,$C2,$ED,$18                       ] , 'vcmpeq_usps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1364, [$62,$91,$0C,$47,$C2,$ED,$18                       ] , 'vcmpeq_usps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1365, [$62,$91,$0C,$10,$C2,$ED,$18                       ] , 'vcmpeq_usps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1366, [$62,$F1,$0C,$40,$C2,$29,$18                       ] , 'vcmpeq_usps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1367, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$18   ] , 'vcmpeq_usps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1368, [$62,$F1,$0C,$50,$C2,$29,$18                       ] , 'vcmpeq_usps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1369, [$62,$F1,$0C,$40,$C2,$6A,$7F,$18                   ] , 'vcmpeq_usps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1370, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$18       ] , 'vcmpeq_usps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1371, [$62,$F1,$0C,$40,$C2,$6A,$80,$18                   ] , 'vcmpeq_usps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1372, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$18       ] , 'vcmpeq_usps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1373, [$62,$F1,$0C,$50,$C2,$6A,$7F,$18                   ] , 'vcmpeq_usps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1374, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$18       ] , 'vcmpeq_usps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1375, [$62,$F1,$0C,$50,$C2,$6A,$80,$18                   ] , 'vcmpeq_usps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1376, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$18       ] , 'vcmpeq_usps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1377, [$62,$91,$0C,$40,$C2,$ED,$19                       ] , 'vcmpnge_uqps  k5,zmm30,zmm29'                     );
  TestCase.testcase(1378, [$62,$91,$0C,$47,$C2,$ED,$19                       ] , 'vcmpnge_uqps  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(1379, [$62,$91,$0C,$10,$C2,$ED,$19                       ] , 'vcmpnge_uqps  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(1380, [$62,$F1,$0C,$40,$C2,$29,$19                       ] , 'vcmpnge_uqps  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(1381, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$19   ] , 'vcmpnge_uqps  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(1382, [$62,$F1,$0C,$50,$C2,$29,$19                       ] , 'vcmpnge_uqps  k5,zmm30,dword [rcx]{1to16}'        );
  TestCase.testcase(1383, [$62,$F1,$0C,$40,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqps  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(1384, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$19       ] , 'vcmpnge_uqps  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(1385, [$62,$F1,$0C,$40,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqps  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(1386, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$19       ] , 'vcmpnge_uqps  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(1387, [$62,$F1,$0C,$50,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(1388, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$19       ] , 'vcmpnge_uqps  k5,zmm30,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(1389, [$62,$F1,$0C,$50,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqps  k5,zmm30,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(1390, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$19       ] , 'vcmpnge_uqps  k5,zmm30,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(1391, [$62,$91,$0C,$40,$C2,$ED,$1A                       ] , 'vcmpngt_uqps  k5,zmm30,zmm29'                     );
  TestCase.testcase(1392, [$62,$91,$0C,$47,$C2,$ED,$1A                       ] , 'vcmpngt_uqps  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(1393, [$62,$91,$0C,$10,$C2,$ED,$1A                       ] , 'vcmpngt_uqps  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(1394, [$62,$F1,$0C,$40,$C2,$29,$1A                       ] , 'vcmpngt_uqps  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(1395, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1A   ] , 'vcmpngt_uqps  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(1396, [$62,$F1,$0C,$50,$C2,$29,$1A                       ] , 'vcmpngt_uqps  k5,zmm30,dword [rcx]{1to16}'        );
  TestCase.testcase(1397, [$62,$F1,$0C,$40,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqps  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(1398, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$1A       ] , 'vcmpngt_uqps  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(1399, [$62,$F1,$0C,$40,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqps  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(1400, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1A       ] , 'vcmpngt_uqps  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(1401, [$62,$F1,$0C,$50,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(1402, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$1A       ] , 'vcmpngt_uqps  k5,zmm30,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(1403, [$62,$F1,$0C,$50,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqps  k5,zmm30,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(1404, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$1A       ] , 'vcmpngt_uqps  k5,zmm30,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(1405, [$62,$91,$0C,$40,$C2,$ED,$1B                       ] , 'vcmpfalse_osps  k5,zmm30,zmm29'                   );
  TestCase.testcase(1406, [$62,$91,$0C,$47,$C2,$ED,$1B                       ] , 'vcmpfalse_osps  k5{k7},zmm30,zmm29'               );
  TestCase.testcase(1407, [$62,$91,$0C,$10,$C2,$ED,$1B                       ] , 'vcmpfalse_osps  k5,zmm30,zmm29,{sae}'             );
  TestCase.testcase(1408, [$62,$F1,$0C,$40,$C2,$29,$1B                       ] , 'vcmpfalse_osps  k5,zmm30,zword [rcx]'             );
  TestCase.testcase(1409, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1B   ] , 'vcmpfalse_osps  k5,zmm30,zword [rax+r14*8+0x123]' );
  TestCase.testcase(1410, [$62,$F1,$0C,$50,$C2,$29,$1B                       ] , 'vcmpfalse_osps  k5,zmm30,dword [rcx]{1to16}'      );
  TestCase.testcase(1411, [$62,$F1,$0C,$40,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_osps  k5,zmm30,zword [rdx+0x1fc0]'      );
  TestCase.testcase(1412, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$1B       ] , 'vcmpfalse_osps  k5,zmm30,zword [rdx+0x2000]'      );
  TestCase.testcase(1413, [$62,$F1,$0C,$40,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_osps  k5,zmm30,zword [rdx-0x2000]'      );
  TestCase.testcase(1414, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1B       ] , 'vcmpfalse_osps  k5,zmm30,zword [rdx-0x2040]'      );
  TestCase.testcase(1415, [$62,$F1,$0C,$50,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_osps  k5,zmm30,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(1416, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$1B       ] , 'vcmpfalse_osps  k5,zmm30,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(1417, [$62,$F1,$0C,$50,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_osps  k5,zmm30,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(1418, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$1B       ] , 'vcmpfalse_osps  k5,zmm30,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(1419, [$62,$91,$0C,$40,$C2,$ED,$1C                       ] , 'vcmpneq_osps  k5,zmm30,zmm29'                     );
  TestCase.testcase(1420, [$62,$91,$0C,$47,$C2,$ED,$1C                       ] , 'vcmpneq_osps  k5{k7},zmm30,zmm29'                 );
  TestCase.testcase(1421, [$62,$91,$0C,$10,$C2,$ED,$1C                       ] , 'vcmpneq_osps  k5,zmm30,zmm29,{sae}'               );
  TestCase.testcase(1422, [$62,$F1,$0C,$40,$C2,$29,$1C                       ] , 'vcmpneq_osps  k5,zmm30,zword [rcx]'               );
  TestCase.testcase(1423, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1C   ] , 'vcmpneq_osps  k5,zmm30,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(1424, [$62,$F1,$0C,$50,$C2,$29,$1C                       ] , 'vcmpneq_osps  k5,zmm30,dword [rcx]{1to16}'        );
  TestCase.testcase(1425, [$62,$F1,$0C,$40,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_osps  k5,zmm30,zword [rdx+0x1fc0]'        );
  TestCase.testcase(1426, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$1C       ] , 'vcmpneq_osps  k5,zmm30,zword [rdx+0x2000]'        );
  TestCase.testcase(1427, [$62,$F1,$0C,$40,$C2,$6A,$80,$1C                   ] , 'vcmpneq_osps  k5,zmm30,zword [rdx-0x2000]'        );
  TestCase.testcase(1428, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1C       ] , 'vcmpneq_osps  k5,zmm30,zword [rdx-0x2040]'        );
  TestCase.testcase(1429, [$62,$F1,$0C,$50,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_osps  k5,zmm30,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(1430, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$1C       ] , 'vcmpneq_osps  k5,zmm30,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(1431, [$62,$F1,$0C,$50,$C2,$6A,$80,$1C                   ] , 'vcmpneq_osps  k5,zmm30,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(1432, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$1C       ] , 'vcmpneq_osps  k5,zmm30,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(1433, [$62,$91,$0C,$40,$C2,$ED,$1D                       ] , 'vcmpge_oqps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1434, [$62,$91,$0C,$47,$C2,$ED,$1D                       ] , 'vcmpge_oqps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1435, [$62,$91,$0C,$10,$C2,$ED,$1D                       ] , 'vcmpge_oqps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1436, [$62,$F1,$0C,$40,$C2,$29,$1D                       ] , 'vcmpge_oqps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1437, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1D   ] , 'vcmpge_oqps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1438, [$62,$F1,$0C,$50,$C2,$29,$1D                       ] , 'vcmpge_oqps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1439, [$62,$F1,$0C,$40,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1440, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$1D       ] , 'vcmpge_oqps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1441, [$62,$F1,$0C,$40,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1442, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1D       ] , 'vcmpge_oqps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1443, [$62,$F1,$0C,$50,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1444, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$1D       ] , 'vcmpge_oqps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1445, [$62,$F1,$0C,$50,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1446, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$1D       ] , 'vcmpge_oqps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1447, [$62,$91,$0C,$40,$C2,$ED,$1E                       ] , 'vcmpgt_oqps  k5,zmm30,zmm29'                      );
  TestCase.testcase(1448, [$62,$91,$0C,$47,$C2,$ED,$1E                       ] , 'vcmpgt_oqps  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(1449, [$62,$91,$0C,$10,$C2,$ED,$1E                       ] , 'vcmpgt_oqps  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(1450, [$62,$F1,$0C,$40,$C2,$29,$1E                       ] , 'vcmpgt_oqps  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(1451, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1E   ] , 'vcmpgt_oqps  k5,zmm30,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(1452, [$62,$F1,$0C,$50,$C2,$29,$1E                       ] , 'vcmpgt_oqps  k5,zmm30,dword [rcx]{1to16}'         );
  TestCase.testcase(1453, [$62,$F1,$0C,$40,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqps  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(1454, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$1E       ] , 'vcmpgt_oqps  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(1455, [$62,$F1,$0C,$40,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqps  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(1456, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1E       ] , 'vcmpgt_oqps  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(1457, [$62,$F1,$0C,$50,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqps  k5,zmm30,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(1458, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$1E       ] , 'vcmpgt_oqps  k5,zmm30,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(1459, [$62,$F1,$0C,$50,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqps  k5,zmm30,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(1460, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$1E       ] , 'vcmpgt_oqps  k5,zmm30,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(1461, [$62,$91,$0C,$40,$C2,$ED,$1F                       ] , 'vcmue_usps  k5,zmm30,zmm29'                       );
  TestCase.testcase(1462, [$62,$91,$0C,$47,$C2,$ED,$1F                       ] , 'vcmue_usps  k5{k7},zmm30,zmm29'                   );
  TestCase.testcase(1463, [$62,$91,$0C,$10,$C2,$ED,$1F                       ] , 'vcmue_usps  k5,zmm30,zmm29,{sae}'                 );
  TestCase.testcase(1464, [$62,$F1,$0C,$40,$C2,$29,$1F                       ] , 'vcmue_usps  k5,zmm30,zword [rcx]'                 );
  TestCase.testcase(1465, [$62,$B1,$0C,$40,$C2,$AC,$F0,$23,$01,$00,$00,$1F   ] , 'vcmue_usps  k5,zmm30,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(1466, [$62,$F1,$0C,$50,$C2,$29,$1F                       ] , 'vcmue_usps  k5,zmm30,dword [rcx]{1to16}'          );
  TestCase.testcase(1467, [$62,$F1,$0C,$40,$C2,$6A,$7F,$1F                   ] , 'vcmue_usps  k5,zmm30,zword [rdx+0x1fc0]'          );
  TestCase.testcase(1468, [$62,$F1,$0C,$40,$C2,$AA,$00,$20,$00,$00,$1F       ] , 'vcmue_usps  k5,zmm30,zword [rdx+0x2000]'          );
  TestCase.testcase(1469, [$62,$F1,$0C,$40,$C2,$6A,$80,$1F                   ] , 'vcmue_usps  k5,zmm30,zword [rdx-0x2000]'          );
  TestCase.testcase(1470, [$62,$F1,$0C,$40,$C2,$AA,$C0,$DF,$FF,$FF,$1F       ] , 'vcmue_usps  k5,zmm30,zword [rdx-0x2040]'          );
  TestCase.testcase(1471, [$62,$F1,$0C,$50,$C2,$6A,$7F,$1F                   ] , 'vcmue_usps  k5,zmm30,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(1472, [$62,$F1,$0C,$50,$C2,$AA,$00,$02,$00,$00,$1F       ] , 'vcmue_usps  k5,zmm30,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(1473, [$62,$F1,$0C,$50,$C2,$6A,$80,$1F                   ] , 'vcmue_usps  k5,zmm30,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(1474, [$62,$F1,$0C,$50,$C2,$AA,$FC,$FD,$FF,$FF,$1F       ] , 'vcmue_usps  k5,zmm30,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(1475, [$62,$91,$97,$07,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,0xab'                  );
  TestCase.testcase(1476, [$62,$91,$97,$17,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,{sae},0xab'            );
  TestCase.testcase(1477, [$62,$91,$97,$07,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,0x7b'                  );
  TestCase.testcase(1478, [$62,$91,$97,$17,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm29,xmm28,{sae},0x7b'            );
  TestCase.testcase(1479, [$62,$F1,$97,$07,$C2,$29,$7B                       ] , 'vcmpsd  k5{k7},xmm29,qword [rcx],0x7b'            );
  TestCase.testcase(1480, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vcmpsd  k5{k7},xmm29,qword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(1481, [$62,$F1,$97,$07,$C2,$6A,$7F,$7B                   ] , 'vcmpsd  k5{k7},xmm29,qword [rdx+0x3f8],0x7b'      );
  TestCase.testcase(1482, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$7B       ] , 'vcmpsd  k5{k7},xmm29,qword [rdx+0x400],0x7b'      );
  TestCase.testcase(1483, [$62,$F1,$97,$07,$C2,$6A,$80,$7B                   ] , 'vcmpsd  k5{k7},xmm29,qword [rdx-0x400],0x7b'      );
  TestCase.testcase(1484, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vcmpsd  k5{k7},xmm29,qword [rdx-0x408],0x7b'      );
  TestCase.testcase(1485, [$62,$91,$97,$07,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1486, [$62,$91,$97,$17,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1487, [$62,$F1,$97,$07,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1488, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1489, [$62,$F1,$97,$07,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1490, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1491, [$62,$F1,$97,$07,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1492, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1493, [$62,$91,$97,$07,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1494, [$62,$91,$97,$17,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1495, [$62,$F1,$97,$07,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1496, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1497, [$62,$F1,$97,$07,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1498, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1499, [$62,$F1,$97,$07,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1500, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1501, [$62,$91,$97,$07,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1502, [$62,$91,$97,$17,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1503, [$62,$F1,$97,$07,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1504, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1505, [$62,$F1,$97,$07,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1506, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1507, [$62,$F1,$97,$07,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1508, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1509, [$62,$91,$97,$07,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1510, [$62,$91,$97,$17,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1511, [$62,$F1,$97,$07,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1512, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1513, [$62,$F1,$97,$07,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1514, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1515, [$62,$F1,$97,$07,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1516, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1517, [$62,$91,$97,$07,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1518, [$62,$91,$97,$17,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1519, [$62,$F1,$97,$07,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1520, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmplesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1521, [$62,$F1,$97,$07,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1522, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1523, [$62,$F1,$97,$07,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1524, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1525, [$62,$91,$97,$07,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1526, [$62,$91,$97,$17,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1527, [$62,$F1,$97,$07,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1528, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmplesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1529, [$62,$F1,$97,$07,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1530, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1531, [$62,$F1,$97,$07,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1532, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1533, [$62,$91,$97,$07,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1534, [$62,$91,$97,$17,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1535, [$62,$F1,$97,$07,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1536, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1537, [$62,$F1,$97,$07,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1538, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1539, [$62,$F1,$97,$07,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1540, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1541, [$62,$91,$97,$07,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1542, [$62,$91,$97,$17,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1543, [$62,$F1,$97,$07,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1544, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1545, [$62,$F1,$97,$07,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1546, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1547, [$62,$F1,$97,$07,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1548, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1549, [$62,$91,$97,$07,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1550, [$62,$91,$97,$17,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1551, [$62,$F1,$97,$07,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1552, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1553, [$62,$F1,$97,$07,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1554, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1555, [$62,$F1,$97,$07,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1556, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1557, [$62,$91,$97,$07,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1558, [$62,$91,$97,$17,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1559, [$62,$F1,$97,$07,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1560, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1561, [$62,$F1,$97,$07,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1562, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1563, [$62,$F1,$97,$07,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1564, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1565, [$62,$91,$97,$07,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1566, [$62,$91,$97,$17,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1567, [$62,$F1,$97,$07,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1568, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1569, [$62,$F1,$97,$07,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1570, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1571, [$62,$F1,$97,$07,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1572, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1573, [$62,$91,$97,$07,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1574, [$62,$91,$97,$17,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1575, [$62,$F1,$97,$07,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1576, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1577, [$62,$F1,$97,$07,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1578, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1579, [$62,$F1,$97,$07,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1580, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1581, [$62,$91,$97,$07,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1582, [$62,$91,$97,$17,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1583, [$62,$F1,$97,$07,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1584, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1585, [$62,$F1,$97,$07,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1586, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1587, [$62,$F1,$97,$07,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1588, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1589, [$62,$91,$97,$07,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1590, [$62,$91,$97,$17,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1591, [$62,$F1,$97,$07,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1592, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1593, [$62,$F1,$97,$07,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1594, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1595, [$62,$F1,$97,$07,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1596, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1597, [$62,$91,$97,$07,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1598, [$62,$91,$97,$17,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1599, [$62,$F1,$97,$07,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1600, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1601, [$62,$F1,$97,$07,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1602, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1603, [$62,$F1,$97,$07,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1604, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1605, [$62,$91,$97,$07,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1606, [$62,$91,$97,$17,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1607, [$62,$F1,$97,$07,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1608, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1609, [$62,$F1,$97,$07,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1610, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1611, [$62,$F1,$97,$07,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1612, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1613, [$62,$91,$97,$07,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1614, [$62,$91,$97,$17,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1615, [$62,$F1,$97,$07,$C2,$29,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1616, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$08   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1617, [$62,$F1,$97,$07,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1618, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1619, [$62,$F1,$97,$07,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1620, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1621, [$62,$91,$97,$07,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1622, [$62,$91,$97,$17,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1623, [$62,$F1,$97,$07,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1624, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1625, [$62,$F1,$97,$07,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1626, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1627, [$62,$F1,$97,$07,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1628, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1629, [$62,$91,$97,$07,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1630, [$62,$91,$97,$17,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1631, [$62,$F1,$97,$07,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1632, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1633, [$62,$F1,$97,$07,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1634, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1635, [$62,$F1,$97,$07,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1636, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1637, [$62,$91,$97,$07,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1638, [$62,$91,$97,$17,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1639, [$62,$F1,$97,$07,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1640, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1641, [$62,$F1,$97,$07,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1642, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1643, [$62,$F1,$97,$07,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1644, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1645, [$62,$91,$97,$07,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1646, [$62,$91,$97,$17,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1647, [$62,$F1,$97,$07,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(1648, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(1649, [$62,$F1,$97,$07,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(1650, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(1651, [$62,$F1,$97,$07,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(1652, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(1653, [$62,$91,$97,$07,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1654, [$62,$91,$97,$17,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1655, [$62,$F1,$97,$07,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1656, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1657, [$62,$F1,$97,$07,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1658, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1659, [$62,$F1,$97,$07,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1660, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1661, [$62,$91,$97,$07,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1662, [$62,$91,$97,$17,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1663, [$62,$F1,$97,$07,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1664, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1665, [$62,$F1,$97,$07,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1666, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1667, [$62,$F1,$97,$07,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1668, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1669, [$62,$91,$97,$07,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(1670, [$62,$91,$97,$17,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1671, [$62,$F1,$97,$07,$C2,$29,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1672, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0C   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1673, [$62,$F1,$97,$07,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1674, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1675, [$62,$F1,$97,$07,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1676, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1677, [$62,$91,$97,$07,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1678, [$62,$91,$97,$17,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1679, [$62,$F1,$97,$07,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1680, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1681, [$62,$F1,$97,$07,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1682, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1683, [$62,$F1,$97,$07,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1684, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1685, [$62,$91,$97,$07,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1686, [$62,$91,$97,$17,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1687, [$62,$F1,$97,$07,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1688, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1689, [$62,$F1,$97,$07,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1690, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1691, [$62,$F1,$97,$07,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1692, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1693, [$62,$91,$97,$07,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1694, [$62,$91,$97,$17,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1695, [$62,$F1,$97,$07,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1696, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1697, [$62,$F1,$97,$07,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1698, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1699, [$62,$F1,$97,$07,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1700, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1701, [$62,$91,$97,$07,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1702, [$62,$91,$97,$17,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1703, [$62,$F1,$97,$07,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rcx]'               );
  TestCase.testcase(1704, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(1705, [$62,$F1,$97,$07,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(1706, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(1707, [$62,$F1,$97,$07,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(1708, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(1709, [$62,$91,$97,$07,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(1710, [$62,$91,$97,$17,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(1711, [$62,$F1,$97,$07,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm29,qword [rcx]'                );
  TestCase.testcase(1712, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'    );
  TestCase.testcase(1713, [$62,$F1,$97,$07,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x3f8]'          );
  TestCase.testcase(1714, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x400]'          );
  TestCase.testcase(1715, [$62,$F1,$97,$07,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x400]'          );
  TestCase.testcase(1716, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x408]'          );
  TestCase.testcase(1717, [$62,$91,$97,$07,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(1718, [$62,$91,$97,$17,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(1719, [$62,$F1,$97,$07,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm29,qword [rcx]'                );
  TestCase.testcase(1720, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuesd  k5{k7},xmm29,qword [rax+r14*8+0x123]'    );
  TestCase.testcase(1721, [$62,$F1,$97,$07,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x3f8]'          );
  TestCase.testcase(1722, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx+0x400]'          );
  TestCase.testcase(1723, [$62,$F1,$97,$07,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x400]'          );
  TestCase.testcase(1724, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm29,qword [rdx-0x408]'          );
  TestCase.testcase(1725, [$62,$91,$97,$07,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1726, [$62,$91,$97,$17,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1727, [$62,$F1,$97,$07,$C2,$29,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1728, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$10   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1729, [$62,$F1,$97,$07,$C2,$6A,$7F,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1730, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$10       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1731, [$62,$F1,$97,$07,$C2,$6A,$80,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1732, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$10       ] , 'vcmpeq_ossd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1733, [$62,$91,$97,$07,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1734, [$62,$91,$97,$17,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1735, [$62,$F1,$97,$07,$C2,$29,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1736, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$11   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1737, [$62,$F1,$97,$07,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1738, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$11       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1739, [$62,$F1,$97,$07,$C2,$6A,$80,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1740, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$11       ] , 'vcmplt_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1741, [$62,$91,$97,$07,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1742, [$62,$91,$97,$17,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1743, [$62,$F1,$97,$07,$C2,$29,$12                       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1744, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$12   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1745, [$62,$F1,$97,$07,$C2,$6A,$7F,$12                   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1746, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$12       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1747, [$62,$F1,$97,$07,$C2,$6A,$80,$12                   ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1748, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$12       ] , 'vcmple_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1749, [$62,$91,$97,$07,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,xmm28'                );
  TestCase.testcase(1750, [$62,$91,$97,$17,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(1751, [$62,$F1,$97,$07,$C2,$29,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rcx]'          );
  TestCase.testcase(1752, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$13   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1753, [$62,$F1,$97,$07,$C2,$6A,$7F,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx+0x3f8]'    );
  TestCase.testcase(1754, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$13       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx+0x400]'    );
  TestCase.testcase(1755, [$62,$F1,$97,$07,$C2,$6A,$80,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx-0x400]'    );
  TestCase.testcase(1756, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$13       ] , 'vcmpunord_ssd  k5{k7},xmm29,qword [rdx-0x408]'    );
  TestCase.testcase(1757, [$62,$91,$97,$07,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(1758, [$62,$91,$97,$17,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1759, [$62,$F1,$97,$07,$C2,$29,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1760, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$14   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1761, [$62,$F1,$97,$07,$C2,$6A,$7F,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1762, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$14       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1763, [$62,$F1,$97,$07,$C2,$6A,$80,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1764, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$14       ] , 'vcmpneq_ussd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1765, [$62,$91,$97,$07,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(1766, [$62,$91,$97,$17,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1767, [$62,$F1,$97,$07,$C2,$29,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1768, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$15   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1769, [$62,$F1,$97,$07,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1770, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1771, [$62,$F1,$97,$07,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1772, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1773, [$62,$91,$97,$07,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(1774, [$62,$91,$97,$17,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1775, [$62,$F1,$97,$07,$C2,$29,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1776, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$16   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1777, [$62,$F1,$97,$07,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1778, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1779, [$62,$F1,$97,$07,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1780, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1781, [$62,$91,$97,$07,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1782, [$62,$91,$97,$17,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1783, [$62,$F1,$97,$07,$C2,$29,$17                       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1784, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$17   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1785, [$62,$F1,$97,$07,$C2,$6A,$7F,$17                   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1786, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$17       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1787, [$62,$F1,$97,$07,$C2,$6A,$80,$17                   ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1788, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$17       ] , 'vcmpord_ssd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1789, [$62,$91,$97,$07,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1790, [$62,$91,$97,$17,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1791, [$62,$F1,$97,$07,$C2,$29,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1792, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$18   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1793, [$62,$F1,$97,$07,$C2,$6A,$7F,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1794, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$18       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1795, [$62,$F1,$97,$07,$C2,$6A,$80,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1796, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$18       ] , 'vcmpeq_ussd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1797, [$62,$91,$97,$07,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(1798, [$62,$91,$97,$17,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1799, [$62,$F1,$97,$07,$C2,$29,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1800, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$19   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1801, [$62,$F1,$97,$07,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1802, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1803, [$62,$F1,$97,$07,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1804, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1805, [$62,$91,$97,$07,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(1806, [$62,$91,$97,$17,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1807, [$62,$F1,$97,$07,$C2,$29,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1808, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1A   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1809, [$62,$F1,$97,$07,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1810, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1811, [$62,$F1,$97,$07,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1812, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1813, [$62,$91,$97,$07,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,xmm28'               );
  TestCase.testcase(1814, [$62,$91,$97,$17,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,xmm28,{sae}'         );
  TestCase.testcase(1815, [$62,$F1,$97,$07,$C2,$29,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(1816, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1B   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1817, [$62,$F1,$97,$07,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(1818, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(1819, [$62,$F1,$97,$07,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(1820, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(1821, [$62,$91,$97,$07,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(1822, [$62,$91,$97,$17,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(1823, [$62,$F1,$97,$07,$C2,$29,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(1824, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1C   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1825, [$62,$F1,$97,$07,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(1826, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(1827, [$62,$F1,$97,$07,$C2,$6A,$80,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(1828, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(1829, [$62,$91,$97,$07,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1830, [$62,$91,$97,$17,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1831, [$62,$F1,$97,$07,$C2,$29,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1832, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1D   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1833, [$62,$F1,$97,$07,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1834, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1835, [$62,$F1,$97,$07,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1836, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1837, [$62,$91,$97,$07,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1838, [$62,$91,$97,$17,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1839, [$62,$F1,$97,$07,$C2,$29,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(1840, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1E   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1841, [$62,$F1,$97,$07,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(1842, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(1843, [$62,$F1,$97,$07,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(1844, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(1845, [$62,$91,$97,$07,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,xmm28'                   );
  TestCase.testcase(1846, [$62,$91,$97,$17,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,xmm28,{sae}'             );
  TestCase.testcase(1847, [$62,$F1,$97,$07,$C2,$29,$1F                       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rcx]'             );
  TestCase.testcase(1848, [$62,$B1,$97,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1F   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(1849, [$62,$F1,$97,$07,$C2,$6A,$7F,$1F                   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx+0x3f8]'       );
  TestCase.testcase(1850, [$62,$F1,$97,$07,$C2,$AA,$00,$04,$00,$00,$1F       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx+0x400]'       );
  TestCase.testcase(1851, [$62,$F1,$97,$07,$C2,$6A,$80,$1F                   ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx-0x400]'       );
  TestCase.testcase(1852, [$62,$F1,$97,$07,$C2,$AA,$F8,$FB,$FF,$FF,$1F       ] , 'vcmue_ussd  k5{k7},xmm29,qword [rdx-0x408]'       );
  TestCase.testcase(1853, [$62,$91,$16,$07,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm29,xmm28,0xab'                  );
  TestCase.testcase(1854, [$62,$91,$16,$17,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm29,xmm28,{sae},0xab'            );
  TestCase.testcase(1855, [$62,$91,$16,$07,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm29,xmm28,0x7b'                  );
  TestCase.testcase(1856, [$62,$91,$16,$17,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm29,xmm28,{sae},0x7b'            );
  TestCase.testcase(1857, [$62,$F1,$16,$07,$C2,$29,$7B                       ] , 'vcmpss  k5{k7},xmm29,dword [rcx],0x7b'            );
  TestCase.testcase(1858, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vcmpss  k5{k7},xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(1859, [$62,$F1,$16,$07,$C2,$6A,$7F,$7B                   ] , 'vcmpss  k5{k7},xmm29,dword [rdx+0x1fc],0x7b'      );
  TestCase.testcase(1860, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$7B       ] , 'vcmpss  k5{k7},xmm29,dword [rdx+0x200],0x7b'      );
  TestCase.testcase(1861, [$62,$F1,$16,$07,$C2,$6A,$80,$7B                   ] , 'vcmpss  k5{k7},xmm29,dword [rdx-0x200],0x7b'      );
  TestCase.testcase(1862, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vcmpss  k5{k7},xmm29,dword [rdx-0x204],0x7b'      );
  TestCase.testcase(1863, [$62,$91,$16,$07,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1864, [$62,$91,$16,$17,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1865, [$62,$F1,$16,$07,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(1866, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(1867, [$62,$F1,$16,$07,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(1868, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(1869, [$62,$F1,$16,$07,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(1870, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(1871, [$62,$91,$16,$07,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1872, [$62,$91,$16,$17,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1873, [$62,$F1,$16,$07,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(1874, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vcmpeqss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(1875, [$62,$F1,$16,$07,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(1876, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(1877, [$62,$F1,$16,$07,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(1878, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(1879, [$62,$91,$16,$07,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1880, [$62,$91,$16,$17,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1881, [$62,$F1,$16,$07,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(1882, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(1883, [$62,$F1,$16,$07,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(1884, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(1885, [$62,$F1,$16,$07,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(1886, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(1887, [$62,$91,$16,$07,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1888, [$62,$91,$16,$17,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1889, [$62,$F1,$16,$07,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(1890, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vcmpltss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(1891, [$62,$F1,$16,$07,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(1892, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(1893, [$62,$F1,$16,$07,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(1894, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(1895, [$62,$91,$16,$07,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1896, [$62,$91,$16,$17,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1897, [$62,$F1,$16,$07,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(1898, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmpless  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(1899, [$62,$F1,$16,$07,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(1900, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(1901, [$62,$F1,$16,$07,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(1902, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(1903, [$62,$91,$16,$07,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(1904, [$62,$91,$16,$17,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(1905, [$62,$F1,$16,$07,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(1906, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vcmpless  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(1907, [$62,$F1,$16,$07,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(1908, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(1909, [$62,$F1,$16,$07,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(1910, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(1911, [$62,$91,$16,$07,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1912, [$62,$91,$16,$17,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1913, [$62,$F1,$16,$07,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(1914, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1915, [$62,$F1,$16,$07,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(1916, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(1917, [$62,$F1,$16,$07,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(1918, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(1919, [$62,$91,$16,$07,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1920, [$62,$91,$16,$17,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1921, [$62,$F1,$16,$07,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(1922, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$03   ] , 'vcmpunordss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1923, [$62,$F1,$16,$07,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(1924, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(1925, [$62,$F1,$16,$07,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(1926, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(1927, [$62,$91,$16,$07,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1928, [$62,$91,$16,$17,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1929, [$62,$F1,$16,$07,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1930, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1931, [$62,$F1,$16,$07,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1932, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1933, [$62,$F1,$16,$07,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1934, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1935, [$62,$91,$16,$07,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1936, [$62,$91,$16,$17,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1937, [$62,$F1,$16,$07,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1938, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vcmpneqss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1939, [$62,$F1,$16,$07,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1940, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1941, [$62,$F1,$16,$07,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1942, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1943, [$62,$91,$16,$07,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1944, [$62,$91,$16,$17,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1945, [$62,$F1,$16,$07,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1946, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1947, [$62,$F1,$16,$07,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1948, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1949, [$62,$F1,$16,$07,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1950, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1951, [$62,$91,$16,$07,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1952, [$62,$91,$16,$17,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1953, [$62,$F1,$16,$07,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1954, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vcmpnltss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1955, [$62,$F1,$16,$07,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1956, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1957, [$62,$F1,$16,$07,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1958, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1959, [$62,$91,$16,$07,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1960, [$62,$91,$16,$17,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1961, [$62,$F1,$16,$07,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1962, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnless  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1963, [$62,$F1,$16,$07,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1964, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1965, [$62,$F1,$16,$07,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1966, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1967, [$62,$91,$16,$07,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1968, [$62,$91,$16,$17,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1969, [$62,$F1,$16,$07,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1970, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vcmpnless  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1971, [$62,$F1,$16,$07,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1972, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1973, [$62,$F1,$16,$07,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1974, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1975, [$62,$91,$16,$07,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1976, [$62,$91,$16,$17,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1977, [$62,$F1,$16,$07,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1978, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1979, [$62,$F1,$16,$07,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1980, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1981, [$62,$F1,$16,$07,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1982, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1983, [$62,$91,$16,$07,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(1984, [$62,$91,$16,$17,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(1985, [$62,$F1,$16,$07,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(1986, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$07   ] , 'vcmpordss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(1987, [$62,$F1,$16,$07,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(1988, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(1989, [$62,$F1,$16,$07,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(1990, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(1991, [$62,$91,$16,$07,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(1992, [$62,$91,$16,$17,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(1993, [$62,$F1,$16,$07,$C2,$29,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(1994, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$08   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(1995, [$62,$F1,$16,$07,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(1996, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$08       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(1997, [$62,$F1,$16,$07,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(1998, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$08       ] , 'vcmpeq_uqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(1999, [$62,$91,$16,$07,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2000, [$62,$91,$16,$17,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2001, [$62,$F1,$16,$07,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2002, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngess  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(2003, [$62,$F1,$16,$07,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2004, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2005, [$62,$F1,$16,$07,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2006, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2007, [$62,$91,$16,$07,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2008, [$62,$91,$16,$17,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2009, [$62,$F1,$16,$07,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2010, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$09   ] , 'vcmpngess  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(2011, [$62,$F1,$16,$07,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2012, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2013, [$62,$F1,$16,$07,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2014, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2015, [$62,$91,$16,$07,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2016, [$62,$91,$16,$17,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2017, [$62,$F1,$16,$07,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2018, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(2019, [$62,$F1,$16,$07,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2020, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2021, [$62,$F1,$16,$07,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2022, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2023, [$62,$91,$16,$07,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28'                    );
  TestCase.testcase(2024, [$62,$91,$16,$17,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(2025, [$62,$F1,$16,$07,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2026, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0A   ] , 'vcmpngtss  k5{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(2027, [$62,$F1,$16,$07,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2028, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2029, [$62,$F1,$16,$07,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2030, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2031, [$62,$91,$16,$07,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2032, [$62,$91,$16,$17,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2033, [$62,$F1,$16,$07,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2034, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2035, [$62,$F1,$16,$07,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2036, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2037, [$62,$F1,$16,$07,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2038, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2039, [$62,$91,$16,$07,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2040, [$62,$91,$16,$17,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2041, [$62,$F1,$16,$07,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2042, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0B   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2043, [$62,$F1,$16,$07,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2044, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2045, [$62,$F1,$16,$07,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2046, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2047, [$62,$91,$16,$07,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2048, [$62,$91,$16,$17,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2049, [$62,$F1,$16,$07,$C2,$29,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2050, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0C   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2051, [$62,$F1,$16,$07,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2052, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2053, [$62,$F1,$16,$07,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2054, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2055, [$62,$91,$16,$07,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2056, [$62,$91,$16,$17,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2057, [$62,$F1,$16,$07,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2058, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgess  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(2059, [$62,$F1,$16,$07,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2060, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2061, [$62,$F1,$16,$07,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2062, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2063, [$62,$91,$16,$07,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2064, [$62,$91,$16,$17,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2065, [$62,$F1,$16,$07,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2066, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0D   ] , 'vcmpgess  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(2067, [$62,$F1,$16,$07,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2068, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2069, [$62,$F1,$16,$07,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2070, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2071, [$62,$91,$16,$07,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2072, [$62,$91,$16,$17,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2073, [$62,$F1,$16,$07,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2074, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(2075, [$62,$F1,$16,$07,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2076, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2077, [$62,$F1,$16,$07,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2078, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2079, [$62,$91,$16,$07,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28'                     );
  TestCase.testcase(2080, [$62,$91,$16,$17,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,xmm28,{sae}'               );
  TestCase.testcase(2081, [$62,$F1,$16,$07,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm29,dword [rcx]'               );
  TestCase.testcase(2082, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0E   ] , 'vcmpgtss  k5{k7},xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(2083, [$62,$F1,$16,$07,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2084, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2085, [$62,$F1,$16,$07,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2086, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2087, [$62,$91,$16,$07,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(2088, [$62,$91,$16,$17,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(2089, [$62,$F1,$16,$07,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm29,dword [rcx]'                );
  TestCase.testcase(2090, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuess  k5{k7},xmm29,dword [rax+r14*8+0x123]'    );
  TestCase.testcase(2091, [$62,$F1,$16,$07,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x1fc]'          );
  TestCase.testcase(2092, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x200]'          );
  TestCase.testcase(2093, [$62,$F1,$16,$07,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x200]'          );
  TestCase.testcase(2094, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x204]'          );
  TestCase.testcase(2095, [$62,$91,$16,$07,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28'                      );
  TestCase.testcase(2096, [$62,$91,$16,$17,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm29,xmm28,{sae}'                );
  TestCase.testcase(2097, [$62,$F1,$16,$07,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm29,dword [rcx]'                );
  TestCase.testcase(2098, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$0F   ] , 'vcmuess  k5{k7},xmm29,dword [rax+r14*8+0x123]'    );
  TestCase.testcase(2099, [$62,$F1,$16,$07,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x1fc]'          );
  TestCase.testcase(2100, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx+0x200]'          );
  TestCase.testcase(2101, [$62,$F1,$16,$07,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x200]'          );
  TestCase.testcase(2102, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm29,dword [rdx-0x204]'          );
  TestCase.testcase(2103, [$62,$91,$16,$07,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2104, [$62,$91,$16,$17,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2105, [$62,$F1,$16,$07,$C2,$29,$10                       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2106, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$10   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2107, [$62,$F1,$16,$07,$C2,$6A,$7F,$10                   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2108, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$10       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2109, [$62,$F1,$16,$07,$C2,$6A,$80,$10                   ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2110, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$10       ] , 'vcmpeq_osss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2111, [$62,$91,$16,$07,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2112, [$62,$91,$16,$17,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2113, [$62,$F1,$16,$07,$C2,$29,$11                       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2114, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$11   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2115, [$62,$F1,$16,$07,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2116, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$11       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2117, [$62,$F1,$16,$07,$C2,$6A,$80,$11                   ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2118, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$11       ] , 'vcmplt_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2119, [$62,$91,$16,$07,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2120, [$62,$91,$16,$17,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2121, [$62,$F1,$16,$07,$C2,$29,$12                       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2122, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$12   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2123, [$62,$F1,$16,$07,$C2,$6A,$7F,$12                   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2124, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$12       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2125, [$62,$F1,$16,$07,$C2,$6A,$80,$12                   ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2126, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$12       ] , 'vcmple_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2127, [$62,$91,$16,$07,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,xmm28'                );
  TestCase.testcase(2128, [$62,$91,$16,$17,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,xmm28,{sae}'          );
  TestCase.testcase(2129, [$62,$F1,$16,$07,$C2,$29,$13                       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rcx]'          );
  TestCase.testcase(2130, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$13   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2131, [$62,$F1,$16,$07,$C2,$6A,$7F,$13                   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx+0x1fc]'    );
  TestCase.testcase(2132, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$13       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx+0x200]'    );
  TestCase.testcase(2133, [$62,$F1,$16,$07,$C2,$6A,$80,$13                   ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx-0x200]'    );
  TestCase.testcase(2134, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$13       ] , 'vcmpunord_sss  k5{k7},xmm29,dword [rdx-0x204]'    );
  TestCase.testcase(2135, [$62,$91,$16,$07,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2136, [$62,$91,$16,$17,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2137, [$62,$F1,$16,$07,$C2,$29,$14                       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2138, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$14   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2139, [$62,$F1,$16,$07,$C2,$6A,$7F,$14                   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2140, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$14       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2141, [$62,$F1,$16,$07,$C2,$6A,$80,$14                   ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2142, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$14       ] , 'vcmpneq_usss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2143, [$62,$91,$16,$07,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2144, [$62,$91,$16,$17,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2145, [$62,$F1,$16,$07,$C2,$29,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2146, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$15   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2147, [$62,$F1,$16,$07,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2148, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2149, [$62,$F1,$16,$07,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2150, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2151, [$62,$91,$16,$07,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2152, [$62,$91,$16,$17,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2153, [$62,$F1,$16,$07,$C2,$29,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2154, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$16   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2155, [$62,$F1,$16,$07,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2156, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$16       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2157, [$62,$F1,$16,$07,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2158, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$16       ] , 'vcmpnle_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2159, [$62,$91,$16,$07,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2160, [$62,$91,$16,$17,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2161, [$62,$F1,$16,$07,$C2,$29,$17                       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2162, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$17   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2163, [$62,$F1,$16,$07,$C2,$6A,$7F,$17                   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2164, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$17       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2165, [$62,$F1,$16,$07,$C2,$6A,$80,$17                   ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2166, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$17       ] , 'vcmpord_sss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2167, [$62,$91,$16,$07,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2168, [$62,$91,$16,$17,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2169, [$62,$F1,$16,$07,$C2,$29,$18                       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2170, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$18   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2171, [$62,$F1,$16,$07,$C2,$6A,$7F,$18                   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2172, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$18       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2173, [$62,$F1,$16,$07,$C2,$6A,$80,$18                   ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2174, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$18       ] , 'vcmpeq_usss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2175, [$62,$91,$16,$07,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2176, [$62,$91,$16,$17,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2177, [$62,$F1,$16,$07,$C2,$29,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2178, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$19   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2179, [$62,$F1,$16,$07,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2180, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$19       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2181, [$62,$F1,$16,$07,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2182, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$19       ] , 'vcmpnge_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2183, [$62,$91,$16,$07,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2184, [$62,$91,$16,$17,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2185, [$62,$F1,$16,$07,$C2,$29,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2186, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1A   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2187, [$62,$F1,$16,$07,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2188, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2189, [$62,$F1,$16,$07,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2190, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2191, [$62,$91,$16,$07,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,xmm28'               );
  TestCase.testcase(2192, [$62,$91,$16,$17,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,xmm28,{sae}'         );
  TestCase.testcase(2193, [$62,$F1,$16,$07,$C2,$29,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2194, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1B   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2195, [$62,$F1,$16,$07,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2196, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2197, [$62,$F1,$16,$07,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2198, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2199, [$62,$91,$16,$07,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,xmm28'                 );
  TestCase.testcase(2200, [$62,$91,$16,$17,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2201, [$62,$F1,$16,$07,$C2,$29,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2202, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1C   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2203, [$62,$F1,$16,$07,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2204, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$1C       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2205, [$62,$F1,$16,$07,$C2,$6A,$80,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2206, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$1C       ] , 'vcmpneq_osss  k5{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2207, [$62,$91,$16,$07,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2208, [$62,$91,$16,$17,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2209, [$62,$F1,$16,$07,$C2,$29,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2210, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1D   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2211, [$62,$F1,$16,$07,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2212, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$1D       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2213, [$62,$F1,$16,$07,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2214, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$1D       ] , 'vcmpge_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2215, [$62,$91,$16,$07,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,xmm28'                  );
  TestCase.testcase(2216, [$62,$91,$16,$17,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,xmm28,{sae}'            );
  TestCase.testcase(2217, [$62,$F1,$16,$07,$C2,$29,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(2218, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1E   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2219, [$62,$F1,$16,$07,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(2220, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(2221, [$62,$F1,$16,$07,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(2222, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(2223, [$62,$91,$16,$07,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,xmm28'                   );
  TestCase.testcase(2224, [$62,$91,$16,$17,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,xmm28,{sae}'             );
  TestCase.testcase(2225, [$62,$F1,$16,$07,$C2,$29,$1F                       ] , 'vcmue_usss  k5{k7},xmm29,dword [rcx]'             );
  TestCase.testcase(2226, [$62,$B1,$16,$07,$C2,$AC,$F0,$23,$01,$00,$00,$1F   ] , 'vcmue_usss  k5{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2227, [$62,$F1,$16,$07,$C2,$6A,$7F,$1F                   ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx+0x1fc]'       );
  TestCase.testcase(2228, [$62,$F1,$16,$07,$C2,$AA,$00,$02,$00,$00,$1F       ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx+0x200]'       );
  TestCase.testcase(2229, [$62,$F1,$16,$07,$C2,$6A,$80,$1F                   ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx-0x200]'       );
  TestCase.testcase(2230, [$62,$F1,$16,$07,$C2,$AA,$FC,$FD,$FF,$FF,$1F       ] , 'vcmue_usss  k5{k7},xmm29,dword [rdx-0x204]'       );
  TestCase.testcase(2231, [$62,$01,$FD,$08,$2F,$F5                           ] , 'vcomisd  xmm30,xmm29'                             );
  TestCase.testcase(2232, [$62,$01,$FD,$18,$2F,$F5                           ] , 'vcomisd  xmm30,xmm29,{sae}'                       );
  TestCase.testcase(2233, [$62,$61,$FD,$08,$2F,$31                           ] , 'vcomisd  xmm30,qword [rcx]'                       );
  TestCase.testcase(2234, [$62,$21,$FD,$08,$2F,$B4,$F0,$23,$01,$00,$00       ] , 'vcomisd  xmm30,qword [rax+r14*8+0x123]'           );
  TestCase.testcase(2235, [$62,$61,$FD,$08,$2F,$72,$7F                       ] , 'vcomisd  xmm30,qword [rdx+0x3f8]'                 );
  TestCase.testcase(2236, [$62,$61,$FD,$08,$2F,$B2,$00,$04,$00,$00           ] , 'vcomisd  xmm30,qword [rdx+0x400]'                 );
  TestCase.testcase(2237, [$62,$61,$FD,$08,$2F,$72,$80                       ] , 'vcomisd  xmm30,qword [rdx-0x400]'                 );
  TestCase.testcase(2238, [$62,$61,$FD,$08,$2F,$B2,$F8,$FB,$FF,$FF           ] , 'vcomisd  xmm30,qword [rdx-0x408]'                 );
  TestCase.testcase(2239, [$62,$01,$7C,$08,$2F,$F5                           ] , 'vcomiss  xmm30,xmm29'                             );
  TestCase.testcase(2240, [$62,$01,$7C,$18,$2F,$F5                           ] , 'vcomiss  xmm30,xmm29,{sae}'                       );
  TestCase.testcase(2241, [$62,$61,$7C,$08,$2F,$31                           ] , 'vcomiss  xmm30,dword [rcx]'                       );
  TestCase.testcase(2242, [$62,$21,$7C,$08,$2F,$B4,$F0,$23,$01,$00,$00       ] , 'vcomiss  xmm30,dword [rax+r14*8+0x123]'           );
  TestCase.testcase(2243, [$62,$61,$7C,$08,$2F,$72,$7F                       ] , 'vcomiss  xmm30,dword [rdx+0x1fc]'                 );
  TestCase.testcase(2244, [$62,$61,$7C,$08,$2F,$B2,$00,$02,$00,$00           ] , 'vcomiss  xmm30,dword [rdx+0x200]'                 );
  TestCase.testcase(2245, [$62,$61,$7C,$08,$2F,$72,$80                       ] , 'vcomiss  xmm30,dword [rdx-0x200]'                 );
  TestCase.testcase(2246, [$62,$61,$7C,$08,$2F,$B2,$FC,$FD,$FF,$FF           ] , 'vcomiss  xmm30,dword [rdx-0x204]'                 );
  TestCase.testcase(2247, [$62,$62,$FD,$48,$8A,$31                           ] , 'vcompresspd  zword [rcx],zmm30'                   );
  TestCase.testcase(2248, [$62,$62,$FD,$4F,$8A,$31                           ] , 'vcompresspd  zword [rcx]{k7},zmm30'               );
  TestCase.testcase(2249, [$62,$22,$FD,$48,$8A,$B4,$F0,$23,$01,$00,$00       ] , 'vcompresspd  zword [rax+r14*8+0x123],zmm30'       );
  TestCase.testcase(2250, [$62,$62,$FD,$48,$8A,$72,$7F                       ] , 'vcompresspd  zword [rdx+0x3f8],zmm30'             );
  TestCase.testcase(2251, [$62,$62,$FD,$48,$8A,$B2,$00,$04,$00,$00           ] , 'vcompresspd  zword [rdx+0x400],zmm30'             );
  TestCase.testcase(2252, [$62,$62,$FD,$48,$8A,$72,$80                       ] , 'vcompresspd  zword [rdx-0x400],zmm30'             );
  TestCase.testcase(2253, [$62,$62,$FD,$48,$8A,$B2,$F8,$FB,$FF,$FF           ] , 'vcompresspd  zword [rdx-0x408],zmm30'             );
  TestCase.testcase(2254, [$62,$02,$FD,$48,$8A,$EE                           ] , 'vcompresspd  zmm30,zmm29'                         );
  TestCase.testcase(2255, [$62,$02,$FD,$4F,$8A,$EE                           ] , 'vcompresspd  zmm30{k7},zmm29'                     );
  TestCase.testcase(2256, [$62,$02,$FD,$CF,$8A,$EE                           ] , 'vcompresspd  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(2257, [$62,$62,$7D,$48,$8A,$31                           ] , 'vcompressps  zword [rcx],zmm30'                   );
  TestCase.testcase(2258, [$62,$62,$7D,$4F,$8A,$31                           ] , 'vcompressps  zword [rcx]{k7},zmm30'               );
  TestCase.testcase(2259, [$62,$22,$7D,$48,$8A,$B4,$F0,$23,$01,$00,$00       ] , 'vcompressps  zword [rax+r14*8+0x123],zmm30'       );
  TestCase.testcase(2260, [$62,$62,$7D,$48,$8A,$72,$7F                       ] , 'vcompressps  zword [rdx+0x1fc],zmm30'             );
  TestCase.testcase(2261, [$62,$62,$7D,$48,$8A,$B2,$00,$02,$00,$00           ] , 'vcompressps  zword [rdx+0x200],zmm30'             );
  TestCase.testcase(2262, [$62,$62,$7D,$48,$8A,$72,$80                       ] , 'vcompressps  zword [rdx-0x200],zmm30'             );
  TestCase.testcase(2263, [$62,$62,$7D,$48,$8A,$B2,$FC,$FD,$FF,$FF           ] , 'vcompressps  zword [rdx-0x204],zmm30'             );
  TestCase.testcase(2264, [$62,$02,$7D,$48,$8A,$EE                           ] , 'vcompressps  zmm30,zmm29'                         );
  TestCase.testcase(2265, [$62,$02,$7D,$4F,$8A,$EE                           ] , 'vcompressps  zmm30{k7},zmm29'                     );
  TestCase.testcase(2266, [$62,$02,$7D,$CF,$8A,$EE                           ] , 'vcompressps  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(2267, [$62,$01,$7E,$4F,$E6,$F5                           ] , 'vcvtdq2pd  zmm30{k7},ymm29'                       );
  TestCase.testcase(2268, [$62,$01,$7E,$CF,$E6,$F5                           ] , 'vcvtdq2pd  zmm30{k7}{z},ymm29'                    );
  TestCase.testcase(2269, [$62,$61,$7E,$4F,$E6,$31                           ] , 'vcvtdq2pd  zmm30{k7},yword [rcx]'                 );
  TestCase.testcase(2270, [$62,$21,$7E,$4F,$E6,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtdq2pd  zmm30{k7},yword [rax+r14*8+0x123]'     );
  TestCase.testcase(2271, [$62,$61,$7E,$5F,$E6,$31                           ] , 'vcvtdq2pd  zmm30{k7},dword [rcx]{1to8}'           );
  TestCase.testcase(2272, [$62,$61,$7E,$4F,$E6,$72,$7F                       ] , 'vcvtdq2pd  zmm30{k7},yword [rdx+0xfe0]'           );
  TestCase.testcase(2273, [$62,$61,$7E,$4F,$E6,$B2,$00,$10,$00,$00           ] , 'vcvtdq2pd  zmm30{k7},yword [rdx+0x1000]'          );
  TestCase.testcase(2274, [$62,$61,$7E,$4F,$E6,$72,$80                       ] , 'vcvtdq2pd  zmm30{k7},yword [rdx-0x1000]'          );
  TestCase.testcase(2275, [$62,$61,$7E,$4F,$E6,$B2,$E0,$EF,$FF,$FF           ] , 'vcvtdq2pd  zmm30{k7},yword [rdx-0x1020]'          );
  TestCase.testcase(2276, [$62,$61,$7E,$5F,$E6,$72,$7F                       ] , 'vcvtdq2pd  zmm30{k7},dword [rdx+0x1fc]{1to8}'     );
  TestCase.testcase(2277, [$62,$61,$7E,$5F,$E6,$B2,$00,$02,$00,$00           ] , 'vcvtdq2pd  zmm30{k7},dword [rdx+0x200]{1to8}'     );
  TestCase.testcase(2278, [$62,$61,$7E,$5F,$E6,$72,$80                       ] , 'vcvtdq2pd  zmm30{k7},dword [rdx-0x200]{1to8}'     );
  TestCase.testcase(2279, [$62,$61,$7E,$5F,$E6,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtdq2pd  zmm30{k7},dword [rdx-0x204]{1to8}'     );
  TestCase.testcase(2280, [$62,$01,$7C,$48,$5B,$F5                           ] , 'vcvtdq2ps  zmm30,zmm29'                           );
  TestCase.testcase(2281, [$62,$01,$7C,$4F,$5B,$F5                           ] , 'vcvtdq2ps  zmm30{k7},zmm29'                       );
  TestCase.testcase(2282, [$62,$01,$7C,$CF,$5B,$F5                           ] , 'vcvtdq2ps  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(2283, [$62,$01,$7C,$18,$5B,$F5                           ] , 'vcvtdq2ps  zmm30,zmm29,{rn-sae}'                  );
  TestCase.testcase(2284, [$62,$01,$7C,$58,$5B,$F5                           ] , 'vcvtdq2ps  zmm30,zmm29,{ru-sae}'                  );
  TestCase.testcase(2285, [$62,$01,$7C,$38,$5B,$F5                           ] , 'vcvtdq2ps  zmm30,zmm29,{rd-sae}'                  );
  TestCase.testcase(2286, [$62,$01,$7C,$78,$5B,$F5                           ] , 'vcvtdq2ps  zmm30,zmm29,{rz-sae}'                  );
  TestCase.testcase(2287, [$62,$61,$7C,$48,$5B,$31                           ] , 'vcvtdq2ps  zmm30,zword [rcx]'                     );
  TestCase.testcase(2288, [$62,$21,$7C,$48,$5B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtdq2ps  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(2289, [$62,$61,$7C,$58,$5B,$31                           ] , 'vcvtdq2ps  zmm30,dword [rcx]{1to16}'              );
  TestCase.testcase(2290, [$62,$61,$7C,$48,$5B,$72,$7F                       ] , 'vcvtdq2ps  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(2291, [$62,$61,$7C,$48,$5B,$B2,$00,$20,$00,$00           ] , 'vcvtdq2ps  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(2292, [$62,$61,$7C,$48,$5B,$72,$80                       ] , 'vcvtdq2ps  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(2293, [$62,$61,$7C,$48,$5B,$B2,$C0,$DF,$FF,$FF           ] , 'vcvtdq2ps  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(2294, [$62,$61,$7C,$58,$5B,$72,$7F                       ] , 'vcvtdq2ps  zmm30,dword [rdx+0x1fc]{1to16}'        );
  TestCase.testcase(2295, [$62,$61,$7C,$58,$5B,$B2,$00,$02,$00,$00           ] , 'vcvtdq2ps  zmm30,dword [rdx+0x200]{1to16}'        );
  TestCase.testcase(2296, [$62,$61,$7C,$58,$5B,$72,$80                       ] , 'vcvtdq2ps  zmm30,dword [rdx-0x200]{1to16}'        );
  TestCase.testcase(2297, [$62,$61,$7C,$58,$5B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtdq2ps  zmm30,dword [rdx-0x204]{1to16}'        );
  TestCase.testcase(2298, [$62,$01,$FF,$4F,$E6,$F5                           ] , 'vcvtpd2dq  ymm30{k7},zmm29'                       );
  TestCase.testcase(2299, [$62,$01,$FF,$CF,$E6,$F5                           ] , 'vcvtpd2dq  ymm30{k7}{z},zmm29'                    );
  TestCase.testcase(2300, [$62,$01,$FF,$1F,$E6,$F5                           ] , 'vcvtpd2dq  ymm30{k7},zmm29,{rn-sae}'              );
  TestCase.testcase(2301, [$62,$01,$FF,$5F,$E6,$F5                           ] , 'vcvtpd2dq  ymm30{k7},zmm29,{ru-sae}'              );
  TestCase.testcase(2302, [$62,$01,$FF,$3F,$E6,$F5                           ] , 'vcvtpd2dq  ymm30{k7},zmm29,{rd-sae}'              );
  TestCase.testcase(2303, [$62,$01,$FF,$7F,$E6,$F5                           ] , 'vcvtpd2dq  ymm30{k7},zmm29,{rz-sae}'              );
  TestCase.testcase(2304, [$62,$61,$FF,$4F,$E6,$31                           ] , 'vcvtpd2dq  ymm30{k7},zword [rcx]'                 );
  TestCase.testcase(2305, [$62,$21,$FF,$4F,$E6,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtpd2dq  ymm30{k7},zword [rax+r14*8+0x123]'     );
  TestCase.testcase(2306, [$62,$61,$FF,$5F,$E6,$31                           ] , 'vcvtpd2dq  ymm30{k7},qword [rcx]{1to8}'           );
  TestCase.testcase(2307, [$62,$61,$FF,$4F,$E6,$72,$7F                       ] , 'vcvtpd2dq  ymm30{k7},zword [rdx+0x1fc0]'          );
  TestCase.testcase(2308, [$62,$61,$FF,$4F,$E6,$B2,$00,$20,$00,$00           ] , 'vcvtpd2dq  ymm30{k7},zword [rdx+0x2000]'          );
  TestCase.testcase(2309, [$62,$61,$FF,$4F,$E6,$72,$80                       ] , 'vcvtpd2dq  ymm30{k7},zword [rdx-0x2000]'          );
  TestCase.testcase(2310, [$62,$61,$FF,$4F,$E6,$B2,$C0,$DF,$FF,$FF           ] , 'vcvtpd2dq  ymm30{k7},zword [rdx-0x2040]'          );
  TestCase.testcase(2311, [$62,$61,$FF,$5F,$E6,$72,$7F                       ] , 'vcvtpd2dq  ymm30{k7},qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(2312, [$62,$61,$FF,$5F,$E6,$B2,$00,$04,$00,$00           ] , 'vcvtpd2dq  ymm30{k7},qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(2313, [$62,$61,$FF,$5F,$E6,$72,$80                       ] , 'vcvtpd2dq  ymm30{k7},qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(2314, [$62,$61,$FF,$5F,$E6,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtpd2dq  ymm30{k7},qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(2315, [$62,$01,$FD,$4F,$5A,$F5                           ] , 'vcvtpd2ps  ymm30{k7},zmm29'                       );
  TestCase.testcase(2316, [$62,$01,$FD,$CF,$5A,$F5                           ] , 'vcvtpd2ps  ymm30{k7}{z},zmm29'                    );
  TestCase.testcase(2317, [$62,$01,$FD,$1F,$5A,$F5                           ] , 'vcvtpd2ps  ymm30{k7},zmm29,{rn-sae}'              );
  TestCase.testcase(2318, [$62,$01,$FD,$5F,$5A,$F5                           ] , 'vcvtpd2ps  ymm30{k7},zmm29,{ru-sae}'              );
  TestCase.testcase(2319, [$62,$01,$FD,$3F,$5A,$F5                           ] , 'vcvtpd2ps  ymm30{k7},zmm29,{rd-sae}'              );
  TestCase.testcase(2320, [$62,$01,$FD,$7F,$5A,$F5                           ] , 'vcvtpd2ps  ymm30{k7},zmm29,{rz-sae}'              );
  TestCase.testcase(2321, [$62,$61,$FD,$4F,$5A,$31                           ] , 'vcvtpd2ps  ymm30{k7},zword [rcx]'                 );
  TestCase.testcase(2322, [$62,$21,$FD,$4F,$5A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtpd2ps  ymm30{k7},zword [rax+r14*8+0x123]'     );
  TestCase.testcase(2323, [$62,$61,$FD,$5F,$5A,$31                           ] , 'vcvtpd2ps  ymm30{k7},qword [rcx]{1to8}'           );
  TestCase.testcase(2324, [$62,$61,$FD,$4F,$5A,$72,$7F                       ] , 'vcvtpd2ps  ymm30{k7},zword [rdx+0x1fc0]'          );
  TestCase.testcase(2325, [$62,$61,$FD,$4F,$5A,$B2,$00,$20,$00,$00           ] , 'vcvtpd2ps  ymm30{k7},zword [rdx+0x2000]'          );
  TestCase.testcase(2326, [$62,$61,$FD,$4F,$5A,$72,$80                       ] , 'vcvtpd2ps  ymm30{k7},zword [rdx-0x2000]'          );
  TestCase.testcase(2327, [$62,$61,$FD,$4F,$5A,$B2,$C0,$DF,$FF,$FF           ] , 'vcvtpd2ps  ymm30{k7},zword [rdx-0x2040]'          );
  TestCase.testcase(2328, [$62,$61,$FD,$5F,$5A,$72,$7F                       ] , 'vcvtpd2ps  ymm30{k7},qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(2329, [$62,$61,$FD,$5F,$5A,$B2,$00,$04,$00,$00           ] , 'vcvtpd2ps  ymm30{k7},qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(2330, [$62,$61,$FD,$5F,$5A,$72,$80                       ] , 'vcvtpd2ps  ymm30{k7},qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(2331, [$62,$61,$FD,$5F,$5A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtpd2ps  ymm30{k7},qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(2332, [$62,$01,$FC,$4F,$79,$F5                           ] , 'vcvtpd2udq  ymm30{k7},zmm29'                      );
  TestCase.testcase(2333, [$62,$01,$FC,$CF,$79,$F5                           ] , 'vcvtpd2udq  ymm30{k7}{z},zmm29'                   );
  TestCase.testcase(2334, [$62,$01,$FC,$1F,$79,$F5                           ] , 'vcvtpd2udq  ymm30{k7},zmm29,{rn-sae}'             );
  TestCase.testcase(2335, [$62,$01,$FC,$5F,$79,$F5                           ] , 'vcvtpd2udq  ymm30{k7},zmm29,{ru-sae}'             );
  TestCase.testcase(2336, [$62,$01,$FC,$3F,$79,$F5                           ] , 'vcvtpd2udq  ymm30{k7},zmm29,{rd-sae}'             );
  TestCase.testcase(2337, [$62,$01,$FC,$7F,$79,$F5                           ] , 'vcvtpd2udq  ymm30{k7},zmm29,{rz-sae}'             );
  TestCase.testcase(2338, [$62,$61,$FC,$4F,$79,$31                           ] , 'vcvtpd2udq  ymm30{k7},zword [rcx]'                );
  TestCase.testcase(2339, [$62,$21,$FC,$4F,$79,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtpd2udq  ymm30{k7},zword [rax+r14*8+0x123]'    );
  TestCase.testcase(2340, [$62,$61,$FC,$5F,$79,$31                           ] , 'vcvtpd2udq  ymm30{k7},qword [rcx]{1to8}'          );
  TestCase.testcase(2341, [$62,$61,$FC,$4F,$79,$72,$7F                       ] , 'vcvtpd2udq  ymm30{k7},zword [rdx+0x1fc0]'         );
  TestCase.testcase(2342, [$62,$61,$FC,$4F,$79,$B2,$00,$20,$00,$00           ] , 'vcvtpd2udq  ymm30{k7},zword [rdx+0x2000]'         );
  TestCase.testcase(2343, [$62,$61,$FC,$4F,$79,$72,$80                       ] , 'vcvtpd2udq  ymm30{k7},zword [rdx-0x2000]'         );
  TestCase.testcase(2344, [$62,$61,$FC,$4F,$79,$B2,$C0,$DF,$FF,$FF           ] , 'vcvtpd2udq  ymm30{k7},zword [rdx-0x2040]'         );
  TestCase.testcase(2345, [$62,$61,$FC,$5F,$79,$72,$7F                       ] , 'vcvtpd2udq  ymm30{k7},qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(2346, [$62,$61,$FC,$5F,$79,$B2,$00,$04,$00,$00           ] , 'vcvtpd2udq  ymm30{k7},qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(2347, [$62,$61,$FC,$5F,$79,$72,$80                       ] , 'vcvtpd2udq  ymm30{k7},qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(2348, [$62,$61,$FC,$5F,$79,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtpd2udq  ymm30{k7},qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(2349, [$62,$02,$7D,$4F,$13,$F5                           ] , 'vcvtph2ps  zmm30{k7},ymm29'                       );
  TestCase.testcase(2350, [$62,$02,$7D,$CF,$13,$F5                           ] , 'vcvtph2ps  zmm30{k7}{z},ymm29'                    );
  TestCase.testcase(2351, [$62,$02,$7D,$1F,$13,$F5                           ] , 'vcvtph2ps  zmm30{k7},ymm29,{sae}'                 );
  TestCase.testcase(2352, [$62,$62,$7D,$4F,$13,$31                           ] , 'vcvtph2ps  zmm30{k7},yword [rcx]'                 );
  TestCase.testcase(2353, [$62,$22,$7D,$4F,$13,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtph2ps  zmm30{k7},yword [rax+r14*8+0x123]'     );
  TestCase.testcase(2354, [$62,$62,$7D,$4F,$13,$72,$7F                       ] , 'vcvtph2ps  zmm30{k7},yword [rdx+0xfe0]'           );
  TestCase.testcase(2355, [$62,$62,$7D,$4F,$13,$B2,$00,$10,$00,$00           ] , 'vcvtph2ps  zmm30{k7},yword [rdx+0x1000]'          );
  TestCase.testcase(2356, [$62,$62,$7D,$4F,$13,$72,$80                       ] , 'vcvtph2ps  zmm30{k7},yword [rdx-0x1000]'          );
  TestCase.testcase(2357, [$62,$62,$7D,$4F,$13,$B2,$E0,$EF,$FF,$FF           ] , 'vcvtph2ps  zmm30{k7},yword [rdx-0x1020]'          );
  TestCase.testcase(2358, [$62,$01,$7D,$48,$5B,$F5                           ] , 'vcvtps2dq  zmm30,zmm29'                           );
  TestCase.testcase(2359, [$62,$01,$7D,$4F,$5B,$F5                           ] , 'vcvtps2dq  zmm30{k7},zmm29'                       );
  TestCase.testcase(2360, [$62,$01,$7D,$CF,$5B,$F5                           ] , 'vcvtps2dq  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(2361, [$62,$01,$7D,$18,$5B,$F5                           ] , 'vcvtps2dq  zmm30,zmm29,{rn-sae}'                  );
  TestCase.testcase(2362, [$62,$01,$7D,$58,$5B,$F5                           ] , 'vcvtps2dq  zmm30,zmm29,{ru-sae}'                  );
  TestCase.testcase(2363, [$62,$01,$7D,$38,$5B,$F5                           ] , 'vcvtps2dq  zmm30,zmm29,{rd-sae}'                  );
  TestCase.testcase(2364, [$62,$01,$7D,$78,$5B,$F5                           ] , 'vcvtps2dq  zmm30,zmm29,{rz-sae}'                  );
  TestCase.testcase(2365, [$62,$61,$7D,$48,$5B,$31                           ] , 'vcvtps2dq  zmm30,zword [rcx]'                     );
  TestCase.testcase(2366, [$62,$21,$7D,$48,$5B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtps2dq  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(2367, [$62,$61,$7D,$58,$5B,$31                           ] , 'vcvtps2dq  zmm30,dword [rcx]{1to16}'              );
  TestCase.testcase(2368, [$62,$61,$7D,$48,$5B,$72,$7F                       ] , 'vcvtps2dq  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(2369, [$62,$61,$7D,$48,$5B,$B2,$00,$20,$00,$00           ] , 'vcvtps2dq  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(2370, [$62,$61,$7D,$48,$5B,$72,$80                       ] , 'vcvtps2dq  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(2371, [$62,$61,$7D,$48,$5B,$B2,$C0,$DF,$FF,$FF           ] , 'vcvtps2dq  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(2372, [$62,$61,$7D,$58,$5B,$72,$7F                       ] , 'vcvtps2dq  zmm30,dword [rdx+0x1fc]{1to16}'        );
  TestCase.testcase(2373, [$62,$61,$7D,$58,$5B,$B2,$00,$02,$00,$00           ] , 'vcvtps2dq  zmm30,dword [rdx+0x200]{1to16}'        );
  TestCase.testcase(2374, [$62,$61,$7D,$58,$5B,$72,$80                       ] , 'vcvtps2dq  zmm30,dword [rdx-0x200]{1to16}'        );
  TestCase.testcase(2375, [$62,$61,$7D,$58,$5B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtps2dq  zmm30,dword [rdx-0x204]{1to16}'        );
  TestCase.testcase(2376, [$62,$01,$7C,$4F,$5A,$F5                           ] , 'vcvtps2pd  zmm30{k7},ymm29'                       );
  TestCase.testcase(2377, [$62,$01,$7C,$CF,$5A,$F5                           ] , 'vcvtps2pd  zmm30{k7}{z},ymm29'                    );
  TestCase.testcase(2378, [$62,$01,$7C,$1F,$5A,$F5                           ] , 'vcvtps2pd  zmm30{k7},ymm29,{sae}'                 );
  TestCase.testcase(2379, [$62,$61,$7C,$4F,$5A,$31                           ] , 'vcvtps2pd  zmm30{k7},yword [rcx]'                 );
  TestCase.testcase(2380, [$62,$21,$7C,$4F,$5A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtps2pd  zmm30{k7},yword [rax+r14*8+0x123]'     );
  TestCase.testcase(2381, [$62,$61,$7C,$5F,$5A,$31                           ] , 'vcvtps2pd  zmm30{k7},dword [rcx]{1to8}'           );
  TestCase.testcase(2382, [$62,$61,$7C,$4F,$5A,$72,$7F                       ] , 'vcvtps2pd  zmm30{k7},yword [rdx+0xfe0]'           );
  TestCase.testcase(2383, [$62,$61,$7C,$4F,$5A,$B2,$00,$10,$00,$00           ] , 'vcvtps2pd  zmm30{k7},yword [rdx+0x1000]'          );
  TestCase.testcase(2384, [$62,$61,$7C,$4F,$5A,$72,$80                       ] , 'vcvtps2pd  zmm30{k7},yword [rdx-0x1000]'          );
  TestCase.testcase(2385, [$62,$61,$7C,$4F,$5A,$B2,$E0,$EF,$FF,$FF           ] , 'vcvtps2pd  zmm30{k7},yword [rdx-0x1020]'          );
  TestCase.testcase(2386, [$62,$61,$7C,$5F,$5A,$72,$7F                       ] , 'vcvtps2pd  zmm30{k7},dword [rdx+0x1fc]{1to8}'     );
  TestCase.testcase(2387, [$62,$61,$7C,$5F,$5A,$B2,$00,$02,$00,$00           ] , 'vcvtps2pd  zmm30{k7},dword [rdx+0x200]{1to8}'     );
  TestCase.testcase(2388, [$62,$61,$7C,$5F,$5A,$72,$80                       ] , 'vcvtps2pd  zmm30{k7},dword [rdx-0x200]{1to8}'     );
  TestCase.testcase(2389, [$62,$61,$7C,$5F,$5A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtps2pd  zmm30{k7},dword [rdx-0x204]{1to8}'     );
  TestCase.testcase(2390, [$62,$03,$7D,$4F,$1D,$EE,$AB                       ] , 'vcvtps2ph  ymm30{k7},zmm29,0xab'                  );
  TestCase.testcase(2391, [$62,$03,$7D,$CF,$1D,$EE,$AB                       ] , 'vcvtps2ph  ymm30{k7}{z},zmm29,0xab'               );
  TestCase.testcase(2392, [$62,$03,$7D,$1F,$1D,$EE,$AB                       ] , 'vcvtps2ph  ymm30{k7},zmm29,{sae},0xab'            );
  TestCase.testcase(2393, [$62,$03,$7D,$4F,$1D,$EE,$7B                       ] , 'vcvtps2ph  ymm30{k7},zmm29,0x7b'                  );
  TestCase.testcase(2394, [$62,$03,$7D,$1F,$1D,$EE,$7B                       ] , 'vcvtps2ph  ymm30{k7},zmm29,{sae},0x7b'            );
  TestCase.testcase(2395, [$62,$01,$7C,$48,$79,$F5                           ] , 'vcvtps2udq  zmm30,zmm29'                          );
  TestCase.testcase(2396, [$62,$01,$7C,$4F,$79,$F5                           ] , 'vcvtps2udq  zmm30{k7},zmm29'                      );
  TestCase.testcase(2397, [$62,$01,$7C,$CF,$79,$F5                           ] , 'vcvtps2udq  zmm30{k7}{z},zmm29'                   );
  TestCase.testcase(2398, [$62,$01,$7C,$18,$79,$F5                           ] , 'vcvtps2udq  zmm30,zmm29,{rn-sae}'                 );
  TestCase.testcase(2399, [$62,$01,$7C,$58,$79,$F5                           ] , 'vcvtps2udq  zmm30,zmm29,{ru-sae}'                 );
  TestCase.testcase(2400, [$62,$01,$7C,$38,$79,$F5                           ] , 'vcvtps2udq  zmm30,zmm29,{rd-sae}'                 );
  TestCase.testcase(2401, [$62,$01,$7C,$78,$79,$F5                           ] , 'vcvtps2udq  zmm30,zmm29,{rz-sae}'                 );
  TestCase.testcase(2402, [$62,$61,$7C,$48,$79,$31                           ] , 'vcvtps2udq  zmm30,zword [rcx]'                    );
  TestCase.testcase(2403, [$62,$21,$7C,$48,$79,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtps2udq  zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(2404, [$62,$61,$7C,$58,$79,$31                           ] , 'vcvtps2udq  zmm30,dword [rcx]{1to16}'             );
  TestCase.testcase(2405, [$62,$61,$7C,$48,$79,$72,$7F                       ] , 'vcvtps2udq  zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(2406, [$62,$61,$7C,$48,$79,$B2,$00,$20,$00,$00           ] , 'vcvtps2udq  zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(2407, [$62,$61,$7C,$48,$79,$72,$80                       ] , 'vcvtps2udq  zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(2408, [$62,$61,$7C,$48,$79,$B2,$C0,$DF,$FF,$FF           ] , 'vcvtps2udq  zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(2409, [$62,$61,$7C,$58,$79,$72,$7F                       ] , 'vcvtps2udq  zmm30,dword [rdx+0x1fc]{1to16}'       );
  TestCase.testcase(2410, [$62,$61,$7C,$58,$79,$B2,$00,$02,$00,$00           ] , 'vcvtps2udq  zmm30,dword [rdx+0x200]{1to16}'       );
  TestCase.testcase(2411, [$62,$61,$7C,$58,$79,$72,$80                       ] , 'vcvtps2udq  zmm30,dword [rdx-0x200]{1to16}'       );
  TestCase.testcase(2412, [$62,$61,$7C,$58,$79,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtps2udq  zmm30,dword [rdx-0x204]{1to16}'       );
  TestCase.testcase(2413, [$62,$91,$7F,$18,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rn-sae}'                    );
  TestCase.testcase(2414, [$62,$91,$7F,$58,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{ru-sae}'                    );
  TestCase.testcase(2415, [$62,$91,$7F,$38,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rd-sae}'                    );
  TestCase.testcase(2416, [$62,$91,$7F,$78,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm30,{rz-sae}'                    );
  TestCase.testcase(2417, [$62,$91,$7F,$18,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rn-sae}'                    );
  TestCase.testcase(2418, [$62,$91,$7F,$58,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{ru-sae}'                    );
  TestCase.testcase(2419, [$62,$91,$7F,$38,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rd-sae}'                    );
  TestCase.testcase(2420, [$62,$91,$7F,$78,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm30,{rz-sae}'                    );
  TestCase.testcase(2421, [$62,$11,$7F,$18,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rn-sae}'                   );
  TestCase.testcase(2422, [$62,$11,$7F,$58,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{ru-sae}'                   );
  TestCase.testcase(2423, [$62,$11,$7F,$38,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rd-sae}'                   );
  TestCase.testcase(2424, [$62,$11,$7F,$78,$2D,$EE                           ] , 'vcvtsd2si  r13d,xmm30,{rz-sae}'                   );
  TestCase.testcase(2425, [$62,$91,$FF,$18,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rn-sae}'                    );
  TestCase.testcase(2426, [$62,$91,$FF,$58,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{ru-sae}'                    );
  TestCase.testcase(2427, [$62,$91,$FF,$38,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rd-sae}'                    );
  TestCase.testcase(2428, [$62,$91,$FF,$78,$2D,$C6                           ] , 'vcvtsd2si  rax,xmm30,{rz-sae}'                    );
  TestCase.testcase(2429, [$62,$11,$FF,$18,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rn-sae}'                     );
  TestCase.testcase(2430, [$62,$11,$FF,$58,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{ru-sae}'                     );
  TestCase.testcase(2431, [$62,$11,$FF,$38,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rd-sae}'                     );
  TestCase.testcase(2432, [$62,$11,$FF,$78,$2D,$C6                           ] , 'vcvtsd2si  r8,xmm30,{rz-sae}'                     );
  TestCase.testcase(2433, [$62,$01,$97,$07,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(2434, [$62,$01,$97,$87,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(2435, [$62,$01,$97,$17,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(2436, [$62,$01,$97,$57,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(2437, [$62,$01,$97,$37,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(2438, [$62,$01,$97,$77,$5A,$F4                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(2439, [$62,$61,$97,$07,$5A,$31                           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(2440, [$62,$21,$97,$07,$5A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(2441, [$62,$61,$97,$07,$5A,$72,$7F                       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(2442, [$62,$61,$97,$07,$5A,$B2,$00,$04,$00,$00           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(2443, [$62,$61,$97,$07,$5A,$72,$80                       ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(2444, [$62,$61,$97,$07,$5A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsd2ss  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(2445, [$62,$61,$17,$00,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,eax'                       );
  TestCase.testcase(2446, [$62,$61,$17,$00,$2A,$F5                           ] , 'vcvtsi2sd  xmm30,xmm29,ebp'                       );
  TestCase.testcase(2447, [$62,$41,$17,$00,$2A,$F5                           ] , 'vcvtsi2sd  xmm30,xmm29,r13d'                      );
  TestCase.testcase(2448, [$62,$61,$17,$00,$2A,$31                           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rcx]'               );
  TestCase.testcase(2449, [$62,$21,$17,$00,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(2450, [$62,$61,$17,$00,$2A,$72,$7F                       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2451, [$62,$61,$17,$00,$2A,$B2,$00,$02,$00,$00           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2452, [$62,$61,$17,$00,$2A,$72,$80                       ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2453, [$62,$61,$17,$00,$2A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtsi2sd  xmm30,xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2454, [$62,$61,$97,$00,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,rax'                       );
  TestCase.testcase(2455, [$62,$61,$97,$10,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rn-sae},rax'              );
  TestCase.testcase(2456, [$62,$61,$97,$50,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{ru-sae},rax'              );
  TestCase.testcase(2457, [$62,$61,$97,$30,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rd-sae},rax'              );
  TestCase.testcase(2458, [$62,$61,$97,$70,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rz-sae},rax'              );
  TestCase.testcase(2459, [$62,$41,$97,$00,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,r8'                        );
  TestCase.testcase(2460, [$62,$41,$97,$10,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rn-sae},r8'               );
  TestCase.testcase(2461, [$62,$41,$97,$50,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{ru-sae},r8'               );
  TestCase.testcase(2462, [$62,$41,$97,$30,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rd-sae},r8'               );
  TestCase.testcase(2463, [$62,$41,$97,$70,$2A,$F0                           ] , 'vcvtsi2sd  xmm30,xmm29,{rz-sae},r8'               );
  TestCase.testcase(2464, [$62,$61,$97,$00,$2A,$31                           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rcx]'               );
  TestCase.testcase(2465, [$62,$21,$97,$00,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(2466, [$62,$61,$97,$00,$2A,$72,$7F                       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(2467, [$62,$61,$97,$00,$2A,$B2,$00,$04,$00,$00           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(2468, [$62,$61,$97,$00,$2A,$72,$80                       ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(2469, [$62,$61,$97,$00,$2A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsi2sd  xmm30,xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(2470, [$62,$61,$16,$00,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,eax'                       );
  TestCase.testcase(2471, [$62,$61,$16,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},eax'              );
  TestCase.testcase(2472, [$62,$61,$16,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},eax'              );
  TestCase.testcase(2473, [$62,$61,$16,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},eax'              );
  TestCase.testcase(2474, [$62,$61,$16,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},eax'              );
  TestCase.testcase(2475, [$62,$61,$16,$00,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,ebp'                       );
  TestCase.testcase(2476, [$62,$61,$16,$10,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},ebp'              );
  TestCase.testcase(2477, [$62,$61,$16,$50,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},ebp'              );
  TestCase.testcase(2478, [$62,$61,$16,$30,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},ebp'              );
  TestCase.testcase(2479, [$62,$61,$16,$70,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},ebp'              );
  TestCase.testcase(2480, [$62,$41,$16,$00,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,r13d'                      );
  TestCase.testcase(2481, [$62,$41,$16,$10,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},r13d'             );
  TestCase.testcase(2482, [$62,$41,$16,$50,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},r13d'             );
  TestCase.testcase(2483, [$62,$41,$16,$30,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},r13d'             );
  TestCase.testcase(2484, [$62,$41,$16,$70,$2A,$F5                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},r13d'             );
  TestCase.testcase(2485, [$62,$61,$16,$00,$2A,$31                           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rcx]'               );
  TestCase.testcase(2486, [$62,$21,$16,$00,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rax+r14*8+0x123]'   );
  TestCase.testcase(2487, [$62,$61,$16,$00,$2A,$72,$7F                       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx+0x1fc]'         );
  TestCase.testcase(2488, [$62,$61,$16,$00,$2A,$B2,$00,$02,$00,$00           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx+0x200]'         );
  TestCase.testcase(2489, [$62,$61,$16,$00,$2A,$72,$80                       ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx-0x200]'         );
  TestCase.testcase(2490, [$62,$61,$16,$00,$2A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtsi2ss  xmm30,xmm29,dword [rdx-0x204]'         );
  TestCase.testcase(2491, [$62,$61,$96,$00,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,rax'                       );
  TestCase.testcase(2492, [$62,$61,$96,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},rax'              );
  TestCase.testcase(2493, [$62,$61,$96,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},rax'              );
  TestCase.testcase(2494, [$62,$61,$96,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},rax'              );
  TestCase.testcase(2495, [$62,$61,$96,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},rax'              );
  TestCase.testcase(2496, [$62,$41,$96,$00,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,r8'                        );
  TestCase.testcase(2497, [$62,$41,$96,$10,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rn-sae},r8'               );
  TestCase.testcase(2498, [$62,$41,$96,$50,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{ru-sae},r8'               );
  TestCase.testcase(2499, [$62,$41,$96,$30,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rd-sae},r8'               );
  TestCase.testcase(2500, [$62,$41,$96,$70,$2A,$F0                           ] , 'vcvtsi2ss  xmm30,xmm29,{rz-sae},r8'               );
  TestCase.testcase(2501, [$62,$61,$96,$00,$2A,$31                           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rcx]'               );
  TestCase.testcase(2502, [$62,$21,$96,$00,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rax+r14*8+0x123]'   );
  TestCase.testcase(2503, [$62,$61,$96,$00,$2A,$72,$7F                       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx+0x3f8]'         );
  TestCase.testcase(2504, [$62,$61,$96,$00,$2A,$B2,$00,$04,$00,$00           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx+0x400]'         );
  TestCase.testcase(2505, [$62,$61,$96,$00,$2A,$72,$80                       ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx-0x400]'         );
  TestCase.testcase(2506, [$62,$61,$96,$00,$2A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsi2ss  xmm30,xmm29,qword [rdx-0x408]'         );
  TestCase.testcase(2507, [$62,$01,$16,$07,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(2508, [$62,$01,$16,$87,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(2509, [$62,$01,$16,$17,$5A,$F4                           ] , 'vcvtss2sd  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(2510, [$62,$61,$16,$07,$5A,$31                           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(2511, [$62,$21,$16,$07,$5A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2512, [$62,$61,$16,$07,$5A,$72,$7F                       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(2513, [$62,$61,$16,$07,$5A,$B2,$00,$02,$00,$00           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(2514, [$62,$61,$16,$07,$5A,$72,$80                       ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(2515, [$62,$61,$16,$07,$5A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtss2sd  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(2516, [$62,$91,$7E,$18,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rn-sae}'                    );
  TestCase.testcase(2517, [$62,$91,$7E,$58,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{ru-sae}'                    );
  TestCase.testcase(2518, [$62,$91,$7E,$38,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rd-sae}'                    );
  TestCase.testcase(2519, [$62,$91,$7E,$78,$2D,$C6                           ] , 'vcvtss2si  eax,xmm30,{rz-sae}'                    );
  TestCase.testcase(2520, [$62,$91,$7E,$18,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rn-sae}'                    );
  TestCase.testcase(2521, [$62,$91,$7E,$58,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{ru-sae}'                    );
  TestCase.testcase(2522, [$62,$91,$7E,$38,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rd-sae}'                    );
  TestCase.testcase(2523, [$62,$91,$7E,$78,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm30,{rz-sae}'                    );
  TestCase.testcase(2524, [$62,$11,$7E,$18,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rn-sae}'                   );
  TestCase.testcase(2525, [$62,$11,$7E,$58,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{ru-sae}'                   );
  TestCase.testcase(2526, [$62,$11,$7E,$38,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rd-sae}'                   );
  TestCase.testcase(2527, [$62,$11,$7E,$78,$2D,$EE                           ] , 'vcvtss2si  r13d,xmm30,{rz-sae}'                   );
  TestCase.testcase(2528, [$62,$91,$FE,$18,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rn-sae}'                    );
  TestCase.testcase(2529, [$62,$91,$FE,$58,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{ru-sae}'                    );
  TestCase.testcase(2530, [$62,$91,$FE,$38,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rd-sae}'                    );
  TestCase.testcase(2531, [$62,$91,$FE,$78,$2D,$C6                           ] , 'vcvtss2si  rax,xmm30,{rz-sae}'                    );
  TestCase.testcase(2532, [$62,$11,$FE,$18,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rn-sae}'                     );
  TestCase.testcase(2533, [$62,$11,$FE,$58,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{ru-sae}'                     );
  TestCase.testcase(2534, [$62,$11,$FE,$38,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rd-sae}'                     );
  TestCase.testcase(2535, [$62,$11,$FE,$78,$2D,$C6                           ] , 'vcvtss2si  r8,xmm30,{rz-sae}'                     );
  TestCase.testcase(2536, [$62,$01,$FD,$4F,$E6,$F5                           ] , 'vcvttpd2dq  ymm30{k7},zmm29'                      );
  TestCase.testcase(2537, [$62,$01,$FD,$CF,$E6,$F5                           ] , 'vcvttpd2dq  ymm30{k7}{z},zmm29'                   );
  TestCase.testcase(2538, [$62,$01,$FD,$1F,$E6,$F5                           ] , 'vcvttpd2dq  ymm30{k7},zmm29,{sae}'                );
  TestCase.testcase(2539, [$62,$61,$FD,$4F,$E6,$31                           ] , 'vcvttpd2dq  ymm30{k7},zword [rcx]'                );
  TestCase.testcase(2540, [$62,$21,$FD,$4F,$E6,$B4,$F0,$23,$01,$00,$00       ] , 'vcvttpd2dq  ymm30{k7},zword [rax+r14*8+0x123]'    );
  TestCase.testcase(2541, [$62,$61,$FD,$5F,$E6,$31                           ] , 'vcvttpd2dq  ymm30{k7},qword [rcx]{1to8}'          );
  TestCase.testcase(2542, [$62,$61,$FD,$4F,$E6,$72,$7F                       ] , 'vcvttpd2dq  ymm30{k7},zword [rdx+0x1fc0]'         );
  TestCase.testcase(2543, [$62,$61,$FD,$4F,$E6,$B2,$00,$20,$00,$00           ] , 'vcvttpd2dq  ymm30{k7},zword [rdx+0x2000]'         );
  TestCase.testcase(2544, [$62,$61,$FD,$4F,$E6,$72,$80                       ] , 'vcvttpd2dq  ymm30{k7},zword [rdx-0x2000]'         );
  TestCase.testcase(2545, [$62,$61,$FD,$4F,$E6,$B2,$C0,$DF,$FF,$FF           ] , 'vcvttpd2dq  ymm30{k7},zword [rdx-0x2040]'         );
  TestCase.testcase(2546, [$62,$61,$FD,$5F,$E6,$72,$7F                       ] , 'vcvttpd2dq  ymm30{k7},qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(2547, [$62,$61,$FD,$5F,$E6,$B2,$00,$04,$00,$00           ] , 'vcvttpd2dq  ymm30{k7},qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(2548, [$62,$61,$FD,$5F,$E6,$72,$80                       ] , 'vcvttpd2dq  ymm30{k7},qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(2549, [$62,$61,$FD,$5F,$E6,$B2,$F8,$FB,$FF,$FF           ] , 'vcvttpd2dq  ymm30{k7},qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(2550, [$62,$01,$7E,$48,$5B,$F5                           ] , 'vcvttps2dq  zmm30,zmm29'                          );
  TestCase.testcase(2551, [$62,$01,$7E,$4F,$5B,$F5                           ] , 'vcvttps2dq  zmm30{k7},zmm29'                      );
  TestCase.testcase(2552, [$62,$01,$7E,$CF,$5B,$F5                           ] , 'vcvttps2dq  zmm30{k7}{z},zmm29'                   );
  TestCase.testcase(2553, [$62,$01,$7E,$18,$5B,$F5                           ] , 'vcvttps2dq  zmm30,zmm29,{sae}'                    );
  TestCase.testcase(2554, [$62,$61,$7E,$48,$5B,$31                           ] , 'vcvttps2dq  zmm30,zword [rcx]'                    );
  TestCase.testcase(2555, [$62,$21,$7E,$48,$5B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvttps2dq  zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(2556, [$62,$61,$7E,$58,$5B,$31                           ] , 'vcvttps2dq  zmm30,dword [rcx]{1to16}'             );
  TestCase.testcase(2557, [$62,$61,$7E,$48,$5B,$72,$7F                       ] , 'vcvttps2dq  zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(2558, [$62,$61,$7E,$48,$5B,$B2,$00,$20,$00,$00           ] , 'vcvttps2dq  zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(2559, [$62,$61,$7E,$48,$5B,$72,$80                       ] , 'vcvttps2dq  zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(2560, [$62,$61,$7E,$48,$5B,$B2,$C0,$DF,$FF,$FF           ] , 'vcvttps2dq  zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(2561, [$62,$61,$7E,$58,$5B,$72,$7F                       ] , 'vcvttps2dq  zmm30,dword [rdx+0x1fc]{1to16}'       );
  TestCase.testcase(2562, [$62,$61,$7E,$58,$5B,$B2,$00,$02,$00,$00           ] , 'vcvttps2dq  zmm30,dword [rdx+0x200]{1to16}'       );
  TestCase.testcase(2563, [$62,$61,$7E,$58,$5B,$72,$80                       ] , 'vcvttps2dq  zmm30,dword [rdx-0x200]{1to16}'       );
  TestCase.testcase(2564, [$62,$61,$7E,$58,$5B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvttps2dq  zmm30,dword [rdx-0x204]{1to16}'       );
  TestCase.testcase(2565, [$62,$91,$7F,$18,$2C,$C6                           ] , 'vcvttsd2si  eax,xmm30,{sae}'                      );
  TestCase.testcase(2566, [$62,$91,$7F,$18,$2C,$EE                           ] , 'vcvttsd2si  ebp,xmm30,{sae}'                      );
  TestCase.testcase(2567, [$62,$11,$7F,$18,$2C,$EE                           ] , 'vcvttsd2si  r13d,xmm30,{sae}'                     );
  TestCase.testcase(2568, [$62,$91,$FF,$18,$2C,$C6                           ] , 'vcvttsd2si  rax,xmm30,{sae}'                      );
  TestCase.testcase(2569, [$62,$11,$FF,$18,$2C,$C6                           ] , 'vcvttsd2si  r8,xmm30,{sae}'                       );
  TestCase.testcase(2570, [$62,$91,$7E,$18,$2C,$C6                           ] , 'vcvttss2si  eax,xmm30,{sae}'                      );
  TestCase.testcase(2571, [$62,$91,$7E,$18,$2C,$EE                           ] , 'vcvttss2si  ebp,xmm30,{sae}'                      );
  TestCase.testcase(2572, [$62,$11,$7E,$18,$2C,$EE                           ] , 'vcvttss2si  r13d,xmm30,{sae}'                     );
  TestCase.testcase(2573, [$62,$91,$FE,$18,$2C,$C6                           ] , 'vcvttss2si  rax,xmm30,{sae}'                      );
  TestCase.testcase(2574, [$62,$11,$FE,$18,$2C,$C6                           ] , 'vcvttss2si  r8,xmm30,{sae}'                       );
  TestCase.testcase(2575, [$62,$01,$7E,$4F,$7A,$F5                           ] , 'vcvtudq2pd  zmm30{k7},ymm29'                      );
  TestCase.testcase(2576, [$62,$01,$7E,$CF,$7A,$F5                           ] , 'vcvtudq2pd  zmm30{k7}{z},ymm29'                   );
  TestCase.testcase(2577, [$62,$61,$7E,$4F,$7A,$31                           ] , 'vcvtudq2pd  zmm30{k7},yword [rcx]'                );
  TestCase.testcase(2578, [$62,$21,$7E,$4F,$7A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtudq2pd  zmm30{k7},yword [rax+r14*8+0x123]'    );
  TestCase.testcase(2579, [$62,$61,$7E,$5F,$7A,$31                           ] , 'vcvtudq2pd  zmm30{k7},dword [rcx]{1to8}'          );
  TestCase.testcase(2580, [$62,$61,$7E,$4F,$7A,$72,$7F                       ] , 'vcvtudq2pd  zmm30{k7},yword [rdx+0xfe0]'          );
  TestCase.testcase(2581, [$62,$61,$7E,$4F,$7A,$B2,$00,$10,$00,$00           ] , 'vcvtudq2pd  zmm30{k7},yword [rdx+0x1000]'         );
  TestCase.testcase(2582, [$62,$61,$7E,$4F,$7A,$72,$80                       ] , 'vcvtudq2pd  zmm30{k7},yword [rdx-0x1000]'         );
  TestCase.testcase(2583, [$62,$61,$7E,$4F,$7A,$B2,$E0,$EF,$FF,$FF           ] , 'vcvtudq2pd  zmm30{k7},yword [rdx-0x1020]'         );
  TestCase.testcase(2584, [$62,$61,$7E,$5F,$7A,$72,$7F                       ] , 'vcvtudq2pd  zmm30{k7},dword [rdx+0x1fc]{1to8}'    );
  TestCase.testcase(2585, [$62,$61,$7E,$5F,$7A,$B2,$00,$02,$00,$00           ] , 'vcvtudq2pd  zmm30{k7},dword [rdx+0x200]{1to8}'    );
  TestCase.testcase(2586, [$62,$61,$7E,$5F,$7A,$72,$80                       ] , 'vcvtudq2pd  zmm30{k7},dword [rdx-0x200]{1to8}'    );
  TestCase.testcase(2587, [$62,$61,$7E,$5F,$7A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtudq2pd  zmm30{k7},dword [rdx-0x204]{1to8}'    );
  TestCase.testcase(2588, [$62,$01,$7F,$48,$7A,$F5                           ] , 'vcvtudq2ps  zmm30,zmm29'                          );
  TestCase.testcase(2589, [$62,$01,$7F,$4F,$7A,$F5                           ] , 'vcvtudq2ps  zmm30{k7},zmm29'                      );
  TestCase.testcase(2590, [$62,$01,$7F,$CF,$7A,$F5                           ] , 'vcvtudq2ps  zmm30{k7}{z},zmm29'                   );
  TestCase.testcase(2591, [$62,$01,$7F,$18,$7A,$F5                           ] , 'vcvtudq2ps  zmm30,zmm29,{rn-sae}'                 );
  TestCase.testcase(2592, [$62,$01,$7F,$58,$7A,$F5                           ] , 'vcvtudq2ps  zmm30,zmm29,{ru-sae}'                 );
  TestCase.testcase(2593, [$62,$01,$7F,$38,$7A,$F5                           ] , 'vcvtudq2ps  zmm30,zmm29,{rd-sae}'                 );
  TestCase.testcase(2594, [$62,$01,$7F,$78,$7A,$F5                           ] , 'vcvtudq2ps  zmm30,zmm29,{rz-sae}'                 );
  TestCase.testcase(2595, [$62,$61,$7F,$48,$7A,$31                           ] , 'vcvtudq2ps  zmm30,zword [rcx]'                    );
  TestCase.testcase(2596, [$62,$21,$7F,$48,$7A,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtudq2ps  zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(2597, [$62,$61,$7F,$58,$7A,$31                           ] , 'vcvtudq2ps  zmm30,dword [rcx]{1to16}'             );
  TestCase.testcase(2598, [$62,$61,$7F,$48,$7A,$72,$7F                       ] , 'vcvtudq2ps  zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(2599, [$62,$61,$7F,$48,$7A,$B2,$00,$20,$00,$00           ] , 'vcvtudq2ps  zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(2600, [$62,$61,$7F,$48,$7A,$72,$80                       ] , 'vcvtudq2ps  zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(2601, [$62,$61,$7F,$48,$7A,$B2,$C0,$DF,$FF,$FF           ] , 'vcvtudq2ps  zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(2602, [$62,$61,$7F,$58,$7A,$72,$7F                       ] , 'vcvtudq2ps  zmm30,dword [rdx+0x1fc]{1to16}'       );
  TestCase.testcase(2603, [$62,$61,$7F,$58,$7A,$B2,$00,$02,$00,$00           ] , 'vcvtudq2ps  zmm30,dword [rdx+0x200]{1to16}'       );
  TestCase.testcase(2604, [$62,$61,$7F,$58,$7A,$72,$80                       ] , 'vcvtudq2ps  zmm30,dword [rdx-0x200]{1to16}'       );
  TestCase.testcase(2605, [$62,$61,$7F,$58,$7A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtudq2ps  zmm30,dword [rdx-0x204]{1to16}'       );
  TestCase.testcase(2606, [$62,$01,$95,$40,$5E,$F4                           ] , 'vdivpd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(2607, [$62,$01,$95,$47,$5E,$F4                           ] , 'vdivpd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(2608, [$62,$01,$95,$C7,$5E,$F4                           ] , 'vdivpd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(2609, [$62,$01,$95,$10,$5E,$F4                           ] , 'vdivpd  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(2610, [$62,$01,$95,$50,$5E,$F4                           ] , 'vdivpd  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(2611, [$62,$01,$95,$30,$5E,$F4                           ] , 'vdivpd  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(2612, [$62,$01,$95,$70,$5E,$F4                           ] , 'vdivpd  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(2613, [$62,$61,$95,$40,$5E,$31                           ] , 'vdivpd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(2614, [$62,$21,$95,$40,$5E,$B4,$F0,$23,$01,$00,$00       ] , 'vdivpd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(2615, [$62,$61,$95,$50,$5E,$31                           ] , 'vdivpd  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(2616, [$62,$61,$95,$40,$5E,$72,$7F                       ] , 'vdivpd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(2617, [$62,$61,$95,$40,$5E,$B2,$00,$20,$00,$00           ] , 'vdivpd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(2618, [$62,$61,$95,$40,$5E,$72,$80                       ] , 'vdivpd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(2619, [$62,$61,$95,$40,$5E,$B2,$C0,$DF,$FF,$FF           ] , 'vdivpd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(2620, [$62,$61,$95,$50,$5E,$72,$7F                       ] , 'vdivpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(2621, [$62,$61,$95,$50,$5E,$B2,$00,$04,$00,$00           ] , 'vdivpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(2622, [$62,$61,$95,$50,$5E,$72,$80                       ] , 'vdivpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(2623, [$62,$61,$95,$50,$5E,$B2,$F8,$FB,$FF,$FF           ] , 'vdivpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(2624, [$62,$01,$14,$40,$5E,$F4                           ] , 'vdivps  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(2625, [$62,$01,$14,$47,$5E,$F4                           ] , 'vdivps  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(2626, [$62,$01,$14,$C7,$5E,$F4                           ] , 'vdivps  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(2627, [$62,$01,$14,$10,$5E,$F4                           ] , 'vdivps  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(2628, [$62,$01,$14,$50,$5E,$F4                           ] , 'vdivps  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(2629, [$62,$01,$14,$30,$5E,$F4                           ] , 'vdivps  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(2630, [$62,$01,$14,$70,$5E,$F4                           ] , 'vdivps  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(2631, [$62,$61,$14,$40,$5E,$31                           ] , 'vdivps  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(2632, [$62,$21,$14,$40,$5E,$B4,$F0,$23,$01,$00,$00       ] , 'vdivps  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(2633, [$62,$61,$14,$50,$5E,$31                           ] , 'vdivps  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(2634, [$62,$61,$14,$40,$5E,$72,$7F                       ] , 'vdivps  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(2635, [$62,$61,$14,$40,$5E,$B2,$00,$20,$00,$00           ] , 'vdivps  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(2636, [$62,$61,$14,$40,$5E,$72,$80                       ] , 'vdivps  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(2637, [$62,$61,$14,$40,$5E,$B2,$C0,$DF,$FF,$FF           ] , 'vdivps  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(2638, [$62,$61,$14,$50,$5E,$72,$7F                       ] , 'vdivps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(2639, [$62,$61,$14,$50,$5E,$B2,$00,$02,$00,$00           ] , 'vdivps  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(2640, [$62,$61,$14,$50,$5E,$72,$80                       ] , 'vdivps  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(2641, [$62,$61,$14,$50,$5E,$B2,$FC,$FD,$FF,$FF           ] , 'vdivps  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(2642, [$62,$01,$97,$07,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(2643, [$62,$01,$97,$87,$5E,$F4                           ] , 'vdivsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(2644, [$62,$01,$97,$17,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(2645, [$62,$01,$97,$57,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(2646, [$62,$01,$97,$37,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(2647, [$62,$01,$97,$77,$5E,$F4                           ] , 'vdivsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(2648, [$62,$61,$97,$07,$5E,$31                           ] , 'vdivsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(2649, [$62,$21,$97,$07,$5E,$B4,$F0,$23,$01,$00,$00       ] , 'vdivsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(2650, [$62,$61,$97,$07,$5E,$72,$7F                       ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(2651, [$62,$61,$97,$07,$5E,$B2,$00,$04,$00,$00           ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(2652, [$62,$61,$97,$07,$5E,$72,$80                       ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(2653, [$62,$61,$97,$07,$5E,$B2,$F8,$FB,$FF,$FF           ] , 'vdivsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(2654, [$62,$01,$16,$07,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(2655, [$62,$01,$16,$87,$5E,$F4                           ] , 'vdivss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(2656, [$62,$01,$16,$17,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(2657, [$62,$01,$16,$57,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(2658, [$62,$01,$16,$37,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(2659, [$62,$01,$16,$77,$5E,$F4                           ] , 'vdivss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(2660, [$62,$61,$16,$07,$5E,$31                           ] , 'vdivss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(2661, [$62,$21,$16,$07,$5E,$B4,$F0,$23,$01,$00,$00       ] , 'vdivss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(2662, [$62,$61,$16,$07,$5E,$72,$7F                       ] , 'vdivss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(2663, [$62,$61,$16,$07,$5E,$B2,$00,$02,$00,$00           ] , 'vdivss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(2664, [$62,$61,$16,$07,$5E,$72,$80                       ] , 'vdivss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(2665, [$62,$61,$16,$07,$5E,$B2,$FC,$FD,$FF,$FF           ] , 'vdivss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(2666, [$62,$62,$FD,$48,$88,$31                           ] , 'vexpandpd  zmm30,zword [rcx]'                     );
  TestCase.testcase(2667, [$62,$62,$FD,$4F,$88,$31                           ] , 'vexpandpd  zmm30{k7},zword [rcx]'                 );
  TestCase.testcase(2668, [$62,$62,$FD,$CF,$88,$31                           ] , 'vexpandpd  zmm30{k7}{z},zword [rcx]'              );
  TestCase.testcase(2669, [$62,$22,$FD,$48,$88,$B4,$F0,$23,$01,$00,$00       ] , 'vexpandpd  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(2670, [$62,$62,$FD,$48,$88,$72,$7F                       ] , 'vexpandpd  zmm30,zword [rdx+0x3f8]'               );
  TestCase.testcase(2671, [$62,$62,$FD,$48,$88,$B2,$00,$04,$00,$00           ] , 'vexpandpd  zmm30,zword [rdx+0x400]'               );
  TestCase.testcase(2672, [$62,$62,$FD,$48,$88,$72,$80                       ] , 'vexpandpd  zmm30,zword [rdx-0x400]'               );
  TestCase.testcase(2673, [$62,$62,$FD,$48,$88,$B2,$F8,$FB,$FF,$FF           ] , 'vexpandpd  zmm30,zword [rdx-0x408]'               );
  TestCase.testcase(2674, [$62,$02,$FD,$48,$88,$F5                           ] , 'vexpandpd  zmm30,zmm29'                           );
  TestCase.testcase(2675, [$62,$02,$FD,$4F,$88,$F5                           ] , 'vexpandpd  zmm30{k7},zmm29'                       );
  TestCase.testcase(2676, [$62,$02,$FD,$CF,$88,$F5                           ] , 'vexpandpd  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(2677, [$62,$62,$7D,$48,$88,$31                           ] , 'vexpandps  zmm30,zword [rcx]'                     );
  TestCase.testcase(2678, [$62,$62,$7D,$4F,$88,$31                           ] , 'vexpandps  zmm30{k7},zword [rcx]'                 );
  TestCase.testcase(2679, [$62,$62,$7D,$CF,$88,$31                           ] , 'vexpandps  zmm30{k7}{z},zword [rcx]'              );
  TestCase.testcase(2680, [$62,$22,$7D,$48,$88,$B4,$F0,$23,$01,$00,$00       ] , 'vexpandps  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(2681, [$62,$62,$7D,$48,$88,$72,$7F                       ] , 'vexpandps  zmm30,zword [rdx+0x1fc]'               );
  TestCase.testcase(2682, [$62,$62,$7D,$48,$88,$B2,$00,$02,$00,$00           ] , 'vexpandps  zmm30,zword [rdx+0x200]'               );
  TestCase.testcase(2683, [$62,$62,$7D,$48,$88,$72,$80                       ] , 'vexpandps  zmm30,zword [rdx-0x200]'               );
  TestCase.testcase(2684, [$62,$62,$7D,$48,$88,$B2,$FC,$FD,$FF,$FF           ] , 'vexpandps  zmm30,zword [rdx-0x204]'               );
  TestCase.testcase(2685, [$62,$02,$7D,$48,$88,$F5                           ] , 'vexpandps  zmm30,zmm29'                           );
  TestCase.testcase(2686, [$62,$02,$7D,$4F,$88,$F5                           ] , 'vexpandps  zmm30{k7},zmm29'                       );
  TestCase.testcase(2687, [$62,$02,$7D,$CF,$88,$F5                           ] , 'vexpandps  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(2688, [$62,$03,$7D,$4F,$19,$EE,$AB                       ] , 'vextractf32x4  xmm30{k7},zmm29,0xab'              );
  TestCase.testcase(2689, [$62,$03,$7D,$CF,$19,$EE,$AB                       ] , 'vextractf32x4  xmm30{k7}{z},zmm29,0xab'           );
  TestCase.testcase(2690, [$62,$03,$7D,$4F,$19,$EE,$7B                       ] , 'vextractf32x4  xmm30{k7},zmm29,0x7b'              );
  TestCase.testcase(2691, [$62,$03,$FD,$4F,$1B,$EE,$AB                       ] , 'vextractf64x4  ymm30{k7},zmm29,0xab'              );
  TestCase.testcase(2692, [$62,$03,$FD,$CF,$1B,$EE,$AB                       ] , 'vextractf64x4  ymm30{k7}{z},zmm29,0xab'           );
  TestCase.testcase(2693, [$62,$03,$FD,$4F,$1B,$EE,$7B                       ] , 'vextractf64x4  ymm30{k7},zmm29,0x7b'              );
  TestCase.testcase(2694, [$62,$03,$7D,$4F,$39,$EE,$AB                       ] , 'vextracti32x4  xmm30{k7},zmm29,0xab'              );
  TestCase.testcase(2695, [$62,$03,$7D,$CF,$39,$EE,$AB                       ] , 'vextracti32x4  xmm30{k7}{z},zmm29,0xab'           );
  TestCase.testcase(2696, [$62,$03,$7D,$4F,$39,$EE,$7B                       ] , 'vextracti32x4  xmm30{k7},zmm29,0x7b'              );
  TestCase.testcase(2697, [$62,$03,$FD,$4F,$3B,$EE,$AB                       ] , 'vextracti64x4  ymm30{k7},zmm29,0xab'              );
  TestCase.testcase(2698, [$62,$03,$FD,$CF,$3B,$EE,$AB                       ] , 'vextracti64x4  ymm30{k7}{z},zmm29,0xab'           );
  TestCase.testcase(2699, [$62,$03,$FD,$4F,$3B,$EE,$7B                       ] , 'vextracti64x4  ymm30{k7},zmm29,0x7b'              );
  TestCase.testcase(2700, [$62,$63,$FD,$08,$17,$E8,$AB                       ] , 'vextractps  rax,xmm29,0xab'                       );
  TestCase.testcase(2701, [$62,$63,$FD,$08,$17,$E8,$7B                       ] , 'vextractps  rax,xmm29,0x7b'                       );
  TestCase.testcase(2702, [$62,$43,$FD,$08,$17,$E8,$7B                       ] , 'vextractps  r8,xmm29,0x7b'                        );
  TestCase.testcase(2703, [$62,$63,$7D,$08,$17,$29,$7B                       ] , 'vextractps  dword [rcx],xmm29,0x7b'               );
  TestCase.testcase(2704, [$62,$23,$7D,$08,$17,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vextractps  dword [rax+r14*8+0x123],xmm29,0x7b'   );
  TestCase.testcase(2705, [$62,$63,$7D,$08,$17,$6A,$7F,$7B                   ] , 'vextractps  dword [rdx+0x1fc],xmm29,0x7b'         );
  TestCase.testcase(2706, [$62,$63,$7D,$08,$17,$AA,$00,$02,$00,$00,$7B       ] , 'vextractps  dword [rdx+0x200],xmm29,0x7b'         );
  TestCase.testcase(2707, [$62,$63,$7D,$08,$17,$6A,$80,$7B                   ] , 'vextractps  dword [rdx-0x200],xmm29,0x7b'         );
  TestCase.testcase(2708, [$62,$63,$7D,$08,$17,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vextractps  dword [rdx-0x204],xmm29,0x7b'         );
  TestCase.testcase(2709, [$62,$02,$95,$40,$98,$F4                           ] , 'vfmadd132pd  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(2710, [$62,$02,$95,$47,$98,$F4                           ] , 'vfmadd132pd  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(2711, [$62,$02,$95,$C7,$98,$F4                           ] , 'vfmadd132pd  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(2712, [$62,$02,$95,$10,$98,$F4                           ] , 'vfmadd132pd  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(2713, [$62,$02,$95,$50,$98,$F4                           ] , 'vfmadd132pd  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(2714, [$62,$02,$95,$30,$98,$F4                           ] , 'vfmadd132pd  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(2715, [$62,$02,$95,$70,$98,$F4                           ] , 'vfmadd132pd  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(2716, [$62,$62,$95,$40,$98,$31                           ] , 'vfmadd132pd  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(2717, [$62,$22,$95,$40,$98,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd132pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2718, [$62,$62,$95,$50,$98,$31                           ] , 'vfmadd132pd  zmm30,zmm29,qword [rcx]{1to8}'       );
  TestCase.testcase(2719, [$62,$62,$95,$40,$98,$72,$7F                       ] , 'vfmadd132pd  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(2720, [$62,$62,$95,$40,$98,$B2,$00,$20,$00,$00           ] , 'vfmadd132pd  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(2721, [$62,$62,$95,$40,$98,$72,$80                       ] , 'vfmadd132pd  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(2722, [$62,$62,$95,$40,$98,$B2,$C0,$DF,$FF,$FF           ] , 'vfmadd132pd  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(2723, [$62,$62,$95,$50,$98,$72,$7F                       ] , 'vfmadd132pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(2724, [$62,$62,$95,$50,$98,$B2,$00,$04,$00,$00           ] , 'vfmadd132pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(2725, [$62,$62,$95,$50,$98,$72,$80                       ] , 'vfmadd132pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(2726, [$62,$62,$95,$50,$98,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd132pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(2727, [$62,$02,$15,$40,$98,$F4                           ] , 'vfmadd132ps  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(2728, [$62,$02,$15,$47,$98,$F4                           ] , 'vfmadd132ps  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(2729, [$62,$02,$15,$C7,$98,$F4                           ] , 'vfmadd132ps  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(2730, [$62,$02,$15,$10,$98,$F4                           ] , 'vfmadd132ps  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(2731, [$62,$02,$15,$50,$98,$F4                           ] , 'vfmadd132ps  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(2732, [$62,$02,$15,$30,$98,$F4                           ] , 'vfmadd132ps  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(2733, [$62,$02,$15,$70,$98,$F4                           ] , 'vfmadd132ps  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(2734, [$62,$62,$15,$40,$98,$31                           ] , 'vfmadd132ps  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(2735, [$62,$22,$15,$40,$98,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd132ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2736, [$62,$62,$15,$50,$98,$31                           ] , 'vfmadd132ps  zmm30,zmm29,dword [rcx]{1to16}'      );
  TestCase.testcase(2737, [$62,$62,$15,$40,$98,$72,$7F                       ] , 'vfmadd132ps  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(2738, [$62,$62,$15,$40,$98,$B2,$00,$20,$00,$00           ] , 'vfmadd132ps  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(2739, [$62,$62,$15,$40,$98,$72,$80                       ] , 'vfmadd132ps  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(2740, [$62,$62,$15,$40,$98,$B2,$C0,$DF,$FF,$FF           ] , 'vfmadd132ps  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(2741, [$62,$62,$15,$50,$98,$72,$7F                       ] , 'vfmadd132ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(2742, [$62,$62,$15,$50,$98,$B2,$00,$02,$00,$00           ] , 'vfmadd132ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(2743, [$62,$62,$15,$50,$98,$72,$80                       ] , 'vfmadd132ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(2744, [$62,$62,$15,$50,$98,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd132ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(2745, [$62,$02,$95,$07,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2746, [$62,$02,$95,$87,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2747, [$62,$02,$95,$17,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2748, [$62,$02,$95,$57,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2749, [$62,$02,$95,$37,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2750, [$62,$02,$95,$77,$99,$F4                           ] , 'vfmadd132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2751, [$62,$62,$95,$07,$99,$31                           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2752, [$62,$22,$95,$07,$99,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(2753, [$62,$62,$95,$07,$99,$72,$7F                       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2754, [$62,$62,$95,$07,$99,$B2,$00,$04,$00,$00           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2755, [$62,$62,$95,$07,$99,$72,$80                       ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2756, [$62,$62,$95,$07,$99,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd132sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2757, [$62,$02,$15,$07,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2758, [$62,$02,$15,$87,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2759, [$62,$02,$15,$17,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2760, [$62,$02,$15,$57,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2761, [$62,$02,$15,$37,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2762, [$62,$02,$15,$77,$99,$F4                           ] , 'vfmadd132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2763, [$62,$62,$15,$07,$99,$31                           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2764, [$62,$22,$15,$07,$99,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2765, [$62,$62,$15,$07,$99,$72,$7F                       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2766, [$62,$62,$15,$07,$99,$B2,$00,$02,$00,$00           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2767, [$62,$62,$15,$07,$99,$72,$80                       ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2768, [$62,$62,$15,$07,$99,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd132ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2769, [$62,$02,$95,$40,$A8,$F4                           ] , 'vfmadd213pd  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(2770, [$62,$02,$95,$47,$A8,$F4                           ] , 'vfmadd213pd  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(2771, [$62,$02,$95,$C7,$A8,$F4                           ] , 'vfmadd213pd  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(2772, [$62,$02,$95,$10,$A8,$F4                           ] , 'vfmadd213pd  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(2773, [$62,$02,$95,$50,$A8,$F4                           ] , 'vfmadd213pd  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(2774, [$62,$02,$95,$30,$A8,$F4                           ] , 'vfmadd213pd  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(2775, [$62,$02,$95,$70,$A8,$F4                           ] , 'vfmadd213pd  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(2776, [$62,$62,$95,$40,$A8,$31                           ] , 'vfmadd213pd  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(2777, [$62,$22,$95,$40,$A8,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd213pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2778, [$62,$62,$95,$50,$A8,$31                           ] , 'vfmadd213pd  zmm30,zmm29,qword [rcx]{1to8}'       );
  TestCase.testcase(2779, [$62,$62,$95,$40,$A8,$72,$7F                       ] , 'vfmadd213pd  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(2780, [$62,$62,$95,$40,$A8,$B2,$00,$20,$00,$00           ] , 'vfmadd213pd  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(2781, [$62,$62,$95,$40,$A8,$72,$80                       ] , 'vfmadd213pd  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(2782, [$62,$62,$95,$40,$A8,$B2,$C0,$DF,$FF,$FF           ] , 'vfmadd213pd  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(2783, [$62,$62,$95,$50,$A8,$72,$7F                       ] , 'vfmadd213pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(2784, [$62,$62,$95,$50,$A8,$B2,$00,$04,$00,$00           ] , 'vfmadd213pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(2785, [$62,$62,$95,$50,$A8,$72,$80                       ] , 'vfmadd213pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(2786, [$62,$62,$95,$50,$A8,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd213pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(2787, [$62,$02,$15,$40,$A8,$F4                           ] , 'vfmadd213ps  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(2788, [$62,$02,$15,$47,$A8,$F4                           ] , 'vfmadd213ps  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(2789, [$62,$02,$15,$C7,$A8,$F4                           ] , 'vfmadd213ps  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(2790, [$62,$02,$15,$10,$A8,$F4                           ] , 'vfmadd213ps  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(2791, [$62,$02,$15,$50,$A8,$F4                           ] , 'vfmadd213ps  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(2792, [$62,$02,$15,$30,$A8,$F4                           ] , 'vfmadd213ps  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(2793, [$62,$02,$15,$70,$A8,$F4                           ] , 'vfmadd213ps  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(2794, [$62,$62,$15,$40,$A8,$31                           ] , 'vfmadd213ps  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(2795, [$62,$22,$15,$40,$A8,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd213ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2796, [$62,$62,$15,$50,$A8,$31                           ] , 'vfmadd213ps  zmm30,zmm29,dword [rcx]{1to16}'      );
  TestCase.testcase(2797, [$62,$62,$15,$40,$A8,$72,$7F                       ] , 'vfmadd213ps  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(2798, [$62,$62,$15,$40,$A8,$B2,$00,$20,$00,$00           ] , 'vfmadd213ps  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(2799, [$62,$62,$15,$40,$A8,$72,$80                       ] , 'vfmadd213ps  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(2800, [$62,$62,$15,$40,$A8,$B2,$C0,$DF,$FF,$FF           ] , 'vfmadd213ps  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(2801, [$62,$62,$15,$50,$A8,$72,$7F                       ] , 'vfmadd213ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(2802, [$62,$62,$15,$50,$A8,$B2,$00,$02,$00,$00           ] , 'vfmadd213ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(2803, [$62,$62,$15,$50,$A8,$72,$80                       ] , 'vfmadd213ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(2804, [$62,$62,$15,$50,$A8,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd213ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(2805, [$62,$02,$95,$07,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2806, [$62,$02,$95,$87,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2807, [$62,$02,$95,$17,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2808, [$62,$02,$95,$57,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2809, [$62,$02,$95,$37,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2810, [$62,$02,$95,$77,$A9,$F4                           ] , 'vfmadd213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2811, [$62,$62,$95,$07,$A9,$31                           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2812, [$62,$22,$95,$07,$A9,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(2813, [$62,$62,$95,$07,$A9,$72,$7F                       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2814, [$62,$62,$95,$07,$A9,$B2,$00,$04,$00,$00           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2815, [$62,$62,$95,$07,$A9,$72,$80                       ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2816, [$62,$62,$95,$07,$A9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd213sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2817, [$62,$02,$15,$07,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2818, [$62,$02,$15,$87,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2819, [$62,$02,$15,$17,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2820, [$62,$02,$15,$57,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2821, [$62,$02,$15,$37,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2822, [$62,$02,$15,$77,$A9,$F4                           ] , 'vfmadd213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2823, [$62,$62,$15,$07,$A9,$31                           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2824, [$62,$22,$15,$07,$A9,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2825, [$62,$62,$15,$07,$A9,$72,$7F                       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2826, [$62,$62,$15,$07,$A9,$B2,$00,$02,$00,$00           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2827, [$62,$62,$15,$07,$A9,$72,$80                       ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2828, [$62,$62,$15,$07,$A9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd213ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2829, [$62,$02,$95,$40,$B8,$F4                           ] , 'vfmadd231pd  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(2830, [$62,$02,$95,$47,$B8,$F4                           ] , 'vfmadd231pd  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(2831, [$62,$02,$95,$C7,$B8,$F4                           ] , 'vfmadd231pd  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(2832, [$62,$02,$95,$10,$B8,$F4                           ] , 'vfmadd231pd  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(2833, [$62,$02,$95,$50,$B8,$F4                           ] , 'vfmadd231pd  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(2834, [$62,$02,$95,$30,$B8,$F4                           ] , 'vfmadd231pd  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(2835, [$62,$02,$95,$70,$B8,$F4                           ] , 'vfmadd231pd  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(2836, [$62,$62,$95,$40,$B8,$31                           ] , 'vfmadd231pd  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(2837, [$62,$22,$95,$40,$B8,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd231pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2838, [$62,$62,$95,$50,$B8,$31                           ] , 'vfmadd231pd  zmm30,zmm29,qword [rcx]{1to8}'       );
  TestCase.testcase(2839, [$62,$62,$95,$40,$B8,$72,$7F                       ] , 'vfmadd231pd  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(2840, [$62,$62,$95,$40,$B8,$B2,$00,$20,$00,$00           ] , 'vfmadd231pd  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(2841, [$62,$62,$95,$40,$B8,$72,$80                       ] , 'vfmadd231pd  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(2842, [$62,$62,$95,$40,$B8,$B2,$C0,$DF,$FF,$FF           ] , 'vfmadd231pd  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(2843, [$62,$62,$95,$50,$B8,$72,$7F                       ] , 'vfmadd231pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(2844, [$62,$62,$95,$50,$B8,$B2,$00,$04,$00,$00           ] , 'vfmadd231pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(2845, [$62,$62,$95,$50,$B8,$72,$80                       ] , 'vfmadd231pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(2846, [$62,$62,$95,$50,$B8,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd231pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(2847, [$62,$02,$15,$40,$B8,$F4                           ] , 'vfmadd231ps  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(2848, [$62,$02,$15,$47,$B8,$F4                           ] , 'vfmadd231ps  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(2849, [$62,$02,$15,$C7,$B8,$F4                           ] , 'vfmadd231ps  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(2850, [$62,$02,$15,$10,$B8,$F4                           ] , 'vfmadd231ps  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(2851, [$62,$02,$15,$50,$B8,$F4                           ] , 'vfmadd231ps  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(2852, [$62,$02,$15,$30,$B8,$F4                           ] , 'vfmadd231ps  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(2853, [$62,$02,$15,$70,$B8,$F4                           ] , 'vfmadd231ps  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(2854, [$62,$62,$15,$40,$B8,$31                           ] , 'vfmadd231ps  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(2855, [$62,$22,$15,$40,$B8,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd231ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2856, [$62,$62,$15,$50,$B8,$31                           ] , 'vfmadd231ps  zmm30,zmm29,dword [rcx]{1to16}'      );
  TestCase.testcase(2857, [$62,$62,$15,$40,$B8,$72,$7F                       ] , 'vfmadd231ps  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(2858, [$62,$62,$15,$40,$B8,$B2,$00,$20,$00,$00           ] , 'vfmadd231ps  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(2859, [$62,$62,$15,$40,$B8,$72,$80                       ] , 'vfmadd231ps  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(2860, [$62,$62,$15,$40,$B8,$B2,$C0,$DF,$FF,$FF           ] , 'vfmadd231ps  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(2861, [$62,$62,$15,$50,$B8,$72,$7F                       ] , 'vfmadd231ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(2862, [$62,$62,$15,$50,$B8,$B2,$00,$02,$00,$00           ] , 'vfmadd231ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(2863, [$62,$62,$15,$50,$B8,$72,$80                       ] , 'vfmadd231ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(2864, [$62,$62,$15,$50,$B8,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd231ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(2865, [$62,$02,$95,$07,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2866, [$62,$02,$95,$87,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2867, [$62,$02,$95,$17,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2868, [$62,$02,$95,$57,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2869, [$62,$02,$95,$37,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2870, [$62,$02,$95,$77,$B9,$F4                           ] , 'vfmadd231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2871, [$62,$62,$95,$07,$B9,$31                           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(2872, [$62,$22,$95,$07,$B9,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(2873, [$62,$62,$95,$07,$B9,$72,$7F                       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(2874, [$62,$62,$95,$07,$B9,$B2,$00,$04,$00,$00           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(2875, [$62,$62,$95,$07,$B9,$72,$80                       ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(2876, [$62,$62,$95,$07,$B9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd231sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(2877, [$62,$02,$15,$07,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(2878, [$62,$02,$15,$87,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(2879, [$62,$02,$15,$17,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(2880, [$62,$02,$15,$57,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(2881, [$62,$02,$15,$37,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(2882, [$62,$02,$15,$77,$B9,$F4                           ] , 'vfmadd231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(2883, [$62,$62,$15,$07,$B9,$31                           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(2884, [$62,$22,$15,$07,$B9,$B4,$F0,$23,$01,$00,$00       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(2885, [$62,$62,$15,$07,$B9,$72,$7F                       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(2886, [$62,$62,$15,$07,$B9,$B2,$00,$02,$00,$00           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(2887, [$62,$62,$15,$07,$B9,$72,$80                       ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(2888, [$62,$62,$15,$07,$B9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd231ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(2889, [$62,$02,$95,$40,$96,$F4                           ] , 'vfmaddsub132pd  zmm30,zmm29,zmm28'                );
  TestCase.testcase(2890, [$62,$02,$95,$47,$96,$F4                           ] , 'vfmaddsub132pd  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(2891, [$62,$02,$95,$C7,$96,$F4                           ] , 'vfmaddsub132pd  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(2892, [$62,$02,$95,$10,$96,$F4                           ] , 'vfmaddsub132pd  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(2893, [$62,$02,$95,$50,$96,$F4                           ] , 'vfmaddsub132pd  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(2894, [$62,$02,$95,$30,$96,$F4                           ] , 'vfmaddsub132pd  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(2895, [$62,$02,$95,$70,$96,$F4                           ] , 'vfmaddsub132pd  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(2896, [$62,$62,$95,$40,$96,$31                           ] , 'vfmaddsub132pd  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(2897, [$62,$22,$95,$40,$96,$B4,$F0,$23,$01,$00,$00       ] , 'vfmaddsub132pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2898, [$62,$62,$95,$50,$96,$31                           ] , 'vfmaddsub132pd  zmm30,zmm29,qword [rcx]{1to8}'    );
  TestCase.testcase(2899, [$62,$62,$95,$40,$96,$72,$7F                       ] , 'vfmaddsub132pd  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(2900, [$62,$62,$95,$40,$96,$B2,$00,$20,$00,$00           ] , 'vfmaddsub132pd  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(2901, [$62,$62,$95,$40,$96,$72,$80                       ] , 'vfmaddsub132pd  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(2902, [$62,$62,$95,$40,$96,$B2,$C0,$DF,$FF,$FF           ] , 'vfmaddsub132pd  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(2903, [$62,$62,$95,$50,$96,$72,$7F                       ] , 'vfmaddsub132pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(2904, [$62,$62,$95,$50,$96,$B2,$00,$04,$00,$00           ] , 'vfmaddsub132pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(2905, [$62,$62,$95,$50,$96,$72,$80                       ] , 'vfmaddsub132pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(2906, [$62,$62,$95,$50,$96,$B2,$F8,$FB,$FF,$FF           ] , 'vfmaddsub132pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(2907, [$62,$02,$15,$40,$96,$F4                           ] , 'vfmaddsub132ps  zmm30,zmm29,zmm28'                );
  TestCase.testcase(2908, [$62,$02,$15,$47,$96,$F4                           ] , 'vfmaddsub132ps  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(2909, [$62,$02,$15,$C7,$96,$F4                           ] , 'vfmaddsub132ps  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(2910, [$62,$02,$15,$10,$96,$F4                           ] , 'vfmaddsub132ps  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(2911, [$62,$02,$15,$50,$96,$F4                           ] , 'vfmaddsub132ps  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(2912, [$62,$02,$15,$30,$96,$F4                           ] , 'vfmaddsub132ps  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(2913, [$62,$02,$15,$70,$96,$F4                           ] , 'vfmaddsub132ps  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(2914, [$62,$62,$15,$40,$96,$31                           ] , 'vfmaddsub132ps  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(2915, [$62,$22,$15,$40,$96,$B4,$F0,$23,$01,$00,$00       ] , 'vfmaddsub132ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2916, [$62,$62,$15,$50,$96,$31                           ] , 'vfmaddsub132ps  zmm30,zmm29,dword [rcx]{1to16}'   );
  TestCase.testcase(2917, [$62,$62,$15,$40,$96,$72,$7F                       ] , 'vfmaddsub132ps  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(2918, [$62,$62,$15,$40,$96,$B2,$00,$20,$00,$00           ] , 'vfmaddsub132ps  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(2919, [$62,$62,$15,$40,$96,$72,$80                       ] , 'vfmaddsub132ps  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(2920, [$62,$62,$15,$40,$96,$B2,$C0,$DF,$FF,$FF           ] , 'vfmaddsub132ps  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(2921, [$62,$62,$15,$50,$96,$72,$7F                       ] , 'vfmaddsub132ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(2922, [$62,$62,$15,$50,$96,$B2,$00,$02,$00,$00           ] , 'vfmaddsub132ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(2923, [$62,$62,$15,$50,$96,$72,$80                       ] , 'vfmaddsub132ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(2924, [$62,$62,$15,$50,$96,$B2,$FC,$FD,$FF,$FF           ] , 'vfmaddsub132ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(2925, [$62,$02,$95,$40,$A6,$F4                           ] , 'vfmaddsub213pd  zmm30,zmm29,zmm28'                );
  TestCase.testcase(2926, [$62,$02,$95,$47,$A6,$F4                           ] , 'vfmaddsub213pd  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(2927, [$62,$02,$95,$C7,$A6,$F4                           ] , 'vfmaddsub213pd  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(2928, [$62,$02,$95,$10,$A6,$F4                           ] , 'vfmaddsub213pd  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(2929, [$62,$02,$95,$50,$A6,$F4                           ] , 'vfmaddsub213pd  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(2930, [$62,$02,$95,$30,$A6,$F4                           ] , 'vfmaddsub213pd  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(2931, [$62,$02,$95,$70,$A6,$F4                           ] , 'vfmaddsub213pd  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(2932, [$62,$62,$95,$40,$A6,$31                           ] , 'vfmaddsub213pd  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(2933, [$62,$22,$95,$40,$A6,$B4,$F0,$23,$01,$00,$00       ] , 'vfmaddsub213pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2934, [$62,$62,$95,$50,$A6,$31                           ] , 'vfmaddsub213pd  zmm30,zmm29,qword [rcx]{1to8}'    );
  TestCase.testcase(2935, [$62,$62,$95,$40,$A6,$72,$7F                       ] , 'vfmaddsub213pd  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(2936, [$62,$62,$95,$40,$A6,$B2,$00,$20,$00,$00           ] , 'vfmaddsub213pd  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(2937, [$62,$62,$95,$40,$A6,$72,$80                       ] , 'vfmaddsub213pd  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(2938, [$62,$62,$95,$40,$A6,$B2,$C0,$DF,$FF,$FF           ] , 'vfmaddsub213pd  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(2939, [$62,$62,$95,$50,$A6,$72,$7F                       ] , 'vfmaddsub213pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(2940, [$62,$62,$95,$50,$A6,$B2,$00,$04,$00,$00           ] , 'vfmaddsub213pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(2941, [$62,$62,$95,$50,$A6,$72,$80                       ] , 'vfmaddsub213pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(2942, [$62,$62,$95,$50,$A6,$B2,$F8,$FB,$FF,$FF           ] , 'vfmaddsub213pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(2943, [$62,$02,$15,$40,$A6,$F4                           ] , 'vfmaddsub213ps  zmm30,zmm29,zmm28'                );
  TestCase.testcase(2944, [$62,$02,$15,$47,$A6,$F4                           ] , 'vfmaddsub213ps  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(2945, [$62,$02,$15,$C7,$A6,$F4                           ] , 'vfmaddsub213ps  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(2946, [$62,$02,$15,$10,$A6,$F4                           ] , 'vfmaddsub213ps  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(2947, [$62,$02,$15,$50,$A6,$F4                           ] , 'vfmaddsub213ps  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(2948, [$62,$02,$15,$30,$A6,$F4                           ] , 'vfmaddsub213ps  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(2949, [$62,$02,$15,$70,$A6,$F4                           ] , 'vfmaddsub213ps  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(2950, [$62,$62,$15,$40,$A6,$31                           ] , 'vfmaddsub213ps  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(2951, [$62,$22,$15,$40,$A6,$B4,$F0,$23,$01,$00,$00       ] , 'vfmaddsub213ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2952, [$62,$62,$15,$50,$A6,$31                           ] , 'vfmaddsub213ps  zmm30,zmm29,dword [rcx]{1to16}'   );
  TestCase.testcase(2953, [$62,$62,$15,$40,$A6,$72,$7F                       ] , 'vfmaddsub213ps  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(2954, [$62,$62,$15,$40,$A6,$B2,$00,$20,$00,$00           ] , 'vfmaddsub213ps  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(2955, [$62,$62,$15,$40,$A6,$72,$80                       ] , 'vfmaddsub213ps  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(2956, [$62,$62,$15,$40,$A6,$B2,$C0,$DF,$FF,$FF           ] , 'vfmaddsub213ps  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(2957, [$62,$62,$15,$50,$A6,$72,$7F                       ] , 'vfmaddsub213ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(2958, [$62,$62,$15,$50,$A6,$B2,$00,$02,$00,$00           ] , 'vfmaddsub213ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(2959, [$62,$62,$15,$50,$A6,$72,$80                       ] , 'vfmaddsub213ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(2960, [$62,$62,$15,$50,$A6,$B2,$FC,$FD,$FF,$FF           ] , 'vfmaddsub213ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(2961, [$62,$02,$95,$40,$B6,$F4                           ] , 'vfmaddsub231pd  zmm30,zmm29,zmm28'                );
  TestCase.testcase(2962, [$62,$02,$95,$47,$B6,$F4                           ] , 'vfmaddsub231pd  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(2963, [$62,$02,$95,$C7,$B6,$F4                           ] , 'vfmaddsub231pd  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(2964, [$62,$02,$95,$10,$B6,$F4                           ] , 'vfmaddsub231pd  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(2965, [$62,$02,$95,$50,$B6,$F4                           ] , 'vfmaddsub231pd  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(2966, [$62,$02,$95,$30,$B6,$F4                           ] , 'vfmaddsub231pd  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(2967, [$62,$02,$95,$70,$B6,$F4                           ] , 'vfmaddsub231pd  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(2968, [$62,$62,$95,$40,$B6,$31                           ] , 'vfmaddsub231pd  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(2969, [$62,$22,$95,$40,$B6,$B4,$F0,$23,$01,$00,$00       ] , 'vfmaddsub231pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2970, [$62,$62,$95,$50,$B6,$31                           ] , 'vfmaddsub231pd  zmm30,zmm29,qword [rcx]{1to8}'    );
  TestCase.testcase(2971, [$62,$62,$95,$40,$B6,$72,$7F                       ] , 'vfmaddsub231pd  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(2972, [$62,$62,$95,$40,$B6,$B2,$00,$20,$00,$00           ] , 'vfmaddsub231pd  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(2973, [$62,$62,$95,$40,$B6,$72,$80                       ] , 'vfmaddsub231pd  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(2974, [$62,$62,$95,$40,$B6,$B2,$C0,$DF,$FF,$FF           ] , 'vfmaddsub231pd  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(2975, [$62,$62,$95,$50,$B6,$72,$7F                       ] , 'vfmaddsub231pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(2976, [$62,$62,$95,$50,$B6,$B2,$00,$04,$00,$00           ] , 'vfmaddsub231pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(2977, [$62,$62,$95,$50,$B6,$72,$80                       ] , 'vfmaddsub231pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(2978, [$62,$62,$95,$50,$B6,$B2,$F8,$FB,$FF,$FF           ] , 'vfmaddsub231pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(2979, [$62,$02,$15,$40,$B6,$F4                           ] , 'vfmaddsub231ps  zmm30,zmm29,zmm28'                );
  TestCase.testcase(2980, [$62,$02,$15,$47,$B6,$F4                           ] , 'vfmaddsub231ps  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(2981, [$62,$02,$15,$C7,$B6,$F4                           ] , 'vfmaddsub231ps  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(2982, [$62,$02,$15,$10,$B6,$F4                           ] , 'vfmaddsub231ps  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(2983, [$62,$02,$15,$50,$B6,$F4                           ] , 'vfmaddsub231ps  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(2984, [$62,$02,$15,$30,$B6,$F4                           ] , 'vfmaddsub231ps  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(2985, [$62,$02,$15,$70,$B6,$F4                           ] , 'vfmaddsub231ps  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(2986, [$62,$62,$15,$40,$B6,$31                           ] , 'vfmaddsub231ps  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(2987, [$62,$22,$15,$40,$B6,$B4,$F0,$23,$01,$00,$00       ] , 'vfmaddsub231ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(2988, [$62,$62,$15,$50,$B6,$31                           ] , 'vfmaddsub231ps  zmm30,zmm29,dword [rcx]{1to16}'   );
  TestCase.testcase(2989, [$62,$62,$15,$40,$B6,$72,$7F                       ] , 'vfmaddsub231ps  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(2990, [$62,$62,$15,$40,$B6,$B2,$00,$20,$00,$00           ] , 'vfmaddsub231ps  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(2991, [$62,$62,$15,$40,$B6,$72,$80                       ] , 'vfmaddsub231ps  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(2992, [$62,$62,$15,$40,$B6,$B2,$C0,$DF,$FF,$FF           ] , 'vfmaddsub231ps  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(2993, [$62,$62,$15,$50,$B6,$72,$7F                       ] , 'vfmaddsub231ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(2994, [$62,$62,$15,$50,$B6,$B2,$00,$02,$00,$00           ] , 'vfmaddsub231ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(2995, [$62,$62,$15,$50,$B6,$72,$80                       ] , 'vfmaddsub231ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(2996, [$62,$62,$15,$50,$B6,$B2,$FC,$FD,$FF,$FF           ] , 'vfmaddsub231ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(2997, [$62,$02,$95,$40,$9A,$F4                           ] , 'vfmsub132pd  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(2998, [$62,$02,$95,$47,$9A,$F4                           ] , 'vfmsub132pd  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(2999, [$62,$02,$95,$C7,$9A,$F4                           ] , 'vfmsub132pd  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(3000, [$62,$02,$95,$10,$9A,$F4                           ] , 'vfmsub132pd  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(3001, [$62,$02,$95,$50,$9A,$F4                           ] , 'vfmsub132pd  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(3002, [$62,$02,$95,$30,$9A,$F4                           ] , 'vfmsub132pd  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(3003, [$62,$02,$95,$70,$9A,$F4                           ] , 'vfmsub132pd  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(3004, [$62,$62,$95,$40,$9A,$31                           ] , 'vfmsub132pd  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(3005, [$62,$22,$95,$40,$9A,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub132pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3006, [$62,$62,$95,$50,$9A,$31                           ] , 'vfmsub132pd  zmm30,zmm29,qword [rcx]{1to8}'       );
  TestCase.testcase(3007, [$62,$62,$95,$40,$9A,$72,$7F                       ] , 'vfmsub132pd  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(3008, [$62,$62,$95,$40,$9A,$B2,$00,$20,$00,$00           ] , 'vfmsub132pd  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(3009, [$62,$62,$95,$40,$9A,$72,$80                       ] , 'vfmsub132pd  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(3010, [$62,$62,$95,$40,$9A,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsub132pd  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(3011, [$62,$62,$95,$50,$9A,$72,$7F                       ] , 'vfmsub132pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3012, [$62,$62,$95,$50,$9A,$B2,$00,$04,$00,$00           ] , 'vfmsub132pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3013, [$62,$62,$95,$50,$9A,$72,$80                       ] , 'vfmsub132pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3014, [$62,$62,$95,$50,$9A,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub132pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3015, [$62,$02,$15,$40,$9A,$F4                           ] , 'vfmsub132ps  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(3016, [$62,$02,$15,$47,$9A,$F4                           ] , 'vfmsub132ps  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(3017, [$62,$02,$15,$C7,$9A,$F4                           ] , 'vfmsub132ps  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(3018, [$62,$02,$15,$10,$9A,$F4                           ] , 'vfmsub132ps  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(3019, [$62,$02,$15,$50,$9A,$F4                           ] , 'vfmsub132ps  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(3020, [$62,$02,$15,$30,$9A,$F4                           ] , 'vfmsub132ps  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(3021, [$62,$02,$15,$70,$9A,$F4                           ] , 'vfmsub132ps  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(3022, [$62,$62,$15,$40,$9A,$31                           ] , 'vfmsub132ps  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(3023, [$62,$22,$15,$40,$9A,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub132ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3024, [$62,$62,$15,$50,$9A,$31                           ] , 'vfmsub132ps  zmm30,zmm29,dword [rcx]{1to16}'      );
  TestCase.testcase(3025, [$62,$62,$15,$40,$9A,$72,$7F                       ] , 'vfmsub132ps  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(3026, [$62,$62,$15,$40,$9A,$B2,$00,$20,$00,$00           ] , 'vfmsub132ps  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(3027, [$62,$62,$15,$40,$9A,$72,$80                       ] , 'vfmsub132ps  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(3028, [$62,$62,$15,$40,$9A,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsub132ps  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(3029, [$62,$62,$15,$50,$9A,$72,$7F                       ] , 'vfmsub132ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3030, [$62,$62,$15,$50,$9A,$B2,$00,$02,$00,$00           ] , 'vfmsub132ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3031, [$62,$62,$15,$50,$9A,$72,$80                       ] , 'vfmsub132ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3032, [$62,$62,$15,$50,$9A,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub132ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3033, [$62,$02,$95,$07,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(3034, [$62,$02,$95,$87,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(3035, [$62,$02,$95,$17,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(3036, [$62,$02,$95,$57,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(3037, [$62,$02,$95,$37,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(3038, [$62,$02,$95,$77,$9B,$F4                           ] , 'vfmsub132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(3039, [$62,$62,$95,$07,$9B,$31                           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(3040, [$62,$22,$95,$07,$9B,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3041, [$62,$62,$95,$07,$9B,$72,$7F                       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(3042, [$62,$62,$95,$07,$9B,$B2,$00,$04,$00,$00           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(3043, [$62,$62,$95,$07,$9B,$72,$80                       ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(3044, [$62,$62,$95,$07,$9B,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub132sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(3045, [$62,$02,$15,$07,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(3046, [$62,$02,$15,$87,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(3047, [$62,$02,$15,$17,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(3048, [$62,$02,$15,$57,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(3049, [$62,$02,$15,$37,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(3050, [$62,$02,$15,$77,$9B,$F4                           ] , 'vfmsub132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(3051, [$62,$62,$15,$07,$9B,$31                           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(3052, [$62,$22,$15,$07,$9B,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3053, [$62,$62,$15,$07,$9B,$72,$7F                       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(3054, [$62,$62,$15,$07,$9B,$B2,$00,$02,$00,$00           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(3055, [$62,$62,$15,$07,$9B,$72,$80                       ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(3056, [$62,$62,$15,$07,$9B,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub132ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(3057, [$62,$02,$95,$40,$AA,$F4                           ] , 'vfmsub213pd  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(3058, [$62,$02,$95,$47,$AA,$F4                           ] , 'vfmsub213pd  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(3059, [$62,$02,$95,$C7,$AA,$F4                           ] , 'vfmsub213pd  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(3060, [$62,$02,$95,$10,$AA,$F4                           ] , 'vfmsub213pd  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(3061, [$62,$02,$95,$50,$AA,$F4                           ] , 'vfmsub213pd  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(3062, [$62,$02,$95,$30,$AA,$F4                           ] , 'vfmsub213pd  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(3063, [$62,$02,$95,$70,$AA,$F4                           ] , 'vfmsub213pd  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(3064, [$62,$62,$95,$40,$AA,$31                           ] , 'vfmsub213pd  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(3065, [$62,$22,$95,$40,$AA,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub213pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3066, [$62,$62,$95,$50,$AA,$31                           ] , 'vfmsub213pd  zmm30,zmm29,qword [rcx]{1to8}'       );
  TestCase.testcase(3067, [$62,$62,$95,$40,$AA,$72,$7F                       ] , 'vfmsub213pd  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(3068, [$62,$62,$95,$40,$AA,$B2,$00,$20,$00,$00           ] , 'vfmsub213pd  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(3069, [$62,$62,$95,$40,$AA,$72,$80                       ] , 'vfmsub213pd  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(3070, [$62,$62,$95,$40,$AA,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsub213pd  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(3071, [$62,$62,$95,$50,$AA,$72,$7F                       ] , 'vfmsub213pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3072, [$62,$62,$95,$50,$AA,$B2,$00,$04,$00,$00           ] , 'vfmsub213pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3073, [$62,$62,$95,$50,$AA,$72,$80                       ] , 'vfmsub213pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3074, [$62,$62,$95,$50,$AA,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub213pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3075, [$62,$02,$15,$40,$AA,$F4                           ] , 'vfmsub213ps  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(3076, [$62,$02,$15,$47,$AA,$F4                           ] , 'vfmsub213ps  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(3077, [$62,$02,$15,$C7,$AA,$F4                           ] , 'vfmsub213ps  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(3078, [$62,$02,$15,$10,$AA,$F4                           ] , 'vfmsub213ps  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(3079, [$62,$02,$15,$50,$AA,$F4                           ] , 'vfmsub213ps  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(3080, [$62,$02,$15,$30,$AA,$F4                           ] , 'vfmsub213ps  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(3081, [$62,$02,$15,$70,$AA,$F4                           ] , 'vfmsub213ps  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(3082, [$62,$62,$15,$40,$AA,$31                           ] , 'vfmsub213ps  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(3083, [$62,$22,$15,$40,$AA,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub213ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3084, [$62,$62,$15,$50,$AA,$31                           ] , 'vfmsub213ps  zmm30,zmm29,dword [rcx]{1to16}'      );
  TestCase.testcase(3085, [$62,$62,$15,$40,$AA,$72,$7F                       ] , 'vfmsub213ps  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(3086, [$62,$62,$15,$40,$AA,$B2,$00,$20,$00,$00           ] , 'vfmsub213ps  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(3087, [$62,$62,$15,$40,$AA,$72,$80                       ] , 'vfmsub213ps  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(3088, [$62,$62,$15,$40,$AA,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsub213ps  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(3089, [$62,$62,$15,$50,$AA,$72,$7F                       ] , 'vfmsub213ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3090, [$62,$62,$15,$50,$AA,$B2,$00,$02,$00,$00           ] , 'vfmsub213ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3091, [$62,$62,$15,$50,$AA,$72,$80                       ] , 'vfmsub213ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3092, [$62,$62,$15,$50,$AA,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub213ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3093, [$62,$02,$95,$07,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(3094, [$62,$02,$95,$87,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(3095, [$62,$02,$95,$17,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(3096, [$62,$02,$95,$57,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(3097, [$62,$02,$95,$37,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(3098, [$62,$02,$95,$77,$AB,$F4                           ] , 'vfmsub213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(3099, [$62,$62,$95,$07,$AB,$31                           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(3100, [$62,$22,$95,$07,$AB,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3101, [$62,$62,$95,$07,$AB,$72,$7F                       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(3102, [$62,$62,$95,$07,$AB,$B2,$00,$04,$00,$00           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(3103, [$62,$62,$95,$07,$AB,$72,$80                       ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(3104, [$62,$62,$95,$07,$AB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub213sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(3105, [$62,$02,$15,$07,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(3106, [$62,$02,$15,$87,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(3107, [$62,$02,$15,$17,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(3108, [$62,$02,$15,$57,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(3109, [$62,$02,$15,$37,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(3110, [$62,$02,$15,$77,$AB,$F4                           ] , 'vfmsub213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(3111, [$62,$62,$15,$07,$AB,$31                           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(3112, [$62,$22,$15,$07,$AB,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3113, [$62,$62,$15,$07,$AB,$72,$7F                       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(3114, [$62,$62,$15,$07,$AB,$B2,$00,$02,$00,$00           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(3115, [$62,$62,$15,$07,$AB,$72,$80                       ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(3116, [$62,$62,$15,$07,$AB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub213ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(3117, [$62,$02,$95,$40,$BA,$F4                           ] , 'vfmsub231pd  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(3118, [$62,$02,$95,$47,$BA,$F4                           ] , 'vfmsub231pd  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(3119, [$62,$02,$95,$C7,$BA,$F4                           ] , 'vfmsub231pd  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(3120, [$62,$02,$95,$10,$BA,$F4                           ] , 'vfmsub231pd  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(3121, [$62,$02,$95,$50,$BA,$F4                           ] , 'vfmsub231pd  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(3122, [$62,$02,$95,$30,$BA,$F4                           ] , 'vfmsub231pd  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(3123, [$62,$02,$95,$70,$BA,$F4                           ] , 'vfmsub231pd  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(3124, [$62,$62,$95,$40,$BA,$31                           ] , 'vfmsub231pd  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(3125, [$62,$22,$95,$40,$BA,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub231pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3126, [$62,$62,$95,$50,$BA,$31                           ] , 'vfmsub231pd  zmm30,zmm29,qword [rcx]{1to8}'       );
  TestCase.testcase(3127, [$62,$62,$95,$40,$BA,$72,$7F                       ] , 'vfmsub231pd  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(3128, [$62,$62,$95,$40,$BA,$B2,$00,$20,$00,$00           ] , 'vfmsub231pd  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(3129, [$62,$62,$95,$40,$BA,$72,$80                       ] , 'vfmsub231pd  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(3130, [$62,$62,$95,$40,$BA,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsub231pd  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(3131, [$62,$62,$95,$50,$BA,$72,$7F                       ] , 'vfmsub231pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3132, [$62,$62,$95,$50,$BA,$B2,$00,$04,$00,$00           ] , 'vfmsub231pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3133, [$62,$62,$95,$50,$BA,$72,$80                       ] , 'vfmsub231pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3134, [$62,$62,$95,$50,$BA,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub231pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3135, [$62,$02,$15,$40,$BA,$F4                           ] , 'vfmsub231ps  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(3136, [$62,$02,$15,$47,$BA,$F4                           ] , 'vfmsub231ps  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(3137, [$62,$02,$15,$C7,$BA,$F4                           ] , 'vfmsub231ps  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(3138, [$62,$02,$15,$10,$BA,$F4                           ] , 'vfmsub231ps  zmm30,zmm29,zmm28,{rn-sae}'          );
  TestCase.testcase(3139, [$62,$02,$15,$50,$BA,$F4                           ] , 'vfmsub231ps  zmm30,zmm29,zmm28,{ru-sae}'          );
  TestCase.testcase(3140, [$62,$02,$15,$30,$BA,$F4                           ] , 'vfmsub231ps  zmm30,zmm29,zmm28,{rd-sae}'          );
  TestCase.testcase(3141, [$62,$02,$15,$70,$BA,$F4                           ] , 'vfmsub231ps  zmm30,zmm29,zmm28,{rz-sae}'          );
  TestCase.testcase(3142, [$62,$62,$15,$40,$BA,$31                           ] , 'vfmsub231ps  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(3143, [$62,$22,$15,$40,$BA,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub231ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3144, [$62,$62,$15,$50,$BA,$31                           ] , 'vfmsub231ps  zmm30,zmm29,dword [rcx]{1to16}'      );
  TestCase.testcase(3145, [$62,$62,$15,$40,$BA,$72,$7F                       ] , 'vfmsub231ps  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(3146, [$62,$62,$15,$40,$BA,$B2,$00,$20,$00,$00           ] , 'vfmsub231ps  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(3147, [$62,$62,$15,$40,$BA,$72,$80                       ] , 'vfmsub231ps  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(3148, [$62,$62,$15,$40,$BA,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsub231ps  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(3149, [$62,$62,$15,$50,$BA,$72,$7F                       ] , 'vfmsub231ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3150, [$62,$62,$15,$50,$BA,$B2,$00,$02,$00,$00           ] , 'vfmsub231ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3151, [$62,$62,$15,$50,$BA,$72,$80                       ] , 'vfmsub231ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3152, [$62,$62,$15,$50,$BA,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub231ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3153, [$62,$02,$95,$07,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(3154, [$62,$02,$95,$87,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(3155, [$62,$02,$95,$17,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(3156, [$62,$02,$95,$57,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(3157, [$62,$02,$95,$37,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(3158, [$62,$02,$95,$77,$BB,$F4                           ] , 'vfmsub231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(3159, [$62,$62,$95,$07,$BB,$31                           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rcx]'         );
  TestCase.testcase(3160, [$62,$22,$95,$07,$BB,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3161, [$62,$62,$95,$07,$BB,$72,$7F                       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'   );
  TestCase.testcase(3162, [$62,$62,$95,$07,$BB,$B2,$00,$04,$00,$00           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx+0x400]'   );
  TestCase.testcase(3163, [$62,$62,$95,$07,$BB,$72,$80                       ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx-0x400]'   );
  TestCase.testcase(3164, [$62,$62,$95,$07,$BB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub231sd  xmm30{k7},xmm29,qword [rdx-0x408]'   );
  TestCase.testcase(3165, [$62,$02,$15,$07,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28'               );
  TestCase.testcase(3166, [$62,$02,$15,$87,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7}{z},xmm29,xmm28'            );
  TestCase.testcase(3167, [$62,$02,$15,$17,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'      );
  TestCase.testcase(3168, [$62,$02,$15,$57,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'      );
  TestCase.testcase(3169, [$62,$02,$15,$37,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'      );
  TestCase.testcase(3170, [$62,$02,$15,$77,$BB,$F4                           ] , 'vfmsub231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'      );
  TestCase.testcase(3171, [$62,$62,$15,$07,$BB,$31                           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rcx]'         );
  TestCase.testcase(3172, [$62,$22,$15,$07,$BB,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3173, [$62,$62,$15,$07,$BB,$72,$7F                       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'   );
  TestCase.testcase(3174, [$62,$62,$15,$07,$BB,$B2,$00,$02,$00,$00           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx+0x200]'   );
  TestCase.testcase(3175, [$62,$62,$15,$07,$BB,$72,$80                       ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx-0x200]'   );
  TestCase.testcase(3176, [$62,$62,$15,$07,$BB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub231ss  xmm30{k7},xmm29,dword [rdx-0x204]'   );
  TestCase.testcase(3177, [$62,$02,$95,$40,$97,$F4                           ] , 'vfmsubadd132pd  zmm30,zmm29,zmm28'                );
  TestCase.testcase(3178, [$62,$02,$95,$47,$97,$F4                           ] , 'vfmsubadd132pd  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(3179, [$62,$02,$95,$C7,$97,$F4                           ] , 'vfmsubadd132pd  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(3180, [$62,$02,$95,$10,$97,$F4                           ] , 'vfmsubadd132pd  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(3181, [$62,$02,$95,$50,$97,$F4                           ] , 'vfmsubadd132pd  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(3182, [$62,$02,$95,$30,$97,$F4                           ] , 'vfmsubadd132pd  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(3183, [$62,$02,$95,$70,$97,$F4                           ] , 'vfmsubadd132pd  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(3184, [$62,$62,$95,$40,$97,$31                           ] , 'vfmsubadd132pd  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(3185, [$62,$22,$95,$40,$97,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsubadd132pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3186, [$62,$62,$95,$50,$97,$31                           ] , 'vfmsubadd132pd  zmm30,zmm29,qword [rcx]{1to8}'    );
  TestCase.testcase(3187, [$62,$62,$95,$40,$97,$72,$7F                       ] , 'vfmsubadd132pd  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(3188, [$62,$62,$95,$40,$97,$B2,$00,$20,$00,$00           ] , 'vfmsubadd132pd  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(3189, [$62,$62,$95,$40,$97,$72,$80                       ] , 'vfmsubadd132pd  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(3190, [$62,$62,$95,$40,$97,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsubadd132pd  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(3191, [$62,$62,$95,$50,$97,$72,$7F                       ] , 'vfmsubadd132pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3192, [$62,$62,$95,$50,$97,$B2,$00,$04,$00,$00           ] , 'vfmsubadd132pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3193, [$62,$62,$95,$50,$97,$72,$80                       ] , 'vfmsubadd132pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3194, [$62,$62,$95,$50,$97,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsubadd132pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3195, [$62,$02,$15,$40,$97,$F4                           ] , 'vfmsubadd132ps  zmm30,zmm29,zmm28'                );
  TestCase.testcase(3196, [$62,$02,$15,$47,$97,$F4                           ] , 'vfmsubadd132ps  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(3197, [$62,$02,$15,$C7,$97,$F4                           ] , 'vfmsubadd132ps  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(3198, [$62,$02,$15,$10,$97,$F4                           ] , 'vfmsubadd132ps  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(3199, [$62,$02,$15,$50,$97,$F4                           ] , 'vfmsubadd132ps  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(3200, [$62,$02,$15,$30,$97,$F4                           ] , 'vfmsubadd132ps  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(3201, [$62,$02,$15,$70,$97,$F4                           ] , 'vfmsubadd132ps  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(3202, [$62,$62,$15,$40,$97,$31                           ] , 'vfmsubadd132ps  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(3203, [$62,$22,$15,$40,$97,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsubadd132ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3204, [$62,$62,$15,$50,$97,$31                           ] , 'vfmsubadd132ps  zmm30,zmm29,dword [rcx]{1to16}'   );
  TestCase.testcase(3205, [$62,$62,$15,$40,$97,$72,$7F                       ] , 'vfmsubadd132ps  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(3206, [$62,$62,$15,$40,$97,$B2,$00,$20,$00,$00           ] , 'vfmsubadd132ps  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(3207, [$62,$62,$15,$40,$97,$72,$80                       ] , 'vfmsubadd132ps  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(3208, [$62,$62,$15,$40,$97,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsubadd132ps  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(3209, [$62,$62,$15,$50,$97,$72,$7F                       ] , 'vfmsubadd132ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3210, [$62,$62,$15,$50,$97,$B2,$00,$02,$00,$00           ] , 'vfmsubadd132ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3211, [$62,$62,$15,$50,$97,$72,$80                       ] , 'vfmsubadd132ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3212, [$62,$62,$15,$50,$97,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsubadd132ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3213, [$62,$02,$95,$40,$A7,$F4                           ] , 'vfmsubadd213pd  zmm30,zmm29,zmm28'                );
  TestCase.testcase(3214, [$62,$02,$95,$47,$A7,$F4                           ] , 'vfmsubadd213pd  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(3215, [$62,$02,$95,$C7,$A7,$F4                           ] , 'vfmsubadd213pd  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(3216, [$62,$02,$95,$10,$A7,$F4                           ] , 'vfmsubadd213pd  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(3217, [$62,$02,$95,$50,$A7,$F4                           ] , 'vfmsubadd213pd  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(3218, [$62,$02,$95,$30,$A7,$F4                           ] , 'vfmsubadd213pd  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(3219, [$62,$02,$95,$70,$A7,$F4                           ] , 'vfmsubadd213pd  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(3220, [$62,$62,$95,$40,$A7,$31                           ] , 'vfmsubadd213pd  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(3221, [$62,$22,$95,$40,$A7,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsubadd213pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3222, [$62,$62,$95,$50,$A7,$31                           ] , 'vfmsubadd213pd  zmm30,zmm29,qword [rcx]{1to8}'    );
  TestCase.testcase(3223, [$62,$62,$95,$40,$A7,$72,$7F                       ] , 'vfmsubadd213pd  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(3224, [$62,$62,$95,$40,$A7,$B2,$00,$20,$00,$00           ] , 'vfmsubadd213pd  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(3225, [$62,$62,$95,$40,$A7,$72,$80                       ] , 'vfmsubadd213pd  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(3226, [$62,$62,$95,$40,$A7,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsubadd213pd  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(3227, [$62,$62,$95,$50,$A7,$72,$7F                       ] , 'vfmsubadd213pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3228, [$62,$62,$95,$50,$A7,$B2,$00,$04,$00,$00           ] , 'vfmsubadd213pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3229, [$62,$62,$95,$50,$A7,$72,$80                       ] , 'vfmsubadd213pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3230, [$62,$62,$95,$50,$A7,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsubadd213pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3231, [$62,$02,$15,$40,$A7,$F4                           ] , 'vfmsubadd213ps  zmm30,zmm29,zmm28'                );
  TestCase.testcase(3232, [$62,$02,$15,$47,$A7,$F4                           ] , 'vfmsubadd213ps  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(3233, [$62,$02,$15,$C7,$A7,$F4                           ] , 'vfmsubadd213ps  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(3234, [$62,$02,$15,$10,$A7,$F4                           ] , 'vfmsubadd213ps  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(3235, [$62,$02,$15,$50,$A7,$F4                           ] , 'vfmsubadd213ps  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(3236, [$62,$02,$15,$30,$A7,$F4                           ] , 'vfmsubadd213ps  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(3237, [$62,$02,$15,$70,$A7,$F4                           ] , 'vfmsubadd213ps  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(3238, [$62,$62,$15,$40,$A7,$31                           ] , 'vfmsubadd213ps  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(3239, [$62,$22,$15,$40,$A7,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsubadd213ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3240, [$62,$62,$15,$50,$A7,$31                           ] , 'vfmsubadd213ps  zmm30,zmm29,dword [rcx]{1to16}'   );
  TestCase.testcase(3241, [$62,$62,$15,$40,$A7,$72,$7F                       ] , 'vfmsubadd213ps  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(3242, [$62,$62,$15,$40,$A7,$B2,$00,$20,$00,$00           ] , 'vfmsubadd213ps  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(3243, [$62,$62,$15,$40,$A7,$72,$80                       ] , 'vfmsubadd213ps  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(3244, [$62,$62,$15,$40,$A7,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsubadd213ps  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(3245, [$62,$62,$15,$50,$A7,$72,$7F                       ] , 'vfmsubadd213ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3246, [$62,$62,$15,$50,$A7,$B2,$00,$02,$00,$00           ] , 'vfmsubadd213ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3247, [$62,$62,$15,$50,$A7,$72,$80                       ] , 'vfmsubadd213ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3248, [$62,$62,$15,$50,$A7,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsubadd213ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3249, [$62,$02,$95,$40,$B7,$F4                           ] , 'vfmsubadd231pd  zmm30,zmm29,zmm28'                );
  TestCase.testcase(3250, [$62,$02,$95,$47,$B7,$F4                           ] , 'vfmsubadd231pd  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(3251, [$62,$02,$95,$C7,$B7,$F4                           ] , 'vfmsubadd231pd  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(3252, [$62,$02,$95,$10,$B7,$F4                           ] , 'vfmsubadd231pd  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(3253, [$62,$02,$95,$50,$B7,$F4                           ] , 'vfmsubadd231pd  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(3254, [$62,$02,$95,$30,$B7,$F4                           ] , 'vfmsubadd231pd  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(3255, [$62,$02,$95,$70,$B7,$F4                           ] , 'vfmsubadd231pd  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(3256, [$62,$62,$95,$40,$B7,$31                           ] , 'vfmsubadd231pd  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(3257, [$62,$22,$95,$40,$B7,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsubadd231pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3258, [$62,$62,$95,$50,$B7,$31                           ] , 'vfmsubadd231pd  zmm30,zmm29,qword [rcx]{1to8}'    );
  TestCase.testcase(3259, [$62,$62,$95,$40,$B7,$72,$7F                       ] , 'vfmsubadd231pd  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(3260, [$62,$62,$95,$40,$B7,$B2,$00,$20,$00,$00           ] , 'vfmsubadd231pd  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(3261, [$62,$62,$95,$40,$B7,$72,$80                       ] , 'vfmsubadd231pd  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(3262, [$62,$62,$95,$40,$B7,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsubadd231pd  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(3263, [$62,$62,$95,$50,$B7,$72,$7F                       ] , 'vfmsubadd231pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3264, [$62,$62,$95,$50,$B7,$B2,$00,$04,$00,$00           ] , 'vfmsubadd231pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3265, [$62,$62,$95,$50,$B7,$72,$80                       ] , 'vfmsubadd231pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3266, [$62,$62,$95,$50,$B7,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsubadd231pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3267, [$62,$02,$15,$40,$B7,$F4                           ] , 'vfmsubadd231ps  zmm30,zmm29,zmm28'                );
  TestCase.testcase(3268, [$62,$02,$15,$47,$B7,$F4                           ] , 'vfmsubadd231ps  zmm30{k7},zmm29,zmm28'            );
  TestCase.testcase(3269, [$62,$02,$15,$C7,$B7,$F4                           ] , 'vfmsubadd231ps  zmm30{k7}{z},zmm29,zmm28'         );
  TestCase.testcase(3270, [$62,$02,$15,$10,$B7,$F4                           ] , 'vfmsubadd231ps  zmm30,zmm29,zmm28,{rn-sae}'       );
  TestCase.testcase(3271, [$62,$02,$15,$50,$B7,$F4                           ] , 'vfmsubadd231ps  zmm30,zmm29,zmm28,{ru-sae}'       );
  TestCase.testcase(3272, [$62,$02,$15,$30,$B7,$F4                           ] , 'vfmsubadd231ps  zmm30,zmm29,zmm28,{rd-sae}'       );
  TestCase.testcase(3273, [$62,$02,$15,$70,$B7,$F4                           ] , 'vfmsubadd231ps  zmm30,zmm29,zmm28,{rz-sae}'       );
  TestCase.testcase(3274, [$62,$62,$15,$40,$B7,$31                           ] , 'vfmsubadd231ps  zmm30,zmm29,zword [rcx]'          );
  TestCase.testcase(3275, [$62,$22,$15,$40,$B7,$B4,$F0,$23,$01,$00,$00       ] , 'vfmsubadd231ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3276, [$62,$62,$15,$50,$B7,$31                           ] , 'vfmsubadd231ps  zmm30,zmm29,dword [rcx]{1to16}'   );
  TestCase.testcase(3277, [$62,$62,$15,$40,$B7,$72,$7F                       ] , 'vfmsubadd231ps  zmm30,zmm29,zword [rdx+0x1fc0]'   );
  TestCase.testcase(3278, [$62,$62,$15,$40,$B7,$B2,$00,$20,$00,$00           ] , 'vfmsubadd231ps  zmm30,zmm29,zword [rdx+0x2000]'   );
  TestCase.testcase(3279, [$62,$62,$15,$40,$B7,$72,$80                       ] , 'vfmsubadd231ps  zmm30,zmm29,zword [rdx-0x2000]'   );
  TestCase.testcase(3280, [$62,$62,$15,$40,$B7,$B2,$C0,$DF,$FF,$FF           ] , 'vfmsubadd231ps  zmm30,zmm29,zword [rdx-0x2040]'   );
  TestCase.testcase(3281, [$62,$62,$15,$50,$B7,$72,$7F                       ] , 'vfmsubadd231ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3282, [$62,$62,$15,$50,$B7,$B2,$00,$02,$00,$00           ] , 'vfmsubadd231ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3283, [$62,$62,$15,$50,$B7,$72,$80                       ] , 'vfmsubadd231ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3284, [$62,$62,$15,$50,$B7,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsubadd231ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3285, [$62,$02,$95,$40,$9C,$F4                           ] , 'vfnmadd132pd  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3286, [$62,$02,$95,$47,$9C,$F4                           ] , 'vfnmadd132pd  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3287, [$62,$02,$95,$C7,$9C,$F4                           ] , 'vfnmadd132pd  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3288, [$62,$02,$95,$10,$9C,$F4                           ] , 'vfnmadd132pd  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3289, [$62,$02,$95,$50,$9C,$F4                           ] , 'vfnmadd132pd  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3290, [$62,$02,$95,$30,$9C,$F4                           ] , 'vfnmadd132pd  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3291, [$62,$02,$95,$70,$9C,$F4                           ] , 'vfnmadd132pd  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3292, [$62,$62,$95,$40,$9C,$31                           ] , 'vfnmadd132pd  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3293, [$62,$22,$95,$40,$9C,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd132pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3294, [$62,$62,$95,$50,$9C,$31                           ] , 'vfnmadd132pd  zmm30,zmm29,qword [rcx]{1to8}'      );
  TestCase.testcase(3295, [$62,$62,$95,$40,$9C,$72,$7F                       ] , 'vfnmadd132pd  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3296, [$62,$62,$95,$40,$9C,$B2,$00,$20,$00,$00           ] , 'vfnmadd132pd  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3297, [$62,$62,$95,$40,$9C,$72,$80                       ] , 'vfnmadd132pd  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3298, [$62,$62,$95,$40,$9C,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmadd132pd  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3299, [$62,$62,$95,$50,$9C,$72,$7F                       ] , 'vfnmadd132pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3300, [$62,$62,$95,$50,$9C,$B2,$00,$04,$00,$00           ] , 'vfnmadd132pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3301, [$62,$62,$95,$50,$9C,$72,$80                       ] , 'vfnmadd132pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3302, [$62,$62,$95,$50,$9C,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd132pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3303, [$62,$02,$15,$40,$9C,$F4                           ] , 'vfnmadd132ps  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3304, [$62,$02,$15,$47,$9C,$F4                           ] , 'vfnmadd132ps  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3305, [$62,$02,$15,$C7,$9C,$F4                           ] , 'vfnmadd132ps  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3306, [$62,$02,$15,$10,$9C,$F4                           ] , 'vfnmadd132ps  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3307, [$62,$02,$15,$50,$9C,$F4                           ] , 'vfnmadd132ps  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3308, [$62,$02,$15,$30,$9C,$F4                           ] , 'vfnmadd132ps  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3309, [$62,$02,$15,$70,$9C,$F4                           ] , 'vfnmadd132ps  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3310, [$62,$62,$15,$40,$9C,$31                           ] , 'vfnmadd132ps  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3311, [$62,$22,$15,$40,$9C,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd132ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3312, [$62,$62,$15,$50,$9C,$31                           ] , 'vfnmadd132ps  zmm30,zmm29,dword [rcx]{1to16}'     );
  TestCase.testcase(3313, [$62,$62,$15,$40,$9C,$72,$7F                       ] , 'vfnmadd132ps  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3314, [$62,$62,$15,$40,$9C,$B2,$00,$20,$00,$00           ] , 'vfnmadd132ps  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3315, [$62,$62,$15,$40,$9C,$72,$80                       ] , 'vfnmadd132ps  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3316, [$62,$62,$15,$40,$9C,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmadd132ps  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3317, [$62,$62,$15,$50,$9C,$72,$7F                       ] , 'vfnmadd132ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3318, [$62,$62,$15,$50,$9C,$B2,$00,$02,$00,$00           ] , 'vfnmadd132ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3319, [$62,$62,$15,$50,$9C,$72,$80                       ] , 'vfnmadd132ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3320, [$62,$62,$15,$50,$9C,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd132ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3321, [$62,$02,$95,$07,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3322, [$62,$02,$95,$87,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3323, [$62,$02,$95,$17,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3324, [$62,$02,$95,$57,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3325, [$62,$02,$95,$37,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3326, [$62,$02,$95,$77,$9D,$F4                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3327, [$62,$62,$95,$07,$9D,$31                           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(3328, [$62,$22,$95,$07,$9D,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3329, [$62,$62,$95,$07,$9D,$72,$7F                       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(3330, [$62,$62,$95,$07,$9D,$B2,$00,$04,$00,$00           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(3331, [$62,$62,$95,$07,$9D,$72,$80                       ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(3332, [$62,$62,$95,$07,$9D,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd132sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(3333, [$62,$02,$15,$07,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3334, [$62,$02,$15,$87,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3335, [$62,$02,$15,$17,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3336, [$62,$02,$15,$57,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3337, [$62,$02,$15,$37,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3338, [$62,$02,$15,$77,$9D,$F4                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3339, [$62,$62,$15,$07,$9D,$31                           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(3340, [$62,$22,$15,$07,$9D,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3341, [$62,$62,$15,$07,$9D,$72,$7F                       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(3342, [$62,$62,$15,$07,$9D,$B2,$00,$02,$00,$00           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(3343, [$62,$62,$15,$07,$9D,$72,$80                       ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(3344, [$62,$62,$15,$07,$9D,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd132ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(3345, [$62,$02,$95,$40,$AC,$F4                           ] , 'vfnmadd213pd  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3346, [$62,$02,$95,$47,$AC,$F4                           ] , 'vfnmadd213pd  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3347, [$62,$02,$95,$C7,$AC,$F4                           ] , 'vfnmadd213pd  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3348, [$62,$02,$95,$10,$AC,$F4                           ] , 'vfnmadd213pd  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3349, [$62,$02,$95,$50,$AC,$F4                           ] , 'vfnmadd213pd  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3350, [$62,$02,$95,$30,$AC,$F4                           ] , 'vfnmadd213pd  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3351, [$62,$02,$95,$70,$AC,$F4                           ] , 'vfnmadd213pd  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3352, [$62,$62,$95,$40,$AC,$31                           ] , 'vfnmadd213pd  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3353, [$62,$22,$95,$40,$AC,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd213pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3354, [$62,$62,$95,$50,$AC,$31                           ] , 'vfnmadd213pd  zmm30,zmm29,qword [rcx]{1to8}'      );
  TestCase.testcase(3355, [$62,$62,$95,$40,$AC,$72,$7F                       ] , 'vfnmadd213pd  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3356, [$62,$62,$95,$40,$AC,$B2,$00,$20,$00,$00           ] , 'vfnmadd213pd  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3357, [$62,$62,$95,$40,$AC,$72,$80                       ] , 'vfnmadd213pd  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3358, [$62,$62,$95,$40,$AC,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmadd213pd  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3359, [$62,$62,$95,$50,$AC,$72,$7F                       ] , 'vfnmadd213pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3360, [$62,$62,$95,$50,$AC,$B2,$00,$04,$00,$00           ] , 'vfnmadd213pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3361, [$62,$62,$95,$50,$AC,$72,$80                       ] , 'vfnmadd213pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3362, [$62,$62,$95,$50,$AC,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd213pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3363, [$62,$02,$15,$40,$AC,$F4                           ] , 'vfnmadd213ps  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3364, [$62,$02,$15,$47,$AC,$F4                           ] , 'vfnmadd213ps  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3365, [$62,$02,$15,$C7,$AC,$F4                           ] , 'vfnmadd213ps  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3366, [$62,$02,$15,$10,$AC,$F4                           ] , 'vfnmadd213ps  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3367, [$62,$02,$15,$50,$AC,$F4                           ] , 'vfnmadd213ps  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3368, [$62,$02,$15,$30,$AC,$F4                           ] , 'vfnmadd213ps  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3369, [$62,$02,$15,$70,$AC,$F4                           ] , 'vfnmadd213ps  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3370, [$62,$62,$15,$40,$AC,$31                           ] , 'vfnmadd213ps  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3371, [$62,$22,$15,$40,$AC,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd213ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3372, [$62,$62,$15,$50,$AC,$31                           ] , 'vfnmadd213ps  zmm30,zmm29,dword [rcx]{1to16}'     );
  TestCase.testcase(3373, [$62,$62,$15,$40,$AC,$72,$7F                       ] , 'vfnmadd213ps  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3374, [$62,$62,$15,$40,$AC,$B2,$00,$20,$00,$00           ] , 'vfnmadd213ps  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3375, [$62,$62,$15,$40,$AC,$72,$80                       ] , 'vfnmadd213ps  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3376, [$62,$62,$15,$40,$AC,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmadd213ps  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3377, [$62,$62,$15,$50,$AC,$72,$7F                       ] , 'vfnmadd213ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3378, [$62,$62,$15,$50,$AC,$B2,$00,$02,$00,$00           ] , 'vfnmadd213ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3379, [$62,$62,$15,$50,$AC,$72,$80                       ] , 'vfnmadd213ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3380, [$62,$62,$15,$50,$AC,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd213ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3381, [$62,$02,$95,$07,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3382, [$62,$02,$95,$87,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3383, [$62,$02,$95,$17,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3384, [$62,$02,$95,$57,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3385, [$62,$02,$95,$37,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3386, [$62,$02,$95,$77,$AD,$F4                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3387, [$62,$62,$95,$07,$AD,$31                           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(3388, [$62,$22,$95,$07,$AD,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3389, [$62,$62,$95,$07,$AD,$72,$7F                       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(3390, [$62,$62,$95,$07,$AD,$B2,$00,$04,$00,$00           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(3391, [$62,$62,$95,$07,$AD,$72,$80                       ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(3392, [$62,$62,$95,$07,$AD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd213sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(3393, [$62,$02,$15,$07,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3394, [$62,$02,$15,$87,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3395, [$62,$02,$15,$17,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3396, [$62,$02,$15,$57,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3397, [$62,$02,$15,$37,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3398, [$62,$02,$15,$77,$AD,$F4                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3399, [$62,$62,$15,$07,$AD,$31                           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(3400, [$62,$22,$15,$07,$AD,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3401, [$62,$62,$15,$07,$AD,$72,$7F                       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(3402, [$62,$62,$15,$07,$AD,$B2,$00,$02,$00,$00           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(3403, [$62,$62,$15,$07,$AD,$72,$80                       ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(3404, [$62,$62,$15,$07,$AD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd213ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(3405, [$62,$02,$95,$40,$BC,$F4                           ] , 'vfnmadd231pd  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3406, [$62,$02,$95,$47,$BC,$F4                           ] , 'vfnmadd231pd  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3407, [$62,$02,$95,$C7,$BC,$F4                           ] , 'vfnmadd231pd  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3408, [$62,$02,$95,$10,$BC,$F4                           ] , 'vfnmadd231pd  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3409, [$62,$02,$95,$50,$BC,$F4                           ] , 'vfnmadd231pd  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3410, [$62,$02,$95,$30,$BC,$F4                           ] , 'vfnmadd231pd  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3411, [$62,$02,$95,$70,$BC,$F4                           ] , 'vfnmadd231pd  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3412, [$62,$62,$95,$40,$BC,$31                           ] , 'vfnmadd231pd  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3413, [$62,$22,$95,$40,$BC,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd231pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3414, [$62,$62,$95,$50,$BC,$31                           ] , 'vfnmadd231pd  zmm30,zmm29,qword [rcx]{1to8}'      );
  TestCase.testcase(3415, [$62,$62,$95,$40,$BC,$72,$7F                       ] , 'vfnmadd231pd  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3416, [$62,$62,$95,$40,$BC,$B2,$00,$20,$00,$00           ] , 'vfnmadd231pd  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3417, [$62,$62,$95,$40,$BC,$72,$80                       ] , 'vfnmadd231pd  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3418, [$62,$62,$95,$40,$BC,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmadd231pd  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3419, [$62,$62,$95,$50,$BC,$72,$7F                       ] , 'vfnmadd231pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3420, [$62,$62,$95,$50,$BC,$B2,$00,$04,$00,$00           ] , 'vfnmadd231pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3421, [$62,$62,$95,$50,$BC,$72,$80                       ] , 'vfnmadd231pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3422, [$62,$62,$95,$50,$BC,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd231pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3423, [$62,$02,$15,$40,$BC,$F4                           ] , 'vfnmadd231ps  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3424, [$62,$02,$15,$47,$BC,$F4                           ] , 'vfnmadd231ps  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3425, [$62,$02,$15,$C7,$BC,$F4                           ] , 'vfnmadd231ps  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3426, [$62,$02,$15,$10,$BC,$F4                           ] , 'vfnmadd231ps  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3427, [$62,$02,$15,$50,$BC,$F4                           ] , 'vfnmadd231ps  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3428, [$62,$02,$15,$30,$BC,$F4                           ] , 'vfnmadd231ps  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3429, [$62,$02,$15,$70,$BC,$F4                           ] , 'vfnmadd231ps  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3430, [$62,$62,$15,$40,$BC,$31                           ] , 'vfnmadd231ps  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3431, [$62,$22,$15,$40,$BC,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd231ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3432, [$62,$62,$15,$50,$BC,$31                           ] , 'vfnmadd231ps  zmm30,zmm29,dword [rcx]{1to16}'     );
  TestCase.testcase(3433, [$62,$62,$15,$40,$BC,$72,$7F                       ] , 'vfnmadd231ps  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3434, [$62,$62,$15,$40,$BC,$B2,$00,$20,$00,$00           ] , 'vfnmadd231ps  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3435, [$62,$62,$15,$40,$BC,$72,$80                       ] , 'vfnmadd231ps  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3436, [$62,$62,$15,$40,$BC,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmadd231ps  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3437, [$62,$62,$15,$50,$BC,$72,$7F                       ] , 'vfnmadd231ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3438, [$62,$62,$15,$50,$BC,$B2,$00,$02,$00,$00           ] , 'vfnmadd231ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3439, [$62,$62,$15,$50,$BC,$72,$80                       ] , 'vfnmadd231ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3440, [$62,$62,$15,$50,$BC,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd231ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3441, [$62,$02,$95,$07,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3442, [$62,$02,$95,$87,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3443, [$62,$02,$95,$17,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3444, [$62,$02,$95,$57,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3445, [$62,$02,$95,$37,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3446, [$62,$02,$95,$77,$BD,$F4                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3447, [$62,$62,$95,$07,$BD,$31                           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(3448, [$62,$22,$95,$07,$BD,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3449, [$62,$62,$95,$07,$BD,$72,$7F                       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(3450, [$62,$62,$95,$07,$BD,$B2,$00,$04,$00,$00           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(3451, [$62,$62,$95,$07,$BD,$72,$80                       ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(3452, [$62,$62,$95,$07,$BD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd231sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(3453, [$62,$02,$15,$07,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3454, [$62,$02,$15,$87,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3455, [$62,$02,$15,$17,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3456, [$62,$02,$15,$57,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3457, [$62,$02,$15,$37,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3458, [$62,$02,$15,$77,$BD,$F4                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3459, [$62,$62,$15,$07,$BD,$31                           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(3460, [$62,$22,$15,$07,$BD,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3461, [$62,$62,$15,$07,$BD,$72,$7F                       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(3462, [$62,$62,$15,$07,$BD,$B2,$00,$02,$00,$00           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(3463, [$62,$62,$15,$07,$BD,$72,$80                       ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(3464, [$62,$62,$15,$07,$BD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd231ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(3465, [$62,$02,$95,$40,$9E,$F4                           ] , 'vfnmsub132pd  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3466, [$62,$02,$95,$47,$9E,$F4                           ] , 'vfnmsub132pd  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3467, [$62,$02,$95,$C7,$9E,$F4                           ] , 'vfnmsub132pd  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3468, [$62,$02,$95,$10,$9E,$F4                           ] , 'vfnmsub132pd  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3469, [$62,$02,$95,$50,$9E,$F4                           ] , 'vfnmsub132pd  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3470, [$62,$02,$95,$30,$9E,$F4                           ] , 'vfnmsub132pd  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3471, [$62,$02,$95,$70,$9E,$F4                           ] , 'vfnmsub132pd  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3472, [$62,$62,$95,$40,$9E,$31                           ] , 'vfnmsub132pd  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3473, [$62,$22,$95,$40,$9E,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub132pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3474, [$62,$62,$95,$50,$9E,$31                           ] , 'vfnmsub132pd  zmm30,zmm29,qword [rcx]{1to8}'      );
  TestCase.testcase(3475, [$62,$62,$95,$40,$9E,$72,$7F                       ] , 'vfnmsub132pd  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3476, [$62,$62,$95,$40,$9E,$B2,$00,$20,$00,$00           ] , 'vfnmsub132pd  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3477, [$62,$62,$95,$40,$9E,$72,$80                       ] , 'vfnmsub132pd  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3478, [$62,$62,$95,$40,$9E,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmsub132pd  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3479, [$62,$62,$95,$50,$9E,$72,$7F                       ] , 'vfnmsub132pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3480, [$62,$62,$95,$50,$9E,$B2,$00,$04,$00,$00           ] , 'vfnmsub132pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3481, [$62,$62,$95,$50,$9E,$72,$80                       ] , 'vfnmsub132pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3482, [$62,$62,$95,$50,$9E,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub132pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3483, [$62,$02,$15,$40,$9E,$F4                           ] , 'vfnmsub132ps  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3484, [$62,$02,$15,$47,$9E,$F4                           ] , 'vfnmsub132ps  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3485, [$62,$02,$15,$C7,$9E,$F4                           ] , 'vfnmsub132ps  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3486, [$62,$02,$15,$10,$9E,$F4                           ] , 'vfnmsub132ps  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3487, [$62,$02,$15,$50,$9E,$F4                           ] , 'vfnmsub132ps  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3488, [$62,$02,$15,$30,$9E,$F4                           ] , 'vfnmsub132ps  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3489, [$62,$02,$15,$70,$9E,$F4                           ] , 'vfnmsub132ps  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3490, [$62,$62,$15,$40,$9E,$31                           ] , 'vfnmsub132ps  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3491, [$62,$22,$15,$40,$9E,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub132ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3492, [$62,$62,$15,$50,$9E,$31                           ] , 'vfnmsub132ps  zmm30,zmm29,dword [rcx]{1to16}'     );
  TestCase.testcase(3493, [$62,$62,$15,$40,$9E,$72,$7F                       ] , 'vfnmsub132ps  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3494, [$62,$62,$15,$40,$9E,$B2,$00,$20,$00,$00           ] , 'vfnmsub132ps  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3495, [$62,$62,$15,$40,$9E,$72,$80                       ] , 'vfnmsub132ps  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3496, [$62,$62,$15,$40,$9E,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmsub132ps  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3497, [$62,$62,$15,$50,$9E,$72,$7F                       ] , 'vfnmsub132ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3498, [$62,$62,$15,$50,$9E,$B2,$00,$02,$00,$00           ] , 'vfnmsub132ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3499, [$62,$62,$15,$50,$9E,$72,$80                       ] , 'vfnmsub132ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3500, [$62,$62,$15,$50,$9E,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub132ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3501, [$62,$02,$95,$07,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3502, [$62,$02,$95,$87,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3503, [$62,$02,$95,$17,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3504, [$62,$02,$95,$57,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3505, [$62,$02,$95,$37,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3506, [$62,$02,$95,$77,$9F,$F4                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3507, [$62,$62,$95,$07,$9F,$31                           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(3508, [$62,$22,$95,$07,$9F,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3509, [$62,$62,$95,$07,$9F,$72,$7F                       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(3510, [$62,$62,$95,$07,$9F,$B2,$00,$04,$00,$00           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(3511, [$62,$62,$95,$07,$9F,$72,$80                       ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(3512, [$62,$62,$95,$07,$9F,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub132sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(3513, [$62,$02,$15,$07,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3514, [$62,$02,$15,$87,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3515, [$62,$02,$15,$17,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3516, [$62,$02,$15,$57,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3517, [$62,$02,$15,$37,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3518, [$62,$02,$15,$77,$9F,$F4                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3519, [$62,$62,$15,$07,$9F,$31                           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(3520, [$62,$22,$15,$07,$9F,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3521, [$62,$62,$15,$07,$9F,$72,$7F                       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(3522, [$62,$62,$15,$07,$9F,$B2,$00,$02,$00,$00           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(3523, [$62,$62,$15,$07,$9F,$72,$80                       ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(3524, [$62,$62,$15,$07,$9F,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub132ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(3525, [$62,$02,$95,$40,$AE,$F4                           ] , 'vfnmsub213pd  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3526, [$62,$02,$95,$47,$AE,$F4                           ] , 'vfnmsub213pd  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3527, [$62,$02,$95,$C7,$AE,$F4                           ] , 'vfnmsub213pd  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3528, [$62,$02,$95,$10,$AE,$F4                           ] , 'vfnmsub213pd  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3529, [$62,$02,$95,$50,$AE,$F4                           ] , 'vfnmsub213pd  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3530, [$62,$02,$95,$30,$AE,$F4                           ] , 'vfnmsub213pd  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3531, [$62,$02,$95,$70,$AE,$F4                           ] , 'vfnmsub213pd  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3532, [$62,$62,$95,$40,$AE,$31                           ] , 'vfnmsub213pd  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3533, [$62,$22,$95,$40,$AE,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub213pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3534, [$62,$62,$95,$50,$AE,$31                           ] , 'vfnmsub213pd  zmm30,zmm29,qword [rcx]{1to8}'      );
  TestCase.testcase(3535, [$62,$62,$95,$40,$AE,$72,$7F                       ] , 'vfnmsub213pd  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3536, [$62,$62,$95,$40,$AE,$B2,$00,$20,$00,$00           ] , 'vfnmsub213pd  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3537, [$62,$62,$95,$40,$AE,$72,$80                       ] , 'vfnmsub213pd  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3538, [$62,$62,$95,$40,$AE,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmsub213pd  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3539, [$62,$62,$95,$50,$AE,$72,$7F                       ] , 'vfnmsub213pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3540, [$62,$62,$95,$50,$AE,$B2,$00,$04,$00,$00           ] , 'vfnmsub213pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3541, [$62,$62,$95,$50,$AE,$72,$80                       ] , 'vfnmsub213pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3542, [$62,$62,$95,$50,$AE,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub213pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3543, [$62,$02,$15,$40,$AE,$F4                           ] , 'vfnmsub213ps  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3544, [$62,$02,$15,$47,$AE,$F4                           ] , 'vfnmsub213ps  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3545, [$62,$02,$15,$C7,$AE,$F4                           ] , 'vfnmsub213ps  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3546, [$62,$02,$15,$10,$AE,$F4                           ] , 'vfnmsub213ps  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3547, [$62,$02,$15,$50,$AE,$F4                           ] , 'vfnmsub213ps  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3548, [$62,$02,$15,$30,$AE,$F4                           ] , 'vfnmsub213ps  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3549, [$62,$02,$15,$70,$AE,$F4                           ] , 'vfnmsub213ps  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3550, [$62,$62,$15,$40,$AE,$31                           ] , 'vfnmsub213ps  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3551, [$62,$22,$15,$40,$AE,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub213ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3552, [$62,$62,$15,$50,$AE,$31                           ] , 'vfnmsub213ps  zmm30,zmm29,dword [rcx]{1to16}'     );
  TestCase.testcase(3553, [$62,$62,$15,$40,$AE,$72,$7F                       ] , 'vfnmsub213ps  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3554, [$62,$62,$15,$40,$AE,$B2,$00,$20,$00,$00           ] , 'vfnmsub213ps  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3555, [$62,$62,$15,$40,$AE,$72,$80                       ] , 'vfnmsub213ps  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3556, [$62,$62,$15,$40,$AE,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmsub213ps  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3557, [$62,$62,$15,$50,$AE,$72,$7F                       ] , 'vfnmsub213ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3558, [$62,$62,$15,$50,$AE,$B2,$00,$02,$00,$00           ] , 'vfnmsub213ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3559, [$62,$62,$15,$50,$AE,$72,$80                       ] , 'vfnmsub213ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3560, [$62,$62,$15,$50,$AE,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub213ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3561, [$62,$02,$95,$07,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3562, [$62,$02,$95,$87,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3563, [$62,$02,$95,$17,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3564, [$62,$02,$95,$57,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3565, [$62,$02,$95,$37,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3566, [$62,$02,$95,$77,$AF,$F4                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3567, [$62,$62,$95,$07,$AF,$31                           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(3568, [$62,$22,$95,$07,$AF,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3569, [$62,$62,$95,$07,$AF,$72,$7F                       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(3570, [$62,$62,$95,$07,$AF,$B2,$00,$04,$00,$00           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(3571, [$62,$62,$95,$07,$AF,$72,$80                       ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(3572, [$62,$62,$95,$07,$AF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub213sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(3573, [$62,$02,$15,$07,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3574, [$62,$02,$15,$87,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3575, [$62,$02,$15,$17,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3576, [$62,$02,$15,$57,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3577, [$62,$02,$15,$37,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3578, [$62,$02,$15,$77,$AF,$F4                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3579, [$62,$62,$15,$07,$AF,$31                           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(3580, [$62,$22,$15,$07,$AF,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3581, [$62,$62,$15,$07,$AF,$72,$7F                       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(3582, [$62,$62,$15,$07,$AF,$B2,$00,$02,$00,$00           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(3583, [$62,$62,$15,$07,$AF,$72,$80                       ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(3584, [$62,$62,$15,$07,$AF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub213ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(3585, [$62,$02,$95,$40,$BE,$F4                           ] , 'vfnmsub231pd  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3586, [$62,$02,$95,$47,$BE,$F4                           ] , 'vfnmsub231pd  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3587, [$62,$02,$95,$C7,$BE,$F4                           ] , 'vfnmsub231pd  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3588, [$62,$02,$95,$10,$BE,$F4                           ] , 'vfnmsub231pd  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3589, [$62,$02,$95,$50,$BE,$F4                           ] , 'vfnmsub231pd  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3590, [$62,$02,$95,$30,$BE,$F4                           ] , 'vfnmsub231pd  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3591, [$62,$02,$95,$70,$BE,$F4                           ] , 'vfnmsub231pd  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3592, [$62,$62,$95,$40,$BE,$31                           ] , 'vfnmsub231pd  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3593, [$62,$22,$95,$40,$BE,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub231pd  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3594, [$62,$62,$95,$50,$BE,$31                           ] , 'vfnmsub231pd  zmm30,zmm29,qword [rcx]{1to8}'      );
  TestCase.testcase(3595, [$62,$62,$95,$40,$BE,$72,$7F                       ] , 'vfnmsub231pd  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3596, [$62,$62,$95,$40,$BE,$B2,$00,$20,$00,$00           ] , 'vfnmsub231pd  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3597, [$62,$62,$95,$40,$BE,$72,$80                       ] , 'vfnmsub231pd  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3598, [$62,$62,$95,$40,$BE,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmsub231pd  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3599, [$62,$62,$95,$50,$BE,$72,$7F                       ] , 'vfnmsub231pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(3600, [$62,$62,$95,$50,$BE,$B2,$00,$04,$00,$00           ] , 'vfnmsub231pd  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(3601, [$62,$62,$95,$50,$BE,$72,$80                       ] , 'vfnmsub231pd  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(3602, [$62,$62,$95,$50,$BE,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub231pd  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(3603, [$62,$02,$15,$40,$BE,$F4                           ] , 'vfnmsub231ps  zmm30,zmm29,zmm28'                  );
  TestCase.testcase(3604, [$62,$02,$15,$47,$BE,$F4                           ] , 'vfnmsub231ps  zmm30{k7},zmm29,zmm28'              );
  TestCase.testcase(3605, [$62,$02,$15,$C7,$BE,$F4                           ] , 'vfnmsub231ps  zmm30{k7}{z},zmm29,zmm28'           );
  TestCase.testcase(3606, [$62,$02,$15,$10,$BE,$F4                           ] , 'vfnmsub231ps  zmm30,zmm29,zmm28,{rn-sae}'         );
  TestCase.testcase(3607, [$62,$02,$15,$50,$BE,$F4                           ] , 'vfnmsub231ps  zmm30,zmm29,zmm28,{ru-sae}'         );
  TestCase.testcase(3608, [$62,$02,$15,$30,$BE,$F4                           ] , 'vfnmsub231ps  zmm30,zmm29,zmm28,{rd-sae}'         );
  TestCase.testcase(3609, [$62,$02,$15,$70,$BE,$F4                           ] , 'vfnmsub231ps  zmm30,zmm29,zmm28,{rz-sae}'         );
  TestCase.testcase(3610, [$62,$62,$15,$40,$BE,$31                           ] , 'vfnmsub231ps  zmm30,zmm29,zword [rcx]'            );
  TestCase.testcase(3611, [$62,$22,$15,$40,$BE,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub231ps  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(3612, [$62,$62,$15,$50,$BE,$31                           ] , 'vfnmsub231ps  zmm30,zmm29,dword [rcx]{1to16}'     );
  TestCase.testcase(3613, [$62,$62,$15,$40,$BE,$72,$7F                       ] , 'vfnmsub231ps  zmm30,zmm29,zword [rdx+0x1fc0]'     );
  TestCase.testcase(3614, [$62,$62,$15,$40,$BE,$B2,$00,$20,$00,$00           ] , 'vfnmsub231ps  zmm30,zmm29,zword [rdx+0x2000]'     );
  TestCase.testcase(3615, [$62,$62,$15,$40,$BE,$72,$80                       ] , 'vfnmsub231ps  zmm30,zmm29,zword [rdx-0x2000]'     );
  TestCase.testcase(3616, [$62,$62,$15,$40,$BE,$B2,$C0,$DF,$FF,$FF           ] , 'vfnmsub231ps  zmm30,zmm29,zword [rdx-0x2040]'     );
  TestCase.testcase(3617, [$62,$62,$15,$50,$BE,$72,$7F                       ] , 'vfnmsub231ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(3618, [$62,$62,$15,$50,$BE,$B2,$00,$02,$00,$00           ] , 'vfnmsub231ps  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(3619, [$62,$62,$15,$50,$BE,$72,$80                       ] , 'vfnmsub231ps  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(3620, [$62,$62,$15,$50,$BE,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub231ps  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(3621, [$62,$02,$95,$07,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3622, [$62,$02,$95,$87,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3623, [$62,$02,$95,$17,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3624, [$62,$02,$95,$57,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3625, [$62,$02,$95,$37,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3626, [$62,$02,$95,$77,$BF,$F4                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3627, [$62,$62,$95,$07,$BF,$31                           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rcx]'        );
  TestCase.testcase(3628, [$62,$22,$95,$07,$BF,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3629, [$62,$62,$95,$07,$BF,$72,$7F                       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'  );
  TestCase.testcase(3630, [$62,$62,$95,$07,$BF,$B2,$00,$04,$00,$00           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx+0x400]'  );
  TestCase.testcase(3631, [$62,$62,$95,$07,$BF,$72,$80                       ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx-0x400]'  );
  TestCase.testcase(3632, [$62,$62,$95,$07,$BF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub231sd  xmm30{k7},xmm29,qword [rdx-0x408]'  );
  TestCase.testcase(3633, [$62,$02,$15,$07,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28'              );
  TestCase.testcase(3634, [$62,$02,$15,$87,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7}{z},xmm29,xmm28'           );
  TestCase.testcase(3635, [$62,$02,$15,$17,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rn-sae}'     );
  TestCase.testcase(3636, [$62,$02,$15,$57,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{ru-sae}'     );
  TestCase.testcase(3637, [$62,$02,$15,$37,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rd-sae}'     );
  TestCase.testcase(3638, [$62,$02,$15,$77,$BF,$F4                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,xmm28,{rz-sae}'     );
  TestCase.testcase(3639, [$62,$62,$15,$07,$BF,$31                           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rcx]'        );
  TestCase.testcase(3640, [$62,$22,$15,$07,$BF,$B4,$F0,$23,$01,$00,$00       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3641, [$62,$62,$15,$07,$BF,$72,$7F                       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'  );
  TestCase.testcase(3642, [$62,$62,$15,$07,$BF,$B2,$00,$02,$00,$00           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx+0x200]'  );
  TestCase.testcase(3643, [$62,$62,$15,$07,$BF,$72,$80                       ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx-0x200]'  );
  TestCase.testcase(3644, [$62,$62,$15,$07,$BF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub231ss  xmm30{k7},xmm29,dword [rdx-0x204]'  );
  TestCase.testcase(3645, [$62,$02,$FD,$41,$92,$B4,$FE,$7B,$00,$00,$00       ] , 'vgatherdpd  zmm30{k1},zword [r14+ymm31*8+0x7b]'   );
  TestCase.testcase(3646, [$62,$02,$FD,$41,$92,$B4,$FE,$7B,$00,$00,$00       ] , 'vgatherdpd  zmm30{k1},zword [r14+ymm31*8+0x7b]'   );
  TestCase.testcase(3647, [$62,$02,$FD,$41,$92,$74,$39,$20                   ] , 'vgatherdpd  zmm30{k1},zword [r9+ymm31*1+0x100]'   );
  TestCase.testcase(3648, [$62,$22,$FD,$41,$92,$B4,$B9,$00,$04,$00,$00       ] , 'vgatherdpd  zmm30{k1},zword [rcx+ymm31*4+0x400]'  );
  TestCase.testcase(3649, [$62,$02,$7D,$41,$92,$B4,$FE,$7B,$00,$00,$00       ] , 'vgatherdps  zmm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(3650, [$62,$02,$7D,$41,$92,$B4,$FE,$7B,$00,$00,$00       ] , 'vgatherdps  zmm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(3651, [$62,$02,$7D,$41,$92,$74,$39,$40                   ] , 'vgatherdps  zmm30{k1},zword [r9+zmm31*1+0x100]'   );
  TestCase.testcase(3652, [$62,$22,$7D,$41,$92,$B4,$B9,$00,$04,$00,$00       ] , 'vgatherdps  zmm30{k1},zword [rcx+zmm31*4+0x400]'  );
  TestCase.testcase(3653, [$62,$02,$FD,$41,$93,$B4,$FE,$7B,$00,$00,$00       ] , 'vgatherqpd  zmm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(3654, [$62,$02,$FD,$41,$93,$B4,$FE,$7B,$00,$00,$00       ] , 'vgatherqpd  zmm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(3655, [$62,$02,$FD,$41,$93,$74,$39,$20                   ] , 'vgatherqpd  zmm30{k1},zword [r9+zmm31*1+0x100]'   );
  TestCase.testcase(3656, [$62,$22,$FD,$41,$93,$B4,$B9,$00,$04,$00,$00       ] , 'vgatherqpd  zmm30{k1},zword [rcx+zmm31*4+0x400]'  );
  TestCase.testcase(3657, [$62,$02,$7D,$41,$93,$B4,$FE,$7B,$00,$00,$00       ] , 'vgatherqps  ymm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(3658, [$62,$02,$7D,$41,$93,$B4,$FE,$7B,$00,$00,$00       ] , 'vgatherqps  ymm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(3659, [$62,$02,$7D,$41,$93,$74,$39,$40                   ] , 'vgatherqps  ymm30{k1},zword [r9+zmm31*1+0x200]'   );
  TestCase.testcase(3660, [$62,$22,$7D,$41,$93,$B4,$B9,$00,$04,$00,$00       ] , 'vgatherqps  ymm30{k1},zword [rcx+zmm31*4+0x400]'  );
  TestCase.testcase(3661, [$62,$02,$FD,$48,$42,$F5                           ] , 'vgetexppd  zmm30,zmm29'                           );
  TestCase.testcase(3662, [$62,$02,$FD,$4F,$42,$F5                           ] , 'vgetexppd  zmm30{k7},zmm29'                       );
  TestCase.testcase(3663, [$62,$02,$FD,$CF,$42,$F5                           ] , 'vgetexppd  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(3664, [$62,$02,$FD,$18,$42,$F5                           ] , 'vgetexppd  zmm30,zmm29,{sae}'                     );
  TestCase.testcase(3665, [$62,$62,$FD,$48,$42,$31                           ] , 'vgetexppd  zmm30,zword [rcx]'                     );
  TestCase.testcase(3666, [$62,$22,$FD,$48,$42,$B4,$F0,$23,$01,$00,$00       ] , 'vgetexppd  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(3667, [$62,$62,$FD,$58,$42,$31                           ] , 'vgetexppd  zmm30,qword [rcx]{1to8}'               );
  TestCase.testcase(3668, [$62,$62,$FD,$48,$42,$72,$7F                       ] , 'vgetexppd  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(3669, [$62,$62,$FD,$48,$42,$B2,$00,$20,$00,$00           ] , 'vgetexppd  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(3670, [$62,$62,$FD,$48,$42,$72,$80                       ] , 'vgetexppd  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(3671, [$62,$62,$FD,$48,$42,$B2,$C0,$DF,$FF,$FF           ] , 'vgetexppd  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(3672, [$62,$62,$FD,$58,$42,$72,$7F                       ] , 'vgetexppd  zmm30,qword [rdx+0x3f8]{1to8}'         );
  TestCase.testcase(3673, [$62,$62,$FD,$58,$42,$B2,$00,$04,$00,$00           ] , 'vgetexppd  zmm30,qword [rdx+0x400]{1to8}'         );
  TestCase.testcase(3674, [$62,$62,$FD,$58,$42,$72,$80                       ] , 'vgetexppd  zmm30,qword [rdx-0x400]{1to8}'         );
  TestCase.testcase(3675, [$62,$62,$FD,$58,$42,$B2,$F8,$FB,$FF,$FF           ] , 'vgetexppd  zmm30,qword [rdx-0x408]{1to8}'         );
  TestCase.testcase(3676, [$62,$02,$7D,$48,$42,$F5                           ] , 'vgetexpps  zmm30,zmm29'                           );
  TestCase.testcase(3677, [$62,$02,$7D,$4F,$42,$F5                           ] , 'vgetexpps  zmm30{k7},zmm29'                       );
  TestCase.testcase(3678, [$62,$02,$7D,$CF,$42,$F5                           ] , 'vgetexpps  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(3679, [$62,$02,$7D,$18,$42,$F5                           ] , 'vgetexpps  zmm30,zmm29,{sae}'                     );
  TestCase.testcase(3680, [$62,$62,$7D,$48,$42,$31                           ] , 'vgetexpps  zmm30,zword [rcx]'                     );
  TestCase.testcase(3681, [$62,$22,$7D,$48,$42,$B4,$F0,$23,$01,$00,$00       ] , 'vgetexpps  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(3682, [$62,$62,$7D,$58,$42,$31                           ] , 'vgetexpps  zmm30,dword [rcx]{1to16}'              );
  TestCase.testcase(3683, [$62,$62,$7D,$48,$42,$72,$7F                       ] , 'vgetexpps  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(3684, [$62,$62,$7D,$48,$42,$B2,$00,$20,$00,$00           ] , 'vgetexpps  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(3685, [$62,$62,$7D,$48,$42,$72,$80                       ] , 'vgetexpps  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(3686, [$62,$62,$7D,$48,$42,$B2,$C0,$DF,$FF,$FF           ] , 'vgetexpps  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(3687, [$62,$62,$7D,$58,$42,$72,$7F                       ] , 'vgetexpps  zmm30,dword [rdx+0x1fc]{1to16}'        );
  TestCase.testcase(3688, [$62,$62,$7D,$58,$42,$B2,$00,$02,$00,$00           ] , 'vgetexpps  zmm30,dword [rdx+0x200]{1to16}'        );
  TestCase.testcase(3689, [$62,$62,$7D,$58,$42,$72,$80                       ] , 'vgetexpps  zmm30,dword [rdx-0x200]{1to16}'        );
  TestCase.testcase(3690, [$62,$62,$7D,$58,$42,$B2,$FC,$FD,$FF,$FF           ] , 'vgetexpps  zmm30,dword [rdx-0x204]{1to16}'        );
  TestCase.testcase(3691, [$62,$02,$95,$07,$43,$F4                           ] , 'vgetexpsd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(3692, [$62,$02,$95,$87,$43,$F4                           ] , 'vgetexpsd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(3693, [$62,$02,$95,$17,$43,$F4                           ] , 'vgetexpsd  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(3694, [$62,$62,$95,$07,$43,$31                           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(3695, [$62,$22,$95,$07,$43,$B4,$F0,$23,$01,$00,$00       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(3696, [$62,$62,$95,$07,$43,$72,$7F                       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(3697, [$62,$62,$95,$07,$43,$B2,$00,$04,$00,$00           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(3698, [$62,$62,$95,$07,$43,$72,$80                       ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(3699, [$62,$62,$95,$07,$43,$B2,$F8,$FB,$FF,$FF           ] , 'vgetexpsd  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(3700, [$62,$02,$15,$07,$43,$F4                           ] , 'vgetexpss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(3701, [$62,$02,$15,$87,$43,$F4                           ] , 'vgetexpss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(3702, [$62,$02,$15,$17,$43,$F4                           ] , 'vgetexpss  xmm30{k7},xmm29,xmm28,{sae}'           );
  TestCase.testcase(3703, [$62,$62,$15,$07,$43,$31                           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(3704, [$62,$22,$15,$07,$43,$B4,$F0,$23,$01,$00,$00       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(3705, [$62,$62,$15,$07,$43,$72,$7F                       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(3706, [$62,$62,$15,$07,$43,$B2,$00,$02,$00,$00           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(3707, [$62,$62,$15,$07,$43,$72,$80                       ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(3708, [$62,$62,$15,$07,$43,$B2,$FC,$FD,$FF,$FF           ] , 'vgetexpss  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(3709, [$62,$03,$FD,$48,$26,$F5,$AB                       ] , 'vgetmantpd  zmm30,zmm29,0xab'                     );
  TestCase.testcase(3710, [$62,$03,$FD,$4F,$26,$F5,$AB                       ] , 'vgetmantpd  zmm30{k7},zmm29,0xab'                 );
  TestCase.testcase(3711, [$62,$03,$FD,$CF,$26,$F5,$AB                       ] , 'vgetmantpd  zmm30{k7}{z},zmm29,0xab'              );
  TestCase.testcase(3712, [$62,$03,$FD,$18,$26,$F5,$AB                       ] , 'vgetmantpd  zmm30,zmm29,{sae},0xab'               );
  TestCase.testcase(3713, [$62,$03,$FD,$48,$26,$F5,$7B                       ] , 'vgetmantpd  zmm30,zmm29,0x7b'                     );
  TestCase.testcase(3714, [$62,$03,$FD,$18,$26,$F5,$7B                       ] , 'vgetmantpd  zmm30,zmm29,{sae},0x7b'               );
  TestCase.testcase(3715, [$62,$63,$FD,$48,$26,$31,$7B                       ] , 'vgetmantpd  zmm30,zword [rcx],0x7b'               );
  TestCase.testcase(3716, [$62,$23,$FD,$48,$26,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vgetmantpd  zmm30,zword [rax+r14*8+0x123],0x7b'   );
  TestCase.testcase(3717, [$62,$63,$FD,$58,$26,$31,$7B                       ] , 'vgetmantpd  zmm30,qword [rcx]{1to8},0x7b'         );
  TestCase.testcase(3718, [$62,$63,$FD,$48,$26,$72,$7F,$7B                   ] , 'vgetmantpd  zmm30,zword [rdx+0x1fc0],0x7b'        );
  TestCase.testcase(3719, [$62,$63,$FD,$48,$26,$B2,$00,$20,$00,$00,$7B       ] , 'vgetmantpd  zmm30,zword [rdx+0x2000],0x7b'        );
  TestCase.testcase(3720, [$62,$63,$FD,$48,$26,$72,$80,$7B                   ] , 'vgetmantpd  zmm30,zword [rdx-0x2000],0x7b'        );
  TestCase.testcase(3721, [$62,$63,$FD,$48,$26,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vgetmantpd  zmm30,zword [rdx-0x2040],0x7b'        );
  TestCase.testcase(3722, [$62,$63,$FD,$58,$26,$72,$7F,$7B                   ] , 'vgetmantpd  zmm30,qword [rdx+0x3f8]{1to8},0x7b'   );
  TestCase.testcase(3723, [$62,$63,$FD,$58,$26,$B2,$00,$04,$00,$00,$7B       ] , 'vgetmantpd  zmm30,qword [rdx+0x400]{1to8},0x7b'   );
  TestCase.testcase(3724, [$62,$63,$FD,$58,$26,$72,$80,$7B                   ] , 'vgetmantpd  zmm30,qword [rdx-0x400]{1to8},0x7b'   );
  TestCase.testcase(3725, [$62,$63,$FD,$58,$26,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vgetmantpd  zmm30,qword [rdx-0x408]{1to8},0x7b'   );
  TestCase.testcase(3726, [$62,$03,$7D,$48,$26,$F5,$AB                       ] , 'vgetmantps  zmm30,zmm29,0xab'                     );
  TestCase.testcase(3727, [$62,$03,$7D,$4F,$26,$F5,$AB                       ] , 'vgetmantps  zmm30{k7},zmm29,0xab'                 );
  TestCase.testcase(3728, [$62,$03,$7D,$CF,$26,$F5,$AB                       ] , 'vgetmantps  zmm30{k7}{z},zmm29,0xab'              );
  TestCase.testcase(3729, [$62,$03,$7D,$18,$26,$F5,$AB                       ] , 'vgetmantps  zmm30,zmm29,{sae},0xab'               );
  TestCase.testcase(3730, [$62,$03,$7D,$48,$26,$F5,$7B                       ] , 'vgetmantps  zmm30,zmm29,0x7b'                     );
  TestCase.testcase(3731, [$62,$03,$7D,$18,$26,$F5,$7B                       ] , 'vgetmantps  zmm30,zmm29,{sae},0x7b'               );
  TestCase.testcase(3732, [$62,$63,$7D,$48,$26,$31,$7B                       ] , 'vgetmantps  zmm30,zword [rcx],0x7b'               );
  TestCase.testcase(3733, [$62,$23,$7D,$48,$26,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vgetmantps  zmm30,zword [rax+r14*8+0x123],0x7b'   );
  TestCase.testcase(3734, [$62,$63,$7D,$58,$26,$31,$7B                       ] , 'vgetmantps  zmm30,dword [rcx]{1to16},0x7b'        );
  TestCase.testcase(3735, [$62,$63,$7D,$48,$26,$72,$7F,$7B                   ] , 'vgetmantps  zmm30,zword [rdx+0x1fc0],0x7b'        );
  TestCase.testcase(3736, [$62,$63,$7D,$48,$26,$B2,$00,$20,$00,$00,$7B       ] , 'vgetmantps  zmm30,zword [rdx+0x2000],0x7b'        );
  TestCase.testcase(3737, [$62,$63,$7D,$48,$26,$72,$80,$7B                   ] , 'vgetmantps  zmm30,zword [rdx-0x2000],0x7b'        );
  TestCase.testcase(3738, [$62,$63,$7D,$48,$26,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vgetmantps  zmm30,zword [rdx-0x2040],0x7b'        );
  TestCase.testcase(3739, [$62,$63,$7D,$58,$26,$72,$7F,$7B                   ] , 'vgetmantps  zmm30,dword [rdx+0x1fc]{1to16},0x7b'  );
  TestCase.testcase(3740, [$62,$63,$7D,$58,$26,$B2,$00,$02,$00,$00,$7B       ] , 'vgetmantps  zmm30,dword [rdx+0x200]{1to16},0x7b'  );
  TestCase.testcase(3741, [$62,$63,$7D,$58,$26,$72,$80,$7B                   ] , 'vgetmantps  zmm30,dword [rdx-0x200]{1to16},0x7b'  );
  TestCase.testcase(3742, [$62,$63,$7D,$58,$26,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vgetmantps  zmm30,dword [rdx-0x204]{1to16},0x7b'  );
  TestCase.testcase(3743, [$62,$03,$95,$07,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,0xab'           );
  TestCase.testcase(3744, [$62,$03,$95,$87,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7}{z},xmm29,xmm28,0xab'        );
  TestCase.testcase(3745, [$62,$03,$95,$17,$27,$F4,$AB                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,{sae},0xab'     );
  TestCase.testcase(3746, [$62,$03,$95,$07,$27,$F4,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,0x7b'           );
  TestCase.testcase(3747, [$62,$03,$95,$17,$27,$F4,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,xmm28,{sae},0x7b'     );
  TestCase.testcase(3748, [$62,$63,$95,$07,$27,$31,$7B                       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rcx],0x7b'     );
  TestCase.testcase(3749, [$62,$23,$95,$07,$27,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(3750, [$62,$63,$95,$07,$27,$72,$7F,$7B                   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(3751, [$62,$63,$95,$07,$27,$B2,$00,$04,$00,$00,$7B       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(3752, [$62,$63,$95,$07,$27,$72,$80,$7B                   ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(3753, [$62,$63,$95,$07,$27,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vgetmantsd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(3754, [$62,$03,$15,$07,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,0xab'           );
  TestCase.testcase(3755, [$62,$03,$15,$87,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7}{z},xmm29,xmm28,0xab'        );
  TestCase.testcase(3756, [$62,$03,$15,$17,$27,$F4,$AB                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,{sae},0xab'     );
  TestCase.testcase(3757, [$62,$03,$15,$07,$27,$F4,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,0x7b'           );
  TestCase.testcase(3758, [$62,$03,$15,$17,$27,$F4,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,xmm28,{sae},0x7b'     );
  TestCase.testcase(3759, [$62,$63,$15,$07,$27,$31,$7B                       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rcx],0x7b'     );
  TestCase.testcase(3760, [$62,$23,$15,$07,$27,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(3761, [$62,$63,$15,$07,$27,$72,$7F,$7B                   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(3762, [$62,$63,$15,$07,$27,$B2,$00,$02,$00,$00,$7B       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(3763, [$62,$63,$15,$07,$27,$72,$80,$7B                   ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(3764, [$62,$63,$15,$07,$27,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vgetmantss  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.testcase(3765, [$62,$03,$15,$47,$18,$F4,$AB                       ] , 'vinsertf32x4  zmm30{k7},zmm29,xmm28,0xab'         );
  TestCase.testcase(3766, [$62,$03,$15,$C7,$18,$F4,$AB                       ] , 'vinsertf32x4  zmm30{k7}{z},zmm29,xmm28,0xab'      );
  TestCase.testcase(3767, [$62,$03,$15,$47,$18,$F4,$7B                       ] , 'vinsertf32x4  zmm30{k7},zmm29,xmm28,0x7b'         );
  TestCase.testcase(3768, [$62,$63,$15,$47,$18,$31,$7B                       ] , 'vinsertf32x4  zmm30{k7},zmm29,oword [rcx],0x7b'   );
  TestCase.testcase(3769, [$62,$23,$15,$47,$18,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vinsertf32x4  zmm30{k7},zmm29,oword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(3770, [$62,$63,$15,$47,$18,$72,$7F,$7B                   ] , 'vinsertf32x4  zmm30{k7},zmm29,oword [rdx+0x7f0],0x7b' );
  TestCase.testcase(3771, [$62,$63,$15,$47,$18,$B2,$00,$08,$00,$00,$7B       ] , 'vinsertf32x4  zmm30{k7},zmm29,oword [rdx+0x800],0x7b' );
  TestCase.testcase(3772, [$62,$63,$15,$47,$18,$72,$80,$7B                   ] , 'vinsertf32x4  zmm30{k7},zmm29,oword [rdx-0x800],0x7b' );
  TestCase.testcase(3773, [$62,$63,$15,$47,$18,$B2,$F0,$F7,$FF,$FF,$7B       ] , 'vinsertf32x4  zmm30{k7},zmm29,oword [rdx-0x810],0x7b' );
  TestCase.testcase(3774, [$62,$03,$95,$47,$1A,$F4,$AB                       ] , 'vinsertf64x4  zmm30{k7},zmm29,ymm28,0xab'         );
  TestCase.testcase(3775, [$62,$03,$95,$C7,$1A,$F4,$AB                       ] , 'vinsertf64x4  zmm30{k7}{z},zmm29,ymm28,0xab'      );
  TestCase.testcase(3776, [$62,$03,$95,$47,$1A,$F4,$7B                       ] , 'vinsertf64x4  zmm30{k7},zmm29,ymm28,0x7b'         );
  TestCase.testcase(3777, [$62,$63,$95,$47,$1A,$31,$7B                       ] , 'vinsertf64x4  zmm30{k7},zmm29,yword [rcx],0x7b'   );
  TestCase.testcase(3778, [$62,$23,$95,$47,$1A,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vinsertf64x4  zmm30{k7},zmm29,yword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(3779, [$62,$63,$95,$47,$1A,$72,$7F,$7B                   ] , 'vinsertf64x4  zmm30{k7},zmm29,yword [rdx+0xfe0],0x7b' );
  TestCase.testcase(3780, [$62,$63,$95,$47,$1A,$B2,$00,$10,$00,$00,$7B       ] , 'vinsertf64x4  zmm30{k7},zmm29,yword [rdx+0x1000],0x7b' );
  TestCase.testcase(3781, [$62,$63,$95,$47,$1A,$72,$80,$7B                   ] , 'vinsertf64x4  zmm30{k7},zmm29,yword [rdx-0x1000],0x7b' );
  TestCase.testcase(3782, [$62,$63,$95,$47,$1A,$B2,$E0,$EF,$FF,$FF,$7B       ] , 'vinsertf64x4  zmm30{k7},zmm29,yword [rdx-0x1020],0x7b' );
  TestCase.testcase(3783, [$62,$03,$15,$47,$38,$F4,$AB                       ] , 'vinserti32x4  zmm30{k7},zmm29,xmm28,0xab'         );
  TestCase.testcase(3784, [$62,$03,$15,$C7,$38,$F4,$AB                       ] , 'vinserti32x4  zmm30{k7}{z},zmm29,xmm28,0xab'      );
  TestCase.testcase(3785, [$62,$03,$15,$47,$38,$F4,$7B                       ] , 'vinserti32x4  zmm30{k7},zmm29,xmm28,0x7b'         );
  TestCase.testcase(3786, [$62,$63,$15,$47,$38,$31,$7B                       ] , 'vinserti32x4  zmm30{k7},zmm29,oword [rcx],0x7b'   );
  TestCase.testcase(3787, [$62,$23,$15,$47,$38,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vinserti32x4  zmm30{k7},zmm29,oword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(3788, [$62,$63,$15,$47,$38,$72,$7F,$7B                   ] , 'vinserti32x4  zmm30{k7},zmm29,oword [rdx+0x7f0],0x7b' );
  TestCase.testcase(3789, [$62,$63,$15,$47,$38,$B2,$00,$08,$00,$00,$7B       ] , 'vinserti32x4  zmm30{k7},zmm29,oword [rdx+0x800],0x7b' );
  TestCase.testcase(3790, [$62,$63,$15,$47,$38,$72,$80,$7B                   ] , 'vinserti32x4  zmm30{k7},zmm29,oword [rdx-0x800],0x7b' );
  TestCase.testcase(3791, [$62,$63,$15,$47,$38,$B2,$F0,$F7,$FF,$FF,$7B       ] , 'vinserti32x4  zmm30{k7},zmm29,oword [rdx-0x810],0x7b' );
  TestCase.testcase(3792, [$62,$03,$95,$47,$3A,$F4,$AB                       ] , 'vinserti64x4  zmm30{k7},zmm29,ymm28,0xab'         );
  TestCase.testcase(3793, [$62,$03,$95,$C7,$3A,$F4,$AB                       ] , 'vinserti64x4  zmm30{k7}{z},zmm29,ymm28,0xab'      );
  TestCase.testcase(3794, [$62,$03,$95,$47,$3A,$F4,$7B                       ] , 'vinserti64x4  zmm30{k7},zmm29,ymm28,0x7b'         );
  TestCase.testcase(3795, [$62,$63,$95,$47,$3A,$31,$7B                       ] , 'vinserti64x4  zmm30{k7},zmm29,yword [rcx],0x7b'   );
  TestCase.testcase(3796, [$62,$23,$95,$47,$3A,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vinserti64x4  zmm30{k7},zmm29,yword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(3797, [$62,$63,$95,$47,$3A,$72,$7F,$7B                   ] , 'vinserti64x4  zmm30{k7},zmm29,yword [rdx+0xfe0],0x7b' );
  TestCase.testcase(3798, [$62,$63,$95,$47,$3A,$B2,$00,$10,$00,$00,$7B       ] , 'vinserti64x4  zmm30{k7},zmm29,yword [rdx+0x1000],0x7b' );
  TestCase.testcase(3799, [$62,$63,$95,$47,$3A,$72,$80,$7B                   ] , 'vinserti64x4  zmm30{k7},zmm29,yword [rdx-0x1000],0x7b' );
  TestCase.testcase(3800, [$62,$63,$95,$47,$3A,$B2,$E0,$EF,$FF,$FF,$7B       ] , 'vinserti64x4  zmm30{k7},zmm29,yword [rdx-0x1020],0x7b' );
  TestCase.testcase(3801, [$62,$03,$15,$00,$21,$F4,$AB                       ] , 'vinsertps  xmm30,xmm29,xmm28,0xab'                );
  TestCase.testcase(3802, [$62,$03,$15,$00,$21,$F4,$7B                       ] , 'vinsertps  xmm30,xmm29,xmm28,0x7b'                );
  TestCase.testcase(3803, [$62,$63,$15,$00,$21,$31,$7B                       ] , 'vinsertps  xmm30,xmm29,dword [rcx],0x7b'          );
  TestCase.testcase(3804, [$62,$23,$15,$00,$21,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vinsertps  xmm30,xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(3805, [$62,$63,$15,$00,$21,$72,$7F,$7B                   ] , 'vinsertps  xmm30,xmm29,dword [rdx+0x1fc],0x7b'    );
  TestCase.testcase(3806, [$62,$63,$15,$00,$21,$B2,$00,$02,$00,$00,$7B       ] , 'vinsertps  xmm30,xmm29,dword [rdx+0x200],0x7b'    );
  TestCase.testcase(3807, [$62,$63,$15,$00,$21,$72,$80,$7B                   ] , 'vinsertps  xmm30,xmm29,dword [rdx-0x200],0x7b'    );
  TestCase.testcase(3808, [$62,$63,$15,$00,$21,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vinsertps  xmm30,xmm29,dword [rdx-0x204],0x7b'    );
  TestCase.testcase(3809, [$62,$01,$95,$40,$5F,$F4                           ] , 'vmaxpd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(3810, [$62,$01,$95,$47,$5F,$F4                           ] , 'vmaxpd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(3811, [$62,$01,$95,$C7,$5F,$F4                           ] , 'vmaxpd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(3812, [$62,$01,$95,$10,$5F,$F4                           ] , 'vmaxpd  zmm30,zmm29,zmm28,{sae}'                  );
  TestCase.testcase(3813, [$62,$61,$95,$40,$5F,$31                           ] , 'vmaxpd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(3814, [$62,$21,$95,$40,$5F,$B4,$F0,$23,$01,$00,$00       ] , 'vmaxpd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(3815, [$62,$61,$95,$50,$5F,$31                           ] , 'vmaxpd  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(3816, [$62,$61,$95,$40,$5F,$72,$7F                       ] , 'vmaxpd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(3817, [$62,$61,$95,$40,$5F,$B2,$00,$20,$00,$00           ] , 'vmaxpd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(3818, [$62,$61,$95,$40,$5F,$72,$80                       ] , 'vmaxpd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(3819, [$62,$61,$95,$40,$5F,$B2,$C0,$DF,$FF,$FF           ] , 'vmaxpd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(3820, [$62,$61,$95,$50,$5F,$72,$7F                       ] , 'vmaxpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(3821, [$62,$61,$95,$50,$5F,$B2,$00,$04,$00,$00           ] , 'vmaxpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(3822, [$62,$61,$95,$50,$5F,$72,$80                       ] , 'vmaxpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(3823, [$62,$61,$95,$50,$5F,$B2,$F8,$FB,$FF,$FF           ] , 'vmaxpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(3824, [$62,$01,$14,$40,$5F,$F4                           ] , 'vmaxps  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(3825, [$62,$01,$14,$47,$5F,$F4                           ] , 'vmaxps  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(3826, [$62,$01,$14,$C7,$5F,$F4                           ] , 'vmaxps  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(3827, [$62,$01,$14,$10,$5F,$F4                           ] , 'vmaxps  zmm30,zmm29,zmm28,{sae}'                  );
  TestCase.testcase(3828, [$62,$61,$14,$40,$5F,$31                           ] , 'vmaxps  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(3829, [$62,$21,$14,$40,$5F,$B4,$F0,$23,$01,$00,$00       ] , 'vmaxps  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(3830, [$62,$61,$14,$50,$5F,$31                           ] , 'vmaxps  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(3831, [$62,$61,$14,$40,$5F,$72,$7F                       ] , 'vmaxps  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(3832, [$62,$61,$14,$40,$5F,$B2,$00,$20,$00,$00           ] , 'vmaxps  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(3833, [$62,$61,$14,$40,$5F,$72,$80                       ] , 'vmaxps  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(3834, [$62,$61,$14,$40,$5F,$B2,$C0,$DF,$FF,$FF           ] , 'vmaxps  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(3835, [$62,$61,$14,$50,$5F,$72,$7F                       ] , 'vmaxps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(3836, [$62,$61,$14,$50,$5F,$B2,$00,$02,$00,$00           ] , 'vmaxps  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(3837, [$62,$61,$14,$50,$5F,$72,$80                       ] , 'vmaxps  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(3838, [$62,$61,$14,$50,$5F,$B2,$FC,$FD,$FF,$FF           ] , 'vmaxps  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(3839, [$62,$01,$97,$07,$5F,$F4                           ] , 'vmaxsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3840, [$62,$01,$97,$87,$5F,$F4                           ] , 'vmaxsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3841, [$62,$01,$97,$17,$5F,$F4                           ] , 'vmaxsd  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(3842, [$62,$61,$97,$07,$5F,$31                           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(3843, [$62,$21,$97,$07,$5F,$B4,$F0,$23,$01,$00,$00       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(3844, [$62,$61,$97,$07,$5F,$72,$7F                       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(3845, [$62,$61,$97,$07,$5F,$B2,$00,$04,$00,$00           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(3846, [$62,$61,$97,$07,$5F,$72,$80                       ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(3847, [$62,$61,$97,$07,$5F,$B2,$F8,$FB,$FF,$FF           ] , 'vmaxsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(3848, [$62,$01,$16,$07,$5F,$F4                           ] , 'vmaxss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3849, [$62,$01,$16,$87,$5F,$F4                           ] , 'vmaxss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3850, [$62,$01,$16,$17,$5F,$F4                           ] , 'vmaxss  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(3851, [$62,$61,$16,$07,$5F,$31                           ] , 'vmaxss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(3852, [$62,$21,$16,$07,$5F,$B4,$F0,$23,$01,$00,$00       ] , 'vmaxss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(3853, [$62,$61,$16,$07,$5F,$72,$7F                       ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(3854, [$62,$61,$16,$07,$5F,$B2,$00,$02,$00,$00           ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(3855, [$62,$61,$16,$07,$5F,$72,$80                       ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(3856, [$62,$61,$16,$07,$5F,$B2,$FC,$FD,$FF,$FF           ] , 'vmaxss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(3857, [$62,$01,$95,$40,$5D,$F4                           ] , 'vminpd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(3858, [$62,$01,$95,$47,$5D,$F4                           ] , 'vminpd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(3859, [$62,$01,$95,$C7,$5D,$F4                           ] , 'vminpd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(3860, [$62,$01,$95,$10,$5D,$F4                           ] , 'vminpd  zmm30,zmm29,zmm28,{sae}'                  );
  TestCase.testcase(3861, [$62,$61,$95,$40,$5D,$31                           ] , 'vminpd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(3862, [$62,$21,$95,$40,$5D,$B4,$F0,$23,$01,$00,$00       ] , 'vminpd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(3863, [$62,$61,$95,$50,$5D,$31                           ] , 'vminpd  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(3864, [$62,$61,$95,$40,$5D,$72,$7F                       ] , 'vminpd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(3865, [$62,$61,$95,$40,$5D,$B2,$00,$20,$00,$00           ] , 'vminpd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(3866, [$62,$61,$95,$40,$5D,$72,$80                       ] , 'vminpd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(3867, [$62,$61,$95,$40,$5D,$B2,$C0,$DF,$FF,$FF           ] , 'vminpd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(3868, [$62,$61,$95,$50,$5D,$72,$7F                       ] , 'vminpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(3869, [$62,$61,$95,$50,$5D,$B2,$00,$04,$00,$00           ] , 'vminpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(3870, [$62,$61,$95,$50,$5D,$72,$80                       ] , 'vminpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(3871, [$62,$61,$95,$50,$5D,$B2,$F8,$FB,$FF,$FF           ] , 'vminpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(3872, [$62,$01,$14,$40,$5D,$F4                           ] , 'vminps  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(3873, [$62,$01,$14,$47,$5D,$F4                           ] , 'vminps  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(3874, [$62,$01,$14,$C7,$5D,$F4                           ] , 'vminps  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(3875, [$62,$01,$14,$10,$5D,$F4                           ] , 'vminps  zmm30,zmm29,zmm28,{sae}'                  );
  TestCase.testcase(3876, [$62,$61,$14,$40,$5D,$31                           ] , 'vminps  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(3877, [$62,$21,$14,$40,$5D,$B4,$F0,$23,$01,$00,$00       ] , 'vminps  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(3878, [$62,$61,$14,$50,$5D,$31                           ] , 'vminps  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(3879, [$62,$61,$14,$40,$5D,$72,$7F                       ] , 'vminps  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(3880, [$62,$61,$14,$40,$5D,$B2,$00,$20,$00,$00           ] , 'vminps  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(3881, [$62,$61,$14,$40,$5D,$72,$80                       ] , 'vminps  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(3882, [$62,$61,$14,$40,$5D,$B2,$C0,$DF,$FF,$FF           ] , 'vminps  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(3883, [$62,$61,$14,$50,$5D,$72,$7F                       ] , 'vminps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(3884, [$62,$61,$14,$50,$5D,$B2,$00,$02,$00,$00           ] , 'vminps  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(3885, [$62,$61,$14,$50,$5D,$72,$80                       ] , 'vminps  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(3886, [$62,$61,$14,$50,$5D,$B2,$FC,$FD,$FF,$FF           ] , 'vminps  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(3887, [$62,$01,$97,$07,$5D,$F4                           ] , 'vminsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3888, [$62,$01,$97,$87,$5D,$F4                           ] , 'vminsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3889, [$62,$01,$97,$17,$5D,$F4                           ] , 'vminsd  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(3890, [$62,$61,$97,$07,$5D,$31                           ] , 'vminsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(3891, [$62,$21,$97,$07,$5D,$B4,$F0,$23,$01,$00,$00       ] , 'vminsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(3892, [$62,$61,$97,$07,$5D,$72,$7F                       ] , 'vminsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(3893, [$62,$61,$97,$07,$5D,$B2,$00,$04,$00,$00           ] , 'vminsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(3894, [$62,$61,$97,$07,$5D,$72,$80                       ] , 'vminsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(3895, [$62,$61,$97,$07,$5D,$B2,$F8,$FB,$FF,$FF           ] , 'vminsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(3896, [$62,$01,$16,$07,$5D,$F4                           ] , 'vminss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(3897, [$62,$01,$16,$87,$5D,$F4                           ] , 'vminss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(3898, [$62,$01,$16,$17,$5D,$F4                           ] , 'vminss  xmm30{k7},xmm29,xmm28,{sae}'              );
  TestCase.testcase(3899, [$62,$61,$16,$07,$5D,$31                           ] , 'vminss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(3900, [$62,$21,$16,$07,$5D,$B4,$F0,$23,$01,$00,$00       ] , 'vminss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(3901, [$62,$61,$16,$07,$5D,$72,$7F                       ] , 'vminss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(3902, [$62,$61,$16,$07,$5D,$B2,$00,$02,$00,$00           ] , 'vminss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(3903, [$62,$61,$16,$07,$5D,$72,$80                       ] , 'vminss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(3904, [$62,$61,$16,$07,$5D,$B2,$FC,$FD,$FF,$FF           ] , 'vminss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(3905, [$62,$01,$FD,$48,$28,$F5                           ] , 'vmovapd  zmm30,zmm29'                             );
  TestCase.testcase(3906, [$62,$01,$FD,$4F,$28,$F5                           ] , 'vmovapd  zmm30{k7},zmm29'                         );
  TestCase.testcase(3907, [$62,$01,$FD,$CF,$28,$F5                           ] , 'vmovapd  zmm30{k7}{z},zmm29'                      );
  TestCase.testcase(3908, [$62,$61,$FD,$48,$28,$31                           ] , 'vmovapd  zmm30,zword [rcx]'                       );
  TestCase.testcase(3909, [$62,$21,$FD,$48,$28,$B4,$F0,$23,$01,$00,$00       ] , 'vmovapd  zmm30,zword [rax+r14*8+0x123]'           );
  TestCase.testcase(3910, [$62,$61,$FD,$48,$28,$72,$7F                       ] , 'vmovapd  zmm30,zword [rdx+0x1fc0]'                );
  TestCase.testcase(3911, [$62,$61,$FD,$48,$28,$B2,$00,$20,$00,$00           ] , 'vmovapd  zmm30,zword [rdx+0x2000]'                );
  TestCase.testcase(3912, [$62,$61,$FD,$48,$28,$72,$80                       ] , 'vmovapd  zmm30,zword [rdx-0x2000]'                );
  TestCase.testcase(3913, [$62,$61,$FD,$48,$28,$B2,$C0,$DF,$FF,$FF           ] , 'vmovapd  zmm30,zword [rdx-0x2040]'                );
  TestCase.testcase(3914, [$62,$01,$7C,$48,$28,$F5                           ] , 'vmovaps  zmm30,zmm29'                             );
  TestCase.testcase(3915, [$62,$01,$7C,$4F,$28,$F5                           ] , 'vmovaps  zmm30{k7},zmm29'                         );
  TestCase.testcase(3916, [$62,$01,$7C,$CF,$28,$F5                           ] , 'vmovaps  zmm30{k7}{z},zmm29'                      );
  TestCase.testcase(3917, [$62,$61,$7C,$48,$28,$31                           ] , 'vmovaps  zmm30,zword [rcx]'                       );
  TestCase.testcase(3918, [$62,$21,$7C,$48,$28,$B4,$F0,$23,$01,$00,$00       ] , 'vmovaps  zmm30,zword [rax+r14*8+0x123]'           );
  TestCase.testcase(3919, [$62,$61,$7C,$48,$28,$72,$7F                       ] , 'vmovaps  zmm30,zword [rdx+0x1fc0]'                );
  TestCase.testcase(3920, [$62,$61,$7C,$48,$28,$B2,$00,$20,$00,$00           ] , 'vmovaps  zmm30,zword [rdx+0x2000]'                );
  TestCase.testcase(3921, [$62,$61,$7C,$48,$28,$72,$80                       ] , 'vmovaps  zmm30,zword [rdx-0x2000]'                );
  TestCase.testcase(3922, [$62,$61,$7C,$48,$28,$B2,$C0,$DF,$FF,$FF           ] , 'vmovaps  zmm30,zword [rdx-0x2040]'                );
  TestCase.testcase(3923, [$62,$61,$7D,$08,$6E,$F0                           ] , 'vmovd  xmm30,eax'                                 );
  TestCase.testcase(3924, [$62,$61,$7D,$08,$6E,$F5                           ] , 'vmovd  xmm30,ebp'                                 );
  TestCase.testcase(3925, [$62,$41,$7D,$08,$6E,$F5                           ] , 'vmovd  xmm30,r13d'                                );
  TestCase.testcase(3926, [$62,$61,$7D,$08,$6E,$31                           ] , 'vmovd  xmm30,dword [rcx]'                         );
  TestCase.testcase(3927, [$62,$21,$7D,$08,$6E,$B4,$F0,$23,$01,$00,$00       ] , 'vmovd  xmm30,dword [rax+r14*8+0x123]'             );
  TestCase.testcase(3928, [$62,$61,$7D,$08,$6E,$72,$7F                       ] , 'vmovd  xmm30,dword [rdx+0x1fc]'                   );
  TestCase.testcase(3929, [$62,$61,$7D,$08,$6E,$B2,$00,$02,$00,$00           ] , 'vmovd  xmm30,dword [rdx+0x200]'                   );
  TestCase.testcase(3930, [$62,$61,$7D,$08,$6E,$72,$80                       ] , 'vmovd  xmm30,dword [rdx-0x200]'                   );
  TestCase.testcase(3931, [$62,$61,$7D,$08,$6E,$B2,$FC,$FD,$FF,$FF           ] , 'vmovd  xmm30,dword [rdx-0x204]'                   );
  TestCase.testcase(3932, [$62,$61,$7D,$08,$7E,$31                           ] , 'vmovd  dword [rcx],xmm30'                         );
  TestCase.testcase(3933, [$62,$21,$7D,$08,$7E,$B4,$F0,$23,$01,$00,$00       ] , 'vmovd  dword [rax+r14*8+0x123],xmm30'             );
  TestCase.testcase(3934, [$62,$61,$7D,$08,$7E,$72,$7F                       ] , 'vmovd  dword [rdx+0x1fc],xmm30'                   );
  TestCase.testcase(3935, [$62,$61,$7D,$08,$7E,$B2,$00,$02,$00,$00           ] , 'vmovd  dword [rdx+0x200],xmm30'                   );
  TestCase.testcase(3936, [$62,$61,$7D,$08,$7E,$72,$80                       ] , 'vmovd  dword [rdx-0x200],xmm30'                   );
  TestCase.testcase(3937, [$62,$61,$7D,$08,$7E,$B2,$FC,$FD,$FF,$FF           ] , 'vmovd  dword [rdx-0x204],xmm30'                   );
  TestCase.testcase(3938, [$62,$01,$FF,$48,$12,$F5                           ] , 'vmovddup  zmm30,zmm29'                            );
  TestCase.testcase(3939, [$62,$01,$FF,$4F,$12,$F5                           ] , 'vmovddup  zmm30{k7},zmm29'                        );
  TestCase.testcase(3940, [$62,$01,$FF,$CF,$12,$F5                           ] , 'vmovddup  zmm30{k7}{z},zmm29'                     );
  TestCase.testcase(3941, [$62,$61,$FF,$48,$12,$31                           ] , 'vmovddup  zmm30,zword [rcx]'                      );
  TestCase.testcase(3942, [$62,$21,$FF,$48,$12,$B4,$F0,$23,$01,$00,$00       ] , 'vmovddup  zmm30,zword [rax+r14*8+0x123]'          );
  TestCase.testcase(3943, [$62,$61,$FF,$48,$12,$72,$7F                       ] , 'vmovddup  zmm30,zword [rdx+0x1fc0]'               );
  TestCase.testcase(3944, [$62,$61,$FF,$48,$12,$B2,$00,$20,$00,$00           ] , 'vmovddup  zmm30,zword [rdx+0x2000]'               );
  TestCase.testcase(3945, [$62,$61,$FF,$48,$12,$72,$80                       ] , 'vmovddup  zmm30,zword [rdx-0x2000]'               );
  TestCase.testcase(3946, [$62,$61,$FF,$48,$12,$B2,$C0,$DF,$FF,$FF           ] , 'vmovddup  zmm30,zword [rdx-0x2040]'               );
  TestCase.testcase(3947, [$62,$01,$7D,$48,$6F,$F5                           ] , 'vmovdqa32  zmm30,zmm29'                           );
  TestCase.testcase(3948, [$62,$01,$7D,$4F,$6F,$F5                           ] , 'vmovdqa32  zmm30{k7},zmm29'                       );
  TestCase.testcase(3949, [$62,$01,$7D,$CF,$6F,$F5                           ] , 'vmovdqa32  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(3950, [$62,$61,$7D,$48,$6F,$31                           ] , 'vmovdqa32  zmm30,zword [rcx]'                     );
  TestCase.testcase(3951, [$62,$21,$7D,$48,$6F,$B4,$F0,$23,$01,$00,$00       ] , 'vmovdqa32  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(3952, [$62,$61,$7D,$48,$6F,$72,$7F                       ] , 'vmovdqa32  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(3953, [$62,$61,$7D,$48,$6F,$B2,$00,$20,$00,$00           ] , 'vmovdqa32  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(3954, [$62,$61,$7D,$48,$6F,$72,$80                       ] , 'vmovdqa32  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(3955, [$62,$61,$7D,$48,$6F,$B2,$C0,$DF,$FF,$FF           ] , 'vmovdqa32  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(3956, [$62,$01,$FD,$48,$6F,$F5                           ] , 'vmovdqa64  zmm30,zmm29'                           );
  TestCase.testcase(3957, [$62,$01,$FD,$4F,$6F,$F5                           ] , 'vmovdqa64  zmm30{k7},zmm29'                       );
  TestCase.testcase(3958, [$62,$01,$FD,$CF,$6F,$F5                           ] , 'vmovdqa64  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(3959, [$62,$61,$FD,$48,$6F,$31                           ] , 'vmovdqa64  zmm30,zword [rcx]'                     );
  TestCase.testcase(3960, [$62,$21,$FD,$48,$6F,$B4,$F0,$23,$01,$00,$00       ] , 'vmovdqa64  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(3961, [$62,$61,$FD,$48,$6F,$72,$7F                       ] , 'vmovdqa64  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(3962, [$62,$61,$FD,$48,$6F,$B2,$00,$20,$00,$00           ] , 'vmovdqa64  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(3963, [$62,$61,$FD,$48,$6F,$72,$80                       ] , 'vmovdqa64  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(3964, [$62,$61,$FD,$48,$6F,$B2,$C0,$DF,$FF,$FF           ] , 'vmovdqa64  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(3965, [$62,$01,$7E,$48,$6F,$F5                           ] , 'vmovdqu32  zmm30,zmm29'                           );
  TestCase.testcase(3966, [$62,$01,$7E,$4F,$6F,$F5                           ] , 'vmovdqu32  zmm30{k7},zmm29'                       );
  TestCase.testcase(3967, [$62,$01,$7E,$CF,$6F,$F5                           ] , 'vmovdqu32  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(3968, [$62,$61,$7E,$48,$6F,$31                           ] , 'vmovdqu32  zmm30,zword [rcx]'                     );
  TestCase.testcase(3969, [$62,$21,$7E,$48,$6F,$B4,$F0,$23,$01,$00,$00       ] , 'vmovdqu32  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(3970, [$62,$61,$7E,$48,$6F,$72,$7F                       ] , 'vmovdqu32  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(3971, [$62,$61,$7E,$48,$6F,$B2,$00,$20,$00,$00           ] , 'vmovdqu32  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(3972, [$62,$61,$7E,$48,$6F,$72,$80                       ] , 'vmovdqu32  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(3973, [$62,$61,$7E,$48,$6F,$B2,$C0,$DF,$FF,$FF           ] , 'vmovdqu32  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(3974, [$62,$01,$FE,$48,$6F,$F5                           ] , 'vmovdqu64  zmm30,zmm29'                           );
  TestCase.testcase(3975, [$62,$01,$FE,$4F,$6F,$F5                           ] , 'vmovdqu64  zmm30{k7},zmm29'                       );
  TestCase.testcase(3976, [$62,$01,$FE,$CF,$6F,$F5                           ] , 'vmovdqu64  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(3977, [$62,$61,$FE,$48,$6F,$31                           ] , 'vmovdqu64  zmm30,zword [rcx]'                     );
  TestCase.testcase(3978, [$62,$21,$FE,$48,$6F,$B4,$F0,$23,$01,$00,$00       ] , 'vmovdqu64  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(3979, [$62,$61,$FE,$48,$6F,$72,$7F                       ] , 'vmovdqu64  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(3980, [$62,$61,$FE,$48,$6F,$B2,$00,$20,$00,$00           ] , 'vmovdqu64  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(3981, [$62,$61,$FE,$48,$6F,$72,$80                       ] , 'vmovdqu64  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(3982, [$62,$61,$FE,$48,$6F,$B2,$C0,$DF,$FF,$FF           ] , 'vmovdqu64  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(3983, [$62,$01,$14,$00,$12,$F4                           ] , 'vmovhlps  xmm30,xmm29,xmm28'                      );
  TestCase.testcase(3984, [$62,$61,$8D,$00,$16,$29                           ] , 'vmovhpd  xmm29,xmm30,qword [rcx]'                 );
  TestCase.testcase(3985, [$62,$21,$8D,$00,$16,$AC,$F0,$23,$01,$00,$00       ] , 'vmovhpd  xmm29,xmm30,qword [rax+r14*8+0x123]'     );
  TestCase.testcase(3986, [$62,$61,$8D,$00,$16,$6A,$7F                       ] , 'vmovhpd  xmm29,xmm30,qword [rdx+0x3f8]'           );
  TestCase.testcase(3987, [$62,$61,$8D,$00,$16,$AA,$00,$04,$00,$00           ] , 'vmovhpd  xmm29,xmm30,qword [rdx+0x400]'           );
  TestCase.testcase(3988, [$62,$61,$8D,$00,$16,$6A,$80                       ] , 'vmovhpd  xmm29,xmm30,qword [rdx-0x400]'           );
  TestCase.testcase(3989, [$62,$61,$8D,$00,$16,$AA,$F8,$FB,$FF,$FF           ] , 'vmovhpd  xmm29,xmm30,qword [rdx-0x408]'           );
  TestCase.testcase(3990, [$62,$61,$FD,$08,$17,$31                           ] , 'vmovhpd  qword [rcx],xmm30'                       );
  TestCase.testcase(3991, [$62,$21,$FD,$08,$17,$B4,$F0,$23,$01,$00,$00       ] , 'vmovhpd  qword [rax+r14*8+0x123],xmm30'           );
  TestCase.testcase(3992, [$62,$61,$FD,$08,$17,$72,$7F                       ] , 'vmovhpd  qword [rdx+0x3f8],xmm30'                 );
  TestCase.testcase(3993, [$62,$61,$FD,$08,$17,$B2,$00,$04,$00,$00           ] , 'vmovhpd  qword [rdx+0x400],xmm30'                 );
  TestCase.testcase(3994, [$62,$61,$FD,$08,$17,$72,$80                       ] , 'vmovhpd  qword [rdx-0x400],xmm30'                 );
  TestCase.testcase(3995, [$62,$61,$FD,$08,$17,$B2,$F8,$FB,$FF,$FF           ] , 'vmovhpd  qword [rdx-0x408],xmm30'                 );
  TestCase.testcase(3996, [$62,$61,$0C,$00,$16,$29                           ] , 'vmovhps  xmm29,xmm30,qword [rcx]'                 );
  TestCase.testcase(3997, [$62,$21,$0C,$00,$16,$AC,$F0,$23,$01,$00,$00       ] , 'vmovhps  xmm29,xmm30,qword [rax+r14*8+0x123]'     );
  TestCase.testcase(3998, [$62,$61,$0C,$00,$16,$6A,$7F                       ] , 'vmovhps  xmm29,xmm30,qword [rdx+0x3f8]'           );
  TestCase.testcase(3999, [$62,$61,$0C,$00,$16,$AA,$00,$04,$00,$00           ] , 'vmovhps  xmm29,xmm30,qword [rdx+0x400]'           );
  TestCase.testcase(4000, [$62,$61,$0C,$00,$16,$6A,$80                       ] , 'vmovhps  xmm29,xmm30,qword [rdx-0x400]'           );
  TestCase.testcase(4001, [$62,$61,$0C,$00,$16,$AA,$F8,$FB,$FF,$FF           ] , 'vmovhps  xmm29,xmm30,qword [rdx-0x408]'           );
  TestCase.testcase(4002, [$62,$61,$7C,$08,$17,$31                           ] , 'vmovhps  qword [rcx],xmm30'                       );
  TestCase.testcase(4003, [$62,$21,$7C,$08,$17,$B4,$F0,$23,$01,$00,$00       ] , 'vmovhps  qword [rax+r14*8+0x123],xmm30'           );
  TestCase.testcase(4004, [$62,$61,$7C,$08,$17,$72,$7F                       ] , 'vmovhps  qword [rdx+0x3f8],xmm30'                 );
  TestCase.testcase(4005, [$62,$61,$7C,$08,$17,$B2,$00,$04,$00,$00           ] , 'vmovhps  qword [rdx+0x400],xmm30'                 );
  TestCase.testcase(4006, [$62,$61,$7C,$08,$17,$72,$80                       ] , 'vmovhps  qword [rdx-0x400],xmm30'                 );
  TestCase.testcase(4007, [$62,$61,$7C,$08,$17,$B2,$F8,$FB,$FF,$FF           ] , 'vmovhps  qword [rdx-0x408],xmm30'                 );
  TestCase.testcase(4008, [$62,$01,$14,$00,$16,$F4                           ] , 'vmovlhps  xmm30,xmm29,xmm28'                      );
  TestCase.testcase(4009, [$62,$61,$8D,$00,$12,$29                           ] , 'vmovlpd  xmm29,xmm30,qword [rcx]'                 );
  TestCase.testcase(4010, [$62,$21,$8D,$00,$12,$AC,$F0,$23,$01,$00,$00       ] , 'vmovlpd  xmm29,xmm30,qword [rax+r14*8+0x123]'     );
  TestCase.testcase(4011, [$62,$61,$8D,$00,$12,$6A,$7F                       ] , 'vmovlpd  xmm29,xmm30,qword [rdx+0x3f8]'           );
  TestCase.testcase(4012, [$62,$61,$8D,$00,$12,$AA,$00,$04,$00,$00           ] , 'vmovlpd  xmm29,xmm30,qword [rdx+0x400]'           );
  TestCase.testcase(4013, [$62,$61,$8D,$00,$12,$6A,$80                       ] , 'vmovlpd  xmm29,xmm30,qword [rdx-0x400]'           );
  TestCase.testcase(4014, [$62,$61,$8D,$00,$12,$AA,$F8,$FB,$FF,$FF           ] , 'vmovlpd  xmm29,xmm30,qword [rdx-0x408]'           );
  TestCase.testcase(4015, [$62,$61,$FD,$08,$13,$31                           ] , 'vmovlpd  qword [rcx],xmm30'                       );
  TestCase.testcase(4016, [$62,$21,$FD,$08,$13,$B4,$F0,$23,$01,$00,$00       ] , 'vmovlpd  qword [rax+r14*8+0x123],xmm30'           );
  TestCase.testcase(4017, [$62,$61,$FD,$08,$13,$72,$7F                       ] , 'vmovlpd  qword [rdx+0x3f8],xmm30'                 );
  TestCase.testcase(4018, [$62,$61,$FD,$08,$13,$B2,$00,$04,$00,$00           ] , 'vmovlpd  qword [rdx+0x400],xmm30'                 );
  TestCase.testcase(4019, [$62,$61,$FD,$08,$13,$72,$80                       ] , 'vmovlpd  qword [rdx-0x400],xmm30'                 );
  TestCase.testcase(4020, [$62,$61,$FD,$08,$13,$B2,$F8,$FB,$FF,$FF           ] , 'vmovlpd  qword [rdx-0x408],xmm30'                 );
  TestCase.testcase(4021, [$62,$61,$0C,$00,$12,$29                           ] , 'vmovlps  xmm29,xmm30,qword [rcx]'                 );
  TestCase.testcase(4022, [$62,$21,$0C,$00,$12,$AC,$F0,$23,$01,$00,$00       ] , 'vmovlps  xmm29,xmm30,qword [rax+r14*8+0x123]'     );
  TestCase.testcase(4023, [$62,$61,$0C,$00,$12,$6A,$7F                       ] , 'vmovlps  xmm29,xmm30,qword [rdx+0x3f8]'           );
  TestCase.testcase(4024, [$62,$61,$0C,$00,$12,$AA,$00,$04,$00,$00           ] , 'vmovlps  xmm29,xmm30,qword [rdx+0x400]'           );
  TestCase.testcase(4025, [$62,$61,$0C,$00,$12,$6A,$80                       ] , 'vmovlps  xmm29,xmm30,qword [rdx-0x400]'           );
  TestCase.testcase(4026, [$62,$61,$0C,$00,$12,$AA,$F8,$FB,$FF,$FF           ] , 'vmovlps  xmm29,xmm30,qword [rdx-0x408]'           );
  TestCase.testcase(4027, [$62,$61,$7C,$08,$13,$31                           ] , 'vmovlps  qword [rcx],xmm30'                       );
  TestCase.testcase(4028, [$62,$21,$7C,$08,$13,$B4,$F0,$23,$01,$00,$00       ] , 'vmovlps  qword [rax+r14*8+0x123],xmm30'           );
  TestCase.testcase(4029, [$62,$61,$7C,$08,$13,$72,$7F                       ] , 'vmovlps  qword [rdx+0x3f8],xmm30'                 );
  TestCase.testcase(4030, [$62,$61,$7C,$08,$13,$B2,$00,$04,$00,$00           ] , 'vmovlps  qword [rdx+0x400],xmm30'                 );
  TestCase.testcase(4031, [$62,$61,$7C,$08,$13,$72,$80                       ] , 'vmovlps  qword [rdx-0x400],xmm30'                 );
  TestCase.testcase(4032, [$62,$61,$7C,$08,$13,$B2,$F8,$FB,$FF,$FF           ] , 'vmovlps  qword [rdx-0x408],xmm30'                 );
  TestCase.testcase(4033, [$62,$61,$7D,$48,$E7,$31                           ] , 'vmovntdq  zword [rcx],zmm30'                      );
  TestCase.testcase(4034, [$62,$21,$7D,$48,$E7,$B4,$F0,$23,$01,$00,$00       ] , 'vmovntdq  zword [rax+r14*8+0x123],zmm30'          );
  TestCase.testcase(4035, [$62,$61,$7D,$48,$E7,$72,$7F                       ] , 'vmovntdq  zword [rdx+0x1fc0],zmm30'               );
  TestCase.testcase(4036, [$62,$61,$7D,$48,$E7,$B2,$00,$20,$00,$00           ] , 'vmovntdq  zword [rdx+0x2000],zmm30'               );
  TestCase.testcase(4037, [$62,$61,$7D,$48,$E7,$72,$80                       ] , 'vmovntdq  zword [rdx-0x2000],zmm30'               );
  TestCase.testcase(4038, [$62,$61,$7D,$48,$E7,$B2,$C0,$DF,$FF,$FF           ] , 'vmovntdq  zword [rdx-0x2040],zmm30'               );
  TestCase.testcase(4039, [$62,$62,$7D,$48,$2A,$31                           ] , 'vmovntdqa  zmm30,zword [rcx]'                     );
  TestCase.testcase(4040, [$62,$22,$7D,$48,$2A,$B4,$F0,$23,$01,$00,$00       ] , 'vmovntdqa  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(4041, [$62,$62,$7D,$48,$2A,$72,$7F                       ] , 'vmovntdqa  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(4042, [$62,$62,$7D,$48,$2A,$B2,$00,$20,$00,$00           ] , 'vmovntdqa  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(4043, [$62,$62,$7D,$48,$2A,$72,$80                       ] , 'vmovntdqa  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(4044, [$62,$62,$7D,$48,$2A,$B2,$C0,$DF,$FF,$FF           ] , 'vmovntdqa  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(4045, [$62,$61,$FD,$48,$2B,$31                           ] , 'vmovntpd  zword [rcx],zmm30'                      );
  TestCase.testcase(4046, [$62,$21,$FD,$48,$2B,$B4,$F0,$23,$01,$00,$00       ] , 'vmovntpd  zword [rax+r14*8+0x123],zmm30'          );
  TestCase.testcase(4047, [$62,$61,$FD,$48,$2B,$72,$7F                       ] , 'vmovntpd  zword [rdx+0x1fc0],zmm30'               );
  TestCase.testcase(4048, [$62,$61,$FD,$48,$2B,$B2,$00,$20,$00,$00           ] , 'vmovntpd  zword [rdx+0x2000],zmm30'               );
  TestCase.testcase(4049, [$62,$61,$FD,$48,$2B,$72,$80                       ] , 'vmovntpd  zword [rdx-0x2000],zmm30'               );
  TestCase.testcase(4050, [$62,$61,$FD,$48,$2B,$B2,$C0,$DF,$FF,$FF           ] , 'vmovntpd  zword [rdx-0x2040],zmm30'               );
  TestCase.testcase(4051, [$62,$61,$7C,$48,$2B,$31                           ] , 'vmovntps  zword [rcx],zmm30'                      );
  TestCase.testcase(4052, [$62,$21,$7C,$48,$2B,$B4,$F0,$23,$01,$00,$00       ] , 'vmovntps  zword [rax+r14*8+0x123],zmm30'          );
  TestCase.testcase(4053, [$62,$61,$7C,$48,$2B,$72,$7F                       ] , 'vmovntps  zword [rdx+0x1fc0],zmm30'               );
  TestCase.testcase(4054, [$62,$61,$7C,$48,$2B,$B2,$00,$20,$00,$00           ] , 'vmovntps  zword [rdx+0x2000],zmm30'               );
  TestCase.testcase(4055, [$62,$61,$7C,$48,$2B,$72,$80                       ] , 'vmovntps  zword [rdx-0x2000],zmm30'               );
  TestCase.testcase(4056, [$62,$61,$7C,$48,$2B,$B2,$C0,$DF,$FF,$FF           ] , 'vmovntps  zword [rdx-0x2040],zmm30'               );
  TestCase.testcase(4057, [$62,$61,$FD,$08,$6E,$F0                           ] , 'vmovq  xmm30,rax'                                 );
  TestCase.testcase(4058, [$62,$41,$FD,$08,$6E,$F0                           ] , 'vmovq  xmm30,r8'                                  );
  TestCase.testcase(4059, [$62,$61,$FD,$08,$6E,$31                           ] , 'vmovq  xmm30,qword [rcx]'                         );
  TestCase.testcase(4060, [$62,$21,$FD,$08,$6E,$B4,$F0,$23,$01,$00,$00       ] , 'vmovq  xmm30,qword [rax+r14*8+0x123]'             );
  TestCase.testcase(4061, [$62,$61,$FD,$08,$6E,$72,$7F                       ] , 'vmovq  xmm30,qword [rdx+0x3f8]'                   );
  TestCase.testcase(4062, [$62,$61,$FD,$08,$6E,$B2,$00,$04,$00,$00           ] , 'vmovq  xmm30,qword [rdx+0x400]'                   );
  TestCase.testcase(4063, [$62,$61,$FD,$08,$6E,$72,$80                       ] , 'vmovq  xmm30,qword [rdx-0x400]'                   );
  TestCase.testcase(4064, [$62,$61,$FD,$08,$6E,$B2,$F8,$FB,$FF,$FF           ] , 'vmovq  xmm30,qword [rdx-0x408]'                   );
  TestCase.testcase(4065, [$62,$61,$FD,$08,$7E,$31                           ] , 'vmovq  qword [rcx],xmm30'                         );
  TestCase.testcase(4066, [$62,$21,$FD,$08,$7E,$B4,$F0,$23,$01,$00,$00       ] , 'vmovq  qword [rax+r14*8+0x123],xmm30'             );
  TestCase.testcase(4067, [$62,$61,$FD,$08,$7E,$72,$7F                       ] , 'vmovq  qword [rdx+0x3f8],xmm30'                   );
  TestCase.testcase(4068, [$62,$61,$FD,$08,$7E,$B2,$00,$04,$00,$00           ] , 'vmovq  qword [rdx+0x400],xmm30'                   );
  TestCase.testcase(4069, [$62,$61,$FD,$08,$7E,$72,$80                       ] , 'vmovq  qword [rdx-0x400],xmm30'                   );
  TestCase.testcase(4070, [$62,$61,$FD,$08,$7E,$B2,$F8,$FB,$FF,$FF           ] , 'vmovq  qword [rdx-0x408],xmm30'                   );
  TestCase.testcase(4071, [$62,$01,$FE,$08,$7E,$F5                           ] , 'vmovq  xmm30,xmm29'                               );
  TestCase.testcase(4072, [$62,$61,$FD,$08,$6E,$31                           ] , 'vmovq  xmm30,qword [rcx]'                         );
  TestCase.testcase(4073, [$62,$21,$FD,$08,$6E,$B4,$F0,$23,$01,$00,$00       ] , 'vmovq  xmm30,qword [rax+r14*8+0x123]'             );
  TestCase.testcase(4074, [$62,$61,$FD,$08,$6E,$72,$7F                       ] , 'vmovq  xmm30,qword [rdx+0x3f8]'                   );
  TestCase.testcase(4075, [$62,$61,$FD,$08,$6E,$B2,$00,$04,$00,$00           ] , 'vmovq  xmm30,qword [rdx+0x400]'                   );
  TestCase.testcase(4076, [$62,$61,$FD,$08,$6E,$72,$80                       ] , 'vmovq  xmm30,qword [rdx-0x400]'                   );
  TestCase.testcase(4077, [$62,$61,$FD,$08,$6E,$B2,$F8,$FB,$FF,$FF           ] , 'vmovq  xmm30,qword [rdx-0x408]'                   );
  TestCase.testcase(4078, [$62,$61,$FD,$08,$7E,$29                           ] , 'vmovq  qword [rcx],xmm29'                         );
  TestCase.testcase(4079, [$62,$21,$FD,$08,$7E,$AC,$F0,$23,$01,$00,$00       ] , 'vmovq  qword [rax+r14*8+0x123],xmm29'             );
  TestCase.testcase(4080, [$62,$61,$FD,$08,$7E,$6A,$7F                       ] , 'vmovq  qword [rdx+0x3f8],xmm29'                   );
  TestCase.testcase(4081, [$62,$61,$FD,$08,$7E,$AA,$00,$04,$00,$00           ] , 'vmovq  qword [rdx+0x400],xmm29'                   );
  TestCase.testcase(4082, [$62,$61,$FD,$08,$7E,$6A,$80                       ] , 'vmovq  qword [rdx-0x400],xmm29'                   );
  TestCase.testcase(4083, [$62,$61,$FD,$08,$7E,$AA,$F8,$FB,$FF,$FF           ] , 'vmovq  qword [rdx-0x408],xmm29'                   );
  TestCase.testcase(4084, [$62,$61,$FF,$0F,$10,$31                           ] , 'vmovsd  xmm30{k7},qword [rcx]'                    );
  TestCase.testcase(4085, [$62,$61,$FF,$8F,$10,$31                           ] , 'vmovsd  xmm30{k7}{z},qword [rcx]'                 );
  TestCase.testcase(4086, [$62,$21,$FF,$0F,$10,$B4,$F0,$23,$01,$00,$00       ] , 'vmovsd  xmm30{k7},qword [rax+r14*8+0x123]'        );
  TestCase.testcase(4087, [$62,$61,$FF,$0F,$10,$72,$7F                       ] , 'vmovsd  xmm30{k7},qword [rdx+0x3f8]'              );
  TestCase.testcase(4088, [$62,$61,$FF,$0F,$10,$B2,$00,$04,$00,$00           ] , 'vmovsd  xmm30{k7},qword [rdx+0x400]'              );
  TestCase.testcase(4089, [$62,$61,$FF,$0F,$10,$72,$80                       ] , 'vmovsd  xmm30{k7},qword [rdx-0x400]'              );
  TestCase.testcase(4090, [$62,$61,$FF,$0F,$10,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  xmm30{k7},qword [rdx-0x408]'              );
  TestCase.testcase(4091, [$62,$61,$FF,$0F,$11,$31                           ] , 'vmovsd  qword [rcx]{k7},xmm30'                    );
  TestCase.testcase(4092, [$62,$21,$FF,$0F,$11,$B4,$F0,$23,$01,$00,$00       ] , 'vmovsd  qword [rax+r14*8+0x123]{k7},xmm30'        );
  TestCase.testcase(4093, [$62,$61,$FF,$0F,$11,$72,$7F                       ] , 'vmovsd  qword [rdx+0x3f8]{k7},xmm30'              );
  TestCase.testcase(4094, [$62,$61,$FF,$0F,$11,$B2,$00,$04,$00,$00           ] , 'vmovsd  qword [rdx+0x400]{k7},xmm30'              );
  TestCase.testcase(4095, [$62,$61,$FF,$0F,$11,$72,$80                       ] , 'vmovsd  qword [rdx-0x400]{k7},xmm30'              );
  TestCase.testcase(4096, [$62,$61,$FF,$0F,$11,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  qword [rdx-0x408]{k7},xmm30'              );
  TestCase.testcase(4097, [$62,$01,$97,$07,$10,$F4                           ] , 'vmovsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(4098, [$62,$01,$97,$87,$10,$F4                           ] , 'vmovsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(4099, [$62,$01,$7E,$48,$16,$F5                           ] , 'vmovshdup  zmm30,zmm29'                           );
  TestCase.testcase(4100, [$62,$01,$7E,$4F,$16,$F5                           ] , 'vmovshdup  zmm30{k7},zmm29'                       );
  TestCase.testcase(4101, [$62,$01,$7E,$CF,$16,$F5                           ] , 'vmovshdup  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(4102, [$62,$61,$7E,$48,$16,$31                           ] , 'vmovshdup  zmm30,zword [rcx]'                     );
  TestCase.testcase(4103, [$62,$21,$7E,$48,$16,$B4,$F0,$23,$01,$00,$00       ] , 'vmovshdup  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(4104, [$62,$61,$7E,$48,$16,$72,$7F                       ] , 'vmovshdup  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(4105, [$62,$61,$7E,$48,$16,$B2,$00,$20,$00,$00           ] , 'vmovshdup  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(4106, [$62,$61,$7E,$48,$16,$72,$80                       ] , 'vmovshdup  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(4107, [$62,$61,$7E,$48,$16,$B2,$C0,$DF,$FF,$FF           ] , 'vmovshdup  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(4108, [$62,$01,$7E,$48,$12,$F5                           ] , 'vmovsldup  zmm30,zmm29'                           );
  TestCase.testcase(4109, [$62,$01,$7E,$4F,$12,$F5                           ] , 'vmovsldup  zmm30{k7},zmm29'                       );
  TestCase.testcase(4110, [$62,$01,$7E,$CF,$12,$F5                           ] , 'vmovsldup  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(4111, [$62,$61,$7E,$48,$12,$31                           ] , 'vmovsldup  zmm30,zword [rcx]'                     );
  TestCase.testcase(4112, [$62,$21,$7E,$48,$12,$B4,$F0,$23,$01,$00,$00       ] , 'vmovsldup  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(4113, [$62,$61,$7E,$48,$12,$72,$7F                       ] , 'vmovsldup  zmm30,zword [rdx+0x1fc0]'              );
  TestCase.testcase(4114, [$62,$61,$7E,$48,$12,$B2,$00,$20,$00,$00           ] , 'vmovsldup  zmm30,zword [rdx+0x2000]'              );
  TestCase.testcase(4115, [$62,$61,$7E,$48,$12,$72,$80                       ] , 'vmovsldup  zmm30,zword [rdx-0x2000]'              );
  TestCase.testcase(4116, [$62,$61,$7E,$48,$12,$B2,$C0,$DF,$FF,$FF           ] , 'vmovsldup  zmm30,zword [rdx-0x2040]'              );
  TestCase.testcase(4117, [$62,$61,$7E,$0F,$10,$31                           ] , 'vmovss  xmm30{k7},dword [rcx]'                    );
  TestCase.testcase(4118, [$62,$61,$7E,$8F,$10,$31                           ] , 'vmovss  xmm30{k7}{z},dword [rcx]'                 );
  TestCase.testcase(4119, [$62,$21,$7E,$0F,$10,$B4,$F0,$23,$01,$00,$00       ] , 'vmovss  xmm30{k7},dword [rax+r14*8+0x123]'        );
  TestCase.testcase(4120, [$62,$61,$7E,$0F,$10,$72,$7F                       ] , 'vmovss  xmm30{k7},dword [rdx+0x1fc]'              );
  TestCase.testcase(4121, [$62,$61,$7E,$0F,$10,$B2,$00,$02,$00,$00           ] , 'vmovss  xmm30{k7},dword [rdx+0x200]'              );
  TestCase.testcase(4122, [$62,$61,$7E,$0F,$10,$72,$80                       ] , 'vmovss  xmm30{k7},dword [rdx-0x200]'              );
  TestCase.testcase(4123, [$62,$61,$7E,$0F,$10,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  xmm30{k7},dword [rdx-0x204]'              );
  TestCase.testcase(4124, [$62,$61,$7E,$0F,$11,$31                           ] , 'vmovss  dword [rcx]{k7},xmm30'                    );
  TestCase.testcase(4125, [$62,$21,$7E,$0F,$11,$B4,$F0,$23,$01,$00,$00       ] , 'vmovss  dword [rax+r14*8+0x123]{k7},xmm30'        );
  TestCase.testcase(4126, [$62,$61,$7E,$0F,$11,$72,$7F                       ] , 'vmovss  dword [rdx+0x1fc]{k7},xmm30'              );
  TestCase.testcase(4127, [$62,$61,$7E,$0F,$11,$B2,$00,$02,$00,$00           ] , 'vmovss  dword [rdx+0x200]{k7},xmm30'              );
  TestCase.testcase(4128, [$62,$61,$7E,$0F,$11,$72,$80                       ] , 'vmovss  dword [rdx-0x200]{k7},xmm30'              );
  TestCase.testcase(4129, [$62,$61,$7E,$0F,$11,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  dword [rdx-0x204]{k7},xmm30'              );
  TestCase.testcase(4130, [$62,$01,$16,$07,$10,$F4                           ] , 'vmovss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(4131, [$62,$01,$16,$87,$10,$F4                           ] , 'vmovss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(4132, [$62,$01,$FD,$48,$10,$F5                           ] , 'vmovupd  zmm30,zmm29'                             );
  TestCase.testcase(4133, [$62,$01,$FD,$4F,$10,$F5                           ] , 'vmovupd  zmm30{k7},zmm29'                         );
  TestCase.testcase(4134, [$62,$01,$FD,$CF,$10,$F5                           ] , 'vmovupd  zmm30{k7}{z},zmm29'                      );
  TestCase.testcase(4135, [$62,$61,$FD,$48,$10,$31                           ] , 'vmovupd  zmm30,zword [rcx]'                       );
  TestCase.testcase(4136, [$62,$21,$FD,$48,$10,$B4,$F0,$23,$01,$00,$00       ] , 'vmovupd  zmm30,zword [rax+r14*8+0x123]'           );
  TestCase.testcase(4137, [$62,$61,$FD,$48,$10,$72,$7F                       ] , 'vmovupd  zmm30,zword [rdx+0x1fc0]'                );
  TestCase.testcase(4138, [$62,$61,$FD,$48,$10,$B2,$00,$20,$00,$00           ] , 'vmovupd  zmm30,zword [rdx+0x2000]'                );
  TestCase.testcase(4139, [$62,$61,$FD,$48,$10,$72,$80                       ] , 'vmovupd  zmm30,zword [rdx-0x2000]'                );
  TestCase.testcase(4140, [$62,$61,$FD,$48,$10,$B2,$C0,$DF,$FF,$FF           ] , 'vmovupd  zmm30,zword [rdx-0x2040]'                );
  TestCase.testcase(4141, [$62,$01,$7C,$48,$10,$F5                           ] , 'vmovups  zmm30,zmm29'                             );
  TestCase.testcase(4142, [$62,$01,$7C,$4F,$10,$F5                           ] , 'vmovups  zmm30{k7},zmm29'                         );
  TestCase.testcase(4143, [$62,$01,$7C,$CF,$10,$F5                           ] , 'vmovups  zmm30{k7}{z},zmm29'                      );
  TestCase.testcase(4144, [$62,$61,$7C,$48,$10,$31                           ] , 'vmovups  zmm30,zword [rcx]'                       );
  TestCase.testcase(4145, [$62,$21,$7C,$48,$10,$B4,$F0,$23,$01,$00,$00       ] , 'vmovups  zmm30,zword [rax+r14*8+0x123]'           );
  TestCase.testcase(4146, [$62,$61,$7C,$48,$10,$72,$7F                       ] , 'vmovups  zmm30,zword [rdx+0x1fc0]'                );
  TestCase.testcase(4147, [$62,$61,$7C,$48,$10,$B2,$00,$20,$00,$00           ] , 'vmovups  zmm30,zword [rdx+0x2000]'                );
  TestCase.testcase(4148, [$62,$61,$7C,$48,$10,$72,$80                       ] , 'vmovups  zmm30,zword [rdx-0x2000]'                );
  TestCase.testcase(4149, [$62,$61,$7C,$48,$10,$B2,$C0,$DF,$FF,$FF           ] , 'vmovups  zmm30,zword [rdx-0x2040]'                );
  TestCase.testcase(4150, [$62,$01,$95,$40,$59,$F4                           ] , 'vmulpd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(4151, [$62,$01,$95,$47,$59,$F4                           ] , 'vmulpd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(4152, [$62,$01,$95,$C7,$59,$F4                           ] , 'vmulpd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(4153, [$62,$01,$95,$10,$59,$F4                           ] , 'vmulpd  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(4154, [$62,$01,$95,$50,$59,$F4                           ] , 'vmulpd  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(4155, [$62,$01,$95,$30,$59,$F4                           ] , 'vmulpd  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(4156, [$62,$01,$95,$70,$59,$F4                           ] , 'vmulpd  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(4157, [$62,$61,$95,$40,$59,$31                           ] , 'vmulpd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(4158, [$62,$21,$95,$40,$59,$B4,$F0,$23,$01,$00,$00       ] , 'vmulpd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4159, [$62,$61,$95,$50,$59,$31                           ] , 'vmulpd  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(4160, [$62,$61,$95,$40,$59,$72,$7F                       ] , 'vmulpd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4161, [$62,$61,$95,$40,$59,$B2,$00,$20,$00,$00           ] , 'vmulpd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(4162, [$62,$61,$95,$40,$59,$72,$80                       ] , 'vmulpd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(4163, [$62,$61,$95,$40,$59,$B2,$C0,$DF,$FF,$FF           ] , 'vmulpd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(4164, [$62,$61,$95,$50,$59,$72,$7F                       ] , 'vmulpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4165, [$62,$61,$95,$50,$59,$B2,$00,$04,$00,$00           ] , 'vmulpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4166, [$62,$61,$95,$50,$59,$72,$80                       ] , 'vmulpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4167, [$62,$61,$95,$50,$59,$B2,$F8,$FB,$FF,$FF           ] , 'vmulpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4168, [$62,$01,$14,$40,$59,$F4                           ] , 'vmulps  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(4169, [$62,$01,$14,$47,$59,$F4                           ] , 'vmulps  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(4170, [$62,$01,$14,$C7,$59,$F4                           ] , 'vmulps  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(4171, [$62,$01,$14,$10,$59,$F4                           ] , 'vmulps  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(4172, [$62,$01,$14,$50,$59,$F4                           ] , 'vmulps  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(4173, [$62,$01,$14,$30,$59,$F4                           ] , 'vmulps  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(4174, [$62,$01,$14,$70,$59,$F4                           ] , 'vmulps  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(4175, [$62,$61,$14,$40,$59,$31                           ] , 'vmulps  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(4176, [$62,$21,$14,$40,$59,$B4,$F0,$23,$01,$00,$00       ] , 'vmulps  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4177, [$62,$61,$14,$50,$59,$31                           ] , 'vmulps  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(4178, [$62,$61,$14,$40,$59,$72,$7F                       ] , 'vmulps  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4179, [$62,$61,$14,$40,$59,$B2,$00,$20,$00,$00           ] , 'vmulps  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(4180, [$62,$61,$14,$40,$59,$72,$80                       ] , 'vmulps  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(4181, [$62,$61,$14,$40,$59,$B2,$C0,$DF,$FF,$FF           ] , 'vmulps  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(4182, [$62,$61,$14,$50,$59,$72,$7F                       ] , 'vmulps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4183, [$62,$61,$14,$50,$59,$B2,$00,$02,$00,$00           ] , 'vmulps  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4184, [$62,$61,$14,$50,$59,$72,$80                       ] , 'vmulps  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4185, [$62,$61,$14,$50,$59,$B2,$FC,$FD,$FF,$FF           ] , 'vmulps  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4186, [$62,$01,$97,$07,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(4187, [$62,$01,$97,$87,$59,$F4                           ] , 'vmulsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(4188, [$62,$01,$97,$17,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(4189, [$62,$01,$97,$57,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(4190, [$62,$01,$97,$37,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(4191, [$62,$01,$97,$77,$59,$F4                           ] , 'vmulsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(4192, [$62,$61,$97,$07,$59,$31                           ] , 'vmulsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(4193, [$62,$21,$97,$07,$59,$B4,$F0,$23,$01,$00,$00       ] , 'vmulsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(4194, [$62,$61,$97,$07,$59,$72,$7F                       ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(4195, [$62,$61,$97,$07,$59,$B2,$00,$04,$00,$00           ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(4196, [$62,$61,$97,$07,$59,$72,$80                       ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(4197, [$62,$61,$97,$07,$59,$B2,$F8,$FB,$FF,$FF           ] , 'vmulsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(4198, [$62,$01,$16,$07,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(4199, [$62,$01,$16,$87,$59,$F4                           ] , 'vmulss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(4200, [$62,$01,$16,$17,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(4201, [$62,$01,$16,$57,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(4202, [$62,$01,$16,$37,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(4203, [$62,$01,$16,$77,$59,$F4                           ] , 'vmulss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(4204, [$62,$61,$16,$07,$59,$31                           ] , 'vmulss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(4205, [$62,$21,$16,$07,$59,$B4,$F0,$23,$01,$00,$00       ] , 'vmulss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(4206, [$62,$61,$16,$07,$59,$72,$7F                       ] , 'vmulss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(4207, [$62,$61,$16,$07,$59,$B2,$00,$02,$00,$00           ] , 'vmulss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(4208, [$62,$61,$16,$07,$59,$72,$80                       ] , 'vmulss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(4209, [$62,$61,$16,$07,$59,$B2,$FC,$FD,$FF,$FF           ] , 'vmulss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(4210, [$62,$02,$7D,$48,$1E,$F5                           ] , 'vpabsd  zmm30,zmm29'                              );
  TestCase.testcase(4211, [$62,$02,$7D,$4F,$1E,$F5                           ] , 'vpabsd  zmm30{k7},zmm29'                          );
  TestCase.testcase(4212, [$62,$02,$7D,$CF,$1E,$F5                           ] , 'vpabsd  zmm30{k7}{z},zmm29'                       );
  TestCase.testcase(4213, [$62,$62,$7D,$48,$1E,$31                           ] , 'vpabsd  zmm30,zword [rcx]'                        );
  TestCase.testcase(4214, [$62,$22,$7D,$48,$1E,$B4,$F0,$23,$01,$00,$00       ] , 'vpabsd  zmm30,zword [rax+r14*8+0x123]'            );
  TestCase.testcase(4215, [$62,$62,$7D,$58,$1E,$31                           ] , 'vpabsd  zmm30,dword [rcx]{1to16}'                 );
  TestCase.testcase(4216, [$62,$62,$7D,$48,$1E,$72,$7F                       ] , 'vpabsd  zmm30,zword [rdx+0x1fc0]'                 );
  TestCase.testcase(4217, [$62,$62,$7D,$48,$1E,$B2,$00,$20,$00,$00           ] , 'vpabsd  zmm30,zword [rdx+0x2000]'                 );
  TestCase.testcase(4218, [$62,$62,$7D,$48,$1E,$72,$80                       ] , 'vpabsd  zmm30,zword [rdx-0x2000]'                 );
  TestCase.testcase(4219, [$62,$62,$7D,$48,$1E,$B2,$C0,$DF,$FF,$FF           ] , 'vpabsd  zmm30,zword [rdx-0x2040]'                 );
  TestCase.testcase(4220, [$62,$62,$7D,$58,$1E,$72,$7F                       ] , 'vpabsd  zmm30,dword [rdx+0x1fc]{1to16}'           );
  TestCase.testcase(4221, [$62,$62,$7D,$58,$1E,$B2,$00,$02,$00,$00           ] , 'vpabsd  zmm30,dword [rdx+0x200]{1to16}'           );
  TestCase.testcase(4222, [$62,$62,$7D,$58,$1E,$72,$80                       ] , 'vpabsd  zmm30,dword [rdx-0x200]{1to16}'           );
  TestCase.testcase(4223, [$62,$62,$7D,$58,$1E,$B2,$FC,$FD,$FF,$FF           ] , 'vpabsd  zmm30,dword [rdx-0x204]{1to16}'           );
  TestCase.testcase(4224, [$62,$02,$FD,$48,$1F,$F5                           ] , 'vpabsq  zmm30,zmm29'                              );
  TestCase.testcase(4225, [$62,$02,$FD,$4F,$1F,$F5                           ] , 'vpabsq  zmm30{k7},zmm29'                          );
  TestCase.testcase(4226, [$62,$02,$FD,$CF,$1F,$F5                           ] , 'vpabsq  zmm30{k7}{z},zmm29'                       );
  TestCase.testcase(4227, [$62,$62,$FD,$48,$1F,$31                           ] , 'vpabsq  zmm30,zword [rcx]'                        );
  TestCase.testcase(4228, [$62,$22,$FD,$48,$1F,$B4,$F0,$23,$01,$00,$00       ] , 'vpabsq  zmm30,zword [rax+r14*8+0x123]'            );
  TestCase.testcase(4229, [$62,$62,$FD,$58,$1F,$31                           ] , 'vpabsq  zmm30,qword [rcx]{1to8}'                  );
  TestCase.testcase(4230, [$62,$62,$FD,$48,$1F,$72,$7F                       ] , 'vpabsq  zmm30,zword [rdx+0x1fc0]'                 );
  TestCase.testcase(4231, [$62,$62,$FD,$48,$1F,$B2,$00,$20,$00,$00           ] , 'vpabsq  zmm30,zword [rdx+0x2000]'                 );
  TestCase.testcase(4232, [$62,$62,$FD,$48,$1F,$72,$80                       ] , 'vpabsq  zmm30,zword [rdx-0x2000]'                 );
  TestCase.testcase(4233, [$62,$62,$FD,$48,$1F,$B2,$C0,$DF,$FF,$FF           ] , 'vpabsq  zmm30,zword [rdx-0x2040]'                 );
  TestCase.testcase(4234, [$62,$62,$FD,$58,$1F,$72,$7F                       ] , 'vpabsq  zmm30,qword [rdx+0x3f8]{1to8}'            );
  TestCase.testcase(4235, [$62,$62,$FD,$58,$1F,$B2,$00,$04,$00,$00           ] , 'vpabsq  zmm30,qword [rdx+0x400]{1to8}'            );
  TestCase.testcase(4236, [$62,$62,$FD,$58,$1F,$72,$80                       ] , 'vpabsq  zmm30,qword [rdx-0x400]{1to8}'            );
  TestCase.testcase(4237, [$62,$62,$FD,$58,$1F,$B2,$F8,$FB,$FF,$FF           ] , 'vpabsq  zmm30,qword [rdx-0x408]{1to8}'            );
  TestCase.testcase(4238, [$62,$01,$15,$40,$FE,$F4                           ] , 'vpaddd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(4239, [$62,$01,$15,$47,$FE,$F4                           ] , 'vpaddd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(4240, [$62,$01,$15,$C7,$FE,$F4                           ] , 'vpaddd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(4241, [$62,$61,$15,$40,$FE,$31                           ] , 'vpaddd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(4242, [$62,$21,$15,$40,$FE,$B4,$F0,$23,$01,$00,$00       ] , 'vpaddd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4243, [$62,$61,$15,$50,$FE,$31                           ] , 'vpaddd  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(4244, [$62,$61,$15,$40,$FE,$72,$7F                       ] , 'vpaddd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4245, [$62,$61,$15,$40,$FE,$B2,$00,$20,$00,$00           ] , 'vpaddd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(4246, [$62,$61,$15,$40,$FE,$72,$80                       ] , 'vpaddd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(4247, [$62,$61,$15,$40,$FE,$B2,$C0,$DF,$FF,$FF           ] , 'vpaddd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(4248, [$62,$61,$15,$50,$FE,$72,$7F                       ] , 'vpaddd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4249, [$62,$61,$15,$50,$FE,$B2,$00,$02,$00,$00           ] , 'vpaddd  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4250, [$62,$61,$15,$50,$FE,$72,$80                       ] , 'vpaddd  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4251, [$62,$61,$15,$50,$FE,$B2,$FC,$FD,$FF,$FF           ] , 'vpaddd  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4252, [$62,$01,$95,$40,$D4,$F4                           ] , 'vpaddq  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(4253, [$62,$01,$95,$47,$D4,$F4                           ] , 'vpaddq  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(4254, [$62,$01,$95,$C7,$D4,$F4                           ] , 'vpaddq  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(4255, [$62,$61,$95,$40,$D4,$31                           ] , 'vpaddq  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(4256, [$62,$21,$95,$40,$D4,$B4,$F0,$23,$01,$00,$00       ] , 'vpaddq  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4257, [$62,$61,$95,$50,$D4,$31                           ] , 'vpaddq  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(4258, [$62,$61,$95,$40,$D4,$72,$7F                       ] , 'vpaddq  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4259, [$62,$61,$95,$40,$D4,$B2,$00,$20,$00,$00           ] , 'vpaddq  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(4260, [$62,$61,$95,$40,$D4,$72,$80                       ] , 'vpaddq  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(4261, [$62,$61,$95,$40,$D4,$B2,$C0,$DF,$FF,$FF           ] , 'vpaddq  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(4262, [$62,$61,$95,$50,$D4,$72,$7F                       ] , 'vpaddq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4263, [$62,$61,$95,$50,$D4,$B2,$00,$04,$00,$00           ] , 'vpaddq  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4264, [$62,$61,$95,$50,$D4,$72,$80                       ] , 'vpaddq  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4265, [$62,$61,$95,$50,$D4,$B2,$F8,$FB,$FF,$FF           ] , 'vpaddq  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4266, [$62,$01,$15,$40,$DB,$F4                           ] , 'vpandd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(4267, [$62,$01,$15,$47,$DB,$F4                           ] , 'vpandd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(4268, [$62,$01,$15,$C7,$DB,$F4                           ] , 'vpandd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(4269, [$62,$61,$15,$40,$DB,$31                           ] , 'vpandd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(4270, [$62,$21,$15,$40,$DB,$B4,$F0,$23,$01,$00,$00       ] , 'vpandd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4271, [$62,$61,$15,$50,$DB,$31                           ] , 'vpandd  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(4272, [$62,$61,$15,$40,$DB,$72,$7F                       ] , 'vpandd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4273, [$62,$61,$15,$40,$DB,$B2,$00,$20,$00,$00           ] , 'vpandd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(4274, [$62,$61,$15,$40,$DB,$72,$80                       ] , 'vpandd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(4275, [$62,$61,$15,$40,$DB,$B2,$C0,$DF,$FF,$FF           ] , 'vpandd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(4276, [$62,$61,$15,$50,$DB,$72,$7F                       ] , 'vpandd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4277, [$62,$61,$15,$50,$DB,$B2,$00,$02,$00,$00           ] , 'vpandd  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4278, [$62,$61,$15,$50,$DB,$72,$80                       ] , 'vpandd  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4279, [$62,$61,$15,$50,$DB,$B2,$FC,$FD,$FF,$FF           ] , 'vpandd  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4280, [$62,$01,$15,$40,$DF,$F4                           ] , 'vpandnd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(4281, [$62,$01,$15,$47,$DF,$F4                           ] , 'vpandnd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(4282, [$62,$01,$15,$C7,$DF,$F4                           ] , 'vpandnd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(4283, [$62,$61,$15,$40,$DF,$31                           ] , 'vpandnd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(4284, [$62,$21,$15,$40,$DF,$B4,$F0,$23,$01,$00,$00       ] , 'vpandnd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4285, [$62,$61,$15,$50,$DF,$31                           ] , 'vpandnd  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(4286, [$62,$61,$15,$40,$DF,$72,$7F                       ] , 'vpandnd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4287, [$62,$61,$15,$40,$DF,$B2,$00,$20,$00,$00           ] , 'vpandnd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(4288, [$62,$61,$15,$40,$DF,$72,$80                       ] , 'vpandnd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(4289, [$62,$61,$15,$40,$DF,$B2,$C0,$DF,$FF,$FF           ] , 'vpandnd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(4290, [$62,$61,$15,$50,$DF,$72,$7F                       ] , 'vpandnd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(4291, [$62,$61,$15,$50,$DF,$B2,$00,$02,$00,$00           ] , 'vpandnd  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(4292, [$62,$61,$15,$50,$DF,$72,$80                       ] , 'vpandnd  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(4293, [$62,$61,$15,$50,$DF,$B2,$FC,$FD,$FF,$FF           ] , 'vpandnd  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(4294, [$62,$01,$95,$40,$DF,$F4                           ] , 'vpandnq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(4295, [$62,$01,$95,$47,$DF,$F4                           ] , 'vpandnq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(4296, [$62,$01,$95,$C7,$DF,$F4                           ] , 'vpandnq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(4297, [$62,$61,$95,$40,$DF,$31                           ] , 'vpandnq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(4298, [$62,$21,$95,$40,$DF,$B4,$F0,$23,$01,$00,$00       ] , 'vpandnq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4299, [$62,$61,$95,$50,$DF,$31                           ] , 'vpandnq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(4300, [$62,$61,$95,$40,$DF,$72,$7F                       ] , 'vpandnq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4301, [$62,$61,$95,$40,$DF,$B2,$00,$20,$00,$00           ] , 'vpandnq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(4302, [$62,$61,$95,$40,$DF,$72,$80                       ] , 'vpandnq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(4303, [$62,$61,$95,$40,$DF,$B2,$C0,$DF,$FF,$FF           ] , 'vpandnq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(4304, [$62,$61,$95,$50,$DF,$72,$7F                       ] , 'vpandnq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(4305, [$62,$61,$95,$50,$DF,$B2,$00,$04,$00,$00           ] , 'vpandnq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(4306, [$62,$61,$95,$50,$DF,$72,$80                       ] , 'vpandnq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(4307, [$62,$61,$95,$50,$DF,$B2,$F8,$FB,$FF,$FF           ] , 'vpandnq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(4308, [$62,$01,$95,$40,$DB,$F4                           ] , 'vpandq  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(4309, [$62,$01,$95,$47,$DB,$F4                           ] , 'vpandq  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(4310, [$62,$01,$95,$C7,$DB,$F4                           ] , 'vpandq  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(4311, [$62,$61,$95,$40,$DB,$31                           ] , 'vpandq  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(4312, [$62,$21,$95,$40,$DB,$B4,$F0,$23,$01,$00,$00       ] , 'vpandq  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4313, [$62,$61,$95,$50,$DB,$31                           ] , 'vpandq  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(4314, [$62,$61,$95,$40,$DB,$72,$7F                       ] , 'vpandq  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4315, [$62,$61,$95,$40,$DB,$B2,$00,$20,$00,$00           ] , 'vpandq  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(4316, [$62,$61,$95,$40,$DB,$72,$80                       ] , 'vpandq  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(4317, [$62,$61,$95,$40,$DB,$B2,$C0,$DF,$FF,$FF           ] , 'vpandq  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(4318, [$62,$61,$95,$50,$DB,$72,$7F                       ] , 'vpandq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4319, [$62,$61,$95,$50,$DB,$B2,$00,$04,$00,$00           ] , 'vpandq  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4320, [$62,$61,$95,$50,$DB,$72,$80                       ] , 'vpandq  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4321, [$62,$61,$95,$50,$DB,$B2,$F8,$FB,$FF,$FF           ] , 'vpandq  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4322, [$62,$02,$15,$40,$64,$F4                           ] , 'vpblendmd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(4323, [$62,$02,$15,$47,$64,$F4                           ] , 'vpblendmd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(4324, [$62,$02,$15,$C7,$64,$F4                           ] , 'vpblendmd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(4325, [$62,$62,$15,$40,$64,$31                           ] , 'vpblendmd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(4326, [$62,$22,$15,$40,$64,$B4,$F0,$23,$01,$00,$00       ] , 'vpblendmd  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(4327, [$62,$62,$15,$50,$64,$31                           ] , 'vpblendmd  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(4328, [$62,$62,$15,$40,$64,$72,$7F                       ] , 'vpblendmd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(4329, [$62,$62,$15,$40,$64,$B2,$00,$20,$00,$00           ] , 'vpblendmd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(4330, [$62,$62,$15,$40,$64,$72,$80                       ] , 'vpblendmd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(4331, [$62,$62,$15,$40,$64,$B2,$C0,$DF,$FF,$FF           ] , 'vpblendmd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(4332, [$62,$62,$15,$50,$64,$72,$7F                       ] , 'vpblendmd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(4333, [$62,$62,$15,$50,$64,$B2,$00,$02,$00,$00           ] , 'vpblendmd  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(4334, [$62,$62,$15,$50,$64,$72,$80                       ] , 'vpblendmd  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(4335, [$62,$62,$15,$50,$64,$B2,$FC,$FD,$FF,$FF           ] , 'vpblendmd  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(4336, [$62,$62,$7D,$48,$58,$31                           ] , 'vpbroadcastd  zmm30,dword [rcx]'                  );
  TestCase.testcase(4337, [$62,$62,$7D,$4F,$58,$31                           ] , 'vpbroadcastd  zmm30{k7},dword [rcx]'              );
  TestCase.testcase(4338, [$62,$62,$7D,$CF,$58,$31                           ] , 'vpbroadcastd  zmm30{k7}{z},dword [rcx]'           );
  TestCase.testcase(4339, [$62,$22,$7D,$48,$58,$B4,$F0,$23,$01,$00,$00       ] , 'vpbroadcastd  zmm30,dword [rax+r14*8+0x123]'      );
  TestCase.testcase(4340, [$62,$62,$7D,$48,$58,$72,$7F                       ] , 'vpbroadcastd  zmm30,dword [rdx+0x1fc]'            );
  TestCase.testcase(4341, [$62,$62,$7D,$48,$58,$B2,$00,$02,$00,$00           ] , 'vpbroadcastd  zmm30,dword [rdx+0x200]'            );
  TestCase.testcase(4342, [$62,$62,$7D,$48,$58,$72,$80                       ] , 'vpbroadcastd  zmm30,dword [rdx-0x200]'            );
  TestCase.testcase(4343, [$62,$62,$7D,$48,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vpbroadcastd  zmm30,dword [rdx-0x204]'            );
  TestCase.testcase(4344, [$62,$02,$7D,$4F,$58,$F5                           ] , 'vpbroadcastd  zmm30{k7},xmm29'                    );
  TestCase.testcase(4345, [$62,$02,$7D,$CF,$58,$F5                           ] , 'vpbroadcastd  zmm30{k7}{z},xmm29'                 );
  TestCase.testcase(4346, [$62,$62,$7D,$48,$7C,$F0                           ] , 'vpbroadcastd  zmm30,eax'                          );
  TestCase.testcase(4347, [$62,$62,$7D,$4F,$7C,$F0                           ] , 'vpbroadcastd  zmm30{k7},eax'                      );
  TestCase.testcase(4348, [$62,$62,$7D,$CF,$7C,$F0                           ] , 'vpbroadcastd  zmm30{k7}{z},eax'                   );
  TestCase.testcase(4349, [$62,$62,$7D,$48,$7C,$F5                           ] , 'vpbroadcastd  zmm30,ebp'                          );
  TestCase.testcase(4350, [$62,$42,$7D,$48,$7C,$F5                           ] , 'vpbroadcastd  zmm30,r13d'                         );
  TestCase.testcase(4351, [$62,$62,$FD,$48,$59,$31                           ] , 'vpbroadcastq  zmm30,qword [rcx]'                  );
  TestCase.testcase(4352, [$62,$62,$FD,$4F,$59,$31                           ] , 'vpbroadcastq  zmm30{k7},qword [rcx]'              );
  TestCase.testcase(4353, [$62,$62,$FD,$CF,$59,$31                           ] , 'vpbroadcastq  zmm30{k7}{z},qword [rcx]'           );
  TestCase.testcase(4354, [$62,$22,$FD,$48,$59,$B4,$F0,$23,$01,$00,$00       ] , 'vpbroadcastq  zmm30,qword [rax+r14*8+0x123]'      );
  TestCase.testcase(4355, [$62,$62,$FD,$48,$59,$72,$7F                       ] , 'vpbroadcastq  zmm30,qword [rdx+0x3f8]'            );
  TestCase.testcase(4356, [$62,$62,$FD,$48,$59,$B2,$00,$04,$00,$00           ] , 'vpbroadcastq  zmm30,qword [rdx+0x400]'            );
  TestCase.testcase(4357, [$62,$62,$FD,$48,$59,$72,$80                       ] , 'vpbroadcastq  zmm30,qword [rdx-0x400]'            );
  TestCase.testcase(4358, [$62,$62,$FD,$48,$59,$B2,$F8,$FB,$FF,$FF           ] , 'vpbroadcastq  zmm30,qword [rdx-0x408]'            );
  TestCase.testcase(4359, [$62,$02,$FD,$4F,$59,$F5                           ] , 'vpbroadcastq  zmm30{k7},xmm29'                    );
  TestCase.testcase(4360, [$62,$02,$FD,$CF,$59,$F5                           ] , 'vpbroadcastq  zmm30{k7}{z},xmm29'                 );
  TestCase.testcase(4361, [$62,$62,$FD,$48,$7C,$F0                           ] , 'vpbroadcastq  zmm30,rax'                          );
  TestCase.testcase(4362, [$62,$62,$FD,$4F,$7C,$F0                           ] , 'vpbroadcastq  zmm30{k7},rax'                      );
  TestCase.testcase(4363, [$62,$62,$FD,$CF,$7C,$F0                           ] , 'vpbroadcastq  zmm30{k7}{z},rax'                   );
  TestCase.testcase(4364, [$62,$42,$FD,$48,$7C,$F0                           ] , 'vpbroadcastq  zmm30,r8'                           );
  TestCase.testcase(4365, [$62,$93,$0D,$40,$1F,$ED,$AB                       ] , 'vpcmpd  k5,zmm30,zmm29,0xab'                      );
  TestCase.testcase(4366, [$62,$93,$0D,$47,$1F,$ED,$AB                       ] , 'vpcmpd  k5{k7},zmm30,zmm29,0xab'                  );
  TestCase.testcase(4367, [$62,$93,$0D,$40,$1F,$ED,$7B                       ] , 'vpcmpd  k5,zmm30,zmm29,0x7b'                      );
  TestCase.testcase(4368, [$62,$F3,$0D,$40,$1F,$29,$7B                       ] , 'vpcmpd  k5,zmm30,zword [rcx],0x7b'                );
  TestCase.testcase(4369, [$62,$B3,$0D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vpcmpd  k5,zmm30,zword [rax+r14*8+0x123],0x7b'    );
  TestCase.testcase(4370, [$62,$F3,$0D,$50,$1F,$29,$7B                       ] , 'vpcmpd  k5,zmm30,dword [rcx]{1to16},0x7b'         );
  TestCase.testcase(4371, [$62,$F3,$0D,$40,$1F,$6A,$7F,$7B                   ] , 'vpcmpd  k5,zmm30,zword [rdx+0x1fc0],0x7b'         );
  TestCase.testcase(4372, [$62,$F3,$0D,$40,$1F,$AA,$00,$20,$00,$00,$7B       ] , 'vpcmpd  k5,zmm30,zword [rdx+0x2000],0x7b'         );
  TestCase.testcase(4373, [$62,$F3,$0D,$40,$1F,$6A,$80,$7B                   ] , 'vpcmpd  k5,zmm30,zword [rdx-0x2000],0x7b'         );
  TestCase.testcase(4374, [$62,$F3,$0D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$7B       ] , 'vpcmpd  k5,zmm30,zword [rdx-0x2040],0x7b'         );
  TestCase.testcase(4375, [$62,$F3,$0D,$50,$1F,$6A,$7F,$7B                   ] , 'vpcmpd  k5,zmm30,dword [rdx+0x1fc]{1to16},0x7b'   );
  TestCase.testcase(4376, [$62,$F3,$0D,$50,$1F,$AA,$00,$02,$00,$00,$7B       ] , 'vpcmpd  k5,zmm30,dword [rdx+0x200]{1to16},0x7b'   );
  TestCase.testcase(4377, [$62,$F3,$0D,$50,$1F,$6A,$80,$7B                   ] , 'vpcmpd  k5,zmm30,dword [rdx-0x200]{1to16},0x7b'   );
  TestCase.testcase(4378, [$62,$F3,$0D,$50,$1F,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vpcmpd  k5,zmm30,dword [rdx-0x204]{1to16},0x7b'   );
  TestCase.testcase(4379, [$62,$93,$0D,$40,$1F,$ED,$01                       ] , 'vpcmpltd  k5,zmm30,zmm29'                         );
  TestCase.testcase(4380, [$62,$93,$0D,$47,$1F,$ED,$01                       ] , 'vpcmpltd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(4381, [$62,$F3,$0D,$40,$1F,$29,$01                       ] , 'vpcmpltd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(4382, [$62,$B3,$0D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vpcmpltd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(4383, [$62,$F3,$0D,$50,$1F,$29,$01                       ] , 'vpcmpltd  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(4384, [$62,$F3,$0D,$40,$1F,$6A,$7F,$01                   ] , 'vpcmpltd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(4385, [$62,$F3,$0D,$40,$1F,$AA,$00,$20,$00,$00,$01       ] , 'vpcmpltd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(4386, [$62,$F3,$0D,$40,$1F,$6A,$80,$01                   ] , 'vpcmpltd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(4387, [$62,$F3,$0D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vpcmpltd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(4388, [$62,$F3,$0D,$50,$1F,$6A,$7F,$01                   ] , 'vpcmpltd  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(4389, [$62,$F3,$0D,$50,$1F,$AA,$00,$02,$00,$00,$01       ] , 'vpcmpltd  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(4390, [$62,$F3,$0D,$50,$1F,$6A,$80,$01                   ] , 'vpcmpltd  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(4391, [$62,$F3,$0D,$50,$1F,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vpcmpltd  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(4392, [$62,$93,$0D,$40,$1F,$ED,$02                       ] , 'vpcmpled  k5,zmm30,zmm29'                         );
  TestCase.testcase(4393, [$62,$93,$0D,$47,$1F,$ED,$02                       ] , 'vpcmpled  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(4394, [$62,$F3,$0D,$40,$1F,$29,$02                       ] , 'vpcmpled  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(4395, [$62,$B3,$0D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vpcmpled  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(4396, [$62,$F3,$0D,$50,$1F,$29,$02                       ] , 'vpcmpled  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(4397, [$62,$F3,$0D,$40,$1F,$6A,$7F,$02                   ] , 'vpcmpled  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(4398, [$62,$F3,$0D,$40,$1F,$AA,$00,$20,$00,$00,$02       ] , 'vpcmpled  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(4399, [$62,$F3,$0D,$40,$1F,$6A,$80,$02                   ] , 'vpcmpled  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(4400, [$62,$F3,$0D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vpcmpled  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(4401, [$62,$F3,$0D,$50,$1F,$6A,$7F,$02                   ] , 'vpcmpled  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(4402, [$62,$F3,$0D,$50,$1F,$AA,$00,$02,$00,$00,$02       ] , 'vpcmpled  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(4403, [$62,$F3,$0D,$50,$1F,$6A,$80,$02                   ] , 'vpcmpled  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(4404, [$62,$F3,$0D,$50,$1F,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vpcmpled  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(4405, [$62,$93,$0D,$40,$1F,$ED,$04                       ] , 'vpcmpneqd  k5,zmm30,zmm29'                        );
  TestCase.testcase(4406, [$62,$93,$0D,$47,$1F,$ED,$04                       ] , 'vpcmpneqd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4407, [$62,$F3,$0D,$40,$1F,$29,$04                       ] , 'vpcmpneqd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4408, [$62,$B3,$0D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vpcmpneqd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4409, [$62,$F3,$0D,$50,$1F,$29,$04                       ] , 'vpcmpneqd  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(4410, [$62,$F3,$0D,$40,$1F,$6A,$7F,$04                   ] , 'vpcmpneqd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4411, [$62,$F3,$0D,$40,$1F,$AA,$00,$20,$00,$00,$04       ] , 'vpcmpneqd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4412, [$62,$F3,$0D,$40,$1F,$6A,$80,$04                   ] , 'vpcmpneqd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4413, [$62,$F3,$0D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vpcmpneqd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4414, [$62,$F3,$0D,$50,$1F,$6A,$7F,$04                   ] , 'vpcmpneqd  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4415, [$62,$F3,$0D,$50,$1F,$AA,$00,$02,$00,$00,$04       ] , 'vpcmpneqd  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4416, [$62,$F3,$0D,$50,$1F,$6A,$80,$04                   ] , 'vpcmpneqd  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4417, [$62,$F3,$0D,$50,$1F,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vpcmpneqd  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4418, [$62,$93,$0D,$40,$1F,$ED,$05                       ] , 'vpcmpnltd  k5,zmm30,zmm29'                        );
  TestCase.testcase(4419, [$62,$93,$0D,$47,$1F,$ED,$05                       ] , 'vpcmpnltd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4420, [$62,$F3,$0D,$40,$1F,$29,$05                       ] , 'vpcmpnltd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4421, [$62,$B3,$0D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vpcmpnltd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4422, [$62,$F3,$0D,$50,$1F,$29,$05                       ] , 'vpcmpnltd  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(4423, [$62,$F3,$0D,$40,$1F,$6A,$7F,$05                   ] , 'vpcmpnltd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4424, [$62,$F3,$0D,$40,$1F,$AA,$00,$20,$00,$00,$05       ] , 'vpcmpnltd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4425, [$62,$F3,$0D,$40,$1F,$6A,$80,$05                   ] , 'vpcmpnltd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4426, [$62,$F3,$0D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vpcmpnltd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4427, [$62,$F3,$0D,$50,$1F,$6A,$7F,$05                   ] , 'vpcmpnltd  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4428, [$62,$F3,$0D,$50,$1F,$AA,$00,$02,$00,$00,$05       ] , 'vpcmpnltd  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4429, [$62,$F3,$0D,$50,$1F,$6A,$80,$05                   ] , 'vpcmpnltd  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4430, [$62,$F3,$0D,$50,$1F,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vpcmpnltd  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4431, [$62,$93,$0D,$40,$1F,$ED,$06                       ] , 'vpcmpnled  k5,zmm30,zmm29'                        );
  TestCase.testcase(4432, [$62,$93,$0D,$47,$1F,$ED,$06                       ] , 'vpcmpnled  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4433, [$62,$F3,$0D,$40,$1F,$29,$06                       ] , 'vpcmpnled  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4434, [$62,$B3,$0D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vpcmpnled  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4435, [$62,$F3,$0D,$50,$1F,$29,$06                       ] , 'vpcmpnled  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(4436, [$62,$F3,$0D,$40,$1F,$6A,$7F,$06                   ] , 'vpcmpnled  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4437, [$62,$F3,$0D,$40,$1F,$AA,$00,$20,$00,$00,$06       ] , 'vpcmpnled  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4438, [$62,$F3,$0D,$40,$1F,$6A,$80,$06                   ] , 'vpcmpnled  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4439, [$62,$F3,$0D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vpcmpnled  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4440, [$62,$F3,$0D,$50,$1F,$6A,$7F,$06                   ] , 'vpcmpnled  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4441, [$62,$F3,$0D,$50,$1F,$AA,$00,$02,$00,$00,$06       ] , 'vpcmpnled  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4442, [$62,$F3,$0D,$50,$1F,$6A,$80,$06                   ] , 'vpcmpnled  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4443, [$62,$F3,$0D,$50,$1F,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vpcmpnled  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4444, [$62,$91,$0D,$40,$76,$ED                           ] , 'vpcmpeqd  k5,zmm30,zmm29'                         );
  TestCase.testcase(4445, [$62,$91,$0D,$47,$76,$ED                           ] , 'vpcmpeqd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(4446, [$62,$F1,$0D,$40,$76,$29                           ] , 'vpcmpeqd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(4447, [$62,$B1,$0D,$40,$76,$AC,$F0,$23,$01,$00,$00       ] , 'vpcmpeqd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(4448, [$62,$F1,$0D,$50,$76,$29                           ] , 'vpcmpeqd  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(4449, [$62,$F1,$0D,$40,$76,$6A,$7F                       ] , 'vpcmpeqd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(4450, [$62,$F1,$0D,$40,$76,$AA,$00,$20,$00,$00           ] , 'vpcmpeqd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(4451, [$62,$F1,$0D,$40,$76,$6A,$80                       ] , 'vpcmpeqd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(4452, [$62,$F1,$0D,$40,$76,$AA,$C0,$DF,$FF,$FF           ] , 'vpcmpeqd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(4453, [$62,$F1,$0D,$50,$76,$6A,$7F                       ] , 'vpcmpeqd  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(4454, [$62,$F1,$0D,$50,$76,$AA,$00,$02,$00,$00           ] , 'vpcmpeqd  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(4455, [$62,$F1,$0D,$50,$76,$6A,$80                       ] , 'vpcmpeqd  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(4456, [$62,$F1,$0D,$50,$76,$AA,$FC,$FD,$FF,$FF           ] , 'vpcmpeqd  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(4457, [$62,$92,$8D,$40,$29,$ED                           ] , 'vpcmpeqq  k5,zmm30,zmm29'                         );
  TestCase.testcase(4458, [$62,$92,$8D,$47,$29,$ED                           ] , 'vpcmpeqq  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(4459, [$62,$F2,$8D,$40,$29,$29                           ] , 'vpcmpeqq  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(4460, [$62,$B2,$8D,$40,$29,$AC,$F0,$23,$01,$00,$00       ] , 'vpcmpeqq  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(4461, [$62,$F2,$8D,$50,$29,$29                           ] , 'vpcmpeqq  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(4462, [$62,$F2,$8D,$40,$29,$6A,$7F                       ] , 'vpcmpeqq  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(4463, [$62,$F2,$8D,$40,$29,$AA,$00,$20,$00,$00           ] , 'vpcmpeqq  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(4464, [$62,$F2,$8D,$40,$29,$6A,$80                       ] , 'vpcmpeqq  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(4465, [$62,$F2,$8D,$40,$29,$AA,$C0,$DF,$FF,$FF           ] , 'vpcmpeqq  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(4466, [$62,$F2,$8D,$50,$29,$6A,$7F                       ] , 'vpcmpeqq  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(4467, [$62,$F2,$8D,$50,$29,$AA,$00,$04,$00,$00           ] , 'vpcmpeqq  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(4468, [$62,$F2,$8D,$50,$29,$6A,$80                       ] , 'vpcmpeqq  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(4469, [$62,$F2,$8D,$50,$29,$AA,$F8,$FB,$FF,$FF           ] , 'vpcmpeqq  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(4470, [$62,$91,$0D,$40,$66,$ED                           ] , 'vpcmpgtd  k5,zmm30,zmm29'                         );
  TestCase.testcase(4471, [$62,$91,$0D,$47,$66,$ED                           ] , 'vpcmpgtd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(4472, [$62,$F1,$0D,$40,$66,$29                           ] , 'vpcmpgtd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(4473, [$62,$B1,$0D,$40,$66,$AC,$F0,$23,$01,$00,$00       ] , 'vpcmpgtd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(4474, [$62,$F1,$0D,$50,$66,$29                           ] , 'vpcmpgtd  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(4475, [$62,$F1,$0D,$40,$66,$6A,$7F                       ] , 'vpcmpgtd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(4476, [$62,$F1,$0D,$40,$66,$AA,$00,$20,$00,$00           ] , 'vpcmpgtd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(4477, [$62,$F1,$0D,$40,$66,$6A,$80                       ] , 'vpcmpgtd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(4478, [$62,$F1,$0D,$40,$66,$AA,$C0,$DF,$FF,$FF           ] , 'vpcmpgtd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(4479, [$62,$F1,$0D,$50,$66,$6A,$7F                       ] , 'vpcmpgtd  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(4480, [$62,$F1,$0D,$50,$66,$AA,$00,$02,$00,$00           ] , 'vpcmpgtd  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(4481, [$62,$F1,$0D,$50,$66,$6A,$80                       ] , 'vpcmpgtd  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(4482, [$62,$F1,$0D,$50,$66,$AA,$FC,$FD,$FF,$FF           ] , 'vpcmpgtd  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(4483, [$62,$92,$8D,$40,$37,$ED                           ] , 'vpcmpgtq  k5,zmm30,zmm29'                         );
  TestCase.testcase(4484, [$62,$92,$8D,$47,$37,$ED                           ] , 'vpcmpgtq  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(4485, [$62,$F2,$8D,$40,$37,$29                           ] , 'vpcmpgtq  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(4486, [$62,$B2,$8D,$40,$37,$AC,$F0,$23,$01,$00,$00       ] , 'vpcmpgtq  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(4487, [$62,$F2,$8D,$50,$37,$29                           ] , 'vpcmpgtq  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(4488, [$62,$F2,$8D,$40,$37,$6A,$7F                       ] , 'vpcmpgtq  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(4489, [$62,$F2,$8D,$40,$37,$AA,$00,$20,$00,$00           ] , 'vpcmpgtq  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(4490, [$62,$F2,$8D,$40,$37,$6A,$80                       ] , 'vpcmpgtq  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(4491, [$62,$F2,$8D,$40,$37,$AA,$C0,$DF,$FF,$FF           ] , 'vpcmpgtq  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(4492, [$62,$F2,$8D,$50,$37,$6A,$7F                       ] , 'vpcmpgtq  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(4493, [$62,$F2,$8D,$50,$37,$AA,$00,$04,$00,$00           ] , 'vpcmpgtq  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(4494, [$62,$F2,$8D,$50,$37,$6A,$80                       ] , 'vpcmpgtq  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(4495, [$62,$F2,$8D,$50,$37,$AA,$F8,$FB,$FF,$FF           ] , 'vpcmpgtq  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(4496, [$62,$93,$8D,$40,$1F,$ED,$AB                       ] , 'vpcmpq  k5,zmm30,zmm29,0xab'                      );
  TestCase.testcase(4497, [$62,$93,$8D,$47,$1F,$ED,$AB                       ] , 'vpcmpq  k5{k7},zmm30,zmm29,0xab'                  );
  TestCase.testcase(4498, [$62,$93,$8D,$40,$1F,$ED,$7B                       ] , 'vpcmpq  k5,zmm30,zmm29,0x7b'                      );
  TestCase.testcase(4499, [$62,$F3,$8D,$40,$1F,$29,$7B                       ] , 'vpcmpq  k5,zmm30,zword [rcx],0x7b'                );
  TestCase.testcase(4500, [$62,$B3,$8D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vpcmpq  k5,zmm30,zword [rax+r14*8+0x123],0x7b'    );
  TestCase.testcase(4501, [$62,$F3,$8D,$50,$1F,$29,$7B                       ] , 'vpcmpq  k5,zmm30,qword [rcx]{1to8},0x7b'          );
  TestCase.testcase(4502, [$62,$F3,$8D,$40,$1F,$6A,$7F,$7B                   ] , 'vpcmpq  k5,zmm30,zword [rdx+0x1fc0],0x7b'         );
  TestCase.testcase(4503, [$62,$F3,$8D,$40,$1F,$AA,$00,$20,$00,$00,$7B       ] , 'vpcmpq  k5,zmm30,zword [rdx+0x2000],0x7b'         );
  TestCase.testcase(4504, [$62,$F3,$8D,$40,$1F,$6A,$80,$7B                   ] , 'vpcmpq  k5,zmm30,zword [rdx-0x2000],0x7b'         );
  TestCase.testcase(4505, [$62,$F3,$8D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$7B       ] , 'vpcmpq  k5,zmm30,zword [rdx-0x2040],0x7b'         );
  TestCase.testcase(4506, [$62,$F3,$8D,$50,$1F,$6A,$7F,$7B                   ] , 'vpcmpq  k5,zmm30,qword [rdx+0x3f8]{1to8},0x7b'    );
  TestCase.testcase(4507, [$62,$F3,$8D,$50,$1F,$AA,$00,$04,$00,$00,$7B       ] , 'vpcmpq  k5,zmm30,qword [rdx+0x400]{1to8},0x7b'    );
  TestCase.testcase(4508, [$62,$F3,$8D,$50,$1F,$6A,$80,$7B                   ] , 'vpcmpq  k5,zmm30,qword [rdx-0x400]{1to8},0x7b'    );
  TestCase.testcase(4509, [$62,$F3,$8D,$50,$1F,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vpcmpq  k5,zmm30,qword [rdx-0x408]{1to8},0x7b'    );
  TestCase.testcase(4510, [$62,$93,$8D,$40,$1F,$ED,$01                       ] , 'vpcmpltq  k5,zmm30,zmm29'                         );
  TestCase.testcase(4511, [$62,$93,$8D,$47,$1F,$ED,$01                       ] , 'vpcmpltq  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(4512, [$62,$F3,$8D,$40,$1F,$29,$01                       ] , 'vpcmpltq  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(4513, [$62,$B3,$8D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vpcmpltq  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(4514, [$62,$F3,$8D,$50,$1F,$29,$01                       ] , 'vpcmpltq  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(4515, [$62,$F3,$8D,$40,$1F,$6A,$7F,$01                   ] , 'vpcmpltq  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(4516, [$62,$F3,$8D,$40,$1F,$AA,$00,$20,$00,$00,$01       ] , 'vpcmpltq  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(4517, [$62,$F3,$8D,$40,$1F,$6A,$80,$01                   ] , 'vpcmpltq  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(4518, [$62,$F3,$8D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vpcmpltq  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(4519, [$62,$F3,$8D,$50,$1F,$6A,$7F,$01                   ] , 'vpcmpltq  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(4520, [$62,$F3,$8D,$50,$1F,$AA,$00,$04,$00,$00,$01       ] , 'vpcmpltq  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(4521, [$62,$F3,$8D,$50,$1F,$6A,$80,$01                   ] , 'vpcmpltq  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(4522, [$62,$F3,$8D,$50,$1F,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vpcmpltq  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(4523, [$62,$93,$8D,$40,$1F,$ED,$02                       ] , 'vpcmpleq  k5,zmm30,zmm29'                         );
  TestCase.testcase(4524, [$62,$93,$8D,$47,$1F,$ED,$02                       ] , 'vpcmpleq  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(4525, [$62,$F3,$8D,$40,$1F,$29,$02                       ] , 'vpcmpleq  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(4526, [$62,$B3,$8D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vpcmpleq  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(4527, [$62,$F3,$8D,$50,$1F,$29,$02                       ] , 'vpcmpleq  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(4528, [$62,$F3,$8D,$40,$1F,$6A,$7F,$02                   ] , 'vpcmpleq  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(4529, [$62,$F3,$8D,$40,$1F,$AA,$00,$20,$00,$00,$02       ] , 'vpcmpleq  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(4530, [$62,$F3,$8D,$40,$1F,$6A,$80,$02                   ] , 'vpcmpleq  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(4531, [$62,$F3,$8D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vpcmpleq  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(4532, [$62,$F3,$8D,$50,$1F,$6A,$7F,$02                   ] , 'vpcmpleq  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(4533, [$62,$F3,$8D,$50,$1F,$AA,$00,$04,$00,$00,$02       ] , 'vpcmpleq  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(4534, [$62,$F3,$8D,$50,$1F,$6A,$80,$02                   ] , 'vpcmpleq  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(4535, [$62,$F3,$8D,$50,$1F,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vpcmpleq  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(4536, [$62,$93,$8D,$40,$1F,$ED,$04                       ] , 'vpcmpneqq  k5,zmm30,zmm29'                        );
  TestCase.testcase(4537, [$62,$93,$8D,$47,$1F,$ED,$04                       ] , 'vpcmpneqq  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4538, [$62,$F3,$8D,$40,$1F,$29,$04                       ] , 'vpcmpneqq  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4539, [$62,$B3,$8D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vpcmpneqq  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4540, [$62,$F3,$8D,$50,$1F,$29,$04                       ] , 'vpcmpneqq  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(4541, [$62,$F3,$8D,$40,$1F,$6A,$7F,$04                   ] , 'vpcmpneqq  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4542, [$62,$F3,$8D,$40,$1F,$AA,$00,$20,$00,$00,$04       ] , 'vpcmpneqq  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4543, [$62,$F3,$8D,$40,$1F,$6A,$80,$04                   ] , 'vpcmpneqq  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4544, [$62,$F3,$8D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vpcmpneqq  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4545, [$62,$F3,$8D,$50,$1F,$6A,$7F,$04                   ] , 'vpcmpneqq  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4546, [$62,$F3,$8D,$50,$1F,$AA,$00,$04,$00,$00,$04       ] , 'vpcmpneqq  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4547, [$62,$F3,$8D,$50,$1F,$6A,$80,$04                   ] , 'vpcmpneqq  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4548, [$62,$F3,$8D,$50,$1F,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vpcmpneqq  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4549, [$62,$93,$8D,$40,$1F,$ED,$05                       ] , 'vpcmpnltq  k5,zmm30,zmm29'                        );
  TestCase.testcase(4550, [$62,$93,$8D,$47,$1F,$ED,$05                       ] , 'vpcmpnltq  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4551, [$62,$F3,$8D,$40,$1F,$29,$05                       ] , 'vpcmpnltq  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4552, [$62,$B3,$8D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vpcmpnltq  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4553, [$62,$F3,$8D,$50,$1F,$29,$05                       ] , 'vpcmpnltq  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(4554, [$62,$F3,$8D,$40,$1F,$6A,$7F,$05                   ] , 'vpcmpnltq  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4555, [$62,$F3,$8D,$40,$1F,$AA,$00,$20,$00,$00,$05       ] , 'vpcmpnltq  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4556, [$62,$F3,$8D,$40,$1F,$6A,$80,$05                   ] , 'vpcmpnltq  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4557, [$62,$F3,$8D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vpcmpnltq  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4558, [$62,$F3,$8D,$50,$1F,$6A,$7F,$05                   ] , 'vpcmpnltq  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4559, [$62,$F3,$8D,$50,$1F,$AA,$00,$04,$00,$00,$05       ] , 'vpcmpnltq  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4560, [$62,$F3,$8D,$50,$1F,$6A,$80,$05                   ] , 'vpcmpnltq  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4561, [$62,$F3,$8D,$50,$1F,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vpcmpnltq  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4562, [$62,$93,$8D,$40,$1F,$ED,$06                       ] , 'vpcmpnleq  k5,zmm30,zmm29'                        );
  TestCase.testcase(4563, [$62,$93,$8D,$47,$1F,$ED,$06                       ] , 'vpcmpnleq  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4564, [$62,$F3,$8D,$40,$1F,$29,$06                       ] , 'vpcmpnleq  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4565, [$62,$B3,$8D,$40,$1F,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vpcmpnleq  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4566, [$62,$F3,$8D,$50,$1F,$29,$06                       ] , 'vpcmpnleq  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(4567, [$62,$F3,$8D,$40,$1F,$6A,$7F,$06                   ] , 'vpcmpnleq  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4568, [$62,$F3,$8D,$40,$1F,$AA,$00,$20,$00,$00,$06       ] , 'vpcmpnleq  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4569, [$62,$F3,$8D,$40,$1F,$6A,$80,$06                   ] , 'vpcmpnleq  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4570, [$62,$F3,$8D,$40,$1F,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vpcmpnleq  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4571, [$62,$F3,$8D,$50,$1F,$6A,$7F,$06                   ] , 'vpcmpnleq  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4572, [$62,$F3,$8D,$50,$1F,$AA,$00,$04,$00,$00,$06       ] , 'vpcmpnleq  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4573, [$62,$F3,$8D,$50,$1F,$6A,$80,$06                   ] , 'vpcmpnleq  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4574, [$62,$F3,$8D,$50,$1F,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vpcmpnleq  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4575, [$62,$93,$0D,$40,$1E,$ED,$AB                       ] , 'vpcmpud  k5,zmm30,zmm29,0xab'                     );
  TestCase.testcase(4576, [$62,$93,$0D,$47,$1E,$ED,$AB                       ] , 'vpcmpud  k5{k7},zmm30,zmm29,0xab'                 );
  TestCase.testcase(4577, [$62,$93,$0D,$40,$1E,$ED,$7B                       ] , 'vpcmpud  k5,zmm30,zmm29,0x7b'                     );
  TestCase.testcase(4578, [$62,$F3,$0D,$40,$1E,$29,$7B                       ] , 'vpcmpud  k5,zmm30,zword [rcx],0x7b'               );
  TestCase.testcase(4579, [$62,$B3,$0D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vpcmpud  k5,zmm30,zword [rax+r14*8+0x123],0x7b'   );
  TestCase.testcase(4580, [$62,$F3,$0D,$50,$1E,$29,$7B                       ] , 'vpcmpud  k5,zmm30,dword [rcx]{1to16},0x7b'        );
  TestCase.testcase(4581, [$62,$F3,$0D,$40,$1E,$6A,$7F,$7B                   ] , 'vpcmpud  k5,zmm30,zword [rdx+0x1fc0],0x7b'        );
  TestCase.testcase(4582, [$62,$F3,$0D,$40,$1E,$AA,$00,$20,$00,$00,$7B       ] , 'vpcmpud  k5,zmm30,zword [rdx+0x2000],0x7b'        );
  TestCase.testcase(4583, [$62,$F3,$0D,$40,$1E,$6A,$80,$7B                   ] , 'vpcmpud  k5,zmm30,zword [rdx-0x2000],0x7b'        );
  TestCase.testcase(4584, [$62,$F3,$0D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$7B       ] , 'vpcmpud  k5,zmm30,zword [rdx-0x2040],0x7b'        );
  TestCase.testcase(4585, [$62,$F3,$0D,$50,$1E,$6A,$7F,$7B                   ] , 'vpcmpud  k5,zmm30,dword [rdx+0x1fc]{1to16},0x7b'  );
  TestCase.testcase(4586, [$62,$F3,$0D,$50,$1E,$AA,$00,$02,$00,$00,$7B       ] , 'vpcmpud  k5,zmm30,dword [rdx+0x200]{1to16},0x7b'  );
  TestCase.testcase(4587, [$62,$F3,$0D,$50,$1E,$6A,$80,$7B                   ] , 'vpcmpud  k5,zmm30,dword [rdx-0x200]{1to16},0x7b'  );
  TestCase.testcase(4588, [$62,$F3,$0D,$50,$1E,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vpcmpud  k5,zmm30,dword [rdx-0x204]{1to16},0x7b'  );
  TestCase.testcase(4589, [$62,$93,$0D,$40,$1E,$ED,$00                       ] , 'vpcmpequd  k5,zmm30,zmm29'                        );
  TestCase.testcase(4590, [$62,$93,$0D,$47,$1E,$ED,$00                       ] , 'vpcmpequd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4591, [$62,$F3,$0D,$40,$1E,$29,$00                       ] , 'vpcmpequd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4592, [$62,$B3,$0D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vpcmpequd  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4593, [$62,$F3,$0D,$50,$1E,$29,$00                       ] , 'vpcmpequd  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(4594, [$62,$F3,$0D,$40,$1E,$6A,$7F,$00                   ] , 'vpcmpequd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4595, [$62,$F3,$0D,$40,$1E,$AA,$00,$20,$00,$00,$00       ] , 'vpcmpequd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4596, [$62,$F3,$0D,$40,$1E,$6A,$80,$00                   ] , 'vpcmpequd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4597, [$62,$F3,$0D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$00       ] , 'vpcmpequd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4598, [$62,$F3,$0D,$50,$1E,$6A,$7F,$00                   ] , 'vpcmpequd  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4599, [$62,$F3,$0D,$50,$1E,$AA,$00,$02,$00,$00,$00       ] , 'vpcmpequd  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4600, [$62,$F3,$0D,$50,$1E,$6A,$80,$00                   ] , 'vpcmpequd  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4601, [$62,$F3,$0D,$50,$1E,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vpcmpequd  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4602, [$62,$93,$0D,$40,$1E,$ED,$01                       ] , 'vpcmpltud  k5,zmm30,zmm29'                        );
  TestCase.testcase(4603, [$62,$93,$0D,$47,$1E,$ED,$01                       ] , 'vpcmpltud  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4604, [$62,$F3,$0D,$40,$1E,$29,$01                       ] , 'vpcmpltud  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4605, [$62,$B3,$0D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vpcmpltud  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4606, [$62,$F3,$0D,$50,$1E,$29,$01                       ] , 'vpcmpltud  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(4607, [$62,$F3,$0D,$40,$1E,$6A,$7F,$01                   ] , 'vpcmpltud  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4608, [$62,$F3,$0D,$40,$1E,$AA,$00,$20,$00,$00,$01       ] , 'vpcmpltud  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4609, [$62,$F3,$0D,$40,$1E,$6A,$80,$01                   ] , 'vpcmpltud  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4610, [$62,$F3,$0D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vpcmpltud  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4611, [$62,$F3,$0D,$50,$1E,$6A,$7F,$01                   ] , 'vpcmpltud  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4612, [$62,$F3,$0D,$50,$1E,$AA,$00,$02,$00,$00,$01       ] , 'vpcmpltud  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4613, [$62,$F3,$0D,$50,$1E,$6A,$80,$01                   ] , 'vpcmpltud  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4614, [$62,$F3,$0D,$50,$1E,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vpcmpltud  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4615, [$62,$93,$0D,$40,$1E,$ED,$02                       ] , 'vpcmpleud  k5,zmm30,zmm29'                        );
  TestCase.testcase(4616, [$62,$93,$0D,$47,$1E,$ED,$02                       ] , 'vpcmpleud  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4617, [$62,$F3,$0D,$40,$1E,$29,$02                       ] , 'vpcmpleud  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4618, [$62,$B3,$0D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vpcmpleud  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4619, [$62,$F3,$0D,$50,$1E,$29,$02                       ] , 'vpcmpleud  k5,zmm30,dword [rcx]{1to16}'           );
  TestCase.testcase(4620, [$62,$F3,$0D,$40,$1E,$6A,$7F,$02                   ] , 'vpcmpleud  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4621, [$62,$F3,$0D,$40,$1E,$AA,$00,$20,$00,$00,$02       ] , 'vpcmpleud  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4622, [$62,$F3,$0D,$40,$1E,$6A,$80,$02                   ] , 'vpcmpleud  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4623, [$62,$F3,$0D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vpcmpleud  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4624, [$62,$F3,$0D,$50,$1E,$6A,$7F,$02                   ] , 'vpcmpleud  k5,zmm30,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4625, [$62,$F3,$0D,$50,$1E,$AA,$00,$02,$00,$00,$02       ] , 'vpcmpleud  k5,zmm30,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4626, [$62,$F3,$0D,$50,$1E,$6A,$80,$02                   ] , 'vpcmpleud  k5,zmm30,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4627, [$62,$F3,$0D,$50,$1E,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vpcmpleud  k5,zmm30,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4628, [$62,$93,$0D,$40,$1E,$ED,$04                       ] , 'vpcmpnequd  k5,zmm30,zmm29'                       );
  TestCase.testcase(4629, [$62,$93,$0D,$47,$1E,$ED,$04                       ] , 'vpcmpnequd  k5{k7},zmm30,zmm29'                   );
  TestCase.testcase(4630, [$62,$F3,$0D,$40,$1E,$29,$04                       ] , 'vpcmpnequd  k5,zmm30,zword [rcx]'                 );
  TestCase.testcase(4631, [$62,$B3,$0D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vpcmpnequd  k5,zmm30,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4632, [$62,$F3,$0D,$50,$1E,$29,$04                       ] , 'vpcmpnequd  k5,zmm30,dword [rcx]{1to16}'          );
  TestCase.testcase(4633, [$62,$F3,$0D,$40,$1E,$6A,$7F,$04                   ] , 'vpcmpnequd  k5,zmm30,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4634, [$62,$F3,$0D,$40,$1E,$AA,$00,$20,$00,$00,$04       ] , 'vpcmpnequd  k5,zmm30,zword [rdx+0x2000]'          );
  TestCase.testcase(4635, [$62,$F3,$0D,$40,$1E,$6A,$80,$04                   ] , 'vpcmpnequd  k5,zmm30,zword [rdx-0x2000]'          );
  TestCase.testcase(4636, [$62,$F3,$0D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vpcmpnequd  k5,zmm30,zword [rdx-0x2040]'          );
  TestCase.testcase(4637, [$62,$F3,$0D,$50,$1E,$6A,$7F,$04                   ] , 'vpcmpnequd  k5,zmm30,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(4638, [$62,$F3,$0D,$50,$1E,$AA,$00,$02,$00,$00,$04       ] , 'vpcmpnequd  k5,zmm30,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(4639, [$62,$F3,$0D,$50,$1E,$6A,$80,$04                   ] , 'vpcmpnequd  k5,zmm30,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(4640, [$62,$F3,$0D,$50,$1E,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vpcmpnequd  k5,zmm30,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(4641, [$62,$93,$0D,$40,$1E,$ED,$05                       ] , 'vpcmpnltud  k5,zmm30,zmm29'                       );
  TestCase.testcase(4642, [$62,$93,$0D,$47,$1E,$ED,$05                       ] , 'vpcmpnltud  k5{k7},zmm30,zmm29'                   );
  TestCase.testcase(4643, [$62,$F3,$0D,$40,$1E,$29,$05                       ] , 'vpcmpnltud  k5,zmm30,zword [rcx]'                 );
  TestCase.testcase(4644, [$62,$B3,$0D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vpcmpnltud  k5,zmm30,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4645, [$62,$F3,$0D,$50,$1E,$29,$05                       ] , 'vpcmpnltud  k5,zmm30,dword [rcx]{1to16}'          );
  TestCase.testcase(4646, [$62,$F3,$0D,$40,$1E,$6A,$7F,$05                   ] , 'vpcmpnltud  k5,zmm30,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4647, [$62,$F3,$0D,$40,$1E,$AA,$00,$20,$00,$00,$05       ] , 'vpcmpnltud  k5,zmm30,zword [rdx+0x2000]'          );
  TestCase.testcase(4648, [$62,$F3,$0D,$40,$1E,$6A,$80,$05                   ] , 'vpcmpnltud  k5,zmm30,zword [rdx-0x2000]'          );
  TestCase.testcase(4649, [$62,$F3,$0D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vpcmpnltud  k5,zmm30,zword [rdx-0x2040]'          );
  TestCase.testcase(4650, [$62,$F3,$0D,$50,$1E,$6A,$7F,$05                   ] , 'vpcmpnltud  k5,zmm30,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(4651, [$62,$F3,$0D,$50,$1E,$AA,$00,$02,$00,$00,$05       ] , 'vpcmpnltud  k5,zmm30,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(4652, [$62,$F3,$0D,$50,$1E,$6A,$80,$05                   ] , 'vpcmpnltud  k5,zmm30,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(4653, [$62,$F3,$0D,$50,$1E,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vpcmpnltud  k5,zmm30,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(4654, [$62,$93,$0D,$40,$1E,$ED,$06                       ] , 'vpcmpnleud  k5,zmm30,zmm29'                       );
  TestCase.testcase(4655, [$62,$93,$0D,$47,$1E,$ED,$06                       ] , 'vpcmpnleud  k5{k7},zmm30,zmm29'                   );
  TestCase.testcase(4656, [$62,$F3,$0D,$40,$1E,$29,$06                       ] , 'vpcmpnleud  k5,zmm30,zword [rcx]'                 );
  TestCase.testcase(4657, [$62,$B3,$0D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vpcmpnleud  k5,zmm30,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4658, [$62,$F3,$0D,$50,$1E,$29,$06                       ] , 'vpcmpnleud  k5,zmm30,dword [rcx]{1to16}'          );
  TestCase.testcase(4659, [$62,$F3,$0D,$40,$1E,$6A,$7F,$06                   ] , 'vpcmpnleud  k5,zmm30,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4660, [$62,$F3,$0D,$40,$1E,$AA,$00,$20,$00,$00,$06       ] , 'vpcmpnleud  k5,zmm30,zword [rdx+0x2000]'          );
  TestCase.testcase(4661, [$62,$F3,$0D,$40,$1E,$6A,$80,$06                   ] , 'vpcmpnleud  k5,zmm30,zword [rdx-0x2000]'          );
  TestCase.testcase(4662, [$62,$F3,$0D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vpcmpnleud  k5,zmm30,zword [rdx-0x2040]'          );
  TestCase.testcase(4663, [$62,$F3,$0D,$50,$1E,$6A,$7F,$06                   ] , 'vpcmpnleud  k5,zmm30,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(4664, [$62,$F3,$0D,$50,$1E,$AA,$00,$02,$00,$00,$06       ] , 'vpcmpnleud  k5,zmm30,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(4665, [$62,$F3,$0D,$50,$1E,$6A,$80,$06                   ] , 'vpcmpnleud  k5,zmm30,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(4666, [$62,$F3,$0D,$50,$1E,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vpcmpnleud  k5,zmm30,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(4667, [$62,$93,$8D,$40,$1E,$ED,$AB                       ] , 'vpcmpuq  k5,zmm30,zmm29,0xab'                     );
  TestCase.testcase(4668, [$62,$93,$8D,$47,$1E,$ED,$AB                       ] , 'vpcmpuq  k5{k7},zmm30,zmm29,0xab'                 );
  TestCase.testcase(4669, [$62,$93,$8D,$40,$1E,$ED,$7B                       ] , 'vpcmpuq  k5,zmm30,zmm29,0x7b'                     );
  TestCase.testcase(4670, [$62,$F3,$8D,$40,$1E,$29,$7B                       ] , 'vpcmpuq  k5,zmm30,zword [rcx],0x7b'               );
  TestCase.testcase(4671, [$62,$B3,$8D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$7B   ] , 'vpcmpuq  k5,zmm30,zword [rax+r14*8+0x123],0x7b'   );
  TestCase.testcase(4672, [$62,$F3,$8D,$50,$1E,$29,$7B                       ] , 'vpcmpuq  k5,zmm30,qword [rcx]{1to8},0x7b'         );
  TestCase.testcase(4673, [$62,$F3,$8D,$40,$1E,$6A,$7F,$7B                   ] , 'vpcmpuq  k5,zmm30,zword [rdx+0x1fc0],0x7b'        );
  TestCase.testcase(4674, [$62,$F3,$8D,$40,$1E,$AA,$00,$20,$00,$00,$7B       ] , 'vpcmpuq  k5,zmm30,zword [rdx+0x2000],0x7b'        );
  TestCase.testcase(4675, [$62,$F3,$8D,$40,$1E,$6A,$80,$7B                   ] , 'vpcmpuq  k5,zmm30,zword [rdx-0x2000],0x7b'        );
  TestCase.testcase(4676, [$62,$F3,$8D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$7B       ] , 'vpcmpuq  k5,zmm30,zword [rdx-0x2040],0x7b'        );
  TestCase.testcase(4677, [$62,$F3,$8D,$50,$1E,$6A,$7F,$7B                   ] , 'vpcmpuq  k5,zmm30,qword [rdx+0x3f8]{1to8},0x7b'   );
  TestCase.testcase(4678, [$62,$F3,$8D,$50,$1E,$AA,$00,$04,$00,$00,$7B       ] , 'vpcmpuq  k5,zmm30,qword [rdx+0x400]{1to8},0x7b'   );
  TestCase.testcase(4679, [$62,$F3,$8D,$50,$1E,$6A,$80,$7B                   ] , 'vpcmpuq  k5,zmm30,qword [rdx-0x400]{1to8},0x7b'   );
  TestCase.testcase(4680, [$62,$F3,$8D,$50,$1E,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vpcmpuq  k5,zmm30,qword [rdx-0x408]{1to8},0x7b'   );
  TestCase.testcase(4681, [$62,$93,$8D,$40,$1E,$ED,$00                       ] , 'vpcmpequq  k5,zmm30,zmm29'                        );
  TestCase.testcase(4682, [$62,$93,$8D,$47,$1E,$ED,$00                       ] , 'vpcmpequq  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4683, [$62,$F3,$8D,$40,$1E,$29,$00                       ] , 'vpcmpequq  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4684, [$62,$B3,$8D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$00   ] , 'vpcmpequq  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4685, [$62,$F3,$8D,$50,$1E,$29,$00                       ] , 'vpcmpequq  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(4686, [$62,$F3,$8D,$40,$1E,$6A,$7F,$00                   ] , 'vpcmpequq  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4687, [$62,$F3,$8D,$40,$1E,$AA,$00,$20,$00,$00,$00       ] , 'vpcmpequq  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4688, [$62,$F3,$8D,$40,$1E,$6A,$80,$00                   ] , 'vpcmpequq  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4689, [$62,$F3,$8D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$00       ] , 'vpcmpequq  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4690, [$62,$F3,$8D,$50,$1E,$6A,$7F,$00                   ] , 'vpcmpequq  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4691, [$62,$F3,$8D,$50,$1E,$AA,$00,$04,$00,$00,$00       ] , 'vpcmpequq  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4692, [$62,$F3,$8D,$50,$1E,$6A,$80,$00                   ] , 'vpcmpequq  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4693, [$62,$F3,$8D,$50,$1E,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vpcmpequq  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4694, [$62,$93,$8D,$40,$1E,$ED,$01                       ] , 'vpcmpltuq  k5,zmm30,zmm29'                        );
  TestCase.testcase(4695, [$62,$93,$8D,$47,$1E,$ED,$01                       ] , 'vpcmpltuq  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4696, [$62,$F3,$8D,$40,$1E,$29,$01                       ] , 'vpcmpltuq  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4697, [$62,$B3,$8D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$01   ] , 'vpcmpltuq  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4698, [$62,$F3,$8D,$50,$1E,$29,$01                       ] , 'vpcmpltuq  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(4699, [$62,$F3,$8D,$40,$1E,$6A,$7F,$01                   ] , 'vpcmpltuq  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4700, [$62,$F3,$8D,$40,$1E,$AA,$00,$20,$00,$00,$01       ] , 'vpcmpltuq  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4701, [$62,$F3,$8D,$40,$1E,$6A,$80,$01                   ] , 'vpcmpltuq  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4702, [$62,$F3,$8D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vpcmpltuq  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4703, [$62,$F3,$8D,$50,$1E,$6A,$7F,$01                   ] , 'vpcmpltuq  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4704, [$62,$F3,$8D,$50,$1E,$AA,$00,$04,$00,$00,$01       ] , 'vpcmpltuq  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4705, [$62,$F3,$8D,$50,$1E,$6A,$80,$01                   ] , 'vpcmpltuq  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4706, [$62,$F3,$8D,$50,$1E,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vpcmpltuq  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4707, [$62,$93,$8D,$40,$1E,$ED,$02                       ] , 'vpcmpleuq  k5,zmm30,zmm29'                        );
  TestCase.testcase(4708, [$62,$93,$8D,$47,$1E,$ED,$02                       ] , 'vpcmpleuq  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(4709, [$62,$F3,$8D,$40,$1E,$29,$02                       ] , 'vpcmpleuq  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(4710, [$62,$B3,$8D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$02   ] , 'vpcmpleuq  k5,zmm30,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4711, [$62,$F3,$8D,$50,$1E,$29,$02                       ] , 'vpcmpleuq  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(4712, [$62,$F3,$8D,$40,$1E,$6A,$7F,$02                   ] , 'vpcmpleuq  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4713, [$62,$F3,$8D,$40,$1E,$AA,$00,$20,$00,$00,$02       ] , 'vpcmpleuq  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(4714, [$62,$F3,$8D,$40,$1E,$6A,$80,$02                   ] , 'vpcmpleuq  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(4715, [$62,$F3,$8D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vpcmpleuq  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(4716, [$62,$F3,$8D,$50,$1E,$6A,$7F,$02                   ] , 'vpcmpleuq  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(4717, [$62,$F3,$8D,$50,$1E,$AA,$00,$04,$00,$00,$02       ] , 'vpcmpleuq  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(4718, [$62,$F3,$8D,$50,$1E,$6A,$80,$02                   ] , 'vpcmpleuq  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(4719, [$62,$F3,$8D,$50,$1E,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vpcmpleuq  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(4720, [$62,$93,$8D,$40,$1E,$ED,$04                       ] , 'vpcmpnequq  k5,zmm30,zmm29'                       );
  TestCase.testcase(4721, [$62,$93,$8D,$47,$1E,$ED,$04                       ] , 'vpcmpnequq  k5{k7},zmm30,zmm29'                   );
  TestCase.testcase(4722, [$62,$F3,$8D,$40,$1E,$29,$04                       ] , 'vpcmpnequq  k5,zmm30,zword [rcx]'                 );
  TestCase.testcase(4723, [$62,$B3,$8D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$04   ] , 'vpcmpnequq  k5,zmm30,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4724, [$62,$F3,$8D,$50,$1E,$29,$04                       ] , 'vpcmpnequq  k5,zmm30,qword [rcx]{1to8}'           );
  TestCase.testcase(4725, [$62,$F3,$8D,$40,$1E,$6A,$7F,$04                   ] , 'vpcmpnequq  k5,zmm30,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4726, [$62,$F3,$8D,$40,$1E,$AA,$00,$20,$00,$00,$04       ] , 'vpcmpnequq  k5,zmm30,zword [rdx+0x2000]'          );
  TestCase.testcase(4727, [$62,$F3,$8D,$40,$1E,$6A,$80,$04                   ] , 'vpcmpnequq  k5,zmm30,zword [rdx-0x2000]'          );
  TestCase.testcase(4728, [$62,$F3,$8D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vpcmpnequq  k5,zmm30,zword [rdx-0x2040]'          );
  TestCase.testcase(4729, [$62,$F3,$8D,$50,$1E,$6A,$7F,$04                   ] , 'vpcmpnequq  k5,zmm30,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(4730, [$62,$F3,$8D,$50,$1E,$AA,$00,$04,$00,$00,$04       ] , 'vpcmpnequq  k5,zmm30,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(4731, [$62,$F3,$8D,$50,$1E,$6A,$80,$04                   ] , 'vpcmpnequq  k5,zmm30,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(4732, [$62,$F3,$8D,$50,$1E,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vpcmpnequq  k5,zmm30,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(4733, [$62,$93,$8D,$40,$1E,$ED,$05                       ] , 'vpcmpnltuq  k5,zmm30,zmm29'                       );
  TestCase.testcase(4734, [$62,$93,$8D,$47,$1E,$ED,$05                       ] , 'vpcmpnltuq  k5{k7},zmm30,zmm29'                   );
  TestCase.testcase(4735, [$62,$F3,$8D,$40,$1E,$29,$05                       ] , 'vpcmpnltuq  k5,zmm30,zword [rcx]'                 );
  TestCase.testcase(4736, [$62,$B3,$8D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$05   ] , 'vpcmpnltuq  k5,zmm30,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4737, [$62,$F3,$8D,$50,$1E,$29,$05                       ] , 'vpcmpnltuq  k5,zmm30,qword [rcx]{1to8}'           );
  TestCase.testcase(4738, [$62,$F3,$8D,$40,$1E,$6A,$7F,$05                   ] , 'vpcmpnltuq  k5,zmm30,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4739, [$62,$F3,$8D,$40,$1E,$AA,$00,$20,$00,$00,$05       ] , 'vpcmpnltuq  k5,zmm30,zword [rdx+0x2000]'          );
  TestCase.testcase(4740, [$62,$F3,$8D,$40,$1E,$6A,$80,$05                   ] , 'vpcmpnltuq  k5,zmm30,zword [rdx-0x2000]'          );
  TestCase.testcase(4741, [$62,$F3,$8D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vpcmpnltuq  k5,zmm30,zword [rdx-0x2040]'          );
  TestCase.testcase(4742, [$62,$F3,$8D,$50,$1E,$6A,$7F,$05                   ] , 'vpcmpnltuq  k5,zmm30,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(4743, [$62,$F3,$8D,$50,$1E,$AA,$00,$04,$00,$00,$05       ] , 'vpcmpnltuq  k5,zmm30,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(4744, [$62,$F3,$8D,$50,$1E,$6A,$80,$05                   ] , 'vpcmpnltuq  k5,zmm30,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(4745, [$62,$F3,$8D,$50,$1E,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vpcmpnltuq  k5,zmm30,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(4746, [$62,$93,$8D,$40,$1E,$ED,$06                       ] , 'vpcmpnleuq  k5,zmm30,zmm29'                       );
  TestCase.testcase(4747, [$62,$93,$8D,$47,$1E,$ED,$06                       ] , 'vpcmpnleuq  k5{k7},zmm30,zmm29'                   );
  TestCase.testcase(4748, [$62,$F3,$8D,$40,$1E,$29,$06                       ] , 'vpcmpnleuq  k5,zmm30,zword [rcx]'                 );
  TestCase.testcase(4749, [$62,$B3,$8D,$40,$1E,$AC,$F0,$23,$01,$00,$00,$06   ] , 'vpcmpnleuq  k5,zmm30,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4750, [$62,$F3,$8D,$50,$1E,$29,$06                       ] , 'vpcmpnleuq  k5,zmm30,qword [rcx]{1to8}'           );
  TestCase.testcase(4751, [$62,$F3,$8D,$40,$1E,$6A,$7F,$06                   ] , 'vpcmpnleuq  k5,zmm30,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4752, [$62,$F3,$8D,$40,$1E,$AA,$00,$20,$00,$00,$06       ] , 'vpcmpnleuq  k5,zmm30,zword [rdx+0x2000]'          );
  TestCase.testcase(4753, [$62,$F3,$8D,$40,$1E,$6A,$80,$06                   ] , 'vpcmpnleuq  k5,zmm30,zword [rdx-0x2000]'          );
  TestCase.testcase(4754, [$62,$F3,$8D,$40,$1E,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vpcmpnleuq  k5,zmm30,zword [rdx-0x2040]'          );
  TestCase.testcase(4755, [$62,$F3,$8D,$50,$1E,$6A,$7F,$06                   ] , 'vpcmpnleuq  k5,zmm30,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(4756, [$62,$F3,$8D,$50,$1E,$AA,$00,$04,$00,$00,$06       ] , 'vpcmpnleuq  k5,zmm30,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(4757, [$62,$F3,$8D,$50,$1E,$6A,$80,$06                   ] , 'vpcmpnleuq  k5,zmm30,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(4758, [$62,$F3,$8D,$50,$1E,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vpcmpnleuq  k5,zmm30,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(4759, [$62,$02,$95,$40,$64,$F4                           ] , 'vpblendmq  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(4760, [$62,$02,$95,$47,$64,$F4                           ] , 'vpblendmq  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(4761, [$62,$02,$95,$C7,$64,$F4                           ] , 'vpblendmq  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(4762, [$62,$62,$95,$40,$64,$31                           ] , 'vpblendmq  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(4763, [$62,$22,$95,$40,$64,$B4,$F0,$23,$01,$00,$00       ] , 'vpblendmq  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(4764, [$62,$62,$95,$50,$64,$31                           ] , 'vpblendmq  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(4765, [$62,$62,$95,$40,$64,$72,$7F                       ] , 'vpblendmq  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(4766, [$62,$62,$95,$40,$64,$B2,$00,$20,$00,$00           ] , 'vpblendmq  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(4767, [$62,$62,$95,$40,$64,$72,$80                       ] , 'vpblendmq  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(4768, [$62,$62,$95,$40,$64,$B2,$C0,$DF,$FF,$FF           ] , 'vpblendmq  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(4769, [$62,$62,$95,$50,$64,$72,$7F                       ] , 'vpblendmq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(4770, [$62,$62,$95,$50,$64,$B2,$00,$04,$00,$00           ] , 'vpblendmq  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(4771, [$62,$62,$95,$50,$64,$72,$80                       ] , 'vpblendmq  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(4772, [$62,$62,$95,$50,$64,$B2,$F8,$FB,$FF,$FF           ] , 'vpblendmq  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(4773, [$62,$62,$7D,$48,$8B,$31                           ] , 'vpcompressd  zword [rcx],zmm30'                   );
  TestCase.testcase(4774, [$62,$62,$7D,$4F,$8B,$31                           ] , 'vpcompressd  zword [rcx]{k7},zmm30'               );
  TestCase.testcase(4775, [$62,$22,$7D,$48,$8B,$B4,$F0,$23,$01,$00,$00       ] , 'vpcompressd  zword [rax+r14*8+0x123],zmm30'       );
  TestCase.testcase(4776, [$62,$62,$7D,$48,$8B,$72,$7F                       ] , 'vpcompressd  zword [rdx+0x1fc],zmm30'             );
  TestCase.testcase(4777, [$62,$62,$7D,$48,$8B,$B2,$00,$02,$00,$00           ] , 'vpcompressd  zword [rdx+0x200],zmm30'             );
  TestCase.testcase(4778, [$62,$62,$7D,$48,$8B,$72,$80                       ] , 'vpcompressd  zword [rdx-0x200],zmm30'             );
  TestCase.testcase(4779, [$62,$62,$7D,$48,$8B,$B2,$FC,$FD,$FF,$FF           ] , 'vpcompressd  zword [rdx-0x204],zmm30'             );
  TestCase.testcase(4780, [$62,$02,$7D,$48,$8B,$EE                           ] , 'vpcompressd  zmm30,zmm29'                         );
  TestCase.testcase(4781, [$62,$02,$7D,$4F,$8B,$EE                           ] , 'vpcompressd  zmm30{k7},zmm29'                     );
  TestCase.testcase(4782, [$62,$02,$7D,$CF,$8B,$EE                           ] , 'vpcompressd  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(4783, [$62,$02,$15,$40,$36,$F4                           ] , 'vpermd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(4784, [$62,$02,$15,$47,$36,$F4                           ] , 'vpermd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(4785, [$62,$02,$15,$C7,$36,$F4                           ] , 'vpermd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(4786, [$62,$62,$15,$40,$36,$31                           ] , 'vpermd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(4787, [$62,$22,$15,$40,$36,$B4,$F0,$23,$01,$00,$00       ] , 'vpermd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(4788, [$62,$62,$15,$50,$36,$31                           ] , 'vpermd  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(4789, [$62,$62,$15,$40,$36,$72,$7F                       ] , 'vpermd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(4790, [$62,$62,$15,$40,$36,$B2,$00,$20,$00,$00           ] , 'vpermd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(4791, [$62,$62,$15,$40,$36,$72,$80                       ] , 'vpermd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(4792, [$62,$62,$15,$40,$36,$B2,$C0,$DF,$FF,$FF           ] , 'vpermd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(4793, [$62,$62,$15,$50,$36,$72,$7F                       ] , 'vpermd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(4794, [$62,$62,$15,$50,$36,$B2,$00,$02,$00,$00           ] , 'vpermd  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(4795, [$62,$62,$15,$50,$36,$72,$80                       ] , 'vpermd  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(4796, [$62,$62,$15,$50,$36,$B2,$FC,$FD,$FF,$FF           ] , 'vpermd  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(4797, [$62,$03,$FD,$48,$05,$F5,$AB                       ] , 'vpermilpd  zmm30,zmm29,0xab'                      );
  TestCase.testcase(4798, [$62,$03,$FD,$4F,$05,$F5,$AB                       ] , 'vpermilpd  zmm30{k7},zmm29,0xab'                  );
  TestCase.testcase(4799, [$62,$03,$FD,$CF,$05,$F5,$AB                       ] , 'vpermilpd  zmm30{k7}{z},zmm29,0xab'               );
  TestCase.testcase(4800, [$62,$03,$FD,$48,$05,$F5,$7B                       ] , 'vpermilpd  zmm30,zmm29,0x7b'                      );
  TestCase.testcase(4801, [$62,$63,$FD,$48,$05,$31,$7B                       ] , 'vpermilpd  zmm30,zword [rcx],0x7b'                );
  TestCase.testcase(4802, [$62,$23,$FD,$48,$05,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpermilpd  zmm30,zword [rax+r14*8+0x123],0x7b'    );
  TestCase.testcase(4803, [$62,$63,$FD,$58,$05,$31,$7B                       ] , 'vpermilpd  zmm30,qword [rcx]{1to8},0x7b'          );
  TestCase.testcase(4804, [$62,$63,$FD,$48,$05,$72,$7F,$7B                   ] , 'vpermilpd  zmm30,zword [rdx+0x1fc0],0x7b'         );
  TestCase.testcase(4805, [$62,$63,$FD,$48,$05,$B2,$00,$20,$00,$00,$7B       ] , 'vpermilpd  zmm30,zword [rdx+0x2000],0x7b'         );
  TestCase.testcase(4806, [$62,$63,$FD,$48,$05,$72,$80,$7B                   ] , 'vpermilpd  zmm30,zword [rdx-0x2000],0x7b'         );
  TestCase.testcase(4807, [$62,$63,$FD,$48,$05,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpermilpd  zmm30,zword [rdx-0x2040],0x7b'         );
  TestCase.testcase(4808, [$62,$63,$FD,$58,$05,$72,$7F,$7B                   ] , 'vpermilpd  zmm30,qword [rdx+0x3f8]{1to8},0x7b'    );
  TestCase.testcase(4809, [$62,$63,$FD,$58,$05,$B2,$00,$04,$00,$00,$7B       ] , 'vpermilpd  zmm30,qword [rdx+0x400]{1to8},0x7b'    );
  TestCase.testcase(4810, [$62,$63,$FD,$58,$05,$72,$80,$7B                   ] , 'vpermilpd  zmm30,qword [rdx-0x400]{1to8},0x7b'    );
  TestCase.testcase(4811, [$62,$63,$FD,$58,$05,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vpermilpd  zmm30,qword [rdx-0x408]{1to8},0x7b'    );
  TestCase.testcase(4812, [$62,$02,$95,$40,$0D,$F4                           ] , 'vpermilpd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(4813, [$62,$02,$95,$47,$0D,$F4                           ] , 'vpermilpd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(4814, [$62,$02,$95,$C7,$0D,$F4                           ] , 'vpermilpd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(4815, [$62,$62,$95,$40,$0D,$31                           ] , 'vpermilpd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(4816, [$62,$22,$95,$40,$0D,$B4,$F0,$23,$01,$00,$00       ] , 'vpermilpd  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(4817, [$62,$62,$95,$50,$0D,$31                           ] , 'vpermilpd  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(4818, [$62,$62,$95,$40,$0D,$72,$7F                       ] , 'vpermilpd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(4819, [$62,$62,$95,$40,$0D,$B2,$00,$20,$00,$00           ] , 'vpermilpd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(4820, [$62,$62,$95,$40,$0D,$72,$80                       ] , 'vpermilpd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(4821, [$62,$62,$95,$40,$0D,$B2,$C0,$DF,$FF,$FF           ] , 'vpermilpd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(4822, [$62,$62,$95,$50,$0D,$72,$7F                       ] , 'vpermilpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(4823, [$62,$62,$95,$50,$0D,$B2,$00,$04,$00,$00           ] , 'vpermilpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(4824, [$62,$62,$95,$50,$0D,$72,$80                       ] , 'vpermilpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(4825, [$62,$62,$95,$50,$0D,$B2,$F8,$FB,$FF,$FF           ] , 'vpermilpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(4826, [$62,$03,$7D,$48,$04,$F5,$AB                       ] , 'vpermilps  zmm30,zmm29,0xab'                      );
  TestCase.testcase(4827, [$62,$03,$7D,$4F,$04,$F5,$AB                       ] , 'vpermilps  zmm30{k7},zmm29,0xab'                  );
  TestCase.testcase(4828, [$62,$03,$7D,$CF,$04,$F5,$AB                       ] , 'vpermilps  zmm30{k7}{z},zmm29,0xab'               );
  TestCase.testcase(4829, [$62,$03,$7D,$48,$04,$F5,$7B                       ] , 'vpermilps  zmm30,zmm29,0x7b'                      );
  TestCase.testcase(4830, [$62,$63,$7D,$48,$04,$31,$7B                       ] , 'vpermilps  zmm30,zword [rcx],0x7b'                );
  TestCase.testcase(4831, [$62,$23,$7D,$48,$04,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpermilps  zmm30,zword [rax+r14*8+0x123],0x7b'    );
  TestCase.testcase(4832, [$62,$63,$7D,$58,$04,$31,$7B                       ] , 'vpermilps  zmm30,dword [rcx]{1to16},0x7b'         );
  TestCase.testcase(4833, [$62,$63,$7D,$48,$04,$72,$7F,$7B                   ] , 'vpermilps  zmm30,zword [rdx+0x1fc0],0x7b'         );
  TestCase.testcase(4834, [$62,$63,$7D,$48,$04,$B2,$00,$20,$00,$00,$7B       ] , 'vpermilps  zmm30,zword [rdx+0x2000],0x7b'         );
  TestCase.testcase(4835, [$62,$63,$7D,$48,$04,$72,$80,$7B                   ] , 'vpermilps  zmm30,zword [rdx-0x2000],0x7b'         );
  TestCase.testcase(4836, [$62,$63,$7D,$48,$04,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpermilps  zmm30,zword [rdx-0x2040],0x7b'         );
  TestCase.testcase(4837, [$62,$63,$7D,$58,$04,$72,$7F,$7B                   ] , 'vpermilps  zmm30,dword [rdx+0x1fc]{1to16},0x7b'   );
  TestCase.testcase(4838, [$62,$63,$7D,$58,$04,$B2,$00,$02,$00,$00,$7B       ] , 'vpermilps  zmm30,dword [rdx+0x200]{1to16},0x7b'   );
  TestCase.testcase(4839, [$62,$63,$7D,$58,$04,$72,$80,$7B                   ] , 'vpermilps  zmm30,dword [rdx-0x200]{1to16},0x7b'   );
  TestCase.testcase(4840, [$62,$63,$7D,$58,$04,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vpermilps  zmm30,dword [rdx-0x204]{1to16},0x7b'   );
  TestCase.testcase(4841, [$62,$02,$15,$40,$0C,$F4                           ] , 'vpermilps  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(4842, [$62,$02,$15,$47,$0C,$F4                           ] , 'vpermilps  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(4843, [$62,$02,$15,$C7,$0C,$F4                           ] , 'vpermilps  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(4844, [$62,$62,$15,$40,$0C,$31                           ] , 'vpermilps  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(4845, [$62,$22,$15,$40,$0C,$B4,$F0,$23,$01,$00,$00       ] , 'vpermilps  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(4846, [$62,$62,$15,$50,$0C,$31                           ] , 'vpermilps  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(4847, [$62,$62,$15,$40,$0C,$72,$7F                       ] , 'vpermilps  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(4848, [$62,$62,$15,$40,$0C,$B2,$00,$20,$00,$00           ] , 'vpermilps  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(4849, [$62,$62,$15,$40,$0C,$72,$80                       ] , 'vpermilps  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(4850, [$62,$62,$15,$40,$0C,$B2,$C0,$DF,$FF,$FF           ] , 'vpermilps  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(4851, [$62,$62,$15,$50,$0C,$72,$7F                       ] , 'vpermilps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(4852, [$62,$62,$15,$50,$0C,$B2,$00,$02,$00,$00           ] , 'vpermilps  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(4853, [$62,$62,$15,$50,$0C,$72,$80                       ] , 'vpermilps  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(4854, [$62,$62,$15,$50,$0C,$B2,$FC,$FD,$FF,$FF           ] , 'vpermilps  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(4855, [$62,$03,$FD,$48,$01,$F5,$AB                       ] , 'vpermpd  zmm30,zmm29,0xab'                        );
  TestCase.testcase(4856, [$62,$03,$FD,$4F,$01,$F5,$AB                       ] , 'vpermpd  zmm30{k7},zmm29,0xab'                    );
  TestCase.testcase(4857, [$62,$03,$FD,$CF,$01,$F5,$AB                       ] , 'vpermpd  zmm30{k7}{z},zmm29,0xab'                 );
  TestCase.testcase(4858, [$62,$03,$FD,$48,$01,$F5,$7B                       ] , 'vpermpd  zmm30,zmm29,0x7b'                        );
  TestCase.testcase(4859, [$62,$63,$FD,$48,$01,$31,$7B                       ] , 'vpermpd  zmm30,zword [rcx],0x7b'                  );
  TestCase.testcase(4860, [$62,$23,$FD,$48,$01,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpermpd  zmm30,zword [rax+r14*8+0x123],0x7b'      );
  TestCase.testcase(4861, [$62,$63,$FD,$58,$01,$31,$7B                       ] , 'vpermpd  zmm30,qword [rcx]{1to8},0x7b'            );
  TestCase.testcase(4862, [$62,$63,$FD,$48,$01,$72,$7F,$7B                   ] , 'vpermpd  zmm30,zword [rdx+0x1fc0],0x7b'           );
  TestCase.testcase(4863, [$62,$63,$FD,$48,$01,$B2,$00,$20,$00,$00,$7B       ] , 'vpermpd  zmm30,zword [rdx+0x2000],0x7b'           );
  TestCase.testcase(4864, [$62,$63,$FD,$48,$01,$72,$80,$7B                   ] , 'vpermpd  zmm30,zword [rdx-0x2000],0x7b'           );
  TestCase.testcase(4865, [$62,$63,$FD,$48,$01,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpermpd  zmm30,zword [rdx-0x2040],0x7b'           );
  TestCase.testcase(4866, [$62,$63,$FD,$58,$01,$72,$7F,$7B                   ] , 'vpermpd  zmm30,qword [rdx+0x3f8]{1to8},0x7b'      );
  TestCase.testcase(4867, [$62,$63,$FD,$58,$01,$B2,$00,$04,$00,$00,$7B       ] , 'vpermpd  zmm30,qword [rdx+0x400]{1to8},0x7b'      );
  TestCase.testcase(4868, [$62,$63,$FD,$58,$01,$72,$80,$7B                   ] , 'vpermpd  zmm30,qword [rdx-0x400]{1to8},0x7b'      );
  TestCase.testcase(4869, [$62,$63,$FD,$58,$01,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vpermpd  zmm30,qword [rdx-0x408]{1to8},0x7b'      );
  TestCase.testcase(4870, [$62,$02,$15,$40,$16,$F4                           ] , 'vpermps  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(4871, [$62,$02,$15,$47,$16,$F4                           ] , 'vpermps  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(4872, [$62,$02,$15,$C7,$16,$F4                           ] , 'vpermps  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(4873, [$62,$62,$15,$40,$16,$31                           ] , 'vpermps  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(4874, [$62,$22,$15,$40,$16,$B4,$F0,$23,$01,$00,$00       ] , 'vpermps  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4875, [$62,$62,$15,$50,$16,$31                           ] , 'vpermps  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(4876, [$62,$62,$15,$40,$16,$72,$7F                       ] , 'vpermps  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4877, [$62,$62,$15,$40,$16,$B2,$00,$20,$00,$00           ] , 'vpermps  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(4878, [$62,$62,$15,$40,$16,$72,$80                       ] , 'vpermps  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(4879, [$62,$62,$15,$40,$16,$B2,$C0,$DF,$FF,$FF           ] , 'vpermps  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(4880, [$62,$62,$15,$50,$16,$72,$7F                       ] , 'vpermps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(4881, [$62,$62,$15,$50,$16,$B2,$00,$02,$00,$00           ] , 'vpermps  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(4882, [$62,$62,$15,$50,$16,$72,$80                       ] , 'vpermps  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(4883, [$62,$62,$15,$50,$16,$B2,$FC,$FD,$FF,$FF           ] , 'vpermps  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(4884, [$62,$03,$FD,$48,$00,$F5,$AB                       ] , 'vpermq  zmm30,zmm29,0xab'                         );
  TestCase.testcase(4885, [$62,$03,$FD,$4F,$00,$F5,$AB                       ] , 'vpermq  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(4886, [$62,$03,$FD,$CF,$00,$F5,$AB                       ] , 'vpermq  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(4887, [$62,$03,$FD,$48,$00,$F5,$7B                       ] , 'vpermq  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(4888, [$62,$63,$FD,$48,$00,$31,$7B                       ] , 'vpermq  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(4889, [$62,$23,$FD,$48,$00,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpermq  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(4890, [$62,$63,$FD,$58,$00,$31,$7B                       ] , 'vpermq  zmm30,qword [rcx]{1to8},0x7b'             );
  TestCase.testcase(4891, [$62,$63,$FD,$48,$00,$72,$7F,$7B                   ] , 'vpermq  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(4892, [$62,$63,$FD,$48,$00,$B2,$00,$20,$00,$00,$7B       ] , 'vpermq  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(4893, [$62,$63,$FD,$48,$00,$72,$80,$7B                   ] , 'vpermq  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(4894, [$62,$63,$FD,$48,$00,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpermq  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(4895, [$62,$63,$FD,$58,$00,$72,$7F,$7B                   ] , 'vpermq  zmm30,qword [rdx+0x3f8]{1to8},0x7b'       );
  TestCase.testcase(4896, [$62,$63,$FD,$58,$00,$B2,$00,$04,$00,$00,$7B       ] , 'vpermq  zmm30,qword [rdx+0x400]{1to8},0x7b'       );
  TestCase.testcase(4897, [$62,$63,$FD,$58,$00,$72,$80,$7B                   ] , 'vpermq  zmm30,qword [rdx-0x400]{1to8},0x7b'       );
  TestCase.testcase(4898, [$62,$63,$FD,$58,$00,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vpermq  zmm30,qword [rdx-0x408]{1to8},0x7b'       );
  TestCase.testcase(4899, [$62,$62,$7D,$48,$89,$31                           ] , 'vpexpandd  zmm30,zword [rcx]'                     );
  TestCase.testcase(4900, [$62,$62,$7D,$4F,$89,$31                           ] , 'vpexpandd  zmm30{k7},zword [rcx]'                 );
  TestCase.testcase(4901, [$62,$62,$7D,$CF,$89,$31                           ] , 'vpexpandd  zmm30{k7}{z},zword [rcx]'              );
  TestCase.testcase(4902, [$62,$22,$7D,$48,$89,$B4,$F0,$23,$01,$00,$00       ] , 'vpexpandd  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(4903, [$62,$62,$7D,$48,$89,$72,$7F                       ] , 'vpexpandd  zmm30,zword [rdx+0x1fc]'               );
  TestCase.testcase(4904, [$62,$62,$7D,$48,$89,$B2,$00,$02,$00,$00           ] , 'vpexpandd  zmm30,zword [rdx+0x200]'               );
  TestCase.testcase(4905, [$62,$62,$7D,$48,$89,$72,$80                       ] , 'vpexpandd  zmm30,zword [rdx-0x200]'               );
  TestCase.testcase(4906, [$62,$62,$7D,$48,$89,$B2,$FC,$FD,$FF,$FF           ] , 'vpexpandd  zmm30,zword [rdx-0x204]'               );
  TestCase.testcase(4907, [$62,$02,$7D,$48,$89,$F5                           ] , 'vpexpandd  zmm30,zmm29'                           );
  TestCase.testcase(4908, [$62,$02,$7D,$4F,$89,$F5                           ] , 'vpexpandd  zmm30{k7},zmm29'                       );
  TestCase.testcase(4909, [$62,$02,$7D,$CF,$89,$F5                           ] , 'vpexpandd  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(4910, [$62,$62,$FD,$48,$89,$31                           ] , 'vpexpandq  zmm30,zword [rcx]'                     );
  TestCase.testcase(4911, [$62,$62,$FD,$4F,$89,$31                           ] , 'vpexpandq  zmm30{k7},zword [rcx]'                 );
  TestCase.testcase(4912, [$62,$62,$FD,$CF,$89,$31                           ] , 'vpexpandq  zmm30{k7}{z},zword [rcx]'              );
  TestCase.testcase(4913, [$62,$22,$FD,$48,$89,$B4,$F0,$23,$01,$00,$00       ] , 'vpexpandq  zmm30,zword [rax+r14*8+0x123]'         );
  TestCase.testcase(4914, [$62,$62,$FD,$48,$89,$72,$7F                       ] , 'vpexpandq  zmm30,zword [rdx+0x3f8]'               );
  TestCase.testcase(4915, [$62,$62,$FD,$48,$89,$B2,$00,$04,$00,$00           ] , 'vpexpandq  zmm30,zword [rdx+0x400]'               );
  TestCase.testcase(4916, [$62,$62,$FD,$48,$89,$72,$80                       ] , 'vpexpandq  zmm30,zword [rdx-0x400]'               );
  TestCase.testcase(4917, [$62,$62,$FD,$48,$89,$B2,$F8,$FB,$FF,$FF           ] , 'vpexpandq  zmm30,zword [rdx-0x408]'               );
  TestCase.testcase(4918, [$62,$02,$FD,$48,$89,$F5                           ] , 'vpexpandq  zmm30,zmm29'                           );
  TestCase.testcase(4919, [$62,$02,$FD,$4F,$89,$F5                           ] , 'vpexpandq  zmm30{k7},zmm29'                       );
  TestCase.testcase(4920, [$62,$02,$FD,$CF,$89,$F5                           ] , 'vpexpandq  zmm30{k7}{z},zmm29'                    );
  TestCase.testcase(4921, [$62,$02,$7D,$41,$90,$B4,$FE,$7B,$00,$00,$00       ] , 'vpgatherdd  zmm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(4922, [$62,$02,$7D,$41,$90,$B4,$FE,$7B,$00,$00,$00       ] , 'vpgatherdd  zmm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(4923, [$62,$02,$7D,$41,$90,$74,$39,$40                   ] , 'vpgatherdd  zmm30{k1},zword [r9+zmm31*1+0x100]'   );
  TestCase.testcase(4924, [$62,$22,$7D,$41,$90,$B4,$B9,$00,$04,$00,$00       ] , 'vpgatherdd  zmm30{k1},zword [rcx+zmm31*4+0x400]'  );
  TestCase.testcase(4925, [$62,$02,$FD,$41,$90,$B4,$FE,$7B,$00,$00,$00       ] , 'vpgatherdq  zmm30{k1},zword [r14+ymm31*8+0x7b]'   );
  TestCase.testcase(4926, [$62,$02,$FD,$41,$90,$B4,$FE,$7B,$00,$00,$00       ] , 'vpgatherdq  zmm30{k1},zword [r14+ymm31*8+0x7b]'   );
  TestCase.testcase(4927, [$62,$02,$FD,$41,$90,$74,$39,$20                   ] , 'vpgatherdq  zmm30{k1},zword [r9+ymm31*1+0x100]'   );
  TestCase.testcase(4928, [$62,$22,$FD,$41,$90,$B4,$B9,$00,$04,$00,$00       ] , 'vpgatherdq  zmm30{k1},zword [rcx+ymm31*4+0x400]'  );
  TestCase.testcase(4929, [$62,$02,$FD,$41,$91,$B4,$FE,$7B,$00,$00,$00       ] , 'vpgatherqq  zmm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(4930, [$62,$02,$FD,$41,$91,$B4,$FE,$7B,$00,$00,$00       ] , 'vpgatherqq  zmm30{k1},zword [r14+zmm31*8+0x7b]'   );
  TestCase.testcase(4931, [$62,$02,$FD,$41,$91,$74,$39,$20                   ] , 'vpgatherqq  zmm30{k1},zword [r9+zmm31*1+0x100]'   );
  TestCase.testcase(4932, [$62,$22,$FD,$41,$91,$B4,$B9,$00,$04,$00,$00       ] , 'vpgatherqq  zmm30{k1},zword [rcx+zmm31*4+0x400]'  );
  TestCase.testcase(4933, [$62,$02,$15,$40,$3D,$F4                           ] , 'vpmaxsd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(4934, [$62,$02,$15,$47,$3D,$F4                           ] , 'vpmaxsd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(4935, [$62,$02,$15,$C7,$3D,$F4                           ] , 'vpmaxsd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(4936, [$62,$62,$15,$40,$3D,$31                           ] , 'vpmaxsd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(4937, [$62,$22,$15,$40,$3D,$B4,$F0,$23,$01,$00,$00       ] , 'vpmaxsd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4938, [$62,$62,$15,$50,$3D,$31                           ] , 'vpmaxsd  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(4939, [$62,$62,$15,$40,$3D,$72,$7F                       ] , 'vpmaxsd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4940, [$62,$62,$15,$40,$3D,$B2,$00,$20,$00,$00           ] , 'vpmaxsd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(4941, [$62,$62,$15,$40,$3D,$72,$80                       ] , 'vpmaxsd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(4942, [$62,$62,$15,$40,$3D,$B2,$C0,$DF,$FF,$FF           ] , 'vpmaxsd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(4943, [$62,$62,$15,$50,$3D,$72,$7F                       ] , 'vpmaxsd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(4944, [$62,$62,$15,$50,$3D,$B2,$00,$02,$00,$00           ] , 'vpmaxsd  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(4945, [$62,$62,$15,$50,$3D,$72,$80                       ] , 'vpmaxsd  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(4946, [$62,$62,$15,$50,$3D,$B2,$FC,$FD,$FF,$FF           ] , 'vpmaxsd  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(4947, [$62,$02,$95,$40,$3D,$F4                           ] , 'vpmaxsq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(4948, [$62,$02,$95,$47,$3D,$F4                           ] , 'vpmaxsq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(4949, [$62,$02,$95,$C7,$3D,$F4                           ] , 'vpmaxsq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(4950, [$62,$62,$95,$40,$3D,$31                           ] , 'vpmaxsq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(4951, [$62,$22,$95,$40,$3D,$B4,$F0,$23,$01,$00,$00       ] , 'vpmaxsq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4952, [$62,$62,$95,$50,$3D,$31                           ] , 'vpmaxsq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(4953, [$62,$62,$95,$40,$3D,$72,$7F                       ] , 'vpmaxsq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4954, [$62,$62,$95,$40,$3D,$B2,$00,$20,$00,$00           ] , 'vpmaxsq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(4955, [$62,$62,$95,$40,$3D,$72,$80                       ] , 'vpmaxsq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(4956, [$62,$62,$95,$40,$3D,$B2,$C0,$DF,$FF,$FF           ] , 'vpmaxsq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(4957, [$62,$62,$95,$50,$3D,$72,$7F                       ] , 'vpmaxsq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(4958, [$62,$62,$95,$50,$3D,$B2,$00,$04,$00,$00           ] , 'vpmaxsq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(4959, [$62,$62,$95,$50,$3D,$72,$80                       ] , 'vpmaxsq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(4960, [$62,$62,$95,$50,$3D,$B2,$F8,$FB,$FF,$FF           ] , 'vpmaxsq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(4961, [$62,$02,$15,$40,$3F,$F4                           ] , 'vpmaxud  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(4962, [$62,$02,$15,$47,$3F,$F4                           ] , 'vpmaxud  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(4963, [$62,$02,$15,$C7,$3F,$F4                           ] , 'vpmaxud  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(4964, [$62,$62,$15,$40,$3F,$31                           ] , 'vpmaxud  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(4965, [$62,$22,$15,$40,$3F,$B4,$F0,$23,$01,$00,$00       ] , 'vpmaxud  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4966, [$62,$62,$15,$50,$3F,$31                           ] , 'vpmaxud  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(4967, [$62,$62,$15,$40,$3F,$72,$7F                       ] , 'vpmaxud  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4968, [$62,$62,$15,$40,$3F,$B2,$00,$20,$00,$00           ] , 'vpmaxud  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(4969, [$62,$62,$15,$40,$3F,$72,$80                       ] , 'vpmaxud  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(4970, [$62,$62,$15,$40,$3F,$B2,$C0,$DF,$FF,$FF           ] , 'vpmaxud  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(4971, [$62,$62,$15,$50,$3F,$72,$7F                       ] , 'vpmaxud  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(4972, [$62,$62,$15,$50,$3F,$B2,$00,$02,$00,$00           ] , 'vpmaxud  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(4973, [$62,$62,$15,$50,$3F,$72,$80                       ] , 'vpmaxud  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(4974, [$62,$62,$15,$50,$3F,$B2,$FC,$FD,$FF,$FF           ] , 'vpmaxud  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(4975, [$62,$02,$95,$40,$3F,$F4                           ] , 'vpmaxuq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(4976, [$62,$02,$95,$47,$3F,$F4                           ] , 'vpmaxuq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(4977, [$62,$02,$95,$C7,$3F,$F4                           ] , 'vpmaxuq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(4978, [$62,$62,$95,$40,$3F,$31                           ] , 'vpmaxuq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(4979, [$62,$22,$95,$40,$3F,$B4,$F0,$23,$01,$00,$00       ] , 'vpmaxuq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4980, [$62,$62,$95,$50,$3F,$31                           ] , 'vpmaxuq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(4981, [$62,$62,$95,$40,$3F,$72,$7F                       ] , 'vpmaxuq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4982, [$62,$62,$95,$40,$3F,$B2,$00,$20,$00,$00           ] , 'vpmaxuq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(4983, [$62,$62,$95,$40,$3F,$72,$80                       ] , 'vpmaxuq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(4984, [$62,$62,$95,$40,$3F,$B2,$C0,$DF,$FF,$FF           ] , 'vpmaxuq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(4985, [$62,$62,$95,$50,$3F,$72,$7F                       ] , 'vpmaxuq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(4986, [$62,$62,$95,$50,$3F,$B2,$00,$04,$00,$00           ] , 'vpmaxuq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(4987, [$62,$62,$95,$50,$3F,$72,$80                       ] , 'vpmaxuq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(4988, [$62,$62,$95,$50,$3F,$B2,$F8,$FB,$FF,$FF           ] , 'vpmaxuq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(4989, [$62,$02,$15,$40,$39,$F4                           ] , 'vpminsd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(4990, [$62,$02,$15,$47,$39,$F4                           ] , 'vpminsd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(4991, [$62,$02,$15,$C7,$39,$F4                           ] , 'vpminsd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(4992, [$62,$62,$15,$40,$39,$31                           ] , 'vpminsd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(4993, [$62,$22,$15,$40,$39,$B4,$F0,$23,$01,$00,$00       ] , 'vpminsd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(4994, [$62,$62,$15,$50,$39,$31                           ] , 'vpminsd  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(4995, [$62,$62,$15,$40,$39,$72,$7F                       ] , 'vpminsd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(4996, [$62,$62,$15,$40,$39,$B2,$00,$20,$00,$00           ] , 'vpminsd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(4997, [$62,$62,$15,$40,$39,$72,$80                       ] , 'vpminsd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(4998, [$62,$62,$15,$40,$39,$B2,$C0,$DF,$FF,$FF           ] , 'vpminsd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(4999, [$62,$62,$15,$50,$39,$72,$7F                       ] , 'vpminsd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(5000, [$62,$62,$15,$50,$39,$B2,$00,$02,$00,$00           ] , 'vpminsd  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(5001, [$62,$62,$15,$50,$39,$72,$80                       ] , 'vpminsd  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(5002, [$62,$62,$15,$50,$39,$B2,$FC,$FD,$FF,$FF           ] , 'vpminsd  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(5003, [$62,$02,$95,$40,$39,$F4                           ] , 'vpminsq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5004, [$62,$02,$95,$47,$39,$F4                           ] , 'vpminsq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5005, [$62,$02,$95,$C7,$39,$F4                           ] , 'vpminsq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5006, [$62,$62,$95,$40,$39,$31                           ] , 'vpminsq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5007, [$62,$22,$95,$40,$39,$B4,$F0,$23,$01,$00,$00       ] , 'vpminsq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5008, [$62,$62,$95,$50,$39,$31                           ] , 'vpminsq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(5009, [$62,$62,$95,$40,$39,$72,$7F                       ] , 'vpminsq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5010, [$62,$62,$95,$40,$39,$B2,$00,$20,$00,$00           ] , 'vpminsq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5011, [$62,$62,$95,$40,$39,$72,$80                       ] , 'vpminsq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5012, [$62,$62,$95,$40,$39,$B2,$C0,$DF,$FF,$FF           ] , 'vpminsq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5013, [$62,$62,$95,$50,$39,$72,$7F                       ] , 'vpminsq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(5014, [$62,$62,$95,$50,$39,$B2,$00,$04,$00,$00           ] , 'vpminsq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(5015, [$62,$62,$95,$50,$39,$72,$80                       ] , 'vpminsq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(5016, [$62,$62,$95,$50,$39,$B2,$F8,$FB,$FF,$FF           ] , 'vpminsq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(5017, [$62,$02,$15,$40,$3B,$F4                           ] , 'vpminud  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5018, [$62,$02,$15,$47,$3B,$F4                           ] , 'vpminud  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5019, [$62,$02,$15,$C7,$3B,$F4                           ] , 'vpminud  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5020, [$62,$62,$15,$40,$3B,$31                           ] , 'vpminud  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5021, [$62,$22,$15,$40,$3B,$B4,$F0,$23,$01,$00,$00       ] , 'vpminud  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5022, [$62,$62,$15,$50,$3B,$31                           ] , 'vpminud  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(5023, [$62,$62,$15,$40,$3B,$72,$7F                       ] , 'vpminud  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5024, [$62,$62,$15,$40,$3B,$B2,$00,$20,$00,$00           ] , 'vpminud  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5025, [$62,$62,$15,$40,$3B,$72,$80                       ] , 'vpminud  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5026, [$62,$62,$15,$40,$3B,$B2,$C0,$DF,$FF,$FF           ] , 'vpminud  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5027, [$62,$62,$15,$50,$3B,$72,$7F                       ] , 'vpminud  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(5028, [$62,$62,$15,$50,$3B,$B2,$00,$02,$00,$00           ] , 'vpminud  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(5029, [$62,$62,$15,$50,$3B,$72,$80                       ] , 'vpminud  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(5030, [$62,$62,$15,$50,$3B,$B2,$FC,$FD,$FF,$FF           ] , 'vpminud  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(5031, [$62,$02,$95,$40,$3B,$F4                           ] , 'vpminuq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5032, [$62,$02,$95,$47,$3B,$F4                           ] , 'vpminuq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5033, [$62,$02,$95,$C7,$3B,$F4                           ] , 'vpminuq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5034, [$62,$62,$95,$40,$3B,$31                           ] , 'vpminuq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5035, [$62,$22,$95,$40,$3B,$B4,$F0,$23,$01,$00,$00       ] , 'vpminuq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5036, [$62,$62,$95,$50,$3B,$31                           ] , 'vpminuq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(5037, [$62,$62,$95,$40,$3B,$72,$7F                       ] , 'vpminuq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5038, [$62,$62,$95,$40,$3B,$B2,$00,$20,$00,$00           ] , 'vpminuq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5039, [$62,$62,$95,$40,$3B,$72,$80                       ] , 'vpminuq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5040, [$62,$62,$95,$40,$3B,$B2,$C0,$DF,$FF,$FF           ] , 'vpminuq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5041, [$62,$62,$95,$50,$3B,$72,$7F                       ] , 'vpminuq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(5042, [$62,$62,$95,$50,$3B,$B2,$00,$04,$00,$00           ] , 'vpminuq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(5043, [$62,$62,$95,$50,$3B,$72,$80                       ] , 'vpminuq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(5044, [$62,$62,$95,$50,$3B,$B2,$F8,$FB,$FF,$FF           ] , 'vpminuq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(5045, [$62,$02,$7D,$4F,$21,$F5                           ] , 'vpmovsxbd  zmm30{k7},xmm29'                       );
  TestCase.testcase(5046, [$62,$02,$7D,$CF,$21,$F5                           ] , 'vpmovsxbd  zmm30{k7}{z},xmm29'                    );
  TestCase.testcase(5047, [$62,$62,$7D,$4F,$21,$31                           ] , 'vpmovsxbd  zmm30{k7},oword [rcx]'                 );
  TestCase.testcase(5048, [$62,$22,$7D,$4F,$21,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsxbd  zmm30{k7},oword [rax+r14*8+0x123]'     );
  TestCase.testcase(5049, [$62,$62,$7D,$4F,$21,$72,$7F                       ] , 'vpmovsxbd  zmm30{k7},oword [rdx+0x7f0]'           );
  TestCase.testcase(5050, [$62,$62,$7D,$4F,$21,$B2,$00,$08,$00,$00           ] , 'vpmovsxbd  zmm30{k7},oword [rdx+0x800]'           );
  TestCase.testcase(5051, [$62,$62,$7D,$4F,$21,$72,$80                       ] , 'vpmovsxbd  zmm30{k7},oword [rdx-0x800]'           );
  TestCase.testcase(5052, [$62,$62,$7D,$4F,$21,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovsxbd  zmm30{k7},oword [rdx-0x810]'           );
  TestCase.testcase(5053, [$62,$02,$7D,$4F,$22,$F5                           ] , 'vpmovsxbq  zmm30{k7},xmm29'                       );
  TestCase.testcase(5054, [$62,$02,$7D,$CF,$22,$F5                           ] , 'vpmovsxbq  zmm30{k7}{z},xmm29'                    );
  TestCase.testcase(5055, [$62,$62,$7D,$4F,$22,$31                           ] , 'vpmovsxbq  zmm30{k7},qword [rcx]'                 );
  TestCase.testcase(5056, [$62,$22,$7D,$4F,$22,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsxbq  zmm30{k7},qword [rax+r14*8+0x123]'     );
  TestCase.testcase(5057, [$62,$62,$7D,$4F,$22,$72,$7F                       ] , 'vpmovsxbq  zmm30{k7},qword [rdx+0x3f8]'           );
  TestCase.testcase(5058, [$62,$62,$7D,$4F,$22,$B2,$00,$04,$00,$00           ] , 'vpmovsxbq  zmm30{k7},qword [rdx+0x400]'           );
  TestCase.testcase(5059, [$62,$62,$7D,$4F,$22,$72,$80                       ] , 'vpmovsxbq  zmm30{k7},qword [rdx-0x400]'           );
  TestCase.testcase(5060, [$62,$62,$7D,$4F,$22,$B2,$F8,$FB,$FF,$FF           ] , 'vpmovsxbq  zmm30{k7},qword [rdx-0x408]'           );
  TestCase.testcase(5061, [$62,$02,$7D,$4F,$25,$F5                           ] , 'vpmovsxdq  zmm30{k7},ymm29'                       );
  TestCase.testcase(5062, [$62,$02,$7D,$CF,$25,$F5                           ] , 'vpmovsxdq  zmm30{k7}{z},ymm29'                    );
  TestCase.testcase(5063, [$62,$62,$7D,$4F,$25,$31                           ] , 'vpmovsxdq  zmm30{k7},yword [rcx]'                 );
  TestCase.testcase(5064, [$62,$22,$7D,$4F,$25,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsxdq  zmm30{k7},yword [rax+r14*8+0x123]'     );
  TestCase.testcase(5065, [$62,$62,$7D,$4F,$25,$72,$7F                       ] , 'vpmovsxdq  zmm30{k7},yword [rdx+0xfe0]'           );
  TestCase.testcase(5066, [$62,$62,$7D,$4F,$25,$B2,$00,$10,$00,$00           ] , 'vpmovsxdq  zmm30{k7},yword [rdx+0x1000]'          );
  TestCase.testcase(5067, [$62,$62,$7D,$4F,$25,$72,$80                       ] , 'vpmovsxdq  zmm30{k7},yword [rdx-0x1000]'          );
  TestCase.testcase(5068, [$62,$62,$7D,$4F,$25,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovsxdq  zmm30{k7},yword [rdx-0x1020]'          );
  TestCase.testcase(5069, [$62,$02,$7D,$4F,$23,$F5                           ] , 'vpmovsxwd  zmm30{k7},ymm29'                       );
  TestCase.testcase(5070, [$62,$02,$7D,$CF,$23,$F5                           ] , 'vpmovsxwd  zmm30{k7}{z},ymm29'                    );
  TestCase.testcase(5071, [$62,$62,$7D,$4F,$23,$31                           ] , 'vpmovsxwd  zmm30{k7},yword [rcx]'                 );
  TestCase.testcase(5072, [$62,$22,$7D,$4F,$23,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsxwd  zmm30{k7},yword [rax+r14*8+0x123]'     );
  TestCase.testcase(5073, [$62,$62,$7D,$4F,$23,$72,$7F                       ] , 'vpmovsxwd  zmm30{k7},yword [rdx+0xfe0]'           );
  TestCase.testcase(5074, [$62,$62,$7D,$4F,$23,$B2,$00,$10,$00,$00           ] , 'vpmovsxwd  zmm30{k7},yword [rdx+0x1000]'          );
  TestCase.testcase(5075, [$62,$62,$7D,$4F,$23,$72,$80                       ] , 'vpmovsxwd  zmm30{k7},yword [rdx-0x1000]'          );
  TestCase.testcase(5076, [$62,$62,$7D,$4F,$23,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovsxwd  zmm30{k7},yword [rdx-0x1020]'          );
  TestCase.testcase(5077, [$62,$02,$7D,$4F,$24,$F5                           ] , 'vpmovsxwq  zmm30{k7},xmm29'                       );
  TestCase.testcase(5078, [$62,$02,$7D,$CF,$24,$F5                           ] , 'vpmovsxwq  zmm30{k7}{z},xmm29'                    );
  TestCase.testcase(5079, [$62,$62,$7D,$4F,$24,$31                           ] , 'vpmovsxwq  zmm30{k7},oword [rcx]'                 );
  TestCase.testcase(5080, [$62,$22,$7D,$4F,$24,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsxwq  zmm30{k7},oword [rax+r14*8+0x123]'     );
  TestCase.testcase(5081, [$62,$62,$7D,$4F,$24,$72,$7F                       ] , 'vpmovsxwq  zmm30{k7},oword [rdx+0x7f0]'           );
  TestCase.testcase(5082, [$62,$62,$7D,$4F,$24,$B2,$00,$08,$00,$00           ] , 'vpmovsxwq  zmm30{k7},oword [rdx+0x800]'           );
  TestCase.testcase(5083, [$62,$62,$7D,$4F,$24,$72,$80                       ] , 'vpmovsxwq  zmm30{k7},oword [rdx-0x800]'           );
  TestCase.testcase(5084, [$62,$62,$7D,$4F,$24,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovsxwq  zmm30{k7},oword [rdx-0x810]'           );
  TestCase.testcase(5085, [$62,$02,$7D,$4F,$31,$F5                           ] , 'vpmovzxbd  zmm30{k7},xmm29'                       );
  TestCase.testcase(5086, [$62,$02,$7D,$CF,$31,$F5                           ] , 'vpmovzxbd  zmm30{k7}{z},xmm29'                    );
  TestCase.testcase(5087, [$62,$62,$7D,$4F,$31,$31                           ] , 'vpmovzxbd  zmm30{k7},oword [rcx]'                 );
  TestCase.testcase(5088, [$62,$22,$7D,$4F,$31,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovzxbd  zmm30{k7},oword [rax+r14*8+0x123]'     );
  TestCase.testcase(5089, [$62,$62,$7D,$4F,$31,$72,$7F                       ] , 'vpmovzxbd  zmm30{k7},oword [rdx+0x7f0]'           );
  TestCase.testcase(5090, [$62,$62,$7D,$4F,$31,$B2,$00,$08,$00,$00           ] , 'vpmovzxbd  zmm30{k7},oword [rdx+0x800]'           );
  TestCase.testcase(5091, [$62,$62,$7D,$4F,$31,$72,$80                       ] , 'vpmovzxbd  zmm30{k7},oword [rdx-0x800]'           );
  TestCase.testcase(5092, [$62,$62,$7D,$4F,$31,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovzxbd  zmm30{k7},oword [rdx-0x810]'           );
  TestCase.testcase(5093, [$62,$02,$7D,$4F,$32,$F5                           ] , 'vpmovzxbq  zmm30{k7},xmm29'                       );
  TestCase.testcase(5094, [$62,$02,$7D,$CF,$32,$F5                           ] , 'vpmovzxbq  zmm30{k7}{z},xmm29'                    );
  TestCase.testcase(5095, [$62,$62,$7D,$4F,$32,$31                           ] , 'vpmovzxbq  zmm30{k7},qword [rcx]'                 );
  TestCase.testcase(5096, [$62,$22,$7D,$4F,$32,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovzxbq  zmm30{k7},qword [rax+r14*8+0x123]'     );
  TestCase.testcase(5097, [$62,$62,$7D,$4F,$32,$72,$7F                       ] , 'vpmovzxbq  zmm30{k7},qword [rdx+0x3f8]'           );
  TestCase.testcase(5098, [$62,$62,$7D,$4F,$32,$B2,$00,$04,$00,$00           ] , 'vpmovzxbq  zmm30{k7},qword [rdx+0x400]'           );
  TestCase.testcase(5099, [$62,$62,$7D,$4F,$32,$72,$80                       ] , 'vpmovzxbq  zmm30{k7},qword [rdx-0x400]'           );
  TestCase.testcase(5100, [$62,$62,$7D,$4F,$32,$B2,$F8,$FB,$FF,$FF           ] , 'vpmovzxbq  zmm30{k7},qword [rdx-0x408]'           );
  TestCase.testcase(5101, [$62,$02,$7D,$4F,$35,$F5                           ] , 'vpmovzxdq  zmm30{k7},ymm29'                       );
  TestCase.testcase(5102, [$62,$02,$7D,$CF,$35,$F5                           ] , 'vpmovzxdq  zmm30{k7}{z},ymm29'                    );
  TestCase.testcase(5103, [$62,$62,$7D,$4F,$35,$31                           ] , 'vpmovzxdq  zmm30{k7},yword [rcx]'                 );
  TestCase.testcase(5104, [$62,$22,$7D,$4F,$35,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovzxdq  zmm30{k7},yword [rax+r14*8+0x123]'     );
  TestCase.testcase(5105, [$62,$62,$7D,$4F,$35,$72,$7F                       ] , 'vpmovzxdq  zmm30{k7},yword [rdx+0xfe0]'           );
  TestCase.testcase(5106, [$62,$62,$7D,$4F,$35,$B2,$00,$10,$00,$00           ] , 'vpmovzxdq  zmm30{k7},yword [rdx+0x1000]'          );
  TestCase.testcase(5107, [$62,$62,$7D,$4F,$35,$72,$80                       ] , 'vpmovzxdq  zmm30{k7},yword [rdx-0x1000]'          );
  TestCase.testcase(5108, [$62,$62,$7D,$4F,$35,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovzxdq  zmm30{k7},yword [rdx-0x1020]'          );
  TestCase.testcase(5109, [$62,$02,$7D,$4F,$33,$F5                           ] , 'vpmovzxwd  zmm30{k7},ymm29'                       );
  TestCase.testcase(5110, [$62,$02,$7D,$CF,$33,$F5                           ] , 'vpmovzxwd  zmm30{k7}{z},ymm29'                    );
  TestCase.testcase(5111, [$62,$62,$7D,$4F,$33,$31                           ] , 'vpmovzxwd  zmm30{k7},yword [rcx]'                 );
  TestCase.testcase(5112, [$62,$22,$7D,$4F,$33,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovzxwd  zmm30{k7},yword [rax+r14*8+0x123]'     );
  TestCase.testcase(5113, [$62,$62,$7D,$4F,$33,$72,$7F                       ] , 'vpmovzxwd  zmm30{k7},yword [rdx+0xfe0]'           );
  TestCase.testcase(5114, [$62,$62,$7D,$4F,$33,$B2,$00,$10,$00,$00           ] , 'vpmovzxwd  zmm30{k7},yword [rdx+0x1000]'          );
  TestCase.testcase(5115, [$62,$62,$7D,$4F,$33,$72,$80                       ] , 'vpmovzxwd  zmm30{k7},yword [rdx-0x1000]'          );
  TestCase.testcase(5116, [$62,$62,$7D,$4F,$33,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovzxwd  zmm30{k7},yword [rdx-0x1020]'          );
  TestCase.testcase(5117, [$62,$02,$7D,$4F,$34,$F5                           ] , 'vpmovzxwq  zmm30{k7},xmm29'                       );
  TestCase.testcase(5118, [$62,$02,$7D,$CF,$34,$F5                           ] , 'vpmovzxwq  zmm30{k7}{z},xmm29'                    );
  TestCase.testcase(5119, [$62,$62,$7D,$4F,$34,$31                           ] , 'vpmovzxwq  zmm30{k7},oword [rcx]'                 );
  TestCase.testcase(5120, [$62,$22,$7D,$4F,$34,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovzxwq  zmm30{k7},oword [rax+r14*8+0x123]'     );
  TestCase.testcase(5121, [$62,$62,$7D,$4F,$34,$72,$7F                       ] , 'vpmovzxwq  zmm30{k7},oword [rdx+0x7f0]'           );
  TestCase.testcase(5122, [$62,$62,$7D,$4F,$34,$B2,$00,$08,$00,$00           ] , 'vpmovzxwq  zmm30{k7},oword [rdx+0x800]'           );
  TestCase.testcase(5123, [$62,$62,$7D,$4F,$34,$72,$80                       ] , 'vpmovzxwq  zmm30{k7},oword [rdx-0x800]'           );
  TestCase.testcase(5124, [$62,$62,$7D,$4F,$34,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovzxwq  zmm30{k7},oword [rdx-0x810]'           );
  TestCase.testcase(5125, [$62,$02,$95,$40,$28,$F4                           ] , 'vpmuldq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5126, [$62,$02,$95,$47,$28,$F4                           ] , 'vpmuldq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5127, [$62,$02,$95,$C7,$28,$F4                           ] , 'vpmuldq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5128, [$62,$62,$95,$40,$28,$31                           ] , 'vpmuldq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5129, [$62,$22,$95,$40,$28,$B4,$F0,$23,$01,$00,$00       ] , 'vpmuldq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5130, [$62,$62,$95,$50,$28,$31                           ] , 'vpmuldq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(5131, [$62,$62,$95,$40,$28,$72,$7F                       ] , 'vpmuldq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5132, [$62,$62,$95,$40,$28,$B2,$00,$20,$00,$00           ] , 'vpmuldq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5133, [$62,$62,$95,$40,$28,$72,$80                       ] , 'vpmuldq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5134, [$62,$62,$95,$40,$28,$B2,$C0,$DF,$FF,$FF           ] , 'vpmuldq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5135, [$62,$62,$95,$50,$28,$72,$7F                       ] , 'vpmuldq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(5136, [$62,$62,$95,$50,$28,$B2,$00,$04,$00,$00           ] , 'vpmuldq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(5137, [$62,$62,$95,$50,$28,$72,$80                       ] , 'vpmuldq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(5138, [$62,$62,$95,$50,$28,$B2,$F8,$FB,$FF,$FF           ] , 'vpmuldq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(5139, [$62,$02,$15,$40,$40,$F4                           ] , 'vpmulld  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5140, [$62,$02,$15,$47,$40,$F4                           ] , 'vpmulld  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5141, [$62,$02,$15,$C7,$40,$F4                           ] , 'vpmulld  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5142, [$62,$62,$15,$40,$40,$31                           ] , 'vpmulld  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5143, [$62,$22,$15,$40,$40,$B4,$F0,$23,$01,$00,$00       ] , 'vpmulld  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5144, [$62,$62,$15,$50,$40,$31                           ] , 'vpmulld  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(5145, [$62,$62,$15,$40,$40,$72,$7F                       ] , 'vpmulld  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5146, [$62,$62,$15,$40,$40,$B2,$00,$20,$00,$00           ] , 'vpmulld  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5147, [$62,$62,$15,$40,$40,$72,$80                       ] , 'vpmulld  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5148, [$62,$62,$15,$40,$40,$B2,$C0,$DF,$FF,$FF           ] , 'vpmulld  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5149, [$62,$62,$15,$50,$40,$72,$7F                       ] , 'vpmulld  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(5150, [$62,$62,$15,$50,$40,$B2,$00,$02,$00,$00           ] , 'vpmulld  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(5151, [$62,$62,$15,$50,$40,$72,$80                       ] , 'vpmulld  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(5152, [$62,$62,$15,$50,$40,$B2,$FC,$FD,$FF,$FF           ] , 'vpmulld  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(5153, [$62,$01,$95,$40,$F4,$F4                           ] , 'vpmuludq  zmm30,zmm29,zmm28'                      );
  TestCase.testcase(5154, [$62,$01,$95,$47,$F4,$F4                           ] , 'vpmuludq  zmm30{k7},zmm29,zmm28'                  );
  TestCase.testcase(5155, [$62,$01,$95,$C7,$F4,$F4                           ] , 'vpmuludq  zmm30{k7}{z},zmm29,zmm28'               );
  TestCase.testcase(5156, [$62,$61,$95,$40,$F4,$31                           ] , 'vpmuludq  zmm30,zmm29,zword [rcx]'                );
  TestCase.testcase(5157, [$62,$21,$95,$40,$F4,$B4,$F0,$23,$01,$00,$00       ] , 'vpmuludq  zmm30,zmm29,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(5158, [$62,$61,$95,$50,$F4,$31                           ] , 'vpmuludq  zmm30,zmm29,qword [rcx]{1to8}'          );
  TestCase.testcase(5159, [$62,$61,$95,$40,$F4,$72,$7F                       ] , 'vpmuludq  zmm30,zmm29,zword [rdx+0x1fc0]'         );
  TestCase.testcase(5160, [$62,$61,$95,$40,$F4,$B2,$00,$20,$00,$00           ] , 'vpmuludq  zmm30,zmm29,zword [rdx+0x2000]'         );
  TestCase.testcase(5161, [$62,$61,$95,$40,$F4,$72,$80                       ] , 'vpmuludq  zmm30,zmm29,zword [rdx-0x2000]'         );
  TestCase.testcase(5162, [$62,$61,$95,$40,$F4,$B2,$C0,$DF,$FF,$FF           ] , 'vpmuludq  zmm30,zmm29,zword [rdx-0x2040]'         );
  TestCase.testcase(5163, [$62,$61,$95,$50,$F4,$72,$7F                       ] , 'vpmuludq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(5164, [$62,$61,$95,$50,$F4,$B2,$00,$04,$00,$00           ] , 'vpmuludq  zmm30,zmm29,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(5165, [$62,$61,$95,$50,$F4,$72,$80                       ] , 'vpmuludq  zmm30,zmm29,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(5166, [$62,$61,$95,$50,$F4,$B2,$F8,$FB,$FF,$FF           ] , 'vpmuludq  zmm30,zmm29,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(5167, [$62,$01,$15,$40,$EB,$F4                           ] , 'vpord  zmm30,zmm29,zmm28'                         );
  TestCase.testcase(5168, [$62,$01,$15,$47,$EB,$F4                           ] , 'vpord  zmm30{k7},zmm29,zmm28'                     );
  TestCase.testcase(5169, [$62,$01,$15,$C7,$EB,$F4                           ] , 'vpord  zmm30{k7}{z},zmm29,zmm28'                  );
  TestCase.testcase(5170, [$62,$61,$15,$40,$EB,$31                           ] , 'vpord  zmm30,zmm29,zword [rcx]'                   );
  TestCase.testcase(5171, [$62,$21,$15,$40,$EB,$B4,$F0,$23,$01,$00,$00       ] , 'vpord  zmm30,zmm29,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(5172, [$62,$61,$15,$50,$EB,$31                           ] , 'vpord  zmm30,zmm29,dword [rcx]{1to16}'            );
  TestCase.testcase(5173, [$62,$61,$15,$40,$EB,$72,$7F                       ] , 'vpord  zmm30,zmm29,zword [rdx+0x1fc0]'            );
  TestCase.testcase(5174, [$62,$61,$15,$40,$EB,$B2,$00,$20,$00,$00           ] , 'vpord  zmm30,zmm29,zword [rdx+0x2000]'            );
  TestCase.testcase(5175, [$62,$61,$15,$40,$EB,$72,$80                       ] , 'vpord  zmm30,zmm29,zword [rdx-0x2000]'            );
  TestCase.testcase(5176, [$62,$61,$15,$40,$EB,$B2,$C0,$DF,$FF,$FF           ] , 'vpord  zmm30,zmm29,zword [rdx-0x2040]'            );
  TestCase.testcase(5177, [$62,$61,$15,$50,$EB,$72,$7F                       ] , 'vpord  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(5178, [$62,$61,$15,$50,$EB,$B2,$00,$02,$00,$00           ] , 'vpord  zmm30,zmm29,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(5179, [$62,$61,$15,$50,$EB,$72,$80                       ] , 'vpord  zmm30,zmm29,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(5180, [$62,$61,$15,$50,$EB,$B2,$FC,$FD,$FF,$FF           ] , 'vpord  zmm30,zmm29,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(5181, [$62,$01,$95,$40,$EB,$F4                           ] , 'vporq  zmm30,zmm29,zmm28'                         );
  TestCase.testcase(5182, [$62,$01,$95,$47,$EB,$F4                           ] , 'vporq  zmm30{k7},zmm29,zmm28'                     );
  TestCase.testcase(5183, [$62,$01,$95,$C7,$EB,$F4                           ] , 'vporq  zmm30{k7}{z},zmm29,zmm28'                  );
  TestCase.testcase(5184, [$62,$61,$95,$40,$EB,$31                           ] , 'vporq  zmm30,zmm29,zword [rcx]'                   );
  TestCase.testcase(5185, [$62,$21,$95,$40,$EB,$B4,$F0,$23,$01,$00,$00       ] , 'vporq  zmm30,zmm29,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(5186, [$62,$61,$95,$50,$EB,$31                           ] , 'vporq  zmm30,zmm29,qword [rcx]{1to8}'             );
  TestCase.testcase(5187, [$62,$61,$95,$40,$EB,$72,$7F                       ] , 'vporq  zmm30,zmm29,zword [rdx+0x1fc0]'            );
  TestCase.testcase(5188, [$62,$61,$95,$40,$EB,$B2,$00,$20,$00,$00           ] , 'vporq  zmm30,zmm29,zword [rdx+0x2000]'            );
  TestCase.testcase(5189, [$62,$61,$95,$40,$EB,$72,$80                       ] , 'vporq  zmm30,zmm29,zword [rdx-0x2000]'            );
  TestCase.testcase(5190, [$62,$61,$95,$40,$EB,$B2,$C0,$DF,$FF,$FF           ] , 'vporq  zmm30,zmm29,zword [rdx-0x2040]'            );
  TestCase.testcase(5191, [$62,$61,$95,$50,$EB,$72,$7F                       ] , 'vporq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(5192, [$62,$61,$95,$50,$EB,$B2,$00,$04,$00,$00           ] , 'vporq  zmm30,zmm29,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(5193, [$62,$61,$95,$50,$EB,$72,$80                       ] , 'vporq  zmm30,zmm29,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(5194, [$62,$61,$95,$50,$EB,$B2,$F8,$FB,$FF,$FF           ] , 'vporq  zmm30,zmm29,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(5195, [$62,$02,$7D,$41,$A0,$B4,$FE,$7B,$00,$00,$00       ] , 'vpscatterdd  zword [r14+zmm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5196, [$62,$02,$7D,$41,$A0,$B4,$FE,$7B,$00,$00,$00       ] , 'vpscatterdd  zword [r14+zmm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5197, [$62,$02,$7D,$41,$A0,$74,$39,$40                   ] , 'vpscatterdd  zword [r9+zmm31*1+0x100]{k1},zmm30'  );
  TestCase.testcase(5198, [$62,$22,$7D,$41,$A0,$B4,$B9,$00,$04,$00,$00       ] , 'vpscatterdd  zword [rcx+zmm31*4+0x400]{k1},zmm30' );
  TestCase.testcase(5199, [$62,$02,$FD,$41,$A0,$B4,$FE,$7B,$00,$00,$00       ] , 'vpscatterdq  zword [r14+ymm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5200, [$62,$02,$FD,$41,$A0,$B4,$FE,$7B,$00,$00,$00       ] , 'vpscatterdq  zword [r14+ymm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5201, [$62,$02,$FD,$41,$A0,$74,$39,$20                   ] , 'vpscatterdq  zword [r9+ymm31*1+0x100]{k1},zmm30'  );
  TestCase.testcase(5202, [$62,$22,$FD,$41,$A0,$B4,$B9,$00,$04,$00,$00       ] , 'vpscatterdq  zword [rcx+ymm31*4+0x400]{k1},zmm30' );
  TestCase.testcase(5203, [$62,$02,$7D,$41,$A1,$B4,$FE,$7B,$00,$00,$00       ] , 'vpscatterqd  zword [r14+zmm31*8+0x7b]{k1},ymm30'  );
  TestCase.testcase(5204, [$62,$02,$7D,$41,$A1,$B4,$FE,$7B,$00,$00,$00       ] , 'vpscatterqd  zword [r14+zmm31*8+0x7b]{k1},ymm30'  );
  TestCase.testcase(5205, [$62,$02,$7D,$41,$A1,$74,$39,$40                   ] , 'vpscatterqd  zword [r9+zmm31*1+0x200]{k1},ymm30'  );
  TestCase.testcase(5206, [$62,$22,$7D,$41,$A1,$B4,$B9,$00,$04,$00,$00       ] , 'vpscatterqd  zword [rcx+zmm31*4+0x400]{k1},ymm30' );
  TestCase.testcase(5207, [$62,$02,$FD,$41,$A1,$B4,$FE,$7B,$00,$00,$00       ] , 'vpscatterqq  zword [r14+zmm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5208, [$62,$02,$FD,$41,$A1,$B4,$FE,$7B,$00,$00,$00       ] , 'vpscatterqq  zword [r14+zmm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5209, [$62,$02,$FD,$41,$A1,$74,$39,$20                   ] , 'vpscatterqq  zword [r9+zmm31*1+0x100]{k1},zmm30'  );
  TestCase.testcase(5210, [$62,$22,$FD,$41,$A1,$B4,$B9,$00,$04,$00,$00       ] , 'vpscatterqq  zword [rcx+zmm31*4+0x400]{k1},zmm30' );
  TestCase.testcase(5211, [$62,$01,$7D,$48,$70,$F5,$AB                       ] , 'vpshufd  zmm30,zmm29,0xab'                        );
  TestCase.testcase(5212, [$62,$01,$7D,$4F,$70,$F5,$AB                       ] , 'vpshufd  zmm30{k7},zmm29,0xab'                    );
  TestCase.testcase(5213, [$62,$01,$7D,$CF,$70,$F5,$AB                       ] , 'vpshufd  zmm30{k7}{z},zmm29,0xab'                 );
  TestCase.testcase(5214, [$62,$01,$7D,$48,$70,$F5,$7B                       ] , 'vpshufd  zmm30,zmm29,0x7b'                        );
  TestCase.testcase(5215, [$62,$61,$7D,$48,$70,$31,$7B                       ] , 'vpshufd  zmm30,zword [rcx],0x7b'                  );
  TestCase.testcase(5216, [$62,$21,$7D,$48,$70,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpshufd  zmm30,zword [rax+r14*8+0x123],0x7b'      );
  TestCase.testcase(5217, [$62,$61,$7D,$58,$70,$31,$7B                       ] , 'vpshufd  zmm30,dword [rcx]{1to16},0x7b'           );
  TestCase.testcase(5218, [$62,$61,$7D,$48,$70,$72,$7F,$7B                   ] , 'vpshufd  zmm30,zword [rdx+0x1fc0],0x7b'           );
  TestCase.testcase(5219, [$62,$61,$7D,$48,$70,$B2,$00,$20,$00,$00,$7B       ] , 'vpshufd  zmm30,zword [rdx+0x2000],0x7b'           );
  TestCase.testcase(5220, [$62,$61,$7D,$48,$70,$72,$80,$7B                   ] , 'vpshufd  zmm30,zword [rdx-0x2000],0x7b'           );
  TestCase.testcase(5221, [$62,$61,$7D,$48,$70,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpshufd  zmm30,zword [rdx-0x2040],0x7b'           );
  TestCase.testcase(5222, [$62,$61,$7D,$58,$70,$72,$7F,$7B                   ] , 'vpshufd  zmm30,dword [rdx+0x1fc]{1to16},0x7b'     );
  TestCase.testcase(5223, [$62,$61,$7D,$58,$70,$B2,$00,$02,$00,$00,$7B       ] , 'vpshufd  zmm30,dword [rdx+0x200]{1to16},0x7b'     );
  TestCase.testcase(5224, [$62,$61,$7D,$58,$70,$72,$80,$7B                   ] , 'vpshufd  zmm30,dword [rdx-0x200]{1to16},0x7b'     );
  TestCase.testcase(5225, [$62,$61,$7D,$58,$70,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vpshufd  zmm30,dword [rdx-0x204]{1to16},0x7b'     );
  TestCase.testcase(5226, [$62,$01,$15,$47,$F2,$F4                           ] , 'vpslld  zmm30{k7},zmm29,xmm28'                    );
  TestCase.testcase(5227, [$62,$01,$15,$C7,$F2,$F4                           ] , 'vpslld  zmm30{k7}{z},zmm29,xmm28'                 );
  TestCase.testcase(5228, [$62,$61,$15,$47,$F2,$31                           ] , 'vpslld  zmm30{k7},zmm29,oword [rcx]'              );
  TestCase.testcase(5229, [$62,$21,$15,$47,$F2,$B4,$F0,$23,$01,$00,$00       ] , 'vpslld  zmm30{k7},zmm29,oword [rax+r14*8+0x123]'  );
  TestCase.testcase(5230, [$62,$61,$15,$47,$F2,$72,$7F                       ] , 'vpslld  zmm30{k7},zmm29,oword [rdx+0x7f0]'        );
  TestCase.testcase(5231, [$62,$61,$15,$47,$F2,$B2,$00,$08,$00,$00           ] , 'vpslld  zmm30{k7},zmm29,oword [rdx+0x800]'        );
  TestCase.testcase(5232, [$62,$61,$15,$47,$F2,$72,$80                       ] , 'vpslld  zmm30{k7},zmm29,oword [rdx-0x800]'        );
  TestCase.testcase(5233, [$62,$61,$15,$47,$F2,$B2,$F0,$F7,$FF,$FF           ] , 'vpslld  zmm30{k7},zmm29,oword [rdx-0x810]'        );
  TestCase.testcase(5234, [$62,$01,$95,$47,$F3,$F4                           ] , 'vpsllq  zmm30{k7},zmm29,xmm28'                    );
  TestCase.testcase(5235, [$62,$01,$95,$C7,$F3,$F4                           ] , 'vpsllq  zmm30{k7}{z},zmm29,xmm28'                 );
  TestCase.testcase(5236, [$62,$61,$95,$47,$F3,$31                           ] , 'vpsllq  zmm30{k7},zmm29,oword [rcx]'              );
  TestCase.testcase(5237, [$62,$21,$95,$47,$F3,$B4,$F0,$23,$01,$00,$00       ] , 'vpsllq  zmm30{k7},zmm29,oword [rax+r14*8+0x123]'  );
  TestCase.testcase(5238, [$62,$61,$95,$47,$F3,$72,$7F                       ] , 'vpsllq  zmm30{k7},zmm29,oword [rdx+0x7f0]'        );
  TestCase.testcase(5239, [$62,$61,$95,$47,$F3,$B2,$00,$08,$00,$00           ] , 'vpsllq  zmm30{k7},zmm29,oword [rdx+0x800]'        );
  TestCase.testcase(5240, [$62,$61,$95,$47,$F3,$72,$80                       ] , 'vpsllq  zmm30{k7},zmm29,oword [rdx-0x800]'        );
  TestCase.testcase(5241, [$62,$61,$95,$47,$F3,$B2,$F0,$F7,$FF,$FF           ] , 'vpsllq  zmm30{k7},zmm29,oword [rdx-0x810]'        );
  TestCase.testcase(5242, [$62,$02,$15,$40,$47,$F4                           ] , 'vpsllvd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5243, [$62,$02,$15,$47,$47,$F4                           ] , 'vpsllvd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5244, [$62,$02,$15,$C7,$47,$F4                           ] , 'vpsllvd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5245, [$62,$62,$15,$40,$47,$31                           ] , 'vpsllvd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5246, [$62,$22,$15,$40,$47,$B4,$F0,$23,$01,$00,$00       ] , 'vpsllvd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5247, [$62,$62,$15,$50,$47,$31                           ] , 'vpsllvd  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(5248, [$62,$62,$15,$40,$47,$72,$7F                       ] , 'vpsllvd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5249, [$62,$62,$15,$40,$47,$B2,$00,$20,$00,$00           ] , 'vpsllvd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5250, [$62,$62,$15,$40,$47,$72,$80                       ] , 'vpsllvd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5251, [$62,$62,$15,$40,$47,$B2,$C0,$DF,$FF,$FF           ] , 'vpsllvd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5252, [$62,$62,$15,$50,$47,$72,$7F                       ] , 'vpsllvd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(5253, [$62,$62,$15,$50,$47,$B2,$00,$02,$00,$00           ] , 'vpsllvd  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(5254, [$62,$62,$15,$50,$47,$72,$80                       ] , 'vpsllvd  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(5255, [$62,$62,$15,$50,$47,$B2,$FC,$FD,$FF,$FF           ] , 'vpsllvd  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(5256, [$62,$02,$95,$40,$47,$F4                           ] , 'vpsllvq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5257, [$62,$02,$95,$47,$47,$F4                           ] , 'vpsllvq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5258, [$62,$02,$95,$C7,$47,$F4                           ] , 'vpsllvq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5259, [$62,$62,$95,$40,$47,$31                           ] , 'vpsllvq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5260, [$62,$22,$95,$40,$47,$B4,$F0,$23,$01,$00,$00       ] , 'vpsllvq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5261, [$62,$62,$95,$50,$47,$31                           ] , 'vpsllvq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(5262, [$62,$62,$95,$40,$47,$72,$7F                       ] , 'vpsllvq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5263, [$62,$62,$95,$40,$47,$B2,$00,$20,$00,$00           ] , 'vpsllvq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5264, [$62,$62,$95,$40,$47,$72,$80                       ] , 'vpsllvq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5265, [$62,$62,$95,$40,$47,$B2,$C0,$DF,$FF,$FF           ] , 'vpsllvq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5266, [$62,$62,$95,$50,$47,$72,$7F                       ] , 'vpsllvq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(5267, [$62,$62,$95,$50,$47,$B2,$00,$04,$00,$00           ] , 'vpsllvq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(5268, [$62,$62,$95,$50,$47,$72,$80                       ] , 'vpsllvq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(5269, [$62,$62,$95,$50,$47,$B2,$F8,$FB,$FF,$FF           ] , 'vpsllvq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(5270, [$62,$01,$15,$47,$E2,$F4                           ] , 'vpsrad  zmm30{k7},zmm29,xmm28'                    );
  TestCase.testcase(5271, [$62,$01,$15,$C7,$E2,$F4                           ] , 'vpsrad  zmm30{k7}{z},zmm29,xmm28'                 );
  TestCase.testcase(5272, [$62,$61,$15,$47,$E2,$31                           ] , 'vpsrad  zmm30{k7},zmm29,oword [rcx]'              );
  TestCase.testcase(5273, [$62,$21,$15,$47,$E2,$B4,$F0,$23,$01,$00,$00       ] , 'vpsrad  zmm30{k7},zmm29,oword [rax+r14*8+0x123]'  );
  TestCase.testcase(5274, [$62,$61,$15,$47,$E2,$72,$7F                       ] , 'vpsrad  zmm30{k7},zmm29,oword [rdx+0x7f0]'        );
  TestCase.testcase(5275, [$62,$61,$15,$47,$E2,$B2,$00,$08,$00,$00           ] , 'vpsrad  zmm30{k7},zmm29,oword [rdx+0x800]'        );
  TestCase.testcase(5276, [$62,$61,$15,$47,$E2,$72,$80                       ] , 'vpsrad  zmm30{k7},zmm29,oword [rdx-0x800]'        );
  TestCase.testcase(5277, [$62,$61,$15,$47,$E2,$B2,$F0,$F7,$FF,$FF           ] , 'vpsrad  zmm30{k7},zmm29,oword [rdx-0x810]'        );
  TestCase.testcase(5278, [$62,$01,$95,$47,$E2,$F4                           ] , 'vpsraq  zmm30{k7},zmm29,xmm28'                    );
  TestCase.testcase(5279, [$62,$01,$95,$C7,$E2,$F4                           ] , 'vpsraq  zmm30{k7}{z},zmm29,xmm28'                 );
  TestCase.testcase(5280, [$62,$61,$95,$47,$E2,$31                           ] , 'vpsraq  zmm30{k7},zmm29,oword [rcx]'              );
  TestCase.testcase(5281, [$62,$21,$95,$47,$E2,$B4,$F0,$23,$01,$00,$00       ] , 'vpsraq  zmm30{k7},zmm29,oword [rax+r14*8+0x123]'  );
  TestCase.testcase(5282, [$62,$61,$95,$47,$E2,$72,$7F                       ] , 'vpsraq  zmm30{k7},zmm29,oword [rdx+0x7f0]'        );
  TestCase.testcase(5283, [$62,$61,$95,$47,$E2,$B2,$00,$08,$00,$00           ] , 'vpsraq  zmm30{k7},zmm29,oword [rdx+0x800]'        );
  TestCase.testcase(5284, [$62,$61,$95,$47,$E2,$72,$80                       ] , 'vpsraq  zmm30{k7},zmm29,oword [rdx-0x800]'        );
  TestCase.testcase(5285, [$62,$61,$95,$47,$E2,$B2,$F0,$F7,$FF,$FF           ] , 'vpsraq  zmm30{k7},zmm29,oword [rdx-0x810]'        );
  TestCase.testcase(5286, [$62,$02,$15,$40,$46,$F4                           ] , 'vpsravd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5287, [$62,$02,$15,$47,$46,$F4                           ] , 'vpsravd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5288, [$62,$02,$15,$C7,$46,$F4                           ] , 'vpsravd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5289, [$62,$62,$15,$40,$46,$31                           ] , 'vpsravd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5290, [$62,$22,$15,$40,$46,$B4,$F0,$23,$01,$00,$00       ] , 'vpsravd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5291, [$62,$62,$15,$50,$46,$31                           ] , 'vpsravd  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(5292, [$62,$62,$15,$40,$46,$72,$7F                       ] , 'vpsravd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5293, [$62,$62,$15,$40,$46,$B2,$00,$20,$00,$00           ] , 'vpsravd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5294, [$62,$62,$15,$40,$46,$72,$80                       ] , 'vpsravd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5295, [$62,$62,$15,$40,$46,$B2,$C0,$DF,$FF,$FF           ] , 'vpsravd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5296, [$62,$62,$15,$50,$46,$72,$7F                       ] , 'vpsravd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(5297, [$62,$62,$15,$50,$46,$B2,$00,$02,$00,$00           ] , 'vpsravd  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(5298, [$62,$62,$15,$50,$46,$72,$80                       ] , 'vpsravd  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(5299, [$62,$62,$15,$50,$46,$B2,$FC,$FD,$FF,$FF           ] , 'vpsravd  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(5300, [$62,$02,$95,$40,$46,$F4                           ] , 'vpsravq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5301, [$62,$02,$95,$47,$46,$F4                           ] , 'vpsravq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5302, [$62,$02,$95,$C7,$46,$F4                           ] , 'vpsravq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5303, [$62,$62,$95,$40,$46,$31                           ] , 'vpsravq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5304, [$62,$22,$95,$40,$46,$B4,$F0,$23,$01,$00,$00       ] , 'vpsravq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5305, [$62,$62,$95,$50,$46,$31                           ] , 'vpsravq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(5306, [$62,$62,$95,$40,$46,$72,$7F                       ] , 'vpsravq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5307, [$62,$62,$95,$40,$46,$B2,$00,$20,$00,$00           ] , 'vpsravq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5308, [$62,$62,$95,$40,$46,$72,$80                       ] , 'vpsravq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5309, [$62,$62,$95,$40,$46,$B2,$C0,$DF,$FF,$FF           ] , 'vpsravq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5310, [$62,$62,$95,$50,$46,$72,$7F                       ] , 'vpsravq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(5311, [$62,$62,$95,$50,$46,$B2,$00,$04,$00,$00           ] , 'vpsravq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(5312, [$62,$62,$95,$50,$46,$72,$80                       ] , 'vpsravq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(5313, [$62,$62,$95,$50,$46,$B2,$F8,$FB,$FF,$FF           ] , 'vpsravq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(5314, [$62,$01,$15,$47,$D2,$F4                           ] , 'vpsrld  zmm30{k7},zmm29,xmm28'                    );
  TestCase.testcase(5315, [$62,$01,$15,$C7,$D2,$F4                           ] , 'vpsrld  zmm30{k7}{z},zmm29,xmm28'                 );
  TestCase.testcase(5316, [$62,$61,$15,$47,$D2,$31                           ] , 'vpsrld  zmm30{k7},zmm29,oword [rcx]'              );
  TestCase.testcase(5317, [$62,$21,$15,$47,$D2,$B4,$F0,$23,$01,$00,$00       ] , 'vpsrld  zmm30{k7},zmm29,oword [rax+r14*8+0x123]'  );
  TestCase.testcase(5318, [$62,$61,$15,$47,$D2,$72,$7F                       ] , 'vpsrld  zmm30{k7},zmm29,oword [rdx+0x7f0]'        );
  TestCase.testcase(5319, [$62,$61,$15,$47,$D2,$B2,$00,$08,$00,$00           ] , 'vpsrld  zmm30{k7},zmm29,oword [rdx+0x800]'        );
  TestCase.testcase(5320, [$62,$61,$15,$47,$D2,$72,$80                       ] , 'vpsrld  zmm30{k7},zmm29,oword [rdx-0x800]'        );
  TestCase.testcase(5321, [$62,$61,$15,$47,$D2,$B2,$F0,$F7,$FF,$FF           ] , 'vpsrld  zmm30{k7},zmm29,oword [rdx-0x810]'        );
  TestCase.testcase(5322, [$62,$01,$95,$47,$D3,$F4                           ] , 'vpsrlq  zmm30{k7},zmm29,xmm28'                    );
  TestCase.testcase(5323, [$62,$01,$95,$C7,$D3,$F4                           ] , 'vpsrlq  zmm30{k7}{z},zmm29,xmm28'                 );
  TestCase.testcase(5324, [$62,$61,$95,$47,$D3,$31                           ] , 'vpsrlq  zmm30{k7},zmm29,oword [rcx]'              );
  TestCase.testcase(5325, [$62,$21,$95,$47,$D3,$B4,$F0,$23,$01,$00,$00       ] , 'vpsrlq  zmm30{k7},zmm29,oword [rax+r14*8+0x123]'  );
  TestCase.testcase(5326, [$62,$61,$95,$47,$D3,$72,$7F                       ] , 'vpsrlq  zmm30{k7},zmm29,oword [rdx+0x7f0]'        );
  TestCase.testcase(5327, [$62,$61,$95,$47,$D3,$B2,$00,$08,$00,$00           ] , 'vpsrlq  zmm30{k7},zmm29,oword [rdx+0x800]'        );
  TestCase.testcase(5328, [$62,$61,$95,$47,$D3,$72,$80                       ] , 'vpsrlq  zmm30{k7},zmm29,oword [rdx-0x800]'        );
  TestCase.testcase(5329, [$62,$61,$95,$47,$D3,$B2,$F0,$F7,$FF,$FF           ] , 'vpsrlq  zmm30{k7},zmm29,oword [rdx-0x810]'        );
  TestCase.testcase(5330, [$62,$02,$15,$40,$45,$F4                           ] , 'vpsrlvd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5331, [$62,$02,$15,$47,$45,$F4                           ] , 'vpsrlvd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5332, [$62,$02,$15,$C7,$45,$F4                           ] , 'vpsrlvd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5333, [$62,$62,$15,$40,$45,$31                           ] , 'vpsrlvd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5334, [$62,$22,$15,$40,$45,$B4,$F0,$23,$01,$00,$00       ] , 'vpsrlvd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5335, [$62,$62,$15,$50,$45,$31                           ] , 'vpsrlvd  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(5336, [$62,$62,$15,$40,$45,$72,$7F                       ] , 'vpsrlvd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5337, [$62,$62,$15,$40,$45,$B2,$00,$20,$00,$00           ] , 'vpsrlvd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5338, [$62,$62,$15,$40,$45,$72,$80                       ] , 'vpsrlvd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5339, [$62,$62,$15,$40,$45,$B2,$C0,$DF,$FF,$FF           ] , 'vpsrlvd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5340, [$62,$62,$15,$50,$45,$72,$7F                       ] , 'vpsrlvd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(5341, [$62,$62,$15,$50,$45,$B2,$00,$02,$00,$00           ] , 'vpsrlvd  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(5342, [$62,$62,$15,$50,$45,$72,$80                       ] , 'vpsrlvd  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(5343, [$62,$62,$15,$50,$45,$B2,$FC,$FD,$FF,$FF           ] , 'vpsrlvd  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(5344, [$62,$02,$95,$40,$45,$F4                           ] , 'vpsrlvq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5345, [$62,$02,$95,$47,$45,$F4                           ] , 'vpsrlvq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5346, [$62,$02,$95,$C7,$45,$F4                           ] , 'vpsrlvq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5347, [$62,$62,$95,$40,$45,$31                           ] , 'vpsrlvq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5348, [$62,$22,$95,$40,$45,$B4,$F0,$23,$01,$00,$00       ] , 'vpsrlvq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5349, [$62,$62,$95,$50,$45,$31                           ] , 'vpsrlvq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(5350, [$62,$62,$95,$40,$45,$72,$7F                       ] , 'vpsrlvq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5351, [$62,$62,$95,$40,$45,$B2,$00,$20,$00,$00           ] , 'vpsrlvq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5352, [$62,$62,$95,$40,$45,$72,$80                       ] , 'vpsrlvq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5353, [$62,$62,$95,$40,$45,$B2,$C0,$DF,$FF,$FF           ] , 'vpsrlvq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5354, [$62,$62,$95,$50,$45,$72,$7F                       ] , 'vpsrlvq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(5355, [$62,$62,$95,$50,$45,$B2,$00,$04,$00,$00           ] , 'vpsrlvq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(5356, [$62,$62,$95,$50,$45,$72,$80                       ] , 'vpsrlvq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(5357, [$62,$62,$95,$50,$45,$B2,$F8,$FB,$FF,$FF           ] , 'vpsrlvq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(5358, [$62,$91,$0D,$40,$72,$D5,$AB                       ] , 'vpsrld  zmm30,zmm29,0xab'                         );
  TestCase.testcase(5359, [$62,$91,$0D,$47,$72,$D5,$AB                       ] , 'vpsrld  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(5360, [$62,$91,$0D,$C7,$72,$D5,$AB                       ] , 'vpsrld  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(5361, [$62,$91,$0D,$40,$72,$D5,$7B                       ] , 'vpsrld  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(5362, [$62,$F1,$0D,$40,$72,$11,$7B                       ] , 'vpsrld  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(5363, [$62,$B1,$0D,$40,$72,$94,$F0,$23,$01,$00,$00,$7B   ] , 'vpsrld  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(5364, [$62,$F1,$0D,$50,$72,$11,$7B                       ] , 'vpsrld  zmm30,dword [rcx]{1to16},0x7b'            );
  TestCase.testcase(5365, [$62,$F1,$0D,$40,$72,$52,$7F,$7B                   ] , 'vpsrld  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(5366, [$62,$F1,$0D,$40,$72,$92,$00,$20,$00,$00,$7B       ] , 'vpsrld  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(5367, [$62,$F1,$0D,$40,$72,$52,$80,$7B                   ] , 'vpsrld  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(5368, [$62,$F1,$0D,$40,$72,$92,$C0,$DF,$FF,$FF,$7B       ] , 'vpsrld  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(5369, [$62,$F1,$0D,$50,$72,$52,$7F,$7B                   ] , 'vpsrld  zmm30,dword [rdx+0x1fc]{1to16},0x7b'      );
  TestCase.testcase(5370, [$62,$F1,$0D,$50,$72,$92,$00,$02,$00,$00,$7B       ] , 'vpsrld  zmm30,dword [rdx+0x200]{1to16},0x7b'      );
  TestCase.testcase(5371, [$62,$F1,$0D,$50,$72,$52,$80,$7B                   ] , 'vpsrld  zmm30,dword [rdx-0x200]{1to16},0x7b'      );
  TestCase.testcase(5372, [$62,$F1,$0D,$50,$72,$92,$FC,$FD,$FF,$FF,$7B       ] , 'vpsrld  zmm30,dword [rdx-0x204]{1to16},0x7b'      );
  TestCase.testcase(5373, [$62,$91,$8D,$40,$73,$D5,$AB                       ] , 'vpsrlq  zmm30,zmm29,0xab'                         );
  TestCase.testcase(5374, [$62,$91,$8D,$47,$73,$D5,$AB                       ] , 'vpsrlq  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(5375, [$62,$91,$8D,$C7,$73,$D5,$AB                       ] , 'vpsrlq  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(5376, [$62,$91,$8D,$40,$73,$D5,$7B                       ] , 'vpsrlq  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(5377, [$62,$F1,$8D,$40,$73,$11,$7B                       ] , 'vpsrlq  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(5378, [$62,$B1,$8D,$40,$73,$94,$F0,$23,$01,$00,$00,$7B   ] , 'vpsrlq  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(5379, [$62,$F1,$8D,$50,$73,$11,$7B                       ] , 'vpsrlq  zmm30,qword [rcx]{1to8},0x7b'             );
  TestCase.testcase(5380, [$62,$F1,$8D,$40,$73,$52,$7F,$7B                   ] , 'vpsrlq  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(5381, [$62,$F1,$8D,$40,$73,$92,$00,$20,$00,$00,$7B       ] , 'vpsrlq  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(5382, [$62,$F1,$8D,$40,$73,$52,$80,$7B                   ] , 'vpsrlq  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(5383, [$62,$F1,$8D,$40,$73,$92,$C0,$DF,$FF,$FF,$7B       ] , 'vpsrlq  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(5384, [$62,$F1,$8D,$50,$73,$52,$7F,$7B                   ] , 'vpsrlq  zmm30,qword [rdx+0x3f8]{1to8},0x7b'       );
  TestCase.testcase(5385, [$62,$F1,$8D,$50,$73,$92,$00,$04,$00,$00,$7B       ] , 'vpsrlq  zmm30,qword [rdx+0x400]{1to8},0x7b'       );
  TestCase.testcase(5386, [$62,$F1,$8D,$50,$73,$52,$80,$7B                   ] , 'vpsrlq  zmm30,qword [rdx-0x400]{1to8},0x7b'       );
  TestCase.testcase(5387, [$62,$F1,$8D,$50,$73,$92,$F8,$FB,$FF,$FF,$7B       ] , 'vpsrlq  zmm30,qword [rdx-0x408]{1to8},0x7b'       );
  TestCase.testcase(5388, [$62,$01,$15,$40,$FA,$F4                           ] , 'vpsubd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(5389, [$62,$01,$15,$47,$FA,$F4                           ] , 'vpsubd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(5390, [$62,$01,$15,$C7,$FA,$F4                           ] , 'vpsubd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(5391, [$62,$61,$15,$40,$FA,$31                           ] , 'vpsubd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(5392, [$62,$21,$15,$40,$FA,$B4,$F0,$23,$01,$00,$00       ] , 'vpsubd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(5393, [$62,$61,$15,$50,$FA,$31                           ] , 'vpsubd  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(5394, [$62,$61,$15,$40,$FA,$72,$7F                       ] , 'vpsubd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(5395, [$62,$61,$15,$40,$FA,$B2,$00,$20,$00,$00           ] , 'vpsubd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(5396, [$62,$61,$15,$40,$FA,$72,$80                       ] , 'vpsubd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(5397, [$62,$61,$15,$40,$FA,$B2,$C0,$DF,$FF,$FF           ] , 'vpsubd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(5398, [$62,$61,$15,$50,$FA,$72,$7F                       ] , 'vpsubd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(5399, [$62,$61,$15,$50,$FA,$B2,$00,$02,$00,$00           ] , 'vpsubd  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(5400, [$62,$61,$15,$50,$FA,$72,$80                       ] , 'vpsubd  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(5401, [$62,$61,$15,$50,$FA,$B2,$FC,$FD,$FF,$FF           ] , 'vpsubd  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(5402, [$62,$01,$95,$40,$FB,$F4                           ] , 'vpsubq  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(5403, [$62,$01,$95,$47,$FB,$F4                           ] , 'vpsubq  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(5404, [$62,$01,$95,$C7,$FB,$F4                           ] , 'vpsubq  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(5405, [$62,$61,$95,$40,$FB,$31                           ] , 'vpsubq  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(5406, [$62,$21,$95,$40,$FB,$B4,$F0,$23,$01,$00,$00       ] , 'vpsubq  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(5407, [$62,$61,$95,$50,$FB,$31                           ] , 'vpsubq  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(5408, [$62,$61,$95,$40,$FB,$72,$7F                       ] , 'vpsubq  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(5409, [$62,$61,$95,$40,$FB,$B2,$00,$20,$00,$00           ] , 'vpsubq  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(5410, [$62,$61,$95,$40,$FB,$72,$80                       ] , 'vpsubq  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(5411, [$62,$61,$95,$40,$FB,$B2,$C0,$DF,$FF,$FF           ] , 'vpsubq  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(5412, [$62,$61,$95,$50,$FB,$72,$7F                       ] , 'vpsubq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(5413, [$62,$61,$95,$50,$FB,$B2,$00,$04,$00,$00           ] , 'vpsubq  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(5414, [$62,$61,$95,$50,$FB,$72,$80                       ] , 'vpsubq  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(5415, [$62,$61,$95,$50,$FB,$B2,$F8,$FB,$FF,$FF           ] , 'vpsubq  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(5416, [$62,$92,$0D,$40,$27,$ED                           ] , 'vptestmd  k5,zmm30,zmm29'                         );
  TestCase.testcase(5417, [$62,$92,$0D,$47,$27,$ED                           ] , 'vptestmd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(5418, [$62,$F2,$0D,$40,$27,$29                           ] , 'vptestmd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(5419, [$62,$B2,$0D,$40,$27,$AC,$F0,$23,$01,$00,$00       ] , 'vptestmd  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(5420, [$62,$F2,$0D,$50,$27,$29                           ] , 'vptestmd  k5,zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(5421, [$62,$F2,$0D,$40,$27,$6A,$7F                       ] , 'vptestmd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(5422, [$62,$F2,$0D,$40,$27,$AA,$00,$20,$00,$00           ] , 'vptestmd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(5423, [$62,$F2,$0D,$40,$27,$6A,$80                       ] , 'vptestmd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(5424, [$62,$F2,$0D,$40,$27,$AA,$C0,$DF,$FF,$FF           ] , 'vptestmd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(5425, [$62,$F2,$0D,$50,$27,$6A,$7F                       ] , 'vptestmd  k5,zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(5426, [$62,$F2,$0D,$50,$27,$AA,$00,$02,$00,$00           ] , 'vptestmd  k5,zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(5427, [$62,$F2,$0D,$50,$27,$6A,$80                       ] , 'vptestmd  k5,zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(5428, [$62,$F2,$0D,$50,$27,$AA,$FC,$FD,$FF,$FF           ] , 'vptestmd  k5,zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(5429, [$62,$92,$8D,$40,$27,$ED                           ] , 'vptestmq  k5,zmm30,zmm29'                         );
  TestCase.testcase(5430, [$62,$92,$8D,$47,$27,$ED                           ] , 'vptestmq  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(5431, [$62,$F2,$8D,$40,$27,$29                           ] , 'vptestmq  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(5432, [$62,$B2,$8D,$40,$27,$AC,$F0,$23,$01,$00,$00       ] , 'vptestmq  k5,zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(5433, [$62,$F2,$8D,$50,$27,$29                           ] , 'vptestmq  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(5434, [$62,$F2,$8D,$40,$27,$6A,$7F                       ] , 'vptestmq  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(5435, [$62,$F2,$8D,$40,$27,$AA,$00,$20,$00,$00           ] , 'vptestmq  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(5436, [$62,$F2,$8D,$40,$27,$6A,$80                       ] , 'vptestmq  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(5437, [$62,$F2,$8D,$40,$27,$AA,$C0,$DF,$FF,$FF           ] , 'vptestmq  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(5438, [$62,$F2,$8D,$50,$27,$6A,$7F                       ] , 'vptestmq  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(5439, [$62,$F2,$8D,$50,$27,$AA,$00,$04,$00,$00           ] , 'vptestmq  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(5440, [$62,$F2,$8D,$50,$27,$6A,$80                       ] , 'vptestmq  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(5441, [$62,$F2,$8D,$50,$27,$AA,$F8,$FB,$FF,$FF           ] , 'vptestmq  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(5442, [$62,$01,$15,$40,$6A,$F4                           ] , 'vpunpckhdq  zmm30,zmm29,zmm28'                    );
  TestCase.testcase(5443, [$62,$01,$15,$47,$6A,$F4                           ] , 'vpunpckhdq  zmm30{k7},zmm29,zmm28'                );
  TestCase.testcase(5444, [$62,$01,$15,$C7,$6A,$F4                           ] , 'vpunpckhdq  zmm30{k7}{z},zmm29,zmm28'             );
  TestCase.testcase(5445, [$62,$61,$15,$40,$6A,$31                           ] , 'vpunpckhdq  zmm30,zmm29,zword [rcx]'              );
  TestCase.testcase(5446, [$62,$21,$15,$40,$6A,$B4,$F0,$23,$01,$00,$00       ] , 'vpunpckhdq  zmm30,zmm29,zword [rax+r14*8+0x123]'  );
  TestCase.testcase(5447, [$62,$61,$15,$50,$6A,$31                           ] , 'vpunpckhdq  zmm30,zmm29,dword [rcx]{1to16}'       );
  TestCase.testcase(5448, [$62,$61,$15,$40,$6A,$72,$7F                       ] , 'vpunpckhdq  zmm30,zmm29,zword [rdx+0x1fc0]'       );
  TestCase.testcase(5449, [$62,$61,$15,$40,$6A,$B2,$00,$20,$00,$00           ] , 'vpunpckhdq  zmm30,zmm29,zword [rdx+0x2000]'       );
  TestCase.testcase(5450, [$62,$61,$15,$40,$6A,$72,$80                       ] , 'vpunpckhdq  zmm30,zmm29,zword [rdx-0x2000]'       );
  TestCase.testcase(5451, [$62,$61,$15,$40,$6A,$B2,$C0,$DF,$FF,$FF           ] , 'vpunpckhdq  zmm30,zmm29,zword [rdx-0x2040]'       );
  TestCase.testcase(5452, [$62,$61,$15,$50,$6A,$72,$7F                       ] , 'vpunpckhdq  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(5453, [$62,$61,$15,$50,$6A,$B2,$00,$02,$00,$00           ] , 'vpunpckhdq  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(5454, [$62,$61,$15,$50,$6A,$72,$80                       ] , 'vpunpckhdq  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(5455, [$62,$61,$15,$50,$6A,$B2,$FC,$FD,$FF,$FF           ] , 'vpunpckhdq  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(5456, [$62,$01,$95,$40,$6D,$F4                           ] , 'vpunpckhqdq  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(5457, [$62,$01,$95,$47,$6D,$F4                           ] , 'vpunpckhqdq  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(5458, [$62,$01,$95,$C7,$6D,$F4                           ] , 'vpunpckhqdq  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(5459, [$62,$61,$95,$40,$6D,$31                           ] , 'vpunpckhqdq  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(5460, [$62,$21,$95,$40,$6D,$B4,$F0,$23,$01,$00,$00       ] , 'vpunpckhqdq  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(5461, [$62,$61,$95,$50,$6D,$31                           ] , 'vpunpckhqdq  zmm30,zmm29,qword [rcx]{1to8}'       );
  TestCase.testcase(5462, [$62,$61,$95,$40,$6D,$72,$7F                       ] , 'vpunpckhqdq  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(5463, [$62,$61,$95,$40,$6D,$B2,$00,$20,$00,$00           ] , 'vpunpckhqdq  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(5464, [$62,$61,$95,$40,$6D,$72,$80                       ] , 'vpunpckhqdq  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(5465, [$62,$61,$95,$40,$6D,$B2,$C0,$DF,$FF,$FF           ] , 'vpunpckhqdq  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(5466, [$62,$61,$95,$50,$6D,$72,$7F                       ] , 'vpunpckhqdq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(5467, [$62,$61,$95,$50,$6D,$B2,$00,$04,$00,$00           ] , 'vpunpckhqdq  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(5468, [$62,$61,$95,$50,$6D,$72,$80                       ] , 'vpunpckhqdq  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(5469, [$62,$61,$95,$50,$6D,$B2,$F8,$FB,$FF,$FF           ] , 'vpunpckhqdq  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(5470, [$62,$01,$15,$40,$62,$F4                           ] , 'vpunpckldq  zmm30,zmm29,zmm28'                    );
  TestCase.testcase(5471, [$62,$01,$15,$47,$62,$F4                           ] , 'vpunpckldq  zmm30{k7},zmm29,zmm28'                );
  TestCase.testcase(5472, [$62,$01,$15,$C7,$62,$F4                           ] , 'vpunpckldq  zmm30{k7}{z},zmm29,zmm28'             );
  TestCase.testcase(5473, [$62,$61,$15,$40,$62,$31                           ] , 'vpunpckldq  zmm30,zmm29,zword [rcx]'              );
  TestCase.testcase(5474, [$62,$21,$15,$40,$62,$B4,$F0,$23,$01,$00,$00       ] , 'vpunpckldq  zmm30,zmm29,zword [rax+r14*8+0x123]'  );
  TestCase.testcase(5475, [$62,$61,$15,$50,$62,$31                           ] , 'vpunpckldq  zmm30,zmm29,dword [rcx]{1to16}'       );
  TestCase.testcase(5476, [$62,$61,$15,$40,$62,$72,$7F                       ] , 'vpunpckldq  zmm30,zmm29,zword [rdx+0x1fc0]'       );
  TestCase.testcase(5477, [$62,$61,$15,$40,$62,$B2,$00,$20,$00,$00           ] , 'vpunpckldq  zmm30,zmm29,zword [rdx+0x2000]'       );
  TestCase.testcase(5478, [$62,$61,$15,$40,$62,$72,$80                       ] , 'vpunpckldq  zmm30,zmm29,zword [rdx-0x2000]'       );
  TestCase.testcase(5479, [$62,$61,$15,$40,$62,$B2,$C0,$DF,$FF,$FF           ] , 'vpunpckldq  zmm30,zmm29,zword [rdx-0x2040]'       );
  TestCase.testcase(5480, [$62,$61,$15,$50,$62,$72,$7F                       ] , 'vpunpckldq  zmm30,zmm29,dword [rdx+0x1fc]{1to16}' );
  TestCase.testcase(5481, [$62,$61,$15,$50,$62,$B2,$00,$02,$00,$00           ] , 'vpunpckldq  zmm30,zmm29,dword [rdx+0x200]{1to16}' );
  TestCase.testcase(5482, [$62,$61,$15,$50,$62,$72,$80                       ] , 'vpunpckldq  zmm30,zmm29,dword [rdx-0x200]{1to16}' );
  TestCase.testcase(5483, [$62,$61,$15,$50,$62,$B2,$FC,$FD,$FF,$FF           ] , 'vpunpckldq  zmm30,zmm29,dword [rdx-0x204]{1to16}' );
  TestCase.testcase(5484, [$62,$01,$95,$40,$6C,$F4                           ] , 'vpunpcklqdq  zmm30,zmm29,zmm28'                   );
  TestCase.testcase(5485, [$62,$01,$95,$47,$6C,$F4                           ] , 'vpunpcklqdq  zmm30{k7},zmm29,zmm28'               );
  TestCase.testcase(5486, [$62,$01,$95,$C7,$6C,$F4                           ] , 'vpunpcklqdq  zmm30{k7}{z},zmm29,zmm28'            );
  TestCase.testcase(5487, [$62,$61,$95,$40,$6C,$31                           ] , 'vpunpcklqdq  zmm30,zmm29,zword [rcx]'             );
  TestCase.testcase(5488, [$62,$21,$95,$40,$6C,$B4,$F0,$23,$01,$00,$00       ] , 'vpunpcklqdq  zmm30,zmm29,zword [rax+r14*8+0x123]' );
  TestCase.testcase(5489, [$62,$61,$95,$50,$6C,$31                           ] , 'vpunpcklqdq  zmm30,zmm29,qword [rcx]{1to8}'       );
  TestCase.testcase(5490, [$62,$61,$95,$40,$6C,$72,$7F                       ] , 'vpunpcklqdq  zmm30,zmm29,zword [rdx+0x1fc0]'      );
  TestCase.testcase(5491, [$62,$61,$95,$40,$6C,$B2,$00,$20,$00,$00           ] , 'vpunpcklqdq  zmm30,zmm29,zword [rdx+0x2000]'      );
  TestCase.testcase(5492, [$62,$61,$95,$40,$6C,$72,$80                       ] , 'vpunpcklqdq  zmm30,zmm29,zword [rdx-0x2000]'      );
  TestCase.testcase(5493, [$62,$61,$95,$40,$6C,$B2,$C0,$DF,$FF,$FF           ] , 'vpunpcklqdq  zmm30,zmm29,zword [rdx-0x2040]'      );
  TestCase.testcase(5494, [$62,$61,$95,$50,$6C,$72,$7F                       ] , 'vpunpcklqdq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}' );
  TestCase.testcase(5495, [$62,$61,$95,$50,$6C,$B2,$00,$04,$00,$00           ] , 'vpunpcklqdq  zmm30,zmm29,qword [rdx+0x400]{1to8}' );
  TestCase.testcase(5496, [$62,$61,$95,$50,$6C,$72,$80                       ] , 'vpunpcklqdq  zmm30,zmm29,qword [rdx-0x400]{1to8}' );
  TestCase.testcase(5497, [$62,$61,$95,$50,$6C,$B2,$F8,$FB,$FF,$FF           ] , 'vpunpcklqdq  zmm30,zmm29,qword [rdx-0x408]{1to8}' );
  TestCase.testcase(5498, [$62,$01,$15,$40,$EF,$F4                           ] , 'vpxord  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(5499, [$62,$01,$15,$47,$EF,$F4                           ] , 'vpxord  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(5500, [$62,$01,$15,$C7,$EF,$F4                           ] , 'vpxord  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(5501, [$62,$61,$15,$40,$EF,$31                           ] , 'vpxord  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(5502, [$62,$21,$15,$40,$EF,$B4,$F0,$23,$01,$00,$00       ] , 'vpxord  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(5503, [$62,$61,$15,$50,$EF,$31                           ] , 'vpxord  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(5504, [$62,$61,$15,$40,$EF,$72,$7F                       ] , 'vpxord  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(5505, [$62,$61,$15,$40,$EF,$B2,$00,$20,$00,$00           ] , 'vpxord  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(5506, [$62,$61,$15,$40,$EF,$72,$80                       ] , 'vpxord  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(5507, [$62,$61,$15,$40,$EF,$B2,$C0,$DF,$FF,$FF           ] , 'vpxord  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(5508, [$62,$61,$15,$50,$EF,$72,$7F                       ] , 'vpxord  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(5509, [$62,$61,$15,$50,$EF,$B2,$00,$02,$00,$00           ] , 'vpxord  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(5510, [$62,$61,$15,$50,$EF,$72,$80                       ] , 'vpxord  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(5511, [$62,$61,$15,$50,$EF,$B2,$FC,$FD,$FF,$FF           ] , 'vpxord  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(5512, [$62,$01,$95,$40,$EF,$F4                           ] , 'vpxorq  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(5513, [$62,$01,$95,$47,$EF,$F4                           ] , 'vpxorq  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(5514, [$62,$01,$95,$C7,$EF,$F4                           ] , 'vpxorq  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(5515, [$62,$61,$95,$40,$EF,$31                           ] , 'vpxorq  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(5516, [$62,$21,$95,$40,$EF,$B4,$F0,$23,$01,$00,$00       ] , 'vpxorq  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(5517, [$62,$61,$95,$50,$EF,$31                           ] , 'vpxorq  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(5518, [$62,$61,$95,$40,$EF,$72,$7F                       ] , 'vpxorq  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(5519, [$62,$61,$95,$40,$EF,$B2,$00,$20,$00,$00           ] , 'vpxorq  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(5520, [$62,$61,$95,$40,$EF,$72,$80                       ] , 'vpxorq  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(5521, [$62,$61,$95,$40,$EF,$B2,$C0,$DF,$FF,$FF           ] , 'vpxorq  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(5522, [$62,$61,$95,$50,$EF,$72,$7F                       ] , 'vpxorq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(5523, [$62,$61,$95,$50,$EF,$B2,$00,$04,$00,$00           ] , 'vpxorq  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(5524, [$62,$61,$95,$50,$EF,$72,$80                       ] , 'vpxorq  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(5525, [$62,$61,$95,$50,$EF,$B2,$F8,$FB,$FF,$FF           ] , 'vpxorq  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(5526, [$62,$02,$FD,$48,$4C,$F5                           ] , 'vrcp14pd  zmm30,zmm29'                            );
  TestCase.testcase(5527, [$62,$02,$FD,$4F,$4C,$F5                           ] , 'vrcp14pd  zmm30{k7},zmm29'                        );
  TestCase.testcase(5528, [$62,$02,$FD,$CF,$4C,$F5                           ] , 'vrcp14pd  zmm30{k7}{z},zmm29'                     );
  TestCase.testcase(5529, [$62,$62,$FD,$48,$4C,$31                           ] , 'vrcp14pd  zmm30,zword [rcx]'                      );
  TestCase.testcase(5530, [$62,$22,$FD,$48,$4C,$B4,$F0,$23,$01,$00,$00       ] , 'vrcp14pd  zmm30,zword [rax+r14*8+0x123]'          );
  TestCase.testcase(5531, [$62,$62,$FD,$58,$4C,$31                           ] , 'vrcp14pd  zmm30,qword [rcx]{1to8}'                );
  TestCase.testcase(5532, [$62,$62,$FD,$48,$4C,$72,$7F                       ] , 'vrcp14pd  zmm30,zword [rdx+0x1fc0]'               );
  TestCase.testcase(5533, [$62,$62,$FD,$48,$4C,$B2,$00,$20,$00,$00           ] , 'vrcp14pd  zmm30,zword [rdx+0x2000]'               );
  TestCase.testcase(5534, [$62,$62,$FD,$48,$4C,$72,$80                       ] , 'vrcp14pd  zmm30,zword [rdx-0x2000]'               );
  TestCase.testcase(5535, [$62,$62,$FD,$48,$4C,$B2,$C0,$DF,$FF,$FF           ] , 'vrcp14pd  zmm30,zword [rdx-0x2040]'               );
  TestCase.testcase(5536, [$62,$62,$FD,$58,$4C,$72,$7F                       ] , 'vrcp14pd  zmm30,qword [rdx+0x3f8]{1to8}'          );
  TestCase.testcase(5537, [$62,$62,$FD,$58,$4C,$B2,$00,$04,$00,$00           ] , 'vrcp14pd  zmm30,qword [rdx+0x400]{1to8}'          );
  TestCase.testcase(5538, [$62,$62,$FD,$58,$4C,$72,$80                       ] , 'vrcp14pd  zmm30,qword [rdx-0x400]{1to8}'          );
  TestCase.testcase(5539, [$62,$62,$FD,$58,$4C,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp14pd  zmm30,qword [rdx-0x408]{1to8}'          );
  TestCase.testcase(5540, [$62,$02,$7D,$48,$4C,$F5                           ] , 'vrcp14ps  zmm30,zmm29'                            );
  TestCase.testcase(5541, [$62,$02,$7D,$4F,$4C,$F5                           ] , 'vrcp14ps  zmm30{k7},zmm29'                        );
  TestCase.testcase(5542, [$62,$02,$7D,$CF,$4C,$F5                           ] , 'vrcp14ps  zmm30{k7}{z},zmm29'                     );
  TestCase.testcase(5543, [$62,$62,$7D,$48,$4C,$31                           ] , 'vrcp14ps  zmm30,zword [rcx]'                      );
  TestCase.testcase(5544, [$62,$22,$7D,$48,$4C,$B4,$F0,$23,$01,$00,$00       ] , 'vrcp14ps  zmm30,zword [rax+r14*8+0x123]'          );
  TestCase.testcase(5545, [$62,$62,$7D,$58,$4C,$31                           ] , 'vrcp14ps  zmm30,dword [rcx]{1to16}'               );
  TestCase.testcase(5546, [$62,$62,$7D,$48,$4C,$72,$7F                       ] , 'vrcp14ps  zmm30,zword [rdx+0x1fc0]'               );
  TestCase.testcase(5547, [$62,$62,$7D,$48,$4C,$B2,$00,$20,$00,$00           ] , 'vrcp14ps  zmm30,zword [rdx+0x2000]'               );
  TestCase.testcase(5548, [$62,$62,$7D,$48,$4C,$72,$80                       ] , 'vrcp14ps  zmm30,zword [rdx-0x2000]'               );
  TestCase.testcase(5549, [$62,$62,$7D,$48,$4C,$B2,$C0,$DF,$FF,$FF           ] , 'vrcp14ps  zmm30,zword [rdx-0x2040]'               );
  TestCase.testcase(5550, [$62,$62,$7D,$58,$4C,$72,$7F                       ] , 'vrcp14ps  zmm30,dword [rdx+0x1fc]{1to16}'         );
  TestCase.testcase(5551, [$62,$62,$7D,$58,$4C,$B2,$00,$02,$00,$00           ] , 'vrcp14ps  zmm30,dword [rdx+0x200]{1to16}'         );
  TestCase.testcase(5552, [$62,$62,$7D,$58,$4C,$72,$80                       ] , 'vrcp14ps  zmm30,dword [rdx-0x200]{1to16}'         );
  TestCase.testcase(5553, [$62,$62,$7D,$58,$4C,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp14ps  zmm30,dword [rdx-0x204]{1to16}'         );
  TestCase.testcase(5554, [$62,$02,$95,$07,$4D,$F4                           ] , 'vrcp14sd  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(5555, [$62,$02,$95,$87,$4D,$F4                           ] , 'vrcp14sd  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(5556, [$62,$62,$95,$07,$4D,$31                           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rcx]'            );
  TestCase.testcase(5557, [$62,$22,$95,$07,$4D,$B4,$F0,$23,$01,$00,$00       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(5558, [$62,$62,$95,$07,$4D,$72,$7F                       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'      );
  TestCase.testcase(5559, [$62,$62,$95,$07,$4D,$B2,$00,$04,$00,$00           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx+0x400]'      );
  TestCase.testcase(5560, [$62,$62,$95,$07,$4D,$72,$80                       ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx-0x400]'      );
  TestCase.testcase(5561, [$62,$62,$95,$07,$4D,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp14sd  xmm30{k7},xmm29,qword [rdx-0x408]'      );
  TestCase.testcase(5562, [$62,$02,$15,$07,$4D,$F4                           ] , 'vrcp14ss  xmm30{k7},xmm29,xmm28'                  );
  TestCase.testcase(5563, [$62,$02,$15,$87,$4D,$F4                           ] , 'vrcp14ss  xmm30{k7}{z},xmm29,xmm28'               );
  TestCase.testcase(5564, [$62,$62,$15,$07,$4D,$31                           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rcx]'            );
  TestCase.testcase(5565, [$62,$22,$15,$07,$4D,$B4,$F0,$23,$01,$00,$00       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(5566, [$62,$62,$15,$07,$4D,$72,$7F                       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'      );
  TestCase.testcase(5567, [$62,$62,$15,$07,$4D,$B2,$00,$02,$00,$00           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx+0x200]'      );
  TestCase.testcase(5568, [$62,$62,$15,$07,$4D,$72,$80                       ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx-0x200]'      );
  TestCase.testcase(5569, [$62,$62,$15,$07,$4D,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp14ss  xmm30{k7},xmm29,dword [rdx-0x204]'      );
  TestCase.testcase(5570, [$62,$02,$FD,$48,$4E,$F5                           ] , 'vrsqrt14pd  zmm30,zmm29'                          );
  TestCase.testcase(5571, [$62,$02,$FD,$4F,$4E,$F5                           ] , 'vrsqrt14pd  zmm30{k7},zmm29'                      );
  TestCase.testcase(5572, [$62,$02,$FD,$CF,$4E,$F5                           ] , 'vrsqrt14pd  zmm30{k7}{z},zmm29'                   );
  TestCase.testcase(5573, [$62,$62,$FD,$48,$4E,$31                           ] , 'vrsqrt14pd  zmm30,zword [rcx]'                    );
  TestCase.testcase(5574, [$62,$22,$FD,$48,$4E,$B4,$F0,$23,$01,$00,$00       ] , 'vrsqrt14pd  zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(5575, [$62,$62,$FD,$58,$4E,$31                           ] , 'vrsqrt14pd  zmm30,qword [rcx]{1to8}'              );
  TestCase.testcase(5576, [$62,$62,$FD,$48,$4E,$72,$7F                       ] , 'vrsqrt14pd  zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(5577, [$62,$62,$FD,$48,$4E,$B2,$00,$20,$00,$00           ] , 'vrsqrt14pd  zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(5578, [$62,$62,$FD,$48,$4E,$72,$80                       ] , 'vrsqrt14pd  zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(5579, [$62,$62,$FD,$48,$4E,$B2,$C0,$DF,$FF,$FF           ] , 'vrsqrt14pd  zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(5580, [$62,$62,$FD,$58,$4E,$72,$7F                       ] , 'vrsqrt14pd  zmm30,qword [rdx+0x3f8]{1to8}'        );
  TestCase.testcase(5581, [$62,$62,$FD,$58,$4E,$B2,$00,$04,$00,$00           ] , 'vrsqrt14pd  zmm30,qword [rdx+0x400]{1to8}'        );
  TestCase.testcase(5582, [$62,$62,$FD,$58,$4E,$72,$80                       ] , 'vrsqrt14pd  zmm30,qword [rdx-0x400]{1to8}'        );
  TestCase.testcase(5583, [$62,$62,$FD,$58,$4E,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt14pd  zmm30,qword [rdx-0x408]{1to8}'        );
  TestCase.testcase(5584, [$62,$02,$7D,$48,$4E,$F5                           ] , 'vrsqrt14ps  zmm30,zmm29'                          );
  TestCase.testcase(5585, [$62,$02,$7D,$4F,$4E,$F5                           ] , 'vrsqrt14ps  zmm30{k7},zmm29'                      );
  TestCase.testcase(5586, [$62,$02,$7D,$CF,$4E,$F5                           ] , 'vrsqrt14ps  zmm30{k7}{z},zmm29'                   );
  TestCase.testcase(5587, [$62,$62,$7D,$48,$4E,$31                           ] , 'vrsqrt14ps  zmm30,zword [rcx]'                    );
  TestCase.testcase(5588, [$62,$22,$7D,$48,$4E,$B4,$F0,$23,$01,$00,$00       ] , 'vrsqrt14ps  zmm30,zword [rax+r14*8+0x123]'        );
  TestCase.testcase(5589, [$62,$62,$7D,$58,$4E,$31                           ] , 'vrsqrt14ps  zmm30,dword [rcx]{1to16}'             );
  TestCase.testcase(5590, [$62,$62,$7D,$48,$4E,$72,$7F                       ] , 'vrsqrt14ps  zmm30,zword [rdx+0x1fc0]'             );
  TestCase.testcase(5591, [$62,$62,$7D,$48,$4E,$B2,$00,$20,$00,$00           ] , 'vrsqrt14ps  zmm30,zword [rdx+0x2000]'             );
  TestCase.testcase(5592, [$62,$62,$7D,$48,$4E,$72,$80                       ] , 'vrsqrt14ps  zmm30,zword [rdx-0x2000]'             );
  TestCase.testcase(5593, [$62,$62,$7D,$48,$4E,$B2,$C0,$DF,$FF,$FF           ] , 'vrsqrt14ps  zmm30,zword [rdx-0x2040]'             );
  TestCase.testcase(5594, [$62,$62,$7D,$58,$4E,$72,$7F                       ] , 'vrsqrt14ps  zmm30,dword [rdx+0x1fc]{1to16}'       );
  TestCase.testcase(5595, [$62,$62,$7D,$58,$4E,$B2,$00,$02,$00,$00           ] , 'vrsqrt14ps  zmm30,dword [rdx+0x200]{1to16}'       );
  TestCase.testcase(5596, [$62,$62,$7D,$58,$4E,$72,$80                       ] , 'vrsqrt14ps  zmm30,dword [rdx-0x200]{1to16}'       );
  TestCase.testcase(5597, [$62,$62,$7D,$58,$4E,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt14ps  zmm30,dword [rdx-0x204]{1to16}'       );
  TestCase.testcase(5598, [$62,$02,$95,$07,$4F,$F4                           ] , 'vrsqrt14sd  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(5599, [$62,$02,$95,$87,$4F,$F4                           ] , 'vrsqrt14sd  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(5600, [$62,$62,$95,$07,$4F,$31                           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rcx]'          );
  TestCase.testcase(5601, [$62,$22,$95,$07,$4F,$B4,$F0,$23,$01,$00,$00       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(5602, [$62,$62,$95,$07,$4F,$72,$7F                       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx+0x3f8]'    );
  TestCase.testcase(5603, [$62,$62,$95,$07,$4F,$B2,$00,$04,$00,$00           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx+0x400]'    );
  TestCase.testcase(5604, [$62,$62,$95,$07,$4F,$72,$80                       ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx-0x400]'    );
  TestCase.testcase(5605, [$62,$62,$95,$07,$4F,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt14sd  xmm30{k7},xmm29,qword [rdx-0x408]'    );
  TestCase.testcase(5606, [$62,$02,$15,$07,$4F,$F4                           ] , 'vrsqrt14ss  xmm30{k7},xmm29,xmm28'                );
  TestCase.testcase(5607, [$62,$02,$15,$87,$4F,$F4                           ] , 'vrsqrt14ss  xmm30{k7}{z},xmm29,xmm28'             );
  TestCase.testcase(5608, [$62,$62,$15,$07,$4F,$31                           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rcx]'          );
  TestCase.testcase(5609, [$62,$22,$15,$07,$4F,$B4,$F0,$23,$01,$00,$00       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(5610, [$62,$62,$15,$07,$4F,$72,$7F                       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx+0x1fc]'    );
  TestCase.testcase(5611, [$62,$62,$15,$07,$4F,$B2,$00,$02,$00,$00           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx+0x200]'    );
  TestCase.testcase(5612, [$62,$62,$15,$07,$4F,$72,$80                       ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx-0x200]'    );
  TestCase.testcase(5613, [$62,$62,$15,$07,$4F,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt14ss  xmm30{k7},xmm29,dword [rdx-0x204]'    );
  TestCase.testcase(5614, [$62,$02,$FD,$41,$A2,$B4,$FE,$7B,$00,$00,$00       ] , 'vscatterdpd  zword [r14+ymm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5615, [$62,$02,$FD,$41,$A2,$B4,$FE,$7B,$00,$00,$00       ] , 'vscatterdpd  zword [r14+ymm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5616, [$62,$02,$FD,$41,$A2,$74,$39,$20                   ] , 'vscatterdpd  zword [r9+ymm31*1+0x100]{k1},zmm30'  );
  TestCase.testcase(5617, [$62,$22,$FD,$41,$A2,$B4,$B9,$00,$04,$00,$00       ] , 'vscatterdpd  zword [rcx+ymm31*4+0x400]{k1},zmm30' );
  TestCase.testcase(5618, [$62,$02,$7D,$41,$A2,$B4,$FE,$7B,$00,$00,$00       ] , 'vscatterdps  zword [r14+zmm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5619, [$62,$02,$7D,$41,$A2,$B4,$FE,$7B,$00,$00,$00       ] , 'vscatterdps  zword [r14+zmm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5620, [$62,$02,$7D,$41,$A2,$74,$39,$40                   ] , 'vscatterdps  zword [r9+zmm31*1+0x100]{k1},zmm30'  );
  TestCase.testcase(5621, [$62,$22,$7D,$41,$A2,$B4,$B9,$00,$04,$00,$00       ] , 'vscatterdps  zword [rcx+zmm31*4+0x400]{k1},zmm30' );
  TestCase.testcase(5622, [$62,$02,$FD,$41,$A3,$B4,$FE,$7B,$00,$00,$00       ] , 'vscatterqpd  zword [r14+zmm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5623, [$62,$02,$FD,$41,$A3,$B4,$FE,$7B,$00,$00,$00       ] , 'vscatterqpd  zword [r14+zmm31*8+0x7b]{k1},zmm30'  );
  TestCase.testcase(5624, [$62,$02,$FD,$41,$A3,$74,$39,$20                   ] , 'vscatterqpd  zword [r9+zmm31*1+0x100]{k1},zmm30'  );
  TestCase.testcase(5625, [$62,$22,$FD,$41,$A3,$B4,$B9,$00,$04,$00,$00       ] , 'vscatterqpd  zword [rcx+zmm31*4+0x400]{k1},zmm30' );
  TestCase.testcase(5626, [$62,$02,$7D,$41,$A3,$B4,$FE,$7B,$00,$00,$00       ] , 'vscatterqps  zword [r14+zmm31*8+0x7b]{k1},ymm30'  );
  TestCase.testcase(5627, [$62,$02,$7D,$41,$A3,$B4,$FE,$7B,$00,$00,$00       ] , 'vscatterqps  zword [r14+zmm31*8+0x7b]{k1},ymm30'  );
  TestCase.testcase(5628, [$62,$02,$7D,$41,$A3,$74,$39,$40                   ] , 'vscatterqps  zword [r9+zmm31*1+0x200]{k1},ymm30'  );
  TestCase.testcase(5629, [$62,$22,$7D,$41,$A3,$B4,$B9,$00,$04,$00,$00       ] , 'vscatterqps  zword [rcx+zmm31*4+0x400]{k1},ymm30' );
  TestCase.testcase(5630, [$62,$01,$95,$40,$C6,$F4,$AB                       ] , 'vshufpd  zmm30,zmm29,zmm28,0xab'                  );
  TestCase.testcase(5631, [$62,$01,$95,$47,$C6,$F4,$AB                       ] , 'vshufpd  zmm30{k7},zmm29,zmm28,0xab'              );
  TestCase.testcase(5632, [$62,$01,$95,$C7,$C6,$F4,$AB                       ] , 'vshufpd  zmm30{k7}{z},zmm29,zmm28,0xab'           );
  TestCase.testcase(5633, [$62,$01,$95,$40,$C6,$F4,$7B                       ] , 'vshufpd  zmm30,zmm29,zmm28,0x7b'                  );
  TestCase.testcase(5634, [$62,$61,$95,$40,$C6,$31,$7B                       ] , 'vshufpd  zmm30,zmm29,zword [rcx],0x7b'            );
  TestCase.testcase(5635, [$62,$21,$95,$40,$C6,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vshufpd  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(5636, [$62,$61,$95,$50,$C6,$31,$7B                       ] , 'vshufpd  zmm30,zmm29,qword [rcx]{1to8},0x7b'      );
  TestCase.testcase(5637, [$62,$61,$95,$40,$C6,$72,$7F,$7B                   ] , 'vshufpd  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'     );
  TestCase.testcase(5638, [$62,$61,$95,$40,$C6,$B2,$00,$20,$00,$00,$7B       ] , 'vshufpd  zmm30,zmm29,zword [rdx+0x2000],0x7b'     );
  TestCase.testcase(5639, [$62,$61,$95,$40,$C6,$72,$80,$7B                   ] , 'vshufpd  zmm30,zmm29,zword [rdx-0x2000],0x7b'     );
  TestCase.testcase(5640, [$62,$61,$95,$40,$C6,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vshufpd  zmm30,zmm29,zword [rdx-0x2040],0x7b'     );
  TestCase.testcase(5641, [$62,$61,$95,$50,$C6,$72,$7F,$7B                   ] , 'vshufpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8},0x7b' );
  TestCase.testcase(5642, [$62,$61,$95,$50,$C6,$B2,$00,$04,$00,$00,$7B       ] , 'vshufpd  zmm30,zmm29,qword [rdx+0x400]{1to8},0x7b' );
  TestCase.testcase(5643, [$62,$61,$95,$50,$C6,$72,$80,$7B                   ] , 'vshufpd  zmm30,zmm29,qword [rdx-0x400]{1to8},0x7b' );
  TestCase.testcase(5644, [$62,$61,$95,$50,$C6,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vshufpd  zmm30,zmm29,qword [rdx-0x408]{1to8},0x7b' );
  TestCase.testcase(5645, [$62,$01,$14,$40,$C6,$F4,$AB                       ] , 'vshufps  zmm30,zmm29,zmm28,0xab'                  );
  TestCase.testcase(5646, [$62,$01,$14,$47,$C6,$F4,$AB                       ] , 'vshufps  zmm30{k7},zmm29,zmm28,0xab'              );
  TestCase.testcase(5647, [$62,$01,$14,$C7,$C6,$F4,$AB                       ] , 'vshufps  zmm30{k7}{z},zmm29,zmm28,0xab'           );
  TestCase.testcase(5648, [$62,$01,$14,$40,$C6,$F4,$7B                       ] , 'vshufps  zmm30,zmm29,zmm28,0x7b'                  );
  TestCase.testcase(5649, [$62,$61,$14,$40,$C6,$31,$7B                       ] , 'vshufps  zmm30,zmm29,zword [rcx],0x7b'            );
  TestCase.testcase(5650, [$62,$21,$14,$40,$C6,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vshufps  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(5651, [$62,$61,$14,$50,$C6,$31,$7B                       ] , 'vshufps  zmm30,zmm29,dword [rcx]{1to16},0x7b'     );
  TestCase.testcase(5652, [$62,$61,$14,$40,$C6,$72,$7F,$7B                   ] , 'vshufps  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'     );
  TestCase.testcase(5653, [$62,$61,$14,$40,$C6,$B2,$00,$20,$00,$00,$7B       ] , 'vshufps  zmm30,zmm29,zword [rdx+0x2000],0x7b'     );
  TestCase.testcase(5654, [$62,$61,$14,$40,$C6,$72,$80,$7B                   ] , 'vshufps  zmm30,zmm29,zword [rdx-0x2000],0x7b'     );
  TestCase.testcase(5655, [$62,$61,$14,$40,$C6,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vshufps  zmm30,zmm29,zword [rdx-0x2040],0x7b'     );
  TestCase.testcase(5656, [$62,$61,$14,$50,$C6,$72,$7F,$7B                   ] , 'vshufps  zmm30,zmm29,dword [rdx+0x1fc]{1to16},0x7b' );
  TestCase.testcase(5657, [$62,$61,$14,$50,$C6,$B2,$00,$02,$00,$00,$7B       ] , 'vshufps  zmm30,zmm29,dword [rdx+0x200]{1to16},0x7b' );
  TestCase.testcase(5658, [$62,$61,$14,$50,$C6,$72,$80,$7B                   ] , 'vshufps  zmm30,zmm29,dword [rdx-0x200]{1to16},0x7b' );
  TestCase.testcase(5659, [$62,$61,$14,$50,$C6,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vshufps  zmm30,zmm29,dword [rdx-0x204]{1to16},0x7b' );
  TestCase.testcase(5660, [$62,$01,$FD,$48,$51,$F5                           ] , 'vsqrtpd  zmm30,zmm29'                             );
  TestCase.testcase(5661, [$62,$01,$FD,$4F,$51,$F5                           ] , 'vsqrtpd  zmm30{k7},zmm29'                         );
  TestCase.testcase(5662, [$62,$01,$FD,$CF,$51,$F5                           ] , 'vsqrtpd  zmm30{k7}{z},zmm29'                      );
  TestCase.testcase(5663, [$62,$01,$FD,$18,$51,$F5                           ] , 'vsqrtpd  zmm30,zmm29,{rn-sae}'                    );
  TestCase.testcase(5664, [$62,$01,$FD,$58,$51,$F5                           ] , 'vsqrtpd  zmm30,zmm29,{ru-sae}'                    );
  TestCase.testcase(5665, [$62,$01,$FD,$38,$51,$F5                           ] , 'vsqrtpd  zmm30,zmm29,{rd-sae}'                    );
  TestCase.testcase(5666, [$62,$01,$FD,$78,$51,$F5                           ] , 'vsqrtpd  zmm30,zmm29,{rz-sae}'                    );
  TestCase.testcase(5667, [$62,$61,$FD,$48,$51,$31                           ] , 'vsqrtpd  zmm30,zword [rcx]'                       );
  TestCase.testcase(5668, [$62,$21,$FD,$48,$51,$B4,$F0,$23,$01,$00,$00       ] , 'vsqrtpd  zmm30,zword [rax+r14*8+0x123]'           );
  TestCase.testcase(5669, [$62,$61,$FD,$58,$51,$31                           ] , 'vsqrtpd  zmm30,qword [rcx]{1to8}'                 );
  TestCase.testcase(5670, [$62,$61,$FD,$48,$51,$72,$7F                       ] , 'vsqrtpd  zmm30,zword [rdx+0x1fc0]'                );
  TestCase.testcase(5671, [$62,$61,$FD,$48,$51,$B2,$00,$20,$00,$00           ] , 'vsqrtpd  zmm30,zword [rdx+0x2000]'                );
  TestCase.testcase(5672, [$62,$61,$FD,$48,$51,$72,$80                       ] , 'vsqrtpd  zmm30,zword [rdx-0x2000]'                );
  TestCase.testcase(5673, [$62,$61,$FD,$48,$51,$B2,$C0,$DF,$FF,$FF           ] , 'vsqrtpd  zmm30,zword [rdx-0x2040]'                );
  TestCase.testcase(5674, [$62,$61,$FD,$58,$51,$72,$7F                       ] , 'vsqrtpd  zmm30,qword [rdx+0x3f8]{1to8}'           );
  TestCase.testcase(5675, [$62,$61,$FD,$58,$51,$B2,$00,$04,$00,$00           ] , 'vsqrtpd  zmm30,qword [rdx+0x400]{1to8}'           );
  TestCase.testcase(5676, [$62,$61,$FD,$58,$51,$72,$80                       ] , 'vsqrtpd  zmm30,qword [rdx-0x400]{1to8}'           );
  TestCase.testcase(5677, [$62,$61,$FD,$58,$51,$B2,$F8,$FB,$FF,$FF           ] , 'vsqrtpd  zmm30,qword [rdx-0x408]{1to8}'           );
  TestCase.testcase(5678, [$62,$01,$7C,$48,$51,$F5                           ] , 'vsqrtps  zmm30,zmm29'                             );
  TestCase.testcase(5679, [$62,$01,$7C,$4F,$51,$F5                           ] , 'vsqrtps  zmm30{k7},zmm29'                         );
  TestCase.testcase(5680, [$62,$01,$7C,$CF,$51,$F5                           ] , 'vsqrtps  zmm30{k7}{z},zmm29'                      );
  TestCase.testcase(5681, [$62,$01,$7C,$18,$51,$F5                           ] , 'vsqrtps  zmm30,zmm29,{rn-sae}'                    );
  TestCase.testcase(5682, [$62,$01,$7C,$58,$51,$F5                           ] , 'vsqrtps  zmm30,zmm29,{ru-sae}'                    );
  TestCase.testcase(5683, [$62,$01,$7C,$38,$51,$F5                           ] , 'vsqrtps  zmm30,zmm29,{rd-sae}'                    );
  TestCase.testcase(5684, [$62,$01,$7C,$78,$51,$F5                           ] , 'vsqrtps  zmm30,zmm29,{rz-sae}'                    );
  TestCase.testcase(5685, [$62,$61,$7C,$48,$51,$31                           ] , 'vsqrtps  zmm30,zword [rcx]'                       );
  TestCase.testcase(5686, [$62,$21,$7C,$48,$51,$B4,$F0,$23,$01,$00,$00       ] , 'vsqrtps  zmm30,zword [rax+r14*8+0x123]'           );
  TestCase.testcase(5687, [$62,$61,$7C,$58,$51,$31                           ] , 'vsqrtps  zmm30,dword [rcx]{1to16}'                );
  TestCase.testcase(5688, [$62,$61,$7C,$48,$51,$72,$7F                       ] , 'vsqrtps  zmm30,zword [rdx+0x1fc0]'                );
  TestCase.testcase(5689, [$62,$61,$7C,$48,$51,$B2,$00,$20,$00,$00           ] , 'vsqrtps  zmm30,zword [rdx+0x2000]'                );
  TestCase.testcase(5690, [$62,$61,$7C,$48,$51,$72,$80                       ] , 'vsqrtps  zmm30,zword [rdx-0x2000]'                );
  TestCase.testcase(5691, [$62,$61,$7C,$48,$51,$B2,$C0,$DF,$FF,$FF           ] , 'vsqrtps  zmm30,zword [rdx-0x2040]'                );
  TestCase.testcase(5692, [$62,$61,$7C,$58,$51,$72,$7F                       ] , 'vsqrtps  zmm30,dword [rdx+0x1fc]{1to16}'          );
  TestCase.testcase(5693, [$62,$61,$7C,$58,$51,$B2,$00,$02,$00,$00           ] , 'vsqrtps  zmm30,dword [rdx+0x200]{1to16}'          );
  TestCase.testcase(5694, [$62,$61,$7C,$58,$51,$72,$80                       ] , 'vsqrtps  zmm30,dword [rdx-0x200]{1to16}'          );
  TestCase.testcase(5695, [$62,$61,$7C,$58,$51,$B2,$FC,$FD,$FF,$FF           ] , 'vsqrtps  zmm30,dword [rdx-0x204]{1to16}'          );
  TestCase.testcase(5696, [$62,$01,$97,$07,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28'                   );
  TestCase.testcase(5697, [$62,$01,$97,$87,$51,$F4                           ] , 'vsqrtsd  xmm30{k7}{z},xmm29,xmm28'                );
  TestCase.testcase(5698, [$62,$01,$97,$17,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rn-sae}'          );
  TestCase.testcase(5699, [$62,$01,$97,$57,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{ru-sae}'          );
  TestCase.testcase(5700, [$62,$01,$97,$37,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rd-sae}'          );
  TestCase.testcase(5701, [$62,$01,$97,$77,$51,$F4                           ] , 'vsqrtsd  xmm30{k7},xmm29,xmm28,{rz-sae}'          );
  TestCase.testcase(5702, [$62,$61,$97,$07,$51,$31                           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rcx]'             );
  TestCase.testcase(5703, [$62,$21,$97,$07,$51,$B4,$F0,$23,$01,$00,$00       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(5704, [$62,$61,$97,$07,$51,$72,$7F                       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'       );
  TestCase.testcase(5705, [$62,$61,$97,$07,$51,$B2,$00,$04,$00,$00           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx+0x400]'       );
  TestCase.testcase(5706, [$62,$61,$97,$07,$51,$72,$80                       ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx-0x400]'       );
  TestCase.testcase(5707, [$62,$61,$97,$07,$51,$B2,$F8,$FB,$FF,$FF           ] , 'vsqrtsd  xmm30{k7},xmm29,qword [rdx-0x408]'       );
  TestCase.testcase(5708, [$62,$01,$16,$07,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28'                   );
  TestCase.testcase(5709, [$62,$01,$16,$87,$51,$F4                           ] , 'vsqrtss  xmm30{k7}{z},xmm29,xmm28'                );
  TestCase.testcase(5710, [$62,$01,$16,$17,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rn-sae}'          );
  TestCase.testcase(5711, [$62,$01,$16,$57,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{ru-sae}'          );
  TestCase.testcase(5712, [$62,$01,$16,$37,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rd-sae}'          );
  TestCase.testcase(5713, [$62,$01,$16,$77,$51,$F4                           ] , 'vsqrtss  xmm30{k7},xmm29,xmm28,{rz-sae}'          );
  TestCase.testcase(5714, [$62,$61,$16,$07,$51,$31                           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rcx]'             );
  TestCase.testcase(5715, [$62,$21,$16,$07,$51,$B4,$F0,$23,$01,$00,$00       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(5716, [$62,$61,$16,$07,$51,$72,$7F                       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx+0x1fc]'       );
  TestCase.testcase(5717, [$62,$61,$16,$07,$51,$B2,$00,$02,$00,$00           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx+0x200]'       );
  TestCase.testcase(5718, [$62,$61,$16,$07,$51,$72,$80                       ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx-0x200]'       );
  TestCase.testcase(5719, [$62,$61,$16,$07,$51,$B2,$FC,$FD,$FF,$FF           ] , 'vsqrtss  xmm30{k7},xmm29,dword [rdx-0x204]'       );
  TestCase.testcase(5720, [$62,$01,$95,$40,$5C,$F4                           ] , 'vsubpd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(5721, [$62,$01,$95,$47,$5C,$F4                           ] , 'vsubpd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(5722, [$62,$01,$95,$C7,$5C,$F4                           ] , 'vsubpd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(5723, [$62,$01,$95,$10,$5C,$F4                           ] , 'vsubpd  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(5724, [$62,$01,$95,$50,$5C,$F4                           ] , 'vsubpd  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(5725, [$62,$01,$95,$30,$5C,$F4                           ] , 'vsubpd  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(5726, [$62,$01,$95,$70,$5C,$F4                           ] , 'vsubpd  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(5727, [$62,$61,$95,$40,$5C,$31                           ] , 'vsubpd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(5728, [$62,$21,$95,$40,$5C,$B4,$F0,$23,$01,$00,$00       ] , 'vsubpd  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(5729, [$62,$61,$95,$50,$5C,$31                           ] , 'vsubpd  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(5730, [$62,$61,$95,$40,$5C,$72,$7F                       ] , 'vsubpd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(5731, [$62,$61,$95,$40,$5C,$B2,$00,$20,$00,$00           ] , 'vsubpd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(5732, [$62,$61,$95,$40,$5C,$72,$80                       ] , 'vsubpd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(5733, [$62,$61,$95,$40,$5C,$B2,$C0,$DF,$FF,$FF           ] , 'vsubpd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(5734, [$62,$61,$95,$50,$5C,$72,$7F                       ] , 'vsubpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(5735, [$62,$61,$95,$50,$5C,$B2,$00,$04,$00,$00           ] , 'vsubpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(5736, [$62,$61,$95,$50,$5C,$72,$80                       ] , 'vsubpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(5737, [$62,$61,$95,$50,$5C,$B2,$F8,$FB,$FF,$FF           ] , 'vsubpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(5738, [$62,$01,$14,$40,$5C,$F4                           ] , 'vsubps  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(5739, [$62,$01,$14,$47,$5C,$F4                           ] , 'vsubps  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(5740, [$62,$01,$14,$C7,$5C,$F4                           ] , 'vsubps  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(5741, [$62,$01,$14,$10,$5C,$F4                           ] , 'vsubps  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(5742, [$62,$01,$14,$50,$5C,$F4                           ] , 'vsubps  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(5743, [$62,$01,$14,$30,$5C,$F4                           ] , 'vsubps  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(5744, [$62,$01,$14,$70,$5C,$F4                           ] , 'vsubps  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(5745, [$62,$61,$14,$40,$5C,$31                           ] , 'vsubps  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(5746, [$62,$21,$14,$40,$5C,$B4,$F0,$23,$01,$00,$00       ] , 'vsubps  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(5747, [$62,$61,$14,$50,$5C,$31                           ] , 'vsubps  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(5748, [$62,$61,$14,$40,$5C,$72,$7F                       ] , 'vsubps  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(5749, [$62,$61,$14,$40,$5C,$B2,$00,$20,$00,$00           ] , 'vsubps  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(5750, [$62,$61,$14,$40,$5C,$72,$80                       ] , 'vsubps  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(5751, [$62,$61,$14,$40,$5C,$B2,$C0,$DF,$FF,$FF           ] , 'vsubps  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(5752, [$62,$61,$14,$50,$5C,$72,$7F                       ] , 'vsubps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(5753, [$62,$61,$14,$50,$5C,$B2,$00,$02,$00,$00           ] , 'vsubps  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(5754, [$62,$61,$14,$50,$5C,$72,$80                       ] , 'vsubps  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(5755, [$62,$61,$14,$50,$5C,$B2,$FC,$FD,$FF,$FF           ] , 'vsubps  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(5756, [$62,$01,$97,$07,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(5757, [$62,$01,$97,$87,$5C,$F4                           ] , 'vsubsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(5758, [$62,$01,$97,$17,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(5759, [$62,$01,$97,$57,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(5760, [$62,$01,$97,$37,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(5761, [$62,$01,$97,$77,$5C,$F4                           ] , 'vsubsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(5762, [$62,$61,$97,$07,$5C,$31                           ] , 'vsubsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(5763, [$62,$21,$97,$07,$5C,$B4,$F0,$23,$01,$00,$00       ] , 'vsubsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(5764, [$62,$61,$97,$07,$5C,$72,$7F                       ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(5765, [$62,$61,$97,$07,$5C,$B2,$00,$04,$00,$00           ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(5766, [$62,$61,$97,$07,$5C,$72,$80                       ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(5767, [$62,$61,$97,$07,$5C,$B2,$F8,$FB,$FF,$FF           ] , 'vsubsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(5768, [$62,$01,$16,$07,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(5769, [$62,$01,$16,$87,$5C,$F4                           ] , 'vsubss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(5770, [$62,$01,$16,$17,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(5771, [$62,$01,$16,$57,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(5772, [$62,$01,$16,$37,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(5773, [$62,$01,$16,$77,$5C,$F4                           ] , 'vsubss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(5774, [$62,$61,$16,$07,$5C,$31                           ] , 'vsubss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(5775, [$62,$21,$16,$07,$5C,$B4,$F0,$23,$01,$00,$00       ] , 'vsubss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(5776, [$62,$61,$16,$07,$5C,$72,$7F                       ] , 'vsubss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(5777, [$62,$61,$16,$07,$5C,$B2,$00,$02,$00,$00           ] , 'vsubss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(5778, [$62,$61,$16,$07,$5C,$72,$80                       ] , 'vsubss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(5779, [$62,$61,$16,$07,$5C,$B2,$FC,$FD,$FF,$FF           ] , 'vsubss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(5780, [$62,$01,$FD,$08,$2E,$F5                           ] , 'vucomisd  xmm30,xmm29'                            );
  TestCase.testcase(5781, [$62,$01,$FD,$18,$2E,$F5                           ] , 'vucomisd  xmm30,xmm29,{sae}'                      );
  TestCase.testcase(5782, [$62,$61,$FD,$08,$2E,$31                           ] , 'vucomisd  xmm30,qword [rcx]'                      );
  TestCase.testcase(5783, [$62,$21,$FD,$08,$2E,$B4,$F0,$23,$01,$00,$00       ] , 'vucomisd  xmm30,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(5784, [$62,$61,$FD,$08,$2E,$72,$7F                       ] , 'vucomisd  xmm30,qword [rdx+0x3f8]'                );
  TestCase.testcase(5785, [$62,$61,$FD,$08,$2E,$B2,$00,$04,$00,$00           ] , 'vucomisd  xmm30,qword [rdx+0x400]'                );
  TestCase.testcase(5786, [$62,$61,$FD,$08,$2E,$72,$80                       ] , 'vucomisd  xmm30,qword [rdx-0x400]'                );
  TestCase.testcase(5787, [$62,$61,$FD,$08,$2E,$B2,$F8,$FB,$FF,$FF           ] , 'vucomisd  xmm30,qword [rdx-0x408]'                );
  TestCase.testcase(5788, [$62,$01,$7C,$08,$2E,$F5                           ] , 'vucomiss  xmm30,xmm29'                            );
  TestCase.testcase(5789, [$62,$01,$7C,$18,$2E,$F5                           ] , 'vucomiss  xmm30,xmm29,{sae}'                      );
  TestCase.testcase(5790, [$62,$61,$7C,$08,$2E,$31                           ] , 'vucomiss  xmm30,dword [rcx]'                      );
  TestCase.testcase(5791, [$62,$21,$7C,$08,$2E,$B4,$F0,$23,$01,$00,$00       ] , 'vucomiss  xmm30,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(5792, [$62,$61,$7C,$08,$2E,$72,$7F                       ] , 'vucomiss  xmm30,dword [rdx+0x1fc]'                );
  TestCase.testcase(5793, [$62,$61,$7C,$08,$2E,$B2,$00,$02,$00,$00           ] , 'vucomiss  xmm30,dword [rdx+0x200]'                );
  TestCase.testcase(5794, [$62,$61,$7C,$08,$2E,$72,$80                       ] , 'vucomiss  xmm30,dword [rdx-0x200]'                );
  TestCase.testcase(5795, [$62,$61,$7C,$08,$2E,$B2,$FC,$FD,$FF,$FF           ] , 'vucomiss  xmm30,dword [rdx-0x204]'                );
  TestCase.testcase(5796, [$62,$01,$95,$40,$15,$F4                           ] , 'vunpckhpd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(5797, [$62,$01,$95,$47,$15,$F4                           ] , 'vunpckhpd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(5798, [$62,$01,$95,$C7,$15,$F4                           ] , 'vunpckhpd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(5799, [$62,$61,$95,$40,$15,$31                           ] , 'vunpckhpd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(5800, [$62,$21,$95,$40,$15,$B4,$F0,$23,$01,$00,$00       ] , 'vunpckhpd  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(5801, [$62,$61,$95,$50,$15,$31                           ] , 'vunpckhpd  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(5802, [$62,$61,$95,$40,$15,$72,$7F                       ] , 'vunpckhpd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(5803, [$62,$61,$95,$40,$15,$B2,$00,$20,$00,$00           ] , 'vunpckhpd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(5804, [$62,$61,$95,$40,$15,$72,$80                       ] , 'vunpckhpd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(5805, [$62,$61,$95,$40,$15,$B2,$C0,$DF,$FF,$FF           ] , 'vunpckhpd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(5806, [$62,$61,$95,$50,$15,$72,$7F                       ] , 'vunpckhpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(5807, [$62,$61,$95,$50,$15,$B2,$00,$04,$00,$00           ] , 'vunpckhpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(5808, [$62,$61,$95,$50,$15,$72,$80                       ] , 'vunpckhpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(5809, [$62,$61,$95,$50,$15,$B2,$F8,$FB,$FF,$FF           ] , 'vunpckhpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(5810, [$62,$01,$14,$40,$15,$F4                           ] , 'vunpckhps  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(5811, [$62,$01,$14,$47,$15,$F4                           ] , 'vunpckhps  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(5812, [$62,$01,$14,$C7,$15,$F4                           ] , 'vunpckhps  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(5813, [$62,$61,$14,$40,$15,$31                           ] , 'vunpckhps  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(5814, [$62,$21,$14,$40,$15,$B4,$F0,$23,$01,$00,$00       ] , 'vunpckhps  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(5815, [$62,$61,$14,$50,$15,$31                           ] , 'vunpckhps  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(5816, [$62,$61,$14,$40,$15,$72,$7F                       ] , 'vunpckhps  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(5817, [$62,$61,$14,$40,$15,$B2,$00,$20,$00,$00           ] , 'vunpckhps  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(5818, [$62,$61,$14,$40,$15,$72,$80                       ] , 'vunpckhps  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(5819, [$62,$61,$14,$40,$15,$B2,$C0,$DF,$FF,$FF           ] , 'vunpckhps  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(5820, [$62,$61,$14,$50,$15,$72,$7F                       ] , 'vunpckhps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(5821, [$62,$61,$14,$50,$15,$B2,$00,$02,$00,$00           ] , 'vunpckhps  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(5822, [$62,$61,$14,$50,$15,$72,$80                       ] , 'vunpckhps  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(5823, [$62,$61,$14,$50,$15,$B2,$FC,$FD,$FF,$FF           ] , 'vunpckhps  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(5824, [$62,$01,$95,$40,$14,$F4                           ] , 'vunpcklpd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(5825, [$62,$01,$95,$47,$14,$F4                           ] , 'vunpcklpd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(5826, [$62,$01,$95,$C7,$14,$F4                           ] , 'vunpcklpd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(5827, [$62,$61,$95,$40,$14,$31                           ] , 'vunpcklpd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(5828, [$62,$21,$95,$40,$14,$B4,$F0,$23,$01,$00,$00       ] , 'vunpcklpd  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(5829, [$62,$61,$95,$50,$14,$31                           ] , 'vunpcklpd  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(5830, [$62,$61,$95,$40,$14,$72,$7F                       ] , 'vunpcklpd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(5831, [$62,$61,$95,$40,$14,$B2,$00,$20,$00,$00           ] , 'vunpcklpd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(5832, [$62,$61,$95,$40,$14,$72,$80                       ] , 'vunpcklpd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(5833, [$62,$61,$95,$40,$14,$B2,$C0,$DF,$FF,$FF           ] , 'vunpcklpd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(5834, [$62,$61,$95,$50,$14,$72,$7F                       ] , 'vunpcklpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(5835, [$62,$61,$95,$50,$14,$B2,$00,$04,$00,$00           ] , 'vunpcklpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(5836, [$62,$61,$95,$50,$14,$72,$80                       ] , 'vunpcklpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(5837, [$62,$61,$95,$50,$14,$B2,$F8,$FB,$FF,$FF           ] , 'vunpcklpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(5838, [$62,$01,$14,$40,$14,$F4                           ] , 'vunpcklps  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(5839, [$62,$01,$14,$47,$14,$F4                           ] , 'vunpcklps  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(5840, [$62,$01,$14,$C7,$14,$F4                           ] , 'vunpcklps  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(5841, [$62,$61,$14,$40,$14,$31                           ] , 'vunpcklps  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(5842, [$62,$21,$14,$40,$14,$B4,$F0,$23,$01,$00,$00       ] , 'vunpcklps  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(5843, [$62,$61,$14,$50,$14,$31                           ] , 'vunpcklps  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(5844, [$62,$61,$14,$40,$14,$72,$7F                       ] , 'vunpcklps  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(5845, [$62,$61,$14,$40,$14,$B2,$00,$20,$00,$00           ] , 'vunpcklps  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(5846, [$62,$61,$14,$40,$14,$72,$80                       ] , 'vunpcklps  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(5847, [$62,$61,$14,$40,$14,$B2,$C0,$DF,$FF,$FF           ] , 'vunpcklps  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(5848, [$62,$61,$14,$50,$14,$72,$7F                       ] , 'vunpcklps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(5849, [$62,$61,$14,$50,$14,$B2,$00,$02,$00,$00           ] , 'vunpcklps  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(5850, [$62,$61,$14,$50,$14,$72,$80                       ] , 'vunpcklps  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(5851, [$62,$61,$14,$50,$14,$B2,$FC,$FD,$FF,$FF           ] , 'vunpcklps  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(5852, [$62,$03,$15,$40,$25,$F4,$AB                       ] , 'vpternlogd  zmm30,zmm29,zmm28,0xab'               );
  TestCase.testcase(5853, [$62,$03,$15,$47,$25,$F4,$AB                       ] , 'vpternlogd  zmm30{k7},zmm29,zmm28,0xab'           );
  TestCase.testcase(5854, [$62,$03,$15,$C7,$25,$F4,$AB                       ] , 'vpternlogd  zmm30{k7}{z},zmm29,zmm28,0xab'        );
  TestCase.testcase(5855, [$62,$03,$15,$40,$25,$F4,$7B                       ] , 'vpternlogd  zmm30,zmm29,zmm28,0x7b'               );
  TestCase.testcase(5856, [$62,$63,$15,$40,$25,$31,$7B                       ] , 'vpternlogd  zmm30,zmm29,zword [rcx],0x7b'         );
  TestCase.testcase(5857, [$62,$23,$15,$40,$25,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpternlogd  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(5858, [$62,$63,$15,$50,$25,$31,$7B                       ] , 'vpternlogd  zmm30,zmm29,dword [rcx]{1to16},0x7b'  );
  TestCase.testcase(5859, [$62,$63,$15,$40,$25,$72,$7F,$7B                   ] , 'vpternlogd  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'  );
  TestCase.testcase(5860, [$62,$63,$15,$40,$25,$B2,$00,$20,$00,$00,$7B       ] , 'vpternlogd  zmm30,zmm29,zword [rdx+0x2000],0x7b'  );
  TestCase.testcase(5861, [$62,$63,$15,$40,$25,$72,$80,$7B                   ] , 'vpternlogd  zmm30,zmm29,zword [rdx-0x2000],0x7b'  );
  TestCase.testcase(5862, [$62,$63,$15,$40,$25,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpternlogd  zmm30,zmm29,zword [rdx-0x2040],0x7b'  );
  TestCase.testcase(5863, [$62,$63,$15,$50,$25,$72,$7F,$7B                   ] , 'vpternlogd  zmm30,zmm29,dword [rdx+0x1fc]{1to16},0x7b' );
  TestCase.testcase(5864, [$62,$63,$15,$50,$25,$B2,$00,$02,$00,$00,$7B       ] , 'vpternlogd  zmm30,zmm29,dword [rdx+0x200]{1to16},0x7b' );
  TestCase.testcase(5865, [$62,$63,$15,$50,$25,$72,$80,$7B                   ] , 'vpternlogd  zmm30,zmm29,dword [rdx-0x200]{1to16},0x7b' );
  TestCase.testcase(5866, [$62,$63,$15,$50,$25,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vpternlogd  zmm30,zmm29,dword [rdx-0x204]{1to16},0x7b' );
  TestCase.testcase(5867, [$62,$03,$95,$40,$25,$F4,$AB                       ] , 'vpternlogq  zmm30,zmm29,zmm28,0xab'               );
  TestCase.testcase(5868, [$62,$03,$95,$47,$25,$F4,$AB                       ] , 'vpternlogq  zmm30{k7},zmm29,zmm28,0xab'           );
  TestCase.testcase(5869, [$62,$03,$95,$C7,$25,$F4,$AB                       ] , 'vpternlogq  zmm30{k7}{z},zmm29,zmm28,0xab'        );
  TestCase.testcase(5870, [$62,$03,$95,$40,$25,$F4,$7B                       ] , 'vpternlogq  zmm30,zmm29,zmm28,0x7b'               );
  TestCase.testcase(5871, [$62,$63,$95,$40,$25,$31,$7B                       ] , 'vpternlogq  zmm30,zmm29,zword [rcx],0x7b'         );
  TestCase.testcase(5872, [$62,$23,$95,$40,$25,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpternlogq  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(5873, [$62,$63,$95,$50,$25,$31,$7B                       ] , 'vpternlogq  zmm30,zmm29,qword [rcx]{1to8},0x7b'   );
  TestCase.testcase(5874, [$62,$63,$95,$40,$25,$72,$7F,$7B                   ] , 'vpternlogq  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'  );
  TestCase.testcase(5875, [$62,$63,$95,$40,$25,$B2,$00,$20,$00,$00,$7B       ] , 'vpternlogq  zmm30,zmm29,zword [rdx+0x2000],0x7b'  );
  TestCase.testcase(5876, [$62,$63,$95,$40,$25,$72,$80,$7B                   ] , 'vpternlogq  zmm30,zmm29,zword [rdx-0x2000],0x7b'  );
  TestCase.testcase(5877, [$62,$63,$95,$40,$25,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpternlogq  zmm30,zmm29,zword [rdx-0x2040],0x7b'  );
  TestCase.testcase(5878, [$62,$63,$95,$50,$25,$72,$7F,$7B                   ] , 'vpternlogq  zmm30,zmm29,qword [rdx+0x3f8]{1to8},0x7b' );
  TestCase.testcase(5879, [$62,$63,$95,$50,$25,$B2,$00,$04,$00,$00,$7B       ] , 'vpternlogq  zmm30,zmm29,qword [rdx+0x400]{1to8},0x7b' );
  TestCase.testcase(5880, [$62,$63,$95,$50,$25,$72,$80,$7B                   ] , 'vpternlogq  zmm30,zmm29,qword [rdx-0x400]{1to8},0x7b' );
  TestCase.testcase(5881, [$62,$63,$95,$50,$25,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vpternlogq  zmm30,zmm29,qword [rdx-0x408]{1to8},0x7b' );
  TestCase.testcase(5882, [$62,$02,$7E,$4F,$32,$EE                           ] , 'vpmovqb  xmm30{k7},zmm29'                         );
  TestCase.testcase(5883, [$62,$02,$7E,$CF,$32,$EE                           ] , 'vpmovqb  xmm30{k7}{z},zmm29'                      );
  TestCase.testcase(5884, [$62,$02,$7E,$4F,$22,$EE                           ] , 'vpmovsqb  xmm30{k7},zmm29'                        );
  TestCase.testcase(5885, [$62,$02,$7E,$CF,$22,$EE                           ] , 'vpmovsqb  xmm30{k7}{z},zmm29'                     );
  TestCase.testcase(5886, [$62,$02,$7E,$4F,$12,$EE                           ] , 'vpmovusqb  xmm30{k7},zmm29'                       );
  TestCase.testcase(5887, [$62,$02,$7E,$CF,$12,$EE                           ] , 'vpmovusqb  xmm30{k7}{z},zmm29'                    );
  TestCase.testcase(5888, [$62,$02,$7E,$4F,$34,$EE                           ] , 'vpmovqw  xmm30{k7},zmm29'                         );
  TestCase.testcase(5889, [$62,$02,$7E,$CF,$34,$EE                           ] , 'vpmovqw  xmm30{k7}{z},zmm29'                      );
  TestCase.testcase(5890, [$62,$02,$7E,$4F,$24,$EE                           ] , 'vpmovsqw  xmm30{k7},zmm29'                        );
  TestCase.testcase(5891, [$62,$02,$7E,$CF,$24,$EE                           ] , 'vpmovsqw  xmm30{k7}{z},zmm29'                     );
  TestCase.testcase(5892, [$62,$02,$7E,$4F,$14,$EE                           ] , 'vpmovusqw  xmm30{k7},zmm29'                       );
  TestCase.testcase(5893, [$62,$02,$7E,$CF,$14,$EE                           ] , 'vpmovusqw  xmm30{k7}{z},zmm29'                    );
  TestCase.testcase(5894, [$62,$02,$7E,$4F,$35,$EE                           ] , 'vpmovqd  ymm30{k7},zmm29'                         );
  TestCase.testcase(5895, [$62,$02,$7E,$CF,$35,$EE                           ] , 'vpmovqd  ymm30{k7}{z},zmm29'                      );
  TestCase.testcase(5896, [$62,$02,$7E,$4F,$25,$EE                           ] , 'vpmovsqd  ymm30{k7},zmm29'                        );
  TestCase.testcase(5897, [$62,$02,$7E,$CF,$25,$EE                           ] , 'vpmovsqd  ymm30{k7}{z},zmm29'                     );
  TestCase.testcase(5898, [$62,$02,$7E,$4F,$15,$EE                           ] , 'vpmovusqd  ymm30{k7},zmm29'                       );
  TestCase.testcase(5899, [$62,$02,$7E,$CF,$15,$EE                           ] , 'vpmovusqd  ymm30{k7}{z},zmm29'                    );
  TestCase.testcase(5900, [$62,$02,$7E,$4F,$31,$EE                           ] , 'vpmovdb  xmm30{k7},zmm29'                         );
  TestCase.testcase(5901, [$62,$02,$7E,$CF,$31,$EE                           ] , 'vpmovdb  xmm30{k7}{z},zmm29'                      );
  TestCase.testcase(5902, [$62,$02,$7E,$4F,$21,$EE                           ] , 'vpmovsdb  xmm30{k7},zmm29'                        );
  TestCase.testcase(5903, [$62,$02,$7E,$CF,$21,$EE                           ] , 'vpmovsdb  xmm30{k7}{z},zmm29'                     );
  TestCase.testcase(5904, [$62,$02,$7E,$4F,$11,$EE                           ] , 'vpmovusdb  xmm30{k7},zmm29'                       );
  TestCase.testcase(5905, [$62,$02,$7E,$CF,$11,$EE                           ] , 'vpmovusdb  xmm30{k7}{z},zmm29'                    );
  TestCase.testcase(5906, [$62,$02,$7E,$4F,$33,$EE                           ] , 'vpmovdw  ymm30{k7},zmm29'                         );
  TestCase.testcase(5907, [$62,$02,$7E,$CF,$33,$EE                           ] , 'vpmovdw  ymm30{k7}{z},zmm29'                      );
  TestCase.testcase(5908, [$62,$02,$7E,$4F,$23,$EE                           ] , 'vpmovsdw  ymm30{k7},zmm29'                        );
  TestCase.testcase(5909, [$62,$02,$7E,$CF,$23,$EE                           ] , 'vpmovsdw  ymm30{k7}{z},zmm29'                     );
  TestCase.testcase(5910, [$62,$02,$7E,$4F,$13,$EE                           ] , 'vpmovusdw  ymm30{k7},zmm29'                       );
  TestCase.testcase(5911, [$62,$02,$7E,$CF,$13,$EE                           ] , 'vpmovusdw  ymm30{k7}{z},zmm29'                    );
  TestCase.testcase(5912, [$62,$03,$15,$40,$23,$F4,$AB                       ] , 'vshuff32x4  zmm30,zmm29,zmm28,0xab'               );
  TestCase.testcase(5913, [$62,$03,$15,$47,$23,$F4,$AB                       ] , 'vshuff32x4  zmm30{k7},zmm29,zmm28,0xab'           );
  TestCase.testcase(5914, [$62,$03,$15,$C7,$23,$F4,$AB                       ] , 'vshuff32x4  zmm30{k7}{z},zmm29,zmm28,0xab'        );
  TestCase.testcase(5915, [$62,$03,$15,$40,$23,$F4,$7B                       ] , 'vshuff32x4  zmm30,zmm29,zmm28,0x7b'               );
  TestCase.testcase(5916, [$62,$63,$15,$40,$23,$31,$7B                       ] , 'vshuff32x4  zmm30,zmm29,zword [rcx],0x7b'         );
  TestCase.testcase(5917, [$62,$23,$15,$40,$23,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vshuff32x4  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(5918, [$62,$63,$15,$50,$23,$31,$7B                       ] , 'vshuff32x4  zmm30,zmm29,dword [rcx]{1to16},0x7b'  );
  TestCase.testcase(5919, [$62,$63,$15,$40,$23,$72,$7F,$7B                   ] , 'vshuff32x4  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'  );
  TestCase.testcase(5920, [$62,$63,$15,$40,$23,$B2,$00,$20,$00,$00,$7B       ] , 'vshuff32x4  zmm30,zmm29,zword [rdx+0x2000],0x7b'  );
  TestCase.testcase(5921, [$62,$63,$15,$40,$23,$72,$80,$7B                   ] , 'vshuff32x4  zmm30,zmm29,zword [rdx-0x2000],0x7b'  );
  TestCase.testcase(5922, [$62,$63,$15,$40,$23,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vshuff32x4  zmm30,zmm29,zword [rdx-0x2040],0x7b'  );
  TestCase.testcase(5923, [$62,$63,$15,$50,$23,$72,$7F,$7B                   ] , 'vshuff32x4  zmm30,zmm29,dword [rdx+0x1fc]{1to16},0x7b' );
  TestCase.testcase(5924, [$62,$63,$15,$50,$23,$B2,$00,$02,$00,$00,$7B       ] , 'vshuff32x4  zmm30,zmm29,dword [rdx+0x200]{1to16},0x7b' );
  TestCase.testcase(5925, [$62,$63,$15,$50,$23,$72,$80,$7B                   ] , 'vshuff32x4  zmm30,zmm29,dword [rdx-0x200]{1to16},0x7b' );
  TestCase.testcase(5926, [$62,$63,$15,$50,$23,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vshuff32x4  zmm30,zmm29,dword [rdx-0x204]{1to16},0x7b' );
  TestCase.testcase(5927, [$62,$03,$95,$40,$23,$F4,$AB                       ] , 'vshuff64x2  zmm30,zmm29,zmm28,0xab'               );
  TestCase.testcase(5928, [$62,$03,$95,$47,$23,$F4,$AB                       ] , 'vshuff64x2  zmm30{k7},zmm29,zmm28,0xab'           );
  TestCase.testcase(5929, [$62,$03,$95,$C7,$23,$F4,$AB                       ] , 'vshuff64x2  zmm30{k7}{z},zmm29,zmm28,0xab'        );
  TestCase.testcase(5930, [$62,$03,$95,$40,$23,$F4,$7B                       ] , 'vshuff64x2  zmm30,zmm29,zmm28,0x7b'               );
  TestCase.testcase(5931, [$62,$63,$95,$40,$23,$31,$7B                       ] , 'vshuff64x2  zmm30,zmm29,zword [rcx],0x7b'         );
  TestCase.testcase(5932, [$62,$23,$95,$40,$23,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vshuff64x2  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(5933, [$62,$63,$95,$50,$23,$31,$7B                       ] , 'vshuff64x2  zmm30,zmm29,qword [rcx]{1to8},0x7b'   );
  TestCase.testcase(5934, [$62,$63,$95,$40,$23,$72,$7F,$7B                   ] , 'vshuff64x2  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'  );
  TestCase.testcase(5935, [$62,$63,$95,$40,$23,$B2,$00,$20,$00,$00,$7B       ] , 'vshuff64x2  zmm30,zmm29,zword [rdx+0x2000],0x7b'  );
  TestCase.testcase(5936, [$62,$63,$95,$40,$23,$72,$80,$7B                   ] , 'vshuff64x2  zmm30,zmm29,zword [rdx-0x2000],0x7b'  );
  TestCase.testcase(5937, [$62,$63,$95,$40,$23,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vshuff64x2  zmm30,zmm29,zword [rdx-0x2040],0x7b'  );
  TestCase.testcase(5938, [$62,$63,$95,$50,$23,$72,$7F,$7B                   ] , 'vshuff64x2  zmm30,zmm29,qword [rdx+0x3f8]{1to8},0x7b' );
  TestCase.testcase(5939, [$62,$63,$95,$50,$23,$B2,$00,$04,$00,$00,$7B       ] , 'vshuff64x2  zmm30,zmm29,qword [rdx+0x400]{1to8},0x7b' );
  TestCase.testcase(5940, [$62,$63,$95,$50,$23,$72,$80,$7B                   ] , 'vshuff64x2  zmm30,zmm29,qword [rdx-0x400]{1to8},0x7b' );
  TestCase.testcase(5941, [$62,$63,$95,$50,$23,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vshuff64x2  zmm30,zmm29,qword [rdx-0x408]{1to8},0x7b' );
  TestCase.testcase(5942, [$62,$03,$15,$40,$43,$F4,$AB                       ] , 'vshufi32x4  zmm30,zmm29,zmm28,0xab'               );
  TestCase.testcase(5943, [$62,$03,$15,$47,$43,$F4,$AB                       ] , 'vshufi32x4  zmm30{k7},zmm29,zmm28,0xab'           );
  TestCase.testcase(5944, [$62,$03,$15,$C7,$43,$F4,$AB                       ] , 'vshufi32x4  zmm30{k7}{z},zmm29,zmm28,0xab'        );
  TestCase.testcase(5945, [$62,$03,$15,$40,$43,$F4,$7B                       ] , 'vshufi32x4  zmm30,zmm29,zmm28,0x7b'               );
  TestCase.testcase(5946, [$62,$63,$15,$40,$43,$31,$7B                       ] , 'vshufi32x4  zmm30,zmm29,zword [rcx],0x7b'         );
  TestCase.testcase(5947, [$62,$23,$15,$40,$43,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vshufi32x4  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(5948, [$62,$63,$15,$50,$43,$31,$7B                       ] , 'vshufi32x4  zmm30,zmm29,dword [rcx]{1to16},0x7b'  );
  TestCase.testcase(5949, [$62,$63,$15,$40,$43,$72,$7F,$7B                   ] , 'vshufi32x4  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'  );
  TestCase.testcase(5950, [$62,$63,$15,$40,$43,$B2,$00,$20,$00,$00,$7B       ] , 'vshufi32x4  zmm30,zmm29,zword [rdx+0x2000],0x7b'  );
  TestCase.testcase(5951, [$62,$63,$15,$40,$43,$72,$80,$7B                   ] , 'vshufi32x4  zmm30,zmm29,zword [rdx-0x2000],0x7b'  );
  TestCase.testcase(5952, [$62,$63,$15,$40,$43,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vshufi32x4  zmm30,zmm29,zword [rdx-0x2040],0x7b'  );
  TestCase.testcase(5953, [$62,$63,$15,$50,$43,$72,$7F,$7B                   ] , 'vshufi32x4  zmm30,zmm29,dword [rdx+0x1fc]{1to16},0x7b' );
  TestCase.testcase(5954, [$62,$63,$15,$50,$43,$B2,$00,$02,$00,$00,$7B       ] , 'vshufi32x4  zmm30,zmm29,dword [rdx+0x200]{1to16},0x7b' );
  TestCase.testcase(5955, [$62,$63,$15,$50,$43,$72,$80,$7B                   ] , 'vshufi32x4  zmm30,zmm29,dword [rdx-0x200]{1to16},0x7b' );
  TestCase.testcase(5956, [$62,$63,$15,$50,$43,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vshufi32x4  zmm30,zmm29,dword [rdx-0x204]{1to16},0x7b' );
  TestCase.testcase(5957, [$62,$03,$95,$40,$43,$F4,$AB                       ] , 'vshufi64x2  zmm30,zmm29,zmm28,0xab'               );
  TestCase.testcase(5958, [$62,$03,$95,$47,$43,$F4,$AB                       ] , 'vshufi64x2  zmm30{k7},zmm29,zmm28,0xab'           );
  TestCase.testcase(5959, [$62,$03,$95,$C7,$43,$F4,$AB                       ] , 'vshufi64x2  zmm30{k7}{z},zmm29,zmm28,0xab'        );
  TestCase.testcase(5960, [$62,$03,$95,$40,$43,$F4,$7B                       ] , 'vshufi64x2  zmm30,zmm29,zmm28,0x7b'               );
  TestCase.testcase(5961, [$62,$63,$95,$40,$43,$31,$7B                       ] , 'vshufi64x2  zmm30,zmm29,zword [rcx],0x7b'         );
  TestCase.testcase(5962, [$62,$23,$95,$40,$43,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vshufi64x2  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(5963, [$62,$63,$95,$50,$43,$31,$7B                       ] , 'vshufi64x2  zmm30,zmm29,qword [rcx]{1to8},0x7b'   );
  TestCase.testcase(5964, [$62,$63,$95,$40,$43,$72,$7F,$7B                   ] , 'vshufi64x2  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'  );
  TestCase.testcase(5965, [$62,$63,$95,$40,$43,$B2,$00,$20,$00,$00,$7B       ] , 'vshufi64x2  zmm30,zmm29,zword [rdx+0x2000],0x7b'  );
  TestCase.testcase(5966, [$62,$63,$95,$40,$43,$72,$80,$7B                   ] , 'vshufi64x2  zmm30,zmm29,zword [rdx-0x2000],0x7b'  );
  TestCase.testcase(5967, [$62,$63,$95,$40,$43,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vshufi64x2  zmm30,zmm29,zword [rdx-0x2040],0x7b'  );
  TestCase.testcase(5968, [$62,$63,$95,$50,$43,$72,$7F,$7B                   ] , 'vshufi64x2  zmm30,zmm29,qword [rdx+0x3f8]{1to8},0x7b' );
  TestCase.testcase(5969, [$62,$63,$95,$50,$43,$B2,$00,$04,$00,$00,$7B       ] , 'vshufi64x2  zmm30,zmm29,qword [rdx+0x400]{1to8},0x7b' );
  TestCase.testcase(5970, [$62,$63,$95,$50,$43,$72,$80,$7B                   ] , 'vshufi64x2  zmm30,zmm29,qword [rdx-0x400]{1to8},0x7b' );
  TestCase.testcase(5971, [$62,$63,$95,$50,$43,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vshufi64x2  zmm30,zmm29,qword [rdx-0x408]{1to8},0x7b' );
  TestCase.testcase(5972, [$62,$02,$95,$40,$36,$F4                           ] , 'vpermq  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(5973, [$62,$02,$95,$47,$36,$F4                           ] , 'vpermq  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(5974, [$62,$02,$95,$C7,$36,$F4                           ] , 'vpermq  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(5975, [$62,$62,$95,$40,$36,$31                           ] , 'vpermq  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(5976, [$62,$22,$95,$40,$36,$B4,$F0,$23,$01,$00,$00       ] , 'vpermq  zmm30,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(5977, [$62,$62,$95,$50,$36,$31                           ] , 'vpermq  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(5978, [$62,$62,$95,$40,$36,$72,$7F                       ] , 'vpermq  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(5979, [$62,$62,$95,$40,$36,$B2,$00,$20,$00,$00           ] , 'vpermq  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(5980, [$62,$62,$95,$40,$36,$72,$80                       ] , 'vpermq  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(5981, [$62,$62,$95,$40,$36,$B2,$C0,$DF,$FF,$FF           ] , 'vpermq  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(5982, [$62,$62,$95,$50,$36,$72,$7F                       ] , 'vpermq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(5983, [$62,$62,$95,$50,$36,$B2,$00,$04,$00,$00           ] , 'vpermq  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(5984, [$62,$62,$95,$50,$36,$72,$80                       ] , 'vpermq  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(5985, [$62,$62,$95,$50,$36,$B2,$F8,$FB,$FF,$FF           ] , 'vpermq  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(5986, [$62,$02,$95,$40,$16,$F4                           ] , 'vpermpd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(5987, [$62,$02,$95,$47,$16,$F4                           ] , 'vpermpd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(5988, [$62,$02,$95,$C7,$16,$F4                           ] , 'vpermpd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(5989, [$62,$62,$95,$40,$16,$31                           ] , 'vpermpd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(5990, [$62,$22,$95,$40,$16,$B4,$F0,$23,$01,$00,$00       ] , 'vpermpd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(5991, [$62,$62,$95,$50,$16,$31                           ] , 'vpermpd  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(5992, [$62,$62,$95,$40,$16,$72,$7F                       ] , 'vpermpd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(5993, [$62,$62,$95,$40,$16,$B2,$00,$20,$00,$00           ] , 'vpermpd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(5994, [$62,$62,$95,$40,$16,$72,$80                       ] , 'vpermpd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(5995, [$62,$62,$95,$40,$16,$B2,$C0,$DF,$FF,$FF           ] , 'vpermpd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(5996, [$62,$62,$95,$50,$16,$72,$7F                       ] , 'vpermpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(5997, [$62,$62,$95,$50,$16,$B2,$00,$04,$00,$00           ] , 'vpermpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(5998, [$62,$62,$95,$50,$16,$72,$80                       ] , 'vpermpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(5999, [$62,$62,$95,$50,$16,$B2,$F8,$FB,$FF,$FF           ] , 'vpermpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(6000, [$62,$02,$15,$40,$7E,$F4                           ] , 'vpermt2d  zmm30,zmm29,zmm28'                      );
  TestCase.testcase(6001, [$62,$02,$15,$47,$7E,$F4                           ] , 'vpermt2d  zmm30{k7},zmm29,zmm28'                  );
  TestCase.testcase(6002, [$62,$02,$15,$C7,$7E,$F4                           ] , 'vpermt2d  zmm30{k7}{z},zmm29,zmm28'               );
  TestCase.testcase(6003, [$62,$62,$15,$40,$7E,$31                           ] , 'vpermt2d  zmm30,zmm29,zword [rcx]'                );
  TestCase.testcase(6004, [$62,$22,$15,$40,$7E,$B4,$F0,$23,$01,$00,$00       ] , 'vpermt2d  zmm30,zmm29,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(6005, [$62,$62,$15,$50,$7E,$31                           ] , 'vpermt2d  zmm30,zmm29,dword [rcx]{1to16}'         );
  TestCase.testcase(6006, [$62,$62,$15,$40,$7E,$72,$7F                       ] , 'vpermt2d  zmm30,zmm29,zword [rdx+0x1fc0]'         );
  TestCase.testcase(6007, [$62,$62,$15,$40,$7E,$B2,$00,$20,$00,$00           ] , 'vpermt2d  zmm30,zmm29,zword [rdx+0x2000]'         );
  TestCase.testcase(6008, [$62,$62,$15,$40,$7E,$72,$80                       ] , 'vpermt2d  zmm30,zmm29,zword [rdx-0x2000]'         );
  TestCase.testcase(6009, [$62,$62,$15,$40,$7E,$B2,$C0,$DF,$FF,$FF           ] , 'vpermt2d  zmm30,zmm29,zword [rdx-0x2040]'         );
  TestCase.testcase(6010, [$62,$62,$15,$50,$7E,$72,$7F                       ] , 'vpermt2d  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(6011, [$62,$62,$15,$50,$7E,$B2,$00,$02,$00,$00           ] , 'vpermt2d  zmm30,zmm29,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(6012, [$62,$62,$15,$50,$7E,$72,$80                       ] , 'vpermt2d  zmm30,zmm29,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(6013, [$62,$62,$15,$50,$7E,$B2,$FC,$FD,$FF,$FF           ] , 'vpermt2d  zmm30,zmm29,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(6014, [$62,$02,$95,$40,$7E,$F4                           ] , 'vpermt2q  zmm30,zmm29,zmm28'                      );
  TestCase.testcase(6015, [$62,$02,$95,$47,$7E,$F4                           ] , 'vpermt2q  zmm30{k7},zmm29,zmm28'                  );
  TestCase.testcase(6016, [$62,$02,$95,$C7,$7E,$F4                           ] , 'vpermt2q  zmm30{k7}{z},zmm29,zmm28'               );
  TestCase.testcase(6017, [$62,$62,$95,$40,$7E,$31                           ] , 'vpermt2q  zmm30,zmm29,zword [rcx]'                );
  TestCase.testcase(6018, [$62,$22,$95,$40,$7E,$B4,$F0,$23,$01,$00,$00       ] , 'vpermt2q  zmm30,zmm29,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(6019, [$62,$62,$95,$50,$7E,$31                           ] , 'vpermt2q  zmm30,zmm29,qword [rcx]{1to8}'          );
  TestCase.testcase(6020, [$62,$62,$95,$40,$7E,$72,$7F                       ] , 'vpermt2q  zmm30,zmm29,zword [rdx+0x1fc0]'         );
  TestCase.testcase(6021, [$62,$62,$95,$40,$7E,$B2,$00,$20,$00,$00           ] , 'vpermt2q  zmm30,zmm29,zword [rdx+0x2000]'         );
  TestCase.testcase(6022, [$62,$62,$95,$40,$7E,$72,$80                       ] , 'vpermt2q  zmm30,zmm29,zword [rdx-0x2000]'         );
  TestCase.testcase(6023, [$62,$62,$95,$40,$7E,$B2,$C0,$DF,$FF,$FF           ] , 'vpermt2q  zmm30,zmm29,zword [rdx-0x2040]'         );
  TestCase.testcase(6024, [$62,$62,$95,$50,$7E,$72,$7F                       ] , 'vpermt2q  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(6025, [$62,$62,$95,$50,$7E,$B2,$00,$04,$00,$00           ] , 'vpermt2q  zmm30,zmm29,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(6026, [$62,$62,$95,$50,$7E,$72,$80                       ] , 'vpermt2q  zmm30,zmm29,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(6027, [$62,$62,$95,$50,$7E,$B2,$F8,$FB,$FF,$FF           ] , 'vpermt2q  zmm30,zmm29,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(6028, [$62,$02,$15,$40,$7F,$F4                           ] , 'vpermt2ps  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(6029, [$62,$02,$15,$47,$7F,$F4                           ] , 'vpermt2ps  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(6030, [$62,$02,$15,$C7,$7F,$F4                           ] , 'vpermt2ps  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(6031, [$62,$62,$15,$40,$7F,$31                           ] , 'vpermt2ps  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(6032, [$62,$22,$15,$40,$7F,$B4,$F0,$23,$01,$00,$00       ] , 'vpermt2ps  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(6033, [$62,$62,$15,$50,$7F,$31                           ] , 'vpermt2ps  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(6034, [$62,$62,$15,$40,$7F,$72,$7F                       ] , 'vpermt2ps  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(6035, [$62,$62,$15,$40,$7F,$B2,$00,$20,$00,$00           ] , 'vpermt2ps  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(6036, [$62,$62,$15,$40,$7F,$72,$80                       ] , 'vpermt2ps  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(6037, [$62,$62,$15,$40,$7F,$B2,$C0,$DF,$FF,$FF           ] , 'vpermt2ps  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(6038, [$62,$62,$15,$50,$7F,$72,$7F                       ] , 'vpermt2ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(6039, [$62,$62,$15,$50,$7F,$B2,$00,$02,$00,$00           ] , 'vpermt2ps  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(6040, [$62,$62,$15,$50,$7F,$72,$80                       ] , 'vpermt2ps  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(6041, [$62,$62,$15,$50,$7F,$B2,$FC,$FD,$FF,$FF           ] , 'vpermt2ps  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(6042, [$62,$02,$95,$40,$7F,$F4                           ] , 'vpermt2pd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(6043, [$62,$02,$95,$47,$7F,$F4                           ] , 'vpermt2pd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(6044, [$62,$02,$95,$C7,$7F,$F4                           ] , 'vpermt2pd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(6045, [$62,$62,$95,$40,$7F,$31                           ] , 'vpermt2pd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(6046, [$62,$22,$95,$40,$7F,$B4,$F0,$23,$01,$00,$00       ] , 'vpermt2pd  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(6047, [$62,$62,$95,$50,$7F,$31                           ] , 'vpermt2pd  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(6048, [$62,$62,$95,$40,$7F,$72,$7F                       ] , 'vpermt2pd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(6049, [$62,$62,$95,$40,$7F,$B2,$00,$20,$00,$00           ] , 'vpermt2pd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(6050, [$62,$62,$95,$40,$7F,$72,$80                       ] , 'vpermt2pd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(6051, [$62,$62,$95,$40,$7F,$B2,$C0,$DF,$FF,$FF           ] , 'vpermt2pd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(6052, [$62,$62,$95,$50,$7F,$72,$7F                       ] , 'vpermt2pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(6053, [$62,$62,$95,$50,$7F,$B2,$00,$04,$00,$00           ] , 'vpermt2pd  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(6054, [$62,$62,$95,$50,$7F,$72,$80                       ] , 'vpermt2pd  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(6055, [$62,$62,$95,$50,$7F,$B2,$F8,$FB,$FF,$FF           ] , 'vpermt2pd  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(6056, [$62,$03,$95,$40,$03,$F4,$AB                       ] , 'valignq  zmm30,zmm29,zmm28,0xab'                  );
  TestCase.testcase(6057, [$62,$03,$95,$47,$03,$F4,$AB                       ] , 'valignq  zmm30{k7},zmm29,zmm28,0xab'              );
  TestCase.testcase(6058, [$62,$03,$95,$C7,$03,$F4,$AB                       ] , 'valignq  zmm30{k7}{z},zmm29,zmm28,0xab'           );
  TestCase.testcase(6059, [$62,$03,$95,$40,$03,$F4,$7B                       ] , 'valignq  zmm30,zmm29,zmm28,0x7b'                  );
  TestCase.testcase(6060, [$62,$63,$95,$40,$03,$31,$7B                       ] , 'valignq  zmm30,zmm29,zword [rcx],0x7b'            );
  TestCase.testcase(6061, [$62,$23,$95,$40,$03,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'valignq  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(6062, [$62,$63,$95,$50,$03,$31,$7B                       ] , 'valignq  zmm30,zmm29,qword [rcx]{1to8},0x7b'      );
  TestCase.testcase(6063, [$62,$63,$95,$40,$03,$72,$7F,$7B                   ] , 'valignq  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'     );
  TestCase.testcase(6064, [$62,$63,$95,$40,$03,$B2,$00,$20,$00,$00,$7B       ] , 'valignq  zmm30,zmm29,zword [rdx+0x2000],0x7b'     );
  TestCase.testcase(6065, [$62,$63,$95,$40,$03,$72,$80,$7B                   ] , 'valignq  zmm30,zmm29,zword [rdx-0x2000],0x7b'     );
  TestCase.testcase(6066, [$62,$63,$95,$40,$03,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'valignq  zmm30,zmm29,zword [rdx-0x2040],0x7b'     );
  TestCase.testcase(6067, [$62,$63,$95,$50,$03,$72,$7F,$7B                   ] , 'valignq  zmm30,zmm29,qword [rdx+0x3f8]{1to8},0x7b' );
  TestCase.testcase(6068, [$62,$63,$95,$50,$03,$B2,$00,$04,$00,$00,$7B       ] , 'valignq  zmm30,zmm29,qword [rdx+0x400]{1to8},0x7b' );
  TestCase.testcase(6069, [$62,$63,$95,$50,$03,$72,$80,$7B                   ] , 'valignq  zmm30,zmm29,qword [rdx-0x400]{1to8},0x7b' );
  TestCase.testcase(6070, [$62,$63,$95,$50,$03,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'valignq  zmm30,zmm29,qword [rdx-0x408]{1to8},0x7b' );
  TestCase.testcase(6071, [$62,$91,$7F,$08,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30'                            );
  TestCase.testcase(6072, [$62,$91,$7F,$18,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rn-sae}'                   );
  TestCase.testcase(6073, [$62,$91,$7F,$58,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{ru-sae}'                   );
  TestCase.testcase(6074, [$62,$91,$7F,$38,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rd-sae}'                   );
  TestCase.testcase(6075, [$62,$91,$7F,$78,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm30,{rz-sae}'                   );
  TestCase.testcase(6076, [$62,$F1,$7F,$08,$79,$01                           ] , 'vcvtsd2usi  eax,qword [rcx]'                      );
  TestCase.testcase(6077, [$62,$B1,$7F,$08,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  eax,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(6078, [$62,$F1,$7F,$08,$79,$42,$7F                       ] , 'vcvtsd2usi  eax,qword [rdx+0x3f8]'                );
  TestCase.testcase(6079, [$62,$F1,$7F,$08,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  eax,qword [rdx+0x400]'                );
  TestCase.testcase(6080, [$62,$F1,$7F,$08,$79,$42,$80                       ] , 'vcvtsd2usi  eax,qword [rdx-0x400]'                );
  TestCase.testcase(6081, [$62,$F1,$7F,$08,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  eax,qword [rdx-0x408]'                );
  TestCase.testcase(6082, [$62,$91,$7F,$08,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30'                            );
  TestCase.testcase(6083, [$62,$91,$7F,$18,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rn-sae}'                   );
  TestCase.testcase(6084, [$62,$91,$7F,$58,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{ru-sae}'                   );
  TestCase.testcase(6085, [$62,$91,$7F,$38,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rd-sae}'                   );
  TestCase.testcase(6086, [$62,$91,$7F,$78,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm30,{rz-sae}'                   );
  TestCase.testcase(6087, [$62,$F1,$7F,$08,$79,$29                           ] , 'vcvtsd2usi  ebp,qword [rcx]'                      );
  TestCase.testcase(6088, [$62,$B1,$7F,$08,$79,$AC,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  ebp,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(6089, [$62,$F1,$7F,$08,$79,$6A,$7F                       ] , 'vcvtsd2usi  ebp,qword [rdx+0x3f8]'                );
  TestCase.testcase(6090, [$62,$F1,$7F,$08,$79,$AA,$00,$04,$00,$00           ] , 'vcvtsd2usi  ebp,qword [rdx+0x400]'                );
  TestCase.testcase(6091, [$62,$F1,$7F,$08,$79,$6A,$80                       ] , 'vcvtsd2usi  ebp,qword [rdx-0x400]'                );
  TestCase.testcase(6092, [$62,$F1,$7F,$08,$79,$AA,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  ebp,qword [rdx-0x408]'                );
  TestCase.testcase(6093, [$62,$11,$7F,$08,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30'                           );
  TestCase.testcase(6094, [$62,$11,$7F,$18,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rn-sae}'                  );
  TestCase.testcase(6095, [$62,$11,$7F,$58,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{ru-sae}'                  );
  TestCase.testcase(6096, [$62,$11,$7F,$38,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rd-sae}'                  );
  TestCase.testcase(6097, [$62,$11,$7F,$78,$79,$EE                           ] , 'vcvtsd2usi  r13d,xmm30,{rz-sae}'                  );
  TestCase.testcase(6098, [$62,$71,$7F,$08,$79,$29                           ] , 'vcvtsd2usi  r13d,qword [rcx]'                     );
  TestCase.testcase(6099, [$62,$31,$7F,$08,$79,$AC,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  r13d,qword [rax+r14*8+0x123]'         );
  TestCase.testcase(6100, [$62,$71,$7F,$08,$79,$6A,$7F                       ] , 'vcvtsd2usi  r13d,qword [rdx+0x3f8]'               );
  TestCase.testcase(6101, [$62,$71,$7F,$08,$79,$AA,$00,$04,$00,$00           ] , 'vcvtsd2usi  r13d,qword [rdx+0x400]'               );
  TestCase.testcase(6102, [$62,$71,$7F,$08,$79,$6A,$80                       ] , 'vcvtsd2usi  r13d,qword [rdx-0x400]'               );
  TestCase.testcase(6103, [$62,$71,$7F,$08,$79,$AA,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  r13d,qword [rdx-0x408]'               );
  TestCase.testcase(6104, [$62,$91,$FF,$08,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30'                            );
  TestCase.testcase(6105, [$62,$91,$FF,$18,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rn-sae}'                   );
  TestCase.testcase(6106, [$62,$91,$FF,$58,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{ru-sae}'                   );
  TestCase.testcase(6107, [$62,$91,$FF,$38,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rd-sae}'                   );
  TestCase.testcase(6108, [$62,$91,$FF,$78,$79,$C6                           ] , 'vcvtsd2usi  rax,xmm30,{rz-sae}'                   );
  TestCase.testcase(6109, [$62,$F1,$FF,$08,$79,$01                           ] , 'vcvtsd2usi  rax,qword [rcx]'                      );
  TestCase.testcase(6110, [$62,$B1,$FF,$08,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  rax,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(6111, [$62,$F1,$FF,$08,$79,$42,$7F                       ] , 'vcvtsd2usi  rax,qword [rdx+0x3f8]'                );
  TestCase.testcase(6112, [$62,$F1,$FF,$08,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  rax,qword [rdx+0x400]'                );
  TestCase.testcase(6113, [$62,$F1,$FF,$08,$79,$42,$80                       ] , 'vcvtsd2usi  rax,qword [rdx-0x400]'                );
  TestCase.testcase(6114, [$62,$F1,$FF,$08,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  rax,qword [rdx-0x408]'                );
  TestCase.testcase(6115, [$62,$11,$FF,$08,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30'                             );
  TestCase.testcase(6116, [$62,$11,$FF,$18,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rn-sae}'                    );
  TestCase.testcase(6117, [$62,$11,$FF,$58,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{ru-sae}'                    );
  TestCase.testcase(6118, [$62,$11,$FF,$38,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rd-sae}'                    );
  TestCase.testcase(6119, [$62,$11,$FF,$78,$79,$C6                           ] , 'vcvtsd2usi  r8,xmm30,{rz-sae}'                    );
  TestCase.testcase(6120, [$62,$71,$FF,$08,$79,$01                           ] , 'vcvtsd2usi  r8,qword [rcx]'                       );
  TestCase.testcase(6121, [$62,$31,$FF,$08,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtsd2usi  r8,qword [rax+r14*8+0x123]'           );
  TestCase.testcase(6122, [$62,$71,$FF,$08,$79,$42,$7F                       ] , 'vcvtsd2usi  r8,qword [rdx+0x3f8]'                 );
  TestCase.testcase(6123, [$62,$71,$FF,$08,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  r8,qword [rdx+0x400]'                 );
  TestCase.testcase(6124, [$62,$71,$FF,$08,$79,$42,$80                       ] , 'vcvtsd2usi  r8,qword [rdx-0x400]'                 );
  TestCase.testcase(6125, [$62,$71,$FF,$08,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  r8,qword [rdx-0x408]'                 );
  TestCase.testcase(6126, [$62,$91,$7E,$08,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30'                            );
  TestCase.testcase(6127, [$62,$91,$7E,$18,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rn-sae}'                   );
  TestCase.testcase(6128, [$62,$91,$7E,$58,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{ru-sae}'                   );
  TestCase.testcase(6129, [$62,$91,$7E,$38,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rd-sae}'                   );
  TestCase.testcase(6130, [$62,$91,$7E,$78,$79,$C6                           ] , 'vcvtss2usi  eax,xmm30,{rz-sae}'                   );
  TestCase.testcase(6131, [$62,$F1,$7E,$08,$79,$01                           ] , 'vcvtss2usi  eax,dword [rcx]'                      );
  TestCase.testcase(6132, [$62,$B1,$7E,$08,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  eax,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(6133, [$62,$F1,$7E,$08,$79,$42,$7F                       ] , 'vcvtss2usi  eax,dword [rdx+0x1fc]'                );
  TestCase.testcase(6134, [$62,$F1,$7E,$08,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  eax,dword [rdx+0x200]'                );
  TestCase.testcase(6135, [$62,$F1,$7E,$08,$79,$42,$80                       ] , 'vcvtss2usi  eax,dword [rdx-0x200]'                );
  TestCase.testcase(6136, [$62,$F1,$7E,$08,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  eax,dword [rdx-0x204]'                );
  TestCase.testcase(6137, [$62,$91,$7E,$08,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30'                            );
  TestCase.testcase(6138, [$62,$91,$7E,$18,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rn-sae}'                   );
  TestCase.testcase(6139, [$62,$91,$7E,$58,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{ru-sae}'                   );
  TestCase.testcase(6140, [$62,$91,$7E,$38,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rd-sae}'                   );
  TestCase.testcase(6141, [$62,$91,$7E,$78,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm30,{rz-sae}'                   );
  TestCase.testcase(6142, [$62,$F1,$7E,$08,$79,$29                           ] , 'vcvtss2usi  ebp,dword [rcx]'                      );
  TestCase.testcase(6143, [$62,$B1,$7E,$08,$79,$AC,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  ebp,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(6144, [$62,$F1,$7E,$08,$79,$6A,$7F                       ] , 'vcvtss2usi  ebp,dword [rdx+0x1fc]'                );
  TestCase.testcase(6145, [$62,$F1,$7E,$08,$79,$AA,$00,$02,$00,$00           ] , 'vcvtss2usi  ebp,dword [rdx+0x200]'                );
  TestCase.testcase(6146, [$62,$F1,$7E,$08,$79,$6A,$80                       ] , 'vcvtss2usi  ebp,dword [rdx-0x200]'                );
  TestCase.testcase(6147, [$62,$F1,$7E,$08,$79,$AA,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  ebp,dword [rdx-0x204]'                );
  TestCase.testcase(6148, [$62,$11,$7E,$08,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30'                           );
  TestCase.testcase(6149, [$62,$11,$7E,$18,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rn-sae}'                  );
  TestCase.testcase(6150, [$62,$11,$7E,$58,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{ru-sae}'                  );
  TestCase.testcase(6151, [$62,$11,$7E,$38,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rd-sae}'                  );
  TestCase.testcase(6152, [$62,$11,$7E,$78,$79,$EE                           ] , 'vcvtss2usi  r13d,xmm30,{rz-sae}'                  );
  TestCase.testcase(6153, [$62,$71,$7E,$08,$79,$29                           ] , 'vcvtss2usi  r13d,dword [rcx]'                     );
  TestCase.testcase(6154, [$62,$31,$7E,$08,$79,$AC,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  r13d,dword [rax+r14*8+0x123]'         );
  TestCase.testcase(6155, [$62,$71,$7E,$08,$79,$6A,$7F                       ] , 'vcvtss2usi  r13d,dword [rdx+0x1fc]'               );
  TestCase.testcase(6156, [$62,$71,$7E,$08,$79,$AA,$00,$02,$00,$00           ] , 'vcvtss2usi  r13d,dword [rdx+0x200]'               );
  TestCase.testcase(6157, [$62,$71,$7E,$08,$79,$6A,$80                       ] , 'vcvtss2usi  r13d,dword [rdx-0x200]'               );
  TestCase.testcase(6158, [$62,$71,$7E,$08,$79,$AA,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  r13d,dword [rdx-0x204]'               );
  TestCase.testcase(6159, [$62,$91,$FE,$08,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30'                            );
  TestCase.testcase(6160, [$62,$91,$FE,$18,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rn-sae}'                   );
  TestCase.testcase(6161, [$62,$91,$FE,$58,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{ru-sae}'                   );
  TestCase.testcase(6162, [$62,$91,$FE,$38,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rd-sae}'                   );
  TestCase.testcase(6163, [$62,$91,$FE,$78,$79,$C6                           ] , 'vcvtss2usi  rax,xmm30,{rz-sae}'                   );
  TestCase.testcase(6164, [$62,$F1,$FE,$08,$79,$01                           ] , 'vcvtss2usi  rax,dword [rcx]'                      );
  TestCase.testcase(6165, [$62,$B1,$FE,$08,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  rax,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(6166, [$62,$F1,$FE,$08,$79,$42,$7F                       ] , 'vcvtss2usi  rax,dword [rdx+0x1fc]'                );
  TestCase.testcase(6167, [$62,$F1,$FE,$08,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  rax,dword [rdx+0x200]'                );
  TestCase.testcase(6168, [$62,$F1,$FE,$08,$79,$42,$80                       ] , 'vcvtss2usi  rax,dword [rdx-0x200]'                );
  TestCase.testcase(6169, [$62,$F1,$FE,$08,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  rax,dword [rdx-0x204]'                );
  TestCase.testcase(6170, [$62,$11,$FE,$08,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30'                             );
  TestCase.testcase(6171, [$62,$11,$FE,$18,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rn-sae}'                    );
  TestCase.testcase(6172, [$62,$11,$FE,$58,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{ru-sae}'                    );
  TestCase.testcase(6173, [$62,$11,$FE,$38,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rd-sae}'                    );
  TestCase.testcase(6174, [$62,$11,$FE,$78,$79,$C6                           ] , 'vcvtss2usi  r8,xmm30,{rz-sae}'                    );
  TestCase.testcase(6175, [$62,$71,$FE,$08,$79,$01                           ] , 'vcvtss2usi  r8,dword [rcx]'                       );
  TestCase.testcase(6176, [$62,$31,$FE,$08,$79,$84,$F0,$23,$01,$00,$00       ] , 'vcvtss2usi  r8,dword [rax+r14*8+0x123]'           );
  TestCase.testcase(6177, [$62,$71,$FE,$08,$79,$42,$7F                       ] , 'vcvtss2usi  r8,dword [rdx+0x1fc]'                 );
  TestCase.testcase(6178, [$62,$71,$FE,$08,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  r8,dword [rdx+0x200]'                 );
  TestCase.testcase(6179, [$62,$71,$FE,$08,$79,$42,$80                       ] , 'vcvtss2usi  r8,dword [rdx-0x200]'                 );
  TestCase.testcase(6180, [$62,$71,$FE,$08,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  r8,dword [rdx-0x204]'                 );
  TestCase.testcase(6181, [$62,$61,$17,$00,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,eax'                      );
  TestCase.testcase(6182, [$62,$61,$17,$00,$7B,$F5                           ] , 'vcvtusi2sd  xmm30,xmm29,ebp'                      );
  TestCase.testcase(6183, [$62,$41,$17,$00,$7B,$F5                           ] , 'vcvtusi2sd  xmm30,xmm29,r13d'                     );
  TestCase.testcase(6184, [$62,$61,$17,$00,$7B,$31                           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rcx]'              );
  TestCase.testcase(6185, [$62,$21,$17,$00,$7B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(6186, [$62,$61,$17,$00,$7B,$72,$7F                       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(6187, [$62,$61,$17,$00,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(6188, [$62,$61,$17,$00,$7B,$72,$80                       ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(6189, [$62,$61,$17,$00,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2sd  xmm30,xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(6190, [$62,$61,$97,$00,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,rax'                      );
  TestCase.testcase(6191, [$62,$61,$97,$10,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rn-sae},rax'             );
  TestCase.testcase(6192, [$62,$61,$97,$50,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{ru-sae},rax'             );
  TestCase.testcase(6193, [$62,$61,$97,$30,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rd-sae},rax'             );
  TestCase.testcase(6194, [$62,$61,$97,$70,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rz-sae},rax'             );
  TestCase.testcase(6195, [$62,$41,$97,$00,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,r8'                       );
  TestCase.testcase(6196, [$62,$41,$97,$10,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rn-sae},r8'              );
  TestCase.testcase(6197, [$62,$41,$97,$50,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{ru-sae},r8'              );
  TestCase.testcase(6198, [$62,$41,$97,$30,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rd-sae},r8'              );
  TestCase.testcase(6199, [$62,$41,$97,$70,$7B,$F0                           ] , 'vcvtusi2sd  xmm30,xmm29,{rz-sae},r8'              );
  TestCase.testcase(6200, [$62,$61,$97,$00,$7B,$31                           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rcx]'              );
  TestCase.testcase(6201, [$62,$21,$97,$00,$7B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(6202, [$62,$61,$97,$00,$7B,$72,$7F                       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(6203, [$62,$61,$97,$00,$7B,$B2,$00,$04,$00,$00           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(6204, [$62,$61,$97,$00,$7B,$72,$80                       ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(6205, [$62,$61,$97,$00,$7B,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtusi2sd  xmm30,xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(6206, [$62,$61,$16,$00,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,eax'                      );
  TestCase.testcase(6207, [$62,$61,$16,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},eax'             );
  TestCase.testcase(6208, [$62,$61,$16,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},eax'             );
  TestCase.testcase(6209, [$62,$61,$16,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},eax'             );
  TestCase.testcase(6210, [$62,$61,$16,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},eax'             );
  TestCase.testcase(6211, [$62,$61,$16,$00,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,ebp'                      );
  TestCase.testcase(6212, [$62,$61,$16,$10,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},ebp'             );
  TestCase.testcase(6213, [$62,$61,$16,$50,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},ebp'             );
  TestCase.testcase(6214, [$62,$61,$16,$30,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},ebp'             );
  TestCase.testcase(6215, [$62,$61,$16,$70,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},ebp'             );
  TestCase.testcase(6216, [$62,$41,$16,$00,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,r13d'                     );
  TestCase.testcase(6217, [$62,$41,$16,$10,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},r13d'            );
  TestCase.testcase(6218, [$62,$41,$16,$50,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},r13d'            );
  TestCase.testcase(6219, [$62,$41,$16,$30,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},r13d'            );
  TestCase.testcase(6220, [$62,$41,$16,$70,$7B,$F5                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},r13d'            );
  TestCase.testcase(6221, [$62,$61,$16,$00,$7B,$31                           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rcx]'              );
  TestCase.testcase(6222, [$62,$21,$16,$00,$7B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rax+r14*8+0x123]'  );
  TestCase.testcase(6223, [$62,$61,$16,$00,$7B,$72,$7F                       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(6224, [$62,$61,$16,$00,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(6225, [$62,$61,$16,$00,$7B,$72,$80                       ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(6226, [$62,$61,$16,$00,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2ss  xmm30,xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(6227, [$62,$61,$96,$00,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,rax'                      );
  TestCase.testcase(6228, [$62,$61,$96,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},rax'             );
  TestCase.testcase(6229, [$62,$61,$96,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},rax'             );
  TestCase.testcase(6230, [$62,$61,$96,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},rax'             );
  TestCase.testcase(6231, [$62,$61,$96,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},rax'             );
  TestCase.testcase(6232, [$62,$41,$96,$00,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,r8'                       );
  TestCase.testcase(6233, [$62,$41,$96,$10,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rn-sae},r8'              );
  TestCase.testcase(6234, [$62,$41,$96,$50,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{ru-sae},r8'              );
  TestCase.testcase(6235, [$62,$41,$96,$30,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rd-sae},r8'              );
  TestCase.testcase(6236, [$62,$41,$96,$70,$7B,$F0                           ] , 'vcvtusi2ss  xmm30,xmm29,{rz-sae},r8'              );
  TestCase.testcase(6237, [$62,$61,$96,$00,$7B,$31                           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rcx]'              );
  TestCase.testcase(6238, [$62,$21,$96,$00,$7B,$B4,$F0,$23,$01,$00,$00       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rax+r14*8+0x123]'  );
  TestCase.testcase(6239, [$62,$61,$96,$00,$7B,$72,$7F                       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(6240, [$62,$61,$96,$00,$7B,$B2,$00,$04,$00,$00           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(6241, [$62,$61,$96,$00,$7B,$72,$80                       ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(6242, [$62,$61,$96,$00,$7B,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtusi2ss  xmm30,xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(6243, [$62,$02,$95,$40,$2C,$F4                           ] , 'vscalefpd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(6244, [$62,$02,$95,$47,$2C,$F4                           ] , 'vscalefpd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(6245, [$62,$02,$95,$C7,$2C,$F4                           ] , 'vscalefpd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(6246, [$62,$02,$95,$10,$2C,$F4                           ] , 'vscalefpd  zmm30,zmm29,zmm28,{rn-sae}'            );
  TestCase.testcase(6247, [$62,$02,$95,$50,$2C,$F4                           ] , 'vscalefpd  zmm30,zmm29,zmm28,{ru-sae}'            );
  TestCase.testcase(6248, [$62,$02,$95,$30,$2C,$F4                           ] , 'vscalefpd  zmm30,zmm29,zmm28,{rd-sae}'            );
  TestCase.testcase(6249, [$62,$02,$95,$70,$2C,$F4                           ] , 'vscalefpd  zmm30,zmm29,zmm28,{rz-sae}'            );
  TestCase.testcase(6250, [$62,$62,$95,$40,$2C,$31                           ] , 'vscalefpd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(6251, [$62,$22,$95,$40,$2C,$B4,$F0,$23,$01,$00,$00       ] , 'vscalefpd  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(6252, [$62,$62,$95,$50,$2C,$31                           ] , 'vscalefpd  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(6253, [$62,$62,$95,$40,$2C,$72,$7F                       ] , 'vscalefpd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(6254, [$62,$62,$95,$40,$2C,$B2,$00,$20,$00,$00           ] , 'vscalefpd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(6255, [$62,$62,$95,$40,$2C,$72,$80                       ] , 'vscalefpd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(6256, [$62,$62,$95,$40,$2C,$B2,$C0,$DF,$FF,$FF           ] , 'vscalefpd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(6257, [$62,$62,$95,$50,$2C,$72,$7F                       ] , 'vscalefpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(6258, [$62,$62,$95,$50,$2C,$B2,$00,$04,$00,$00           ] , 'vscalefpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(6259, [$62,$62,$95,$50,$2C,$72,$80                       ] , 'vscalefpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(6260, [$62,$62,$95,$50,$2C,$B2,$F8,$FB,$FF,$FF           ] , 'vscalefpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(6261, [$62,$02,$15,$40,$2C,$F4                           ] , 'vscalefps  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(6262, [$62,$02,$15,$47,$2C,$F4                           ] , 'vscalefps  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(6263, [$62,$02,$15,$C7,$2C,$F4                           ] , 'vscalefps  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(6264, [$62,$02,$15,$10,$2C,$F4                           ] , 'vscalefps  zmm30,zmm29,zmm28,{rn-sae}'            );
  TestCase.testcase(6265, [$62,$02,$15,$50,$2C,$F4                           ] , 'vscalefps  zmm30,zmm29,zmm28,{ru-sae}'            );
  TestCase.testcase(6266, [$62,$02,$15,$30,$2C,$F4                           ] , 'vscalefps  zmm30,zmm29,zmm28,{rd-sae}'            );
  TestCase.testcase(6267, [$62,$02,$15,$70,$2C,$F4                           ] , 'vscalefps  zmm30,zmm29,zmm28,{rz-sae}'            );
  TestCase.testcase(6268, [$62,$62,$15,$40,$2C,$31                           ] , 'vscalefps  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(6269, [$62,$22,$15,$40,$2C,$B4,$F0,$23,$01,$00,$00       ] , 'vscalefps  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(6270, [$62,$62,$15,$50,$2C,$31                           ] , 'vscalefps  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(6271, [$62,$62,$15,$40,$2C,$72,$7F                       ] , 'vscalefps  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(6272, [$62,$62,$15,$40,$2C,$B2,$00,$20,$00,$00           ] , 'vscalefps  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(6273, [$62,$62,$15,$40,$2C,$72,$80                       ] , 'vscalefps  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(6274, [$62,$62,$15,$40,$2C,$B2,$C0,$DF,$FF,$FF           ] , 'vscalefps  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(6275, [$62,$62,$15,$50,$2C,$72,$7F                       ] , 'vscalefps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(6276, [$62,$62,$15,$50,$2C,$B2,$00,$02,$00,$00           ] , 'vscalefps  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(6277, [$62,$62,$15,$50,$2C,$72,$80                       ] , 'vscalefps  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(6278, [$62,$62,$15,$50,$2C,$B2,$FC,$FD,$FF,$FF           ] , 'vscalefps  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(6279, [$62,$02,$95,$07,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(6280, [$62,$02,$95,$87,$2D,$F4                           ] , 'vscalefsd  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(6281, [$62,$02,$95,$17,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(6282, [$62,$02,$95,$57,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(6283, [$62,$02,$95,$37,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(6284, [$62,$02,$95,$77,$2D,$F4                           ] , 'vscalefsd  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(6285, [$62,$62,$95,$07,$2D,$31                           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rcx]'           );
  TestCase.testcase(6286, [$62,$22,$95,$07,$2D,$B4,$F0,$23,$01,$00,$00       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123]' );
  TestCase.testcase(6287, [$62,$62,$95,$07,$2D,$72,$7F                       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'     );
  TestCase.testcase(6288, [$62,$62,$95,$07,$2D,$B2,$00,$04,$00,$00           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx+0x400]'     );
  TestCase.testcase(6289, [$62,$62,$95,$07,$2D,$72,$80                       ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx-0x400]'     );
  TestCase.testcase(6290, [$62,$62,$95,$07,$2D,$B2,$F8,$FB,$FF,$FF           ] , 'vscalefsd  xmm30{k7},xmm29,qword [rdx-0x408]'     );
  TestCase.testcase(6291, [$62,$02,$15,$07,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28'                 );
  TestCase.testcase(6292, [$62,$02,$15,$87,$2D,$F4                           ] , 'vscalefss  xmm30{k7}{z},xmm29,xmm28'              );
  TestCase.testcase(6293, [$62,$02,$15,$17,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rn-sae}'        );
  TestCase.testcase(6294, [$62,$02,$15,$57,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{ru-sae}'        );
  TestCase.testcase(6295, [$62,$02,$15,$37,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rd-sae}'        );
  TestCase.testcase(6296, [$62,$02,$15,$77,$2D,$F4                           ] , 'vscalefss  xmm30{k7},xmm29,xmm28,{rz-sae}'        );
  TestCase.testcase(6297, [$62,$62,$15,$07,$2D,$31                           ] , 'vscalefss  xmm30{k7},xmm29,dword [rcx]'           );
  TestCase.testcase(6298, [$62,$22,$15,$07,$2D,$B4,$F0,$23,$01,$00,$00       ] , 'vscalefss  xmm30{k7},xmm29,dword [rax+r14*8+0x123]' );
  TestCase.testcase(6299, [$62,$62,$15,$07,$2D,$72,$7F                       ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx+0x1fc]'     );
  TestCase.testcase(6300, [$62,$62,$15,$07,$2D,$B2,$00,$02,$00,$00           ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx+0x200]'     );
  TestCase.testcase(6301, [$62,$62,$15,$07,$2D,$72,$80                       ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx-0x200]'     );
  TestCase.testcase(6302, [$62,$62,$15,$07,$2D,$B2,$FC,$FD,$FF,$FF           ] , 'vscalefss  xmm30{k7},xmm29,dword [rdx-0x204]'     );
  TestCase.testcase(6303, [$62,$03,$15,$40,$54,$F4,$AB                       ] , 'vfixupimmps  zmm30,zmm29,zmm28,0xab'              );
  TestCase.testcase(6304, [$62,$03,$15,$47,$54,$F4,$AB                       ] , 'vfixupimmps  zmm30{k7},zmm29,zmm28,0xab'          );
  TestCase.testcase(6305, [$62,$03,$15,$C7,$54,$F4,$AB                       ] , 'vfixupimmps  zmm30{k7}{z},zmm29,zmm28,0xab'       );
  TestCase.testcase(6306, [$62,$03,$15,$10,$54,$F4,$AB                       ] , 'vfixupimmps  zmm30,zmm29,zmm28,{sae},0xab'        );
  TestCase.testcase(6307, [$62,$03,$15,$40,$54,$F4,$7B                       ] , 'vfixupimmps  zmm30,zmm29,zmm28,0x7b'              );
  TestCase.testcase(6308, [$62,$03,$15,$10,$54,$F4,$7B                       ] , 'vfixupimmps  zmm30,zmm29,zmm28,{sae},0x7b'        );
  TestCase.testcase(6309, [$62,$63,$15,$40,$54,$31,$7B                       ] , 'vfixupimmps  zmm30,zmm29,zword [rcx],0x7b'        );
  TestCase.testcase(6310, [$62,$23,$15,$40,$54,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vfixupimmps  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(6311, [$62,$63,$15,$50,$54,$31,$7B                       ] , 'vfixupimmps  zmm30,zmm29,dword [rcx]{1to16},0x7b' );
  TestCase.testcase(6312, [$62,$63,$15,$40,$54,$72,$7F,$7B                   ] , 'vfixupimmps  zmm30,zmm29,zword [rdx+0x1fc0],0x7b' );
  TestCase.testcase(6313, [$62,$63,$15,$40,$54,$B2,$00,$20,$00,$00,$7B       ] , 'vfixupimmps  zmm30,zmm29,zword [rdx+0x2000],0x7b' );
  TestCase.testcase(6314, [$62,$63,$15,$40,$54,$72,$80,$7B                   ] , 'vfixupimmps  zmm30,zmm29,zword [rdx-0x2000],0x7b' );
  TestCase.testcase(6315, [$62,$63,$15,$40,$54,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vfixupimmps  zmm30,zmm29,zword [rdx-0x2040],0x7b' );
  TestCase.testcase(6316, [$62,$63,$15,$50,$54,$72,$7F,$7B                   ] , 'vfixupimmps  zmm30,zmm29,dword [rdx+0x1fc]{1to16},0x7b' );
  TestCase.testcase(6317, [$62,$63,$15,$50,$54,$B2,$00,$02,$00,$00,$7B       ] , 'vfixupimmps  zmm30,zmm29,dword [rdx+0x200]{1to16},0x7b' );
  TestCase.testcase(6318, [$62,$63,$15,$50,$54,$72,$80,$7B                   ] , 'vfixupimmps  zmm30,zmm29,dword [rdx-0x200]{1to16},0x7b' );
  TestCase.testcase(6319, [$62,$63,$15,$50,$54,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vfixupimmps  zmm30,zmm29,dword [rdx-0x204]{1to16},0x7b' );
  TestCase.testcase(6320, [$62,$03,$95,$40,$54,$F4,$AB                       ] , 'vfixupimmpd  zmm30,zmm29,zmm28,0xab'              );
  TestCase.testcase(6321, [$62,$03,$95,$47,$54,$F4,$AB                       ] , 'vfixupimmpd  zmm30{k7},zmm29,zmm28,0xab'          );
  TestCase.testcase(6322, [$62,$03,$95,$C7,$54,$F4,$AB                       ] , 'vfixupimmpd  zmm30{k7}{z},zmm29,zmm28,0xab'       );
  TestCase.testcase(6323, [$62,$03,$95,$10,$54,$F4,$AB                       ] , 'vfixupimmpd  zmm30,zmm29,zmm28,{sae},0xab'        );
  TestCase.testcase(6324, [$62,$03,$95,$40,$54,$F4,$7B                       ] , 'vfixupimmpd  zmm30,zmm29,zmm28,0x7b'              );
  TestCase.testcase(6325, [$62,$03,$95,$10,$54,$F4,$7B                       ] , 'vfixupimmpd  zmm30,zmm29,zmm28,{sae},0x7b'        );
  TestCase.testcase(6326, [$62,$63,$95,$40,$54,$31,$7B                       ] , 'vfixupimmpd  zmm30,zmm29,zword [rcx],0x7b'        );
  TestCase.testcase(6327, [$62,$23,$95,$40,$54,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vfixupimmpd  zmm30,zmm29,zword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(6328, [$62,$63,$95,$50,$54,$31,$7B                       ] , 'vfixupimmpd  zmm30,zmm29,qword [rcx]{1to8},0x7b'  );
  TestCase.testcase(6329, [$62,$63,$95,$40,$54,$72,$7F,$7B                   ] , 'vfixupimmpd  zmm30,zmm29,zword [rdx+0x1fc0],0x7b' );
  TestCase.testcase(6330, [$62,$63,$95,$40,$54,$B2,$00,$20,$00,$00,$7B       ] , 'vfixupimmpd  zmm30,zmm29,zword [rdx+0x2000],0x7b' );
  TestCase.testcase(6331, [$62,$63,$95,$40,$54,$72,$80,$7B                   ] , 'vfixupimmpd  zmm30,zmm29,zword [rdx-0x2000],0x7b' );
  TestCase.testcase(6332, [$62,$63,$95,$40,$54,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vfixupimmpd  zmm30,zmm29,zword [rdx-0x2040],0x7b' );
  TestCase.testcase(6333, [$62,$63,$95,$50,$54,$72,$7F,$7B                   ] , 'vfixupimmpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8},0x7b' );
  TestCase.testcase(6334, [$62,$63,$95,$50,$54,$B2,$00,$04,$00,$00,$7B       ] , 'vfixupimmpd  zmm30,zmm29,qword [rdx+0x400]{1to8},0x7b' );
  TestCase.testcase(6335, [$62,$63,$95,$50,$54,$72,$80,$7B                   ] , 'vfixupimmpd  zmm30,zmm29,qword [rdx-0x400]{1to8},0x7b' );
  TestCase.testcase(6336, [$62,$63,$95,$50,$54,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vfixupimmpd  zmm30,zmm29,qword [rdx-0x408]{1to8},0x7b' );
  TestCase.testcase(6337, [$62,$03,$15,$07,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(6338, [$62,$03,$15,$87,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(6339, [$62,$03,$15,$17,$55,$F4,$AB                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(6340, [$62,$03,$15,$07,$55,$F4,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(6341, [$62,$03,$15,$17,$55,$F4,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(6342, [$62,$63,$15,$07,$55,$31,$7B                       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rcx],0x7b'    );
  TestCase.testcase(6343, [$62,$23,$15,$07,$55,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(6344, [$62,$63,$15,$07,$55,$72,$7F,$7B                   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(6345, [$62,$63,$15,$07,$55,$B2,$00,$02,$00,$00,$7B       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(6346, [$62,$63,$15,$07,$55,$72,$80,$7B                   ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(6347, [$62,$63,$15,$07,$55,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vfixupimmss  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.testcase(6348, [$62,$03,$95,$07,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(6349, [$62,$03,$95,$87,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(6350, [$62,$03,$95,$17,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(6351, [$62,$03,$95,$07,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(6352, [$62,$03,$95,$17,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(6353, [$62,$63,$95,$07,$55,$31,$7B                       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rcx],0x7b'    );
  TestCase.testcase(6354, [$62,$23,$95,$07,$55,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(6355, [$62,$63,$95,$07,$55,$72,$7F,$7B                   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(6356, [$62,$63,$95,$07,$55,$B2,$00,$04,$00,$00,$7B       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(6357, [$62,$63,$95,$07,$55,$72,$80,$7B                   ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(6358, [$62,$63,$95,$07,$55,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vfixupimmsd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(6359, [$62,$91,$0D,$40,$72,$F5,$AB                       ] , 'vpslld  zmm30,zmm29,0xab'                         );
  TestCase.testcase(6360, [$62,$91,$0D,$47,$72,$F5,$AB                       ] , 'vpslld  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(6361, [$62,$91,$0D,$C7,$72,$F5,$AB                       ] , 'vpslld  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(6362, [$62,$91,$0D,$40,$72,$F5,$7B                       ] , 'vpslld  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(6363, [$62,$F1,$0D,$40,$72,$31,$7B                       ] , 'vpslld  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(6364, [$62,$B1,$0D,$40,$72,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpslld  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(6365, [$62,$F1,$0D,$50,$72,$31,$7B                       ] , 'vpslld  zmm30,dword [rcx]{1to16},0x7b'            );
  TestCase.testcase(6366, [$62,$F1,$0D,$40,$72,$72,$7F,$7B                   ] , 'vpslld  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(6367, [$62,$F1,$0D,$40,$72,$B2,$00,$20,$00,$00,$7B       ] , 'vpslld  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(6368, [$62,$F1,$0D,$40,$72,$72,$80,$7B                   ] , 'vpslld  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(6369, [$62,$F1,$0D,$40,$72,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpslld  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(6370, [$62,$F1,$0D,$50,$72,$72,$7F,$7B                   ] , 'vpslld  zmm30,dword [rdx+0x1fc]{1to16},0x7b'      );
  TestCase.testcase(6371, [$62,$F1,$0D,$50,$72,$B2,$00,$02,$00,$00,$7B       ] , 'vpslld  zmm30,dword [rdx+0x200]{1to16},0x7b'      );
  TestCase.testcase(6372, [$62,$F1,$0D,$50,$72,$72,$80,$7B                   ] , 'vpslld  zmm30,dword [rdx-0x200]{1to16},0x7b'      );
  TestCase.testcase(6373, [$62,$F1,$0D,$50,$72,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vpslld  zmm30,dword [rdx-0x204]{1to16},0x7b'      );
  TestCase.testcase(6374, [$62,$91,$8D,$40,$73,$F5,$AB                       ] , 'vpsllq  zmm30,zmm29,0xab'                         );
  TestCase.testcase(6375, [$62,$91,$8D,$47,$73,$F5,$AB                       ] , 'vpsllq  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(6376, [$62,$91,$8D,$C7,$73,$F5,$AB                       ] , 'vpsllq  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(6377, [$62,$91,$8D,$40,$73,$F5,$7B                       ] , 'vpsllq  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(6378, [$62,$F1,$8D,$40,$73,$31,$7B                       ] , 'vpsllq  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(6379, [$62,$B1,$8D,$40,$73,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vpsllq  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(6380, [$62,$F1,$8D,$50,$73,$31,$7B                       ] , 'vpsllq  zmm30,qword [rcx]{1to8},0x7b'             );
  TestCase.testcase(6381, [$62,$F1,$8D,$40,$73,$72,$7F,$7B                   ] , 'vpsllq  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(6382, [$62,$F1,$8D,$40,$73,$B2,$00,$20,$00,$00,$7B       ] , 'vpsllq  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(6383, [$62,$F1,$8D,$40,$73,$72,$80,$7B                   ] , 'vpsllq  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(6384, [$62,$F1,$8D,$40,$73,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vpsllq  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(6385, [$62,$F1,$8D,$50,$73,$72,$7F,$7B                   ] , 'vpsllq  zmm30,qword [rdx+0x3f8]{1to8},0x7b'       );
  TestCase.testcase(6386, [$62,$F1,$8D,$50,$73,$B2,$00,$04,$00,$00,$7B       ] , 'vpsllq  zmm30,qword [rdx+0x400]{1to8},0x7b'       );
  TestCase.testcase(6387, [$62,$F1,$8D,$50,$73,$72,$80,$7B                   ] , 'vpsllq  zmm30,qword [rdx-0x400]{1to8},0x7b'       );
  TestCase.testcase(6388, [$62,$F1,$8D,$50,$73,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vpsllq  zmm30,qword [rdx-0x408]{1to8},0x7b'       );
  TestCase.testcase(6389, [$62,$91,$0D,$40,$72,$E5,$AB                       ] , 'vpsrad  zmm30,zmm29,0xab'                         );
  TestCase.testcase(6390, [$62,$91,$0D,$47,$72,$E5,$AB                       ] , 'vpsrad  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(6391, [$62,$91,$0D,$C7,$72,$E5,$AB                       ] , 'vpsrad  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(6392, [$62,$91,$0D,$40,$72,$E5,$7B                       ] , 'vpsrad  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(6393, [$62,$F1,$0D,$40,$72,$21,$7B                       ] , 'vpsrad  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(6394, [$62,$B1,$0D,$40,$72,$A4,$F0,$23,$01,$00,$00,$7B   ] , 'vpsrad  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(6395, [$62,$F1,$0D,$50,$72,$21,$7B                       ] , 'vpsrad  zmm30,dword [rcx]{1to16},0x7b'            );
  TestCase.testcase(6396, [$62,$F1,$0D,$40,$72,$62,$7F,$7B                   ] , 'vpsrad  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(6397, [$62,$F1,$0D,$40,$72,$A2,$00,$20,$00,$00,$7B       ] , 'vpsrad  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(6398, [$62,$F1,$0D,$40,$72,$62,$80,$7B                   ] , 'vpsrad  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(6399, [$62,$F1,$0D,$40,$72,$A2,$C0,$DF,$FF,$FF,$7B       ] , 'vpsrad  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(6400, [$62,$F1,$0D,$50,$72,$62,$7F,$7B                   ] , 'vpsrad  zmm30,dword [rdx+0x1fc]{1to16},0x7b'      );
  TestCase.testcase(6401, [$62,$F1,$0D,$50,$72,$A2,$00,$02,$00,$00,$7B       ] , 'vpsrad  zmm30,dword [rdx+0x200]{1to16},0x7b'      );
  TestCase.testcase(6402, [$62,$F1,$0D,$50,$72,$62,$80,$7B                   ] , 'vpsrad  zmm30,dword [rdx-0x200]{1to16},0x7b'      );
  TestCase.testcase(6403, [$62,$F1,$0D,$50,$72,$A2,$FC,$FD,$FF,$FF,$7B       ] , 'vpsrad  zmm30,dword [rdx-0x204]{1to16},0x7b'      );
  TestCase.testcase(6404, [$62,$91,$8D,$40,$72,$E5,$AB                       ] , 'vpsraq  zmm30,zmm29,0xab'                         );
  TestCase.testcase(6405, [$62,$91,$8D,$47,$72,$E5,$AB                       ] , 'vpsraq  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(6406, [$62,$91,$8D,$C7,$72,$E5,$AB                       ] , 'vpsraq  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(6407, [$62,$91,$8D,$40,$72,$E5,$7B                       ] , 'vpsraq  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(6408, [$62,$F1,$8D,$40,$72,$21,$7B                       ] , 'vpsraq  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(6409, [$62,$B1,$8D,$40,$72,$A4,$F0,$23,$01,$00,$00,$7B   ] , 'vpsraq  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(6410, [$62,$F1,$8D,$50,$72,$21,$7B                       ] , 'vpsraq  zmm30,qword [rcx]{1to8},0x7b'             );
  TestCase.testcase(6411, [$62,$F1,$8D,$40,$72,$62,$7F,$7B                   ] , 'vpsraq  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(6412, [$62,$F1,$8D,$40,$72,$A2,$00,$20,$00,$00,$7B       ] , 'vpsraq  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(6413, [$62,$F1,$8D,$40,$72,$62,$80,$7B                   ] , 'vpsraq  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(6414, [$62,$F1,$8D,$40,$72,$A2,$C0,$DF,$FF,$FF,$7B       ] , 'vpsraq  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(6415, [$62,$F1,$8D,$50,$72,$62,$7F,$7B                   ] , 'vpsraq  zmm30,qword [rdx+0x3f8]{1to8},0x7b'       );
  TestCase.testcase(6416, [$62,$F1,$8D,$50,$72,$A2,$00,$04,$00,$00,$7B       ] , 'vpsraq  zmm30,qword [rdx+0x400]{1to8},0x7b'       );
  TestCase.testcase(6417, [$62,$F1,$8D,$50,$72,$62,$80,$7B                   ] , 'vpsraq  zmm30,qword [rdx-0x400]{1to8},0x7b'       );
  TestCase.testcase(6418, [$62,$F1,$8D,$50,$72,$A2,$F8,$FB,$FF,$FF,$7B       ] , 'vpsraq  zmm30,qword [rdx-0x408]{1to8},0x7b'       );
  TestCase.testcase(6419, [$62,$02,$15,$40,$15,$F4                           ] , 'vprolvd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(6420, [$62,$02,$15,$47,$15,$F4                           ] , 'vprolvd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(6421, [$62,$02,$15,$C7,$15,$F4                           ] , 'vprolvd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(6422, [$62,$62,$15,$40,$15,$31                           ] , 'vprolvd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(6423, [$62,$22,$15,$40,$15,$B4,$F0,$23,$01,$00,$00       ] , 'vprolvd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(6424, [$62,$62,$15,$50,$15,$31                           ] , 'vprolvd  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(6425, [$62,$62,$15,$40,$15,$72,$7F                       ] , 'vprolvd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(6426, [$62,$62,$15,$40,$15,$B2,$00,$20,$00,$00           ] , 'vprolvd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(6427, [$62,$62,$15,$40,$15,$72,$80                       ] , 'vprolvd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(6428, [$62,$62,$15,$40,$15,$B2,$C0,$DF,$FF,$FF           ] , 'vprolvd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(6429, [$62,$62,$15,$50,$15,$72,$7F                       ] , 'vprolvd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(6430, [$62,$62,$15,$50,$15,$B2,$00,$02,$00,$00           ] , 'vprolvd  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(6431, [$62,$62,$15,$50,$15,$72,$80                       ] , 'vprolvd  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(6432, [$62,$62,$15,$50,$15,$B2,$FC,$FD,$FF,$FF           ] , 'vprolvd  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(6433, [$62,$91,$0D,$40,$72,$CD,$AB                       ] , 'vprold  zmm30,zmm29,0xab'                         );
  TestCase.testcase(6434, [$62,$91,$0D,$47,$72,$CD,$AB                       ] , 'vprold  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(6435, [$62,$91,$0D,$C7,$72,$CD,$AB                       ] , 'vprold  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(6436, [$62,$91,$0D,$40,$72,$CD,$7B                       ] , 'vprold  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(6437, [$62,$F1,$0D,$40,$72,$09,$7B                       ] , 'vprold  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(6438, [$62,$B1,$0D,$40,$72,$8C,$F0,$23,$01,$00,$00,$7B   ] , 'vprold  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(6439, [$62,$F1,$0D,$50,$72,$09,$7B                       ] , 'vprold  zmm30,dword [rcx]{1to16},0x7b'            );
  TestCase.testcase(6440, [$62,$F1,$0D,$40,$72,$4A,$7F,$7B                   ] , 'vprold  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(6441, [$62,$F1,$0D,$40,$72,$8A,$00,$20,$00,$00,$7B       ] , 'vprold  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(6442, [$62,$F1,$0D,$40,$72,$4A,$80,$7B                   ] , 'vprold  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(6443, [$62,$F1,$0D,$40,$72,$8A,$C0,$DF,$FF,$FF,$7B       ] , 'vprold  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(6444, [$62,$F1,$0D,$50,$72,$4A,$7F,$7B                   ] , 'vprold  zmm30,dword [rdx+0x1fc]{1to16},0x7b'      );
  TestCase.testcase(6445, [$62,$F1,$0D,$50,$72,$8A,$00,$02,$00,$00,$7B       ] , 'vprold  zmm30,dword [rdx+0x200]{1to16},0x7b'      );
  TestCase.testcase(6446, [$62,$F1,$0D,$50,$72,$4A,$80,$7B                   ] , 'vprold  zmm30,dword [rdx-0x200]{1to16},0x7b'      );
  TestCase.testcase(6447, [$62,$F1,$0D,$50,$72,$8A,$FC,$FD,$FF,$FF,$7B       ] , 'vprold  zmm30,dword [rdx-0x204]{1to16},0x7b'      );
  TestCase.testcase(6448, [$62,$02,$95,$40,$15,$F4                           ] , 'vprolvq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(6449, [$62,$02,$95,$47,$15,$F4                           ] , 'vprolvq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(6450, [$62,$02,$95,$C7,$15,$F4                           ] , 'vprolvq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(6451, [$62,$62,$95,$40,$15,$31                           ] , 'vprolvq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(6452, [$62,$22,$95,$40,$15,$B4,$F0,$23,$01,$00,$00       ] , 'vprolvq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(6453, [$62,$62,$95,$50,$15,$31                           ] , 'vprolvq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(6454, [$62,$62,$95,$40,$15,$72,$7F                       ] , 'vprolvq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(6455, [$62,$62,$95,$40,$15,$B2,$00,$20,$00,$00           ] , 'vprolvq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(6456, [$62,$62,$95,$40,$15,$72,$80                       ] , 'vprolvq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(6457, [$62,$62,$95,$40,$15,$B2,$C0,$DF,$FF,$FF           ] , 'vprolvq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(6458, [$62,$62,$95,$50,$15,$72,$7F                       ] , 'vprolvq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(6459, [$62,$62,$95,$50,$15,$B2,$00,$04,$00,$00           ] , 'vprolvq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(6460, [$62,$62,$95,$50,$15,$72,$80                       ] , 'vprolvq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(6461, [$62,$62,$95,$50,$15,$B2,$F8,$FB,$FF,$FF           ] , 'vprolvq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(6462, [$62,$91,$8D,$40,$72,$CD,$AB                       ] , 'vprolq  zmm30,zmm29,0xab'                         );
  TestCase.testcase(6463, [$62,$91,$8D,$47,$72,$CD,$AB                       ] , 'vprolq  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(6464, [$62,$91,$8D,$C7,$72,$CD,$AB                       ] , 'vprolq  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(6465, [$62,$91,$8D,$40,$72,$CD,$7B                       ] , 'vprolq  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(6466, [$62,$F1,$8D,$40,$72,$09,$7B                       ] , 'vprolq  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(6467, [$62,$B1,$8D,$40,$72,$8C,$F0,$23,$01,$00,$00,$7B   ] , 'vprolq  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(6468, [$62,$F1,$8D,$50,$72,$09,$7B                       ] , 'vprolq  zmm30,qword [rcx]{1to8},0x7b'             );
  TestCase.testcase(6469, [$62,$F1,$8D,$40,$72,$4A,$7F,$7B                   ] , 'vprolq  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(6470, [$62,$F1,$8D,$40,$72,$8A,$00,$20,$00,$00,$7B       ] , 'vprolq  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(6471, [$62,$F1,$8D,$40,$72,$4A,$80,$7B                   ] , 'vprolq  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(6472, [$62,$F1,$8D,$40,$72,$8A,$C0,$DF,$FF,$FF,$7B       ] , 'vprolq  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(6473, [$62,$F1,$8D,$50,$72,$4A,$7F,$7B                   ] , 'vprolq  zmm30,qword [rdx+0x3f8]{1to8},0x7b'       );
  TestCase.testcase(6474, [$62,$F1,$8D,$50,$72,$8A,$00,$04,$00,$00,$7B       ] , 'vprolq  zmm30,qword [rdx+0x400]{1to8},0x7b'       );
  TestCase.testcase(6475, [$62,$F1,$8D,$50,$72,$4A,$80,$7B                   ] , 'vprolq  zmm30,qword [rdx-0x400]{1to8},0x7b'       );
  TestCase.testcase(6476, [$62,$F1,$8D,$50,$72,$8A,$F8,$FB,$FF,$FF,$7B       ] , 'vprolq  zmm30,qword [rdx-0x408]{1to8},0x7b'       );
  TestCase.testcase(6477, [$62,$02,$15,$40,$14,$F4                           ] , 'vprorvd  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(6478, [$62,$02,$15,$47,$14,$F4                           ] , 'vprorvd  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(6479, [$62,$02,$15,$C7,$14,$F4                           ] , 'vprorvd  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(6480, [$62,$62,$15,$40,$14,$31                           ] , 'vprorvd  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(6481, [$62,$22,$15,$40,$14,$B4,$F0,$23,$01,$00,$00       ] , 'vprorvd  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(6482, [$62,$62,$15,$50,$14,$31                           ] , 'vprorvd  zmm30,zmm29,dword [rcx]{1to16}'          );
  TestCase.testcase(6483, [$62,$62,$15,$40,$14,$72,$7F                       ] , 'vprorvd  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(6484, [$62,$62,$15,$40,$14,$B2,$00,$20,$00,$00           ] , 'vprorvd  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(6485, [$62,$62,$15,$40,$14,$72,$80                       ] , 'vprorvd  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(6486, [$62,$62,$15,$40,$14,$B2,$C0,$DF,$FF,$FF           ] , 'vprorvd  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(6487, [$62,$62,$15,$50,$14,$72,$7F                       ] , 'vprorvd  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'    );
  TestCase.testcase(6488, [$62,$62,$15,$50,$14,$B2,$00,$02,$00,$00           ] , 'vprorvd  zmm30,zmm29,dword [rdx+0x200]{1to16}'    );
  TestCase.testcase(6489, [$62,$62,$15,$50,$14,$72,$80                       ] , 'vprorvd  zmm30,zmm29,dword [rdx-0x200]{1to16}'    );
  TestCase.testcase(6490, [$62,$62,$15,$50,$14,$B2,$FC,$FD,$FF,$FF           ] , 'vprorvd  zmm30,zmm29,dword [rdx-0x204]{1to16}'    );
  TestCase.testcase(6491, [$62,$91,$0D,$40,$72,$C5,$AB                       ] , 'vprord  zmm30,zmm29,0xab'                         );
  TestCase.testcase(6492, [$62,$91,$0D,$47,$72,$C5,$AB                       ] , 'vprord  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(6493, [$62,$91,$0D,$C7,$72,$C5,$AB                       ] , 'vprord  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(6494, [$62,$91,$0D,$40,$72,$C5,$7B                       ] , 'vprord  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(6495, [$62,$F1,$0D,$40,$72,$01,$7B                       ] , 'vprord  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(6496, [$62,$B1,$0D,$40,$72,$84,$F0,$23,$01,$00,$00,$7B   ] , 'vprord  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(6497, [$62,$F1,$0D,$50,$72,$01,$7B                       ] , 'vprord  zmm30,dword [rcx]{1to16},0x7b'            );
  TestCase.testcase(6498, [$62,$F1,$0D,$40,$72,$42,$7F,$7B                   ] , 'vprord  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(6499, [$62,$F1,$0D,$40,$72,$82,$00,$20,$00,$00,$7B       ] , 'vprord  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(6500, [$62,$F1,$0D,$40,$72,$42,$80,$7B                   ] , 'vprord  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(6501, [$62,$F1,$0D,$40,$72,$82,$C0,$DF,$FF,$FF,$7B       ] , 'vprord  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(6502, [$62,$F1,$0D,$50,$72,$42,$7F,$7B                   ] , 'vprord  zmm30,dword [rdx+0x1fc]{1to16},0x7b'      );
  TestCase.testcase(6503, [$62,$F1,$0D,$50,$72,$82,$00,$02,$00,$00,$7B       ] , 'vprord  zmm30,dword [rdx+0x200]{1to16},0x7b'      );
  TestCase.testcase(6504, [$62,$F1,$0D,$50,$72,$42,$80,$7B                   ] , 'vprord  zmm30,dword [rdx-0x200]{1to16},0x7b'      );
  TestCase.testcase(6505, [$62,$F1,$0D,$50,$72,$82,$FC,$FD,$FF,$FF,$7B       ] , 'vprord  zmm30,dword [rdx-0x204]{1to16},0x7b'      );
  TestCase.testcase(6506, [$62,$02,$95,$40,$14,$F4                           ] , 'vprorvq  zmm30,zmm29,zmm28'                       );
  TestCase.testcase(6507, [$62,$02,$95,$47,$14,$F4                           ] , 'vprorvq  zmm30{k7},zmm29,zmm28'                   );
  TestCase.testcase(6508, [$62,$02,$95,$C7,$14,$F4                           ] , 'vprorvq  zmm30{k7}{z},zmm29,zmm28'                );
  TestCase.testcase(6509, [$62,$62,$95,$40,$14,$31                           ] , 'vprorvq  zmm30,zmm29,zword [rcx]'                 );
  TestCase.testcase(6510, [$62,$22,$95,$40,$14,$B4,$F0,$23,$01,$00,$00       ] , 'vprorvq  zmm30,zmm29,zword [rax+r14*8+0x123]'     );
  TestCase.testcase(6511, [$62,$62,$95,$50,$14,$31                           ] , 'vprorvq  zmm30,zmm29,qword [rcx]{1to8}'           );
  TestCase.testcase(6512, [$62,$62,$95,$40,$14,$72,$7F                       ] , 'vprorvq  zmm30,zmm29,zword [rdx+0x1fc0]'          );
  TestCase.testcase(6513, [$62,$62,$95,$40,$14,$B2,$00,$20,$00,$00           ] , 'vprorvq  zmm30,zmm29,zword [rdx+0x2000]'          );
  TestCase.testcase(6514, [$62,$62,$95,$40,$14,$72,$80                       ] , 'vprorvq  zmm30,zmm29,zword [rdx-0x2000]'          );
  TestCase.testcase(6515, [$62,$62,$95,$40,$14,$B2,$C0,$DF,$FF,$FF           ] , 'vprorvq  zmm30,zmm29,zword [rdx-0x2040]'          );
  TestCase.testcase(6516, [$62,$62,$95,$50,$14,$72,$7F                       ] , 'vprorvq  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'     );
  TestCase.testcase(6517, [$62,$62,$95,$50,$14,$B2,$00,$04,$00,$00           ] , 'vprorvq  zmm30,zmm29,qword [rdx+0x400]{1to8}'     );
  TestCase.testcase(6518, [$62,$62,$95,$50,$14,$72,$80                       ] , 'vprorvq  zmm30,zmm29,qword [rdx-0x400]{1to8}'     );
  TestCase.testcase(6519, [$62,$62,$95,$50,$14,$B2,$F8,$FB,$FF,$FF           ] , 'vprorvq  zmm30,zmm29,qword [rdx-0x408]{1to8}'     );
  TestCase.testcase(6520, [$62,$91,$8D,$40,$72,$C5,$AB                       ] , 'vprorq  zmm30,zmm29,0xab'                         );
  TestCase.testcase(6521, [$62,$91,$8D,$47,$72,$C5,$AB                       ] , 'vprorq  zmm30{k7},zmm29,0xab'                     );
  TestCase.testcase(6522, [$62,$91,$8D,$C7,$72,$C5,$AB                       ] , 'vprorq  zmm30{k7}{z},zmm29,0xab'                  );
  TestCase.testcase(6523, [$62,$91,$8D,$40,$72,$C5,$7B                       ] , 'vprorq  zmm30,zmm29,0x7b'                         );
  TestCase.testcase(6524, [$62,$F1,$8D,$40,$72,$01,$7B                       ] , 'vprorq  zmm30,zword [rcx],0x7b'                   );
  TestCase.testcase(6525, [$62,$B1,$8D,$40,$72,$84,$F0,$23,$01,$00,$00,$7B   ] , 'vprorq  zmm30,zword [rax+r14*8+0x123],0x7b'       );
  TestCase.testcase(6526, [$62,$F1,$8D,$50,$72,$01,$7B                       ] , 'vprorq  zmm30,qword [rcx]{1to8},0x7b'             );
  TestCase.testcase(6527, [$62,$F1,$8D,$40,$72,$42,$7F,$7B                   ] , 'vprorq  zmm30,zword [rdx+0x1fc0],0x7b'            );
  TestCase.testcase(6528, [$62,$F1,$8D,$40,$72,$82,$00,$20,$00,$00,$7B       ] , 'vprorq  zmm30,zword [rdx+0x2000],0x7b'            );
  TestCase.testcase(6529, [$62,$F1,$8D,$40,$72,$42,$80,$7B                   ] , 'vprorq  zmm30,zword [rdx-0x2000],0x7b'            );
  TestCase.testcase(6530, [$62,$F1,$8D,$40,$72,$82,$C0,$DF,$FF,$FF,$7B       ] , 'vprorq  zmm30,zword [rdx-0x2040],0x7b'            );
  TestCase.testcase(6531, [$62,$F1,$8D,$50,$72,$42,$7F,$7B                   ] , 'vprorq  zmm30,qword [rdx+0x3f8]{1to8},0x7b'       );
  TestCase.testcase(6532, [$62,$F1,$8D,$50,$72,$82,$00,$04,$00,$00,$7B       ] , 'vprorq  zmm30,qword [rdx+0x400]{1to8},0x7b'       );
  TestCase.testcase(6533, [$62,$F1,$8D,$50,$72,$42,$80,$7B                   ] , 'vprorq  zmm30,qword [rdx-0x400]{1to8},0x7b'       );
  TestCase.testcase(6534, [$62,$F1,$8D,$50,$72,$82,$F8,$FB,$FF,$FF,$7B       ] , 'vprorq  zmm30,qword [rdx-0x408]{1to8},0x7b'       );
  TestCase.testcase(6535, [$62,$03,$FD,$48,$09,$F5,$AB                       ] , 'vrndscalepd  zmm30,zmm29,0xab'                    );
  TestCase.testcase(6536, [$62,$03,$FD,$4F,$09,$F5,$AB                       ] , 'vrndscalepd  zmm30{k7},zmm29,0xab'                );
  TestCase.testcase(6537, [$62,$03,$FD,$CF,$09,$F5,$AB                       ] , 'vrndscalepd  zmm30{k7}{z},zmm29,0xab'             );
  TestCase.testcase(6538, [$62,$03,$FD,$18,$09,$F5,$AB                       ] , 'vrndscalepd  zmm30,zmm29,{sae},0xab'              );
  TestCase.testcase(6539, [$62,$03,$FD,$48,$09,$F5,$7B                       ] , 'vrndscalepd  zmm30,zmm29,0x7b'                    );
  TestCase.testcase(6540, [$62,$03,$FD,$18,$09,$F5,$7B                       ] , 'vrndscalepd  zmm30,zmm29,{sae},0x7b'              );
  TestCase.testcase(6541, [$62,$63,$FD,$48,$09,$31,$7B                       ] , 'vrndscalepd  zmm30,zword [rcx],0x7b'              );
  TestCase.testcase(6542, [$62,$23,$FD,$48,$09,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vrndscalepd  zmm30,zword [rax+r14*8+0x123],0x7b'  );
  TestCase.testcase(6543, [$62,$63,$FD,$58,$09,$31,$7B                       ] , 'vrndscalepd  zmm30,qword [rcx]{1to8},0x7b'        );
  TestCase.testcase(6544, [$62,$63,$FD,$48,$09,$72,$7F,$7B                   ] , 'vrndscalepd  zmm30,zword [rdx+0x1fc0],0x7b'       );
  TestCase.testcase(6545, [$62,$63,$FD,$48,$09,$B2,$00,$20,$00,$00,$7B       ] , 'vrndscalepd  zmm30,zword [rdx+0x2000],0x7b'       );
  TestCase.testcase(6546, [$62,$63,$FD,$48,$09,$72,$80,$7B                   ] , 'vrndscalepd  zmm30,zword [rdx-0x2000],0x7b'       );
  TestCase.testcase(6547, [$62,$63,$FD,$48,$09,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vrndscalepd  zmm30,zword [rdx-0x2040],0x7b'       );
  TestCase.testcase(6548, [$62,$63,$FD,$58,$09,$72,$7F,$7B                   ] , 'vrndscalepd  zmm30,qword [rdx+0x3f8]{1to8},0x7b'  );
  TestCase.testcase(6549, [$62,$63,$FD,$58,$09,$B2,$00,$04,$00,$00,$7B       ] , 'vrndscalepd  zmm30,qword [rdx+0x400]{1to8},0x7b'  );
  TestCase.testcase(6550, [$62,$63,$FD,$58,$09,$72,$80,$7B                   ] , 'vrndscalepd  zmm30,qword [rdx-0x400]{1to8},0x7b'  );
  TestCase.testcase(6551, [$62,$63,$FD,$58,$09,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vrndscalepd  zmm30,qword [rdx-0x408]{1to8},0x7b'  );
  TestCase.testcase(6552, [$62,$03,$7D,$48,$08,$F5,$AB                       ] , 'vrndscaleps  zmm30,zmm29,0xab'                    );
  TestCase.testcase(6553, [$62,$03,$7D,$4F,$08,$F5,$AB                       ] , 'vrndscaleps  zmm30{k7},zmm29,0xab'                );
  TestCase.testcase(6554, [$62,$03,$7D,$CF,$08,$F5,$AB                       ] , 'vrndscaleps  zmm30{k7}{z},zmm29,0xab'             );
  TestCase.testcase(6555, [$62,$03,$7D,$18,$08,$F5,$AB                       ] , 'vrndscaleps  zmm30,zmm29,{sae},0xab'              );
  TestCase.testcase(6556, [$62,$03,$7D,$48,$08,$F5,$7B                       ] , 'vrndscaleps  zmm30,zmm29,0x7b'                    );
  TestCase.testcase(6557, [$62,$03,$7D,$18,$08,$F5,$7B                       ] , 'vrndscaleps  zmm30,zmm29,{sae},0x7b'              );
  TestCase.testcase(6558, [$62,$63,$7D,$48,$08,$31,$7B                       ] , 'vrndscaleps  zmm30,zword [rcx],0x7b'              );
  TestCase.testcase(6559, [$62,$23,$7D,$48,$08,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vrndscaleps  zmm30,zword [rax+r14*8+0x123],0x7b'  );
  TestCase.testcase(6560, [$62,$63,$7D,$58,$08,$31,$7B                       ] , 'vrndscaleps  zmm30,dword [rcx]{1to16},0x7b'       );
  TestCase.testcase(6561, [$62,$63,$7D,$48,$08,$72,$7F,$7B                   ] , 'vrndscaleps  zmm30,zword [rdx+0x1fc0],0x7b'       );
  TestCase.testcase(6562, [$62,$63,$7D,$48,$08,$B2,$00,$20,$00,$00,$7B       ] , 'vrndscaleps  zmm30,zword [rdx+0x2000],0x7b'       );
  TestCase.testcase(6563, [$62,$63,$7D,$48,$08,$72,$80,$7B                   ] , 'vrndscaleps  zmm30,zword [rdx-0x2000],0x7b'       );
  TestCase.testcase(6564, [$62,$63,$7D,$48,$08,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'vrndscaleps  zmm30,zword [rdx-0x2040],0x7b'       );
  TestCase.testcase(6565, [$62,$63,$7D,$58,$08,$72,$7F,$7B                   ] , 'vrndscaleps  zmm30,dword [rdx+0x1fc]{1to16},0x7b' );
  TestCase.testcase(6566, [$62,$63,$7D,$58,$08,$B2,$00,$02,$00,$00,$7B       ] , 'vrndscaleps  zmm30,dword [rdx+0x200]{1to16},0x7b' );
  TestCase.testcase(6567, [$62,$63,$7D,$58,$08,$72,$80,$7B                   ] , 'vrndscaleps  zmm30,dword [rdx-0x200]{1to16},0x7b' );
  TestCase.testcase(6568, [$62,$63,$7D,$58,$08,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vrndscaleps  zmm30,dword [rdx-0x204]{1to16},0x7b' );
  TestCase.testcase(6569, [$62,$03,$95,$07,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(6570, [$62,$03,$95,$87,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(6571, [$62,$03,$95,$17,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(6572, [$62,$03,$95,$07,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(6573, [$62,$03,$95,$17,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(6574, [$62,$63,$95,$07,$0B,$31,$7B                       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rcx],0x7b'    );
  TestCase.testcase(6575, [$62,$23,$95,$07,$0B,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(6576, [$62,$63,$95,$07,$0B,$72,$7F,$7B                   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx+0x3f8],0x7b' );
  TestCase.testcase(6577, [$62,$63,$95,$07,$0B,$B2,$00,$04,$00,$00,$7B       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx+0x400],0x7b' );
  TestCase.testcase(6578, [$62,$63,$95,$07,$0B,$72,$80,$7B                   ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx-0x400],0x7b' );
  TestCase.testcase(6579, [$62,$63,$95,$07,$0B,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vrndscalesd  xmm30{k7},xmm29,qword [rdx-0x408],0x7b' );
  TestCase.testcase(6580, [$62,$03,$15,$07,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,0xab'          );
  TestCase.testcase(6581, [$62,$03,$15,$87,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7}{z},xmm29,xmm28,0xab'       );
  TestCase.testcase(6582, [$62,$03,$15,$17,$0A,$F4,$AB                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,{sae},0xab'    );
  TestCase.testcase(6583, [$62,$03,$15,$07,$0A,$F4,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,0x7b'          );
  TestCase.testcase(6584, [$62,$03,$15,$17,$0A,$F4,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,xmm28,{sae},0x7b'    );
  TestCase.testcase(6585, [$62,$63,$15,$07,$0A,$31,$7B                       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rcx],0x7b'    );
  TestCase.testcase(6586, [$62,$23,$15,$07,$0A,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rax+r14*8+0x123],0x7b' );
  TestCase.testcase(6587, [$62,$63,$15,$07,$0A,$72,$7F,$7B                   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx+0x1fc],0x7b' );
  TestCase.testcase(6588, [$62,$63,$15,$07,$0A,$B2,$00,$02,$00,$00,$7B       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx+0x200],0x7b' );
  TestCase.testcase(6589, [$62,$63,$15,$07,$0A,$72,$80,$7B                   ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx-0x200],0x7b' );
  TestCase.testcase(6590, [$62,$63,$15,$07,$0A,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vrndscaless  xmm30{k7},xmm29,dword [rdx-0x204],0x7b' );
  TestCase.testcase(6591, [$62,$62,$FD,$48,$8B,$31                           ] , 'vpcompressq  zword [rcx],zmm30'                   );
  TestCase.testcase(6592, [$62,$62,$FD,$4F,$8B,$31                           ] , 'vpcompressq  zword [rcx]{k7},zmm30'               );
  TestCase.testcase(6593, [$62,$22,$FD,$48,$8B,$B4,$F0,$23,$01,$00,$00       ] , 'vpcompressq  zword [rax+r14*8+0x123],zmm30'       );
  TestCase.testcase(6594, [$62,$62,$FD,$48,$8B,$72,$7F                       ] , 'vpcompressq  zword [rdx+0x3f8],zmm30'             );
  TestCase.testcase(6595, [$62,$62,$FD,$48,$8B,$B2,$00,$04,$00,$00           ] , 'vpcompressq  zword [rdx+0x400],zmm30'             );
  TestCase.testcase(6596, [$62,$62,$FD,$48,$8B,$72,$80                       ] , 'vpcompressq  zword [rdx-0x400],zmm30'             );
  TestCase.testcase(6597, [$62,$62,$FD,$48,$8B,$B2,$F8,$FB,$FF,$FF           ] , 'vpcompressq  zword [rdx-0x408],zmm30'             );
  TestCase.testcase(6598, [$62,$02,$FD,$48,$8B,$EE                           ] , 'vpcompressq  zmm30,zmm29'                         );
  TestCase.testcase(6599, [$62,$02,$FD,$4F,$8B,$EE                           ] , 'vpcompressq  zmm30{k7},zmm29'                     );
  TestCase.testcase(6600, [$62,$02,$FD,$CF,$8B,$EE                           ] , 'vpcompressq  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(6601, [$C5,$CC,$41,$EF                                   ] , 'kandw  k5,k6,k7'                                  );
  TestCase.testcase(6602, [$C5,$CC,$42,$EF                                   ] , 'kandnw  k5,k6,k7'                                 );
  TestCase.testcase(6603, [$C5,$CC,$45,$EF                                   ] , 'korw  k5,k6,k7'                                   );
  TestCase.testcase(6604, [$C5,$CC,$46,$EF                                   ] , 'kxnorw  k5,k6,k7'                                 );
  TestCase.testcase(6605, [$C5,$CC,$47,$EF                                   ] , 'kxorw  k5,k6,k7'                                  );
  TestCase.testcase(6606, [$C5,$F8,$44,$EE                                   ] , 'knotw  k5,k6'                                     );
  TestCase.testcase(6607, [$C5,$F8,$98,$EE                                   ] , 'kortestw  k5,k6'                                  );
  TestCase.testcase(6608, [$C4,$E3,$F9,$30,$EE,$AB                           ] , 'kshiftrw  k5,k6,0xab'                             );
  TestCase.testcase(6609, [$C4,$E3,$F9,$30,$EE,$7B                           ] , 'kshiftrw  k5,k6,0x7b'                             );
  TestCase.testcase(6610, [$C4,$E3,$F9,$32,$EE,$AB                           ] , 'kshiftlw  k5,k6,0xab'                             );
  TestCase.testcase(6611, [$C4,$E3,$F9,$32,$EE,$7B                           ] , 'kshiftlw  k5,k6,0x7b'                             );
  TestCase.testcase(6612, [$C5,$F8,$90,$EE                                   ] , 'kmovw  k5,k6'                                     );
  TestCase.testcase(6613, [$C5,$F8,$90,$29                                   ] , 'kmovw  k5,word [rcx]'                             );
  TestCase.testcase(6614, [$C4,$A1,$78,$90,$AC,$F0,$23,$01,$00,$00           ] , 'kmovw  k5,word [rax+r14*8+0x123]'                 );
  TestCase.testcase(6615, [$C5,$F8,$91,$29                                   ] , 'kmovw  word [rcx],k5'                             );
  TestCase.testcase(6616, [$C4,$A1,$78,$91,$AC,$F0,$23,$01,$00,$00           ] , 'kmovw  word [rax+r14*8+0x123],k5'                 );
  TestCase.testcase(6617, [$C5,$F8,$92,$E8                                   ] , 'kmovw  k5,eax'                                    );
  TestCase.testcase(6618, [$C5,$F8,$92,$ED                                   ] , 'kmovw  k5,ebp'                                    );
  TestCase.testcase(6619, [$C4,$C1,$78,$92,$ED                               ] , 'kmovw  k5,r13d'                                   );
  TestCase.testcase(6620, [$C5,$F8,$93,$C5                                   ] , 'kmovw  eax,k5'                                    );
  TestCase.testcase(6621, [$C5,$F8,$93,$ED                                   ] , 'kmovw  ebp,k5'                                    );
  TestCase.testcase(6622, [$C5,$78,$93,$ED                                   ] , 'kmovw  r13d,k5'                                   );
  TestCase.testcase(6623, [$C5,$CD,$4B,$EF                                   ] , 'kunpckbw  k5,k6,k7'                               );
  TestCase.testcase(6624, [$62,$63,$7D,$48,$1D,$31,$AB                       ] , 'vcvtps2ph  yword [rcx],zmm30,0xab'                );
  TestCase.testcase(6625, [$62,$63,$7D,$4F,$1D,$31,$AB                       ] , 'vcvtps2ph  yword [rcx]{k7},zmm30,0xab'            );
  TestCase.testcase(6626, [$62,$63,$7D,$48,$1D,$31,$7B                       ] , 'vcvtps2ph  yword [rcx],zmm30,0x7b'                );
  TestCase.testcase(6627, [$62,$23,$7D,$48,$1D,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vcvtps2ph  yword [rax+r14*8+0x123],zmm30,0x7b'    );
  TestCase.testcase(6628, [$62,$63,$7D,$48,$1D,$72,$7F,$7B                   ] , 'vcvtps2ph  yword [rdx+0xfe0],zmm30,0x7b'          );
  TestCase.testcase(6629, [$62,$63,$7D,$48,$1D,$B2,$00,$10,$00,$00,$7B       ] , 'vcvtps2ph  yword [rdx+0x1000],zmm30,0x7b'         );
  TestCase.testcase(6630, [$62,$63,$7D,$48,$1D,$72,$80,$7B                   ] , 'vcvtps2ph  yword [rdx-0x1000],zmm30,0x7b'         );
  TestCase.testcase(6631, [$62,$63,$7D,$48,$1D,$B2,$E0,$EF,$FF,$FF,$7B       ] , 'vcvtps2ph  yword [rdx-0x1020],zmm30,0x7b'         );
  TestCase.testcase(6632, [$62,$63,$7D,$48,$19,$31,$AB                       ] , 'vextractf32x4  oword [rcx],zmm30,0xab'            );
  TestCase.testcase(6633, [$62,$63,$7D,$4F,$19,$31,$AB                       ] , 'vextractf32x4  oword [rcx]{k7},zmm30,0xab'        );
  TestCase.testcase(6634, [$62,$63,$7D,$48,$19,$31,$7B                       ] , 'vextractf32x4  oword [rcx],zmm30,0x7b'            );
  TestCase.testcase(6635, [$62,$23,$7D,$48,$19,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vextractf32x4  oword [rax+r14*8+0x123],zmm30,0x7b' );
  TestCase.testcase(6636, [$62,$63,$7D,$48,$19,$72,$7F,$7B                   ] , 'vextractf32x4  oword [rdx+0x7f0],zmm30,0x7b'      );
  TestCase.testcase(6637, [$62,$63,$7D,$48,$19,$B2,$00,$08,$00,$00,$7B       ] , 'vextractf32x4  oword [rdx+0x800],zmm30,0x7b'      );
  TestCase.testcase(6638, [$62,$63,$7D,$48,$19,$72,$80,$7B                   ] , 'vextractf32x4  oword [rdx-0x800],zmm30,0x7b'      );
  TestCase.testcase(6639, [$62,$63,$7D,$48,$19,$B2,$F0,$F7,$FF,$FF,$7B       ] , 'vextractf32x4  oword [rdx-0x810],zmm30,0x7b'      );
  TestCase.testcase(6640, [$62,$63,$FD,$48,$1B,$31,$AB                       ] , 'vextractf64x4  yword [rcx],zmm30,0xab'            );
  TestCase.testcase(6641, [$62,$63,$FD,$4F,$1B,$31,$AB                       ] , 'vextractf64x4  yword [rcx]{k7},zmm30,0xab'        );
  TestCase.testcase(6642, [$62,$63,$FD,$48,$1B,$31,$7B                       ] , 'vextractf64x4  yword [rcx],zmm30,0x7b'            );
  TestCase.testcase(6643, [$62,$23,$FD,$48,$1B,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vextractf64x4  yword [rax+r14*8+0x123],zmm30,0x7b' );
  TestCase.testcase(6644, [$62,$63,$FD,$48,$1B,$72,$7F,$7B                   ] , 'vextractf64x4  yword [rdx+0xfe0],zmm30,0x7b'      );
  TestCase.testcase(6645, [$62,$63,$FD,$48,$1B,$B2,$00,$10,$00,$00,$7B       ] , 'vextractf64x4  yword [rdx+0x1000],zmm30,0x7b'     );
  TestCase.testcase(6646, [$62,$63,$FD,$48,$1B,$72,$80,$7B                   ] , 'vextractf64x4  yword [rdx-0x1000],zmm30,0x7b'     );
  TestCase.testcase(6647, [$62,$63,$FD,$48,$1B,$B2,$E0,$EF,$FF,$FF,$7B       ] , 'vextractf64x4  yword [rdx-0x1020],zmm30,0x7b'     );
  TestCase.testcase(6648, [$62,$63,$7D,$48,$39,$31,$AB                       ] , 'vextracti32x4  oword [rcx],zmm30,0xab'            );
  TestCase.testcase(6649, [$62,$63,$7D,$4F,$39,$31,$AB                       ] , 'vextracti32x4  oword [rcx]{k7},zmm30,0xab'        );
  TestCase.testcase(6650, [$62,$63,$7D,$48,$39,$31,$7B                       ] , 'vextracti32x4  oword [rcx],zmm30,0x7b'            );
  TestCase.testcase(6651, [$62,$23,$7D,$48,$39,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vextracti32x4  oword [rax+r14*8+0x123],zmm30,0x7b' );
  TestCase.testcase(6652, [$62,$63,$7D,$48,$39,$72,$7F,$7B                   ] , 'vextracti32x4  oword [rdx+0x7f0],zmm30,0x7b'      );
  TestCase.testcase(6653, [$62,$63,$7D,$48,$39,$B2,$00,$08,$00,$00,$7B       ] , 'vextracti32x4  oword [rdx+0x800],zmm30,0x7b'      );
  TestCase.testcase(6654, [$62,$63,$7D,$48,$39,$72,$80,$7B                   ] , 'vextracti32x4  oword [rdx-0x800],zmm30,0x7b'      );
  TestCase.testcase(6655, [$62,$63,$7D,$48,$39,$B2,$F0,$F7,$FF,$FF,$7B       ] , 'vextracti32x4  oword [rdx-0x810],zmm30,0x7b'      );
  TestCase.testcase(6656, [$62,$63,$FD,$48,$3B,$31,$AB                       ] , 'vextracti64x4  yword [rcx],zmm30,0xab'            );
  TestCase.testcase(6657, [$62,$63,$FD,$4F,$3B,$31,$AB                       ] , 'vextracti64x4  yword [rcx]{k7},zmm30,0xab'        );
  TestCase.testcase(6658, [$62,$63,$FD,$48,$3B,$31,$7B                       ] , 'vextracti64x4  yword [rcx],zmm30,0x7b'            );
  TestCase.testcase(6659, [$62,$23,$FD,$48,$3B,$B4,$F0,$23,$01,$00,$00,$7B   ] , 'vextracti64x4  yword [rax+r14*8+0x123],zmm30,0x7b' );
  TestCase.testcase(6660, [$62,$63,$FD,$48,$3B,$72,$7F,$7B                   ] , 'vextracti64x4  yword [rdx+0xfe0],zmm30,0x7b'      );
  TestCase.testcase(6661, [$62,$63,$FD,$48,$3B,$B2,$00,$10,$00,$00,$7B       ] , 'vextracti64x4  yword [rdx+0x1000],zmm30,0x7b'     );
  TestCase.testcase(6662, [$62,$63,$FD,$48,$3B,$72,$80,$7B                   ] , 'vextracti64x4  yword [rdx-0x1000],zmm30,0x7b'     );
  TestCase.testcase(6663, [$62,$63,$FD,$48,$3B,$B2,$E0,$EF,$FF,$FF,$7B       ] , 'vextracti64x4  yword [rdx-0x1020],zmm30,0x7b'     );
  TestCase.testcase(6664, [$62,$61,$FD,$48,$29,$31                           ] , 'vmovapd  zword [rcx],zmm30'                       );
  TestCase.testcase(6665, [$62,$61,$FD,$4F,$29,$31                           ] , 'vmovapd  zword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6666, [$62,$21,$FD,$48,$29,$B4,$F0,$23,$01,$00,$00       ] , 'vmovapd  zword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6667, [$62,$61,$FD,$48,$29,$72,$7F                       ] , 'vmovapd  zword [rdx+0x1fc0],zmm30'                );
  TestCase.testcase(6668, [$62,$61,$FD,$48,$29,$B2,$00,$20,$00,$00           ] , 'vmovapd  zword [rdx+0x2000],zmm30'                );
  TestCase.testcase(6669, [$62,$61,$FD,$48,$29,$72,$80                       ] , 'vmovapd  zword [rdx-0x2000],zmm30'                );
  TestCase.testcase(6670, [$62,$61,$FD,$48,$29,$B2,$C0,$DF,$FF,$FF           ] , 'vmovapd  zword [rdx-0x2040],zmm30'                );
  TestCase.testcase(6671, [$62,$61,$7C,$48,$29,$31                           ] , 'vmovaps  zword [rcx],zmm30'                       );
  TestCase.testcase(6672, [$62,$61,$7C,$4F,$29,$31                           ] , 'vmovaps  zword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6673, [$62,$21,$7C,$48,$29,$B4,$F0,$23,$01,$00,$00       ] , 'vmovaps  zword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6674, [$62,$61,$7C,$48,$29,$72,$7F                       ] , 'vmovaps  zword [rdx+0x1fc0],zmm30'                );
  TestCase.testcase(6675, [$62,$61,$7C,$48,$29,$B2,$00,$20,$00,$00           ] , 'vmovaps  zword [rdx+0x2000],zmm30'                );
  TestCase.testcase(6676, [$62,$61,$7C,$48,$29,$72,$80                       ] , 'vmovaps  zword [rdx-0x2000],zmm30'                );
  TestCase.testcase(6677, [$62,$61,$7C,$48,$29,$B2,$C0,$DF,$FF,$FF           ] , 'vmovaps  zword [rdx-0x2040],zmm30'                );
  TestCase.testcase(6678, [$62,$61,$7D,$48,$7F,$31                           ] , 'vmovdqa32  zword [rcx],zmm30'                     );
  TestCase.testcase(6679, [$62,$61,$7D,$4F,$7F,$31                           ] , 'vmovdqa32  zword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6680, [$62,$21,$7D,$48,$7F,$B4,$F0,$23,$01,$00,$00       ] , 'vmovdqa32  zword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6681, [$62,$61,$7D,$48,$7F,$72,$7F                       ] , 'vmovdqa32  zword [rdx+0x1fc0],zmm30'              );
  TestCase.testcase(6682, [$62,$61,$7D,$48,$7F,$B2,$00,$20,$00,$00           ] , 'vmovdqa32  zword [rdx+0x2000],zmm30'              );
  TestCase.testcase(6683, [$62,$61,$7D,$48,$7F,$72,$80                       ] , 'vmovdqa32  zword [rdx-0x2000],zmm30'              );
  TestCase.testcase(6684, [$62,$61,$7D,$48,$7F,$B2,$C0,$DF,$FF,$FF           ] , 'vmovdqa32  zword [rdx-0x2040],zmm30'              );
  TestCase.testcase(6685, [$62,$61,$FD,$48,$7F,$31                           ] , 'vmovdqa64  zword [rcx],zmm30'                     );
  TestCase.testcase(6686, [$62,$61,$FD,$4F,$7F,$31                           ] , 'vmovdqa64  zword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6687, [$62,$21,$FD,$48,$7F,$B4,$F0,$23,$01,$00,$00       ] , 'vmovdqa64  zword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6688, [$62,$61,$FD,$48,$7F,$72,$7F                       ] , 'vmovdqa64  zword [rdx+0x1fc0],zmm30'              );
  TestCase.testcase(6689, [$62,$61,$FD,$48,$7F,$B2,$00,$20,$00,$00           ] , 'vmovdqa64  zword [rdx+0x2000],zmm30'              );
  TestCase.testcase(6690, [$62,$61,$FD,$48,$7F,$72,$80                       ] , 'vmovdqa64  zword [rdx-0x2000],zmm30'              );
  TestCase.testcase(6691, [$62,$61,$FD,$48,$7F,$B2,$C0,$DF,$FF,$FF           ] , 'vmovdqa64  zword [rdx-0x2040],zmm30'              );
  TestCase.testcase(6692, [$62,$61,$7E,$48,$7F,$31                           ] , 'vmovdqu32  zword [rcx],zmm30'                     );
  TestCase.testcase(6693, [$62,$61,$7E,$4F,$7F,$31                           ] , 'vmovdqu32  zword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6694, [$62,$21,$7E,$48,$7F,$B4,$F0,$23,$01,$00,$00       ] , 'vmovdqu32  zword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6695, [$62,$61,$7E,$48,$7F,$72,$7F                       ] , 'vmovdqu32  zword [rdx+0x1fc0],zmm30'              );
  TestCase.testcase(6696, [$62,$61,$7E,$48,$7F,$B2,$00,$20,$00,$00           ] , 'vmovdqu32  zword [rdx+0x2000],zmm30'              );
  TestCase.testcase(6697, [$62,$61,$7E,$48,$7F,$72,$80                       ] , 'vmovdqu32  zword [rdx-0x2000],zmm30'              );
  TestCase.testcase(6698, [$62,$61,$7E,$48,$7F,$B2,$C0,$DF,$FF,$FF           ] , 'vmovdqu32  zword [rdx-0x2040],zmm30'              );
  TestCase.testcase(6699, [$62,$61,$FE,$48,$7F,$31                           ] , 'vmovdqu64  zword [rcx],zmm30'                     );
  TestCase.testcase(6700, [$62,$61,$FE,$4F,$7F,$31                           ] , 'vmovdqu64  zword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6701, [$62,$21,$FE,$48,$7F,$B4,$F0,$23,$01,$00,$00       ] , 'vmovdqu64  zword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6702, [$62,$61,$FE,$48,$7F,$72,$7F                       ] , 'vmovdqu64  zword [rdx+0x1fc0],zmm30'              );
  TestCase.testcase(6703, [$62,$61,$FE,$48,$7F,$B2,$00,$20,$00,$00           ] , 'vmovdqu64  zword [rdx+0x2000],zmm30'              );
  TestCase.testcase(6704, [$62,$61,$FE,$48,$7F,$72,$80                       ] , 'vmovdqu64  zword [rdx-0x2000],zmm30'              );
  TestCase.testcase(6705, [$62,$61,$FE,$48,$7F,$B2,$C0,$DF,$FF,$FF           ] , 'vmovdqu64  zword [rdx-0x2040],zmm30'              );
  TestCase.testcase(6706, [$62,$61,$FD,$48,$11,$31                           ] , 'vmovupd  zword [rcx],zmm30'                       );
  TestCase.testcase(6707, [$62,$61,$FD,$4F,$11,$31                           ] , 'vmovupd  zword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6708, [$62,$21,$FD,$48,$11,$B4,$F0,$23,$01,$00,$00       ] , 'vmovupd  zword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6709, [$62,$61,$FD,$48,$11,$72,$7F                       ] , 'vmovupd  zword [rdx+0x1fc0],zmm30'                );
  TestCase.testcase(6710, [$62,$61,$FD,$48,$11,$B2,$00,$20,$00,$00           ] , 'vmovupd  zword [rdx+0x2000],zmm30'                );
  TestCase.testcase(6711, [$62,$61,$FD,$48,$11,$72,$80                       ] , 'vmovupd  zword [rdx-0x2000],zmm30'                );
  TestCase.testcase(6712, [$62,$61,$FD,$48,$11,$B2,$C0,$DF,$FF,$FF           ] , 'vmovupd  zword [rdx-0x2040],zmm30'                );
  TestCase.testcase(6713, [$62,$61,$7C,$48,$11,$31                           ] , 'vmovups  zword [rcx],zmm30'                       );
  TestCase.testcase(6714, [$62,$61,$7C,$4F,$11,$31                           ] , 'vmovups  zword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6715, [$62,$21,$7C,$48,$11,$B4,$F0,$23,$01,$00,$00       ] , 'vmovups  zword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6716, [$62,$61,$7C,$48,$11,$72,$7F                       ] , 'vmovups  zword [rdx+0x1fc0],zmm30'                );
  TestCase.testcase(6717, [$62,$61,$7C,$48,$11,$B2,$00,$20,$00,$00           ] , 'vmovups  zword [rdx+0x2000],zmm30'                );
  TestCase.testcase(6718, [$62,$61,$7C,$48,$11,$72,$80                       ] , 'vmovups  zword [rdx-0x2000],zmm30'                );
  TestCase.testcase(6719, [$62,$61,$7C,$48,$11,$B2,$C0,$DF,$FF,$FF           ] , 'vmovups  zword [rdx-0x2040],zmm30'                );
  TestCase.testcase(6720, [$62,$62,$7E,$48,$32,$31                           ] , 'vpmovqb  qword [rcx],zmm30'                       );
  TestCase.testcase(6721, [$62,$62,$7E,$4F,$32,$31                           ] , 'vpmovqb  qword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6722, [$62,$22,$7E,$48,$32,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovqb  qword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6723, [$62,$62,$7E,$48,$32,$72,$7F                       ] , 'vpmovqb  qword [rdx+0x3f8],zmm30'                 );
  TestCase.testcase(6724, [$62,$62,$7E,$48,$32,$B2,$00,$04,$00,$00           ] , 'vpmovqb  qword [rdx+0x400],zmm30'                 );
  TestCase.testcase(6725, [$62,$62,$7E,$48,$32,$72,$80                       ] , 'vpmovqb  qword [rdx-0x400],zmm30'                 );
  TestCase.testcase(6726, [$62,$62,$7E,$48,$32,$B2,$F8,$FB,$FF,$FF           ] , 'vpmovqb  qword [rdx-0x408],zmm30'                 );
  TestCase.testcase(6727, [$62,$62,$7E,$48,$22,$31                           ] , 'vpmovsqb  qword [rcx],zmm30'                      );
  TestCase.testcase(6728, [$62,$62,$7E,$4F,$22,$31                           ] , 'vpmovsqb  qword [rcx]{k7},zmm30'                  );
  TestCase.testcase(6729, [$62,$22,$7E,$48,$22,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsqb  qword [rax+r14*8+0x123],zmm30'          );
  TestCase.testcase(6730, [$62,$62,$7E,$48,$22,$72,$7F                       ] , 'vpmovsqb  qword [rdx+0x3f8],zmm30'                );
  TestCase.testcase(6731, [$62,$62,$7E,$48,$22,$B2,$00,$04,$00,$00           ] , 'vpmovsqb  qword [rdx+0x400],zmm30'                );
  TestCase.testcase(6732, [$62,$62,$7E,$48,$22,$72,$80                       ] , 'vpmovsqb  qword [rdx-0x400],zmm30'                );
  TestCase.testcase(6733, [$62,$62,$7E,$48,$22,$B2,$F8,$FB,$FF,$FF           ] , 'vpmovsqb  qword [rdx-0x408],zmm30'                );
  TestCase.testcase(6734, [$62,$62,$7E,$48,$12,$31                           ] , 'vpmovusqb  qword [rcx],zmm30'                     );
  TestCase.testcase(6735, [$62,$62,$7E,$4F,$12,$31                           ] , 'vpmovusqb  qword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6736, [$62,$22,$7E,$48,$12,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovusqb  qword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6737, [$62,$62,$7E,$48,$12,$72,$7F                       ] , 'vpmovusqb  qword [rdx+0x3f8],zmm30'               );
  TestCase.testcase(6738, [$62,$62,$7E,$48,$12,$B2,$00,$04,$00,$00           ] , 'vpmovusqb  qword [rdx+0x400],zmm30'               );
  TestCase.testcase(6739, [$62,$62,$7E,$48,$12,$72,$80                       ] , 'vpmovusqb  qword [rdx-0x400],zmm30'               );
  TestCase.testcase(6740, [$62,$62,$7E,$48,$12,$B2,$F8,$FB,$FF,$FF           ] , 'vpmovusqb  qword [rdx-0x408],zmm30'               );
  TestCase.testcase(6741, [$62,$62,$7E,$48,$34,$31                           ] , 'vpmovqw  oword [rcx],zmm30'                       );
  TestCase.testcase(6742, [$62,$62,$7E,$4F,$34,$31                           ] , 'vpmovqw  oword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6743, [$62,$22,$7E,$48,$34,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovqw  oword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6744, [$62,$62,$7E,$48,$34,$72,$7F                       ] , 'vpmovqw  oword [rdx+0x7f0],zmm30'                 );
  TestCase.testcase(6745, [$62,$62,$7E,$48,$34,$B2,$00,$08,$00,$00           ] , 'vpmovqw  oword [rdx+0x800],zmm30'                 );
  TestCase.testcase(6746, [$62,$62,$7E,$48,$34,$72,$80                       ] , 'vpmovqw  oword [rdx-0x800],zmm30'                 );
  TestCase.testcase(6747, [$62,$62,$7E,$48,$34,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovqw  oword [rdx-0x810],zmm30'                 );
  TestCase.testcase(6748, [$62,$62,$7E,$48,$24,$31                           ] , 'vpmovsqw  oword [rcx],zmm30'                      );
  TestCase.testcase(6749, [$62,$62,$7E,$4F,$24,$31                           ] , 'vpmovsqw  oword [rcx]{k7},zmm30'                  );
  TestCase.testcase(6750, [$62,$22,$7E,$48,$24,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsqw  oword [rax+r14*8+0x123],zmm30'          );
  TestCase.testcase(6751, [$62,$62,$7E,$48,$24,$72,$7F                       ] , 'vpmovsqw  oword [rdx+0x7f0],zmm30'                );
  TestCase.testcase(6752, [$62,$62,$7E,$48,$24,$B2,$00,$08,$00,$00           ] , 'vpmovsqw  oword [rdx+0x800],zmm30'                );
  TestCase.testcase(6753, [$62,$62,$7E,$48,$24,$72,$80                       ] , 'vpmovsqw  oword [rdx-0x800],zmm30'                );
  TestCase.testcase(6754, [$62,$62,$7E,$48,$24,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovsqw  oword [rdx-0x810],zmm30'                );
  TestCase.testcase(6755, [$62,$62,$7E,$48,$14,$31                           ] , 'vpmovusqw  oword [rcx],zmm30'                     );
  TestCase.testcase(6756, [$62,$62,$7E,$4F,$14,$31                           ] , 'vpmovusqw  oword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6757, [$62,$22,$7E,$48,$14,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovusqw  oword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6758, [$62,$62,$7E,$48,$14,$72,$7F                       ] , 'vpmovusqw  oword [rdx+0x7f0],zmm30'               );
  TestCase.testcase(6759, [$62,$62,$7E,$48,$14,$B2,$00,$08,$00,$00           ] , 'vpmovusqw  oword [rdx+0x800],zmm30'               );
  TestCase.testcase(6760, [$62,$62,$7E,$48,$14,$72,$80                       ] , 'vpmovusqw  oword [rdx-0x800],zmm30'               );
  TestCase.testcase(6761, [$62,$62,$7E,$48,$14,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovusqw  oword [rdx-0x810],zmm30'               );
  TestCase.testcase(6762, [$62,$62,$7E,$48,$35,$31                           ] , 'vpmovqd  yword [rcx],zmm30'                       );
  TestCase.testcase(6763, [$62,$62,$7E,$4F,$35,$31                           ] , 'vpmovqd  yword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6764, [$62,$22,$7E,$48,$35,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovqd  yword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6765, [$62,$62,$7E,$48,$35,$72,$7F                       ] , 'vpmovqd  yword [rdx+0xfe0],zmm30'                 );
  TestCase.testcase(6766, [$62,$62,$7E,$48,$35,$B2,$00,$10,$00,$00           ] , 'vpmovqd  yword [rdx+0x1000],zmm30'                );
  TestCase.testcase(6767, [$62,$62,$7E,$48,$35,$72,$80                       ] , 'vpmovqd  yword [rdx-0x1000],zmm30'                );
  TestCase.testcase(6768, [$62,$62,$7E,$48,$35,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovqd  yword [rdx-0x1020],zmm30'                );
  TestCase.testcase(6769, [$62,$62,$7E,$48,$25,$31                           ] , 'vpmovsqd  yword [rcx],zmm30'                      );
  TestCase.testcase(6770, [$62,$62,$7E,$4F,$25,$31                           ] , 'vpmovsqd  yword [rcx]{k7},zmm30'                  );
  TestCase.testcase(6771, [$62,$22,$7E,$48,$25,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsqd  yword [rax+r14*8+0x123],zmm30'          );
  TestCase.testcase(6772, [$62,$62,$7E,$48,$25,$72,$7F                       ] , 'vpmovsqd  yword [rdx+0xfe0],zmm30'                );
  TestCase.testcase(6773, [$62,$62,$7E,$48,$25,$B2,$00,$10,$00,$00           ] , 'vpmovsqd  yword [rdx+0x1000],zmm30'               );
  TestCase.testcase(6774, [$62,$62,$7E,$48,$25,$72,$80                       ] , 'vpmovsqd  yword [rdx-0x1000],zmm30'               );
  TestCase.testcase(6775, [$62,$62,$7E,$48,$25,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovsqd  yword [rdx-0x1020],zmm30'               );
  TestCase.testcase(6776, [$62,$62,$7E,$48,$15,$31                           ] , 'vpmovusqd  yword [rcx],zmm30'                     );
  TestCase.testcase(6777, [$62,$62,$7E,$4F,$15,$31                           ] , 'vpmovusqd  yword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6778, [$62,$22,$7E,$48,$15,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovusqd  yword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6779, [$62,$62,$7E,$48,$15,$72,$7F                       ] , 'vpmovusqd  yword [rdx+0xfe0],zmm30'               );
  TestCase.testcase(6780, [$62,$62,$7E,$48,$15,$B2,$00,$10,$00,$00           ] , 'vpmovusqd  yword [rdx+0x1000],zmm30'              );
  TestCase.testcase(6781, [$62,$62,$7E,$48,$15,$72,$80                       ] , 'vpmovusqd  yword [rdx-0x1000],zmm30'              );
  TestCase.testcase(6782, [$62,$62,$7E,$48,$15,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovusqd  yword [rdx-0x1020],zmm30'              );
  TestCase.testcase(6783, [$62,$62,$7E,$48,$31,$31                           ] , 'vpmovdb  oword [rcx],zmm30'                       );
  TestCase.testcase(6784, [$62,$62,$7E,$4F,$31,$31                           ] , 'vpmovdb  oword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6785, [$62,$22,$7E,$48,$31,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovdb  oword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6786, [$62,$62,$7E,$48,$31,$72,$7F                       ] , 'vpmovdb  oword [rdx+0x7f0],zmm30'                 );
  TestCase.testcase(6787, [$62,$62,$7E,$48,$31,$B2,$00,$08,$00,$00           ] , 'vpmovdb  oword [rdx+0x800],zmm30'                 );
  TestCase.testcase(6788, [$62,$62,$7E,$48,$31,$72,$80                       ] , 'vpmovdb  oword [rdx-0x800],zmm30'                 );
  TestCase.testcase(6789, [$62,$62,$7E,$48,$31,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovdb  oword [rdx-0x810],zmm30'                 );
  TestCase.testcase(6790, [$62,$62,$7E,$48,$21,$31                           ] , 'vpmovsdb  oword [rcx],zmm30'                      );
  TestCase.testcase(6791, [$62,$62,$7E,$4F,$21,$31                           ] , 'vpmovsdb  oword [rcx]{k7},zmm30'                  );
  TestCase.testcase(6792, [$62,$22,$7E,$48,$21,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsdb  oword [rax+r14*8+0x123],zmm30'          );
  TestCase.testcase(6793, [$62,$62,$7E,$48,$21,$72,$7F                       ] , 'vpmovsdb  oword [rdx+0x7f0],zmm30'                );
  TestCase.testcase(6794, [$62,$62,$7E,$48,$21,$B2,$00,$08,$00,$00           ] , 'vpmovsdb  oword [rdx+0x800],zmm30'                );
  TestCase.testcase(6795, [$62,$62,$7E,$48,$21,$72,$80                       ] , 'vpmovsdb  oword [rdx-0x800],zmm30'                );
  TestCase.testcase(6796, [$62,$62,$7E,$48,$21,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovsdb  oword [rdx-0x810],zmm30'                );
  TestCase.testcase(6797, [$62,$62,$7E,$48,$11,$31                           ] , 'vpmovusdb  oword [rcx],zmm30'                     );
  TestCase.testcase(6798, [$62,$62,$7E,$4F,$11,$31                           ] , 'vpmovusdb  oword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6799, [$62,$22,$7E,$48,$11,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovusdb  oword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6800, [$62,$62,$7E,$48,$11,$72,$7F                       ] , 'vpmovusdb  oword [rdx+0x7f0],zmm30'               );
  TestCase.testcase(6801, [$62,$62,$7E,$48,$11,$B2,$00,$08,$00,$00           ] , 'vpmovusdb  oword [rdx+0x800],zmm30'               );
  TestCase.testcase(6802, [$62,$62,$7E,$48,$11,$72,$80                       ] , 'vpmovusdb  oword [rdx-0x800],zmm30'               );
  TestCase.testcase(6803, [$62,$62,$7E,$48,$11,$B2,$F0,$F7,$FF,$FF           ] , 'vpmovusdb  oword [rdx-0x810],zmm30'               );
  TestCase.testcase(6804, [$62,$62,$7E,$48,$33,$31                           ] , 'vpmovdw  yword [rcx],zmm30'                       );
  TestCase.testcase(6805, [$62,$62,$7E,$4F,$33,$31                           ] , 'vpmovdw  yword [rcx]{k7},zmm30'                   );
  TestCase.testcase(6806, [$62,$22,$7E,$48,$33,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovdw  yword [rax+r14*8+0x123],zmm30'           );
  TestCase.testcase(6807, [$62,$62,$7E,$48,$33,$72,$7F                       ] , 'vpmovdw  yword [rdx+0xfe0],zmm30'                 );
  TestCase.testcase(6808, [$62,$62,$7E,$48,$33,$B2,$00,$10,$00,$00           ] , 'vpmovdw  yword [rdx+0x1000],zmm30'                );
  TestCase.testcase(6809, [$62,$62,$7E,$48,$33,$72,$80                       ] , 'vpmovdw  yword [rdx-0x1000],zmm30'                );
  TestCase.testcase(6810, [$62,$62,$7E,$48,$33,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovdw  yword [rdx-0x1020],zmm30'                );
  TestCase.testcase(6811, [$62,$62,$7E,$48,$23,$31                           ] , 'vpmovsdw  yword [rcx],zmm30'                      );
  TestCase.testcase(6812, [$62,$62,$7E,$4F,$23,$31                           ] , 'vpmovsdw  yword [rcx]{k7},zmm30'                  );
  TestCase.testcase(6813, [$62,$22,$7E,$48,$23,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovsdw  yword [rax+r14*8+0x123],zmm30'          );
  TestCase.testcase(6814, [$62,$62,$7E,$48,$23,$72,$7F                       ] , 'vpmovsdw  yword [rdx+0xfe0],zmm30'                );
  TestCase.testcase(6815, [$62,$62,$7E,$48,$23,$B2,$00,$10,$00,$00           ] , 'vpmovsdw  yword [rdx+0x1000],zmm30'               );
  TestCase.testcase(6816, [$62,$62,$7E,$48,$23,$72,$80                       ] , 'vpmovsdw  yword [rdx-0x1000],zmm30'               );
  TestCase.testcase(6817, [$62,$62,$7E,$48,$23,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovsdw  yword [rdx-0x1020],zmm30'               );
  TestCase.testcase(6818, [$62,$62,$7E,$48,$13,$31                           ] , 'vpmovusdw  yword [rcx],zmm30'                     );
  TestCase.testcase(6819, [$62,$62,$7E,$4F,$13,$31                           ] , 'vpmovusdw  yword [rcx]{k7},zmm30'                 );
  TestCase.testcase(6820, [$62,$22,$7E,$48,$13,$B4,$F0,$23,$01,$00,$00       ] , 'vpmovusdw  yword [rax+r14*8+0x123],zmm30'         );
  TestCase.testcase(6821, [$62,$62,$7E,$48,$13,$72,$7F                       ] , 'vpmovusdw  yword [rdx+0xfe0],zmm30'               );
  TestCase.testcase(6822, [$62,$62,$7E,$48,$13,$B2,$00,$10,$00,$00           ] , 'vpmovusdw  yword [rdx+0x1000],zmm30'              );
  TestCase.testcase(6823, [$62,$62,$7E,$48,$13,$72,$80                       ] , 'vpmovusdw  yword [rdx-0x1000],zmm30'              );
  TestCase.testcase(6824, [$62,$62,$7E,$48,$13,$B2,$E0,$EF,$FF,$FF           ] , 'vpmovusdw  yword [rdx-0x1020],zmm30'              );
  TestCase.testcase(6825, [$62,$01,$FC,$4F,$78,$F5                           ] , 'vcvttpd2udq  ymm30{k7},zmm29'                     );
  TestCase.testcase(6826, [$62,$01,$FC,$CF,$78,$F5                           ] , 'vcvttpd2udq  ymm30{k7}{z},zmm29'                  );
  TestCase.testcase(6827, [$62,$01,$FC,$1F,$78,$F5                           ] , 'vcvttpd2udq  ymm30{k7},zmm29,{sae}'               );
  TestCase.testcase(6828, [$62,$61,$FC,$4F,$78,$31                           ] , 'vcvttpd2udq  ymm30{k7},zword [rcx]'               );
  TestCase.testcase(6829, [$62,$21,$FC,$4F,$78,$B4,$F0,$23,$01,$00,$00       ] , 'vcvttpd2udq  ymm30{k7},zword [rax+r14*8+0x123]'   );
  TestCase.testcase(6830, [$62,$61,$FC,$5F,$78,$31                           ] , 'vcvttpd2udq  ymm30{k7},qword [rcx]{1to8}'         );
  TestCase.testcase(6831, [$62,$61,$FC,$4F,$78,$72,$7F                       ] , 'vcvttpd2udq  ymm30{k7},zword [rdx+0x1fc0]'        );
  TestCase.testcase(6832, [$62,$61,$FC,$4F,$78,$B2,$00,$20,$00,$00           ] , 'vcvttpd2udq  ymm30{k7},zword [rdx+0x2000]'        );
  TestCase.testcase(6833, [$62,$61,$FC,$4F,$78,$72,$80                       ] , 'vcvttpd2udq  ymm30{k7},zword [rdx-0x2000]'        );
  TestCase.testcase(6834, [$62,$61,$FC,$4F,$78,$B2,$C0,$DF,$FF,$FF           ] , 'vcvttpd2udq  ymm30{k7},zword [rdx-0x2040]'        );
  TestCase.testcase(6835, [$62,$61,$FC,$5F,$78,$72,$7F                       ] , 'vcvttpd2udq  ymm30{k7},qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(6836, [$62,$61,$FC,$5F,$78,$B2,$00,$04,$00,$00           ] , 'vcvttpd2udq  ymm30{k7},qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(6837, [$62,$61,$FC,$5F,$78,$72,$80                       ] , 'vcvttpd2udq  ymm30{k7},qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(6838, [$62,$61,$FC,$5F,$78,$B2,$F8,$FB,$FF,$FF           ] , 'vcvttpd2udq  ymm30{k7},qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(6839, [$62,$01,$7C,$48,$78,$F5                           ] , 'vcvttps2udq  zmm30,zmm29'                         );
  TestCase.testcase(6840, [$62,$01,$7C,$4F,$78,$F5                           ] , 'vcvttps2udq  zmm30{k7},zmm29'                     );
  TestCase.testcase(6841, [$62,$01,$7C,$CF,$78,$F5                           ] , 'vcvttps2udq  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(6842, [$62,$01,$7C,$18,$78,$F5                           ] , 'vcvttps2udq  zmm30,zmm29,{sae}'                   );
  TestCase.testcase(6843, [$62,$61,$7C,$48,$78,$31                           ] , 'vcvttps2udq  zmm30,zword [rcx]'                   );
  TestCase.testcase(6844, [$62,$21,$7C,$48,$78,$B4,$F0,$23,$01,$00,$00       ] , 'vcvttps2udq  zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(6845, [$62,$61,$7C,$58,$78,$31                           ] , 'vcvttps2udq  zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(6846, [$62,$61,$7C,$48,$78,$72,$7F                       ] , 'vcvttps2udq  zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(6847, [$62,$61,$7C,$48,$78,$B2,$00,$20,$00,$00           ] , 'vcvttps2udq  zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(6848, [$62,$61,$7C,$48,$78,$72,$80                       ] , 'vcvttps2udq  zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(6849, [$62,$61,$7C,$48,$78,$B2,$C0,$DF,$FF,$FF           ] , 'vcvttps2udq  zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(6850, [$62,$61,$7C,$58,$78,$72,$7F                       ] , 'vcvttps2udq  zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(6851, [$62,$61,$7C,$58,$78,$B2,$00,$02,$00,$00           ] , 'vcvttps2udq  zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(6852, [$62,$61,$7C,$58,$78,$72,$80                       ] , 'vcvttps2udq  zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(6853, [$62,$61,$7C,$58,$78,$B2,$FC,$FD,$FF,$FF           ] , 'vcvttps2udq  zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(6854, [$62,$91,$7F,$08,$78,$C6                           ] , 'vcvttsd2usi  eax,xmm30'                           );
  TestCase.testcase(6855, [$62,$91,$7F,$18,$78,$C6                           ] , 'vcvttsd2usi  eax,xmm30,{sae}'                     );
  TestCase.testcase(6856, [$62,$F1,$7F,$08,$78,$01                           ] , 'vcvttsd2usi  eax,qword [rcx]'                     );
  TestCase.testcase(6857, [$62,$B1,$7F,$08,$78,$84,$F0,$23,$01,$00,$00       ] , 'vcvttsd2usi  eax,qword [rax+r14*8+0x123]'         );
  TestCase.testcase(6858, [$62,$F1,$7F,$08,$78,$42,$7F                       ] , 'vcvttsd2usi  eax,qword [rdx+0x3f8]'               );
  TestCase.testcase(6859, [$62,$F1,$7F,$08,$78,$82,$00,$04,$00,$00           ] , 'vcvttsd2usi  eax,qword [rdx+0x400]'               );
  TestCase.testcase(6860, [$62,$F1,$7F,$08,$78,$42,$80                       ] , 'vcvttsd2usi  eax,qword [rdx-0x400]'               );
  TestCase.testcase(6861, [$62,$F1,$7F,$08,$78,$82,$F8,$FB,$FF,$FF           ] , 'vcvttsd2usi  eax,qword [rdx-0x408]'               );
  TestCase.testcase(6862, [$62,$91,$7F,$08,$78,$EE                           ] , 'vcvttsd2usi  ebp,xmm30'                           );
  TestCase.testcase(6863, [$62,$91,$7F,$18,$78,$EE                           ] , 'vcvttsd2usi  ebp,xmm30,{sae}'                     );
  TestCase.testcase(6864, [$62,$F1,$7F,$08,$78,$29                           ] , 'vcvttsd2usi  ebp,qword [rcx]'                     );
  TestCase.testcase(6865, [$62,$B1,$7F,$08,$78,$AC,$F0,$23,$01,$00,$00       ] , 'vcvttsd2usi  ebp,qword [rax+r14*8+0x123]'         );
  TestCase.testcase(6866, [$62,$F1,$7F,$08,$78,$6A,$7F                       ] , 'vcvttsd2usi  ebp,qword [rdx+0x3f8]'               );
  TestCase.testcase(6867, [$62,$F1,$7F,$08,$78,$AA,$00,$04,$00,$00           ] , 'vcvttsd2usi  ebp,qword [rdx+0x400]'               );
  TestCase.testcase(6868, [$62,$F1,$7F,$08,$78,$6A,$80                       ] , 'vcvttsd2usi  ebp,qword [rdx-0x400]'               );
  TestCase.testcase(6869, [$62,$F1,$7F,$08,$78,$AA,$F8,$FB,$FF,$FF           ] , 'vcvttsd2usi  ebp,qword [rdx-0x408]'               );
  TestCase.testcase(6870, [$62,$11,$7F,$08,$78,$EE                           ] , 'vcvttsd2usi  r13d,xmm30'                          );
  TestCase.testcase(6871, [$62,$11,$7F,$18,$78,$EE                           ] , 'vcvttsd2usi  r13d,xmm30,{sae}'                    );
  TestCase.testcase(6872, [$62,$71,$7F,$08,$78,$29                           ] , 'vcvttsd2usi  r13d,qword [rcx]'                    );
  TestCase.testcase(6873, [$62,$31,$7F,$08,$78,$AC,$F0,$23,$01,$00,$00       ] , 'vcvttsd2usi  r13d,qword [rax+r14*8+0x123]'        );
  TestCase.testcase(6874, [$62,$71,$7F,$08,$78,$6A,$7F                       ] , 'vcvttsd2usi  r13d,qword [rdx+0x3f8]'              );
  TestCase.testcase(6875, [$62,$71,$7F,$08,$78,$AA,$00,$04,$00,$00           ] , 'vcvttsd2usi  r13d,qword [rdx+0x400]'              );
  TestCase.testcase(6876, [$62,$71,$7F,$08,$78,$6A,$80                       ] , 'vcvttsd2usi  r13d,qword [rdx-0x400]'              );
  TestCase.testcase(6877, [$62,$71,$7F,$08,$78,$AA,$F8,$FB,$FF,$FF           ] , 'vcvttsd2usi  r13d,qword [rdx-0x408]'              );
  TestCase.testcase(6878, [$62,$91,$FF,$08,$78,$C6                           ] , 'vcvttsd2usi  rax,xmm30'                           );
  TestCase.testcase(6879, [$62,$91,$FF,$18,$78,$C6                           ] , 'vcvttsd2usi  rax,xmm30,{sae}'                     );
  TestCase.testcase(6880, [$62,$F1,$FF,$08,$78,$01                           ] , 'vcvttsd2usi  rax,qword [rcx]'                     );
  TestCase.testcase(6881, [$62,$B1,$FF,$08,$78,$84,$F0,$23,$01,$00,$00       ] , 'vcvttsd2usi  rax,qword [rax+r14*8+0x123]'         );
  TestCase.testcase(6882, [$62,$F1,$FF,$08,$78,$42,$7F                       ] , 'vcvttsd2usi  rax,qword [rdx+0x3f8]'               );
  TestCase.testcase(6883, [$62,$F1,$FF,$08,$78,$82,$00,$04,$00,$00           ] , 'vcvttsd2usi  rax,qword [rdx+0x400]'               );
  TestCase.testcase(6884, [$62,$F1,$FF,$08,$78,$42,$80                       ] , 'vcvttsd2usi  rax,qword [rdx-0x400]'               );
  TestCase.testcase(6885, [$62,$F1,$FF,$08,$78,$82,$F8,$FB,$FF,$FF           ] , 'vcvttsd2usi  rax,qword [rdx-0x408]'               );
  TestCase.testcase(6886, [$62,$11,$FF,$08,$78,$C6                           ] , 'vcvttsd2usi  r8,xmm30'                            );
  TestCase.testcase(6887, [$62,$11,$FF,$18,$78,$C6                           ] , 'vcvttsd2usi  r8,xmm30,{sae}'                      );
  TestCase.testcase(6888, [$62,$71,$FF,$08,$78,$01                           ] , 'vcvttsd2usi  r8,qword [rcx]'                      );
  TestCase.testcase(6889, [$62,$31,$FF,$08,$78,$84,$F0,$23,$01,$00,$00       ] , 'vcvttsd2usi  r8,qword [rax+r14*8+0x123]'          );
  TestCase.testcase(6890, [$62,$71,$FF,$08,$78,$42,$7F                       ] , 'vcvttsd2usi  r8,qword [rdx+0x3f8]'                );
  TestCase.testcase(6891, [$62,$71,$FF,$08,$78,$82,$00,$04,$00,$00           ] , 'vcvttsd2usi  r8,qword [rdx+0x400]'                );
  TestCase.testcase(6892, [$62,$71,$FF,$08,$78,$42,$80                       ] , 'vcvttsd2usi  r8,qword [rdx-0x400]'                );
  TestCase.testcase(6893, [$62,$71,$FF,$08,$78,$82,$F8,$FB,$FF,$FF           ] , 'vcvttsd2usi  r8,qword [rdx-0x408]'                );
  TestCase.testcase(6894, [$62,$91,$7E,$08,$78,$C6                           ] , 'vcvttss2usi  eax,xmm30'                           );
  TestCase.testcase(6895, [$62,$91,$7E,$18,$78,$C6                           ] , 'vcvttss2usi  eax,xmm30,{sae}'                     );
  TestCase.testcase(6896, [$62,$F1,$7E,$08,$78,$01                           ] , 'vcvttss2usi  eax,dword [rcx]'                     );
  TestCase.testcase(6897, [$62,$B1,$7E,$08,$78,$84,$F0,$23,$01,$00,$00       ] , 'vcvttss2usi  eax,dword [rax+r14*8+0x123]'         );
  TestCase.testcase(6898, [$62,$F1,$7E,$08,$78,$42,$7F                       ] , 'vcvttss2usi  eax,dword [rdx+0x1fc]'               );
  TestCase.testcase(6899, [$62,$F1,$7E,$08,$78,$82,$00,$02,$00,$00           ] , 'vcvttss2usi  eax,dword [rdx+0x200]'               );
  TestCase.testcase(6900, [$62,$F1,$7E,$08,$78,$42,$80                       ] , 'vcvttss2usi  eax,dword [rdx-0x200]'               );
  TestCase.testcase(6901, [$62,$F1,$7E,$08,$78,$82,$FC,$FD,$FF,$FF           ] , 'vcvttss2usi  eax,dword [rdx-0x204]'               );
  TestCase.testcase(6902, [$62,$91,$7E,$08,$78,$EE                           ] , 'vcvttss2usi  ebp,xmm30'                           );
  TestCase.testcase(6903, [$62,$91,$7E,$18,$78,$EE                           ] , 'vcvttss2usi  ebp,xmm30,{sae}'                     );
  TestCase.testcase(6904, [$62,$F1,$7E,$08,$78,$29                           ] , 'vcvttss2usi  ebp,dword [rcx]'                     );
  TestCase.testcase(6905, [$62,$B1,$7E,$08,$78,$AC,$F0,$23,$01,$00,$00       ] , 'vcvttss2usi  ebp,dword [rax+r14*8+0x123]'         );
  TestCase.testcase(6906, [$62,$F1,$7E,$08,$78,$6A,$7F                       ] , 'vcvttss2usi  ebp,dword [rdx+0x1fc]'               );
  TestCase.testcase(6907, [$62,$F1,$7E,$08,$78,$AA,$00,$02,$00,$00           ] , 'vcvttss2usi  ebp,dword [rdx+0x200]'               );
  TestCase.testcase(6908, [$62,$F1,$7E,$08,$78,$6A,$80                       ] , 'vcvttss2usi  ebp,dword [rdx-0x200]'               );
  TestCase.testcase(6909, [$62,$F1,$7E,$08,$78,$AA,$FC,$FD,$FF,$FF           ] , 'vcvttss2usi  ebp,dword [rdx-0x204]'               );
  TestCase.testcase(6910, [$62,$11,$7E,$08,$78,$EE                           ] , 'vcvttss2usi  r13d,xmm30'                          );
  TestCase.testcase(6911, [$62,$11,$7E,$18,$78,$EE                           ] , 'vcvttss2usi  r13d,xmm30,{sae}'                    );
  TestCase.testcase(6912, [$62,$71,$7E,$08,$78,$29                           ] , 'vcvttss2usi  r13d,dword [rcx]'                    );
  TestCase.testcase(6913, [$62,$31,$7E,$08,$78,$AC,$F0,$23,$01,$00,$00       ] , 'vcvttss2usi  r13d,dword [rax+r14*8+0x123]'        );
  TestCase.testcase(6914, [$62,$71,$7E,$08,$78,$6A,$7F                       ] , 'vcvttss2usi  r13d,dword [rdx+0x1fc]'              );
  TestCase.testcase(6915, [$62,$71,$7E,$08,$78,$AA,$00,$02,$00,$00           ] , 'vcvttss2usi  r13d,dword [rdx+0x200]'              );
  TestCase.testcase(6916, [$62,$71,$7E,$08,$78,$6A,$80                       ] , 'vcvttss2usi  r13d,dword [rdx-0x200]'              );
  TestCase.testcase(6917, [$62,$71,$7E,$08,$78,$AA,$FC,$FD,$FF,$FF           ] , 'vcvttss2usi  r13d,dword [rdx-0x204]'              );
  TestCase.testcase(6918, [$62,$91,$FE,$08,$78,$C6                           ] , 'vcvttss2usi  rax,xmm30'                           );
  TestCase.testcase(6919, [$62,$91,$FE,$18,$78,$C6                           ] , 'vcvttss2usi  rax,xmm30,{sae}'                     );
  TestCase.testcase(6920, [$62,$F1,$FE,$08,$78,$01                           ] , 'vcvttss2usi  rax,dword [rcx]'                     );
  TestCase.testcase(6921, [$62,$B1,$FE,$08,$78,$84,$F0,$23,$01,$00,$00       ] , 'vcvttss2usi  rax,dword [rax+r14*8+0x123]'         );
  TestCase.testcase(6922, [$62,$F1,$FE,$08,$78,$42,$7F                       ] , 'vcvttss2usi  rax,dword [rdx+0x1fc]'               );
  TestCase.testcase(6923, [$62,$F1,$FE,$08,$78,$82,$00,$02,$00,$00           ] , 'vcvttss2usi  rax,dword [rdx+0x200]'               );
  TestCase.testcase(6924, [$62,$F1,$FE,$08,$78,$42,$80                       ] , 'vcvttss2usi  rax,dword [rdx-0x200]'               );
  TestCase.testcase(6925, [$62,$F1,$FE,$08,$78,$82,$FC,$FD,$FF,$FF           ] , 'vcvttss2usi  rax,dword [rdx-0x204]'               );
  TestCase.testcase(6926, [$62,$11,$FE,$08,$78,$C6                           ] , 'vcvttss2usi  r8,xmm30'                            );
  TestCase.testcase(6927, [$62,$11,$FE,$18,$78,$C6                           ] , 'vcvttss2usi  r8,xmm30,{sae}'                      );
  TestCase.testcase(6928, [$62,$71,$FE,$08,$78,$01                           ] , 'vcvttss2usi  r8,dword [rcx]'                      );
  TestCase.testcase(6929, [$62,$31,$FE,$08,$78,$84,$F0,$23,$01,$00,$00       ] , 'vcvttss2usi  r8,dword [rax+r14*8+0x123]'          );
  TestCase.testcase(6930, [$62,$71,$FE,$08,$78,$42,$7F                       ] , 'vcvttss2usi  r8,dword [rdx+0x1fc]'                );
  TestCase.testcase(6931, [$62,$71,$FE,$08,$78,$82,$00,$02,$00,$00           ] , 'vcvttss2usi  r8,dword [rdx+0x200]'                );
  TestCase.testcase(6932, [$62,$71,$FE,$08,$78,$42,$80                       ] , 'vcvttss2usi  r8,dword [rdx-0x200]'                );
  TestCase.testcase(6933, [$62,$71,$FE,$08,$78,$82,$FC,$FD,$FF,$FF           ] , 'vcvttss2usi  r8,dword [rdx-0x204]'                );
  TestCase.testcase(6934, [$62,$02,$15,$40,$76,$F4                           ] , 'vpermi2d  zmm30,zmm29,zmm28'                      );
  TestCase.testcase(6935, [$62,$02,$15,$47,$76,$F4                           ] , 'vpermi2d  zmm30{k7},zmm29,zmm28'                  );
  TestCase.testcase(6936, [$62,$02,$15,$C7,$76,$F4                           ] , 'vpermi2d  zmm30{k7}{z},zmm29,zmm28'               );
  TestCase.testcase(6937, [$62,$62,$15,$40,$76,$31                           ] , 'vpermi2d  zmm30,zmm29,zword [rcx]'                );
  TestCase.testcase(6938, [$62,$22,$15,$40,$76,$B4,$F0,$23,$01,$00,$00       ] , 'vpermi2d  zmm30,zmm29,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(6939, [$62,$62,$15,$50,$76,$31                           ] , 'vpermi2d  zmm30,zmm29,dword [rcx]{1to16}'         );
  TestCase.testcase(6940, [$62,$62,$15,$40,$76,$72,$7F                       ] , 'vpermi2d  zmm30,zmm29,zword [rdx+0x1fc0]'         );
  TestCase.testcase(6941, [$62,$62,$15,$40,$76,$B2,$00,$20,$00,$00           ] , 'vpermi2d  zmm30,zmm29,zword [rdx+0x2000]'         );
  TestCase.testcase(6942, [$62,$62,$15,$40,$76,$72,$80                       ] , 'vpermi2d  zmm30,zmm29,zword [rdx-0x2000]'         );
  TestCase.testcase(6943, [$62,$62,$15,$40,$76,$B2,$C0,$DF,$FF,$FF           ] , 'vpermi2d  zmm30,zmm29,zword [rdx-0x2040]'         );
  TestCase.testcase(6944, [$62,$62,$15,$50,$76,$72,$7F                       ] , 'vpermi2d  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'   );
  TestCase.testcase(6945, [$62,$62,$15,$50,$76,$B2,$00,$02,$00,$00           ] , 'vpermi2d  zmm30,zmm29,dword [rdx+0x200]{1to16}'   );
  TestCase.testcase(6946, [$62,$62,$15,$50,$76,$72,$80                       ] , 'vpermi2d  zmm30,zmm29,dword [rdx-0x200]{1to16}'   );
  TestCase.testcase(6947, [$62,$62,$15,$50,$76,$B2,$FC,$FD,$FF,$FF           ] , 'vpermi2d  zmm30,zmm29,dword [rdx-0x204]{1to16}'   );
  TestCase.testcase(6948, [$62,$02,$95,$40,$76,$F4                           ] , 'vpermi2q  zmm30,zmm29,zmm28'                      );
  TestCase.testcase(6949, [$62,$02,$95,$47,$76,$F4                           ] , 'vpermi2q  zmm30{k7},zmm29,zmm28'                  );
  TestCase.testcase(6950, [$62,$02,$95,$C7,$76,$F4                           ] , 'vpermi2q  zmm30{k7}{z},zmm29,zmm28'               );
  TestCase.testcase(6951, [$62,$62,$95,$40,$76,$31                           ] , 'vpermi2q  zmm30,zmm29,zword [rcx]'                );
  TestCase.testcase(6952, [$62,$22,$95,$40,$76,$B4,$F0,$23,$01,$00,$00       ] , 'vpermi2q  zmm30,zmm29,zword [rax+r14*8+0x123]'    );
  TestCase.testcase(6953, [$62,$62,$95,$50,$76,$31                           ] , 'vpermi2q  zmm30,zmm29,qword [rcx]{1to8}'          );
  TestCase.testcase(6954, [$62,$62,$95,$40,$76,$72,$7F                       ] , 'vpermi2q  zmm30,zmm29,zword [rdx+0x1fc0]'         );
  TestCase.testcase(6955, [$62,$62,$95,$40,$76,$B2,$00,$20,$00,$00           ] , 'vpermi2q  zmm30,zmm29,zword [rdx+0x2000]'         );
  TestCase.testcase(6956, [$62,$62,$95,$40,$76,$72,$80                       ] , 'vpermi2q  zmm30,zmm29,zword [rdx-0x2000]'         );
  TestCase.testcase(6957, [$62,$62,$95,$40,$76,$B2,$C0,$DF,$FF,$FF           ] , 'vpermi2q  zmm30,zmm29,zword [rdx-0x2040]'         );
  TestCase.testcase(6958, [$62,$62,$95,$50,$76,$72,$7F                       ] , 'vpermi2q  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(6959, [$62,$62,$95,$50,$76,$B2,$00,$04,$00,$00           ] , 'vpermi2q  zmm30,zmm29,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(6960, [$62,$62,$95,$50,$76,$72,$80                       ] , 'vpermi2q  zmm30,zmm29,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(6961, [$62,$62,$95,$50,$76,$B2,$F8,$FB,$FF,$FF           ] , 'vpermi2q  zmm30,zmm29,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(6962, [$62,$02,$15,$40,$77,$F4                           ] , 'vpermi2ps  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(6963, [$62,$02,$15,$47,$77,$F4                           ] , 'vpermi2ps  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(6964, [$62,$02,$15,$C7,$77,$F4                           ] , 'vpermi2ps  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(6965, [$62,$62,$15,$40,$77,$31                           ] , 'vpermi2ps  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(6966, [$62,$22,$15,$40,$77,$B4,$F0,$23,$01,$00,$00       ] , 'vpermi2ps  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(6967, [$62,$62,$15,$50,$77,$31                           ] , 'vpermi2ps  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(6968, [$62,$62,$15,$40,$77,$72,$7F                       ] , 'vpermi2ps  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(6969, [$62,$62,$15,$40,$77,$B2,$00,$20,$00,$00           ] , 'vpermi2ps  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(6970, [$62,$62,$15,$40,$77,$72,$80                       ] , 'vpermi2ps  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(6971, [$62,$62,$15,$40,$77,$B2,$C0,$DF,$FF,$FF           ] , 'vpermi2ps  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(6972, [$62,$62,$15,$50,$77,$72,$7F                       ] , 'vpermi2ps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(6973, [$62,$62,$15,$50,$77,$B2,$00,$02,$00,$00           ] , 'vpermi2ps  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(6974, [$62,$62,$15,$50,$77,$72,$80                       ] , 'vpermi2ps  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(6975, [$62,$62,$15,$50,$77,$B2,$FC,$FD,$FF,$FF           ] , 'vpermi2ps  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(6976, [$62,$02,$95,$40,$77,$F4                           ] , 'vpermi2pd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(6977, [$62,$02,$95,$47,$77,$F4                           ] , 'vpermi2pd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(6978, [$62,$02,$95,$C7,$77,$F4                           ] , 'vpermi2pd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(6979, [$62,$62,$95,$40,$77,$31                           ] , 'vpermi2pd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(6980, [$62,$22,$95,$40,$77,$B4,$F0,$23,$01,$00,$00       ] , 'vpermi2pd  zmm30,zmm29,zword [rax+r14*8+0x123]'   );
  TestCase.testcase(6981, [$62,$62,$95,$50,$77,$31                           ] , 'vpermi2pd  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(6982, [$62,$62,$95,$40,$77,$72,$7F                       ] , 'vpermi2pd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(6983, [$62,$62,$95,$40,$77,$B2,$00,$20,$00,$00           ] , 'vpermi2pd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(6984, [$62,$62,$95,$40,$77,$72,$80                       ] , 'vpermi2pd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(6985, [$62,$62,$95,$40,$77,$B2,$C0,$DF,$FF,$FF           ] , 'vpermi2pd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(6986, [$62,$62,$95,$50,$77,$72,$7F                       ] , 'vpermi2pd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(6987, [$62,$62,$95,$50,$77,$B2,$00,$04,$00,$00           ] , 'vpermi2pd  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(6988, [$62,$62,$95,$50,$77,$72,$80                       ] , 'vpermi2pd  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(6989, [$62,$62,$95,$50,$77,$B2,$F8,$FB,$FF,$FF           ] , 'vpermi2pd  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(6990, [$62,$01,$95,$40,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(6991, [$62,$01,$95,$47,$58,$F4                           ] , 'vaddpd  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(6992, [$62,$01,$95,$C7,$58,$F4                           ] , 'vaddpd  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(6993, [$62,$01,$95,$10,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(6994, [$62,$01,$95,$50,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(6995, [$62,$01,$95,$30,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(6996, [$62,$01,$95,$70,$58,$F4                           ] , 'vaddpd  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(6997, [$62,$61,$95,$40,$58,$31                           ] , 'vaddpd  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(6998, [$62,$21,$95,$40,$58,$B4,$F0,$34,$12,$00,$00       ] , 'vaddpd  zmm30,zmm29,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(6999, [$62,$61,$95,$50,$58,$31                           ] , 'vaddpd  zmm30,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(7000, [$62,$61,$95,$40,$58,$72,$7F                       ] , 'vaddpd  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7001, [$62,$61,$95,$40,$58,$B2,$00,$20,$00,$00           ] , 'vaddpd  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(7002, [$62,$61,$95,$40,$58,$72,$80                       ] , 'vaddpd  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(7003, [$62,$61,$95,$40,$58,$B2,$C0,$DF,$FF,$FF           ] , 'vaddpd  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(7004, [$62,$61,$95,$50,$58,$72,$7F                       ] , 'vaddpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7005, [$62,$61,$95,$50,$58,$B2,$00,$04,$00,$00           ] , 'vaddpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7006, [$62,$61,$95,$50,$58,$72,$80                       ] , 'vaddpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7007, [$62,$61,$95,$50,$58,$B2,$F8,$FB,$FF,$FF           ] , 'vaddpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7008, [$62,$01,$14,$40,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28'                        );
  TestCase.testcase(7009, [$62,$01,$14,$47,$58,$F4                           ] , 'vaddps  zmm30{k7},zmm29,zmm28'                    );
  TestCase.testcase(7010, [$62,$01,$14,$C7,$58,$F4                           ] , 'vaddps  zmm30{k7}{z},zmm29,zmm28'                 );
  TestCase.testcase(7011, [$62,$01,$14,$10,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28,{rn-sae}'               );
  TestCase.testcase(7012, [$62,$01,$14,$50,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28,{ru-sae}'               );
  TestCase.testcase(7013, [$62,$01,$14,$30,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28,{rd-sae}'               );
  TestCase.testcase(7014, [$62,$01,$14,$70,$58,$F4                           ] , 'vaddps  zmm30,zmm29,zmm28,{rz-sae}'               );
  TestCase.testcase(7015, [$62,$61,$14,$40,$58,$31                           ] , 'vaddps  zmm30,zmm29,zword [rcx]'                  );
  TestCase.testcase(7016, [$62,$21,$14,$40,$58,$B4,$F0,$34,$12,$00,$00       ] , 'vaddps  zmm30,zmm29,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7017, [$62,$61,$14,$50,$58,$31                           ] , 'vaddps  zmm30,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(7018, [$62,$61,$14,$40,$58,$72,$7F                       ] , 'vaddps  zmm30,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7019, [$62,$61,$14,$40,$58,$B2,$00,$20,$00,$00           ] , 'vaddps  zmm30,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(7020, [$62,$61,$14,$40,$58,$72,$80                       ] , 'vaddps  zmm30,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(7021, [$62,$61,$14,$40,$58,$B2,$C0,$DF,$FF,$FF           ] , 'vaddps  zmm30,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(7022, [$62,$61,$14,$50,$58,$72,$7F                       ] , 'vaddps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(7023, [$62,$61,$14,$50,$58,$B2,$00,$02,$00,$00           ] , 'vaddps  zmm30,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(7024, [$62,$61,$14,$50,$58,$72,$80                       ] , 'vaddps  zmm30,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(7025, [$62,$61,$14,$50,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vaddps  zmm30,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(7026, [$62,$01,$97,$07,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(7027, [$62,$01,$97,$87,$58,$F4                           ] , 'vaddsd  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(7028, [$62,$01,$97,$17,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(7029, [$62,$01,$97,$57,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(7030, [$62,$01,$97,$37,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(7031, [$62,$01,$97,$77,$58,$F4                           ] , 'vaddsd  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(7032, [$62,$61,$97,$07,$58,$31                           ] , 'vaddsd  xmm30{k7},xmm29,qword [rcx]'              );
  TestCase.testcase(7033, [$62,$21,$97,$07,$58,$B4,$F0,$34,$12,$00,$00       ] , 'vaddsd  xmm30{k7},xmm29,qword [rax+r14*8+0x1234]' );
  TestCase.testcase(7034, [$62,$61,$97,$07,$58,$72,$7F                       ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx+0x3f8]'        );
  TestCase.testcase(7035, [$62,$61,$97,$07,$58,$B2,$00,$04,$00,$00           ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx+0x400]'        );
  TestCase.testcase(7036, [$62,$61,$97,$07,$58,$72,$80                       ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx-0x400]'        );
  TestCase.testcase(7037, [$62,$61,$97,$07,$58,$B2,$F8,$FB,$FF,$FF           ] , 'vaddsd  xmm30{k7},xmm29,qword [rdx-0x408]'        );
  TestCase.testcase(7038, [$62,$01,$16,$07,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28'                    );
  TestCase.testcase(7039, [$62,$01,$16,$87,$58,$F4                           ] , 'vaddss  xmm30{k7}{z},xmm29,xmm28'                 );
  TestCase.testcase(7040, [$62,$01,$16,$17,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rn-sae}'           );
  TestCase.testcase(7041, [$62,$01,$16,$57,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{ru-sae}'           );
  TestCase.testcase(7042, [$62,$01,$16,$37,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rd-sae}'           );
  TestCase.testcase(7043, [$62,$01,$16,$77,$58,$F4                           ] , 'vaddss  xmm30{k7},xmm29,xmm28,{rz-sae}'           );
  TestCase.testcase(7044, [$62,$61,$16,$07,$58,$31                           ] , 'vaddss  xmm30{k7},xmm29,dword [rcx]'              );
  TestCase.testcase(7045, [$62,$21,$16,$07,$58,$B4,$F0,$34,$12,$00,$00       ] , 'vaddss  xmm30{k7},xmm29,dword [rax+r14*8+0x1234]' );
  TestCase.testcase(7046, [$62,$61,$16,$07,$58,$72,$7F                       ] , 'vaddss  xmm30{k7},xmm29,dword [rdx+0x1fc]'        );
  TestCase.testcase(7047, [$62,$61,$16,$07,$58,$B2,$00,$02,$00,$00           ] , 'vaddss  xmm30{k7},xmm29,dword [rdx+0x200]'        );
  TestCase.testcase(7048, [$62,$61,$16,$07,$58,$72,$80                       ] , 'vaddss  xmm30{k7},xmm29,dword [rdx-0x200]'        );
  TestCase.testcase(7049, [$62,$61,$16,$07,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vaddss  xmm30{k7},xmm29,dword [rdx-0x204]'        );
  TestCase.testcase(7050, [$62,$03,$15,$40,$03,$F4,$AB                       ] , 'valignd  zmm30,zmm29,zmm28,0xab'                  );
  TestCase.testcase(7051, [$62,$03,$15,$47,$03,$F4,$AB                       ] , 'valignd  zmm30{k7},zmm29,zmm28,0xab'              );
  TestCase.testcase(7052, [$62,$03,$15,$C7,$03,$F4,$AB                       ] , 'valignd  zmm30{k7}{z},zmm29,zmm28,0xab'           );
  TestCase.testcase(7053, [$62,$03,$15,$40,$03,$F4,$7B                       ] , 'valignd  zmm30,zmm29,zmm28,0x7b'                  );
  TestCase.testcase(7054, [$62,$63,$15,$40,$03,$31,$7B                       ] , 'valignd  zmm30,zmm29,zword [rcx],0x7b'            );
  TestCase.testcase(7055, [$62,$23,$15,$40,$03,$B4,$F0,$34,$12,$00,$00,$7B   ] , 'valignd  zmm30,zmm29,zword [rax+r14*8+0x1234],0x7b' );
  TestCase.testcase(7056, [$62,$63,$15,$50,$03,$31,$7B                       ] , 'valignd  zmm30,zmm29,dword [rcx]{1to16},0x7b'     );
  TestCase.testcase(7057, [$62,$63,$15,$40,$03,$72,$7F,$7B                   ] , 'valignd  zmm30,zmm29,zword [rdx+0x1fc0],0x7b'     );
  TestCase.testcase(7058, [$62,$63,$15,$40,$03,$B2,$00,$20,$00,$00,$7B       ] , 'valignd  zmm30,zmm29,zword [rdx+0x2000],0x7b'     );
  TestCase.testcase(7059, [$62,$63,$15,$40,$03,$72,$80,$7B                   ] , 'valignd  zmm30,zmm29,zword [rdx-0x2000],0x7b'     );
  TestCase.testcase(7060, [$62,$63,$15,$40,$03,$B2,$C0,$DF,$FF,$FF,$7B       ] , 'valignd  zmm30,zmm29,zword [rdx-0x2040],0x7b'     );
  TestCase.testcase(7061, [$62,$63,$15,$50,$03,$72,$7F,$7B                   ] , 'valignd  zmm30,zmm29,dword [rdx+0x1fc]{1to16},0x7b' );
  TestCase.testcase(7062, [$62,$63,$15,$50,$03,$B2,$00,$02,$00,$00,$7B       ] , 'valignd  zmm30,zmm29,dword [rdx+0x200]{1to16},0x7b' );
  TestCase.testcase(7063, [$62,$63,$15,$50,$03,$72,$80,$7B                   ] , 'valignd  zmm30,zmm29,dword [rdx-0x200]{1to16},0x7b' );
  TestCase.testcase(7064, [$62,$63,$15,$50,$03,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'valignd  zmm30,zmm29,dword [rdx-0x204]{1to16},0x7b' );
  TestCase.testcase(7065, [$62,$02,$95,$40,$65,$F4                           ] , 'vblendmpd  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(7066, [$62,$02,$95,$47,$65,$F4                           ] , 'vblendmpd  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(7067, [$62,$02,$95,$C7,$65,$F4                           ] , 'vblendmpd  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(7068, [$62,$62,$95,$40,$65,$31                           ] , 'vblendmpd  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(7069, [$62,$22,$95,$40,$65,$B4,$F0,$34,$12,$00,$00       ] , 'vblendmpd  zmm30,zmm29,zword [rax+r14*8+0x1234]'  );
  TestCase.testcase(7070, [$62,$62,$95,$50,$65,$31                           ] , 'vblendmpd  zmm30,zmm29,qword [rcx]{1to8}'         );
  TestCase.testcase(7071, [$62,$62,$95,$40,$65,$72,$7F                       ] , 'vblendmpd  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(7072, [$62,$62,$95,$40,$65,$B2,$00,$20,$00,$00           ] , 'vblendmpd  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(7073, [$62,$62,$95,$40,$65,$72,$80                       ] , 'vblendmpd  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(7074, [$62,$62,$95,$40,$65,$B2,$C0,$DF,$FF,$FF           ] , 'vblendmpd  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(7075, [$62,$62,$95,$50,$65,$72,$7F                       ] , 'vblendmpd  zmm30,zmm29,qword [rdx+0x3f8]{1to8}'   );
  TestCase.testcase(7076, [$62,$62,$95,$50,$65,$B2,$00,$04,$00,$00           ] , 'vblendmpd  zmm30,zmm29,qword [rdx+0x400]{1to8}'   );
  TestCase.testcase(7077, [$62,$62,$95,$50,$65,$72,$80                       ] , 'vblendmpd  zmm30,zmm29,qword [rdx-0x400]{1to8}'   );
  TestCase.testcase(7078, [$62,$62,$95,$50,$65,$B2,$F8,$FB,$FF,$FF           ] , 'vblendmpd  zmm30,zmm29,qword [rdx-0x408]{1to8}'   );
  TestCase.testcase(7079, [$62,$02,$15,$40,$65,$F4                           ] , 'vblendmps  zmm30,zmm29,zmm28'                     );
  TestCase.testcase(7080, [$62,$02,$15,$47,$65,$F4                           ] , 'vblendmps  zmm30{k7},zmm29,zmm28'                 );
  TestCase.testcase(7081, [$62,$02,$15,$C7,$65,$F4                           ] , 'vblendmps  zmm30{k7}{z},zmm29,zmm28'              );
  TestCase.testcase(7082, [$62,$62,$15,$40,$65,$31                           ] , 'vblendmps  zmm30,zmm29,zword [rcx]'               );
  TestCase.testcase(7083, [$62,$22,$15,$40,$65,$B4,$F0,$34,$12,$00,$00       ] , 'vblendmps  zmm30,zmm29,zword [rax+r14*8+0x1234]'  );
  TestCase.testcase(7084, [$62,$62,$15,$50,$65,$31                           ] , 'vblendmps  zmm30,zmm29,dword [rcx]{1to16}'        );
  TestCase.testcase(7085, [$62,$62,$15,$40,$65,$72,$7F                       ] , 'vblendmps  zmm30,zmm29,zword [rdx+0x1fc0]'        );
  TestCase.testcase(7086, [$62,$62,$15,$40,$65,$B2,$00,$20,$00,$00           ] , 'vblendmps  zmm30,zmm29,zword [rdx+0x2000]'        );
  TestCase.testcase(7087, [$62,$62,$15,$40,$65,$72,$80                       ] , 'vblendmps  zmm30,zmm29,zword [rdx-0x2000]'        );
  TestCase.testcase(7088, [$62,$62,$15,$40,$65,$B2,$C0,$DF,$FF,$FF           ] , 'vblendmps  zmm30,zmm29,zword [rdx-0x2040]'        );
  TestCase.testcase(7089, [$62,$62,$15,$50,$65,$72,$7F                       ] , 'vblendmps  zmm30,zmm29,dword [rdx+0x1fc]{1to16}'  );
  TestCase.testcase(7090, [$62,$62,$15,$50,$65,$B2,$00,$02,$00,$00           ] , 'vblendmps  zmm30,zmm29,dword [rdx+0x200]{1to16}'  );
  TestCase.testcase(7091, [$62,$62,$15,$50,$65,$72,$80                       ] , 'vblendmps  zmm30,zmm29,dword [rdx-0x200]{1to16}'  );
  TestCase.testcase(7092, [$62,$62,$15,$50,$65,$B2,$FC,$FD,$FF,$FF           ] , 'vblendmps  zmm30,zmm29,dword [rdx-0x204]{1to16}'  );
  TestCase.testcase(7093, [$62,$62,$7D,$48,$1A,$31                           ] , 'vbroadcastf32x4  zmm30,oword [rcx]'               );
  TestCase.testcase(7094, [$62,$62,$7D,$4F,$1A,$31                           ] , 'vbroadcastf32x4  zmm30{k7},oword [rcx]'           );
  TestCase.testcase(7095, [$62,$62,$7D,$CF,$1A,$31                           ] , 'vbroadcastf32x4  zmm30{k7}{z},oword [rcx]'        );
  TestCase.testcase(7096, [$62,$22,$7D,$48,$1A,$B4,$F0,$34,$12,$00,$00       ] , 'vbroadcastf32x4  zmm30,oword [rax+r14*8+0x1234]'  );
  TestCase.testcase(7097, [$62,$62,$7D,$48,$1A,$72,$7F                       ] , 'vbroadcastf32x4  zmm30,oword [rdx+0x7f0]'         );
  TestCase.testcase(7098, [$62,$62,$7D,$48,$1A,$B2,$00,$08,$00,$00           ] , 'vbroadcastf32x4  zmm30,oword [rdx+0x800]'         );
  TestCase.testcase(7099, [$62,$62,$7D,$48,$1A,$72,$80                       ] , 'vbroadcastf32x4  zmm30,oword [rdx-0x800]'         );
  TestCase.testcase(7100, [$62,$62,$7D,$48,$1A,$B2,$F0,$F7,$FF,$FF           ] , 'vbroadcastf32x4  zmm30,oword [rdx-0x810]'         );
  TestCase.testcase(7101, [$62,$62,$FD,$48,$1B,$31                           ] , 'vbroadcastf64x4  zmm30,yword [rcx]'               );
  TestCase.testcase(7102, [$62,$62,$FD,$4F,$1B,$31                           ] , 'vbroadcastf64x4  zmm30{k7},yword [rcx]'           );
  TestCase.testcase(7103, [$62,$62,$FD,$CF,$1B,$31                           ] , 'vbroadcastf64x4  zmm30{k7}{z},yword [rcx]'        );
  TestCase.testcase(7104, [$62,$22,$FD,$48,$1B,$B4,$F0,$34,$12,$00,$00       ] , 'vbroadcastf64x4  zmm30,yword [rax+r14*8+0x1234]'  );
  TestCase.testcase(7105, [$62,$62,$FD,$48,$1B,$72,$7F                       ] , 'vbroadcastf64x4  zmm30,yword [rdx+0xfe0]'         );
  TestCase.testcase(7106, [$62,$62,$FD,$48,$1B,$B2,$00,$10,$00,$00           ] , 'vbroadcastf64x4  zmm30,yword [rdx+0x1000]'        );
  TestCase.testcase(7107, [$62,$62,$FD,$48,$1B,$72,$80                       ] , 'vbroadcastf64x4  zmm30,yword [rdx-0x1000]'        );
  TestCase.testcase(7108, [$62,$62,$FD,$48,$1B,$B2,$E0,$EF,$FF,$FF           ] , 'vbroadcastf64x4  zmm30,yword [rdx-0x1020]'        );
  TestCase.testcase(7109, [$62,$62,$7D,$48,$5A,$31                           ] , 'vbroadcasti32x4  zmm30,oword [rcx]'               );
  TestCase.testcase(7110, [$62,$62,$7D,$4F,$5A,$31                           ] , 'vbroadcasti32x4  zmm30{k7},oword [rcx]'           );
  TestCase.testcase(7111, [$62,$62,$7D,$CF,$5A,$31                           ] , 'vbroadcasti32x4  zmm30{k7}{z},oword [rcx]'        );
  TestCase.testcase(7112, [$62,$22,$7D,$48,$5A,$B4,$F0,$34,$12,$00,$00       ] , 'vbroadcasti32x4  zmm30,oword [rax+r14*8+0x1234]'  );
  TestCase.testcase(7113, [$62,$62,$7D,$48,$5A,$72,$7F                       ] , 'vbroadcasti32x4  zmm30,oword [rdx+0x7f0]'         );
  TestCase.testcase(7114, [$62,$62,$7D,$48,$5A,$B2,$00,$08,$00,$00           ] , 'vbroadcasti32x4  zmm30,oword [rdx+0x800]'         );
  TestCase.testcase(7115, [$62,$62,$7D,$48,$5A,$72,$80                       ] , 'vbroadcasti32x4  zmm30,oword [rdx-0x800]'         );
  TestCase.testcase(7116, [$62,$62,$7D,$48,$5A,$B2,$F0,$F7,$FF,$FF           ] , 'vbroadcasti32x4  zmm30,oword [rdx-0x810]'         );
  TestCase.testcase(7117, [$62,$62,$FD,$48,$5B,$31                           ] , 'vbroadcasti64x4  zmm30,yword [rcx]'               );
  TestCase.testcase(7118, [$62,$62,$FD,$4F,$5B,$31                           ] , 'vbroadcasti64x4  zmm30{k7},yword [rcx]'           );
  TestCase.testcase(7119, [$62,$62,$FD,$CF,$5B,$31                           ] , 'vbroadcasti64x4  zmm30{k7}{z},yword [rcx]'        );
  TestCase.testcase(7120, [$62,$22,$FD,$48,$5B,$B4,$F0,$34,$12,$00,$00       ] , 'vbroadcasti64x4  zmm30,yword [rax+r14*8+0x1234]'  );
  TestCase.testcase(7121, [$62,$62,$FD,$48,$5B,$72,$7F                       ] , 'vbroadcasti64x4  zmm30,yword [rdx+0xfe0]'         );
  TestCase.testcase(7122, [$62,$62,$FD,$48,$5B,$B2,$00,$10,$00,$00           ] , 'vbroadcasti64x4  zmm30,yword [rdx+0x1000]'        );
  TestCase.testcase(7123, [$62,$62,$FD,$48,$5B,$72,$80                       ] , 'vbroadcasti64x4  zmm30,yword [rdx-0x1000]'        );
  TestCase.testcase(7124, [$62,$62,$FD,$48,$5B,$B2,$E0,$EF,$FF,$FF           ] , 'vbroadcasti64x4  zmm30,yword [rdx-0x1020]'        );
  TestCase.testcase(7125, [$62,$62,$FD,$48,$19,$31                           ] , 'vbroadcastsd  zmm30,qword [rcx]'                  );
  TestCase.testcase(7126, [$62,$62,$FD,$4F,$19,$31                           ] , 'vbroadcastsd  zmm30{k7},qword [rcx]'              );
  TestCase.testcase(7127, [$62,$62,$FD,$CF,$19,$31                           ] , 'vbroadcastsd  zmm30{k7}{z},qword [rcx]'           );
  TestCase.testcase(7128, [$62,$22,$FD,$48,$19,$B4,$F0,$34,$12,$00,$00       ] , 'vbroadcastsd  zmm30,qword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7129, [$62,$62,$FD,$48,$19,$72,$7F                       ] , 'vbroadcastsd  zmm30,qword [rdx+0x3f8]'            );
  TestCase.testcase(7130, [$62,$62,$FD,$48,$19,$B2,$00,$04,$00,$00           ] , 'vbroadcastsd  zmm30,qword [rdx+0x400]'            );
  TestCase.testcase(7131, [$62,$62,$FD,$48,$19,$72,$80                       ] , 'vbroadcastsd  zmm30,qword [rdx-0x400]'            );
  TestCase.testcase(7132, [$62,$62,$FD,$48,$19,$B2,$F8,$FB,$FF,$FF           ] , 'vbroadcastsd  zmm30,qword [rdx-0x408]'            );
  TestCase.testcase(7133, [$62,$02,$FD,$4F,$19,$F5                           ] , 'vbroadcastsd  zmm30{k7},xmm29'                    );
  TestCase.testcase(7134, [$62,$02,$FD,$CF,$19,$F5                           ] , 'vbroadcastsd  zmm30{k7}{z},xmm29'                 );
  TestCase.testcase(7135, [$62,$62,$7D,$48,$18,$31                           ] , 'vbroadcastss  zmm30,dword [rcx]'                  );
  TestCase.testcase(7136, [$62,$62,$7D,$4F,$18,$31                           ] , 'vbroadcastss  zmm30{k7},dword [rcx]'              );
  TestCase.testcase(7137, [$62,$62,$7D,$CF,$18,$31                           ] , 'vbroadcastss  zmm30{k7}{z},dword [rcx]'           );
  TestCase.testcase(7138, [$62,$22,$7D,$48,$18,$B4,$F0,$34,$12,$00,$00       ] , 'vbroadcastss  zmm30,dword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7139, [$62,$62,$7D,$48,$18,$72,$7F                       ] , 'vbroadcastss  zmm30,dword [rdx+0x1fc]'            );
  TestCase.testcase(7140, [$62,$62,$7D,$48,$18,$B2,$00,$02,$00,$00           ] , 'vbroadcastss  zmm30,dword [rdx+0x200]'            );
  TestCase.testcase(7141, [$62,$62,$7D,$48,$18,$72,$80                       ] , 'vbroadcastss  zmm30,dword [rdx-0x200]'            );
  TestCase.testcase(7142, [$62,$62,$7D,$48,$18,$B2,$FC,$FD,$FF,$FF           ] , 'vbroadcastss  zmm30,dword [rdx-0x204]'            );
  TestCase.testcase(7143, [$62,$02,$7D,$4F,$18,$F5                           ] , 'vbroadcastss  zmm30{k7},xmm29'                    );
  TestCase.testcase(7144, [$62,$02,$7D,$CF,$18,$F5                           ] , 'vbroadcastss  zmm30{k7}{z},xmm29'                 );
  TestCase.testcase(7145, [$62,$91,$8D,$40,$C2,$ED,$AB                       ] , 'vcmppd  k5,zmm30,zmm29,0xab'                      );
  TestCase.testcase(7146, [$62,$91,$8D,$47,$C2,$ED,$AB                       ] , 'vcmppd  k5{k7},zmm30,zmm29,0xab'                  );
  TestCase.testcase(7147, [$62,$91,$8D,$10,$C2,$ED,$AB                       ] , 'vcmppd  k5,zmm30,zmm29,{sae},0xab'                );
  TestCase.testcase(7148, [$62,$91,$8D,$40,$C2,$ED,$7B                       ] , 'vcmppd  k5,zmm30,zmm29,0x7b'                      );
  TestCase.testcase(7149, [$62,$91,$8D,$10,$C2,$ED,$7B                       ] , 'vcmppd  k5,zmm30,zmm29,{sae},0x7b'                );
  TestCase.testcase(7150, [$62,$F1,$8D,$40,$C2,$29,$7B                       ] , 'vcmppd  k5,zmm30,zword [rcx],0x7b'                );
  TestCase.testcase(7151, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$7B   ] , 'vcmppd  k5,zmm30,zword [rax+r14*8+0x1234],0x7b'   );
  TestCase.testcase(7152, [$62,$F1,$8D,$50,$C2,$29,$7B                       ] , 'vcmppd  k5,zmm30,qword [rcx]{1to8},0x7b'          );
  TestCase.testcase(7153, [$62,$F1,$8D,$40,$C2,$6A,$7F,$7B                   ] , 'vcmppd  k5,zmm30,zword [rdx+0x1fc0],0x7b'         );
  TestCase.testcase(7154, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$7B       ] , 'vcmppd  k5,zmm30,zword [rdx+0x2000],0x7b'         );
  TestCase.testcase(7155, [$62,$F1,$8D,$40,$C2,$6A,$80,$7B                   ] , 'vcmppd  k5,zmm30,zword [rdx-0x2000],0x7b'         );
  TestCase.testcase(7156, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$7B       ] , 'vcmppd  k5,zmm30,zword [rdx-0x2040],0x7b'         );
  TestCase.testcase(7157, [$62,$F1,$8D,$50,$C2,$6A,$7F,$7B                   ] , 'vcmppd  k5,zmm30,qword [rdx+0x3f8]{1to8},0x7b'    );
  TestCase.testcase(7158, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$7B       ] , 'vcmppd  k5,zmm30,qword [rdx+0x400]{1to8},0x7b'    );
  TestCase.testcase(7159, [$62,$F1,$8D,$50,$C2,$6A,$80,$7B                   ] , 'vcmppd  k5,zmm30,qword [rdx-0x400]{1to8},0x7b'    );
  TestCase.testcase(7160, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vcmppd  k5,zmm30,qword [rdx-0x408]{1to8},0x7b'    );
  TestCase.testcase(7161, [$62,$91,$8D,$40,$C2,$ED,$00                       ] , 'vcmpeqpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(7162, [$62,$91,$8D,$47,$C2,$ED,$00                       ] , 'vcmpeqpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(7163, [$62,$91,$8D,$10,$C2,$ED,$00                       ] , 'vcmpeqpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(7164, [$62,$F1,$8D,$40,$C2,$29,$00                       ] , 'vcmpeqpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(7165, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$00   ] , 'vcmpeqpd  k5,zmm30,zword [rax+r14*8+0x1234]'      );
  TestCase.testcase(7166, [$62,$F1,$8D,$50,$C2,$29,$00                       ] , 'vcmpeqpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(7167, [$62,$F1,$8D,$40,$C2,$6A,$7F,$00                   ] , 'vcmpeqpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(7168, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$00       ] , 'vcmpeqpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(7169, [$62,$F1,$8D,$40,$C2,$6A,$80,$00                   ] , 'vcmpeqpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(7170, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$00       ] , 'vcmpeqpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(7171, [$62,$F1,$8D,$50,$C2,$6A,$7F,$00                   ] , 'vcmpeqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(7172, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(7173, [$62,$F1,$8D,$50,$C2,$6A,$80,$00                   ] , 'vcmpeqpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(7174, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(7175, [$62,$91,$8D,$40,$C2,$ED,$00                       ] , 'vcmpeqpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(7176, [$62,$91,$8D,$47,$C2,$ED,$00                       ] , 'vcmpeqpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(7177, [$62,$91,$8D,$10,$C2,$ED,$00                       ] , 'vcmpeqpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(7178, [$62,$F1,$8D,$40,$C2,$29,$00                       ] , 'vcmpeqpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(7179, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$00   ] , 'vcmpeqpd  k5,zmm30,zword [rax+r14*8+0x1234]'      );
  TestCase.testcase(7180, [$62,$F1,$8D,$50,$C2,$29,$00                       ] , 'vcmpeqpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(7181, [$62,$F1,$8D,$40,$C2,$6A,$7F,$00                   ] , 'vcmpeqpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(7182, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$00       ] , 'vcmpeqpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(7183, [$62,$F1,$8D,$40,$C2,$6A,$80,$00                   ] , 'vcmpeqpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(7184, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$00       ] , 'vcmpeqpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(7185, [$62,$F1,$8D,$50,$C2,$6A,$7F,$00                   ] , 'vcmpeqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(7186, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(7187, [$62,$F1,$8D,$50,$C2,$6A,$80,$00                   ] , 'vcmpeqpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(7188, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(7189, [$62,$91,$8D,$40,$C2,$ED,$01                       ] , 'vcmpltpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(7190, [$62,$91,$8D,$47,$C2,$ED,$01                       ] , 'vcmpltpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(7191, [$62,$91,$8D,$10,$C2,$ED,$01                       ] , 'vcmpltpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(7192, [$62,$F1,$8D,$40,$C2,$29,$01                       ] , 'vcmpltpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(7193, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$01   ] , 'vcmpltpd  k5,zmm30,zword [rax+r14*8+0x1234]'      );
  TestCase.testcase(7194, [$62,$F1,$8D,$50,$C2,$29,$01                       ] , 'vcmpltpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(7195, [$62,$F1,$8D,$40,$C2,$6A,$7F,$01                   ] , 'vcmpltpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(7196, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$01       ] , 'vcmpltpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(7197, [$62,$F1,$8D,$40,$C2,$6A,$80,$01                   ] , 'vcmpltpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(7198, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vcmpltpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(7199, [$62,$F1,$8D,$50,$C2,$6A,$7F,$01                   ] , 'vcmpltpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(7200, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(7201, [$62,$F1,$8D,$50,$C2,$6A,$80,$01                   ] , 'vcmpltpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(7202, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(7203, [$62,$91,$8D,$40,$C2,$ED,$01                       ] , 'vcmpltpd  k5,zmm30,zmm29'                         );
  TestCase.testcase(7204, [$62,$91,$8D,$47,$C2,$ED,$01                       ] , 'vcmpltpd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(7205, [$62,$91,$8D,$10,$C2,$ED,$01                       ] , 'vcmpltpd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(7206, [$62,$F1,$8D,$40,$C2,$29,$01                       ] , 'vcmpltpd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(7207, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$01   ] , 'vcmpltpd  k5,zmm30,zword [rax+r14*8+0x1234]'      );
  TestCase.testcase(7208, [$62,$F1,$8D,$50,$C2,$29,$01                       ] , 'vcmpltpd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(7209, [$62,$F1,$8D,$40,$C2,$6A,$7F,$01                   ] , 'vcmpltpd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(7210, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$01       ] , 'vcmpltpd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(7211, [$62,$F1,$8D,$40,$C2,$6A,$80,$01                   ] , 'vcmpltpd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(7212, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$01       ] , 'vcmpltpd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(7213, [$62,$F1,$8D,$50,$C2,$6A,$7F,$01                   ] , 'vcmpltpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(7214, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltpd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(7215, [$62,$F1,$8D,$50,$C2,$6A,$80,$01                   ] , 'vcmpltpd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(7216, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltpd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(7217, [$62,$91,$8D,$40,$C2,$ED,$02                       ] , 'vcmplepd  k5,zmm30,zmm29'                         );
  TestCase.testcase(7218, [$62,$91,$8D,$47,$C2,$ED,$02                       ] , 'vcmplepd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(7219, [$62,$91,$8D,$10,$C2,$ED,$02                       ] , 'vcmplepd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(7220, [$62,$F1,$8D,$40,$C2,$29,$02                       ] , 'vcmplepd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(7221, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$02   ] , 'vcmplepd  k5,zmm30,zword [rax+r14*8+0x1234]'      );
  TestCase.testcase(7222, [$62,$F1,$8D,$50,$C2,$29,$02                       ] , 'vcmplepd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(7223, [$62,$F1,$8D,$40,$C2,$6A,$7F,$02                   ] , 'vcmplepd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(7224, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$02       ] , 'vcmplepd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(7225, [$62,$F1,$8D,$40,$C2,$6A,$80,$02                   ] , 'vcmplepd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(7226, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vcmplepd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(7227, [$62,$F1,$8D,$50,$C2,$6A,$7F,$02                   ] , 'vcmplepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(7228, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplepd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(7229, [$62,$F1,$8D,$50,$C2,$6A,$80,$02                   ] , 'vcmplepd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(7230, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplepd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(7231, [$62,$91,$8D,$40,$C2,$ED,$02                       ] , 'vcmplepd  k5,zmm30,zmm29'                         );
  TestCase.testcase(7232, [$62,$91,$8D,$47,$C2,$ED,$02                       ] , 'vcmplepd  k5{k7},zmm30,zmm29'                     );
  TestCase.testcase(7233, [$62,$91,$8D,$10,$C2,$ED,$02                       ] , 'vcmplepd  k5,zmm30,zmm29,{sae}'                   );
  TestCase.testcase(7234, [$62,$F1,$8D,$40,$C2,$29,$02                       ] , 'vcmplepd  k5,zmm30,zword [rcx]'                   );
  TestCase.testcase(7235, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$02   ] , 'vcmplepd  k5,zmm30,zword [rax+r14*8+0x1234]'      );
  TestCase.testcase(7236, [$62,$F1,$8D,$50,$C2,$29,$02                       ] , 'vcmplepd  k5,zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(7237, [$62,$F1,$8D,$40,$C2,$6A,$7F,$02                   ] , 'vcmplepd  k5,zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(7238, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$02       ] , 'vcmplepd  k5,zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(7239, [$62,$F1,$8D,$40,$C2,$6A,$80,$02                   ] , 'vcmplepd  k5,zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(7240, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$02       ] , 'vcmplepd  k5,zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(7241, [$62,$F1,$8D,$50,$C2,$6A,$7F,$02                   ] , 'vcmplepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(7242, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplepd  k5,zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(7243, [$62,$F1,$8D,$50,$C2,$6A,$80,$02                   ] , 'vcmplepd  k5,zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(7244, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplepd  k5,zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(7245, [$62,$91,$8D,$40,$C2,$ED,$03                       ] , 'vcmpunordpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(7246, [$62,$91,$8D,$47,$C2,$ED,$03                       ] , 'vcmpunordpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(7247, [$62,$91,$8D,$10,$C2,$ED,$03                       ] , 'vcmpunordpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(7248, [$62,$F1,$8D,$40,$C2,$29,$03                       ] , 'vcmpunordpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(7249, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$03   ] , 'vcmpunordpd  k5,zmm30,zword [rax+r14*8+0x1234]'   );
  TestCase.testcase(7250, [$62,$F1,$8D,$50,$C2,$29,$03                       ] , 'vcmpunordpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(7251, [$62,$F1,$8D,$40,$C2,$6A,$7F,$03                   ] , 'vcmpunordpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(7252, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$03       ] , 'vcmpunordpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(7253, [$62,$F1,$8D,$40,$C2,$6A,$80,$03                   ] , 'vcmpunordpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(7254, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$03       ] , 'vcmpunordpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(7255, [$62,$F1,$8D,$50,$C2,$6A,$7F,$03                   ] , 'vcmpunordpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(7256, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(7257, [$62,$F1,$8D,$50,$C2,$6A,$80,$03                   ] , 'vcmpunordpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(7258, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(7259, [$62,$91,$8D,$40,$C2,$ED,$03                       ] , 'vcmpunordpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(7260, [$62,$91,$8D,$47,$C2,$ED,$03                       ] , 'vcmpunordpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(7261, [$62,$91,$8D,$10,$C2,$ED,$03                       ] , 'vcmpunordpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(7262, [$62,$F1,$8D,$40,$C2,$29,$03                       ] , 'vcmpunordpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(7263, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$03   ] , 'vcmpunordpd  k5,zmm30,zword [rax+r14*8+0x1234]'   );
  TestCase.testcase(7264, [$62,$F1,$8D,$50,$C2,$29,$03                       ] , 'vcmpunordpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(7265, [$62,$F1,$8D,$40,$C2,$6A,$7F,$03                   ] , 'vcmpunordpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(7266, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$03       ] , 'vcmpunordpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(7267, [$62,$F1,$8D,$40,$C2,$6A,$80,$03                   ] , 'vcmpunordpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(7268, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$03       ] , 'vcmpunordpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(7269, [$62,$F1,$8D,$50,$C2,$6A,$7F,$03                   ] , 'vcmpunordpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(7270, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(7271, [$62,$F1,$8D,$50,$C2,$6A,$80,$03                   ] , 'vcmpunordpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(7272, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(7273, [$62,$91,$8D,$40,$C2,$ED,$04                       ] , 'vcmpneqpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7274, [$62,$91,$8D,$47,$C2,$ED,$04                       ] , 'vcmpneqpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7275, [$62,$91,$8D,$10,$C2,$ED,$04                       ] , 'vcmpneqpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7276, [$62,$F1,$8D,$40,$C2,$29,$04                       ] , 'vcmpneqpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7277, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$04   ] , 'vcmpneqpd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7278, [$62,$F1,$8D,$50,$C2,$29,$04                       ] , 'vcmpneqpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7279, [$62,$F1,$8D,$40,$C2,$6A,$7F,$04                   ] , 'vcmpneqpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7280, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$04       ] , 'vcmpneqpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(7281, [$62,$F1,$8D,$40,$C2,$6A,$80,$04                   ] , 'vcmpneqpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(7282, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vcmpneqpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(7283, [$62,$F1,$8D,$50,$C2,$6A,$7F,$04                   ] , 'vcmpneqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7284, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7285, [$62,$F1,$8D,$50,$C2,$6A,$80,$04                   ] , 'vcmpneqpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7286, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7287, [$62,$91,$8D,$40,$C2,$ED,$04                       ] , 'vcmpneqpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7288, [$62,$91,$8D,$47,$C2,$ED,$04                       ] , 'vcmpneqpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7289, [$62,$91,$8D,$10,$C2,$ED,$04                       ] , 'vcmpneqpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7290, [$62,$F1,$8D,$40,$C2,$29,$04                       ] , 'vcmpneqpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7291, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$04   ] , 'vcmpneqpd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7292, [$62,$F1,$8D,$50,$C2,$29,$04                       ] , 'vcmpneqpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7293, [$62,$F1,$8D,$40,$C2,$6A,$7F,$04                   ] , 'vcmpneqpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7294, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$04       ] , 'vcmpneqpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(7295, [$62,$F1,$8D,$40,$C2,$6A,$80,$04                   ] , 'vcmpneqpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(7296, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$04       ] , 'vcmpneqpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(7297, [$62,$F1,$8D,$50,$C2,$6A,$7F,$04                   ] , 'vcmpneqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7298, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7299, [$62,$F1,$8D,$50,$C2,$6A,$80,$04                   ] , 'vcmpneqpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7300, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7301, [$62,$91,$8D,$40,$C2,$ED,$05                       ] , 'vcmpnltpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7302, [$62,$91,$8D,$47,$C2,$ED,$05                       ] , 'vcmpnltpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7303, [$62,$91,$8D,$10,$C2,$ED,$05                       ] , 'vcmpnltpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7304, [$62,$F1,$8D,$40,$C2,$29,$05                       ] , 'vcmpnltpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7305, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$05   ] , 'vcmpnltpd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7306, [$62,$F1,$8D,$50,$C2,$29,$05                       ] , 'vcmpnltpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7307, [$62,$F1,$8D,$40,$C2,$6A,$7F,$05                   ] , 'vcmpnltpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7308, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$05       ] , 'vcmpnltpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(7309, [$62,$F1,$8D,$40,$C2,$6A,$80,$05                   ] , 'vcmpnltpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(7310, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vcmpnltpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(7311, [$62,$F1,$8D,$50,$C2,$6A,$7F,$05                   ] , 'vcmpnltpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7312, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7313, [$62,$F1,$8D,$50,$C2,$6A,$80,$05                   ] , 'vcmpnltpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7314, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7315, [$62,$91,$8D,$40,$C2,$ED,$05                       ] , 'vcmpnltpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7316, [$62,$91,$8D,$47,$C2,$ED,$05                       ] , 'vcmpnltpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7317, [$62,$91,$8D,$10,$C2,$ED,$05                       ] , 'vcmpnltpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7318, [$62,$F1,$8D,$40,$C2,$29,$05                       ] , 'vcmpnltpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7319, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$05   ] , 'vcmpnltpd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7320, [$62,$F1,$8D,$50,$C2,$29,$05                       ] , 'vcmpnltpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7321, [$62,$F1,$8D,$40,$C2,$6A,$7F,$05                   ] , 'vcmpnltpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7322, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$05       ] , 'vcmpnltpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(7323, [$62,$F1,$8D,$40,$C2,$6A,$80,$05                   ] , 'vcmpnltpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(7324, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$05       ] , 'vcmpnltpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(7325, [$62,$F1,$8D,$50,$C2,$6A,$7F,$05                   ] , 'vcmpnltpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7326, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7327, [$62,$F1,$8D,$50,$C2,$6A,$80,$05                   ] , 'vcmpnltpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7328, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7329, [$62,$91,$8D,$40,$C2,$ED,$06                       ] , 'vcmpnlepd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7330, [$62,$91,$8D,$47,$C2,$ED,$06                       ] , 'vcmpnlepd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7331, [$62,$91,$8D,$10,$C2,$ED,$06                       ] , 'vcmpnlepd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7332, [$62,$F1,$8D,$40,$C2,$29,$06                       ] , 'vcmpnlepd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7333, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$06   ] , 'vcmpnlepd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7334, [$62,$F1,$8D,$50,$C2,$29,$06                       ] , 'vcmpnlepd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7335, [$62,$F1,$8D,$40,$C2,$6A,$7F,$06                   ] , 'vcmpnlepd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7336, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$06       ] , 'vcmpnlepd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(7337, [$62,$F1,$8D,$40,$C2,$6A,$80,$06                   ] , 'vcmpnlepd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(7338, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vcmpnlepd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(7339, [$62,$F1,$8D,$50,$C2,$6A,$7F,$06                   ] , 'vcmpnlepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7340, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlepd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7341, [$62,$F1,$8D,$50,$C2,$6A,$80,$06                   ] , 'vcmpnlepd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7342, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlepd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7343, [$62,$91,$8D,$40,$C2,$ED,$06                       ] , 'vcmpnlepd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7344, [$62,$91,$8D,$47,$C2,$ED,$06                       ] , 'vcmpnlepd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7345, [$62,$91,$8D,$10,$C2,$ED,$06                       ] , 'vcmpnlepd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7346, [$62,$F1,$8D,$40,$C2,$29,$06                       ] , 'vcmpnlepd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7347, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$06   ] , 'vcmpnlepd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7348, [$62,$F1,$8D,$50,$C2,$29,$06                       ] , 'vcmpnlepd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7349, [$62,$F1,$8D,$40,$C2,$6A,$7F,$06                   ] , 'vcmpnlepd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7350, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$06       ] , 'vcmpnlepd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(7351, [$62,$F1,$8D,$40,$C2,$6A,$80,$06                   ] , 'vcmpnlepd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(7352, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$06       ] , 'vcmpnlepd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(7353, [$62,$F1,$8D,$50,$C2,$6A,$7F,$06                   ] , 'vcmpnlepd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7354, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlepd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7355, [$62,$F1,$8D,$50,$C2,$6A,$80,$06                   ] , 'vcmpnlepd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7356, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlepd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7357, [$62,$91,$8D,$40,$C2,$ED,$07                       ] , 'vcmpordpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7358, [$62,$91,$8D,$47,$C2,$ED,$07                       ] , 'vcmpordpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7359, [$62,$91,$8D,$10,$C2,$ED,$07                       ] , 'vcmpordpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7360, [$62,$F1,$8D,$40,$C2,$29,$07                       ] , 'vcmpordpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7361, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$07   ] , 'vcmpordpd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7362, [$62,$F1,$8D,$50,$C2,$29,$07                       ] , 'vcmpordpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7363, [$62,$F1,$8D,$40,$C2,$6A,$7F,$07                   ] , 'vcmpordpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7364, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$07       ] , 'vcmpordpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(7365, [$62,$F1,$8D,$40,$C2,$6A,$80,$07                   ] , 'vcmpordpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(7366, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$07       ] , 'vcmpordpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(7367, [$62,$F1,$8D,$50,$C2,$6A,$7F,$07                   ] , 'vcmpordpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7368, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7369, [$62,$F1,$8D,$50,$C2,$6A,$80,$07                   ] , 'vcmpordpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7370, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7371, [$62,$91,$8D,$40,$C2,$ED,$07                       ] , 'vcmpordpd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7372, [$62,$91,$8D,$47,$C2,$ED,$07                       ] , 'vcmpordpd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7373, [$62,$91,$8D,$10,$C2,$ED,$07                       ] , 'vcmpordpd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7374, [$62,$F1,$8D,$40,$C2,$29,$07                       ] , 'vcmpordpd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7375, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$07   ] , 'vcmpordpd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7376, [$62,$F1,$8D,$50,$C2,$29,$07                       ] , 'vcmpordpd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7377, [$62,$F1,$8D,$40,$C2,$6A,$7F,$07                   ] , 'vcmpordpd  k5,zmm30,zword [rdx+0x1fc0]'           );
  TestCase.testcase(7378, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$07       ] , 'vcmpordpd  k5,zmm30,zword [rdx+0x2000]'           );
  TestCase.testcase(7379, [$62,$F1,$8D,$40,$C2,$6A,$80,$07                   ] , 'vcmpordpd  k5,zmm30,zword [rdx-0x2000]'           );
  TestCase.testcase(7380, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$07       ] , 'vcmpordpd  k5,zmm30,zword [rdx-0x2040]'           );
  TestCase.testcase(7381, [$62,$F1,$8D,$50,$C2,$6A,$7F,$07                   ] , 'vcmpordpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(7382, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordpd  k5,zmm30,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(7383, [$62,$F1,$8D,$50,$C2,$6A,$80,$07                   ] , 'vcmpordpd  k5,zmm30,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(7384, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordpd  k5,zmm30,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(7385, [$62,$91,$8D,$40,$C2,$ED,$08                       ] , 'vcmpeq_uqpd  k5,zmm30,zmm29'                      );
  TestCase.testcase(7386, [$62,$91,$8D,$47,$C2,$ED,$08                       ] , 'vcmpeq_uqpd  k5{k7},zmm30,zmm29'                  );
  TestCase.testcase(7387, [$62,$91,$8D,$10,$C2,$ED,$08                       ] , 'vcmpeq_uqpd  k5,zmm30,zmm29,{sae}'                );
  TestCase.testcase(7388, [$62,$F1,$8D,$40,$C2,$29,$08                       ] , 'vcmpeq_uqpd  k5,zmm30,zword [rcx]'                );
  TestCase.testcase(7389, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$08   ] , 'vcmpeq_uqpd  k5,zmm30,zword [rax+r14*8+0x1234]'   );
  TestCase.testcase(7390, [$62,$F1,$8D,$50,$C2,$29,$08                       ] , 'vcmpeq_uqpd  k5,zmm30,qword [rcx]{1to8}'          );
  TestCase.testcase(7391, [$62,$F1,$8D,$40,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqpd  k5,zmm30,zword [rdx+0x1fc0]'         );
  TestCase.testcase(7392, [$62,$F1,$8D,$40,$C2,$AA,$00,$20,$00,$00,$08       ] , 'vcmpeq_uqpd  k5,zmm30,zword [rdx+0x2000]'         );
  TestCase.testcase(7393, [$62,$F1,$8D,$40,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqpd  k5,zmm30,zword [rdx-0x2000]'         );
  TestCase.testcase(7394, [$62,$F1,$8D,$40,$C2,$AA,$C0,$DF,$FF,$FF,$08       ] , 'vcmpeq_uqpd  k5,zmm30,zword [rdx-0x2040]'         );
  TestCase.testcase(7395, [$62,$F1,$8D,$50,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqpd  k5,zmm30,qword [rdx+0x3f8]{1to8}'    );
  TestCase.testcase(7396, [$62,$F1,$8D,$50,$C2,$AA,$00,$04,$00,$00,$08       ] , 'vcmpeq_uqpd  k5,zmm30,qword [rdx+0x400]{1to8}'    );
  TestCase.testcase(7397, [$62,$F1,$8D,$50,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqpd  k5,zmm30,qword [rdx-0x400]{1to8}'    );
  TestCase.testcase(7398, [$62,$F1,$8D,$50,$C2,$AA,$F8,$FB,$FF,$FF,$08       ] , 'vcmpeq_uqpd  k5,zmm30,qword [rdx-0x408]{1to8}'    );
  TestCase.testcase(7399, [$62,$91,$8D,$40,$C2,$ED,$09                       ] , 'vcmpngepd  k5,zmm30,zmm29'                        );
  TestCase.testcase(7400, [$62,$91,$8D,$47,$C2,$ED,$09                       ] , 'vcmpngepd  k5{k7},zmm30,zmm29'                    );
  TestCase.testcase(7401, [$62,$91,$8D,$10,$C2,$ED,$09                       ] , 'vcmpngepd  k5,zmm30,zmm29,{sae}'                  );
  TestCase.testcase(7402, [$62,$F1,$8D,$40,$C2,$29,$09                       ] , 'vcmpngepd  k5,zmm30,zword [rcx]'                  );
  TestCase.testcase(7403, [$62,$B1,$8D,$40,$C2,$AC,$F0,$34,$12,$00,$00,$09   ] , 'vcmpngepd  k5,zmm30,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(7404, [$62,$F1,$8D,$50,$C2,$29,$09                       ] , 'vcmpngepd  k5,zmm30,qword [rcx]{1to8}'            );
  TestCase.testcase(7405, [$62,$F1,$8D,$40,$C2,$6A,$7F,$09                   ] , 'vcmpngepd  k5,zmm30,zword [rdx+0x1fc0]'          