unit x64.avx512cd;

// This unit was generated by d2p.pl script.
// Source : gas/x86-64-avx512cd-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x64.avx512cd');
  TestCase.Start();	
  TestCase.Arch := CPUX64;

  TestCase.testcase(0, [$62,$02,$7D,$48,$C4,$F5                           ] , 'vpconflictd  zmm30,zmm29'                         );
  TestCase.testcase(1, [$62,$02,$7D,$4F,$C4,$F5                           ] , 'vpconflictd  zmm30{k7},zmm29'                     );
  TestCase.testcase(2, [$62,$02,$7D,$CF,$C4,$F5                           ] , 'vpconflictd  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(3, [$62,$62,$7D,$48,$C4,$31                           ] , 'vpconflictd  zmm30,zword [rcx]'                   );
  TestCase.testcase(4, [$62,$22,$7D,$48,$C4,$B4,$F0,$23,$01,$00,$00       ] , 'vpconflictd  zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(5, [$62,$62,$7D,$58,$C4,$31                           ] , 'vpconflictd  zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(6, [$62,$62,$7D,$48,$C4,$72,$7F                       ] , 'vpconflictd  zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(7, [$62,$62,$7D,$48,$C4,$B2,$00,$20,$00,$00           ] , 'vpconflictd  zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(8, [$62,$62,$7D,$48,$C4,$72,$80                       ] , 'vpconflictd  zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(9, [$62,$62,$7D,$48,$C4,$B2,$C0,$DF,$FF,$FF           ] , 'vpconflictd  zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(10, [$62,$62,$7D,$58,$C4,$72,$7F                       ] , 'vpconflictd  zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(11, [$62,$62,$7D,$58,$C4,$B2,$00,$02,$00,$00           ] , 'vpconflictd  zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(12, [$62,$62,$7D,$58,$C4,$72,$80                       ] , 'vpconflictd  zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(13, [$62,$62,$7D,$58,$C4,$B2,$FC,$FD,$FF,$FF           ] , 'vpconflictd  zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(14, [$62,$02,$FD,$48,$C4,$F5                           ] , 'vpconflictq  zmm30,zmm29'                         );
  TestCase.testcase(15, [$62,$02,$FD,$4F,$C4,$F5                           ] , 'vpconflictq  zmm30{k7},zmm29'                     );
  TestCase.testcase(16, [$62,$02,$FD,$CF,$C4,$F5                           ] , 'vpconflictq  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(17, [$62,$62,$FD,$48,$C4,$31                           ] , 'vpconflictq  zmm30,zword [rcx]'                   );
  TestCase.testcase(18, [$62,$22,$FD,$48,$C4,$B4,$F0,$23,$01,$00,$00       ] , 'vpconflictq  zmm30,zword [rax+r14*8+0x123]'       );
  TestCase.testcase(19, [$62,$62,$FD,$58,$C4,$31                           ] , 'vpconflictq  zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(20, [$62,$62,$FD,$48,$C4,$72,$7F                       ] , 'vpconflictq  zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(21, [$62,$62,$FD,$48,$C4,$B2,$00,$20,$00,$00           ] , 'vpconflictq  zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(22, [$62,$62,$FD,$48,$C4,$72,$80                       ] , 'vpconflictq  zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(23, [$62,$62,$FD,$48,$C4,$B2,$C0,$DF,$FF,$FF           ] , 'vpconflictq  zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(24, [$62,$62,$FD,$58,$C4,$72,$7F                       ] , 'vpconflictq  zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(25, [$62,$62,$FD,$58,$C4,$B2,$00,$04,$00,$00           ] , 'vpconflictq  zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(26, [$62,$62,$FD,$58,$C4,$72,$80                       ] , 'vpconflictq  zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(27, [$62,$62,$FD,$58,$C4,$B2,$F8,$FB,$FF,$FF           ] , 'vpconflictq  zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(28, [$62,$02,$7D,$48,$44,$F5                           ] , 'vplzcntd  zmm30,zmm29'                            );
  TestCase.testcase(29, [$62,$02,$7D,$4F,$44,$F5                           ] , 'vplzcntd  zmm30{k7},zmm29'                        );
  TestCase.testcase(30, [$62,$02,$7D,$CF,$44,$F5                           ] , 'vplzcntd  zmm30{k7}{z},zmm29'                     );
  TestCase.testcase(31, [$62,$62,$7D,$48,$44,$31                           ] , 'vplzcntd  zmm30,zword [rcx]'                      );
  TestCase.testcase(32, [$62,$22,$7D,$48,$44,$B4,$F0,$23,$01,$00,$00       ] , 'vplzcntd  zmm30,zword [rax+r14*8+0x123]'          );
  TestCase.testcase(33, [$62,$62,$7D,$58,$44,$31                           ] , 'vplzcntd  zmm30,dword [rcx]{1to16}'               );
  TestCase.testcase(34, [$62,$62,$7D,$48,$44,$72,$7F                       ] , 'vplzcntd  zmm30,zword [rdx+0x1fc0]'               );
  TestCase.testcase(35, [$62,$62,$7D,$48,$44,$B2,$00,$20,$00,$00           ] , 'vplzcntd  zmm30,zword [rdx+0x2000]'               );
  TestCase.testcase(36, [$62,$62,$7D,$48,$44,$72,$80                       ] , 'vplzcntd  zmm30,zword [rdx-0x2000]'               );
  TestCase.testcase(37, [$62,$62,$7D,$48,$44,$B2,$C0,$DF,$FF,$FF           ] , 'vplzcntd  zmm30,zword [rdx-0x2040]'               );
  TestCase.testcase(38, [$62,$62,$7D,$58,$44,$72,$7F                       ] , 'vplzcntd  zmm30,dword [rdx+0x1fc]{1to16}'         );
  TestCase.testcase(39, [$62,$62,$7D,$58,$44,$B2,$00,$02,$00,$00           ] , 'vplzcntd  zmm30,dword [rdx+0x200]{1to16}'         );
  TestCase.testcase(40, [$62,$62,$7D,$58,$44,$72,$80                       ] , 'vplzcntd  zmm30,dword [rdx-0x200]{1to16}'         );
  TestCase.testcase(41, [$62,$62,$7D,$58,$44,$B2,$FC,$FD,$FF,$FF           ] , 'vplzcntd  zmm30,dword [rdx-0x204]{1to16}'         );
  TestCase.testcase(42, [$62,$02,$FD,$48,$44,$F5                           ] , 'vplzcntq  zmm30,zmm29'                            );
  TestCase.testcase(43, [$62,$02,$FD,$4F,$44,$F5                           ] , 'vplzcntq  zmm30{k7},zmm29'                        );
  TestCase.testcase(44, [$62,$02,$FD,$CF,$44,$F5                           ] , 'vplzcntq  zmm30{k7}{z},zmm29'                     );
  TestCase.testcase(45, [$62,$62,$FD,$48,$44,$31                           ] , 'vplzcntq  zmm30,zword [rcx]'                      );
  TestCase.testcase(46, [$62,$22,$FD,$48,$44,$B4,$F0,$23,$01,$00,$00       ] , 'vplzcntq  zmm30,zword [rax+r14*8+0x123]'          );
  TestCase.testcase(47, [$62,$62,$FD,$58,$44,$31                           ] , 'vplzcntq  zmm30,qword [rcx]{1to8}'                );
  TestCase.testcase(48, [$62,$62,$FD,$48,$44,$72,$7F                       ] , 'vplzcntq  zmm30,zword [rdx+0x1fc0]'               );
  TestCase.testcase(49, [$62,$62,$FD,$48,$44,$B2,$00,$20,$00,$00           ] , 'vplzcntq  zmm30,zword [rdx+0x2000]'               );
  TestCase.testcase(50, [$62,$62,$FD,$48,$44,$72,$80                       ] , 'vplzcntq  zmm30,zword [rdx-0x2000]'               );
  TestCase.testcase(51, [$62,$62,$FD,$48,$44,$B2,$C0,$DF,$FF,$FF           ] , 'vplzcntq  zmm30,zword [rdx-0x2040]'               );
  TestCase.testcase(52, [$62,$62,$FD,$58,$44,$72,$7F                       ] , 'vplzcntq  zmm30,qword [rdx+0x3f8]{1to8}'          );
  TestCase.testcase(53, [$62,$62,$FD,$58,$44,$B2,$00,$04,$00,$00           ] , 'vplzcntq  zmm30,qword [rdx+0x400]{1to8}'          );
  TestCase.testcase(54, [$62,$62,$FD,$58,$44,$72,$80                       ] , 'vplzcntq  zmm30,qword [rdx-0x400]{1to8}'          );
  TestCase.testcase(55, [$62,$62,$FD,$58,$44,$B2,$F8,$FB,$FF,$FF           ] , 'vplzcntq  zmm30,qword [rdx-0x408]{1to8}'          );
  TestCase.testcase(56, [$62,$92,$16,$40,$27,$EC                           ] , 'vptestnmd  k5,zmm29,zmm28'                        );
  TestCase.testcase(57, [$62,$92,$16,$47,$27,$EC                           ] , 'vptestnmd  k5{k7},zmm29,zmm28'                    );
  TestCase.testcase(58, [$62,$F2,$16,$40,$27,$29                           ] , 'vptestnmd  k5,zmm29,zword [rcx]'                  );
  TestCase.testcase(59, [$62,$B2,$16,$40,$27,$AC,$F0,$23,$01,$00,$00       ] , 'vptestnmd  k5,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(60, [$62,$F2,$16,$50,$27,$29                           ] , 'vptestnmd  k5,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(61, [$62,$F2,$16,$40,$27,$6A,$7F                       ] , 'vptestnmd  k5,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(62, [$62,$F2,$16,$40,$27,$AA,$00,$20,$00,$00           ] , 'vptestnmd  k5,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(63, [$62,$F2,$16,$40,$27,$6A,$80                       ] , 'vptestnmd  k5,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(64, [$62,$F2,$16,$40,$27,$AA,$C0,$DF,$FF,$FF           ] , 'vptestnmd  k5,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(65, [$62,$F2,$16,$50,$27,$6A,$7F                       ] , 'vptestnmd  k5,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(66, [$62,$F2,$16,$50,$27,$AA,$00,$02,$00,$00           ] , 'vptestnmd  k5,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(67, [$62,$F2,$16,$50,$27,$6A,$80                       ] , 'vptestnmd  k5,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(68, [$62,$F2,$16,$50,$27,$AA,$FC,$FD,$FF,$FF           ] , 'vptestnmd  k5,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(69, [$62,$92,$96,$40,$27,$EC                           ] , 'vptestnmq  k5,zmm29,zmm28'                        );
  TestCase.testcase(70, [$62,$92,$96,$47,$27,$EC                           ] , 'vptestnmq  k5{k7},zmm29,zmm28'                    );
  TestCase.testcase(71, [$62,$F2,$96,$40,$27,$29                           ] , 'vptestnmq  k5,zmm29,zword [rcx]'                  );
  TestCase.testcase(72, [$62,$B2,$96,$40,$27,$AC,$F0,$23,$01,$00,$00       ] , 'vptestnmq  k5,zmm29,zword [rax+r14*8+0x123]'      );
  TestCase.testcase(73, [$62,$F2,$96,$50,$27,$29                           ] , 'vptestnmq  k5,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(74, [$62,$F2,$96,$40,$27,$6A,$7F                       ] , 'vptestnmq  k5,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(75, [$62,$F2,$96,$40,$27,$AA,$00,$20,$00,$00           ] , 'vptestnmq  k5,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(76, [$62,$F2,$96,$40,$27,$6A,$80                       ] , 'vptestnmq  k5,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(77, [$62,$F2,$96,$40,$27,$AA,$C0,$DF,$FF,$FF           ] , 'vptestnmq  k5,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(78, [$62,$F2,$96,$50,$27,$6A,$7F                       ] , 'vptestnmq  k5,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(79, [$62,$F2,$96,$50,$27,$AA,$00,$04,$00,$00           ] , 'vptestnmq  k5,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(80, [$62,$F2,$96,$50,$27,$6A,$80                       ] , 'vptestnmq  k5,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(81, [$62,$F2,$96,$50,$27,$AA,$F8,$FB,$FF,$FF           ] , 'vptestnmq  k5,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(82, [$62,$62,$7E,$48,$3A,$F6                           ] , 'vpbroadcastmw2d  zmm30,k6'                        );
  TestCase.testcase(83, [$62,$62,$FE,$48,$2A,$F6                           ] , 'vpbroadcastmb2q  zmm30,k6'                        );
  TestCase.testcase(84, [$62,$02,$7D,$48,$C4,$F5                           ] , 'vpconflictd  zmm30,zmm29'                         );
  TestCase.testcase(85, [$62,$02,$7D,$4F,$C4,$F5                           ] , 'vpconflictd  zmm30{k7},zmm29'                     );
  TestCase.testcase(86, [$62,$02,$7D,$CF,$C4,$F5                           ] , 'vpconflictd  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(87, [$62,$62,$7D,$48,$C4,$31                           ] , 'vpconflictd  zmm30,zword [rcx]'                   );
  TestCase.testcase(88, [$62,$22,$7D,$48,$C4,$B4,$F0,$34,$12,$00,$00       ] , 'vpconflictd  zmm30,zword [rax+r14*8+0x1234]'      );
  TestCase.testcase(89, [$62,$62,$7D,$58,$C4,$31                           ] , 'vpconflictd  zmm30,dword [rcx]{1to16}'            );
  TestCase.testcase(90, [$62,$62,$7D,$48,$C4,$72,$7F                       ] , 'vpconflictd  zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(91, [$62,$62,$7D,$48,$C4,$B2,$00,$20,$00,$00           ] , 'vpconflictd  zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(92, [$62,$62,$7D,$48,$C4,$72,$80                       ] , 'vpconflictd  zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(93, [$62,$62,$7D,$48,$C4,$B2,$C0,$DF,$FF,$FF           ] , 'vpconflictd  zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(94, [$62,$62,$7D,$58,$C4,$72,$7F                       ] , 'vpconflictd  zmm30,dword [rdx+0x1fc]{1to16}'      );
  TestCase.testcase(95, [$62,$62,$7D,$58,$C4,$B2,$00,$02,$00,$00           ] , 'vpconflictd  zmm30,dword [rdx+0x200]{1to16}'      );
  TestCase.testcase(96, [$62,$62,$7D,$58,$C4,$72,$80                       ] , 'vpconflictd  zmm30,dword [rdx-0x200]{1to16}'      );
  TestCase.testcase(97, [$62,$62,$7D,$58,$C4,$B2,$FC,$FD,$FF,$FF           ] , 'vpconflictd  zmm30,dword [rdx-0x204]{1to16}'      );
  TestCase.testcase(98, [$62,$02,$FD,$48,$C4,$F5                           ] , 'vpconflictq  zmm30,zmm29'                         );
  TestCase.testcase(99, [$62,$02,$FD,$4F,$C4,$F5                           ] , 'vpconflictq  zmm30{k7},zmm29'                     );
  TestCase.testcase(100, [$62,$02,$FD,$CF,$C4,$F5                           ] , 'vpconflictq  zmm30{k7}{z},zmm29'                  );
  TestCase.testcase(101, [$62,$62,$FD,$48,$C4,$31                           ] , 'vpconflictq  zmm30,zword [rcx]'                   );
  TestCase.testcase(102, [$62,$22,$FD,$48,$C4,$B4,$F0,$34,$12,$00,$00       ] , 'vpconflictq  zmm30,zword [rax+r14*8+0x1234]'      );
  TestCase.testcase(103, [$62,$62,$FD,$58,$C4,$31                           ] , 'vpconflictq  zmm30,qword [rcx]{1to8}'             );
  TestCase.testcase(104, [$62,$62,$FD,$48,$C4,$72,$7F                       ] , 'vpconflictq  zmm30,zword [rdx+0x1fc0]'            );
  TestCase.testcase(105, [$62,$62,$FD,$48,$C4,$B2,$00,$20,$00,$00           ] , 'vpconflictq  zmm30,zword [rdx+0x2000]'            );
  TestCase.testcase(106, [$62,$62,$FD,$48,$C4,$72,$80                       ] , 'vpconflictq  zmm30,zword [rdx-0x2000]'            );
  TestCase.testcase(107, [$62,$62,$FD,$48,$C4,$B2,$C0,$DF,$FF,$FF           ] , 'vpconflictq  zmm30,zword [rdx-0x2040]'            );
  TestCase.testcase(108, [$62,$62,$FD,$58,$C4,$72,$7F                       ] , 'vpconflictq  zmm30,qword [rdx+0x3f8]{1to8}'       );
  TestCase.testcase(109, [$62,$62,$FD,$58,$C4,$B2,$00,$04,$00,$00           ] , 'vpconflictq  zmm30,qword [rdx+0x400]{1to8}'       );
  TestCase.testcase(110, [$62,$62,$FD,$58,$C4,$72,$80                       ] , 'vpconflictq  zmm30,qword [rdx-0x400]{1to8}'       );
  TestCase.testcase(111, [$62,$62,$FD,$58,$C4,$B2,$F8,$FB,$FF,$FF           ] , 'vpconflictq  zmm30,qword [rdx-0x408]{1to8}'       );
  TestCase.testcase(112, [$62,$02,$7D,$48,$44,$F5                           ] , 'vplzcntd  zmm30,zmm29'                            );
  TestCase.testcase(113, [$62,$02,$7D,$4F,$44,$F5                           ] , 'vplzcntd  zmm30{k7},zmm29'                        );
  TestCase.testcase(114, [$62,$02,$7D,$CF,$44,$F5                           ] , 'vplzcntd  zmm30{k7}{z},zmm29'                     );
  TestCase.testcase(115, [$62,$62,$7D,$48,$44,$31                           ] , 'vplzcntd  zmm30,zword [rcx]'                      );
  TestCase.testcase(116, [$62,$22,$7D,$48,$44,$B4,$F0,$34,$12,$00,$00       ] , 'vplzcntd  zmm30,zword [rax+r14*8+0x1234]'         );
  TestCase.testcase(117, [$62,$62,$7D,$58,$44,$31                           ] , 'vplzcntd  zmm30,dword [rcx]{1to16}'               );
  TestCase.testcase(118, [$62,$62,$7D,$48,$44,$72,$7F                       ] , 'vplzcntd  zmm30,zword [rdx+0x1fc0]'               );
  TestCase.testcase(119, [$62,$62,$7D,$48,$44,$B2,$00,$20,$00,$00           ] , 'vplzcntd  zmm30,zword [rdx+0x2000]'               );
  TestCase.testcase(120, [$62,$62,$7D,$48,$44,$72,$80                       ] , 'vplzcntd  zmm30,zword [rdx-0x2000]'               );
  TestCase.testcase(121, [$62,$62,$7D,$48,$44,$B2,$C0,$DF,$FF,$FF           ] , 'vplzcntd  zmm30,zword [rdx-0x2040]'               );
  TestCase.testcase(122, [$62,$62,$7D,$58,$44,$72,$7F                       ] , 'vplzcntd  zmm30,dword [rdx+0x1fc]{1to16}'         );
  TestCase.testcase(123, [$62,$62,$7D,$58,$44,$B2,$00,$02,$00,$00           ] , 'vplzcntd  zmm30,dword [rdx+0x200]{1to16}'         );
  TestCase.testcase(124, [$62,$62,$7D,$58,$44,$72,$80                       ] , 'vplzcntd  zmm30,dword [rdx-0x200]{1to16}'         );
  TestCase.testcase(125, [$62,$62,$7D,$58,$44,$B2,$FC,$FD,$FF,$FF           ] , 'vplzcntd  zmm30,dword [rdx-0x204]{1to16}'         );
  TestCase.testcase(126, [$62,$02,$FD,$48,$44,$F5                           ] , 'vplzcntq  zmm30,zmm29'                            );
  TestCase.testcase(127, [$62,$02,$FD,$4F,$44,$F5                           ] , 'vplzcntq  zmm30{k7},zmm29'                        );
  TestCase.testcase(128, [$62,$02,$FD,$CF,$44,$F5                           ] , 'vplzcntq  zmm30{k7}{z},zmm29'                     );
  TestCase.testcase(129, [$62,$62,$FD,$48,$44,$31                           ] , 'vplzcntq  zmm30,zword [rcx]'                      );
  TestCase.testcase(130, [$62,$22,$FD,$48,$44,$B4,$F0,$34,$12,$00,$00       ] , 'vplzcntq  zmm30,zword [rax+r14*8+0x1234]'         );
  TestCase.testcase(131, [$62,$62,$FD,$58,$44,$31                           ] , 'vplzcntq  zmm30,qword [rcx]{1to8}'                );
  TestCase.testcase(132, [$62,$62,$FD,$48,$44,$72,$7F                       ] , 'vplzcntq  zmm30,zword [rdx+0x1fc0]'               );
  TestCase.testcase(133, [$62,$62,$FD,$48,$44,$B2,$00,$20,$00,$00           ] , 'vplzcntq  zmm30,zword [rdx+0x2000]'               );
  TestCase.testcase(134, [$62,$62,$FD,$48,$44,$72,$80                       ] , 'vplzcntq  zmm30,zword [rdx-0x2000]'               );
  TestCase.testcase(135, [$62,$62,$FD,$48,$44,$B2,$C0,$DF,$FF,$FF           ] , 'vplzcntq  zmm30,zword [rdx-0x2040]'               );
  TestCase.testcase(136, [$62,$62,$FD,$58,$44,$72,$7F                       ] , 'vplzcntq  zmm30,qword [rdx+0x3f8]{1to8}'          );
  TestCase.testcase(137, [$62,$62,$FD,$58,$44,$B2,$00,$04,$00,$00           ] , 'vplzcntq  zmm30,qword [rdx+0x400]{1to8}'          );
  TestCase.testcase(138, [$62,$62,$FD,$58,$44,$72,$80                       ] , 'vplzcntq  zmm30,qword [rdx-0x400]{1to8}'          );
  TestCase.testcase(139, [$62,$62,$FD,$58,$44,$B2,$F8,$FB,$FF,$FF           ] , 'vplzcntq  zmm30,qword [rdx-0x408]{1to8}'          );
  TestCase.testcase(140, [$62,$92,$16,$40,$27,$EC                           ] , 'vptestnmd  k5,zmm29,zmm28'                        );
  TestCase.testcase(141, [$62,$92,$16,$47,$27,$EC                           ] , 'vptestnmd  k5{k7},zmm29,zmm28'                    );
  TestCase.testcase(142, [$62,$F2,$16,$40,$27,$29                           ] , 'vptestnmd  k5,zmm29,zword [rcx]'                  );
  TestCase.testcase(143, [$62,$B2,$16,$40,$27,$AC,$F0,$34,$12,$00,$00       ] , 'vptestnmd  k5,zmm29,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(144, [$62,$F2,$16,$50,$27,$29                           ] , 'vptestnmd  k5,zmm29,dword [rcx]{1to16}'           );
  TestCase.testcase(145, [$62,$F2,$16,$40,$27,$6A,$7F                       ] , 'vptestnmd  k5,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(146, [$62,$F2,$16,$40,$27,$AA,$00,$20,$00,$00           ] , 'vptestnmd  k5,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(147, [$62,$F2,$16,$40,$27,$6A,$80                       ] , 'vptestnmd  k5,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(148, [$62,$F2,$16,$40,$27,$AA,$C0,$DF,$FF,$FF           ] , 'vptestnmd  k5,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(149, [$62,$F2,$16,$50,$27,$6A,$7F                       ] , 'vptestnmd  k5,zmm29,dword [rdx+0x1fc]{1to16}'     );
  TestCase.testcase(150, [$62,$F2,$16,$50,$27,$AA,$00,$02,$00,$00           ] , 'vptestnmd  k5,zmm29,dword [rdx+0x200]{1to16}'     );
  TestCase.testcase(151, [$62,$F2,$16,$50,$27,$6A,$80                       ] , 'vptestnmd  k5,zmm29,dword [rdx-0x200]{1to16}'     );
  TestCase.testcase(152, [$62,$F2,$16,$50,$27,$AA,$FC,$FD,$FF,$FF           ] , 'vptestnmd  k5,zmm29,dword [rdx-0x204]{1to16}'     );
  TestCase.testcase(153, [$62,$92,$96,$40,$27,$EC                           ] , 'vptestnmq  k5,zmm29,zmm28'                        );
  TestCase.testcase(154, [$62,$92,$96,$47,$27,$EC                           ] , 'vptestnmq  k5{k7},zmm29,zmm28'                    );
  TestCase.testcase(155, [$62,$F2,$96,$40,$27,$29                           ] , 'vptestnmq  k5,zmm29,zword [rcx]'                  );
  TestCase.testcase(156, [$62,$B2,$96,$40,$27,$AC,$F0,$34,$12,$00,$00       ] , 'vptestnmq  k5,zmm29,zword [rax+r14*8+0x1234]'     );
  TestCase.testcase(157, [$62,$F2,$96,$50,$27,$29                           ] , 'vptestnmq  k5,zmm29,qword [rcx]{1to8}'            );
  TestCase.testcase(158, [$62,$F2,$96,$40,$27,$6A,$7F                       ] , 'vptestnmq  k5,zmm29,zword [rdx+0x1fc0]'           );
  TestCase.testcase(159, [$62,$F2,$96,$40,$27,$AA,$00,$20,$00,$00           ] , 'vptestnmq  k5,zmm29,zword [rdx+0x2000]'           );
  TestCase.testcase(160, [$62,$F2,$96,$40,$27,$6A,$80                       ] , 'vptestnmq  k5,zmm29,zword [rdx-0x2000]'           );
  TestCase.testcase(161, [$62,$F2,$96,$40,$27,$AA,$C0,$DF,$FF,$FF           ] , 'vptestnmq  k5,zmm29,zword [rdx-0x2040]'           );
  TestCase.testcase(162, [$62,$F2,$96,$50,$27,$6A,$7F                       ] , 'vptestnmq  k5,zmm29,qword [rdx+0x3f8]{1to8}'      );
  TestCase.testcase(163, [$62,$F2,$96,$50,$27,$AA,$00,$04,$00,$00           ] , 'vptestnmq  k5,zmm29,qword [rdx+0x400]{1to8}'      );
  TestCase.testcase(164, [$62,$F2,$96,$50,$27,$6A,$80                       ] , 'vptestnmq  k5,zmm29,qword [rdx-0x400]{1to8}'      );
  TestCase.testcase(165, [$62,$F2,$96,$50,$27,$AA,$F8,$FB,$FF,$FF           ] , 'vptestnmq  k5,zmm29,qword [rdx-0x408]{1to8}'      );
  TestCase.testcase(166, [$62,$62,$7E,$48,$3A,$F6                           ] , 'vpbroadcastmw2d  zmm30,k6'                        );
  TestCase.testcase(167, [$62,$62,$FE,$48,$2A,$F6                           ] , 'vpbroadcastmb2q  zmm30,k6'                        );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x64.avx512cd.log');
end;

end.