unit x32.simd;

// This unit was generated by d2p.pl script.
// Source : gas/simd-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x32.simd');
  TestCase.Start();	
  TestCase.Arch := CPUX32;

  TestCase.testcase(0, [$F2,$0F,$D0,$0D,$78,$56,$34,$12                   ] , 'addsubps  xmm1,oword ds:[0x12345678]'             );
  TestCase.testcase(1, [$66,$0F,$2F,$0D,$78,$56,$34,$12                   ] , 'comisd  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(2, [$0F,$2F,$0D,$78,$56,$34,$12                       ] , 'comiss  xmm1,dword ds:[0x12345678]'               );
  TestCase.testcase(3, [$F3,$0F,$E6,$0D,$78,$56,$34,$12                   ] , 'cvtdq2pd  xmm1,qword ds:[0x12345678]'             );
  TestCase.testcase(4, [$F2,$0F,$E6,$0D,$78,$56,$34,$12                   ] , 'cvtpd2dq  xmm1,oword ds:[0x12345678]'             );
  TestCase.testcase(5, [$0F,$5A,$0D,$78,$56,$34,$12                       ] , 'cvtps2pd  xmm1,qword ds:[0x12345678]'             );
  TestCase.testcase(6, [$F3,$0F,$5B,$0D,$78,$56,$34,$12                   ] , 'cvttps2dq  xmm1,oword ds:[0x12345678]'            );
  TestCase.testcase(7, [$F2,$0F,$7C,$0D,$78,$56,$34,$12                   ] , 'haddps  xmm1,oword ds:[0x12345678]'               );
  TestCase.testcase(8, [$F3,$0F,$7F,$0D,$78,$56,$34,$12                   ] , 'movdqu  oword ds:[0x12345678],xmm1'               );
  TestCase.testcase(9, [$F3,$0F,$6F,$0D,$78,$56,$34,$12                   ] , 'movdqu  xmm1,oword ds:[0x12345678]'               );
  TestCase.testcase(10, [$66,$0F,$17,$0D,$78,$56,$34,$12                   ] , 'movhpd  qword ds:[0x12345678],xmm1'               );
  TestCase.testcase(11, [$66,$0F,$16,$0D,$78,$56,$34,$12                   ] , 'movhpd  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(12, [$0F,$17,$0D,$78,$56,$34,$12                       ] , 'movhps  qword ds:[0x12345678],xmm1'               );
  TestCase.testcase(13, [$0F,$16,$0D,$78,$56,$34,$12                       ] , 'movhps  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(14, [$66,$0F,$13,$0D,$78,$56,$34,$12                   ] , 'movlpd  qword ds:[0x12345678],xmm1'               );
  TestCase.testcase(15, [$66,$0F,$12,$0D,$78,$56,$34,$12                   ] , 'movlpd  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(16, [$0F,$13,$0D,$78,$56,$34,$12                       ] , 'movlps  qword ds:[0x12345678],xmm1'               );
  TestCase.testcase(17, [$0F,$12,$0D,$78,$56,$34,$12                       ] , 'movlps  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(18, [$F3,$0F,$16,$0D,$78,$56,$34,$12                   ] , 'movshdup  xmm1,oword ds:[0x12345678]'             );
  TestCase.testcase(19, [$F3,$0F,$12,$0D,$78,$56,$34,$12                   ] , 'movsldup  xmm1,oword ds:[0x12345678]'             );
  TestCase.testcase(20, [$F3,$0F,$70,$0D,$78,$56,$34,$12,$90               ] , 'pshufhw  xmm1,oword ds:[0x12345678],0x90'         );
  TestCase.testcase(21, [$F2,$0F,$70,$0D,$78,$56,$34,$12,$90               ] , 'pshuflw  xmm1,oword ds:[0x12345678],0x90'         );
  TestCase.testcase(22, [$0F,$60,$0D,$78,$56,$34,$12                       ] , 'punpcklbw  mm1,dword ds:[0x12345678]'             );
  TestCase.testcase(23, [$0F,$62,$0D,$78,$56,$34,$12                       ] , 'punpckldq  mm1,dword ds:[0x12345678]'             );
  TestCase.testcase(24, [$0F,$61,$0D,$78,$56,$34,$12                       ] , 'punpcklwd  mm1,dword ds:[0x12345678]'             );
  TestCase.testcase(25, [$66,$0F,$60,$0D,$78,$56,$34,$12                   ] , 'punpcklbw  xmm1,oword ds:[0x12345678]'            );
  TestCase.testcase(26, [$66,$0F,$62,$0D,$78,$56,$34,$12                   ] , 'punpckldq  xmm1,oword ds:[0x12345678]'            );
  TestCase.testcase(27, [$66,$0F,$61,$0D,$78,$56,$34,$12                   ] , 'punpcklwd  xmm1,oword ds:[0x12345678]'            );
  TestCase.testcase(28, [$66,$0F,$6C,$0D,$78,$56,$34,$12                   ] , 'punpcklqdq  xmm1,oword ds:[0x12345678]'           );
  TestCase.testcase(29, [$66,$0F,$2E,$0D,$78,$56,$34,$12                   ] , 'ucomisd  xmm1,qword ds:[0x12345678]'              );
  TestCase.testcase(30, [$0F,$2E,$0D,$78,$56,$34,$12                       ] , 'ucomiss  xmm1,dword ds:[0x12345678]'              );
  TestCase.testcase(31, [$F2,$0F,$C2,$00,$00                               ] , 'cmpeqsd  xmm0,qword [eax]'                        );
  TestCase.testcase(32, [$F3,$0F,$C2,$00,$00                               ] , 'cmpeqss  xmm0,dword [eax]'                        );
  TestCase.testcase(33, [$66,$0F,$2A,$00                                   ] , 'cvtpi2pd  xmm0,qword [eax]'                       );
  TestCase.testcase(34, [$0F,$2A,$00                                       ] , 'cvtpi2ps  xmm0,qword [eax]'                       );
  TestCase.testcase(35, [$0F,$2D,$00                                       ] , 'cvtps2pi  mm0,qword [eax]'                        );
  TestCase.testcase(36, [$F2,$0F,$2D,$00                                   ] , 'cvtsd2si  eax,qword [eax]'                        );
  TestCase.testcase(37, [$F2,$0F,$2C,$00                                   ] , 'cvttsd2si  eax,qword [eax]'                       );
  TestCase.testcase(38, [$F2,$0F,$5A,$00                                   ] , 'cvtsd2ss  xmm0,qword [eax]'                       );
  TestCase.testcase(39, [$F3,$0F,$5A,$00                                   ] , 'cvtss2sd  xmm0,dword [eax]'                       );
  TestCase.testcase(40, [$F3,$0F,$2D,$00                                   ] , 'cvtss2si  eax,dword [eax]'                        );
  TestCase.testcase(41, [$F3,$0F,$2C,$00                                   ] , 'cvttss2si  eax,dword [eax]'                       );
  TestCase.testcase(42, [$F2,$0F,$5E,$00                                   ] , 'divsd  xmm0,qword [eax]'                          );
  TestCase.testcase(43, [$F3,$0F,$5E,$00                                   ] , 'divss  xmm0,dword [eax]'                          );
  TestCase.testcase(44, [$F2,$0F,$5F,$00                                   ] , 'maxsd  xmm0,qword [eax]'                          );
  TestCase.testcase(45, [$F3,$0F,$5F,$00                                   ] , 'maxss  xmm0,dword [eax]'                          );
  TestCase.testcase(46, [$F3,$0F,$5D,$00                                   ] , 'minss  xmm0,dword [eax]'                          );
  TestCase.testcase(47, [$F3,$0F,$5D,$00                                   ] , 'minss  xmm0,dword [eax]'                          );
  TestCase.testcase(48, [$F2,$0F,$2B,$00                                   ] , 'movntsd  qword [eax],xmm0'                        );
  TestCase.testcase(49, [$F3,$0F,$2B,$00                                   ] , 'movntss  dword [eax],xmm0'                        );
  TestCase.testcase(50, [$F2,$0F,$10,$00                                   ] , 'movsd  xmm0,qword [eax]'                          );
  TestCase.testcase(51, [$F2,$0F,$11,$00                                   ] , 'movsd  qword [eax],xmm0'                          );
  TestCase.testcase(52, [$F3,$0F,$10,$00                                   ] , 'movss  xmm0,dword [eax]'                          );
  TestCase.testcase(53, [$F3,$0F,$11,$00                                   ] , 'movss  dword [eax],xmm0'                          );
  TestCase.testcase(54, [$F2,$0F,$59,$00                                   ] , 'mulsd  xmm0,qword [eax]'                          );
  TestCase.testcase(55, [$F3,$0F,$59,$00                                   ] , 'mulss  xmm0,dword [eax]'                          );
  TestCase.testcase(56, [$F3,$0F,$53,$00                                   ] , 'rcpss  xmm0,dword [eax]'                          );
  TestCase.testcase(57, [$66,$0F,$3A,$0B,$00,$00                           ] , 'roundsd  xmm0,qword [eax],0x0'                    );
  TestCase.testcase(58, [$66,$0F,$3A,$0A,$00,$00                           ] , 'roundss  xmm0,dword [eax],0x0'                    );
  TestCase.testcase(59, [$F3,$0F,$52,$00                                   ] , 'rsqrtss  xmm0,dword [eax]'                        );
  TestCase.testcase(60, [$F2,$0F,$51,$00                                   ] , 'sqrtsd  xmm0,qword [eax]'                         );
  TestCase.testcase(61, [$F3,$0F,$51,$00                                   ] , 'sqrtss  xmm0,dword [eax]'                         );
  TestCase.testcase(62, [$F2,$0F,$5C,$00                                   ] , 'subsd  xmm0,qword [eax]'                          );
  TestCase.testcase(63, [$F3,$0F,$5C,$00                                   ] , 'subss  xmm0,dword [eax]'                          );
  TestCase.testcase(64, [$66,$0F,$38,$20,$00                               ] , 'pmovsxbw  xmm0,qword [eax]'                       );
  TestCase.testcase(65, [$66,$0F,$38,$21,$00                               ] , 'pmovsxbd  xmm0,dword [eax]'                       );
  TestCase.testcase(66, [$66,$0F,$38,$22,$00                               ] , 'pmovsxbq  xmm0,word [eax]'                        );
  TestCase.testcase(67, [$66,$0F,$38,$23,$00                               ] , 'pmovsxwd  xmm0,qword [eax]'                       );
  TestCase.testcase(68, [$66,$0F,$38,$24,$00                               ] , 'pmovsxwq  xmm0,dword [eax]'                       );
  TestCase.testcase(69, [$66,$0F,$38,$25,$00                               ] , 'pmovsxdq  xmm0,qword [eax]'                       );
  TestCase.testcase(70, [$66,$0F,$38,$30,$00                               ] , 'pmovzxbw  xmm0,qword [eax]'                       );
  TestCase.testcase(71, [$66,$0F,$38,$31,$00                               ] , 'pmovzxbd  xmm0,dword [eax]'                       );
  TestCase.testcase(72, [$66,$0F,$38,$32,$00                               ] , 'pmovzxbq  xmm0,word [eax]'                        );
  TestCase.testcase(73, [$66,$0F,$38,$33,$00                               ] , 'pmovzxwd  xmm0,qword [eax]'                       );
  TestCase.testcase(74, [$66,$0F,$38,$34,$00                               ] , 'pmovzxwq  xmm0,dword [eax]'                       );
  TestCase.testcase(75, [$66,$0F,$38,$35,$00                               ] , 'pmovzxdq  xmm0,qword [eax]'                       );
  TestCase.testcase(76, [$66,$0F,$3A,$21,$00,$00                           ] , 'insertps  xmm0,dword [eax],0x0'                   );
  TestCase.testcase(77, [$66,$0F,$15,$08                                   ] , 'unpckhpd  xmm1,oword [eax]'                       );
  TestCase.testcase(78, [$0F,$15,$08                                       ] , 'unpckhps  xmm1,oword [eax]'                       );
  TestCase.testcase(79, [$66,$0F,$14,$08                                   ] , 'unpcklpd  xmm1,oword [eax]'                       );
  TestCase.testcase(80, [$0F,$14,$08                                       ] , 'unpcklps  xmm1,oword [eax]'                       );
  TestCase.testcase(81, [$F3,$0F,$C2,$F7,$10                               ] , 'cmpss  xmm6,xmm7,0x10'                            );
  TestCase.testcase(82, [$F3,$0F,$C2,$38,$10                               ] , 'cmpss  xmm7,dword [eax],0x10'                     );
  TestCase.testcase(83, [$F2,$0F,$C2,$F7,$10                               ] , 'cmpsd  xmm6,xmm7,0x10'                            );
  TestCase.testcase(84, [$F2,$0F,$C2,$38,$10                               ] , 'cmpsd  xmm7,qword [eax],0x10'                     );
  TestCase.testcase(85, [$F3,$0F,$2A,$C8                                   ] , 'cvtsi2ss  xmm1,eax'                               );
  TestCase.testcase(86, [$F2,$0F,$2A,$C8                                   ] , 'cvtsi2sd  xmm1,eax'                               );
  TestCase.testcase(87, [$F3,$0F,$2A,$C8                                   ] , 'cvtsi2ss  xmm1,eax'                               );
  TestCase.testcase(88, [$F2,$0F,$2A,$C8                                   ] , 'cvtsi2sd  xmm1,eax'                               );
  TestCase.testcase(89, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [eax]'                       );
  TestCase.testcase(90, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [eax]'                       );
  TestCase.testcase(91, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [eax]'                       );
  TestCase.testcase(92, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [eax]'                       );
  TestCase.testcase(93, [$F2,$0F,$D0,$0D,$78,$56,$34,$12                   ] , 'addsubps  xmm1,oword ds:[0x12345678]'             );
  TestCase.testcase(94, [$66,$0F,$2F,$0D,$78,$56,$34,$12                   ] , 'comisd  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(95, [$0F,$2F,$0D,$78,$56,$34,$12                       ] , 'comiss  xmm1,dword ds:[0x12345678]'               );
  TestCase.testcase(96, [$F3,$0F,$E6,$0D,$78,$56,$34,$12                   ] , 'cvtdq2pd  xmm1,qword ds:[0x12345678]'             );
  TestCase.testcase(97, [$F2,$0F,$E6,$0D,$78,$56,$34,$12                   ] , 'cvtpd2dq  xmm1,oword ds:[0x12345678]'             );
  TestCase.testcase(98, [$0F,$5A,$0D,$78,$56,$34,$12                       ] , 'cvtps2pd  xmm1,qword ds:[0x12345678]'             );
  TestCase.testcase(99, [$F3,$0F,$5B,$0D,$78,$56,$34,$12                   ] , 'cvttps2dq  xmm1,oword ds:[0x12345678]'            );
  TestCase.testcase(100, [$F2,$0F,$7C,$0D,$78,$56,$34,$12                   ] , 'haddps  xmm1,oword ds:[0x12345678]'               );
  TestCase.testcase(101, [$F3,$0F,$7F,$0D,$78,$56,$34,$12                   ] , 'movdqu  oword ds:[0x12345678],xmm1'               );
  TestCase.testcase(102, [$F3,$0F,$6F,$0D,$78,$56,$34,$12                   ] , 'movdqu  xmm1,oword ds:[0x12345678]'               );
  TestCase.testcase(103, [$66,$0F,$17,$0D,$78,$56,$34,$12                   ] , 'movhpd  qword ds:[0x12345678],xmm1'               );
  TestCase.testcase(104, [$66,$0F,$16,$0D,$78,$56,$34,$12                   ] , 'movhpd  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(105, [$0F,$17,$0D,$78,$56,$34,$12                       ] , 'movhps  qword ds:[0x12345678],xmm1'               );
  TestCase.testcase(106, [$0F,$16,$0D,$78,$56,$34,$12                       ] , 'movhps  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(107, [$66,$0F,$13,$0D,$78,$56,$34,$12                   ] , 'movlpd  qword ds:[0x12345678],xmm1'               );
  TestCase.testcase(108, [$66,$0F,$12,$0D,$78,$56,$34,$12                   ] , 'movlpd  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(109, [$0F,$13,$0D,$78,$56,$34,$12                       ] , 'movlps  qword ds:[0x12345678],xmm1'               );
  TestCase.testcase(110, [$0F,$12,$0D,$78,$56,$34,$12                       ] , 'movlps  xmm1,qword ds:[0x12345678]'               );
  TestCase.testcase(111, [$F3,$0F,$16,$0D,$78,$56,$34,$12                   ] , 'movshdup  xmm1,oword ds:[0x12345678]'             );
  TestCase.testcase(112, [$F3,$0F,$12,$0D,$78,$56,$34,$12                   ] , 'movsldup  xmm1,oword ds:[0x12345678]'             );
  TestCase.testcase(113, [$F3,$0F,$70,$0D,$78,$56,$34,$12,$90               ] , 'pshufhw  xmm1,oword ds:[0x12345678],0x90'         );
  TestCase.testcase(114, [$F2,$0F,$70,$0D,$78,$56,$34,$12,$90               ] , 'pshuflw  xmm1,oword ds:[0x12345678],0x90'         );
  TestCase.testcase(115, [$0F,$60,$0D,$78,$56,$34,$12                       ] , 'punpcklbw  mm1,dword ds:[0x12345678]'             );
  TestCase.testcase(116, [$0F,$62,$0D,$78,$56,$34,$12                       ] , 'punpckldq  mm1,dword ds:[0x12345678]'             );
  TestCase.testcase(117, [$0F,$61,$0D,$78,$56,$34,$12                       ] , 'punpcklwd  mm1,dword ds:[0x12345678]'             );
  TestCase.testcase(118, [$66,$0F,$60,$0D,$78,$56,$34,$12                   ] , 'punpcklbw  xmm1,oword ds:[0x12345678]'            );
  TestCase.testcase(119, [$66,$0F,$62,$0D,$78,$56,$34,$12                   ] , 'punpckldq  xmm1,oword ds:[0x12345678]'            );
  TestCase.testcase(120, [$66,$0F,$61,$0D,$78,$56,$34,$12                   ] , 'punpcklwd  xmm1,oword ds:[0x12345678]'            );
  TestCase.testcase(121, [$66,$0F,$6C,$0D,$78,$56,$34,$12                   ] , 'punpcklqdq  xmm1,oword ds:[0x12345678]'           );
  TestCase.testcase(122, [$66,$0F,$2E,$0D,$78,$56,$34,$12                   ] , 'ucomisd  xmm1,qword ds:[0x12345678]'              );
  TestCase.testcase(123, [$0F,$2E,$0D,$78,$56,$34,$12                       ] , 'ucomiss  xmm1,dword ds:[0x12345678]'              );
  TestCase.testcase(124, [$F2,$0F,$C2,$00,$00                               ] , 'cmpeqsd  xmm0,qword [eax]'                        );
  TestCase.testcase(125, [$F3,$0F,$C2,$00,$00                               ] , 'cmpeqss  xmm0,dword [eax]'                        );
  TestCase.testcase(126, [$66,$0F,$2A,$00                                   ] , 'cvtpi2pd  xmm0,qword [eax]'                       );
  TestCase.testcase(127, [$0F,$2A,$00                                       ] , 'cvtpi2ps  xmm0,qword [eax]'                       );
  TestCase.testcase(128, [$0F,$2D,$00                                       ] , 'cvtps2pi  mm0,qword [eax]'                        );
  TestCase.testcase(129, [$F2,$0F,$2D,$00                                   ] , 'cvtsd2si  eax,qword [eax]'                        );
  TestCase.testcase(130, [$F2,$0F,$2C,$00                                   ] , 'cvttsd2si  eax,qword [eax]'                       );
  TestCase.testcase(131, [$F2,$0F,$5A,$00                                   ] , 'cvtsd2ss  xmm0,qword [eax]'                       );
  TestCase.testcase(132, [$F3,$0F,$5A,$00                                   ] , 'cvtss2sd  xmm0,dword [eax]'                       );
  TestCase.testcase(133, [$F3,$0F,$2D,$00                                   ] , 'cvtss2si  eax,dword [eax]'                        );
  TestCase.testcase(134, [$F3,$0F,$2C,$00                                   ] , 'cvttss2si  eax,dword [eax]'                       );
  TestCase.testcase(135, [$F2,$0F,$5E,$00                                   ] , 'divsd  xmm0,qword [eax]'                          );
  TestCase.testcase(136, [$F3,$0F,$5E,$00                                   ] , 'divss  xmm0,dword [eax]'                          );
  TestCase.testcase(137, [$F2,$0F,$5F,$00                                   ] , 'maxsd  xmm0,qword [eax]'                          );
  TestCase.testcase(138, [$F3,$0F,$5F,$00                                   ] , 'maxss  xmm0,dword [eax]'                          );
  TestCase.testcase(139, [$F3,$0F,$5D,$00                                   ] , 'minss  xmm0,dword [eax]'                          );
  TestCase.testcase(140, [$F3,$0F,$5D,$00                                   ] , 'minss  xmm0,dword [eax]'                          );
  TestCase.testcase(141, [$F2,$0F,$2B,$00                                   ] , 'movntsd  qword [eax],xmm0'                        );
  TestCase.testcase(142, [$F3,$0F,$2B,$00                                   ] , 'movntss  dword [eax],xmm0'                        );
  TestCase.testcase(143, [$F2,$0F,$10,$00                                   ] , 'movsd  xmm0,qword [eax]'                          );
  TestCase.testcase(144, [$F2,$0F,$11,$00                                   ] , 'movsd  qword [eax],xmm0'                          );
  TestCase.testcase(145, [$F3,$0F,$10,$00                                   ] , 'movss  xmm0,dword [eax]'                          );
  TestCase.testcase(146, [$F3,$0F,$11,$00                                   ] , 'movss  dword [eax],xmm0'                          );
  TestCase.testcase(147, [$F2,$0F,$59,$00                                   ] , 'mulsd  xmm0,qword [eax]'                          );
  TestCase.testcase(148, [$F3,$0F,$59,$00                                   ] , 'mulss  xmm0,dword [eax]'                          );
  TestCase.testcase(149, [$F3,$0F,$53,$00                                   ] , 'rcpss  xmm0,dword [eax]'                          );
  TestCase.testcase(150, [$66,$0F,$3A,$0B,$00,$00                           ] , 'roundsd  xmm0,qword [eax],0x0'                    );
  TestCase.testcase(151, [$66,$0F,$3A,$0A,$00,$00                           ] , 'roundss  xmm0,dword [eax],0x0'                    );
  TestCase.testcase(152, [$F3,$0F,$52,$00                                   ] , 'rsqrtss  xmm0,dword [eax]'                        );
  TestCase.testcase(153, [$F2,$0F,$51,$00                                   ] , 'sqrtsd  xmm0,qword [eax]'                         );
  TestCase.testcase(154, [$F3,$0F,$51,$00                                   ] , 'sqrtss  xmm0,dword [eax]'                         );
  TestCase.testcase(155, [$F2,$0F,$5C,$00                                   ] , 'subsd  xmm0,qword [eax]'                          );
  TestCase.testcase(156, [$F3,$0F,$5C,$00                                   ] , 'subss  xmm0,dword [eax]'                          );
  TestCase.testcase(157, [$66,$0F,$38,$20,$00                               ] , 'pmovsxbw  xmm0,qword [eax]'                       );
  TestCase.testcase(158, [$66,$0F,$38,$21,$00                               ] , 'pmovsxbd  xmm0,dword [eax]'                       );
  TestCase.testcase(159, [$66,$0F,$38,$22,$00                               ] , 'pmovsxbq  xmm0,word [eax]'                        );
  TestCase.testcase(160, [$66,$0F,$38,$23,$00                               ] , 'pmovsxwd  xmm0,qword [eax]'                       );
  TestCase.testcase(161, [$66,$0F,$38,$24,$00                               ] , 'pmovsxwq  xmm0,dword [eax]'                       );
  TestCase.testcase(162, [$66,$0F,$38,$25,$00                               ] , 'pmovsxdq  xmm0,qword [eax]'                       );
  TestCase.testcase(163, [$66,$0F,$38,$30,$00                               ] , 'pmovzxbw  xmm0,qword [eax]'                       );
  TestCase.testcase(164, [$66,$0F,$38,$31,$00                               ] , 'pmovzxbd  xmm0,dword [eax]'                       );
  TestCase.testcase(165, [$66,$0F,$38,$32,$00                               ] , 'pmovzxbq  xmm0,word [eax]'                        );
  TestCase.testcase(166, [$66,$0F,$38,$33,$00                               ] , 'pmovzxwd  xmm0,qword [eax]'                       );
  TestCase.testcase(167, [$66,$0F,$38,$34,$00                               ] , 'pmovzxwq  xmm0,dword [eax]'                       );
  TestCase.testcase(168, [$66,$0F,$38,$35,$00                               ] , 'pmovzxdq  xmm0,qword [eax]'                       );
  TestCase.testcase(169, [$66,$0F,$3A,$21,$00,$00                           ] , 'insertps  xmm0,dword [eax],0x0'                   );
  TestCase.testcase(170, [$66,$0F,$15,$00                                   ] , 'unpckhpd  xmm0,oword [eax]'                       );
  TestCase.testcase(171, [$0F,$15,$00                                       ] , 'unpckhps  xmm0,oword [eax]'                       );
  TestCase.testcase(172, [$66,$0F,$14,$00                                   ] , 'unpcklpd  xmm0,oword [eax]'                       );
  TestCase.testcase(173, [$0F,$14,$00                                       ] , 'unpcklps  xmm0,oword [eax]'                       );
  TestCase.testcase(174, [$F3,$0F,$C2,$F7,$10                               ] , 'cmpss  xmm6,xmm7,0x10'                            );
  TestCase.testcase(175, [$F3,$0F,$C2,$38,$10                               ] , 'cmpss  xmm7,dword [eax],0x10'                     );
  TestCase.testcase(176, [$F2,$0F,$C2,$F7,$10                               ] , 'cmpsd  xmm6,xmm7,0x10'                            );
  TestCase.testcase(177, [$F2,$0F,$C2,$38,$10                               ] , 'cmpsd  xmm7,qword [eax],0x10'                     );
  TestCase.testcase(178, [$F3,$0F,$2A,$C8                                   ] , 'cvtsi2ss  xmm1,eax'                               );
  TestCase.testcase(179, [$F2,$0F,$2A,$C8                                   ] , 'cvtsi2sd  xmm1,eax'                               );
  TestCase.testcase(180, [$F3,$0F,$2A,$C8                                   ] , 'cvtsi2ss  xmm1,eax'                               );
  TestCase.testcase(181, [$F2,$0F,$2A,$C8                                   ] , 'cvtsi2sd  xmm1,eax'                               );
  TestCase.testcase(182, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [eax]'                       );
  TestCase.testcase(183, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [eax]'                       );
  TestCase.testcase(184, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [eax]'                       );
  TestCase.testcase(185, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [eax]'                       );
  TestCase.testcase(186, [$F3,$0F,$2A,$08                                   ] , 'cvtsi2ss  xmm1,dword [eax]'                       );
  TestCase.testcase(187, [$F2,$0F,$2A,$08                                   ] , 'cvtsi2sd  xmm1,dword [eax]'                       );
  TestCase.testcase(188, [$0F,$2C,$00                                       ] , 'cvttps2pi  mm0,qword [eax]'                       );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x32.simd.log');
end;

end.