unit x32.evex_lig256;

// This unit was generated by d2p.pl script.
// Source : gas/evex-lig256-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x32.evex_lig256');
  TestCase.Start();	
  TestCase.Arch := CPUX32;

  TestCase.testcase(0, [$62,$F1,$D7,$2F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1, [$62,$F1,$D7,$AF,$58,$F4                           ] , 'vaddsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2, [$62,$F1,$D7,$1F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(3, [$62,$F1,$D7,$5F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(4, [$62,$F1,$D7,$3F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(5, [$62,$F1,$D7,$7F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(6, [$62,$F1,$D7,$2F,$58,$31                           ] , 'vaddsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(7, [$62,$F1,$D7,$2F,$58,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vaddsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(8, [$62,$F1,$D7,$2F,$58,$72,$7F                       ] , 'vaddsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(9, [$62,$F1,$D7,$2F,$58,$B2,$00,$04,$00,$00           ] , 'vaddsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(10, [$62,$F1,$D7,$2F,$58,$72,$80                       ] , 'vaddsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(11, [$62,$F1,$D7,$2F,$58,$B2,$F8,$FB,$FF,$FF           ] , 'vaddsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(12, [$62,$F1,$56,$2F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(13, [$62,$F1,$56,$AF,$58,$F4                           ] , 'vaddss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(14, [$62,$F1,$56,$1F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(15, [$62,$F1,$56,$5F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(16, [$62,$F1,$56,$3F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(17, [$62,$F1,$56,$7F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(18, [$62,$F1,$56,$2F,$58,$31                           ] , 'vaddss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(19, [$62,$F1,$56,$2F,$58,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vaddss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(20, [$62,$F1,$56,$2F,$58,$72,$7F                       ] , 'vaddss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(21, [$62,$F1,$56,$2F,$58,$B2,$00,$02,$00,$00           ] , 'vaddss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(22, [$62,$F1,$56,$2F,$58,$72,$80                       ] , 'vaddss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(23, [$62,$F1,$56,$2F,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vaddss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(24, [$62,$F1,$D7,$2F,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm5,xmm4,0xab'                    );
  TestCase.testcase(25, [$62,$F1,$D7,$1F,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm5,xmm4,{sae},0xab'              );
  TestCase.testcase(26, [$62,$F1,$D7,$2F,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm5,xmm4,0x7b'                    );
  TestCase.testcase(27, [$62,$F1,$D7,$1F,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm5,xmm4,{sae},0x7b'              );
  TestCase.testcase(28, [$62,$F1,$D7,$2F,$C2,$29,$7B                       ] , 'vcmpsd  k5{k7},xmm5,qword [ecx],0x7b'             );
  TestCase.testcase(29, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vcmpsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(30, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$7B                   ] , 'vcmpsd  k5{k7},xmm5,qword [edx+0x3f8],0x7b'       );
  TestCase.testcase(31, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$7B       ] , 'vcmpsd  k5{k7},xmm5,qword [edx+0x400],0x7b'       );
  TestCase.testcase(32, [$62,$F1,$D7,$2F,$C2,$6A,$80,$7B                   ] , 'vcmpsd  k5{k7},xmm5,qword [edx-0x400],0x7b'       );
  TestCase.testcase(33, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vcmpsd  k5{k7},xmm5,qword [edx-0x408],0x7b'       );
  TestCase.testcase(34, [$62,$F1,$D7,$2F,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(35, [$62,$F1,$D7,$1F,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(36, [$62,$F1,$D7,$2F,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(37, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$00   ] , 'vcmpeqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(38, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(39, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(40, [$62,$F1,$D7,$2F,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(41, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(42, [$62,$F1,$D7,$2F,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(43, [$62,$F1,$D7,$1F,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(44, [$62,$F1,$D7,$2F,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(45, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$00   ] , 'vcmpeqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(46, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(47, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(48, [$62,$F1,$D7,$2F,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(49, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(50, [$62,$F1,$D7,$2F,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(51, [$62,$F1,$D7,$1F,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(52, [$62,$F1,$D7,$2F,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(53, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$01   ] , 'vcmpltsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(54, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(55, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(56, [$62,$F1,$D7,$2F,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(57, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(58, [$62,$F1,$D7,$2F,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(59, [$62,$F1,$D7,$1F,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(60, [$62,$F1,$D7,$2F,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(61, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$01   ] , 'vcmpltsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(62, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(63, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(64, [$62,$F1,$D7,$2F,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(65, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(66, [$62,$F1,$D7,$2F,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(67, [$62,$F1,$D7,$1F,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(68, [$62,$F1,$D7,$2F,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(69, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$02   ] , 'vcmplesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(70, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(71, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(72, [$62,$F1,$D7,$2F,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(73, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(74, [$62,$F1,$D7,$2F,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(75, [$62,$F1,$D7,$1F,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(76, [$62,$F1,$D7,$2F,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(77, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$02   ] , 'vcmplesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(78, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(79, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(80, [$62,$F1,$D7,$2F,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(81, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(82, [$62,$F1,$D7,$2F,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(83, [$62,$F1,$D7,$1F,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(84, [$62,$F1,$D7,$2F,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(85, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$03   ] , 'vcmpunordsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(86, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(87, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(88, [$62,$F1,$D7,$2F,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(89, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(90, [$62,$F1,$D7,$2F,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(91, [$62,$F1,$D7,$1F,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(92, [$62,$F1,$D7,$2F,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(93, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$03   ] , 'vcmpunordsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(94, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(95, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(96, [$62,$F1,$D7,$2F,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(97, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(98, [$62,$F1,$D7,$2F,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(99, [$62,$F1,$D7,$1F,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(100, [$62,$F1,$D7,$2F,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(101, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$04   ] , 'vcmpneqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(102, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(103, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(104, [$62,$F1,$D7,$2F,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(105, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(106, [$62,$F1,$D7,$2F,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(107, [$62,$F1,$D7,$1F,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(108, [$62,$F1,$D7,$2F,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(109, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$04   ] , 'vcmpneqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(110, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(111, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(112, [$62,$F1,$D7,$2F,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(113, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(114, [$62,$F1,$D7,$2F,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(115, [$62,$F1,$D7,$1F,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(116, [$62,$F1,$D7,$2F,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(117, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$05   ] , 'vcmpnltsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(118, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(119, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(120, [$62,$F1,$D7,$2F,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(121, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(122, [$62,$F1,$D7,$2F,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(123, [$62,$F1,$D7,$1F,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(124, [$62,$F1,$D7,$2F,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(125, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$05   ] , 'vcmpnltsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(126, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(127, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(128, [$62,$F1,$D7,$2F,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(129, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(130, [$62,$F1,$D7,$2F,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(131, [$62,$F1,$D7,$1F,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(132, [$62,$F1,$D7,$2F,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(133, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$06   ] , 'vcmpnlesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(134, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(135, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(136, [$62,$F1,$D7,$2F,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(137, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(138, [$62,$F1,$D7,$2F,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(139, [$62,$F1,$D7,$1F,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(140, [$62,$F1,$D7,$2F,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(141, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$06   ] , 'vcmpnlesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(142, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(143, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(144, [$62,$F1,$D7,$2F,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(145, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(146, [$62,$F1,$D7,$2F,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(147, [$62,$F1,$D7,$1F,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(148, [$62,$F1,$D7,$2F,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(149, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$07   ] , 'vcmpordsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(150, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(151, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(152, [$62,$F1,$D7,$2F,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(153, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(154, [$62,$F1,$D7,$2F,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(155, [$62,$F1,$D7,$1F,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(156, [$62,$F1,$D7,$2F,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(157, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$07   ] , 'vcmpordsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(158, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(159, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(160, [$62,$F1,$D7,$2F,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(161, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(162, [$62,$F1,$D7,$2F,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(163, [$62,$F1,$D7,$1F,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(164, [$62,$F1,$D7,$2F,$C2,$29,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(165, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$08   ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(166, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(167, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(168, [$62,$F1,$D7,$2F,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(169, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(170, [$62,$F1,$D7,$2F,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(171, [$62,$F1,$D7,$1F,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(172, [$62,$F1,$D7,$2F,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(173, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$09   ] , 'vcmpngesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(174, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(175, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(176, [$62,$F1,$D7,$2F,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(177, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(178, [$62,$F1,$D7,$2F,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(179, [$62,$F1,$D7,$1F,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(180, [$62,$F1,$D7,$2F,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(181, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$09   ] , 'vcmpngesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(182, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(183, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(184, [$62,$F1,$D7,$2F,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(185, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(186, [$62,$F1,$D7,$2F,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(187, [$62,$F1,$D7,$1F,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(188, [$62,$F1,$D7,$2F,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(189, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0A   ] , 'vcmpngtsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(190, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(191, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(192, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(193, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(194, [$62,$F1,$D7,$2F,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(195, [$62,$F1,$D7,$1F,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(196, [$62,$F1,$D7,$2F,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(197, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0A   ] , 'vcmpngtsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(198, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(199, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(200, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(201, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(202, [$62,$F1,$D7,$2F,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(203, [$62,$F1,$D7,$1F,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(204, [$62,$F1,$D7,$2F,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(205, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0B   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(206, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(207, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(208, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(209, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(210, [$62,$F1,$D7,$2F,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(211, [$62,$F1,$D7,$1F,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(212, [$62,$F1,$D7,$2F,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(213, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0B   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(214, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(215, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(216, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(217, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(218, [$62,$F1,$D7,$2F,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(219, [$62,$F1,$D7,$1F,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(220, [$62,$F1,$D7,$2F,$C2,$29,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(221, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0C   ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(222, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(223, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(224, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(225, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(226, [$62,$F1,$D7,$2F,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(227, [$62,$F1,$D7,$1F,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(228, [$62,$F1,$D7,$2F,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(229, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0D   ] , 'vcmpgesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(230, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(231, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(232, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(233, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(234, [$62,$F1,$D7,$2F,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(235, [$62,$F1,$D7,$1F,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(236, [$62,$F1,$D7,$2F,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(237, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0D   ] , 'vcmpgesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(238, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(239, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(240, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(241, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(242, [$62,$F1,$D7,$2F,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(243, [$62,$F1,$D7,$1F,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(244, [$62,$F1,$D7,$2F,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(245, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0E   ] , 'vcmpgtsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(246, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(247, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(248, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(249, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(250, [$62,$F1,$D7,$2F,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(251, [$62,$F1,$D7,$1F,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(252, [$62,$F1,$D7,$2F,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(253, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0E   ] , 'vcmpgtsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(254, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(255, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(256, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(257, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(258, [$62,$F1,$D7,$2F,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm5,xmm4'                        );
  TestCase.testcase(259, [$62,$F1,$D7,$1F,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm5,xmm4,{sae}'                  );
  TestCase.testcase(260, [$62,$F1,$D7,$2F,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm5,qword [ecx]'                 );
  TestCase.testcase(261, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0F   ] , 'vcmuesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'   );
  TestCase.testcase(262, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm5,qword [edx+0x3f8]'           );
  TestCase.testcase(263, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm5,qword [edx+0x400]'           );
  TestCase.testcase(264, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm5,qword [edx-0x400]'           );
  TestCase.testcase(265, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm5,qword [edx-0x408]'           );
  TestCase.testcase(266, [$62,$F1,$D7,$2F,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm5,xmm4'                        );
  TestCase.testcase(267, [$62,$F1,$D7,$1F,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm5,xmm4,{sae}'                  );
  TestCase.testcase(268, [$62,$F1,$D7,$2F,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm5,qword [ecx]'                 );
  TestCase.testcase(269, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0F   ] , 'vcmuesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'   );
  TestCase.testcase(270, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm5,qword [edx+0x3f8]'           );
  TestCase.testcase(271, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm5,qword [edx+0x400]'           );
  TestCase.testcase(272, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm5,qword [edx-0x400]'           );
  TestCase.testcase(273, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm5,qword [edx-0x408]'           );
  TestCase.testcase(274, [$62,$F1,$D7,$2F,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(275, [$62,$F1,$D7,$1F,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(276, [$62,$F1,$D7,$2F,$C2,$29,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(277, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$10   ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(278, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(279, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$10       ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(280, [$62,$F1,$D7,$2F,$C2,$6A,$80,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(281, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$10       ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(282, [$62,$F1,$D7,$2F,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(283, [$62,$F1,$D7,$1F,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(284, [$62,$F1,$D7,$2F,$C2,$29,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(285, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$11   ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(286, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(287, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$11       ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(288, [$62,$F1,$D7,$2F,$C2,$6A,$80,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(289, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$11       ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(290, [$62,$F1,$D7,$2F,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(291, [$62,$F1,$D7,$1F,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(292, [$62,$F1,$D7,$2F,$C2,$29,$12                       ] , 'vcmple_oqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(293, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$12   ] , 'vcmple_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(294, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$12                   ] , 'vcmple_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(295, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$12       ] , 'vcmple_oqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(296, [$62,$F1,$D7,$2F,$C2,$6A,$80,$12                   ] , 'vcmple_oqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(297, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$12       ] , 'vcmple_oqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(298, [$62,$F1,$D7,$2F,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm5,xmm4'                  );
  TestCase.testcase(299, [$62,$F1,$D7,$1F,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm5,xmm4,{sae}'            );
  TestCase.testcase(300, [$62,$F1,$D7,$2F,$C2,$29,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(301, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$13   ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(302, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(303, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$13       ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(304, [$62,$F1,$D7,$2F,$C2,$6A,$80,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(305, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$13       ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(306, [$62,$F1,$D7,$2F,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(307, [$62,$F1,$D7,$1F,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(308, [$62,$F1,$D7,$2F,$C2,$29,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(309, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$14   ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(310, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(311, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$14       ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(312, [$62,$F1,$D7,$2F,$C2,$6A,$80,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(313, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$14       ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(314, [$62,$F1,$D7,$2F,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(315, [$62,$F1,$D7,$1F,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(316, [$62,$F1,$D7,$2F,$C2,$29,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(317, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$15   ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(318, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(319, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(320, [$62,$F1,$D7,$2F,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(321, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(322, [$62,$F1,$D7,$2F,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(323, [$62,$F1,$D7,$1F,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(324, [$62,$F1,$D7,$2F,$C2,$29,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(325, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$16   ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(326, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(327, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(328, [$62,$F1,$D7,$2F,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(329, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(330, [$62,$F1,$D7,$2F,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(331, [$62,$F1,$D7,$1F,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(332, [$62,$F1,$D7,$2F,$C2,$29,$17                       ] , 'vcmpord_ssd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(333, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$17   ] , 'vcmpord_ssd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(334, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$17                   ] , 'vcmpord_ssd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(335, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$17       ] , 'vcmpord_ssd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(336, [$62,$F1,$D7,$2F,$C2,$6A,$80,$17                   ] , 'vcmpord_ssd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(337, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$17       ] , 'vcmpord_ssd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(338, [$62,$F1,$D7,$2F,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(339, [$62,$F1,$D7,$1F,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(340, [$62,$F1,$D7,$2F,$C2,$29,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(341, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$18   ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(342, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(343, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$18       ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(344, [$62,$F1,$D7,$2F,$C2,$6A,$80,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(345, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$18       ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(346, [$62,$F1,$D7,$2F,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(347, [$62,$F1,$D7,$1F,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(348, [$62,$F1,$D7,$2F,$C2,$29,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(349, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$19   ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(350, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(351, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(352, [$62,$F1,$D7,$2F,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(353, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(354, [$62,$F1,$D7,$2F,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(355, [$62,$F1,$D7,$1F,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(356, [$62,$F1,$D7,$2F,$C2,$29,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(357, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1A   ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(358, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(359, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(360, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(361, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(362, [$62,$F1,$D7,$2F,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm5,xmm4'                 );
  TestCase.testcase(363, [$62,$F1,$D7,$1F,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm5,xmm4,{sae}'           );
  TestCase.testcase(364, [$62,$F1,$D7,$2F,$C2,$29,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(365, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1B   ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(366, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(367, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(368, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(369, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(370, [$62,$F1,$D7,$2F,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(371, [$62,$F1,$D7,$1F,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(372, [$62,$F1,$D7,$2F,$C2,$29,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(373, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1C   ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(374, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(375, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(376, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(377, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(378, [$62,$F1,$D7,$2F,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(379, [$62,$F1,$D7,$1F,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(380, [$62,$F1,$D7,$2F,$C2,$29,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(381, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1D   ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(382, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(383, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(384, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(385, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(386, [$62,$F1,$D7,$2F,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(387, [$62,$F1,$D7,$1F,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(388, [$62,$F1,$D7,$2F,$C2,$29,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(389, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1E   ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(390, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(391, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(392, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(393, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(394, [$62,$F1,$D7,$2F,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm5,xmm4'                     );
  TestCase.testcase(395, [$62,$F1,$D7,$1F,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(396, [$62,$F1,$D7,$2F,$C2,$29,$1F                       ] , 'vcmue_ussd  k5{k7},xmm5,qword [ecx]'              );
  TestCase.testcase(397, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1F   ] , 'vcmue_ussd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(398, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1F                   ] , 'vcmue_ussd  k5{k7},xmm5,qword [edx+0x3f8]'        );
  TestCase.testcase(399, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1F       ] , 'vcmue_ussd  k5{k7},xmm5,qword [edx+0x400]'        );
  TestCase.testcase(400, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1F                   ] , 'vcmue_ussd  k5{k7},xmm5,qword [edx-0x400]'        );
  TestCase.testcase(401, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1F       ] , 'vcmue_ussd  k5{k7},xmm5,qword [edx-0x408]'        );
  TestCase.testcase(402, [$62,$F1,$56,$2F,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm5,xmm4,0xab'                    );
  TestCase.testcase(403, [$62,$F1,$56,$1F,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm5,xmm4,{sae},0xab'              );
  TestCase.testcase(404, [$62,$F1,$56,$2F,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm5,xmm4,0x7b'                    );
  TestCase.testcase(405, [$62,$F1,$56,$1F,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm5,xmm4,{sae},0x7b'              );
  TestCase.testcase(406, [$62,$F1,$56,$2F,$C2,$29,$7B                       ] , 'vcmpss  k5{k7},xmm5,dword [ecx],0x7b'             );
  TestCase.testcase(407, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vcmpss  k5{k7},xmm5,dword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(408, [$62,$F1,$56,$2F,$C2,$6A,$7F,$7B                   ] , 'vcmpss  k5{k7},xmm5,dword [edx+0x1fc],0x7b'       );
  TestCase.testcase(409, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$7B       ] , 'vcmpss  k5{k7},xmm5,dword [edx+0x200],0x7b'       );
  TestCase.testcase(410, [$62,$F1,$56,$2F,$C2,$6A,$80,$7B                   ] , 'vcmpss  k5{k7},xmm5,dword [edx-0x200],0x7b'       );
  TestCase.testcase(411, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vcmpss  k5{k7},xmm5,dword [edx-0x204],0x7b'       );
  TestCase.testcase(412, [$62,$F1,$56,$2F,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(413, [$62,$F1,$56,$1F,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(414, [$62,$F1,$56,$2F,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(415, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$00   ] , 'vcmpeqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(416, [$62,$F1,$56,$2F,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(417, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(418, [$62,$F1,$56,$2F,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(419, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(420, [$62,$F1,$56,$2F,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(421, [$62,$F1,$56,$1F,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(422, [$62,$F1,$56,$2F,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(423, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$00   ] , 'vcmpeqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(424, [$62,$F1,$56,$2F,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(425, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(426, [$62,$F1,$56,$2F,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(427, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(428, [$62,$F1,$56,$2F,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(429, [$62,$F1,$56,$1F,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(430, [$62,$F1,$56,$2F,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(431, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$01   ] , 'vcmpltss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(432, [$62,$F1,$56,$2F,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(433, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(434, [$62,$F1,$56,$2F,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(435, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(436, [$62,$F1,$56,$2F,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(437, [$62,$F1,$56,$1F,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(438, [$62,$F1,$56,$2F,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(439, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$01   ] , 'vcmpltss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(440, [$62,$F1,$56,$2F,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(441, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(442, [$62,$F1,$56,$2F,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(443, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(444, [$62,$F1,$56,$2F,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(445, [$62,$F1,$56,$1F,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(446, [$62,$F1,$56,$2F,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(447, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$02   ] , 'vcmpless  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(448, [$62,$F1,$56,$2F,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(449, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(450, [$62,$F1,$56,$2F,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(451, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(452, [$62,$F1,$56,$2F,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(453, [$62,$F1,$56,$1F,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(454, [$62,$F1,$56,$2F,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(455, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$02   ] , 'vcmpless  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(456, [$62,$F1,$56,$2F,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(457, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(458, [$62,$F1,$56,$2F,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(459, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(460, [$62,$F1,$56,$2F,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(461, [$62,$F1,$56,$1F,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(462, [$62,$F1,$56,$2F,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(463, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$03   ] , 'vcmpunordss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(464, [$62,$F1,$56,$2F,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(465, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(466, [$62,$F1,$56,$2F,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(467, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(468, [$62,$F1,$56,$2F,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(469, [$62,$F1,$56,$1F,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(470, [$62,$F1,$56,$2F,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(471, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$03   ] , 'vcmpunordss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(472, [$62,$F1,$56,$2F,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(473, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(474, [$62,$F1,$56,$2F,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(475, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(476, [$62,$F1,$56,$2F,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(477, [$62,$F1,$56,$1F,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(478, [$62,$F1,$56,$2F,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(479, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$04   ] , 'vcmpneqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(480, [$62,$F1,$56,$2F,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(481, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(482, [$62,$F1,$56,$2F,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(483, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(484, [$62,$F1,$56,$2F,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(485, [$62,$F1,$56,$1F,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(486, [$62,$F1,$56,$2F,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(487, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$04   ] , 'vcmpneqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(488, [$62,$F1,$56,$2F,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(489, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(490, [$62,$F1,$56,$2F,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(491, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(492, [$62,$F1,$56,$2F,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(493, [$62,$F1,$56,$1F,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(494, [$62,$F1,$56,$2F,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(495, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$05   ] , 'vcmpnltss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(496, [$62,$F1,$56,$2F,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(497, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(498, [$62,$F1,$56,$2F,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(499, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(500, [$62,$F1,$56,$2F,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(501, [$62,$F1,$56,$1F,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(502, [$62,$F1,$56,$2F,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(503, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$05   ] , 'vcmpnltss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(504, [$62,$F1,$56,$2F,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(505, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(506, [$62,$F1,$56,$2F,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(507, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(508, [$62,$F1,$56,$2F,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(509, [$62,$F1,$56,$1F,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(510, [$62,$F1,$56,$2F,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(511, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$06   ] , 'vcmpnless  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(512, [$62,$F1,$56,$2F,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(513, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(514, [$62,$F1,$56,$2F,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(515, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(516, [$62,$F1,$56,$2F,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(517, [$62,$F1,$56,$1F,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(518, [$62,$F1,$56,$2F,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(519, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$06   ] , 'vcmpnless  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(520, [$62,$F1,$56,$2F,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(521, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(522, [$62,$F1,$56,$2F,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(523, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(524, [$62,$F1,$56,$2F,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(525, [$62,$F1,$56,$1F,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(526, [$62,$F1,$56,$2F,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(527, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$07   ] , 'vcmpordss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(528, [$62,$F1,$56,$2F,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(529, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(530, [$62,$F1,$56,$2F,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(531, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(532, [$62,$F1,$56,$2F,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(533, [$62,$F1,$56,$1F,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(534, [$62,$F1,$56,$2F,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(535, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$07   ] , 'vcmpordss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(536, [$62,$F1,$56,$2F,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(537, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(538, [$62,$F1,$56,$2F,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(539, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(540, [$62,$F1,$56,$2F,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(541, [$62,$F1,$56,$1F,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(542, [$62,$F1,$56,$2F,$C2,$29,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(543, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$08   ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(544, [$62,$F1,$56,$2F,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(545, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$08       ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(546, [$62,$F1,$56,$2F,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(547, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$08       ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(548, [$62,$F1,$56,$2F,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(549, [$62,$F1,$56,$1F,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(550, [$62,$F1,$56,$2F,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(551, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$09   ] , 'vcmpngess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(552, [$62,$F1,$56,$2F,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(553, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(554, [$62,$F1,$56,$2F,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(555, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(556, [$62,$F1,$56,$2F,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(557, [$62,$F1,$56,$1F,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(558, [$62,$F1,$56,$2F,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(559, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$09   ] , 'vcmpngess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(560, [$62,$F1,$56,$2F,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(561, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(562, [$62,$F1,$56,$2F,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(563, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(564, [$62,$F1,$56,$2F,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(565, [$62,$F1,$56,$1F,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(566, [$62,$F1,$56,$2F,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(567, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0A   ] , 'vcmpngtss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(568, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(569, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(570, [$62,$F1,$56,$2F,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(571, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(572, [$62,$F1,$56,$2F,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(573, [$62,$F1,$56,$1F,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(574, [$62,$F1,$56,$2F,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(575, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0A   ] , 'vcmpngtss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(576, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(577, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(578, [$62,$F1,$56,$2F,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(579, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(580, [$62,$F1,$56,$2F,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(581, [$62,$F1,$56,$1F,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(582, [$62,$F1,$56,$2F,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(583, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0B   ] , 'vcmpfalsess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(584, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(585, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(586, [$62,$F1,$56,$2F,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(587, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(588, [$62,$F1,$56,$2F,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(589, [$62,$F1,$56,$1F,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(590, [$62,$F1,$56,$2F,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(591, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0B   ] , 'vcmpfalsess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(592, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(593, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(594, [$62,$F1,$56,$2F,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(595, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(596, [$62,$F1,$56,$2F,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(597, [$62,$F1,$56,$1F,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(598, [$62,$F1,$56,$2F,$C2,$29,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(599, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0C   ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(600, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(601, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(602, [$62,$F1,$56,$2F,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(603, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(604, [$62,$F1,$56,$2F,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(605, [$62,$F1,$56,$1F,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(606, [$62,$F1,$56,$2F,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(607, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0D   ] , 'vcmpgess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(608, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(609, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(610, [$62,$F1,$56,$2F,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(611, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(612, [$62,$F1,$56,$2F,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(613, [$62,$F1,$56,$1F,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(614, [$62,$F1,$56,$2F,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(615, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0D   ] , 'vcmpgess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(616, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(617, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(618, [$62,$F1,$56,$2F,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(619, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(620, [$62,$F1,$56,$2F,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(621, [$62,$F1,$56,$1F,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(622, [$62,$F1,$56,$2F,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(623, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0E   ] , 'vcmpgtss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(624, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(625, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(626, [$62,$F1,$56,$2F,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(627, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(628, [$62,$F1,$56,$2F,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(629, [$62,$F1,$56,$1F,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(630, [$62,$F1,$56,$2F,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(631, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0E   ] , 'vcmpgtss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(632, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(633, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(634, [$62,$F1,$56,$2F,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(635, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(636, [$62,$F1,$56,$2F,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm5,xmm4'                        );
  TestCase.testcase(637, [$62,$F1,$56,$1F,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm5,xmm4,{sae}'                  );
  TestCase.testcase(638, [$62,$F1,$56,$2F,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm5,dword [ecx]'                 );
  TestCase.testcase(639, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0F   ] , 'vcmuess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'   );
  TestCase.testcase(640, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm5,dword [edx+0x1fc]'           );
  TestCase.testcase(641, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm5,dword [edx+0x200]'           );
  TestCase.testcase(642, [$62,$F1,$56,$2F,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm5,dword [edx-0x200]'           );
  TestCase.testcase(643, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm5,dword [edx-0x204]'           );
  TestCase.testcase(644, [$62,$F1,$56,$2F,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm5,xmm4'                        );
  TestCase.testcase(645, [$62,$F1,$56,$1F,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm5,xmm4,{sae}'                  );
  TestCase.testcase(646, [$62,$F1,$56,$2F,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm5,dword [ecx]'                 );
  TestCase.testcase(647, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0F   ] , 'vcmuess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'   );
  TestCase.testcase(648, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm5,dword [edx+0x1fc]'           );
  TestCase.testcase(649, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm5,dword [edx+0x200]'           );
  TestCase.testcase(650, [$62,$F1,$56,$2F,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm5,dword [edx-0x200]'           );
  TestCase.testcase(651, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm5,dword [edx-0x204]'           );
  TestCase.testcase(652, [$62,$F1,$56,$2F,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(653, [$62,$F1,$56,$1F,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(654, [$62,$F1,$56,$2F,$C2,$29,$10                       ] , 'vcmpeq_osss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(655, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$10   ] , 'vcmpeq_osss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(656, [$62,$F1,$56,$2F,$C2,$6A,$7F,$10                   ] , 'vcmpeq_osss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(657, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$10       ] , 'vcmpeq_osss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(658, [$62,$F1,$56,$2F,$C2,$6A,$80,$10                   ] , 'vcmpeq_osss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(659, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$10       ] , 'vcmpeq_osss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(660, [$62,$F1,$56,$2F,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(661, [$62,$F1,$56,$1F,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(662, [$62,$F1,$56,$2F,$C2,$29,$11                       ] , 'vcmplt_oqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(663, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$11   ] , 'vcmplt_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(664, [$62,$F1,$56,$2F,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(665, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$11       ] , 'vcmplt_oqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(666, [$62,$F1,$56,$2F,$C2,$6A,$80,$11                   ] , 'vcmplt_oqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(667, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$11       ] , 'vcmplt_oqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(668, [$62,$F1,$56,$2F,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(669, [$62,$F1,$56,$1F,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(670, [$62,$F1,$56,$2F,$C2,$29,$12                       ] , 'vcmple_oqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(671, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$12   ] , 'vcmple_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(672, [$62,$F1,$56,$2F,$C2,$6A,$7F,$12                   ] , 'vcmple_oqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(673, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$12       ] , 'vcmple_oqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(674, [$62,$F1,$56,$2F,$C2,$6A,$80,$12                   ] , 'vcmple_oqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(675, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$12       ] , 'vcmple_oqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(676, [$62,$F1,$56,$2F,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm5,xmm4'                  );
  TestCase.testcase(677, [$62,$F1,$56,$1F,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm5,xmm4,{sae}'            );
  TestCase.testcase(678, [$62,$F1,$56,$2F,$C2,$29,$13                       ] , 'vcmpunord_sss  k5{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(679, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$13   ] , 'vcmpunord_sss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(680, [$62,$F1,$56,$2F,$C2,$6A,$7F,$13                   ] , 'vcmpunord_sss  k5{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(681, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$13       ] , 'vcmpunord_sss  k5{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(682, [$62,$F1,$56,$2F,$C2,$6A,$80,$13                   ] , 'vcmpunord_sss  k5{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(683, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$13       ] , 'vcmpunord_sss  k5{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(684, [$62,$F1,$56,$2F,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(685, [$62,$F1,$56,$1F,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(686, [$62,$F1,$56,$2F,$C2,$29,$14                       ] , 'vcmpneq_usss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(687, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$14   ] , 'vcmpneq_usss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(688, [$62,$F1,$56,$2F,$C2,$6A,$7F,$14                   ] , 'vcmpneq_usss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(689, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$14       ] , 'vcmpneq_usss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(690, [$62,$F1,$56,$2F,$C2,$6A,$80,$14                   ] , 'vcmpneq_usss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(691, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$14       ] , 'vcmpneq_usss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(692, [$62,$F1,$56,$2F,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(693, [$62,$F1,$56,$1F,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(694, [$62,$F1,$56,$2F,$C2,$29,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(695, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$15   ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(696, [$62,$F1,$56,$2F,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(697, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(698, [$62,$F1,$56,$2F,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(699, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(700, [$62,$F1,$56,$2F,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(701, [$62,$F1,$56,$1F,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(702, [$62,$F1,$56,$2F,$C2,$29,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(703, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$16   ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(704, [$62,$F1,$56,$2F,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(705, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$16       ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(706, [$62,$F1,$56,$2F,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(707, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$16       ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(708, [$62,$F1,$56,$2F,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(709, [$62,$F1,$56,$1F,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(710, [$62,$F1,$56,$2F,$C2,$29,$17                       ] , 'vcmpord_sss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(711, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$17   ] , 'vcmpord_sss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(712, [$62,$F1,$56,$2F,$C2,$6A,$7F,$17                   ] , 'vcmpord_sss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(713, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$17       ] , 'vcmpord_sss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(714, [$62,$F1,$56,$2F,$C2,$6A,$80,$17                   ] , 'vcmpord_sss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(715, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$17       ] , 'vcmpord_sss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(716, [$62,$F1,$56,$2F,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(717, [$62,$F1,$56,$1F,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(718, [$62,$F1,$56,$2F,$C2,$29,$18                       ] , 'vcmpeq_usss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(719, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$18   ] , 'vcmpeq_usss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(720, [$62,$F1,$56,$2F,$C2,$6A,$7F,$18                   ] , 'vcmpeq_usss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(721, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$18       ] , 'vcmpeq_usss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(722, [$62,$F1,$56,$2F,$C2,$6A,$80,$18                   ] , 'vcmpeq_usss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(723, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$18       ] , 'vcmpeq_usss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(724, [$62,$F1,$56,$2F,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(725, [$62,$F1,$56,$1F,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(726, [$62,$F1,$56,$2F,$C2,$29,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(727, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$19   ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(728, [$62,$F1,$56,$2F,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(729, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$19       ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(730, [$62,$F1,$56,$2F,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(731, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$19       ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(732, [$62,$F1,$56,$2F,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(733, [$62,$F1,$56,$1F,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(734, [$62,$F1,$56,$2F,$C2,$29,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(735, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1A   ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(736, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(737, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(738, [$62,$F1,$56,$2F,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(739, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(740, [$62,$F1,$56,$2F,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm5,xmm4'                 );
  TestCase.testcase(741, [$62,$F1,$56,$1F,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm5,xmm4,{sae}'           );
  TestCase.testcase(742, [$62,$F1,$56,$2F,$C2,$29,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(743, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1B   ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(744, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(745, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(746, [$62,$F1,$56,$2F,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(747, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(748, [$62,$F1,$56,$2F,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(749, [$62,$F1,$56,$1F,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(750, [$62,$F1,$56,$2F,$C2,$29,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(751, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1C   ] , 'vcmpneq_osss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(752, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(753, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1C       ] , 'vcmpneq_osss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(754, [$62,$F1,$56,$2F,$C2,$6A,$80,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(755, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1C       ] , 'vcmpneq_osss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(756, [$62,$F1,$56,$2F,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(757, [$62,$F1,$56,$1F,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(758, [$62,$F1,$56,$2F,$C2,$29,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(759, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1D   ] , 'vcmpge_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(760, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(761, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1D       ] , 'vcmpge_oqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(762, [$62,$F1,$56,$2F,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(763, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1D       ] , 'vcmpge_oqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(764, [$62,$F1,$56,$2F,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(765, [$62,$F1,$56,$1F,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(766, [$62,$F1,$56,$2F,$C2,$29,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(767, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1E   ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(768, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(769, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(770, [$62,$F1,$56,$2F,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(771, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(772, [$62,$F1,$56,$2F,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm5,xmm4'                     );
  TestCase.testcase(773, [$62,$F1,$56,$1F,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(774, [$62,$F1,$56,$2F,$C2,$29,$1F                       ] , 'vcmue_usss  k5{k7},xmm5,dword [ecx]'              );
  TestCase.testcase(775, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1F   ] , 'vcmue_usss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(776, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1F                   ] , 'vcmue_usss  k5{k7},xmm5,dword [edx+0x1fc]'        );
  TestCase.testcase(777, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1F       ] , 'vcmue_usss  k5{k7},xmm5,dword [edx+0x200]'        );
  TestCase.testcase(778, [$62,$F1,$56,$2F,$C2,$6A,$80,$1F                   ] , 'vcmue_usss  k5{k7},xmm5,dword [edx-0x200]'        );
  TestCase.testcase(779, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1F       ] , 'vcmue_usss  k5{k7},xmm5,dword [edx-0x204]'        );
  TestCase.testcase(780, [$62,$F1,$FD,$18,$2F,$F5                           ] , 'vcomisd  xmm6,xmm5,{sae}'                         );
  TestCase.testcase(781, [$62,$F1,$7C,$18,$2F,$F5                           ] , 'vcomiss  xmm6,xmm5,{sae}'                         );
  TestCase.testcase(782, [$62,$F1,$7F,$18,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm6,{rn-sae}'                     );
  TestCase.testcase(783, [$62,$F1,$7F,$58,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm6,{ru-sae}'                     );
  TestCase.testcase(784, [$62,$F1,$7F,$38,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm6,{rd-sae}'                     );
  TestCase.testcase(785, [$62,$F1,$7F,$78,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm6,{rz-sae}'                     );
  TestCase.testcase(786, [$62,$F1,$7F,$18,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm6,{rn-sae}'                     );
  TestCase.testcase(787, [$62,$F1,$7F,$58,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm6,{ru-sae}'                     );
  TestCase.testcase(788, [$62,$F1,$7F,$38,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm6,{rd-sae}'                     );
  TestCase.testcase(789, [$62,$F1,$7F,$78,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm6,{rz-sae}'                     );
  TestCase.testcase(790, [$62,$F1,$D7,$2F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(791, [$62,$F1,$D7,$AF,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(792, [$62,$F1,$D7,$1F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4,{rn-sae}'           );
  TestCase.testcase(793, [$62,$F1,$D7,$5F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4,{ru-sae}'           );
  TestCase.testcase(794, [$62,$F1,$D7,$3F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4,{rd-sae}'           );
  TestCase.testcase(795, [$62,$F1,$D7,$7F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4,{rz-sae}'           );
  TestCase.testcase(796, [$62,$F1,$D7,$2F,$5A,$31                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(797, [$62,$F1,$D7,$2F,$5A,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(798, [$62,$F1,$D7,$2F,$5A,$72,$7F                       ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(799, [$62,$F1,$D7,$2F,$5A,$B2,$00,$04,$00,$00           ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(800, [$62,$F1,$D7,$2F,$5A,$72,$80                       ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(801, [$62,$F1,$D7,$2F,$5A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(802, [$62,$F1,$56,$18,$2A,$F0                           ] , 'vcvtsi2ss  xmm6,xmm5,{rn-sae},eax'                );
  TestCase.testcase(803, [$62,$F1,$56,$58,$2A,$F0                           ] , 'vcvtsi2ss  xmm6,xmm5,{ru-sae},eax'                );
  TestCase.testcase(804, [$62,$F1,$56,$38,$2A,$F0                           ] , 'vcvtsi2ss  xmm6,xmm5,{rd-sae},eax'                );
  TestCase.testcase(805, [$62,$F1,$56,$78,$2A,$F0                           ] , 'vcvtsi2ss  xmm6,xmm5,{rz-sae},eax'                );
  TestCase.testcase(806, [$62,$F1,$56,$18,$2A,$F5                           ] , 'vcvtsi2ss  xmm6,xmm5,{rn-sae},ebp'                );
  TestCase.testcase(807, [$62,$F1,$56,$58,$2A,$F5                           ] , 'vcvtsi2ss  xmm6,xmm5,{ru-sae},ebp'                );
  TestCase.testcase(808, [$62,$F1,$56,$38,$2A,$F5                           ] , 'vcvtsi2ss  xmm6,xmm5,{rd-sae},ebp'                );
  TestCase.testcase(809, [$62,$F1,$56,$78,$2A,$F5                           ] , 'vcvtsi2ss  xmm6,xmm5,{rz-sae},ebp'                );
  TestCase.testcase(810, [$62,$F1,$56,$2F,$5A,$F4                           ] , 'vcvtss2sd  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(811, [$62,$F1,$56,$AF,$5A,$F4                           ] , 'vcvtss2sd  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(812, [$62,$F1,$56,$1F,$5A,$F4                           ] , 'vcvtss2sd  xmm6{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(813, [$62,$F1,$56,$2F,$5A,$31                           ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(814, [$62,$F1,$56,$2F,$5A,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(815, [$62,$F1,$56,$2F,$5A,$72,$7F                       ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(816, [$62,$F1,$56,$2F,$5A,$B2,$00,$02,$00,$00           ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(817, [$62,$F1,$56,$2F,$5A,$72,$80                       ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(818, [$62,$F1,$56,$2F,$5A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(819, [$62,$F1,$7E,$18,$2D,$C6                           ] , 'vcvtss2si  eax,xmm6,{rn-sae}'                     );
  TestCase.testcase(820, [$62,$F1,$7E,$58,$2D,$C6                           ] , 'vcvtss2si  eax,xmm6,{ru-sae}'                     );
  TestCase.testcase(821, [$62,$F1,$7E,$38,$2D,$C6                           ] , 'vcvtss2si  eax,xmm6,{rd-sae}'                     );
  TestCase.testcase(822, [$62,$F1,$7E,$78,$2D,$C6                           ] , 'vcvtss2si  eax,xmm6,{rz-sae}'                     );
  TestCase.testcase(823, [$62,$F1,$7E,$18,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm6,{rn-sae}'                     );
  TestCase.testcase(824, [$62,$F1,$7E,$58,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm6,{ru-sae}'                     );
  TestCase.testcase(825, [$62,$F1,$7E,$38,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm6,{rd-sae}'                     );
  TestCase.testcase(826, [$62,$F1,$7E,$78,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm6,{rz-sae}'                     );
  TestCase.testcase(827, [$62,$F1,$7F,$18,$2C,$C6                           ] , 'vcvttsd2si  eax,xmm6,{sae}'                       );
  TestCase.testcase(828, [$62,$F1,$7F,$18,$2C,$EE                           ] , 'vcvttsd2si  ebp,xmm6,{sae}'                       );
  TestCase.testcase(829, [$62,$F1,$7E,$18,$2C,$C6                           ] , 'vcvttss2si  eax,xmm6,{sae}'                       );
  TestCase.testcase(830, [$62,$F1,$7E,$18,$2C,$EE                           ] , 'vcvttss2si  ebp,xmm6,{sae}'                       );
  TestCase.testcase(831, [$62,$F1,$D7,$2F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(832, [$62,$F1,$D7,$AF,$5E,$F4                           ] , 'vdivsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(833, [$62,$F1,$D7,$1F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(834, [$62,$F1,$D7,$5F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(835, [$62,$F1,$D7,$3F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(836, [$62,$F1,$D7,$7F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(837, [$62,$F1,$D7,$2F,$5E,$31                           ] , 'vdivsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(838, [$62,$F1,$D7,$2F,$5E,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vdivsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(839, [$62,$F1,$D7,$2F,$5E,$72,$7F                       ] , 'vdivsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(840, [$62,$F1,$D7,$2F,$5E,$B2,$00,$04,$00,$00           ] , 'vdivsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(841, [$62,$F1,$D7,$2F,$5E,$72,$80                       ] , 'vdivsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(842, [$62,$F1,$D7,$2F,$5E,$B2,$F8,$FB,$FF,$FF           ] , 'vdivsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(843, [$62,$F1,$56,$2F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(844, [$62,$F1,$56,$AF,$5E,$F4                           ] , 'vdivss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(845, [$62,$F1,$56,$1F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(846, [$62,$F1,$56,$5F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(847, [$62,$F1,$56,$3F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(848, [$62,$F1,$56,$7F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(849, [$62,$F1,$56,$2F,$5E,$31                           ] , 'vdivss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(850, [$62,$F1,$56,$2F,$5E,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vdivss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(851, [$62,$F1,$56,$2F,$5E,$72,$7F                       ] , 'vdivss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(852, [$62,$F1,$56,$2F,$5E,$B2,$00,$02,$00,$00           ] , 'vdivss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(853, [$62,$F1,$56,$2F,$5E,$72,$80                       ] , 'vdivss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(854, [$62,$F1,$56,$2F,$5E,$B2,$FC,$FD,$FF,$FF           ] , 'vdivss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(855, [$62,$F2,$D5,$2F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(856, [$62,$F2,$D5,$AF,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(857, [$62,$F2,$D5,$1F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(858, [$62,$F2,$D5,$5F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(859, [$62,$F2,$D5,$3F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(860, [$62,$F2,$D5,$7F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(861, [$62,$F2,$D5,$2F,$99,$31                           ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(862, [$62,$F2,$D5,$2F,$99,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(863, [$62,$F2,$D5,$2F,$99,$72,$7F                       ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(864, [$62,$F2,$D5,$2F,$99,$B2,$00,$04,$00,$00           ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(865, [$62,$F2,$D5,$2F,$99,$72,$80                       ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(866, [$62,$F2,$D5,$2F,$99,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(867, [$62,$F2,$55,$2F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(868, [$62,$F2,$55,$AF,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(869, [$62,$F2,$55,$1F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(870, [$62,$F2,$55,$5F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(871, [$62,$F2,$55,$3F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(872, [$62,$F2,$55,$7F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(873, [$62,$F2,$55,$2F,$99,$31                           ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(874, [$62,$F2,$55,$2F,$99,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(875, [$62,$F2,$55,$2F,$99,$72,$7F                       ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(876, [$62,$F2,$55,$2F,$99,$B2,$00,$02,$00,$00           ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(877, [$62,$F2,$55,$2F,$99,$72,$80                       ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(878, [$62,$F2,$55,$2F,$99,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(879, [$62,$F2,$D5,$2F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(880, [$62,$F2,$D5,$AF,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(881, [$62,$F2,$D5,$1F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(882, [$62,$F2,$D5,$5F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(883, [$62,$F2,$D5,$3F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(884, [$62,$F2,$D5,$7F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(885, [$62,$F2,$D5,$2F,$A9,$31                           ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(886, [$62,$F2,$D5,$2F,$A9,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(887, [$62,$F2,$D5,$2F,$A9,$72,$7F                       ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(888, [$62,$F2,$D5,$2F,$A9,$B2,$00,$04,$00,$00           ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(889, [$62,$F2,$D5,$2F,$A9,$72,$80                       ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(890, [$62,$F2,$D5,$2F,$A9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(891, [$62,$F2,$55,$2F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(892, [$62,$F2,$55,$AF,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(893, [$62,$F2,$55,$1F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(894, [$62,$F2,$55,$5F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(895, [$62,$F2,$55,$3F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(896, [$62,$F2,$55,$7F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(897, [$62,$F2,$55,$2F,$A9,$31                           ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(898, [$62,$F2,$55,$2F,$A9,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(899, [$62,$F2,$55,$2F,$A9,$72,$7F                       ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(900, [$62,$F2,$55,$2F,$A9,$B2,$00,$02,$00,$00           ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(901, [$62,$F2,$55,$2F,$A9,$72,$80                       ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(902, [$62,$F2,$55,$2F,$A9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(903, [$62,$F2,$D5,$2F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(904, [$62,$F2,$D5,$AF,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(905, [$62,$F2,$D5,$1F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(906, [$62,$F2,$D5,$5F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(907, [$62,$F2,$D5,$3F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(908, [$62,$F2,$D5,$7F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(909, [$62,$F2,$D5,$2F,$B9,$31                           ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(910, [$62,$F2,$D5,$2F,$B9,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(911, [$62,$F2,$D5,$2F,$B9,$72,$7F                       ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(912, [$62,$F2,$D5,$2F,$B9,$B2,$00,$04,$00,$00           ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(913, [$62,$F2,$D5,$2F,$B9,$72,$80                       ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(914, [$62,$F2,$D5,$2F,$B9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(915, [$62,$F2,$55,$2F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(916, [$62,$F2,$55,$AF,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(917, [$62,$F2,$55,$1F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(918, [$62,$F2,$55,$5F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(919, [$62,$F2,$55,$3F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(920, [$62,$F2,$55,$7F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(921, [$62,$F2,$55,$2F,$B9,$31                           ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(922, [$62,$F2,$55,$2F,$B9,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(923, [$62,$F2,$55,$2F,$B9,$72,$7F                       ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(924, [$62,$F2,$55,$2F,$B9,$B2,$00,$02,$00,$00           ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(925, [$62,$F2,$55,$2F,$B9,$72,$80                       ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(926, [$62,$F2,$55,$2F,$B9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(927, [$62,$F2,$D5,$2F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(928, [$62,$F2,$D5,$AF,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(929, [$62,$F2,$D5,$1F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(930, [$62,$F2,$D5,$5F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(931, [$62,$F2,$D5,$3F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(932, [$62,$F2,$D5,$7F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(933, [$62,$F2,$D5,$2F,$9B,$31                           ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(934, [$62,$F2,$D5,$2F,$9B,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(935, [$62,$F2,$D5,$2F,$9B,$72,$7F                       ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(936, [$62,$F2,$D5,$2F,$9B,$B2,$00,$04,$00,$00           ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(937, [$62,$F2,$D5,$2F,$9B,$72,$80                       ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(938, [$62,$F2,$D5,$2F,$9B,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(939, [$62,$F2,$55,$2F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(940, [$62,$F2,$55,$AF,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(941, [$62,$F2,$55,$1F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(942, [$62,$F2,$55,$5F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(943, [$62,$F2,$55,$3F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(944, [$62,$F2,$55,$7F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(945, [$62,$F2,$55,$2F,$9B,$31                           ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(946, [$62,$F2,$55,$2F,$9B,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(947, [$62,$F2,$55,$2F,$9B,$72,$7F                       ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(948, [$62,$F2,$55,$2F,$9B,$B2,$00,$02,$00,$00           ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(949, [$62,$F2,$55,$2F,$9B,$72,$80                       ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(950, [$62,$F2,$55,$2F,$9B,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(951, [$62,$F2,$D5,$2F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(952, [$62,$F2,$D5,$AF,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(953, [$62,$F2,$D5,$1F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(954, [$62,$F2,$D5,$5F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(955, [$62,$F2,$D5,$3F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(956, [$62,$F2,$D5,$7F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(957, [$62,$F2,$D5,$2F,$AB,$31                           ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(958, [$62,$F2,$D5,$2F,$AB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(959, [$62,$F2,$D5,$2F,$AB,$72,$7F                       ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(960, [$62,$F2,$D5,$2F,$AB,$B2,$00,$04,$00,$00           ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(961, [$62,$F2,$D5,$2F,$AB,$72,$80                       ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(962, [$62,$F2,$D5,$2F,$AB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(963, [$62,$F2,$55,$2F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(964, [$62,$F2,$55,$AF,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(965, [$62,$F2,$55,$1F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(966, [$62,$F2,$55,$5F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(967, [$62,$F2,$55,$3F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(968, [$62,$F2,$55,$7F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(969, [$62,$F2,$55,$2F,$AB,$31                           ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(970, [$62,$F2,$55,$2F,$AB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(971, [$62,$F2,$55,$2F,$AB,$72,$7F                       ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(972, [$62,$F2,$55,$2F,$AB,$B2,$00,$02,$00,$00           ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(973, [$62,$F2,$55,$2F,$AB,$72,$80                       ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(974, [$62,$F2,$55,$2F,$AB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(975, [$62,$F2,$D5,$2F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(976, [$62,$F2,$D5,$AF,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(977, [$62,$F2,$D5,$1F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(978, [$62,$F2,$D5,$5F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(979, [$62,$F2,$D5,$3F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(980, [$62,$F2,$D5,$7F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(981, [$62,$F2,$D5,$2F,$BB,$31                           ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(982, [$62,$F2,$D5,$2F,$BB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(983, [$62,$F2,$D5,$2F,$BB,$72,$7F                       ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(984, [$62,$F2,$D5,$2F,$BB,$B2,$00,$04,$00,$00           ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(985, [$62,$F2,$D5,$2F,$BB,$72,$80                       ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(986, [$62,$F2,$D5,$2F,$BB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(987, [$62,$F2,$55,$2F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(988, [$62,$F2,$55,$AF,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(989, [$62,$F2,$55,$1F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(990, [$62,$F2,$55,$5F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(991, [$62,$F2,$55,$3F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(992, [$62,$F2,$55,$7F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(993, [$62,$F2,$55,$2F,$BB,$31                           ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(994, [$62,$F2,$55,$2F,$BB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(995, [$62,$F2,$55,$2F,$BB,$72,$7F                       ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(996, [$62,$F2,$55,$2F,$BB,$B2,$00,$02,$00,$00           ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(997, [$62,$F2,$55,$2F,$BB,$72,$80                       ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(998, [$62,$F2,$55,$2F,$BB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(999, [$62,$F2,$D5,$2F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1000, [$62,$F2,$D5,$AF,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1001, [$62,$F2,$D5,$1F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1002, [$62,$F2,$D5,$5F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1003, [$62,$F2,$D5,$3F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1004, [$62,$F2,$D5,$7F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1005, [$62,$F2,$D5,$2F,$9D,$31                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(1006, [$62,$F2,$D5,$2F,$9D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1007, [$62,$F2,$D5,$2F,$9D,$72,$7F                       ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(1008, [$62,$F2,$D5,$2F,$9D,$B2,$00,$04,$00,$00           ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(1009, [$62,$F2,$D5,$2F,$9D,$72,$80                       ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(1010, [$62,$F2,$D5,$2F,$9D,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(1011, [$62,$F2,$55,$2F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1012, [$62,$F2,$55,$AF,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1013, [$62,$F2,$55,$1F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1014, [$62,$F2,$55,$5F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1015, [$62,$F2,$55,$3F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1016, [$62,$F2,$55,$7F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1017, [$62,$F2,$55,$2F,$9D,$31                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(1018, [$62,$F2,$55,$2F,$9D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1019, [$62,$F2,$55,$2F,$9D,$72,$7F                       ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(1020, [$62,$F2,$55,$2F,$9D,$B2,$00,$02,$00,$00           ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(1021, [$62,$F2,$55,$2F,$9D,$72,$80                       ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(1022, [$62,$F2,$55,$2F,$9D,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(1023, [$62,$F2,$D5,$2F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1024, [$62,$F2,$D5,$AF,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1025, [$62,$F2,$D5,$1F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1026, [$62,$F2,$D5,$5F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1027, [$62,$F2,$D5,$3F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1028, [$62,$F2,$D5,$7F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1029, [$62,$F2,$D5,$2F,$AD,$31                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(1030, [$62,$F2,$D5,$2F,$AD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1031, [$62,$F2,$D5,$2F,$AD,$72,$7F                       ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(1032, [$62,$F2,$D5,$2F,$AD,$B2,$00,$04,$00,$00           ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(1033, [$62,$F2,$D5,$2F,$AD,$72,$80                       ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(1034, [$62,$F2,$D5,$2F,$AD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(1035, [$62,$F2,$55,$2F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1036, [$62,$F2,$55,$AF,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1037, [$62,$F2,$55,$1F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1038, [$62,$F2,$55,$5F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1039, [$62,$F2,$55,$3F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1040, [$62,$F2,$55,$7F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1041, [$62,$F2,$55,$2F,$AD,$31                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(1042, [$62,$F2,$55,$2F,$AD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1043, [$62,$F2,$55,$2F,$AD,$72,$7F                       ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(1044, [$62,$F2,$55,$2F,$AD,$B2,$00,$02,$00,$00           ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(1045, [$62,$F2,$55,$2F,$AD,$72,$80                       ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(1046, [$62,$F2,$55,$2F,$AD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(1047, [$62,$F2,$D5,$2F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1048, [$62,$F2,$D5,$AF,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1049, [$62,$F2,$D5,$1F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1050, [$62,$F2,$D5,$5F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1051, [$62,$F2,$D5,$3F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1052, [$62,$F2,$D5,$7F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1053, [$62,$F2,$D5,$2F,$BD,$31                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(1054, [$62,$F2,$D5,$2F,$BD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1055, [$62,$F2,$D5,$2F,$BD,$72,$7F                       ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(1056, [$62,$F2,$D5,$2F,$BD,$B2,$00,$04,$00,$00           ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(1057, [$62,$F2,$D5,$2F,$BD,$72,$80                       ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(1058, [$62,$F2,$D5,$2F,$BD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(1059, [$62,$F2,$55,$2F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1060, [$62,$F2,$55,$AF,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1061, [$62,$F2,$55,$1F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1062, [$62,$F2,$55,$5F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1063, [$62,$F2,$55,$3F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1064, [$62,$F2,$55,$7F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1065, [$62,$F2,$55,$2F,$BD,$31                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(1066, [$62,$F2,$55,$2F,$BD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1067, [$62,$F2,$55,$2F,$BD,$72,$7F                       ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(1068, [$62,$F2,$55,$2F,$BD,$B2,$00,$02,$00,$00           ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(1069, [$62,$F2,$55,$2F,$BD,$72,$80                       ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(1070, [$62,$F2,$55,$2F,$BD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(1071, [$62,$F2,$D5,$2F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1072, [$62,$F2,$D5,$AF,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1073, [$62,$F2,$D5,$1F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1074, [$62,$F2,$D5,$5F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1075, [$62,$F2,$D5,$3F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1076, [$62,$F2,$D5,$7F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1077, [$62,$F2,$D5,$2F,$9F,$31                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(1078, [$62,$F2,$D5,$2F,$9F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1079, [$62,$F2,$D5,$2F,$9F,$72,$7F                       ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(1080, [$62,$F2,$D5,$2F,$9F,$B2,$00,$04,$00,$00           ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(1081, [$62,$F2,$D5,$2F,$9F,$72,$80                       ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(1082, [$62,$F2,$D5,$2F,$9F,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(1083, [$62,$F2,$55,$2F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1084, [$62,$F2,$55,$AF,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1085, [$62,$F2,$55,$1F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1086, [$62,$F2,$55,$5F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1087, [$62,$F2,$55,$3F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1088, [$62,$F2,$55,$7F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1089, [$62,$F2,$55,$2F,$9F,$31                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(1090, [$62,$F2,$55,$2F,$9F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1091, [$62,$F2,$55,$2F,$9F,$72,$7F                       ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(1092, [$62,$F2,$55,$2F,$9F,$B2,$00,$02,$00,$00           ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(1093, [$62,$F2,$55,$2F,$9F,$72,$80                       ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(1094, [$62,$F2,$55,$2F,$9F,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(1095, [$62,$F2,$D5,$2F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1096, [$62,$F2,$D5,$AF,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1097, [$62,$F2,$D5,$1F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1098, [$62,$F2,$D5,$5F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1099, [$62,$F2,$D5,$3F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1100, [$62,$F2,$D5,$7F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1101, [$62,$F2,$D5,$2F,$AF,$31                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(1102, [$62,$F2,$D5,$2F,$AF,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1103, [$62,$F2,$D5,$2F,$AF,$72,$7F                       ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(1104, [$62,$F2,$D5,$2F,$AF,$B2,$00,$04,$00,$00           ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(1105, [$62,$F2,$D5,$2F,$AF,$72,$80                       ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(1106, [$62,$F2,$D5,$2F,$AF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(1107, [$62,$F2,$55,$2F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1108, [$62,$F2,$55,$AF,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1109, [$62,$F2,$55,$1F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1110, [$62,$F2,$55,$5F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1111, [$62,$F2,$55,$3F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1112, [$62,$F2,$55,$7F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1113, [$62,$F2,$55,$2F,$AF,$31                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(1114, [$62,$F2,$55,$2F,$AF,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1115, [$62,$F2,$55,$2F,$AF,$72,$7F                       ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(1116, [$62,$F2,$55,$2F,$AF,$B2,$00,$02,$00,$00           ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(1117, [$62,$F2,$55,$2F,$AF,$72,$80                       ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(1118, [$62,$F2,$55,$2F,$AF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(1119, [$62,$F2,$D5,$2F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1120, [$62,$F2,$D5,$AF,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1121, [$62,$F2,$D5,$1F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1122, [$62,$F2,$D5,$5F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1123, [$62,$F2,$D5,$3F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1124, [$62,$F2,$D5,$7F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1125, [$62,$F2,$D5,$2F,$BF,$31                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(1126, [$62,$F2,$D5,$2F,$BF,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1127, [$62,$F2,$D5,$2F,$BF,$72,$7F                       ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(1128, [$62,$F2,$D5,$2F,$BF,$B2,$00,$04,$00,$00           ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(1129, [$62,$F2,$D5,$2F,$BF,$72,$80                       ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(1130, [$62,$F2,$D5,$2F,$BF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(1131, [$62,$F2,$55,$2F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(1132, [$62,$F2,$55,$AF,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(1133, [$62,$F2,$55,$1F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(1134, [$62,$F2,$55,$5F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(1135, [$62,$F2,$55,$3F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(1136, [$62,$F2,$55,$7F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(1137, [$62,$F2,$55,$2F,$BF,$31                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(1138, [$62,$F2,$55,$2F,$BF,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1139, [$62,$F2,$55,$2F,$BF,$72,$7F                       ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(1140, [$62,$F2,$55,$2F,$BF,$B2,$00,$02,$00,$00           ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(1141, [$62,$F2,$55,$2F,$BF,$72,$80                       ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(1142, [$62,$F2,$55,$2F,$BF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(1143, [$62,$F2,$D5,$2F,$43,$F4                           ] , 'vgetexpsd  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(1144, [$62,$F2,$D5,$AF,$43,$F4                           ] , 'vgetexpsd  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(1145, [$62,$F2,$D5,$1F,$43,$F4                           ] , 'vgetexpsd  xmm6{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1146, [$62,$F2,$D5,$2F,$43,$31                           ] , 'vgetexpsd  xmm6{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1147, [$62,$F2,$D5,$2F,$43,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vgetexpsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1148, [$62,$F2,$D5,$2F,$43,$72,$7F                       ] , 'vgetexpsd  xmm6{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1149, [$62,$F2,$D5,$2F,$43,$B2,$00,$04,$00,$00           ] , 'vgetexpsd  xmm6{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1150, [$62,$F2,$D5,$2F,$43,$72,$80                       ] , 'vgetexpsd  xmm6{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1151, [$62,$F2,$D5,$2F,$43,$B2,$F8,$FB,$FF,$FF           ] , 'vgetexpsd  xmm6{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1152, [$62,$F2,$55,$2F,$43,$F4                           ] , 'vgetexpss  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(1153, [$62,$F2,$55,$AF,$43,$F4                           ] , 'vgetexpss  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(1154, [$62,$F2,$55,$1F,$43,$F4                           ] , 'vgetexpss  xmm6{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1155, [$62,$F2,$55,$2F,$43,$31                           ] , 'vgetexpss  xmm6{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(1156, [$62,$F2,$55,$2F,$43,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vgetexpss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1157, [$62,$F2,$55,$2F,$43,$72,$7F                       ] , 'vgetexpss  xmm6{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(1158, [$62,$F2,$55,$2F,$43,$B2,$00,$02,$00,$00           ] , 'vgetexpss  xmm6{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(1159, [$62,$F2,$55,$2F,$43,$72,$80                       ] , 'vgetexpss  xmm6{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(1160, [$62,$F2,$55,$2F,$43,$B2,$FC,$FD,$FF,$FF           ] , 'vgetexpss  xmm6{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(1161, [$62,$F3,$D5,$2F,$27,$F4,$AB                       ] , 'vgetmantsd  xmm6{k7},xmm5,xmm4,0xab'              );
  TestCase.testcase(1162, [$62,$F3,$D5,$AF,$27,$F4,$AB                       ] , 'vgetmantsd  xmm6{k7}{z},xmm5,xmm4,0xab'           );
  TestCase.testcase(1163, [$62,$F3,$D5,$1F,$27,$F4,$AB                       ] , 'vgetmantsd  xmm6{k7},xmm5,xmm4,{sae},0xab'        );
  TestCase.testcase(1164, [$62,$F3,$D5,$2F,$27,$F4,$7B                       ] , 'vgetmantsd  xmm6{k7},xmm5,xmm4,0x7b'              );
  TestCase.testcase(1165, [$62,$F3,$D5,$1F,$27,$F4,$7B                       ] , 'vgetmantsd  xmm6{k7},xmm5,xmm4,{sae},0x7b'        );
  TestCase.testcase(1166, [$62,$F3,$D5,$2F,$27,$31,$7B                       ] , 'vgetmantsd  xmm6{k7},xmm5,qword [ecx],0x7b'       );
  TestCase.testcase(1167, [$62,$F3,$D5,$2F,$27,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vgetmantsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(1168, [$62,$F3,$D5,$2F,$27,$72,$7F,$7B                   ] , 'vgetmantsd  xmm6{k7},xmm5,qword [edx+0x3f8],0x7b' );
  TestCase.testcase(1169, [$62,$F3,$D5,$2F,$27,$B2,$00,$04,$00,$00,$7B       ] , 'vgetmantsd  xmm6{k7},xmm5,qword [edx+0x400],0x7b' );
  TestCase.testcase(1170, [$62,$F3,$D5,$2F,$27,$72,$80,$7B                   ] , 'vgetmantsd  xmm6{k7},xmm5,qword [edx-0x400],0x7b' );
  TestCase.testcase(1171, [$62,$F3,$D5,$2F,$27,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vgetmantsd  xmm6{k7},xmm5,qword [edx-0x408],0x7b' );
  TestCase.testcase(1172, [$62,$F3,$55,$2F,$27,$F4,$AB                       ] , 'vgetmantss  xmm6{k7},xmm5,xmm4,0xab'              );
  TestCase.testcase(1173, [$62,$F3,$55,$AF,$27,$F4,$AB                       ] , 'vgetmantss  xmm6{k7}{z},xmm5,xmm4,0xab'           );
  TestCase.testcase(1174, [$62,$F3,$55,$1F,$27,$F4,$AB                       ] , 'vgetmantss  xmm6{k7},xmm5,xmm4,{sae},0xab'        );
  TestCase.testcase(1175, [$62,$F3,$55,$2F,$27,$F4,$7B                       ] , 'vgetmantss  xmm6{k7},xmm5,xmm4,0x7b'              );
  TestCase.testcase(1176, [$62,$F3,$55,$1F,$27,$F4,$7B                       ] , 'vgetmantss  xmm6{k7},xmm5,xmm4,{sae},0x7b'        );
  TestCase.testcase(1177, [$62,$F3,$55,$2F,$27,$31,$7B                       ] , 'vgetmantss  xmm6{k7},xmm5,dword [ecx],0x7b'       );
  TestCase.testcase(1178, [$62,$F3,$55,$2F,$27,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vgetmantss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(1179, [$62,$F3,$55,$2F,$27,$72,$7F,$7B                   ] , 'vgetmantss  xmm6{k7},xmm5,dword [edx+0x1fc],0x7b' );
  TestCase.testcase(1180, [$62,$F3,$55,$2F,$27,$B2,$00,$02,$00,$00,$7B       ] , 'vgetmantss  xmm6{k7},xmm5,dword [edx+0x200],0x7b' );
  TestCase.testcase(1181, [$62,$F3,$55,$2F,$27,$72,$80,$7B                   ] , 'vgetmantss  xmm6{k7},xmm5,dword [edx-0x200],0x7b' );
  TestCase.testcase(1182, [$62,$F3,$55,$2F,$27,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vgetmantss  xmm6{k7},xmm5,dword [edx-0x204],0x7b' );
  TestCase.testcase(1183, [$62,$F1,$D7,$2F,$5F,$F4                           ] , 'vmaxsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1184, [$62,$F1,$D7,$AF,$5F,$F4                           ] , 'vmaxsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1185, [$62,$F1,$D7,$1F,$5F,$F4                           ] , 'vmaxsd  xmm6{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1186, [$62,$F1,$D7,$2F,$5F,$31                           ] , 'vmaxsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1187, [$62,$F1,$D7,$2F,$5F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmaxsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1188, [$62,$F1,$D7,$2F,$5F,$72,$7F                       ] , 'vmaxsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1189, [$62,$F1,$D7,$2F,$5F,$B2,$00,$04,$00,$00           ] , 'vmaxsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1190, [$62,$F1,$D7,$2F,$5F,$72,$80                       ] , 'vmaxsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1191, [$62,$F1,$D7,$2F,$5F,$B2,$F8,$FB,$FF,$FF           ] , 'vmaxsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1192, [$62,$F1,$56,$2F,$5F,$F4                           ] , 'vmaxss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1193, [$62,$F1,$56,$AF,$5F,$F4                           ] , 'vmaxss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1194, [$62,$F1,$56,$1F,$5F,$F4                           ] , 'vmaxss  xmm6{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1195, [$62,$F1,$56,$2F,$5F,$31                           ] , 'vmaxss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1196, [$62,$F1,$56,$2F,$5F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmaxss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1197, [$62,$F1,$56,$2F,$5F,$72,$7F                       ] , 'vmaxss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1198, [$62,$F1,$56,$2F,$5F,$B2,$00,$02,$00,$00           ] , 'vmaxss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1199, [$62,$F1,$56,$2F,$5F,$72,$80                       ] , 'vmaxss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1200, [$62,$F1,$56,$2F,$5F,$B2,$FC,$FD,$FF,$FF           ] , 'vmaxss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1201, [$62,$F1,$D7,$2F,$5D,$F4                           ] , 'vminsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1202, [$62,$F1,$D7,$AF,$5D,$F4                           ] , 'vminsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1203, [$62,$F1,$D7,$1F,$5D,$F4                           ] , 'vminsd  xmm6{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1204, [$62,$F1,$D7,$2F,$5D,$31                           ] , 'vminsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1205, [$62,$F1,$D7,$2F,$5D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vminsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1206, [$62,$F1,$D7,$2F,$5D,$72,$7F                       ] , 'vminsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1207, [$62,$F1,$D7,$2F,$5D,$B2,$00,$04,$00,$00           ] , 'vminsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1208, [$62,$F1,$D7,$2F,$5D,$72,$80                       ] , 'vminsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1209, [$62,$F1,$D7,$2F,$5D,$B2,$F8,$FB,$FF,$FF           ] , 'vminsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1210, [$62,$F1,$56,$2F,$5D,$F4                           ] , 'vminss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1211, [$62,$F1,$56,$AF,$5D,$F4                           ] , 'vminss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1212, [$62,$F1,$56,$1F,$5D,$F4                           ] , 'vminss  xmm6{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1213, [$62,$F1,$56,$2F,$5D,$31                           ] , 'vminss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1214, [$62,$F1,$56,$2F,$5D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vminss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1215, [$62,$F1,$56,$2F,$5D,$72,$7F                       ] , 'vminss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1216, [$62,$F1,$56,$2F,$5D,$B2,$00,$02,$00,$00           ] , 'vminss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1217, [$62,$F1,$56,$2F,$5D,$72,$80                       ] , 'vminss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1218, [$62,$F1,$56,$2F,$5D,$B2,$FC,$FD,$FF,$FF           ] , 'vminss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1219, [$62,$F1,$FF,$2F,$10,$31                           ] , 'vmovsd  xmm6{k7},qword [ecx]'                     );
  TestCase.testcase(1220, [$62,$F1,$FF,$AF,$10,$31                           ] , 'vmovsd  xmm6{k7}{z},qword [ecx]'                  );
  TestCase.testcase(1221, [$62,$F1,$FF,$2F,$10,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmovsd  xmm6{k7},qword [esp+esi*8-0x1e240]'       );
  TestCase.testcase(1222, [$62,$F1,$FF,$2F,$10,$72,$7F                       ] , 'vmovsd  xmm6{k7},qword [edx+0x3f8]'               );
  TestCase.testcase(1223, [$62,$F1,$FF,$2F,$10,$B2,$00,$04,$00,$00           ] , 'vmovsd  xmm6{k7},qword [edx+0x400]'               );
  TestCase.testcase(1224, [$62,$F1,$FF,$2F,$10,$72,$80                       ] , 'vmovsd  xmm6{k7},qword [edx-0x400]'               );
  TestCase.testcase(1225, [$62,$F1,$FF,$2F,$10,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  xmm6{k7},qword [edx-0x408]'               );
  TestCase.testcase(1226, [$62,$F1,$FF,$2F,$11,$31                           ] , 'vmovsd  qword [ecx]{k7},xmm6'                     );
  TestCase.testcase(1227, [$62,$F1,$FF,$2F,$11,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmovsd  qword [esp+esi*8-0x1e240]{k7},xmm6'       );
  TestCase.testcase(1228, [$62,$F1,$FF,$2F,$11,$72,$7F                       ] , 'vmovsd  qword [edx+0x3f8]{k7},xmm6'               );
  TestCase.testcase(1229, [$62,$F1,$FF,$2F,$11,$B2,$00,$04,$00,$00           ] , 'vmovsd  qword [edx+0x400]{k7},xmm6'               );
  TestCase.testcase(1230, [$62,$F1,$FF,$2F,$11,$72,$80                       ] , 'vmovsd  qword [edx-0x400]{k7},xmm6'               );
  TestCase.testcase(1231, [$62,$F1,$FF,$2F,$11,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  qword [edx-0x408]{k7},xmm6'               );
  TestCase.testcase(1232, [$62,$F1,$D7,$2F,$10,$F4                           ] , 'vmovsd  xmm6{k7},xmm5,ymm4'                       );
  TestCase.testcase(1233, [$62,$F1,$D7,$AF,$10,$F4                           ] , 'vmovsd  xmm6{k7}{z},xmm5,ymm4'                    );
  TestCase.testcase(1234, [$62,$F1,$7E,$2F,$10,$31                           ] , 'vmovss  xmm6{k7},dword [ecx]'                     );
  TestCase.testcase(1235, [$62,$F1,$7E,$AF,$10,$31                           ] , 'vmovss  xmm6{k7}{z},dword [ecx]'                  );
  TestCase.testcase(1236, [$62,$F1,$7E,$2F,$10,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmovss  xmm6{k7},dword [esp+esi*8-0x1e240]'       );
  TestCase.testcase(1237, [$62,$F1,$7E,$2F,$10,$72,$7F                       ] , 'vmovss  xmm6{k7},dword [edx+0x1fc]'               );
  TestCase.testcase(1238, [$62,$F1,$7E,$2F,$10,$B2,$00,$02,$00,$00           ] , 'vmovss  xmm6{k7},dword [edx+0x200]'               );
  TestCase.testcase(1239, [$62,$F1,$7E,$2F,$10,$72,$80                       ] , 'vmovss  xmm6{k7},dword [edx-0x200]'               );
  TestCase.testcase(1240, [$62,$F1,$7E,$2F,$10,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  xmm6{k7},dword [edx-0x204]'               );
  TestCase.testcase(1241, [$62,$F1,$7E,$2F,$11,$31                           ] , 'vmovss  dword [ecx]{k7},xmm6'                     );
  TestCase.testcase(1242, [$62,$F1,$7E,$2F,$11,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmovss  dword [esp+esi*8-0x1e240]{k7},xmm6'       );
  TestCase.testcase(1243, [$62,$F1,$7E,$2F,$11,$72,$7F                       ] , 'vmovss  dword [edx+0x1fc]{k7},xmm6'               );
  TestCase.testcase(1244, [$62,$F1,$7E,$2F,$11,$B2,$00,$02,$00,$00           ] , 'vmovss  dword [edx+0x200]{k7},xmm6'               );
  TestCase.testcase(1245, [$62,$F1,$7E,$2F,$11,$72,$80                       ] , 'vmovss  dword [edx-0x200]{k7},xmm6'               );
  TestCase.testcase(1246, [$62,$F1,$7E,$2F,$11,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  dword [edx-0x204]{k7},xmm6'               );
  TestCase.testcase(1247, [$62,$F1,$56,$2F,$10,$F4                           ] , 'vmovss  xmm6{k7},xmm5,ymm4'                       );
  TestCase.testcase(1248, [$62,$F1,$56,$AF,$10,$F4                           ] , 'vmovss  xmm6{k7}{z},xmm5,ymm4'                    );
  TestCase.testcase(1249, [$62,$F1,$D7,$2F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1250, [$62,$F1,$D7,$AF,$59,$F4                           ] , 'vmulsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1251, [$62,$F1,$D7,$1F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(1252, [$62,$F1,$D7,$5F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(1253, [$62,$F1,$D7,$3F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(1254, [$62,$F1,$D7,$7F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(1255, [$62,$F1,$D7,$2F,$59,$31                           ] , 'vmulsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1256, [$62,$F1,$D7,$2F,$59,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmulsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1257, [$62,$F1,$D7,$2F,$59,$72,$7F                       ] , 'vmulsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1258, [$62,$F1,$D7,$2F,$59,$B2,$00,$04,$00,$00           ] , 'vmulsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1259, [$62,$F1,$D7,$2F,$59,$72,$80                       ] , 'vmulsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1260, [$62,$F1,$D7,$2F,$59,$B2,$F8,$FB,$FF,$FF           ] , 'vmulsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1261, [$62,$F1,$56,$2F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1262, [$62,$F1,$56,$AF,$59,$F4                           ] , 'vmulss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1263, [$62,$F1,$56,$1F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(1264, [$62,$F1,$56,$5F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(1265, [$62,$F1,$56,$3F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(1266, [$62,$F1,$56,$7F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(1267, [$62,$F1,$56,$2F,$59,$31                           ] , 'vmulss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1268, [$62,$F1,$56,$2F,$59,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmulss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1269, [$62,$F1,$56,$2F,$59,$72,$7F                       ] , 'vmulss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1270, [$62,$F1,$56,$2F,$59,$B2,$00,$02,$00,$00           ] , 'vmulss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1271, [$62,$F1,$56,$2F,$59,$72,$80                       ] , 'vmulss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1272, [$62,$F1,$56,$2F,$59,$B2,$FC,$FD,$FF,$FF           ] , 'vmulss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1273, [$62,$F2,$D5,$2F,$4D,$F4                           ] , 'vrcp14sd  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(1274, [$62,$F2,$D5,$AF,$4D,$F4                           ] , 'vrcp14sd  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(1275, [$62,$F2,$D5,$2F,$4D,$31                           ] , 'vrcp14sd  xmm6{k7},xmm5,qword [ecx]'              );
  TestCase.testcase(1276, [$62,$F2,$D5,$2F,$4D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp14sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1277, [$62,$F2,$D5,$2F,$4D,$72,$7F                       ] , 'vrcp14sd  xmm6{k7},xmm5,qword [edx+0x3f8]'        );
  TestCase.testcase(1278, [$62,$F2,$D5,$2F,$4D,$B2,$00,$04,$00,$00           ] , 'vrcp14sd  xmm6{k7},xmm5,qword [edx+0x400]'        );
  TestCase.testcase(1279, [$62,$F2,$D5,$2F,$4D,$72,$80                       ] , 'vrcp14sd  xmm6{k7},xmm5,qword [edx-0x400]'        );
  TestCase.testcase(1280, [$62,$F2,$D5,$2F,$4D,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp14sd  xmm6{k7},xmm5,qword [edx-0x408]'        );
  TestCase.testcase(1281, [$62,$F2,$55,$2F,$4D,$F4                           ] , 'vrcp14ss  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(1282, [$62,$F2,$55,$AF,$4D,$F4                           ] , 'vrcp14ss  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(1283, [$62,$F2,$55,$2F,$4D,$31                           ] , 'vrcp14ss  xmm6{k7},xmm5,dword [ecx]'              );
  TestCase.testcase(1284, [$62,$F2,$55,$2F,$4D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp14ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1285, [$62,$F2,$55,$2F,$4D,$72,$7F                       ] , 'vrcp14ss  xmm6{k7},xmm5,dword [edx+0x1fc]'        );
  TestCase.testcase(1286, [$62,$F2,$55,$2F,$4D,$B2,$00,$02,$00,$00           ] , 'vrcp14ss  xmm6{k7},xmm5,dword [edx+0x200]'        );
  TestCase.testcase(1287, [$62,$F2,$55,$2F,$4D,$72,$80                       ] , 'vrcp14ss  xmm6{k7},xmm5,dword [edx-0x200]'        );
  TestCase.testcase(1288, [$62,$F2,$55,$2F,$4D,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp14ss  xmm6{k7},xmm5,dword [edx-0x204]'        );
  TestCase.testcase(1289, [$62,$F2,$55,$2F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(1290, [$62,$F2,$55,$AF,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(1291, [$62,$F2,$55,$1F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(1292, [$62,$F2,$55,$2F,$CB,$31                           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [ecx]'              );
  TestCase.testcase(1293, [$62,$F2,$55,$2F,$CB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1294, [$62,$F2,$55,$2F,$CB,$72,$7F                       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx+0x1fc]'        );
  TestCase.testcase(1295, [$62,$F2,$55,$2F,$CB,$B2,$00,$02,$00,$00           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx+0x200]'        );
  TestCase.testcase(1296, [$62,$F2,$55,$2F,$CB,$72,$80                       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx-0x200]'        );
  TestCase.testcase(1297, [$62,$F2,$55,$2F,$CB,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx-0x204]'        );
  TestCase.testcase(1298, [$62,$F2,$D5,$2F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(1299, [$62,$F2,$D5,$AF,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(1300, [$62,$F2,$D5,$1F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(1301, [$62,$F2,$D5,$2F,$CB,$31                           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [ecx]'              );
  TestCase.testcase(1302, [$62,$F2,$D5,$2F,$CB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1303, [$62,$F2,$D5,$2F,$CB,$72,$7F                       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx+0x3f8]'        );
  TestCase.testcase(1304, [$62,$F2,$D5,$2F,$CB,$B2,$00,$04,$00,$00           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx+0x400]'        );
  TestCase.testcase(1305, [$62,$F2,$D5,$2F,$CB,$72,$80                       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx-0x400]'        );
  TestCase.testcase(1306, [$62,$F2,$D5,$2F,$CB,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx-0x408]'        );
  TestCase.testcase(1307, [$62,$F2,$D5,$2F,$4F,$F4                           ] , 'vrsqrt14sd  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(1308, [$62,$F2,$D5,$AF,$4F,$F4                           ] , 'vrsqrt14sd  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(1309, [$62,$F2,$D5,$2F,$4F,$31                           ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1310, [$62,$F2,$D5,$2F,$4F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1311, [$62,$F2,$D5,$2F,$4F,$72,$7F                       ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1312, [$62,$F2,$D5,$2F,$4F,$B2,$00,$04,$00,$00           ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1313, [$62,$F2,$D5,$2F,$4F,$72,$80                       ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1314, [$62,$F2,$D5,$2F,$4F,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1315, [$62,$F2,$55,$2F,$4F,$F4                           ] , 'vrsqrt14ss  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(1316, [$62,$F2,$55,$AF,$4F,$F4                           ] , 'vrsqrt14ss  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(1317, [$62,$F2,$55,$2F,$4F,$31                           ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(1318, [$62,$F2,$55,$2F,$4F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1319, [$62,$F2,$55,$2F,$4F,$72,$7F                       ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(1320, [$62,$F2,$55,$2F,$4F,$B2,$00,$02,$00,$00           ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(1321, [$62,$F2,$55,$2F,$4F,$72,$80                       ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(1322, [$62,$F2,$55,$2F,$4F,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(1323, [$62,$F2,$55,$2F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(1324, [$62,$F2,$55,$AF,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(1325, [$62,$F2,$55,$1F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1326, [$62,$F2,$55,$2F,$CD,$31                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(1327, [$62,$F2,$55,$2F,$CD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1328, [$62,$F2,$55,$2F,$CD,$72,$7F                       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(1329, [$62,$F2,$55,$2F,$CD,$B2,$00,$02,$00,$00           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(1330, [$62,$F2,$55,$2F,$CD,$72,$80                       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(1331, [$62,$F2,$55,$2F,$CD,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(1332, [$62,$F2,$D5,$2F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(1333, [$62,$F2,$D5,$AF,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(1334, [$62,$F2,$D5,$1F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1335, [$62,$F2,$D5,$2F,$CD,$31                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1336, [$62,$F2,$D5,$2F,$CD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1337, [$62,$F2,$D5,$2F,$CD,$72,$7F                       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1338, [$62,$F2,$D5,$2F,$CD,$B2,$00,$04,$00,$00           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1339, [$62,$F2,$D5,$2F,$CD,$72,$80                       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1340, [$62,$F2,$D5,$2F,$CD,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1341, [$62,$F1,$D7,$2F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4'                      );
  TestCase.testcase(1342, [$62,$F1,$D7,$AF,$51,$F4                           ] , 'vsqrtsd  xmm6{k7}{z},xmm5,xmm4'                   );
  TestCase.testcase(1343, [$62,$F1,$D7,$1F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4,{rn-sae}'             );
  TestCase.testcase(1344, [$62,$F1,$D7,$5F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4,{ru-sae}'             );
  TestCase.testcase(1345, [$62,$F1,$D7,$3F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4,{rd-sae}'             );
  TestCase.testcase(1346, [$62,$F1,$D7,$7F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4,{rz-sae}'             );
  TestCase.testcase(1347, [$62,$F1,$D7,$2F,$51,$31                           ] , 'vsqrtsd  xmm6{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1348, [$62,$F1,$D7,$2F,$51,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vsqrtsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1349, [$62,$F1,$D7,$2F,$51,$72,$7F                       ] , 'vsqrtsd  xmm6{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1350, [$62,$F1,$D7,$2F,$51,$B2,$00,$04,$00,$00           ] , 'vsqrtsd  xmm6{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1351, [$62,$F1,$D7,$2F,$51,$72,$80                       ] , 'vsqrtsd  xmm6{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1352, [$62,$F1,$D7,$2F,$51,$B2,$F8,$FB,$FF,$FF           ] , 'vsqrtsd  xmm6{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1353, [$62,$F1,$56,$2F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4'                      );
  TestCase.testcase(1354, [$62,$F1,$56,$AF,$51,$F4                           ] , 'vsqrtss  xmm6{k7}{z},xmm5,xmm4'                   );
  TestCase.testcase(1355, [$62,$F1,$56,$1F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4,{rn-sae}'             );
  TestCase.testcase(1356, [$62,$F1,$56,$5F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4,{ru-sae}'             );
  TestCase.testcase(1357, [$62,$F1,$56,$3F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4,{rd-sae}'             );
  TestCase.testcase(1358, [$62,$F1,$56,$7F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4,{rz-sae}'             );
  TestCase.testcase(1359, [$62,$F1,$56,$2F,$51,$31                           ] , 'vsqrtss  xmm6{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(1360, [$62,$F1,$56,$2F,$51,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vsqrtss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1361, [$62,$F1,$56,$2F,$51,$72,$7F                       ] , 'vsqrtss  xmm6{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(1362, [$62,$F1,$56,$2F,$51,$B2,$00,$02,$00,$00           ] , 'vsqrtss  xmm6{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(1363, [$62,$F1,$56,$2F,$51,$72,$80                       ] , 'vsqrtss  xmm6{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(1364, [$62,$F1,$56,$2F,$51,$B2,$FC,$FD,$FF,$FF           ] , 'vsqrtss  xmm6{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(1365, [$62,$F1,$D7,$2F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1366, [$62,$F1,$D7,$AF,$5C,$F4                           ] , 'vsubsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1367, [$62,$F1,$D7,$1F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(1368, [$62,$F1,$D7,$5F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(1369, [$62,$F1,$D7,$3F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(1370, [$62,$F1,$D7,$7F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(1371, [$62,$F1,$D7,$2F,$5C,$31                           ] , 'vsubsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1372, [$62,$F1,$D7,$2F,$5C,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vsubsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1373, [$62,$F1,$D7,$2F,$5C,$72,$7F                       ] , 'vsubsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1374, [$62,$F1,$D7,$2F,$5C,$B2,$00,$04,$00,$00           ] , 'vsubsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1375, [$62,$F1,$D7,$2F,$5C,$72,$80                       ] , 'vsubsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1376, [$62,$F1,$D7,$2F,$5C,$B2,$F8,$FB,$FF,$FF           ] , 'vsubsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1377, [$62,$F1,$56,$2F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1378, [$62,$F1,$56,$AF,$5C,$F4                           ] , 'vsubss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1379, [$62,$F1,$56,$1F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(1380, [$62,$F1,$56,$5F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(1381, [$62,$F1,$56,$3F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(1382, [$62,$F1,$56,$7F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(1383, [$62,$F1,$56,$2F,$5C,$31                           ] , 'vsubss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1384, [$62,$F1,$56,$2F,$5C,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vsubss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1385, [$62,$F1,$56,$2F,$5C,$72,$7F                       ] , 'vsubss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1386, [$62,$F1,$56,$2F,$5C,$B2,$00,$02,$00,$00           ] , 'vsubss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1387, [$62,$F1,$56,$2F,$5C,$72,$80                       ] , 'vsubss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1388, [$62,$F1,$56,$2F,$5C,$B2,$FC,$FD,$FF,$FF           ] , 'vsubss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1389, [$62,$F1,$FD,$18,$2E,$F5                           ] , 'vucomisd  xmm6,xmm5,{sae}'                        );
  TestCase.testcase(1390, [$62,$F1,$7C,$18,$2E,$F5                           ] , 'vucomiss  xmm6,xmm5,{sae}'                        );
  TestCase.testcase(1391, [$62,$F1,$7F,$28,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6'                             );
  TestCase.testcase(1392, [$62,$F1,$7F,$18,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6,{rn-sae}'                    );
  TestCase.testcase(1393, [$62,$F1,$7F,$58,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6,{ru-sae}'                    );
  TestCase.testcase(1394, [$62,$F1,$7F,$38,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6,{rd-sae}'                    );
  TestCase.testcase(1395, [$62,$F1,$7F,$78,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6,{rz-sae}'                    );
  TestCase.testcase(1396, [$62,$F1,$7F,$28,$79,$01                           ] , 'vcvtsd2usi  eax,qword [ecx]'                      );
  TestCase.testcase(1397, [$62,$F1,$7F,$28,$79,$84,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtsd2usi  eax,qword [esp+esi*8-0x1e240]'        );
  TestCase.testcase(1398, [$62,$F1,$7F,$28,$79,$42,$7F                       ] , 'vcvtsd2usi  eax,qword [edx+0x3f8]'                );
  TestCase.testcase(1399, [$62,$F1,$7F,$28,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  eax,qword [edx+0x400]'                );
  TestCase.testcase(1400, [$62,$F1,$7F,$28,$79,$42,$80                       ] , 'vcvtsd2usi  eax,qword [edx-0x400]'                );
  TestCase.testcase(1401, [$62,$F1,$7F,$28,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  eax,qword [edx-0x408]'                );
  TestCase.testcase(1402, [$62,$F1,$7F,$28,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6'                             );
  TestCase.testcase(1403, [$62,$F1,$7F,$18,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6,{rn-sae}'                    );
  TestCase.testcase(1404, [$62,$F1,$7F,$58,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6,{ru-sae}'                    );
  TestCase.testcase(1405, [$62,$F1,$7F,$38,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6,{rd-sae}'                    );
  TestCase.testcase(1406, [$62,$F1,$7F,$78,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6,{rz-sae}'                    );
  TestCase.testcase(1407, [$62,$F1,$7F,$28,$79,$29                           ] , 'vcvtsd2usi  ebp,qword [ecx]'                      );
  TestCase.testcase(1408, [$62,$F1,$7F,$28,$79,$AC,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtsd2usi  ebp,qword [esp+esi*8-0x1e240]'        );
  TestCase.testcase(1409, [$62,$F1,$7F,$28,$79,$6A,$7F                       ] , 'vcvtsd2usi  ebp,qword [edx+0x3f8]'                );
  TestCase.testcase(1410, [$62,$F1,$7F,$28,$79,$AA,$00,$04,$00,$00           ] , 'vcvtsd2usi  ebp,qword [edx+0x400]'                );
  TestCase.testcase(1411, [$62,$F1,$7F,$28,$79,$6A,$80                       ] , 'vcvtsd2usi  ebp,qword [edx-0x400]'                );
  TestCase.testcase(1412, [$62,$F1,$7F,$28,$79,$AA,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  ebp,qword [edx-0x408]'                );
  TestCase.testcase(1413, [$62,$F1,$7E,$28,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6'                             );
  TestCase.testcase(1414, [$62,$F1,$7E,$18,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6,{rn-sae}'                    );
  TestCase.testcase(1415, [$62,$F1,$7E,$58,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6,{ru-sae}'                    );
  TestCase.testcase(1416, [$62,$F1,$7E,$38,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6,{rd-sae}'                    );
  TestCase.testcase(1417, [$62,$F1,$7E,$78,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6,{rz-sae}'                    );
  TestCase.testcase(1418, [$62,$F1,$7E,$28,$79,$01                           ] , 'vcvtss2usi  eax,dword [ecx]'                      );
  TestCase.testcase(1419, [$62,$F1,$7E,$28,$79,$84,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtss2usi  eax,dword [esp+esi*8-0x1e240]'        );
  TestCase.testcase(1420, [$62,$F1,$7E,$28,$79,$42,$7F                       ] , 'vcvtss2usi  eax,dword [edx+0x1fc]'                );
  TestCase.testcase(1421, [$62,$F1,$7E,$28,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  eax,dword [edx+0x200]'                );
  TestCase.testcase(1422, [$62,$F1,$7E,$28,$79,$42,$80                       ] , 'vcvtss2usi  eax,dword [edx-0x200]'                );
  TestCase.testcase(1423, [$62,$F1,$7E,$28,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  eax,dword [edx-0x204]'                );
  TestCase.testcase(1424, [$62,$F1,$7E,$28,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6'                             );
  TestCase.testcase(1425, [$62,$F1,$7E,$18,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6,{rn-sae}'                    );
  TestCase.testcase(1426, [$62,$F1,$7E,$58,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6,{ru-sae}'                    );
  TestCase.testcase(1427, [$62,$F1,$7E,$38,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6,{rd-sae}'                    );
  TestCase.testcase(1428, [$62,$F1,$7E,$78,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6,{rz-sae}'                    );
  TestCase.testcase(1429, [$62,$F1,$7E,$28,$79,$29                           ] , 'vcvtss2usi  ebp,dword [ecx]'                      );
  TestCase.testcase(1430, [$62,$F1,$7E,$28,$79,$AC,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtss2usi  ebp,dword [esp+esi*8-0x1e240]'        );
  TestCase.testcase(1431, [$62,$F1,$7E,$28,$79,$6A,$7F                       ] , 'vcvtss2usi  ebp,dword [edx+0x1fc]'                );
  TestCase.testcase(1432, [$62,$F1,$7E,$28,$79,$AA,$00,$02,$00,$00           ] , 'vcvtss2usi  ebp,dword [edx+0x200]'                );
  TestCase.testcase(1433, [$62,$F1,$7E,$28,$79,$6A,$80                       ] , 'vcvtss2usi  ebp,dword [edx-0x200]'                );
  TestCase.testcase(1434, [$62,$F1,$7E,$28,$79,$AA,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  ebp,dword [edx-0x204]'                );
  TestCase.testcase(1435, [$62,$F1,$57,$28,$7B,$F0                           ] , 'vcvtusi2sd  xmm6,xmm5,eax'                        );
  TestCase.testcase(1436, [$62,$F1,$57,$28,$7B,$F5                           ] , 'vcvtusi2sd  xmm6,xmm5,ebp'                        );
  TestCase.testcase(1437, [$62,$F1,$57,$28,$7B,$31                           ] , 'vcvtusi2sd  xmm6,xmm5,dword [ecx]'                );
  TestCase.testcase(1438, [$62,$F1,$57,$28,$7B,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtusi2sd  xmm6,xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1439, [$62,$F1,$57,$28,$7B,$72,$7F                       ] , 'vcvtusi2sd  xmm6,xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1440, [$62,$F1,$57,$28,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2sd  xmm6,xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1441, [$62,$F1,$57,$28,$7B,$72,$80                       ] , 'vcvtusi2sd  xmm6,xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1442, [$62,$F1,$57,$28,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2sd  xmm6,xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1443, [$62,$F1,$56,$28,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,eax'                        );
  TestCase.testcase(1444, [$62,$F1,$56,$18,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,{rn-sae},eax'               );
  TestCase.testcase(1445, [$62,$F1,$56,$58,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,{ru-sae},eax'               );
  TestCase.testcase(1446, [$62,$F1,$56,$38,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,{rd-sae},eax'               );
  TestCase.testcase(1447, [$62,$F1,$56,$78,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,{rz-sae},eax'               );
  TestCase.testcase(1448, [$62,$F1,$56,$28,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,ebp'                        );
  TestCase.testcase(1449, [$62,$F1,$56,$18,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,{rn-sae},ebp'               );
  TestCase.testcase(1450, [$62,$F1,$56,$58,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,{ru-sae},ebp'               );
  TestCase.testcase(1451, [$62,$F1,$56,$38,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,{rd-sae},ebp'               );
  TestCase.testcase(1452, [$62,$F1,$56,$78,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,{rz-sae},ebp'               );
  TestCase.testcase(1453, [$62,$F1,$56,$28,$7B,$31                           ] , 'vcvtusi2ss  xmm6,xmm5,dword [ecx]'                );
  TestCase.testcase(1454, [$62,$F1,$56,$28,$7B,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtusi2ss  xmm6,xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1455, [$62,$F1,$56,$28,$7B,$72,$7F                       ] , 'vcvtusi2ss  xmm6,xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1456, [$62,$F1,$56,$28,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2ss  xmm6,xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1457, [$62,$F1,$56,$28,$7B,$72,$80                       ] , 'vcvtusi2ss  xmm6,xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1458, [$62,$F1,$56,$28,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2ss  xmm6,xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1459, [$62,$F2,$D5,$2F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(1460, [$62,$F2,$D5,$AF,$2D,$F4                           ] , 'vscalefsd  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(1461, [$62,$F2,$D5,$1F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4,{rn-sae}'           );
  TestCase.testcase(1462, [$62,$F2,$D5,$5F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4,{ru-sae}'           );
  TestCase.testcase(1463, [$62,$F2,$D5,$3F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4,{rd-sae}'           );
  TestCase.testcase(1464, [$62,$F2,$D5,$7F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4,{rz-sae}'           );
  TestCase.testcase(1465, [$62,$F2,$D5,$2F,$2D,$31                           ] , 'vscalefsd  xmm6{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1466, [$62,$F2,$D5,$2F,$2D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vscalefsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1467, [$62,$F2,$D5,$2F,$2D,$72,$7F                       ] , 'vscalefsd  xmm6{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1468, [$62,$F2,$D5,$2F,$2D,$B2,$00,$04,$00,$00           ] , 'vscalefsd  xmm6{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1469, [$62,$F2,$D5,$2F,$2D,$72,$80                       ] , 'vscalefsd  xmm6{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1470, [$62,$F2,$D5,$2F,$2D,$B2,$F8,$FB,$FF,$FF           ] , 'vscalefsd  xmm6{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1471, [$62,$F2,$55,$2F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(1472, [$62,$F2,$55,$AF,$2D,$F4                           ] , 'vscalefss  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(1473, [$62,$F2,$55,$1F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4,{rn-sae}'           );
  TestCase.testcase(1474, [$62,$F2,$55,$5F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4,{ru-sae}'           );
  TestCase.testcase(1475, [$62,$F2,$55,$3F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4,{rd-sae}'           );
  TestCase.testcase(1476, [$62,$F2,$55,$7F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4,{rz-sae}'           );
  TestCase.testcase(1477, [$62,$F2,$55,$2F,$2D,$31                           ] , 'vscalefss  xmm6{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(1478, [$62,$F2,$55,$2F,$2D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vscalefss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1479, [$62,$F2,$55,$2F,$2D,$72,$7F                       ] , 'vscalefss  xmm6{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(1480, [$62,$F2,$55,$2F,$2D,$B2,$00,$02,$00,$00           ] , 'vscalefss  xmm6{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(1481, [$62,$F2,$55,$2F,$2D,$72,$80                       ] , 'vscalefss  xmm6{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(1482, [$62,$F2,$55,$2F,$2D,$B2,$FC,$FD,$FF,$FF           ] , 'vscalefss  xmm6{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(1483, [$62,$F3,$55,$2F,$55,$F4,$AB                       ] , 'vfixupimmss  xmm6{k7},xmm5,xmm4,0xab'             );
  TestCase.testcase(1484, [$62,$F3,$55,$AF,$55,$F4,$AB                       ] , 'vfixupimmss  xmm6{k7}{z},xmm5,xmm4,0xab'          );
  TestCase.testcase(1485, [$62,$F3,$55,$1F,$55,$F4,$AB                       ] , 'vfixupimmss  xmm6{k7},xmm5,xmm4,{sae},0xab'       );
  TestCase.testcase(1486, [$62,$F3,$55,$2F,$55,$F4,$7B                       ] , 'vfixupimmss  xmm6{k7},xmm5,xmm4,0x7b'             );
  TestCase.testcase(1487, [$62,$F3,$55,$1F,$55,$F4,$7B                       ] , 'vfixupimmss  xmm6{k7},xmm5,xmm4,{sae},0x7b'       );
  TestCase.testcase(1488, [$62,$F3,$55,$2F,$55,$31,$7B                       ] , 'vfixupimmss  xmm6{k7},xmm5,dword [ecx],0x7b'      );
  TestCase.testcase(1489, [$62,$F3,$55,$2F,$55,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vfixupimmss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(1490, [$62,$F3,$55,$2F,$55,$72,$7F,$7B                   ] , 'vfixupimmss  xmm6{k7},xmm5,dword [edx+0x1fc],0x7b' );
  TestCase.testcase(1491, [$62,$F3,$55,$2F,$55,$B2,$00,$02,$00,$00,$7B       ] , 'vfixupimmss  xmm6{k7},xmm5,dword [edx+0x200],0x7b' );
  TestCase.testcase(1492, [$62,$F3,$55,$2F,$55,$72,$80,$7B                   ] , 'vfixupimmss  xmm6{k7},xmm5,dword [edx-0x200],0x7b' );
  TestCase.testcase(1493, [$62,$F3,$55,$2F,$55,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vfixupimmss  xmm6{k7},xmm5,dword [edx-0x204],0x7b' );
  TestCase.testcase(1494, [$62,$F3,$D5,$2F,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm6{k7},xmm5,xmm4,0xab'             );
  TestCase.testcase(1495, [$62,$F3,$D5,$AF,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm6{k7}{z},xmm5,xmm4,0xab'          );
  TestCase.testcase(1496, [$62,$F3,$D5,$1F,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm6{k7},xmm5,xmm4,{sae},0xab'       );
  TestCase.testcase(1497, [$62,$F3,$D5,$2F,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm6{k7},xmm5,xmm4,0x7b'             );
  TestCase.testcase(1498, [$62,$F3,$D5,$1F,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm6{k7},xmm5,xmm4,{sae},0x7b'       );
  TestCase.testcase(1499, [$62,$F3,$D5,$2F,$55,$31,$7B                       ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [ecx],0x7b'      );
  TestCase.testcase(1500, [$62,$F3,$D5,$2F,$55,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(1501, [$62,$F3,$D5,$2F,$55,$72,$7F,$7B                   ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [edx+0x3f8],0x7b' );
  TestCase.testcase(1502, [$62,$F3,$D5,$2F,$55,$B2,$00,$04,$00,$00,$7B       ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [edx+0x400],0x7b' );
  TestCase.testcase(1503, [$62,$F3,$D5,$2F,$55,$72,$80,$7B                   ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [edx-0x400],0x7b' );
  TestCase.testcase(1504, [$62,$F3,$D5,$2F,$55,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [edx-0x408],0x7b' );
  TestCase.testcase(1505, [$62,$F3,$D5,$2F,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm6{k7},xmm5,xmm4,0xab'             );
  TestCase.testcase(1506, [$62,$F3,$D5,$AF,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm6{k7}{z},xmm5,xmm4,0xab'          );
  TestCase.testcase(1507, [$62,$F3,$D5,$1F,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm6{k7},xmm5,xmm4,{sae},0xab'       );
  TestCase.testcase(1508, [$62,$F3,$D5,$2F,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm6{k7},xmm5,xmm4,0x7b'             );
  TestCase.testcase(1509, [$62,$F3,$D5,$1F,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm6{k7},xmm5,xmm4,{sae},0x7b'       );
  TestCase.testcase(1510, [$62,$F3,$D5,$2F,$0B,$31,$7B                       ] , 'vrndscalesd  xmm6{k7},xmm5,qword [ecx],0x7b'      );
  TestCase.testcase(1511, [$62,$F3,$D5,$2F,$0B,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vrndscalesd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(1512, [$62,$F3,$D5,$2F,$0B,$72,$7F,$7B                   ] , 'vrndscalesd  xmm6{k7},xmm5,qword [edx+0x3f8],0x7b' );
  TestCase.testcase(1513, [$62,$F3,$D5,$2F,$0B,$B2,$00,$04,$00,$00,$7B       ] , 'vrndscalesd  xmm6{k7},xmm5,qword [edx+0x400],0x7b' );
  TestCase.testcase(1514, [$62,$F3,$D5,$2F,$0B,$72,$80,$7B                   ] , 'vrndscalesd  xmm6{k7},xmm5,qword [edx-0x400],0x7b' );
  TestCase.testcase(1515, [$62,$F3,$D5,$2F,$0B,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vrndscalesd  xmm6{k7},xmm5,qword [edx-0x408],0x7b' );
  TestCase.testcase(1516, [$62,$F3,$55,$2F,$0A,$F4,$AB                       ] , 'vrndscaless  xmm6{k7},xmm5,xmm4,0xab'             );
  TestCase.testcase(1517, [$62,$F3,$55,$AF,$0A,$F4,$AB                       ] , 'vrndscaless  xmm6{k7}{z},xmm5,xmm4,0xab'          );
  TestCase.testcase(1518, [$62,$F3,$55,$1F,$0A,$F4,$AB                       ] , 'vrndscaless  xmm6{k7},xmm5,xmm4,{sae},0xab'       );
  TestCase.testcase(1519, [$62,$F3,$55,$2F,$0A,$F4,$7B                       ] , 'vrndscaless  xmm6{k7},xmm5,xmm4,0x7b'             );
  TestCase.testcase(1520, [$62,$F3,$55,$1F,$0A,$F4,$7B                       ] , 'vrndscaless  xmm6{k7},xmm5,xmm4,{sae},0x7b'       );
  TestCase.testcase(1521, [$62,$F3,$55,$2F,$0A,$31,$7B                       ] , 'vrndscaless  xmm6{k7},xmm5,dword [ecx],0x7b'      );
  TestCase.testcase(1522, [$62,$F3,$55,$2F,$0A,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vrndscaless  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(1523, [$62,$F3,$55,$2F,$0A,$72,$7F,$7B                   ] , 'vrndscaless  xmm6{k7},xmm5,dword [edx+0x1fc],0x7b' );
  TestCase.testcase(1524, [$62,$F3,$55,$2F,$0A,$B2,$00,$02,$00,$00,$7B       ] , 'vrndscaless  xmm6{k7},xmm5,dword [edx+0x200],0x7b' );
  TestCase.testcase(1525, [$62,$F3,$55,$2F,$0A,$72,$80,$7B                   ] , 'vrndscaless  xmm6{k7},xmm5,dword [edx-0x200],0x7b' );
  TestCase.testcase(1526, [$62,$F3,$55,$2F,$0A,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vrndscaless  xmm6{k7},xmm5,dword [edx-0x204],0x7b' );
  TestCase.testcase(1527, [$62,$F1,$D7,$2F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1528, [$62,$F1,$D7,$AF,$58,$F4                           ] , 'vaddsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1529, [$62,$F1,$D7,$1F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(1530, [$62,$F1,$D7,$5F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(1531, [$62,$F1,$D7,$3F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(1532, [$62,$F1,$D7,$7F,$58,$F4                           ] , 'vaddsd  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(1533, [$62,$F1,$D7,$2F,$58,$31                           ] , 'vaddsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1534, [$62,$F1,$D7,$2F,$58,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vaddsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1535, [$62,$F1,$D7,$2F,$58,$72,$7F                       ] , 'vaddsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1536, [$62,$F1,$D7,$2F,$58,$B2,$00,$04,$00,$00           ] , 'vaddsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1537, [$62,$F1,$D7,$2F,$58,$72,$80                       ] , 'vaddsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1538, [$62,$F1,$D7,$2F,$58,$B2,$F8,$FB,$FF,$FF           ] , 'vaddsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1539, [$62,$F1,$56,$2F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(1540, [$62,$F1,$56,$AF,$58,$F4                           ] , 'vaddss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(1541, [$62,$F1,$56,$1F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(1542, [$62,$F1,$56,$5F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(1543, [$62,$F1,$56,$3F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(1544, [$62,$F1,$56,$7F,$58,$F4                           ] , 'vaddss  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(1545, [$62,$F1,$56,$2F,$58,$31                           ] , 'vaddss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1546, [$62,$F1,$56,$2F,$58,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vaddss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1547, [$62,$F1,$56,$2F,$58,$72,$7F                       ] , 'vaddss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1548, [$62,$F1,$56,$2F,$58,$B2,$00,$02,$00,$00           ] , 'vaddss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1549, [$62,$F1,$56,$2F,$58,$72,$80                       ] , 'vaddss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1550, [$62,$F1,$56,$2F,$58,$B2,$FC,$FD,$FF,$FF           ] , 'vaddss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1551, [$62,$F1,$D7,$2F,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm5,xmm4,0xab'                    );
  TestCase.testcase(1552, [$62,$F1,$D7,$1F,$C2,$EC,$AB                       ] , 'vcmpsd  k5{k7},xmm5,xmm4,{sae},0xab'              );
  TestCase.testcase(1553, [$62,$F1,$D7,$2F,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm5,xmm4,0x7b'                    );
  TestCase.testcase(1554, [$62,$F1,$D7,$1F,$C2,$EC,$7B                       ] , 'vcmpsd  k5{k7},xmm5,xmm4,{sae},0x7b'              );
  TestCase.testcase(1555, [$62,$F1,$D7,$2F,$C2,$29,$7B                       ] , 'vcmpsd  k5{k7},xmm5,qword [ecx],0x7b'             );
  TestCase.testcase(1556, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vcmpsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(1557, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$7B                   ] , 'vcmpsd  k5{k7},xmm5,qword [edx+0x3f8],0x7b'       );
  TestCase.testcase(1558, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$7B       ] , 'vcmpsd  k5{k7},xmm5,qword [edx+0x400],0x7b'       );
  TestCase.testcase(1559, [$62,$F1,$D7,$2F,$C2,$6A,$80,$7B                   ] , 'vcmpsd  k5{k7},xmm5,qword [edx-0x400],0x7b'       );
  TestCase.testcase(1560, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$7B       ] , 'vcmpsd  k5{k7},xmm5,qword [edx-0x408],0x7b'       );
  TestCase.testcase(1561, [$62,$F1,$D7,$2F,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1562, [$62,$F1,$D7,$1F,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1563, [$62,$F1,$D7,$2F,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1564, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$00   ] , 'vcmpeqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1565, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1566, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1567, [$62,$F1,$D7,$2F,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1568, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1569, [$62,$F1,$D7,$2F,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1570, [$62,$F1,$D7,$1F,$C2,$EC,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1571, [$62,$F1,$D7,$2F,$C2,$29,$00                       ] , 'vcmpeqsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1572, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$00   ] , 'vcmpeqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1573, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$00                   ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1574, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$00       ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1575, [$62,$F1,$D7,$2F,$C2,$6A,$80,$00                   ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1576, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$00       ] , 'vcmpeqsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1577, [$62,$F1,$D7,$2F,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1578, [$62,$F1,$D7,$1F,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1579, [$62,$F1,$D7,$2F,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1580, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$01   ] , 'vcmpltsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1581, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1582, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1583, [$62,$F1,$D7,$2F,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1584, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1585, [$62,$F1,$D7,$2F,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1586, [$62,$F1,$D7,$1F,$C2,$EC,$01                       ] , 'vcmpltsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1587, [$62,$F1,$D7,$2F,$C2,$29,$01                       ] , 'vcmpltsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1588, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$01   ] , 'vcmpltsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1589, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$01                   ] , 'vcmpltsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1590, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$01       ] , 'vcmpltsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1591, [$62,$F1,$D7,$2F,$C2,$6A,$80,$01                   ] , 'vcmpltsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1592, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$01       ] , 'vcmpltsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1593, [$62,$F1,$D7,$2F,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1594, [$62,$F1,$D7,$1F,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1595, [$62,$F1,$D7,$2F,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1596, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$02   ] , 'vcmplesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1597, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1598, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1599, [$62,$F1,$D7,$2F,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1600, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1601, [$62,$F1,$D7,$2F,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1602, [$62,$F1,$D7,$1F,$C2,$EC,$02                       ] , 'vcmplesd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1603, [$62,$F1,$D7,$2F,$C2,$29,$02                       ] , 'vcmplesd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1604, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$02   ] , 'vcmplesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1605, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$02                   ] , 'vcmplesd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1606, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$02       ] , 'vcmplesd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1607, [$62,$F1,$D7,$2F,$C2,$6A,$80,$02                   ] , 'vcmplesd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1608, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$02       ] , 'vcmplesd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1609, [$62,$F1,$D7,$2F,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1610, [$62,$F1,$D7,$1F,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1611, [$62,$F1,$D7,$2F,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1612, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$03   ] , 'vcmpunordsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1613, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1614, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1615, [$62,$F1,$D7,$2F,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1616, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1617, [$62,$F1,$D7,$2F,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1618, [$62,$F1,$D7,$1F,$C2,$EC,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1619, [$62,$F1,$D7,$2F,$C2,$29,$03                       ] , 'vcmpunordsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1620, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$03   ] , 'vcmpunordsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1621, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$03                   ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1622, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$03       ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1623, [$62,$F1,$D7,$2F,$C2,$6A,$80,$03                   ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1624, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$03       ] , 'vcmpunordsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1625, [$62,$F1,$D7,$2F,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1626, [$62,$F1,$D7,$1F,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1627, [$62,$F1,$D7,$2F,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1628, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$04   ] , 'vcmpneqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1629, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1630, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1631, [$62,$F1,$D7,$2F,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1632, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1633, [$62,$F1,$D7,$2F,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1634, [$62,$F1,$D7,$1F,$C2,$EC,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1635, [$62,$F1,$D7,$2F,$C2,$29,$04                       ] , 'vcmpneqsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1636, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$04   ] , 'vcmpneqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1637, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$04                   ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1638, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$04       ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1639, [$62,$F1,$D7,$2F,$C2,$6A,$80,$04                   ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1640, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$04       ] , 'vcmpneqsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1641, [$62,$F1,$D7,$2F,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1642, [$62,$F1,$D7,$1F,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1643, [$62,$F1,$D7,$2F,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1644, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$05   ] , 'vcmpnltsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1645, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1646, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1647, [$62,$F1,$D7,$2F,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1648, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1649, [$62,$F1,$D7,$2F,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1650, [$62,$F1,$D7,$1F,$C2,$EC,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1651, [$62,$F1,$D7,$2F,$C2,$29,$05                       ] , 'vcmpnltsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1652, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$05   ] , 'vcmpnltsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1653, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$05                   ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1654, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$05       ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1655, [$62,$F1,$D7,$2F,$C2,$6A,$80,$05                   ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1656, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$05       ] , 'vcmpnltsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1657, [$62,$F1,$D7,$2F,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1658, [$62,$F1,$D7,$1F,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1659, [$62,$F1,$D7,$2F,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1660, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$06   ] , 'vcmpnlesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1661, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1662, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1663, [$62,$F1,$D7,$2F,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1664, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1665, [$62,$F1,$D7,$2F,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1666, [$62,$F1,$D7,$1F,$C2,$EC,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1667, [$62,$F1,$D7,$2F,$C2,$29,$06                       ] , 'vcmpnlesd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1668, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$06   ] , 'vcmpnlesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1669, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$06                   ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1670, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$06       ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1671, [$62,$F1,$D7,$2F,$C2,$6A,$80,$06                   ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1672, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$06       ] , 'vcmpnlesd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1673, [$62,$F1,$D7,$2F,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1674, [$62,$F1,$D7,$1F,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1675, [$62,$F1,$D7,$2F,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1676, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$07   ] , 'vcmpordsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1677, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1678, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1679, [$62,$F1,$D7,$2F,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1680, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1681, [$62,$F1,$D7,$2F,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1682, [$62,$F1,$D7,$1F,$C2,$EC,$07                       ] , 'vcmpordsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1683, [$62,$F1,$D7,$2F,$C2,$29,$07                       ] , 'vcmpordsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1684, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$07   ] , 'vcmpordsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1685, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$07                   ] , 'vcmpordsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1686, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$07       ] , 'vcmpordsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1687, [$62,$F1,$D7,$2F,$C2,$6A,$80,$07                   ] , 'vcmpordsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1688, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$07       ] , 'vcmpordsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1689, [$62,$F1,$D7,$2F,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1690, [$62,$F1,$D7,$1F,$C2,$EC,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1691, [$62,$F1,$D7,$2F,$C2,$29,$08                       ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1692, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$08   ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1693, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1694, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1695, [$62,$F1,$D7,$2F,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1696, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$08       ] , 'vcmpeq_uqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1697, [$62,$F1,$D7,$2F,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1698, [$62,$F1,$D7,$1F,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1699, [$62,$F1,$D7,$2F,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1700, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$09   ] , 'vcmpngesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1701, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1702, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1703, [$62,$F1,$D7,$2F,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1704, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1705, [$62,$F1,$D7,$2F,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1706, [$62,$F1,$D7,$1F,$C2,$EC,$09                       ] , 'vcmpngesd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1707, [$62,$F1,$D7,$2F,$C2,$29,$09                       ] , 'vcmpngesd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1708, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$09   ] , 'vcmpngesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1709, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$09                   ] , 'vcmpngesd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1710, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$09       ] , 'vcmpngesd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1711, [$62,$F1,$D7,$2F,$C2,$6A,$80,$09                   ] , 'vcmpngesd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1712, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$09       ] , 'vcmpngesd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1713, [$62,$F1,$D7,$2F,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1714, [$62,$F1,$D7,$1F,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1715, [$62,$F1,$D7,$2F,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1716, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0A   ] , 'vcmpngtsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1717, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1718, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1719, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1720, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1721, [$62,$F1,$D7,$2F,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(1722, [$62,$F1,$D7,$1F,$C2,$EC,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(1723, [$62,$F1,$D7,$2F,$C2,$29,$0A                       ] , 'vcmpngtsd  k5{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(1724, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0A   ] , 'vcmpngtsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1725, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0A                   ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(1726, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0A       ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(1727, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0A                   ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(1728, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0A       ] , 'vcmpngtsd  k5{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(1729, [$62,$F1,$D7,$2F,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1730, [$62,$F1,$D7,$1F,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1731, [$62,$F1,$D7,$2F,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1732, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0B   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1733, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1734, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1735, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1736, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1737, [$62,$F1,$D7,$2F,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1738, [$62,$F1,$D7,$1F,$C2,$EC,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1739, [$62,$F1,$D7,$2F,$C2,$29,$0B                       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1740, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0B   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1741, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1742, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0B       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1743, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0B                   ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1744, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0B       ] , 'vcmpfalsesd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1745, [$62,$F1,$D7,$2F,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(1746, [$62,$F1,$D7,$1F,$C2,$EC,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1747, [$62,$F1,$D7,$2F,$C2,$29,$0C                       ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1748, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0C   ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1749, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1750, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1751, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1752, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0C       ] , 'vcmpneq_oqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1753, [$62,$F1,$D7,$2F,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1754, [$62,$F1,$D7,$1F,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1755, [$62,$F1,$D7,$2F,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1756, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0D   ] , 'vcmpgesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1757, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1758, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1759, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1760, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1761, [$62,$F1,$D7,$2F,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1762, [$62,$F1,$D7,$1F,$C2,$EC,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1763, [$62,$F1,$D7,$2F,$C2,$29,$0D                       ] , 'vcmpgesd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1764, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0D   ] , 'vcmpgesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1765, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0D                   ] , 'vcmpgesd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1766, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0D       ] , 'vcmpgesd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1767, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0D                   ] , 'vcmpgesd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1768, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0D       ] , 'vcmpgesd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1769, [$62,$F1,$D7,$2F,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1770, [$62,$F1,$D7,$1F,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1771, [$62,$F1,$D7,$2F,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1772, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0E   ] , 'vcmpgtsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1773, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1774, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1775, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1776, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1777, [$62,$F1,$D7,$2F,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1778, [$62,$F1,$D7,$1F,$C2,$EC,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1779, [$62,$F1,$D7,$2F,$C2,$29,$0E                       ] , 'vcmpgtsd  k5{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(1780, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0E   ] , 'vcmpgtsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1781, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0E                   ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(1782, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0E       ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(1783, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0E                   ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(1784, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0E       ] , 'vcmpgtsd  k5{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(1785, [$62,$F1,$D7,$2F,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm5,xmm4'                        );
  TestCase.testcase(1786, [$62,$F1,$D7,$1F,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm5,xmm4,{sae}'                  );
  TestCase.testcase(1787, [$62,$F1,$D7,$2F,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm5,qword [ecx]'                 );
  TestCase.testcase(1788, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0F   ] , 'vcmuesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'   );
  TestCase.testcase(1789, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm5,qword [edx+0x3f8]'           );
  TestCase.testcase(1790, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm5,qword [edx+0x400]'           );
  TestCase.testcase(1791, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm5,qword [edx-0x400]'           );
  TestCase.testcase(1792, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm5,qword [edx-0x408]'           );
  TestCase.testcase(1793, [$62,$F1,$D7,$2F,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm5,xmm4'                        );
  TestCase.testcase(1794, [$62,$F1,$D7,$1F,$C2,$EC,$0F                       ] , 'vcmuesd  k5{k7},xmm5,xmm4,{sae}'                  );
  TestCase.testcase(1795, [$62,$F1,$D7,$2F,$C2,$29,$0F                       ] , 'vcmuesd  k5{k7},xmm5,qword [ecx]'                 );
  TestCase.testcase(1796, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0F   ] , 'vcmuesd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]'   );
  TestCase.testcase(1797, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$0F                   ] , 'vcmuesd  k5{k7},xmm5,qword [edx+0x3f8]'           );
  TestCase.testcase(1798, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$0F       ] , 'vcmuesd  k5{k7},xmm5,qword [edx+0x400]'           );
  TestCase.testcase(1799, [$62,$F1,$D7,$2F,$C2,$6A,$80,$0F                   ] , 'vcmuesd  k5{k7},xmm5,qword [edx-0x400]'           );
  TestCase.testcase(1800, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$0F       ] , 'vcmuesd  k5{k7},xmm5,qword [edx-0x408]'           );
  TestCase.testcase(1801, [$62,$F1,$D7,$2F,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1802, [$62,$F1,$D7,$1F,$C2,$EC,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1803, [$62,$F1,$D7,$2F,$C2,$29,$10                       ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1804, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$10   ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1805, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1806, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$10       ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1807, [$62,$F1,$D7,$2F,$C2,$6A,$80,$10                   ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1808, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$10       ] , 'vcmpeq_ossd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1809, [$62,$F1,$D7,$2F,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1810, [$62,$F1,$D7,$1F,$C2,$EC,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1811, [$62,$F1,$D7,$2F,$C2,$29,$11                       ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1812, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$11   ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1813, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1814, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$11       ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1815, [$62,$F1,$D7,$2F,$C2,$6A,$80,$11                   ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1816, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$11       ] , 'vcmplt_oqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1817, [$62,$F1,$D7,$2F,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1818, [$62,$F1,$D7,$1F,$C2,$EC,$12                       ] , 'vcmple_oqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1819, [$62,$F1,$D7,$2F,$C2,$29,$12                       ] , 'vcmple_oqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1820, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$12   ] , 'vcmple_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1821, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$12                   ] , 'vcmple_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1822, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$12       ] , 'vcmple_oqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1823, [$62,$F1,$D7,$2F,$C2,$6A,$80,$12                   ] , 'vcmple_oqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1824, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$12       ] , 'vcmple_oqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1825, [$62,$F1,$D7,$2F,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm5,xmm4'                  );
  TestCase.testcase(1826, [$62,$F1,$D7,$1F,$C2,$EC,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm5,xmm4,{sae}'            );
  TestCase.testcase(1827, [$62,$F1,$D7,$2F,$C2,$29,$13                       ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(1828, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$13   ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1829, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(1830, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$13       ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(1831, [$62,$F1,$D7,$2F,$C2,$6A,$80,$13                   ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(1832, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$13       ] , 'vcmpunord_ssd  k5{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(1833, [$62,$F1,$D7,$2F,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(1834, [$62,$F1,$D7,$1F,$C2,$EC,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1835, [$62,$F1,$D7,$2F,$C2,$29,$14                       ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1836, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$14   ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1837, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1838, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$14       ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1839, [$62,$F1,$D7,$2F,$C2,$6A,$80,$14                   ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1840, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$14       ] , 'vcmpneq_ussd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1841, [$62,$F1,$D7,$2F,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(1842, [$62,$F1,$D7,$1F,$C2,$EC,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1843, [$62,$F1,$D7,$2F,$C2,$29,$15                       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1844, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$15   ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1845, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1846, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1847, [$62,$F1,$D7,$2F,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1848, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$15       ] , 'vcmpnlt_uqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1849, [$62,$F1,$D7,$2F,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(1850, [$62,$F1,$D7,$1F,$C2,$EC,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1851, [$62,$F1,$D7,$2F,$C2,$29,$16                       ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1852, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$16   ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1853, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1854, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1855, [$62,$F1,$D7,$2F,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1856, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$16       ] , 'vcmpnle_uqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1857, [$62,$F1,$D7,$2F,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1858, [$62,$F1,$D7,$1F,$C2,$EC,$17                       ] , 'vcmpord_ssd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1859, [$62,$F1,$D7,$2F,$C2,$29,$17                       ] , 'vcmpord_ssd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1860, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$17   ] , 'vcmpord_ssd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1861, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$17                   ] , 'vcmpord_ssd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1862, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$17       ] , 'vcmpord_ssd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1863, [$62,$F1,$D7,$2F,$C2,$6A,$80,$17                   ] , 'vcmpord_ssd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1864, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$17       ] , 'vcmpord_ssd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1865, [$62,$F1,$D7,$2F,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1866, [$62,$F1,$D7,$1F,$C2,$EC,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1867, [$62,$F1,$D7,$2F,$C2,$29,$18                       ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1868, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$18   ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1869, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1870, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$18       ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1871, [$62,$F1,$D7,$2F,$C2,$6A,$80,$18                   ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1872, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$18       ] , 'vcmpeq_ussd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1873, [$62,$F1,$D7,$2F,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(1874, [$62,$F1,$D7,$1F,$C2,$EC,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1875, [$62,$F1,$D7,$2F,$C2,$29,$19                       ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1876, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$19   ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1877, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1878, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1879, [$62,$F1,$D7,$2F,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1880, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$19       ] , 'vcmpnge_uqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1881, [$62,$F1,$D7,$2F,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(1882, [$62,$F1,$D7,$1F,$C2,$EC,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1883, [$62,$F1,$D7,$2F,$C2,$29,$1A                       ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1884, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1A   ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1885, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1886, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1887, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1888, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1A       ] , 'vcmpngt_uqsd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1889, [$62,$F1,$D7,$2F,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm5,xmm4'                 );
  TestCase.testcase(1890, [$62,$F1,$D7,$1F,$C2,$EC,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm5,xmm4,{sae}'           );
  TestCase.testcase(1891, [$62,$F1,$D7,$2F,$C2,$29,$1B                       ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(1892, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1B   ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1893, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(1894, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(1895, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(1896, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1B       ] , 'vcmpfalse_ossd  k5{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(1897, [$62,$F1,$D7,$2F,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(1898, [$62,$F1,$D7,$1F,$C2,$EC,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(1899, [$62,$F1,$D7,$2F,$C2,$29,$1C                       ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(1900, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1C   ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1901, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(1902, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(1903, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1C                   ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(1904, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1C       ] , 'vcmpneq_ossd  k5{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(1905, [$62,$F1,$D7,$2F,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1906, [$62,$F1,$D7,$1F,$C2,$EC,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1907, [$62,$F1,$D7,$2F,$C2,$29,$1D                       ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1908, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1D   ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1909, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1910, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1911, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1912, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1D       ] , 'vcmpge_oqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1913, [$62,$F1,$D7,$2F,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1914, [$62,$F1,$D7,$1F,$C2,$EC,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1915, [$62,$F1,$D7,$2F,$C2,$29,$1E                       ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(1916, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1E   ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1917, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(1918, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(1919, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(1920, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1E       ] , 'vcmpgt_oqsd  k5{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(1921, [$62,$F1,$D7,$2F,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm5,xmm4'                     );
  TestCase.testcase(1922, [$62,$F1,$D7,$1F,$C2,$EC,$1F                       ] , 'vcmue_ussd  k5{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(1923, [$62,$F1,$D7,$2F,$C2,$29,$1F                       ] , 'vcmue_ussd  k5{k7},xmm5,qword [ecx]'              );
  TestCase.testcase(1924, [$62,$F1,$D7,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1F   ] , 'vcmue_ussd  k5{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1925, [$62,$F1,$D7,$2F,$C2,$6A,$7F,$1F                   ] , 'vcmue_ussd  k5{k7},xmm5,qword [edx+0x3f8]'        );
  TestCase.testcase(1926, [$62,$F1,$D7,$2F,$C2,$AA,$00,$04,$00,$00,$1F       ] , 'vcmue_ussd  k5{k7},xmm5,qword [edx+0x400]'        );
  TestCase.testcase(1927, [$62,$F1,$D7,$2F,$C2,$6A,$80,$1F                   ] , 'vcmue_ussd  k5{k7},xmm5,qword [edx-0x400]'        );
  TestCase.testcase(1928, [$62,$F1,$D7,$2F,$C2,$AA,$F8,$FB,$FF,$FF,$1F       ] , 'vcmue_ussd  k5{k7},xmm5,qword [edx-0x408]'        );
  TestCase.testcase(1929, [$62,$F1,$56,$2F,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm5,xmm4,0xab'                    );
  TestCase.testcase(1930, [$62,$F1,$56,$1F,$C2,$EC,$AB                       ] , 'vcmpss  k5{k7},xmm5,xmm4,{sae},0xab'              );
  TestCase.testcase(1931, [$62,$F1,$56,$2F,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm5,xmm4,0x7b'                    );
  TestCase.testcase(1932, [$62,$F1,$56,$1F,$C2,$EC,$7B                       ] , 'vcmpss  k5{k7},xmm5,xmm4,{sae},0x7b'              );
  TestCase.testcase(1933, [$62,$F1,$56,$2F,$C2,$29,$7B                       ] , 'vcmpss  k5{k7},xmm5,dword [ecx],0x7b'             );
  TestCase.testcase(1934, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vcmpss  k5{k7},xmm5,dword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(1935, [$62,$F1,$56,$2F,$C2,$6A,$7F,$7B                   ] , 'vcmpss  k5{k7},xmm5,dword [edx+0x1fc],0x7b'       );
  TestCase.testcase(1936, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$7B       ] , 'vcmpss  k5{k7},xmm5,dword [edx+0x200],0x7b'       );
  TestCase.testcase(1937, [$62,$F1,$56,$2F,$C2,$6A,$80,$7B                   ] , 'vcmpss  k5{k7},xmm5,dword [edx-0x200],0x7b'       );
  TestCase.testcase(1938, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$7B       ] , 'vcmpss  k5{k7},xmm5,dword [edx-0x204],0x7b'       );
  TestCase.testcase(1939, [$62,$F1,$56,$2F,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1940, [$62,$F1,$56,$1F,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1941, [$62,$F1,$56,$2F,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1942, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$00   ] , 'vcmpeqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1943, [$62,$F1,$56,$2F,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1944, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1945, [$62,$F1,$56,$2F,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1946, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1947, [$62,$F1,$56,$2F,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1948, [$62,$F1,$56,$1F,$C2,$EC,$00                       ] , 'vcmpeqss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1949, [$62,$F1,$56,$2F,$C2,$29,$00                       ] , 'vcmpeqss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1950, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$00   ] , 'vcmpeqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1951, [$62,$F1,$56,$2F,$C2,$6A,$7F,$00                   ] , 'vcmpeqss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1952, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$00       ] , 'vcmpeqss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1953, [$62,$F1,$56,$2F,$C2,$6A,$80,$00                   ] , 'vcmpeqss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1954, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$00       ] , 'vcmpeqss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1955, [$62,$F1,$56,$2F,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1956, [$62,$F1,$56,$1F,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1957, [$62,$F1,$56,$2F,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1958, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$01   ] , 'vcmpltss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1959, [$62,$F1,$56,$2F,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1960, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1961, [$62,$F1,$56,$2F,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1962, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1963, [$62,$F1,$56,$2F,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1964, [$62,$F1,$56,$1F,$C2,$EC,$01                       ] , 'vcmpltss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1965, [$62,$F1,$56,$2F,$C2,$29,$01                       ] , 'vcmpltss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1966, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$01   ] , 'vcmpltss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1967, [$62,$F1,$56,$2F,$C2,$6A,$7F,$01                   ] , 'vcmpltss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1968, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$01       ] , 'vcmpltss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1969, [$62,$F1,$56,$2F,$C2,$6A,$80,$01                   ] , 'vcmpltss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1970, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$01       ] , 'vcmpltss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1971, [$62,$F1,$56,$2F,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1972, [$62,$F1,$56,$1F,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1973, [$62,$F1,$56,$2F,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1974, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$02   ] , 'vcmpless  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1975, [$62,$F1,$56,$2F,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1976, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1977, [$62,$F1,$56,$2F,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1978, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1979, [$62,$F1,$56,$2F,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(1980, [$62,$F1,$56,$1F,$C2,$EC,$02                       ] , 'vcmpless  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(1981, [$62,$F1,$56,$2F,$C2,$29,$02                       ] , 'vcmpless  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(1982, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$02   ] , 'vcmpless  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(1983, [$62,$F1,$56,$2F,$C2,$6A,$7F,$02                   ] , 'vcmpless  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(1984, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$02       ] , 'vcmpless  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(1985, [$62,$F1,$56,$2F,$C2,$6A,$80,$02                   ] , 'vcmpless  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(1986, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$02       ] , 'vcmpless  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(1987, [$62,$F1,$56,$2F,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1988, [$62,$F1,$56,$1F,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1989, [$62,$F1,$56,$2F,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(1990, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$03   ] , 'vcmpunordss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1991, [$62,$F1,$56,$2F,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(1992, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(1993, [$62,$F1,$56,$2F,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(1994, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(1995, [$62,$F1,$56,$2F,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(1996, [$62,$F1,$56,$1F,$C2,$EC,$03                       ] , 'vcmpunordss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(1997, [$62,$F1,$56,$2F,$C2,$29,$03                       ] , 'vcmpunordss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(1998, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$03   ] , 'vcmpunordss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(1999, [$62,$F1,$56,$2F,$C2,$6A,$7F,$03                   ] , 'vcmpunordss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2000, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$03       ] , 'vcmpunordss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2001, [$62,$F1,$56,$2F,$C2,$6A,$80,$03                   ] , 'vcmpunordss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2002, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$03       ] , 'vcmpunordss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2003, [$62,$F1,$56,$2F,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2004, [$62,$F1,$56,$1F,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2005, [$62,$F1,$56,$2F,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2006, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$04   ] , 'vcmpneqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2007, [$62,$F1,$56,$2F,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2008, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2009, [$62,$F1,$56,$2F,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2010, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2011, [$62,$F1,$56,$2F,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2012, [$62,$F1,$56,$1F,$C2,$EC,$04                       ] , 'vcmpneqss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2013, [$62,$F1,$56,$2F,$C2,$29,$04                       ] , 'vcmpneqss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2014, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$04   ] , 'vcmpneqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2015, [$62,$F1,$56,$2F,$C2,$6A,$7F,$04                   ] , 'vcmpneqss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2016, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$04       ] , 'vcmpneqss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2017, [$62,$F1,$56,$2F,$C2,$6A,$80,$04                   ] , 'vcmpneqss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2018, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$04       ] , 'vcmpneqss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2019, [$62,$F1,$56,$2F,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2020, [$62,$F1,$56,$1F,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2021, [$62,$F1,$56,$2F,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2022, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$05   ] , 'vcmpnltss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2023, [$62,$F1,$56,$2F,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2024, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2025, [$62,$F1,$56,$2F,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2026, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2027, [$62,$F1,$56,$2F,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2028, [$62,$F1,$56,$1F,$C2,$EC,$05                       ] , 'vcmpnltss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2029, [$62,$F1,$56,$2F,$C2,$29,$05                       ] , 'vcmpnltss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2030, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$05   ] , 'vcmpnltss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2031, [$62,$F1,$56,$2F,$C2,$6A,$7F,$05                   ] , 'vcmpnltss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2032, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$05       ] , 'vcmpnltss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2033, [$62,$F1,$56,$2F,$C2,$6A,$80,$05                   ] , 'vcmpnltss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2034, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$05       ] , 'vcmpnltss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2035, [$62,$F1,$56,$2F,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2036, [$62,$F1,$56,$1F,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2037, [$62,$F1,$56,$2F,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2038, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$06   ] , 'vcmpnless  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2039, [$62,$F1,$56,$2F,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2040, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2041, [$62,$F1,$56,$2F,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2042, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2043, [$62,$F1,$56,$2F,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2044, [$62,$F1,$56,$1F,$C2,$EC,$06                       ] , 'vcmpnless  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2045, [$62,$F1,$56,$2F,$C2,$29,$06                       ] , 'vcmpnless  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2046, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$06   ] , 'vcmpnless  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2047, [$62,$F1,$56,$2F,$C2,$6A,$7F,$06                   ] , 'vcmpnless  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2048, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$06       ] , 'vcmpnless  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2049, [$62,$F1,$56,$2F,$C2,$6A,$80,$06                   ] , 'vcmpnless  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2050, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$06       ] , 'vcmpnless  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2051, [$62,$F1,$56,$2F,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2052, [$62,$F1,$56,$1F,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2053, [$62,$F1,$56,$2F,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2054, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$07   ] , 'vcmpordss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2055, [$62,$F1,$56,$2F,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2056, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2057, [$62,$F1,$56,$2F,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2058, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2059, [$62,$F1,$56,$2F,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2060, [$62,$F1,$56,$1F,$C2,$EC,$07                       ] , 'vcmpordss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2061, [$62,$F1,$56,$2F,$C2,$29,$07                       ] , 'vcmpordss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2062, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$07   ] , 'vcmpordss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2063, [$62,$F1,$56,$2F,$C2,$6A,$7F,$07                   ] , 'vcmpordss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2064, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$07       ] , 'vcmpordss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2065, [$62,$F1,$56,$2F,$C2,$6A,$80,$07                   ] , 'vcmpordss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2066, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$07       ] , 'vcmpordss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2067, [$62,$F1,$56,$2F,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2068, [$62,$F1,$56,$1F,$C2,$EC,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2069, [$62,$F1,$56,$2F,$C2,$29,$08                       ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2070, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$08   ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2071, [$62,$F1,$56,$2F,$C2,$6A,$7F,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2072, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$08       ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2073, [$62,$F1,$56,$2F,$C2,$6A,$80,$08                   ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2074, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$08       ] , 'vcmpeq_uqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2075, [$62,$F1,$56,$2F,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2076, [$62,$F1,$56,$1F,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2077, [$62,$F1,$56,$2F,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2078, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$09   ] , 'vcmpngess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2079, [$62,$F1,$56,$2F,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2080, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2081, [$62,$F1,$56,$2F,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2082, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2083, [$62,$F1,$56,$2F,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2084, [$62,$F1,$56,$1F,$C2,$EC,$09                       ] , 'vcmpngess  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2085, [$62,$F1,$56,$2F,$C2,$29,$09                       ] , 'vcmpngess  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2086, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$09   ] , 'vcmpngess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2087, [$62,$F1,$56,$2F,$C2,$6A,$7F,$09                   ] , 'vcmpngess  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2088, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$09       ] , 'vcmpngess  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2089, [$62,$F1,$56,$2F,$C2,$6A,$80,$09                   ] , 'vcmpngess  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2090, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$09       ] , 'vcmpngess  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2091, [$62,$F1,$56,$2F,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2092, [$62,$F1,$56,$1F,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2093, [$62,$F1,$56,$2F,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2094, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0A   ] , 'vcmpngtss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2095, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2096, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2097, [$62,$F1,$56,$2F,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2098, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2099, [$62,$F1,$56,$2F,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,xmm4'                      );
  TestCase.testcase(2100, [$62,$F1,$56,$1F,$C2,$EC,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,xmm4,{sae}'                );
  TestCase.testcase(2101, [$62,$F1,$56,$2F,$C2,$29,$0A                       ] , 'vcmpngtss  k5{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2102, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0A   ] , 'vcmpngtss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2103, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0A                   ] , 'vcmpngtss  k5{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2104, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0A       ] , 'vcmpngtss  k5{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2105, [$62,$F1,$56,$2F,$C2,$6A,$80,$0A                   ] , 'vcmpngtss  k5{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2106, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0A       ] , 'vcmpngtss  k5{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2107, [$62,$F1,$56,$2F,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2108, [$62,$F1,$56,$1F,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2109, [$62,$F1,$56,$2F,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2110, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0B   ] , 'vcmpfalsess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2111, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2112, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2113, [$62,$F1,$56,$2F,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2114, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2115, [$62,$F1,$56,$2F,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2116, [$62,$F1,$56,$1F,$C2,$EC,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2117, [$62,$F1,$56,$2F,$C2,$29,$0B                       ] , 'vcmpfalsess  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2118, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0B   ] , 'vcmpfalsess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2119, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0B                   ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2120, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0B       ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2121, [$62,$F1,$56,$2F,$C2,$6A,$80,$0B                   ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2122, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0B       ] , 'vcmpfalsess  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2123, [$62,$F1,$56,$2F,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(2124, [$62,$F1,$56,$1F,$C2,$EC,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2125, [$62,$F1,$56,$2F,$C2,$29,$0C                       ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2126, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0C   ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2127, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2128, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2129, [$62,$F1,$56,$2F,$C2,$6A,$80,$0C                   ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2130, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0C       ] , 'vcmpneq_oqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2131, [$62,$F1,$56,$2F,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(2132, [$62,$F1,$56,$1F,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(2133, [$62,$F1,$56,$2F,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2134, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0D   ] , 'vcmpgess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2135, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2136, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2137, [$62,$F1,$56,$2F,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2138, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2139, [$62,$F1,$56,$2F,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(2140, [$62,$F1,$56,$1F,$C2,$EC,$0D                       ] , 'vcmpgess  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(2141, [$62,$F1,$56,$2F,$C2,$29,$0D                       ] , 'vcmpgess  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2142, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0D   ] , 'vcmpgess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2143, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0D                   ] , 'vcmpgess  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2144, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0D       ] , 'vcmpgess  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2145, [$62,$F1,$56,$2F,$C2,$6A,$80,$0D                   ] , 'vcmpgess  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2146, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0D       ] , 'vcmpgess  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2147, [$62,$F1,$56,$2F,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(2148, [$62,$F1,$56,$1F,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(2149, [$62,$F1,$56,$2F,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2150, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0E   ] , 'vcmpgtss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2151, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2152, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2153, [$62,$F1,$56,$2F,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2154, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2155, [$62,$F1,$56,$2F,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,xmm4'                       );
  TestCase.testcase(2156, [$62,$F1,$56,$1F,$C2,$EC,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(2157, [$62,$F1,$56,$2F,$C2,$29,$0E                       ] , 'vcmpgtss  k5{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2158, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0E   ] , 'vcmpgtss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2159, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0E                   ] , 'vcmpgtss  k5{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2160, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0E       ] , 'vcmpgtss  k5{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2161, [$62,$F1,$56,$2F,$C2,$6A,$80,$0E                   ] , 'vcmpgtss  k5{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2162, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0E       ] , 'vcmpgtss  k5{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2163, [$62,$F1,$56,$2F,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm5,xmm4'                        );
  TestCase.testcase(2164, [$62,$F1,$56,$1F,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm5,xmm4,{sae}'                  );
  TestCase.testcase(2165, [$62,$F1,$56,$2F,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm5,dword [ecx]'                 );
  TestCase.testcase(2166, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0F   ] , 'vcmuess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'   );
  TestCase.testcase(2167, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm5,dword [edx+0x1fc]'           );
  TestCase.testcase(2168, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm5,dword [edx+0x200]'           );
  TestCase.testcase(2169, [$62,$F1,$56,$2F,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm5,dword [edx-0x200]'           );
  TestCase.testcase(2170, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm5,dword [edx-0x204]'           );
  TestCase.testcase(2171, [$62,$F1,$56,$2F,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm5,xmm4'                        );
  TestCase.testcase(2172, [$62,$F1,$56,$1F,$C2,$EC,$0F                       ] , 'vcmuess  k5{k7},xmm5,xmm4,{sae}'                  );
  TestCase.testcase(2173, [$62,$F1,$56,$2F,$C2,$29,$0F                       ] , 'vcmuess  k5{k7},xmm5,dword [ecx]'                 );
  TestCase.testcase(2174, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$0F   ] , 'vcmuess  k5{k7},xmm5,dword [esp+esi*8-0x1e240]'   );
  TestCase.testcase(2175, [$62,$F1,$56,$2F,$C2,$6A,$7F,$0F                   ] , 'vcmuess  k5{k7},xmm5,dword [edx+0x1fc]'           );
  TestCase.testcase(2176, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$0F       ] , 'vcmuess  k5{k7},xmm5,dword [edx+0x200]'           );
  TestCase.testcase(2177, [$62,$F1,$56,$2F,$C2,$6A,$80,$0F                   ] , 'vcmuess  k5{k7},xmm5,dword [edx-0x200]'           );
  TestCase.testcase(2178, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$0F       ] , 'vcmuess  k5{k7},xmm5,dword [edx-0x204]'           );
  TestCase.testcase(2179, [$62,$F1,$56,$2F,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2180, [$62,$F1,$56,$1F,$C2,$EC,$10                       ] , 'vcmpeq_osss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2181, [$62,$F1,$56,$2F,$C2,$29,$10                       ] , 'vcmpeq_osss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2182, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$10   ] , 'vcmpeq_osss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2183, [$62,$F1,$56,$2F,$C2,$6A,$7F,$10                   ] , 'vcmpeq_osss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2184, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$10       ] , 'vcmpeq_osss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2185, [$62,$F1,$56,$2F,$C2,$6A,$80,$10                   ] , 'vcmpeq_osss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2186, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$10       ] , 'vcmpeq_osss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2187, [$62,$F1,$56,$2F,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2188, [$62,$F1,$56,$1F,$C2,$EC,$11                       ] , 'vcmplt_oqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2189, [$62,$F1,$56,$2F,$C2,$29,$11                       ] , 'vcmplt_oqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2190, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$11   ] , 'vcmplt_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2191, [$62,$F1,$56,$2F,$C2,$6A,$7F,$11                   ] , 'vcmplt_oqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2192, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$11       ] , 'vcmplt_oqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2193, [$62,$F1,$56,$2F,$C2,$6A,$80,$11                   ] , 'vcmplt_oqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2194, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$11       ] , 'vcmplt_oqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2195, [$62,$F1,$56,$2F,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2196, [$62,$F1,$56,$1F,$C2,$EC,$12                       ] , 'vcmple_oqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2197, [$62,$F1,$56,$2F,$C2,$29,$12                       ] , 'vcmple_oqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2198, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$12   ] , 'vcmple_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2199, [$62,$F1,$56,$2F,$C2,$6A,$7F,$12                   ] , 'vcmple_oqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2200, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$12       ] , 'vcmple_oqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2201, [$62,$F1,$56,$2F,$C2,$6A,$80,$12                   ] , 'vcmple_oqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2202, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$12       ] , 'vcmple_oqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2203, [$62,$F1,$56,$2F,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm5,xmm4'                  );
  TestCase.testcase(2204, [$62,$F1,$56,$1F,$C2,$EC,$13                       ] , 'vcmpunord_sss  k5{k7},xmm5,xmm4,{sae}'            );
  TestCase.testcase(2205, [$62,$F1,$56,$2F,$C2,$29,$13                       ] , 'vcmpunord_sss  k5{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(2206, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$13   ] , 'vcmpunord_sss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2207, [$62,$F1,$56,$2F,$C2,$6A,$7F,$13                   ] , 'vcmpunord_sss  k5{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(2208, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$13       ] , 'vcmpunord_sss  k5{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(2209, [$62,$F1,$56,$2F,$C2,$6A,$80,$13                   ] , 'vcmpunord_sss  k5{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(2210, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$13       ] , 'vcmpunord_sss  k5{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(2211, [$62,$F1,$56,$2F,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(2212, [$62,$F1,$56,$1F,$C2,$EC,$14                       ] , 'vcmpneq_usss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2213, [$62,$F1,$56,$2F,$C2,$29,$14                       ] , 'vcmpneq_usss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2214, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$14   ] , 'vcmpneq_usss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2215, [$62,$F1,$56,$2F,$C2,$6A,$7F,$14                   ] , 'vcmpneq_usss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2216, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$14       ] , 'vcmpneq_usss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2217, [$62,$F1,$56,$2F,$C2,$6A,$80,$14                   ] , 'vcmpneq_usss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2218, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$14       ] , 'vcmpneq_usss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2219, [$62,$F1,$56,$2F,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(2220, [$62,$F1,$56,$1F,$C2,$EC,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2221, [$62,$F1,$56,$2F,$C2,$29,$15                       ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2222, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$15   ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2223, [$62,$F1,$56,$2F,$C2,$6A,$7F,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2224, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2225, [$62,$F1,$56,$2F,$C2,$6A,$80,$15                   ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2226, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$15       ] , 'vcmpnlt_uqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2227, [$62,$F1,$56,$2F,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(2228, [$62,$F1,$56,$1F,$C2,$EC,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2229, [$62,$F1,$56,$2F,$C2,$29,$16                       ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2230, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$16   ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2231, [$62,$F1,$56,$2F,$C2,$6A,$7F,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2232, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$16       ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2233, [$62,$F1,$56,$2F,$C2,$6A,$80,$16                   ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2234, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$16       ] , 'vcmpnle_uqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2235, [$62,$F1,$56,$2F,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2236, [$62,$F1,$56,$1F,$C2,$EC,$17                       ] , 'vcmpord_sss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2237, [$62,$F1,$56,$2F,$C2,$29,$17                       ] , 'vcmpord_sss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2238, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$17   ] , 'vcmpord_sss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2239, [$62,$F1,$56,$2F,$C2,$6A,$7F,$17                   ] , 'vcmpord_sss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2240, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$17       ] , 'vcmpord_sss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2241, [$62,$F1,$56,$2F,$C2,$6A,$80,$17                   ] , 'vcmpord_sss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2242, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$17       ] , 'vcmpord_sss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2243, [$62,$F1,$56,$2F,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2244, [$62,$F1,$56,$1F,$C2,$EC,$18                       ] , 'vcmpeq_usss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2245, [$62,$F1,$56,$2F,$C2,$29,$18                       ] , 'vcmpeq_usss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2246, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$18   ] , 'vcmpeq_usss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2247, [$62,$F1,$56,$2F,$C2,$6A,$7F,$18                   ] , 'vcmpeq_usss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2248, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$18       ] , 'vcmpeq_usss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2249, [$62,$F1,$56,$2F,$C2,$6A,$80,$18                   ] , 'vcmpeq_usss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2250, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$18       ] , 'vcmpeq_usss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2251, [$62,$F1,$56,$2F,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(2252, [$62,$F1,$56,$1F,$C2,$EC,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2253, [$62,$F1,$56,$2F,$C2,$29,$19                       ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2254, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$19   ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2255, [$62,$F1,$56,$2F,$C2,$6A,$7F,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2256, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$19       ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2257, [$62,$F1,$56,$2F,$C2,$6A,$80,$19                   ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2258, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$19       ] , 'vcmpnge_uqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2259, [$62,$F1,$56,$2F,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(2260, [$62,$F1,$56,$1F,$C2,$EC,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2261, [$62,$F1,$56,$2F,$C2,$29,$1A                       ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2262, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1A   ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2263, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2264, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2265, [$62,$F1,$56,$2F,$C2,$6A,$80,$1A                   ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2266, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1A       ] , 'vcmpngt_uqss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2267, [$62,$F1,$56,$2F,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm5,xmm4'                 );
  TestCase.testcase(2268, [$62,$F1,$56,$1F,$C2,$EC,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm5,xmm4,{sae}'           );
  TestCase.testcase(2269, [$62,$F1,$56,$2F,$C2,$29,$1B                       ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(2270, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1B   ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2271, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(2272, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(2273, [$62,$F1,$56,$2F,$C2,$6A,$80,$1B                   ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(2274, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1B       ] , 'vcmpfalse_osss  k5{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(2275, [$62,$F1,$56,$2F,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm5,xmm4'                   );
  TestCase.testcase(2276, [$62,$F1,$56,$1F,$C2,$EC,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2277, [$62,$F1,$56,$2F,$C2,$29,$1C                       ] , 'vcmpneq_osss  k5{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2278, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1C   ] , 'vcmpneq_osss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2279, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2280, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1C       ] , 'vcmpneq_osss  k5{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2281, [$62,$F1,$56,$2F,$C2,$6A,$80,$1C                   ] , 'vcmpneq_osss  k5{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2282, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1C       ] , 'vcmpneq_osss  k5{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2283, [$62,$F1,$56,$2F,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2284, [$62,$F1,$56,$1F,$C2,$EC,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2285, [$62,$F1,$56,$2F,$C2,$29,$1D                       ] , 'vcmpge_oqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2286, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1D   ] , 'vcmpge_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2287, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2288, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1D       ] , 'vcmpge_oqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2289, [$62,$F1,$56,$2F,$C2,$6A,$80,$1D                   ] , 'vcmpge_oqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2290, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1D       ] , 'vcmpge_oqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2291, [$62,$F1,$56,$2F,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm5,xmm4'                    );
  TestCase.testcase(2292, [$62,$F1,$56,$1F,$C2,$EC,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2293, [$62,$F1,$56,$2F,$C2,$29,$1E                       ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2294, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1E   ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2295, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2296, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2297, [$62,$F1,$56,$2F,$C2,$6A,$80,$1E                   ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2298, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1E       ] , 'vcmpgt_oqss  k5{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2299, [$62,$F1,$56,$2F,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm5,xmm4'                     );
  TestCase.testcase(2300, [$62,$F1,$56,$1F,$C2,$EC,$1F                       ] , 'vcmue_usss  k5{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(2301, [$62,$F1,$56,$2F,$C2,$29,$1F                       ] , 'vcmue_usss  k5{k7},xmm5,dword [ecx]'              );
  TestCase.testcase(2302, [$62,$F1,$56,$2F,$C2,$AC,$F4,$C0,$1D,$FE,$FF,$1F   ] , 'vcmue_usss  k5{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2303, [$62,$F1,$56,$2F,$C2,$6A,$7F,$1F                   ] , 'vcmue_usss  k5{k7},xmm5,dword [edx+0x1fc]'        );
  TestCase.testcase(2304, [$62,$F1,$56,$2F,$C2,$AA,$00,$02,$00,$00,$1F       ] , 'vcmue_usss  k5{k7},xmm5,dword [edx+0x200]'        );
  TestCase.testcase(2305, [$62,$F1,$56,$2F,$C2,$6A,$80,$1F                   ] , 'vcmue_usss  k5{k7},xmm5,dword [edx-0x200]'        );
  TestCase.testcase(2306, [$62,$F1,$56,$2F,$C2,$AA,$FC,$FD,$FF,$FF,$1F       ] , 'vcmue_usss  k5{k7},xmm5,dword [edx-0x204]'        );
  TestCase.testcase(2307, [$62,$F1,$FD,$18,$2F,$F5                           ] , 'vcomisd  xmm6,xmm5,{sae}'                         );
  TestCase.testcase(2308, [$62,$F1,$7C,$18,$2F,$F5                           ] , 'vcomiss  xmm6,xmm5,{sae}'                         );
  TestCase.testcase(2309, [$62,$F1,$7F,$18,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm6,{rn-sae}'                     );
  TestCase.testcase(2310, [$62,$F1,$7F,$58,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm6,{ru-sae}'                     );
  TestCase.testcase(2311, [$62,$F1,$7F,$38,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm6,{rd-sae}'                     );
  TestCase.testcase(2312, [$62,$F1,$7F,$78,$2D,$C6                           ] , 'vcvtsd2si  eax,xmm6,{rz-sae}'                     );
  TestCase.testcase(2313, [$62,$F1,$7F,$18,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm6,{rn-sae}'                     );
  TestCase.testcase(2314, [$62,$F1,$7F,$58,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm6,{ru-sae}'                     );
  TestCase.testcase(2315, [$62,$F1,$7F,$38,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm6,{rd-sae}'                     );
  TestCase.testcase(2316, [$62,$F1,$7F,$78,$2D,$EE                           ] , 'vcvtsd2si  ebp,xmm6,{rz-sae}'                     );
  TestCase.testcase(2317, [$62,$F1,$D7,$2F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(2318, [$62,$F1,$D7,$AF,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(2319, [$62,$F1,$D7,$1F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4,{rn-sae}'           );
  TestCase.testcase(2320, [$62,$F1,$D7,$5F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4,{ru-sae}'           );
  TestCase.testcase(2321, [$62,$F1,$D7,$3F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4,{rd-sae}'           );
  TestCase.testcase(2322, [$62,$F1,$D7,$7F,$5A,$F4                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,xmm4,{rz-sae}'           );
  TestCase.testcase(2323, [$62,$F1,$D7,$2F,$5A,$31                           ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(2324, [$62,$F1,$D7,$2F,$5A,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2325, [$62,$F1,$D7,$2F,$5A,$72,$7F                       ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(2326, [$62,$F1,$D7,$2F,$5A,$B2,$00,$04,$00,$00           ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(2327, [$62,$F1,$D7,$2F,$5A,$72,$80                       ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(2328, [$62,$F1,$D7,$2F,$5A,$B2,$F8,$FB,$FF,$FF           ] , 'vcvtsd2ss  xmm6{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(2329, [$62,$F1,$56,$18,$2A,$F0                           ] , 'vcvtsi2ss  xmm6,xmm5,{rn-sae},eax'                );
  TestCase.testcase(2330, [$62,$F1,$56,$58,$2A,$F0                           ] , 'vcvtsi2ss  xmm6,xmm5,{ru-sae},eax'                );
  TestCase.testcase(2331, [$62,$F1,$56,$38,$2A,$F0                           ] , 'vcvtsi2ss  xmm6,xmm5,{rd-sae},eax'                );
  TestCase.testcase(2332, [$62,$F1,$56,$78,$2A,$F0                           ] , 'vcvtsi2ss  xmm6,xmm5,{rz-sae},eax'                );
  TestCase.testcase(2333, [$62,$F1,$56,$18,$2A,$F5                           ] , 'vcvtsi2ss  xmm6,xmm5,{rn-sae},ebp'                );
  TestCase.testcase(2334, [$62,$F1,$56,$58,$2A,$F5                           ] , 'vcvtsi2ss  xmm6,xmm5,{ru-sae},ebp'                );
  TestCase.testcase(2335, [$62,$F1,$56,$38,$2A,$F5                           ] , 'vcvtsi2ss  xmm6,xmm5,{rd-sae},ebp'                );
  TestCase.testcase(2336, [$62,$F1,$56,$78,$2A,$F5                           ] , 'vcvtsi2ss  xmm6,xmm5,{rz-sae},ebp'                );
  TestCase.testcase(2337, [$62,$F1,$56,$2F,$5A,$F4                           ] , 'vcvtss2sd  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(2338, [$62,$F1,$56,$AF,$5A,$F4                           ] , 'vcvtss2sd  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(2339, [$62,$F1,$56,$1F,$5A,$F4                           ] , 'vcvtss2sd  xmm6{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2340, [$62,$F1,$56,$2F,$5A,$31                           ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2341, [$62,$F1,$56,$2F,$5A,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2342, [$62,$F1,$56,$2F,$5A,$72,$7F                       ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2343, [$62,$F1,$56,$2F,$5A,$B2,$00,$02,$00,$00           ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2344, [$62,$F1,$56,$2F,$5A,$72,$80                       ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2345, [$62,$F1,$56,$2F,$5A,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtss2sd  xmm6{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2346, [$62,$F1,$7E,$18,$2D,$C6                           ] , 'vcvtss2si  eax,xmm6,{rn-sae}'                     );
  TestCase.testcase(2347, [$62,$F1,$7E,$58,$2D,$C6                           ] , 'vcvtss2si  eax,xmm6,{ru-sae}'                     );
  TestCase.testcase(2348, [$62,$F1,$7E,$38,$2D,$C6                           ] , 'vcvtss2si  eax,xmm6,{rd-sae}'                     );
  TestCase.testcase(2349, [$62,$F1,$7E,$78,$2D,$C6                           ] , 'vcvtss2si  eax,xmm6,{rz-sae}'                     );
  TestCase.testcase(2350, [$62,$F1,$7E,$18,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm6,{rn-sae}'                     );
  TestCase.testcase(2351, [$62,$F1,$7E,$58,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm6,{ru-sae}'                     );
  TestCase.testcase(2352, [$62,$F1,$7E,$38,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm6,{rd-sae}'                     );
  TestCase.testcase(2353, [$62,$F1,$7E,$78,$2D,$EE                           ] , 'vcvtss2si  ebp,xmm6,{rz-sae}'                     );
  TestCase.testcase(2354, [$62,$F1,$7F,$18,$2C,$C6                           ] , 'vcvttsd2si  eax,xmm6,{sae}'                       );
  TestCase.testcase(2355, [$62,$F1,$7F,$18,$2C,$EE                           ] , 'vcvttsd2si  ebp,xmm6,{sae}'                       );
  TestCase.testcase(2356, [$62,$F1,$7E,$18,$2C,$C6                           ] , 'vcvttss2si  eax,xmm6,{sae}'                       );
  TestCase.testcase(2357, [$62,$F1,$7E,$18,$2C,$EE                           ] , 'vcvttss2si  ebp,xmm6,{sae}'                       );
  TestCase.testcase(2358, [$62,$F1,$D7,$2F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2359, [$62,$F1,$D7,$AF,$5E,$F4                           ] , 'vdivsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2360, [$62,$F1,$D7,$1F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(2361, [$62,$F1,$D7,$5F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(2362, [$62,$F1,$D7,$3F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(2363, [$62,$F1,$D7,$7F,$5E,$F4                           ] , 'vdivsd  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(2364, [$62,$F1,$D7,$2F,$5E,$31                           ] , 'vdivsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(2365, [$62,$F1,$D7,$2F,$5E,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vdivsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2366, [$62,$F1,$D7,$2F,$5E,$72,$7F                       ] , 'vdivsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(2367, [$62,$F1,$D7,$2F,$5E,$B2,$00,$04,$00,$00           ] , 'vdivsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(2368, [$62,$F1,$D7,$2F,$5E,$72,$80                       ] , 'vdivsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(2369, [$62,$F1,$D7,$2F,$5E,$B2,$F8,$FB,$FF,$FF           ] , 'vdivsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(2370, [$62,$F1,$56,$2F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2371, [$62,$F1,$56,$AF,$5E,$F4                           ] , 'vdivss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2372, [$62,$F1,$56,$1F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(2373, [$62,$F1,$56,$5F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(2374, [$62,$F1,$56,$3F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(2375, [$62,$F1,$56,$7F,$5E,$F4                           ] , 'vdivss  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(2376, [$62,$F1,$56,$2F,$5E,$31                           ] , 'vdivss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2377, [$62,$F1,$56,$2F,$5E,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vdivss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2378, [$62,$F1,$56,$2F,$5E,$72,$7F                       ] , 'vdivss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2379, [$62,$F1,$56,$2F,$5E,$B2,$00,$02,$00,$00           ] , 'vdivss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2380, [$62,$F1,$56,$2F,$5E,$72,$80                       ] , 'vdivss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2381, [$62,$F1,$56,$2F,$5E,$B2,$FC,$FD,$FF,$FF           ] , 'vdivss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2382, [$62,$F2,$D5,$2F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2383, [$62,$F2,$D5,$AF,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2384, [$62,$F2,$D5,$1F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2385, [$62,$F2,$D5,$5F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2386, [$62,$F2,$D5,$3F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2387, [$62,$F2,$D5,$7F,$99,$F4                           ] , 'vfmadd132sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2388, [$62,$F2,$D5,$2F,$99,$31                           ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(2389, [$62,$F2,$D5,$2F,$99,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2390, [$62,$F2,$D5,$2F,$99,$72,$7F                       ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(2391, [$62,$F2,$D5,$2F,$99,$B2,$00,$04,$00,$00           ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(2392, [$62,$F2,$D5,$2F,$99,$72,$80                       ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(2393, [$62,$F2,$D5,$2F,$99,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd132sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(2394, [$62,$F2,$55,$2F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2395, [$62,$F2,$55,$AF,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2396, [$62,$F2,$55,$1F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2397, [$62,$F2,$55,$5F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2398, [$62,$F2,$55,$3F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2399, [$62,$F2,$55,$7F,$99,$F4                           ] , 'vfmadd132ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2400, [$62,$F2,$55,$2F,$99,$31                           ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(2401, [$62,$F2,$55,$2F,$99,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2402, [$62,$F2,$55,$2F,$99,$72,$7F                       ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(2403, [$62,$F2,$55,$2F,$99,$B2,$00,$02,$00,$00           ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(2404, [$62,$F2,$55,$2F,$99,$72,$80                       ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(2405, [$62,$F2,$55,$2F,$99,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd132ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(2406, [$62,$F2,$D5,$2F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2407, [$62,$F2,$D5,$AF,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2408, [$62,$F2,$D5,$1F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2409, [$62,$F2,$D5,$5F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2410, [$62,$F2,$D5,$3F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2411, [$62,$F2,$D5,$7F,$A9,$F4                           ] , 'vfmadd213sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2412, [$62,$F2,$D5,$2F,$A9,$31                           ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(2413, [$62,$F2,$D5,$2F,$A9,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2414, [$62,$F2,$D5,$2F,$A9,$72,$7F                       ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(2415, [$62,$F2,$D5,$2F,$A9,$B2,$00,$04,$00,$00           ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(2416, [$62,$F2,$D5,$2F,$A9,$72,$80                       ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(2417, [$62,$F2,$D5,$2F,$A9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd213sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(2418, [$62,$F2,$55,$2F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2419, [$62,$F2,$55,$AF,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2420, [$62,$F2,$55,$1F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2421, [$62,$F2,$55,$5F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2422, [$62,$F2,$55,$3F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2423, [$62,$F2,$55,$7F,$A9,$F4                           ] , 'vfmadd213ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2424, [$62,$F2,$55,$2F,$A9,$31                           ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(2425, [$62,$F2,$55,$2F,$A9,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2426, [$62,$F2,$55,$2F,$A9,$72,$7F                       ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(2427, [$62,$F2,$55,$2F,$A9,$B2,$00,$02,$00,$00           ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(2428, [$62,$F2,$55,$2F,$A9,$72,$80                       ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(2429, [$62,$F2,$55,$2F,$A9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd213ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(2430, [$62,$F2,$D5,$2F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2431, [$62,$F2,$D5,$AF,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2432, [$62,$F2,$D5,$1F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2433, [$62,$F2,$D5,$5F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2434, [$62,$F2,$D5,$3F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2435, [$62,$F2,$D5,$7F,$B9,$F4                           ] , 'vfmadd231sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2436, [$62,$F2,$D5,$2F,$B9,$31                           ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(2437, [$62,$F2,$D5,$2F,$B9,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2438, [$62,$F2,$D5,$2F,$B9,$72,$7F                       ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(2439, [$62,$F2,$D5,$2F,$B9,$B2,$00,$04,$00,$00           ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(2440, [$62,$F2,$D5,$2F,$B9,$72,$80                       ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(2441, [$62,$F2,$D5,$2F,$B9,$B2,$F8,$FB,$FF,$FF           ] , 'vfmadd231sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(2442, [$62,$F2,$55,$2F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2443, [$62,$F2,$55,$AF,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2444, [$62,$F2,$55,$1F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2445, [$62,$F2,$55,$5F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2446, [$62,$F2,$55,$3F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2447, [$62,$F2,$55,$7F,$B9,$F4                           ] , 'vfmadd231ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2448, [$62,$F2,$55,$2F,$B9,$31                           ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(2449, [$62,$F2,$55,$2F,$B9,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2450, [$62,$F2,$55,$2F,$B9,$72,$7F                       ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(2451, [$62,$F2,$55,$2F,$B9,$B2,$00,$02,$00,$00           ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(2452, [$62,$F2,$55,$2F,$B9,$72,$80                       ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(2453, [$62,$F2,$55,$2F,$B9,$B2,$FC,$FD,$FF,$FF           ] , 'vfmadd231ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(2454, [$62,$F2,$D5,$2F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2455, [$62,$F2,$D5,$AF,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2456, [$62,$F2,$D5,$1F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2457, [$62,$F2,$D5,$5F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2458, [$62,$F2,$D5,$3F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2459, [$62,$F2,$D5,$7F,$9B,$F4                           ] , 'vfmsub132sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2460, [$62,$F2,$D5,$2F,$9B,$31                           ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(2461, [$62,$F2,$D5,$2F,$9B,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2462, [$62,$F2,$D5,$2F,$9B,$72,$7F                       ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(2463, [$62,$F2,$D5,$2F,$9B,$B2,$00,$04,$00,$00           ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(2464, [$62,$F2,$D5,$2F,$9B,$72,$80                       ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(2465, [$62,$F2,$D5,$2F,$9B,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub132sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(2466, [$62,$F2,$55,$2F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2467, [$62,$F2,$55,$AF,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2468, [$62,$F2,$55,$1F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2469, [$62,$F2,$55,$5F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2470, [$62,$F2,$55,$3F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2471, [$62,$F2,$55,$7F,$9B,$F4                           ] , 'vfmsub132ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2472, [$62,$F2,$55,$2F,$9B,$31                           ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(2473, [$62,$F2,$55,$2F,$9B,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2474, [$62,$F2,$55,$2F,$9B,$72,$7F                       ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(2475, [$62,$F2,$55,$2F,$9B,$B2,$00,$02,$00,$00           ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(2476, [$62,$F2,$55,$2F,$9B,$72,$80                       ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(2477, [$62,$F2,$55,$2F,$9B,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub132ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(2478, [$62,$F2,$D5,$2F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2479, [$62,$F2,$D5,$AF,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2480, [$62,$F2,$D5,$1F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2481, [$62,$F2,$D5,$5F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2482, [$62,$F2,$D5,$3F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2483, [$62,$F2,$D5,$7F,$AB,$F4                           ] , 'vfmsub213sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2484, [$62,$F2,$D5,$2F,$AB,$31                           ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(2485, [$62,$F2,$D5,$2F,$AB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2486, [$62,$F2,$D5,$2F,$AB,$72,$7F                       ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(2487, [$62,$F2,$D5,$2F,$AB,$B2,$00,$04,$00,$00           ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(2488, [$62,$F2,$D5,$2F,$AB,$72,$80                       ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(2489, [$62,$F2,$D5,$2F,$AB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub213sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(2490, [$62,$F2,$55,$2F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2491, [$62,$F2,$55,$AF,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2492, [$62,$F2,$55,$1F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2493, [$62,$F2,$55,$5F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2494, [$62,$F2,$55,$3F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2495, [$62,$F2,$55,$7F,$AB,$F4                           ] , 'vfmsub213ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2496, [$62,$F2,$55,$2F,$AB,$31                           ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(2497, [$62,$F2,$55,$2F,$AB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2498, [$62,$F2,$55,$2F,$AB,$72,$7F                       ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(2499, [$62,$F2,$55,$2F,$AB,$B2,$00,$02,$00,$00           ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(2500, [$62,$F2,$55,$2F,$AB,$72,$80                       ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(2501, [$62,$F2,$55,$2F,$AB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub213ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(2502, [$62,$F2,$D5,$2F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2503, [$62,$F2,$D5,$AF,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2504, [$62,$F2,$D5,$1F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2505, [$62,$F2,$D5,$5F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2506, [$62,$F2,$D5,$3F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2507, [$62,$F2,$D5,$7F,$BB,$F4                           ] , 'vfmsub231sd  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2508, [$62,$F2,$D5,$2F,$BB,$31                           ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [ecx]'           );
  TestCase.testcase(2509, [$62,$F2,$D5,$2F,$BB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2510, [$62,$F2,$D5,$2F,$BB,$72,$7F                       ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [edx+0x3f8]'     );
  TestCase.testcase(2511, [$62,$F2,$D5,$2F,$BB,$B2,$00,$04,$00,$00           ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [edx+0x400]'     );
  TestCase.testcase(2512, [$62,$F2,$D5,$2F,$BB,$72,$80                       ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [edx-0x400]'     );
  TestCase.testcase(2513, [$62,$F2,$D5,$2F,$BB,$B2,$F8,$FB,$FF,$FF           ] , 'vfmsub231sd  xmm6{k7},xmm5,qword [edx-0x408]'     );
  TestCase.testcase(2514, [$62,$F2,$55,$2F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4'                  );
  TestCase.testcase(2515, [$62,$F2,$55,$AF,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7}{z},xmm5,xmm4'               );
  TestCase.testcase(2516, [$62,$F2,$55,$1F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4,{rn-sae}'         );
  TestCase.testcase(2517, [$62,$F2,$55,$5F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4,{ru-sae}'         );
  TestCase.testcase(2518, [$62,$F2,$55,$3F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4,{rd-sae}'         );
  TestCase.testcase(2519, [$62,$F2,$55,$7F,$BB,$F4                           ] , 'vfmsub231ss  xmm6{k7},xmm5,xmm4,{rz-sae}'         );
  TestCase.testcase(2520, [$62,$F2,$55,$2F,$BB,$31                           ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [ecx]'           );
  TestCase.testcase(2521, [$62,$F2,$55,$2F,$BB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2522, [$62,$F2,$55,$2F,$BB,$72,$7F                       ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [edx+0x1fc]'     );
  TestCase.testcase(2523, [$62,$F2,$55,$2F,$BB,$B2,$00,$02,$00,$00           ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [edx+0x200]'     );
  TestCase.testcase(2524, [$62,$F2,$55,$2F,$BB,$72,$80                       ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [edx-0x200]'     );
  TestCase.testcase(2525, [$62,$F2,$55,$2F,$BB,$B2,$FC,$FD,$FF,$FF           ] , 'vfmsub231ss  xmm6{k7},xmm5,dword [edx-0x204]'     );
  TestCase.testcase(2526, [$62,$F2,$D5,$2F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2527, [$62,$F2,$D5,$AF,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2528, [$62,$F2,$D5,$1F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2529, [$62,$F2,$D5,$5F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2530, [$62,$F2,$D5,$3F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2531, [$62,$F2,$D5,$7F,$9D,$F4                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2532, [$62,$F2,$D5,$2F,$9D,$31                           ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(2533, [$62,$F2,$D5,$2F,$9D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2534, [$62,$F2,$D5,$2F,$9D,$72,$7F                       ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(2535, [$62,$F2,$D5,$2F,$9D,$B2,$00,$04,$00,$00           ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(2536, [$62,$F2,$D5,$2F,$9D,$72,$80                       ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(2537, [$62,$F2,$D5,$2F,$9D,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd132sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(2538, [$62,$F2,$55,$2F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2539, [$62,$F2,$55,$AF,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2540, [$62,$F2,$55,$1F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2541, [$62,$F2,$55,$5F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2542, [$62,$F2,$55,$3F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2543, [$62,$F2,$55,$7F,$9D,$F4                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2544, [$62,$F2,$55,$2F,$9D,$31                           ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(2545, [$62,$F2,$55,$2F,$9D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2546, [$62,$F2,$55,$2F,$9D,$72,$7F                       ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(2547, [$62,$F2,$55,$2F,$9D,$B2,$00,$02,$00,$00           ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(2548, [$62,$F2,$55,$2F,$9D,$72,$80                       ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(2549, [$62,$F2,$55,$2F,$9D,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd132ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(2550, [$62,$F2,$D5,$2F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2551, [$62,$F2,$D5,$AF,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2552, [$62,$F2,$D5,$1F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2553, [$62,$F2,$D5,$5F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2554, [$62,$F2,$D5,$3F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2555, [$62,$F2,$D5,$7F,$AD,$F4                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2556, [$62,$F2,$D5,$2F,$AD,$31                           ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(2557, [$62,$F2,$D5,$2F,$AD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2558, [$62,$F2,$D5,$2F,$AD,$72,$7F                       ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(2559, [$62,$F2,$D5,$2F,$AD,$B2,$00,$04,$00,$00           ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(2560, [$62,$F2,$D5,$2F,$AD,$72,$80                       ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(2561, [$62,$F2,$D5,$2F,$AD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd213sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(2562, [$62,$F2,$55,$2F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2563, [$62,$F2,$55,$AF,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2564, [$62,$F2,$55,$1F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2565, [$62,$F2,$55,$5F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2566, [$62,$F2,$55,$3F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2567, [$62,$F2,$55,$7F,$AD,$F4                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2568, [$62,$F2,$55,$2F,$AD,$31                           ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(2569, [$62,$F2,$55,$2F,$AD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2570, [$62,$F2,$55,$2F,$AD,$72,$7F                       ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(2571, [$62,$F2,$55,$2F,$AD,$B2,$00,$02,$00,$00           ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(2572, [$62,$F2,$55,$2F,$AD,$72,$80                       ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(2573, [$62,$F2,$55,$2F,$AD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd213ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(2574, [$62,$F2,$D5,$2F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2575, [$62,$F2,$D5,$AF,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2576, [$62,$F2,$D5,$1F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2577, [$62,$F2,$D5,$5F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2578, [$62,$F2,$D5,$3F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2579, [$62,$F2,$D5,$7F,$BD,$F4                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2580, [$62,$F2,$D5,$2F,$BD,$31                           ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(2581, [$62,$F2,$D5,$2F,$BD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2582, [$62,$F2,$D5,$2F,$BD,$72,$7F                       ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(2583, [$62,$F2,$D5,$2F,$BD,$B2,$00,$04,$00,$00           ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(2584, [$62,$F2,$D5,$2F,$BD,$72,$80                       ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(2585, [$62,$F2,$D5,$2F,$BD,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmadd231sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(2586, [$62,$F2,$55,$2F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2587, [$62,$F2,$55,$AF,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2588, [$62,$F2,$55,$1F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2589, [$62,$F2,$55,$5F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2590, [$62,$F2,$55,$3F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2591, [$62,$F2,$55,$7F,$BD,$F4                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2592, [$62,$F2,$55,$2F,$BD,$31                           ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(2593, [$62,$F2,$55,$2F,$BD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2594, [$62,$F2,$55,$2F,$BD,$72,$7F                       ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(2595, [$62,$F2,$55,$2F,$BD,$B2,$00,$02,$00,$00           ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(2596, [$62,$F2,$55,$2F,$BD,$72,$80                       ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(2597, [$62,$F2,$55,$2F,$BD,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmadd231ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(2598, [$62,$F2,$D5,$2F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2599, [$62,$F2,$D5,$AF,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2600, [$62,$F2,$D5,$1F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2601, [$62,$F2,$D5,$5F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2602, [$62,$F2,$D5,$3F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2603, [$62,$F2,$D5,$7F,$9F,$F4                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2604, [$62,$F2,$D5,$2F,$9F,$31                           ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(2605, [$62,$F2,$D5,$2F,$9F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2606, [$62,$F2,$D5,$2F,$9F,$72,$7F                       ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(2607, [$62,$F2,$D5,$2F,$9F,$B2,$00,$04,$00,$00           ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(2608, [$62,$F2,$D5,$2F,$9F,$72,$80                       ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(2609, [$62,$F2,$D5,$2F,$9F,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub132sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(2610, [$62,$F2,$55,$2F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2611, [$62,$F2,$55,$AF,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2612, [$62,$F2,$55,$1F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2613, [$62,$F2,$55,$5F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2614, [$62,$F2,$55,$3F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2615, [$62,$F2,$55,$7F,$9F,$F4                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2616, [$62,$F2,$55,$2F,$9F,$31                           ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(2617, [$62,$F2,$55,$2F,$9F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2618, [$62,$F2,$55,$2F,$9F,$72,$7F                       ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(2619, [$62,$F2,$55,$2F,$9F,$B2,$00,$02,$00,$00           ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(2620, [$62,$F2,$55,$2F,$9F,$72,$80                       ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(2621, [$62,$F2,$55,$2F,$9F,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub132ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(2622, [$62,$F2,$D5,$2F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2623, [$62,$F2,$D5,$AF,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2624, [$62,$F2,$D5,$1F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2625, [$62,$F2,$D5,$5F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2626, [$62,$F2,$D5,$3F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2627, [$62,$F2,$D5,$7F,$AF,$F4                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2628, [$62,$F2,$D5,$2F,$AF,$31                           ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(2629, [$62,$F2,$D5,$2F,$AF,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2630, [$62,$F2,$D5,$2F,$AF,$72,$7F                       ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(2631, [$62,$F2,$D5,$2F,$AF,$B2,$00,$04,$00,$00           ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(2632, [$62,$F2,$D5,$2F,$AF,$72,$80                       ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(2633, [$62,$F2,$D5,$2F,$AF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub213sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(2634, [$62,$F2,$55,$2F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2635, [$62,$F2,$55,$AF,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2636, [$62,$F2,$55,$1F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2637, [$62,$F2,$55,$5F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2638, [$62,$F2,$55,$3F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2639, [$62,$F2,$55,$7F,$AF,$F4                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2640, [$62,$F2,$55,$2F,$AF,$31                           ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(2641, [$62,$F2,$55,$2F,$AF,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2642, [$62,$F2,$55,$2F,$AF,$72,$7F                       ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(2643, [$62,$F2,$55,$2F,$AF,$B2,$00,$02,$00,$00           ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(2644, [$62,$F2,$55,$2F,$AF,$72,$80                       ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(2645, [$62,$F2,$55,$2F,$AF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub213ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(2646, [$62,$F2,$D5,$2F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2647, [$62,$F2,$D5,$AF,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2648, [$62,$F2,$D5,$1F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2649, [$62,$F2,$D5,$5F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2650, [$62,$F2,$D5,$3F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2651, [$62,$F2,$D5,$7F,$BF,$F4                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2652, [$62,$F2,$D5,$2F,$BF,$31                           ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [ecx]'          );
  TestCase.testcase(2653, [$62,$F2,$D5,$2F,$BF,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2654, [$62,$F2,$D5,$2F,$BF,$72,$7F                       ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [edx+0x3f8]'    );
  TestCase.testcase(2655, [$62,$F2,$D5,$2F,$BF,$B2,$00,$04,$00,$00           ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [edx+0x400]'    );
  TestCase.testcase(2656, [$62,$F2,$D5,$2F,$BF,$72,$80                       ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [edx-0x400]'    );
  TestCase.testcase(2657, [$62,$F2,$D5,$2F,$BF,$B2,$F8,$FB,$FF,$FF           ] , 'vfnmsub231sd  xmm6{k7},xmm5,qword [edx-0x408]'    );
  TestCase.testcase(2658, [$62,$F2,$55,$2F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4'                 );
  TestCase.testcase(2659, [$62,$F2,$55,$AF,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7}{z},xmm5,xmm4'              );
  TestCase.testcase(2660, [$62,$F2,$55,$1F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4,{rn-sae}'        );
  TestCase.testcase(2661, [$62,$F2,$55,$5F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4,{ru-sae}'        );
  TestCase.testcase(2662, [$62,$F2,$55,$3F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4,{rd-sae}'        );
  TestCase.testcase(2663, [$62,$F2,$55,$7F,$BF,$F4                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,xmm4,{rz-sae}'        );
  TestCase.testcase(2664, [$62,$F2,$55,$2F,$BF,$31                           ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [ecx]'          );
  TestCase.testcase(2665, [$62,$F2,$55,$2F,$BF,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2666, [$62,$F2,$55,$2F,$BF,$72,$7F                       ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [edx+0x1fc]'    );
  TestCase.testcase(2667, [$62,$F2,$55,$2F,$BF,$B2,$00,$02,$00,$00           ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [edx+0x200]'    );
  TestCase.testcase(2668, [$62,$F2,$55,$2F,$BF,$72,$80                       ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [edx-0x200]'    );
  TestCase.testcase(2669, [$62,$F2,$55,$2F,$BF,$B2,$FC,$FD,$FF,$FF           ] , 'vfnmsub231ss  xmm6{k7},xmm5,dword [edx-0x204]'    );
  TestCase.testcase(2670, [$62,$F2,$D5,$2F,$43,$F4                           ] , 'vgetexpsd  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(2671, [$62,$F2,$D5,$AF,$43,$F4                           ] , 'vgetexpsd  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(2672, [$62,$F2,$D5,$1F,$43,$F4                           ] , 'vgetexpsd  xmm6{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2673, [$62,$F2,$D5,$2F,$43,$31                           ] , 'vgetexpsd  xmm6{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(2674, [$62,$F2,$D5,$2F,$43,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vgetexpsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2675, [$62,$F2,$D5,$2F,$43,$72,$7F                       ] , 'vgetexpsd  xmm6{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(2676, [$62,$F2,$D5,$2F,$43,$B2,$00,$04,$00,$00           ] , 'vgetexpsd  xmm6{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(2677, [$62,$F2,$D5,$2F,$43,$72,$80                       ] , 'vgetexpsd  xmm6{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(2678, [$62,$F2,$D5,$2F,$43,$B2,$F8,$FB,$FF,$FF           ] , 'vgetexpsd  xmm6{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(2679, [$62,$F2,$55,$2F,$43,$F4                           ] , 'vgetexpss  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(2680, [$62,$F2,$55,$AF,$43,$F4                           ] , 'vgetexpss  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(2681, [$62,$F2,$55,$1F,$43,$F4                           ] , 'vgetexpss  xmm6{k7},xmm5,xmm4,{sae}'              );
  TestCase.testcase(2682, [$62,$F2,$55,$2F,$43,$31                           ] , 'vgetexpss  xmm6{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(2683, [$62,$F2,$55,$2F,$43,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vgetexpss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2684, [$62,$F2,$55,$2F,$43,$72,$7F                       ] , 'vgetexpss  xmm6{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(2685, [$62,$F2,$55,$2F,$43,$B2,$00,$02,$00,$00           ] , 'vgetexpss  xmm6{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(2686, [$62,$F2,$55,$2F,$43,$72,$80                       ] , 'vgetexpss  xmm6{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(2687, [$62,$F2,$55,$2F,$43,$B2,$FC,$FD,$FF,$FF           ] , 'vgetexpss  xmm6{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(2688, [$62,$F3,$D5,$2F,$27,$F4,$AB                       ] , 'vgetmantsd  xmm6{k7},xmm5,xmm4,0xab'              );
  TestCase.testcase(2689, [$62,$F3,$D5,$AF,$27,$F4,$AB                       ] , 'vgetmantsd  xmm6{k7}{z},xmm5,xmm4,0xab'           );
  TestCase.testcase(2690, [$62,$F3,$D5,$1F,$27,$F4,$AB                       ] , 'vgetmantsd  xmm6{k7},xmm5,xmm4,{sae},0xab'        );
  TestCase.testcase(2691, [$62,$F3,$D5,$2F,$27,$F4,$7B                       ] , 'vgetmantsd  xmm6{k7},xmm5,xmm4,0x7b'              );
  TestCase.testcase(2692, [$62,$F3,$D5,$1F,$27,$F4,$7B                       ] , 'vgetmantsd  xmm6{k7},xmm5,xmm4,{sae},0x7b'        );
  TestCase.testcase(2693, [$62,$F3,$D5,$2F,$27,$31,$7B                       ] , 'vgetmantsd  xmm6{k7},xmm5,qword [ecx],0x7b'       );
  TestCase.testcase(2694, [$62,$F3,$D5,$2F,$27,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vgetmantsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(2695, [$62,$F3,$D5,$2F,$27,$72,$7F,$7B                   ] , 'vgetmantsd  xmm6{k7},xmm5,qword [edx+0x3f8],0x7b' );
  TestCase.testcase(2696, [$62,$F3,$D5,$2F,$27,$B2,$00,$04,$00,$00,$7B       ] , 'vgetmantsd  xmm6{k7},xmm5,qword [edx+0x400],0x7b' );
  TestCase.testcase(2697, [$62,$F3,$D5,$2F,$27,$72,$80,$7B                   ] , 'vgetmantsd  xmm6{k7},xmm5,qword [edx-0x400],0x7b' );
  TestCase.testcase(2698, [$62,$F3,$D5,$2F,$27,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vgetmantsd  xmm6{k7},xmm5,qword [edx-0x408],0x7b' );
  TestCase.testcase(2699, [$62,$F3,$55,$2F,$27,$F4,$AB                       ] , 'vgetmantss  xmm6{k7},xmm5,xmm4,0xab'              );
  TestCase.testcase(2700, [$62,$F3,$55,$AF,$27,$F4,$AB                       ] , 'vgetmantss  xmm6{k7}{z},xmm5,xmm4,0xab'           );
  TestCase.testcase(2701, [$62,$F3,$55,$1F,$27,$F4,$AB                       ] , 'vgetmantss  xmm6{k7},xmm5,xmm4,{sae},0xab'        );
  TestCase.testcase(2702, [$62,$F3,$55,$2F,$27,$F4,$7B                       ] , 'vgetmantss  xmm6{k7},xmm5,xmm4,0x7b'              );
  TestCase.testcase(2703, [$62,$F3,$55,$1F,$27,$F4,$7B                       ] , 'vgetmantss  xmm6{k7},xmm5,xmm4,{sae},0x7b'        );
  TestCase.testcase(2704, [$62,$F3,$55,$2F,$27,$31,$7B                       ] , 'vgetmantss  xmm6{k7},xmm5,dword [ecx],0x7b'       );
  TestCase.testcase(2705, [$62,$F3,$55,$2F,$27,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vgetmantss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(2706, [$62,$F3,$55,$2F,$27,$72,$7F,$7B                   ] , 'vgetmantss  xmm6{k7},xmm5,dword [edx+0x1fc],0x7b' );
  TestCase.testcase(2707, [$62,$F3,$55,$2F,$27,$B2,$00,$02,$00,$00,$7B       ] , 'vgetmantss  xmm6{k7},xmm5,dword [edx+0x200],0x7b' );
  TestCase.testcase(2708, [$62,$F3,$55,$2F,$27,$72,$80,$7B                   ] , 'vgetmantss  xmm6{k7},xmm5,dword [edx-0x200],0x7b' );
  TestCase.testcase(2709, [$62,$F3,$55,$2F,$27,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vgetmantss  xmm6{k7},xmm5,dword [edx-0x204],0x7b' );
  TestCase.testcase(2710, [$62,$F1,$D7,$2F,$5F,$F4                           ] , 'vmaxsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2711, [$62,$F1,$D7,$AF,$5F,$F4                           ] , 'vmaxsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2712, [$62,$F1,$D7,$1F,$5F,$F4                           ] , 'vmaxsd  xmm6{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(2713, [$62,$F1,$D7,$2F,$5F,$31                           ] , 'vmaxsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(2714, [$62,$F1,$D7,$2F,$5F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmaxsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2715, [$62,$F1,$D7,$2F,$5F,$72,$7F                       ] , 'vmaxsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(2716, [$62,$F1,$D7,$2F,$5F,$B2,$00,$04,$00,$00           ] , 'vmaxsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(2717, [$62,$F1,$D7,$2F,$5F,$72,$80                       ] , 'vmaxsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(2718, [$62,$F1,$D7,$2F,$5F,$B2,$F8,$FB,$FF,$FF           ] , 'vmaxsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(2719, [$62,$F1,$56,$2F,$5F,$F4                           ] , 'vmaxss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2720, [$62,$F1,$56,$AF,$5F,$F4                           ] , 'vmaxss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2721, [$62,$F1,$56,$1F,$5F,$F4                           ] , 'vmaxss  xmm6{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(2722, [$62,$F1,$56,$2F,$5F,$31                           ] , 'vmaxss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2723, [$62,$F1,$56,$2F,$5F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmaxss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2724, [$62,$F1,$56,$2F,$5F,$72,$7F                       ] , 'vmaxss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2725, [$62,$F1,$56,$2F,$5F,$B2,$00,$02,$00,$00           ] , 'vmaxss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2726, [$62,$F1,$56,$2F,$5F,$72,$80                       ] , 'vmaxss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2727, [$62,$F1,$56,$2F,$5F,$B2,$FC,$FD,$FF,$FF           ] , 'vmaxss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2728, [$62,$F1,$D7,$2F,$5D,$F4                           ] , 'vminsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2729, [$62,$F1,$D7,$AF,$5D,$F4                           ] , 'vminsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2730, [$62,$F1,$D7,$1F,$5D,$F4                           ] , 'vminsd  xmm6{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(2731, [$62,$F1,$D7,$2F,$5D,$31                           ] , 'vminsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(2732, [$62,$F1,$D7,$2F,$5D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vminsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2733, [$62,$F1,$D7,$2F,$5D,$72,$7F                       ] , 'vminsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(2734, [$62,$F1,$D7,$2F,$5D,$B2,$00,$04,$00,$00           ] , 'vminsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(2735, [$62,$F1,$D7,$2F,$5D,$72,$80                       ] , 'vminsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(2736, [$62,$F1,$D7,$2F,$5D,$B2,$F8,$FB,$FF,$FF           ] , 'vminsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(2737, [$62,$F1,$56,$2F,$5D,$F4                           ] , 'vminss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2738, [$62,$F1,$56,$AF,$5D,$F4                           ] , 'vminss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2739, [$62,$F1,$56,$1F,$5D,$F4                           ] , 'vminss  xmm6{k7},xmm5,xmm4,{sae}'                 );
  TestCase.testcase(2740, [$62,$F1,$56,$2F,$5D,$31                           ] , 'vminss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2741, [$62,$F1,$56,$2F,$5D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vminss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2742, [$62,$F1,$56,$2F,$5D,$72,$7F                       ] , 'vminss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2743, [$62,$F1,$56,$2F,$5D,$B2,$00,$02,$00,$00           ] , 'vminss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2744, [$62,$F1,$56,$2F,$5D,$72,$80                       ] , 'vminss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2745, [$62,$F1,$56,$2F,$5D,$B2,$FC,$FD,$FF,$FF           ] , 'vminss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2746, [$62,$F1,$FF,$2F,$10,$31                           ] , 'vmovsd  xmm6{k7},qword [ecx]'                     );
  TestCase.testcase(2747, [$62,$F1,$FF,$AF,$10,$31                           ] , 'vmovsd  xmm6{k7}{z},qword [ecx]'                  );
  TestCase.testcase(2748, [$62,$F1,$FF,$2F,$10,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmovsd  xmm6{k7},qword [esp+esi*8-0x1e240]'       );
  TestCase.testcase(2749, [$62,$F1,$FF,$2F,$10,$72,$7F                       ] , 'vmovsd  xmm6{k7},qword [edx+0x3f8]'               );
  TestCase.testcase(2750, [$62,$F1,$FF,$2F,$10,$B2,$00,$04,$00,$00           ] , 'vmovsd  xmm6{k7},qword [edx+0x400]'               );
  TestCase.testcase(2751, [$62,$F1,$FF,$2F,$10,$72,$80                       ] , 'vmovsd  xmm6{k7},qword [edx-0x400]'               );
  TestCase.testcase(2752, [$62,$F1,$FF,$2F,$10,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  xmm6{k7},qword [edx-0x408]'               );
  TestCase.testcase(2753, [$62,$F1,$FF,$2F,$11,$31                           ] , 'vmovsd  qword [ecx]{k7},xmm6'                     );
  TestCase.testcase(2754, [$62,$F1,$FF,$2F,$11,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmovsd  qword [esp+esi*8-0x1e240]{k7},xmm6'       );
  TestCase.testcase(2755, [$62,$F1,$FF,$2F,$11,$72,$7F                       ] , 'vmovsd  qword [edx+0x3f8]{k7},xmm6'               );
  TestCase.testcase(2756, [$62,$F1,$FF,$2F,$11,$B2,$00,$04,$00,$00           ] , 'vmovsd  qword [edx+0x400]{k7},xmm6'               );
  TestCase.testcase(2757, [$62,$F1,$FF,$2F,$11,$72,$80                       ] , 'vmovsd  qword [edx-0x400]{k7},xmm6'               );
  TestCase.testcase(2758, [$62,$F1,$FF,$2F,$11,$B2,$F8,$FB,$FF,$FF           ] , 'vmovsd  qword [edx-0x408]{k7},xmm6'               );
  TestCase.testcase(2759, [$62,$F1,$D7,$2F,$10,$F4                           ] , 'vmovsd  xmm6{k7},xmm5,ymm4'                       );
  TestCase.testcase(2760, [$62,$F1,$D7,$AF,$10,$F4                           ] , 'vmovsd  xmm6{k7}{z},xmm5,ymm4'                    );
  TestCase.testcase(2761, [$62,$F1,$7E,$2F,$10,$31                           ] , 'vmovss  xmm6{k7},dword [ecx]'                     );
  TestCase.testcase(2762, [$62,$F1,$7E,$AF,$10,$31                           ] , 'vmovss  xmm6{k7}{z},dword [ecx]'                  );
  TestCase.testcase(2763, [$62,$F1,$7E,$2F,$10,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmovss  xmm6{k7},dword [esp+esi*8-0x1e240]'       );
  TestCase.testcase(2764, [$62,$F1,$7E,$2F,$10,$72,$7F                       ] , 'vmovss  xmm6{k7},dword [edx+0x1fc]'               );
  TestCase.testcase(2765, [$62,$F1,$7E,$2F,$10,$B2,$00,$02,$00,$00           ] , 'vmovss  xmm6{k7},dword [edx+0x200]'               );
  TestCase.testcase(2766, [$62,$F1,$7E,$2F,$10,$72,$80                       ] , 'vmovss  xmm6{k7},dword [edx-0x200]'               );
  TestCase.testcase(2767, [$62,$F1,$7E,$2F,$10,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  xmm6{k7},dword [edx-0x204]'               );
  TestCase.testcase(2768, [$62,$F1,$7E,$2F,$11,$31                           ] , 'vmovss  dword [ecx]{k7},xmm6'                     );
  TestCase.testcase(2769, [$62,$F1,$7E,$2F,$11,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmovss  dword [esp+esi*8-0x1e240]{k7},xmm6'       );
  TestCase.testcase(2770, [$62,$F1,$7E,$2F,$11,$72,$7F                       ] , 'vmovss  dword [edx+0x1fc]{k7},xmm6'               );
  TestCase.testcase(2771, [$62,$F1,$7E,$2F,$11,$B2,$00,$02,$00,$00           ] , 'vmovss  dword [edx+0x200]{k7},xmm6'               );
  TestCase.testcase(2772, [$62,$F1,$7E,$2F,$11,$72,$80                       ] , 'vmovss  dword [edx-0x200]{k7},xmm6'               );
  TestCase.testcase(2773, [$62,$F1,$7E,$2F,$11,$B2,$FC,$FD,$FF,$FF           ] , 'vmovss  dword [edx-0x204]{k7},xmm6'               );
  TestCase.testcase(2774, [$62,$F1,$56,$2F,$10,$F4                           ] , 'vmovss  xmm6{k7},xmm5,ymm4'                       );
  TestCase.testcase(2775, [$62,$F1,$56,$AF,$10,$F4                           ] , 'vmovss  xmm6{k7}{z},xmm5,ymm4'                    );
  TestCase.testcase(2776, [$62,$F1,$D7,$2F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2777, [$62,$F1,$D7,$AF,$59,$F4                           ] , 'vmulsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2778, [$62,$F1,$D7,$1F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(2779, [$62,$F1,$D7,$5F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(2780, [$62,$F1,$D7,$3F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(2781, [$62,$F1,$D7,$7F,$59,$F4                           ] , 'vmulsd  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(2782, [$62,$F1,$D7,$2F,$59,$31                           ] , 'vmulsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(2783, [$62,$F1,$D7,$2F,$59,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmulsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2784, [$62,$F1,$D7,$2F,$59,$72,$7F                       ] , 'vmulsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(2785, [$62,$F1,$D7,$2F,$59,$B2,$00,$04,$00,$00           ] , 'vmulsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(2786, [$62,$F1,$D7,$2F,$59,$72,$80                       ] , 'vmulsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(2787, [$62,$F1,$D7,$2F,$59,$B2,$F8,$FB,$FF,$FF           ] , 'vmulsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(2788, [$62,$F1,$56,$2F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2789, [$62,$F1,$56,$AF,$59,$F4                           ] , 'vmulss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2790, [$62,$F1,$56,$1F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(2791, [$62,$F1,$56,$5F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(2792, [$62,$F1,$56,$3F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(2793, [$62,$F1,$56,$7F,$59,$F4                           ] , 'vmulss  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(2794, [$62,$F1,$56,$2F,$59,$31                           ] , 'vmulss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2795, [$62,$F1,$56,$2F,$59,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vmulss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2796, [$62,$F1,$56,$2F,$59,$72,$7F                       ] , 'vmulss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2797, [$62,$F1,$56,$2F,$59,$B2,$00,$02,$00,$00           ] , 'vmulss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2798, [$62,$F1,$56,$2F,$59,$72,$80                       ] , 'vmulss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2799, [$62,$F1,$56,$2F,$59,$B2,$FC,$FD,$FF,$FF           ] , 'vmulss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2800, [$62,$F2,$D5,$2F,$4D,$F4                           ] , 'vrcp14sd  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(2801, [$62,$F2,$D5,$AF,$4D,$F4                           ] , 'vrcp14sd  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(2802, [$62,$F2,$D5,$2F,$4D,$31                           ] , 'vrcp14sd  xmm6{k7},xmm5,qword [ecx]'              );
  TestCase.testcase(2803, [$62,$F2,$D5,$2F,$4D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp14sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2804, [$62,$F2,$D5,$2F,$4D,$72,$7F                       ] , 'vrcp14sd  xmm6{k7},xmm5,qword [edx+0x3f8]'        );
  TestCase.testcase(2805, [$62,$F2,$D5,$2F,$4D,$B2,$00,$04,$00,$00           ] , 'vrcp14sd  xmm6{k7},xmm5,qword [edx+0x400]'        );
  TestCase.testcase(2806, [$62,$F2,$D5,$2F,$4D,$72,$80                       ] , 'vrcp14sd  xmm6{k7},xmm5,qword [edx-0x400]'        );
  TestCase.testcase(2807, [$62,$F2,$D5,$2F,$4D,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp14sd  xmm6{k7},xmm5,qword [edx-0x408]'        );
  TestCase.testcase(2808, [$62,$F2,$55,$2F,$4D,$F4                           ] , 'vrcp14ss  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(2809, [$62,$F2,$55,$AF,$4D,$F4                           ] , 'vrcp14ss  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(2810, [$62,$F2,$55,$2F,$4D,$31                           ] , 'vrcp14ss  xmm6{k7},xmm5,dword [ecx]'              );
  TestCase.testcase(2811, [$62,$F2,$55,$2F,$4D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp14ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2812, [$62,$F2,$55,$2F,$4D,$72,$7F                       ] , 'vrcp14ss  xmm6{k7},xmm5,dword [edx+0x1fc]'        );
  TestCase.testcase(2813, [$62,$F2,$55,$2F,$4D,$B2,$00,$02,$00,$00           ] , 'vrcp14ss  xmm6{k7},xmm5,dword [edx+0x200]'        );
  TestCase.testcase(2814, [$62,$F2,$55,$2F,$4D,$72,$80                       ] , 'vrcp14ss  xmm6{k7},xmm5,dword [edx-0x200]'        );
  TestCase.testcase(2815, [$62,$F2,$55,$2F,$4D,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp14ss  xmm6{k7},xmm5,dword [edx-0x204]'        );
  TestCase.testcase(2816, [$62,$F2,$55,$2F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(2817, [$62,$F2,$55,$AF,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(2818, [$62,$F2,$55,$1F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(2819, [$62,$F2,$55,$2F,$CB,$31                           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [ecx]'              );
  TestCase.testcase(2820, [$62,$F2,$55,$2F,$CB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2821, [$62,$F2,$55,$2F,$CB,$72,$7F                       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx+0x1fc]'        );
  TestCase.testcase(2822, [$62,$F2,$55,$2F,$CB,$B2,$00,$02,$00,$00           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx+0x200]'        );
  TestCase.testcase(2823, [$62,$F2,$55,$2F,$CB,$72,$80                       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx-0x200]'        );
  TestCase.testcase(2824, [$62,$F2,$55,$2F,$CB,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx-0x204]'        );
  TestCase.testcase(2825, [$62,$F2,$D5,$2F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(2826, [$62,$F2,$D5,$AF,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(2827, [$62,$F2,$D5,$1F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(2828, [$62,$F2,$D5,$2F,$CB,$31                           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [ecx]'              );
  TestCase.testcase(2829, [$62,$F2,$D5,$2F,$CB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2830, [$62,$F2,$D5,$2F,$CB,$72,$7F                       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx+0x3f8]'        );
  TestCase.testcase(2831, [$62,$F2,$D5,$2F,$CB,$B2,$00,$04,$00,$00           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx+0x400]'        );
  TestCase.testcase(2832, [$62,$F2,$D5,$2F,$CB,$72,$80                       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx-0x400]'        );
  TestCase.testcase(2833, [$62,$F2,$D5,$2F,$CB,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx-0x408]'        );
  TestCase.testcase(2834, [$62,$F2,$D5,$2F,$4F,$F4                           ] , 'vrsqrt14sd  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(2835, [$62,$F2,$D5,$AF,$4F,$F4                           ] , 'vrsqrt14sd  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(2836, [$62,$F2,$D5,$2F,$4F,$31                           ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(2837, [$62,$F2,$D5,$2F,$4F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2838, [$62,$F2,$D5,$2F,$4F,$72,$7F                       ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(2839, [$62,$F2,$D5,$2F,$4F,$B2,$00,$04,$00,$00           ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(2840, [$62,$F2,$D5,$2F,$4F,$72,$80                       ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(2841, [$62,$F2,$D5,$2F,$4F,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt14sd  xmm6{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(2842, [$62,$F2,$55,$2F,$4F,$F4                           ] , 'vrsqrt14ss  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(2843, [$62,$F2,$55,$AF,$4F,$F4                           ] , 'vrsqrt14ss  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(2844, [$62,$F2,$55,$2F,$4F,$31                           ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2845, [$62,$F2,$55,$2F,$4F,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2846, [$62,$F2,$55,$2F,$4F,$72,$7F                       ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2847, [$62,$F2,$55,$2F,$4F,$B2,$00,$02,$00,$00           ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2848, [$62,$F2,$55,$2F,$4F,$72,$80                       ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2849, [$62,$F2,$55,$2F,$4F,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt14ss  xmm6{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2850, [$62,$F2,$55,$2F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(2851, [$62,$F2,$55,$AF,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(2852, [$62,$F2,$55,$1F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2853, [$62,$F2,$55,$2F,$CD,$31                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(2854, [$62,$F2,$55,$2F,$CD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2855, [$62,$F2,$55,$2F,$CD,$72,$7F                       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(2856, [$62,$F2,$55,$2F,$CD,$B2,$00,$02,$00,$00           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(2857, [$62,$F2,$55,$2F,$CD,$72,$80                       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(2858, [$62,$F2,$55,$2F,$CD,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(2859, [$62,$F2,$D5,$2F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(2860, [$62,$F2,$D5,$AF,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(2861, [$62,$F2,$D5,$1F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(2862, [$62,$F2,$D5,$2F,$CD,$31                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(2863, [$62,$F2,$D5,$2F,$CD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2864, [$62,$F2,$D5,$2F,$CD,$72,$7F                       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(2865, [$62,$F2,$D5,$2F,$CD,$B2,$00,$04,$00,$00           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(2866, [$62,$F2,$D5,$2F,$CD,$72,$80                       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(2867, [$62,$F2,$D5,$2F,$CD,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(2868, [$62,$F1,$D7,$2F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4'                      );
  TestCase.testcase(2869, [$62,$F1,$D7,$AF,$51,$F4                           ] , 'vsqrtsd  xmm6{k7}{z},xmm5,xmm4'                   );
  TestCase.testcase(2870, [$62,$F1,$D7,$1F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4,{rn-sae}'             );
  TestCase.testcase(2871, [$62,$F1,$D7,$5F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4,{ru-sae}'             );
  TestCase.testcase(2872, [$62,$F1,$D7,$3F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4,{rd-sae}'             );
  TestCase.testcase(2873, [$62,$F1,$D7,$7F,$51,$F4                           ] , 'vsqrtsd  xmm6{k7},xmm5,xmm4,{rz-sae}'             );
  TestCase.testcase(2874, [$62,$F1,$D7,$2F,$51,$31                           ] , 'vsqrtsd  xmm6{k7},xmm5,qword [ecx]'               );
  TestCase.testcase(2875, [$62,$F1,$D7,$2F,$51,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vsqrtsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2876, [$62,$F1,$D7,$2F,$51,$72,$7F                       ] , 'vsqrtsd  xmm6{k7},xmm5,qword [edx+0x3f8]'         );
  TestCase.testcase(2877, [$62,$F1,$D7,$2F,$51,$B2,$00,$04,$00,$00           ] , 'vsqrtsd  xmm6{k7},xmm5,qword [edx+0x400]'         );
  TestCase.testcase(2878, [$62,$F1,$D7,$2F,$51,$72,$80                       ] , 'vsqrtsd  xmm6{k7},xmm5,qword [edx-0x400]'         );
  TestCase.testcase(2879, [$62,$F1,$D7,$2F,$51,$B2,$F8,$FB,$FF,$FF           ] , 'vsqrtsd  xmm6{k7},xmm5,qword [edx-0x408]'         );
  TestCase.testcase(2880, [$62,$F1,$56,$2F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4'                      );
  TestCase.testcase(2881, [$62,$F1,$56,$AF,$51,$F4                           ] , 'vsqrtss  xmm6{k7}{z},xmm5,xmm4'                   );
  TestCase.testcase(2882, [$62,$F1,$56,$1F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4,{rn-sae}'             );
  TestCase.testcase(2883, [$62,$F1,$56,$5F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4,{ru-sae}'             );
  TestCase.testcase(2884, [$62,$F1,$56,$3F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4,{rd-sae}'             );
  TestCase.testcase(2885, [$62,$F1,$56,$7F,$51,$F4                           ] , 'vsqrtss  xmm6{k7},xmm5,xmm4,{rz-sae}'             );
  TestCase.testcase(2886, [$62,$F1,$56,$2F,$51,$31                           ] , 'vsqrtss  xmm6{k7},xmm5,dword [ecx]'               );
  TestCase.testcase(2887, [$62,$F1,$56,$2F,$51,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vsqrtss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2888, [$62,$F1,$56,$2F,$51,$72,$7F                       ] , 'vsqrtss  xmm6{k7},xmm5,dword [edx+0x1fc]'         );
  TestCase.testcase(2889, [$62,$F1,$56,$2F,$51,$B2,$00,$02,$00,$00           ] , 'vsqrtss  xmm6{k7},xmm5,dword [edx+0x200]'         );
  TestCase.testcase(2890, [$62,$F1,$56,$2F,$51,$72,$80                       ] , 'vsqrtss  xmm6{k7},xmm5,dword [edx-0x200]'         );
  TestCase.testcase(2891, [$62,$F1,$56,$2F,$51,$B2,$FC,$FD,$FF,$FF           ] , 'vsqrtss  xmm6{k7},xmm5,dword [edx-0x204]'         );
  TestCase.testcase(2892, [$62,$F1,$D7,$2F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2893, [$62,$F1,$D7,$AF,$5C,$F4                           ] , 'vsubsd  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2894, [$62,$F1,$D7,$1F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(2895, [$62,$F1,$D7,$5F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(2896, [$62,$F1,$D7,$3F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(2897, [$62,$F1,$D7,$7F,$5C,$F4                           ] , 'vsubsd  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(2898, [$62,$F1,$D7,$2F,$5C,$31                           ] , 'vsubsd  xmm6{k7},xmm5,qword [ecx]'                );
  TestCase.testcase(2899, [$62,$F1,$D7,$2F,$5C,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vsubsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2900, [$62,$F1,$D7,$2F,$5C,$72,$7F                       ] , 'vsubsd  xmm6{k7},xmm5,qword [edx+0x3f8]'          );
  TestCase.testcase(2901, [$62,$F1,$D7,$2F,$5C,$B2,$00,$04,$00,$00           ] , 'vsubsd  xmm6{k7},xmm5,qword [edx+0x400]'          );
  TestCase.testcase(2902, [$62,$F1,$D7,$2F,$5C,$72,$80                       ] , 'vsubsd  xmm6{k7},xmm5,qword [edx-0x400]'          );
  TestCase.testcase(2903, [$62,$F1,$D7,$2F,$5C,$B2,$F8,$FB,$FF,$FF           ] , 'vsubsd  xmm6{k7},xmm5,qword [edx-0x408]'          );
  TestCase.testcase(2904, [$62,$F1,$56,$2F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4'                       );
  TestCase.testcase(2905, [$62,$F1,$56,$AF,$5C,$F4                           ] , 'vsubss  xmm6{k7}{z},xmm5,xmm4'                    );
  TestCase.testcase(2906, [$62,$F1,$56,$1F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4,{rn-sae}'              );
  TestCase.testcase(2907, [$62,$F1,$56,$5F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4,{ru-sae}'              );
  TestCase.testcase(2908, [$62,$F1,$56,$3F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4,{rd-sae}'              );
  TestCase.testcase(2909, [$62,$F1,$56,$7F,$5C,$F4                           ] , 'vsubss  xmm6{k7},xmm5,xmm4,{rz-sae}'              );
  TestCase.testcase(2910, [$62,$F1,$56,$2F,$5C,$31                           ] , 'vsubss  xmm6{k7},xmm5,dword [ecx]'                );
  TestCase.testcase(2911, [$62,$F1,$56,$2F,$5C,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vsubss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2912, [$62,$F1,$56,$2F,$5C,$72,$7F                       ] , 'vsubss  xmm6{k7},xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2913, [$62,$F1,$56,$2F,$5C,$B2,$00,$02,$00,$00           ] , 'vsubss  xmm6{k7},xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2914, [$62,$F1,$56,$2F,$5C,$72,$80                       ] , 'vsubss  xmm6{k7},xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2915, [$62,$F1,$56,$2F,$5C,$B2,$FC,$FD,$FF,$FF           ] , 'vsubss  xmm6{k7},xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2916, [$62,$F1,$FD,$18,$2E,$F5                           ] , 'vucomisd  xmm6,xmm5,{sae}'                        );
  TestCase.testcase(2917, [$62,$F1,$7C,$18,$2E,$F5                           ] , 'vucomiss  xmm6,xmm5,{sae}'                        );
  TestCase.testcase(2918, [$62,$F1,$7F,$28,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6'                             );
  TestCase.testcase(2919, [$62,$F1,$7F,$18,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6,{rn-sae}'                    );
  TestCase.testcase(2920, [$62,$F1,$7F,$58,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6,{ru-sae}'                    );
  TestCase.testcase(2921, [$62,$F1,$7F,$38,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6,{rd-sae}'                    );
  TestCase.testcase(2922, [$62,$F1,$7F,$78,$79,$C6                           ] , 'vcvtsd2usi  eax,xmm6,{rz-sae}'                    );
  TestCase.testcase(2923, [$62,$F1,$7F,$28,$79,$01                           ] , 'vcvtsd2usi  eax,qword [ecx]'                      );
  TestCase.testcase(2924, [$62,$F1,$7F,$28,$79,$84,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtsd2usi  eax,qword [esp+esi*8-0x1e240]'        );
  TestCase.testcase(2925, [$62,$F1,$7F,$28,$79,$42,$7F                       ] , 'vcvtsd2usi  eax,qword [edx+0x3f8]'                );
  TestCase.testcase(2926, [$62,$F1,$7F,$28,$79,$82,$00,$04,$00,$00           ] , 'vcvtsd2usi  eax,qword [edx+0x400]'                );
  TestCase.testcase(2927, [$62,$F1,$7F,$28,$79,$42,$80                       ] , 'vcvtsd2usi  eax,qword [edx-0x400]'                );
  TestCase.testcase(2928, [$62,$F1,$7F,$28,$79,$82,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  eax,qword [edx-0x408]'                );
  TestCase.testcase(2929, [$62,$F1,$7F,$28,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6'                             );
  TestCase.testcase(2930, [$62,$F1,$7F,$18,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6,{rn-sae}'                    );
  TestCase.testcase(2931, [$62,$F1,$7F,$58,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6,{ru-sae}'                    );
  TestCase.testcase(2932, [$62,$F1,$7F,$38,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6,{rd-sae}'                    );
  TestCase.testcase(2933, [$62,$F1,$7F,$78,$79,$EE                           ] , 'vcvtsd2usi  ebp,xmm6,{rz-sae}'                    );
  TestCase.testcase(2934, [$62,$F1,$7F,$28,$79,$29                           ] , 'vcvtsd2usi  ebp,qword [ecx]'                      );
  TestCase.testcase(2935, [$62,$F1,$7F,$28,$79,$AC,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtsd2usi  ebp,qword [esp+esi*8-0x1e240]'        );
  TestCase.testcase(2936, [$62,$F1,$7F,$28,$79,$6A,$7F                       ] , 'vcvtsd2usi  ebp,qword [edx+0x3f8]'                );
  TestCase.testcase(2937, [$62,$F1,$7F,$28,$79,$AA,$00,$04,$00,$00           ] , 'vcvtsd2usi  ebp,qword [edx+0x400]'                );
  TestCase.testcase(2938, [$62,$F1,$7F,$28,$79,$6A,$80                       ] , 'vcvtsd2usi  ebp,qword [edx-0x400]'                );
  TestCase.testcase(2939, [$62,$F1,$7F,$28,$79,$AA,$F8,$FB,$FF,$FF           ] , 'vcvtsd2usi  ebp,qword [edx-0x408]'                );
  TestCase.testcase(2940, [$62,$F1,$7E,$28,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6'                             );
  TestCase.testcase(2941, [$62,$F1,$7E,$18,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6,{rn-sae}'                    );
  TestCase.testcase(2942, [$62,$F1,$7E,$58,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6,{ru-sae}'                    );
  TestCase.testcase(2943, [$62,$F1,$7E,$38,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6,{rd-sae}'                    );
  TestCase.testcase(2944, [$62,$F1,$7E,$78,$79,$C6                           ] , 'vcvtss2usi  eax,xmm6,{rz-sae}'                    );
  TestCase.testcase(2945, [$62,$F1,$7E,$28,$79,$01                           ] , 'vcvtss2usi  eax,dword [ecx]'                      );
  TestCase.testcase(2946, [$62,$F1,$7E,$28,$79,$84,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtss2usi  eax,dword [esp+esi*8-0x1e240]'        );
  TestCase.testcase(2947, [$62,$F1,$7E,$28,$79,$42,$7F                       ] , 'vcvtss2usi  eax,dword [edx+0x1fc]'                );
  TestCase.testcase(2948, [$62,$F1,$7E,$28,$79,$82,$00,$02,$00,$00           ] , 'vcvtss2usi  eax,dword [edx+0x200]'                );
  TestCase.testcase(2949, [$62,$F1,$7E,$28,$79,$42,$80                       ] , 'vcvtss2usi  eax,dword [edx-0x200]'                );
  TestCase.testcase(2950, [$62,$F1,$7E,$28,$79,$82,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  eax,dword [edx-0x204]'                );
  TestCase.testcase(2951, [$62,$F1,$7E,$28,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6'                             );
  TestCase.testcase(2952, [$62,$F1,$7E,$18,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6,{rn-sae}'                    );
  TestCase.testcase(2953, [$62,$F1,$7E,$58,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6,{ru-sae}'                    );
  TestCase.testcase(2954, [$62,$F1,$7E,$38,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6,{rd-sae}'                    );
  TestCase.testcase(2955, [$62,$F1,$7E,$78,$79,$EE                           ] , 'vcvtss2usi  ebp,xmm6,{rz-sae}'                    );
  TestCase.testcase(2956, [$62,$F1,$7E,$28,$79,$29                           ] , 'vcvtss2usi  ebp,dword [ecx]'                      );
  TestCase.testcase(2957, [$62,$F1,$7E,$28,$79,$AC,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtss2usi  ebp,dword [esp+esi*8-0x1e240]'        );
  TestCase.testcase(2958, [$62,$F1,$7E,$28,$79,$6A,$7F                       ] , 'vcvtss2usi  ebp,dword [edx+0x1fc]'                );
  TestCase.testcase(2959, [$62,$F1,$7E,$28,$79,$AA,$00,$02,$00,$00           ] , 'vcvtss2usi  ebp,dword [edx+0x200]'                );
  TestCase.testcase(2960, [$62,$F1,$7E,$28,$79,$6A,$80                       ] , 'vcvtss2usi  ebp,dword [edx-0x200]'                );
  TestCase.testcase(2961, [$62,$F1,$7E,$28,$79,$AA,$FC,$FD,$FF,$FF           ] , 'vcvtss2usi  ebp,dword [edx-0x204]'                );
  TestCase.testcase(2962, [$62,$F1,$57,$28,$7B,$F0                           ] , 'vcvtusi2sd  xmm6,xmm5,eax'                        );
  TestCase.testcase(2963, [$62,$F1,$57,$28,$7B,$F5                           ] , 'vcvtusi2sd  xmm6,xmm5,ebp'                        );
  TestCase.testcase(2964, [$62,$F1,$57,$28,$7B,$31                           ] , 'vcvtusi2sd  xmm6,xmm5,dword [ecx]'                );
  TestCase.testcase(2965, [$62,$F1,$57,$28,$7B,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtusi2sd  xmm6,xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2966, [$62,$F1,$57,$28,$7B,$72,$7F                       ] , 'vcvtusi2sd  xmm6,xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2967, [$62,$F1,$57,$28,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2sd  xmm6,xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2968, [$62,$F1,$57,$28,$7B,$72,$80                       ] , 'vcvtusi2sd  xmm6,xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2969, [$62,$F1,$57,$28,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2sd  xmm6,xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2970, [$62,$F1,$56,$28,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,eax'                        );
  TestCase.testcase(2971, [$62,$F1,$56,$18,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,{rn-sae},eax'               );
  TestCase.testcase(2972, [$62,$F1,$56,$58,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,{ru-sae},eax'               );
  TestCase.testcase(2973, [$62,$F1,$56,$38,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,{rd-sae},eax'               );
  TestCase.testcase(2974, [$62,$F1,$56,$78,$7B,$F0                           ] , 'vcvtusi2ss  xmm6,xmm5,{rz-sae},eax'               );
  TestCase.testcase(2975, [$62,$F1,$56,$28,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,ebp'                        );
  TestCase.testcase(2976, [$62,$F1,$56,$18,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,{rn-sae},ebp'               );
  TestCase.testcase(2977, [$62,$F1,$56,$58,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,{ru-sae},ebp'               );
  TestCase.testcase(2978, [$62,$F1,$56,$38,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,{rd-sae},ebp'               );
  TestCase.testcase(2979, [$62,$F1,$56,$78,$7B,$F5                           ] , 'vcvtusi2ss  xmm6,xmm5,{rz-sae},ebp'               );
  TestCase.testcase(2980, [$62,$F1,$56,$28,$7B,$31                           ] , 'vcvtusi2ss  xmm6,xmm5,dword [ecx]'                );
  TestCase.testcase(2981, [$62,$F1,$56,$28,$7B,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vcvtusi2ss  xmm6,xmm5,dword [esp+esi*8-0x1e240]'  );
  TestCase.testcase(2982, [$62,$F1,$56,$28,$7B,$72,$7F                       ] , 'vcvtusi2ss  xmm6,xmm5,dword [edx+0x1fc]'          );
  TestCase.testcase(2983, [$62,$F1,$56,$28,$7B,$B2,$00,$02,$00,$00           ] , 'vcvtusi2ss  xmm6,xmm5,dword [edx+0x200]'          );
  TestCase.testcase(2984, [$62,$F1,$56,$28,$7B,$72,$80                       ] , 'vcvtusi2ss  xmm6,xmm5,dword [edx-0x200]'          );
  TestCase.testcase(2985, [$62,$F1,$56,$28,$7B,$B2,$FC,$FD,$FF,$FF           ] , 'vcvtusi2ss  xmm6,xmm5,dword [edx-0x204]'          );
  TestCase.testcase(2986, [$62,$F2,$D5,$2F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(2987, [$62,$F2,$D5,$AF,$2D,$F4                           ] , 'vscalefsd  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(2988, [$62,$F2,$D5,$1F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4,{rn-sae}'           );
  TestCase.testcase(2989, [$62,$F2,$D5,$5F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4,{ru-sae}'           );
  TestCase.testcase(2990, [$62,$F2,$D5,$3F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4,{rd-sae}'           );
  TestCase.testcase(2991, [$62,$F2,$D5,$7F,$2D,$F4                           ] , 'vscalefsd  xmm6{k7},xmm5,xmm4,{rz-sae}'           );
  TestCase.testcase(2992, [$62,$F2,$D5,$2F,$2D,$31                           ] , 'vscalefsd  xmm6{k7},xmm5,qword [ecx]'             );
  TestCase.testcase(2993, [$62,$F2,$D5,$2F,$2D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vscalefsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(2994, [$62,$F2,$D5,$2F,$2D,$72,$7F                       ] , 'vscalefsd  xmm6{k7},xmm5,qword [edx+0x3f8]'       );
  TestCase.testcase(2995, [$62,$F2,$D5,$2F,$2D,$B2,$00,$04,$00,$00           ] , 'vscalefsd  xmm6{k7},xmm5,qword [edx+0x400]'       );
  TestCase.testcase(2996, [$62,$F2,$D5,$2F,$2D,$72,$80                       ] , 'vscalefsd  xmm6{k7},xmm5,qword [edx-0x400]'       );
  TestCase.testcase(2997, [$62,$F2,$D5,$2F,$2D,$B2,$F8,$FB,$FF,$FF           ] , 'vscalefsd  xmm6{k7},xmm5,qword [edx-0x408]'       );
  TestCase.testcase(2998, [$62,$F2,$55,$2F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4'                    );
  TestCase.testcase(2999, [$62,$F2,$55,$AF,$2D,$F4                           ] , 'vscalefss  xmm6{k7}{z},xmm5,xmm4'                 );
  TestCase.testcase(3000, [$62,$F2,$55,$1F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4,{rn-sae}'           );
  TestCase.testcase(3001, [$62,$F2,$55,$5F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4,{ru-sae}'           );
  TestCase.testcase(3002, [$62,$F2,$55,$3F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4,{rd-sae}'           );
  TestCase.testcase(3003, [$62,$F2,$55,$7F,$2D,$F4                           ] , 'vscalefss  xmm6{k7},xmm5,xmm4,{rz-sae}'           );
  TestCase.testcase(3004, [$62,$F2,$55,$2F,$2D,$31                           ] , 'vscalefss  xmm6{k7},xmm5,dword [ecx]'             );
  TestCase.testcase(3005, [$62,$F2,$55,$2F,$2D,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vscalefss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(3006, [$62,$F2,$55,$2F,$2D,$72,$7F                       ] , 'vscalefss  xmm6{k7},xmm5,dword [edx+0x1fc]'       );
  TestCase.testcase(3007, [$62,$F2,$55,$2F,$2D,$B2,$00,$02,$00,$00           ] , 'vscalefss  xmm6{k7},xmm5,dword [edx+0x200]'       );
  TestCase.testcase(3008, [$62,$F2,$55,$2F,$2D,$72,$80                       ] , 'vscalefss  xmm6{k7},xmm5,dword [edx-0x200]'       );
  TestCase.testcase(3009, [$62,$F2,$55,$2F,$2D,$B2,$FC,$FD,$FF,$FF           ] , 'vscalefss  xmm6{k7},xmm5,dword [edx-0x204]'       );
  TestCase.testcase(3010, [$62,$F3,$55,$2F,$55,$F4,$AB                       ] , 'vfixupimmss  xmm6{k7},xmm5,xmm4,0xab'             );
  TestCase.testcase(3011, [$62,$F3,$55,$AF,$55,$F4,$AB                       ] , 'vfixupimmss  xmm6{k7}{z},xmm5,xmm4,0xab'          );
  TestCase.testcase(3012, [$62,$F3,$55,$1F,$55,$F4,$AB                       ] , 'vfixupimmss  xmm6{k7},xmm5,xmm4,{sae},0xab'       );
  TestCase.testcase(3013, [$62,$F3,$55,$2F,$55,$F4,$7B                       ] , 'vfixupimmss  xmm6{k7},xmm5,xmm4,0x7b'             );
  TestCase.testcase(3014, [$62,$F3,$55,$1F,$55,$F4,$7B                       ] , 'vfixupimmss  xmm6{k7},xmm5,xmm4,{sae},0x7b'       );
  TestCase.testcase(3015, [$62,$F3,$55,$2F,$55,$31,$7B                       ] , 'vfixupimmss  xmm6{k7},xmm5,dword [ecx],0x7b'      );
  TestCase.testcase(3016, [$62,$F3,$55,$2F,$55,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vfixupimmss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(3017, [$62,$F3,$55,$2F,$55,$72,$7F,$7B                   ] , 'vfixupimmss  xmm6{k7},xmm5,dword [edx+0x1fc],0x7b' );
  TestCase.testcase(3018, [$62,$F3,$55,$2F,$55,$B2,$00,$02,$00,$00,$7B       ] , 'vfixupimmss  xmm6{k7},xmm5,dword [edx+0x200],0x7b' );
  TestCase.testcase(3019, [$62,$F3,$55,$2F,$55,$72,$80,$7B                   ] , 'vfixupimmss  xmm6{k7},xmm5,dword [edx-0x200],0x7b' );
  TestCase.testcase(3020, [$62,$F3,$55,$2F,$55,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vfixupimmss  xmm6{k7},xmm5,dword [edx-0x204],0x7b' );
  TestCase.testcase(3021, [$62,$F3,$D5,$2F,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm6{k7},xmm5,xmm4,0xab'             );
  TestCase.testcase(3022, [$62,$F3,$D5,$AF,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm6{k7}{z},xmm5,xmm4,0xab'          );
  TestCase.testcase(3023, [$62,$F3,$D5,$1F,$55,$F4,$AB                       ] , 'vfixupimmsd  xmm6{k7},xmm5,xmm4,{sae},0xab'       );
  TestCase.testcase(3024, [$62,$F3,$D5,$2F,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm6{k7},xmm5,xmm4,0x7b'             );
  TestCase.testcase(3025, [$62,$F3,$D5,$1F,$55,$F4,$7B                       ] , 'vfixupimmsd  xmm6{k7},xmm5,xmm4,{sae},0x7b'       );
  TestCase.testcase(3026, [$62,$F3,$D5,$2F,$55,$31,$7B                       ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [ecx],0x7b'      );
  TestCase.testcase(3027, [$62,$F3,$D5,$2F,$55,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(3028, [$62,$F3,$D5,$2F,$55,$72,$7F,$7B                   ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [edx+0x3f8],0x7b' );
  TestCase.testcase(3029, [$62,$F3,$D5,$2F,$55,$B2,$00,$04,$00,$00,$7B       ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [edx+0x400],0x7b' );
  TestCase.testcase(3030, [$62,$F3,$D5,$2F,$55,$72,$80,$7B                   ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [edx-0x400],0x7b' );
  TestCase.testcase(3031, [$62,$F3,$D5,$2F,$55,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vfixupimmsd  xmm6{k7},xmm5,qword [edx-0x408],0x7b' );
  TestCase.testcase(3032, [$62,$F3,$D5,$2F,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm6{k7},xmm5,xmm4,0xab'             );
  TestCase.testcase(3033, [$62,$F3,$D5,$AF,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm6{k7}{z},xmm5,xmm4,0xab'          );
  TestCase.testcase(3034, [$62,$F3,$D5,$1F,$0B,$F4,$AB                       ] , 'vrndscalesd  xmm6{k7},xmm5,xmm4,{sae},0xab'       );
  TestCase.testcase(3035, [$62,$F3,$D5,$2F,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm6{k7},xmm5,xmm4,0x7b'             );
  TestCase.testcase(3036, [$62,$F3,$D5,$1F,$0B,$F4,$7B                       ] , 'vrndscalesd  xmm6{k7},xmm5,xmm4,{sae},0x7b'       );
  TestCase.testcase(3037, [$62,$F3,$D5,$2F,$0B,$31,$7B                       ] , 'vrndscalesd  xmm6{k7},xmm5,qword [ecx],0x7b'      );
  TestCase.testcase(3038, [$62,$F3,$D5,$2F,$0B,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vrndscalesd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(3039, [$62,$F3,$D5,$2F,$0B,$72,$7F,$7B                   ] , 'vrndscalesd  xmm6{k7},xmm5,qword [edx+0x3f8],0x7b' );
  TestCase.testcase(3040, [$62,$F3,$D5,$2F,$0B,$B2,$00,$04,$00,$00,$7B       ] , 'vrndscalesd  xmm6{k7},xmm5,qword [edx+0x400],0x7b' );
  TestCase.testcase(3041, [$62,$F3,$D5,$2F,$0B,$72,$80,$7B                   ] , 'vrndscalesd  xmm6{k7},xmm5,qword [edx-0x400],0x7b' );
  TestCase.testcase(3042, [$62,$F3,$D5,$2F,$0B,$B2,$F8,$FB,$FF,$FF,$7B       ] , 'vrndscalesd  xmm6{k7},xmm5,qword [edx-0x408],0x7b' );
  TestCase.testcase(3043, [$62,$F3,$55,$2F,$0A,$F4,$AB                       ] , 'vrndscaless  xmm6{k7},xmm5,xmm4,0xab'             );
  TestCase.testcase(3044, [$62,$F3,$55,$AF,$0A,$F4,$AB                       ] , 'vrndscaless  xmm6{k7}{z},xmm5,xmm4,0xab'          );
  TestCase.testcase(3045, [$62,$F3,$55,$1F,$0A,$F4,$AB                       ] , 'vrndscaless  xmm6{k7},xmm5,xmm4,{sae},0xab'       );
  TestCase.testcase(3046, [$62,$F3,$55,$2F,$0A,$F4,$7B                       ] , 'vrndscaless  xmm6{k7},xmm5,xmm4,0x7b'             );
  TestCase.testcase(3047, [$62,$F3,$55,$1F,$0A,$F4,$7B                       ] , 'vrndscaless  xmm6{k7},xmm5,xmm4,{sae},0x7b'       );
  TestCase.testcase(3048, [$62,$F3,$55,$2F,$0A,$31,$7B                       ] , 'vrndscaless  xmm6{k7},xmm5,dword [ecx],0x7b'      );
  TestCase.testcase(3049, [$62,$F3,$55,$2F,$0A,$B4,$F4,$C0,$1D,$FE,$FF,$7B   ] , 'vrndscaless  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240],0x7b' );
  TestCase.testcase(3050, [$62,$F3,$55,$2F,$0A,$72,$7F,$7B                   ] , 'vrndscaless  xmm6{k7},xmm5,dword [edx+0x1fc],0x7b' );
  TestCase.testcase(3051, [$62,$F3,$55,$2F,$0A,$B2,$00,$02,$00,$00,$7B       ] , 'vrndscaless  xmm6{k7},xmm5,dword [edx+0x200],0x7b' );
  TestCase.testcase(3052, [$62,$F3,$55,$2F,$0A,$72,$80,$7B                   ] , 'vrndscaless  xmm6{k7},xmm5,dword [edx-0x200],0x7b' );
  TestCase.testcase(3053, [$62,$F3,$55,$2F,$0A,$B2,$FC,$FD,$FF,$FF,$7B       ] , 'vrndscaless  xmm6{k7},xmm5,dword [edx-0x204],0x7b' );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x32.evex_lig256.log');
end;

end.