unit x32.avx512er;

// This unit was generated by d2p.pl script.
// Source : gas/avx512er-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x32.avx512er');
  TestCase.Start();	
  TestCase.Arch := CPUX32;

  TestCase.testcase(0, [$62,$F2,$7D,$48,$C8,$F5                           ] , 'vexp2ps  zmm6,zmm5'                               );
  TestCase.testcase(1, [$62,$F2,$7D,$18,$C8,$F5                           ] , 'vexp2ps  zmm6,zmm5,{sae}'                         );
  TestCase.testcase(2, [$62,$F2,$7D,$48,$C8,$31                           ] , 'vexp2ps  zmm6,zword [ecx]'                        );
  TestCase.testcase(3, [$62,$F2,$7D,$48,$C8,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vexp2ps  zmm6,zword [esp+esi*8-0x1e240]'          );
  TestCase.testcase(4, [$62,$F2,$7D,$58,$C8,$30                           ] , 'vexp2ps  zmm6,dword [eax]{1to16}'                 );
  TestCase.testcase(5, [$62,$F2,$7D,$48,$C8,$72,$7F                       ] , 'vexp2ps  zmm6,zword [edx+0x1fc0]'                 );
  TestCase.testcase(6, [$62,$F2,$7D,$48,$C8,$B2,$00,$20,$00,$00           ] , 'vexp2ps  zmm6,zword [edx+0x2000]'                 );
  TestCase.testcase(7, [$62,$F2,$7D,$48,$C8,$72,$80                       ] , 'vexp2ps  zmm6,zword [edx-0x2000]'                 );
  TestCase.testcase(8, [$62,$F2,$7D,$48,$C8,$B2,$C0,$DF,$FF,$FF           ] , 'vexp2ps  zmm6,zword [edx-0x2040]'                 );
  TestCase.testcase(9, [$62,$F2,$7D,$58,$C8,$72,$7F                       ] , 'vexp2ps  zmm6,dword [edx+0x1fc]{1to16}'           );
  TestCase.testcase(10, [$62,$F2,$7D,$58,$C8,$B2,$00,$02,$00,$00           ] , 'vexp2ps  zmm6,dword [edx+0x200]{1to16}'           );
  TestCase.testcase(11, [$62,$F2,$7D,$58,$C8,$72,$80                       ] , 'vexp2ps  zmm6,dword [edx-0x200]{1to16}'           );
  TestCase.testcase(12, [$62,$F2,$7D,$58,$C8,$B2,$FC,$FD,$FF,$FF           ] , 'vexp2ps  zmm6,dword [edx-0x204]{1to16}'           );
  TestCase.testcase(13, [$62,$F2,$FD,$48,$C8,$F5                           ] , 'vexp2pd  zmm6,zmm5'                               );
  TestCase.testcase(14, [$62,$F2,$FD,$18,$C8,$F5                           ] , 'vexp2pd  zmm6,zmm5,{sae}'                         );
  TestCase.testcase(15, [$62,$F2,$FD,$48,$C8,$31                           ] , 'vexp2pd  zmm6,zword [ecx]'                        );
  TestCase.testcase(16, [$62,$F2,$FD,$48,$C8,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vexp2pd  zmm6,zword [esp+esi*8-0x1e240]'          );
  TestCase.testcase(17, [$62,$F2,$FD,$58,$C8,$30                           ] , 'vexp2pd  zmm6,qword [eax]{1to8}'                  );
  TestCase.testcase(18, [$62,$F2,$FD,$48,$C8,$72,$7F                       ] , 'vexp2pd  zmm6,zword [edx+0x1fc0]'                 );
  TestCase.testcase(19, [$62,$F2,$FD,$48,$C8,$B2,$00,$20,$00,$00           ] , 'vexp2pd  zmm6,zword [edx+0x2000]'                 );
  TestCase.testcase(20, [$62,$F2,$FD,$48,$C8,$72,$80                       ] , 'vexp2pd  zmm6,zword [edx-0x2000]'                 );
  TestCase.testcase(21, [$62,$F2,$FD,$48,$C8,$B2,$C0,$DF,$FF,$FF           ] , 'vexp2pd  zmm6,zword [edx-0x2040]'                 );
  TestCase.testcase(22, [$62,$F2,$FD,$58,$C8,$72,$7F                       ] , 'vexp2pd  zmm6,qword [edx+0x3f8]{1to8}'            );
  TestCase.testcase(23, [$62,$F2,$FD,$58,$C8,$B2,$00,$04,$00,$00           ] , 'vexp2pd  zmm6,qword [edx+0x400]{1to8}'            );
  TestCase.testcase(24, [$62,$F2,$FD,$58,$C8,$72,$80                       ] , 'vexp2pd  zmm6,qword [edx-0x400]{1to8}'            );
  TestCase.testcase(25, [$62,$F2,$FD,$58,$C8,$B2,$F8,$FB,$FF,$FF           ] , 'vexp2pd  zmm6,qword [edx-0x408]{1to8}'            );
  TestCase.testcase(26, [$62,$F2,$7D,$48,$CA,$F5                           ] , 'vrcp28ps  zmm6,zmm5'                              );
  TestCase.testcase(27, [$62,$F2,$7D,$4F,$CA,$F5                           ] , 'vrcp28ps  zmm6{k7},zmm5'                          );
  TestCase.testcase(28, [$62,$F2,$7D,$CF,$CA,$F5                           ] , 'vrcp28ps  zmm6{k7}{z},zmm5'                       );
  TestCase.testcase(29, [$62,$F2,$7D,$18,$CA,$F5                           ] , 'vrcp28ps  zmm6,zmm5,{sae}'                        );
  TestCase.testcase(30, [$62,$F2,$7D,$48,$CA,$31                           ] , 'vrcp28ps  zmm6,zword [ecx]'                       );
  TestCase.testcase(31, [$62,$F2,$7D,$48,$CA,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28ps  zmm6,zword [esp+esi*8-0x1e240]'         );
  TestCase.testcase(32, [$62,$F2,$7D,$58,$CA,$30                           ] , 'vrcp28ps  zmm6,dword [eax]{1to16}'                );
  TestCase.testcase(33, [$62,$F2,$7D,$48,$CA,$72,$7F                       ] , 'vrcp28ps  zmm6,zword [edx+0x1fc0]'                );
  TestCase.testcase(34, [$62,$F2,$7D,$48,$CA,$B2,$00,$20,$00,$00           ] , 'vrcp28ps  zmm6,zword [edx+0x2000]'                );
  TestCase.testcase(35, [$62,$F2,$7D,$48,$CA,$72,$80                       ] , 'vrcp28ps  zmm6,zword [edx-0x2000]'                );
  TestCase.testcase(36, [$62,$F2,$7D,$48,$CA,$B2,$C0,$DF,$FF,$FF           ] , 'vrcp28ps  zmm6,zword [edx-0x2040]'                );
  TestCase.testcase(37, [$62,$F2,$7D,$58,$CA,$72,$7F                       ] , 'vrcp28ps  zmm6,dword [edx+0x1fc]{1to16}'          );
  TestCase.testcase(38, [$62,$F2,$7D,$58,$CA,$B2,$00,$02,$00,$00           ] , 'vrcp28ps  zmm6,dword [edx+0x200]{1to16}'          );
  TestCase.testcase(39, [$62,$F2,$7D,$58,$CA,$72,$80                       ] , 'vrcp28ps  zmm6,dword [edx-0x200]{1to16}'          );
  TestCase.testcase(40, [$62,$F2,$7D,$58,$CA,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp28ps  zmm6,dword [edx-0x204]{1to16}'          );
  TestCase.testcase(41, [$62,$F2,$FD,$48,$CA,$F5                           ] , 'vrcp28pd  zmm6,zmm5'                              );
  TestCase.testcase(42, [$62,$F2,$FD,$4F,$CA,$F5                           ] , 'vrcp28pd  zmm6{k7},zmm5'                          );
  TestCase.testcase(43, [$62,$F2,$FD,$CF,$CA,$F5                           ] , 'vrcp28pd  zmm6{k7}{z},zmm5'                       );
  TestCase.testcase(44, [$62,$F2,$FD,$18,$CA,$F5                           ] , 'vrcp28pd  zmm6,zmm5,{sae}'                        );
  TestCase.testcase(45, [$62,$F2,$FD,$48,$CA,$31                           ] , 'vrcp28pd  zmm6,zword [ecx]'                       );
  TestCase.testcase(46, [$62,$F2,$FD,$48,$CA,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28pd  zmm6,zword [esp+esi*8-0x1e240]'         );
  TestCase.testcase(47, [$62,$F2,$FD,$58,$CA,$30                           ] , 'vrcp28pd  zmm6,qword [eax]{1to8}'                 );
  TestCase.testcase(48, [$62,$F2,$FD,$48,$CA,$72,$7F                       ] , 'vrcp28pd  zmm6,zword [edx+0x1fc0]'                );
  TestCase.testcase(49, [$62,$F2,$FD,$48,$CA,$B2,$00,$20,$00,$00           ] , 'vrcp28pd  zmm6,zword [edx+0x2000]'                );
  TestCase.testcase(50, [$62,$F2,$FD,$48,$CA,$72,$80                       ] , 'vrcp28pd  zmm6,zword [edx-0x2000]'                );
  TestCase.testcase(51, [$62,$F2,$FD,$48,$CA,$B2,$C0,$DF,$FF,$FF           ] , 'vrcp28pd  zmm6,zword [edx-0x2040]'                );
  TestCase.testcase(52, [$62,$F2,$FD,$58,$CA,$72,$7F                       ] , 'vrcp28pd  zmm6,qword [edx+0x3f8]{1to8}'           );
  TestCase.testcase(53, [$62,$F2,$FD,$58,$CA,$B2,$00,$04,$00,$00           ] , 'vrcp28pd  zmm6,qword [edx+0x400]{1to8}'           );
  TestCase.testcase(54, [$62,$F2,$FD,$58,$CA,$72,$80                       ] , 'vrcp28pd  zmm6,qword [edx-0x400]{1to8}'           );
  TestCase.testcase(55, [$62,$F2,$FD,$58,$CA,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp28pd  zmm6,qword [edx-0x408]{1to8}'           );
  TestCase.testcase(56, [$62,$F2,$55,$0F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(57, [$62,$F2,$55,$8F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(58, [$62,$F2,$55,$1F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(59, [$62,$F2,$55,$0F,$CB,$31                           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [ecx]'              );
  TestCase.testcase(60, [$62,$F2,$55,$0F,$CB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(61, [$62,$F2,$55,$0F,$CB,$72,$7F                       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx+0x1fc]'        );
  TestCase.testcase(62, [$62,$F2,$55,$0F,$CB,$B2,$00,$02,$00,$00           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx+0x200]'        );
  TestCase.testcase(63, [$62,$F2,$55,$0F,$CB,$72,$80                       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx-0x200]'        );
  TestCase.testcase(64, [$62,$F2,$55,$0F,$CB,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx-0x204]'        );
  TestCase.testcase(65, [$62,$F2,$D5,$0F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(66, [$62,$F2,$D5,$8F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(67, [$62,$F2,$D5,$1F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(68, [$62,$F2,$D5,$0F,$CB,$31                           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [ecx]'              );
  TestCase.testcase(69, [$62,$F2,$D5,$0F,$CB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(70, [$62,$F2,$D5,$0F,$CB,$72,$7F                       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx+0x3f8]'        );
  TestCase.testcase(71, [$62,$F2,$D5,$0F,$CB,$B2,$00,$04,$00,$00           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx+0x400]'        );
  TestCase.testcase(72, [$62,$F2,$D5,$0F,$CB,$72,$80                       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx-0x400]'        );
  TestCase.testcase(73, [$62,$F2,$D5,$0F,$CB,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx-0x408]'        );
  TestCase.testcase(74, [$62,$F2,$7D,$48,$CC,$F5                           ] , 'vrsqrt28ps  zmm6,zmm5'                            );
  TestCase.testcase(75, [$62,$F2,$7D,$4F,$CC,$F5                           ] , 'vrsqrt28ps  zmm6{k7},zmm5'                        );
  TestCase.testcase(76, [$62,$F2,$7D,$CF,$CC,$F5                           ] , 'vrsqrt28ps  zmm6{k7}{z},zmm5'                     );
  TestCase.testcase(77, [$62,$F2,$7D,$18,$CC,$F5                           ] , 'vrsqrt28ps  zmm6,zmm5,{sae}'                      );
  TestCase.testcase(78, [$62,$F2,$7D,$48,$CC,$31                           ] , 'vrsqrt28ps  zmm6,zword [ecx]'                     );
  TestCase.testcase(79, [$62,$F2,$7D,$48,$CC,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28ps  zmm6,zword [esp+esi*8-0x1e240]'       );
  TestCase.testcase(80, [$62,$F2,$7D,$58,$CC,$30                           ] , 'vrsqrt28ps  zmm6,dword [eax]{1to16}'              );
  TestCase.testcase(81, [$62,$F2,$7D,$48,$CC,$72,$7F                       ] , 'vrsqrt28ps  zmm6,zword [edx+0x1fc0]'              );
  TestCase.testcase(82, [$62,$F2,$7D,$48,$CC,$B2,$00,$20,$00,$00           ] , 'vrsqrt28ps  zmm6,zword [edx+0x2000]'              );
  TestCase.testcase(83, [$62,$F2,$7D,$48,$CC,$72,$80                       ] , 'vrsqrt28ps  zmm6,zword [edx-0x2000]'              );
  TestCase.testcase(84, [$62,$F2,$7D,$48,$CC,$B2,$C0,$DF,$FF,$FF           ] , 'vrsqrt28ps  zmm6,zword [edx-0x2040]'              );
  TestCase.testcase(85, [$62,$F2,$7D,$58,$CC,$72,$7F                       ] , 'vrsqrt28ps  zmm6,dword [edx+0x1fc]{1to16}'        );
  TestCase.testcase(86, [$62,$F2,$7D,$58,$CC,$B2,$00,$02,$00,$00           ] , 'vrsqrt28ps  zmm6,dword [edx+0x200]{1to16}'        );
  TestCase.testcase(87, [$62,$F2,$7D,$58,$CC,$72,$80                       ] , 'vrsqrt28ps  zmm6,dword [edx-0x200]{1to16}'        );
  TestCase.testcase(88, [$62,$F2,$7D,$58,$CC,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt28ps  zmm6,dword [edx-0x204]{1to16}'        );
  TestCase.testcase(89, [$62,$F2,$FD,$48,$CC,$F5                           ] , 'vrsqrt28pd  zmm6,zmm5'                            );
  TestCase.testcase(90, [$62,$F2,$FD,$4F,$CC,$F5                           ] , 'vrsqrt28pd  zmm6{k7},zmm5'                        );
  TestCase.testcase(91, [$62,$F2,$FD,$CF,$CC,$F5                           ] , 'vrsqrt28pd  zmm6{k7}{z},zmm5'                     );
  TestCase.testcase(92, [$62,$F2,$FD,$18,$CC,$F5                           ] , 'vrsqrt28pd  zmm6,zmm5,{sae}'                      );
  TestCase.testcase(93, [$62,$F2,$FD,$48,$CC,$31                           ] , 'vrsqrt28pd  zmm6,zword [ecx]'                     );
  TestCase.testcase(94, [$62,$F2,$FD,$48,$CC,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28pd  zmm6,zword [esp+esi*8-0x1e240]'       );
  TestCase.testcase(95, [$62,$F2,$FD,$58,$CC,$30                           ] , 'vrsqrt28pd  zmm6,qword [eax]{1to8}'               );
  TestCase.testcase(96, [$62,$F2,$FD,$48,$CC,$72,$7F                       ] , 'vrsqrt28pd  zmm6,zword [edx+0x1fc0]'              );
  TestCase.testcase(97, [$62,$F2,$FD,$48,$CC,$B2,$00,$20,$00,$00           ] , 'vrsqrt28pd  zmm6,zword [edx+0x2000]'              );
  TestCase.testcase(98, [$62,$F2,$FD,$48,$CC,$72,$80                       ] , 'vrsqrt28pd  zmm6,zword [edx-0x2000]'              );
  TestCase.testcase(99, [$62,$F2,$FD,$48,$CC,$B2,$C0,$DF,$FF,$FF           ] , 'vrsqrt28pd  zmm6,zword [edx-0x2040]'              );
  TestCase.testcase(100, [$62,$F2,$FD,$58,$CC,$72,$7F                       ] , 'vrsqrt28pd  zmm6,qword [edx+0x3f8]{1to8}'         );
  TestCase.testcase(101, [$62,$F2,$FD,$58,$CC,$B2,$00,$04,$00,$00           ] , 'vrsqrt28pd  zmm6,qword [edx+0x400]{1to8}'         );
  TestCase.testcase(102, [$62,$F2,$FD,$58,$CC,$72,$80                       ] , 'vrsqrt28pd  zmm6,qword [edx-0x400]{1to8}'         );
  TestCase.testcase(103, [$62,$F2,$FD,$58,$CC,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt28pd  zmm6,qword [edx-0x408]{1to8}'         );
  TestCase.testcase(104, [$62,$F2,$55,$0F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(105, [$62,$F2,$55,$8F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(106, [$62,$F2,$55,$1F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(107, [$62,$F2,$55,$0F,$CD,$31                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(108, [$62,$F2,$55,$0F,$CD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(109, [$62,$F2,$55,$0F,$CD,$72,$7F                       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(110, [$62,$F2,$55,$0F,$CD,$B2,$00,$02,$00,$00           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(111, [$62,$F2,$55,$0F,$CD,$72,$80                       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(112, [$62,$F2,$55,$0F,$CD,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(113, [$62,$F2,$D5,$0F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(114, [$62,$F2,$D5,$8F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(115, [$62,$F2,$D5,$1F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(116, [$62,$F2,$D5,$0F,$CD,$31                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(117, [$62,$F2,$D5,$0F,$CD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(118, [$62,$F2,$D5,$0F,$CD,$72,$7F                       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(119, [$62,$F2,$D5,$0F,$CD,$B2,$00,$04,$00,$00           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(120, [$62,$F2,$D5,$0F,$CD,$72,$80                       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(121, [$62,$F2,$D5,$0F,$CD,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx-0x408]'      );
  TestCase.testcase(122, [$62,$F2,$7D,$48,$C8,$F5                           ] , 'vexp2ps  zmm6,zmm5'                               );
  TestCase.testcase(123, [$62,$F2,$7D,$18,$C8,$F5                           ] , 'vexp2ps  zmm6,zmm5,{sae}'                         );
  TestCase.testcase(124, [$62,$F2,$7D,$48,$C8,$31                           ] , 'vexp2ps  zmm6,zword [ecx]'                        );
  TestCase.testcase(125, [$62,$F2,$7D,$48,$C8,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vexp2ps  zmm6,zword [esp+esi*8-0x1e240]'          );
  TestCase.testcase(126, [$62,$F2,$7D,$58,$C8,$30                           ] , 'vexp2ps  zmm6,dword [eax]{1to16}'                 );
  TestCase.testcase(127, [$62,$F2,$7D,$48,$C8,$72,$7F                       ] , 'vexp2ps  zmm6,zword [edx+0x1fc0]'                 );
  TestCase.testcase(128, [$62,$F2,$7D,$48,$C8,$B2,$00,$20,$00,$00           ] , 'vexp2ps  zmm6,zword [edx+0x2000]'                 );
  TestCase.testcase(129, [$62,$F2,$7D,$48,$C8,$72,$80                       ] , 'vexp2ps  zmm6,zword [edx-0x2000]'                 );
  TestCase.testcase(130, [$62,$F2,$7D,$48,$C8,$B2,$C0,$DF,$FF,$FF           ] , 'vexp2ps  zmm6,zword [edx-0x2040]'                 );
  TestCase.testcase(131, [$62,$F2,$7D,$58,$C8,$72,$7F                       ] , 'vexp2ps  zmm6,dword [edx+0x1fc]{1to16}'           );
  TestCase.testcase(132, [$62,$F2,$7D,$58,$C8,$B2,$00,$02,$00,$00           ] , 'vexp2ps  zmm6,dword [edx+0x200]{1to16}'           );
  TestCase.testcase(133, [$62,$F2,$7D,$58,$C8,$72,$80                       ] , 'vexp2ps  zmm6,dword [edx-0x200]{1to16}'           );
  TestCase.testcase(134, [$62,$F2,$7D,$58,$C8,$B2,$FC,$FD,$FF,$FF           ] , 'vexp2ps  zmm6,dword [edx-0x204]{1to16}'           );
  TestCase.testcase(135, [$62,$F2,$FD,$48,$C8,$F5                           ] , 'vexp2pd  zmm6,zmm5'                               );
  TestCase.testcase(136, [$62,$F2,$FD,$18,$C8,$F5                           ] , 'vexp2pd  zmm6,zmm5,{sae}'                         );
  TestCase.testcase(137, [$62,$F2,$FD,$48,$C8,$31                           ] , 'vexp2pd  zmm6,zword [ecx]'                        );
  TestCase.testcase(138, [$62,$F2,$FD,$48,$C8,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vexp2pd  zmm6,zword [esp+esi*8-0x1e240]'          );
  TestCase.testcase(139, [$62,$F2,$FD,$58,$C8,$30                           ] , 'vexp2pd  zmm6,qword [eax]{1to8}'                  );
  TestCase.testcase(140, [$62,$F2,$FD,$48,$C8,$72,$7F                       ] , 'vexp2pd  zmm6,zword [edx+0x1fc0]'                 );
  TestCase.testcase(141, [$62,$F2,$FD,$48,$C8,$B2,$00,$20,$00,$00           ] , 'vexp2pd  zmm6,zword [edx+0x2000]'                 );
  TestCase.testcase(142, [$62,$F2,$FD,$48,$C8,$72,$80                       ] , 'vexp2pd  zmm6,zword [edx-0x2000]'                 );
  TestCase.testcase(143, [$62,$F2,$FD,$48,$C8,$B2,$C0,$DF,$FF,$FF           ] , 'vexp2pd  zmm6,zword [edx-0x2040]'                 );
  TestCase.testcase(144, [$62,$F2,$FD,$58,$C8,$72,$7F                       ] , 'vexp2pd  zmm6,qword [edx+0x3f8]{1to8}'            );
  TestCase.testcase(145, [$62,$F2,$FD,$58,$C8,$B2,$00,$04,$00,$00           ] , 'vexp2pd  zmm6,qword [edx+0x400]{1to8}'            );
  TestCase.testcase(146, [$62,$F2,$FD,$58,$C8,$72,$80                       ] , 'vexp2pd  zmm6,qword [edx-0x400]{1to8}'            );
  TestCase.testcase(147, [$62,$F2,$FD,$58,$C8,$B2,$F8,$FB,$FF,$FF           ] , 'vexp2pd  zmm6,qword [edx-0x408]{1to8}'            );
  TestCase.testcase(148, [$62,$F2,$7D,$48,$CA,$F5                           ] , 'vrcp28ps  zmm6,zmm5'                              );
  TestCase.testcase(149, [$62,$F2,$7D,$4F,$CA,$F5                           ] , 'vrcp28ps  zmm6{k7},zmm5'                          );
  TestCase.testcase(150, [$62,$F2,$7D,$CF,$CA,$F5                           ] , 'vrcp28ps  zmm6{k7}{z},zmm5'                       );
  TestCase.testcase(151, [$62,$F2,$7D,$18,$CA,$F5                           ] , 'vrcp28ps  zmm6,zmm5,{sae}'                        );
  TestCase.testcase(152, [$62,$F2,$7D,$48,$CA,$31                           ] , 'vrcp28ps  zmm6,zword [ecx]'                       );
  TestCase.testcase(153, [$62,$F2,$7D,$48,$CA,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28ps  zmm6,zword [esp+esi*8-0x1e240]'         );
  TestCase.testcase(154, [$62,$F2,$7D,$58,$CA,$30                           ] , 'vrcp28ps  zmm6,dword [eax]{1to16}'                );
  TestCase.testcase(155, [$62,$F2,$7D,$48,$CA,$72,$7F                       ] , 'vrcp28ps  zmm6,zword [edx+0x1fc0]'                );
  TestCase.testcase(156, [$62,$F2,$7D,$48,$CA,$B2,$00,$20,$00,$00           ] , 'vrcp28ps  zmm6,zword [edx+0x2000]'                );
  TestCase.testcase(157, [$62,$F2,$7D,$48,$CA,$72,$80                       ] , 'vrcp28ps  zmm6,zword [edx-0x2000]'                );
  TestCase.testcase(158, [$62,$F2,$7D,$48,$CA,$B2,$C0,$DF,$FF,$FF           ] , 'vrcp28ps  zmm6,zword [edx-0x2040]'                );
  TestCase.testcase(159, [$62,$F2,$7D,$58,$CA,$72,$7F                       ] , 'vrcp28ps  zmm6,dword [edx+0x1fc]{1to16}'          );
  TestCase.testcase(160, [$62,$F2,$7D,$58,$CA,$B2,$00,$02,$00,$00           ] , 'vrcp28ps  zmm6,dword [edx+0x200]{1to16}'          );
  TestCase.testcase(161, [$62,$F2,$7D,$58,$CA,$72,$80                       ] , 'vrcp28ps  zmm6,dword [edx-0x200]{1to16}'          );
  TestCase.testcase(162, [$62,$F2,$7D,$58,$CA,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp28ps  zmm6,dword [edx-0x204]{1to16}'          );
  TestCase.testcase(163, [$62,$F2,$FD,$48,$CA,$F5                           ] , 'vrcp28pd  zmm6,zmm5'                              );
  TestCase.testcase(164, [$62,$F2,$FD,$4F,$CA,$F5                           ] , 'vrcp28pd  zmm6{k7},zmm5'                          );
  TestCase.testcase(165, [$62,$F2,$FD,$CF,$CA,$F5                           ] , 'vrcp28pd  zmm6{k7}{z},zmm5'                       );
  TestCase.testcase(166, [$62,$F2,$FD,$18,$CA,$F5                           ] , 'vrcp28pd  zmm6,zmm5,{sae}'                        );
  TestCase.testcase(167, [$62,$F2,$FD,$48,$CA,$31                           ] , 'vrcp28pd  zmm6,zword [ecx]'                       );
  TestCase.testcase(168, [$62,$F2,$FD,$48,$CA,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28pd  zmm6,zword [esp+esi*8-0x1e240]'         );
  TestCase.testcase(169, [$62,$F2,$FD,$58,$CA,$30                           ] , 'vrcp28pd  zmm6,qword [eax]{1to8}'                 );
  TestCase.testcase(170, [$62,$F2,$FD,$48,$CA,$72,$7F                       ] , 'vrcp28pd  zmm6,zword [edx+0x1fc0]'                );
  TestCase.testcase(171, [$62,$F2,$FD,$48,$CA,$B2,$00,$20,$00,$00           ] , 'vrcp28pd  zmm6,zword [edx+0x2000]'                );
  TestCase.testcase(172, [$62,$F2,$FD,$48,$CA,$72,$80                       ] , 'vrcp28pd  zmm6,zword [edx-0x2000]'                );
  TestCase.testcase(173, [$62,$F2,$FD,$48,$CA,$B2,$C0,$DF,$FF,$FF           ] , 'vrcp28pd  zmm6,zword [edx-0x2040]'                );
  TestCase.testcase(174, [$62,$F2,$FD,$58,$CA,$72,$7F                       ] , 'vrcp28pd  zmm6,qword [edx+0x3f8]{1to8}'           );
  TestCase.testcase(175, [$62,$F2,$FD,$58,$CA,$B2,$00,$04,$00,$00           ] , 'vrcp28pd  zmm6,qword [edx+0x400]{1to8}'           );
  TestCase.testcase(176, [$62,$F2,$FD,$58,$CA,$72,$80                       ] , 'vrcp28pd  zmm6,qword [edx-0x400]{1to8}'           );
  TestCase.testcase(177, [$62,$F2,$FD,$58,$CA,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp28pd  zmm6,qword [edx-0x408]{1to8}'           );
  TestCase.testcase(178, [$62,$F2,$55,$0F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(179, [$62,$F2,$55,$8F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(180, [$62,$F2,$55,$1F,$CB,$F4                           ] , 'vrcp28ss  xmm6{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(181, [$62,$F2,$55,$0F,$CB,$31                           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [ecx]'              );
  TestCase.testcase(182, [$62,$F2,$55,$0F,$CB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(183, [$62,$F2,$55,$0F,$CB,$72,$7F                       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx+0x1fc]'        );
  TestCase.testcase(184, [$62,$F2,$55,$0F,$CB,$B2,$00,$02,$00,$00           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx+0x200]'        );
  TestCase.testcase(185, [$62,$F2,$55,$0F,$CB,$72,$80                       ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx-0x200]'        );
  TestCase.testcase(186, [$62,$F2,$55,$0F,$CB,$B2,$FC,$FD,$FF,$FF           ] , 'vrcp28ss  xmm6{k7},xmm5,dword [edx-0x204]'        );
  TestCase.testcase(187, [$62,$F2,$D5,$0F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7},xmm5,xmm4'                     );
  TestCase.testcase(188, [$62,$F2,$D5,$8F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7}{z},xmm5,xmm4'                  );
  TestCase.testcase(189, [$62,$F2,$D5,$1F,$CB,$F4                           ] , 'vrcp28sd  xmm6{k7},xmm5,xmm4,{sae}'               );
  TestCase.testcase(190, [$62,$F2,$D5,$0F,$CB,$31                           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [ecx]'              );
  TestCase.testcase(191, [$62,$F2,$D5,$0F,$CB,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(192, [$62,$F2,$D5,$0F,$CB,$72,$7F                       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx+0x3f8]'        );
  TestCase.testcase(193, [$62,$F2,$D5,$0F,$CB,$B2,$00,$04,$00,$00           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx+0x400]'        );
  TestCase.testcase(194, [$62,$F2,$D5,$0F,$CB,$72,$80                       ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx-0x400]'        );
  TestCase.testcase(195, [$62,$F2,$D5,$0F,$CB,$B2,$F8,$FB,$FF,$FF           ] , 'vrcp28sd  xmm6{k7},xmm5,qword [edx-0x408]'        );
  TestCase.testcase(196, [$62,$F2,$7D,$48,$CC,$F5                           ] , 'vrsqrt28ps  zmm6,zmm5'                            );
  TestCase.testcase(197, [$62,$F2,$7D,$4F,$CC,$F5                           ] , 'vrsqrt28ps  zmm6{k7},zmm5'                        );
  TestCase.testcase(198, [$62,$F2,$7D,$CF,$CC,$F5                           ] , 'vrsqrt28ps  zmm6{k7}{z},zmm5'                     );
  TestCase.testcase(199, [$62,$F2,$7D,$18,$CC,$F5                           ] , 'vrsqrt28ps  zmm6,zmm5,{sae}'                      );
  TestCase.testcase(200, [$62,$F2,$7D,$48,$CC,$31                           ] , 'vrsqrt28ps  zmm6,zword [ecx]'                     );
  TestCase.testcase(201, [$62,$F2,$7D,$48,$CC,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28ps  zmm6,zword [esp+esi*8-0x1e240]'       );
  TestCase.testcase(202, [$62,$F2,$7D,$58,$CC,$30                           ] , 'vrsqrt28ps  zmm6,dword [eax]{1to16}'              );
  TestCase.testcase(203, [$62,$F2,$7D,$48,$CC,$72,$7F                       ] , 'vrsqrt28ps  zmm6,zword [edx+0x1fc0]'              );
  TestCase.testcase(204, [$62,$F2,$7D,$48,$CC,$B2,$00,$20,$00,$00           ] , 'vrsqrt28ps  zmm6,zword [edx+0x2000]'              );
  TestCase.testcase(205, [$62,$F2,$7D,$48,$CC,$72,$80                       ] , 'vrsqrt28ps  zmm6,zword [edx-0x2000]'              );
  TestCase.testcase(206, [$62,$F2,$7D,$48,$CC,$B2,$C0,$DF,$FF,$FF           ] , 'vrsqrt28ps  zmm6,zword [edx-0x2040]'              );
  TestCase.testcase(207, [$62,$F2,$7D,$58,$CC,$72,$7F                       ] , 'vrsqrt28ps  zmm6,dword [edx+0x1fc]{1to16}'        );
  TestCase.testcase(208, [$62,$F2,$7D,$58,$CC,$B2,$00,$02,$00,$00           ] , 'vrsqrt28ps  zmm6,dword [edx+0x200]{1to16}'        );
  TestCase.testcase(209, [$62,$F2,$7D,$58,$CC,$72,$80                       ] , 'vrsqrt28ps  zmm6,dword [edx-0x200]{1to16}'        );
  TestCase.testcase(210, [$62,$F2,$7D,$58,$CC,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt28ps  zmm6,dword [edx-0x204]{1to16}'        );
  TestCase.testcase(211, [$62,$F2,$FD,$48,$CC,$F5                           ] , 'vrsqrt28pd  zmm6,zmm5'                            );
  TestCase.testcase(212, [$62,$F2,$FD,$4F,$CC,$F5                           ] , 'vrsqrt28pd  zmm6{k7},zmm5'                        );
  TestCase.testcase(213, [$62,$F2,$FD,$CF,$CC,$F5                           ] , 'vrsqrt28pd  zmm6{k7}{z},zmm5'                     );
  TestCase.testcase(214, [$62,$F2,$FD,$18,$CC,$F5                           ] , 'vrsqrt28pd  zmm6,zmm5,{sae}'                      );
  TestCase.testcase(215, [$62,$F2,$FD,$48,$CC,$31                           ] , 'vrsqrt28pd  zmm6,zword [ecx]'                     );
  TestCase.testcase(216, [$62,$F2,$FD,$48,$CC,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28pd  zmm6,zword [esp+esi*8-0x1e240]'       );
  TestCase.testcase(217, [$62,$F2,$FD,$58,$CC,$30                           ] , 'vrsqrt28pd  zmm6,qword [eax]{1to8}'               );
  TestCase.testcase(218, [$62,$F2,$FD,$48,$CC,$72,$7F                       ] , 'vrsqrt28pd  zmm6,zword [edx+0x1fc0]'              );
  TestCase.testcase(219, [$62,$F2,$FD,$48,$CC,$B2,$00,$20,$00,$00           ] , 'vrsqrt28pd  zmm6,zword [edx+0x2000]'              );
  TestCase.testcase(220, [$62,$F2,$FD,$48,$CC,$72,$80                       ] , 'vrsqrt28pd  zmm6,zword [edx-0x2000]'              );
  TestCase.testcase(221, [$62,$F2,$FD,$48,$CC,$B2,$C0,$DF,$FF,$FF           ] , 'vrsqrt28pd  zmm6,zword [edx-0x2040]'              );
  TestCase.testcase(222, [$62,$F2,$FD,$58,$CC,$72,$7F                       ] , 'vrsqrt28pd  zmm6,qword [edx+0x3f8]{1to8}'         );
  TestCase.testcase(223, [$62,$F2,$FD,$58,$CC,$B2,$00,$04,$00,$00           ] , 'vrsqrt28pd  zmm6,qword [edx+0x400]{1to8}'         );
  TestCase.testcase(224, [$62,$F2,$FD,$58,$CC,$72,$80                       ] , 'vrsqrt28pd  zmm6,qword [edx-0x400]{1to8}'         );
  TestCase.testcase(225, [$62,$F2,$FD,$58,$CC,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt28pd  zmm6,qword [edx-0x408]{1to8}'         );
  TestCase.testcase(226, [$62,$F2,$55,$0F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(227, [$62,$F2,$55,$8F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(228, [$62,$F2,$55,$1F,$CD,$F4                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(229, [$62,$F2,$55,$0F,$CD,$31                           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [ecx]'            );
  TestCase.testcase(230, [$62,$F2,$55,$0F,$CD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [esp+esi*8-0x1e240]' );
  TestCase.testcase(231, [$62,$F2,$55,$0F,$CD,$72,$7F                       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx+0x1fc]'      );
  TestCase.testcase(232, [$62,$F2,$55,$0F,$CD,$B2,$00,$02,$00,$00           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx+0x200]'      );
  TestCase.testcase(233, [$62,$F2,$55,$0F,$CD,$72,$80                       ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx-0x200]'      );
  TestCase.testcase(234, [$62,$F2,$55,$0F,$CD,$B2,$FC,$FD,$FF,$FF           ] , 'vrsqrt28ss  xmm6{k7},xmm5,dword [edx-0x204]'      );
  TestCase.testcase(235, [$62,$F2,$D5,$0F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,xmm4'                   );
  TestCase.testcase(236, [$62,$F2,$D5,$8F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7}{z},xmm5,xmm4'                );
  TestCase.testcase(237, [$62,$F2,$D5,$1F,$CD,$F4                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,xmm4,{sae}'             );
  TestCase.testcase(238, [$62,$F2,$D5,$0F,$CD,$31                           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [ecx]'            );
  TestCase.testcase(239, [$62,$F2,$D5,$0F,$CD,$B4,$F4,$C0,$1D,$FE,$FF       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [esp+esi*8-0x1e240]' );
  TestCase.testcase(240, [$62,$F2,$D5,$0F,$CD,$72,$7F                       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx+0x3f8]'      );
  TestCase.testcase(241, [$62,$F2,$D5,$0F,$CD,$B2,$00,$04,$00,$00           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx+0x400]'      );
  TestCase.testcase(242, [$62,$F2,$D5,$0F,$CD,$72,$80                       ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx-0x400]'      );
  TestCase.testcase(243, [$62,$F2,$D5,$0F,$CD,$B2,$F8,$FB,$FF,$FF           ] , 'vrsqrt28sd  xmm6{k7},xmm5,qword [edx-0x408]'      );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x32.avx512er.log');
end;

end.