unit x32.avx256int;

// This unit was generated by d2p.pl script.
// Source : gas/avx256int-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x32.avx256int');
  TestCase.Start();	
  TestCase.Arch := CPUX32;

  TestCase.testcase(0, [$C5,$FD,$D7,$CC                                   ] , 'vpmovmskb  ecx,ymm4'                              );
  TestCase.testcase(1, [$C5,$ED,$72,$F6,$07                               ] , 'vpslld  ymm2,ymm6,0x7'                            );
  TestCase.testcase(2, [$C5,$ED,$73,$FE,$07                               ] , 'vpslldq  ymm2,ymm6,0x7'                           );
  TestCase.testcase(3, [$C5,$ED,$73,$F6,$07                               ] , 'vpsllq  ymm2,ymm6,0x7'                            );
  TestCase.testcase(4, [$C5,$ED,$71,$F6,$07                               ] , 'vpsllw  ymm2,ymm6,0x7'                            );
  TestCase.testcase(5, [$C5,$ED,$72,$E6,$07                               ] , 'vpsrad  ymm2,ymm6,0x7'                            );
  TestCase.testcase(6, [$C5,$ED,$71,$E6,$07                               ] , 'vpsraw  ymm2,ymm6,0x7'                            );
  TestCase.testcase(7, [$C5,$ED,$72,$D6,$07                               ] , 'vpsrld  ymm2,ymm6,0x7'                            );
  TestCase.testcase(8, [$C5,$ED,$73,$DE,$07                               ] , 'vpsrldq  ymm2,ymm6,0x7'                           );
  TestCase.testcase(9, [$C5,$ED,$73,$D6,$07                               ] , 'vpsrlq  ymm2,ymm6,0x7'                            );
  TestCase.testcase(10, [$C5,$ED,$71,$D6,$07                               ] , 'vpsrlw  ymm2,ymm6,0x7'                            );
  TestCase.testcase(11, [$C5,$FD,$70,$D6,$07                               ] , 'vpshufd  ymm2,ymm6,0x7'                           );
  TestCase.testcase(12, [$C5,$FD,$70,$31,$07                               ] , 'vpshufd  ymm6,yword [ecx],0x7'                    );
  TestCase.testcase(13, [$C5,$FE,$70,$D6,$07                               ] , 'vpshufhw  ymm2,ymm6,0x7'                          );
  TestCase.testcase(14, [$C5,$FE,$70,$31,$07                               ] , 'vpshufhw  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(15, [$C5,$FF,$70,$D6,$07                               ] , 'vpshuflw  ymm2,ymm6,0x7'                          );
  TestCase.testcase(16, [$C5,$FF,$70,$31,$07                               ] , 'vpshuflw  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(17, [$C5,$CD,$6B,$D4                                   ] , 'vpackssdw  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(18, [$C5,$CD,$6B,$11                                   ] , 'vpackssdw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(19, [$C5,$CD,$63,$D4                                   ] , 'vpacksswb  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(20, [$C5,$CD,$63,$11                                   ] , 'vpacksswb  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(21, [$C4,$E2,$4D,$2B,$D4                               ] , 'vpackusdw  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(22, [$C4,$E2,$4D,$2B,$11                               ] , 'vpackusdw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(23, [$C5,$CD,$67,$D4                                   ] , 'vpackuswb  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(24, [$C5,$CD,$67,$11                                   ] , 'vpackuswb  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(25, [$C5,$CD,$FC,$D4                                   ] , 'vpaddb  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(26, [$C5,$CD,$FC,$11                                   ] , 'vpaddb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(27, [$C5,$CD,$FD,$D4                                   ] , 'vpaddw  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(28, [$C5,$CD,$FD,$11                                   ] , 'vpaddw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(29, [$C5,$CD,$FE,$D4                                   ] , 'vpaddd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(30, [$C5,$CD,$FE,$11                                   ] , 'vpaddd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(31, [$C5,$CD,$D4,$D4                                   ] , 'vpaddq  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(32, [$C5,$CD,$D4,$11                                   ] , 'vpaddq  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(33, [$C5,$CD,$EC,$D4                                   ] , 'vpaddsb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(34, [$C5,$CD,$EC,$11                                   ] , 'vpaddsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(35, [$C5,$CD,$ED,$D4                                   ] , 'vpaddsw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(36, [$C5,$CD,$ED,$11                                   ] , 'vpaddsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(37, [$C5,$CD,$DC,$D4                                   ] , 'vpaddusb  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(38, [$C5,$CD,$DC,$11                                   ] , 'vpaddusb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(39, [$C5,$CD,$DD,$D4                                   ] , 'vpaddusw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(40, [$C5,$CD,$DD,$11                                   ] , 'vpaddusw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(41, [$C5,$CD,$DB,$D4                                   ] , 'vpand  ymm2,ymm6,ymm4'                            );
  TestCase.testcase(42, [$C5,$CD,$DB,$11                                   ] , 'vpand  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(43, [$C5,$CD,$DF,$D4                                   ] , 'vpandn  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(44, [$C5,$CD,$DF,$11                                   ] , 'vpandn  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(45, [$C5,$CD,$E0,$D4                                   ] , 'vpavgb  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(46, [$C5,$CD,$E0,$11                                   ] , 'vpavgb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(47, [$C5,$CD,$E3,$D4                                   ] , 'vpavgw  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(48, [$C5,$CD,$E3,$11                                   ] , 'vpavgw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(49, [$C5,$CD,$74,$D4                                   ] , 'vpcmpeqb  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(50, [$C5,$CD,$74,$11                                   ] , 'vpcmpeqb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(51, [$C5,$CD,$75,$D4                                   ] , 'vpcmpeqw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(52, [$C5,$CD,$75,$11                                   ] , 'vpcmpeqw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(53, [$C5,$CD,$76,$D4                                   ] , 'vpcmpeqd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(54, [$C5,$CD,$76,$11                                   ] , 'vpcmpeqd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(55, [$C4,$E2,$4D,$29,$D4                               ] , 'vpcmpeqq  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(56, [$C4,$E2,$4D,$29,$11                               ] , 'vpcmpeqq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(57, [$C5,$CD,$64,$D4                                   ] , 'vpcmpgtb  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(58, [$C5,$CD,$64,$11                                   ] , 'vpcmpgtb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(59, [$C5,$CD,$65,$D4                                   ] , 'vpcmpgtw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(60, [$C5,$CD,$65,$11                                   ] , 'vpcmpgtw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(61, [$C5,$CD,$66,$D4                                   ] , 'vpcmpgtd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(62, [$C5,$CD,$66,$11                                   ] , 'vpcmpgtd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(63, [$C4,$E2,$4D,$37,$D4                               ] , 'vpcmpgtq  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(64, [$C4,$E2,$4D,$37,$11                               ] , 'vpcmpgtq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(65, [$C4,$E2,$4D,$01,$D4                               ] , 'vphaddw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(66, [$C4,$E2,$4D,$01,$11                               ] , 'vphaddw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(67, [$C4,$E2,$4D,$02,$D4                               ] , 'vphaddd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(68, [$C4,$E2,$4D,$02,$11                               ] , 'vphaddd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(69, [$C4,$E2,$4D,$03,$D4                               ] , 'vphaddsw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(70, [$C4,$E2,$4D,$03,$11                               ] , 'vphaddsw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(71, [$C4,$E2,$4D,$05,$D4                               ] , 'vphsubw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(72, [$C4,$E2,$4D,$05,$11                               ] , 'vphsubw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(73, [$C4,$E2,$4D,$06,$D4                               ] , 'vphsubd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(74, [$C4,$E2,$4D,$06,$11                               ] , 'vphsubd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(75, [$C4,$E2,$4D,$07,$D4                               ] , 'vphsubsw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(76, [$C4,$E2,$4D,$07,$11                               ] , 'vphsubsw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(77, [$C5,$CD,$F5,$D4                                   ] , 'vpmaddwd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(78, [$C5,$CD,$F5,$11                                   ] , 'vpmaddwd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(79, [$C4,$E2,$4D,$04,$D4                               ] , 'vpmaddubsw  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(80, [$C4,$E2,$4D,$04,$11                               ] , 'vpmaddubsw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(81, [$C4,$E2,$4D,$3C,$D4                               ] , 'vpmaxsb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(82, [$C4,$E2,$4D,$3C,$11                               ] , 'vpmaxsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(83, [$C5,$CD,$EE,$D4                                   ] , 'vpmaxsw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(84, [$C5,$CD,$EE,$11                                   ] , 'vpmaxsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(85, [$C4,$E2,$4D,$3D,$D4                               ] , 'vpmaxsd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(86, [$C4,$E2,$4D,$3D,$11                               ] , 'vpmaxsd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(87, [$C5,$CD,$DE,$D4                                   ] , 'vpmaxub  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(88, [$C5,$CD,$DE,$11                                   ] , 'vpmaxub  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(89, [$C4,$E2,$4D,$3E,$D4                               ] , 'vpmaxuw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(90, [$C4,$E2,$4D,$3E,$11                               ] , 'vpmaxuw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(91, [$C4,$E2,$4D,$3F,$D4                               ] , 'vpmaxud  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(92, [$C4,$E2,$4D,$3F,$11                               ] , 'vpmaxud  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(93, [$C4,$E2,$4D,$38,$D4                               ] , 'vpminsb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(94, [$C4,$E2,$4D,$38,$11                               ] , 'vpminsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(95, [$C5,$CD,$EA,$D4                                   ] , 'vpminsw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(96, [$C5,$CD,$EA,$11                                   ] , 'vpminsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(97, [$C4,$E2,$4D,$39,$D4                               ] , 'vpminsd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(98, [$C4,$E2,$4D,$39,$11                               ] , 'vpminsd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(99, [$C5,$CD,$DA,$D4                                   ] , 'vpminub  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(100, [$C5,$CD,$DA,$11                                   ] , 'vpminub  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(101, [$C4,$E2,$4D,$3A,$D4                               ] , 'vpminuw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(102, [$C4,$E2,$4D,$3A,$11                               ] , 'vpminuw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(103, [$C4,$E2,$4D,$3B,$D4                               ] , 'vpminud  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(104, [$C4,$E2,$4D,$3B,$11                               ] , 'vpminud  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(105, [$C5,$CD,$E4,$D4                                   ] , 'vpmulhuw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(106, [$C5,$CD,$E4,$11                                   ] , 'vpmulhuw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(107, [$C4,$E2,$4D,$0B,$D4                               ] , 'vpmulhrsw  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(108, [$C4,$E2,$4D,$0B,$11                               ] , 'vpmulhrsw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(109, [$C5,$CD,$E5,$D4                                   ] , 'vpmulhw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(110, [$C5,$CD,$E5,$11                                   ] , 'vpmulhw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(111, [$C5,$CD,$D5,$D4                                   ] , 'vpmullw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(112, [$C5,$CD,$D5,$11                                   ] , 'vpmullw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(113, [$C4,$E2,$4D,$40,$D4                               ] , 'vpmulld  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(114, [$C4,$E2,$4D,$40,$11                               ] , 'vpmulld  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(115, [$C5,$CD,$F4,$D4                                   ] , 'vpmuludq  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(116, [$C5,$CD,$F4,$11                                   ] , 'vpmuludq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(117, [$C4,$E2,$4D,$28,$D4                               ] , 'vpmuldq  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(118, [$C4,$E2,$4D,$28,$11                               ] , 'vpmuldq  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(119, [$C5,$CD,$EB,$D4                                   ] , 'vpor  ymm2,ymm6,ymm4'                             );
  TestCase.testcase(120, [$C5,$CD,$EB,$11                                   ] , 'vpor  ymm2,ymm6,yword [ecx]'                      );
  TestCase.testcase(121, [$C5,$CD,$F6,$D4                                   ] , 'vpsadbw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(122, [$C5,$CD,$F6,$11                                   ] , 'vpsadbw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(123, [$C4,$E2,$4D,$00,$D4                               ] , 'vpshufb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(124, [$C4,$E2,$4D,$00,$11                               ] , 'vpshufb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(125, [$C4,$E2,$4D,$08,$D4                               ] , 'vpsignb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(126, [$C4,$E2,$4D,$08,$11                               ] , 'vpsignb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(127, [$C4,$E2,$4D,$09,$D4                               ] , 'vpsignw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(128, [$C4,$E2,$4D,$09,$11                               ] , 'vpsignw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(129, [$C4,$E2,$4D,$0A,$D4                               ] , 'vpsignd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(130, [$C4,$E2,$4D,$0A,$11                               ] , 'vpsignd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(131, [$C5,$CD,$F8,$D4                                   ] , 'vpsubb  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(132, [$C5,$CD,$F8,$11                                   ] , 'vpsubb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(133, [$C5,$CD,$F9,$D4                                   ] , 'vpsubw  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(134, [$C5,$CD,$F9,$11                                   ] , 'vpsubw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(135, [$C5,$CD,$FA,$D4                                   ] , 'vpsubd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(136, [$C5,$CD,$FA,$11                                   ] , 'vpsubd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(137, [$C5,$CD,$FB,$D4                                   ] , 'vpsubq  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(138, [$C5,$CD,$FB,$11                                   ] , 'vpsubq  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(139, [$C5,$CD,$E8,$D4                                   ] , 'vpsubsb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(140, [$C5,$CD,$E8,$11                                   ] , 'vpsubsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(141, [$C5,$CD,$E9,$D4                                   ] , 'vpsubsw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(142, [$C5,$CD,$E9,$11                                   ] , 'vpsubsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(143, [$C5,$CD,$D8,$D4                                   ] , 'vpsubusb  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(144, [$C5,$CD,$D8,$11                                   ] , 'vpsubusb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(145, [$C5,$CD,$D9,$D4                                   ] , 'vpsubusw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(146, [$C5,$CD,$D9,$11                                   ] , 'vpsubusw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(147, [$C5,$CD,$68,$D4                                   ] , 'vpunpckhbw  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(148, [$C5,$CD,$68,$11                                   ] , 'vpunpckhbw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(149, [$C5,$CD,$69,$D4                                   ] , 'vpunpckhwd  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(150, [$C5,$CD,$69,$11                                   ] , 'vpunpckhwd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(151, [$C5,$CD,$6A,$D4                                   ] , 'vpunpckhdq  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(152, [$C5,$CD,$6A,$11                                   ] , 'vpunpckhdq  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(153, [$C5,$CD,$6D,$D4                                   ] , 'vpunpckhqdq  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(154, [$C5,$CD,$6D,$11                                   ] , 'vpunpckhqdq  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(155, [$C5,$CD,$60,$D4                                   ] , 'vpunpcklbw  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(156, [$C5,$CD,$60,$11                                   ] , 'vpunpcklbw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(157, [$C5,$CD,$61,$D4                                   ] , 'vpunpcklwd  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(158, [$C5,$CD,$61,$11                                   ] , 'vpunpcklwd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(159, [$C5,$CD,$62,$D4                                   ] , 'vpunpckldq  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(160, [$C5,$CD,$62,$11                                   ] , 'vpunpckldq  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(161, [$C5,$CD,$6C,$D4                                   ] , 'vpunpcklqdq  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(162, [$C5,$CD,$6C,$11                                   ] , 'vpunpcklqdq  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(163, [$C5,$CD,$EF,$D4                                   ] , 'vpxor  ymm2,ymm6,ymm4'                            );
  TestCase.testcase(164, [$C5,$CD,$EF,$11                                   ] , 'vpxor  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(165, [$C4,$E2,$7D,$1C,$F4                               ] , 'vpabsb  ymm6,ymm4'                                );
  TestCase.testcase(166, [$C4,$E2,$7D,$1C,$21                               ] , 'vpabsb  ymm4,yword [ecx]'                         );
  TestCase.testcase(167, [$C4,$E2,$7D,$1D,$F4                               ] , 'vpabsw  ymm6,ymm4'                                );
  TestCase.testcase(168, [$C4,$E2,$7D,$1D,$21                               ] , 'vpabsw  ymm4,yword [ecx]'                         );
  TestCase.testcase(169, [$C4,$E2,$7D,$1E,$F4                               ] , 'vpabsd  ymm6,ymm4'                                );
  TestCase.testcase(170, [$C4,$E2,$7D,$1E,$21                               ] , 'vpabsd  ymm4,yword [ecx]'                         );
  TestCase.testcase(171, [$C4,$E3,$4D,$42,$D4,$07                           ] , 'vmpsadbw  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(172, [$C4,$E3,$4D,$42,$11,$07                           ] , 'vmpsadbw  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(173, [$C4,$E3,$4D,$0F,$D4,$07                           ] , 'vpalignr  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(174, [$C4,$E3,$4D,$0F,$11,$07                           ] , 'vpalignr  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(175, [$C4,$E3,$4D,$0E,$D4,$07                           ] , 'vpblendw  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(176, [$C4,$E3,$4D,$0E,$11,$07                           ] , 'vpblendw  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(177, [$C4,$E3,$6D,$4C,$FE,$40                           ] , 'vpblendvb  ymm7,ymm2,ymm6,ymm4'                   );
  TestCase.testcase(178, [$C4,$E3,$6D,$4C,$39,$40                           ] , 'vpblendvb  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(179, [$C5,$CD,$F1,$D4                                   ] , 'vpsllw  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(180, [$C5,$CD,$F1,$11                                   ] , 'vpsllw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(181, [$C5,$CD,$F2,$D4                                   ] , 'vpslld  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(182, [$C5,$CD,$F2,$11                                   ] , 'vpslld  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(183, [$C5,$CD,$F3,$D4                                   ] , 'vpsllq  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(184, [$C5,$CD,$F3,$11                                   ] , 'vpsllq  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(185, [$C5,$CD,$E1,$D4                                   ] , 'vpsraw  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(186, [$C5,$CD,$E1,$11                                   ] , 'vpsraw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(187, [$C5,$CD,$E2,$D4                                   ] , 'vpsrad  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(188, [$C5,$CD,$E2,$11                                   ] , 'vpsrad  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(189, [$C5,$CD,$D1,$D4                                   ] , 'vpsrlw  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(190, [$C5,$CD,$D1,$11                                   ] , 'vpsrlw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(191, [$C5,$CD,$D2,$D4                                   ] , 'vpsrld  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(192, [$C5,$CD,$D2,$11                                   ] , 'vpsrld  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(193, [$C5,$CD,$D3,$D4                                   ] , 'vpsrlq  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(194, [$C5,$CD,$D3,$11                                   ] , 'vpsrlq  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(195, [$C4,$E2,$7D,$20,$E4                               ] , 'vpmovsxbw  ymm4,xmm4'                             );
  TestCase.testcase(196, [$C4,$E2,$7D,$20,$21                               ] , 'vpmovsxbw  ymm4,oword [ecx]'                      );
  TestCase.testcase(197, [$C4,$E2,$7D,$23,$E4                               ] , 'vpmovsxwd  ymm4,xmm4'                             );
  TestCase.testcase(198, [$C4,$E2,$7D,$23,$21                               ] , 'vpmovsxwd  ymm4,oword [ecx]'                      );
  TestCase.testcase(199, [$C4,$E2,$7D,$25,$E4                               ] , 'vpmovsxdq  ymm4,xmm4'                             );
  TestCase.testcase(200, [$C4,$E2,$7D,$25,$21                               ] , 'vpmovsxdq  ymm4,oword [ecx]'                      );
  TestCase.testcase(201, [$C4,$E2,$7D,$30,$E4                               ] , 'vpmovzxbw  ymm4,xmm4'                             );
  TestCase.testcase(202, [$C4,$E2,$7D,$30,$21                               ] , 'vpmovzxbw  ymm4,oword [ecx]'                      );
  TestCase.testcase(203, [$C4,$E2,$7D,$33,$E4                               ] , 'vpmovzxwd  ymm4,xmm4'                             );
  TestCase.testcase(204, [$C4,$E2,$7D,$33,$21                               ] , 'vpmovzxwd  ymm4,oword [ecx]'                      );
  TestCase.testcase(205, [$C4,$E2,$7D,$35,$E4                               ] , 'vpmovzxdq  ymm4,xmm4'                             );
  TestCase.testcase(206, [$C4,$E2,$7D,$35,$21                               ] , 'vpmovzxdq  ymm4,oword [ecx]'                      );
  TestCase.testcase(207, [$C4,$E2,$7D,$21,$F4                               ] , 'vpmovsxbd  ymm6,xmm4'                             );
  TestCase.testcase(208, [$C4,$E2,$7D,$21,$21                               ] , 'vpmovsxbd  ymm4,qword [ecx]'                      );
  TestCase.testcase(209, [$C4,$E2,$7D,$24,$F4                               ] , 'vpmovsxwq  ymm6,xmm4'                             );
  TestCase.testcase(210, [$C4,$E2,$7D,$24,$21                               ] , 'vpmovsxwq  ymm4,qword [ecx]'                      );
  TestCase.testcase(211, [$C4,$E2,$7D,$31,$F4                               ] , 'vpmovzxbd  ymm6,xmm4'                             );
  TestCase.testcase(212, [$C4,$E2,$7D,$31,$21                               ] , 'vpmovzxbd  ymm4,qword [ecx]'                      );
  TestCase.testcase(213, [$C4,$E2,$7D,$34,$F4                               ] , 'vpmovzxwq  ymm6,xmm4'                             );
  TestCase.testcase(214, [$C4,$E2,$7D,$34,$21                               ] , 'vpmovzxwq  ymm4,qword [ecx]'                      );
  TestCase.testcase(215, [$C4,$E2,$7D,$22,$E4                               ] , 'vpmovsxbq  ymm4,xmm4'                             );
  TestCase.testcase(216, [$C4,$E2,$7D,$22,$21                               ] , 'vpmovsxbq  ymm4,dword [ecx]'                      );
  TestCase.testcase(217, [$C4,$E2,$7D,$32,$E4                               ] , 'vpmovzxbq  ymm4,xmm4'                             );
  TestCase.testcase(218, [$C4,$E2,$7D,$32,$21                               ] , 'vpmovzxbq  ymm4,dword [ecx]'                      );
  TestCase.testcase(219, [$C5,$FD,$D7,$CC                                   ] , 'vpmovmskb  ecx,ymm4'                              );
  TestCase.testcase(220, [$C5,$ED,$72,$F6,$07                               ] , 'vpslld  ymm2,ymm6,0x7'                            );
  TestCase.testcase(221, [$C5,$ED,$73,$FE,$07                               ] , 'vpslldq  ymm2,ymm6,0x7'                           );
  TestCase.testcase(222, [$C5,$ED,$73,$F6,$07                               ] , 'vpsllq  ymm2,ymm6,0x7'                            );
  TestCase.testcase(223, [$C5,$ED,$71,$F6,$07                               ] , 'vpsllw  ymm2,ymm6,0x7'                            );
  TestCase.testcase(224, [$C5,$ED,$72,$E6,$07                               ] , 'vpsrad  ymm2,ymm6,0x7'                            );
  TestCase.testcase(225, [$C5,$ED,$71,$E6,$07                               ] , 'vpsraw  ymm2,ymm6,0x7'                            );
  TestCase.testcase(226, [$C5,$ED,$72,$D6,$07                               ] , 'vpsrld  ymm2,ymm6,0x7'                            );
  TestCase.testcase(227, [$C5,$ED,$73,$DE,$07                               ] , 'vpsrldq  ymm2,ymm6,0x7'                           );
  TestCase.testcase(228, [$C5,$ED,$73,$D6,$07                               ] , 'vpsrlq  ymm2,ymm6,0x7'                            );
  TestCase.testcase(229, [$C5,$ED,$71,$D6,$07                               ] , 'vpsrlw  ymm2,ymm6,0x7'                            );
  TestCase.testcase(230, [$C5,$FD,$70,$D6,$07                               ] , 'vpshufd  ymm2,ymm6,0x7'                           );
  TestCase.testcase(231, [$C5,$FD,$70,$31,$07                               ] , 'vpshufd  ymm6,yword [ecx],0x7'                    );
  TestCase.testcase(232, [$C5,$FD,$70,$31,$07                               ] , 'vpshufd  ymm6,yword [ecx],0x7'                    );
  TestCase.testcase(233, [$C5,$FE,$70,$D6,$07                               ] , 'vpshufhw  ymm2,ymm6,0x7'                          );
  TestCase.testcase(234, [$C5,$FE,$70,$31,$07                               ] , 'vpshufhw  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(235, [$C5,$FE,$70,$31,$07                               ] , 'vpshufhw  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(236, [$C5,$FF,$70,$D6,$07                               ] , 'vpshuflw  ymm2,ymm6,0x7'                          );
  TestCase.testcase(237, [$C5,$FF,$70,$31,$07                               ] , 'vpshuflw  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(238, [$C5,$FF,$70,$31,$07                               ] , 'vpshuflw  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(239, [$C5,$CD,$6B,$D4                                   ] , 'vpackssdw  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(240, [$C5,$CD,$6B,$11                                   ] , 'vpackssdw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(241, [$C5,$CD,$6B,$11                                   ] , 'vpackssdw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(242, [$C5,$CD,$63,$D4                                   ] , 'vpacksswb  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(243, [$C5,$CD,$63,$11                                   ] , 'vpacksswb  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(244, [$C5,$CD,$63,$11                                   ] , 'vpacksswb  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(245, [$C4,$E2,$4D,$2B,$D4                               ] , 'vpackusdw  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(246, [$C4,$E2,$4D,$2B,$11                               ] , 'vpackusdw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(247, [$C4,$E2,$4D,$2B,$11                               ] , 'vpackusdw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(248, [$C5,$CD,$67,$D4                                   ] , 'vpackuswb  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(249, [$C5,$CD,$67,$11                                   ] , 'vpackuswb  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(250, [$C5,$CD,$67,$11                                   ] , 'vpackuswb  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(251, [$C5,$CD,$FC,$D4                                   ] , 'vpaddb  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(252, [$C5,$CD,$FC,$11                                   ] , 'vpaddb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(253, [$C5,$CD,$FC,$11                                   ] , 'vpaddb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(254, [$C5,$CD,$FD,$D4                                   ] , 'vpaddw  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(255, [$C5,$CD,$FD,$11                                   ] , 'vpaddw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(256, [$C5,$CD,$FD,$11                                   ] , 'vpaddw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(257, [$C5,$CD,$FE,$D4                                   ] , 'vpaddd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(258, [$C5,$CD,$FE,$11                                   ] , 'vpaddd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(259, [$C5,$CD,$FE,$11                                   ] , 'vpaddd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(260, [$C5,$CD,$D4,$D4                                   ] , 'vpaddq  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(261, [$C5,$CD,$D4,$11                                   ] , 'vpaddq  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(262, [$C5,$CD,$D4,$11                                   ] , 'vpaddq  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(263, [$C5,$CD,$EC,$D4                                   ] , 'vpaddsb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(264, [$C5,$CD,$EC,$11                                   ] , 'vpaddsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(265, [$C5,$CD,$EC,$11                                   ] , 'vpaddsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(266, [$C5,$CD,$ED,$D4                                   ] , 'vpaddsw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(267, [$C5,$CD,$ED,$11                                   ] , 'vpaddsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(268, [$C5,$CD,$ED,$11                                   ] , 'vpaddsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(269, [$C5,$CD,$DC,$D4                                   ] , 'vpaddusb  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(270, [$C5,$CD,$DC,$11                                   ] , 'vpaddusb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(271, [$C5,$CD,$DC,$11                                   ] , 'vpaddusb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(272, [$C5,$CD,$DD,$D4                                   ] , 'vpaddusw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(273, [$C5,$CD,$DD,$11                                   ] , 'vpaddusw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(274, [$C5,$CD,$DD,$11                                   ] , 'vpaddusw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(275, [$C5,$CD,$DB,$D4                                   ] , 'vpand  ymm2,ymm6,ymm4'                            );
  TestCase.testcase(276, [$C5,$CD,$DB,$11                                   ] , 'vpand  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(277, [$C5,$CD,$DB,$11                                   ] , 'vpand  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(278, [$C5,$CD,$DF,$D4                                   ] , 'vpandn  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(279, [$C5,$CD,$DF,$11                                   ] , 'vpandn  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(280, [$C5,$CD,$DF,$11                                   ] , 'vpandn  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(281, [$C5,$CD,$E0,$D4                                   ] , 'vpavgb  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(282, [$C5,$CD,$E0,$11                                   ] , 'vpavgb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(283, [$C5,$CD,$E0,$11                                   ] , 'vpavgb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(284, [$C5,$CD,$E3,$D4                                   ] , 'vpavgw  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(285, [$C5,$CD,$E3,$11                                   ] , 'vpavgw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(286, [$C5,$CD,$E3,$11                                   ] , 'vpavgw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(287, [$C5,$CD,$74,$D4                                   ] , 'vpcmpeqb  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(288, [$C5,$CD,$74,$11                                   ] , 'vpcmpeqb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(289, [$C5,$CD,$74,$11                                   ] , 'vpcmpeqb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(290, [$C5,$CD,$75,$D4                                   ] , 'vpcmpeqw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(291, [$C5,$CD,$75,$11                                   ] , 'vpcmpeqw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(292, [$C5,$CD,$75,$11                                   ] , 'vpcmpeqw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(293, [$C5,$CD,$76,$D4                                   ] , 'vpcmpeqd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(294, [$C5,$CD,$76,$11                                   ] , 'vpcmpeqd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(295, [$C5,$CD,$76,$11                                   ] , 'vpcmpeqd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(296, [$C4,$E2,$4D,$29,$D4                               ] , 'vpcmpeqq  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(297, [$C4,$E2,$4D,$29,$11                               ] , 'vpcmpeqq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(298, [$C4,$E2,$4D,$29,$11                               ] , 'vpcmpeqq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(299, [$C5,$CD,$64,$D4                                   ] , 'vpcmpgtb  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(300, [$C5,$CD,$64,$11                                   ] , 'vpcmpgtb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(301, [$C5,$CD,$64,$11                                   ] , 'vpcmpgtb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(302, [$C5,$CD,$65,$D4                                   ] , 'vpcmpgtw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(303, [$C5,$CD,$65,$11                                   ] , 'vpcmpgtw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(304, [$C5,$CD,$65,$11                                   ] , 'vpcmpgtw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(305, [$C5,$CD,$66,$D4                                   ] , 'vpcmpgtd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(306, [$C5,$CD,$66,$11                                   ] , 'vpcmpgtd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(307, [$C5,$CD,$66,$11                                   ] , 'vpcmpgtd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(308, [$C4,$E2,$4D,$37,$D4                               ] , 'vpcmpgtq  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(309, [$C4,$E2,$4D,$37,$11                               ] , 'vpcmpgtq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(310, [$C4,$E2,$4D,$37,$11                               ] , 'vpcmpgtq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(311, [$C4,$E2,$4D,$01,$D4                               ] , 'vphaddw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(312, [$C4,$E2,$4D,$01,$11                               ] , 'vphaddw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(313, [$C4,$E2,$4D,$01,$11                               ] , 'vphaddw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(314, [$C4,$E2,$4D,$02,$D4                               ] , 'vphaddd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(315, [$C4,$E2,$4D,$02,$11                               ] , 'vphaddd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(316, [$C4,$E2,$4D,$02,$11                               ] , 'vphaddd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(317, [$C4,$E2,$4D,$03,$D4                               ] , 'vphaddsw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(318, [$C4,$E2,$4D,$03,$11                               ] , 'vphaddsw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(319, [$C4,$E2,$4D,$03,$11                               ] , 'vphaddsw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(320, [$C4,$E2,$4D,$05,$D4                               ] , 'vphsubw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(321, [$C4,$E2,$4D,$05,$11                               ] , 'vphsubw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(322, [$C4,$E2,$4D,$05,$11                               ] , 'vphsubw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(323, [$C4,$E2,$4D,$06,$D4                               ] , 'vphsubd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(324, [$C4,$E2,$4D,$06,$11                               ] , 'vphsubd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(325, [$C4,$E2,$4D,$06,$11                               ] , 'vphsubd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(326, [$C4,$E2,$4D,$07,$D4                               ] , 'vphsubsw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(327, [$C4,$E2,$4D,$07,$11                               ] , 'vphsubsw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(328, [$C4,$E2,$4D,$07,$11                               ] , 'vphsubsw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(329, [$C5,$CD,$F5,$D4                                   ] , 'vpmaddwd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(330, [$C5,$CD,$F5,$11                                   ] , 'vpmaddwd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(331, [$C5,$CD,$F5,$11                                   ] , 'vpmaddwd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(332, [$C4,$E2,$4D,$04,$D4                               ] , 'vpmaddubsw  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(333, [$C4,$E2,$4D,$04,$11                               ] , 'vpmaddubsw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(334, [$C4,$E2,$4D,$04,$11                               ] , 'vpmaddubsw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(335, [$C4,$E2,$4D,$3C,$D4                               ] , 'vpmaxsb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(336, [$C4,$E2,$4D,$3C,$11                               ] , 'vpmaxsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(337, [$C4,$E2,$4D,$3C,$11                               ] , 'vpmaxsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(338, [$C5,$CD,$EE,$D4                                   ] , 'vpmaxsw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(339, [$C5,$CD,$EE,$11                                   ] , 'vpmaxsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(340, [$C5,$CD,$EE,$11                                   ] , 'vpmaxsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(341, [$C4,$E2,$4D,$3D,$D4                               ] , 'vpmaxsd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(342, [$C4,$E2,$4D,$3D,$11                               ] , 'vpmaxsd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(343, [$C4,$E2,$4D,$3D,$11                               ] , 'vpmaxsd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(344, [$C5,$CD,$DE,$D4                                   ] , 'vpmaxub  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(345, [$C5,$CD,$DE,$11                                   ] , 'vpmaxub  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(346, [$C5,$CD,$DE,$11                                   ] , 'vpmaxub  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(347, [$C4,$E2,$4D,$3E,$D4                               ] , 'vpmaxuw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(348, [$C4,$E2,$4D,$3E,$11                               ] , 'vpmaxuw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(349, [$C4,$E2,$4D,$3E,$11                               ] , 'vpmaxuw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(350, [$C4,$E2,$4D,$3F,$D4                               ] , 'vpmaxud  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(351, [$C4,$E2,$4D,$3F,$11                               ] , 'vpmaxud  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(352, [$C4,$E2,$4D,$3F,$11                               ] , 'vpmaxud  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(353, [$C4,$E2,$4D,$38,$D4                               ] , 'vpminsb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(354, [$C4,$E2,$4D,$38,$11                               ] , 'vpminsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(355, [$C4,$E2,$4D,$38,$11                               ] , 'vpminsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(356, [$C5,$CD,$EA,$D4                                   ] , 'vpminsw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(357, [$C5,$CD,$EA,$11                                   ] , 'vpminsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(358, [$C5,$CD,$EA,$11                                   ] , 'vpminsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(359, [$C4,$E2,$4D,$39,$D4                               ] , 'vpminsd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(360, [$C4,$E2,$4D,$39,$11                               ] , 'vpminsd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(361, [$C4,$E2,$4D,$39,$11                               ] , 'vpminsd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(362, [$C5,$CD,$DA,$D4                                   ] , 'vpminub  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(363, [$C5,$CD,$DA,$11                                   ] , 'vpminub  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(364, [$C5,$CD,$DA,$11                                   ] , 'vpminub  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(365, [$C4,$E2,$4D,$3A,$D4                               ] , 'vpminuw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(366, [$C4,$E2,$4D,$3A,$11                               ] , 'vpminuw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(367, [$C4,$E2,$4D,$3A,$11                               ] , 'vpminuw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(368, [$C4,$E2,$4D,$3B,$D4                               ] , 'vpminud  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(369, [$C4,$E2,$4D,$3B,$11                               ] , 'vpminud  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(370, [$C4,$E2,$4D,$3B,$11                               ] , 'vpminud  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(371, [$C5,$CD,$E4,$D4                                   ] , 'vpmulhuw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(372, [$C5,$CD,$E4,$11                                   ] , 'vpmulhuw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(373, [$C5,$CD,$E4,$11                                   ] , 'vpmulhuw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(374, [$C4,$E2,$4D,$0B,$D4                               ] , 'vpmulhrsw  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(375, [$C4,$E2,$4D,$0B,$11                               ] , 'vpmulhrsw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(376, [$C4,$E2,$4D,$0B,$11                               ] , 'vpmulhrsw  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(377, [$C5,$CD,$E5,$D4                                   ] , 'vpmulhw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(378, [$C5,$CD,$E5,$11                                   ] , 'vpmulhw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(379, [$C5,$CD,$E5,$11                                   ] , 'vpmulhw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(380, [$C5,$CD,$D5,$D4                                   ] , 'vpmullw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(381, [$C5,$CD,$D5,$11                                   ] , 'vpmullw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(382, [$C5,$CD,$D5,$11                                   ] , 'vpmullw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(383, [$C4,$E2,$4D,$40,$D4                               ] , 'vpmulld  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(384, [$C4,$E2,$4D,$40,$11                               ] , 'vpmulld  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(385, [$C4,$E2,$4D,$40,$11                               ] , 'vpmulld  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(386, [$C5,$CD,$F4,$D4                                   ] , 'vpmuludq  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(387, [$C5,$CD,$F4,$11                                   ] , 'vpmuludq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(388, [$C5,$CD,$F4,$11                                   ] , 'vpmuludq  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(389, [$C4,$E2,$4D,$28,$D4                               ] , 'vpmuldq  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(390, [$C4,$E2,$4D,$28,$11                               ] , 'vpmuldq  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(391, [$C4,$E2,$4D,$28,$11                               ] , 'vpmuldq  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(392, [$C5,$CD,$EB,$D4                                   ] , 'vpor  ymm2,ymm6,ymm4'                             );
  TestCase.testcase(393, [$C5,$CD,$EB,$11                                   ] , 'vpor  ymm2,ymm6,yword [ecx]'                      );
  TestCase.testcase(394, [$C5,$CD,$EB,$11                                   ] , 'vpor  ymm2,ymm6,yword [ecx]'                      );
  TestCase.testcase(395, [$C5,$CD,$F6,$D4                                   ] , 'vpsadbw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(396, [$C5,$CD,$F6,$11                                   ] , 'vpsadbw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(397, [$C5,$CD,$F6,$11                                   ] , 'vpsadbw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(398, [$C4,$E2,$4D,$00,$D4                               ] , 'vpshufb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(399, [$C4,$E2,$4D,$00,$11                               ] , 'vpshufb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(400, [$C4,$E2,$4D,$00,$11                               ] , 'vpshufb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(401, [$C4,$E2,$4D,$08,$D4                               ] , 'vpsignb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(402, [$C4,$E2,$4D,$08,$11                               ] , 'vpsignb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(403, [$C4,$E2,$4D,$08,$11                               ] , 'vpsignb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(404, [$C4,$E2,$4D,$09,$D4                               ] , 'vpsignw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(405, [$C4,$E2,$4D,$09,$11                               ] , 'vpsignw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(406, [$C4,$E2,$4D,$09,$11                               ] , 'vpsignw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(407, [$C4,$E2,$4D,$0A,$D4                               ] , 'vpsignd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(408, [$C4,$E2,$4D,$0A,$11                               ] , 'vpsignd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(409, [$C4,$E2,$4D,$0A,$11                               ] , 'vpsignd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(410, [$C5,$CD,$F8,$D4                                   ] , 'vpsubb  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(411, [$C5,$CD,$F8,$11                                   ] , 'vpsubb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(412, [$C5,$CD,$F8,$11                                   ] , 'vpsubb  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(413, [$C5,$CD,$F9,$D4                                   ] , 'vpsubw  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(414, [$C5,$CD,$F9,$11                                   ] , 'vpsubw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(415, [$C5,$CD,$F9,$11                                   ] , 'vpsubw  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(416, [$C5,$CD,$FA,$D4                                   ] , 'vpsubd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(417, [$C5,$CD,$FA,$11                                   ] , 'vpsubd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(418, [$C5,$CD,$FA,$11                                   ] , 'vpsubd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(419, [$C5,$CD,$FB,$D4                                   ] , 'vpsubq  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(420, [$C5,$CD,$FB,$11                                   ] , 'vpsubq  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(421, [$C5,$CD,$FB,$11                                   ] , 'vpsubq  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(422, [$C5,$CD,$E8,$D4                                   ] , 'vpsubsb  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(423, [$C5,$CD,$E8,$11                                   ] , 'vpsubsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(424, [$C5,$CD,$E8,$11                                   ] , 'vpsubsb  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(425, [$C5,$CD,$E9,$D4                                   ] , 'vpsubsw  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(426, [$C5,$CD,$E9,$11                                   ] , 'vpsubsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(427, [$C5,$CD,$E9,$11                                   ] , 'vpsubsw  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(428, [$C5,$CD,$D8,$D4                                   ] , 'vpsubusb  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(429, [$C5,$CD,$D8,$11                                   ] , 'vpsubusb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(430, [$C5,$CD,$D8,$11                                   ] , 'vpsubusb  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(431, [$C5,$CD,$D9,$D4                                   ] , 'vpsubusw  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(432, [$C5,$CD,$D9,$11                                   ] , 'vpsubusw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(433, [$C5,$CD,$D9,$11                                   ] , 'vpsubusw  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(434, [$C5,$CD,$68,$D4                                   ] , 'vpunpckhbw  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(435, [$C5,$CD,$68,$11                                   ] , 'vpunpckhbw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(436, [$C5,$CD,$68,$11                                   ] , 'vpunpckhbw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(437, [$C5,$CD,$69,$D4                                   ] , 'vpunpckhwd  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(438, [$C5,$CD,$69,$11                                   ] , 'vpunpckhwd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(439, [$C5,$CD,$69,$11                                   ] , 'vpunpckhwd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(440, [$C5,$CD,$6A,$D4                                   ] , 'vpunpckhdq  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(441, [$C5,$CD,$6A,$11                                   ] , 'vpunpckhdq  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(442, [$C5,$CD,$6A,$11                                   ] , 'vpunpckhdq  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(443, [$C5,$CD,$6D,$D4                                   ] , 'vpunpckhqdq  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(444, [$C5,$CD,$6D,$11                                   ] , 'vpunpckhqdq  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(445, [$C5,$CD,$6D,$11                                   ] , 'vpunpckhqdq  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(446, [$C5,$CD,$60,$D4                                   ] , 'vpunpcklbw  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(447, [$C5,$CD,$60,$11                                   ] , 'vpunpcklbw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(448, [$C5,$CD,$60,$11                                   ] , 'vpunpcklbw  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(449, [$C5,$CD,$61,$D4                                   ] , 'vpunpcklwd  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(450, [$C5,$CD,$61,$11                                   ] , 'vpunpcklwd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(451, [$C5,$CD,$61,$11                                   ] , 'vpunpcklwd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(452, [$C5,$CD,$62,$D4                                   ] , 'vpunpckldq  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(453, [$C5,$CD,$62,$11                                   ] , 'vpunpckldq  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(454, [$C5,$CD,$62,$11                                   ] , 'vpunpckldq  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(455, [$C5,$CD,$6C,$D4                                   ] , 'vpunpcklqdq  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(456, [$C5,$CD,$6C,$11                                   ] , 'vpunpcklqdq  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(457, [$C5,$CD,$6C,$11                                   ] , 'vpunpcklqdq  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(458, [$C5,$CD,$EF,$D4                                   ] , 'vpxor  ymm2,ymm6,ymm4'                            );
  TestCase.testcase(459, [$C5,$CD,$EF,$11                                   ] , 'vpxor  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(460, [$C5,$CD,$EF,$11                                   ] , 'vpxor  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(461, [$C4,$E2,$7D,$1C,$F4                               ] , 'vpabsb  ymm6,ymm4'                                );
  TestCase.testcase(462, [$C4,$E2,$7D,$1C,$21                               ] , 'vpabsb  ymm4,yword [ecx]'                         );
  TestCase.testcase(463, [$C4,$E2,$7D,$1C,$21                               ] , 'vpabsb  ymm4,yword [ecx]'                         );
  TestCase.testcase(464, [$C4,$E2,$7D,$1D,$F4                               ] , 'vpabsw  ymm6,ymm4'                                );
  TestCase.testcase(465, [$C4,$E2,$7D,$1D,$21                               ] , 'vpabsw  ymm4,yword [ecx]'                         );
  TestCase.testcase(466, [$C4,$E2,$7D,$1D,$21                               ] , 'vpabsw  ymm4,yword [ecx]'                         );
  TestCase.testcase(467, [$C4,$E2,$7D,$1E,$F4                               ] , 'vpabsd  ymm6,ymm4'                                );
  TestCase.testcase(468, [$C4,$E2,$7D,$1E,$21                               ] , 'vpabsd  ymm4,yword [ecx]'                         );
  TestCase.testcase(469, [$C4,$E2,$7D,$1E,$21                               ] , 'vpabsd  ymm4,yword [ecx]'                         );
  TestCase.testcase(470, [$C4,$E3,$4D,$42,$D4,$07                           ] , 'vmpsadbw  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(471, [$C4,$E3,$4D,$42,$11,$07                           ] , 'vmpsadbw  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(472, [$C4,$E3,$4D,$42,$11,$07                           ] , 'vmpsadbw  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(473, [$C4,$E3,$4D,$0F,$D4,$07                           ] , 'vpalignr  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(474, [$C4,$E3,$4D,$0F,$11,$07                           ] , 'vpalignr  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(475, [$C4,$E3,$4D,$0F,$11,$07                           ] , 'vpalignr  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(476, [$C4,$E3,$4D,$0E,$D4,$07                           ] , 'vpblendw  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(477, [$C4,$E3,$4D,$0E,$11,$07                           ] , 'vpblendw  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(478, [$C4,$E3,$4D,$0E,$11,$07                           ] , 'vpblendw  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(479, [$C4,$E3,$6D,$4C,$FE,$40                           ] , 'vpblendvb  ymm7,ymm2,ymm6,ymm4'                   );
  TestCase.testcase(480, [$C4,$E3,$6D,$4C,$39,$40                           ] , 'vpblendvb  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(481, [$C4,$E3,$6D,$4C,$39,$40                           ] , 'vpblendvb  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(482, [$C5,$CD,$F1,$D4                                   ] , 'vpsllw  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(483, [$C5,$CD,$F1,$11                                   ] , 'vpsllw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(484, [$C5,$CD,$F1,$11                                   ] , 'vpsllw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(485, [$C5,$CD,$F2,$D4                                   ] , 'vpslld  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(486, [$C5,$CD,$F2,$11                                   ] , 'vpslld  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(487, [$C5,$CD,$F2,$11                                   ] , 'vpslld  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(488, [$C5,$CD,$F3,$D4                                   ] , 'vpsllq  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(489, [$C5,$CD,$F3,$11                                   ] , 'vpsllq  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(490, [$C5,$CD,$F3,$11                                   ] , 'vpsllq  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(491, [$C5,$CD,$E1,$D4                                   ] , 'vpsraw  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(492, [$C5,$CD,$E1,$11                                   ] , 'vpsraw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(493, [$C5,$CD,$E1,$11                                   ] , 'vpsraw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(494, [$C5,$CD,$E2,$D4                                   ] , 'vpsrad  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(495, [$C5,$CD,$E2,$11                                   ] , 'vpsrad  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(496, [$C5,$CD,$E2,$11                                   ] , 'vpsrad  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(497, [$C5,$CD,$D1,$D4                                   ] , 'vpsrlw  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(498, [$C5,$CD,$D1,$11                                   ] , 'vpsrlw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(499, [$C5,$CD,$D1,$11                                   ] , 'vpsrlw  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(500, [$C5,$CD,$D2,$D4                                   ] , 'vpsrld  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(501, [$C5,$CD,$D2,$11                                   ] , 'vpsrld  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(502, [$C5,$CD,$D2,$11                                   ] , 'vpsrld  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(503, [$C5,$CD,$D3,$D4                                   ] , 'vpsrlq  ymm2,ymm6,xmm4'                           );
  TestCase.testcase(504, [$C5,$CD,$D3,$11                                   ] , 'vpsrlq  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(505, [$C5,$CD,$D3,$11                                   ] , 'vpsrlq  ymm2,ymm6,oword [ecx]'                    );
  TestCase.testcase(506, [$C4,$E2,$7D,$20,$E4                               ] , 'vpmovsxbw  ymm4,xmm4'                             );
  TestCase.testcase(507, [$C4,$E2,$7D,$20,$21                               ] , 'vpmovsxbw  ymm4,oword [ecx]'                      );
  TestCase.testcase(508, [$C4,$E2,$7D,$20,$21                               ] , 'vpmovsxbw  ymm4,oword [ecx]'                      );
  TestCase.testcase(509, [$C4,$E2,$7D,$23,$E4                               ] , 'vpmovsxwd  ymm4,xmm4'                             );
  TestCase.testcase(510, [$C4,$E2,$7D,$23,$21                               ] , 'vpmovsxwd  ymm4,oword [ecx]'                      );
  TestCase.testcase(511, [$C4,$E2,$7D,$23,$21                               ] , 'vpmovsxwd  ymm4,oword [ecx]'                      );
  TestCase.testcase(512, [$C4,$E2,$7D,$25,$E4                               ] , 'vpmovsxdq  ymm4,xmm4'                             );
  TestCase.testcase(513, [$C4,$E2,$7D,$25,$21                               ] , 'vpmovsxdq  ymm4,oword [ecx]'                      );
  TestCase.testcase(514, [$C4,$E2,$7D,$25,$21                               ] , 'vpmovsxdq  ymm4,oword [ecx]'                      );
  TestCase.testcase(515, [$C4,$E2,$7D,$30,$E4                               ] , 'vpmovzxbw  ymm4,xmm4'                             );
  TestCase.testcase(516, [$C4,$E2,$7D,$30,$21                               ] , 'vpmovzxbw  ymm4,oword [ecx]'                      );
  TestCase.testcase(517, [$C4,$E2,$7D,$30,$21                               ] , 'vpmovzxbw  ymm4,oword [ecx]'                      );
  TestCase.testcase(518, [$C4,$E2,$7D,$33,$E4                               ] , 'vpmovzxwd  ymm4,xmm4'                             );
  TestCase.testcase(519, [$C4,$E2,$7D,$33,$21                               ] , 'vpmovzxwd  ymm4,oword [ecx]'                      );
  TestCase.testcase(520, [$C4,$E2,$7D,$33,$21                               ] , 'vpmovzxwd  ymm4,oword [ecx]'                      );
  TestCase.testcase(521, [$C4,$E2,$7D,$35,$E4                               ] , 'vpmovzxdq  ymm4,xmm4'                             );
  TestCase.testcase(522, [$C4,$E2,$7D,$35,$21                               ] , 'vpmovzxdq  ymm4,oword [ecx]'                      );
  TestCase.testcase(523, [$C4,$E2,$7D,$35,$21                               ] , 'vpmovzxdq  ymm4,oword [ecx]'                      );
  TestCase.testcase(524, [$C4,$E2,$7D,$21,$F4                               ] , 'vpmovsxbd  ymm6,xmm4'                             );
  TestCase.testcase(525, [$C4,$E2,$7D,$21,$21                               ] , 'vpmovsxbd  ymm4,qword [ecx]'                      );
  TestCase.testcase(526, [$C4,$E2,$7D,$21,$21                               ] , 'vpmovsxbd  ymm4,qword [ecx]'                      );
  TestCase.testcase(527, [$C4,$E2,$7D,$24,$F4                               ] , 'vpmovsxwq  ymm6,xmm4'                             );
  TestCase.testcase(528, [$C4,$E2,$7D,$24,$21                               ] , 'vpmovsxwq  ymm4,qword [ecx]'                      );
  TestCase.testcase(529, [$C4,$E2,$7D,$24,$21                               ] , 'vpmovsxwq  ymm4,qword [ecx]'                      );
  TestCase.testcase(530, [$C4,$E2,$7D,$31,$F4                               ] , 'vpmovzxbd  ymm6,xmm4'                             );
  TestCase.testcase(531, [$C4,$E2,$7D,$31,$21                               ] , 'vpmovzxbd  ymm4,qword [ecx]'                      );
  TestCase.testcase(532, [$C4,$E2,$7D,$31,$21                               ] , 'vpmovzxbd  ymm4,qword [ecx]'                      );
  TestCase.testcase(533, [$C4,$E2,$7D,$34,$F4                               ] , 'vpmovzxwq  ymm6,xmm4'                             );
  TestCase.testcase(534, [$C4,$E2,$7D,$34,$21                               ] , 'vpmovzxwq  ymm4,qword [ecx]'                      );
  TestCase.testcase(535, [$C4,$E2,$7D,$34,$21                               ] , 'vpmovzxwq  ymm4,qword [ecx]'                      );
  TestCase.testcase(536, [$C4,$E2,$7D,$22,$E4                               ] , 'vpmovsxbq  ymm4,xmm4'                             );
  TestCase.testcase(537, [$C4,$E2,$7D,$22,$21                               ] , 'vpmovsxbq  ymm4,dword [ecx]'                      );
  TestCase.testcase(538, [$C4,$E2,$7D,$22,$21                               ] , 'vpmovsxbq  ymm4,dword [ecx]'                      );
  TestCase.testcase(539, [$C4,$E2,$7D,$32,$E4                               ] , 'vpmovzxbq  ymm4,xmm4'                             );
  TestCase.testcase(540, [$C4,$E2,$7D,$32,$21                               ] , 'vpmovzxbq  ymm4,dword [ecx]'                      );
  TestCase.testcase(541, [$C4,$E2,$7D,$32,$21                               ] , 'vpmovzxbq  ymm4,dword [ecx]'                      );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x32.avx256int.log');
end;

end.