unit x32.avx;

// This unit was generated by d2p.pl script.
// Source : gas/avx-intel.d

interface

uses
  uTestCase,
  UnivDisasm.Cnsts;

procedure Test();

implementation

procedure Test();
var
  TestCase:TTestCase;
begin
  TestCase := TTestCase.Create('x32.avx');
  TestCase.Start();	
  TestCase.Arch := CPUX32;

  TestCase.testcase(0, [$C5,$FC,$77                                       ] , 'vzeroall'                                         );
  TestCase.testcase(1, [$C5,$F8,$77                                       ] , 'vzeroupper'                                       );
  TestCase.testcase(2, [$C5,$F8,$AE,$11                                   ] , 'vldmxcsr  dword [ecx]'                            );
  TestCase.testcase(3, [$C5,$F8,$AE,$19                                   ] , 'vstmxcsr  dword [ecx]'                            );
  TestCase.testcase(4, [$C4,$E2,$5D,$2D,$31                               ] , 'vmaskmovpd  ymm6,ymm4,yword [ecx]'                );
  TestCase.testcase(5, [$C4,$E2,$4D,$2F,$21                               ] , 'vmaskmovpd  yword [ecx],ymm6,ymm4'                );
  TestCase.testcase(6, [$C4,$E2,$5D,$2C,$31                               ] , 'vmaskmovps  ymm6,ymm4,yword [ecx]'                );
  TestCase.testcase(7, [$C4,$E2,$4D,$2E,$21                               ] , 'vmaskmovps  yword [ecx],ymm6,ymm4'                );
  TestCase.testcase(8, [$C4,$E3,$7D,$05,$D6,$07                           ] , 'vpermilpd  ymm2,ymm6,0x7'                         );
  TestCase.testcase(9, [$C4,$E3,$7D,$05,$31,$07                           ] , 'vpermilpd  ymm6,yword [ecx],0x7'                  );
  TestCase.testcase(10, [$C4,$E3,$7D,$04,$D6,$07                           ] , 'vpermilps  ymm2,ymm6,0x7'                         );
  TestCase.testcase(11, [$C4,$E3,$7D,$04,$31,$07                           ] , 'vpermilps  ymm6,yword [ecx],0x7'                  );
  TestCase.testcase(12, [$C4,$E3,$7D,$09,$D6,$07                           ] , 'vroundpd  ymm2,ymm6,0x7'                          );
  TestCase.testcase(13, [$C4,$E3,$7D,$09,$31,$07                           ] , 'vroundpd  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(14, [$C4,$E3,$7D,$08,$D6,$07                           ] , 'vroundps  ymm2,ymm6,0x7'                          );
  TestCase.testcase(15, [$C4,$E3,$7D,$08,$31,$07                           ] , 'vroundps  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(16, [$C5,$CD,$58,$D4                                   ] , 'vaddpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(17, [$C5,$CD,$58,$11                                   ] , 'vaddpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(18, [$C5,$CC,$58,$D4                                   ] , 'vaddps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(19, [$C5,$CC,$58,$11                                   ] , 'vaddps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(20, [$C5,$CD,$D0,$D4                                   ] , 'vaddsubpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(21, [$C5,$CD,$D0,$11                                   ] , 'vaddsubpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(22, [$C5,$CF,$D0,$D4                                   ] , 'vaddsubps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(23, [$C5,$CF,$D0,$11                                   ] , 'vaddsubps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(24, [$C5,$CD,$55,$D4                                   ] , 'vandnpd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(25, [$C5,$CD,$55,$11                                   ] , 'vandnpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(26, [$C5,$CC,$55,$D4                                   ] , 'vandnps  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(27, [$C5,$CC,$55,$11                                   ] , 'vandnps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(28, [$C5,$CD,$54,$D4                                   ] , 'vandpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(29, [$C5,$CD,$54,$11                                   ] , 'vandpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(30, [$C5,$CC,$54,$D4                                   ] , 'vandps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(31, [$C5,$CC,$54,$11                                   ] , 'vandps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(32, [$C5,$CD,$5E,$D4                                   ] , 'vdivpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(33, [$C5,$CD,$5E,$11                                   ] , 'vdivpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(34, [$C5,$CC,$5E,$D4                                   ] , 'vdivps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(35, [$C5,$CC,$5E,$11                                   ] , 'vdivps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(36, [$C5,$CD,$7C,$D4                                   ] , 'vhaddpd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(37, [$C5,$CD,$7C,$11                                   ] , 'vhaddpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(38, [$C5,$CF,$7C,$D4                                   ] , 'vhaddps  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(39, [$C5,$CF,$7C,$11                                   ] , 'vhaddps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(40, [$C5,$CD,$7D,$D4                                   ] , 'vhsubpd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(41, [$C5,$CD,$7D,$11                                   ] , 'vhsubpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(42, [$C5,$CF,$7D,$D4                                   ] , 'vhsubps  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(43, [$C5,$CF,$7D,$11                                   ] , 'vhsubps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(44, [$C5,$CD,$5F,$D4                                   ] , 'vmaxpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(45, [$C5,$CD,$5F,$11                                   ] , 'vmaxpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(46, [$C5,$CC,$5F,$D4                                   ] , 'vmaxps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(47, [$C5,$CC,$5F,$11                                   ] , 'vmaxps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(48, [$C5,$CD,$5D,$D4                                   ] , 'vminpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(49, [$C5,$CD,$5D,$11                                   ] , 'vminpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(50, [$C5,$CC,$5D,$D4                                   ] , 'vminps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(51, [$C5,$CC,$5D,$11                                   ] , 'vminps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(52, [$C5,$CD,$59,$D4                                   ] , 'vmulpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(53, [$C5,$CD,$59,$11                                   ] , 'vmulpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(54, [$C5,$CC,$59,$D4                                   ] , 'vmulps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(55, [$C5,$CC,$59,$11                                   ] , 'vmulps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(56, [$C5,$CD,$56,$D4                                   ] , 'vorpd  ymm2,ymm6,ymm4'                            );
  TestCase.testcase(57, [$C5,$CD,$56,$11                                   ] , 'vorpd  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(58, [$C5,$CC,$56,$D4                                   ] , 'vorps  ymm2,ymm6,ymm4'                            );
  TestCase.testcase(59, [$C5,$CC,$56,$11                                   ] , 'vorps  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(60, [$C4,$E2,$4D,$0D,$D4                               ] , 'vpermilpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(61, [$C4,$E2,$4D,$0D,$11                               ] , 'vpermilpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(62, [$C4,$E2,$4D,$0C,$D4                               ] , 'vpermilps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(63, [$C4,$E2,$4D,$0C,$11                               ] , 'vpermilps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(64, [$C5,$CD,$5C,$D4                                   ] , 'vsubpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(65, [$C5,$CD,$5C,$11                                   ] , 'vsubpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(66, [$C5,$CC,$5C,$D4                                   ] , 'vsubps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(67, [$C5,$CC,$5C,$11                                   ] , 'vsubps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(68, [$C5,$CD,$15,$D4                                   ] , 'vunpckhpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(69, [$C5,$CD,$15,$11                                   ] , 'vunpckhpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(70, [$C5,$CC,$15,$D4                                   ] , 'vunpckhps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(71, [$C5,$CC,$15,$11                                   ] , 'vunpckhps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(72, [$C5,$CD,$14,$D4                                   ] , 'vunpcklpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(73, [$C5,$CD,$14,$11                                   ] , 'vunpcklpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(74, [$C5,$CC,$14,$D4                                   ] , 'vunpcklps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(75, [$C5,$CC,$14,$11                                   ] , 'vunpcklps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(76, [$C5,$CD,$57,$D4                                   ] , 'vxorpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(77, [$C5,$CD,$57,$11                                   ] , 'vxorpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(78, [$C5,$CC,$57,$D4                                   ] , 'vxorps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(79, [$C5,$CC,$57,$11                                   ] , 'vxorps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(80, [$C5,$CD,$C2,$D4,$00                               ] , 'vcmpeqpd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(81, [$C5,$CD,$C2,$11,$00                               ] , 'vcmpeqpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(82, [$C5,$CD,$C2,$D4,$01                               ] , 'vcmpltpd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(83, [$C5,$CD,$C2,$11,$01                               ] , 'vcmpltpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(84, [$C5,$CD,$C2,$D4,$02                               ] , 'vcmplepd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(85, [$C5,$CD,$C2,$11,$02                               ] , 'vcmplepd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(86, [$C5,$CD,$C2,$D4,$03                               ] , 'vcmpunordpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(87, [$C5,$CD,$C2,$11,$03                               ] , 'vcmpunordpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(88, [$C5,$CD,$C2,$D4,$04                               ] , 'vcmpneqpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(89, [$C5,$CD,$C2,$11,$04                               ] , 'vcmpneqpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(90, [$C5,$CD,$C2,$D4,$05                               ] , 'vcmpnltpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(91, [$C5,$CD,$C2,$11,$05                               ] , 'vcmpnltpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(92, [$C5,$CD,$C2,$D4,$06                               ] , 'vcmpnlepd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(93, [$C5,$CD,$C2,$11,$06                               ] , 'vcmpnlepd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(94, [$C5,$CD,$C2,$D4,$07                               ] , 'vcmpordpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(95, [$C5,$CD,$C2,$11,$07                               ] , 'vcmpordpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(96, [$C5,$CD,$C2,$D4,$08                               ] , 'vcmpeq_uqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(97, [$C5,$CD,$C2,$11,$08                               ] , 'vcmpeq_uqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(98, [$C5,$CD,$C2,$D4,$09                               ] , 'vcmpngepd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(99, [$C5,$CD,$C2,$11,$09                               ] , 'vcmpngepd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(100, [$C5,$CD,$C2,$D4,$0A                               ] , 'vcmpngtpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(101, [$C5,$CD,$C2,$11,$0A                               ] , 'vcmpngtpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(102, [$C5,$CD,$C2,$D4,$0B                               ] , 'vcmpfalsepd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(103, [$C5,$CD,$C2,$11,$0B                               ] , 'vcmpfalsepd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(104, [$C5,$CD,$C2,$D4,$0C                               ] , 'vcmpneq_oqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(105, [$C5,$CD,$C2,$11,$0C                               ] , 'vcmpneq_oqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(106, [$C5,$CD,$C2,$D4,$0D                               ] , 'vcmpgepd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(107, [$C5,$CD,$C2,$11,$0D                               ] , 'vcmpgepd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(108, [$C5,$CD,$C2,$D4,$0E                               ] , 'vcmpgtpd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(109, [$C5,$CD,$C2,$11,$0E                               ] , 'vcmpgtpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(110, [$C5,$CD,$C2,$D4,$0F                               ] , 'vcmuepd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(111, [$C5,$CD,$C2,$11,$0F                               ] , 'vcmuepd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(112, [$C5,$CD,$C2,$D4,$10                               ] , 'vcmpeq_ospd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(113, [$C5,$CD,$C2,$11,$10                               ] , 'vcmpeq_ospd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(114, [$C5,$CD,$C2,$D4,$11                               ] , 'vcmplt_oqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(115, [$C5,$CD,$C2,$11,$11                               ] , 'vcmplt_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(116, [$C5,$CD,$C2,$D4,$12                               ] , 'vcmple_oqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(117, [$C5,$CD,$C2,$11,$12                               ] , 'vcmple_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(118, [$C5,$CD,$C2,$D4,$13                               ] , 'vcmpunord_spd  ymm2,ymm6,ymm4'                    );
  TestCase.testcase(119, [$C5,$CD,$C2,$11,$13                               ] , 'vcmpunord_spd  ymm2,ymm6,yword [ecx]'             );
  TestCase.testcase(120, [$C5,$CD,$C2,$D4,$14                               ] , 'vcmpneq_uspd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(121, [$C5,$CD,$C2,$11,$14                               ] , 'vcmpneq_uspd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(122, [$C5,$CD,$C2,$D4,$15                               ] , 'vcmpnlt_uqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(123, [$C5,$CD,$C2,$11,$15                               ] , 'vcmpnlt_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(124, [$C5,$CD,$C2,$D4,$16                               ] , 'vcmpnle_uqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(125, [$C5,$CD,$C2,$11,$16                               ] , 'vcmpnle_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(126, [$C5,$CD,$C2,$D4,$17                               ] , 'vcmpord_spd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(127, [$C5,$CD,$C2,$11,$17                               ] , 'vcmpord_spd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(128, [$C5,$CD,$C2,$D4,$18                               ] , 'vcmpeq_uspd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(129, [$C5,$CD,$C2,$11,$18                               ] , 'vcmpeq_uspd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(130, [$C5,$CD,$C2,$D4,$19                               ] , 'vcmpnge_uqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(131, [$C5,$CD,$C2,$11,$19                               ] , 'vcmpnge_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(132, [$C5,$CD,$C2,$D4,$1A                               ] , 'vcmpngt_uqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(133, [$C5,$CD,$C2,$11,$1A                               ] , 'vcmpngt_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(134, [$C5,$CD,$C2,$D4,$1B                               ] , 'vcmpfalse_ospd  ymm2,ymm6,ymm4'                   );
  TestCase.testcase(135, [$C5,$CD,$C2,$11,$1B                               ] , 'vcmpfalse_ospd  ymm2,ymm6,yword [ecx]'            );
  TestCase.testcase(136, [$C5,$CD,$C2,$D4,$1C                               ] , 'vcmpneq_ospd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(137, [$C5,$CD,$C2,$11,$1C                               ] , 'vcmpneq_ospd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(138, [$C5,$CD,$C2,$D4,$1D                               ] , 'vcmpge_oqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(139, [$C5,$CD,$C2,$11,$1D                               ] , 'vcmpge_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(140, [$C5,$CD,$C2,$D4,$1E                               ] , 'vcmpgt_oqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(141, [$C5,$CD,$C2,$11,$1E                               ] , 'vcmpgt_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(142, [$C5,$CD,$C2,$D4,$1F                               ] , 'vcmue_uspd  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(143, [$C5,$CD,$C2,$11,$1F                               ] , 'vcmue_uspd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(144, [$C5,$CC,$C2,$D4,$00                               ] , 'vcmpeqps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(145, [$C5,$CC,$C2,$11,$00                               ] , 'vcmpeqps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(146, [$C5,$CC,$C2,$D4,$01                               ] , 'vcmpltps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(147, [$C5,$CC,$C2,$11,$01                               ] , 'vcmpltps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(148, [$C5,$CC,$C2,$D4,$02                               ] , 'vcmpleps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(149, [$C5,$CC,$C2,$11,$02                               ] , 'vcmpleps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(150, [$C5,$CC,$C2,$D4,$03                               ] , 'vcmpunordps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(151, [$C5,$CC,$C2,$11,$03                               ] , 'vcmpunordps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(152, [$C5,$CC,$C2,$D4,$04                               ] , 'vcmpneqps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(153, [$C5,$CC,$C2,$11,$04                               ] , 'vcmpneqps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(154, [$C5,$CC,$C2,$D4,$05                               ] , 'vcmpnltps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(155, [$C5,$CC,$C2,$11,$05                               ] , 'vcmpnltps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(156, [$C5,$CC,$C2,$D4,$06                               ] , 'vcmpnleps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(157, [$C5,$CC,$C2,$11,$06                               ] , 'vcmpnleps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(158, [$C5,$CC,$C2,$D4,$07                               ] , 'vcmpordps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(159, [$C5,$CC,$C2,$11,$07                               ] , 'vcmpordps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(160, [$C5,$CC,$C2,$D4,$08                               ] , 'vcmpeq_uqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(161, [$C5,$CC,$C2,$11,$08                               ] , 'vcmpeq_uqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(162, [$C5,$CC,$C2,$D4,$09                               ] , 'vcmpngeps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(163, [$C5,$CC,$C2,$11,$09                               ] , 'vcmpngeps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(164, [$C5,$CC,$C2,$D4,$0A                               ] , 'vcmpngtps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(165, [$C5,$CC,$C2,$11,$0A                               ] , 'vcmpngtps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(166, [$C5,$CC,$C2,$D4,$0B                               ] , 'vcmpfalseps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(167, [$C5,$CC,$C2,$11,$0B                               ] , 'vcmpfalseps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(168, [$C5,$CC,$C2,$D4,$0C                               ] , 'vcmpneq_oqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(169, [$C5,$CC,$C2,$11,$0C                               ] , 'vcmpneq_oqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(170, [$C5,$CC,$C2,$D4,$0D                               ] , 'vcmpgeps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(171, [$C5,$CC,$C2,$11,$0D                               ] , 'vcmpgeps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(172, [$C5,$CC,$C2,$D4,$0E                               ] , 'vcmpgtps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(173, [$C5,$CC,$C2,$11,$0E                               ] , 'vcmpgtps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(174, [$C5,$CC,$C2,$D4,$0F                               ] , 'vcmueps  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(175, [$C5,$CC,$C2,$11,$0F                               ] , 'vcmueps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(176, [$C5,$CC,$C2,$D4,$10                               ] , 'vcmpeq_osps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(177, [$C5,$CC,$C2,$11,$10                               ] , 'vcmpeq_osps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(178, [$C5,$CC,$C2,$D4,$11                               ] , 'vcmplt_oqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(179, [$C5,$CC,$C2,$11,$11                               ] , 'vcmplt_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(180, [$C5,$CC,$C2,$D4,$12                               ] , 'vcmple_oqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(181, [$C5,$CC,$C2,$11,$12                               ] , 'vcmple_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(182, [$C5,$CC,$C2,$D4,$13                               ] , 'vcmpunord_sps  ymm2,ymm6,ymm4'                    );
  TestCase.testcase(183, [$C5,$CC,$C2,$11,$13                               ] , 'vcmpunord_sps  ymm2,ymm6,yword [ecx]'             );
  TestCase.testcase(184, [$C5,$CC,$C2,$D4,$14                               ] , 'vcmpneq_usps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(185, [$C5,$CC,$C2,$11,$14                               ] , 'vcmpneq_usps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(186, [$C5,$CC,$C2,$D4,$15                               ] , 'vcmpnlt_uqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(187, [$C5,$CC,$C2,$11,$15                               ] , 'vcmpnlt_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(188, [$C5,$CC,$C2,$D4,$16                               ] , 'vcmpnle_uqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(189, [$C5,$CC,$C2,$11,$16                               ] , 'vcmpnle_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(190, [$C5,$CC,$C2,$D4,$17                               ] , 'vcmpord_sps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(191, [$C5,$CC,$C2,$11,$17                               ] , 'vcmpord_sps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(192, [$C5,$CC,$C2,$D4,$18                               ] , 'vcmpeq_usps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(193, [$C5,$CC,$C2,$11,$18                               ] , 'vcmpeq_usps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(194, [$C5,$CC,$C2,$D4,$19                               ] , 'vcmpnge_uqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(195, [$C5,$CC,$C2,$11,$19                               ] , 'vcmpnge_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(196, [$C5,$CC,$C2,$D4,$1A                               ] , 'vcmpngt_uqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(197, [$C5,$CC,$C2,$11,$1A                               ] , 'vcmpngt_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(198, [$C5,$CC,$C2,$D4,$1B                               ] , 'vcmpfalse_osps  ymm2,ymm6,ymm4'                   );
  TestCase.testcase(199, [$C5,$CC,$C2,$11,$1B                               ] , 'vcmpfalse_osps  ymm2,ymm6,yword [ecx]'            );
  TestCase.testcase(200, [$C5,$CC,$C2,$D4,$1C                               ] , 'vcmpneq_osps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(201, [$C5,$CC,$C2,$11,$1C                               ] , 'vcmpneq_osps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(202, [$C5,$CC,$C2,$D4,$1D                               ] , 'vcmpge_oqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(203, [$C5,$CC,$C2,$11,$1D                               ] , 'vcmpge_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(204, [$C5,$CC,$C2,$D4,$1E                               ] , 'vcmpgt_oqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(205, [$C5,$CC,$C2,$11,$1E                               ] , 'vcmpgt_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(206, [$C5,$CC,$C2,$D4,$1F                               ] , 'vcmue_usps  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(207, [$C5,$CC,$C2,$11,$1F                               ] , 'vcmue_usps  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(208, [$C5,$FF,$E6,$E4                                   ] , 'vcvtpd2dq  xmm4,ymm4'                             );
  TestCase.testcase(209, [$C5,$FF,$E6,$21                                   ] , 'vcvtpd2dq  xmm4,yword [ecx]'                      );
  TestCase.testcase(210, [$C5,$FD,$5A,$E4                                   ] , 'vcvtpd2ps  xmm4,ymm4'                             );
  TestCase.testcase(211, [$C5,$FD,$5A,$21                                   ] , 'vcvtpd2ps  xmm4,yword [ecx]'                      );
  TestCase.testcase(212, [$C5,$FD,$E6,$E4                                   ] , 'vcvttpd2dq  xmm4,ymm4'                            );
  TestCase.testcase(213, [$C5,$FD,$E6,$21                                   ] , 'vcvttpd2dq  xmm4,yword [ecx]'                     );
  TestCase.testcase(214, [$C5,$FC,$5B,$F4                                   ] , 'vcvtdq2ps  ymm6,ymm4'                             );
  TestCase.testcase(215, [$C5,$FC,$5B,$21                                   ] , 'vcvtdq2ps  ymm4,yword [ecx]'                      );
  TestCase.testcase(216, [$C5,$FD,$5B,$F4                                   ] , 'vcvtps2dq  ymm6,ymm4'                             );
  TestCase.testcase(217, [$C5,$FD,$5B,$21                                   ] , 'vcvtps2dq  ymm4,yword [ecx]'                      );
  TestCase.testcase(218, [$C5,$FE,$5B,$F4                                   ] , 'vcvttps2dq  ymm6,ymm4'                            );
  TestCase.testcase(219, [$C5,$FE,$5B,$21                                   ] , 'vcvttps2dq  ymm4,yword [ecx]'                     );
  TestCase.testcase(220, [$C5,$FD,$28,$F4                                   ] , 'vmovapd  ymm6,ymm4'                               );
  TestCase.testcase(221, [$C5,$FD,$28,$21                                   ] , 'vmovapd  ymm4,yword [ecx]'                        );
  TestCase.testcase(222, [$C5,$FC,$28,$F4                                   ] , 'vmovaps  ymm6,ymm4'                               );
  TestCase.testcase(223, [$C5,$FC,$28,$21                                   ] , 'vmovaps  ymm4,yword [ecx]'                        );
  TestCase.testcase(224, [$C5,$FD,$6F,$F4                                   ] , 'vmovdqa  ymm6,ymm4'                               );
  TestCase.testcase(225, [$C5,$FD,$6F,$21                                   ] , 'vmovdqa  ymm4,yword [ecx]'                        );
  TestCase.testcase(226, [$C5,$FE,$6F,$F4                                   ] , 'vmovdqu  ymm6,ymm4'                               );
  TestCase.testcase(227, [$C5,$FE,$6F,$21                                   ] , 'vmovdqu  ymm4,yword [ecx]'                        );
  TestCase.testcase(228, [$C5,$FF,$12,$F4                                   ] , 'vmovddup  ymm6,ymm4'                              );
  TestCase.testcase(229, [$C5,$FF,$12,$21                                   ] , 'vmovddup  ymm4,yword [ecx]'                       );
  TestCase.testcase(230, [$C5,$FE,$16,$F4                                   ] , 'vmovshdup  ymm6,ymm4'                             );
  TestCase.testcase(231, [$C5,$FE,$16,$21                                   ] , 'vmovshdup  ymm4,yword [ecx]'                      );
  TestCase.testcase(232, [$C5,$FE,$12,$F4                                   ] , 'vmovsldup  ymm6,ymm4'                             );
  TestCase.testcase(233, [$C5,$FE,$12,$21                                   ] , 'vmovsldup  ymm4,yword [ecx]'                      );
  TestCase.testcase(234, [$C5,$FD,$10,$F4                                   ] , 'vmovupd  ymm6,ymm4'                               );
  TestCase.testcase(235, [$C5,$FD,$10,$21                                   ] , 'vmovupd  ymm4,yword [ecx]'                        );
  TestCase.testcase(236, [$C5,$FC,$10,$F4                                   ] , 'vmovups  ymm6,ymm4'                               );
  TestCase.testcase(237, [$C5,$FC,$10,$21                                   ] , 'vmovups  ymm4,yword [ecx]'                        );
  TestCase.testcase(238, [$C4,$E2,$7D,$17,$F4                               ] , 'vptest  ymm6,ymm4'                                );
  TestCase.testcase(239, [$C4,$E2,$7D,$17,$21                               ] , 'vptest  ymm4,yword [ecx]'                         );
  TestCase.testcase(240, [$C5,$FC,$53,$F4                                   ] , 'vrcpps  ymm6,ymm4'                                );
  TestCase.testcase(241, [$C5,$FC,$53,$21                                   ] , 'vrcpps  ymm4,yword [ecx]'                         );
  TestCase.testcase(242, [$C5,$FC,$52,$F4                                   ] , 'vrsqrtps  ymm6,ymm4'                              );
  TestCase.testcase(243, [$C5,$FC,$52,$21                                   ] , 'vrsqrtps  ymm4,yword [ecx]'                       );
  TestCase.testcase(244, [$C5,$FD,$51,$F4                                   ] , 'vsqrtpd  ymm6,ymm4'                               );
  TestCase.testcase(245, [$C5,$FD,$51,$21                                   ] , 'vsqrtpd  ymm4,yword [ecx]'                        );
  TestCase.testcase(246, [$C5,$FC,$51,$F4                                   ] , 'vsqrtps  ymm6,ymm4'                               );
  TestCase.testcase(247, [$C5,$FC,$51,$21                                   ] , 'vsqrtps  ymm4,yword [ecx]'                        );
  TestCase.testcase(248, [$C4,$E2,$7D,$0F,$F4                               ] , 'vtestpd  ymm6,ymm4'                               );
  TestCase.testcase(249, [$C4,$E2,$7D,$0F,$21                               ] , 'vtestpd  ymm4,yword [ecx]'                        );
  TestCase.testcase(250, [$C4,$E2,$7D,$0E,$F4                               ] , 'vtestps  ymm6,ymm4'                               );
  TestCase.testcase(251, [$C4,$E2,$7D,$0E,$21                               ] , 'vtestps  ymm4,yword [ecx]'                        );
  TestCase.testcase(252, [$C5,$FD,$28,$F4                                   ] , 'vmovapd  ymm6,ymm4'                               );
  TestCase.testcase(253, [$C5,$FD,$29,$21                                   ] , 'vmovapd  yword [ecx],ymm4'                        );
  TestCase.testcase(254, [$C5,$FC,$28,$F4                                   ] , 'vmovaps  ymm6,ymm4'                               );
  TestCase.testcase(255, [$C5,$FC,$29,$21                                   ] , 'vmovaps  yword [ecx],ymm4'                        );
  TestCase.testcase(256, [$C5,$FD,$6F,$F4                                   ] , 'vmovdqa  ymm6,ymm4'                               );
  TestCase.testcase(257, [$C5,$FD,$7F,$21                                   ] , 'vmovdqa  yword [ecx],ymm4'                        );
  TestCase.testcase(258, [$C5,$FE,$6F,$F4                                   ] , 'vmovdqu  ymm6,ymm4'                               );
  TestCase.testcase(259, [$C5,$FE,$7F,$21                                   ] , 'vmovdqu  yword [ecx],ymm4'                        );
  TestCase.testcase(260, [$C5,$FD,$10,$F4                                   ] , 'vmovupd  ymm6,ymm4'                               );
  TestCase.testcase(261, [$C5,$FD,$11,$21                                   ] , 'vmovupd  yword [ecx],ymm4'                        );
  TestCase.testcase(262, [$C5,$FC,$10,$F4                                   ] , 'vmovups  ymm6,ymm4'                               );
  TestCase.testcase(263, [$C5,$FC,$11,$21                                   ] , 'vmovups  yword [ecx],ymm4'                        );
  TestCase.testcase(264, [$C5,$FF,$F0,$21                                   ] , 'vlddqu  ymm4,[ecx]'                               );
  TestCase.testcase(265, [$C5,$FD,$E7,$21                                   ] , 'vmovntdq  yword [ecx],ymm4'                       );
  TestCase.testcase(266, [$C5,$FD,$2B,$21                                   ] , 'vmovntpd  yword [ecx],ymm4'                       );
  TestCase.testcase(267, [$C5,$FC,$2B,$21                                   ] , 'vmovntps  yword [ecx],ymm4'                       );
  TestCase.testcase(268, [$C4,$E3,$4D,$0D,$D4,$07                           ] , 'vblendpd  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(269, [$C4,$E3,$4D,$0D,$11,$07                           ] , 'vblendpd  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(270, [$C4,$E3,$4D,$0C,$D4,$07                           ] , 'vblendps  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(271, [$C4,$E3,$4D,$0C,$11,$07                           ] , 'vblendps  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(272, [$C5,$CD,$C2,$D4,$07                               ] , 'vcmpordpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(273, [$C5,$CD,$C2,$11,$07                               ] , 'vcmpordpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(274, [$C5,$CC,$C2,$D4,$07                               ] , 'vcmpordps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(275, [$C5,$CC,$C2,$11,$07                               ] , 'vcmpordps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(276, [$C4,$E3,$4D,$40,$D4,$07                           ] , 'vdpps  ymm2,ymm6,ymm4,0x7'                        );
  TestCase.testcase(277, [$C4,$E3,$4D,$40,$11,$07                           ] , 'vdpps  ymm2,ymm6,yword [ecx],0x7'                 );
  TestCase.testcase(278, [$C4,$E3,$4D,$06,$D4,$07                           ] , 'vperm2f128  ymm2,ymm6,ymm4,0x7'                   );
  TestCase.testcase(279, [$C4,$E3,$4D,$06,$11,$07                           ] , 'vperm2f128  ymm2,ymm6,yword [ecx],0x7'            );
  TestCase.testcase(280, [$C5,$CD,$C6,$D4,$07                               ] , 'vshufpd  ymm2,ymm6,ymm4,0x7'                      );
  TestCase.testcase(281, [$C5,$CD,$C6,$11,$07                               ] , 'vshufpd  ymm2,ymm6,yword [ecx],0x7'               );
  TestCase.testcase(282, [$C5,$CC,$C6,$D4,$07                               ] , 'vshufps  ymm2,ymm6,ymm4,0x7'                      );
  TestCase.testcase(283, [$C5,$CC,$C6,$11,$07                               ] , 'vshufps  ymm2,ymm6,yword [ecx],0x7'               );
  TestCase.testcase(284, [$C4,$E3,$6D,$4B,$FE,$40                           ] , 'vblendvpd  ymm7,ymm2,ymm6,ymm4'                   );
  TestCase.testcase(285, [$C4,$E3,$6D,$4B,$39,$40                           ] , 'vblendvpd  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(286, [$C4,$E3,$6D,$4A,$FE,$40                           ] , 'vblendvps  ymm7,ymm2,ymm6,ymm4'                   );
  TestCase.testcase(287, [$C4,$E3,$6D,$4A,$39,$40                           ] , 'vblendvps  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(288, [$C4,$E3,$5D,$18,$F4,$07                           ] , 'vinsertf128  ymm6,ymm4,xmm4,0x7'                  );
  TestCase.testcase(289, [$C4,$E3,$5D,$18,$31,$07                           ] , 'vinsertf128  ymm6,ymm4,oword [ecx],0x7'           );
  TestCase.testcase(290, [$C4,$E3,$7D,$19,$E4,$07                           ] , 'vextractf128  xmm4,ymm4,0x7'                      );
  TestCase.testcase(291, [$C4,$E3,$7D,$19,$21,$07                           ] , 'vextractf128  oword [ecx],ymm4,0x7'               );
  TestCase.testcase(292, [$C4,$E2,$7D,$1A,$21                               ] , 'vbroadcastf128  ymm4,oword [ecx]'                 );
  TestCase.testcase(293, [$C5,$F8,$5B,$F4                                   ] , 'vcvtdq2ps  xmm6,xmm4'                             );
  TestCase.testcase(294, [$C5,$F8,$5B,$21                                   ] , 'vcvtdq2ps  xmm4,oword [ecx]'                      );
  TestCase.testcase(295, [$C5,$FB,$E6,$F4                                   ] , 'vcvtpd2dq  xmm6,xmm4'                             );
  TestCase.testcase(296, [$C5,$FB,$E6,$21                                   ] , 'vcvtpd2dq  xmm4,oword [ecx]'                      );
  TestCase.testcase(297, [$C5,$F9,$5A,$F4                                   ] , 'vcvtpd2ps  xmm6,xmm4'                             );
  TestCase.testcase(298, [$C5,$F9,$5A,$21                                   ] , 'vcvtpd2ps  xmm4,oword [ecx]'                      );
  TestCase.testcase(299, [$C5,$F9,$5B,$F4                                   ] , 'vcvtps2dq  xmm6,xmm4'                             );
  TestCase.testcase(300, [$C5,$F9,$5B,$21                                   ] , 'vcvtps2dq  xmm4,oword [ecx]'                      );
  TestCase.testcase(301, [$C5,$F9,$E6,$F4                                   ] , 'vcvttpd2dq  xmm6,xmm4'                            );
  TestCase.testcase(302, [$C5,$F9,$E6,$21                                   ] , 'vcvttpd2dq  xmm4,oword [ecx]'                     );
  TestCase.testcase(303, [$C5,$FA,$5B,$F4                                   ] , 'vcvttps2dq  xmm6,xmm4'                            );
  TestCase.testcase(304, [$C5,$FA,$5B,$21                                   ] , 'vcvttps2dq  xmm4,oword [ecx]'                     );
  TestCase.testcase(305, [$C5,$F9,$28,$F4                                   ] , 'vmovapd  xmm6,xmm4'                               );
  TestCase.testcase(306, [$C5,$F9,$28,$21                                   ] , 'vmovapd  xmm4,oword [ecx]'                        );
  TestCase.testcase(307, [$C5,$F8,$28,$F4                                   ] , 'vmovaps  xmm6,xmm4'                               );
  TestCase.testcase(308, [$C5,$F8,$28,$21                                   ] , 'vmovaps  xmm4,oword [ecx]'                        );
  TestCase.testcase(309, [$C5,$F9,$6F,$F4                                   ] , 'vmovdqa  xmm6,xmm4'                               );
  TestCase.testcase(310, [$C5,$F9,$6F,$21                                   ] , 'vmovdqa  xmm4,oword [ecx]'                        );
  TestCase.testcase(311, [$C5,$FA,$6F,$F4                                   ] , 'vmovdqu  xmm6,xmm4'                               );
  TestCase.testcase(312, [$C5,$FA,$6F,$21                                   ] , 'vmovdqu  xmm4,oword [ecx]'                        );
  TestCase.testcase(313, [$C5,$FA,$16,$F4                                   ] , 'vmovshdup  xmm6,xmm4'                             );
  TestCase.testcase(314, [$C5,$FA,$16,$21                                   ] , 'vmovshdup  xmm4,oword [ecx]'                      );
  TestCase.testcase(315, [$C5,$FA,$12,$F4                                   ] , 'vmovsldup  xmm6,xmm4'                             );
  TestCase.testcase(316, [$C5,$FA,$12,$21                                   ] , 'vmovsldup  xmm4,oword [ecx]'                      );
  TestCase.testcase(317, [$C5,$F9,$10,$F4                                   ] , 'vmovupd  xmm6,xmm4'                               );
  TestCase.testcase(318, [$C5,$F9,$10,$21                                   ] , 'vmovupd  xmm4,oword [ecx]'                        );
  TestCase.testcase(319, [$C5,$F8,$10,$F4                                   ] , 'vmovups  xmm6,xmm4'                               );
  TestCase.testcase(320, [$C5,$F8,$10,$21                                   ] , 'vmovups  xmm4,oword [ecx]'                        );
  TestCase.testcase(321, [$C4,$E2,$79,$1C,$F4                               ] , 'vpabsb  xmm6,xmm4'                                );
  TestCase.testcase(322, [$C4,$E2,$79,$1C,$21                               ] , 'vpabsb  xmm4,oword [ecx]'                         );
  TestCase.testcase(323, [$C4,$E2,$79,$1D,$F4                               ] , 'vpabsw  xmm6,xmm4'                                );
  TestCase.testcase(324, [$C4,$E2,$79,$1D,$21                               ] , 'vpabsw  xmm4,oword [ecx]'                         );
  TestCase.testcase(325, [$C4,$E2,$79,$1E,$F4                               ] , 'vpabsd  xmm6,xmm4'                                );
  TestCase.testcase(326, [$C4,$E2,$79,$1E,$21                               ] , 'vpabsd  xmm4,oword [ecx]'                         );
  TestCase.testcase(327, [$C4,$E2,$79,$41,$F4                               ] , 'vphminposuw  xmm6,xmm4'                           );
  TestCase.testcase(328, [$C4,$E2,$79,$41,$21                               ] , 'vphminposuw  xmm4,oword [ecx]'                    );
  TestCase.testcase(329, [$C4,$E2,$79,$17,$F4                               ] , 'vptest  xmm6,xmm4'                                );
  TestCase.testcase(330, [$C4,$E2,$79,$17,$21                               ] , 'vptest  xmm4,oword [ecx]'                         );
  TestCase.testcase(331, [$C4,$E2,$79,$0E,$F4                               ] , 'vtestps  xmm6,xmm4'                               );
  TestCase.testcase(332, [$C4,$E2,$79,$0E,$21                               ] , 'vtestps  xmm4,oword [ecx]'                        );
  TestCase.testcase(333, [$C4,$E2,$79,$0F,$F4                               ] , 'vtestpd  xmm6,xmm4'                               );
  TestCase.testcase(334, [$C4,$E2,$79,$0F,$21                               ] , 'vtestpd  xmm4,oword [ecx]'                        );
  TestCase.testcase(335, [$C5,$F8,$53,$F4                                   ] , 'vrcpps  xmm6,xmm4'                                );
  TestCase.testcase(336, [$C5,$F8,$53,$21                                   ] , 'vrcpps  xmm4,oword [ecx]'                         );
  TestCase.testcase(337, [$C5,$F8,$52,$F4                                   ] , 'vrsqrtps  xmm6,xmm4'                              );
  TestCase.testcase(338, [$C5,$F8,$52,$21                                   ] , 'vrsqrtps  xmm4,oword [ecx]'                       );
  TestCase.testcase(339, [$C5,$F9,$51,$F4                                   ] , 'vsqrtpd  xmm6,xmm4'                               );
  TestCase.testcase(340, [$C5,$F9,$51,$21                                   ] , 'vsqrtpd  xmm4,oword [ecx]'                        );
  TestCase.testcase(341, [$C5,$F8,$51,$F4                                   ] , 'vsqrtps  xmm6,xmm4'                               );
  TestCase.testcase(342, [$C5,$F8,$51,$21                                   ] , 'vsqrtps  xmm4,oword [ecx]'                        );
  TestCase.testcase(343, [$C4,$E2,$79,$DB,$F4                               ] , 'vaesimc  xmm6,xmm4'                               );
  TestCase.testcase(344, [$C4,$E2,$79,$DB,$21                               ] , 'vaesimc  xmm4,oword [ecx]'                        );
  TestCase.testcase(345, [$C5,$F9,$28,$F4                                   ] , 'vmovapd  xmm6,xmm4'                               );
  TestCase.testcase(346, [$C5,$F9,$29,$21                                   ] , 'vmovapd  oword [ecx],xmm4'                        );
  TestCase.testcase(347, [$C5,$F8,$28,$F4                                   ] , 'vmovaps  xmm6,xmm4'                               );
  TestCase.testcase(348, [$C5,$F8,$29,$21                                   ] , 'vmovaps  oword [ecx],xmm4'                        );
  TestCase.testcase(349, [$C5,$F9,$6F,$F4                                   ] , 'vmovdqa  xmm6,xmm4'                               );
  TestCase.testcase(350, [$C5,$F9,$7F,$21                                   ] , 'vmovdqa  oword [ecx],xmm4'                        );
  TestCase.testcase(351, [$C5,$FA,$6F,$F4                                   ] , 'vmovdqu  xmm6,xmm4'                               );
  TestCase.testcase(352, [$C5,$FA,$7F,$21                                   ] , 'vmovdqu  oword [ecx],xmm4'                        );
  TestCase.testcase(353, [$C5,$F9,$10,$F4                                   ] , 'vmovupd  xmm6,xmm4'                               );
  TestCase.testcase(354, [$C5,$F9,$11,$21                                   ] , 'vmovupd  oword [ecx],xmm4'                        );
  TestCase.testcase(355, [$C5,$F8,$10,$F4                                   ] , 'vmovups  xmm6,xmm4'                               );
  TestCase.testcase(356, [$C5,$F8,$11,$21                                   ] , 'vmovups  oword [ecx],xmm4'                        );
  TestCase.testcase(357, [$C5,$FB,$F0,$21                                   ] , 'vlddqu  xmm4,[ecx]'                               );
  TestCase.testcase(358, [$C4,$E2,$79,$2A,$21                               ] , 'vmovntdqa  xmm4,oword [ecx]'                      );
  TestCase.testcase(359, [$C5,$F9,$E7,$21                                   ] , 'vmovntdq  oword [ecx],xmm4'                       );
  TestCase.testcase(360, [$C5,$F9,$2B,$21                                   ] , 'vmovntpd  oword [ecx],xmm4'                       );
  TestCase.testcase(361, [$C5,$F8,$2B,$21                                   ] , 'vmovntps  oword [ecx],xmm4'                       );
  TestCase.testcase(362, [$C5,$FE,$E6,$E4                                   ] , 'vcvtdq2pd  ymm4,xmm4'                             );
  TestCase.testcase(363, [$C5,$FE,$E6,$21                                   ] , 'vcvtdq2pd  ymm4,oword [ecx]'                      );
  TestCase.testcase(364, [$C5,$FC,$5A,$E4                                   ] , 'vcvtps2pd  ymm4,xmm4'                             );
  TestCase.testcase(365, [$C5,$FC,$5A,$21                                   ] , 'vcvtps2pd  ymm4,oword [ecx]'                      );
  TestCase.testcase(366, [$C5,$C9,$58,$D4                                   ] , 'vaddpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(367, [$C5,$C9,$58,$39                                   ] , 'vaddpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(368, [$C5,$C8,$58,$D4                                   ] , 'vaddps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(369, [$C5,$C8,$58,$39                                   ] , 'vaddps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(370, [$C5,$C9,$D0,$D4                                   ] , 'vaddsubpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(371, [$C5,$C9,$D0,$39                                   ] , 'vaddsubpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(372, [$C5,$CB,$D0,$D4                                   ] , 'vaddsubps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(373, [$C5,$CB,$D0,$39                                   ] , 'vaddsubps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(374, [$C5,$C9,$55,$D4                                   ] , 'vandnpd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(375, [$C5,$C9,$55,$39                                   ] , 'vandnpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(376, [$C5,$C8,$55,$D4                                   ] , 'vandnps  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(377, [$C5,$C8,$55,$39                                   ] , 'vandnps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(378, [$C5,$C9,$54,$D4                                   ] , 'vandpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(379, [$C5,$C9,$54,$39                                   ] , 'vandpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(380, [$C5,$C8,$54,$D4                                   ] , 'vandps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(381, [$C5,$C8,$54,$39                                   ] , 'vandps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(382, [$C5,$C9,$5E,$D4                                   ] , 'vdivpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(383, [$C5,$C9,$5E,$39                                   ] , 'vdivpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(384, [$C5,$C8,$5E,$D4                                   ] , 'vdivps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(385, [$C5,$C8,$5E,$39                                   ] , 'vdivps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(386, [$C5,$C9,$7C,$D4                                   ] , 'vhaddpd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(387, [$C5,$C9,$7C,$39                                   ] , 'vhaddpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(388, [$C5,$CB,$7C,$D4                                   ] , 'vhaddps  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(389, [$C5,$CB,$7C,$39                                   ] , 'vhaddps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(390, [$C5,$C9,$7D,$D4                                   ] , 'vhsubpd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(391, [$C5,$C9,$7D,$39                                   ] , 'vhsubpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(392, [$C5,$CB,$7D,$D4                                   ] , 'vhsubps  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(393, [$C5,$CB,$7D,$39                                   ] , 'vhsubps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(394, [$C5,$C9,$5F,$D4                                   ] , 'vmaxpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(395, [$C5,$C9,$5F,$39                                   ] , 'vmaxpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(396, [$C5,$C8,$5F,$D4                                   ] , 'vmaxps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(397, [$C5,$C8,$5F,$39                                   ] , 'vmaxps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(398, [$C5,$C9,$5D,$D4                                   ] , 'vminpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(399, [$C5,$C9,$5D,$39                                   ] , 'vminpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(400, [$C5,$C8,$5D,$D4                                   ] , 'vminps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(401, [$C5,$C8,$5D,$39                                   ] , 'vminps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(402, [$C5,$C9,$59,$D4                                   ] , 'vmulpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(403, [$C5,$C9,$59,$39                                   ] , 'vmulpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(404, [$C5,$C8,$59,$D4                                   ] , 'vmulps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(405, [$C5,$C8,$59,$39                                   ] , 'vmulps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(406, [$C5,$C9,$56,$D4                                   ] , 'vorpd  xmm2,xmm6,xmm4'                            );
  TestCase.testcase(407, [$C5,$C9,$56,$39                                   ] , 'vorpd  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(408, [$C5,$C8,$56,$D4                                   ] , 'vorps  xmm2,xmm6,xmm4'                            );
  TestCase.testcase(409, [$C5,$C8,$56,$39                                   ] , 'vorps  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(410, [$C5,$C9,$63,$D4                                   ] , 'vpacksswb  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(411, [$C5,$C9,$63,$39                                   ] , 'vpacksswb  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(412, [$C5,$C9,$6B,$D4                                   ] , 'vpackssdw  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(413, [$C5,$C9,$6B,$39                                   ] , 'vpackssdw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(414, [$C5,$C9,$67,$D4                                   ] , 'vpackuswb  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(415, [$C5,$C9,$67,$39                                   ] , 'vpackuswb  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(416, [$C4,$E2,$49,$2B,$D4                               ] , 'vpackusdw  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(417, [$C4,$E2,$49,$2B,$39                               ] , 'vpackusdw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(418, [$C5,$C9,$FC,$D4                                   ] , 'vpaddb  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(419, [$C5,$C9,$FC,$39                                   ] , 'vpaddb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(420, [$C5,$C9,$FD,$D4                                   ] , 'vpaddw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(421, [$C5,$C9,$FD,$39                                   ] , 'vpaddw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(422, [$C5,$C9,$FE,$D4                                   ] , 'vpaddd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(423, [$C5,$C9,$FE,$39                                   ] , 'vpaddd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(424, [$C5,$C9,$D4,$D4                                   ] , 'vpaddq  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(425, [$C5,$C9,$D4,$39                                   ] , 'vpaddq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(426, [$C5,$C9,$EC,$D4                                   ] , 'vpaddsb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(427, [$C5,$C9,$EC,$39                                   ] , 'vpaddsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(428, [$C5,$C9,$ED,$D4                                   ] , 'vpaddsw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(429, [$C5,$C9,$ED,$39                                   ] , 'vpaddsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(430, [$C5,$C9,$DC,$D4                                   ] , 'vpaddusb  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(431, [$C5,$C9,$DC,$39                                   ] , 'vpaddusb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(432, [$C5,$C9,$DD,$D4                                   ] , 'vpaddusw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(433, [$C5,$C9,$DD,$39                                   ] , 'vpaddusw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(434, [$C5,$C9,$DB,$D4                                   ] , 'vpand  xmm2,xmm6,xmm4'                            );
  TestCase.testcase(435, [$C5,$C9,$DB,$39                                   ] , 'vpand  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(436, [$C5,$C9,$DF,$D4                                   ] , 'vpandn  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(437, [$C5,$C9,$DF,$39                                   ] , 'vpandn  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(438, [$C5,$C9,$E0,$D4                                   ] , 'vpavgb  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(439, [$C5,$C9,$E0,$39                                   ] , 'vpavgb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(440, [$C5,$C9,$E3,$D4                                   ] , 'vpavgw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(441, [$C5,$C9,$E3,$39                                   ] , 'vpavgw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(442, [$C4,$E3,$49,$44,$D4,$00                           ] , 'vpclmullqlqdq  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(443, [$C4,$E3,$49,$44,$39,$00                           ] , 'vpclmullqlqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(444, [$C4,$E3,$49,$44,$D4,$01                           ] , 'vpclmulhqlqdq  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(445, [$C4,$E3,$49,$44,$39,$01                           ] , 'vpclmulhqlqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(446, [$C4,$E3,$49,$44,$D4,$10                           ] , 'vpclmullqhqdq  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(447, [$C4,$E3,$49,$44,$39,$10                           ] , 'vpclmullqhqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(448, [$C4,$E3,$49,$44,$D4,$11                           ] , 'vpclmulhqhqdq  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(449, [$C4,$E3,$49,$44,$39,$11                           ] , 'vpclmulhqhqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(450, [$C5,$C9,$74,$D4                                   ] , 'vpcmpeqb  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(451, [$C5,$C9,$74,$39                                   ] , 'vpcmpeqb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(452, [$C5,$C9,$75,$D4                                   ] , 'vpcmpeqw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(453, [$C5,$C9,$75,$39                                   ] , 'vpcmpeqw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(454, [$C5,$C9,$76,$D4                                   ] , 'vpcmpeqd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(455, [$C5,$C9,$76,$39                                   ] , 'vpcmpeqd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(456, [$C4,$E2,$49,$29,$D4                               ] , 'vpcmpeqq  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(457, [$C4,$E2,$49,$29,$39                               ] , 'vpcmpeqq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(458, [$C5,$C9,$64,$D4                                   ] , 'vpcmpgtb  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(459, [$C5,$C9,$64,$39                                   ] , 'vpcmpgtb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(460, [$C5,$C9,$65,$D4                                   ] , 'vpcmpgtw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(461, [$C5,$C9,$65,$39                                   ] , 'vpcmpgtw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(462, [$C5,$C9,$66,$D4                                   ] , 'vpcmpgtd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(463, [$C5,$C9,$66,$39                                   ] , 'vpcmpgtd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(464, [$C4,$E2,$49,$37,$D4                               ] , 'vpcmpgtq  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(465, [$C4,$E2,$49,$37,$39                               ] , 'vpcmpgtq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(466, [$C4,$E2,$49,$0D,$D4                               ] , 'vpermilpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(467, [$C4,$E2,$49,$0D,$39                               ] , 'vpermilpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(468, [$C4,$E2,$49,$0C,$D4                               ] , 'vpermilps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(469, [$C4,$E2,$49,$0C,$39                               ] , 'vpermilps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(470, [$C4,$E2,$49,$01,$D4                               ] , 'vphaddw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(471, [$C4,$E2,$49,$01,$39                               ] , 'vphaddw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(472, [$C4,$E2,$49,$02,$D4                               ] , 'vphaddd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(473, [$C4,$E2,$49,$02,$39                               ] , 'vphaddd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(474, [$C4,$E2,$49,$03,$D4                               ] , 'vphaddsw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(475, [$C4,$E2,$49,$03,$39                               ] , 'vphaddsw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(476, [$C4,$E2,$49,$05,$D4                               ] , 'vphsubw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(477, [$C4,$E2,$49,$05,$39                               ] , 'vphsubw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(478, [$C4,$E2,$49,$06,$D4                               ] , 'vphsubd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(479, [$C4,$E2,$49,$06,$39                               ] , 'vphsubd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(480, [$C4,$E2,$49,$07,$D4                               ] , 'vphsubsw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(481, [$C4,$E2,$49,$07,$39                               ] , 'vphsubsw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(482, [$C5,$C9,$F5,$D4                                   ] , 'vpmaddwd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(483, [$C5,$C9,$F5,$39                                   ] , 'vpmaddwd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(484, [$C4,$E2,$49,$04,$D4                               ] , 'vpmaddubsw  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(485, [$C4,$E2,$49,$04,$39                               ] , 'vpmaddubsw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(486, [$C4,$E2,$49,$3C,$D4                               ] , 'vpmaxsb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(487, [$C4,$E2,$49,$3C,$39                               ] , 'vpmaxsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(488, [$C5,$C9,$EE,$D4                                   ] , 'vpmaxsw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(489, [$C5,$C9,$EE,$39                                   ] , 'vpmaxsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(490, [$C4,$E2,$49,$3D,$D4                               ] , 'vpmaxsd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(491, [$C4,$E2,$49,$3D,$39                               ] , 'vpmaxsd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(492, [$C5,$C9,$DE,$D4                                   ] , 'vpmaxub  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(493, [$C5,$C9,$DE,$39                                   ] , 'vpmaxub  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(494, [$C4,$E2,$49,$3E,$D4                               ] , 'vpmaxuw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(495, [$C4,$E2,$49,$3E,$39                               ] , 'vpmaxuw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(496, [$C4,$E2,$49,$3F,$D4                               ] , 'vpmaxud  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(497, [$C4,$E2,$49,$3F,$39                               ] , 'vpmaxud  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(498, [$C4,$E2,$49,$38,$D4                               ] , 'vpminsb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(499, [$C4,$E2,$49,$38,$39                               ] , 'vpminsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(500, [$C5,$C9,$EA,$D4                                   ] , 'vpminsw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(501, [$C5,$C9,$EA,$39                                   ] , 'vpminsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(502, [$C4,$E2,$49,$39,$D4                               ] , 'vpminsd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(503, [$C4,$E2,$49,$39,$39                               ] , 'vpminsd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(504, [$C5,$C9,$DA,$D4                                   ] , 'vpminub  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(505, [$C5,$C9,$DA,$39                                   ] , 'vpminub  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(506, [$C4,$E2,$49,$3A,$D4                               ] , 'vpminuw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(507, [$C4,$E2,$49,$3A,$39                               ] , 'vpminuw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(508, [$C4,$E2,$49,$3B,$D4                               ] , 'vpminud  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(509, [$C4,$E2,$49,$3B,$39                               ] , 'vpminud  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(510, [$C5,$C9,$E4,$D4                                   ] , 'vpmulhuw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(511, [$C5,$C9,$E4,$39                                   ] , 'vpmulhuw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(512, [$C4,$E2,$49,$0B,$D4                               ] , 'vpmulhrsw  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(513, [$C4,$E2,$49,$0B,$39                               ] , 'vpmulhrsw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(514, [$C5,$C9,$E5,$D4                                   ] , 'vpmulhw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(515, [$C5,$C9,$E5,$39                                   ] , 'vpmulhw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(516, [$C5,$C9,$D5,$D4                                   ] , 'vpmullw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(517, [$C5,$C9,$D5,$39                                   ] , 'vpmullw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(518, [$C4,$E2,$49,$40,$D4                               ] , 'vpmulld  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(519, [$C4,$E2,$49,$40,$39                               ] , 'vpmulld  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(520, [$C5,$C9,$F4,$D4                                   ] , 'vpmuludq  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(521, [$C5,$C9,$F4,$39                                   ] , 'vpmuludq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(522, [$C4,$E2,$49,$28,$D4                               ] , 'vpmuldq  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(523, [$C4,$E2,$49,$28,$39                               ] , 'vpmuldq  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(524, [$C5,$C9,$EB,$D4                                   ] , 'vpor  xmm2,xmm6,xmm4'                             );
  TestCase.testcase(525, [$C5,$C9,$EB,$39                                   ] , 'vpor  xmm7,xmm6,oword [ecx]'                      );
  TestCase.testcase(526, [$C5,$C9,$F6,$D4                                   ] , 'vpsadbw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(527, [$C5,$C9,$F6,$39                                   ] , 'vpsadbw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(528, [$C4,$E2,$49,$00,$D4                               ] , 'vpshufb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(529, [$C4,$E2,$49,$00,$39                               ] , 'vpshufb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(530, [$C4,$E2,$49,$08,$D4                               ] , 'vpsignb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(531, [$C4,$E2,$49,$08,$39                               ] , 'vpsignb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(532, [$C4,$E2,$49,$09,$D4                               ] , 'vpsignw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(533, [$C4,$E2,$49,$09,$39                               ] , 'vpsignw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(534, [$C4,$E2,$49,$0A,$D4                               ] , 'vpsignd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(535, [$C4,$E2,$49,$0A,$39                               ] , 'vpsignd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(536, [$C5,$C9,$F1,$D4                                   ] , 'vpsllw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(537, [$C5,$C9,$F1,$39                                   ] , 'vpsllw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(538, [$C5,$C9,$F2,$D4                                   ] , 'vpslld  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(539, [$C5,$C9,$F2,$39                                   ] , 'vpslld  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(540, [$C5,$C9,$F3,$D4                                   ] , 'vpsllq  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(541, [$C5,$C9,$F3,$39                                   ] , 'vpsllq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(542, [$C5,$C9,$E1,$D4                                   ] , 'vpsraw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(543, [$C5,$C9,$E1,$39                                   ] , 'vpsraw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(544, [$C5,$C9,$E2,$D4                                   ] , 'vpsrad  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(545, [$C5,$C9,$E2,$39                                   ] , 'vpsrad  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(546, [$C5,$C9,$D1,$D4                                   ] , 'vpsrlw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(547, [$C5,$C9,$D1,$39                                   ] , 'vpsrlw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(548, [$C5,$C9,$D2,$D4                                   ] , 'vpsrld  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(549, [$C5,$C9,$D2,$39                                   ] , 'vpsrld  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(550, [$C5,$C9,$D3,$D4                                   ] , 'vpsrlq  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(551, [$C5,$C9,$D3,$39                                   ] , 'vpsrlq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(552, [$C5,$C9,$F8,$D4                                   ] , 'vpsubb  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(553, [$C5,$C9,$F8,$39                                   ] , 'vpsubb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(554, [$C5,$C9,$F9,$D4                                   ] , 'vpsubw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(555, [$C5,$C9,$F9,$39                                   ] , 'vpsubw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(556, [$C5,$C9,$FA,$D4                                   ] , 'vpsubd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(557, [$C5,$C9,$FA,$39                                   ] , 'vpsubd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(558, [$C5,$C9,$FB,$D4                                   ] , 'vpsubq  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(559, [$C5,$C9,$FB,$39                                   ] , 'vpsubq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(560, [$C5,$C9,$E8,$D4                                   ] , 'vpsubsb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(561, [$C5,$C9,$E8,$39                                   ] , 'vpsubsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(562, [$C5,$C9,$E9,$D4                                   ] , 'vpsubsw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(563, [$C5,$C9,$E9,$39                                   ] , 'vpsubsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(564, [$C5,$C9,$D8,$D4                                   ] , 'vpsubusb  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(565, [$C5,$C9,$D8,$39                                   ] , 'vpsubusb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(566, [$C5,$C9,$D9,$D4                                   ] , 'vpsubusw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(567, [$C5,$C9,$D9,$39                                   ] , 'vpsubusw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(568, [$C5,$C9,$68,$D4                                   ] , 'vpunpckhbw  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(569, [$C5,$C9,$68,$39                                   ] , 'vpunpckhbw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(570, [$C5,$C9,$69,$D4                                   ] , 'vpunpckhwd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(571, [$C5,$C9,$69,$39                                   ] , 'vpunpckhwd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(572, [$C5,$C9,$6A,$D4                                   ] , 'vpunpckhdq  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(573, [$C5,$C9,$6A,$39                                   ] , 'vpunpckhdq  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(574, [$C5,$C9,$6D,$D4                                   ] , 'vpunpckhqdq  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(575, [$C5,$C9,$6D,$39                                   ] , 'vpunpckhqdq  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(576, [$C5,$C9,$60,$D4                                   ] , 'vpunpcklbw  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(577, [$C5,$C9,$60,$39                                   ] , 'vpunpcklbw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(578, [$C5,$C9,$61,$D4                                   ] , 'vpunpcklwd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(579, [$C5,$C9,$61,$39                                   ] , 'vpunpcklwd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(580, [$C5,$C9,$62,$D4                                   ] , 'vpunpckldq  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(581, [$C5,$C9,$62,$39                                   ] , 'vpunpckldq  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(582, [$C5,$C9,$6C,$D4                                   ] , 'vpunpcklqdq  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(583, [$C5,$C9,$6C,$39                                   ] , 'vpunpcklqdq  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(584, [$C5,$C9,$EF,$D4                                   ] , 'vpxor  xmm2,xmm6,xmm4'                            );
  TestCase.testcase(585, [$C5,$C9,$EF,$39                                   ] , 'vpxor  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(586, [$C5,$C9,$5C,$D4                                   ] , 'vsubpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(587, [$C5,$C9,$5C,$39                                   ] , 'vsubpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(588, [$C5,$C8,$5C,$D4                                   ] , 'vsubps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(589, [$C5,$C8,$5C,$39                                   ] , 'vsubps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(590, [$C5,$C9,$15,$D4                                   ] , 'vunpckhpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(591, [$C5,$C9,$15,$39                                   ] , 'vunpckhpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(592, [$C5,$C8,$15,$D4                                   ] , 'vunpckhps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(593, [$C5,$C8,$15,$39                                   ] , 'vunpckhps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(594, [$C5,$C9,$14,$D4                                   ] , 'vunpcklpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(595, [$C5,$C9,$14,$39                                   ] , 'vunpcklpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(596, [$C5,$C8,$14,$D4                                   ] , 'vunpcklps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(597, [$C5,$C8,$14,$39                                   ] , 'vunpcklps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(598, [$C5,$C9,$57,$D4                                   ] , 'vxorpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(599, [$C5,$C9,$57,$39                                   ] , 'vxorpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(600, [$C5,$C8,$57,$D4                                   ] , 'vxorps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(601, [$C5,$C8,$57,$39                                   ] , 'vxorps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(602, [$C4,$E2,$49,$DC,$D4                               ] , 'vaesenc  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(603, [$C4,$E2,$49,$DC,$39                               ] , 'vaesenc  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(604, [$C4,$E2,$49,$DD,$D4                               ] , 'vaesenclast  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(605, [$C4,$E2,$49,$DD,$39                               ] , 'vaesenclast  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(606, [$C4,$E2,$49,$DE,$D4                               ] , 'vaesdec  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(607, [$C4,$E2,$49,$DE,$39                               ] , 'vaesdec  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(608, [$C4,$E2,$49,$DF,$D4                               ] , 'vaesdeclast  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(609, [$C4,$E2,$49,$DF,$39                               ] , 'vaesdeclast  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(610, [$C5,$C9,$C2,$D4,$00                               ] , 'vcmpeqpd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(611, [$C5,$C9,$C2,$39,$00                               ] , 'vcmpeqpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(612, [$C5,$C9,$C2,$D4,$01                               ] , 'vcmpltpd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(613, [$C5,$C9,$C2,$39,$01                               ] , 'vcmpltpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(614, [$C5,$C9,$C2,$D4,$02                               ] , 'vcmplepd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(615, [$C5,$C9,$C2,$39,$02                               ] , 'vcmplepd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(616, [$C5,$C9,$C2,$D4,$03                               ] , 'vcmpunordpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(617, [$C5,$C9,$C2,$39,$03                               ] , 'vcmpunordpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(618, [$C5,$C9,$C2,$D4,$04                               ] , 'vcmpneqpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(619, [$C5,$C9,$C2,$39,$04                               ] , 'vcmpneqpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(620, [$C5,$C9,$C2,$D4,$05                               ] , 'vcmpnltpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(621, [$C5,$C9,$C2,$39,$05                               ] , 'vcmpnltpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(622, [$C5,$C9,$C2,$D4,$06                               ] , 'vcmpnlepd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(623, [$C5,$C9,$C2,$39,$06                               ] , 'vcmpnlepd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(624, [$C5,$C9,$C2,$D4,$07                               ] , 'vcmpordpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(625, [$C5,$C9,$C2,$39,$07                               ] , 'vcmpordpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(626, [$C5,$C9,$C2,$D4,$08                               ] , 'vcmpeq_uqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(627, [$C5,$C9,$C2,$39,$08                               ] , 'vcmpeq_uqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(628, [$C5,$C9,$C2,$D4,$09                               ] , 'vcmpngepd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(629, [$C5,$C9,$C2,$39,$09                               ] , 'vcmpngepd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(630, [$C5,$C9,$C2,$D4,$0A                               ] , 'vcmpngtpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(631, [$C5,$C9,$C2,$39,$0A                               ] , 'vcmpngtpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(632, [$C5,$C9,$C2,$D4,$0B                               ] , 'vcmpfalsepd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(633, [$C5,$C9,$C2,$39,$0B                               ] , 'vcmpfalsepd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(634, [$C5,$C9,$C2,$D4,$0C                               ] , 'vcmpneq_oqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(635, [$C5,$C9,$C2,$39,$0C                               ] , 'vcmpneq_oqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(636, [$C5,$C9,$C2,$D4,$0D                               ] , 'vcmpgepd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(637, [$C5,$C9,$C2,$39,$0D                               ] , 'vcmpgepd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(638, [$C5,$C9,$C2,$D4,$0E                               ] , 'vcmpgtpd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(639, [$C5,$C9,$C2,$39,$0E                               ] , 'vcmpgtpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(640, [$C5,$C9,$C2,$D4,$0F                               ] , 'vcmuepd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(641, [$C5,$C9,$C2,$39,$0F                               ] , 'vcmuepd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(642, [$C5,$C9,$C2,$D4,$10                               ] , 'vcmpeq_ospd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(643, [$C5,$C9,$C2,$39,$10                               ] , 'vcmpeq_ospd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(644, [$C5,$C9,$C2,$D4,$11                               ] , 'vcmplt_oqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(645, [$C5,$C9,$C2,$39,$11                               ] , 'vcmplt_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(646, [$C5,$C9,$C2,$D4,$12                               ] , 'vcmple_oqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(647, [$C5,$C9,$C2,$39,$12                               ] , 'vcmple_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(648, [$C5,$C9,$C2,$D4,$13                               ] , 'vcmpunord_spd  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(649, [$C5,$C9,$C2,$39,$13                               ] , 'vcmpunord_spd  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(650, [$C5,$C9,$C2,$D4,$14                               ] , 'vcmpneq_uspd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(651, [$C5,$C9,$C2,$39,$14                               ] , 'vcmpneq_uspd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(652, [$C5,$C9,$C2,$D4,$15                               ] , 'vcmpnlt_uqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(653, [$C5,$C9,$C2,$39,$15                               ] , 'vcmpnlt_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(654, [$C5,$C9,$C2,$D4,$16                               ] , 'vcmpnle_uqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(655, [$C5,$C9,$C2,$39,$16                               ] , 'vcmpnle_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(656, [$C5,$C9,$C2,$D4,$17                               ] , 'vcmpord_spd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(657, [$C5,$C9,$C2,$39,$17                               ] , 'vcmpord_spd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(658, [$C5,$C9,$C2,$D4,$18                               ] , 'vcmpeq_uspd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(659, [$C5,$C9,$C2,$39,$18                               ] , 'vcmpeq_uspd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(660, [$C5,$C9,$C2,$D4,$19                               ] , 'vcmpnge_uqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(661, [$C5,$C9,$C2,$39,$19                               ] , 'vcmpnge_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(662, [$C5,$C9,$C2,$D4,$1A                               ] , 'vcmpngt_uqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(663, [$C5,$C9,$C2,$39,$1A                               ] , 'vcmpngt_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(664, [$C5,$C9,$C2,$D4,$1B                               ] , 'vcmpfalse_ospd  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(665, [$C5,$C9,$C2,$39,$1B                               ] , 'vcmpfalse_ospd  xmm7,xmm6,oword [ecx]'            );
  TestCase.testcase(666, [$C5,$C9,$C2,$D4,$1C                               ] , 'vcmpneq_ospd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(667, [$C5,$C9,$C2,$39,$1C                               ] , 'vcmpneq_ospd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(668, [$C5,$C9,$C2,$D4,$1D                               ] , 'vcmpge_oqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(669, [$C5,$C9,$C2,$39,$1D                               ] , 'vcmpge_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(670, [$C5,$C9,$C2,$D4,$1E                               ] , 'vcmpgt_oqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(671, [$C5,$C9,$C2,$39,$1E                               ] , 'vcmpgt_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(672, [$C5,$C9,$C2,$D4,$1F                               ] , 'vcmue_uspd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(673, [$C5,$C9,$C2,$39,$1F                               ] , 'vcmue_uspd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(674, [$C5,$C8,$C2,$D4,$00                               ] , 'vcmpeqps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(675, [$C5,$C8,$C2,$39,$00                               ] , 'vcmpeqps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(676, [$C5,$C8,$C2,$D4,$01                               ] , 'vcmpltps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(677, [$C5,$C8,$C2,$39,$01                               ] , 'vcmpltps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(678, [$C5,$C8,$C2,$D4,$02                               ] , 'vcmpleps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(679, [$C5,$C8,$C2,$39,$02                               ] , 'vcmpleps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(680, [$C5,$C8,$C2,$D4,$03                               ] , 'vcmpunordps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(681, [$C5,$C8,$C2,$39,$03                               ] , 'vcmpunordps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(682, [$C5,$C8,$C2,$D4,$04                               ] , 'vcmpneqps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(683, [$C5,$C8,$C2,$39,$04                               ] , 'vcmpneqps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(684, [$C5,$C8,$C2,$D4,$05                               ] , 'vcmpnltps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(685, [$C5,$C8,$C2,$39,$05                               ] , 'vcmpnltps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(686, [$C5,$C8,$C2,$D4,$06                               ] , 'vcmpnleps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(687, [$C5,$C8,$C2,$39,$06                               ] , 'vcmpnleps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(688, [$C5,$C8,$C2,$D4,$07                               ] , 'vcmpordps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(689, [$C5,$C8,$C2,$39,$07                               ] , 'vcmpordps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(690, [$C5,$C8,$C2,$D4,$08                               ] , 'vcmpeq_uqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(691, [$C5,$C8,$C2,$39,$08                               ] , 'vcmpeq_uqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(692, [$C5,$C8,$C2,$D4,$09                               ] , 'vcmpngeps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(693, [$C5,$C8,$C2,$39,$09                               ] , 'vcmpngeps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(694, [$C5,$C8,$C2,$D4,$0A                               ] , 'vcmpngtps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(695, [$C5,$C8,$C2,$39,$0A                               ] , 'vcmpngtps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(696, [$C5,$C8,$C2,$D4,$0B                               ] , 'vcmpfalseps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(697, [$C5,$C8,$C2,$39,$0B                               ] , 'vcmpfalseps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(698, [$C5,$C8,$C2,$D4,$0C                               ] , 'vcmpneq_oqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(699, [$C5,$C8,$C2,$39,$0C                               ] , 'vcmpneq_oqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(700, [$C5,$C8,$C2,$D4,$0D                               ] , 'vcmpgeps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(701, [$C5,$C8,$C2,$39,$0D                               ] , 'vcmpgeps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(702, [$C5,$C8,$C2,$D4,$0E                               ] , 'vcmpgtps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(703, [$C5,$C8,$C2,$39,$0E                               ] , 'vcmpgtps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(704, [$C5,$C8,$C2,$D4,$0F                               ] , 'vcmueps  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(705, [$C5,$C8,$C2,$39,$0F                               ] , 'vcmueps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(706, [$C5,$C8,$C2,$D4,$10                               ] , 'vcmpeq_osps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(707, [$C5,$C8,$C2,$39,$10                               ] , 'vcmpeq_osps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(708, [$C5,$C8,$C2,$D4,$11                               ] , 'vcmplt_oqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(709, [$C5,$C8,$C2,$39,$11                               ] , 'vcmplt_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(710, [$C5,$C8,$C2,$D4,$12                               ] , 'vcmple_oqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(711, [$C5,$C8,$C2,$39,$12                               ] , 'vcmple_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(712, [$C5,$C8,$C2,$D4,$13                               ] , 'vcmpunord_sps  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(713, [$C5,$C8,$C2,$39,$13                               ] , 'vcmpunord_sps  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(714, [$C5,$C8,$C2,$D4,$14                               ] , 'vcmpneq_usps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(715, [$C5,$C8,$C2,$39,$14                               ] , 'vcmpneq_usps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(716, [$C5,$C8,$C2,$D4,$15                               ] , 'vcmpnlt_uqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(717, [$C5,$C8,$C2,$39,$15                               ] , 'vcmpnlt_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(718, [$C5,$C8,$C2,$D4,$16                               ] , 'vcmpnle_uqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(719, [$C5,$C8,$C2,$39,$16                               ] , 'vcmpnle_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(720, [$C5,$C8,$C2,$D4,$17                               ] , 'vcmpord_sps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(721, [$C5,$C8,$C2,$39,$17                               ] , 'vcmpord_sps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(722, [$C5,$C8,$C2,$D4,$18                               ] , 'vcmpeq_usps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(723, [$C5,$C8,$C2,$39,$18                               ] , 'vcmpeq_usps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(724, [$C5,$C8,$C2,$D4,$19                               ] , 'vcmpnge_uqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(725, [$C5,$C8,$C2,$39,$19                               ] , 'vcmpnge_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(726, [$C5,$C8,$C2,$D4,$1A                               ] , 'vcmpngt_uqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(727, [$C5,$C8,$C2,$39,$1A                               ] , 'vcmpngt_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(728, [$C5,$C8,$C2,$D4,$1B                               ] , 'vcmpfalse_osps  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(729, [$C5,$C8,$C2,$39,$1B                               ] , 'vcmpfalse_osps  xmm7,xmm6,oword [ecx]'            );
  TestCase.testcase(730, [$C5,$C8,$C2,$D4,$1C                               ] , 'vcmpneq_osps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(731, [$C5,$C8,$C2,$39,$1C                               ] , 'vcmpneq_osps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(732, [$C5,$C8,$C2,$D4,$1D                               ] , 'vcmpge_oqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(733, [$C5,$C8,$C2,$39,$1D                               ] , 'vcmpge_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(734, [$C5,$C8,$C2,$D4,$1E                               ] , 'vcmpgt_oqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(735, [$C5,$C8,$C2,$39,$1E                               ] , 'vcmpgt_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(736, [$C5,$C8,$C2,$D4,$1F                               ] , 'vcmue_usps  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(737, [$C5,$C8,$C2,$39,$1F                               ] , 'vcmue_usps  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(738, [$C4,$E2,$59,$2C,$31                               ] , 'vmaskmovps  xmm6,xmm4,oword [ecx]'                );
  TestCase.testcase(739, [$C4,$E2,$59,$2D,$31                               ] , 'vmaskmovpd  xmm6,xmm4,oword [ecx]'                );
  TestCase.testcase(740, [$C4,$E3,$79,$DF,$F4,$07                           ] , 'vaeskeygenassist  xmm6,xmm4,0x7'                  );
  TestCase.testcase(741, [$C4,$E3,$79,$DF,$31,$07                           ] , 'vaeskeygenassist  xmm6,oword [ecx],0x7'           );
  TestCase.testcase(742, [$C4,$E3,$79,$61,$F4,$07                           ] , 'vpcmpestri  xmm6,xmm4,0x7'                        );
  TestCase.testcase(743, [$C4,$E3,$79,$61,$31,$07                           ] , 'vpcmpestri  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(744, [$C4,$E3,$79,$60,$F4,$07                           ] , 'vpcmpestrm  xmm6,xmm4,0x7'                        );
  TestCase.testcase(745, [$C4,$E3,$79,$60,$31,$07                           ] , 'vpcmpestrm  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(746, [$C4,$E3,$79,$63,$F4,$07                           ] , 'vpcmpistri  xmm6,xmm4,0x7'                        );
  TestCase.testcase(747, [$C4,$E3,$79,$63,$31,$07                           ] , 'vpcmpistri  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(748, [$C4,$E3,$79,$62,$F4,$07                           ] , 'vpcmpistrm  xmm6,xmm4,0x7'                        );
  TestCase.testcase(749, [$C4,$E3,$79,$62,$31,$07                           ] , 'vpcmpistrm  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(750, [$C4,$E3,$79,$05,$F4,$07                           ] , 'vpermilpd  xmm6,xmm4,0x7'                         );
  TestCase.testcase(751, [$C4,$E3,$79,$05,$31,$07                           ] , 'vpermilpd  xmm6,oword [ecx],0x7'                  );
  TestCase.testcase(752, [$C4,$E3,$79,$04,$F4,$07                           ] , 'vpermilps  xmm6,xmm4,0x7'                         );
  TestCase.testcase(753, [$C4,$E3,$79,$04,$31,$07                           ] , 'vpermilps  xmm6,oword [ecx],0x7'                  );
  TestCase.testcase(754, [$C5,$F9,$70,$F4,$07                               ] , 'vpshufd  xmm6,xmm4,0x7'                           );
  TestCase.testcase(755, [$C5,$F9,$70,$31,$07                               ] , 'vpshufd  xmm6,oword [ecx],0x7'                    );
  TestCase.testcase(756, [$C5,$FA,$70,$F4,$07                               ] , 'vpshufhw  xmm6,xmm4,0x7'                          );
  TestCase.testcase(757, [$C5,$FA,$70,$31,$07                               ] , 'vpshufhw  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(758, [$C5,$FB,$70,$F4,$07                               ] , 'vpshuflw  xmm6,xmm4,0x7'                          );
  TestCase.testcase(759, [$C5,$FB,$70,$31,$07                               ] , 'vpshuflw  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(760, [$C4,$E3,$79,$09,$F4,$07                           ] , 'vroundpd  xmm6,xmm4,0x7'                          );
  TestCase.testcase(761, [$C4,$E3,$79,$09,$31,$07                           ] , 'vroundpd  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(762, [$C4,$E3,$79,$08,$F4,$07                           ] , 'vroundps  xmm6,xmm4,0x7'                          );
  TestCase.testcase(763, [$C4,$E3,$79,$08,$31,$07                           ] , 'vroundps  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(764, [$C4,$E2,$49,$2E,$21                               ] , 'vmaskmovps  oword [ecx],xmm6,xmm4'                );
  TestCase.testcase(765, [$C4,$E2,$49,$2F,$21                               ] , 'vmaskmovpd  oword [ecx],xmm6,xmm4'                );
  TestCase.testcase(766, [$C4,$E3,$49,$0D,$D4,$07                           ] , 'vblendpd  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(767, [$C4,$E3,$49,$0D,$11,$07                           ] , 'vblendpd  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(768, [$C4,$E3,$49,$0C,$D4,$07                           ] , 'vblendps  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(769, [$C4,$E3,$49,$0C,$11,$07                           ] , 'vblendps  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(770, [$C5,$C9,$C2,$D4,$07                               ] , 'vcmpordpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(771, [$C5,$C9,$C2,$11,$07                               ] , 'vcmpordpd  xmm2,xmm6,oword [ecx]'                 );
  TestCase.testcase(772, [$C5,$C8,$C2,$D4,$07                               ] , 'vcmpordps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(773, [$C5,$C8,$C2,$11,$07                               ] , 'vcmpordps  xmm2,xmm6,oword [ecx]'                 );
  TestCase.testcase(774, [$C4,$E3,$49,$41,$D4,$07                           ] , 'vdppd  xmm2,xmm6,xmm4,0x7'                        );
  TestCase.testcase(775, [$C4,$E3,$49,$41,$11,$07                           ] , 'vdppd  xmm2,xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(776, [$C4,$E3,$49,$40,$D4,$07                           ] , 'vdpps  xmm2,xmm6,xmm4,0x7'                        );
  TestCase.testcase(777, [$C4,$E3,$49,$40,$11,$07                           ] , 'vdpps  xmm2,xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(778, [$C4,$E3,$49,$42,$D4,$07                           ] , 'vmpsadbw  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(779, [$C4,$E3,$49,$42,$11,$07                           ] , 'vmpsadbw  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(780, [$C4,$E3,$49,$0F,$D4,$07                           ] , 'vpalignr  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(781, [$C4,$E3,$49,$0F,$11,$07                           ] , 'vpalignr  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(782, [$C4,$E3,$49,$0E,$D4,$07                           ] , 'vpblendw  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(783, [$C4,$E3,$49,$0E,$11,$07                           ] , 'vpblendw  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(784, [$C4,$E3,$49,$44,$D4,$07                           ] , 'vpclmulqdq  xmm2,xmm6,xmm4,0x7'                   );
  TestCase.testcase(785, [$C4,$E3,$49,$44,$11,$07                           ] , 'vpclmulqdq  xmm2,xmm6,oword [ecx],0x7'            );
  TestCase.testcase(786, [$C5,$C9,$C6,$D4,$07                               ] , 'vshufpd  xmm2,xmm6,xmm4,0x7'                      );
  TestCase.testcase(787, [$C5,$C9,$C6,$11,$07                               ] , 'vshufpd  xmm2,xmm6,oword [ecx],0x7'               );
  TestCase.testcase(788, [$C5,$C8,$C6,$D4,$07                               ] , 'vshufps  xmm2,xmm6,xmm4,0x7'                      );
  TestCase.testcase(789, [$C5,$C8,$C6,$11,$07                               ] , 'vshufps  xmm2,xmm6,oword [ecx],0x7'               );
  TestCase.testcase(790, [$C4,$E3,$69,$4B,$FE,$40                           ] , 'vblendvpd  xmm7,xmm2,xmm6,xmm4'                   );
  TestCase.testcase(791, [$C4,$E3,$69,$4B,$39,$40                           ] , 'vblendvpd  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(792, [$C4,$E3,$69,$4A,$FE,$40                           ] , 'vblendvps  xmm7,xmm2,xmm6,xmm4'                   );
  TestCase.testcase(793, [$C4,$E3,$69,$4A,$39,$40                           ] , 'vblendvps  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(794, [$C4,$E3,$69,$4C,$FE,$40                           ] , 'vpblendvb  xmm7,xmm2,xmm6,xmm4'                   );
  TestCase.testcase(795, [$C4,$E3,$69,$4C,$39,$40                           ] , 'vpblendvb  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(796, [$C4,$E2,$7D,$19,$21                               ] , 'vbroadcastsd  ymm4,qword [ecx]'                   );
  TestCase.testcase(797, [$C5,$F9,$2F,$F4                                   ] , 'vcomisd  xmm6,xmm4'                               );
  TestCase.testcase(798, [$C5,$F9,$2F,$21                                   ] , 'vcomisd  xmm4,qword [ecx]'                        );
  TestCase.testcase(799, [$C5,$FA,$E6,$F4                                   ] , 'vcvtdq2pd  xmm6,xmm4'                             );
  TestCase.testcase(800, [$C5,$FA,$E6,$21                                   ] , 'vcvtdq2pd  xmm4,qword [ecx]'                      );
  TestCase.testcase(801, [$C5,$F8,$5A,$F4                                   ] , 'vcvtps2pd  xmm6,xmm4'                             );
  TestCase.testcase(802, [$C5,$F8,$5A,$21                                   ] , 'vcvtps2pd  xmm4,qword [ecx]'                      );
  TestCase.testcase(803, [$C5,$FB,$12,$F4                                   ] , 'vmovddup  xmm6,xmm4'                              );
  TestCase.testcase(804, [$C5,$FB,$12,$21                                   ] , 'vmovddup  xmm4,qword [ecx]'                       );
  TestCase.testcase(805, [$C4,$E2,$79,$20,$F4                               ] , 'vpmovsxbw  xmm6,xmm4'                             );
  TestCase.testcase(806, [$C4,$E2,$79,$20,$21                               ] , 'vpmovsxbw  xmm4,qword [ecx]'                      );
  TestCase.testcase(807, [$C4,$E2,$79,$23,$F4                               ] , 'vpmovsxwd  xmm6,xmm4'                             );
  TestCase.testcase(808, [$C4,$E2,$79,$23,$21                               ] , 'vpmovsxwd  xmm4,qword [ecx]'                      );
  TestCase.testcase(809, [$C4,$E2,$79,$25,$F4                               ] , 'vpmovsxdq  xmm6,xmm4'                             );
  TestCase.testcase(810, [$C4,$E2,$79,$25,$21                               ] , 'vpmovsxdq  xmm4,qword [ecx]'                      );
  TestCase.testcase(811, [$C4,$E2,$79,$30,$F4                               ] , 'vpmovzxbw  xmm6,xmm4'                             );
  TestCase.testcase(812, [$C4,$E2,$79,$30,$21                               ] , 'vpmovzxbw  xmm4,qword [ecx]'                      );
  TestCase.testcase(813, [$C4,$E2,$79,$33,$F4                               ] , 'vpmovzxwd  xmm6,xmm4'                             );
  TestCase.testcase(814, [$C4,$E2,$79,$33,$21                               ] , 'vpmovzxwd  xmm4,qword [ecx]'                      );
  TestCase.testcase(815, [$C4,$E2,$79,$35,$F4                               ] , 'vpmovzxdq  xmm6,xmm4'                             );
  TestCase.testcase(816, [$C4,$E2,$79,$35,$21                               ] , 'vpmovzxdq  xmm4,qword [ecx]'                      );
  TestCase.testcase(817, [$C5,$F9,$2E,$F4                                   ] , 'vucomisd  xmm6,xmm4'                              );
  TestCase.testcase(818, [$C5,$F9,$2E,$21                                   ] , 'vucomisd  xmm4,qword [ecx]'                       );
  TestCase.testcase(819, [$C5,$FB,$10,$21                                   ] , 'vmovsd  xmm4,qword [ecx]'                         );
  TestCase.testcase(820, [$C5,$F9,$13,$21                                   ] , 'vmovlpd  qword [ecx],xmm4'                        );
  TestCase.testcase(821, [$C5,$F8,$13,$21                                   ] , 'vmovlps  qword [ecx],xmm4'                        );
  TestCase.testcase(822, [$C5,$F9,$17,$21                                   ] , 'vmovhpd  qword [ecx],xmm4'                        );
  TestCase.testcase(823, [$C5,$F8,$17,$21                                   ] , 'vmovhps  qword [ecx],xmm4'                        );
  TestCase.testcase(824, [$C5,$FB,$11,$21                                   ] , 'vmovsd  qword [ecx],xmm4'                         );
  TestCase.testcase(825, [$C5,$F9,$D6,$21                                   ] , 'vmovq  qword [ecx],xmm4'                          );
  TestCase.testcase(826, [$C5,$FA,$7E,$21                                   ] , 'vmovq  xmm4,qword [ecx]'                          );
  TestCase.testcase(827, [$C5,$FB,$2D,$CC                                   ] , 'vcvtsd2si  ecx,xmm4'                              );
  TestCase.testcase(828, [$C5,$FB,$2D,$09                                   ] , 'vcvtsd2si  ecx,qword [ecx]'                       );
  TestCase.testcase(829, [$C5,$FB,$2C,$CC                                   ] , 'vcvttsd2si  ecx,xmm4'                             );
  TestCase.testcase(830, [$C5,$FB,$2C,$09                                   ] , 'vcvttsd2si  ecx,qword [ecx]'                      );
  TestCase.testcase(831, [$C5,$D9,$12,$31                                   ] , 'vmovlpd  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(832, [$C5,$D8,$12,$31                                   ] , 'vmovlps  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(833, [$C5,$D9,$16,$31                                   ] , 'vmovhpd  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(834, [$C5,$D8,$16,$31                                   ] , 'vmovhps  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(835, [$C5,$CB,$C2,$D4,$07                               ] , 'vcmpordsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(836, [$C5,$CB,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(837, [$C4,$E3,$49,$0B,$D4,$07                           ] , 'vroundsd  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(838, [$C4,$E3,$49,$0B,$11,$07                           ] , 'vroundsd  xmm2,xmm6,qword [ecx],0x7'              );
  TestCase.testcase(839, [$C5,$CB,$58,$D4                                   ] , 'vaddsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(840, [$C5,$CB,$58,$11                                   ] , 'vaddsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(841, [$C5,$CB,$5A,$D4                                   ] , 'vcvtsd2ss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(842, [$C5,$CB,$5A,$11                                   ] , 'vcvtsd2ss  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(843, [$C5,$CB,$5E,$D4                                   ] , 'vdivsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(844, [$C5,$CB,$5E,$11                                   ] , 'vdivsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(845, [$C5,$CB,$5F,$D4                                   ] , 'vmaxsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(846, [$C5,$CB,$5F,$11                                   ] , 'vmaxsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(847, [$C5,$CB,$5D,$D4                                   ] , 'vminsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(848, [$C5,$CB,$5D,$11                                   ] , 'vminsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(849, [$C5,$CB,$59,$D4                                   ] , 'vmulsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(850, [$C5,$CB,$59,$11                                   ] , 'vmulsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(851, [$C5,$CB,$51,$D4                                   ] , 'vsqrtsd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(852, [$C5,$CB,$51,$11                                   ] , 'vsqrtsd  xmm2,xmm6,qword [ecx]'                   );
  TestCase.testcase(853, [$C5,$CB,$5C,$D4                                   ] , 'vsubsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(854, [$C5,$CB,$5C,$11                                   ] , 'vsubsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(855, [$C5,$CB,$C2,$D4,$00                               ] , 'vcmpeqsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(856, [$C5,$CB,$C2,$11,$00                               ] , 'vcmpeqsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(857, [$C5,$CB,$C2,$D4,$01                               ] , 'vcmpltsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(858, [$C5,$CB,$C2,$11,$01                               ] , 'vcmpltsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(859, [$C5,$CB,$C2,$D4,$02                               ] , 'vcmplesd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(860, [$C5,$CB,$C2,$11,$02                               ] , 'vcmplesd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(861, [$C5,$CB,$C2,$D4,$03                               ] , 'vcmpunordsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(862, [$C5,$CB,$C2,$11,$03                               ] , 'vcmpunordsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(863, [$C5,$CB,$C2,$D4,$04                               ] , 'vcmpneqsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(864, [$C5,$CB,$C2,$11,$04                               ] , 'vcmpneqsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(865, [$C5,$CB,$C2,$D4,$05                               ] , 'vcmpnltsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(866, [$C5,$CB,$C2,$11,$05                               ] , 'vcmpnltsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(867, [$C5,$CB,$C2,$D4,$06                               ] , 'vcmpnlesd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(868, [$C5,$CB,$C2,$11,$06                               ] , 'vcmpnlesd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(869, [$C5,$CB,$C2,$D4,$07                               ] , 'vcmpordsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(870, [$C5,$CB,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(871, [$C5,$CB,$C2,$D4,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(872, [$C5,$CB,$C2,$11,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(873, [$C5,$CB,$C2,$D4,$09                               ] , 'vcmpngesd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(874, [$C5,$CB,$C2,$11,$09                               ] , 'vcmpngesd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(875, [$C5,$CB,$C2,$D4,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(876, [$C5,$CB,$C2,$11,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(877, [$C5,$CB,$C2,$D4,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(878, [$C5,$CB,$C2,$11,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(879, [$C5,$CB,$C2,$D4,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(880, [$C5,$CB,$C2,$11,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(881, [$C5,$CB,$C2,$D4,$0D                               ] , 'vcmpgesd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(882, [$C5,$CB,$C2,$11,$0D                               ] , 'vcmpgesd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(883, [$C5,$CB,$C2,$D4,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(884, [$C5,$CB,$C2,$11,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(885, [$C5,$CB,$C2,$D4,$0F                               ] , 'vcmuesd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(886, [$C5,$CB,$C2,$11,$0F                               ] , 'vcmuesd  xmm2,xmm6,qword [ecx]'                   );
  TestCase.testcase(887, [$C5,$CB,$C2,$D4,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(888, [$C5,$CB,$C2,$11,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(889, [$C5,$CB,$C2,$D4,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(890, [$C5,$CB,$C2,$11,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(891, [$C5,$CB,$C2,$D4,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(892, [$C5,$CB,$C2,$11,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(893, [$C5,$CB,$C2,$D4,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(894, [$C5,$CB,$C2,$11,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,qword [ecx]'             );
  TestCase.testcase(895, [$C5,$CB,$C2,$D4,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(896, [$C5,$CB,$C2,$11,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(897, [$C5,$CB,$C2,$D4,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(898, [$C5,$CB,$C2,$11,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(899, [$C5,$CB,$C2,$D4,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(900, [$C5,$CB,$C2,$11,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(901, [$C5,$CB,$C2,$D4,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(902, [$C5,$CB,$C2,$11,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(903, [$C5,$CB,$C2,$D4,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(904, [$C5,$CB,$C2,$11,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(905, [$C5,$CB,$C2,$D4,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(906, [$C5,$CB,$C2,$11,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(907, [$C5,$CB,$C2,$D4,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(908, [$C5,$CB,$C2,$11,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(909, [$C5,$CB,$C2,$D4,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(910, [$C5,$CB,$C2,$11,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,qword [ecx]'            );
  TestCase.testcase(911, [$C5,$CB,$C2,$D4,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(912, [$C5,$CB,$C2,$11,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(913, [$C5,$CB,$C2,$D4,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(914, [$C5,$CB,$C2,$11,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(915, [$C5,$CB,$C2,$D4,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(916, [$C5,$CB,$C2,$11,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(917, [$C5,$CB,$C2,$D4,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(918, [$C5,$CB,$C2,$11,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,qword [ecx]'                );
  TestCase.testcase(919, [$C5,$F8,$AE,$11                                   ] , 'vldmxcsr  dword [ecx]'                            );
  TestCase.testcase(920, [$C5,$F8,$AE,$19                                   ] , 'vstmxcsr  dword [ecx]'                            );
  TestCase.testcase(921, [$C5,$CA,$58,$D4                                   ] , 'vaddss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(922, [$C5,$CA,$58,$11                                   ] , 'vaddss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(923, [$C5,$CA,$5A,$D4                                   ] , 'vcvtss2sd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(924, [$C5,$CA,$5A,$11                                   ] , 'vcvtss2sd  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(925, [$C5,$CA,$5E,$D4                                   ] , 'vdivss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(926, [$C5,$CA,$5E,$11                                   ] , 'vdivss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(927, [$C5,$CA,$5F,$D4                                   ] , 'vmaxss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(928, [$C5,$CA,$5F,$11                                   ] , 'vmaxss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(929, [$C5,$CA,$5D,$D4                                   ] , 'vminss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(930, [$C5,$CA,$5D,$11                                   ] , 'vminss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(931, [$C5,$CA,$59,$D4                                   ] , 'vmulss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(932, [$C5,$CA,$59,$11                                   ] , 'vmulss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(933, [$C5,$CA,$53,$D4                                   ] , 'vrcpss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(934, [$C5,$CA,$53,$11                                   ] , 'vrcpss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(935, [$C5,$CA,$52,$D4                                   ] , 'vrsqrtss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(936, [$C5,$CA,$52,$11                                   ] , 'vrsqrtss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(937, [$C5,$CA,$51,$D4                                   ] , 'vsqrtss  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(938, [$C5,$CA,$51,$11                                   ] , 'vsqrtss  xmm2,xmm6,dword [ecx]'                   );
  TestCase.testcase(939, [$C5,$CA,$5C,$D4                                   ] , 'vsubss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(940, [$C5,$CA,$5C,$11                                   ] , 'vsubss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(941, [$C5,$CA,$C2,$D4,$00                               ] , 'vcmpeqss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(942, [$C5,$CA,$C2,$11,$00                               ] , 'vcmpeqss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(943, [$C5,$CA,$C2,$D4,$01                               ] , 'vcmpltss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(944, [$C5,$CA,$C2,$11,$01                               ] , 'vcmpltss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(945, [$C5,$CA,$C2,$D4,$02                               ] , 'vcmpless  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(946, [$C5,$CA,$C2,$11,$02                               ] , 'vcmpless  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(947, [$C5,$CA,$C2,$D4,$03                               ] , 'vcmpunordss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(948, [$C5,$CA,$C2,$11,$03                               ] , 'vcmpunordss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(949, [$C5,$CA,$C2,$D4,$04                               ] , 'vcmpneqss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(950, [$C5,$CA,$C2,$11,$04                               ] , 'vcmpneqss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(951, [$C5,$CA,$C2,$D4,$05                               ] , 'vcmpnltss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(952, [$C5,$CA,$C2,$11,$05                               ] , 'vcmpnltss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(953, [$C5,$CA,$C2,$D4,$06                               ] , 'vcmpnless  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(954, [$C5,$CA,$C2,$11,$06                               ] , 'vcmpnless  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(955, [$C5,$CA,$C2,$D4,$07                               ] , 'vcmpordss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(956, [$C5,$CA,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(957, [$C5,$CA,$C2,$D4,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(958, [$C5,$CA,$C2,$11,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(959, [$C5,$CA,$C2,$D4,$09                               ] , 'vcmpngess  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(960, [$C5,$CA,$C2,$11,$09                               ] , 'vcmpngess  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(961, [$C5,$CA,$C2,$D4,$0A                               ] , 'vcmpngtss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(962, [$C5,$CA,$C2,$11,$0A                               ] , 'vcmpngtss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(963, [$C5,$CA,$C2,$D4,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(964, [$C5,$CA,$C2,$11,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(965, [$C5,$CA,$C2,$D4,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(966, [$C5,$CA,$C2,$11,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(967, [$C5,$CA,$C2,$D4,$0D                               ] , 'vcmpgess  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(968, [$C5,$CA,$C2,$11,$0D                               ] , 'vcmpgess  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(969, [$C5,$CA,$C2,$D4,$0E                               ] , 'vcmpgtss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(970, [$C5,$CA,$C2,$11,$0E                               ] , 'vcmpgtss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(971, [$C5,$CA,$C2,$D4,$0F                               ] , 'vcmuess  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(972, [$C5,$CA,$C2,$11,$0F                               ] , 'vcmuess  xmm2,xmm6,dword [ecx]'                   );
  TestCase.testcase(973, [$C5,$CA,$C2,$D4,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(974, [$C5,$CA,$C2,$11,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(975, [$C5,$CA,$C2,$D4,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(976, [$C5,$CA,$C2,$11,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(977, [$C5,$CA,$C2,$D4,$12                               ] , 'vcmple_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(978, [$C5,$CA,$C2,$11,$12                               ] , 'vcmple_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(979, [$C5,$CA,$C2,$D4,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(980, [$C5,$CA,$C2,$11,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,dword [ecx]'             );
  TestCase.testcase(981, [$C5,$CA,$C2,$D4,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(982, [$C5,$CA,$C2,$11,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(983, [$C5,$CA,$C2,$D4,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(984, [$C5,$CA,$C2,$11,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(985, [$C5,$CA,$C2,$D4,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(986, [$C5,$CA,$C2,$11,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(987, [$C5,$CA,$C2,$D4,$17                               ] , 'vcmpord_sss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(988, [$C5,$CA,$C2,$11,$17                               ] , 'vcmpord_sss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(989, [$C5,$CA,$C2,$D4,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(990, [$C5,$CA,$C2,$11,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(991, [$C5,$CA,$C2,$D4,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(992, [$C5,$CA,$C2,$11,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(993, [$C5,$CA,$C2,$D4,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(994, [$C5,$CA,$C2,$11,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(995, [$C5,$CA,$C2,$D4,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(996, [$C5,$CA,$C2,$11,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,dword [ecx]'            );
  TestCase.testcase(997, [$C5,$CA,$C2,$D4,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(998, [$C5,$CA,$C2,$11,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(999, [$C5,$CA,$C2,$D4,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(1000, [$C5,$CA,$C2,$11,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(1001, [$C5,$CA,$C2,$D4,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(1002, [$C5,$CA,$C2,$11,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(1003, [$C5,$CA,$C2,$D4,$1F                               ] , 'vcmue_usss  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(1004, [$C5,$CA,$C2,$11,$1F                               ] , 'vcmue_usss  xmm2,xmm6,dword [ecx]'                );
  TestCase.testcase(1005, [$C4,$E2,$7D,$18,$21                               ] , 'vbroadcastss  ymm4,dword [ecx]'                   );
  TestCase.testcase(1006, [$C5,$F8,$2F,$F4                                   ] , 'vcomiss  xmm6,xmm4'                               );
  TestCase.testcase(1007, [$C5,$F8,$2F,$21                                   ] , 'vcomiss  xmm4,dword [ecx]'                        );
  TestCase.testcase(1008, [$C4,$E2,$79,$21,$F4                               ] , 'vpmovsxbd  xmm6,xmm4'                             );
  TestCase.testcase(1009, [$C4,$E2,$79,$21,$21                               ] , 'vpmovsxbd  xmm4,dword [ecx]'                      );
  TestCase.testcase(1010, [$C4,$E2,$79,$24,$F4                               ] , 'vpmovsxwq  xmm6,xmm4'                             );
  TestCase.testcase(1011, [$C4,$E2,$79,$24,$21                               ] , 'vpmovsxwq  xmm4,dword [ecx]'                      );
  TestCase.testcase(1012, [$C4,$E2,$79,$31,$F4                               ] , 'vpmovzxbd  xmm6,xmm4'                             );
  TestCase.testcase(1013, [$C4,$E2,$79,$31,$21                               ] , 'vpmovzxbd  xmm4,dword [ecx]'                      );
  TestCase.testcase(1014, [$C4,$E2,$79,$34,$F4                               ] , 'vpmovzxwq  xmm6,xmm4'                             );
  TestCase.testcase(1015, [$C4,$E2,$79,$34,$21                               ] , 'vpmovzxwq  xmm4,dword [ecx]'                      );
  TestCase.testcase(1016, [$C5,$F8,$2E,$F4                                   ] , 'vucomiss  xmm6,xmm4'                              );
  TestCase.testcase(1017, [$C5,$F8,$2E,$21                                   ] , 'vucomiss  xmm4,dword [ecx]'                       );
  TestCase.testcase(1018, [$C4,$E2,$79,$18,$21                               ] , 'vbroadcastss  xmm4,dword [ecx]'                   );
  TestCase.testcase(1019, [$C5,$FA,$10,$21                                   ] , 'vmovss  xmm4,dword [ecx]'                         );
  TestCase.testcase(1020, [$C5,$FA,$11,$21                                   ] , 'vmovss  dword [ecx],xmm4'                         );
  TestCase.testcase(1021, [$C5,$F9,$7E,$E1                                   ] , 'vmovd  ecx,xmm4'                                  );
  TestCase.testcase(1022, [$C5,$F9,$7E,$21                                   ] , 'vmovd  dword [ecx],xmm4'                          );
  TestCase.testcase(1023, [$C5,$F9,$6E,$E1                                   ] , 'vmovd  xmm4,ecx'                                  );
  TestCase.testcase(1024, [$C5,$F9,$6E,$21                                   ] , 'vmovd  xmm4,dword [ecx]'                          );
  TestCase.testcase(1025, [$C5,$FA,$2D,$CC                                   ] , 'vcvtss2si  ecx,xmm4'                              );
  TestCase.testcase(1026, [$C5,$FA,$2D,$09                                   ] , 'vcvtss2si  ecx,dword [ecx]'                       );
  TestCase.testcase(1027, [$C5,$FA,$2C,$CC                                   ] , 'vcvttss2si  ecx,xmm4'                             );
  TestCase.testcase(1028, [$C5,$FA,$2C,$09                                   ] , 'vcvttss2si  ecx,dword [ecx]'                      );
  TestCase.testcase(1029, [$C4,$E3,$79,$17,$21,$07                           ] , 'vextractps  dword [ecx],xmm4,0x7'                 );
  TestCase.testcase(1030, [$C4,$E3,$79,$16,$E1,$07                           ] , 'vpextrd  ecx,xmm4,0x7'                            );
  TestCase.testcase(1031, [$C4,$E3,$79,$16,$21,$07                           ] , 'vpextrd  dword [ecx],xmm4,0x7'                    );
  TestCase.testcase(1032, [$C4,$E3,$79,$17,$E1,$07                           ] , 'vextractps  ecx,xmm4,0x7'                         );
  TestCase.testcase(1033, [$C4,$E3,$79,$17,$21,$07                           ] , 'vextractps  dword [ecx],xmm4,0x7'                 );
  TestCase.testcase(1034, [$C4,$E3,$59,$22,$F1,$07                           ] , 'vpinsrd  xmm6,xmm4,ecx,0x7'                       );
  TestCase.testcase(1035, [$C4,$E3,$59,$22,$31,$07                           ] , 'vpinsrd  xmm6,xmm4,dword [ecx],0x7'               );
  TestCase.testcase(1036, [$C5,$DB,$2A,$F1                                   ] , 'vcvtsi2sd  xmm6,xmm4,ecx'                         );
  TestCase.testcase(1037, [$C5,$DB,$2A,$31                                   ] , 'vcvtsi2sd  xmm6,xmm4,dword [ecx]'                 );
  TestCase.testcase(1038, [$C5,$DA,$2A,$F1                                   ] , 'vcvtsi2ss  xmm6,xmm4,ecx'                         );
  TestCase.testcase(1039, [$C5,$DA,$2A,$31                                   ] , 'vcvtsi2ss  xmm6,xmm4,dword [ecx]'                 );
  TestCase.testcase(1040, [$C5,$CA,$C2,$D4,$07                               ] , 'vcmpordss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(1041, [$C5,$CA,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(1042, [$C4,$E3,$49,$21,$D4,$07                           ] , 'vinsertps  xmm2,xmm6,xmm4,0x7'                    );
  TestCase.testcase(1043, [$C4,$E3,$49,$21,$11,$07                           ] , 'vinsertps  xmm2,xmm6,dword [ecx],0x7'             );
  TestCase.testcase(1044, [$C4,$E3,$49,$0A,$D4,$07                           ] , 'vroundss  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(1045, [$C4,$E3,$49,$0A,$11,$07                           ] , 'vroundss  xmm2,xmm6,dword [ecx],0x7'              );
  TestCase.testcase(1046, [$C4,$E2,$79,$22,$F4                               ] , 'vpmovsxbq  xmm6,xmm4'                             );
  TestCase.testcase(1047, [$C4,$E2,$79,$22,$21                               ] , 'vpmovsxbq  xmm4,word [ecx]'                       );
  TestCase.testcase(1048, [$C4,$E2,$79,$32,$F4                               ] , 'vpmovzxbq  xmm6,xmm4'                             );
  TestCase.testcase(1049, [$C4,$E2,$79,$32,$21                               ] , 'vpmovzxbq  xmm4,word [ecx]'                       );
  TestCase.testcase(1050, [$C5,$F9,$C5,$CC,$07                               ] , 'vpextrw  ecx,xmm4,0x7'                            );
  TestCase.testcase(1051, [$C4,$E3,$79,$15,$21,$07                           ] , 'vpextrw  word [ecx],xmm4,0x7'                     );
  TestCase.testcase(1052, [$C4,$E3,$79,$15,$21,$07                           ] , 'vpextrw  word [ecx],xmm4,0x7'                     );
  TestCase.testcase(1053, [$C5,$D9,$C4,$F1,$07                               ] , 'vpinsrw  xmm6,xmm4,ecx,0x7'                       );
  TestCase.testcase(1054, [$C5,$D9,$C4,$31,$07                               ] , 'vpinsrw  xmm6,xmm4,word [ecx],0x7'                );
  TestCase.testcase(1055, [$C4,$E3,$79,$14,$E1,$07                           ] , 'vpextrb  ecx,xmm4,0x7'                            );
  TestCase.testcase(1056, [$C4,$E3,$79,$14,$21,$07                           ] , 'vpextrb  byte [ecx],xmm4,0x7'                     );
  TestCase.testcase(1057, [$C4,$E3,$59,$20,$F1,$07                           ] , 'vpinsrb  xmm6,xmm4,ecx,0x7'                       );
  TestCase.testcase(1058, [$C4,$E3,$59,$20,$31,$07                           ] , 'vpinsrb  xmm6,xmm4,byte [ecx],0x7'                );
  TestCase.testcase(1059, [$C4,$E3,$79,$14,$21,$07                           ] , 'vpextrb  byte [ecx],xmm4,0x7'                     );
  TestCase.testcase(1060, [$C5,$F9,$F7,$F4                                   ] , 'vmaskmovdqu  xmm6,xmm4'                           );
  TestCase.testcase(1061, [$C5,$FA,$7E,$F4                                   ] , 'vmovq  xmm6,xmm4'                                 );
  TestCase.testcase(1062, [$C5,$F9,$50,$CC                                   ] , 'vmovmskpd  ecx,xmm4'                              );
  TestCase.testcase(1063, [$C5,$F8,$50,$CC                                   ] , 'vmovmskps  ecx,xmm4'                              );
  TestCase.testcase(1064, [$C5,$F9,$D7,$CC                                   ] , 'vpmovmskb  ecx,xmm4'                              );
  TestCase.testcase(1065, [$C5,$C8,$12,$D4                                   ] , 'vmovhlps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(1066, [$C5,$C8,$16,$D4                                   ] , 'vmovlhps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(1067, [$C5,$CB,$10,$D4                                   ] , 'vmovsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1068, [$C5,$CA,$10,$D4                                   ] , 'vmovss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1069, [$C5,$C9,$72,$F4,$07                               ] , 'vpslld  xmm6,xmm4,0x7'                            );
  TestCase.testcase(1070, [$C5,$C9,$73,$FC,$07                               ] , 'vpslldq  xmm6,xmm4,0x7'                           );
  TestCase.testcase(1071, [$C5,$C9,$73,$F4,$07                               ] , 'vpsllq  xmm6,xmm4,0x7'                            );
  TestCase.testcase(1072, [$C5,$C9,$71,$F4,$07                               ] , 'vpsllw  xmm6,xmm4,0x7'                            );
  TestCase.testcase(1073, [$C5,$C9,$72,$E4,$07                               ] , 'vpsrad  xmm6,xmm4,0x7'                            );
  TestCase.testcase(1074, [$C5,$C9,$71,$E4,$07                               ] , 'vpsraw  xmm6,xmm4,0x7'                            );
  TestCase.testcase(1075, [$C5,$C9,$72,$D4,$07                               ] , 'vpsrld  xmm6,xmm4,0x7'                            );
  TestCase.testcase(1076, [$C5,$C9,$73,$DC,$07                               ] , 'vpsrldq  xmm6,xmm4,0x7'                           );
  TestCase.testcase(1077, [$C5,$C9,$73,$D4,$07                               ] , 'vpsrlq  xmm6,xmm4,0x7'                            );
  TestCase.testcase(1078, [$C5,$C9,$71,$D4,$07                               ] , 'vpsrlw  xmm6,xmm4,0x7'                            );
  TestCase.testcase(1079, [$C5,$F9,$C5,$CC,$07                               ] , 'vpextrw  ecx,xmm4,0x7'                            );
  TestCase.testcase(1080, [$C5,$FD,$50,$CC                                   ] , 'vmovmskpd  ecx,ymm4'                              );
  TestCase.testcase(1081, [$C5,$FC,$50,$CC                                   ] , 'vmovmskps  ecx,ymm4'                              );
  TestCase.testcase(1082, [$C5,$FB,$E6,$F4                                   ] , 'vcvtpd2dq  xmm6,xmm4'                             );
  TestCase.testcase(1083, [$C5,$FF,$E6,$F4                                   ] , 'vcvtpd2dq  xmm6,ymm4'                             );
  TestCase.testcase(1084, [$C5,$F9,$5A,$F4                                   ] , 'vcvtpd2ps  xmm6,xmm4'                             );
  TestCase.testcase(1085, [$C5,$FD,$5A,$F4                                   ] , 'vcvtpd2ps  xmm6,ymm4'                             );
  TestCase.testcase(1086, [$C5,$F9,$E6,$F4                                   ] , 'vcvttpd2dq  xmm6,xmm4'                            );
  TestCase.testcase(1087, [$C5,$FD,$E6,$F4                                   ] , 'vcvttpd2dq  xmm6,ymm4'                            );
  TestCase.testcase(1088, [$C5,$F8,$AE,$15,$34,$12,$00,$00                   ] , 'vldmxcsr  dword ds:[0x1234]'                      );
  TestCase.testcase(1089, [$C5,$F9,$6F,$05,$34,$12,$00,$00                   ] , 'vmovdqa  xmm0,oword ds:[0x1234]'                  );
  TestCase.testcase(1090, [$C5,$F9,$7F,$05,$34,$12,$00,$00                   ] , 'vmovdqa  oword ds:[0x1234],xmm0'                  );
  TestCase.testcase(1091, [$C5,$F9,$7E,$05,$34,$12,$00,$00                   ] , 'vmovd  dword ds:[0x1234],xmm0'                    );
  TestCase.testcase(1092, [$C5,$FB,$2D,$05,$34,$12,$00,$00                   ] , 'vcvtsd2si  eax,qword ds:[0x1234]'                 );
  TestCase.testcase(1093, [$C5,$FE,$E6,$05,$34,$12,$00,$00                   ] , 'vcvtdq2pd  ymm0,oword ds:[0x1234]'                );
  TestCase.testcase(1094, [$C5,$FD,$5A,$05,$34,$12,$00,$00                   ] , 'vcvtpd2ps  xmm0,yword ds:[0x1234]'                );
  TestCase.testcase(1095, [$C5,$F9,$E0,$3D,$34,$12,$00,$00                   ] , 'vpavgb  xmm7,xmm0,oword ds:[0x1234]'              );
  TestCase.testcase(1096, [$C4,$E3,$79,$DF,$05,$34,$12,$00,$00,$07           ] , 'vaeskeygenassist  xmm0,oword ds:[0x1234],0x7'     );
  TestCase.testcase(1097, [$C4,$E3,$79,$14,$05,$34,$12,$00,$00,$07           ] , 'vpextrb  byte ds:[0x1234],xmm0,0x7'               );
  TestCase.testcase(1098, [$C5,$FB,$2A,$3D,$34,$12,$00,$00                   ] , 'vcvtsi2sd  xmm7,xmm0,dword ds:[0x1234]'           );
  TestCase.testcase(1099, [$C4,$E3,$79,$44,$3D,$34,$12,$00,$00,$07           ] , 'vpclmulqdq  xmm7,xmm0,oword ds:[0x1234],0x7'      );
  TestCase.testcase(1100, [$C4,$E3,$59,$4A,$35,$34,$12,$00,$00,$00           ] , 'vblendvps  xmm6,xmm4,oword ds:[0x1234],xmm0'      );
  TestCase.testcase(1101, [$C4,$E3,$79,$20,$3D,$34,$12,$00,$00,$07           ] , 'vpinsrb  xmm7,xmm0,byte ds:[0x1234],0x7'          );
  TestCase.testcase(1102, [$C5,$FD,$6F,$05,$34,$12,$00,$00                   ] , 'vmovdqa  ymm0,yword ds:[0x1234]'                  );
  TestCase.testcase(1103, [$C5,$FD,$7F,$05,$34,$12,$00,$00                   ] , 'vmovdqa  yword ds:[0x1234],ymm0'                  );
  TestCase.testcase(1104, [$C4,$E2,$7D,$0D,$3D,$34,$12,$00,$00               ] , 'vpermilpd  ymm7,ymm0,yword ds:[0x1234]'           );
  TestCase.testcase(1105, [$C4,$E3,$7D,$09,$05,$34,$12,$00,$00,$07           ] , 'vroundpd  ymm0,yword ds:[0x1234],0x7'             );
  TestCase.testcase(1106, [$C4,$E3,$7D,$19,$05,$34,$12,$00,$00,$07           ] , 'vextractf128  oword ds:[0x1234],ymm0,0x7'         );
  TestCase.testcase(1107, [$C4,$E3,$7D,$06,$3D,$34,$12,$00,$00,$07           ] , 'vperm2f128  ymm7,ymm0,yword ds:[0x1234],0x7'      );
  TestCase.testcase(1108, [$C4,$E3,$5D,$4B,$35,$34,$12,$00,$00,$00           ] , 'vblendvpd  ymm6,ymm4,yword ds:[0x1234],ymm0'      );
  TestCase.testcase(1109, [$C5,$F8,$AE,$55,$00                               ] , 'vldmxcsr  dword [ebp+0x0]'                        );
  TestCase.testcase(1110, [$C5,$F9,$6F,$45,$00                               ] , 'vmovdqa  xmm0,oword [ebp+0x0]'                    );
  TestCase.testcase(1111, [$C5,$F9,$7F,$45,$00                               ] , 'vmovdqa  oword [ebp+0x0],xmm0'                    );
  TestCase.testcase(1112, [$C5,$F9,$7E,$45,$00                               ] , 'vmovd  dword [ebp+0x0],xmm0'                      );
  TestCase.testcase(1113, [$C5,$FB,$2D,$45,$00                               ] , 'vcvtsd2si  eax,qword [ebp+0x0]'                   );
  TestCase.testcase(1114, [$C5,$FE,$E6,$45,$00                               ] , 'vcvtdq2pd  ymm0,oword [ebp+0x0]'                  );
  TestCase.testcase(1115, [$C5,$FD,$5A,$45,$00                               ] , 'vcvtpd2ps  xmm0,yword [ebp+0x0]'                  );
  TestCase.testcase(1116, [$C5,$F9,$E0,$7D,$00                               ] , 'vpavgb  xmm7,xmm0,oword [ebp+0x0]'                );
  TestCase.testcase(1117, [$C4,$E3,$79,$DF,$45,$00,$07                       ] , 'vaeskeygenassist  xmm0,oword [ebp+0x0],0x7'       );
  TestCase.testcase(1118, [$C4,$E3,$79,$14,$45,$00,$07                       ] , 'vpextrb  byte [ebp+0x0],xmm0,0x7'                 );
  TestCase.testcase(1119, [$C5,$FB,$2A,$7D,$00                               ] , 'vcvtsi2sd  xmm7,xmm0,dword [ebp+0x0]'             );
  TestCase.testcase(1120, [$C4,$E3,$79,$44,$7D,$00,$07                       ] , 'vpclmulqdq  xmm7,xmm0,oword [ebp+0x0],0x7'        );
  TestCase.testcase(1121, [$C4,$E3,$59,$4A,$75,$00,$00                       ] , 'vblendvps  xmm6,xmm4,oword [ebp+0x0],xmm0'        );
  TestCase.testcase(1122, [$C4,$E3,$79,$20,$7D,$00,$07                       ] , 'vpinsrb  xmm7,xmm0,byte [ebp+0x0],0x7'            );
  TestCase.testcase(1123, [$C5,$FD,$6F,$45,$00                               ] , 'vmovdqa  ymm0,yword [ebp+0x0]'                    );
  TestCase.testcase(1124, [$C5,$FD,$7F,$45,$00                               ] , 'vmovdqa  yword [ebp+0x0],ymm0'                    );
  TestCase.testcase(1125, [$C4,$E2,$7D,$0D,$7D,$00                           ] , 'vpermilpd  ymm7,ymm0,yword [ebp+0x0]'             );
  TestCase.testcase(1126, [$C4,$E3,$7D,$09,$45,$00,$07                       ] , 'vroundpd  ymm0,yword [ebp+0x0],0x7'               );
  TestCase.testcase(1127, [$C4,$E3,$7D,$19,$45,$00,$07                       ] , 'vextractf128  oword [ebp+0x0],ymm0,0x7'           );
  TestCase.testcase(1128, [$C4,$E3,$7D,$06,$7D,$00,$07                       ] , 'vperm2f128  ymm7,ymm0,yword [ebp+0x0],0x7'        );
  TestCase.testcase(1129, [$C4,$E3,$5D,$4B,$75,$00,$00                       ] , 'vblendvpd  ymm6,ymm4,yword [ebp+0x0],ymm0'        );
  TestCase.testcase(1130, [$C5,$F8,$AE,$14,$24                               ] , 'vldmxcsr  dword [esp]'                            );
  TestCase.testcase(1131, [$C5,$F9,$6F,$04,$24                               ] , 'vmovdqa  xmm0,oword [esp]'                        );
  TestCase.testcase(1132, [$C5,$F9,$7F,$04,$24                               ] , 'vmovdqa  oword [esp],xmm0'                        );
  TestCase.testcase(1133, [$C5,$F9,$7E,$04,$24                               ] , 'vmovd  dword [esp],xmm0'                          );
  TestCase.testcase(1134, [$C5,$FB,$2D,$04,$24                               ] , 'vcvtsd2si  eax,qword [esp]'                       );
  TestCase.testcase(1135, [$C5,$FE,$E6,$04,$24                               ] , 'vcvtdq2pd  ymm0,oword [esp]'                      );
  TestCase.testcase(1136, [$C5,$FD,$5A,$04,$24                               ] , 'vcvtpd2ps  xmm0,yword [esp]'                      );
  TestCase.testcase(1137, [$C5,$F9,$E0,$3C,$24                               ] , 'vpavgb  xmm7,xmm0,oword [esp]'                    );
  TestCase.testcase(1138, [$C4,$E3,$79,$DF,$04,$24,$07                       ] , 'vaeskeygenassist  xmm0,oword [esp],0x7'           );
  TestCase.testcase(1139, [$C4,$E3,$79,$14,$04,$24,$07                       ] , 'vpextrb  byte [esp],xmm0,0x7'                     );
  TestCase.testcase(1140, [$C5,$FB,$2A,$3C,$24                               ] , 'vcvtsi2sd  xmm7,xmm0,dword [esp]'                 );
  TestCase.testcase(1141, [$C4,$E3,$79,$44,$3C,$24,$07                       ] , 'vpclmulqdq  xmm7,xmm0,oword [esp],0x7'            );
  TestCase.testcase(1142, [$C4,$E3,$59,$4A,$34,$24,$00                       ] , 'vblendvps  xmm6,xmm4,oword [esp],xmm0'            );
  TestCase.testcase(1143, [$C4,$E3,$79,$20,$3C,$24,$07                       ] , 'vpinsrb  xmm7,xmm0,byte [esp],0x7'                );
  TestCase.testcase(1144, [$C5,$FD,$6F,$04,$24                               ] , 'vmovdqa  ymm0,yword [esp]'                        );
  TestCase.testcase(1145, [$C5,$FD,$7F,$04,$24                               ] , 'vmovdqa  yword [esp],ymm0'                        );
  TestCase.testcase(1146, [$C4,$E2,$7D,$0D,$3C,$24                           ] , 'vpermilpd  ymm7,ymm0,yword [esp]'                 );
  TestCase.testcase(1147, [$C4,$E3,$7D,$09,$04,$24,$07                       ] , 'vroundpd  ymm0,yword [esp],0x7'                   );
  TestCase.testcase(1148, [$C4,$E3,$7D,$19,$04,$24,$07                       ] , 'vextractf128  oword [esp],ymm0,0x7'               );
  TestCase.testcase(1149, [$C4,$E3,$7D,$06,$3C,$24,$07                       ] , 'vperm2f128  ymm7,ymm0,yword [esp],0x7'            );
  TestCase.testcase(1150, [$C4,$E3,$5D,$4B,$34,$24,$00                       ] , 'vblendvpd  ymm6,ymm4,yword [esp],ymm0'            );
  TestCase.testcase(1151, [$C5,$F8,$AE,$95,$99,$00,$00,$00                   ] , 'vldmxcsr  dword [ebp+0x99]'                       );
  TestCase.testcase(1152, [$C5,$F9,$6F,$85,$99,$00,$00,$00                   ] , 'vmovdqa  xmm0,oword [ebp+0x99]'                   );
  TestCase.testcase(1153, [$C5,$F9,$7F,$85,$99,$00,$00,$00                   ] , 'vmovdqa  oword [ebp+0x99],xmm0'                   );
  TestCase.testcase(1154, [$C5,$F9,$7E,$85,$99,$00,$00,$00                   ] , 'vmovd  dword [ebp+0x99],xmm0'                     );
  TestCase.testcase(1155, [$C5,$FB,$2D,$85,$99,$00,$00,$00                   ] , 'vcvtsd2si  eax,qword [ebp+0x99]'                  );
  TestCase.testcase(1156, [$C5,$FE,$E6,$85,$99,$00,$00,$00                   ] , 'vcvtdq2pd  ymm0,oword [ebp+0x99]'                 );
  TestCase.testcase(1157, [$C5,$FD,$5A,$85,$99,$00,$00,$00                   ] , 'vcvtpd2ps  xmm0,yword [ebp+0x99]'                 );
  TestCase.testcase(1158, [$C5,$F9,$E0,$BD,$99,$00,$00,$00                   ] , 'vpavgb  xmm7,xmm0,oword [ebp+0x99]'               );
  TestCase.testcase(1159, [$C4,$E3,$79,$DF,$85,$99,$00,$00,$00,$07           ] , 'vaeskeygenassist  xmm0,oword [ebp+0x99],0x7'      );
  TestCase.testcase(1160, [$C4,$E3,$79,$14,$85,$99,$00,$00,$00,$07           ] , 'vpextrb  byte [ebp+0x99],xmm0,0x7'                );
  TestCase.testcase(1161, [$C5,$FB,$2A,$BD,$99,$00,$00,$00                   ] , 'vcvtsi2sd  xmm7,xmm0,dword [ebp+0x99]'            );
  TestCase.testcase(1162, [$C4,$E3,$79,$44,$BD,$99,$00,$00,$00,$07           ] , 'vpclmulqdq  xmm7,xmm0,oword [ebp+0x99],0x7'       );
  TestCase.testcase(1163, [$C4,$E3,$59,$4A,$B5,$99,$00,$00,$00,$00           ] , 'vblendvps  xmm6,xmm4,oword [ebp+0x99],xmm0'       );
  TestCase.testcase(1164, [$C4,$E3,$79,$20,$BD,$99,$00,$00,$00,$07           ] , 'vpinsrb  xmm7,xmm0,byte [ebp+0x99],0x7'           );
  TestCase.testcase(1165, [$C5,$FD,$6F,$85,$99,$00,$00,$00                   ] , 'vmovdqa  ymm0,yword [ebp+0x99]'                   );
  TestCase.testcase(1166, [$C5,$FD,$7F,$85,$99,$00,$00,$00                   ] , 'vmovdqa  yword [ebp+0x99],ymm0'                   );
  TestCase.testcase(1167, [$C4,$E2,$7D,$0D,$BD,$99,$00,$00,$00               ] , 'vpermilpd  ymm7,ymm0,yword [ebp+0x99]'            );
  TestCase.testcase(1168, [$C4,$E3,$7D,$09,$85,$99,$00,$00,$00,$07           ] , 'vroundpd  ymm0,yword [ebp+0x99],0x7'              );
  TestCase.testcase(1169, [$C4,$E3,$7D,$19,$85,$99,$00,$00,$00,$07           ] , 'vextractf128  oword [ebp+0x99],ymm0,0x7'          );
  TestCase.testcase(1170, [$C4,$E3,$7D,$06,$BD,$99,$00,$00,$00,$07           ] , 'vperm2f128  ymm7,ymm0,yword [ebp+0x99],0x7'       );
  TestCase.testcase(1171, [$C4,$E3,$5D,$4B,$B5,$99,$00,$00,$00,$00           ] , 'vblendvpd  ymm6,ymm4,yword [ebp+0x99],ymm0'       );
  TestCase.testcase(1172, [$C5,$F8,$AE,$14,$25,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eiz*1+0x99]'                     );
  TestCase.testcase(1173, [$C5,$F9,$6F,$04,$25,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eiz*1+0x99]'                 );
  TestCase.testcase(1174, [$C5,$F9,$7F,$04,$25,$99,$00,$00,$00               ] , 'vmovdqa  oword [eiz*1+0x99],xmm0'                 );
  TestCase.testcase(1175, [$C5,$F9,$7E,$04,$25,$99,$00,$00,$00               ] , 'vmovd  dword [eiz*1+0x99],xmm0'                   );
  TestCase.testcase(1176, [$C5,$FB,$2D,$04,$25,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eiz*1+0x99]'                );
  TestCase.testcase(1177, [$C5,$FE,$E6,$04,$25,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eiz*1+0x99]'               );
  TestCase.testcase(1178, [$C5,$FD,$5A,$04,$25,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eiz*1+0x99]'               );
  TestCase.testcase(1179, [$C5,$F9,$E0,$3C,$25,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eiz*1+0x99]'             );
  TestCase.testcase(1180, [$C4,$E3,$79,$DF,$04,$25,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eiz*1+0x99],0x7'    );
  TestCase.testcase(1181, [$C4,$E3,$79,$14,$04,$25,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eiz*1+0x99],xmm0,0x7'              );
  TestCase.testcase(1182, [$C5,$FB,$2A,$3C,$25,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eiz*1+0x99]'          );
  TestCase.testcase(1183, [$C4,$E3,$79,$44,$3C,$25,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eiz*1+0x99],0x7'     );
  TestCase.testcase(1184, [$C4,$E3,$59,$4A,$34,$25,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eiz*1+0x99],xmm0'     );
  TestCase.testcase(1185, [$C4,$E3,$79,$20,$3C,$25,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eiz*1+0x99],0x7'         );
  TestCase.testcase(1186, [$C5,$FD,$6F,$04,$25,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eiz*1+0x99]'                 );
  TestCase.testcase(1187, [$C5,$FD,$7F,$04,$25,$99,$00,$00,$00               ] , 'vmovdqa  yword [eiz*1+0x99],ymm0'                 );
  TestCase.testcase(1188, [$C4,$E2,$7D,$0D,$3C,$25,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eiz*1+0x99]'          );
  TestCase.testcase(1189, [$C4,$E3,$7D,$09,$04,$25,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eiz*1+0x99],0x7'            );
  TestCase.testcase(1190, [$C4,$E3,$7D,$19,$04,$25,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eiz*1+0x99],ymm0,0x7'        );
  TestCase.testcase(1191, [$C4,$E3,$7D,$06,$3C,$25,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eiz*1+0x99],0x7'     );
  TestCase.testcase(1192, [$C4,$E3,$5D,$4B,$34,$25,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eiz*1+0x99],ymm0'     );
  TestCase.testcase(1193, [$C5,$F8,$AE,$14,$65,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eiz*2+0x99]'                     );
  TestCase.testcase(1194, [$C5,$F9,$6F,$04,$65,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eiz*2+0x99]'                 );
  TestCase.testcase(1195, [$C5,$F9,$7F,$04,$65,$99,$00,$00,$00               ] , 'vmovdqa  oword [eiz*2+0x99],xmm0'                 );
  TestCase.testcase(1196, [$C5,$F9,$7E,$04,$65,$99,$00,$00,$00               ] , 'vmovd  dword [eiz*2+0x99],xmm0'                   );
  TestCase.testcase(1197, [$C5,$FB,$2D,$04,$65,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eiz*2+0x99]'                );
  TestCase.testcase(1198, [$C5,$FE,$E6,$04,$65,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eiz*2+0x99]'               );
  TestCase.testcase(1199, [$C5,$FD,$5A,$04,$65,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eiz*2+0x99]'               );
  TestCase.testcase(1200, [$C5,$F9,$E0,$3C,$65,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eiz*2+0x99]'             );
  TestCase.testcase(1201, [$C4,$E3,$79,$DF,$04,$65,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eiz*2+0x99],0x7'    );
  TestCase.testcase(1202, [$C4,$E3,$79,$14,$04,$65,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eiz*2+0x99],xmm0,0x7'              );
  TestCase.testcase(1203, [$C5,$FB,$2A,$3C,$65,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eiz*2+0x99]'          );
  TestCase.testcase(1204, [$C4,$E3,$79,$44,$3C,$65,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eiz*2+0x99],0x7'     );
  TestCase.testcase(1205, [$C4,$E3,$59,$4A,$34,$65,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eiz*2+0x99],xmm0'     );
  TestCase.testcase(1206, [$C4,$E3,$79,$20,$3C,$65,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eiz*2+0x99],0x7'         );
  TestCase.testcase(1207, [$C5,$FD,$6F,$04,$65,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eiz*2+0x99]'                 );
  TestCase.testcase(1208, [$C5,$FD,$7F,$04,$65,$99,$00,$00,$00               ] , 'vmovdqa  yword [eiz*2+0x99],ymm0'                 );
  TestCase.testcase(1209, [$C4,$E2,$7D,$0D,$3C,$65,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eiz*2+0x99]'          );
  TestCase.testcase(1210, [$C4,$E3,$7D,$09,$04,$65,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eiz*2+0x99],0x7'            );
  TestCase.testcase(1211, [$C4,$E3,$7D,$19,$04,$65,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eiz*2+0x99],ymm0,0x7'        );
  TestCase.testcase(1212, [$C4,$E3,$7D,$06,$3C,$65,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eiz*2+0x99],0x7'     );
  TestCase.testcase(1213, [$C4,$E3,$5D,$4B,$34,$65,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eiz*2+0x99],ymm0'     );
  TestCase.testcase(1214, [$C5,$F8,$AE,$94,$20,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eax+eiz*1+0x99]'                 );
  TestCase.testcase(1215, [$C5,$F9,$6F,$84,$20,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eax+eiz*1+0x99]'             );
  TestCase.testcase(1216, [$C5,$F9,$7F,$84,$20,$99,$00,$00,$00               ] , 'vmovdqa  oword [eax+eiz*1+0x99],xmm0'             );
  TestCase.testcase(1217, [$C5,$F9,$7E,$84,$20,$99,$00,$00,$00               ] , 'vmovd  dword [eax+eiz*1+0x99],xmm0'               );
  TestCase.testcase(1218, [$C5,$FB,$2D,$84,$20,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eax+eiz*1+0x99]'            );
  TestCase.testcase(1219, [$C5,$FE,$E6,$84,$20,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eax+eiz*1+0x99]'           );
  TestCase.testcase(1220, [$C5,$FD,$5A,$84,$20,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eax+eiz*1+0x99]'           );
  TestCase.testcase(1221, [$C5,$F9,$E0,$BC,$20,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eax+eiz*1+0x99]'         );
  TestCase.testcase(1222, [$C4,$E3,$79,$DF,$84,$20,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eax+eiz*1+0x99],0x7' );
  TestCase.testcase(1223, [$C4,$E3,$79,$14,$84,$20,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eax+eiz*1+0x99],xmm0,0x7'          );
  TestCase.testcase(1224, [$C5,$FB,$2A,$BC,$20,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eax+eiz*1+0x99]'      );
  TestCase.testcase(1225, [$C4,$E3,$79,$44,$BC,$20,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eax+eiz*1+0x99],0x7' );
  TestCase.testcase(1226, [$C4,$E3,$59,$4A,$B4,$20,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eax+eiz*1+0x99],xmm0' );
  TestCase.testcase(1227, [$C4,$E3,$79,$20,$BC,$20,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eax+eiz*1+0x99],0x7'     );
  TestCase.testcase(1228, [$C5,$FD,$6F,$84,$20,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eax+eiz*1+0x99]'             );
  TestCase.testcase(1229, [$C5,$FD,$7F,$84,$20,$99,$00,$00,$00               ] , 'vmovdqa  yword [eax+eiz*1+0x99],ymm0'             );
  TestCase.testcase(1230, [$C4,$E2,$7D,$0D,$BC,$20,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eax+eiz*1+0x99]'      );
  TestCase.testcase(1231, [$C4,$E3,$7D,$09,$84,$20,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eax+eiz*1+0x99],0x7'        );
  TestCase.testcase(1232, [$C4,$E3,$7D,$19,$84,$20,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eax+eiz*1+0x99],ymm0,0x7'    );
  TestCase.testcase(1233, [$C4,$E3,$7D,$06,$BC,$20,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eax+eiz*1+0x99],0x7' );
  TestCase.testcase(1234, [$C4,$E3,$5D,$4B,$B4,$20,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eax+eiz*1+0x99],ymm0' );
  TestCase.testcase(1235, [$C5,$F8,$AE,$94,$60,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eax+eiz*2+0x99]'                 );
  TestCase.testcase(1236, [$C5,$F9,$6F,$84,$60,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eax+eiz*2+0x99]'             );
  TestCase.testcase(1237, [$C5,$F9,$7F,$84,$60,$99,$00,$00,$00               ] , 'vmovdqa  oword [eax+eiz*2+0x99],xmm0'             );
  TestCase.testcase(1238, [$C5,$F9,$7E,$84,$60,$99,$00,$00,$00               ] , 'vmovd  dword [eax+eiz*2+0x99],xmm0'               );
  TestCase.testcase(1239, [$C5,$FB,$2D,$84,$60,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eax+eiz*2+0x99]'            );
  TestCase.testcase(1240, [$C5,$FE,$E6,$84,$60,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eax+eiz*2+0x99]'           );
  TestCase.testcase(1241, [$C5,$FD,$5A,$84,$60,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eax+eiz*2+0x99]'           );
  TestCase.testcase(1242, [$C5,$F9,$E0,$BC,$60,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eax+eiz*2+0x99]'         );
  TestCase.testcase(1243, [$C4,$E3,$79,$DF,$84,$60,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eax+eiz*2+0x99],0x7' );
  TestCase.testcase(1244, [$C4,$E3,$79,$14,$84,$60,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eax+eiz*2+0x99],xmm0,0x7'          );
  TestCase.testcase(1245, [$C5,$FB,$2A,$BC,$60,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eax+eiz*2+0x99]'      );
  TestCase.testcase(1246, [$C4,$E3,$79,$44,$BC,$60,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eax+eiz*2+0x99],0x7' );
  TestCase.testcase(1247, [$C4,$E3,$59,$4A,$B4,$60,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eax+eiz*2+0x99],xmm0' );
  TestCase.testcase(1248, [$C4,$E3,$79,$20,$BC,$60,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eax+eiz*2+0x99],0x7'     );
  TestCase.testcase(1249, [$C5,$FD,$6F,$84,$60,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eax+eiz*2+0x99]'             );
  TestCase.testcase(1250, [$C5,$FD,$7F,$84,$60,$99,$00,$00,$00               ] , 'vmovdqa  yword [eax+eiz*2+0x99],ymm0'             );
  TestCase.testcase(1251, [$C4,$E2,$7D,$0D,$BC,$60,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eax+eiz*2+0x99]'      );
  TestCase.testcase(1252, [$C4,$E3,$7D,$09,$84,$60,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eax+eiz*2+0x99],0x7'        );
  TestCase.testcase(1253, [$C4,$E3,$7D,$19,$84,$60,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eax+eiz*2+0x99],ymm0,0x7'    );
  TestCase.testcase(1254, [$C4,$E3,$7D,$06,$BC,$60,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eax+eiz*2+0x99],0x7' );
  TestCase.testcase(1255, [$C4,$E3,$5D,$4B,$B4,$60,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eax+eiz*2+0x99],ymm0' );
  TestCase.testcase(1256, [$C5,$F8,$AE,$94,$98,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eax+ebx*4+0x99]'                 );
  TestCase.testcase(1257, [$C5,$F9,$6F,$84,$98,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eax+ebx*4+0x99]'             );
  TestCase.testcase(1258, [$C5,$F9,$7F,$84,$98,$99,$00,$00,$00               ] , 'vmovdqa  oword [eax+ebx*4+0x99],xmm0'             );
  TestCase.testcase(1259, [$C5,$F9,$7E,$84,$98,$99,$00,$00,$00               ] , 'vmovd  dword [eax+ebx*4+0x99],xmm0'               );
  TestCase.testcase(1260, [$C5,$FB,$2D,$84,$98,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eax+ebx*4+0x99]'            );
  TestCase.testcase(1261, [$C5,$FE,$E6,$84,$98,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eax+ebx*4+0x99]'           );
  TestCase.testcase(1262, [$C5,$FD,$5A,$84,$98,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eax+ebx*4+0x99]'           );
  TestCase.testcase(1263, [$C5,$F9,$E0,$BC,$98,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eax+ebx*4+0x99]'         );
  TestCase.testcase(1264, [$C4,$E3,$79,$DF,$84,$98,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eax+ebx*4+0x99],0x7' );
  TestCase.testcase(1265, [$C4,$E3,$79,$14,$84,$98,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eax+ebx*4+0x99],xmm0,0x7'          );
  TestCase.testcase(1266, [$C5,$FB,$2A,$BC,$98,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eax+ebx*4+0x99]'      );
  TestCase.testcase(1267, [$C4,$E3,$79,$44,$BC,$98,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eax+ebx*4+0x99],0x7' );
  TestCase.testcase(1268, [$C4,$E3,$59,$4A,$B4,$98,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eax+ebx*4+0x99],xmm0' );
  TestCase.testcase(1269, [$C4,$E3,$79,$20,$BC,$98,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eax+ebx*4+0x99],0x7'     );
  TestCase.testcase(1270, [$C5,$FD,$6F,$84,$98,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eax+ebx*4+0x99]'             );
  TestCase.testcase(1271, [$C5,$FD,$7F,$84,$98,$99,$00,$00,$00               ] , 'vmovdqa  yword [eax+ebx*4+0x99],ymm0'             );
  TestCase.testcase(1272, [$C4,$E2,$7D,$0D,$BC,$98,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eax+ebx*4+0x99]'      );
  TestCase.testcase(1273, [$C4,$E3,$7D,$09,$84,$98,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eax+ebx*4+0x99],0x7'        );
  TestCase.testcase(1274, [$C4,$E3,$7D,$19,$84,$98,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eax+ebx*4+0x99],ymm0,0x7'    );
  TestCase.testcase(1275, [$C4,$E3,$7D,$06,$BC,$98,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eax+ebx*4+0x99],0x7' );
  TestCase.testcase(1276, [$C4,$E3,$5D,$4B,$B4,$98,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eax+ebx*4+0x99],ymm0' );
  TestCase.testcase(1277, [$C5,$F8,$AE,$94,$CC,$99,$00,$00,$00               ] , 'vldmxcsr  dword [esp+ecx*8+0x99]'                 );
  TestCase.testcase(1278, [$C5,$F9,$6F,$84,$CC,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [esp+ecx*8+0x99]'             );
  TestCase.testcase(1279, [$C5,$F9,$7F,$84,$CC,$99,$00,$00,$00               ] , 'vmovdqa  oword [esp+ecx*8+0x99],xmm0'             );
  TestCase.testcase(1280, [$C5,$F9,$7E,$84,$CC,$99,$00,$00,$00               ] , 'vmovd  dword [esp+ecx*8+0x99],xmm0'               );
  TestCase.testcase(1281, [$C5,$FB,$2D,$84,$CC,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [esp+ecx*8+0x99]'            );
  TestCase.testcase(1282, [$C5,$FE,$E6,$84,$CC,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [esp+ecx*8+0x99]'           );
  TestCase.testcase(1283, [$C5,$FD,$5A,$84,$CC,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [esp+ecx*8+0x99]'           );
  TestCase.testcase(1284, [$C5,$F9,$E0,$BC,$CC,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [esp+ecx*8+0x99]'         );
  TestCase.testcase(1285, [$C4,$E3,$79,$DF,$84,$CC,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [esp+ecx*8+0x99],0x7' );
  TestCase.testcase(1286, [$C4,$E3,$79,$14,$84,$CC,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [esp+ecx*8+0x99],xmm0,0x7'          );
  TestCase.testcase(1287, [$C5,$FB,$2A,$BC,$CC,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [esp+ecx*8+0x99]'      );
  TestCase.testcase(1288, [$C4,$E3,$79,$44,$BC,$CC,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [esp+ecx*8+0x99],0x7' );
  TestCase.testcase(1289, [$C4,$E3,$59,$4A,$B4,$CC,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [esp+ecx*8+0x99],xmm0' );
  TestCase.testcase(1290, [$C4,$E3,$79,$20,$BC,$CC,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [esp+ecx*8+0x99],0x7'     );
  TestCase.testcase(1291, [$C5,$FD,$6F,$84,$CC,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [esp+ecx*8+0x99]'             );
  TestCase.testcase(1292, [$C5,$FD,$7F,$84,$CC,$99,$00,$00,$00               ] , 'vmovdqa  yword [esp+ecx*8+0x99],ymm0'             );
  TestCase.testcase(1293, [$C4,$E2,$7D,$0D,$BC,$CC,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [esp+ecx*8+0x99]'      );
  TestCase.testcase(1294, [$C4,$E3,$7D,$09,$84,$CC,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [esp+ecx*8+0x99],0x7'        );
  TestCase.testcase(1295, [$C4,$E3,$7D,$19,$84,$CC,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [esp+ecx*8+0x99],ymm0,0x7'    );
  TestCase.testcase(1296, [$C4,$E3,$7D,$06,$BC,$CC,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [esp+ecx*8+0x99],0x7' );
  TestCase.testcase(1297, [$C4,$E3,$5D,$4B,$B4,$CC,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [esp+ecx*8+0x99],ymm0' );
  TestCase.testcase(1298, [$C5,$F8,$AE,$94,$15,$99,$00,$00,$00               ] , 'vldmxcsr  dword [ebp+edx*1+0x99]'                 );
  TestCase.testcase(1299, [$C5,$F9,$6F,$84,$15,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [ebp+edx*1+0x99]'             );
  TestCase.testcase(1300, [$C5,$F9,$7F,$84,$15,$99,$00,$00,$00               ] , 'vmovdqa  oword [ebp+edx*1+0x99],xmm0'             );
  TestCase.testcase(1301, [$C5,$F9,$7E,$84,$15,$99,$00,$00,$00               ] , 'vmovd  dword [ebp+edx*1+0x99],xmm0'               );
  TestCase.testcase(1302, [$C5,$FB,$2D,$84,$15,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [ebp+edx*1+0x99]'            );
  TestCase.testcase(1303, [$C5,$FE,$E6,$84,$15,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [ebp+edx*1+0x99]'           );
  TestCase.testcase(1304, [$C5,$FD,$5A,$84,$15,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [ebp+edx*1+0x99]'           );
  TestCase.testcase(1305, [$C5,$F9,$E0,$BC,$15,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [ebp+edx*1+0x99]'         );
  TestCase.testcase(1306, [$C4,$E3,$79,$DF,$84,$15,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [ebp+edx*1+0x99],0x7' );
  TestCase.testcase(1307, [$C4,$E3,$79,$14,$84,$15,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [ebp+edx*1+0x99],xmm0,0x7'          );
  TestCase.testcase(1308, [$C5,$FB,$2A,$BC,$15,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [ebp+edx*1+0x99]'      );
  TestCase.testcase(1309, [$C4,$E3,$79,$44,$BC,$15,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [ebp+edx*1+0x99],0x7' );
  TestCase.testcase(1310, [$C4,$E3,$59,$4A,$B4,$15,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [ebp+edx*1+0x99],xmm0' );
  TestCase.testcase(1311, [$C4,$E3,$79,$20,$BC,$15,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [ebp+edx*1+0x99],0x7'     );
  TestCase.testcase(1312, [$C5,$FD,$6F,$84,$15,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [ebp+edx*1+0x99]'             );
  TestCase.testcase(1313, [$C5,$FD,$7F,$84,$15,$99,$00,$00,$00               ] , 'vmovdqa  yword [ebp+edx*1+0x99],ymm0'             );
  TestCase.testcase(1314, [$C4,$E2,$7D,$0D,$BC,$15,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [ebp+edx*1+0x99]'      );
  TestCase.testcase(1315, [$C4,$E3,$7D,$09,$84,$15,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [ebp+edx*1+0x99],0x7'        );
  TestCase.testcase(1316, [$C4,$E3,$7D,$19,$84,$15,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [ebp+edx*1+0x99],ymm0,0x7'    );
  TestCase.testcase(1317, [$C4,$E3,$7D,$06,$BC,$15,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [ebp+edx*1+0x99],0x7' );
  TestCase.testcase(1318, [$C4,$E3,$5D,$4B,$B4,$15,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [ebp+edx*1+0x99],ymm0' );
  TestCase.testcase(1319, [$C5,$F9,$50,$C0                                   ] , 'vmovmskpd  eax,xmm0'                              );
  TestCase.testcase(1320, [$C5,$C1,$72,$F0,$07                               ] , 'vpslld  xmm7,xmm0,0x7'                            );
  TestCase.testcase(1321, [$C5,$FC,$50,$C0                                   ] , 'vmovmskps  eax,ymm0'                              );
  TestCase.testcase(1322, [$C5,$F8,$AE,$11                                   ] , 'vldmxcsr  dword [ecx]'                            );
  TestCase.testcase(1323, [$C5,$F8,$AE,$11                                   ] , 'vldmxcsr  dword [ecx]'                            );
  TestCase.testcase(1324, [$C5,$F8,$AE,$19                                   ] , 'vstmxcsr  dword [ecx]'                            );
  TestCase.testcase(1325, [$C5,$F8,$AE,$19                                   ] , 'vstmxcsr  dword [ecx]'                            );
  TestCase.testcase(1326, [$C4,$E2,$5D,$2D,$31                               ] , 'vmaskmovpd  ymm6,ymm4,yword [ecx]'                );
  TestCase.testcase(1327, [$C4,$E2,$4D,$2F,$21                               ] , 'vmaskmovpd  yword [ecx],ymm6,ymm4'                );
  TestCase.testcase(1328, [$C4,$E2,$5D,$2D,$31                               ] , 'vmaskmovpd  ymm6,ymm4,yword [ecx]'                );
  TestCase.testcase(1329, [$C4,$E2,$4D,$2F,$21                               ] , 'vmaskmovpd  yword [ecx],ymm6,ymm4'                );
  TestCase.testcase(1330, [$C4,$E2,$5D,$2C,$31                               ] , 'vmaskmovps  ymm6,ymm4,yword [ecx]'                );
  TestCase.testcase(1331, [$C4,$E2,$4D,$2E,$21                               ] , 'vmaskmovps  yword [ecx],ymm6,ymm4'                );
  TestCase.testcase(1332, [$C4,$E2,$5D,$2C,$31                               ] , 'vmaskmovps  ymm6,ymm4,yword [ecx]'                );
  TestCase.testcase(1333, [$C4,$E2,$4D,$2E,$21                               ] , 'vmaskmovps  yword [ecx],ymm6,ymm4'                );
  TestCase.testcase(1334, [$C4,$E3,$7D,$05,$D6,$07                           ] , 'vpermilpd  ymm2,ymm6,0x7'                         );
  TestCase.testcase(1335, [$C4,$E3,$7D,$05,$31,$07                           ] , 'vpermilpd  ymm6,yword [ecx],0x7'                  );
  TestCase.testcase(1336, [$C4,$E3,$7D,$05,$31,$07                           ] , 'vpermilpd  ymm6,yword [ecx],0x7'                  );
  TestCase.testcase(1337, [$C4,$E3,$7D,$04,$D6,$07                           ] , 'vpermilps  ymm2,ymm6,0x7'                         );
  TestCase.testcase(1338, [$C4,$E3,$7D,$04,$31,$07                           ] , 'vpermilps  ymm6,yword [ecx],0x7'                  );
  TestCase.testcase(1339, [$C4,$E3,$7D,$04,$31,$07                           ] , 'vpermilps  ymm6,yword [ecx],0x7'                  );
  TestCase.testcase(1340, [$C4,$E3,$7D,$09,$D6,$07                           ] , 'vroundpd  ymm2,ymm6,0x7'                          );
  TestCase.testcase(1341, [$C4,$E3,$7D,$09,$31,$07                           ] , 'vroundpd  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(1342, [$C4,$E3,$7D,$09,$31,$07                           ] , 'vroundpd  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(1343, [$C4,$E3,$7D,$08,$D6,$07                           ] , 'vroundps  ymm2,ymm6,0x7'                          );
  TestCase.testcase(1344, [$C4,$E3,$7D,$08,$31,$07                           ] , 'vroundps  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(1345, [$C4,$E3,$7D,$08,$31,$07                           ] , 'vroundps  ymm6,yword [ecx],0x7'                   );
  TestCase.testcase(1346, [$C5,$CD,$58,$D4                                   ] , 'vaddpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1347, [$C5,$CD,$58,$11                                   ] , 'vaddpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1348, [$C5,$CD,$58,$11                                   ] , 'vaddpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1349, [$C5,$CC,$58,$D4                                   ] , 'vaddps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1350, [$C5,$CC,$58,$11                                   ] , 'vaddps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1351, [$C5,$CC,$58,$11                                   ] , 'vaddps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1352, [$C5,$CD,$D0,$D4                                   ] , 'vaddsubpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1353, [$C5,$CD,$D0,$11                                   ] , 'vaddsubpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1354, [$C5,$CD,$D0,$11                                   ] , 'vaddsubpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1355, [$C5,$CF,$D0,$D4                                   ] , 'vaddsubps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1356, [$C5,$CF,$D0,$11                                   ] , 'vaddsubps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1357, [$C5,$CF,$D0,$11                                   ] , 'vaddsubps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1358, [$C5,$CD,$55,$D4                                   ] , 'vandnpd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(1359, [$C5,$CD,$55,$11                                   ] , 'vandnpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1360, [$C5,$CD,$55,$11                                   ] , 'vandnpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1361, [$C5,$CC,$55,$D4                                   ] , 'vandnps  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(1362, [$C5,$CC,$55,$11                                   ] , 'vandnps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1363, [$C5,$CC,$55,$11                                   ] , 'vandnps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1364, [$C5,$CD,$54,$D4                                   ] , 'vandpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1365, [$C5,$CD,$54,$11                                   ] , 'vandpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1366, [$C5,$CD,$54,$11                                   ] , 'vandpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1367, [$C5,$CC,$54,$D4                                   ] , 'vandps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1368, [$C5,$CC,$54,$11                                   ] , 'vandps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1369, [$C5,$CC,$54,$11                                   ] , 'vandps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1370, [$C5,$CD,$5E,$D4                                   ] , 'vdivpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1371, [$C5,$CD,$5E,$11                                   ] , 'vdivpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1372, [$C5,$CD,$5E,$11                                   ] , 'vdivpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1373, [$C5,$CC,$5E,$D4                                   ] , 'vdivps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1374, [$C5,$CC,$5E,$11                                   ] , 'vdivps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1375, [$C5,$CC,$5E,$11                                   ] , 'vdivps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1376, [$C5,$CD,$7C,$D4                                   ] , 'vhaddpd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(1377, [$C5,$CD,$7C,$11                                   ] , 'vhaddpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1378, [$C5,$CD,$7C,$11                                   ] , 'vhaddpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1379, [$C5,$CF,$7C,$D4                                   ] , 'vhaddps  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(1380, [$C5,$CF,$7C,$11                                   ] , 'vhaddps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1381, [$C5,$CF,$7C,$11                                   ] , 'vhaddps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1382, [$C5,$CD,$7D,$D4                                   ] , 'vhsubpd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(1383, [$C5,$CD,$7D,$11                                   ] , 'vhsubpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1384, [$C5,$CD,$7D,$11                                   ] , 'vhsubpd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1385, [$C5,$CF,$7D,$D4                                   ] , 'vhsubps  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(1386, [$C5,$CF,$7D,$11                                   ] , 'vhsubps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1387, [$C5,$CF,$7D,$11                                   ] , 'vhsubps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1388, [$C5,$CD,$5F,$D4                                   ] , 'vmaxpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1389, [$C5,$CD,$5F,$11                                   ] , 'vmaxpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1390, [$C5,$CD,$5F,$11                                   ] , 'vmaxpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1391, [$C5,$CC,$5F,$D4                                   ] , 'vmaxps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1392, [$C5,$CC,$5F,$11                                   ] , 'vmaxps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1393, [$C5,$CC,$5F,$11                                   ] , 'vmaxps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1394, [$C5,$CD,$5D,$D4                                   ] , 'vminpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1395, [$C5,$CD,$5D,$11                                   ] , 'vminpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1396, [$C5,$CD,$5D,$11                                   ] , 'vminpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1397, [$C5,$CC,$5D,$D4                                   ] , 'vminps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1398, [$C5,$CC,$5D,$11                                   ] , 'vminps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1399, [$C5,$CC,$5D,$11                                   ] , 'vminps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1400, [$C5,$CD,$59,$D4                                   ] , 'vmulpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1401, [$C5,$CD,$59,$11                                   ] , 'vmulpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1402, [$C5,$CD,$59,$11                                   ] , 'vmulpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1403, [$C5,$CC,$59,$D4                                   ] , 'vmulps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1404, [$C5,$CC,$59,$11                                   ] , 'vmulps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1405, [$C5,$CC,$59,$11                                   ] , 'vmulps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1406, [$C5,$CD,$56,$D4                                   ] , 'vorpd  ymm2,ymm6,ymm4'                            );
  TestCase.testcase(1407, [$C5,$CD,$56,$11                                   ] , 'vorpd  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(1408, [$C5,$CD,$56,$11                                   ] , 'vorpd  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(1409, [$C5,$CC,$56,$D4                                   ] , 'vorps  ymm2,ymm6,ymm4'                            );
  TestCase.testcase(1410, [$C5,$CC,$56,$11                                   ] , 'vorps  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(1411, [$C5,$CC,$56,$11                                   ] , 'vorps  ymm2,ymm6,yword [ecx]'                     );
  TestCase.testcase(1412, [$C4,$E2,$4D,$0D,$D4                               ] , 'vpermilpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1413, [$C4,$E2,$4D,$0D,$11                               ] , 'vpermilpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1414, [$C4,$E2,$4D,$0D,$11                               ] , 'vpermilpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1415, [$C4,$E2,$4D,$0C,$D4                               ] , 'vpermilps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1416, [$C4,$E2,$4D,$0C,$11                               ] , 'vpermilps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1417, [$C4,$E2,$4D,$0C,$11                               ] , 'vpermilps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1418, [$C5,$CD,$5C,$D4                                   ] , 'vsubpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1419, [$C5,$CD,$5C,$11                                   ] , 'vsubpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1420, [$C5,$CD,$5C,$11                                   ] , 'vsubpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1421, [$C5,$CC,$5C,$D4                                   ] , 'vsubps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1422, [$C5,$CC,$5C,$11                                   ] , 'vsubps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1423, [$C5,$CC,$5C,$11                                   ] , 'vsubps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1424, [$C5,$CD,$15,$D4                                   ] , 'vunpckhpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1425, [$C5,$CD,$15,$11                                   ] , 'vunpckhpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1426, [$C5,$CD,$15,$11                                   ] , 'vunpckhpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1427, [$C5,$CC,$15,$D4                                   ] , 'vunpckhps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1428, [$C5,$CC,$15,$11                                   ] , 'vunpckhps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1429, [$C5,$CC,$15,$11                                   ] , 'vunpckhps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1430, [$C5,$CD,$14,$D4                                   ] , 'vunpcklpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1431, [$C5,$CD,$14,$11                                   ] , 'vunpcklpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1432, [$C5,$CD,$14,$11                                   ] , 'vunpcklpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1433, [$C5,$CC,$14,$D4                                   ] , 'vunpcklps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1434, [$C5,$CC,$14,$11                                   ] , 'vunpcklps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1435, [$C5,$CC,$14,$11                                   ] , 'vunpcklps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1436, [$C5,$CD,$57,$D4                                   ] , 'vxorpd  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1437, [$C5,$CD,$57,$11                                   ] , 'vxorpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1438, [$C5,$CD,$57,$11                                   ] , 'vxorpd  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1439, [$C5,$CC,$57,$D4                                   ] , 'vxorps  ymm2,ymm6,ymm4'                           );
  TestCase.testcase(1440, [$C5,$CC,$57,$11                                   ] , 'vxorps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1441, [$C5,$CC,$57,$11                                   ] , 'vxorps  ymm2,ymm6,yword [ecx]'                    );
  TestCase.testcase(1442, [$C5,$CD,$C2,$D4,$00                               ] , 'vcmpeqpd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1443, [$C5,$CD,$C2,$11,$00                               ] , 'vcmpeqpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1444, [$C5,$CD,$C2,$11,$00                               ] , 'vcmpeqpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1445, [$C5,$CD,$C2,$D4,$01                               ] , 'vcmpltpd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1446, [$C5,$CD,$C2,$11,$01                               ] , 'vcmpltpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1447, [$C5,$CD,$C2,$11,$01                               ] , 'vcmpltpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1448, [$C5,$CD,$C2,$D4,$02                               ] , 'vcmplepd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1449, [$C5,$CD,$C2,$11,$02                               ] , 'vcmplepd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1450, [$C5,$CD,$C2,$11,$02                               ] , 'vcmplepd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1451, [$C5,$CD,$C2,$D4,$03                               ] , 'vcmpunordpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1452, [$C5,$CD,$C2,$11,$03                               ] , 'vcmpunordpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1453, [$C5,$CD,$C2,$11,$03                               ] , 'vcmpunordpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1454, [$C5,$CD,$C2,$D4,$04                               ] , 'vcmpneqpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1455, [$C5,$CD,$C2,$11,$04                               ] , 'vcmpneqpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1456, [$C5,$CD,$C2,$11,$04                               ] , 'vcmpneqpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1457, [$C5,$CD,$C2,$D4,$05                               ] , 'vcmpnltpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1458, [$C5,$CD,$C2,$11,$05                               ] , 'vcmpnltpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1459, [$C5,$CD,$C2,$11,$05                               ] , 'vcmpnltpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1460, [$C5,$CD,$C2,$D4,$06                               ] , 'vcmpnlepd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1461, [$C5,$CD,$C2,$11,$06                               ] , 'vcmpnlepd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1462, [$C5,$CD,$C2,$11,$06                               ] , 'vcmpnlepd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1463, [$C5,$CD,$C2,$D4,$07                               ] , 'vcmpordpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1464, [$C5,$CD,$C2,$11,$07                               ] , 'vcmpordpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1465, [$C5,$CD,$C2,$11,$07                               ] , 'vcmpordpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1466, [$C5,$CD,$C2,$D4,$08                               ] , 'vcmpeq_uqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1467, [$C5,$CD,$C2,$11,$08                               ] , 'vcmpeq_uqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1468, [$C5,$CD,$C2,$11,$08                               ] , 'vcmpeq_uqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1469, [$C5,$CD,$C2,$D4,$09                               ] , 'vcmpngepd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1470, [$C5,$CD,$C2,$11,$09                               ] , 'vcmpngepd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1471, [$C5,$CD,$C2,$11,$09                               ] , 'vcmpngepd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1472, [$C5,$CD,$C2,$D4,$0A                               ] , 'vcmpngtpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1473, [$C5,$CD,$C2,$11,$0A                               ] , 'vcmpngtpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1474, [$C5,$CD,$C2,$11,$0A                               ] , 'vcmpngtpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1475, [$C5,$CD,$C2,$D4,$0B                               ] , 'vcmpfalsepd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1476, [$C5,$CD,$C2,$11,$0B                               ] , 'vcmpfalsepd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1477, [$C5,$CD,$C2,$11,$0B                               ] , 'vcmpfalsepd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1478, [$C5,$CD,$C2,$D4,$0C                               ] , 'vcmpneq_oqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1479, [$C5,$CD,$C2,$11,$0C                               ] , 'vcmpneq_oqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1480, [$C5,$CD,$C2,$11,$0C                               ] , 'vcmpneq_oqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1481, [$C5,$CD,$C2,$D4,$0D                               ] , 'vcmpgepd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1482, [$C5,$CD,$C2,$11,$0D                               ] , 'vcmpgepd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1483, [$C5,$CD,$C2,$11,$0D                               ] , 'vcmpgepd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1484, [$C5,$CD,$C2,$D4,$0E                               ] , 'vcmpgtpd  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1485, [$C5,$CD,$C2,$11,$0E                               ] , 'vcmpgtpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1486, [$C5,$CD,$C2,$11,$0E                               ] , 'vcmpgtpd  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1487, [$C5,$CD,$C2,$D4,$0F                               ] , 'vcmuepd  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(1488, [$C5,$CD,$C2,$11,$0F                               ] , 'vcmuepd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1489, [$C5,$CD,$C2,$11,$0F                               ] , 'vcmuepd  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1490, [$C5,$CD,$C2,$D4,$10                               ] , 'vcmpeq_ospd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1491, [$C5,$CD,$C2,$11,$10                               ] , 'vcmpeq_ospd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1492, [$C5,$CD,$C2,$11,$10                               ] , 'vcmpeq_ospd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1493, [$C5,$CD,$C2,$D4,$11                               ] , 'vcmplt_oqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1494, [$C5,$CD,$C2,$11,$11                               ] , 'vcmplt_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1495, [$C5,$CD,$C2,$11,$11                               ] , 'vcmplt_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1496, [$C5,$CD,$C2,$D4,$12                               ] , 'vcmple_oqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1497, [$C5,$CD,$C2,$11,$12                               ] , 'vcmple_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1498, [$C5,$CD,$C2,$11,$12                               ] , 'vcmple_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1499, [$C5,$CD,$C2,$D4,$13                               ] , 'vcmpunord_spd  ymm2,ymm6,ymm4'                    );
  TestCase.testcase(1500, [$C5,$CD,$C2,$11,$13                               ] , 'vcmpunord_spd  ymm2,ymm6,yword [ecx]'             );
  TestCase.testcase(1501, [$C5,$CD,$C2,$11,$13                               ] , 'vcmpunord_spd  ymm2,ymm6,yword [ecx]'             );
  TestCase.testcase(1502, [$C5,$CD,$C2,$D4,$14                               ] , 'vcmpneq_uspd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1503, [$C5,$CD,$C2,$11,$14                               ] , 'vcmpneq_uspd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1504, [$C5,$CD,$C2,$11,$14                               ] , 'vcmpneq_uspd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1505, [$C5,$CD,$C2,$D4,$15                               ] , 'vcmpnlt_uqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1506, [$C5,$CD,$C2,$11,$15                               ] , 'vcmpnlt_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1507, [$C5,$CD,$C2,$11,$15                               ] , 'vcmpnlt_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1508, [$C5,$CD,$C2,$D4,$16                               ] , 'vcmpnle_uqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1509, [$C5,$CD,$C2,$11,$16                               ] , 'vcmpnle_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1510, [$C5,$CD,$C2,$11,$16                               ] , 'vcmpnle_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1511, [$C5,$CD,$C2,$D4,$17                               ] , 'vcmpord_spd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1512, [$C5,$CD,$C2,$11,$17                               ] , 'vcmpord_spd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1513, [$C5,$CD,$C2,$11,$17                               ] , 'vcmpord_spd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1514, [$C5,$CD,$C2,$D4,$18                               ] , 'vcmpeq_uspd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1515, [$C5,$CD,$C2,$11,$18                               ] , 'vcmpeq_uspd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1516, [$C5,$CD,$C2,$11,$18                               ] , 'vcmpeq_uspd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1517, [$C5,$CD,$C2,$D4,$19                               ] , 'vcmpnge_uqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1518, [$C5,$CD,$C2,$11,$19                               ] , 'vcmpnge_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1519, [$C5,$CD,$C2,$11,$19                               ] , 'vcmpnge_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1520, [$C5,$CD,$C2,$D4,$1A                               ] , 'vcmpngt_uqpd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1521, [$C5,$CD,$C2,$11,$1A                               ] , 'vcmpngt_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1522, [$C5,$CD,$C2,$11,$1A                               ] , 'vcmpngt_uqpd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1523, [$C5,$CD,$C2,$D4,$1B                               ] , 'vcmpfalse_ospd  ymm2,ymm6,ymm4'                   );
  TestCase.testcase(1524, [$C5,$CD,$C2,$11,$1B                               ] , 'vcmpfalse_ospd  ymm2,ymm6,yword [ecx]'            );
  TestCase.testcase(1525, [$C5,$CD,$C2,$11,$1B                               ] , 'vcmpfalse_ospd  ymm2,ymm6,yword [ecx]'            );
  TestCase.testcase(1526, [$C5,$CD,$C2,$D4,$1C                               ] , 'vcmpneq_ospd  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1527, [$C5,$CD,$C2,$11,$1C                               ] , 'vcmpneq_ospd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1528, [$C5,$CD,$C2,$11,$1C                               ] , 'vcmpneq_ospd  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1529, [$C5,$CD,$C2,$D4,$1D                               ] , 'vcmpge_oqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1530, [$C5,$CD,$C2,$11,$1D                               ] , 'vcmpge_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1531, [$C5,$CD,$C2,$11,$1D                               ] , 'vcmpge_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1532, [$C5,$CD,$C2,$D4,$1E                               ] , 'vcmpgt_oqpd  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1533, [$C5,$CD,$C2,$11,$1E                               ] , 'vcmpgt_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1534, [$C5,$CD,$C2,$11,$1E                               ] , 'vcmpgt_oqpd  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1535, [$C5,$CD,$C2,$D4,$1F                               ] , 'vcmue_uspd  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(1536, [$C5,$CD,$C2,$11,$1F                               ] , 'vcmue_uspd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(1537, [$C5,$CD,$C2,$11,$1F                               ] , 'vcmue_uspd  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(1538, [$C5,$CC,$C2,$D4,$00                               ] , 'vcmpeqps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1539, [$C5,$CC,$C2,$11,$00                               ] , 'vcmpeqps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1540, [$C5,$CC,$C2,$11,$00                               ] , 'vcmpeqps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1541, [$C5,$CC,$C2,$D4,$01                               ] , 'vcmpltps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1542, [$C5,$CC,$C2,$11,$01                               ] , 'vcmpltps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1543, [$C5,$CC,$C2,$11,$01                               ] , 'vcmpltps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1544, [$C5,$CC,$C2,$D4,$02                               ] , 'vcmpleps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1545, [$C5,$CC,$C2,$11,$02                               ] , 'vcmpleps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1546, [$C5,$CC,$C2,$11,$02                               ] , 'vcmpleps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1547, [$C5,$CC,$C2,$D4,$03                               ] , 'vcmpunordps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1548, [$C5,$CC,$C2,$11,$03                               ] , 'vcmpunordps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1549, [$C5,$CC,$C2,$11,$03                               ] , 'vcmpunordps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1550, [$C5,$CC,$C2,$D4,$04                               ] , 'vcmpneqps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1551, [$C5,$CC,$C2,$11,$04                               ] , 'vcmpneqps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1552, [$C5,$CC,$C2,$11,$04                               ] , 'vcmpneqps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1553, [$C5,$CC,$C2,$D4,$05                               ] , 'vcmpnltps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1554, [$C5,$CC,$C2,$11,$05                               ] , 'vcmpnltps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1555, [$C5,$CC,$C2,$11,$05                               ] , 'vcmpnltps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1556, [$C5,$CC,$C2,$D4,$06                               ] , 'vcmpnleps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1557, [$C5,$CC,$C2,$11,$06                               ] , 'vcmpnleps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1558, [$C5,$CC,$C2,$11,$06                               ] , 'vcmpnleps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1559, [$C5,$CC,$C2,$D4,$07                               ] , 'vcmpordps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1560, [$C5,$CC,$C2,$11,$07                               ] , 'vcmpordps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1561, [$C5,$CC,$C2,$11,$07                               ] , 'vcmpordps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1562, [$C5,$CC,$C2,$D4,$08                               ] , 'vcmpeq_uqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1563, [$C5,$CC,$C2,$11,$08                               ] , 'vcmpeq_uqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1564, [$C5,$CC,$C2,$11,$08                               ] , 'vcmpeq_uqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1565, [$C5,$CC,$C2,$D4,$09                               ] , 'vcmpngeps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1566, [$C5,$CC,$C2,$11,$09                               ] , 'vcmpngeps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1567, [$C5,$CC,$C2,$11,$09                               ] , 'vcmpngeps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1568, [$C5,$CC,$C2,$D4,$0A                               ] , 'vcmpngtps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1569, [$C5,$CC,$C2,$11,$0A                               ] , 'vcmpngtps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1570, [$C5,$CC,$C2,$11,$0A                               ] , 'vcmpngtps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1571, [$C5,$CC,$C2,$D4,$0B                               ] , 'vcmpfalseps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1572, [$C5,$CC,$C2,$11,$0B                               ] , 'vcmpfalseps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1573, [$C5,$CC,$C2,$11,$0B                               ] , 'vcmpfalseps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1574, [$C5,$CC,$C2,$D4,$0C                               ] , 'vcmpneq_oqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1575, [$C5,$CC,$C2,$11,$0C                               ] , 'vcmpneq_oqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1576, [$C5,$CC,$C2,$11,$0C                               ] , 'vcmpneq_oqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1577, [$C5,$CC,$C2,$D4,$0D                               ] , 'vcmpgeps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1578, [$C5,$CC,$C2,$11,$0D                               ] , 'vcmpgeps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1579, [$C5,$CC,$C2,$11,$0D                               ] , 'vcmpgeps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1580, [$C5,$CC,$C2,$D4,$0E                               ] , 'vcmpgtps  ymm2,ymm6,ymm4'                         );
  TestCase.testcase(1581, [$C5,$CC,$C2,$11,$0E                               ] , 'vcmpgtps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1582, [$C5,$CC,$C2,$11,$0E                               ] , 'vcmpgtps  ymm2,ymm6,yword [ecx]'                  );
  TestCase.testcase(1583, [$C5,$CC,$C2,$D4,$0F                               ] , 'vcmueps  ymm2,ymm6,ymm4'                          );
  TestCase.testcase(1584, [$C5,$CC,$C2,$11,$0F                               ] , 'vcmueps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1585, [$C5,$CC,$C2,$11,$0F                               ] , 'vcmueps  ymm2,ymm6,yword [ecx]'                   );
  TestCase.testcase(1586, [$C5,$CC,$C2,$D4,$10                               ] , 'vcmpeq_osps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1587, [$C5,$CC,$C2,$11,$10                               ] , 'vcmpeq_osps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1588, [$C5,$CC,$C2,$11,$10                               ] , 'vcmpeq_osps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1589, [$C5,$CC,$C2,$D4,$11                               ] , 'vcmplt_oqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1590, [$C5,$CC,$C2,$11,$11                               ] , 'vcmplt_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1591, [$C5,$CC,$C2,$11,$11                               ] , 'vcmplt_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1592, [$C5,$CC,$C2,$D4,$12                               ] , 'vcmple_oqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1593, [$C5,$CC,$C2,$11,$12                               ] , 'vcmple_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1594, [$C5,$CC,$C2,$11,$12                               ] , 'vcmple_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1595, [$C5,$CC,$C2,$D4,$13                               ] , 'vcmpunord_sps  ymm2,ymm6,ymm4'                    );
  TestCase.testcase(1596, [$C5,$CC,$C2,$11,$13                               ] , 'vcmpunord_sps  ymm2,ymm6,yword [ecx]'             );
  TestCase.testcase(1597, [$C5,$CC,$C2,$11,$13                               ] , 'vcmpunord_sps  ymm2,ymm6,yword [ecx]'             );
  TestCase.testcase(1598, [$C5,$CC,$C2,$D4,$14                               ] , 'vcmpneq_usps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1599, [$C5,$CC,$C2,$11,$14                               ] , 'vcmpneq_usps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1600, [$C5,$CC,$C2,$11,$14                               ] , 'vcmpneq_usps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1601, [$C5,$CC,$C2,$D4,$15                               ] , 'vcmpnlt_uqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1602, [$C5,$CC,$C2,$11,$15                               ] , 'vcmpnlt_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1603, [$C5,$CC,$C2,$11,$15                               ] , 'vcmpnlt_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1604, [$C5,$CC,$C2,$D4,$16                               ] , 'vcmpnle_uqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1605, [$C5,$CC,$C2,$11,$16                               ] , 'vcmpnle_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1606, [$C5,$CC,$C2,$11,$16                               ] , 'vcmpnle_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1607, [$C5,$CC,$C2,$D4,$17                               ] , 'vcmpord_sps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1608, [$C5,$CC,$C2,$11,$17                               ] , 'vcmpord_sps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1609, [$C5,$CC,$C2,$11,$17                               ] , 'vcmpord_sps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1610, [$C5,$CC,$C2,$D4,$18                               ] , 'vcmpeq_usps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1611, [$C5,$CC,$C2,$11,$18                               ] , 'vcmpeq_usps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1612, [$C5,$CC,$C2,$11,$18                               ] , 'vcmpeq_usps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1613, [$C5,$CC,$C2,$D4,$19                               ] , 'vcmpnge_uqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1614, [$C5,$CC,$C2,$11,$19                               ] , 'vcmpnge_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1615, [$C5,$CC,$C2,$11,$19                               ] , 'vcmpnge_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1616, [$C5,$CC,$C2,$D4,$1A                               ] , 'vcmpngt_uqps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1617, [$C5,$CC,$C2,$11,$1A                               ] , 'vcmpngt_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1618, [$C5,$CC,$C2,$11,$1A                               ] , 'vcmpngt_uqps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1619, [$C5,$CC,$C2,$D4,$1B                               ] , 'vcmpfalse_osps  ymm2,ymm6,ymm4'                   );
  TestCase.testcase(1620, [$C5,$CC,$C2,$11,$1B                               ] , 'vcmpfalse_osps  ymm2,ymm6,yword [ecx]'            );
  TestCase.testcase(1621, [$C5,$CC,$C2,$11,$1B                               ] , 'vcmpfalse_osps  ymm2,ymm6,yword [ecx]'            );
  TestCase.testcase(1622, [$C5,$CC,$C2,$D4,$1C                               ] , 'vcmpneq_osps  ymm2,ymm6,ymm4'                     );
  TestCase.testcase(1623, [$C5,$CC,$C2,$11,$1C                               ] , 'vcmpneq_osps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1624, [$C5,$CC,$C2,$11,$1C                               ] , 'vcmpneq_osps  ymm2,ymm6,yword [ecx]'              );
  TestCase.testcase(1625, [$C5,$CC,$C2,$D4,$1D                               ] , 'vcmpge_oqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1626, [$C5,$CC,$C2,$11,$1D                               ] , 'vcmpge_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1627, [$C5,$CC,$C2,$11,$1D                               ] , 'vcmpge_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1628, [$C5,$CC,$C2,$D4,$1E                               ] , 'vcmpgt_oqps  ymm2,ymm6,ymm4'                      );
  TestCase.testcase(1629, [$C5,$CC,$C2,$11,$1E                               ] , 'vcmpgt_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1630, [$C5,$CC,$C2,$11,$1E                               ] , 'vcmpgt_oqps  ymm2,ymm6,yword [ecx]'               );
  TestCase.testcase(1631, [$C5,$CC,$C2,$D4,$1F                               ] , 'vcmue_usps  ymm2,ymm6,ymm4'                       );
  TestCase.testcase(1632, [$C5,$CC,$C2,$11,$1F                               ] , 'vcmue_usps  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(1633, [$C5,$CC,$C2,$11,$1F                               ] , 'vcmue_usps  ymm2,ymm6,yword [ecx]'                );
  TestCase.testcase(1634, [$C5,$FF,$E6,$E4                                   ] , 'vcvtpd2dq  xmm4,ymm4'                             );
  TestCase.testcase(1635, [$C5,$FF,$E6,$21                                   ] , 'vcvtpd2dq  xmm4,yword [ecx]'                      );
  TestCase.testcase(1636, [$C5,$FD,$5A,$E4                                   ] , 'vcvtpd2ps  xmm4,ymm4'                             );
  TestCase.testcase(1637, [$C5,$FD,$5A,$21                                   ] , 'vcvtpd2ps  xmm4,yword [ecx]'                      );
  TestCase.testcase(1638, [$C5,$FD,$E6,$E4                                   ] , 'vcvttpd2dq  xmm4,ymm4'                            );
  TestCase.testcase(1639, [$C5,$FD,$E6,$21                                   ] , 'vcvttpd2dq  xmm4,yword [ecx]'                     );
  TestCase.testcase(1640, [$C5,$FC,$5B,$F4                                   ] , 'vcvtdq2ps  ymm6,ymm4'                             );
  TestCase.testcase(1641, [$C5,$FC,$5B,$21                                   ] , 'vcvtdq2ps  ymm4,yword [ecx]'                      );
  TestCase.testcase(1642, [$C5,$FC,$5B,$21                                   ] , 'vcvtdq2ps  ymm4,yword [ecx]'                      );
  TestCase.testcase(1643, [$C5,$FD,$5B,$F4                                   ] , 'vcvtps2dq  ymm6,ymm4'                             );
  TestCase.testcase(1644, [$C5,$FD,$5B,$21                                   ] , 'vcvtps2dq  ymm4,yword [ecx]'                      );
  TestCase.testcase(1645, [$C5,$FD,$5B,$21                                   ] , 'vcvtps2dq  ymm4,yword [ecx]'                      );
  TestCase.testcase(1646, [$C5,$FE,$5B,$F4                                   ] , 'vcvttps2dq  ymm6,ymm4'                            );
  TestCase.testcase(1647, [$C5,$FE,$5B,$21                                   ] , 'vcvttps2dq  ymm4,yword [ecx]'                     );
  TestCase.testcase(1648, [$C5,$FE,$5B,$21                                   ] , 'vcvttps2dq  ymm4,yword [ecx]'                     );
  TestCase.testcase(1649, [$C5,$FD,$28,$F4                                   ] , 'vmovapd  ymm6,ymm4'                               );
  TestCase.testcase(1650, [$C5,$FD,$28,$21                                   ] , 'vmovapd  ymm4,yword [ecx]'                        );
  TestCase.testcase(1651, [$C5,$FD,$28,$21                                   ] , 'vmovapd  ymm4,yword [ecx]'                        );
  TestCase.testcase(1652, [$C5,$FC,$28,$F4                                   ] , 'vmovaps  ymm6,ymm4'                               );
  TestCase.testcase(1653, [$C5,$FC,$28,$21                                   ] , 'vmovaps  ymm4,yword [ecx]'                        );
  TestCase.testcase(1654, [$C5,$FC,$28,$21                                   ] , 'vmovaps  ymm4,yword [ecx]'                        );
  TestCase.testcase(1655, [$C5,$FD,$6F,$F4                                   ] , 'vmovdqa  ymm6,ymm4'                               );
  TestCase.testcase(1656, [$C5,$FD,$6F,$21                                   ] , 'vmovdqa  ymm4,yword [ecx]'                        );
  TestCase.testcase(1657, [$C5,$FD,$6F,$21                                   ] , 'vmovdqa  ymm4,yword [ecx]'                        );
  TestCase.testcase(1658, [$C5,$FE,$6F,$F4                                   ] , 'vmovdqu  ymm6,ymm4'                               );
  TestCase.testcase(1659, [$C5,$FE,$6F,$21                                   ] , 'vmovdqu  ymm4,yword [ecx]'                        );
  TestCase.testcase(1660, [$C5,$FE,$6F,$21                                   ] , 'vmovdqu  ymm4,yword [ecx]'                        );
  TestCase.testcase(1661, [$C5,$FF,$12,$F4                                   ] , 'vmovddup  ymm6,ymm4'                              );
  TestCase.testcase(1662, [$C5,$FF,$12,$21                                   ] , 'vmovddup  ymm4,yword [ecx]'                       );
  TestCase.testcase(1663, [$C5,$FF,$12,$21                                   ] , 'vmovddup  ymm4,yword [ecx]'                       );
  TestCase.testcase(1664, [$C5,$FE,$16,$F4                                   ] , 'vmovshdup  ymm6,ymm4'                             );
  TestCase.testcase(1665, [$C5,$FE,$16,$21                                   ] , 'vmovshdup  ymm4,yword [ecx]'                      );
  TestCase.testcase(1666, [$C5,$FE,$16,$21                                   ] , 'vmovshdup  ymm4,yword [ecx]'                      );
  TestCase.testcase(1667, [$C5,$FE,$12,$F4                                   ] , 'vmovsldup  ymm6,ymm4'                             );
  TestCase.testcase(1668, [$C5,$FE,$12,$21                                   ] , 'vmovsldup  ymm4,yword [ecx]'                      );
  TestCase.testcase(1669, [$C5,$FE,$12,$21                                   ] , 'vmovsldup  ymm4,yword [ecx]'                      );
  TestCase.testcase(1670, [$C5,$FD,$10,$F4                                   ] , 'vmovupd  ymm6,ymm4'                               );
  TestCase.testcase(1671, [$C5,$FD,$10,$21                                   ] , 'vmovupd  ymm4,yword [ecx]'                        );
  TestCase.testcase(1672, [$C5,$FD,$10,$21                                   ] , 'vmovupd  ymm4,yword [ecx]'                        );
  TestCase.testcase(1673, [$C5,$FC,$10,$F4                                   ] , 'vmovups  ymm6,ymm4'                               );
  TestCase.testcase(1674, [$C5,$FC,$10,$21                                   ] , 'vmovups  ymm4,yword [ecx]'                        );
  TestCase.testcase(1675, [$C5,$FC,$10,$21                                   ] , 'vmovups  ymm4,yword [ecx]'                        );
  TestCase.testcase(1676, [$C4,$E2,$7D,$17,$F4                               ] , 'vptest  ymm6,ymm4'                                );
  TestCase.testcase(1677, [$C4,$E2,$7D,$17,$21                               ] , 'vptest  ymm4,yword [ecx]'                         );
  TestCase.testcase(1678, [$C4,$E2,$7D,$17,$21                               ] , 'vptest  ymm4,yword [ecx]'                         );
  TestCase.testcase(1679, [$C5,$FC,$53,$F4                                   ] , 'vrcpps  ymm6,ymm4'                                );
  TestCase.testcase(1680, [$C5,$FC,$53,$21                                   ] , 'vrcpps  ymm4,yword [ecx]'                         );
  TestCase.testcase(1681, [$C5,$FC,$53,$21                                   ] , 'vrcpps  ymm4,yword [ecx]'                         );
  TestCase.testcase(1682, [$C5,$FC,$52,$F4                                   ] , 'vrsqrtps  ymm6,ymm4'                              );
  TestCase.testcase(1683, [$C5,$FC,$52,$21                                   ] , 'vrsqrtps  ymm4,yword [ecx]'                       );
  TestCase.testcase(1684, [$C5,$FC,$52,$21                                   ] , 'vrsqrtps  ymm4,yword [ecx]'                       );
  TestCase.testcase(1685, [$C5,$FD,$51,$F4                                   ] , 'vsqrtpd  ymm6,ymm4'                               );
  TestCase.testcase(1686, [$C5,$FD,$51,$21                                   ] , 'vsqrtpd  ymm4,yword [ecx]'                        );
  TestCase.testcase(1687, [$C5,$FD,$51,$21                                   ] , 'vsqrtpd  ymm4,yword [ecx]'                        );
  TestCase.testcase(1688, [$C5,$FC,$51,$F4                                   ] , 'vsqrtps  ymm6,ymm4'                               );
  TestCase.testcase(1689, [$C5,$FC,$51,$21                                   ] , 'vsqrtps  ymm4,yword [ecx]'                        );
  TestCase.testcase(1690, [$C5,$FC,$51,$21                                   ] , 'vsqrtps  ymm4,yword [ecx]'                        );
  TestCase.testcase(1691, [$C4,$E2,$7D,$0F,$F4                               ] , 'vtestpd  ymm6,ymm4'                               );
  TestCase.testcase(1692, [$C4,$E2,$7D,$0F,$21                               ] , 'vtestpd  ymm4,yword [ecx]'                        );
  TestCase.testcase(1693, [$C4,$E2,$7D,$0F,$21                               ] , 'vtestpd  ymm4,yword [ecx]'                        );
  TestCase.testcase(1694, [$C4,$E2,$7D,$0E,$F4                               ] , 'vtestps  ymm6,ymm4'                               );
  TestCase.testcase(1695, [$C4,$E2,$7D,$0E,$21                               ] , 'vtestps  ymm4,yword [ecx]'                        );
  TestCase.testcase(1696, [$C4,$E2,$7D,$0E,$21                               ] , 'vtestps  ymm4,yword [ecx]'                        );
  TestCase.testcase(1697, [$C5,$FD,$28,$F4                                   ] , 'vmovapd  ymm6,ymm4'                               );
  TestCase.testcase(1698, [$C5,$FD,$29,$21                                   ] , 'vmovapd  yword [ecx],ymm4'                        );
  TestCase.testcase(1699, [$C5,$FD,$29,$21                                   ] , 'vmovapd  yword [ecx],ymm4'                        );
  TestCase.testcase(1700, [$C5,$FC,$28,$F4                                   ] , 'vmovaps  ymm6,ymm4'                               );
  TestCase.testcase(1701, [$C5,$FC,$29,$21                                   ] , 'vmovaps  yword [ecx],ymm4'                        );
  TestCase.testcase(1702, [$C5,$FC,$29,$21                                   ] , 'vmovaps  yword [ecx],ymm4'                        );
  TestCase.testcase(1703, [$C5,$FD,$6F,$F4                                   ] , 'vmovdqa  ymm6,ymm4'                               );
  TestCase.testcase(1704, [$C5,$FD,$7F,$21                                   ] , 'vmovdqa  yword [ecx],ymm4'                        );
  TestCase.testcase(1705, [$C5,$FD,$7F,$21                                   ] , 'vmovdqa  yword [ecx],ymm4'                        );
  TestCase.testcase(1706, [$C5,$FE,$6F,$F4                                   ] , 'vmovdqu  ymm6,ymm4'                               );
  TestCase.testcase(1707, [$C5,$FE,$7F,$21                                   ] , 'vmovdqu  yword [ecx],ymm4'                        );
  TestCase.testcase(1708, [$C5,$FE,$7F,$21                                   ] , 'vmovdqu  yword [ecx],ymm4'                        );
  TestCase.testcase(1709, [$C5,$FD,$10,$F4                                   ] , 'vmovupd  ymm6,ymm4'                               );
  TestCase.testcase(1710, [$C5,$FD,$11,$21                                   ] , 'vmovupd  yword [ecx],ymm4'                        );
  TestCase.testcase(1711, [$C5,$FD,$11,$21                                   ] , 'vmovupd  yword [ecx],ymm4'                        );
  TestCase.testcase(1712, [$C5,$FC,$10,$F4                                   ] , 'vmovups  ymm6,ymm4'                               );
  TestCase.testcase(1713, [$C5,$FC,$11,$21                                   ] , 'vmovups  yword [ecx],ymm4'                        );
  TestCase.testcase(1714, [$C5,$FC,$11,$21                                   ] , 'vmovups  yword [ecx],ymm4'                        );
  TestCase.testcase(1715, [$C5,$FF,$F0,$21                                   ] , 'vlddqu  ymm4,[ecx]'                               );
  TestCase.testcase(1716, [$C5,$FF,$F0,$21                                   ] , 'vlddqu  ymm4,[ecx]'                               );
  TestCase.testcase(1717, [$C5,$FD,$E7,$21                                   ] , 'vmovntdq  yword [ecx],ymm4'                       );
  TestCase.testcase(1718, [$C5,$FD,$E7,$21                                   ] , 'vmovntdq  yword [ecx],ymm4'                       );
  TestCase.testcase(1719, [$C5,$FD,$2B,$21                                   ] , 'vmovntpd  yword [ecx],ymm4'                       );
  TestCase.testcase(1720, [$C5,$FD,$2B,$21                                   ] , 'vmovntpd  yword [ecx],ymm4'                       );
  TestCase.testcase(1721, [$C5,$FC,$2B,$21                                   ] , 'vmovntps  yword [ecx],ymm4'                       );
  TestCase.testcase(1722, [$C5,$FC,$2B,$21                                   ] , 'vmovntps  yword [ecx],ymm4'                       );
  TestCase.testcase(1723, [$C4,$E3,$4D,$0D,$D4,$07                           ] , 'vblendpd  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(1724, [$C4,$E3,$4D,$0D,$11,$07                           ] , 'vblendpd  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(1725, [$C4,$E3,$4D,$0D,$11,$07                           ] , 'vblendpd  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(1726, [$C4,$E3,$4D,$0C,$D4,$07                           ] , 'vblendps  ymm2,ymm6,ymm4,0x7'                     );
  TestCase.testcase(1727, [$C4,$E3,$4D,$0C,$11,$07                           ] , 'vblendps  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(1728, [$C4,$E3,$4D,$0C,$11,$07                           ] , 'vblendps  ymm2,ymm6,yword [ecx],0x7'              );
  TestCase.testcase(1729, [$C5,$CD,$C2,$D4,$07                               ] , 'vcmpordpd  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1730, [$C5,$CD,$C2,$11,$07                               ] , 'vcmpordpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1731, [$C5,$CD,$C2,$11,$07                               ] , 'vcmpordpd  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1732, [$C5,$CC,$C2,$D4,$07                               ] , 'vcmpordps  ymm2,ymm6,ymm4'                        );
  TestCase.testcase(1733, [$C5,$CC,$C2,$11,$07                               ] , 'vcmpordps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1734, [$C5,$CC,$C2,$11,$07                               ] , 'vcmpordps  ymm2,ymm6,yword [ecx]'                 );
  TestCase.testcase(1735, [$C4,$E3,$4D,$40,$D4,$07                           ] , 'vdpps  ymm2,ymm6,ymm4,0x7'                        );
  TestCase.testcase(1736, [$C4,$E3,$4D,$40,$11,$07                           ] , 'vdpps  ymm2,ymm6,yword [ecx],0x7'                 );
  TestCase.testcase(1737, [$C4,$E3,$4D,$40,$11,$07                           ] , 'vdpps  ymm2,ymm6,yword [ecx],0x7'                 );
  TestCase.testcase(1738, [$C4,$E3,$4D,$06,$D4,$07                           ] , 'vperm2f128  ymm2,ymm6,ymm4,0x7'                   );
  TestCase.testcase(1739, [$C4,$E3,$4D,$06,$11,$07                           ] , 'vperm2f128  ymm2,ymm6,yword [ecx],0x7'            );
  TestCase.testcase(1740, [$C4,$E3,$4D,$06,$11,$07                           ] , 'vperm2f128  ymm2,ymm6,yword [ecx],0x7'            );
  TestCase.testcase(1741, [$C5,$CD,$C6,$D4,$07                               ] , 'vshufpd  ymm2,ymm6,ymm4,0x7'                      );
  TestCase.testcase(1742, [$C5,$CD,$C6,$11,$07                               ] , 'vshufpd  ymm2,ymm6,yword [ecx],0x7'               );
  TestCase.testcase(1743, [$C5,$CD,$C6,$11,$07                               ] , 'vshufpd  ymm2,ymm6,yword [ecx],0x7'               );
  TestCase.testcase(1744, [$C5,$CC,$C6,$D4,$07                               ] , 'vshufps  ymm2,ymm6,ymm4,0x7'                      );
  TestCase.testcase(1745, [$C5,$CC,$C6,$11,$07                               ] , 'vshufps  ymm2,ymm6,yword [ecx],0x7'               );
  TestCase.testcase(1746, [$C5,$CC,$C6,$11,$07                               ] , 'vshufps  ymm2,ymm6,yword [ecx],0x7'               );
  TestCase.testcase(1747, [$C4,$E3,$6D,$4B,$FE,$40                           ] , 'vblendvpd  ymm7,ymm2,ymm6,ymm4'                   );
  TestCase.testcase(1748, [$C4,$E3,$6D,$4B,$39,$40                           ] , 'vblendvpd  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(1749, [$C4,$E3,$6D,$4B,$39,$40                           ] , 'vblendvpd  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(1750, [$C4,$E3,$6D,$4A,$FE,$40                           ] , 'vblendvps  ymm7,ymm2,ymm6,ymm4'                   );
  TestCase.testcase(1751, [$C4,$E3,$6D,$4A,$39,$40                           ] , 'vblendvps  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(1752, [$C4,$E3,$6D,$4A,$39,$40                           ] , 'vblendvps  ymm7,ymm2,yword [ecx],ymm4'            );
  TestCase.testcase(1753, [$C4,$E3,$5D,$18,$F4,$07                           ] , 'vinsertf128  ymm6,ymm4,xmm4,0x7'                  );
  TestCase.testcase(1754, [$C4,$E3,$5D,$18,$31,$07                           ] , 'vinsertf128  ymm6,ymm4,oword [ecx],0x7'           );
  TestCase.testcase(1755, [$C4,$E3,$5D,$18,$31,$07                           ] , 'vinsertf128  ymm6,ymm4,oword [ecx],0x7'           );
  TestCase.testcase(1756, [$C4,$E3,$7D,$19,$E4,$07                           ] , 'vextractf128  xmm4,ymm4,0x7'                      );
  TestCase.testcase(1757, [$C4,$E3,$7D,$19,$21,$07                           ] , 'vextractf128  oword [ecx],ymm4,0x7'               );
  TestCase.testcase(1758, [$C4,$E3,$7D,$19,$21,$07                           ] , 'vextractf128  oword [ecx],ymm4,0x7'               );
  TestCase.testcase(1759, [$C4,$E2,$7D,$1A,$21                               ] , 'vbroadcastf128  ymm4,oword [ecx]'                 );
  TestCase.testcase(1760, [$C4,$E2,$7D,$1A,$21                               ] , 'vbroadcastf128  ymm4,oword [ecx]'                 );
  TestCase.testcase(1761, [$C5,$F8,$5B,$F4                                   ] , 'vcvtdq2ps  xmm6,xmm4'                             );
  TestCase.testcase(1762, [$C5,$F8,$5B,$21                                   ] , 'vcvtdq2ps  xmm4,oword [ecx]'                      );
  TestCase.testcase(1763, [$C5,$F8,$5B,$21                                   ] , 'vcvtdq2ps  xmm4,oword [ecx]'                      );
  TestCase.testcase(1764, [$C5,$FB,$E6,$F4                                   ] , 'vcvtpd2dq  xmm6,xmm4'                             );
  TestCase.testcase(1765, [$C5,$FB,$E6,$21                                   ] , 'vcvtpd2dq  xmm4,oword [ecx]'                      );
  TestCase.testcase(1766, [$C5,$F9,$5A,$F4                                   ] , 'vcvtpd2ps  xmm6,xmm4'                             );
  TestCase.testcase(1767, [$C5,$F9,$5A,$21                                   ] , 'vcvtpd2ps  xmm4,oword [ecx]'                      );
  TestCase.testcase(1768, [$C5,$F9,$5B,$F4                                   ] , 'vcvtps2dq  xmm6,xmm4'                             );
  TestCase.testcase(1769, [$C5,$F9,$5B,$21                                   ] , 'vcvtps2dq  xmm4,oword [ecx]'                      );
  TestCase.testcase(1770, [$C5,$F9,$5B,$21                                   ] , 'vcvtps2dq  xmm4,oword [ecx]'                      );
  TestCase.testcase(1771, [$C5,$F9,$E6,$F4                                   ] , 'vcvttpd2dq  xmm6,xmm4'                            );
  TestCase.testcase(1772, [$C5,$F9,$E6,$21                                   ] , 'vcvttpd2dq  xmm4,oword [ecx]'                     );
  TestCase.testcase(1773, [$C5,$FA,$5B,$F4                                   ] , 'vcvttps2dq  xmm6,xmm4'                            );
  TestCase.testcase(1774, [$C5,$FA,$5B,$21                                   ] , 'vcvttps2dq  xmm4,oword [ecx]'                     );
  TestCase.testcase(1775, [$C5,$FA,$5B,$21                                   ] , 'vcvttps2dq  xmm4,oword [ecx]'                     );
  TestCase.testcase(1776, [$C5,$F9,$28,$F4                                   ] , 'vmovapd  xmm6,xmm4'                               );
  TestCase.testcase(1777, [$C5,$F9,$28,$21                                   ] , 'vmovapd  xmm4,oword [ecx]'                        );
  TestCase.testcase(1778, [$C5,$F9,$28,$21                                   ] , 'vmovapd  xmm4,oword [ecx]'                        );
  TestCase.testcase(1779, [$C5,$F8,$28,$F4                                   ] , 'vmovaps  xmm6,xmm4'                               );
  TestCase.testcase(1780, [$C5,$F8,$28,$21                                   ] , 'vmovaps  xmm4,oword [ecx]'                        );
  TestCase.testcase(1781, [$C5,$F8,$28,$21                                   ] , 'vmovaps  xmm4,oword [ecx]'                        );
  TestCase.testcase(1782, [$C5,$F9,$6F,$F4                                   ] , 'vmovdqa  xmm6,xmm4'                               );
  TestCase.testcase(1783, [$C5,$F9,$6F,$21                                   ] , 'vmovdqa  xmm4,oword [ecx]'                        );
  TestCase.testcase(1784, [$C5,$F9,$6F,$21                                   ] , 'vmovdqa  xmm4,oword [ecx]'                        );
  TestCase.testcase(1785, [$C5,$FA,$6F,$F4                                   ] , 'vmovdqu  xmm6,xmm4'                               );
  TestCase.testcase(1786, [$C5,$FA,$6F,$21                                   ] , 'vmovdqu  xmm4,oword [ecx]'                        );
  TestCase.testcase(1787, [$C5,$FA,$6F,$21                                   ] , 'vmovdqu  xmm4,oword [ecx]'                        );
  TestCase.testcase(1788, [$C5,$FA,$16,$F4                                   ] , 'vmovshdup  xmm6,xmm4'                             );
  TestCase.testcase(1789, [$C5,$FA,$16,$21                                   ] , 'vmovshdup  xmm4,oword [ecx]'                      );
  TestCase.testcase(1790, [$C5,$FA,$16,$21                                   ] , 'vmovshdup  xmm4,oword [ecx]'                      );
  TestCase.testcase(1791, [$C5,$FA,$12,$F4                                   ] , 'vmovsldup  xmm6,xmm4'                             );
  TestCase.testcase(1792, [$C5,$FA,$12,$21                                   ] , 'vmovsldup  xmm4,oword [ecx]'                      );
  TestCase.testcase(1793, [$C5,$FA,$12,$21                                   ] , 'vmovsldup  xmm4,oword [ecx]'                      );
  TestCase.testcase(1794, [$C5,$F9,$10,$F4                                   ] , 'vmovupd  xmm6,xmm4'                               );
  TestCase.testcase(1795, [$C5,$F9,$10,$21                                   ] , 'vmovupd  xmm4,oword [ecx]'                        );
  TestCase.testcase(1796, [$C5,$F9,$10,$21                                   ] , 'vmovupd  xmm4,oword [ecx]'                        );
  TestCase.testcase(1797, [$C5,$F8,$10,$F4                                   ] , 'vmovups  xmm6,xmm4'                               );
  TestCase.testcase(1798, [$C5,$F8,$10,$21                                   ] , 'vmovups  xmm4,oword [ecx]'                        );
  TestCase.testcase(1799, [$C5,$F8,$10,$21                                   ] , 'vmovups  xmm4,oword [ecx]'                        );
  TestCase.testcase(1800, [$C4,$E2,$79,$1C,$F4                               ] , 'vpabsb  xmm6,xmm4'                                );
  TestCase.testcase(1801, [$C4,$E2,$79,$1C,$21                               ] , 'vpabsb  xmm4,oword [ecx]'                         );
  TestCase.testcase(1802, [$C4,$E2,$79,$1C,$21                               ] , 'vpabsb  xmm4,oword [ecx]'                         );
  TestCase.testcase(1803, [$C4,$E2,$79,$1D,$F4                               ] , 'vpabsw  xmm6,xmm4'                                );
  TestCase.testcase(1804, [$C4,$E2,$79,$1D,$21                               ] , 'vpabsw  xmm4,oword [ecx]'                         );
  TestCase.testcase(1805, [$C4,$E2,$79,$1D,$21                               ] , 'vpabsw  xmm4,oword [ecx]'                         );
  TestCase.testcase(1806, [$C4,$E2,$79,$1E,$F4                               ] , 'vpabsd  xmm6,xmm4'                                );
  TestCase.testcase(1807, [$C4,$E2,$79,$1E,$21                               ] , 'vpabsd  xmm4,oword [ecx]'                         );
  TestCase.testcase(1808, [$C4,$E2,$79,$1E,$21                               ] , 'vpabsd  xmm4,oword [ecx]'                         );
  TestCase.testcase(1809, [$C4,$E2,$79,$41,$F4                               ] , 'vphminposuw  xmm6,xmm4'                           );
  TestCase.testcase(1810, [$C4,$E2,$79,$41,$21                               ] , 'vphminposuw  xmm4,oword [ecx]'                    );
  TestCase.testcase(1811, [$C4,$E2,$79,$41,$21                               ] , 'vphminposuw  xmm4,oword [ecx]'                    );
  TestCase.testcase(1812, [$C4,$E2,$79,$17,$F4                               ] , 'vptest  xmm6,xmm4'                                );
  TestCase.testcase(1813, [$C4,$E2,$79,$17,$21                               ] , 'vptest  xmm4,oword [ecx]'                         );
  TestCase.testcase(1814, [$C4,$E2,$79,$17,$21                               ] , 'vptest  xmm4,oword [ecx]'                         );
  TestCase.testcase(1815, [$C4,$E2,$79,$0E,$F4                               ] , 'vtestps  xmm6,xmm4'                               );
  TestCase.testcase(1816, [$C4,$E2,$79,$0E,$21                               ] , 'vtestps  xmm4,oword [ecx]'                        );
  TestCase.testcase(1817, [$C4,$E2,$79,$0E,$21                               ] , 'vtestps  xmm4,oword [ecx]'                        );
  TestCase.testcase(1818, [$C4,$E2,$79,$0F,$F4                               ] , 'vtestpd  xmm6,xmm4'                               );
  TestCase.testcase(1819, [$C4,$E2,$79,$0F,$21                               ] , 'vtestpd  xmm4,oword [ecx]'                        );
  TestCase.testcase(1820, [$C4,$E2,$79,$0F,$21                               ] , 'vtestpd  xmm4,oword [ecx]'                        );
  TestCase.testcase(1821, [$C5,$F8,$53,$F4                                   ] , 'vrcpps  xmm6,xmm4'                                );
  TestCase.testcase(1822, [$C5,$F8,$53,$21                                   ] , 'vrcpps  xmm4,oword [ecx]'                         );
  TestCase.testcase(1823, [$C5,$F8,$53,$21                                   ] , 'vrcpps  xmm4,oword [ecx]'                         );
  TestCase.testcase(1824, [$C5,$F8,$52,$F4                                   ] , 'vrsqrtps  xmm6,xmm4'                              );
  TestCase.testcase(1825, [$C5,$F8,$52,$21                                   ] , 'vrsqrtps  xmm4,oword [ecx]'                       );
  TestCase.testcase(1826, [$C5,$F8,$52,$21                                   ] , 'vrsqrtps  xmm4,oword [ecx]'                       );
  TestCase.testcase(1827, [$C5,$F9,$51,$F4                                   ] , 'vsqrtpd  xmm6,xmm4'                               );
  TestCase.testcase(1828, [$C5,$F9,$51,$21                                   ] , 'vsqrtpd  xmm4,oword [ecx]'                        );
  TestCase.testcase(1829, [$C5,$F9,$51,$21                                   ] , 'vsqrtpd  xmm4,oword [ecx]'                        );
  TestCase.testcase(1830, [$C5,$F8,$51,$F4                                   ] , 'vsqrtps  xmm6,xmm4'                               );
  TestCase.testcase(1831, [$C5,$F8,$51,$21                                   ] , 'vsqrtps  xmm4,oword [ecx]'                        );
  TestCase.testcase(1832, [$C5,$F8,$51,$21                                   ] , 'vsqrtps  xmm4,oword [ecx]'                        );
  TestCase.testcase(1833, [$C4,$E2,$79,$DB,$F4                               ] , 'vaesimc  xmm6,xmm4'                               );
  TestCase.testcase(1834, [$C4,$E2,$79,$DB,$21                               ] , 'vaesimc  xmm4,oword [ecx]'                        );
  TestCase.testcase(1835, [$C4,$E2,$79,$DB,$21                               ] , 'vaesimc  xmm4,oword [ecx]'                        );
  TestCase.testcase(1836, [$C5,$F9,$28,$F4                                   ] , 'vmovapd  xmm6,xmm4'                               );
  TestCase.testcase(1837, [$C5,$F9,$29,$21                                   ] , 'vmovapd  oword [ecx],xmm4'                        );
  TestCase.testcase(1838, [$C5,$F9,$29,$21                                   ] , 'vmovapd  oword [ecx],xmm4'                        );
  TestCase.testcase(1839, [$C5,$F8,$28,$F4                                   ] , 'vmovaps  xmm6,xmm4'                               );
  TestCase.testcase(1840, [$C5,$F8,$29,$21                                   ] , 'vmovaps  oword [ecx],xmm4'                        );
  TestCase.testcase(1841, [$C5,$F8,$29,$21                                   ] , 'vmovaps  oword [ecx],xmm4'                        );
  TestCase.testcase(1842, [$C5,$F9,$6F,$F4                                   ] , 'vmovdqa  xmm6,xmm4'                               );
  TestCase.testcase(1843, [$C5,$F9,$7F,$21                                   ] , 'vmovdqa  oword [ecx],xmm4'                        );
  TestCase.testcase(1844, [$C5,$F9,$7F,$21                                   ] , 'vmovdqa  oword [ecx],xmm4'                        );
  TestCase.testcase(1845, [$C5,$FA,$6F,$F4                                   ] , 'vmovdqu  xmm6,xmm4'                               );
  TestCase.testcase(1846, [$C5,$FA,$7F,$21                                   ] , 'vmovdqu  oword [ecx],xmm4'                        );
  TestCase.testcase(1847, [$C5,$FA,$7F,$21                                   ] , 'vmovdqu  oword [ecx],xmm4'                        );
  TestCase.testcase(1848, [$C5,$F9,$10,$F4                                   ] , 'vmovupd  xmm6,xmm4'                               );
  TestCase.testcase(1849, [$C5,$F9,$11,$21                                   ] , 'vmovupd  oword [ecx],xmm4'                        );
  TestCase.testcase(1850, [$C5,$F9,$11,$21                                   ] , 'vmovupd  oword [ecx],xmm4'                        );
  TestCase.testcase(1851, [$C5,$F8,$10,$F4                                   ] , 'vmovups  xmm6,xmm4'                               );
  TestCase.testcase(1852, [$C5,$F8,$11,$21                                   ] , 'vmovups  oword [ecx],xmm4'                        );
  TestCase.testcase(1853, [$C5,$F8,$11,$21                                   ] , 'vmovups  oword [ecx],xmm4'                        );
  TestCase.testcase(1854, [$C5,$FB,$F0,$21                                   ] , 'vlddqu  xmm4,[ecx]'                               );
  TestCase.testcase(1855, [$C5,$FB,$F0,$21                                   ] , 'vlddqu  xmm4,[ecx]'                               );
  TestCase.testcase(1856, [$C4,$E2,$79,$2A,$21                               ] , 'vmovntdqa  xmm4,oword [ecx]'                      );
  TestCase.testcase(1857, [$C4,$E2,$79,$2A,$21                               ] , 'vmovntdqa  xmm4,oword [ecx]'                      );
  TestCase.testcase(1858, [$C5,$F9,$E7,$21                                   ] , 'vmovntdq  oword [ecx],xmm4'                       );
  TestCase.testcase(1859, [$C5,$F9,$E7,$21                                   ] , 'vmovntdq  oword [ecx],xmm4'                       );
  TestCase.testcase(1860, [$C5,$F9,$2B,$21                                   ] , 'vmovntpd  oword [ecx],xmm4'                       );
  TestCase.testcase(1861, [$C5,$F9,$2B,$21                                   ] , 'vmovntpd  oword [ecx],xmm4'                       );
  TestCase.testcase(1862, [$C5,$F8,$2B,$21                                   ] , 'vmovntps  oword [ecx],xmm4'                       );
  TestCase.testcase(1863, [$C5,$F8,$2B,$21                                   ] , 'vmovntps  oword [ecx],xmm4'                       );
  TestCase.testcase(1864, [$C5,$FE,$E6,$E4                                   ] , 'vcvtdq2pd  ymm4,xmm4'                             );
  TestCase.testcase(1865, [$C5,$FE,$E6,$21                                   ] , 'vcvtdq2pd  ymm4,oword [ecx]'                      );
  TestCase.testcase(1866, [$C5,$FE,$E6,$21                                   ] , 'vcvtdq2pd  ymm4,oword [ecx]'                      );
  TestCase.testcase(1867, [$C5,$FC,$5A,$E4                                   ] , 'vcvtps2pd  ymm4,xmm4'                             );
  TestCase.testcase(1868, [$C5,$FC,$5A,$21                                   ] , 'vcvtps2pd  ymm4,oword [ecx]'                      );
  TestCase.testcase(1869, [$C5,$FC,$5A,$21                                   ] , 'vcvtps2pd  ymm4,oword [ecx]'                      );
  TestCase.testcase(1870, [$C5,$C9,$58,$D4                                   ] , 'vaddpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1871, [$C5,$C9,$58,$39                                   ] , 'vaddpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1872, [$C5,$C9,$58,$39                                   ] , 'vaddpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1873, [$C5,$C8,$58,$D4                                   ] , 'vaddps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1874, [$C5,$C8,$58,$39                                   ] , 'vaddps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1875, [$C5,$C8,$58,$39                                   ] , 'vaddps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1876, [$C5,$C9,$D0,$D4                                   ] , 'vaddsubpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(1877, [$C5,$C9,$D0,$39                                   ] , 'vaddsubpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1878, [$C5,$C9,$D0,$39                                   ] , 'vaddsubpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1879, [$C5,$CB,$D0,$D4                                   ] , 'vaddsubps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(1880, [$C5,$CB,$D0,$39                                   ] , 'vaddsubps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1881, [$C5,$CB,$D0,$39                                   ] , 'vaddsubps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1882, [$C5,$C9,$55,$D4                                   ] , 'vandnpd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(1883, [$C5,$C9,$55,$39                                   ] , 'vandnpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1884, [$C5,$C9,$55,$39                                   ] , 'vandnpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1885, [$C5,$C8,$55,$D4                                   ] , 'vandnps  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(1886, [$C5,$C8,$55,$39                                   ] , 'vandnps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1887, [$C5,$C8,$55,$39                                   ] , 'vandnps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1888, [$C5,$C9,$54,$D4                                   ] , 'vandpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1889, [$C5,$C9,$54,$39                                   ] , 'vandpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1890, [$C5,$C9,$54,$39                                   ] , 'vandpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1891, [$C5,$C8,$54,$D4                                   ] , 'vandps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1892, [$C5,$C8,$54,$39                                   ] , 'vandps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1893, [$C5,$C8,$54,$39                                   ] , 'vandps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1894, [$C5,$C9,$5E,$D4                                   ] , 'vdivpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1895, [$C5,$C9,$5E,$39                                   ] , 'vdivpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1896, [$C5,$C9,$5E,$39                                   ] , 'vdivpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1897, [$C5,$C8,$5E,$D4                                   ] , 'vdivps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1898, [$C5,$C8,$5E,$39                                   ] , 'vdivps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1899, [$C5,$C8,$5E,$39                                   ] , 'vdivps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1900, [$C5,$C9,$7C,$D4                                   ] , 'vhaddpd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(1901, [$C5,$C9,$7C,$39                                   ] , 'vhaddpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1902, [$C5,$C9,$7C,$39                                   ] , 'vhaddpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1903, [$C5,$CB,$7C,$D4                                   ] , 'vhaddps  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(1904, [$C5,$CB,$7C,$39                                   ] , 'vhaddps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1905, [$C5,$CB,$7C,$39                                   ] , 'vhaddps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1906, [$C5,$C9,$7D,$D4                                   ] , 'vhsubpd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(1907, [$C5,$C9,$7D,$39                                   ] , 'vhsubpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1908, [$C5,$C9,$7D,$39                                   ] , 'vhsubpd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1909, [$C5,$CB,$7D,$D4                                   ] , 'vhsubps  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(1910, [$C5,$CB,$7D,$39                                   ] , 'vhsubps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1911, [$C5,$CB,$7D,$39                                   ] , 'vhsubps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1912, [$C5,$C9,$5F,$D4                                   ] , 'vmaxpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1913, [$C5,$C9,$5F,$39                                   ] , 'vmaxpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1914, [$C5,$C9,$5F,$39                                   ] , 'vmaxpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1915, [$C5,$C8,$5F,$D4                                   ] , 'vmaxps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1916, [$C5,$C8,$5F,$39                                   ] , 'vmaxps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1917, [$C5,$C8,$5F,$39                                   ] , 'vmaxps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1918, [$C5,$C9,$5D,$D4                                   ] , 'vminpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1919, [$C5,$C9,$5D,$39                                   ] , 'vminpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1920, [$C5,$C9,$5D,$39                                   ] , 'vminpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1921, [$C5,$C8,$5D,$D4                                   ] , 'vminps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1922, [$C5,$C8,$5D,$39                                   ] , 'vminps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1923, [$C5,$C8,$5D,$39                                   ] , 'vminps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1924, [$C5,$C9,$59,$D4                                   ] , 'vmulpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1925, [$C5,$C9,$59,$39                                   ] , 'vmulpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1926, [$C5,$C9,$59,$39                                   ] , 'vmulpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1927, [$C5,$C8,$59,$D4                                   ] , 'vmulps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1928, [$C5,$C8,$59,$39                                   ] , 'vmulps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1929, [$C5,$C8,$59,$39                                   ] , 'vmulps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1930, [$C5,$C9,$56,$D4                                   ] , 'vorpd  xmm2,xmm6,xmm4'                            );
  TestCase.testcase(1931, [$C5,$C9,$56,$39                                   ] , 'vorpd  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(1932, [$C5,$C9,$56,$39                                   ] , 'vorpd  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(1933, [$C5,$C8,$56,$D4                                   ] , 'vorps  xmm2,xmm6,xmm4'                            );
  TestCase.testcase(1934, [$C5,$C8,$56,$39                                   ] , 'vorps  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(1935, [$C5,$C8,$56,$39                                   ] , 'vorps  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(1936, [$C5,$C9,$63,$D4                                   ] , 'vpacksswb  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(1937, [$C5,$C9,$63,$39                                   ] , 'vpacksswb  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1938, [$C5,$C9,$63,$39                                   ] , 'vpacksswb  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1939, [$C5,$C9,$6B,$D4                                   ] , 'vpackssdw  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(1940, [$C5,$C9,$6B,$39                                   ] , 'vpackssdw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1941, [$C5,$C9,$6B,$39                                   ] , 'vpackssdw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1942, [$C5,$C9,$67,$D4                                   ] , 'vpackuswb  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(1943, [$C5,$C9,$67,$39                                   ] , 'vpackuswb  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1944, [$C5,$C9,$67,$39                                   ] , 'vpackuswb  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1945, [$C4,$E2,$49,$2B,$D4                               ] , 'vpackusdw  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(1946, [$C4,$E2,$49,$2B,$39                               ] , 'vpackusdw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1947, [$C4,$E2,$49,$2B,$39                               ] , 'vpackusdw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(1948, [$C5,$C9,$FC,$D4                                   ] , 'vpaddb  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1949, [$C5,$C9,$FC,$39                                   ] , 'vpaddb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1950, [$C5,$C9,$FC,$39                                   ] , 'vpaddb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1951, [$C5,$C9,$FD,$D4                                   ] , 'vpaddw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1952, [$C5,$C9,$FD,$39                                   ] , 'vpaddw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1953, [$C5,$C9,$FD,$39                                   ] , 'vpaddw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1954, [$C5,$C9,$FE,$D4                                   ] , 'vpaddd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1955, [$C5,$C9,$FE,$39                                   ] , 'vpaddd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1956, [$C5,$C9,$FE,$39                                   ] , 'vpaddd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1957, [$C5,$C9,$D4,$D4                                   ] , 'vpaddq  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1958, [$C5,$C9,$D4,$39                                   ] , 'vpaddq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1959, [$C5,$C9,$D4,$39                                   ] , 'vpaddq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1960, [$C5,$C9,$EC,$D4                                   ] , 'vpaddsb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(1961, [$C5,$C9,$EC,$39                                   ] , 'vpaddsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1962, [$C5,$C9,$EC,$39                                   ] , 'vpaddsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1963, [$C5,$C9,$ED,$D4                                   ] , 'vpaddsw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(1964, [$C5,$C9,$ED,$39                                   ] , 'vpaddsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1965, [$C5,$C9,$ED,$39                                   ] , 'vpaddsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(1966, [$C5,$C9,$DC,$D4                                   ] , 'vpaddusb  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(1967, [$C5,$C9,$DC,$39                                   ] , 'vpaddusb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(1968, [$C5,$C9,$DC,$39                                   ] , 'vpaddusb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(1969, [$C5,$C9,$DD,$D4                                   ] , 'vpaddusw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(1970, [$C5,$C9,$DD,$39                                   ] , 'vpaddusw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(1971, [$C5,$C9,$DD,$39                                   ] , 'vpaddusw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(1972, [$C5,$C9,$DB,$D4                                   ] , 'vpand  xmm2,xmm6,xmm4'                            );
  TestCase.testcase(1973, [$C5,$C9,$DB,$39                                   ] , 'vpand  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(1974, [$C5,$C9,$DB,$39                                   ] , 'vpand  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(1975, [$C5,$C9,$DF,$D4                                   ] , 'vpandn  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1976, [$C5,$C9,$DF,$39                                   ] , 'vpandn  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1977, [$C5,$C9,$DF,$39                                   ] , 'vpandn  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1978, [$C5,$C9,$E0,$D4                                   ] , 'vpavgb  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1979, [$C5,$C9,$E0,$39                                   ] , 'vpavgb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1980, [$C5,$C9,$E0,$39                                   ] , 'vpavgb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1981, [$C5,$C9,$E3,$D4                                   ] , 'vpavgw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(1982, [$C5,$C9,$E3,$39                                   ] , 'vpavgw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1983, [$C5,$C9,$E3,$39                                   ] , 'vpavgw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(1984, [$C4,$E3,$49,$44,$D4,$00                           ] , 'vpclmullqlqdq  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(1985, [$C4,$E3,$49,$44,$39,$00                           ] , 'vpclmullqlqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(1986, [$C4,$E3,$49,$44,$39,$00                           ] , 'vpclmullqlqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(1987, [$C4,$E3,$49,$44,$D4,$01                           ] , 'vpclmulhqlqdq  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(1988, [$C4,$E3,$49,$44,$39,$01                           ] , 'vpclmulhqlqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(1989, [$C4,$E3,$49,$44,$39,$01                           ] , 'vpclmulhqlqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(1990, [$C4,$E3,$49,$44,$D4,$10                           ] , 'vpclmullqhqdq  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(1991, [$C4,$E3,$49,$44,$39,$10                           ] , 'vpclmullqhqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(1992, [$C4,$E3,$49,$44,$39,$10                           ] , 'vpclmullqhqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(1993, [$C4,$E3,$49,$44,$D4,$11                           ] , 'vpclmulhqhqdq  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(1994, [$C4,$E3,$49,$44,$39,$11                           ] , 'vpclmulhqhqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(1995, [$C4,$E3,$49,$44,$39,$11                           ] , 'vpclmulhqhqdq  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(1996, [$C5,$C9,$74,$D4                                   ] , 'vpcmpeqb  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(1997, [$C5,$C9,$74,$39                                   ] , 'vpcmpeqb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(1998, [$C5,$C9,$74,$39                                   ] , 'vpcmpeqb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(1999, [$C5,$C9,$75,$D4                                   ] , 'vpcmpeqw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2000, [$C5,$C9,$75,$39                                   ] , 'vpcmpeqw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2001, [$C5,$C9,$75,$39                                   ] , 'vpcmpeqw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2002, [$C5,$C9,$76,$D4                                   ] , 'vpcmpeqd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2003, [$C5,$C9,$76,$39                                   ] , 'vpcmpeqd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2004, [$C5,$C9,$76,$39                                   ] , 'vpcmpeqd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2005, [$C4,$E2,$49,$29,$D4                               ] , 'vpcmpeqq  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2006, [$C4,$E2,$49,$29,$39                               ] , 'vpcmpeqq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2007, [$C4,$E2,$49,$29,$39                               ] , 'vpcmpeqq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2008, [$C5,$C9,$64,$D4                                   ] , 'vpcmpgtb  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2009, [$C5,$C9,$64,$39                                   ] , 'vpcmpgtb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2010, [$C5,$C9,$64,$39                                   ] , 'vpcmpgtb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2011, [$C5,$C9,$65,$D4                                   ] , 'vpcmpgtw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2012, [$C5,$C9,$65,$39                                   ] , 'vpcmpgtw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2013, [$C5,$C9,$65,$39                                   ] , 'vpcmpgtw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2014, [$C5,$C9,$66,$D4                                   ] , 'vpcmpgtd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2015, [$C5,$C9,$66,$39                                   ] , 'vpcmpgtd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2016, [$C5,$C9,$66,$39                                   ] , 'vpcmpgtd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2017, [$C4,$E2,$49,$37,$D4                               ] , 'vpcmpgtq  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2018, [$C4,$E2,$49,$37,$39                               ] , 'vpcmpgtq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2019, [$C4,$E2,$49,$37,$39                               ] , 'vpcmpgtq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2020, [$C4,$E2,$49,$0D,$D4                               ] , 'vpermilpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2021, [$C4,$E2,$49,$0D,$39                               ] , 'vpermilpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2022, [$C4,$E2,$49,$0D,$39                               ] , 'vpermilpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2023, [$C4,$E2,$49,$0C,$D4                               ] , 'vpermilps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2024, [$C4,$E2,$49,$0C,$39                               ] , 'vpermilps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2025, [$C4,$E2,$49,$0C,$39                               ] , 'vpermilps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2026, [$C4,$E2,$49,$01,$D4                               ] , 'vphaddw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2027, [$C4,$E2,$49,$01,$39                               ] , 'vphaddw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2028, [$C4,$E2,$49,$01,$39                               ] , 'vphaddw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2029, [$C4,$E2,$49,$02,$D4                               ] , 'vphaddd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2030, [$C4,$E2,$49,$02,$39                               ] , 'vphaddd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2031, [$C4,$E2,$49,$02,$39                               ] , 'vphaddd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2032, [$C4,$E2,$49,$03,$D4                               ] , 'vphaddsw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2033, [$C4,$E2,$49,$03,$39                               ] , 'vphaddsw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2034, [$C4,$E2,$49,$03,$39                               ] , 'vphaddsw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2035, [$C4,$E2,$49,$05,$D4                               ] , 'vphsubw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2036, [$C4,$E2,$49,$05,$39                               ] , 'vphsubw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2037, [$C4,$E2,$49,$05,$39                               ] , 'vphsubw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2038, [$C4,$E2,$49,$06,$D4                               ] , 'vphsubd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2039, [$C4,$E2,$49,$06,$39                               ] , 'vphsubd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2040, [$C4,$E2,$49,$06,$39                               ] , 'vphsubd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2041, [$C4,$E2,$49,$07,$D4                               ] , 'vphsubsw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2042, [$C4,$E2,$49,$07,$39                               ] , 'vphsubsw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2043, [$C4,$E2,$49,$07,$39                               ] , 'vphsubsw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2044, [$C5,$C9,$F5,$D4                                   ] , 'vpmaddwd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2045, [$C5,$C9,$F5,$39                                   ] , 'vpmaddwd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2046, [$C5,$C9,$F5,$39                                   ] , 'vpmaddwd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2047, [$C4,$E2,$49,$04,$D4                               ] , 'vpmaddubsw  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2048, [$C4,$E2,$49,$04,$39                               ] , 'vpmaddubsw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2049, [$C4,$E2,$49,$04,$39                               ] , 'vpmaddubsw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2050, [$C4,$E2,$49,$3C,$D4                               ] , 'vpmaxsb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2051, [$C4,$E2,$49,$3C,$39                               ] , 'vpmaxsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2052, [$C4,$E2,$49,$3C,$39                               ] , 'vpmaxsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2053, [$C5,$C9,$EE,$D4                                   ] , 'vpmaxsw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2054, [$C5,$C9,$EE,$39                                   ] , 'vpmaxsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2055, [$C5,$C9,$EE,$39                                   ] , 'vpmaxsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2056, [$C4,$E2,$49,$3D,$D4                               ] , 'vpmaxsd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2057, [$C4,$E2,$49,$3D,$39                               ] , 'vpmaxsd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2058, [$C4,$E2,$49,$3D,$39                               ] , 'vpmaxsd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2059, [$C5,$C9,$DE,$D4                                   ] , 'vpmaxub  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2060, [$C5,$C9,$DE,$39                                   ] , 'vpmaxub  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2061, [$C5,$C9,$DE,$39                                   ] , 'vpmaxub  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2062, [$C4,$E2,$49,$3E,$D4                               ] , 'vpmaxuw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2063, [$C4,$E2,$49,$3E,$39                               ] , 'vpmaxuw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2064, [$C4,$E2,$49,$3E,$39                               ] , 'vpmaxuw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2065, [$C4,$E2,$49,$3F,$D4                               ] , 'vpmaxud  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2066, [$C4,$E2,$49,$3F,$39                               ] , 'vpmaxud  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2067, [$C4,$E2,$49,$3F,$39                               ] , 'vpmaxud  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2068, [$C4,$E2,$49,$38,$D4                               ] , 'vpminsb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2069, [$C4,$E2,$49,$38,$39                               ] , 'vpminsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2070, [$C4,$E2,$49,$38,$39                               ] , 'vpminsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2071, [$C5,$C9,$EA,$D4                                   ] , 'vpminsw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2072, [$C5,$C9,$EA,$39                                   ] , 'vpminsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2073, [$C5,$C9,$EA,$39                                   ] , 'vpminsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2074, [$C4,$E2,$49,$39,$D4                               ] , 'vpminsd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2075, [$C4,$E2,$49,$39,$39                               ] , 'vpminsd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2076, [$C4,$E2,$49,$39,$39                               ] , 'vpminsd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2077, [$C5,$C9,$DA,$D4                                   ] , 'vpminub  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2078, [$C5,$C9,$DA,$39                                   ] , 'vpminub  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2079, [$C5,$C9,$DA,$39                                   ] , 'vpminub  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2080, [$C4,$E2,$49,$3A,$D4                               ] , 'vpminuw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2081, [$C4,$E2,$49,$3A,$39                               ] , 'vpminuw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2082, [$C4,$E2,$49,$3A,$39                               ] , 'vpminuw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2083, [$C4,$E2,$49,$3B,$D4                               ] , 'vpminud  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2084, [$C4,$E2,$49,$3B,$39                               ] , 'vpminud  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2085, [$C4,$E2,$49,$3B,$39                               ] , 'vpminud  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2086, [$C5,$C9,$E4,$D4                                   ] , 'vpmulhuw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2087, [$C5,$C9,$E4,$39                                   ] , 'vpmulhuw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2088, [$C5,$C9,$E4,$39                                   ] , 'vpmulhuw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2089, [$C4,$E2,$49,$0B,$D4                               ] , 'vpmulhrsw  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2090, [$C4,$E2,$49,$0B,$39                               ] , 'vpmulhrsw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2091, [$C4,$E2,$49,$0B,$39                               ] , 'vpmulhrsw  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2092, [$C5,$C9,$E5,$D4                                   ] , 'vpmulhw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2093, [$C5,$C9,$E5,$39                                   ] , 'vpmulhw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2094, [$C5,$C9,$E5,$39                                   ] , 'vpmulhw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2095, [$C5,$C9,$D5,$D4                                   ] , 'vpmullw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2096, [$C5,$C9,$D5,$39                                   ] , 'vpmullw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2097, [$C5,$C9,$D5,$39                                   ] , 'vpmullw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2098, [$C4,$E2,$49,$40,$D4                               ] , 'vpmulld  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2099, [$C4,$E2,$49,$40,$39                               ] , 'vpmulld  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2100, [$C4,$E2,$49,$40,$39                               ] , 'vpmulld  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2101, [$C5,$C9,$F4,$D4                                   ] , 'vpmuludq  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2102, [$C5,$C9,$F4,$39                                   ] , 'vpmuludq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2103, [$C5,$C9,$F4,$39                                   ] , 'vpmuludq  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2104, [$C4,$E2,$49,$28,$D4                               ] , 'vpmuldq  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2105, [$C4,$E2,$49,$28,$39                               ] , 'vpmuldq  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2106, [$C4,$E2,$49,$28,$39                               ] , 'vpmuldq  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2107, [$C5,$C9,$EB,$D4                                   ] , 'vpor  xmm2,xmm6,xmm4'                             );
  TestCase.testcase(2108, [$C5,$C9,$EB,$39                                   ] , 'vpor  xmm7,xmm6,oword [ecx]'                      );
  TestCase.testcase(2109, [$C5,$C9,$EB,$39                                   ] , 'vpor  xmm7,xmm6,oword [ecx]'                      );
  TestCase.testcase(2110, [$C5,$C9,$F6,$D4                                   ] , 'vpsadbw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2111, [$C5,$C9,$F6,$39                                   ] , 'vpsadbw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2112, [$C5,$C9,$F6,$39                                   ] , 'vpsadbw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2113, [$C4,$E2,$49,$00,$D4                               ] , 'vpshufb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2114, [$C4,$E2,$49,$00,$39                               ] , 'vpshufb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2115, [$C4,$E2,$49,$00,$39                               ] , 'vpshufb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2116, [$C4,$E2,$49,$08,$D4                               ] , 'vpsignb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2117, [$C4,$E2,$49,$08,$39                               ] , 'vpsignb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2118, [$C4,$E2,$49,$08,$39                               ] , 'vpsignb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2119, [$C4,$E2,$49,$09,$D4                               ] , 'vpsignw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2120, [$C4,$E2,$49,$09,$39                               ] , 'vpsignw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2121, [$C4,$E2,$49,$09,$39                               ] , 'vpsignw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2122, [$C4,$E2,$49,$0A,$D4                               ] , 'vpsignd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2123, [$C4,$E2,$49,$0A,$39                               ] , 'vpsignd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2124, [$C4,$E2,$49,$0A,$39                               ] , 'vpsignd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2125, [$C5,$C9,$F1,$D4                                   ] , 'vpsllw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2126, [$C5,$C9,$F1,$39                                   ] , 'vpsllw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2127, [$C5,$C9,$F1,$39                                   ] , 'vpsllw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2128, [$C5,$C9,$F2,$D4                                   ] , 'vpslld  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2129, [$C5,$C9,$F2,$39                                   ] , 'vpslld  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2130, [$C5,$C9,$F2,$39                                   ] , 'vpslld  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2131, [$C5,$C9,$F3,$D4                                   ] , 'vpsllq  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2132, [$C5,$C9,$F3,$39                                   ] , 'vpsllq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2133, [$C5,$C9,$F3,$39                                   ] , 'vpsllq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2134, [$C5,$C9,$E1,$D4                                   ] , 'vpsraw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2135, [$C5,$C9,$E1,$39                                   ] , 'vpsraw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2136, [$C5,$C9,$E1,$39                                   ] , 'vpsraw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2137, [$C5,$C9,$E2,$D4                                   ] , 'vpsrad  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2138, [$C5,$C9,$E2,$39                                   ] , 'vpsrad  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2139, [$C5,$C9,$E2,$39                                   ] , 'vpsrad  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2140, [$C5,$C9,$D1,$D4                                   ] , 'vpsrlw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2141, [$C5,$C9,$D1,$39                                   ] , 'vpsrlw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2142, [$C5,$C9,$D1,$39                                   ] , 'vpsrlw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2143, [$C5,$C9,$D2,$D4                                   ] , 'vpsrld  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2144, [$C5,$C9,$D2,$39                                   ] , 'vpsrld  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2145, [$C5,$C9,$D2,$39                                   ] , 'vpsrld  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2146, [$C5,$C9,$D3,$D4                                   ] , 'vpsrlq  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2147, [$C5,$C9,$D3,$39                                   ] , 'vpsrlq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2148, [$C5,$C9,$D3,$39                                   ] , 'vpsrlq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2149, [$C5,$C9,$F8,$D4                                   ] , 'vpsubb  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2150, [$C5,$C9,$F8,$39                                   ] , 'vpsubb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2151, [$C5,$C9,$F8,$39                                   ] , 'vpsubb  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2152, [$C5,$C9,$F9,$D4                                   ] , 'vpsubw  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2153, [$C5,$C9,$F9,$39                                   ] , 'vpsubw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2154, [$C5,$C9,$F9,$39                                   ] , 'vpsubw  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2155, [$C5,$C9,$FA,$D4                                   ] , 'vpsubd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2156, [$C5,$C9,$FA,$39                                   ] , 'vpsubd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2157, [$C5,$C9,$FA,$39                                   ] , 'vpsubd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2158, [$C5,$C9,$FB,$D4                                   ] , 'vpsubq  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2159, [$C5,$C9,$FB,$39                                   ] , 'vpsubq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2160, [$C5,$C9,$FB,$39                                   ] , 'vpsubq  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2161, [$C5,$C9,$E8,$D4                                   ] , 'vpsubsb  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2162, [$C5,$C9,$E8,$39                                   ] , 'vpsubsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2163, [$C5,$C9,$E8,$39                                   ] , 'vpsubsb  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2164, [$C5,$C9,$E9,$D4                                   ] , 'vpsubsw  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2165, [$C5,$C9,$E9,$39                                   ] , 'vpsubsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2166, [$C5,$C9,$E9,$39                                   ] , 'vpsubsw  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2167, [$C5,$C9,$D8,$D4                                   ] , 'vpsubusb  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2168, [$C5,$C9,$D8,$39                                   ] , 'vpsubusb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2169, [$C5,$C9,$D8,$39                                   ] , 'vpsubusb  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2170, [$C5,$C9,$D9,$D4                                   ] , 'vpsubusw  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2171, [$C5,$C9,$D9,$39                                   ] , 'vpsubusw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2172, [$C5,$C9,$D9,$39                                   ] , 'vpsubusw  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2173, [$C5,$C9,$68,$D4                                   ] , 'vpunpckhbw  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2174, [$C5,$C9,$68,$39                                   ] , 'vpunpckhbw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2175, [$C5,$C9,$68,$39                                   ] , 'vpunpckhbw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2176, [$C5,$C9,$69,$D4                                   ] , 'vpunpckhwd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2177, [$C5,$C9,$69,$39                                   ] , 'vpunpckhwd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2178, [$C5,$C9,$69,$39                                   ] , 'vpunpckhwd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2179, [$C5,$C9,$6A,$D4                                   ] , 'vpunpckhdq  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2180, [$C5,$C9,$6A,$39                                   ] , 'vpunpckhdq  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2181, [$C5,$C9,$6A,$39                                   ] , 'vpunpckhdq  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2182, [$C5,$C9,$6D,$D4                                   ] , 'vpunpckhqdq  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2183, [$C5,$C9,$6D,$39                                   ] , 'vpunpckhqdq  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2184, [$C5,$C9,$6D,$39                                   ] , 'vpunpckhqdq  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2185, [$C5,$C9,$60,$D4                                   ] , 'vpunpcklbw  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2186, [$C5,$C9,$60,$39                                   ] , 'vpunpcklbw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2187, [$C5,$C9,$60,$39                                   ] , 'vpunpcklbw  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2188, [$C5,$C9,$61,$D4                                   ] , 'vpunpcklwd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2189, [$C5,$C9,$61,$39                                   ] , 'vpunpcklwd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2190, [$C5,$C9,$61,$39                                   ] , 'vpunpcklwd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2191, [$C5,$C9,$62,$D4                                   ] , 'vpunpckldq  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2192, [$C5,$C9,$62,$39                                   ] , 'vpunpckldq  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2193, [$C5,$C9,$62,$39                                   ] , 'vpunpckldq  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2194, [$C5,$C9,$6C,$D4                                   ] , 'vpunpcklqdq  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2195, [$C5,$C9,$6C,$39                                   ] , 'vpunpcklqdq  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2196, [$C5,$C9,$6C,$39                                   ] , 'vpunpcklqdq  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2197, [$C5,$C9,$EF,$D4                                   ] , 'vpxor  xmm2,xmm6,xmm4'                            );
  TestCase.testcase(2198, [$C5,$C9,$EF,$39                                   ] , 'vpxor  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(2199, [$C5,$C9,$EF,$39                                   ] , 'vpxor  xmm7,xmm6,oword [ecx]'                     );
  TestCase.testcase(2200, [$C5,$C9,$5C,$D4                                   ] , 'vsubpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2201, [$C5,$C9,$5C,$39                                   ] , 'vsubpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2202, [$C5,$C9,$5C,$39                                   ] , 'vsubpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2203, [$C5,$C8,$5C,$D4                                   ] , 'vsubps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2204, [$C5,$C8,$5C,$39                                   ] , 'vsubps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2205, [$C5,$C8,$5C,$39                                   ] , 'vsubps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2206, [$C5,$C9,$15,$D4                                   ] , 'vunpckhpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2207, [$C5,$C9,$15,$39                                   ] , 'vunpckhpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2208, [$C5,$C9,$15,$39                                   ] , 'vunpckhpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2209, [$C5,$C8,$15,$D4                                   ] , 'vunpckhps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2210, [$C5,$C8,$15,$39                                   ] , 'vunpckhps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2211, [$C5,$C8,$15,$39                                   ] , 'vunpckhps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2212, [$C5,$C9,$14,$D4                                   ] , 'vunpcklpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2213, [$C5,$C9,$14,$39                                   ] , 'vunpcklpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2214, [$C5,$C9,$14,$39                                   ] , 'vunpcklpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2215, [$C5,$C8,$14,$D4                                   ] , 'vunpcklps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2216, [$C5,$C8,$14,$39                                   ] , 'vunpcklps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2217, [$C5,$C8,$14,$39                                   ] , 'vunpcklps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2218, [$C5,$C9,$57,$D4                                   ] , 'vxorpd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2219, [$C5,$C9,$57,$39                                   ] , 'vxorpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2220, [$C5,$C9,$57,$39                                   ] , 'vxorpd  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2221, [$C5,$C8,$57,$D4                                   ] , 'vxorps  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2222, [$C5,$C8,$57,$39                                   ] , 'vxorps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2223, [$C5,$C8,$57,$39                                   ] , 'vxorps  xmm7,xmm6,oword [ecx]'                    );
  TestCase.testcase(2224, [$C4,$E2,$49,$DC,$D4                               ] , 'vaesenc  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2225, [$C4,$E2,$49,$DC,$39                               ] , 'vaesenc  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2226, [$C4,$E2,$49,$DC,$39                               ] , 'vaesenc  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2227, [$C4,$E2,$49,$DD,$D4                               ] , 'vaesenclast  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2228, [$C4,$E2,$49,$DD,$39                               ] , 'vaesenclast  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2229, [$C4,$E2,$49,$DD,$39                               ] , 'vaesenclast  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2230, [$C4,$E2,$49,$DE,$D4                               ] , 'vaesdec  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2231, [$C4,$E2,$49,$DE,$39                               ] , 'vaesdec  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2232, [$C4,$E2,$49,$DE,$39                               ] , 'vaesdec  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2233, [$C4,$E2,$49,$DF,$D4                               ] , 'vaesdeclast  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2234, [$C4,$E2,$49,$DF,$39                               ] , 'vaesdeclast  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2235, [$C4,$E2,$49,$DF,$39                               ] , 'vaesdeclast  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2236, [$C5,$C9,$C2,$D4,$00                               ] , 'vcmpeqpd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2237, [$C5,$C9,$C2,$39,$00                               ] , 'vcmpeqpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2238, [$C5,$C9,$C2,$39,$00                               ] , 'vcmpeqpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2239, [$C5,$C9,$C2,$D4,$01                               ] , 'vcmpltpd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2240, [$C5,$C9,$C2,$39,$01                               ] , 'vcmpltpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2241, [$C5,$C9,$C2,$39,$01                               ] , 'vcmpltpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2242, [$C5,$C9,$C2,$D4,$02                               ] , 'vcmplepd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2243, [$C5,$C9,$C2,$39,$02                               ] , 'vcmplepd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2244, [$C5,$C9,$C2,$39,$02                               ] , 'vcmplepd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2245, [$C5,$C9,$C2,$D4,$03                               ] , 'vcmpunordpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2246, [$C5,$C9,$C2,$39,$03                               ] , 'vcmpunordpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2247, [$C5,$C9,$C2,$39,$03                               ] , 'vcmpunordpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2248, [$C5,$C9,$C2,$D4,$04                               ] , 'vcmpneqpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2249, [$C5,$C9,$C2,$39,$04                               ] , 'vcmpneqpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2250, [$C5,$C9,$C2,$39,$04                               ] , 'vcmpneqpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2251, [$C5,$C9,$C2,$D4,$05                               ] , 'vcmpnltpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2252, [$C5,$C9,$C2,$39,$05                               ] , 'vcmpnltpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2253, [$C5,$C9,$C2,$39,$05                               ] , 'vcmpnltpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2254, [$C5,$C9,$C2,$D4,$06                               ] , 'vcmpnlepd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2255, [$C5,$C9,$C2,$39,$06                               ] , 'vcmpnlepd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2256, [$C5,$C9,$C2,$39,$06                               ] , 'vcmpnlepd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2257, [$C5,$C9,$C2,$D4,$07                               ] , 'vcmpordpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2258, [$C5,$C9,$C2,$39,$07                               ] , 'vcmpordpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2259, [$C5,$C9,$C2,$39,$07                               ] , 'vcmpordpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2260, [$C5,$C9,$C2,$D4,$08                               ] , 'vcmpeq_uqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2261, [$C5,$C9,$C2,$39,$08                               ] , 'vcmpeq_uqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2262, [$C5,$C9,$C2,$39,$08                               ] , 'vcmpeq_uqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2263, [$C5,$C9,$C2,$D4,$09                               ] , 'vcmpngepd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2264, [$C5,$C9,$C2,$39,$09                               ] , 'vcmpngepd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2265, [$C5,$C9,$C2,$39,$09                               ] , 'vcmpngepd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2266, [$C5,$C9,$C2,$D4,$0A                               ] , 'vcmpngtpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2267, [$C5,$C9,$C2,$39,$0A                               ] , 'vcmpngtpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2268, [$C5,$C9,$C2,$39,$0A                               ] , 'vcmpngtpd  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2269, [$C5,$C9,$C2,$D4,$0B                               ] , 'vcmpfalsepd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2270, [$C5,$C9,$C2,$39,$0B                               ] , 'vcmpfalsepd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2271, [$C5,$C9,$C2,$39,$0B                               ] , 'vcmpfalsepd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2272, [$C5,$C9,$C2,$D4,$0C                               ] , 'vcmpneq_oqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2273, [$C5,$C9,$C2,$39,$0C                               ] , 'vcmpneq_oqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2274, [$C5,$C9,$C2,$39,$0C                               ] , 'vcmpneq_oqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2275, [$C5,$C9,$C2,$D4,$0D                               ] , 'vcmpgepd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2276, [$C5,$C9,$C2,$39,$0D                               ] , 'vcmpgepd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2277, [$C5,$C9,$C2,$39,$0D                               ] , 'vcmpgepd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2278, [$C5,$C9,$C2,$D4,$0E                               ] , 'vcmpgtpd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2279, [$C5,$C9,$C2,$39,$0E                               ] , 'vcmpgtpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2280, [$C5,$C9,$C2,$39,$0E                               ] , 'vcmpgtpd  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2281, [$C5,$C9,$C2,$D4,$0F                               ] , 'vcmuepd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2282, [$C5,$C9,$C2,$39,$0F                               ] , 'vcmuepd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2283, [$C5,$C9,$C2,$39,$0F                               ] , 'vcmuepd  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2284, [$C5,$C9,$C2,$D4,$10                               ] , 'vcmpeq_ospd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2285, [$C5,$C9,$C2,$39,$10                               ] , 'vcmpeq_ospd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2286, [$C5,$C9,$C2,$39,$10                               ] , 'vcmpeq_ospd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2287, [$C5,$C9,$C2,$D4,$11                               ] , 'vcmplt_oqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2288, [$C5,$C9,$C2,$39,$11                               ] , 'vcmplt_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2289, [$C5,$C9,$C2,$39,$11                               ] , 'vcmplt_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2290, [$C5,$C9,$C2,$D4,$12                               ] , 'vcmple_oqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2291, [$C5,$C9,$C2,$39,$12                               ] , 'vcmple_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2292, [$C5,$C9,$C2,$39,$12                               ] , 'vcmple_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2293, [$C5,$C9,$C2,$D4,$13                               ] , 'vcmpunord_spd  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(2294, [$C5,$C9,$C2,$39,$13                               ] , 'vcmpunord_spd  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(2295, [$C5,$C9,$C2,$39,$13                               ] , 'vcmpunord_spd  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(2296, [$C5,$C9,$C2,$D4,$14                               ] , 'vcmpneq_uspd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2297, [$C5,$C9,$C2,$39,$14                               ] , 'vcmpneq_uspd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2298, [$C5,$C9,$C2,$39,$14                               ] , 'vcmpneq_uspd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2299, [$C5,$C9,$C2,$D4,$15                               ] , 'vcmpnlt_uqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2300, [$C5,$C9,$C2,$39,$15                               ] , 'vcmpnlt_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2301, [$C5,$C9,$C2,$39,$15                               ] , 'vcmpnlt_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2302, [$C5,$C9,$C2,$D4,$16                               ] , 'vcmpnle_uqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2303, [$C5,$C9,$C2,$39,$16                               ] , 'vcmpnle_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2304, [$C5,$C9,$C2,$39,$16                               ] , 'vcmpnle_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2305, [$C5,$C9,$C2,$D4,$17                               ] , 'vcmpord_spd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2306, [$C5,$C9,$C2,$39,$17                               ] , 'vcmpord_spd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2307, [$C5,$C9,$C2,$39,$17                               ] , 'vcmpord_spd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2308, [$C5,$C9,$C2,$D4,$18                               ] , 'vcmpeq_uspd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2309, [$C5,$C9,$C2,$39,$18                               ] , 'vcmpeq_uspd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2310, [$C5,$C9,$C2,$39,$18                               ] , 'vcmpeq_uspd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2311, [$C5,$C9,$C2,$D4,$19                               ] , 'vcmpnge_uqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2312, [$C5,$C9,$C2,$39,$19                               ] , 'vcmpnge_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2313, [$C5,$C9,$C2,$39,$19                               ] , 'vcmpnge_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2314, [$C5,$C9,$C2,$D4,$1A                               ] , 'vcmpngt_uqpd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2315, [$C5,$C9,$C2,$39,$1A                               ] , 'vcmpngt_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2316, [$C5,$C9,$C2,$39,$1A                               ] , 'vcmpngt_uqpd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2317, [$C5,$C9,$C2,$D4,$1B                               ] , 'vcmpfalse_ospd  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(2318, [$C5,$C9,$C2,$39,$1B                               ] , 'vcmpfalse_ospd  xmm7,xmm6,oword [ecx]'            );
  TestCase.testcase(2319, [$C5,$C9,$C2,$39,$1B                               ] , 'vcmpfalse_ospd  xmm7,xmm6,oword [ecx]'            );
  TestCase.testcase(2320, [$C5,$C9,$C2,$D4,$1C                               ] , 'vcmpneq_ospd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2321, [$C5,$C9,$C2,$39,$1C                               ] , 'vcmpneq_ospd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2322, [$C5,$C9,$C2,$39,$1C                               ] , 'vcmpneq_ospd  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2323, [$C5,$C9,$C2,$D4,$1D                               ] , 'vcmpge_oqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2324, [$C5,$C9,$C2,$39,$1D                               ] , 'vcmpge_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2325, [$C5,$C9,$C2,$39,$1D                               ] , 'vcmpge_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2326, [$C5,$C9,$C2,$D4,$1E                               ] , 'vcmpgt_oqpd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2327, [$C5,$C9,$C2,$39,$1E                               ] , 'vcmpgt_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2328, [$C5,$C9,$C2,$39,$1E                               ] , 'vcmpgt_oqpd  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2329, [$C5,$C9,$C2,$D4,$1F                               ] , 'vcmue_uspd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2330, [$C5,$C9,$C2,$39,$1F                               ] , 'vcmue_uspd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2331, [$C5,$C9,$C2,$39,$1F                               ] , 'vcmue_uspd  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2332, [$C5,$C8,$C2,$D4,$00                               ] , 'vcmpeqps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2333, [$C5,$C8,$C2,$39,$00                               ] , 'vcmpeqps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2334, [$C5,$C8,$C2,$39,$00                               ] , 'vcmpeqps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2335, [$C5,$C8,$C2,$D4,$01                               ] , 'vcmpltps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2336, [$C5,$C8,$C2,$39,$01                               ] , 'vcmpltps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2337, [$C5,$C8,$C2,$39,$01                               ] , 'vcmpltps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2338, [$C5,$C8,$C2,$D4,$02                               ] , 'vcmpleps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2339, [$C5,$C8,$C2,$39,$02                               ] , 'vcmpleps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2340, [$C5,$C8,$C2,$39,$02                               ] , 'vcmpleps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2341, [$C5,$C8,$C2,$D4,$03                               ] , 'vcmpunordps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2342, [$C5,$C8,$C2,$39,$03                               ] , 'vcmpunordps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2343, [$C5,$C8,$C2,$39,$03                               ] , 'vcmpunordps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2344, [$C5,$C8,$C2,$D4,$04                               ] , 'vcmpneqps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2345, [$C5,$C8,$C2,$39,$04                               ] , 'vcmpneqps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2346, [$C5,$C8,$C2,$39,$04                               ] , 'vcmpneqps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2347, [$C5,$C8,$C2,$D4,$05                               ] , 'vcmpnltps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2348, [$C5,$C8,$C2,$39,$05                               ] , 'vcmpnltps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2349, [$C5,$C8,$C2,$39,$05                               ] , 'vcmpnltps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2350, [$C5,$C8,$C2,$D4,$06                               ] , 'vcmpnleps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2351, [$C5,$C8,$C2,$39,$06                               ] , 'vcmpnleps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2352, [$C5,$C8,$C2,$39,$06                               ] , 'vcmpnleps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2353, [$C5,$C8,$C2,$D4,$07                               ] , 'vcmpordps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2354, [$C5,$C8,$C2,$39,$07                               ] , 'vcmpordps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2355, [$C5,$C8,$C2,$39,$07                               ] , 'vcmpordps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2356, [$C5,$C8,$C2,$D4,$08                               ] , 'vcmpeq_uqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2357, [$C5,$C8,$C2,$39,$08                               ] , 'vcmpeq_uqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2358, [$C5,$C8,$C2,$39,$08                               ] , 'vcmpeq_uqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2359, [$C5,$C8,$C2,$D4,$09                               ] , 'vcmpngeps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2360, [$C5,$C8,$C2,$39,$09                               ] , 'vcmpngeps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2361, [$C5,$C8,$C2,$39,$09                               ] , 'vcmpngeps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2362, [$C5,$C8,$C2,$D4,$0A                               ] , 'vcmpngtps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2363, [$C5,$C8,$C2,$39,$0A                               ] , 'vcmpngtps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2364, [$C5,$C8,$C2,$39,$0A                               ] , 'vcmpngtps  xmm7,xmm6,oword [ecx]'                 );
  TestCase.testcase(2365, [$C5,$C8,$C2,$D4,$0B                               ] , 'vcmpfalseps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2366, [$C5,$C8,$C2,$39,$0B                               ] , 'vcmpfalseps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2367, [$C5,$C8,$C2,$39,$0B                               ] , 'vcmpfalseps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2368, [$C5,$C8,$C2,$D4,$0C                               ] , 'vcmpneq_oqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2369, [$C5,$C8,$C2,$39,$0C                               ] , 'vcmpneq_oqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2370, [$C5,$C8,$C2,$39,$0C                               ] , 'vcmpneq_oqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2371, [$C5,$C8,$C2,$D4,$0D                               ] , 'vcmpgeps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2372, [$C5,$C8,$C2,$39,$0D                               ] , 'vcmpgeps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2373, [$C5,$C8,$C2,$39,$0D                               ] , 'vcmpgeps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2374, [$C5,$C8,$C2,$D4,$0E                               ] , 'vcmpgtps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2375, [$C5,$C8,$C2,$39,$0E                               ] , 'vcmpgtps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2376, [$C5,$C8,$C2,$39,$0E                               ] , 'vcmpgtps  xmm7,xmm6,oword [ecx]'                  );
  TestCase.testcase(2377, [$C5,$C8,$C2,$D4,$0F                               ] , 'vcmueps  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2378, [$C5,$C8,$C2,$39,$0F                               ] , 'vcmueps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2379, [$C5,$C8,$C2,$39,$0F                               ] , 'vcmueps  xmm7,xmm6,oword [ecx]'                   );
  TestCase.testcase(2380, [$C5,$C8,$C2,$D4,$10                               ] , 'vcmpeq_osps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2381, [$C5,$C8,$C2,$39,$10                               ] , 'vcmpeq_osps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2382, [$C5,$C8,$C2,$39,$10                               ] , 'vcmpeq_osps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2383, [$C5,$C8,$C2,$D4,$11                               ] , 'vcmplt_oqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2384, [$C5,$C8,$C2,$39,$11                               ] , 'vcmplt_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2385, [$C5,$C8,$C2,$39,$11                               ] , 'vcmplt_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2386, [$C5,$C8,$C2,$D4,$12                               ] , 'vcmple_oqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2387, [$C5,$C8,$C2,$39,$12                               ] , 'vcmple_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2388, [$C5,$C8,$C2,$39,$12                               ] , 'vcmple_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2389, [$C5,$C8,$C2,$D4,$13                               ] , 'vcmpunord_sps  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(2390, [$C5,$C8,$C2,$39,$13                               ] , 'vcmpunord_sps  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(2391, [$C5,$C8,$C2,$39,$13                               ] , 'vcmpunord_sps  xmm7,xmm6,oword [ecx]'             );
  TestCase.testcase(2392, [$C5,$C8,$C2,$D4,$14                               ] , 'vcmpneq_usps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2393, [$C5,$C8,$C2,$39,$14                               ] , 'vcmpneq_usps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2394, [$C5,$C8,$C2,$39,$14                               ] , 'vcmpneq_usps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2395, [$C5,$C8,$C2,$D4,$15                               ] , 'vcmpnlt_uqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2396, [$C5,$C8,$C2,$39,$15                               ] , 'vcmpnlt_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2397, [$C5,$C8,$C2,$39,$15                               ] , 'vcmpnlt_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2398, [$C5,$C8,$C2,$D4,$16                               ] , 'vcmpnle_uqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2399, [$C5,$C8,$C2,$39,$16                               ] , 'vcmpnle_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2400, [$C5,$C8,$C2,$39,$16                               ] , 'vcmpnle_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2401, [$C5,$C8,$C2,$D4,$17                               ] , 'vcmpord_sps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2402, [$C5,$C8,$C2,$39,$17                               ] , 'vcmpord_sps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2403, [$C5,$C8,$C2,$39,$17                               ] , 'vcmpord_sps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2404, [$C5,$C8,$C2,$D4,$18                               ] , 'vcmpeq_usps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2405, [$C5,$C8,$C2,$39,$18                               ] , 'vcmpeq_usps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2406, [$C5,$C8,$C2,$39,$18                               ] , 'vcmpeq_usps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2407, [$C5,$C8,$C2,$D4,$19                               ] , 'vcmpnge_uqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2408, [$C5,$C8,$C2,$39,$19                               ] , 'vcmpnge_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2409, [$C5,$C8,$C2,$39,$19                               ] , 'vcmpnge_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2410, [$C5,$C8,$C2,$D4,$1A                               ] , 'vcmpngt_uqps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2411, [$C5,$C8,$C2,$39,$1A                               ] , 'vcmpngt_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2412, [$C5,$C8,$C2,$39,$1A                               ] , 'vcmpngt_uqps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2413, [$C5,$C8,$C2,$D4,$1B                               ] , 'vcmpfalse_osps  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(2414, [$C5,$C8,$C2,$39,$1B                               ] , 'vcmpfalse_osps  xmm7,xmm6,oword [ecx]'            );
  TestCase.testcase(2415, [$C5,$C8,$C2,$39,$1B                               ] , 'vcmpfalse_osps  xmm7,xmm6,oword [ecx]'            );
  TestCase.testcase(2416, [$C5,$C8,$C2,$D4,$1C                               ] , 'vcmpneq_osps  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2417, [$C5,$C8,$C2,$39,$1C                               ] , 'vcmpneq_osps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2418, [$C5,$C8,$C2,$39,$1C                               ] , 'vcmpneq_osps  xmm7,xmm6,oword [ecx]'              );
  TestCase.testcase(2419, [$C5,$C8,$C2,$D4,$1D                               ] , 'vcmpge_oqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2420, [$C5,$C8,$C2,$39,$1D                               ] , 'vcmpge_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2421, [$C5,$C8,$C2,$39,$1D                               ] , 'vcmpge_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2422, [$C5,$C8,$C2,$D4,$1E                               ] , 'vcmpgt_oqps  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2423, [$C5,$C8,$C2,$39,$1E                               ] , 'vcmpgt_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2424, [$C5,$C8,$C2,$39,$1E                               ] , 'vcmpgt_oqps  xmm7,xmm6,oword [ecx]'               );
  TestCase.testcase(2425, [$C5,$C8,$C2,$D4,$1F                               ] , 'vcmue_usps  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2426, [$C5,$C8,$C2,$39,$1F                               ] , 'vcmue_usps  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2427, [$C5,$C8,$C2,$39,$1F                               ] , 'vcmue_usps  xmm7,xmm6,oword [ecx]'                );
  TestCase.testcase(2428, [$C4,$E2,$59,$2C,$31                               ] , 'vmaskmovps  xmm6,xmm4,oword [ecx]'                );
  TestCase.testcase(2429, [$C4,$E2,$59,$2C,$31                               ] , 'vmaskmovps  xmm6,xmm4,oword [ecx]'                );
  TestCase.testcase(2430, [$C4,$E2,$59,$2D,$31                               ] , 'vmaskmovpd  xmm6,xmm4,oword [ecx]'                );
  TestCase.testcase(2431, [$C4,$E2,$59,$2D,$31                               ] , 'vmaskmovpd  xmm6,xmm4,oword [ecx]'                );
  TestCase.testcase(2432, [$C4,$E3,$79,$DF,$F4,$07                           ] , 'vaeskeygenassist  xmm6,xmm4,0x7'                  );
  TestCase.testcase(2433, [$C4,$E3,$79,$DF,$31,$07                           ] , 'vaeskeygenassist  xmm6,oword [ecx],0x7'           );
  TestCase.testcase(2434, [$C4,$E3,$79,$DF,$31,$07                           ] , 'vaeskeygenassist  xmm6,oword [ecx],0x7'           );
  TestCase.testcase(2435, [$C4,$E3,$79,$61,$F4,$07                           ] , 'vpcmpestri  xmm6,xmm4,0x7'                        );
  TestCase.testcase(2436, [$C4,$E3,$79,$61,$31,$07                           ] , 'vpcmpestri  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2437, [$C4,$E3,$79,$61,$31,$07                           ] , 'vpcmpestri  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2438, [$C4,$E3,$79,$60,$F4,$07                           ] , 'vpcmpestrm  xmm6,xmm4,0x7'                        );
  TestCase.testcase(2439, [$C4,$E3,$79,$60,$31,$07                           ] , 'vpcmpestrm  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2440, [$C4,$E3,$79,$60,$31,$07                           ] , 'vpcmpestrm  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2441, [$C4,$E3,$79,$63,$F4,$07                           ] , 'vpcmpistri  xmm6,xmm4,0x7'                        );
  TestCase.testcase(2442, [$C4,$E3,$79,$63,$31,$07                           ] , 'vpcmpistri  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2443, [$C4,$E3,$79,$63,$31,$07                           ] , 'vpcmpistri  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2444, [$C4,$E3,$79,$62,$F4,$07                           ] , 'vpcmpistrm  xmm6,xmm4,0x7'                        );
  TestCase.testcase(2445, [$C4,$E3,$79,$62,$31,$07                           ] , 'vpcmpistrm  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2446, [$C4,$E3,$79,$62,$31,$07                           ] , 'vpcmpistrm  xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2447, [$C4,$E3,$79,$05,$F4,$07                           ] , 'vpermilpd  xmm6,xmm4,0x7'                         );
  TestCase.testcase(2448, [$C4,$E3,$79,$05,$31,$07                           ] , 'vpermilpd  xmm6,oword [ecx],0x7'                  );
  TestCase.testcase(2449, [$C4,$E3,$79,$05,$31,$07                           ] , 'vpermilpd  xmm6,oword [ecx],0x7'                  );
  TestCase.testcase(2450, [$C4,$E3,$79,$04,$F4,$07                           ] , 'vpermilps  xmm6,xmm4,0x7'                         );
  TestCase.testcase(2451, [$C4,$E3,$79,$04,$31,$07                           ] , 'vpermilps  xmm6,oword [ecx],0x7'                  );
  TestCase.testcase(2452, [$C4,$E3,$79,$04,$31,$07                           ] , 'vpermilps  xmm6,oword [ecx],0x7'                  );
  TestCase.testcase(2453, [$C5,$F9,$70,$F4,$07                               ] , 'vpshufd  xmm6,xmm4,0x7'                           );
  TestCase.testcase(2454, [$C5,$F9,$70,$31,$07                               ] , 'vpshufd  xmm6,oword [ecx],0x7'                    );
  TestCase.testcase(2455, [$C5,$F9,$70,$31,$07                               ] , 'vpshufd  xmm6,oword [ecx],0x7'                    );
  TestCase.testcase(2456, [$C5,$FA,$70,$F4,$07                               ] , 'vpshufhw  xmm6,xmm4,0x7'                          );
  TestCase.testcase(2457, [$C5,$FA,$70,$31,$07                               ] , 'vpshufhw  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(2458, [$C5,$FA,$70,$31,$07                               ] , 'vpshufhw  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(2459, [$C5,$FB,$70,$F4,$07                               ] , 'vpshuflw  xmm6,xmm4,0x7'                          );
  TestCase.testcase(2460, [$C5,$FB,$70,$31,$07                               ] , 'vpshuflw  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(2461, [$C5,$FB,$70,$31,$07                               ] , 'vpshuflw  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(2462, [$C4,$E3,$79,$09,$F4,$07                           ] , 'vroundpd  xmm6,xmm4,0x7'                          );
  TestCase.testcase(2463, [$C4,$E3,$79,$09,$31,$07                           ] , 'vroundpd  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(2464, [$C4,$E3,$79,$09,$31,$07                           ] , 'vroundpd  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(2465, [$C4,$E3,$79,$08,$F4,$07                           ] , 'vroundps  xmm6,xmm4,0x7'                          );
  TestCase.testcase(2466, [$C4,$E3,$79,$08,$31,$07                           ] , 'vroundps  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(2467, [$C4,$E3,$79,$08,$31,$07                           ] , 'vroundps  xmm6,oword [ecx],0x7'                   );
  TestCase.testcase(2468, [$C4,$E2,$49,$2E,$21                               ] , 'vmaskmovps  oword [ecx],xmm6,xmm4'                );
  TestCase.testcase(2469, [$C4,$E2,$49,$2E,$21                               ] , 'vmaskmovps  oword [ecx],xmm6,xmm4'                );
  TestCase.testcase(2470, [$C4,$E2,$49,$2F,$21                               ] , 'vmaskmovpd  oword [ecx],xmm6,xmm4'                );
  TestCase.testcase(2471, [$C4,$E2,$49,$2F,$21                               ] , 'vmaskmovpd  oword [ecx],xmm6,xmm4'                );
  TestCase.testcase(2472, [$C4,$E3,$49,$0D,$D4,$07                           ] , 'vblendpd  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(2473, [$C4,$E3,$49,$0D,$11,$07                           ] , 'vblendpd  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2474, [$C4,$E3,$49,$0D,$11,$07                           ] , 'vblendpd  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2475, [$C4,$E3,$49,$0C,$D4,$07                           ] , 'vblendps  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(2476, [$C4,$E3,$49,$0C,$11,$07                           ] , 'vblendps  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2477, [$C4,$E3,$49,$0C,$11,$07                           ] , 'vblendps  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2478, [$C5,$C9,$C2,$D4,$07                               ] , 'vcmpordpd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2479, [$C5,$C9,$C2,$11,$07                               ] , 'vcmpordpd  xmm2,xmm6,oword [ecx]'                 );
  TestCase.testcase(2480, [$C5,$C9,$C2,$11,$07                               ] , 'vcmpordpd  xmm2,xmm6,oword [ecx]'                 );
  TestCase.testcase(2481, [$C5,$C8,$C2,$D4,$07                               ] , 'vcmpordps  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2482, [$C5,$C8,$C2,$11,$07                               ] , 'vcmpordps  xmm2,xmm6,oword [ecx]'                 );
  TestCase.testcase(2483, [$C5,$C8,$C2,$11,$07                               ] , 'vcmpordps  xmm2,xmm6,oword [ecx]'                 );
  TestCase.testcase(2484, [$C4,$E3,$49,$41,$D4,$07                           ] , 'vdppd  xmm2,xmm6,xmm4,0x7'                        );
  TestCase.testcase(2485, [$C4,$E3,$49,$41,$11,$07                           ] , 'vdppd  xmm2,xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2486, [$C4,$E3,$49,$41,$11,$07                           ] , 'vdppd  xmm2,xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2487, [$C4,$E3,$49,$40,$D4,$07                           ] , 'vdpps  xmm2,xmm6,xmm4,0x7'                        );
  TestCase.testcase(2488, [$C4,$E3,$49,$40,$11,$07                           ] , 'vdpps  xmm2,xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2489, [$C4,$E3,$49,$40,$11,$07                           ] , 'vdpps  xmm2,xmm6,oword [ecx],0x7'                 );
  TestCase.testcase(2490, [$C4,$E3,$49,$42,$D4,$07                           ] , 'vmpsadbw  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(2491, [$C4,$E3,$49,$42,$11,$07                           ] , 'vmpsadbw  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2492, [$C4,$E3,$49,$42,$11,$07                           ] , 'vmpsadbw  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2493, [$C4,$E3,$49,$0F,$D4,$07                           ] , 'vpalignr  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(2494, [$C4,$E3,$49,$0F,$11,$07                           ] , 'vpalignr  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2495, [$C4,$E3,$49,$0F,$11,$07                           ] , 'vpalignr  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2496, [$C4,$E3,$49,$0E,$D4,$07                           ] , 'vpblendw  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(2497, [$C4,$E3,$49,$0E,$11,$07                           ] , 'vpblendw  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2498, [$C4,$E3,$49,$0E,$11,$07                           ] , 'vpblendw  xmm2,xmm6,oword [ecx],0x7'              );
  TestCase.testcase(2499, [$C4,$E3,$49,$44,$D4,$07                           ] , 'vpclmulqdq  xmm2,xmm6,xmm4,0x7'                   );
  TestCase.testcase(2500, [$C4,$E3,$49,$44,$11,$07                           ] , 'vpclmulqdq  xmm2,xmm6,oword [ecx],0x7'            );
  TestCase.testcase(2501, [$C4,$E3,$49,$44,$11,$07                           ] , 'vpclmulqdq  xmm2,xmm6,oword [ecx],0x7'            );
  TestCase.testcase(2502, [$C5,$C9,$C6,$D4,$07                               ] , 'vshufpd  xmm2,xmm6,xmm4,0x7'                      );
  TestCase.testcase(2503, [$C5,$C9,$C6,$11,$07                               ] , 'vshufpd  xmm2,xmm6,oword [ecx],0x7'               );
  TestCase.testcase(2504, [$C5,$C9,$C6,$11,$07                               ] , 'vshufpd  xmm2,xmm6,oword [ecx],0x7'               );
  TestCase.testcase(2505, [$C5,$C8,$C6,$D4,$07                               ] , 'vshufps  xmm2,xmm6,xmm4,0x7'                      );
  TestCase.testcase(2506, [$C5,$C8,$C6,$11,$07                               ] , 'vshufps  xmm2,xmm6,oword [ecx],0x7'               );
  TestCase.testcase(2507, [$C5,$C8,$C6,$11,$07                               ] , 'vshufps  xmm2,xmm6,oword [ecx],0x7'               );
  TestCase.testcase(2508, [$C4,$E3,$69,$4B,$FE,$40                           ] , 'vblendvpd  xmm7,xmm2,xmm6,xmm4'                   );
  TestCase.testcase(2509, [$C4,$E3,$69,$4B,$39,$40                           ] , 'vblendvpd  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(2510, [$C4,$E3,$69,$4B,$39,$40                           ] , 'vblendvpd  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(2511, [$C4,$E3,$69,$4A,$FE,$40                           ] , 'vblendvps  xmm7,xmm2,xmm6,xmm4'                   );
  TestCase.testcase(2512, [$C4,$E3,$69,$4A,$39,$40                           ] , 'vblendvps  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(2513, [$C4,$E3,$69,$4A,$39,$40                           ] , 'vblendvps  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(2514, [$C4,$E3,$69,$4C,$FE,$40                           ] , 'vpblendvb  xmm7,xmm2,xmm6,xmm4'                   );
  TestCase.testcase(2515, [$C4,$E3,$69,$4C,$39,$40                           ] , 'vpblendvb  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(2516, [$C4,$E3,$69,$4C,$39,$40                           ] , 'vpblendvb  xmm7,xmm2,oword [ecx],xmm4'            );
  TestCase.testcase(2517, [$C4,$E2,$7D,$19,$21                               ] , 'vbroadcastsd  ymm4,qword [ecx]'                   );
  TestCase.testcase(2518, [$C4,$E2,$7D,$19,$21                               ] , 'vbroadcastsd  ymm4,qword [ecx]'                   );
  TestCase.testcase(2519, [$C5,$F9,$2F,$F4                                   ] , 'vcomisd  xmm6,xmm4'                               );
  TestCase.testcase(2520, [$C5,$F9,$2F,$21                                   ] , 'vcomisd  xmm4,qword [ecx]'                        );
  TestCase.testcase(2521, [$C5,$F9,$2F,$21                                   ] , 'vcomisd  xmm4,qword [ecx]'                        );
  TestCase.testcase(2522, [$C5,$FA,$E6,$F4                                   ] , 'vcvtdq2pd  xmm6,xmm4'                             );
  TestCase.testcase(2523, [$C5,$FA,$E6,$21                                   ] , 'vcvtdq2pd  xmm4,qword [ecx]'                      );
  TestCase.testcase(2524, [$C5,$FA,$E6,$21                                   ] , 'vcvtdq2pd  xmm4,qword [ecx]'                      );
  TestCase.testcase(2525, [$C5,$F8,$5A,$F4                                   ] , 'vcvtps2pd  xmm6,xmm4'                             );
  TestCase.testcase(2526, [$C5,$F8,$5A,$21                                   ] , 'vcvtps2pd  xmm4,qword [ecx]'                      );
  TestCase.testcase(2527, [$C5,$F8,$5A,$21                                   ] , 'vcvtps2pd  xmm4,qword [ecx]'                      );
  TestCase.testcase(2528, [$C5,$FB,$12,$F4                                   ] , 'vmovddup  xmm6,xmm4'                              );
  TestCase.testcase(2529, [$C5,$FB,$12,$21                                   ] , 'vmovddup  xmm4,qword [ecx]'                       );
  TestCase.testcase(2530, [$C5,$FB,$12,$21                                   ] , 'vmovddup  xmm4,qword [ecx]'                       );
  TestCase.testcase(2531, [$C4,$E2,$79,$20,$F4                               ] , 'vpmovsxbw  xmm6,xmm4'                             );
  TestCase.testcase(2532, [$C4,$E2,$79,$20,$21                               ] , 'vpmovsxbw  xmm4,qword [ecx]'                      );
  TestCase.testcase(2533, [$C4,$E2,$79,$20,$21                               ] , 'vpmovsxbw  xmm4,qword [ecx]'                      );
  TestCase.testcase(2534, [$C4,$E2,$79,$23,$F4                               ] , 'vpmovsxwd  xmm6,xmm4'                             );
  TestCase.testcase(2535, [$C4,$E2,$79,$23,$21                               ] , 'vpmovsxwd  xmm4,qword [ecx]'                      );
  TestCase.testcase(2536, [$C4,$E2,$79,$23,$21                               ] , 'vpmovsxwd  xmm4,qword [ecx]'                      );
  TestCase.testcase(2537, [$C4,$E2,$79,$25,$F4                               ] , 'vpmovsxdq  xmm6,xmm4'                             );
  TestCase.testcase(2538, [$C4,$E2,$79,$25,$21                               ] , 'vpmovsxdq  xmm4,qword [ecx]'                      );
  TestCase.testcase(2539, [$C4,$E2,$79,$25,$21                               ] , 'vpmovsxdq  xmm4,qword [ecx]'                      );
  TestCase.testcase(2540, [$C4,$E2,$79,$30,$F4                               ] , 'vpmovzxbw  xmm6,xmm4'                             );
  TestCase.testcase(2541, [$C4,$E2,$79,$30,$21                               ] , 'vpmovzxbw  xmm4,qword [ecx]'                      );
  TestCase.testcase(2542, [$C4,$E2,$79,$30,$21                               ] , 'vpmovzxbw  xmm4,qword [ecx]'                      );
  TestCase.testcase(2543, [$C4,$E2,$79,$33,$F4                               ] , 'vpmovzxwd  xmm6,xmm4'                             );
  TestCase.testcase(2544, [$C4,$E2,$79,$33,$21                               ] , 'vpmovzxwd  xmm4,qword [ecx]'                      );
  TestCase.testcase(2545, [$C4,$E2,$79,$33,$21                               ] , 'vpmovzxwd  xmm4,qword [ecx]'                      );
  TestCase.testcase(2546, [$C4,$E2,$79,$35,$F4                               ] , 'vpmovzxdq  xmm6,xmm4'                             );
  TestCase.testcase(2547, [$C4,$E2,$79,$35,$21                               ] , 'vpmovzxdq  xmm4,qword [ecx]'                      );
  TestCase.testcase(2548, [$C4,$E2,$79,$35,$21                               ] , 'vpmovzxdq  xmm4,qword [ecx]'                      );
  TestCase.testcase(2549, [$C5,$F9,$2E,$F4                                   ] , 'vucomisd  xmm6,xmm4'                              );
  TestCase.testcase(2550, [$C5,$F9,$2E,$21                                   ] , 'vucomisd  xmm4,qword [ecx]'                       );
  TestCase.testcase(2551, [$C5,$F9,$2E,$21                                   ] , 'vucomisd  xmm4,qword [ecx]'                       );
  TestCase.testcase(2552, [$C5,$FB,$10,$21                                   ] , 'vmovsd  xmm4,qword [ecx]'                         );
  TestCase.testcase(2553, [$C5,$FB,$10,$21                                   ] , 'vmovsd  xmm4,qword [ecx]'                         );
  TestCase.testcase(2554, [$C5,$F9,$13,$21                                   ] , 'vmovlpd  qword [ecx],xmm4'                        );
  TestCase.testcase(2555, [$C5,$F9,$13,$21                                   ] , 'vmovlpd  qword [ecx],xmm4'                        );
  TestCase.testcase(2556, [$C5,$F8,$13,$21                                   ] , 'vmovlps  qword [ecx],xmm4'                        );
  TestCase.testcase(2557, [$C5,$F8,$13,$21                                   ] , 'vmovlps  qword [ecx],xmm4'                        );
  TestCase.testcase(2558, [$C5,$F9,$17,$21                                   ] , 'vmovhpd  qword [ecx],xmm4'                        );
  TestCase.testcase(2559, [$C5,$F9,$17,$21                                   ] , 'vmovhpd  qword [ecx],xmm4'                        );
  TestCase.testcase(2560, [$C5,$F8,$17,$21                                   ] , 'vmovhps  qword [ecx],xmm4'                        );
  TestCase.testcase(2561, [$C5,$F8,$17,$21                                   ] , 'vmovhps  qword [ecx],xmm4'                        );
  TestCase.testcase(2562, [$C5,$FB,$11,$21                                   ] , 'vmovsd  qword [ecx],xmm4'                         );
  TestCase.testcase(2563, [$C5,$FB,$11,$21                                   ] , 'vmovsd  qword [ecx],xmm4'                         );
  TestCase.testcase(2564, [$C5,$F9,$D6,$21                                   ] , 'vmovq  qword [ecx],xmm4'                          );
  TestCase.testcase(2565, [$C5,$FA,$7E,$21                                   ] , 'vmovq  xmm4,qword [ecx]'                          );
  TestCase.testcase(2566, [$C5,$F9,$D6,$21                                   ] , 'vmovq  qword [ecx],xmm4'                          );
  TestCase.testcase(2567, [$C5,$FA,$7E,$21                                   ] , 'vmovq  xmm4,qword [ecx]'                          );
  TestCase.testcase(2568, [$C5,$FB,$2D,$CC                                   ] , 'vcvtsd2si  ecx,xmm4'                              );
  TestCase.testcase(2569, [$C5,$FB,$2D,$09                                   ] , 'vcvtsd2si  ecx,qword [ecx]'                       );
  TestCase.testcase(2570, [$C5,$FB,$2D,$09                                   ] , 'vcvtsd2si  ecx,qword [ecx]'                       );
  TestCase.testcase(2571, [$C5,$FB,$2C,$CC                                   ] , 'vcvttsd2si  ecx,xmm4'                             );
  TestCase.testcase(2572, [$C5,$FB,$2C,$09                                   ] , 'vcvttsd2si  ecx,qword [ecx]'                      );
  TestCase.testcase(2573, [$C5,$FB,$2C,$09                                   ] , 'vcvttsd2si  ecx,qword [ecx]'                      );
  TestCase.testcase(2574, [$C5,$D9,$12,$31                                   ] , 'vmovlpd  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(2575, [$C5,$D9,$12,$31                                   ] , 'vmovlpd  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(2576, [$C5,$D8,$12,$31                                   ] , 'vmovlps  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(2577, [$C5,$D8,$12,$31                                   ] , 'vmovlps  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(2578, [$C5,$D9,$16,$31                                   ] , 'vmovhpd  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(2579, [$C5,$D9,$16,$31                                   ] , 'vmovhpd  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(2580, [$C5,$D8,$16,$31                                   ] , 'vmovhps  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(2581, [$C5,$D8,$16,$31                                   ] , 'vmovhps  xmm6,xmm4,qword [ecx]'                   );
  TestCase.testcase(2582, [$C5,$CB,$C2,$D4,$07                               ] , 'vcmpordsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2583, [$C5,$CB,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2584, [$C5,$CB,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2585, [$C4,$E3,$49,$0B,$D4,$07                           ] , 'vroundsd  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(2586, [$C4,$E3,$49,$0B,$11,$07                           ] , 'vroundsd  xmm2,xmm6,qword [ecx],0x7'              );
  TestCase.testcase(2587, [$C4,$E3,$49,$0B,$11,$07                           ] , 'vroundsd  xmm2,xmm6,qword [ecx],0x7'              );
  TestCase.testcase(2588, [$C5,$CB,$58,$D4                                   ] , 'vaddsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2589, [$C5,$CB,$58,$11                                   ] , 'vaddsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2590, [$C5,$CB,$58,$11                                   ] , 'vaddsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2591, [$C5,$CB,$5A,$D4                                   ] , 'vcvtsd2ss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2592, [$C5,$CB,$5A,$11                                   ] , 'vcvtsd2ss  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2593, [$C5,$CB,$5A,$11                                   ] , 'vcvtsd2ss  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2594, [$C5,$CB,$5E,$D4                                   ] , 'vdivsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2595, [$C5,$CB,$5E,$11                                   ] , 'vdivsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2596, [$C5,$CB,$5E,$11                                   ] , 'vdivsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2597, [$C5,$CB,$5F,$D4                                   ] , 'vmaxsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2598, [$C5,$CB,$5F,$11                                   ] , 'vmaxsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2599, [$C5,$CB,$5F,$11                                   ] , 'vmaxsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2600, [$C5,$CB,$5D,$D4                                   ] , 'vminsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2601, [$C5,$CB,$5D,$11                                   ] , 'vminsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2602, [$C5,$CB,$5D,$11                                   ] , 'vminsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2603, [$C5,$CB,$59,$D4                                   ] , 'vmulsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2604, [$C5,$CB,$59,$11                                   ] , 'vmulsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2605, [$C5,$CB,$59,$11                                   ] , 'vmulsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2606, [$C5,$CB,$51,$D4                                   ] , 'vsqrtsd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2607, [$C5,$CB,$51,$11                                   ] , 'vsqrtsd  xmm2,xmm6,qword [ecx]'                   );
  TestCase.testcase(2608, [$C5,$CB,$51,$11                                   ] , 'vsqrtsd  xmm2,xmm6,qword [ecx]'                   );
  TestCase.testcase(2609, [$C5,$CB,$5C,$D4                                   ] , 'vsubsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2610, [$C5,$CB,$5C,$11                                   ] , 'vsubsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2611, [$C5,$CB,$5C,$11                                   ] , 'vsubsd  xmm2,xmm6,qword [ecx]'                    );
  TestCase.testcase(2612, [$C5,$CB,$C2,$D4,$00                               ] , 'vcmpeqsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2613, [$C5,$CB,$C2,$11,$00                               ] , 'vcmpeqsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2614, [$C5,$CB,$C2,$11,$00                               ] , 'vcmpeqsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2615, [$C5,$CB,$C2,$D4,$01                               ] , 'vcmpltsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2616, [$C5,$CB,$C2,$11,$01                               ] , 'vcmpltsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2617, [$C5,$CB,$C2,$11,$01                               ] , 'vcmpltsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2618, [$C5,$CB,$C2,$D4,$02                               ] , 'vcmplesd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2619, [$C5,$CB,$C2,$11,$02                               ] , 'vcmplesd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2620, [$C5,$CB,$C2,$11,$02                               ] , 'vcmplesd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2621, [$C5,$CB,$C2,$D4,$03                               ] , 'vcmpunordsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2622, [$C5,$CB,$C2,$11,$03                               ] , 'vcmpunordsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2623, [$C5,$CB,$C2,$11,$03                               ] , 'vcmpunordsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2624, [$C5,$CB,$C2,$D4,$04                               ] , 'vcmpneqsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2625, [$C5,$CB,$C2,$11,$04                               ] , 'vcmpneqsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2626, [$C5,$CB,$C2,$11,$04                               ] , 'vcmpneqsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2627, [$C5,$CB,$C2,$D4,$05                               ] , 'vcmpnltsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2628, [$C5,$CB,$C2,$11,$05                               ] , 'vcmpnltsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2629, [$C5,$CB,$C2,$11,$05                               ] , 'vcmpnltsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2630, [$C5,$CB,$C2,$D4,$06                               ] , 'vcmpnlesd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2631, [$C5,$CB,$C2,$11,$06                               ] , 'vcmpnlesd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2632, [$C5,$CB,$C2,$11,$06                               ] , 'vcmpnlesd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2633, [$C5,$CB,$C2,$D4,$07                               ] , 'vcmpordsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2634, [$C5,$CB,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2635, [$C5,$CB,$C2,$11,$07                               ] , 'vcmpordsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2636, [$C5,$CB,$C2,$D4,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2637, [$C5,$CB,$C2,$11,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2638, [$C5,$CB,$C2,$11,$08                               ] , 'vcmpeq_uqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2639, [$C5,$CB,$C2,$D4,$09                               ] , 'vcmpngesd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2640, [$C5,$CB,$C2,$11,$09                               ] , 'vcmpngesd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2641, [$C5,$CB,$C2,$11,$09                               ] , 'vcmpngesd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2642, [$C5,$CB,$C2,$D4,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2643, [$C5,$CB,$C2,$11,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2644, [$C5,$CB,$C2,$11,$0A                               ] , 'vcmpngtsd  xmm2,xmm6,qword [ecx]'                 );
  TestCase.testcase(2645, [$C5,$CB,$C2,$D4,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2646, [$C5,$CB,$C2,$11,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2647, [$C5,$CB,$C2,$11,$0B                               ] , 'vcmpfalsesd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2648, [$C5,$CB,$C2,$D4,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2649, [$C5,$CB,$C2,$11,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2650, [$C5,$CB,$C2,$11,$0C                               ] , 'vcmpneq_oqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2651, [$C5,$CB,$C2,$D4,$0D                               ] , 'vcmpgesd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2652, [$C5,$CB,$C2,$11,$0D                               ] , 'vcmpgesd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2653, [$C5,$CB,$C2,$11,$0D                               ] , 'vcmpgesd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2654, [$C5,$CB,$C2,$D4,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2655, [$C5,$CB,$C2,$11,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2656, [$C5,$CB,$C2,$11,$0E                               ] , 'vcmpgtsd  xmm2,xmm6,qword [ecx]'                  );
  TestCase.testcase(2657, [$C5,$CB,$C2,$D4,$0F                               ] , 'vcmuesd  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2658, [$C5,$CB,$C2,$11,$0F                               ] , 'vcmuesd  xmm2,xmm6,qword [ecx]'                   );
  TestCase.testcase(2659, [$C5,$CB,$C2,$11,$0F                               ] , 'vcmuesd  xmm2,xmm6,qword [ecx]'                   );
  TestCase.testcase(2660, [$C5,$CB,$C2,$D4,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2661, [$C5,$CB,$C2,$11,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2662, [$C5,$CB,$C2,$11,$10                               ] , 'vcmpeq_ossd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2663, [$C5,$CB,$C2,$D4,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2664, [$C5,$CB,$C2,$11,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2665, [$C5,$CB,$C2,$11,$11                               ] , 'vcmplt_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2666, [$C5,$CB,$C2,$D4,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2667, [$C5,$CB,$C2,$11,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2668, [$C5,$CB,$C2,$11,$12                               ] , 'vcmple_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2669, [$C5,$CB,$C2,$D4,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(2670, [$C5,$CB,$C2,$11,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,qword [ecx]'             );
  TestCase.testcase(2671, [$C5,$CB,$C2,$11,$13                               ] , 'vcmpunord_ssd  xmm2,xmm6,qword [ecx]'             );
  TestCase.testcase(2672, [$C5,$CB,$C2,$D4,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2673, [$C5,$CB,$C2,$11,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2674, [$C5,$CB,$C2,$11,$14                               ] , 'vcmpneq_ussd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2675, [$C5,$CB,$C2,$D4,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2676, [$C5,$CB,$C2,$11,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2677, [$C5,$CB,$C2,$11,$15                               ] , 'vcmpnlt_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2678, [$C5,$CB,$C2,$D4,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2679, [$C5,$CB,$C2,$11,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2680, [$C5,$CB,$C2,$11,$16                               ] , 'vcmpnle_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2681, [$C5,$CB,$C2,$D4,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2682, [$C5,$CB,$C2,$11,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2683, [$C5,$CB,$C2,$11,$17                               ] , 'vcmpord_ssd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2684, [$C5,$CB,$C2,$D4,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2685, [$C5,$CB,$C2,$11,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2686, [$C5,$CB,$C2,$11,$18                               ] , 'vcmpeq_ussd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2687, [$C5,$CB,$C2,$D4,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2688, [$C5,$CB,$C2,$11,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2689, [$C5,$CB,$C2,$11,$19                               ] , 'vcmpnge_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2690, [$C5,$CB,$C2,$D4,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2691, [$C5,$CB,$C2,$11,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2692, [$C5,$CB,$C2,$11,$1A                               ] , 'vcmpngt_uqsd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2693, [$C5,$CB,$C2,$D4,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(2694, [$C5,$CB,$C2,$11,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,qword [ecx]'            );
  TestCase.testcase(2695, [$C5,$CB,$C2,$11,$1B                               ] , 'vcmpfalse_ossd  xmm2,xmm6,qword [ecx]'            );
  TestCase.testcase(2696, [$C5,$CB,$C2,$D4,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2697, [$C5,$CB,$C2,$11,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2698, [$C5,$CB,$C2,$11,$1C                               ] , 'vcmpneq_ossd  xmm2,xmm6,qword [ecx]'              );
  TestCase.testcase(2699, [$C5,$CB,$C2,$D4,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2700, [$C5,$CB,$C2,$11,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2701, [$C5,$CB,$C2,$11,$1D                               ] , 'vcmpge_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2702, [$C5,$CB,$C2,$D4,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2703, [$C5,$CB,$C2,$11,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2704, [$C5,$CB,$C2,$11,$1E                               ] , 'vcmpgt_oqsd  xmm2,xmm6,qword [ecx]'               );
  TestCase.testcase(2705, [$C5,$CB,$C2,$D4,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2706, [$C5,$CB,$C2,$11,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,qword [ecx]'                );
  TestCase.testcase(2707, [$C5,$CB,$C2,$11,$1F                               ] , 'vcmue_ussd  xmm2,xmm6,qword [ecx]'                );
  TestCase.testcase(2708, [$C5,$F8,$AE,$11                                   ] , 'vldmxcsr  dword [ecx]'                            );
  TestCase.testcase(2709, [$C5,$F8,$AE,$11                                   ] , 'vldmxcsr  dword [ecx]'                            );
  TestCase.testcase(2710, [$C5,$F8,$AE,$19                                   ] , 'vstmxcsr  dword [ecx]'                            );
  TestCase.testcase(2711, [$C5,$F8,$AE,$19                                   ] , 'vstmxcsr  dword [ecx]'                            );
  TestCase.testcase(2712, [$C5,$CA,$58,$D4                                   ] , 'vaddss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2713, [$C5,$CA,$58,$11                                   ] , 'vaddss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2714, [$C5,$CA,$58,$11                                   ] , 'vaddss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2715, [$C5,$CA,$5A,$D4                                   ] , 'vcvtss2sd  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2716, [$C5,$CA,$5A,$11                                   ] , 'vcvtss2sd  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2717, [$C5,$CA,$5A,$11                                   ] , 'vcvtss2sd  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2718, [$C5,$CA,$5E,$D4                                   ] , 'vdivss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2719, [$C5,$CA,$5E,$11                                   ] , 'vdivss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2720, [$C5,$CA,$5E,$11                                   ] , 'vdivss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2721, [$C5,$CA,$5F,$D4                                   ] , 'vmaxss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2722, [$C5,$CA,$5F,$11                                   ] , 'vmaxss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2723, [$C5,$CA,$5F,$11                                   ] , 'vmaxss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2724, [$C5,$CA,$5D,$D4                                   ] , 'vminss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2725, [$C5,$CA,$5D,$11                                   ] , 'vminss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2726, [$C5,$CA,$5D,$11                                   ] , 'vminss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2727, [$C5,$CA,$59,$D4                                   ] , 'vmulss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2728, [$C5,$CA,$59,$11                                   ] , 'vmulss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2729, [$C5,$CA,$59,$11                                   ] , 'vmulss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2730, [$C5,$CA,$53,$D4                                   ] , 'vrcpss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2731, [$C5,$CA,$53,$11                                   ] , 'vrcpss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2732, [$C5,$CA,$53,$11                                   ] , 'vrcpss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2733, [$C5,$CA,$52,$D4                                   ] , 'vrsqrtss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2734, [$C5,$CA,$52,$11                                   ] , 'vrsqrtss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2735, [$C5,$CA,$52,$11                                   ] , 'vrsqrtss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2736, [$C5,$CA,$51,$D4                                   ] , 'vsqrtss  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2737, [$C5,$CA,$51,$11                                   ] , 'vsqrtss  xmm2,xmm6,dword [ecx]'                   );
  TestCase.testcase(2738, [$C5,$CA,$51,$11                                   ] , 'vsqrtss  xmm2,xmm6,dword [ecx]'                   );
  TestCase.testcase(2739, [$C5,$CA,$5C,$D4                                   ] , 'vsubss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2740, [$C5,$CA,$5C,$11                                   ] , 'vsubss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2741, [$C5,$CA,$5C,$11                                   ] , 'vsubss  xmm2,xmm6,dword [ecx]'                    );
  TestCase.testcase(2742, [$C5,$CA,$C2,$D4,$00                               ] , 'vcmpeqss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2743, [$C5,$CA,$C2,$11,$00                               ] , 'vcmpeqss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2744, [$C5,$CA,$C2,$11,$00                               ] , 'vcmpeqss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2745, [$C5,$CA,$C2,$D4,$01                               ] , 'vcmpltss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2746, [$C5,$CA,$C2,$11,$01                               ] , 'vcmpltss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2747, [$C5,$CA,$C2,$11,$01                               ] , 'vcmpltss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2748, [$C5,$CA,$C2,$D4,$02                               ] , 'vcmpless  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2749, [$C5,$CA,$C2,$11,$02                               ] , 'vcmpless  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2750, [$C5,$CA,$C2,$11,$02                               ] , 'vcmpless  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2751, [$C5,$CA,$C2,$D4,$03                               ] , 'vcmpunordss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2752, [$C5,$CA,$C2,$11,$03                               ] , 'vcmpunordss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2753, [$C5,$CA,$C2,$11,$03                               ] , 'vcmpunordss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2754, [$C5,$CA,$C2,$D4,$04                               ] , 'vcmpneqss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2755, [$C5,$CA,$C2,$11,$04                               ] , 'vcmpneqss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2756, [$C5,$CA,$C2,$11,$04                               ] , 'vcmpneqss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2757, [$C5,$CA,$C2,$D4,$05                               ] , 'vcmpnltss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2758, [$C5,$CA,$C2,$11,$05                               ] , 'vcmpnltss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2759, [$C5,$CA,$C2,$11,$05                               ] , 'vcmpnltss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2760, [$C5,$CA,$C2,$D4,$06                               ] , 'vcmpnless  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2761, [$C5,$CA,$C2,$11,$06                               ] , 'vcmpnless  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2762, [$C5,$CA,$C2,$11,$06                               ] , 'vcmpnless  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2763, [$C5,$CA,$C2,$D4,$07                               ] , 'vcmpordss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2764, [$C5,$CA,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2765, [$C5,$CA,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2766, [$C5,$CA,$C2,$D4,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2767, [$C5,$CA,$C2,$11,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2768, [$C5,$CA,$C2,$11,$08                               ] , 'vcmpeq_uqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2769, [$C5,$CA,$C2,$D4,$09                               ] , 'vcmpngess  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2770, [$C5,$CA,$C2,$11,$09                               ] , 'vcmpngess  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2771, [$C5,$CA,$C2,$11,$09                               ] , 'vcmpngess  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2772, [$C5,$CA,$C2,$D4,$0A                               ] , 'vcmpngtss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2773, [$C5,$CA,$C2,$11,$0A                               ] , 'vcmpngtss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2774, [$C5,$CA,$C2,$11,$0A                               ] , 'vcmpngtss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2775, [$C5,$CA,$C2,$D4,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2776, [$C5,$CA,$C2,$11,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2777, [$C5,$CA,$C2,$11,$0B                               ] , 'vcmpfalsess  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2778, [$C5,$CA,$C2,$D4,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2779, [$C5,$CA,$C2,$11,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2780, [$C5,$CA,$C2,$11,$0C                               ] , 'vcmpneq_oqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2781, [$C5,$CA,$C2,$D4,$0D                               ] , 'vcmpgess  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2782, [$C5,$CA,$C2,$11,$0D                               ] , 'vcmpgess  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2783, [$C5,$CA,$C2,$11,$0D                               ] , 'vcmpgess  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2784, [$C5,$CA,$C2,$D4,$0E                               ] , 'vcmpgtss  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2785, [$C5,$CA,$C2,$11,$0E                               ] , 'vcmpgtss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2786, [$C5,$CA,$C2,$11,$0E                               ] , 'vcmpgtss  xmm2,xmm6,dword [ecx]'                  );
  TestCase.testcase(2787, [$C5,$CA,$C2,$D4,$0F                               ] , 'vcmuess  xmm2,xmm6,xmm4'                          );
  TestCase.testcase(2788, [$C5,$CA,$C2,$11,$0F                               ] , 'vcmuess  xmm2,xmm6,dword [ecx]'                   );
  TestCase.testcase(2789, [$C5,$CA,$C2,$11,$0F                               ] , 'vcmuess  xmm2,xmm6,dword [ecx]'                   );
  TestCase.testcase(2790, [$C5,$CA,$C2,$D4,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2791, [$C5,$CA,$C2,$11,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2792, [$C5,$CA,$C2,$11,$10                               ] , 'vcmpeq_osss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2793, [$C5,$CA,$C2,$D4,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2794, [$C5,$CA,$C2,$11,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2795, [$C5,$CA,$C2,$11,$11                               ] , 'vcmplt_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2796, [$C5,$CA,$C2,$D4,$12                               ] , 'vcmple_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2797, [$C5,$CA,$C2,$11,$12                               ] , 'vcmple_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2798, [$C5,$CA,$C2,$11,$12                               ] , 'vcmple_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2799, [$C5,$CA,$C2,$D4,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,xmm4'                    );
  TestCase.testcase(2800, [$C5,$CA,$C2,$11,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,dword [ecx]'             );
  TestCase.testcase(2801, [$C5,$CA,$C2,$11,$13                               ] , 'vcmpunord_sss  xmm2,xmm6,dword [ecx]'             );
  TestCase.testcase(2802, [$C5,$CA,$C2,$D4,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2803, [$C5,$CA,$C2,$11,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2804, [$C5,$CA,$C2,$11,$14                               ] , 'vcmpneq_usss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2805, [$C5,$CA,$C2,$D4,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2806, [$C5,$CA,$C2,$11,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2807, [$C5,$CA,$C2,$11,$15                               ] , 'vcmpnlt_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2808, [$C5,$CA,$C2,$D4,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2809, [$C5,$CA,$C2,$11,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2810, [$C5,$CA,$C2,$11,$16                               ] , 'vcmpnle_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2811, [$C5,$CA,$C2,$D4,$17                               ] , 'vcmpord_sss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2812, [$C5,$CA,$C2,$11,$17                               ] , 'vcmpord_sss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2813, [$C5,$CA,$C2,$11,$17                               ] , 'vcmpord_sss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2814, [$C5,$CA,$C2,$D4,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2815, [$C5,$CA,$C2,$11,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2816, [$C5,$CA,$C2,$11,$18                               ] , 'vcmpeq_usss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2817, [$C5,$CA,$C2,$D4,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2818, [$C5,$CA,$C2,$11,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2819, [$C5,$CA,$C2,$11,$19                               ] , 'vcmpnge_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2820, [$C5,$CA,$C2,$D4,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2821, [$C5,$CA,$C2,$11,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2822, [$C5,$CA,$C2,$11,$1A                               ] , 'vcmpngt_uqss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2823, [$C5,$CA,$C2,$D4,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,xmm4'                   );
  TestCase.testcase(2824, [$C5,$CA,$C2,$11,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,dword [ecx]'            );
  TestCase.testcase(2825, [$C5,$CA,$C2,$11,$1B                               ] , 'vcmpfalse_osss  xmm2,xmm6,dword [ecx]'            );
  TestCase.testcase(2826, [$C5,$CA,$C2,$D4,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,xmm4'                     );
  TestCase.testcase(2827, [$C5,$CA,$C2,$11,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2828, [$C5,$CA,$C2,$11,$1C                               ] , 'vcmpneq_osss  xmm2,xmm6,dword [ecx]'              );
  TestCase.testcase(2829, [$C5,$CA,$C2,$D4,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2830, [$C5,$CA,$C2,$11,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2831, [$C5,$CA,$C2,$11,$1D                               ] , 'vcmpge_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2832, [$C5,$CA,$C2,$D4,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,xmm4'                      );
  TestCase.testcase(2833, [$C5,$CA,$C2,$11,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2834, [$C5,$CA,$C2,$11,$1E                               ] , 'vcmpgt_oqss  xmm2,xmm6,dword [ecx]'               );
  TestCase.testcase(2835, [$C5,$CA,$C2,$D4,$1F                               ] , 'vcmue_usss  xmm2,xmm6,xmm4'                       );
  TestCase.testcase(2836, [$C5,$CA,$C2,$11,$1F                               ] , 'vcmue_usss  xmm2,xmm6,dword [ecx]'                );
  TestCase.testcase(2837, [$C5,$CA,$C2,$11,$1F                               ] , 'vcmue_usss  xmm2,xmm6,dword [ecx]'                );
  TestCase.testcase(2838, [$C4,$E2,$7D,$18,$21                               ] , 'vbroadcastss  ymm4,dword [ecx]'                   );
  TestCase.testcase(2839, [$C4,$E2,$7D,$18,$21                               ] , 'vbroadcastss  ymm4,dword [ecx]'                   );
  TestCase.testcase(2840, [$C5,$F8,$2F,$F4                                   ] , 'vcomiss  xmm6,xmm4'                               );
  TestCase.testcase(2841, [$C5,$F8,$2F,$21                                   ] , 'vcomiss  xmm4,dword [ecx]'                        );
  TestCase.testcase(2842, [$C5,$F8,$2F,$21                                   ] , 'vcomiss  xmm4,dword [ecx]'                        );
  TestCase.testcase(2843, [$C4,$E2,$79,$21,$F4                               ] , 'vpmovsxbd  xmm6,xmm4'                             );
  TestCase.testcase(2844, [$C4,$E2,$79,$21,$21                               ] , 'vpmovsxbd  xmm4,dword [ecx]'                      );
  TestCase.testcase(2845, [$C4,$E2,$79,$21,$21                               ] , 'vpmovsxbd  xmm4,dword [ecx]'                      );
  TestCase.testcase(2846, [$C4,$E2,$79,$24,$F4                               ] , 'vpmovsxwq  xmm6,xmm4'                             );
  TestCase.testcase(2847, [$C4,$E2,$79,$24,$21                               ] , 'vpmovsxwq  xmm4,dword [ecx]'                      );
  TestCase.testcase(2848, [$C4,$E2,$79,$24,$21                               ] , 'vpmovsxwq  xmm4,dword [ecx]'                      );
  TestCase.testcase(2849, [$C4,$E2,$79,$31,$F4                               ] , 'vpmovzxbd  xmm6,xmm4'                             );
  TestCase.testcase(2850, [$C4,$E2,$79,$31,$21                               ] , 'vpmovzxbd  xmm4,dword [ecx]'                      );
  TestCase.testcase(2851, [$C4,$E2,$79,$31,$21                               ] , 'vpmovzxbd  xmm4,dword [ecx]'                      );
  TestCase.testcase(2852, [$C4,$E2,$79,$34,$F4                               ] , 'vpmovzxwq  xmm6,xmm4'                             );
  TestCase.testcase(2853, [$C4,$E2,$79,$34,$21                               ] , 'vpmovzxwq  xmm4,dword [ecx]'                      );
  TestCase.testcase(2854, [$C4,$E2,$79,$34,$21                               ] , 'vpmovzxwq  xmm4,dword [ecx]'                      );
  TestCase.testcase(2855, [$C5,$F8,$2E,$F4                                   ] , 'vucomiss  xmm6,xmm4'                              );
  TestCase.testcase(2856, [$C5,$F8,$2E,$21                                   ] , 'vucomiss  xmm4,dword [ecx]'                       );
  TestCase.testcase(2857, [$C5,$F8,$2E,$21                                   ] , 'vucomiss  xmm4,dword [ecx]'                       );
  TestCase.testcase(2858, [$C4,$E2,$79,$18,$21                               ] , 'vbroadcastss  xmm4,dword [ecx]'                   );
  TestCase.testcase(2859, [$C4,$E2,$79,$18,$21                               ] , 'vbroadcastss  xmm4,dword [ecx]'                   );
  TestCase.testcase(2860, [$C5,$FA,$10,$21                                   ] , 'vmovss  xmm4,dword [ecx]'                         );
  TestCase.testcase(2861, [$C5,$FA,$10,$21                                   ] , 'vmovss  xmm4,dword [ecx]'                         );
  TestCase.testcase(2862, [$C5,$FA,$11,$21                                   ] , 'vmovss  dword [ecx],xmm4'                         );
  TestCase.testcase(2863, [$C5,$FA,$11,$21                                   ] , 'vmovss  dword [ecx],xmm4'                         );
  TestCase.testcase(2864, [$C5,$F9,$7E,$E1                                   ] , 'vmovd  ecx,xmm4'                                  );
  TestCase.testcase(2865, [$C5,$F9,$7E,$21                                   ] , 'vmovd  dword [ecx],xmm4'                          );
  TestCase.testcase(2866, [$C5,$F9,$6E,$E1                                   ] , 'vmovd  xmm4,ecx'                                  );
  TestCase.testcase(2867, [$C5,$F9,$6E,$21                                   ] , 'vmovd  xmm4,dword [ecx]'                          );
  TestCase.testcase(2868, [$C5,$F9,$7E,$21                                   ] , 'vmovd  dword [ecx],xmm4'                          );
  TestCase.testcase(2869, [$C5,$F9,$6E,$21                                   ] , 'vmovd  xmm4,dword [ecx]'                          );
  TestCase.testcase(2870, [$C5,$FA,$2D,$CC                                   ] , 'vcvtss2si  ecx,xmm4'                              );
  TestCase.testcase(2871, [$C5,$FA,$2D,$09                                   ] , 'vcvtss2si  ecx,dword [ecx]'                       );
  TestCase.testcase(2872, [$C5,$FA,$2D,$09                                   ] , 'vcvtss2si  ecx,dword [ecx]'                       );
  TestCase.testcase(2873, [$C5,$FA,$2C,$CC                                   ] , 'vcvttss2si  ecx,xmm4'                             );
  TestCase.testcase(2874, [$C5,$FA,$2C,$09                                   ] , 'vcvttss2si  ecx,dword [ecx]'                      );
  TestCase.testcase(2875, [$C5,$FA,$2C,$09                                   ] , 'vcvttss2si  ecx,dword [ecx]'                      );
  TestCase.testcase(2876, [$C4,$E3,$79,$17,$21,$07                           ] , 'vextractps  dword [ecx],xmm4,0x7'                 );
  TestCase.testcase(2877, [$C4,$E3,$79,$17,$21,$07                           ] , 'vextractps  dword [ecx],xmm4,0x7'                 );
  TestCase.testcase(2878, [$C4,$E3,$79,$16,$E1,$07                           ] , 'vpextrd  ecx,xmm4,0x7'                            );
  TestCase.testcase(2879, [$C4,$E3,$79,$16,$21,$07                           ] , 'vpextrd  dword [ecx],xmm4,0x7'                    );
  TestCase.testcase(2880, [$C4,$E3,$79,$16,$21,$07                           ] , 'vpextrd  dword [ecx],xmm4,0x7'                    );
  TestCase.testcase(2881, [$C4,$E3,$79,$17,$E1,$07                           ] , 'vextractps  ecx,xmm4,0x7'                         );
  TestCase.testcase(2882, [$C4,$E3,$79,$17,$21,$07                           ] , 'vextractps  dword [ecx],xmm4,0x7'                 );
  TestCase.testcase(2883, [$C4,$E3,$79,$17,$21,$07                           ] , 'vextractps  dword [ecx],xmm4,0x7'                 );
  TestCase.testcase(2884, [$C4,$E3,$59,$22,$F1,$07                           ] , 'vpinsrd  xmm6,xmm4,ecx,0x7'                       );
  TestCase.testcase(2885, [$C4,$E3,$59,$22,$31,$07                           ] , 'vpinsrd  xmm6,xmm4,dword [ecx],0x7'               );
  TestCase.testcase(2886, [$C4,$E3,$59,$22,$31,$07                           ] , 'vpinsrd  xmm6,xmm4,dword [ecx],0x7'               );
  TestCase.testcase(2887, [$C5,$DB,$2A,$F1                                   ] , 'vcvtsi2sd  xmm6,xmm4,ecx'                         );
  TestCase.testcase(2888, [$C5,$DB,$2A,$31                                   ] , 'vcvtsi2sd  xmm6,xmm4,dword [ecx]'                 );
  TestCase.testcase(2889, [$C5,$DB,$2A,$31                                   ] , 'vcvtsi2sd  xmm6,xmm4,dword [ecx]'                 );
  TestCase.testcase(2890, [$C5,$DA,$2A,$F1                                   ] , 'vcvtsi2ss  xmm6,xmm4,ecx'                         );
  TestCase.testcase(2891, [$C5,$DA,$2A,$31                                   ] , 'vcvtsi2ss  xmm6,xmm4,dword [ecx]'                 );
  TestCase.testcase(2892, [$C5,$DA,$2A,$31                                   ] , 'vcvtsi2ss  xmm6,xmm4,dword [ecx]'                 );
  TestCase.testcase(2893, [$C5,$CA,$C2,$D4,$07                               ] , 'vcmpordss  xmm2,xmm6,xmm4'                        );
  TestCase.testcase(2894, [$C5,$CA,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2895, [$C5,$CA,$C2,$11,$07                               ] , 'vcmpordss  xmm2,xmm6,dword [ecx]'                 );
  TestCase.testcase(2896, [$C4,$E3,$49,$21,$D4,$07                           ] , 'vinsertps  xmm2,xmm6,xmm4,0x7'                    );
  TestCase.testcase(2897, [$C4,$E3,$49,$21,$11,$07                           ] , 'vinsertps  xmm2,xmm6,dword [ecx],0x7'             );
  TestCase.testcase(2898, [$C4,$E3,$49,$21,$11,$07                           ] , 'vinsertps  xmm2,xmm6,dword [ecx],0x7'             );
  TestCase.testcase(2899, [$C4,$E3,$49,$0A,$D4,$07                           ] , 'vroundss  xmm2,xmm6,xmm4,0x7'                     );
  TestCase.testcase(2900, [$C4,$E3,$49,$0A,$11,$07                           ] , 'vroundss  xmm2,xmm6,dword [ecx],0x7'              );
  TestCase.testcase(2901, [$C4,$E3,$49,$0A,$11,$07                           ] , 'vroundss  xmm2,xmm6,dword [ecx],0x7'              );
  TestCase.testcase(2902, [$C4,$E2,$79,$22,$F4                               ] , 'vpmovsxbq  xmm6,xmm4'                             );
  TestCase.testcase(2903, [$C4,$E2,$79,$22,$21                               ] , 'vpmovsxbq  xmm4,word [ecx]'                       );
  TestCase.testcase(2904, [$C4,$E2,$79,$22,$21                               ] , 'vpmovsxbq  xmm4,word [ecx]'                       );
  TestCase.testcase(2905, [$C4,$E2,$79,$32,$F4                               ] , 'vpmovzxbq  xmm6,xmm4'                             );
  TestCase.testcase(2906, [$C4,$E2,$79,$32,$21                               ] , 'vpmovzxbq  xmm4,word [ecx]'                       );
  TestCase.testcase(2907, [$C4,$E2,$79,$32,$21                               ] , 'vpmovzxbq  xmm4,word [ecx]'                       );
  TestCase.testcase(2908, [$C5,$F9,$C5,$CC,$07                               ] , 'vpextrw  ecx,xmm4,0x7'                            );
  TestCase.testcase(2909, [$C4,$E3,$79,$15,$21,$07                           ] , 'vpextrw  word [ecx],xmm4,0x7'                     );
  TestCase.testcase(2910, [$C4,$E3,$79,$15,$21,$07                           ] , 'vpextrw  word [ecx],xmm4,0x7'                     );
  TestCase.testcase(2911, [$C4,$E3,$79,$15,$21,$07                           ] , 'vpextrw  word [ecx],xmm4,0x7'                     );
  TestCase.testcase(2912, [$C4,$E3,$79,$15,$21,$07                           ] , 'vpextrw  word [ecx],xmm4,0x7'                     );
  TestCase.testcase(2913, [$C5,$D9,$C4,$F1,$07                               ] , 'vpinsrw  xmm6,xmm4,ecx,0x7'                       );
  TestCase.testcase(2914, [$C5,$D9,$C4,$31,$07                               ] , 'vpinsrw  xmm6,xmm4,word [ecx],0x7'                );
  TestCase.testcase(2915, [$C5,$D9,$C4,$31,$07                               ] , 'vpinsrw  xmm6,xmm4,word [ecx],0x7'                );
  TestCase.testcase(2916, [$C4,$E3,$79,$14,$E1,$07                           ] , 'vpextrb  ecx,xmm4,0x7'                            );
  TestCase.testcase(2917, [$C4,$E3,$79,$14,$21,$07                           ] , 'vpextrb  byte [ecx],xmm4,0x7'                     );
  TestCase.testcase(2918, [$C4,$E3,$79,$14,$21,$07                           ] , 'vpextrb  byte [ecx],xmm4,0x7'                     );
  TestCase.testcase(2919, [$C4,$E3,$59,$20,$F1,$07                           ] , 'vpinsrb  xmm6,xmm4,ecx,0x7'                       );
  TestCase.testcase(2920, [$C4,$E3,$59,$20,$31,$07                           ] , 'vpinsrb  xmm6,xmm4,byte [ecx],0x7'                );
  TestCase.testcase(2921, [$C4,$E3,$59,$20,$31,$07                           ] , 'vpinsrb  xmm6,xmm4,byte [ecx],0x7'                );
  TestCase.testcase(2922, [$C4,$E3,$79,$14,$21,$07                           ] , 'vpextrb  byte [ecx],xmm4,0x7'                     );
  TestCase.testcase(2923, [$C4,$E3,$79,$14,$21,$07                           ] , 'vpextrb  byte [ecx],xmm4,0x7'                     );
  TestCase.testcase(2924, [$C5,$F9,$F7,$F4                                   ] , 'vmaskmovdqu  xmm6,xmm4'                           );
  TestCase.testcase(2925, [$C5,$FA,$7E,$F4                                   ] , 'vmovq  xmm6,xmm4'                                 );
  TestCase.testcase(2926, [$C5,$F9,$50,$CC                                   ] , 'vmovmskpd  ecx,xmm4'                              );
  TestCase.testcase(2927, [$C5,$F8,$50,$CC                                   ] , 'vmovmskps  ecx,xmm4'                              );
  TestCase.testcase(2928, [$C5,$F9,$D7,$CC                                   ] , 'vpmovmskb  ecx,xmm4'                              );
  TestCase.testcase(2929, [$C5,$C8,$12,$D4                                   ] , 'vmovhlps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2930, [$C5,$C8,$16,$D4                                   ] , 'vmovlhps  xmm2,xmm6,xmm4'                         );
  TestCase.testcase(2931, [$C5,$CB,$10,$D4                                   ] , 'vmovsd  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2932, [$C5,$CA,$10,$D4                                   ] , 'vmovss  xmm2,xmm6,xmm4'                           );
  TestCase.testcase(2933, [$C5,$C9,$72,$F4,$07                               ] , 'vpslld  xmm6,xmm4,0x7'                            );
  TestCase.testcase(2934, [$C5,$C9,$73,$FC,$07                               ] , 'vpslldq  xmm6,xmm4,0x7'                           );
  TestCase.testcase(2935, [$C5,$C9,$73,$F4,$07                               ] , 'vpsllq  xmm6,xmm4,0x7'                            );
  TestCase.testcase(2936, [$C5,$C9,$71,$F4,$07                               ] , 'vpsllw  xmm6,xmm4,0x7'                            );
  TestCase.testcase(2937, [$C5,$C9,$72,$E4,$07                               ] , 'vpsrad  xmm6,xmm4,0x7'                            );
  TestCase.testcase(2938, [$C5,$C9,$71,$E4,$07                               ] , 'vpsraw  xmm6,xmm4,0x7'                            );
  TestCase.testcase(2939, [$C5,$C9,$72,$D4,$07                               ] , 'vpsrld  xmm6,xmm4,0x7'                            );
  TestCase.testcase(2940, [$C5,$C9,$73,$DC,$07                               ] , 'vpsrldq  xmm6,xmm4,0x7'                           );
  TestCase.testcase(2941, [$C5,$C9,$73,$D4,$07                               ] , 'vpsrlq  xmm6,xmm4,0x7'                            );
  TestCase.testcase(2942, [$C5,$C9,$71,$D4,$07                               ] , 'vpsrlw  xmm6,xmm4,0x7'                            );
  TestCase.testcase(2943, [$C5,$F9,$C5,$CC,$07                               ] , 'vpextrw  ecx,xmm4,0x7'                            );
  TestCase.testcase(2944, [$C5,$FD,$50,$CC                                   ] , 'vmovmskpd  ecx,ymm4'                              );
  TestCase.testcase(2945, [$C5,$FC,$50,$CC                                   ] , 'vmovmskps  ecx,ymm4'                              );
  TestCase.testcase(2946, [$C5,$FB,$E6,$F4                                   ] , 'vcvtpd2dq  xmm6,xmm4'                             );
  TestCase.testcase(2947, [$C5,$FF,$E6,$F4                                   ] , 'vcvtpd2dq  xmm6,ymm4'                             );
  TestCase.testcase(2948, [$C5,$F9,$5A,$F4                                   ] , 'vcvtpd2ps  xmm6,xmm4'                             );
  TestCase.testcase(2949, [$C5,$FD,$5A,$F4                                   ] , 'vcvtpd2ps  xmm6,ymm4'                             );
  TestCase.testcase(2950, [$C5,$F9,$E6,$F4                                   ] , 'vcvttpd2dq  xmm6,xmm4'                            );
  TestCase.testcase(2951, [$C5,$FD,$E6,$F4                                   ] , 'vcvttpd2dq  xmm6,ymm4'                            );
  TestCase.testcase(2952, [$C5,$F8,$AE,$15,$34,$12,$00,$00                   ] , 'vldmxcsr  dword ds:[0x1234]'                      );
  TestCase.testcase(2953, [$C5,$F9,$6F,$05,$34,$12,$00,$00                   ] , 'vmovdqa  xmm0,oword ds:[0x1234]'                  );
  TestCase.testcase(2954, [$C5,$F9,$7F,$05,$34,$12,$00,$00                   ] , 'vmovdqa  oword ds:[0x1234],xmm0'                  );
  TestCase.testcase(2955, [$C5,$F9,$7E,$05,$34,$12,$00,$00                   ] , 'vmovd  dword ds:[0x1234],xmm0'                    );
  TestCase.testcase(2956, [$C5,$FB,$2D,$05,$34,$12,$00,$00                   ] , 'vcvtsd2si  eax,qword ds:[0x1234]'                 );
  TestCase.testcase(2957, [$C5,$FE,$E6,$05,$34,$12,$00,$00                   ] , 'vcvtdq2pd  ymm0,oword ds:[0x1234]'                );
  TestCase.testcase(2958, [$C5,$FD,$5A,$05,$34,$12,$00,$00                   ] , 'vcvtpd2ps  xmm0,yword ds:[0x1234]'                );
  TestCase.testcase(2959, [$C5,$F9,$E0,$3D,$34,$12,$00,$00                   ] , 'vpavgb  xmm7,xmm0,oword ds:[0x1234]'              );
  TestCase.testcase(2960, [$C4,$E3,$79,$DF,$05,$34,$12,$00,$00,$07           ] , 'vaeskeygenassist  xmm0,oword ds:[0x1234],0x7'     );
  TestCase.testcase(2961, [$C4,$E3,$79,$14,$05,$34,$12,$00,$00,$07           ] , 'vpextrb  byte ds:[0x1234],xmm0,0x7'               );
  TestCase.testcase(2962, [$C5,$FB,$2A,$3D,$34,$12,$00,$00                   ] , 'vcvtsi2sd  xmm7,xmm0,dword ds:[0x1234]'           );
  TestCase.testcase(2963, [$C4,$E3,$79,$44,$3D,$34,$12,$00,$00,$07           ] , 'vpclmulqdq  xmm7,xmm0,oword ds:[0x1234],0x7'      );
  TestCase.testcase(2964, [$C4,$E3,$59,$4A,$35,$34,$12,$00,$00,$00           ] , 'vblendvps  xmm6,xmm4,oword ds:[0x1234],xmm0'      );
  TestCase.testcase(2965, [$C4,$E3,$79,$20,$3D,$34,$12,$00,$00,$07           ] , 'vpinsrb  xmm7,xmm0,byte ds:[0x1234],0x7'          );
  TestCase.testcase(2966, [$C5,$FD,$6F,$05,$34,$12,$00,$00                   ] , 'vmovdqa  ymm0,yword ds:[0x1234]'                  );
  TestCase.testcase(2967, [$C5,$FD,$7F,$05,$34,$12,$00,$00                   ] , 'vmovdqa  yword ds:[0x1234],ymm0'                  );
  TestCase.testcase(2968, [$C4,$E2,$7D,$0D,$3D,$34,$12,$00,$00               ] , 'vpermilpd  ymm7,ymm0,yword ds:[0x1234]'           );
  TestCase.testcase(2969, [$C4,$E3,$7D,$09,$05,$34,$12,$00,$00,$07           ] , 'vroundpd  ymm0,yword ds:[0x1234],0x7'             );
  TestCase.testcase(2970, [$C4,$E3,$7D,$19,$05,$34,$12,$00,$00,$07           ] , 'vextractf128  oword ds:[0x1234],ymm0,0x7'         );
  TestCase.testcase(2971, [$C4,$E3,$7D,$06,$3D,$34,$12,$00,$00,$07           ] , 'vperm2f128  ymm7,ymm0,yword ds:[0x1234],0x7'      );
  TestCase.testcase(2972, [$C4,$E3,$5D,$4B,$35,$34,$12,$00,$00,$00           ] , 'vblendvpd  ymm6,ymm4,yword ds:[0x1234],ymm0'      );
  TestCase.testcase(2973, [$C5,$F8,$AE,$55,$00                               ] , 'vldmxcsr  dword [ebp+0x0]'                        );
  TestCase.testcase(2974, [$C5,$F9,$6F,$45,$00                               ] , 'vmovdqa  xmm0,oword [ebp+0x0]'                    );
  TestCase.testcase(2975, [$C5,$F9,$7F,$45,$00                               ] , 'vmovdqa  oword [ebp+0x0],xmm0'                    );
  TestCase.testcase(2976, [$C5,$F9,$7E,$45,$00                               ] , 'vmovd  dword [ebp+0x0],xmm0'                      );
  TestCase.testcase(2977, [$C5,$FB,$2D,$45,$00                               ] , 'vcvtsd2si  eax,qword [ebp+0x0]'                   );
  TestCase.testcase(2978, [$C5,$FE,$E6,$45,$00                               ] , 'vcvtdq2pd  ymm0,oword [ebp+0x0]'                  );
  TestCase.testcase(2979, [$C5,$FD,$5A,$45,$00                               ] , 'vcvtpd2ps  xmm0,yword [ebp+0x0]'                  );
  TestCase.testcase(2980, [$C5,$F9,$E0,$7D,$00                               ] , 'vpavgb  xmm7,xmm0,oword [ebp+0x0]'                );
  TestCase.testcase(2981, [$C4,$E3,$79,$DF,$45,$00,$07                       ] , 'vaeskeygenassist  xmm0,oword [ebp+0x0],0x7'       );
  TestCase.testcase(2982, [$C4,$E3,$79,$14,$45,$00,$07                       ] , 'vpextrb  byte [ebp+0x0],xmm0,0x7'                 );
  TestCase.testcase(2983, [$C5,$FB,$2A,$7D,$00                               ] , 'vcvtsi2sd  xmm7,xmm0,dword [ebp+0x0]'             );
  TestCase.testcase(2984, [$C4,$E3,$79,$44,$7D,$00,$07                       ] , 'vpclmulqdq  xmm7,xmm0,oword [ebp+0x0],0x7'        );
  TestCase.testcase(2985, [$C4,$E3,$59,$4A,$75,$00,$00                       ] , 'vblendvps  xmm6,xmm4,oword [ebp+0x0],xmm0'        );
  TestCase.testcase(2986, [$C4,$E3,$79,$20,$7D,$00,$07                       ] , 'vpinsrb  xmm7,xmm0,byte [ebp+0x0],0x7'            );
  TestCase.testcase(2987, [$C5,$FD,$6F,$45,$00                               ] , 'vmovdqa  ymm0,yword [ebp+0x0]'                    );
  TestCase.testcase(2988, [$C5,$FD,$7F,$45,$00                               ] , 'vmovdqa  yword [ebp+0x0],ymm0'                    );
  TestCase.testcase(2989, [$C4,$E2,$7D,$0D,$7D,$00                           ] , 'vpermilpd  ymm7,ymm0,yword [ebp+0x0]'             );
  TestCase.testcase(2990, [$C4,$E3,$7D,$09,$45,$00,$07                       ] , 'vroundpd  ymm0,yword [ebp+0x0],0x7'               );
  TestCase.testcase(2991, [$C4,$E3,$7D,$19,$45,$00,$07                       ] , 'vextractf128  oword [ebp+0x0],ymm0,0x7'           );
  TestCase.testcase(2992, [$C4,$E3,$7D,$06,$7D,$00,$07                       ] , 'vperm2f128  ymm7,ymm0,yword [ebp+0x0],0x7'        );
  TestCase.testcase(2993, [$C4,$E3,$5D,$4B,$75,$00,$00                       ] , 'vblendvpd  ymm6,ymm4,yword [ebp+0x0],ymm0'        );
  TestCase.testcase(2994, [$C5,$F8,$AE,$95,$99,$00,$00,$00                   ] , 'vldmxcsr  dword [ebp+0x99]'                       );
  TestCase.testcase(2995, [$C5,$F9,$6F,$85,$99,$00,$00,$00                   ] , 'vmovdqa  xmm0,oword [ebp+0x99]'                   );
  TestCase.testcase(2996, [$C5,$F9,$7F,$85,$99,$00,$00,$00                   ] , 'vmovdqa  oword [ebp+0x99],xmm0'                   );
  TestCase.testcase(2997, [$C5,$F9,$7E,$85,$99,$00,$00,$00                   ] , 'vmovd  dword [ebp+0x99],xmm0'                     );
  TestCase.testcase(2998, [$C5,$FB,$2D,$85,$99,$00,$00,$00                   ] , 'vcvtsd2si  eax,qword [ebp+0x99]'                  );
  TestCase.testcase(2999, [$C5,$FE,$E6,$85,$99,$00,$00,$00                   ] , 'vcvtdq2pd  ymm0,oword [ebp+0x99]'                 );
  TestCase.testcase(3000, [$C5,$FD,$5A,$85,$99,$00,$00,$00                   ] , 'vcvtpd2ps  xmm0,yword [ebp+0x99]'                 );
  TestCase.testcase(3001, [$C5,$F9,$E0,$BD,$99,$00,$00,$00                   ] , 'vpavgb  xmm7,xmm0,oword [ebp+0x99]'               );
  TestCase.testcase(3002, [$C4,$E3,$79,$DF,$85,$99,$00,$00,$00,$07           ] , 'vaeskeygenassist  xmm0,oword [ebp+0x99],0x7'      );
  TestCase.testcase(3003, [$C4,$E3,$79,$14,$85,$99,$00,$00,$00,$07           ] , 'vpextrb  byte [ebp+0x99],xmm0,0x7'                );
  TestCase.testcase(3004, [$C5,$FB,$2A,$BD,$99,$00,$00,$00                   ] , 'vcvtsi2sd  xmm7,xmm0,dword [ebp+0x99]'            );
  TestCase.testcase(3005, [$C4,$E3,$79,$44,$BD,$99,$00,$00,$00,$07           ] , 'vpclmulqdq  xmm7,xmm0,oword [ebp+0x99],0x7'       );
  TestCase.testcase(3006, [$C4,$E3,$59,$4A,$B5,$99,$00,$00,$00,$00           ] , 'vblendvps  xmm6,xmm4,oword [ebp+0x99],xmm0'       );
  TestCase.testcase(3007, [$C4,$E3,$79,$20,$BD,$99,$00,$00,$00,$07           ] , 'vpinsrb  xmm7,xmm0,byte [ebp+0x99],0x7'           );
  TestCase.testcase(3008, [$C5,$FD,$6F,$85,$99,$00,$00,$00                   ] , 'vmovdqa  ymm0,yword [ebp+0x99]'                   );
  TestCase.testcase(3009, [$C5,$FD,$7F,$85,$99,$00,$00,$00                   ] , 'vmovdqa  yword [ebp+0x99],ymm0'                   );
  TestCase.testcase(3010, [$C4,$E2,$7D,$0D,$BD,$99,$00,$00,$00               ] , 'vpermilpd  ymm7,ymm0,yword [ebp+0x99]'            );
  TestCase.testcase(3011, [$C4,$E3,$7D,$09,$85,$99,$00,$00,$00,$07           ] , 'vroundpd  ymm0,yword [ebp+0x99],0x7'              );
  TestCase.testcase(3012, [$C4,$E3,$7D,$19,$85,$99,$00,$00,$00,$07           ] , 'vextractf128  oword [ebp+0x99],ymm0,0x7'          );
  TestCase.testcase(3013, [$C4,$E3,$7D,$06,$BD,$99,$00,$00,$00,$07           ] , 'vperm2f128  ymm7,ymm0,yword [ebp+0x99],0x7'       );
  TestCase.testcase(3014, [$C4,$E3,$5D,$4B,$B5,$99,$00,$00,$00,$00           ] , 'vblendvpd  ymm6,ymm4,yword [ebp+0x99],ymm0'       );
  TestCase.testcase(3015, [$C5,$F8,$AE,$14,$25,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eiz*1+0x99]'                     );
  TestCase.testcase(3016, [$C5,$F9,$6F,$04,$25,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eiz*1+0x99]'                 );
  TestCase.testcase(3017, [$C5,$F9,$7F,$04,$25,$99,$00,$00,$00               ] , 'vmovdqa  oword [eiz*1+0x99],xmm0'                 );
  TestCase.testcase(3018, [$C5,$F9,$7E,$04,$25,$99,$00,$00,$00               ] , 'vmovd  dword [eiz*1+0x99],xmm0'                   );
  TestCase.testcase(3019, [$C5,$FB,$2D,$04,$25,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eiz*1+0x99]'                );
  TestCase.testcase(3020, [$C5,$FE,$E6,$04,$25,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eiz*1+0x99]'               );
  TestCase.testcase(3021, [$C5,$FD,$5A,$04,$25,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eiz*1+0x99]'               );
  TestCase.testcase(3022, [$C5,$F9,$E0,$3C,$25,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eiz*1+0x99]'             );
  TestCase.testcase(3023, [$C4,$E3,$79,$DF,$04,$25,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eiz*1+0x99],0x7'    );
  TestCase.testcase(3024, [$C4,$E3,$79,$14,$04,$25,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eiz*1+0x99],xmm0,0x7'              );
  TestCase.testcase(3025, [$C5,$FB,$2A,$3C,$25,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eiz*1+0x99]'          );
  TestCase.testcase(3026, [$C4,$E3,$79,$44,$3C,$25,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eiz*1+0x99],0x7'     );
  TestCase.testcase(3027, [$C4,$E3,$59,$4A,$34,$25,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eiz*1+0x99],xmm0'     );
  TestCase.testcase(3028, [$C4,$E3,$79,$20,$3C,$25,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eiz*1+0x99],0x7'         );
  TestCase.testcase(3029, [$C5,$FD,$6F,$04,$25,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eiz*1+0x99]'                 );
  TestCase.testcase(3030, [$C5,$FD,$7F,$04,$25,$99,$00,$00,$00               ] , 'vmovdqa  yword [eiz*1+0x99],ymm0'                 );
  TestCase.testcase(3031, [$C4,$E2,$7D,$0D,$3C,$25,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eiz*1+0x99]'          );
  TestCase.testcase(3032, [$C4,$E3,$7D,$09,$04,$25,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eiz*1+0x99],0x7'            );
  TestCase.testcase(3033, [$C4,$E3,$7D,$19,$04,$25,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eiz*1+0x99],ymm0,0x7'        );
  TestCase.testcase(3034, [$C4,$E3,$7D,$06,$3C,$25,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eiz*1+0x99],0x7'     );
  TestCase.testcase(3035, [$C4,$E3,$5D,$4B,$34,$25,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eiz*1+0x99],ymm0'     );
  TestCase.testcase(3036, [$C5,$F8,$AE,$14,$65,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eiz*2+0x99]'                     );
  TestCase.testcase(3037, [$C5,$F9,$6F,$04,$65,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eiz*2+0x99]'                 );
  TestCase.testcase(3038, [$C5,$F9,$7F,$04,$65,$99,$00,$00,$00               ] , 'vmovdqa  oword [eiz*2+0x99],xmm0'                 );
  TestCase.testcase(3039, [$C5,$F9,$7E,$04,$65,$99,$00,$00,$00               ] , 'vmovd  dword [eiz*2+0x99],xmm0'                   );
  TestCase.testcase(3040, [$C5,$FB,$2D,$04,$65,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eiz*2+0x99]'                );
  TestCase.testcase(3041, [$C5,$FE,$E6,$04,$65,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eiz*2+0x99]'               );
  TestCase.testcase(3042, [$C5,$FD,$5A,$04,$65,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eiz*2+0x99]'               );
  TestCase.testcase(3043, [$C5,$F9,$E0,$3C,$65,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eiz*2+0x99]'             );
  TestCase.testcase(3044, [$C4,$E3,$79,$DF,$04,$65,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eiz*2+0x99],0x7'    );
  TestCase.testcase(3045, [$C4,$E3,$79,$14,$04,$65,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eiz*2+0x99],xmm0,0x7'              );
  TestCase.testcase(3046, [$C5,$FB,$2A,$3C,$65,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eiz*2+0x99]'          );
  TestCase.testcase(3047, [$C4,$E3,$79,$44,$3C,$65,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eiz*2+0x99],0x7'     );
  TestCase.testcase(3048, [$C4,$E3,$59,$4A,$34,$65,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eiz*2+0x99],xmm0'     );
  TestCase.testcase(3049, [$C4,$E3,$79,$20,$3C,$65,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eiz*2+0x99],0x7'         );
  TestCase.testcase(3050, [$C5,$FD,$6F,$04,$65,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eiz*2+0x99]'                 );
  TestCase.testcase(3051, [$C5,$FD,$7F,$04,$65,$99,$00,$00,$00               ] , 'vmovdqa  yword [eiz*2+0x99],ymm0'                 );
  TestCase.testcase(3052, [$C4,$E2,$7D,$0D,$3C,$65,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eiz*2+0x99]'          );
  TestCase.testcase(3053, [$C4,$E3,$7D,$09,$04,$65,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eiz*2+0x99],0x7'            );
  TestCase.testcase(3054, [$C4,$E3,$7D,$19,$04,$65,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eiz*2+0x99],ymm0,0x7'        );
  TestCase.testcase(3055, [$C4,$E3,$7D,$06,$3C,$65,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eiz*2+0x99],0x7'     );
  TestCase.testcase(3056, [$C4,$E3,$5D,$4B,$34,$65,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eiz*2+0x99],ymm0'     );
  TestCase.testcase(3057, [$C5,$F8,$AE,$94,$20,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eax+eiz*1+0x99]'                 );
  TestCase.testcase(3058, [$C5,$F9,$6F,$84,$20,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eax+eiz*1+0x99]'             );
  TestCase.testcase(3059, [$C5,$F9,$7F,$84,$20,$99,$00,$00,$00               ] , 'vmovdqa  oword [eax+eiz*1+0x99],xmm0'             );
  TestCase.testcase(3060, [$C5,$F9,$7E,$84,$20,$99,$00,$00,$00               ] , 'vmovd  dword [eax+eiz*1+0x99],xmm0'               );
  TestCase.testcase(3061, [$C5,$FB,$2D,$84,$20,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eax+eiz*1+0x99]'            );
  TestCase.testcase(3062, [$C5,$FE,$E6,$84,$20,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eax+eiz*1+0x99]'           );
  TestCase.testcase(3063, [$C5,$FD,$5A,$84,$20,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eax+eiz*1+0x99]'           );
  TestCase.testcase(3064, [$C5,$F9,$E0,$BC,$20,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eax+eiz*1+0x99]'         );
  TestCase.testcase(3065, [$C4,$E3,$79,$DF,$84,$20,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eax+eiz*1+0x99],0x7' );
  TestCase.testcase(3066, [$C4,$E3,$79,$14,$84,$20,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eax+eiz*1+0x99],xmm0,0x7'          );
  TestCase.testcase(3067, [$C5,$FB,$2A,$BC,$20,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eax+eiz*1+0x99]'      );
  TestCase.testcase(3068, [$C4,$E3,$79,$44,$BC,$20,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eax+eiz*1+0x99],0x7' );
  TestCase.testcase(3069, [$C4,$E3,$59,$4A,$B4,$20,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eax+eiz*1+0x99],xmm0' );
  TestCase.testcase(3070, [$C4,$E3,$79,$20,$BC,$20,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eax+eiz*1+0x99],0x7'     );
  TestCase.testcase(3071, [$C5,$FD,$6F,$84,$20,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eax+eiz*1+0x99]'             );
  TestCase.testcase(3072, [$C5,$FD,$7F,$84,$20,$99,$00,$00,$00               ] , 'vmovdqa  yword [eax+eiz*1+0x99],ymm0'             );
  TestCase.testcase(3073, [$C4,$E2,$7D,$0D,$BC,$20,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eax+eiz*1+0x99]'      );
  TestCase.testcase(3074, [$C4,$E3,$7D,$09,$84,$20,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eax+eiz*1+0x99],0x7'        );
  TestCase.testcase(3075, [$C4,$E3,$7D,$19,$84,$20,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eax+eiz*1+0x99],ymm0,0x7'    );
  TestCase.testcase(3076, [$C4,$E3,$7D,$06,$BC,$20,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eax+eiz*1+0x99],0x7' );
  TestCase.testcase(3077, [$C4,$E3,$5D,$4B,$B4,$20,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eax+eiz*1+0x99],ymm0' );
  TestCase.testcase(3078, [$C5,$F8,$AE,$94,$60,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eax+eiz*2+0x99]'                 );
  TestCase.testcase(3079, [$C5,$F9,$6F,$84,$60,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eax+eiz*2+0x99]'             );
  TestCase.testcase(3080, [$C5,$F9,$7F,$84,$60,$99,$00,$00,$00               ] , 'vmovdqa  oword [eax+eiz*2+0x99],xmm0'             );
  TestCase.testcase(3081, [$C5,$F9,$7E,$84,$60,$99,$00,$00,$00               ] , 'vmovd  dword [eax+eiz*2+0x99],xmm0'               );
  TestCase.testcase(3082, [$C5,$FB,$2D,$84,$60,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eax+eiz*2+0x99]'            );
  TestCase.testcase(3083, [$C5,$FE,$E6,$84,$60,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eax+eiz*2+0x99]'           );
  TestCase.testcase(3084, [$C5,$FD,$5A,$84,$60,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eax+eiz*2+0x99]'           );
  TestCase.testcase(3085, [$C5,$F9,$E0,$BC,$60,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eax+eiz*2+0x99]'         );
  TestCase.testcase(3086, [$C4,$E3,$79,$DF,$84,$60,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eax+eiz*2+0x99],0x7' );
  TestCase.testcase(3087, [$C4,$E3,$79,$14,$84,$60,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eax+eiz*2+0x99],xmm0,0x7'          );
  TestCase.testcase(3088, [$C5,$FB,$2A,$BC,$60,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eax+eiz*2+0x99]'      );
  TestCase.testcase(3089, [$C4,$E3,$79,$44,$BC,$60,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eax+eiz*2+0x99],0x7' );
  TestCase.testcase(3090, [$C4,$E3,$59,$4A,$B4,$60,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eax+eiz*2+0x99],xmm0' );
  TestCase.testcase(3091, [$C4,$E3,$79,$20,$BC,$60,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eax+eiz*2+0x99],0x7'     );
  TestCase.testcase(3092, [$C5,$FD,$6F,$84,$60,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eax+eiz*2+0x99]'             );
  TestCase.testcase(3093, [$C5,$FD,$7F,$84,$60,$99,$00,$00,$00               ] , 'vmovdqa  yword [eax+eiz*2+0x99],ymm0'             );
  TestCase.testcase(3094, [$C4,$E2,$7D,$0D,$BC,$60,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eax+eiz*2+0x99]'      );
  TestCase.testcase(3095, [$C4,$E3,$7D,$09,$84,$60,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eax+eiz*2+0x99],0x7'        );
  TestCase.testcase(3096, [$C4,$E3,$7D,$19,$84,$60,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eax+eiz*2+0x99],ymm0,0x7'    );
  TestCase.testcase(3097, [$C4,$E3,$7D,$06,$BC,$60,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eax+eiz*2+0x99],0x7' );
  TestCase.testcase(3098, [$C4,$E3,$5D,$4B,$B4,$60,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eax+eiz*2+0x99],ymm0' );
  TestCase.testcase(3099, [$C5,$F8,$AE,$94,$98,$99,$00,$00,$00               ] , 'vldmxcsr  dword [eax+ebx*4+0x99]'                 );
  TestCase.testcase(3100, [$C5,$F9,$6F,$84,$98,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [eax+ebx*4+0x99]'             );
  TestCase.testcase(3101, [$C5,$F9,$7F,$84,$98,$99,$00,$00,$00               ] , 'vmovdqa  oword [eax+ebx*4+0x99],xmm0'             );
  TestCase.testcase(3102, [$C5,$F9,$7E,$84,$98,$99,$00,$00,$00               ] , 'vmovd  dword [eax+ebx*4+0x99],xmm0'               );
  TestCase.testcase(3103, [$C5,$FB,$2D,$84,$98,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [eax+ebx*4+0x99]'            );
  TestCase.testcase(3104, [$C5,$FE,$E6,$84,$98,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [eax+ebx*4+0x99]'           );
  TestCase.testcase(3105, [$C5,$FD,$5A,$84,$98,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [eax+ebx*4+0x99]'           );
  TestCase.testcase(3106, [$C5,$F9,$E0,$BC,$98,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [eax+ebx*4+0x99]'         );
  TestCase.testcase(3107, [$C4,$E3,$79,$DF,$84,$98,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [eax+ebx*4+0x99],0x7' );
  TestCase.testcase(3108, [$C4,$E3,$79,$14,$84,$98,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [eax+ebx*4+0x99],xmm0,0x7'          );
  TestCase.testcase(3109, [$C5,$FB,$2A,$BC,$98,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [eax+ebx*4+0x99]'      );
  TestCase.testcase(3110, [$C4,$E3,$79,$44,$BC,$98,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [eax+ebx*4+0x99],0x7' );
  TestCase.testcase(3111, [$C4,$E3,$59,$4A,$B4,$98,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [eax+ebx*4+0x99],xmm0' );
  TestCase.testcase(3112, [$C4,$E3,$79,$20,$BC,$98,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [eax+ebx*4+0x99],0x7'     );
  TestCase.testcase(3113, [$C5,$FD,$6F,$84,$98,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [eax+ebx*4+0x99]'             );
  TestCase.testcase(3114, [$C5,$FD,$7F,$84,$98,$99,$00,$00,$00               ] , 'vmovdqa  yword [eax+ebx*4+0x99],ymm0'             );
  TestCase.testcase(3115, [$C4,$E2,$7D,$0D,$BC,$98,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [eax+ebx*4+0x99]'      );
  TestCase.testcase(3116, [$C4,$E3,$7D,$09,$84,$98,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [eax+ebx*4+0x99],0x7'        );
  TestCase.testcase(3117, [$C4,$E3,$7D,$19,$84,$98,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [eax+ebx*4+0x99],ymm0,0x7'    );
  TestCase.testcase(3118, [$C4,$E3,$7D,$06,$BC,$98,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [eax+ebx*4+0x99],0x7' );
  TestCase.testcase(3119, [$C4,$E3,$5D,$4B,$B4,$98,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [eax+ebx*4+0x99],ymm0' );
  TestCase.testcase(3120, [$C5,$F8,$AE,$94,$CC,$99,$00,$00,$00               ] , 'vldmxcsr  dword [esp+ecx*8+0x99]'                 );
  TestCase.testcase(3121, [$C5,$F9,$6F,$84,$CC,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [esp+ecx*8+0x99]'             );
  TestCase.testcase(3122, [$C5,$F9,$7F,$84,$CC,$99,$00,$00,$00               ] , 'vmovdqa  oword [esp+ecx*8+0x99],xmm0'             );
  TestCase.testcase(3123, [$C5,$F9,$7E,$84,$CC,$99,$00,$00,$00               ] , 'vmovd  dword [esp+ecx*8+0x99],xmm0'               );
  TestCase.testcase(3124, [$C5,$FB,$2D,$84,$CC,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [esp+ecx*8+0x99]'            );
  TestCase.testcase(3125, [$C5,$FE,$E6,$84,$CC,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [esp+ecx*8+0x99]'           );
  TestCase.testcase(3126, [$C5,$FD,$5A,$84,$CC,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [esp+ecx*8+0x99]'           );
  TestCase.testcase(3127, [$C5,$F9,$E0,$BC,$CC,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [esp+ecx*8+0x99]'         );
  TestCase.testcase(3128, [$C4,$E3,$79,$DF,$84,$CC,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [esp+ecx*8+0x99],0x7' );
  TestCase.testcase(3129, [$C4,$E3,$79,$14,$84,$CC,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [esp+ecx*8+0x99],xmm0,0x7'          );
  TestCase.testcase(3130, [$C5,$FB,$2A,$BC,$CC,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [esp+ecx*8+0x99]'      );
  TestCase.testcase(3131, [$C4,$E3,$79,$44,$BC,$CC,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [esp+ecx*8+0x99],0x7' );
  TestCase.testcase(3132, [$C4,$E3,$59,$4A,$B4,$CC,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [esp+ecx*8+0x99],xmm0' );
  TestCase.testcase(3133, [$C4,$E3,$79,$20,$BC,$CC,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [esp+ecx*8+0x99],0x7'     );
  TestCase.testcase(3134, [$C5,$FD,$6F,$84,$CC,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [esp+ecx*8+0x99]'             );
  TestCase.testcase(3135, [$C5,$FD,$7F,$84,$CC,$99,$00,$00,$00               ] , 'vmovdqa  yword [esp+ecx*8+0x99],ymm0'             );
  TestCase.testcase(3136, [$C4,$E2,$7D,$0D,$BC,$CC,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [esp+ecx*8+0x99]'      );
  TestCase.testcase(3137, [$C4,$E3,$7D,$09,$84,$CC,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [esp+ecx*8+0x99],0x7'        );
  TestCase.testcase(3138, [$C4,$E3,$7D,$19,$84,$CC,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [esp+ecx*8+0x99],ymm0,0x7'    );
  TestCase.testcase(3139, [$C4,$E3,$7D,$06,$BC,$CC,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [esp+ecx*8+0x99],0x7' );
  TestCase.testcase(3140, [$C4,$E3,$5D,$4B,$B4,$CC,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [esp+ecx*8+0x99],ymm0' );
  TestCase.testcase(3141, [$C5,$F8,$AE,$94,$15,$99,$00,$00,$00               ] , 'vldmxcsr  dword [ebp+edx*1+0x99]'                 );
  TestCase.testcase(3142, [$C5,$F9,$6F,$84,$15,$99,$00,$00,$00               ] , 'vmovdqa  xmm0,oword [ebp+edx*1+0x99]'             );
  TestCase.testcase(3143, [$C5,$F9,$7F,$84,$15,$99,$00,$00,$00               ] , 'vmovdqa  oword [ebp+edx*1+0x99],xmm0'             );
  TestCase.testcase(3144, [$C5,$F9,$7E,$84,$15,$99,$00,$00,$00               ] , 'vmovd  dword [ebp+edx*1+0x99],xmm0'               );
  TestCase.testcase(3145, [$C5,$FB,$2D,$84,$15,$99,$00,$00,$00               ] , 'vcvtsd2si  eax,qword [ebp+edx*1+0x99]'            );
  TestCase.testcase(3146, [$C5,$FE,$E6,$84,$15,$99,$00,$00,$00               ] , 'vcvtdq2pd  ymm0,oword [ebp+edx*1+0x99]'           );
  TestCase.testcase(3147, [$C5,$FD,$5A,$84,$15,$99,$00,$00,$00               ] , 'vcvtpd2ps  xmm0,yword [ebp+edx*1+0x99]'           );
  TestCase.testcase(3148, [$C5,$F9,$E0,$BC,$15,$99,$00,$00,$00               ] , 'vpavgb  xmm7,xmm0,oword [ebp+edx*1+0x99]'         );
  TestCase.testcase(3149, [$C4,$E3,$79,$DF,$84,$15,$99,$00,$00,$00,$07       ] , 'vaeskeygenassist  xmm0,oword [ebp+edx*1+0x99],0x7' );
  TestCase.testcase(3150, [$C4,$E3,$79,$14,$84,$15,$99,$00,$00,$00,$07       ] , 'vpextrb  byte [ebp+edx*1+0x99],xmm0,0x7'          );
  TestCase.testcase(3151, [$C5,$FB,$2A,$BC,$15,$99,$00,$00,$00               ] , 'vcvtsi2sd  xmm7,xmm0,dword [ebp+edx*1+0x99]'      );
  TestCase.testcase(3152, [$C4,$E3,$79,$44,$BC,$15,$99,$00,$00,$00,$07       ] , 'vpclmulqdq  xmm7,xmm0,oword [ebp+edx*1+0x99],0x7' );
  TestCase.testcase(3153, [$C4,$E3,$59,$4A,$B4,$15,$99,$00,$00,$00,$00       ] , 'vblendvps  xmm6,xmm4,oword [ebp+edx*1+0x99],xmm0' );
  TestCase.testcase(3154, [$C4,$E3,$79,$20,$BC,$15,$99,$00,$00,$00,$07       ] , 'vpinsrb  xmm7,xmm0,byte [ebp+edx*1+0x99],0x7'     );
  TestCase.testcase(3155, [$C5,$FD,$6F,$84,$15,$99,$00,$00,$00               ] , 'vmovdqa  ymm0,yword [ebp+edx*1+0x99]'             );
  TestCase.testcase(3156, [$C5,$FD,$7F,$84,$15,$99,$00,$00,$00               ] , 'vmovdqa  yword [ebp+edx*1+0x99],ymm0'             );
  TestCase.testcase(3157, [$C4,$E2,$7D,$0D,$BC,$15,$99,$00,$00,$00           ] , 'vpermilpd  ymm7,ymm0,yword [ebp+edx*1+0x99]'      );
  TestCase.testcase(3158, [$C4,$E3,$7D,$09,$84,$15,$99,$00,$00,$00,$07       ] , 'vroundpd  ymm0,yword [ebp+edx*1+0x99],0x7'        );
  TestCase.testcase(3159, [$C4,$E3,$7D,$19,$84,$15,$99,$00,$00,$00,$07       ] , 'vextractf128  oword [ebp+edx*1+0x99],ymm0,0x7'    );
  TestCase.testcase(3160, [$C4,$E3,$7D,$06,$BC,$15,$99,$00,$00,$00,$07       ] , 'vperm2f128  ymm7,ymm0,yword [ebp+edx*1+0x99],0x7' );
  TestCase.testcase(3161, [$C4,$E3,$5D,$4B,$B4,$15,$99,$00,$00,$00,$00       ] , 'vblendvpd  ymm6,ymm4,yword [ebp+edx*1+0x99],ymm0' );
  TestCase.testcase(3162, [$C5,$F9,$50,$C0                                   ] , 'vmovmskpd  eax,xmm0'                              );
  TestCase.testcase(3163, [$C5,$C1,$72,$F0,$07                               ] , 'vpslld  xmm7,xmm0,0x7'                            );
  TestCase.testcase(3164, [$C5,$FC,$50,$C0                                   ] , 'vmovmskps  eax,ymm0'                              );
  TestCase.Stop();
  TestCase.SaveToFile('../../../log/x32.avx.log');
end;

end.