﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace MahApps.Metro.Controls
{
    /// <summary>
    /// Defines how the selected Items should be arranged for display
    /// </summary>
    public enum SelectedItemsOrderType
    {
        /// <summary>
        /// Displays the selected items in the same order as they were selected
        /// </summary>
        SelectedOrder,

        /// <summary>
        /// Displays the selected items in the same order as they are stored in the ItemsSource
        /// </summary>
        ItemsSourceOrder
    }
}