# 统一码名词汉化
苦于译名混乱，对统一码各种名词作汉化，如[Blocks-](https://www.unicode.org/Public/UCD/latest/ucd/Blocks.txt)[15.0.0.txt](https://www.unicode.org/Public/15.0.0/ucd/Blocks.txt)文件内区段名称，详见[Blocks.txt](/Blocks/Blocks.txt)。

关于某些ISO 15924 四字代码的汉化，另见[abbr：区段名不用的ISO代码表格](/abbr#区段名不用字符名或可用)。

## 勘误
Tagbanwa例字“ᝦᝤᝪᝨᝯ”遗漏了3个附标，但还有附标截至15.1版未收录，勉强作“ᝦᝲᝤᝪᝨᝯ”也不准确，文本暂时不改。

## 更新
- 第2版：和英文一样不区分“某”文\字、“某”字母、“某”语的文字。据[Unicode Standard 译介尝试（一）・文种名、符号名与块名](https://zhuanlan.zhihu.com/p/240087278)（下略称“尝试”）修正大量译名，少量参考《GB/T 34836-2017 信息与文献　文字名称表示代码》（下略称“GB/T”）。更新对译表，改动之处见注释。
  - 2.1版，2021-1-5，更正为“阿拉伯数学字母符号”
- 第3版：就[cv8280047 - 哔哩哔哩](https://www.bilibili.com/read/cv8280047#reply3919855387)评论区讨论结果修改存疑部分。
  - 3.1版，更正为“图符”
- 第4版：添加统一码14.0新增区段，及改动区段范围：阿含扩到..1174F，西夏补充修正为..18D7F（[13.0.0勘误：2020-3-11](https://www.unicode.org/versions/Unicode14.0.0/erratafixed.html)，该错误导致字体[Last](../../../../Unicode#monu-last)发布延迟）。略译文件开头注释。
  - 4.1版：就[Kushim-Jiang/Zhuanlan-Zhihu/006](https://github.com/Kushim-Jiang/Zhuanlan-Zhihu/tree/master/006)更新内容修改。
  - 4.2版：就[有哪些语言学术语翻译得并不恰当？ - 知乎](https://www.zhihu.com/answer/2076356395)内容修改。
- 第5版：添加统一码15.0新增区段，改动部分区段范围，修改译名：那巴泰 → 奈伯特、王朝阿拉姆 → 帝国阿拉姆、…象形文字 → …意音文字，等。
- 第6版，2023-1-15：改善和添加示例。此页补充平面翻译。追加规划版[Blocks-roadmap.txt](/Blocks/Blocks-roadmap.txt)。
  - 6.1版：修正规划版区段范围。补充有 ISO 15924 代码的规划外译名。
  - 6.2版：彝文例字改为“ꆈꌠꁱꂷ”，等；补充“第十平面”🥴
- 第7版，2023-4-12：据[SMP规划15.0.2](https://www.unicode.org/roadmaps/smp/smp-15-0-2.html)更新规划版.txt，添加例字“𖹝𖹰𖹯𖹼𖹫 𖹚𖹬𖹾𖹠𖹯 ([Obɛri Ɔkaimɛ](https://www.omniglot.com/writing/medefaidrin.htm))”
  - 7.1版，2023-4-15：小更正，此页补充 GB18030-2022 第6页7.3四字节部分名称（下略称“GB’22”）。同日发布[Last 8](https://github.com/MY1L/Unicode/releases/tag/Last8).10版。
  - 7.2版：添加例字“ࡓࡀࡈࡍࡀ” “ᜱᜨᜳᜨᜳᜢ” “ᝊᝓᝑᝒ” “ᝦᝤᝪᝨᝯ” “[ᤕᤠᤰᤌᤢᤱ ᤐᤠᤴ](https://www.omniglot.com/writing/limbu.htm)” “ᥖᥭᥰᥖᥬᥳᥑᥨᥒᥰ” “ᦅᧄᦺᦑᦟᦹᧉ” “ᨕᨘᨁᨗ” “ᬩᬲᬩᬮᬶ” “𐐔𐐯𐑅𐐨𐑉𐐯𐐻”。
- 第8版，2023-4-23：修正，添加例字“[ᨲ᩠ᩅᩫᨵᩢᨾ᩠ᨾ᩼](https://en.wikipedia.org/wiki/Tai_Tham_script)” “ᮞᮥᮔ᮪ᮓ” “ᯅᯖᯂ᯲” “[ᰛᰩᰵᰛᰧᰵᰶ](https://www.omniglot.com/writing/lepcha.htm)” “[⠠⠃⠗⠇](https://www.brailletranslator.org/)” “ⰳⰾⰰⰳⱁⰾⰹⱌⰰ” “ⲘⲉⲧⲢⲉⲙ̀ⲛⲭⲏⲙⲓ” “ⵜⵉⴼⵉⵏⴰⵖ” “ꕙꔤ” “[ꛀꛣꚧꚳ](https://www.omniglot.com/writing/bamumsyllabary.htm)” “ꠍꠤꠟꠐꠤ (西洛蒂 ~~(城体)~~ )” “ꢱꣃꢬꢵꢰ꣄ꢜ꣄ꢬ” “ꤜꤟꤤ꤬ ( ~~(克耶)~~ 利)” “ꤽꥍꤺꥏ” “ꦗꦮ” “ꨌꩌ” “ꪎꪳ ꪼꪕ” “ꯃꯤꯇꯩ ꯃꯌꯦꯛ” “𐊗𐊕𐊐𐊎𐊆𐊍𐊆 (trm̃mili)” “𐌲𐌿𐍄𐌹𐍃𐌺𐌰 (Gutiska)” “𐑖𐑱𐑝𐑾𐑯” “[𐒋𐒘𐒈𐒑𐒛𐒒𐒕𐒀](https://www.omniglot.com/writing/somali.htm#osmanya)” “𐓏𐒰𐓓𐒰𐓓𐒷 (Wažáže)” “𐔇𐔐𐔁𐔀𐔛𐔀𐔓𐔍𐔝 ([Elbasanit](https://en.wikipedia.org/wiki/Elbasan_script))” “[𐕲𐖻𐖶𐖨𐖷𐖰𐖥](https://en.wikipedia.org/wiki/Vithkuqi_script)” “𐡀𐡓𐡌𐡉𐡀 (arāmāyā)” “𐢕𐢂𐢋𐢈 (奈伯特)” “𐣤𐣵𐣣𐣭 (哈特拉)” “𐤊𐤍𐤀𐤍𐤌 ([迦南](https://www.omniglot.com/writing/phoenician.htm))” “𐤮𐤱𐤠𐤭𐤣𐤶𐤯𐤦𐤳 (sfardẽtiš)” “𐨑𐨪𐨆𐨯𐨠𐨁 (Kharoṣṭhī)” “𐩣𐩯𐩬𐩵 (ms³nd)” “𐬛𐬍𐬥 𐬛𐬀𐬠𐬌𐬫𐬭𐬵 ([Avestan?](https://www.omniglot.com/writing/avestan.htm))” “𐭯𐭠𐭫𐭮𐭩𐭪 (Pārsīk)” “𐴌𐴗𐴥𐴝𐴙𐴚𐴒𐴙𐴝 (rwâyṅgya)” “𐺨𐺦𐺏𐺨𐺋𐺨 (Yazidi?)” “𐿯𐿫𐿩𐿬𐿠𐿪 (Elymaic?)” “𑀩𑁆𑀭𑀸𑀳𑁆𑀫𑀻” “𑂍𑂶𑂟𑂲” “𑃐𑃦𑃝𑃗 𑃐𑃦𑃖𑃣𑃗” “𑄌𑄋𑄴𑄟𑄳𑄦” “𑅬𑅱𑅐𑅛𑅧𑅑” “𑆯𑆳𑆫𑆢𑆳” “𑈉𑈲𑈐𑈈𑈮” “𑊠𑊂𑊣𑊖𑊀𑊚𑊁” “𑊻𑋩𑋣𑋏𑋠𑋔𑋠𑋏𑋢” “𑌗𑍍𑌰𑌨𑍍𑌥” “𑐣𑐾𑐰𑐵𑑅” “𑒞𑒱𑒩𑒯𑒳𑒞𑒰” “𑘦𑘻𑘚𑘲” “𑚔𑚭𑚊𑚤𑚯” “𑜒𑜑𑜪𑜨” “𑠖𑠵𑠌𑠤𑠬” “𑢹𑣗𑣁𑣜𑣊 𑢯𑣂𑣕𑣂” “𑤝𑤱𑤩𑤴𑤬𑤽 𑤥𑤌𑤳𑤧𑤳” “𑧁𑧞𑦿𑧒𑧁𑧑𑦰𑧈𑧓” “𑨢𑨆𑨏𑨳𑨋𑨆𑨬𑨳” “𑪁𑩖𑩻𑩖𑪌𑩰𑩖” “𑰥𑰹𑰎𑰿𑰬𑰲𑰎𑰱” “𑴤𑴫𑴦𑴱𑴤 𑴎𑴽𑵀𑴘𑴳” “𑵶𑶓𑶕𑶂𑶋 𑵵𑶋𑶅𑶋” “𑻪𑻢𑻪𑻢 (Jangang-jangang)” “𑼒𑼮𑼶” “𖩃𖩓𖩑” “𖪰𖩵𖪂𖪫𖩸” “𖫔𖫧𖫱𖫒𖫨𖫴 𖫣𖫧𖫱” “𖬖𖬰𖬝𖬵 𖬄𖬶𖬟 𖬌𖬣𖬵” “𘱿𘱤” “[𞄀𞄄𞄰𞄩](https://zh.wikipedia.org/wiki/創世紀苗文) ( ~~(创世)~~ 苗)” “𞊒𞊪𞊒𞊪” “𞋒𞋀𞋉𞋃𞋕” “𞓧𞓟𞓨𞓜𞓕𞓣𞓚 ( ~~(纳格)~~ 蒙达里)” “𞠗𞢱 𞠀𞠁𞠂 (Mɛɛnde Ki-ka-ku)” “𞤀𞤣𞤤𞤢𞤥 (ADLaM)”。**注意**某些引号内文字是自右向左的。
  - 8.0版志在补全各区段以本区段字符自称，除了科普特必须用1个变音标记不够完美，其它都达成了目标（不计空格）
    - 以上例字有注释或带链接的表示该文字自称与统一码取名差异较大，例如Lepcha使用者自称用语名为“Róngríng”。
    - 顺带尝试 [线形乙\塞浦路斯 机翻](https://linear-b.kinezika.com/) 译“linear 2”获得“l𐀂𐀚𐀀𐄈”、译“cypriot”获得“cyr𐠂𐠃”显然不对。
    - 如有误请指出：我不确定巴尔米拉例字是否是“[𐡶𐡣𐡬𐡥𐡴](https://www.omniglot.com/writing/palmyrene.htm) (t_d_m_w_r)”、突厥是否是“[𐰜𐰇𐰛](https://www.omniglot.com/writing/orkhon.htm) (oek_oe_aek)”，自己拼的。花剌子模“[𐾳𐾲𐾲𐿋𐾲𐾲𐾽𐾻](https://en.wikipedia.org/wiki/Khwarezmian_language)”例字中的“𐿋”是数字100，可疑。古北阿拉比亚应该不是“[𐪀𐪁𐪂𐪃𐪄](https://www.omniglot.com/writing/northarabian.htm) (h_l_ḥ_m_q)”。注意到[维基上有人似乎传了错误的回鹘例字](https://en.wikipedia.org/wiki/File:Uighur_native_name.svg)。
  - 8.1版：将7.2版添的八思巴例字更正为“ꡖꡍꡂꡛ ꡌ”
- 第9版，2023-5-20：更新SIP、TIP平面规划版区段。
- 第10版，2023-10-1：更新至统一码15.1版、补充SMP大区翻译、据[SMP规划15.0.3](https://www.unicode.org/roadmaps/smp/smp-15-0-3.html)更新规划版.txt，等。
  - 10.1版：几处小更正。
  - 10.2版：添加2个格鲁吉亚区段例字“[ᲛᲮᲔᲓᲠᲣᲚᲘ](https://www.omniglot.com/writing/mkhedruli.htm)” “[ⴌⴓⴑⴞⴓⴐⴈ](https://www.omniglot.com/writing/nuskhuri.htm)”
  - 10.3版：更新SMP平面规划版区段（v15.1.1）
  - 10.4版：更新SMP平面规划版区段（v15.1.2）

## 对译表
我推敲统一码取名不一定用英文原本含义，因此下列词组优先于词，已用 *着重样式* 标出。

|原文|译文|注释|
| -: | :- | - |
|Additional|追加||
|Alphabetic|字母||
|Alphanumerics|字母数字||
|*Ancient* Greek|古希腊||
|Ancient|古代|实际多为古罗马……|
|and|及||
|Arrows|箭头||
|*Block* Elements|方块构素|作区段名时不译“区段”|
|Block|区段|不译“区块”|
|Box Drawing|制表符||
|Character(s)|字符||
|CJK|汉字／中日韩||
|CodePoint|码位||
|Combining|结合|曾译“组合”|
|Common／General|通用|General曾译“常用”|
|Compatibility|兼容||
|Components|偏旁||
|Control|控制||
|Controls|控制符||
|Cuneiform|楔形／楔形文字||
|Cursive|草书体|不译“世俗体”(Demotic)|
|Description|描述||
|Diacritical|变音||
|Dingbats|什锦||
|Enclosed|附围|带圈或围括号或附标……|
|Emoji|绘文字|日文“絵文字”|
|Extended／Extensions|扩充|曾译“扩展”|
|Form(s)|形式||
|Format|格式|见cv8280047评论区|
|Hieroglyph(s)|圣书体／意音文字|不译“象形文字”：[黑之圣雷](https://www.zhihu.com/question/480891401)反对|
|Ideograms／Ideographic|表意／表意文字||
|Legacy Computing|遗留电脑|Legacy曾译“传统”，Computing不译“计算”|
|Letters|字／字母||
|Linear|线形／线形文字|不译“线性文字”|
|Marks|标记||
|Mathematical|数学||
|Miscellaneous|各式|曾译“杂项”|
|Modifier Tone Letters|声调修饰字|语序调整|
|Modifier|修饰||
|Musical Notation|音符|Note“音符”，Notation“谱”|
|Musical Symbols|乐符||
|Counting Rod *Numerals*|算筹|“算筹”已含数字涵义|
|Number(s)／Numeral(s)|数字|Numbers不必区分为“数量”|
|Operators|运算符||
|Patterns|点字|仅限描述盲文|
|Phonetic|音标||
|Playing Cards|扑克|亦译“纸牌”，但语感似泛指纸质牌而不用|
|Pictographs|象形|这才是“象形文字”吧……|
|Pictographic|图形||
|Pictures|图符|曾译“图形”|
|Presentation|表现|曾译“表达”，“尝试”译“显现”|
|Proto-|原始||
|Punctuation|标点||
|Radicals|部首||
|Roadmap|规划|亦译“路线图”|
|Selectors|选择符||
|Shorthand|速记||
|SignWriting|手语|“GB/T”|
|Spacing|有距|直译“间距”，指字符相对同形结合标记而言左右有间距|
|Strokes|笔画||
|Extensions *Supplement*|扩充增补|只是“扩充补充”比较傻，曾译“补遗”|
|Supplement|补充|后置|
|Supplemental／Supplementary|增补|前置|
|Surrogates|替代|或译“代理(对)”（Surrogate Pair）|
|Syllabics|音节|音节文字|
|*Marks* for *Symbols*|记号||
|Hexagram *Symbols*|六十四卦|“卦”已含符号涵义|
|Tai Xuan Jing *Symbols*|太玄经卦爻|存在此称谓|
|Symbols|符／符号||
|Technical|技术符|不完全是“工业”|
|Tiles|牌|牌面和牌背都有|
|Unified|统一||
|Variants／Variation|变体||
|zone||暂译“大区”，含多个区段|

## 双标
这些译法例外。

|原称|译称|注释|
| -: | :- | - |
|Duployan|杜普雷速记|字客网译“杜洛耶速记”，“尝试”按法语Duployé译“迪普卢瓦耶”|
|Ethiopic|埃塞|直译“埃塞俄比亚”，但区段收的是ግዕዝ([格厄兹字母](https://www.zhihu.com/topic/21821106/hot))|
|Hangul Jamo|谚文字母|直译“韩文字母”，但有朝鲜|
|Lisu|傈僳(老)|直译“傈僳”，但区段收的是缅甸克伦族传教士Sara Ba Thaw创制的老傈僳文，亦名“富能仁文”(Fraser)，“GB’22”作“傈僳文”|
|Miao|苗(老)|直译“苗”，但区段收的是传教士柏格理(Pollard，ISO 15924：Plrd)等人创制的滇东北**老苗文**，“GB’22”作“滇东北苗文”|
|Pahawh Hmong|帕皓苗|直译“字母表苗”，“尝试”译“帕皓苗”，“GB/T”译“苗文”，异名“救世苗文”欠考据|
|Nyiakeng Puachue Hmong|苗(创世)|直译“创世完成苗\创世纪苗文”（[Hmnp.該怎麼翻譯？](https://www.ubuntu-tw.org/modules/newbb/viewtopic.php?post_id=361148)），“尝试”译“涅该布瓦启苗”|
|Old Turkic<br>Old Uyghur|突厥<br>回鹘|没有“(今)突厥”了<br>“回鹘”亦同|
|New Tai Lue|新傣仂|“尝试”曾译“新傣泐”，据[我们的文字](http://www.nlc.cn/cmptest/wmdwz/ssmz/index_11.htm)：古代傣族称西双版纳为“泐”，“GB’22”作“西双版纳新傣文”|
|Tai Le|傣㐻|“GB’22”作“德宏傣文”|
|Tai Tham|傣昙|即“(老)傣泐文”，“GB’22”作“西双版纳老傣文”|
|Yi ~|彝文~|直译“彝”，“GB’22”作“彝文”，但区段收的是[ꆈꌠꁱꂷ](https://www.zhihu.com/question/557581075 "请问各位这是什么文字？ - 知乎")竖式819个凉山规范彝文（横式顺时针旋转90°，[也有例外](https://www.douban.com/note/653171942/)，竖式笔势写着比较怪）可参见我归纳的[各式(非凉山)彝文列表](https://github.com/MY1L/Unicode/discussions/6)<br>凉山当地彝族自称ꆈꌠ(诺苏，ꆈ-黑 ꌠ-人)，据说泛彝语族(傈僳、哈尼…)自称为ꆀ，ꆀ是ꆈ的音变|

#### 序数对译
甲乙丙丁戊己庚辛壬癸子丑寅卯辰巳午未申酉戌亥物天地人\
ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ

用“天、地、人、物”代字母的做法源自李善兰译《代数学》，其参考朱世杰《四元玉鉴》(1303年)——如“一元二次方程”那样，「元」指未知数源于宋元“天元术”，未知数为“天”元，常数项为“太”极……\
相关例图和介绍：[清朝以前的微积分、代数用汉字黑体试作](https://www.bilibili.com/read/cv27076507/)

## 平面
~~或译“飞机”~~。统计截至统一码15.0.0版：

|#|简称|原称|译称|略称|别称|区数|字数|余数|
| -: | -: | -: | - | - | - | -: | -: | -: |
|0|BMP|Basic Multilingual Plane|基本多文种平面|基本平面|-|161|62034|1420|
|1|SMP|Supplementary Multilingual Plane|增补多文种平面|第一平面|多文种辅助平面|151|23276|42258|
|2|SIP|Supplementary Ideographic Plane|增补表意平面|第二平面|汉字辅助平面|6|60873|4661|
|3|TIP|Tertiary Ideographic Plane|第三表意平面|第三平面|汉字第三平面|2|9131|56403|
|4~9|-|-|-|-|-|0|0|65534|
|A|-|“[国标18030-2022平面](https://zi.tools/?secondary=character_set&set=GB18030)”|-|第十平面|-|?|63?|6489?|
|B~D|-|-|-|-|-|0|0|65534|
|E|SSP|Supplementary Special-purpose Plane|增补殊用平面|-|特殊用途平面|2|337|65197|
|F|PUA-A|Supplementary Private Use Area-A|增补私用区甲|私用区增甲|-|1|65534|0|
|10|PUA-B|Supplementary Private Use Area-B|增补私用区乙|私用区增乙|-|1|65534|0|

> 以下图一乐。\
据《滇川黔桂彝文字集》，目前记录在册的古彝文多达87046个。从总量上看，未经整理规范的古彝文字符数高达八万七千多个。——扬子晚报\
假设上述属实，又假设统一码收录古彝文，那么需要2个平面，则可拟名“Yi Ideographic Plane｜彝文表意平面甲、乙”，简称“YIP-A、B”，（虽不允许）不知“古彝文区段”能否开跨平面区段之先河🥴\
参见：[Unicode 收錄傳統上的彝文的話，是在涼山彝文的基礎上補全好，還是另開新區好？ - 知乎](https://www.zhihu.com/question/276373846) “在Unicode的问题上，2007年提交一份9万字符的方案”

#### 大区
第二、三平面目前都是汉字不分区。也许是基本平面分区较乱，第一平面暂规划大区如下：

|范围|原文|译文|
| -: | -: | - |
|10000-107FF|Alphabetic and syllabic LTR scripts and sets of symbols|左起的字母、音节文字及符号集|
|10800-10FFF|Alphabetic and syllabic RTL scripts|右起的字母、音节文字|
|11000-11FFF|Brahmic scripts|婆罗米系文字|
|12000-12FFF|Cuneiform and other ancient scripts|楔形文字及其它古文字|
|13000-14FFF|Egyptian and Anatolian hieroglyphic scripts|埃及、安纳托利亚意音文字|
|15000-15FFF|Other large scripts|其它大字汇文字|
|16000-16FFF|Recently-devised scripts|新设计的文字|
|17000-1BBFF|Large East Asian scripts|大字汇东亚文字|
|1BC00-1BCFF|Shorthands|各种速记|
|1BD00-1CEFF|Other large scripts|其它大字汇文字 之二|
|1CF00-1DFFF|Notational systems|记号系统|
|1E000-1E7FF|Alphabetic and syllabic LTR scripts|左起的字母、音节文字|
|1E800-1EFFF|RTL scripts and numeric systems|右起的文字、数字系统|
|1F000-1F0FF|Game symbols|棋牌符号|
|1F100-1F2FF|Alphanumeric and ideographic sets|字母数字、表意文字集|
|1F300-1FBFF|Pictographic sets and miscellaneous symbols|图形符号集、各式符号|
|1FC00-1FFFD|unallocated|未分配|

## 图外
- Visible Speech
  - <sup>ISO 15924</sup>`Visp`	`280`	`Visible Speech`
  - 钟雨柔：“**可视语音**”:汉字革命与字母普遍主义在中国
  - 这是类似音标的非语言，且没有主流语言用它作为文字。
- Klingon
  - <sup>ISO 15924</sup>`Piqd`	`293`	`Klingon (KLI pIqaD)`
  - KLI：[Klingon Language Institute](http://klingon.wiki/En/KlingonLanguageInstitute)（克林贡语言学院）的缩写，可简称“克语”
- Sarati
  - <sup>ISO 15924</sup>`Sara`	`292`	`Sarati`
  - https://lotr.huijiwiki.com/wiki/萨拉提