"""add action

Revision ID: e7339aab6549
Revises: 283e8cbdf17a
Create Date: 2024-02-23 15:55:52.440984

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel


# revision identifiers, used by Alembic.
revision: str = "e7339aab6549"
down_revision: Union[str, None] = "283e8cbdf17a"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "action",
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("null"), nullable=True),
        sa.Column("id", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("description", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("openapi_schema", sa.JSON(), nullable=True),
        sa.Column("authentication", sa.JSON(), nullable=True),
        sa.Column("extra", sa.JSON(), nullable=True),
        sa.Column("metadata", sa.JSON(), nullable=True),
        sa.Column("operation_id", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("url", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("method", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("path_param_schema", sa.JSON(), nullable=True),
        sa.Column("query_param_schema", sa.JSON(), nullable=True),
        sa.Column("body_param_schema", sa.JSON(), nullable=True),
        sa.Column("body_type", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("function_def", sa.JSON(), nullable=True),
        sa.Column("object", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("use_for_everyone", sa.Boolean(), default=False, nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.add_column("run", sa.Column("extra_body", sa.JSON(), nullable=True))
    op.execute(
        " ALTER TABLE token_relation MODIFY COLUMN relation_type enum('Assistant','File','Thread','Action') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;"
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("action")
    op.drop_column("run", "extra_body")
    op.execute(
        "ALTER TABLE token_relation MODIFY COLUMN relation_type enum('Assistant','File','Thread') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;"
    )
    # ### end Alembic commands ###
