"""empty message

Revision ID: 283e8cbdf17a
Revises: 6db192bc124b
Create Date: 2024-01-25 15:41:50.410216

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel


# revision identifiers, used by Alembic.
revision: str = '283e8cbdf17a'
down_revision: Union[str, None] = '6db192bc124b'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('token',
    sa.Column('id', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text('null'), nullable=True),
    sa.Column('llm_base_url', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('llm_api_key', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('description', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('assistant_token', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('token_relation',
    sa.Column('id', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text('null'), nullable=True),
    sa.Column('token_id', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('relation_type', sa.Enum('Assistant', 'File', 'Thread', name='relationtype'), nullable=False),
    sa.Column('relation_id', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('token_relation')
    op.drop_table('token')
    # ### end Alembic commands ###
