# AI实战-[practicalAI](https://github.com/LisonEvf/practicalAI-cn) 中文版
[![Colab](https://img.shields.io/badge/launch-Google%20Colab-orange.svg)](https://colab.research.google.com/)
[![MIT](https://img.shields.io/badge/license-MIT-brightgreen.svg)](https://github.com/LisonEvf/practicalAI-cn/blob/master/LICENSE)
[![Author](https://img.shields.io/badge/Author-GokuMohandas-blue.svg)](https://github.com/GokuMohandas)
[![Fork](https://img.shields.io/badge/Fork-MLEveryday/practicalAI--cn-yellow.svg)](https://github.com/MLEveryday/practicalAI-cn)

让你有能力使用机器学习从数据中获取有价值的见解。
- 🔥 使用 [PyTorch](https://pytorch.org/) 实现基本的机器学习算法和深度神经网络。
- 🖥️ 不需要任何设置，在浏览器中使用 [Google Colab](https://colab.research.google.com/) 运行所有程序。
- 📦 不仅仅是教程，而是学习产品级的面向对象机器学习编程。

## Notebooks
|基础|深度学习|进阶|主题|
|-|-|-|-|
|📓 [Notebooks](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/00_Notebooks.ipynb)|🔥 [PyTorch](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/07_PyTorch.ipynb)|📚 [高级循环神经网络 Advanced RNNs](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/14_Advanced_RNNs.ipynb)|📸 [计算机视觉 Computer Vision](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/15_Computer_Vision.ipynb)|
|🐍 [Python](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/01_Python.ipynb)|🎛️ [多层感知 Multilayer Perceptrons](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/08_Multilayer_Perceptron.ipynb)|🏎️ Highway and Residual Networks|⏰ 时间序列分析 Time Series Analysis|
|🔢 [NumPy](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/02_NumPy.ipynb)|🔎 [数据和模型 Data & Models](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/09_Data_and_Models.ipynb)|🔮 自编码器 Autoencoders|🏘️ Topic Modeling|
| 🐼 [Pandas](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/03_Pandas.ipynb) |📦 [面向对象的机器学习 Object-Oriented ML](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/10_Object_Oriented_ML.ipynb)|🎭 生成对抗网络 Generative Adversarial Networks|🛒 推荐系统 Recommendation Systems|
|📈 [线性回归 Linear Regression](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/04_Linear_Regression.ipynb)|🖼️ [卷积神经网络 Convolutional Neural Networks](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/11_Convolutional_Neural_Networks.ipynb)|🐝 空间变换模型 Spatial Transformer Networks|🗣️ 预训练语言模型 Pretrained Language Modeling|
|📊 [逻辑回归 Logistic Regression](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/05_Logistic_Regression.ipynb)|📝 [嵌入层 Embeddings](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/12_Embeddings.ipynb)||🤷 多任务学习 Multitask Learning|
|🌳 [随机森林 Random Forests](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/06_Random_Forests.ipynb)|📗 [递归神经网络 Recurrent Neural Networks](https://nbviewer.jupyter.org/github/LisonEvf/practicalAI-cn/blob/master/notebooks/13_Recurrent_Neural_Networks.ipynb)||🎯 Low Shot Learning|
|💥 k-均值聚类 KMeans Clustering|||🍒 强化学习 Reinforcement Learning|

## 查看 notebooks

如果不需要运行 notebooks，使用 Jupyter nbviewer 就可以方便地查看它们。

将 `https://github.com/` 替换为 `https://nbviewer.jupyter.org/github/` ，或者打开 `https://nbviewer.jupyter.org` 并输入 notebook 的 URL。

## 运行 notebooks
1. 在本项目的 [`notebooks`](/notebooks/) 文件夹获取 notebook；
2. 你可以在 Google Colab（推荐）或本地电脑运行这些 notebook；
3. 点击一个 notebook，然后替换URL地址中 `https://github.com/` 为 `https://colab.research.google.com/github/` ，或者使用这个 [Chrome扩展](https://chrome.google.com/webstore/detail/open-in-colab/iogfkhleblhcpcekbiedikdehleodpjo) 一键完成；
4. 登录你自己的 Google 账户；
5. 点击工具栏上的 `复制到云端硬盘`，会在一个新的标签页打开 notebook；

<img src="images/copy_to_drive.png">

5. 通过去掉标题中的`副本`完成 notebook 重命名；
6. 运行代码、修改等，所有这些都会自动保存到你的个人 Google Drive。

## 贡献 notebooks
1. 修改后下载 Google Colab notebook 为 .ipynb 文件；

<img src="images/download_ipynb.png">

2. 转到 https://github.com/LisonEvf/practicalAI-cn/tree/master/notebooks ；
3. 点击 `Upload files`.

<img src="images/upload.png">

5. 上传这个 .ipynb 文件；
6. 写一个详细详细的提交标题和说明；
7. 适当命名你的分支；
8. 点击 `Propose changes`。

<img src="images/commit.png">

## 贡献列表
欢迎任何人参与和完善。

|Notebook|译者|
|--|--|
|00_Notebooks.ipynb|[@amusi](https://github.com/amusi)|
|01_Python.ipynb|[@amusi](https://github.com/amusi)|
|02_NumPy.ipynb|[@amusi](https://github.com/amusi)|
|03_Pandas.ipynb|[@amusi](https://github.com/amusi)|
|04_Linear_Regression.ipynb|[@jasonhhao](https://github.com/jasonhhao)|
|05_Logistic_Regression.ipynb|[@jasonhhao](https://github.com/jasonhhao)|
|06_Random_Forests.ipynb|[@jasonhhao](https://github.com/jasonhhao)|
|07_PyTorch.ipynb|[@amusi](https://github.com/amusi)|
|08_Multilayer_Perceptron.ipynb|[@zhyongquan](https://github.com/zhyongquan)|
|09_Data_and_Models.ipynb|[@zhyongquan](https://github.com/zhyongquan)|
|10_Object_Oriented_ML.ipynb|[@zhyongquan](https://github.com/zhyongquan)|
|11_Convolutional_Neural_Networks.ipynb||
|12_Embeddings.ipynb|[@wengJJ](https://github.com/wengJJ)|
|13_Recurrent_Neural_Networks.ipynb||
|14_Advanced_RNNs.ipynb||
|15_Computer_Vision.ipynb|||
