# Delphi Code Coverage Wizard Code of Conduct

## 1. Purpose

A primary goal of Delphi Code Coverage Wizard is to be inclusive to the largest number of contributors. 
As such, we are committed to providing a friendly, safe and welcoming environment for all, regardless 
of gender, sexual orientation, ability, ethnicity, socioeconomic status, and religion (or lack thereof).

This code of conduct outlines our expectations for all those who participate in our community, as well as
the consequences for unacceptable behavior.

We invite all those who participate in Delphi Code Coverage Wizard to help us create safe and positive 
experiences for everyone.

## 2. Expected Behavior

The following behaviors are expected and requested of all community members:

 * Participate in an authentic and active way. In doing so, you contribute to the health and longevity of 
   this community.
 * Exercise consideration and respect in your speech and actions.
 * Attempt collaboration before conflict.
 * Refrain from demeaning, discriminatory, or harassing behavior and speech.
 * Be mindful of your surroundings and of your fellow participants. Alert community leaders if you notice 
   a dangerous situation, someone in distress, or violations of this Code of Conduct, even if they seem 
   inconsequential.
 
## 3. Unacceptable Behavior

The following behaviors are considered harassment and are unacceptable within our community:

 * Violence, threats of violence or violent language directed against another person.
 * Sexist, racist, homophobic, transphobic, ableist or otherwise discriminatory jokes and language.
 * Posting or displaying sexually explicit or violent material.
 * Posting or threatening to post other people's personally identifying information ("doxing").
 * Personal insults, particularly those related to gender, sexual orientation, race, religion, or disability.
 * Inappropriate photography or recording.
 * Inappropriate physical contact. You should have someone's consent before touching them.
 * Unwelcome sexual attention. This includes, sexualized comments or jokes; inappropriate touching, groping, 
   and unwelcomed sexual advances.
 * Deliberate intimidation, stalking or following (online or in person).
 * Advocating for, or encouraging, any of the above behavior.
 * Sustained disruption of community events, including talks and presentations.

## 4. Weapons Policy

Since this is a virtual community site no weapons policy is needed currently.
If a physical community event should be planned, a weapons policy will be created and enforced.

## 5. Consequences of Unacceptable Behavior

Unacceptable behavior from any community member, including sponsors and those with decision-making authority, 
will not be tolerated.

Anyone asked to stop unacceptable behavior is expected to comply immediately.

If a community member engages in unacceptable behavior, the community organizers may take any action they deem 
appropriate, up to and including a temporary ban or permanent expulsion from the community without warning 
(and without refund in the case of a paid event).

## 6. Reporting Guidelines

If you are subject to or witness unacceptable behavior, or have any other concerns, please notify a community 
organizer as soon as possible. 

Additionally, community organizers are available to help community members engage with local law enforcement or 
to otherwise help those experiencing unacceptable behavior feel safe. In the context of in-person events, 
organizers will also provide escorts as desired by the person experiencing distress.

## 7. Addressing Grievances

If you feel you have been falsely or unfairly accused of violating this Code of Conduct, you should notify  
with a concise description of your grievance. Your grievance will be handled in accordance with our existing 
governing policies. 

## 8. Scope

We expect all community participants (contributors, paid or otherwise; sponsors; and other guests) to abide by 
this Code of Conduct in all community venues--online and in-person--as well as in all one-on-one communications 
pertaining to community business.

## 9. Contact info

See NOTICE.txt from the project repository. Preferably contact the person marked as "main contact" in this file.

## 10. License and attribution

The Citizen Code of Conduct is distributed by "Team Delphi Code Coverage Wizard" under a [Creative Commons Attribution-ShareAlike license](http://creativecommons.org/licenses/by-sa/3.0/)
and it is based on the one from [Stumptown Syndicate].