/*
 Navicat Premium Data Transfer

 Source Server         : 192.168.0.6
 Source Server Type    : MySQL
 Source Server Version : 50733 (5.7.33)
 Source Host           : 192.168.0.6:3306
 Source Schema         : mcms

 Target Server Type    : MySQL
 Target Server Version : 50733 (5.7.33)
 File Encoding         : 65001

 Date: 29/09/2024 15:59:47
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for app
-- ----------------------------
DROP TABLE IF EXISTS `app`;
CREATE TABLE `app` (
  `id` varchar(20) NOT NULL COMMENT '站点id',
  `app_name` varchar(60) NOT NULL COMMENT '站点名称',
  `app_url` varchar(200) NOT NULL COMMENT '站点域名，多个回车换行显示',
  `app_logo` varchar(4000) DEFAULT NULL COMMENT '网站logo',
  `app_keyword` varchar(500) DEFAULT NULL COMMENT '站点关键字',
  `app_copyright` varchar(500) DEFAULT NULL COMMENT '站点版权信息',
  `app_style` varchar(50) DEFAULT NULL COMMENT '站点风格',
  `app_description` varchar(500) DEFAULT NULL COMMENT '描述',
  `app_pay` varchar(300) DEFAULT NULL COMMENT '费用清单',
  `app_state` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '0运行中 1已停止  ',
  `app_datetime` datetime DEFAULT NULL COMMENT '创建时间',
  `app_pay_date` datetime DEFAULT NULL COMMENT '应用续费时间',
  `app_dir` varchar(10) DEFAULT NULL COMMENT '网站生成的目录',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL,
  `del` int(1) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='应用表';

-- ----------------------------
-- Records of app
-- ----------------------------
BEGIN;
INSERT INTO `app` (`id`, `app_name`, `app_url`, `app_logo`, `app_keyword`, `app_copyright`, `app_style`, `app_description`, `app_pay`, `app_state`, `app_datetime`, `app_pay_date`, `app_dir`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES ('1', '5.4.2 铭飞MCms', 'http://localhost:8081/', '[{\"url\":\"/upload/1/appLogo/1609397756549.png\",\"name\":\"logo_small.png\",\"path\":\"/upload/1/appLogo/1609397756549.png\",\"uid\":1685699633311,\"status\":\"success\"}]', 'CMS,免费CMS,免费开源Java CMS,CMS系统,Java CMS,CMS内容管理系统,企业CMS,HTML网页模板,CMS模板,CMS源码,网站源码,信创系统软件,安可系统,网站建设,模板网站,建站模板,建站工具,建站平台,建站工具', '站点版权信息，可配置', 'default', '基于java开发的一套java cms，也是轻量级开源内容管理系统，CMS简洁、安全、开源、免费，可运行在Linux、Windows、MacOSX、Solaris等各种平台上，专注为公司企业、个人站长快速建站提供解决方案，铭飞MS平台为您提供各类cms网站模板下载,公司网站、企业网站模板、网站后台系统模板、免费网站模板,10年建站公司老品牌值得信赖的cms!', '', 0, NULL, '2019-11-17 00:00:00', 'web', '2024-02-01 16:29:30', '57', NULL, '', 0);
COMMIT;

-- ----------------------------
-- Table structure for cms_category
-- ----------------------------
DROP TABLE IF EXISTS `cms_category`;
CREATE TABLE `cms_category` (
  `id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL COMMENT '所属栏目',
  `leaf` int(1) DEFAULT NULL COMMENT '是否是叶子节点',
  `top_id` bigint(20) DEFAULT NULL COMMENT '顶级id',
  `dict_id` int(11) DEFAULT NULL COMMENT '字典对应编号',
  `mdiy_model_id` varchar(50) DEFAULT NULL COMMENT '文章管理的内容模型ID',
  `mdiy_category_model_id` varchar(50) DEFAULT NULL COMMENT '栏目管理的内容模型ID',
  `category_parent_ids` varchar(255) DEFAULT NULL COMMENT '父类型编号，多个id逗号',
  `category_title` varchar(255) DEFAULT NULL COMMENT '栏目管理名称',
  `category_img` varchar(2000) DEFAULT NULL COMMENT '栏目banner图',
  `category_ico` varchar(2000) DEFAULT NULL COMMENT '栏目小图',
  `category_short_title` varchar(255) DEFAULT NULL COMMENT '栏目副标题',
  `category_flag` varchar(255) DEFAULT NULL COMMENT '栏目属性',
  `category_display` varchar(50) DEFAULT NULL COMMENT '栏目是否显示',
  `category_is_search` varchar(50) DEFAULT 'enable' COMMENT '栏目是否被搜索',
  `category_descrip` varchar(500) DEFAULT NULL COMMENT '栏目管理描述',
  `category_keyword` varchar(300) DEFAULT NULL COMMENT '栏目管理关键字',
  `category_path` varchar(500) DEFAULT NULL COMMENT '栏目路径',
  `category_diy_url` varchar(255) DEFAULT NULL COMMENT '自定义链接',
  `category_url` varchar(50) DEFAULT NULL COMMENT '内容模板',
  `category_list_url` varchar(50) DEFAULT NULL COMMENT '列表模板',
  `category_type` varchar(10) DEFAULT NULL COMMENT '栏目管理属性',
  `category_pinyin` varchar(255) DEFAULT NULL COMMENT '栏目拼音',
  `category_sort` int(11) DEFAULT NULL COMMENT '自定义顺序',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='分类';

-- ----------------------------
-- Records of cms_category
-- ----------------------------
BEGIN;
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1329316146811314177, 1666653706550321152, 1, 1666653706550321152, NULL, NULL, NULL, '1666653706550321152', '平台产品', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', NULL, NULL, '', 'enable', 'enable', '公司产品', '', 'product/pingtaichanpin', '', 'product-detail.htm', 'product-list.htm', '1', 'pingtaichanpin', 0, '2022-09-09 14:37:47', '57', '2020-11-19 14:50:42', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321152, NULL, 0, 0, NULL, NULL, NULL, NULL, '公司产品', '[{\"url\":\"/upload/1/cms/category/1686219436865.jpg\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', 'PRODUCT', 'n', 'enable', 'enable', '公司产品', '', 'product', '', '', 'product-list.htm', '1', 'product', 1, '2023-06-29 09:57:13', '57', '2020-11-19 10:56:31', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321153, NULL, 0, 0, NULL, NULL, NULL, NULL, '新闻动态', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', NULL, 'n', 'enable', 'enable', '公司动态', '', 'news', '', '', 'news-list.htm', '1', 'news', 4, '2023-06-08 17:56:04', '57', '2020-11-19 10:56:47', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321154, NULL, 0, 0, NULL, NULL, NULL, NULL, '关于我们', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', NULL, 'n', 'enable', 'enable', '关于我们', '', 'gywm', 'gywm/gongsijieshao/index.html', '', '', '3', 'gywm', 6, '2023-06-08 15:56:35', '57', '2020-11-19 10:57:39', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321155, 1666653706550321154, 1, 1666653706550321154, NULL, NULL, NULL, '1666653706550321154', '联系我们', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', NULL, '', 'enable', 'enable', '关于我们', '', 'gywm/lianxiwomen', '', 'about.htm', '', '2', 'lianxiwomen', 0, '2023-06-08 13:39:36', '57', '2020-11-19 10:58:02', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321156, 1666653706550321152, 1, 1666653706550321152, NULL, '', NULL, '1666653706550321152', '开源产品', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', NULL, '', 'enable', 'enable', '公司产品', '', 'product/kycp', '', 'product-detail.htm', 'product-list.htm', '1', 'kycp', 0, '2023-06-08 15:44:25', '57', '2020-11-19 10:58:41', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321157, 1666653706550321152, 1, 1666653706550321152, NULL, NULL, NULL, '1666653706550321152', '行业产品', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', NULL, '', 'enable', 'enable', '公司产品', '', 'product/hycp', '', 'product-detail.htm', 'product-list.htm', '1', 'hycp', 0, '2023-06-08 15:45:19', '57', '2020-11-19 10:58:56', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321158, 1666653706550321153, 1, 1666653706550321153, NULL, NULL, NULL, '1666653706550321153', '公司动态', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', NULL, '', 'enable', 'enable', '公司动态', '', 'news/gsdt', '', 'news-detail.htm', 'news-list.htm', '1', 'gsdt', 0, '2023-06-08 15:46:09', '57', '2020-11-19 11:02:08', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321159, 1666653706550321153, 1, 1666653706550321153, NULL, NULL, NULL, '1666653706550321153', '行业动态', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', NULL, '', 'enable', 'enable', '行业动态', '', 'news/xingyedongtai', '', 'news-detail.htm', 'news-list.htm', '1', 'xingyedongtai', 0, '2023-06-08 15:46:22', '57', '2020-11-19 11:02:36', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321160, 1666653706550321154, 1, 1666653706550321154, NULL, NULL, NULL, '1666653706550321154', '公司介绍', '[{\"url\":\"/upload/1/cms/category/1686219436865.jpg\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', NULL, '', 'enable', 'enable', '关于我们', '', 'gywm/gongsijieshao', '', 'about.htm', '', '2', 'gongsijieshao', 0, '2023-06-08 18:26:10', '57', '2020-11-19 11:04:39', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321162, NULL, 1, 0, NULL, NULL, NULL, NULL, '幻灯', '[]', '[]', NULL, '', 'enable', 'enable', '', '', 'huandeng', '', '', '', '1', 'huandeng', 0, '2023-06-08 15:52:18', '57', '2020-11-19 17:34:10', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321163, NULL, 0, 0, NULL, '', '', NULL, '解决方案', '[{\"url\":\"/upload/1/cms/category/1686219436865.jpg\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[{\"url\":\"/upload/1/cms/category/1686032572679.jpg\",\"name\":\"1571617311885681.jpg\",\"path\":\"/upload/1/cms/category/1686032572679.jpg\",\"uid\":1686032572647,\"status\":\"success\"}]', '诚聘优秀人士加入我们的团队', 'n', 'enable', 'enable', '', '', 'jiejuefangan', '', 'product-detail.htm', 'product-list.htm', '1', 'jiejuefangan', 2, '2023-07-02 14:28:18', '57', '2023-06-06 14:20:42', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321164, NULL, 1, 0, NULL, '', '', NULL, '服务案例', '[{\"url\":\"/upload/1/cms/category/1686219436865.jpg\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', '服务创造价值、存在造就未来', 'n', 'enable', 'enable', '服务案例', '', 'fuwuanli', '', 'product-detail.htm', 'product-list.htm', '1', 'fuwuanli', 3, '2023-07-02 14:28:30', '57', '2023-06-06 14:21:08', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321165, NULL, 1, 0, NULL, '', '', NULL, '招聘信息', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', '', 'n', 'enable', 'enable', '招聘信息', '', 'zhaopinxinxi', '', 'about.htm', '', '2', 'zhaopinxinxi', 4, '2023-06-08 15:56:00', '57', '2023-06-06 14:21:27', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321166, 1666653706550321163, 1, 1666653706550321163, NULL, '', '', '1666653706550321163', '信创国产化解决方案', '[{\"url\":\"/upload/1/cms/category/1686219436865.jpg\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[{\"url\":\"blob:http://localhost:8080/1fe52e96-425e-47da-83de-a87accc79040\",\"name\":\"1609397756549.png .png\",\"path\":\"/upload/1/cms/category/1688006502514.png\",\"uid\":1688006502302,\"status\":\"success\"}]', '真正自研的中国云，坚持核心代码自主研发，产品经过工信部权威机构测评，完全符合可信标准。青云以中立开放的态度，深度参与信创生态建立， 适配各大信创生态。用户仅需一个平台，即可实现国产化替代、IT 架构升级及云原生升级等现实需求，青云以专业服务保障多行业、多场景的平稳运行。', '', 'enable', 'enable', '解决方案', '', 'jiejuefangan/zhihuiyiliaojiejuefangan', 'https://www.mingsoft.net/banben.html', 'about.htm', '', '2', 'zhihuiyiliaojiejuefangan', 0, '2023-06-29 10:41:44', '57', '2023-06-06 14:26:27', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321167, 1666653706550321163, 1, 1666653706550321163, NULL, '', '', '1666653706550321163', '低代码开发解决方案', '[{\"url\":\"/upload/1/cms/category/1686219436865.jpg\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[{\"url\":\"blob:http://localhost:8080/80e8107d-1623-4418-82e5-1656c8ce9d3f\",\"name\":\"1609397756549.png .png\",\"path\":\"/upload/1/cms/category/1688006545514.png\",\"uid\":1688006545446,\"status\":\"success\"}]', '真正自研的中国云，坚持核心代码自主研发，产品经过工信部权威机构测评，完全符合可信标准。青云以中立开放的态度，深度参与信创生态建立， 适配各大信创生态。用户仅需一个平台，即可实现国产化替代、IT 架构升级及云原生升级等现实需求，青云以专业服务保障多行业、多场景的平稳运行。', '', 'enable', 'enable', '解决方案', '', 'jiejuefangan/zhihuiyingyetingjiejuefangan', 'https://www.mingsoft.net/', 'about.htm', '', '2', 'zhihuiyingyetingjiejuefangan', 0, '2023-06-29 10:42:27', '57', '2023-06-06 14:27:03', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321168, NULL, 1, 0, NULL, '', '', NULL, '在线留言', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', '', 'n', 'enable', 'enable', '', '', 'zaixianliuyan', '', 'message.htm', '', '2', 'zaixianliuyan', 5, '2023-06-08 15:56:23', '57', '2023-06-06 14:54:46', '57', 0);
INSERT INTO `cms_category` (`id`, `category_id`, `leaf`, `top_id`, `dict_id`, `mdiy_model_id`, `mdiy_category_model_id`, `category_parent_ids`, `category_title`, `category_img`, `category_ico`, `category_short_title`, `category_flag`, `category_display`, `category_is_search`, `category_descrip`, `category_keyword`, `category_path`, `category_diy_url`, `category_url`, `category_list_url`, `category_type`, `category_pinyin`, `category_sort`, `update_date`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653706550321169, NULL, 1, 0, NULL, '', '', NULL, '合作伙伴', '[{\"url\":\"blob:http://localhost:8080/c88cc2d9-d543-496e-a178-66185908b7ae\",\"name\":\"1634799978903085.jpg\",\"path\":\"/upload/1/cms/category/1686219436865.jpg\",\"uid\":1686219436617,\"status\":\"success\"}]', '[]', '', '', 'enable', 'enable', '', '', 'hezuohuoban', '', '', '', '1', 'hezuohuoban', 0, '2023-06-08 15:51:53', '57', '2023-06-08 09:14:15', '57', 0);
COMMIT;

-- ----------------------------
-- Table structure for cms_content
-- ----------------------------
DROP TABLE IF EXISTS `cms_content`;
CREATE TABLE `cms_content` (
  `id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL COMMENT '所属栏目',
  `content_details` longtext COMMENT '文章内容',
  `content_title` varchar(255) DEFAULT NULL COMMENT '文章标题',
  `content_short_title` varchar(255) DEFAULT NULL COMMENT '文章副标题',
  `content_keyword` varchar(255) DEFAULT NULL COMMENT '关键字',
  `content_description` varchar(400) DEFAULT NULL COMMENT '描述',
  `content_img` varchar(2000) DEFAULT NULL COMMENT '文章缩略图',
  `content_source` varchar(255) DEFAULT NULL COMMENT '文章来源',
  `content_author` varchar(255) DEFAULT NULL COMMENT '文章作者',
  `content_display` varchar(10) DEFAULT '0' COMMENT '是否显示0显示 1不显示',
  `content_type` varchar(100) DEFAULT NULL COMMENT '文章类型',
  `content_datetime` timestamp NULL DEFAULT NULL COMMENT '发布时间',
  `content_sort` int(11) DEFAULT NULL COMMENT '自定义顺序',
  `content_tags` varchar(255) DEFAULT NULL COMMENT '文章标签',
  `content_hit` int(22) DEFAULT '0' COMMENT '点击次数',
  `content_out_link` varchar(255) DEFAULT NULL COMMENT '文章为链接',
  `has_detail_html` int(1) DEFAULT '0' COMMENT '文章静态化标识 0表示未被自动静态化,1反之',
  `update_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `has_list_html` int(1) DEFAULT '0' COMMENT '栏目静态化标识 0表示未被自动静态化,1反之',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `fk_category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文章';

-- ----------------------------
-- Records of cms_content
-- ----------------------------
BEGIN;
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653707267547136, 1666653706550321157, '<p><img src=\"/upload/1/cms/content/editor/1609809963757.png\" title=\"1609809963757.png\" alt=\"image.png\"/></p>', 'MEC工程造价咨询管理软件', NULL, '', '支持分公司、跨地域协同管理，支持微信审批、通知更即时，与钉钉一样的审批，让审批流程更简单', '[{\"url\":\"blob:http://localhost:8080/605fb4e4-7874-4f30-9eb6-87c8dc4b046f\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609837720097.png\",\"uid\":1609837720054,\"status\":\"success\"}]', '', '', '0', 'c', '2023-06-08 11:49:43', 0, NULL, 0, NULL, 0, '2023-06-08 11:49:43', 0, '57', '2023-06-08 11:49:43', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653707301101568, 1666653706550321157, '<p>1、BIM引擎</p><p>2、项目管理</p><p>3、计划管理</p><p>4、进度管理</p><p>5、质量管理</p><p>6、填报管理</p>', 'BIMCms施工管理软件', NULL, '', 'BIM数字化构件施工模型', '[{\"url\":\"blob:http://localhost:8080/e267453c-5762-40af-ba47-b7979e11421e\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609837616948.png\",\"uid\":1609837616874,\"status\":\"success\"}]', '', '', '0', 'c', '2023-06-08 11:49:44', 0, NULL, 0, NULL, 0, '2023-06-08 11:49:43', 0, '57', '2023-06-08 11:49:43', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653707418542080, 1666653706550321158, '<p><br/></p><ul style=\"box-sizing: border-box; margin-bottom: 0.85em; font-size: 14px; padding: 0px 0px 0px 2em; color: rgb(51, 51, 51); font-family: Roboto, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.3px; white-space: normal; background-color: rgb(250, 250, 250);\" class=\" list-paddingleft-2\"><li><p>【框架】增加MybatisPlus支持</p></li><li><p>【新增】静态化文件夹配置(html)</p></li><li><p>【新增】静态化站点文件夹配置(web)，html/1-&gt;自定义/自定义</p></li><li><p>【优化】模版管理修改</p></li><li><p>【优化】标签修改，更灵活的支持if等逻辑判断</p></li><li><p>【优化】解析速度再次提升</p></li><li><p>【优化】栏目管理操作功能优化</p></li><li><p>【优化】栏目生成链接优化，采用拼音格式</p></li><li><p>【修复】bug修复，具体参考开源中国ISSUES</p></li><li><p>5.1升级5.2.0步骤(1、同步代码；2、导入5.1-to-5.2.0-mysql.sql；3、Store更新内容插件)</p></li></ul><p><br/></p>', '5.2.0稳定版本发布', NULL, '', '', '[{\"url\":\"blob:http://localhost:8080/e246f0df-08a8-41e8-9494-17db1970ba0d\",\"name\":\"5.png\",\"path\":\"/upload/1/cms/content/1609825459624.png\",\"uid\":1609825459171,\"status\":\"success\"}]', '', '', '0', 'c', '2023-06-08 11:49:49', 0, NULL, 41, NULL, 0, '2023-06-08 11:49:43', 0, '57', '2023-06-08 11:49:43', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653707447902208, 1666653706550321158, '<p>http://doc.mingsoft.net/plugs-cms/</p>', 'mcms在线适用手册', NULL, '', 'MCms内容插件提供最基本的菜单、权限、角色、栏目、内容、静态化、等常用功能。', '[{\"url\":\"/upload/1/cms/content/1609835836996.png\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609835836996.png\",\"uid\":1609835836971,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:49:50', 0, '', 23, '', 0, '2023-09-28 16:33:22', 0, '57', '2023-06-08 11:49:43', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653707494039552, 1666653706550321159, '<p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">国内的开源环境已经相当好，但是国内开发注重是应用，创新有但不多，从榜单可以看出，专门搞技术的还是少数，结合项目实践的站大多数，分享给你们，架构的时候可以参考这些解决方案，传送门：gogeeks.cn</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">zheng征项目(stars 5.6k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">基于Spring+SpringMVC+Mybatis分布式敏捷开发系统架构，提供整套公共微服务服务模块：集中权限管理（单点登录）、内容管理、支付中心、用户管理（支持第三方登录）、微信平台、存储系统、配置中心、日志分析、任务和通知等，支持服务治理、监控和追踪，努力为中小型企业打造全方位J2EE企业级开发解决方案。</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000831977.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/shuzheng/zheng</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">JFinal(stars 4.8k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">JFinal 是基于 Java 语言的极速 WEB + ORM 框架，其核心设计目标是开发迅速、代码量少、学习简单、功能强大、轻量级、易扩展、Restful。在拥有Java语言所有优势的同时再拥有ruby、python、php等动态语言的开发效率！为您节约更多时间，去陪恋人、家人和朋友 :)</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832098.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：http://www.jfinal.com/</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">SpringBoot-Learning(stars 4.6k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">Spring Boot教程与Spring Cloud教程</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/didispace/SpringBoot-Learning</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">iBase4J(stars 4.1k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">AVA分布式快速开发平台：SpringBoot，SpringMVC，Mybatis，mybatis-plus，motan/dubbo分布式，Redis缓存，Shiro权限管理，Spring-Session单点登录，Quartz分布式集群调度，Restful服务，QQ/微信登录，App token登录，微信/支付宝支付；日期转换、数据类型转换、序列化、汉字转拼音、身份证号码验证、数字转人民币、发送短信、发送邮件、加密解密、图片处理、excel导入导出、FTP/SFTP/fastDFS上传下载、二维码、XML读写、高精度计算、系统配置工具类等等。</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832267.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/iBase4J/iBase4J</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">JeeSite(stars 3.1k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">JeeSite 是一个企业信息化开发基础平台，Java EE（J2EE）快速开发框架，使用经典技术组合（Spring、Spring MVC、Apache Shiro、MyBatis、Bootstrap UI），包括核心模块如：组织机构、角色用户、权限授权、数据权限、内容管理、工作流等。</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/thinkgem/jeesite</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">jeewx(stars 2.6k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">Jeewx是一款开源、免费的微信管家系统（多触点管理平台）。采用JAVA语言，支持微信公众号、微信企业号、支付宝服务窗、QQ公众号、微博账号等多触点管理。Jeewx实现了微信、支付窗、微信企业号、微博等触点的基础管理功能，便于用户二次开发。2014年荣获CSDN开发商大会第一名</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832393.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/jeecg/jeewx</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">MCMS建站系统（stars 2.5k）</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">完整开源！Java快速开发平台！基于Spring、SpringMVC、Mybatis架构，MStore提供更多好用的插件与模板（文章、商城、微信、论坛、会员、评论、支付、积分、工作流、任务调度等，同时提供上百套免费模板任意选择），价值源自分享！铭飞系统不仅一套简单好用的开源系统、更是一整套优质的开源生态内容体系。铭飞的使命就是降低开发成本提高开发效率，提供全方位的企业级开发解决方案，每月28定期更新版本</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832647.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/mingSoft/MCMS</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">t-io(stars 2.3k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">t-io是基于jdk aio实现的易学易用、稳定耐操、性能强悍、将多线程运用到极致、内置功能丰富、核心代码只有3000多行(2017年05月13号统计)的即时通讯框架(广义上的即时通讯，并非指im)，字母 t 寓意talent。</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832783.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/tywo45/t-io</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">CMS(stars 2.1k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">一款使用Java语言开发的CMS，使用了Spring MVC,Spring,MyBatis等流行框架，提供首页大图管理、目录管理、文章管理和管理员管理等功能。是学习和二次开发的首选</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000832990.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">地址：https://gitee.com/shishuo/CMS</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">hutool(stars 2k)</p><p style=\"margin: 10px auto; padding: 0px; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(245, 245, 245);\">一个Java基础工具类，对文件、流、加密解密、转码、正则、线程、XML等JDK方法进行封装，组成各种Util工具类，同时提供以下组件： 1. 布隆过滤 2. 缓存 3. 数据库ORM（基于ActiveRecord思想）4. HTTP客户端 5. IO 6. JSON 7. 日志 8. System（JVM和系统信息等） 9. Setting（一种扩展Properties的配置文件）</p><p><img class=\"large\" src=\"/upload/1/cms/content/editor/1610000833108.jpg\" alt=\"\" data-loadfunc=\"0\" data-loaded=\"0\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p><br/></p>', '国内最火的10款Java开源项目，都是国人开发，CMS居多', NULL, '', '价值源自分享！铭飞系统不仅一套简单好用的开源系统、更是一整套优质的开源生态内容体系。铭飞的使命就是降低开发成本提高开发效率，提供全方位的企业级开发解决方案，每月28定期更新版本', '[{\"url\":\"/upload/1/cms/content/1609835640813.jpeg\",\"name\":\"a.jpeg\",\"path\":\"/upload/1/cms/content/1609835640813.jpeg\",\"uid\":1609835640738,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:49:51', 0, NULL, 66, NULL, 0, '2023-06-08 11:49:43', 0, '57', '2023-06-08 11:49:43', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653707573731328, 1666653706550321160, '<p>&nbsp; &nbsp; &nbsp; 团队成立于2012年，是一群不断的以技术创新与软件研发为核心的学习型技术团队。团队在软件研发的技术领域，不断地积累通用、实用、好用的通用功能插件，实现系统模块化集成开发解决方案。方案适用于传统互联网、移动互联网、物联网，不仅大大降低软件产品在研发投入的成本，更能加快软件的研发进程！</p><p><br/></p><p><strong>使命：</strong>降低软件研发成</p><p><strong>价值观：</strong>价值源自分享</p><p><strong>愿景：</strong>享自由、享生活</p><p><br/></p>', '公司介绍', NULL, '关键字', '团队成立于2012年，是一群不断的以技术创新与软件研发为核心的学习型技术团队。团队在软件研发的技术领域，不断地积累通用、实用、好用的通用功能插件，实现系统模块化集成开发解决方案。方案适用于传统互联网、移动互联网、物联网，不仅大大降低软件产品在研发投入的成本，更能加快软件的研发进程！', '[{\"url\":\"/upload/1/cms/content/1609838258663.png\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609838258663.png\",\"uid\":1609838258513,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:49:52', 0, NULL, 0, NULL, 0, '2023-06-08 18:15:26', 0, '57', '2023-06-08 11:49:43', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653707686977536, 1666653706550321155, '<p><span style=\"color: rgb(127, 127, 127);\">TEL：</span>12345678901</p><p><br/></p><p><span style=\"color: rgb(127, 127, 127);\">客服QQ：</span>1234567890&nbsp; &nbsp; &nbsp;&nbsp;<span style=\"color: rgb(127, 127, 127);\">商务QQ：</span>1234567890</p><p><br/></p><p><span style=\"color: rgb(127, 127, 127);\">Email：</span>XXXXXX@XX.com</p><p><br/></p><p><span style=\"color: rgb(127, 127, 127);\">Addr：</span>北京市东城区天安门广场</p><p><br/></p><p><img width=\"530\" height=\"340\" src=\"http://api.map.baidu.com/staticimage?center=116.393541,39.902292&zoom=18&width=530&height=340&markers=116.393541,39.902292\"/></p><p><br/></p>', '联系我们', NULL, '', '', '', '', '', '0', '', '2023-06-08 11:49:53', 0, '', 0, '', 0, '2024-07-12 14:30:17', 0, '57', '2023-06-08 11:49:43', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653707733114880, 1666653706550321162, '', '降低软件研发成本', NULL, '', '', '[{\"url\":\"/upload/1/cms/content/1609838691084.png\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1609838691084.png\",\"uid\":1609838690980,\"status\":\"success\"}]', 'https://www.mingsoft.net', '', '0', 'f', '2023-06-08 11:49:55', 0, NULL, 1, NULL, 0, '2023-06-08 11:49:44', 0, '57', '2023-06-08 11:49:44', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653709796712448, 1666653706550321156, '<blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">当前版本</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://search.maven.org/search?q=ms-msend\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\"><img title=\"\" src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-msend.svg?label=Maven%20Central\" alt=\"\" width=\"134\" height=\"20\"/></a></p><pre class=\"brush:xml;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">&lt;dependency&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;ms-msend&lt;/artifactId&gt;\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">后台使用：<a href=\"http://doc.mingsoft.net/plugs/fa-song-cha-jian/jie-shao.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/fa-song-cha-jian/jie-shao.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">开放接口：<a href=\"http://doc.mingsoft.net/plugs/fa-song-cha-jian/ye-wu-kai-fa.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/fa-song-cha-jian/ye-wu-kai-fa.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">常见问题：<a href=\"http://doc.mingsoft.net/plugs/fa-song-cha-jian/chang-jian-wen-ti.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/fa-song-cha-jian/chang-jian-wen-ti.html</a></p><p><br/></p>', '发送插件', NULL, '免费', '支持通过邮件、短信方式进行消息推送，也支持第三方平台sendcloud', '[{\"url\":\"blob:http://192.168.0.215:8080/c661dd33-d7a6-4f0f-9665-517fda7d5df7\",\"name\":\"1652089443130.jpeg\",\"path\":\"/upload/1/cms/content/1686218113888.jpeg\",\"uid\":1686218113866,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:05', 0, '', 0, NULL, 0, '2023-06-08 17:55:57', 0, '57', '2023-06-08 11:49:44', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653709826072576, 1666653706550321159, '<p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">下面我们开始分享一下开源中国中最火的Java开源CMS建站系统（代码可以到gitee.com中下载 搜一下项目名称）</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\">　　（1）铭飞 / MCMS（开发人/项目名称）</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 1800 star 3400 fork 1800</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　完整开源！Java快速开发平台！基于Spring、SpringMVC、Mybatis架构，MStore提供更多好用的插件与模板（文章、商城、微信、论坛、会员、评论、支付、积分、工作流、任务调度等，同时提供上百套免费模板任意选择），价值源自分享！铭飞系统不仅一套简单好用的开源系统、更是一整套优质的开源生态内容体系。铭飞的使命就是降低开发成本提高开发效率，提供全方位的企业级开发解决方案。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　核心框架：Spring Framework 4</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　安全框架：Apache Shiro 1.2</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　视图框架：Spring MVC 4</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　任务调度：Spring Task 4</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　持久层框架：MyBatis 3</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　数据库连接池：Alibaba Druid 1.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　日志管理：SLF4J 1.7、Log4j</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　JS框架：jQuery 1.10</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　CSS框架：Twitter Bootstrap 2.3.1。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　富文本：Ueditor</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932423.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932622.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　<span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\">　（2）Fly的狐狸 / jfinal_cms</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 713 star 1417 fork 822</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　jfinal cms是一个java开发的功能强大的信息咨询网站，采用了简洁强大的JFinal作为web框架，模板引擎用的是beetl，数据库用mysql，前端bootstrap框架。 支持oauth2认证、帐号注册、密码加密、评论及回复，消息提示，网站访问量统计，文章评论数和浏览量统计，回复管理，支持权限管理。 后台模块包含：栏目管理，栏目公告，栏目滚动图片，文章管理，回复管理，意见反馈，我的相册，相册管理，图片管理，专辑管理、视频管理、缓存更新，友情链接，访问统计，联系人管理，模板管理，组织机构管理，用户管理，角色管理，菜单管理，数据字典管理。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　jfinal cms，采用了简洁强大的JFinal作为web框架，模板引擎用的是beetl，数据库用mysql，前端bootstrap框架。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　后台模块包含：栏目管理，栏目公告，栏目滚动图片，文章管理，回复管理，意见反馈，我的相册，相册管理，图片管理，专辑管理，视频管理，缓存更新，友情链接，访问统计，联系人管理，模板管理，组织机构管理，用户管理，角色管理，菜单管理，参数配置，数据字典管理。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　后端模板支持：bootstrap默认样式、bootstrap黑色样式和flat-ui样式</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　前端模板支持：默认内容发布、官网模板、图片模板和视频模板</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932670.gif\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932808.gif\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\">　　（3）kerneler / PublicCMS</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 382 star 726 fork 370</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　PublicCMS是采用2018年最新主流技术开发的开源JAVACMS系统。架构科学，轻松支持上千万数据、千万PV；支持全站静态化，SSI，动态页面局部静态化等为您快速建站，建设大规模站点提供强大驱动，也是企业级项目产品原型的良好选择。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932910.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932970.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000932989.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　<span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\">（4）付苗 / 51opencms</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 181 star 370 fork 133</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　youngcms采用spring mvc ,mybatis,freemaker，mysql等技术开发完成,我们正在采用dubbo,activeMq消息队列，redis等技术进行全新的架构</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933017.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933033.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933052.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\">　　（5）jeffxu / tianti天梯</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 156 star 345 fork 174</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　java轻量级的CMS系统-天梯。天梯是一个用java相关技术搭建的后台CMS解决方案，用户可以结合自身业务进行相应扩展，同时提供了针对dao、service等的代码生成工具。技术选型：Spring Data JPA、Hibernate、Shiro、 Spring MVC、Layer、Mysql等。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　核心框架：Spring Framework 4.2.5.RELEASE</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·安全框架：Apache Shiro 1.3.2</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·视图框架：Spring MVC 4.2.5.RELEASE</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·数据库连接池：Tomcat JDBC</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·缓存框架：Ehcache</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·ORM框架：Spring Data JPA、hibernate 4.3.5.Final</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·日志管理：SLF4J 1.7.21、Log4j</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·编辑器：ueditor</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·工具类：Apache Commons、Jackson 2.8.5、POI 3.15</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·view层：JSP</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·数据库：mysql、oracle等关系型数据库</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·dom : Jquery</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·分页 : jquery.pagination</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·UI管理 : common</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·UI集成 : uiExtend</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·滚动条 : jquery.nicescroll.min.js</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·图表 ： highcharts</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·3D图表 ：highcharts-more</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·轮播图 ： jquery-swipe</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·表单提交 ：jquery.form</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·文件上传 ：jquery.uploadify</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·表单验证 ：jquery.validator</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·展现树 ：jquery.ztree</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　·html模版引擎 ：template</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933075.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933116.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933143.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><span style=\"box-sizing: border-box; outline: 0px; margin: 0px; padding: 0px; overflow-wrap: break-word; color: rgb(243, 59, 69);\"><span style=\"box-sizing: border-box; outline: 0px; font-weight: 700; overflow-wrap: break-word;\">　　（6）SeeYoui / kensite_cms</span></span></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　watch 197 star 320 fork 135</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目介绍：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　KenSite是基于多个优秀的开源项目，高度整合封装而成的高效，高性能，强安全性的开源Java EE快速开发平台。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　KenSite本身是以Spring Framework为核心容器，Spring MVC为模型视图控制器，MyBatis为数据访问层， Apache Shiro为权限授权层，Ehcahe对常用数据进行缓存，Quartz为定时任务计划管理。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　KenSite 提供了常用工具进行封装，包括日志工具、缓存工具、服务器端验证、数据字典、当前组织机构数据以及其它常用小工具等。另外还提供一个强大的在线&nbsp;代码生成&nbsp;工具，直接生成controller、service、domain、mapper、mybatis xml、jsp等文件， 前端显示基于easyui，一键生成就可以直接使用包括新增修改删除等常规操作。 如果你使用了KenSite基础框架，就可以很高效的快速开发出，优秀的信息管理系统。</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　使用技术：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　核心框架：Spring Framework 4.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　安全框架：Apache Shiro 1.2</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　视图框架：Spring MVC 4.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　服务端验证：Hibernate Validator 5.1</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　定时任务计划：Quartz</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　流程引擎：activiti 5.21.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　持久层框架：MyBatis 3.2</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　数据库连接池：Alibaba Druid 1.0</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　缓存框架：Ehcache 2.6、Redis</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　日志管理：SLF4J 1.7、Log4j</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　全文检索：lucene</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　验证码：patchca</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　WebService：CXF webservice</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　工具类：Apache Commons、Jackson 2.2、Xstream 1.4、Dozer 5.3、POI 3.9</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　JS框架：jQuery 1.9</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　CSS框架：Twitter Bootstrap 2.3.1</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　前端组件：easyui</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　客户端验证：JQuery Validation Plugin 1.11</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　富文本：Ueditor</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　对话框：layer、jquery-ui</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　上传空间：uploadify</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　树结构控件：jQuery zTree</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　日期控件： My97DatePicker</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　web excel插件：handsontable</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　统计图表：echarts</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\">　　项目预览图：</p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933178.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933214.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p style=\"box-sizing: border-box; outline: 0px; margin-top: 0px; margin-bottom: 16px; padding: 0px; color: rgb(77, 77, 77); overflow: auto hidden; overflow-wrap: break-word; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun; white-space: normal; background-color: rgb(255, 255, 255); line-height: 26px !important;\"><img alt=\"国内有哪些较好的Java开源CMS建站系统？\" class=\"has\" src=\"/upload/1/cms/content/editor/1610000933236.jpg\" style=\"box-sizing: border-box; outline: none; border: 0px; max-width: 100%; height: auto; overflow-wrap: break-word; cursor: zoom-in;\"/></p><p><br/></p>', '【网站】国内 前6名 Java开源CMS建站系统', NULL, '', '下面我们开始分享一下开源中国中最火的Java开源CMS建站系统', '[{\"url\":\"/upload/1/cms/content/1609835629433.jpeg\",\"name\":\"a.jpeg\",\"path\":\"/upload/1/cms/content/1609835629433.jpeg\",\"uid\":1609835629283,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:06', 0, NULL, 24, NULL, 0, '2023-06-08 11:49:44', 0, '57', '2023-06-08 11:49:44', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653711092752384, 1666653706550321159, '<h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\">特点</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>免费完整开源：基于MIT协议，源代码完全开源，无商业限制,MS开发团队承诺将MCMS内容系统永久完整开源；</p></li><li><p>标签化建站：不需要专业的后台开发技能，只要使用系统提供的标签，就能轻松建设网站；</p></li><li><p>html静态化：系统支持全站静态化；</p></li><li><p>跨终端：站点同时支持PC与移动端访问，同时会自动根据访问的终端切换到对应的界面，数据由系统统一管理；</p></li><li><p>海量模版：铭飞通过MStore（MS商城）分享更多免费、精美的企业网站模版，降低建站成本；</p></li><li><p>丰富插件：为了让MCms适应更多的业务场景，在MStore用户可以下载对应的插件，如：站群插件、微信插件、商城插件等；</p></li><li><p>每月更新：铭飞团队承诺每月28日为系统升级日，分享更多好用等模版与插件；</p></li><li><p>文档丰富：为了让用户更快速的使用MCms系统进行开发，铭飞团队持续更新开发相关文档，如标签文档、使用文档、视频教程等；</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"面向对象_3\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E9%9D%A2%E5%90%91%E5%AF%B9%E8%B1%A1_3\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>面向对象</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>铭飞MCMS是企业在创立初期很好的技术基础框架，加快公司项目开发进度，当然也可以对现有的系统进行升级；</p></li><li><p>个人开发者也可以使用MCMS承接外包项目；</p></li><li><p>初学JAVA的同学可以下载源代码来进行学习交流；</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"技术框架_4\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E6%8A%80%E6%9C%AF%E6%A1%86%E6%9E%B6_4\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>技术框架</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>核心框架：Spring Framework 4</p></li><li><p>安全框架：Apache Shiro 1.2</p></li><li><p>视图框架：Spring MVC 4</p></li><li><p>任务调度：Spring Task 4</p></li><li><p>持久层框架：MyBatis 3</p></li><li><p>数据库连接池：Alibaba Druid 1.0</p></li><li><p>日志管理：SLF4J 1.7、Log4j</p></li><li><p>JS框架：jQuery 1.10</p></li><li><p>CSS框架：Twitter Bootstrap 2.3.1。</p></li><li><p>富文本：Ueditor</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"系统结构_5\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E7%B3%BB%E7%BB%9F%E7%BB%93%E6%9E%84_5\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>系统结构</h1><p style=\"margin: 10px auto; padding: 0px; line-height: 1.5;\"><img class=\"md_relative_url\" title=\"在这里输入图片标题\" src=\"/ueditor/jsp/upload/image/20210105/1609818395900070630.jpg\" alt=\"输入图片说明\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"开发环境_6\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E5%BC%80%E5%8F%91%E7%8E%AF%E5%A2%83_6\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>开发环境</h1><p style=\"margin: 10px auto; padding: 0px; line-height: 1.5;\">建议开发者使用以下环境，这样避免版本带来的问题</p><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>IDE:eclipse</p></li><li><p>DB:Mysql5.5</p></li><li><p>JDK:JAVA 7、J2EE6</p></li><li><p>WEB:Tomcat8</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"运行环境_7\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E8%BF%90%E8%A1%8C%E7%8E%AF%E5%A2%83_7\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>运行环境</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>WEB服务器：Weblogic、Tomcat、WebSphere、JBoss、Jetty 等</p></li><li><p>数据库服务器：Mysql5.5</p></li><li><p>操作系统：Windows、Linux、Unix 等</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"快速体验_8\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E5%BF%AB%E9%80%9F%E4%BD%93%E9%AA%8C_8\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>快速体验</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>将MCMS项目源码导入eclipse；</p></li><li><p>创建数据库db-mcms-open,注意：数据库使用utf-8编码，导入doc/db-mcms-open.sql备份文件；</p></li><li><p>修改src\\main\\resources\\ms.properties文件中的数据库设置参数；</p></li><li><p>第一次启动必须先访问后台，后台访问地址：http://+ip地址（或localhost）:tomcat端口/项目发布名/ms/login.do 必需先访问后台界面再访问前台界面</p></li><li><p>前台访问地址：<a href=\"http://xn--ip%28localhost%29-4v7w4gy75n:tomcat%E7%AB%AF%E5%8F%A3/%E9%A1%B9%E7%9B%AE%E5%8F%91%E5%B8%83%E5%90%8D\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://ip地址（或localhost）:tomcat端口/项目发布名</a>,如果发布的地址不是<a href=\"http://localhost:8080/mcms\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://localhost:8080/mcms</a>，先在后台生成静态页面再进行访问</p></li><li><p>管理员账号，用户名：msopen 密码：msopen</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"文件说明_9\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E6%96%87%E4%BB%B6%E8%AF%B4%E6%98%8E_9\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>文件说明</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>.externalToolBuilders eclipse缓存文件</p></li><li><p>.settings eclipse配置缓存文件</p></li><li><p>doc 项目文档文件夹，里面有数据库文件</p></li><li><p>src/main maven结构的项目源代码</p></li><li><p>java/com/mingsoft java源代码文件</p></li><li><p>resources 项目的资源配置文件</p></li><li><p>webapp<br style=\"margin: 0px; padding: 0px;\"/>META-INF&nbsp;<br style=\"margin: 0px; padding: 0px;\"/>WEB-INF&nbsp;<br style=\"margin: 0px; padding: 0px;\"/>manager&nbsp;<br style=\"margin: 0px; padding: 0px;\"/>html/1 默认生成的静态代码，实际项目需要删除，只是提供给开发者快速预览生成后的静态页面<br style=\"margin: 0px; padding: 0px;\"/>templets/1/mooc 默认模版<br style=\"margin: 0px; padding: 0px;\"/>upload&nbsp;</p></li><li><p>target 临时文件，可以删除让maven自动生成</p></li><li><p>.classpath eclipse配置缓存文件</p></li><li><p>.project eclipse配置缓存文件</p></li><li><p>LICENSE 项目协议说明</p></li><li><p>README.md 项目说明文档</p></li><li><p>pom.xml maven的依赖配置文件</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"代码部署与常见问题_10\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E4%BB%A3%E7%A0%81%E9%83%A8%E7%BD%B2%E4%B8%8E%E5%B8%B8%E8%A7%81%E9%97%AE%E9%A2%98_10\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>代码部署与常见问题</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>铭飞MCms 部署视频&nbsp;<a href=\"http://ms.mingsoft.net/mbbs/13988/detail.do\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://ms.mingsoft.net/mbbs/13988/detail.do</a></p></li><li><p>MCms环境配置常见问题&nbsp;<a href=\"http://ms.mingsoft.net/mbbs/13000/detail.do\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://ms.mingsoft.net/mbbs/13000/detail.do</a></p></li><li><p>MStore使用方式：<a href=\"http://ms.mingsoft.net/mbbs/13008/detail.do\" target=\"_blank\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\">http://ms.mingsoft.net/mbbs/13008/detail.do</a></p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"开源说明_11\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E5%BC%80%E6%BA%90%E8%AF%B4%E6%98%8E_11\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>开源说明</h1><ul class=\"task-list list-paddingleft-2\" style=\"margin-left: 30px; padding: 0px; word-break: break-all;\"><li><p>系统100%开源</p></li><li><p>铭飞MCms是铭飞MS平台的一个子模块，同时铭飞MCms所依赖的模块都是用maven方式提供了源码获取方式,具体看pom.xml文件的&lt;!-- MAVEN源码加载 --&gt;部分</p></li></ul><h1 style=\"margin: 10px 0px; padding: 0px; font-size: 28px; line-height: 1.5;\"><a id=\"系统美图_12\" class=\"anchor\" href=\"http://git.oschina.net/mingSoft/MCMS#%E7%B3%BB%E7%BB%9F%E7%BE%8E%E5%9B%BE_12\" style=\"margin: 0px; padding: 0px; color: rgb(51, 51, 51);\"></a>系统美图</h1><p style=\"margin: 10px auto; padding: 0px; line-height: 1.5;\"><img class=\"md_relative_url\" title=\"铭飞模版商城，模版商城\" src=\"/ueditor/jsp/upload/image/20210105/1609818396224099515.jpg\" alt=\"输入图片说明\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/><br style=\"margin: 0px; padding: 0px;\"/><img class=\"md_relative_url\" title=\"铭飞模版商城，插件商城\" src=\"/ueditor/jsp/upload/image/20210105/1609818396728044765.png\" alt=\"输入图片说明\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/><br style=\"margin: 0px; padding: 0px;\"/><img class=\"md_relative_url\" title=\"铭飞内容管理系统后台演示\" src=\"/ueditor/jsp/upload/image/20210105/1609818396886062056.png\" alt=\"输入图片说明\" style=\"margin: 0px; padding: 0px; border: 0px; max-width: 100%; height: auto;\"/></p><p><br/></p>', '铭飞MCMS内容管理系统完整开源版J2EE代码', NULL, '', '官网同时提供一键运行版本下载，请步移官网....', '[{\"url\":\"/upload/1/cms/content/1609835614568.jpeg\",\"name\":\"a.jpeg\",\"path\":\"/upload/1/cms/content/1609835614568.jpeg\",\"uid\":1609835614464,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:07', 0, NULL, 37, NULL, 0, '2023-06-08 11:49:44', 0, '57', '2023-06-08 11:49:44', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653714305589248, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例10', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033073949.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033073949.jpg\",\"uid\":1686033073930,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:10', 0, '', 0, '', 0, '2023-06-08 17:52:06', 0, '57', '2023-06-08 11:49:45', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716146888704, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例9', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033094169.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033094169.jpg\",\"uid\":1686033094151,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:12', 0, '', 0, '', 0, '2023-06-08 17:51:58', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716172054528, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例8', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033105353.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033105353.jpg\",\"uid\":1686033105327,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:13', 0, '', 0, '', 0, '2023-06-08 17:51:49', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716285300736, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例7', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033117767.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033117767.jpg\",\"uid\":1686033117748,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:14', 0, '', 0, '', 0, '2023-06-08 17:51:39', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716323049472, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例6', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033127866.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033127866.jpg\",\"uid\":1686033127842,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:15', 0, '', 0, '', 0, '2023-06-08 17:51:31', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716339826688, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例5', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033141394.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033141394.jpg\",\"uid\":1686033141373,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:16', 0, '', 0, '', 0, '2023-06-08 17:51:23', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716360798208, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例4', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033153504.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033153504.jpg\",\"uid\":1686033153483,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:17', 0, '', 0, '', 0, '2023-06-08 17:50:59', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716381769728, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例3', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033170932.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033170932.jpg\",\"uid\":1686033170907,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:18', 0, '', 0, '', 0, '2023-06-08 17:22:41', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716402741248, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例2', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033183710.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033183710.jpg\",\"uid\":1686033183694,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:19', 0, '', 0, '', 0, '2023-07-02 11:30:08', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716423712768, 1666653706550321164, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">1、营销管理方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品的定义：作为商品向市场提供的，引起注意、获取、使用或者消费，以满足欲望或需要的任何东西。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">消费者购买的不只是产品的实体，还包括产品的核心利益（即向消费者提供的基本效用和利益）。产品的实体称为一般产品，即产品的基本形式，只有依附于产品实体，产品的核心利益才能实现。期望产品是消费者采购产品时期望的一系列属性和条件。附加产品是产品的第四层次，即产品包含的附加服务和利益。产品的第五层次是潜在产品，潜在产品预示着该产品最终可能的所有增加和改变。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">在供应链上，上流工厂的产品是下流工厂的生产原料或耗材，例如塑料粒、纸皮盒、玻璃片、计算机中央处理器、油漆等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">2、企业管理基础概念方向</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品定义：人们在实现需求的过程中，与实现需求相关的全部感知事物及意象的集合。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">此定义的特点：其一，产品是一个过程性的事物而不是一个静止的事物，从选择、付款、安装、使用、报废等过程都可能属于产品；其二，产品不是企业提供的事物，而是属于顾客的事物，产品的本质是顾客的“感知”，其依赖顾客而存在，不可能独立于顾客而存在；其三，意象也是产品的重要构成，意象来自感知，意象包括记忆意象和想象意象。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">这里的“感知”是心理学概念，也常翻译为“知觉”。感知和知觉是同义词。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; background-color: rgb(245, 245, 245);\">产品是企业与外部世界的唯一联结，也是企业生存的唯一依托。</p><p><br/></p>', '服务案例1', '', '', '产品定义目前有两个学术方向。一个是以“营销管理”为定位的方向；另一个是以整个“企业管理的基础概念”为定位方向。', '[{\"url\":\"/upload/1/cms/content/1686033195038.jpg\",\"name\":\"1571207930508600.jpg\",\"path\":\"/upload/1/cms/content/1686033195038.jpg\",\"uid\":1686033195016,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:20', 0, '', 0, '', 0, '2023-06-08 17:22:27', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716448878592, 1666653706550321169, '', '中电建商业保理有限公司', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/904ade77-2377-4167-84f3-2448a62ccced\",\"name\":\"1684557468352.png\",\"path\":\"/upload/1/cms/content/1686215537420.png\",\"uid\":1686215537391,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:21', 0, '', 2, '', 0, '2023-06-08 17:12:44', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716465655808, 1666653706550321169, '', '郑州轻大产业技术研究院', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/26037198-991e-4974-81cb-9c4b592e81ea\",\"name\":\"1602603060008.jpg\",\"path\":\"/upload/1/cms/content/1686215506299.jpg\",\"uid\":1686215506253,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:22', 0, '', 1, '', 0, '2023-06-08 17:12:06', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716503404544, 1666653706550321169, '', '车智家集团', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/ec84be6c-6423-4d4d-a91e-d75d56214a3d\",\"name\":\"1600739696748.png\",\"path\":\"/upload/1/cms/content/1686215474321.png\",\"uid\":1686215474275,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:23', 0, '', 0, '', 0, '2023-06-08 17:11:32', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716520181760, 1666653706550321169, '', '景德镇陶瓷大学', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/542c1f2e-49b3-480f-a442-d4637aeba457\",\"name\":\"1600738933544.png\",\"path\":\"/upload/1/cms/content/1686215253408.png\",\"uid\":1686215253369,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:24', 0, '', 0, '', 0, '2023-06-08 17:07:42', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716557930496, 1666653706550321169, '', '北京科技大学', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/3957b153-be45-4634-abb6-374f964f4009\",\"name\":\"1600738722683.png\",\"path\":\"/upload/1/cms/content/1686215232869.png\",\"uid\":1686215232832,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:25', 0, '', 0, '', 0, '2023-06-08 17:07:21', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666653716599873536, 1666653706550321169, '', '海尔', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/76057b4a-46d7-442e-a12a-ee4c710ec984\",\"name\":\"1600097933163.png\",\"path\":\"/upload/1/cms/content/1686215179288.png\",\"uid\":1686215179264,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 11:50:26', 0, '', 0, '', 0, '2023-06-08 17:06:31', 0, '57', '2023-06-08 11:49:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666720458662727682, 1666653706550321165, '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal;  line-height: 24px;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体;\">岗位职责：</span></strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">1、负责公司服务器基础环境的部署、配置、日常巡检、维护、故障的应急响应和问题处理；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">2、负责公司kvm虚拟化平台的管理工作，基础环境部署，性能容量管理，漏洞扫描、安全加固，保证其稳定、高效运行；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">3、负责维护公司集中监控系统，根据业务需求调整监控策略、告警阀值，处理告警信息和问题跟踪；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">4、编写系统维护文档，完善并更新运维流程文档；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal;  line-height: 24px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 24px;\">&nbsp;</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal;  line-height: 24px;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体;\">任职要求：</span></strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">1、计算机等相关专业，本科以上学历，2年以上linux系统管理工作经验，经验丰富可适当放宽学历条件；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">2、熟悉基础网络知识，熟悉TCP/IP协议工作原理，有大流量网站服务器管理经验者优先，熟悉自动化运维工具（三选一puppet/saltstack/ansible）优先；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">3、熟悉linux系统高可用技术和负载均衡技术，熟悉WEB相关技术，包括Apache/Nginx/tomcat/squid 等应用程序的安装、配置和维护；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">4、熟悉服务器硬件，具备排错及故障定位、处理的能力；熟练使用各种工具进行系统状态监控（cacti、Nagios、ganglia等），有虚拟化平台相关经验者优先（vmware/kvm/docker）；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">5、有良好的沟通能力和团队合作精神，有强烈的事业心和责任感，工作细心，热爱学习和分享，具有RHCE、RHCA认证者优先；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \">6、熟练撑握shell/python/perl等1至2种语言。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; font-size: 14px; white-space: normal; \"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">工作地址：</strong>&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p><h2 style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-family: 微软雅黑, Arial, &quot;Microsoft YaHei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;sans-serif&quot;; white-space: normal; \">北京市朝阳区</h2><p><br/></p>', '人才招聘', '', '', '', '', '', '', '0', '', '2023-06-08 16:13:40', 0, '', 0, '', 0, '2023-06-08 16:14:58', 0, NULL, '2023-06-08 16:14:58', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666735079036440577, 1666653706550321169, '', '藏书馆', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/4efa21ca-db0a-4d00-8fe3-0dcf65f2694b\",\"name\":\"1684557767759.png\",\"path\":\"/upload/1/cms/content/1686215577592.png\",\"uid\":1686215577536,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:12:52', 0, '', 0, '', 0, '2023-06-08 17:13:04', 0, NULL, '2023-06-08 17:13:04', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666735154181591042, 1666653706550321169, '', '科大国创', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/9fa2ac96-e76a-4eec-9161-a040430e026b\",\"name\":\"1684570759624.png\",\"path\":\"/upload/1/cms/content/1686215592867.png\",\"uid\":1686215592845,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:13:08', 0, '', 0, '', 0, '2023-06-08 17:13:22', 0, NULL, '2023-06-08 17:13:22', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666735248415019009, 1666653706550321169, '', '满井智信', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/1ec23a47-b279-4b83-af86-347fd272a903\",\"name\":\"1684672801443.png\",\"path\":\"/upload/1/cms/content/1686215611850.png\",\"uid\":1686215611835,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:13:26', 0, '', 0, '', 0, '2023-06-08 17:13:44', 0, NULL, '2023-06-08 17:13:44', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666735336336019457, 1666653706550321169, '', '中科方德', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/761e995c-4735-4244-b98c-3863c04c82a8\",\"name\":\"1684917748516.jpg\",\"path\":\"/upload/1/cms/content/1686215634206.jpg\",\"uid\":1686215634188,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:13:49', 0, '', 0, '', 0, '2023-06-08 17:14:05', 0, NULL, '2023-06-08 17:14:05', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666735424202493953, 1666653706550321169, '', '香港北京高校校友联盟', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/2ecbf3e0-c4f4-465b-bf4a-117f263ab11f\",\"name\":\"1685606017974.png\",\"path\":\"/upload/1/cms/content/1686215652816.png\",\"uid\":1686215652793,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:14:08', 0, '', 0, '', 0, '2023-06-08 17:14:26', 0, NULL, '2023-06-08 17:14:26', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666735506201137154, 1666653706550321169, '', '安徽信用中国', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/e7369bd3-ce09-4714-abb8-ca6c1dd12755\",\"name\":\"1685609162250.png\",\"path\":\"/upload/1/cms/content/1686215674142.png\",\"uid\":1686215674126,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:14:29', 0, '', 0, '', 0, '2023-06-08 17:14:46', 0, NULL, '2023-06-08 17:14:46', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666746118801084417, 1666653706550321156, '<blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-family: sans-serif; font-size: 16px;\">当前版本</span><br/></h2></blockquote><p style=\"width: 848px; white-space: normal;\"><span style=\"font-size: 18px;\"></span></p><p style=\"width: 848px; white-space: normal;\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mdiy\" style=\"color: rgb(56, 56, 56);\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mdiy.svg?label=Maven%20Central\" width=\"134\" height=\"20\" title=\"\" alt=\"\"/></a></p><p style=\"width: 848px; white-space: normal;\">默认已集成到mcms，不需要安装</p><blockquote style=\"white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; white-space: normal;\">后台使用：<a href=\"http://doc.mingsoft.net/plugs-diy/chapter1/zi-ding-yi-zi-dian.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs-diy/chapter1/zi-ding-yi-zi-dian.html</a></p><p style=\"width: 848px; white-space: normal;\">开放接口：<a href=\"http://doc.mingsoft.net/plugs-diy/jie-kou/zi-dian-lie-biao.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs-diy/jie-kou/zi-dian-lie-biao.html</a></p><p style=\"width: 848px; white-space: normal;\">常见问题：<a href=\"http://doc.mingsoft.net/plugs-diy/chang-jian-wen-ti.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs-diy/chang-jian-wen-ti.html</a></p><p style=\"width: 848px; white-space: normal;\">更新说明：<a href=\"http://doc.mingsoft.net/plugs-diy/ban-ben-geng-xin-shuo-ming.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs-diy/ban-ben-geng-xin-shuo-ming.html</a></p><p style=\"width: 848px; white-space: normal;\"><br/></p><p><br/></p>', '自定义插件', '', '', '包含自定义字典、自定义搜索、自定义模型、自定义表单、自定义页面等功能', '[{\"url\":\"blob:http://192.168.0.215:8080/2e9a1c93-56ff-4731-87a1-5cf1420f056a\",\"name\":\"1652089960217.jpeg\",\"path\":\"/upload/1/cms/content/1686218200498.jpeg\",\"uid\":1686218200481,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:56:19', 0, '', 0, '', 0, '2023-06-08 17:56:56', 0, NULL, '2023-06-08 17:56:56', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666746342634311681, 1666653706550321156, '<blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统（注意：<span style=\"color: rgb(68, 68, 68); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; orphans: 3; widows: 3;\">必须安装会员插件才能正常使用关注插件</span>）</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">当前版本</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mattention\" style=\"color: rgb(56, 56, 56);\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mattention.svg?label=Maven%20Central\" width=\"134\" height=\"20\" title=\"\" alt=\"\"/></a></p><pre class=\"brush:xml;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">&lt;!--关注插件依赖--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&lt;artifactId&gt;ms-mattention&lt;/artifactId&gt;\n&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，到此插件安装完成；</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box;\"></span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">源码</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\">https://github.com/ming-soft/ms-mattention</span></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">开放接口：<a href=\"http://doc.mingsoft.net/plugs/guan-zhu-cha-jian/ye-wu-kai-fa.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/guan-zhu-cha-jian/ye-wu-kai-fa.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">常见问题：<a href=\"http://doc.mingsoft.net/plugs/guan-zhu-cha-jian/chang-jian-wen-ti.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/guan-zhu-cha-jian/chang-jian-wen-ti.html</a></p><p><br/></p>', '关注插件', '', '', '关注插件可以满足常见的业务场景如收藏、赞、顶、踩、关注等。', '[{\"url\":\"blob:http://192.168.0.215:8080/b0a836a8-5bfb-4a74-b6c4-a250d15970e9\",\"name\":\"1652092292981.jpeg\",\"path\":\"/upload/1/cms/content/1686218243647.jpeg\",\"uid\":1686218243627,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:57:12', 0, '', 0, '', 0, '2023-06-08 17:57:49', 0, NULL, '2023-06-08 17:57:49', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666746591885021186, 1666653706550321156, '<p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">只需要按照表单的配置流程配置好就可以进行数据迁移的工作。</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><img src=\"http://store.mingsoft.net/upload/store/editor/1672044039961.gif\" alt=\"\" width=\"100%\"/></p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">安装方法</span>&nbsp;&nbsp; &nbsp;</h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">当前版本</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://search.maven.org/search?q=ms-mpeople\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\"><img title=\"\" src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-transfer.svg?label=Maven%20Central\" alt=\"\" width=\"134\" height=\"20\"/></a></p><pre class=\"brush:xml;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">&lt;!--会员插件--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&lt;artifactId&gt;ms-transfer&lt;/artifactId&gt;\n&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：点击安装，会自动生成系统对应的菜单。</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 3：配置需要迁移的数据，具体参考表单中的文字描述说明</p><p><br/></p>', '数据迁移', '', '', '可以快速迁移数据到MCms系统中', '[{\"url\":\"blob:http://192.168.0.215:8080/159394ca-970e-4593-a589-7e76dffc1d22\",\"name\":\"1671180785455.png\",\"path\":\"/upload/1/cms/content/1686218295568.png\",\"uid\":1686218295547,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:57:57', 0, '', 0, '', 0, '2023-06-08 17:58:49', 0, NULL, '2023-06-08 17:58:49', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666746750492626945, 1666653706550321156, '<blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">安装方法</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\"></span>Steup 1：pom.xml增加依赖，并重启系统（注意：<span style=\"color: rgb(68, 68, 68); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; orphans: 3; widows: 3;\">必须安装会员插件才能正常使用评论插件</span>）</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><a target=\"_blank\" href=\"https://search.maven.org/search?q=ms-mcomment\" style=\"color: rgb(56, 56, 56);\"><img src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mcomment.svg?label=Maven%20Central\" width=\"134\" height=\"20\" title=\"\" alt=\"\"/></a></p><pre class=\"brush:xml;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">&lt;!--评论插件依赖--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&lt;artifactId&gt;ms-mcomment&lt;/artifactId&gt;\n&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box;\"></span></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">在线文档</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">后台使用：<a href=\"http://doc.mingsoft.net/plugs/ping-lun-cha-jian/jie-shao.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/ping-lun-cha-jian/jie-shao.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">开放接口：<a href=\"http://doc.mingsoft.net/plugs/ping-lun-cha-jian/ye-wu-kai-fa.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/ping-lun-cha-jian/ye-wu-kai-fa.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">常见问题：<a href=\"http://doc.mingsoft.net/plugs/ping-lun-cha-jian/chang-jian-wen-ti.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/ping-lun-cha-jian/chang-jian-wen-ti.html</a></p><p><br/></p>', '评论插件', '', '', '支持对信息的评论，后台查看用户评论的信息，支持对用户评论的筛选。', '[{\"url\":\"blob:http://192.168.0.215:8080/fdcd2436-dc24-4858-9150-485a88bcefc0\",\"name\":\"1652092825144.jpeg\",\"path\":\"/upload/1/cms/content/1686218353776.jpeg\",\"uid\":1686218353754,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:58:58', 0, '', 0, '', 0, '2023-06-08 17:59:27', 0, NULL, '2023-06-08 17:59:27', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666746969481433090, 1666653706550321156, '<p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">会员插件可以快速实现会员中心的功能，开发者参考手册对接对应的接口，具体参考文档。</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">会员需要用到城市插件的数据，开发者可以查看城市插件的安装使用</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">安装方法</span>&nbsp;&nbsp; &nbsp;</h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 1：pom.xml增加依赖，并重启系统</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">当前版本</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://search.maven.org/search?q=ms-mpeople\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\"><img title=\"\" src=\"https://img.shields.io/maven-central/v/net.mingsoft/ms-mpeople.svg?label=Maven%20Central\" alt=\"\" width=\"134\" height=\"20\"/></a></p><pre class=\"brush:xml;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">&lt;!--会员插件--&gt;\n&lt;dependency&gt;\n&nbsp;&nbsp;&lt;groupId&gt;net.mingsoft&lt;/groupId&gt;\n&nbsp;&nbsp;&lt;artifactId&gt;ms-mpeople&lt;/artifactId&gt;\n&nbsp;&nbsp;&lt;version&gt;当前版本&lt;/version&gt;\n&lt;/dependency&gt;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 2：在 src/main/java/config/WebConfig 中的&nbsp;addInterceptors 增加会员拦截器</p><pre class=\"brush:java;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">public&nbsp;void&nbsp;addInterceptors(InterceptorRegistry&nbsp;registry)&nbsp;{\n&nbsp;&nbsp;&nbsp;&nbsp;registry.addInterceptor(new&nbsp;net.mingsoft.people.interceptor.ActionInterceptor(&quot;/mdiyPage/login.do&quot;))\n&nbsp;&nbsp;&nbsp;&nbsp;.addPathPatterns(&quot;/people/**&quot;);\n}</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 3：重新进入mstore、进入插件详情页点击 在线安装&nbsp; 完成后，刷新后台主界面，会显示相应插件功能菜单，到此插件安装完成；</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">Steup 4：如果需要 扩展会员信息，需要通过代码生成器设计一个表单（注意 名称必须是 扩展会员信息），通过自定义模型导入，选择会员类型，再次去新增会员信息就可以看到扩展会员信息表单，这样会员信息就很方便进行扩展了；</p><blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">在线文档</span>&nbsp;&nbsp; &nbsp;</h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">后台使用：<a href=\"http://doc.mingsoft.net/plugs/hui-yuan-cha-jian/jie-shao.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/hui-yuan-cha-jian/jie-shao.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">开放接口：<a href=\"http://doc.mingsoft.net/plugs/hui-yuan-cha-jian/ye-wu-kai-fa.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/hui-yuan-cha-jian/ye-wu-kai-fa.html</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">常见问题：<a href=\"http://doc.mingsoft.net/plugs/hui-yuan-cha-jian/chang-jian-wen-ti.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/hui-yuan-cha-jian/chang-jian-wen-ti.html</a></p><p><br/></p>', '会员模块', '', '', '包含会员注册、登录、取回密码、个人中心等基本功能', '[{\"url\":\"blob:http://192.168.0.215:8080/6ef0a2ad-a546-4899-9a74-cfcba9af3f88\",\"name\":\"1652094102595.jpeg\",\"path\":\"/upload/1/cms/content/1686218401045.jpeg\",\"uid\":1686218401028,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 17:59:44', 0, '', 0, '', 0, '2023-06-08 18:00:19', 0, NULL, '2023-06-08 18:00:19', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666747234498531329, 1666653706550321156, '<blockquote style=\"font-size: medium; white-space: normal; box-sizing: border-box; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; break-inside: avoid; margin: 0px 0px 0.85em; padding: 0px 15px; color: rgb(133, 133, 133); border-left: 4px solid rgb(229, 229, 229); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: 0.2px; background-color: rgb(255, 255, 255);\"><h2><span style=\"font-size: 18px;\">安装方式</span></h2></blockquote><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">由于城市数据文件比较大，约90M，所以提供在线SQL文件下载，需要手动导入数据库，推荐使用source指令导入方式。</p><pre class=\"brush:sql;toolbar:false\" style=\"background-color: rgb(255, 255, 255);\">mysql&gt;use&nbsp;数据名称;\nmysql&gt;source&nbsp;路径/city.sql;</pre><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">城市数据接口读取方式参考代码生成器中的城市组件，特别说明：商城插件、运费插件、会员插件等用以后用到城市数据的插件都必须导入城市数据，否则会因缺少城市数据导致业务流程失败。</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><strong><span style=\"font-size: 24px;\">具体安装步骤：</span></strong></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">1.进入MStore点击安装，系统自动生成城市菜单</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">2.下载城市数据压缩包，里面是城市数据的sql</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">3.手动将sql文件导入到系统指向的数据库中</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">务必参考安装步骤来！！！</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">城市数据库来自国家统计局<a href=\"http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/</a></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">具体请参考插件手册：http://doc.mingsoft.net/plugs/cheng-shi-cha-jian/jie-shao.html</p><h2 style=\"font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">安装方法：</h2><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><em>Steup 1</em>：下载城市数据压缩包，里面是城市数据的sql&nbsp;</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><em>Steup 2</em>：手动将sql文件导入到系统指向的数据库中</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><em>Steup 3</em>：点击左侧安装（系统会自动为您添加上菜单）</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><em>注意：城市数据库来自国家统计局&nbsp;<a href=\"http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/</a></em></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><strong><span style=\"font-size: 24px;\">在线文档：</span></strong></p><p style=\"width: 848px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Segoe UI&quot;, &quot;Helvetica Neue&quot;, &quot;PingFang SC&quot;, &quot;Noto Sans&quot;, &quot;Noto Sans CJK SC&quot;, &quot;Microsoft YaHei&quot;, 微软雅黑, sans-serif; font-size: medium; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"font-size: 18px;\">具体请参考插件手册：&nbsp;<a href=\"http://doc.mingsoft.net/plugs/cheng-shi-cha-jian/jie-shao.html\" target=\"_blank\" style=\"color: rgb(56, 56, 56);\">http://doc.mingsoft.net/plugs/cheng-shi-cha-jian/jie-shao.html</a></span></p><p><br/></p>', '城市插件', '', '', '目前最完整的城市数据库，精确到乡镇村  点击下载城市数据压缩包', '[{\"url\":\"/upload/1/cms/content/1686218452848.jpeg\",\"name\":\"1652091254863.jpeg\",\"path\":\"/upload/1/cms/content/1686218452848.jpeg\",\"uid\":1686218452829,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 18:00:33', 0, '', 0, '', 0, '2023-06-08 18:02:13', 0, '57', '2023-06-08 18:01:22', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666747315024973825, 1666653706550321156, '', '微信插件', '', '', '', '[{\"url\":\"/upload/1/cms/content/1686218500020.jpeg\",\"name\":\"1652093894689.jpeg\",\"path\":\"/upload/1/cms/content/1686218500020.jpeg\",\"uid\":1686218500003,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 18:01:31', 0, '', 0, '', 0, '2023-06-08 18:02:58', 0, '57', '2023-06-08 18:01:41', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666747903594876929, 1329316146811314177, '', '新版本富文本编辑器', '', '', '因为百度编辑器已经停止维护，这里推荐更新最新的基于vue 版本的编辑器mce，直接下载源码覆盖使用，发布附件、视频、图文更加方便\n\n注意：如果文章发布有修改过，建议源码覆盖的时候注意进行git比对。(https://gitee.com/mingSoft/MCMS 记得watch\\start\\fork 这样代码有修改会第一时间通过邮箱通知)', '[{\"url\":\"/upload/1/cms/content/1686218640385.png\",\"name\":\"1652078211570.png\",\"path\":\"/upload/1/cms/content/1686218640385.png\",\"uid\":1686218640357,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 18:03:42', 0, '', 0, '', 0, '2023-06-08 18:04:44', 0, '57', '2023-06-08 18:04:02', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666748214455717889, 1329316146811314177, '', '在线留言', '', '', '', '[{\"url\":\"blob:http://192.168.0.215:8080/830b687b-959f-4ce3-8ce2-27801d567d1d\",\"name\":\"1652079758611.jpeg\",\"path\":\"/upload/1/cms/content/1686218713768.jpeg\",\"uid\":1686218713749,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 18:04:51', 0, '', 0, '', 0, '2023-06-08 18:05:16', 0, NULL, '2023-06-08 18:05:16', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666748349411643394, 1329316146811314177, '', '自动静态化插件', '', '', '', '[{\"url\":\"/upload/1/cms/content/1686218746865.jpeg\",\"name\":\"1652095443016.jpeg\",\"path\":\"/upload/1/cms/content/1686218746865.jpeg\",\"uid\":1686218746844,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 18:05:21', 0, '', 0, '', 0, '2023-09-28 16:31:38', 0, '57', '2023-06-08 18:05:48', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1666748457335279617, 1329316146811314177, '', '分享插件', '', '', '', '[{\"url\":\"/upload/1/cms/content/1686218772032.png\",\"name\":\"1680171316440.png\",\"path\":\"/upload/1/cms/content/1686218772032.png\",\"uid\":1686218772009,\"status\":\"success\"}]', '', '', '0', '', '2023-06-08 18:05:55', 0, '', 0, '', 0, '2023-09-28 16:31:32', 0, '57', '2023-09-28 16:28:49', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1674243446207381505, 1666653706550321166, '<p><a href=\"https://www.mingsoft.net/banben.html\" target=\"_blank\">点击打开</a></p>', '信创国产化解决方案', '', '', '', '[{\"url\":\"blob:http://localhost:8080/dfc5bbe5-03fd-4b96-9941-066421106247\",\"name\":\"1609397756549.png .png\",\"path\":\"/upload/1/cms/content/1688005871192.png\",\"uid\":1688005870964,\"status\":\"success\"}]', '', '', '0', '', '2023-06-29 10:27:30', 0, '', 0, 'https://www.mingsoft.net/banben.html', 0, '2023-06-29 10:31:13', 0, '57', '2023-06-29 10:28:38', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1674243652642635777, 1666653706550321167, '<p><a href=\"https://www.mingsoft.net/\" target=\"_blank\">点击打开</a></p>', '低代码开发解决方案', '', '', '', '[{\"url\":\"blob:http://localhost:8080/b369fa81-fd5e-41db-9377-b2538b556b03\",\"name\":\"1609397756549.png .png\",\"path\":\"/upload/1/cms/content/1688005911798.png\",\"uid\":1688005911720,\"status\":\"success\"}]', '', '', '0', '', '2023-06-29 10:28:39', 0, '', 0, 'https://www.mingsoft.net/', 0, '2023-06-29 10:31:53', 0, '57', '2023-06-29 10:29:27', '57', 0);
INSERT INTO `cms_content` (`id`, `category_id`, `content_details`, `content_title`, `content_short_title`, `content_keyword`, `content_description`, `content_img`, `content_source`, `content_author`, `content_display`, `content_type`, `content_datetime`, `content_sort`, `content_tags`, `content_hit`, `content_out_link`, `has_detail_html`, `update_date`, `has_list_html`, `update_by`, `create_date`, `create_by`, `del`) VALUES (1674338953676128258, 1666653706550321162, '', '任务大厅', '', '', '', '[{\"url\":\"/upload/1/cms/content/1686278659721.jpg\",\"name\":\"a.png\",\"path\":\"/upload/1/cms/content/1686278659721.jpg\",\"uid\":16098386909801,\"status\":\"success\"}]', 'https://www.mingsoft.net/renwudating.html', '', '0', '', '2023-06-29 16:47:51', 0, '', 0, '', 0, '2024-02-04 15:11:23', 0, '57', '2023-06-29 17:05:47', '57', 0);
COMMIT;

-- ----------------------------
-- Table structure for cms_history_log
-- ----------------------------
DROP TABLE IF EXISTS `cms_history_log`;
CREATE TABLE `cms_history_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` bigint(20) unsigned NOT NULL COMMENT '文章编号',
  `people_id` int(20) DEFAULT NULL COMMENT '用户id',
  `hl_ip` varchar(255) DEFAULT NULL COMMENT '浏览ip',
  `hl_is_mobile` varchar(255) DEFAULT NULL COMMENT '是否为移动端',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章浏览记录';

-- ----------------------------
-- Records of cms_history_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for logger
-- ----------------------------
DROP TABLE IF EXISTS `logger`;
CREATE TABLE `logger` (
  `id` bigint(20) unsigned NOT NULL,
  `log_error_msg` text COMMENT '错误消息',
  `log_result` text COMMENT '返回参数',
  `log_param` longtext COMMENT '请求参数',
  `log_location` varchar(255) DEFAULT NULL COMMENT '所在地区',
  `log_user` varchar(255) DEFAULT NULL COMMENT '操作人员',
  `log_user_type` varchar(255) DEFAULT NULL COMMENT '用户类型',
  `log_business_type` varchar(255) DEFAULT NULL COMMENT '业务类型',
  `log_status` varchar(255) DEFAULT NULL COMMENT '请求状态',
  `log_url` varchar(255) DEFAULT NULL COMMENT '请求地址',
  `log_request_method` varchar(255) DEFAULT NULL COMMENT '请求方式',
  `log_method` varchar(255) DEFAULT NULL COMMENT '请求方法',
  `log_ip` varchar(255) DEFAULT NULL COMMENT 'IP',
  `log_title` varchar(255) DEFAULT NULL COMMENT '标题',
  `BUSINESS_ID` varchar(255) DEFAULT NULL COMMENT '业务id',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统日志';

-- ----------------------------
-- Records of logger
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for manager
-- ----------------------------
DROP TABLE IF EXISTS `manager`;
CREATE TABLE `manager` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `ROLE_IDS` varchar(11) DEFAULT NULL COMMENT '角色编号',
  `people_id` int(11) DEFAULT '0' COMMENT '用户编号即商家编号',
  `manager_admin` varchar(255) DEFAULT NULL COMMENT '管理员标识，超级管理员：super，子管理员：open',
  `manager_name` varchar(15) DEFAULT NULL COMMENT '管理员用户名',
  `manager_nickname` varchar(15) DEFAULT NULL COMMENT '管理员昵称',
  `manager_password` varchar(45) DEFAULT NULL COMMENT '管理员密码',
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  `MANAGER_LOCK` varchar(10) DEFAULT '0' COMMENT '锁定状态',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `fk_manager_role_id` (`ROLE_IDS`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- ----------------------------
-- Records of manager
-- ----------------------------
BEGIN;
INSERT INTO `manager` (`id`, `ROLE_IDS`, `people_id`, `manager_admin`, `manager_name`, `manager_nickname`, `manager_password`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `MANAGER_LOCK`) VALUES (57, '48', 0, 'super', 'msopen', 'msopen', '9d8622060de5f24937b60585c3f4d66b', NULL, NULL, NULL, NULL, 0, '0');
COMMIT;

-- ----------------------------
-- Table structure for mdiy_config
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_config`;
CREATE TABLE `mdiy_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `config_name` varchar(255) DEFAULT NULL COMMENT '模型名称',
  `config_data` varchar(4000) DEFAULT NULL COMMENT '模型数据',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` int(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` int(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  `NOT_DEL` int(1) DEFAULT '0' COMMENT '1为不能删除，主要用于系统默认数据,0为一般数据，主要是前端控制',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_config_name` (`config_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='自定义配置';

-- ----------------------------
-- Records of mdiy_config
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mdiy_dict
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_dict`;
CREATE TABLE `mdiy_dict` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `dict_value` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '数据值',
  `dict_label` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '标签名',
  `dict_type` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '类型',
  `dict_description` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '描述',
  `is_child` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '扩展业务标记',
  `dict_enable` varchar(11) COLLATE utf8_bin DEFAULT '1' COMMENT '启用状态',
  `dict_remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `dict_sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序（升序）',
  `UPDATE_BY` varchar(11) COLLATE utf8_bin DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) COLLATE utf8_bin DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  `NOT_DEL` int(1) DEFAULT '0' COMMENT '1为不能删除，主要用于系统默认数据,0为一般数据，主要是前端控制',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `inx_unique` (`dict_value`,`dict_label`,`dict_type`) USING BTREE,
  KEY `inx_dict_value` (`dict_value`) USING BTREE,
  KEY `inx_dict_label` (`dict_label`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=651 DEFAULT CHARSET=utf8 COLLATE=utf8_bin ROW_FORMAT=DYNAMIC COMMENT='字典表';

-- ----------------------------
-- Records of mdiy_dict
-- ----------------------------
BEGIN;
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (1, 'f', '幻灯', '文章属性', NULL, NULL, '1', NULL, 3, NULL, NULL, NULL, NULL, 3, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (2, 'p', '图片', '文章属性', NULL, NULL, '1', NULL, 1, '57', '2022-09-09 09:11:04', NULL, NULL, 3, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (3, 'c', '推荐', '文章属性', NULL, NULL, '1', NULL, 4, '57', '2021-03-26 08:39:05', NULL, NULL, 3, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (4, 'h', '头条', '文章属性', NULL, NULL, '1', NULL, 2, NULL, NULL, NULL, NULL, 3, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (621, 'cms', '文章', '自定义模型类型', NULL, '0', '1', NULL, 0, NULL, NULL, NULL, NULL, 3, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (642, 'cms', '文章', '自定义页面类型', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 3, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (643, 'c', '推荐', '栏目属性', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 3, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (644, 'n', '导航', '栏目属性', NULL, NULL, '1', NULL, 0, '57', '2022-09-09 14:39:35', NULL, NULL, 3, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (645, 'guest', '游客', '自定义页面类型', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (646, 'pt', '普通', '用户等级类型', NULL, NULL, '1', NULL, 0, '57', '2022-09-09 09:36:34', NULL, NULL, 0, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (647, 'gj', '高级', '用户等级类型', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (648, 'people', '会员', '自定义模型类型', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (649, 'people', '会员', '自定义页面类型', NULL, NULL, '1', NULL, 0, NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_dict` (`id`, `dict_value`, `dict_label`, `dict_type`, `dict_description`, `is_child`, `dict_enable`, `dict_remarks`, `dict_sort`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (650, '时政热点', '时政热点', '文章标签', NULL, NULL, '1', NULL, 0, '57', '2023-09-28 16:27:43', '106', '2023-06-08 15:13:13', 0, 0);
COMMIT;

-- ----------------------------
-- Table structure for mdiy_model
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_model`;
CREATE TABLE `mdiy_model` (
  `ID` bigint(19) unsigned NOT NULL,
  `model_json` longtext COMMENT 'json',
  `model_table_name` varchar(255) DEFAULT NULL COMMENT '模型表名',
  `model_name` varchar(30) DEFAULT NULL COMMENT '模型名称',
  `model_id_type` int(1) DEFAULT NULL COMMENT '0雪花1自增长',
  `model_type` varchar(255) DEFAULT NULL COMMENT '自定义模型类型，自定义表单不用该字段',
  `model_field` text COMMENT '模型字段',
  `model_custom_type` varchar(255) DEFAULT NULL COMMENT '类型，自定义表单：post，自定义模型：model',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(11) DEFAULT NULL COMMENT '修改人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(11) DEFAULT NULL COMMENT '创建人',
  `del` int(1) DEFAULT '0' COMMENT '删除标记',
  `NOT_DEL` int(1) DEFAULT '0' COMMENT '1为不能删除，主要用于系统默认数据,0为一般数据，主要是前端控制',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='自定义模型';

-- ----------------------------
-- Records of mdiy_model
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mdiy_page
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_page`;
CREATE TABLE `mdiy_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `page_key` varchar(255) NOT NULL COMMENT '自定义页面访问路径',
  `PAGE_ENABLE` int(1) DEFAULT '1' COMMENT '启用状态 0-关闭 1-启用',
  `page_path` varchar(255) NOT NULL COMMENT '自定义页面绑定模板的路径',
  `page_title` varchar(255) NOT NULL COMMENT '自定义页面标题',
  `page_type` varchar(255) DEFAULT NULL COMMENT '字典分类字段',
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `page_model_id` int(11) DEFAULT NULL COMMENT '模块id',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  `NOT_DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_page_key` (`page_key`) USING BTREE,
  KEY `idx_page_model_id` (`page_model_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='自定义页面表';

-- ----------------------------
-- Records of mdiy_page
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mdiy_tag
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_tag`;
CREATE TABLE `mdiy_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(255) DEFAULT NULL COMMENT '标签名称',
  `tag_type` varchar(255) DEFAULT NULL COMMENT '标签类型',
  `tag_sql` text COMMENT '标签sql',
  `tag_class` varchar(255) DEFAULT NULL COMMENT '标签类',
  `tag_description` varchar(255) DEFAULT NULL COMMENT '描述',
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  `NOT_DEL` int(1) DEFAULT '0' COMMENT '1为不能删除，主要用于系统默认数据,0为一般数据，主要是前端控制',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='标签';

-- ----------------------------
-- Records of mdiy_tag
-- ----------------------------
BEGIN;
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (3, 'arclist', 'list', '<#assign _typeid=\'\'/>\r\n<#assign _typetitle=\'\'/>\r\n<#-- 分页数，默认返回20条数据 -->\r\n<#assign _size=\'20\'/>\r\n<#if column?? && column.id?? && column.id?number gt 0>\r\n    <#assign  _typeid=\'${column.id}\'>\r\n</#if>\r\n<#if typeid??>\r\n    <#assign  _typeid=\'${typeid}\'>\r\n</#if>\r\n<#if typeids??>\r\n    <#assign  _typeids=\'${typeids}\'>\r\n</#if>\r\n<#if typetitle??>\r\n    <#assign  _typetitle=\'${typetitle}\'>\r\n</#if>\r\n<#if size??>\r\n    <#assign  _size=\'${size}\'>\r\n</#if>\r\n\r\n<#assign  _order=\'desc\'>\r\n\r\n<#if order?? >\r\n    <#if order==\'desc\'>\r\n        <#assign _order=\'desc\'>\r\n    </#if>\r\n    <#if order==\'asc\'>\r\n        <#assign _order=\'asc\'>\r\n    </#if>\r\n</#if>\r\n\r\n<#if orderby?? >\r\n    <#assign  _orderby = \'\'>\r\n    <#list orderby?split(\',\') as order>\r\n    <#-- 防止传空值拼接, -->\r\n        <#if !order?has_content>\r\n            <#continue >\r\n        </#if>\r\n        <#if _orderby?has_content>\r\n            <#assign _orderby += \',\'>\r\n        </#if>\r\n        <#if order==\'date\'>\r\n            <#assign  _orderby += \'cms_content.content_datetime\'>\r\n        <#elseif order==\'updatedate\'>\r\n            <#assign  _orderby += \'cms_content.cms_content.update_date\'>\r\n        <#elseif order==\'hit\'>\r\n            <#assign  _orderby += \'cms_content.content_hit\'>\r\n        <#elseif order==\'sort\'>\r\n            <#assign  _orderby += \'cms_content.content_sort\'>\r\n        </#if>\r\n        <#-- 去除_orderby末尾的逗号（如果存在） -->\r\n        <#if _orderby?has_content && _orderby?last_index_of(\',\') == _orderby?length - 1>\r\n            <#assign _orderby = _orderby?substring(0, _orderby?length - 1)>\r\n        </#if>\r\n        <#if _orderby?has_content>\r\n            <#assign _orderby += \' \' + _order>\r\n        </#if>\r\n    </#list>\r\n    <#-- 容错处理，如果什么都没有匹配到，则默认按文章时间排序 -->\r\n    <#if !_orderby?has_content>\r\n        <#assign _orderby = \'cms_content.content_datetime \' + _order>\r\n    </#if>\r\n<#else>\r\n    <#assign _orderby = \'cms_content.content_datetime \' + _order>\r\n</#if>\r\n\r\n\r\nSELECT\r\ncms_content.id AS \"id\",\r\ncontent_title AS \"title\",\r\ncontent_short_title AS \"shorttitle\",\r\ncontent_author AS \"author\",\r\ncontent_source AS \"source\",\r\ncontent_out_link AS \"outlink\",\r\ncontent_tags AS \"tags\",\r\n\r\ncategory.category_title AS \"typetitle\",\r\ncategory.category_short_title AS \"typeshorttitle\",\r\ncategory.id AS \"typeid\",\r\ncategory.category_path AS \"typepath\",\r\ncategory.category_img AS \"typelitpic\",\r\ncategory.category_ico AS \"typeico\",\r\ncategory.category_keyword as \"typekeyword\",\r\ncategory.top_id as \"topid\",\r\ncategory.category_id as \"parentid\",\r\ncategory.category_parent_ids as \"parentids\",\r\ncategory.category_type AS \"type\",\r\n<#--列表页动态链接-->\r\n<#if isDo?? && isDo>\r\n    CONCAT(\'${modelName}/list.do?style=${templateName!\"\"}&typeid=\', category.category_id) as \"typelink\",\r\n<#else>\r\n<#--栏目类型为链接-->\r\n    <#if shortSwitch?? && shortSwitch>\r\n        CONCAT(category.category_pinyin,\'.html\') AS \"typelink\",\r\n    <#else>\r\n        CONCAT(category.category_path,\'/index.html\') AS \"typelink\",\r\n    </#if>\r\n</#if>\r\ncontent_description AS \"descrip\",\r\ncontent_hit AS \"hit\",\r\ncontent_type AS \"flag\",\r\ncms_content.content_keyword AS \"keyword\",\r\ncontent_img AS \"litpic\",\r\n<#--内容页动态链接-->\r\n<#if isDo?? && isDo>\r\n    CONCAT(\'${modelName}/view.do?style=${templateName!\"\"}&id=\', cms_content.id) as \"link\",\r\n<#else>\r\n    <#if shortSwitch?? && shortSwitch>\r\n        CONCAT(cms_content.id,\'.html\') AS \"link\",\r\n    <#else>\r\n        CONCAT(CONCAT( category.category_path, \'/\' ), CONCAT(CASE category_type WHEN  \'2\' THEN \'index\' ELSE cms_content.id END , \'.html\' )) as \"link\",\r\n    </#if>\r\n</#if>\r\n<#if tableName??>${tableName}.*,</#if>\r\ncontent_datetime AS \"date\"\r\nFROM\r\ncms_content\r\nLEFT JOIN\r\ncms_category as category\r\nON cms_content.category_id = category.id\r\n<#--判断是否有自定义模型表-->\r\n<#if tableName??>\r\n    LEFT JOIN ${tableName} ON ${tableName}.link_id=cms_content.id\r\n</#if>\r\nWHERE\r\ncontent_display=0\r\nand category_display=\'enable\'\r\nand cms_content.del=0\r\n\r\n<#--文章审核-->\r\n<#if contentApprove?? && contentApprove>\r\n    and cms_content.progress_status=\'终审通过\'\r\n</#if>\r\n<#--根据站点编号查询-->\r\n<#if appId?? >\r\n    and cms_content.app_id=${appId}\r\n    and cms_content.id>0\r\n</#if>\r\n<#--判断是否有搜索分类集合，暂时移除 _typeid=\"\" 条件-->\r\n<#if search?? && !typeid??>\r\n    and category_is_search=\'enable\'\r\n<#-- 文章标签 -->\r\n    <#if search.content_tag??>and FIND_IN_SET(\'${search.content_tag}\',content_tags) > 0</#if>\r\n    <#if search.categoryIds?has_content>\r\n        and (\r\n        <#list search.categoryIds?split(\",\") as item>\r\n            <#if item?index gt 0>\r\n                or\r\n            </#if>\r\n            (cms_content.category_id=${item}\r\n            or cms_content.category_id in (select id FROM cms_category where cms_category.del=0\r\n            <#if _typetitle?has_content>\r\n                and cms_category.category_title=\'${_typetitle}\'\r\n            </#if>\r\n            and FIND_IN_SET(${item},CATEGORY_PARENT_IDS) > 0)\r\n            )\r\n        </#list>\r\n        )\r\n    </#if>\r\n<#--标题-->\r\n    <#if search.content_title??> and content_title like CONCAT(CONCAT(\'%\',\'${search.content_title}\'),\'%\')</#if>\r\n<#--作者-->\r\n    <#if search.content_author??> and content_author like CONCAT(CONCAT(\'%\',\'${search.content_author}\'),\'%\')</#if>\r\n<#--来源-->\r\n    <#if search.content_source??> and content_source like CONCAT(CONCAT(\'%\',\'${search.content_source}\'),\'%\')</#if>\r\n<#--属性-->\r\n    <#if search.content_type??>\r\n        and(<#list search.content_type?split(\',\') as item>\r\n        <#if item?index gt 0> or</#if>\r\n        FIND_IN_SET(\'${item}\',cms_content.content_type) > 0\r\n    </#list>)\r\n    </#if>\r\n<#--描述-->\r\n    <#if search.content_description??>\r\n        and content_description like CONCAT(CONCAT(\'%\',\'${search.content_description}\'),\'%\')\r\n    </#if>\r\n<#--关键字-->\r\n    <#if search.content_keyword??> and content_keyword like CONCAT(CONCAT(\'%\',\'${search.content_keyword}\'),\'%\')</#if>\r\n<#--内容-->\r\n    <#if search.content_details??> and content_details like CONCAT(CONCAT(\'%\',\'${search.content_details}\'),\'%\')</#if>\r\n<#--自定义顺序-->\r\n    <#if search.content_sort??> and content_sort=${search.content_sort}</#if>\r\n<#--时间范围-->\r\n    <#if search.content_datetime_start??&&search.content_datetime_end??>\r\n        and content_datetime between \'${search.content_datetime_start}\' and \'${search.content_datetime_end}\'\r\n    </#if>\r\n<#else>\r\n<#--查询栏目-->\r\n    <#if _typeids?has_content>\r\n        and (\r\n        <#list _typeids?split(\",\") as item>\r\n            <#if item?index gt 0>\r\n                or\r\n            </#if>\r\n            (cms_content.category_id=${item}\r\n            or cms_content.category_id in (select id FROM cms_category where cms_category.del=0\r\n            <#if _typetitle?has_content>\r\n                and cms_category.category_title=\'${_typetitle}\'\r\n            </#if>\r\n            and FIND_IN_SET(${item},CATEGORY_PARENT_IDS) > 0)\r\n            )\r\n        </#list>\r\n        )\r\n    <#elseif _typeid?has_content && _typeid?string != \'0\' >\r\n        and (cms_content.category_id=${_typeid}\r\n        or cms_content.category_id in (select id FROM cms_category where cms_category.del=0\r\n        <#if _typetitle?has_content>\r\n            and cms_category.category_title=\'${_typetitle}\'\r\n        </#if>\r\n        and FIND_IN_SET(${_typeid},CATEGORY_PARENT_IDS) > 0))\r\n    </#if>\r\n</#if>\r\n<#--判断搜索分类结束-->\r\n<#--标题-->\r\n<#if content_title??> and content_title like CONCAT(CONCAT(\'%\',\'${content_title}\'),\'%\')</#if>\r\n<#--作者-->\r\n<#if content_author??> and content_author like CONCAT(CONCAT(\'%\',\'${content_author}\'),\'%\')</#if>\r\n<#--来源-->\r\n<#if content_source??> and content_source like CONCAT(CONCAT(\'%\',\'${content_source}\'),\'%\')</#if>\r\n<#--属性-->\r\n<#if content_type??> and content_type like CONCAT(CONCAT(\'%\',\'${content_type}\'),\'%\')</#if>\r\n<#--描述-->\r\n<#if content_description??> and content_description like CONCAT(CONCAT(\'%\',\'${content_description}\'),\'%\')</#if>\r\n<#--关键字-->\r\n<#if content_keyword??> and content_keyword like CONCAT(CONCAT(\'%\',\'${content_keyword}\'),\'%\')</#if>\r\n<#--内容-->\r\n<#if content_details??> and content_details like CONCAT(CONCAT(\'%\',\'${content_details}\'),\'%\')</#if>\r\n<#--自定义顺序-->\r\n<#if content_sort??> and content_sort=${content_sort}</#if>\r\n<#--自定义模型-->\r\n<#if diyModel??>\r\n    <#list diyModel as dm>\r\n        <#assign json=\"${dm}\"?eval />\r\n        and ${tableName}.${json.key} like CONCAT(CONCAT(\'%\',\'${json.value}\'),\'%\')\r\n    </#list>\r\n</#if>\r\n<#--文章属性-->\r\n<#if flag?? >\r\n    and(<#list flag?split(\',\') as item>\r\n    <#if item?index gt 0> or</#if>\r\n    FIND_IN_SET(\'${item}\',cms_content.content_type) > 0\r\n</#list>)\r\n</#if>\r\n<#if noflag??>\r\n    and(<#list noflag?split(\',\') as item>\r\n    <#if item?index gt 0> and</#if>\r\n    FIND_IN_SET(\'${item}\',cms_content.content_type)=0\r\n</#list> or cms_content.content_type is null)\r\n</#if>\r\n\r\n<#--字段排序-->\r\nORDER BY\r\n<#if topflag??>\r\n    CASE\r\n    <#list topflag?split(\",\") as item>\r\n        WHEN FIND_IN_SET(\'${item}\',cms_content.content_type)>0 THEN\r\n        ${item?index}\r\n    </#list>\r\n    ELSE 100\r\n    END,\r\n</#if>\r\n${_orderby}\r\nLIMIT\r\n<#--判断是否分页-->\r\n<#if ispaging?? && (pageTag.pageNo)??>\r\n    ${((pageTag.pageNo-1)*_size?eval)?c},${_size?default(20)}\r\n<#else>\r\n    ${_size?default(20)}\r\n</#if>\r\n\r\n', NULL, '文章列表', NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (4, 'channel', 'list', '<#assign _typeid=\'0\'/>\r\n<#assign _size=\'9999\'/>\r\n<#if column?? && column.id?? && column.id?number gt 0>\r\n    <#assign  _typeid=\'${column.id}\'>\r\n    <#assign  selfid=\'${column.id}\'>\r\n</#if>\r\n\r\n<#if typeid??>\r\n    <#assign  _typeid=\'${typeid}\'>\r\n</#if>\r\n<#if typeids??>\r\n    <#assign  _typeids=\'${typeids}\'>\r\n</#if>\r\n<#if size??>\r\n    <#assign  _size=\'${size}\'>\r\n</#if>\r\n\r\nselect\r\ncms_category.id as \"id\",\r\ncms_category.id as \"typeid\",\r\ncms_category.category_title as \"typetitle\",\r\ncms_category.category_short_title as \"typeshorttitle\",\r\n<#--动态链接-->\r\n<#if isDo?? && isDo>\r\n    IF(cms_category.category_type=2,CONCAT(\'${modelName}/view.do?style=${templateName!\"\"}&typeid=\', cms_category.id),CONCAT(\'${modelName}/list.do?style=${templateName!\"\"}&typeid=\', cms_category.id)) as \"typelink\",\r\n<#else>\r\n<#--栏目类型为链接-->\r\n    <#if shortSwitch?? && shortSwitch>\r\n        CONCAT(cms_category.category_pinyin,\'.html\') AS \"typelink\",\r\n    <#else>\r\n        CONCAT(cms_category.category_path,\'/index.html\') as \"typelink\",\r\n    </#if>\r\n</#if>\r\ncms_category.category_keyword as \"typekeyword\",\r\ncms_category.category_diy_url as \"typeurl\",\r\ncms_category.category_flag as \"flag\",\r\ncms_category.category_id as \"parentid\",\r\ncms_category.category_parent_ids as \"parentids\",\r\ncms_category.category_descrip as \"typedescrip\",\r\ncms_category.category_type as \"type\",\r\ncms_category.category_path as \"typepath\",\r\ncms_category.leaf as \"typeleaf\",\r\ncms_category.category_img as \"typelitpic\" ,\r\ncms_category.category_ico as \"typeico\" ,\r\n<#if tableName??>${tableName}.*,</#if>\r\n( SELECT count(*) FROM cms_category cc WHERE cc.category_id = cms_category.id AND cc.del = 0 ) AS \"childsize\"\r\nfrom\r\ncms_category\r\n<#--判断是否有自定义模型表-->\r\n<#if tableName??>LEFT JOIN ${tableName} ON ${tableName}.link_id=cms_category.id</#if>\r\nwhere\r\ncms_category.del= 0\r\nand  cms_category.category_display = \'enable\'\r\n<#--自定义模型-->\r\n<#if diyModel??>\r\n    <#list diyModel as dm>\r\n        <#assign json=\"${dm}\"?eval />\r\n        and ${tableName}.${json.key} like CONCAT(\'%\',\'${json.value}\',\'%\')\r\n    </#list>\r\n</#if>\r\n<#--根据站点编号查询-->\r\n<#if appId?? >\r\n    and cms_category.app_id=${appId}\r\n</#if>\r\n\r\n<#--栏目属性-->\r\n<#if flag?? >\r\n    and\r\n    (<#list flag?split(\',\') as item>\r\n    <#if item?index gt 0> or</#if>\r\n    FIND_IN_SET(\'${item}\',cms_category.category_flag) > 0\r\n</#list>)\r\n</#if>\r\n\r\n<#if noflag?? >\r\n    and\r\n    (<#list noflag?split(\',\') as item>\r\n    <#if item?index gt 0> and</#if>\r\n    FIND_IN_SET(\'${item}\',cms_category.category_flag)=0\r\n</#list> or cms_category.category_flag is null)\r\n</#if>\r\n\r\n<#--type默认son-->\r\n<#if !type??||!type?has_content>\r\n    <#assign type=\'son\'/>\r\n</#if>\r\n\r\n<#-- 如果有typeids参数，则只查询typeids参数指定的栏目  -->\r\n<#if _typeids?has_content>\r\n    and cms_category.id in (${_typeids})\r\n<#elseif type?has_content>\r\n    <#--顶级栏目（单个）-->\r\n    <#if type==\'top\'>\r\n        <#if _typeid != \'0\'>\r\n            and (cms_category.id = cms_category.top_id or cms_category.top_id = 0)\r\n        </#if>\r\n\r\n    <#elseif type==\'nav\'>\r\n        and(cms_category.category_id=0 or cms_category.category_id is null)\r\n\r\n    <#--同级栏目（多个）-->\r\n    <#elseif type==\'level\'>\r\n        <#if _typeid != \'0\'>\r\n            and cms_category.category_id=(select category_id from cms_category where id=${_typeid})\r\n        </#if>\r\n\r\n    <#--当前栏目（单个）-->\r\n    <#elseif type==\'self\'>\r\n        <#if _typeid != \'0\'>\r\n            and cms_category.id=${_typeid}\r\n        </#if>\r\n\r\n    <#--当前栏目的所属栏目（多个）-->\r\n    <#elseif type==\'path\'>\r\n        <#if _typeid != \'0\'>\r\n            and cms_category.id in\r\n            (<#if column?? && column.categoryParentIds??>${column.categoryParentIds},</#if>${_typeid})\r\n        </#if>\r\n\r\n    <#--子栏目（多个）-->\r\n    <#elseif type==\'son\'>\r\n        <#if _typeid != \'0\'>\r\n            and cms_category.category_id=${_typeid}\r\n        </#if>\r\n\r\n    <#--上一级栏目没有则取当前栏目（单个）-->\r\n    <#elseif type==\'parent\'>\r\n        <#if _typeid != \'0\'>\r\n            and\r\n            <#if column?? && column.categoryId??>\r\n                cms_category.id=${column.categoryId}\r\n            <#else>\r\n                cms_category.id=(select category_id from cms_category where id=${_typeid})\r\n            </#if>\r\n        </#if>\r\n    </#if>\r\n\r\n<#else> <#--默认顶级栏目-->\r\n    and\r\n    <#if _typeid != \'0\'>\r\n        cms_category.id=${_typeid}\r\n    <#else>\r\n        (cms_category.category_id=0 or cms_category.category_id is null)\r\n    </#if>\r\n</#if>\r\n\r\n<#--字段排序-->\r\n<#if type == \'path\'>\r\n    ORDER BY cms_category.category_path asc\r\n<#else>\r\n    <#if orderby?? >\r\n        ORDER BY\r\n        <#if orderby==\'date\'> cms_category.create_date\r\n        <#elseif orderby==\'sort\'> cms_category.category_sort\r\n        <#else>cms_category.id\r\n        </#if>\r\n    </#if>\r\n\r\n    <#if order?? >\r\n        <#if order==\'desc\'> desc</#if>\r\n        <#if order==\'asc\'> asc</#if>\r\n    </#if>\r\n</#if>\r\nLIMIT\r\n${_size?default(9999)}\r\n', NULL, '通用栏目', NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (5, 'global', 'single', 'select\n  APP_NAME as \"name\",\n  app_logo as \"logo\",\n  app_keyword as \"keyword\",\n  app_description as \"descrip\",\n  app_copyright as \"copyright\",\n  \'${contextPath}\' as \"contextpath\",\n  <#--动态解析 -->\n  <#if isDo?? && isDo>\n    \'${url}\' as \"url\",\n    \'${url}\' as \"host\",\n    \'/\' as \"html\",\n  <#--使用地址栏的域名 -->\n  <#else>\n    <#if shortSwitch?? && shortSwitch>\n      CONCAT(\'${url}\',\'${appDir}<#if appDir?has_content>/</#if>\') as \"url\",\n      \'<#if appDir?has_content>/</#if>${appDir}/\' as \"html\",\n    <#else>\n      CONCAT(CONCAT(\'${url}\',\'${html}\'),\'<#if appDir?has_content>/${appDir}</#if>\') as \"url\",\n      CONCAT(CONCAT(\'/${html}\',\'<#if appDir?has_content>/${appDir}</#if>\'),\'/\') as \"html\",\n    </#if>\n    \'${url}\' as \"host\",\n  </#if>\n    CONCAT(CONCAT(CONCAT(CONCAT(\'template/\',id),\'/\'),app_style),\'/\') as \"style\"\nfrom app\n  <#--根据站点编号查询-->\n  <#if appId?? >\n    where id = ${appId}\n  </#if>\n', NULL, '全局', NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (7, 'field', 'single', 'SELECT\n    cms_content.id as \"id\",\n    <#--这里会存在id覆盖的情况,所以需要在cms_content.id下面-->\n    <#if tableName??>${tableName}.*,</#if>\n    <#--查询站点编号-->\n    <#if appId??>\n        cms_content.app_id as \"appId\",\n    </#if>\n    content_title as \"title\",\n    content_short_title AS \"shorttitle\",\n    content_author as \"author\",\n    content_source as \"source\",\n    content_out_link as \"outlink\",\n    content_details as \"content\",\n    content_datetime as \"date\",\n    content_description as \"descrip\",\n    content_keyword as \"keyword\",\n    <#if contextPath?? && contextPath != \"/\">\n    	CONCAT(CONCAT( \'<script type=\"text/javascript\" src=\"${contextPath}/cms/content/\', cms_content.id),\'/hit.do\"></script>\') as \"hit\",\n    <#else>\n    	CONCAT(CONCAT( \'<script type=\"text/javascript\" src=\"/cms/content/\', cms_content.id),\'/hit.do\"></script>\') as \"hit\",\n    </#if>\n    content_type as \"flag\",\n    content_tags as \"tags\",\n    category_title as \"typetitle\",\n    cms_content.content_img as \"litpic\",\n    <#--内容页动态链接-->\n    <#if isDo?? && isDo>\n    	CONCAT(\'/mcms/view.do?id=\', cms_content.id) as \"link\",\n    <#else>\n    	<#if shortSwitch?? && shortSwitch>\n    		CONCAT(cms_content.id, \'.html\' ) as \"link\",\n    	<#else>\n    		CONCAT(CONCAT( cms_category.category_path, \'/\' ), CONCAT(cms_content.id, \'.html\' )) as \"link\",\n    	</#if>\n    </#if>\n    cms_category.id as \"typeid\",\n    cms_category.leaf as \"typeleaf\",\n    cms_category.category_title as \"typetitle\",\n    cms_category.category_short_title AS \"typeshorttitle\",\n    cms_category.category_img as \"typelitpic\",\n    cms_category.category_ico as \"typeico\",\n    cms_category.category_path as \"typepath\",\n    cms_category.top_id as \"topid\",\n    cms_category.category_flag as \"typeflag\",\n    cms_category.category_id as \"parentid\",\n    cms_category.category_parent_ids as \"parentids\",\n    cms_category.category_keyword as \"typekeyword\",\n    cms_category.category_descrip as \"typedescrip\",\n    <#--动态链接-->\n    <#if isDo?? && isDo>\n    	CONCAT(\'/${modelName}/list.do?typeid=\', cms_category.id) as \"typelink\"\n    <#else>\n    	<#if shortSwitch?? && shortSwitch>\n    		CONCAT(category_pinyin,\'.html\') AS \"typelink\"\n    	<#else>\n    		CONCAT(category_path,\'/index.html\') AS \"typelink\"\n    	</#if>\n    </#if>\n\nFROM cms_content\n    LEFT JOIN cms_category  ON\n    cms_category.id = cms_content.category_id\n    <#--判断是否有自定义模型表-->\n    <#if tableName??>left join ${tableName} on ${tableName}.link_id=cms_content.id</#if>\nWHERE\n    <#--如果是栏目列表页没有文章id所以只取栏目id-->\n    <#if column??&&column.id??&&!id??>\n        cms_category.id=${column.id} and\n    </#if>\n    <#--根据站点编号查询-->\n    <#if appId??>\n        cms_content.app_id = ${appId} and\n    </#if>\n    cms_content.del=0\n    <#if id??> and cms_content.id=${id}</#if>\n\n', NULL, '文章内容', NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (8, 'pre', 'single', '<#assign select=\"\'\'\"/>\n<#if orderby?? >\n	<#if orderby==\"date\">\n	  <#assign  _orderby=\"content_datetime\">\n	<#elseif orderby==\"updatedate\">\n	  <#assign  _orderby=\"cms_content.update_date\">\n	<#elseif orderby==\"hit\">\n	  <#assign  _orderby=\"content_hit\">\n	<#elseif orderby==\"sort\">\n	  <#assign  _orderby=\"content_sort\">\n	<#else><#assign  _orderby=\"cms_content.id\"></#if>\n<#else>\n	<#assign  _orderby=\"cms_content.id\">\n</#if>\n<#--上一页-->\n<#if pageTag.preId??>\n	SELECT\n    cms_content.id as \"id\",\n    content_title as \"title\",\n    content_author as \"author\",\n    content_source as \"source\",\n    content_details as \"content\",\n    category.category_title as \"typename\",\n    category.category_id as \"typeid\",\n    <#if isDo?? && isDo>\n      CONCAT(\'/${modelName}/list.do?typeid=\', cms_category.id) as \"typelink\",\n    <#else>\n    	<#if shortSwitch?? && shortSwitch>\n            CONCAT(category.category_pinyin,\'.html\') AS \"typelink\",\n    	<#else>\n    		CONCAT(category.category_path,\'/index.html\') AS \"typelink\",\n    	</#if>\n    </#if>\n    content_img as \"litpic\",\n    <#--内容页动态链接-->\n    <#if isDo?? && isDo>\n    	CONCAT(\'${modelName}/view.do?id=\', cms_content.id,\'&orderby=${_orderby}\',\'&order=${order!\'ASC\'}\',\'&typeid=${typeid}\') as \"link\",\n    <#else>\n      <#if shortSwitch?? && shortSwitch>\n        CONCAT(cms_content.id,\'.html\') AS \"link\",\n      <#else>\n    	CONCAT(CONCAT(category_path,\'/\'),CONCAT(cms_content.id,\'.html\')) AS \"link\",\n      </#if>\n    </#if>\n    content_description as \"descrip\",\n    content_hit as \"hit\",\n    content_type as \"flag\",\n    content_keyword as \"keyword\"\n	FROM cms_content\n    LEFT JOIN cms_category category ON cms_content.category_id=category.id\n	WHERE cms_content.id=${pageTag.preId}\n<#else>\n	SELECT\n    ${select} as \"id\",\n    \'没有了\' as \"title\",\n    ${select} as \"author\",\n    ${select} as \"source\",\n    ${select} as \"content\",\n    ${select} as \"typename\",\n    ${select} as \"typeid\",\n    ${select} as \"typelink\",\n    ${select} as \"litpic\",\n    ${select} as \"typelink\",\n    ${select} as \"date\",\n    ${select} as \"descrip\",\n    ${select} as \"hit\",\n    ${select} as \"flag\",\n    ${select} as \"keyword\"\n    FROM dual\n</#if>\n', NULL, '文章上一篇', NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (9, 'page', 'single', '<#if pageTag??>\nselect\n  <#--是否开启短链接-->\n    <#if shortSwitch?? && shortSwitch>\n	    \'${shortSwitch?string(\'true\',\'false\')}\' as \"shortSwitch\",\n    </#if>\n	<#if !(pageTag.indexUrl??)>\n		<#--判断是否有栏目对象，用于搜索不传栏目-->\n		<#if column??>\n			<#if shortSwitch?? && shortSwitch>\n				<#assign path=column.categoryPinyin/>\n			<#else>\n				<#assign path=column.categoryPath/>\n			</#if>\n		<#else>\n			<#assign path=\'\' />\n		</#if>\n		<#--总记录数、总页数-->\n		\'${pageTag.total}\' as \"total\",\n		\'${pageTag.size}\' as \"size\",\n\n		<#--记录总数-->\n		\'${pageTag.rcount}\' as \"rcount\",\n		<#--当前页码-->\n		\'${pageTag.pageNo}\' as \"cur\",\n		<#--首页-->\n		<#if shortSwitch?? && shortSwitch>\n			CONCAT(\'${path}\', \'.html\') as \"index\",\n		<#else>\n			CONCAT(\'${path}\', \'/index.html\') as \"index\",\n		</#if>\n		<#--上一页-->\n		<#if (pageTag.pageNo?eval-1) gt 1>\n			<#if shortSwitch?? && shortSwitch>\n				CONCAT(\'${path}\',\'-${pageTag.pageNo?eval-1}.html\') as \"pre\",\n			<#else>\n				CONCAT(\'${path}\',\'/list-${pageTag.pageNo?eval-1}.html\') as \"pre\",\n			</#if>\n		<#else>\n			<#if shortSwitch?? && shortSwitch>\n				CONCAT(\'${path}\',\'.html\') as \"pre\",\n			<#else>\n				CONCAT(\'${path}\',\'/index.html\') as \"pre\",\n			</#if>\n		</#if>\n		<#--下一页-->\n		<#if pageTag.total lte 1>\n			<#if shortSwitch?? && shortSwitch>\n				CONCAT(\'${path}\', \'.html\') as \"next\",\n				CONCAT(\'${path}\', \'.html\') as \"last\"\n			<#else>\n				CONCAT(\'${path}\', \'/index.html\') as \"next\",\n				CONCAT(\'${path}\', \'/index.html\') as \"last\"\n			</#if>\n		<#else>\n			<#if pageTag.pageNo?eval gte pageTag.total>\n				<#if shortSwitch?? && shortSwitch>\n					CONCAT(\'${path}\',\'-${pageTag.total}.html\') as \"next\",\n				<#else>\n					CONCAT(\'${path}\',\'/list-${pageTag.total}.html\') as \"next\",\n				</#if>\n			<#else>\n				<#if shortSwitch?? && shortSwitch>\n					CONCAT(\'${path}\',\'-${pageTag.pageNo?eval+1}.html\') as \"next\",\n				<#else>\n					CONCAT(\'${path}\',\'/list-${pageTag.pageNo?eval+1}.html\') as \"next\",\n				</#if>\n			</#if>\n			<#--最后一页-->\n			<#if shortSwitch?? && shortSwitch>\n				CONCAT(\'${path}\',\'-${pageTag.total}.html\') as \"last\"\n			<#else>\n				CONCAT(\'${path}\',\'/list-${pageTag.total}.html\') as \"last\"\n			</#if>\n		</#if>\n	<#else>\n		<#--判断是否是搜索页面-->\n		\'${pageTag.indexUrl}\' as \"index\",\n		\'${pageTag.lastUrl}\' as \"last\",\n		\'${pageTag.preUrl}\' as \"pre\",\n		\'${pageTag.nextUrl}\' as \"next\",\n		\'${pageTag.total}\' as \"total\",\n		\'${pageTag.size}\' as \"size\",\n		\'${pageTag.rcount}\' as \"rcount\",\n		\'${pageTag.pageNo}\' as \"cur\"\n	</#if>\n    from dual\n</#if>', NULL, '通用分页', NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (10, 'next', 'single', '<#assign select=\"\'\'\"/>\n<#if orderby?? >\n	<#if orderby==\"date\">\n		<#assign  _orderby=\"content_datetime\">\n	<#elseif orderby==\"updatedate\">\n		<#assign  _orderby=\"cms_content.update_date\">\n	<#elseif orderby==\"hit\">\n		<#assign  _orderby=\"content_hit\">\n	<#elseif orderby==\"sort\">\n		<#assign  _orderby=\"content_sort\">\n	<#else>\n		<#assign  _orderby=\"cms_content.id\"></#if>\n	<#else>\n		<#assign  _orderby=\"cms_content.id\">\n	</#if>\n<#--开始-->\n<#if pageTag.nextId??>\n	SELECT\n    cms_content.id as \"id\",\n    content_title as \"title\",\n    content_author as \"author\",\n    content_source as \"source\",\n    content_details as \"content\",\n    category.category_title as \"typename\",\n    category.category_id as \"typeid\",\n    <#if isDo?? && isDo>\n        CONCAT(\'/${modelName}/list.do?typeid=\', cms_category.id) as \"typelink\",\n    <#else>\n        <#if shortSwitch?? && shortSwitch>\n            CONCAT(category.category_pinyin,\'.html\') AS \"typelink\",\n        <#else>\n            CONCAT(category.category_path,\'/index.html\') AS \"typelink\",\n        </#if>\n    </#if>\n    content_img as \"litpic\",\n    <#--内容页动态链接-->\n    <#if isDo?? && isDo>\n        CONCAT(\'${modelName}/view.do?id=\', cms_content.id,\'&orderby=${_orderby}\',\'&order=${order!\'ASC\'}\',\'&typeid=${typeid}\') as \"link\",\n    <#else>\n        <#if shortSwitch?? && shortSwitch>\n            CONCAT(cms_content.id,\'.html\') AS \"link\",\n        <#else>\n            CONCAT(CONCAT(category_path,\'/\'),CONCAT(cms_content.id,\'.html\')) AS \"link\",\n        </#if>\n    </#if>\n    content_description as \"descrip\",\n    content_hit as \"hit\",\n    content_type as \"flag\",\n    content_keyword as \"keyword\"\n	FROM cms_content\n    LEFT JOIN cms_category category ON cms_content.category_id=category.id\n	WHERE cms_content.id=${pageTag.nextId}\n<#else>\n  SELECT\n    ${select} as \"id\",\n    \'没有了\' as \"title\",\n    ${select} as \"author\",\n    ${select} as \"source\",\n    ${select} as \"content\",\n    ${select} as \"typename\",\n    ${select} as \"typeid\",\n    ${select} as \"typelink\",\n    ${select} as \"litpic\",\n    ${select} as \"link\",\n    ${select} as \"date\",\n    ${select} as \"descrip\",\n    ${select} as \"hit\",\n    ${select} as \"flag\",\n    ${select} as \"keyword\"\n  FROM dual\n</#if>\n', NULL, '文章下一篇', NULL, NULL, NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (11, 'diyform', 'macro', '<#macro ms_diyform formName>\n<div id=\"form\" v-cloak style=\"width: 30%; margin: 5% auto\">\n  <div id=\"formModel\">\n    <!--会自动渲染代码生成器的表单-->\n  </div>\n  <!--必须包含验证码-->\n  <el-form ref=\"form\" :model=\"form\" :rules=\"rules\" label-position=\"right\" size=\"large\" label-width=\"120px\">\n    <el-row :gutter=\"0\" justify=\"start\" align=\"top\">\n      <el-col :span=\"12\">\n        <el-form-item label=\"验证码\" prop=\"rand_code\">\n          <el-input\n                  v-model=\"form.rand_code\"\n                  :disabled=\"false\"\n                  :readonly=\"false\"\n                  :clearable=\"true\"\n                  placeholder=\"请输入验证码\">\n          </el-input>\n        </el-form-item>\n      </el-col>\n      <el-col :span=\"12\">\n        <div style=\"display: flex; height: 38px;margin-left: 1em; align-items: center; cursor: pointer\">\n          <img :src=\"verifCode\" class=\"code-img\" @click=\"code\"/>\n          <div @click=\"code\" style=\"margin-left: 10px\">\n            看不清？换一张\n          </div>\n        </div>\n      </el-col>\n    </el-row>\n    <el-form-item label=\"  \">\n      <el-button @click=\"save\" type=\"primary\" :loading=\"isLoading\" style=\"width: 200px\">\n        {{isLoading ? \'保存中\' : \'保存\'}}\n      </el-button>\n    </el-form-item>\n  </el-form>\n</div>\n<script>\n  //vue的实例名称必须为 from\n  var form = new Vue({\n    el: \'#form\',\n    data: {\n      formModel: undefined, //自定义业务的vue对象\n      verifCode:  \"/code.do?t=\" + new Date().getTime(),\n      isLoading: false,\n      form: {\n        rand_code: \'\'\n      },\n      rules: {\n        rand_code: [\n          {required: true, message: \'请输入验证码\', trigger: \'blur\'},\n          {min: 1, max: 4, message: \'长度不能超过4个字符\', trigger: \'change\'}\n        ],\n      },\n    },\n    methods: {\n      save: function () {\n        var that = this;\n        that.isLoading = true;\n        //将验证码值复制到自定义模型\n        form.formModel.form.rand_code = this.form.rand_code;\n        //调用自定义模型的保存\n        that.formModel.save(function (res) {\n          if (res.result) {\n            that.$notify({\n              title: \'成功\',\n              type: \'success\',\n              message: \'保存成功!\'\n            });\n\n          } else {\n            that.$notify({\n              title: \'失败\',\n              message: res.msg,\n              type: \'warning\'\n            });\n          }\n          that.isLoading = false;\n        });\n      },\n      code: function () {\n        this.verifCode = \"/code.do?t=\" + (new Date).getTime();\n      }\n    },\n    created: function () {\n      var that = this;\n      ms.mdiy.model.form(\"formModel\", { \"modelName\": \"${formName}\" }).then(function(obj) {\n        that.formModel = obj;\n      });\n    }\n  });\n</script>\n</#macro>', NULL, '智能表单', '57', '2022-11-15 16:10:49', NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (12, 'data', 'list', 'SELECT\n	cms_content.id AS \"id\",\n	content_title AS \"title\",\n	content_author AS \"author\",\n	content_source AS \"source\",\n	content_details AS \"content\",\n	content_out_link AS \"outlink\",\n	content_short_title AS \"shorttitle\",\n	category.category_title AS \"typetitle\",\n	category.category_short_title AS \"typeshorttitle\",\n	category.id AS \"typeid\",\n	category.category_path AS \"typepath\",\n	category.category_img AS \"typelitpic\",\n	category.category_ico AS \"typeico\",\n	category.category_keyword AS \"typekeyword\",\n	category.top_id AS \"topid\",\n	category.category_parent_ids AS \"parentids\",\n	category.category_type AS \"type\",\n	<#--列表页动态链接-->\n	<#if isDo?? && isDo>\n	    CONCAT(\'/${modelName}/list.do?style=${templateName!\"\"}&typeid=\', category.category_id) AS \"typelink\",\n	<#else>\n	<#if shortSwitch?? && shortSwitch>\n		CONCAT(category_pinyin,\'.html\') AS \"typelink\",\n	<#else>\n		CONCAT(category_path,\'/index.html\') AS \"typelink\",\n	</#if>\n	</#if>\n	content_description AS \"descrip\",\n	content_hit AS \"hit\",\n	content_type AS \"flag\",\n	cms_content.content_keyword AS \"keyword\",\n	content_img AS \"litpic\",\n	<#--内容页动态链接-->\n	<#if isDo?? && isDo>\n		CONCAT(\'/${modelName}/view.do?style=${templateName!\"\"}&id=\', cms_content.id) AS \"link\",\n	<#else>\n		<#if shortSwitch?? && shortSwitch>\n			CONCAT(cms_content.id,\'.html\') AS \"link\",\n		<#else>\n			CONCAT(CONCAT(CONCAT(category.category_path,\'/\'),cms_content.id),\'.html\') AS \"link\",\n		</#if>\n	</#if>\n 	<#if tableName??>${tableName}.*,</#if>\n	content_datetime AS \"date\"\nFROM\n	cms_content LEFT JOIN cms_category category ON cms_content.category_id = category.id\n	<#--判断是否有自定义模型表-->\n	<#if tableName??>\n		LEFT JOIN ${tableName} ON ${tableName}.link_id=cms_content.id\n	</#if>\nWHERE\n  content_display=0\n  and category_display=\'enable\'\n  and cms_content.del=0\n	<#--根据站点编号查询-->\n	<#if appId?? >\n		and cms_content.app_id=${appId}\n	</#if>\n	and cms_content.id=${dataid}\n\n', NULL, '单篇', '57', '2022-11-15 16:10:49', NULL, NULL, 0, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (17, 'tag', 'single', '<#assign _typeid=\'0\'/>\n<#assign order=\'desc\'/>\n<#assign _size=\'99\'/>\n<#if column?? && column.id?? && column.id?number gt 0>\n  <#assign  _typeid=\'${column.id}\'>\n</#if>\n\n<#if typeid??>\n  <#assign  _typeid=\'${typeid}\'>\n</#if>\n<#if size??>\n  <#assign  _size=\'${size}\'>\n</#if>\n\nSELECT\n    GROUP_CONCAT(DISTINCT content_tags ) AS tags\nFROM\n    cms_content\nLEFT JOIN cms_category ON cms_content.category_id = cms_category.id\nWHERE\n  cms_category.category_display = \'enable\'\n  AND cms_content.del = 0\n  AND cms_content.content_display = 0\n  AND LENGTH( cms_content.content_tags )>0\n    <#if _typeid != \'0\'>\n      AND (cms_category.id = ${_typeid} or FIND_IN_SET(${_typeid},cms_category.category_parent_ids) > 0)\n    </#if>\n    <#if appId??>\n  AND cms_content.app_id = ${appId}\n    </#if>\nORDER BY CONTENT_HIT DESC\nLimit ${_size}\n', '', '文章标签配置，不提供模板使用', '', '2023-06-12 17:26:19', '57', '2023-05-23 09:31:49', 57, 1);
INSERT INTO `mdiy_tag` (`id`, `tag_name`, `tag_type`, `tag_sql`, `tag_class`, `tag_description`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (18, 'tags', 'macro', '<#assign tags=\"\">\n<#macro ms_tags>\n    <#if tag??>\n        <#assign ___tags = tag.tags?split(\",\")>\n		<#list ___tags as tag>\n		    <#list ___tags as _tag>\n		        <#if tag == _tag>\n		            <#if tag_index == _tag_index>\n		            	<#assign tags+=tag+\",\">\n		            <#else>\n		            <#break>\n		            </#if>\n		        </#if>\n		    </#list>\n		</#list>\n    </#if>\n</#macro>', '', '文章标签', '', '2023-06-12 17:26:21', '57', '2023-05-23 09:31:40', 57, 1);
COMMIT;

-- ----------------------------
-- Table structure for model
-- ----------------------------
DROP TABLE IF EXISTS `model`;
CREATE TABLE `model` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `model_id` int(22) DEFAULT NULL COMMENT '模块的父模块id',
  `model_parent_ids` varchar(300) DEFAULT NULL COMMENT '父级编号集合，从小到大排序',
  `model_code` varchar(255) DEFAULT NULL COMMENT '模块编码',
  `model_title` varchar(150) DEFAULT NULL COMMENT '模块标题',
  `model_url` varchar(255) DEFAULT NULL COMMENT '模块连接地址',
  `model_icon` varchar(120) DEFAULT NULL COMMENT '模块图标',
  `model_sort` int(11) DEFAULT NULL COMMENT '模块的排序',
  `model_ismenu` int(1) DEFAULT '0' COMMENT '模块是否是菜单',
  `IS_CHILD` varchar(300) DEFAULT NULL COMMENT '扩展字段',
  `model_datetime` datetime DEFAULT NULL,
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_model_id` (`model_id`) USING BTREE,
  KEY `idx_model_title` (`model_title`,`model_url`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1820 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='模块表';

-- ----------------------------
-- Records of model
-- ----------------------------
BEGIN;
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (23, NULL, NULL, '01000000', '权限管理', '', 'icon-quanxianguanli', 5, 1, NULL, '2014-09-09 10:12:22', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (84, NULL, NULL, '12000000', '系统设置', '', 'icon-xitongguanli', 3, 1, NULL, '2014-12-19 22:30:24', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (86, 84, '84', '12010000', '应用设置', 'basic/app/app.do', '', 2, 1, NULL, '2014-12-19 22:31:59', '57', '2023-01-03 13:51:29', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (87, 84, '84', '12020000', '模版管理', 'basic/template/index.do', '', 1, 1, NULL, '2014-12-19 22:32:50', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (182, 86, '84,86', '12010004', '修改', 'basic:app:update', '', 0, 0, NULL, '2017-09-05 16:14:42', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (183, 23, '23', '01030000', '菜单管理', 'basic/model/index.do', '', 0, 1, NULL, '2017-09-05 13:09:26', '57', '2023-01-03 10:46:19', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (184, 183, '23,183', '01030001', '查看', 'basic:model:view', '', 0, 0, NULL, '2017-09-05 13:10:43', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (201, 183, '23,183', '01030002', '新增', 'basic:model:save', NULL, 0, 0, NULL, '2019-12-28 14:26:29', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (202, 183, '23,183', '01030004', '修改', 'basic:model:update', '', 0, 0, NULL, '2019-12-28 14:26:33', '57', '2023-01-06 15:10:56', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (204, 87, '84,87', '12020002', '上传', 'basic:template:upload', '', 0, 0, '', '2019-12-28 14:26:37', '', NULL, '', NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (406, 23, '23', '406', '角色管理', 'basic/role/index.do', '', 0, 1, NULL, '2019-08-03 19:18:47', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (407, 406, '23,406', '407', '新增', 'basic:role:save', '', 0, 0, NULL, '2019-08-03 19:19:10', '57', '2023-01-07 14:58:52', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (408, 406, '23,406', '408', '修改', 'basic:role:update', '', 0, 0, NULL, '2019-08-03 19:19:34', '57', '2023-01-06 09:59:49', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (409, 406, '23,406', '409', '删除', 'basic:role:del', '', 0, 0, NULL, '2019-08-03 19:19:59', '57', '2023-01-03 11:42:47', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (411, 23, '23', '411', '管理员管理', 'basic/manager/index.do', '', 0, 1, NULL, '2019-08-04 12:54:38', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (412, 411, '23,411', '412', '查看', 'basic:manager:view', '', 0, 0, NULL, '2019-08-04 12:56:13', '57', '2023-01-03 11:57:03', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (663, 411, '23,411', '15737980803547570', '删除', 'basic:manager:del', '', 0, 0, NULL, '2019-11-19 18:19:35', '57', '2023-01-06 14:33:09', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (664, 411, '23,411', '15737980853527702', '更新', 'basic:manager:update', '', 0, 0, NULL, '2019-11-19 18:21:08', '57', '2023-01-06 14:33:32', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (665, 411, '23,411', '15735981803267702', '新增', 'basic:manager:save', '', 0, 0, NULL, '2019-11-19 18:21:42', '57', '2023-01-07 15:06:12', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (668, 183, '23,183', '668', '删除', 'basic:model:del', '', 0, 0, NULL, '2019-11-19 18:35:49', '57', '2023-01-06 15:09:37', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (672, 87, '84,87', '5434345', '删除', 'basic:template:del', '', 0, 0, '', '2019-11-19 19:05:09', '', NULL, '', NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (673, 87, '84,87', '452435345', '更新', 'basic:template:update', '', 0, 0, '', '2019-11-19 19:05:35', '', NULL, '', NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (685, 84, '84', '65123656532', '系统日志', 'basic/log/index.do', '', 0, 1, NULL, '2019-11-22 21:13:50', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (686, 685, '84,685', '351463145634', '查看', 'basic:log:view', '', 0, 0, NULL, '2019-11-22 21:14:24', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (706, NULL, NULL, '02000000', '内容管理', '', 'icon-neirongguanli', 5, 1, NULL, '2019-11-23 20:14:59', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (707, 706, '706', '02980000', '文章管理', 'cms/content/index.do', '', 3, 1, NULL, '2019-11-23 20:16:25', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (708, 706, '706', '02990000', '栏目管理', 'cms/category/index.do', '', 2, 1, NULL, '2019-11-23 20:16:50', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (709, 706, '706', '02020000', '静态化', 'cms/generate/index.do', '', 1, 1, NULL, '2019-11-23 20:17:15', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (710, 709, '706,709', '02020004', '生成文章', 'cms:generate:article', '', 0, 0, NULL, '2019-11-23 20:17:39', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (711, 709, '706,709', '02020003', '生成栏目', 'cms:generate:column', '', 0, 0, NULL, '2019-11-23 20:18:05', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (713, 709, '706,709', '02020001', '查看', 'cms:generate:view', '', 0, 0, NULL, '2019-11-23 20:18:48', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (714, 709, '706,709', '56454656', '生成主页', 'cms:generate:index', '', 0, 0, NULL, '2019-11-23 20:20:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (715, 708, '706,708', '02990004', '新增', 'cms:category:save', '', 0, 0, NULL, '2019-11-23 20:20:42', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (716, 708, '706,708', '02990003', '修改', 'cms:category:update', '', 0, 0, NULL, '2019-11-23 20:21:36', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (717, 708, '706,708', '02990001', '查看', 'cms:category:view', '', 0, 0, NULL, '2019-11-23 20:22:05', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (718, 707, '706,707', '02980002', '新增', 'cms:content:save', '', 0, 0, NULL, '2019-11-23 20:22:35', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (719, 707, '706,707', '02980004', '修改', 'cms:content:update', '', 0, 0, NULL, '2019-11-23 20:22:57', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (720, 707, '706,707', '02980001', '查看', 'cms:content:view', '', 0, 0, NULL, '2019-11-23 20:23:15', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (721, 707, '706,707', '721', '删除', 'cms:content:del', '', 0, 0, NULL, '2019-11-23 21:02:28', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1653, 708, '706,708', '1320', '删除', 'cms:category:del', '', 0, 0, NULL, '2020-09-22 07:41:21', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1700, NULL, NULL, '16197622071887865', '自定义模块', '', 'icon-zhanqun', 0, 1, '', '2021-05-25 22:07:10', '57', '2022-02-28 09:40:50', '', NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1701, 1700, '1700', '16197622071885990', '自定义页面', 'mdiy/page/index.do', '', 0, 1, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1702, 1701, '1700,1701', '16197622071882306', '新增', 'mdiy:page:save', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1703, 1701, '1700,1701', '16197622071889774', '删除', 'mdiy:page:del', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1704, 1701, '1700,1701', '16197622071883980', '更新', 'mdiy:page:update', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1705, 1701, '1700,1701', '16197622071888834', '查看', 'mdiy:page:view', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1706, 1701, '1700,1701', '161976235700096088', '导入', 'mdiy:form:importJson', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1707, 1700, '1700', '16197622071880623', '自定义模型', 'mdiy/model/index.do', '', 0, 1, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1708, 1707, '1700,1707', '16197622071887303', '新增', 'mdiy:model:save', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1709, 1707, '1700,1707', '16197622071881168', '删除', 'mdiy:model:del', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1710, 1707, '1700,1707', '16197622071881215', '更新', 'mdiy:model:update', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1711, 1707, '1700,1707', '16197622071884291', '查看', 'mdiy:model:view', NULL, 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1712, 1707, '1700,1707', '161976234500028132', '导入', 'mdiy:model:importJson', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1724, 1700, '1700', '162034834200049578', '自定义业务', 'mdiy/form/index.do', 'icon-caidan', 0, 1, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1725, 1724, '1700,1724', '162034839300098062', '导入', 'mdiy:form:importJson', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1726, 1724, '1700,1724', '162034842600047746', '删除', 'mdiy:form:del', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1727, 1724, '1700,1724', '16203484400006602', '查看', 'mdiy:form:view', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1728, 1724, '1700,1724', '162034845600099530', '保存', 'mdiy:form:save', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1729, 1724, '1700,1724', '162034847100023820', '更新', 'mdiy:form:update', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1730, 1724, '1700,1724', '162143180100032708', '新增业务数据', 'mdiy:formData:save', '', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1731, 1724, '1700,1724', '162143181700031623', '删除业务数据', 'mdiy:formData:del', 'icon-caidan', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1732, 1724, '1700,1724', '162143576500025187', '更新业务数据', 'mdiy:formData:update', 'icon-caidan', 0, 0, NULL, '2021-05-25 22:07:10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1764, 406, '23,406', '409', '查看', 'basic:role:view', '', 0, 0, NULL, '2022-05-07 14:12:58', '57', '2023-01-03 11:42:51', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1765, 86, '84,86', '12010004', '查看', 'basic:app:view', '', 0, 0, NULL, '2022-05-07 14:13:36', '57', '2023-01-03 13:51:03', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1767, 87, '84,87', '12010004', '查看', 'basic:template:view', '', 0, 0, '', '2022-05-07 14:17:03', '57', '2022-05-07 14:17:18', '', NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1780, 706, '706', NULL, '文章属性', '/mdiy/dict/data/index.do?dictType=文章属性', NULL, 3, 1, NULL, '2022-05-31 10:53:44', '57', '2022-05-31 10:54:12', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1781, 1780, '706,1780', NULL, '设置', 'mdiy:dictData:文章属性:settings', NULL, NULL, 0, NULL, '2022-05-31 10:53:44', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1782, 706, '706', NULL, '栏目属性', '/mdiy/dict/data/index.do?dictType=栏目属性', NULL, 2, 1, NULL, '2022-05-31 10:53:55', '57', '2022-05-31 10:54:50', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1783, 1782, '706,1782', NULL, '设置', 'mdiy:dictData:栏目属性:settings', NULL, NULL, 0, NULL, '2022-05-31 10:53:55', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1801, 1724, '1700,1724', '', '查看业务数据', 'mdiy:formData:view', '', 0, 0, '', '2022-09-09 09:41:36', NULL, '2022-09-09 09:41:36', '57', '2022-09-09 09:41:36', 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1802, 1700, '1700', '16197622071884456', '自定义配置', 'mdiy/config/index.do', NULL, 0, 1, NULL, '2023-04-13 15:24:41', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1803, 1802, '1700,1802', '16197622071881449', '新增', 'mdiy:config:save', NULL, 0, 0, NULL, '2023-04-13 15:24:41', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1804, 1802, '1700,1802', '16197622071889126', '删除', 'mdiy:config:del', NULL, 0, 0, NULL, '2023-04-13 15:24:41', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1805, 1802, '1700,1802', '16197622071888369', '更新', 'mdiy:config:update', '', 0, 0, NULL, '2023-04-13 15:24:41', '57', '2022-08-25 11:19:04', NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1806, 1802, '1700,1802', '16197622071882134', '查看', 'mdiy:config:view', NULL, 0, 0, NULL, '2023-04-13 15:24:41', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1807, 1802, '1700,1802', '161976231700026503', '导入', 'mdiy:config:importJson', NULL, 0, 0, NULL, '2023-04-13 15:24:41', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1808, 1802, '1700,1802', '', '更新配置数据', 'mdiy:configData:update', '', 0, 0, NULL, '2023-04-13 15:24:41', NULL, '2022-08-25 11:20:48', '57', '2022-08-25 11:20:48', 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1809, 1802, '1700,1802', '', '删除配置数据', 'mdiy:configData:del', '', 0, 0, NULL, '2023-04-13 15:24:41', NULL, '2022-08-25 11:21:22', '57', '2022-08-25 11:21:22', 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1810, 1802, '1700,1802', '', '新增配置数据', 'mdiy:configData:save', '', 0, 0, NULL, '2023-04-13 15:24:41', NULL, '2022-08-25 11:21:52', '57', '2022-08-25 11:21:52', 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1811, 1802, '1700,1802', '', '查看配置数据', 'mdiy:configData:view', '', 0, 0, '', '2023-04-13 15:24:41', NULL, '2022-08-25 22:29:48', '57', '2022-08-25 22:29:48', 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1812, 1700, '1700', '15725929177747726', '自定义字典', 'mdiy/dict/index.do', NULL, 0, 1, NULL, '2023-08-12 09:11:16', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1813, 1812, '1700,1812', '15725929177745034', '查看', 'mdiy:dict:view', NULL, 0, 0, NULL, '2023-08-12 09:11:16', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1814, 1812, '1700,1812', '15725929177742474', '新增', 'mdiy:dict:save', NULL, 0, 0, NULL, '2023-08-12 09:11:16', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1815, 1812, '1700,1812', '15725929177744138', '修改', 'mdiy:dict:update', NULL, 0, 0, NULL, '2023-08-12 09:11:16', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1816, 1812, '1700,1812', '15725929177748034', '删除', 'mdiy:dict:del', NULL, 0, 0, NULL, '2023-08-12 09:11:16', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1817, 1812, '1700,1812', NULL, '导入', 'mdiy:dict:importJson', NULL, 0, 0, NULL, '2023-08-12 09:11:17', NULL, NULL, NULL, NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1818, 84, '84', '', '系统信息', 'basic/system/index.do', '', 11, 1, '', '2024-02-01 16:33:10', '57', '2024-02-04 16:52:14', '', NULL, 0);
INSERT INTO `model` (`id`, `model_id`, `model_parent_ids`, `model_code`, `model_title`, `model_url`, `model_icon`, `model_sort`, `model_ismenu`, `IS_CHILD`, `model_datetime`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`) VALUES (1819, 1818, '84,1818', NULL, '查看', 'system:view', NULL, 0, 0, NULL, '2024-02-01 16:33:10', NULL, NULL, NULL, NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for role
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名',
  `UPDATE_BY` varchar(11) DEFAULT NULL COMMENT '更新人',
  `UPDATE_DATE` datetime DEFAULT NULL COMMENT '更新时间',
  `CREATE_BY` varchar(11) DEFAULT NULL COMMENT '创建人',
  `CREATE_DATE` datetime DEFAULT NULL COMMENT '创建时间',
  `DEL` int(1) DEFAULT '0' COMMENT '删除标记',
  `NOT_DEL` int(1) DEFAULT '0' COMMENT '1为不能删除，主要用于系统默认数据,0为一般数据，主要是前端控制',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色表';

-- ----------------------------
-- Records of role
-- ----------------------------
BEGIN;
INSERT INTO `role` (`id`, `role_name`, `UPDATE_BY`, `UPDATE_DATE`, `CREATE_BY`, `CREATE_DATE`, `DEL`, `NOT_DEL`) VALUES (48, '默认角色', '57', '2022-02-27 10:50:25', NULL, NULL, 0, 1);
COMMIT;

-- ----------------------------
-- Table structure for role_model
-- ----------------------------
DROP TABLE IF EXISTS `role_model`;
CREATE TABLE `role_model` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `model_id` int(22) DEFAULT NULL COMMENT '模块编号',
  `role_id` int(22) DEFAULT NULL COMMENT '角色编号',
  PRIMARY KEY (`id`),
  KEY `fk_model_id` (`model_id`) USING BTREE,
  KEY `fk_role_id` (`role_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色模块关联表';

-- ----------------------------
-- Records of role_model
-- ----------------------------
BEGIN;
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (1, 182, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (2, 204, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (3, 672, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (4, 673, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (5, 184, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (6, 201, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (7, 202, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (8, 668, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (9, 407, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (10, 408, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (11, 409, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (12, 412, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (13, 663, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (14, 664, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (15, 665, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (16, 686, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (17, 718, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (18, 719, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (19, 720, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (20, 721, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (21, 715, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (22, 716, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (23, 717, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (24, 1653, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (25, 710, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (26, 711, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (27, 713, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (28, 714, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (29, 1702, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (30, 1703, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (31, 1704, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (32, 1705, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (33, 1706, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (34, 1708, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (35, 1709, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (36, 1710, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (37, 1711, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (38, 1712, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (49, 1725, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (50, 1726, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (51, 1727, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (52, 1728, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (53, 1729, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (54, 1730, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (55, 1731, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (56, 1732, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (57, 84, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (58, 86, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (59, 87, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (60, 23, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (61, 183, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (62, 406, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (63, 411, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (64, 685, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (65, 706, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (66, 707, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (67, 708, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (68, 709, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (69, 1700, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (70, 1701, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (71, 1707, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (74, 1724, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (75, 1764, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (76, 1765, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (77, 1767, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (78, 1780, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (79, 1781, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (80, 1782, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (81, 1783, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (82, 1801, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (83, 1802, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (84, 1803, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (85, 1804, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (86, 1805, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (87, 1806, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (88, 1807, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (89, 1808, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (90, 1809, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (91, 1810, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (92, 1811, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (93, 1812, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (94, 1813, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (95, 1814, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (96, 1815, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (97, 1816, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (98, 1817, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (99, 1818, 48);
INSERT INTO `role_model` (`id`, `model_id`, `role_id`) VALUES (100, 1819, 48);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
