# 設定変数初期化
use strict;
my %cf;

#┌─────────────────────────────────
#│ Magick Counter : init.cgi - 2011/05/14
#│ Copyright (c) KentWeb
#│ http://www.kent-web.com/
#└─────────────────────────────────
# バージョン情報
$cf{version} = 'Magick Counter v1.0';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このスクリプトはフリーソフトです。このスクリプトを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
#  設定内容
#===========================================================

# 二重カウント防止の時間（分単位で指定）
# → この機能を使用しない場合は「0」とする
$cf{limit_time} = 60;

# 最少表示桁数
# 【例】6桁設定の場合 :「123」→「000123」
$cf{digit} = 7;

# データファイル【サーバパス】
$cf{datfile} = "./data/mgcount.dat";

# 画像ディレクトリ【サーバパス】
# （最後は / で閉じないこと）
$cf{gifdir} = "./gif";

# BOTっぽいアクセスをカウントしない
$cf{ignore_bot} = 1;

#===========================================================
#  設定完了
#===========================================================

# 設定内容を返す
sub init {
	return %cf;
}


1;

