# Contribution Guide

## Guideline
The development of robot systems requires a variety of tools within a coordinated development environment. 
This list is an attempt to show the variety of open and free tools in software and hardware development, which are necessary for professional robot development.
Since the development processes are often of crucial importance for the approval of such systems, the interaction of development processes and tools is emphasized.  This ensures the safety and security of such developments based on requirements.

## How to contribute to the list      
Additions on the list will be done by Pull Requests.      

* Every new project on the list needs to be a new pull request.      
* Create a fork of awesome-robotic-tooling.          
* Insert the project into one of the categories of your fork. We can discuss later on in the 'Pull Request' comments whether another category fits better or we need to open a new one.          
* Add your project in the following format:           
 ``- [Project Name](Project URL) - A sentence that describes your project and what makes it different from others.``
* Describe in at least one sentence why you think the project meets the guidelines. You can find a discussion about the definition of awesome in robotics [here](https://discourse.ros.org/t/about-the-definition-of-awesome-in-robotics/).  In the end, however, we decided against fixed rules for participation in the list. It is up to you to give us the right reasons to convince us in a ``Pull Request``.    
* Create a pull request and wait for the reaction of the maintainer. We may ask you additional questions or you may need to make changes to your pull request.    
* To reorder the list or for creating new categories please open an issue. After a discussion in the issue comments, we can decide on how to reorganize the list based on a pull request from you.     

Further details on how do `Pull Requests` can be found in the official GitHub [documentation](https://docs.github.com/en/free-pro-team@latest/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request).
