# Android App Library

## About
Welcome to this repository. The Android App Library is an Open Source project containing multiple apps which showcase one or more features of the Android platform.
All source code is written in Java with the exception of the XML styling in layout files and the SQL in database queries.

This work is connected to the bachelor thesis of the repisotory owner [Lukas Plenk](https://github.com/LukPle) from the 
[Deggendorf Institute of Technology](https://www.th-deg.de/en) but can be used for any purpose.

Thank you for checking out the library and supporting Open Source projects.

## Goals
Learning different aspects of coding for Android can be tricky. Some websites and articles focus to much on descriptive explanations and do not offer useful code to inspect. Code examples on the other hand often include to many features at once with sometimes even outdated and deprecated components. 
This library should give everyone simple apps that diplay only certain features of Android. They can be fully modified and used for different scenarios.
This makes the learning process more simple, easy to understand and fun.

The library is also useful for people who have a coding background but are not familiar with writing apps for Android because the applications in this repository cover most of the common features and display them in an isolated example. The code is also well documented for more accessability. This enables developers to use different samples and combine them for their idea or the anticipated use case without doing a lot of research on how to specificly code for Android.

## List of Apps

Applications for the following Android features are available:

* Methods for Input
  * [Button with Intent](https://github.com/LukPle/button-intent.git)
  * [ImageButton](https://github.com/LukPle/imagebutton.git)
  * [EditText](https://github.com/LukPle/edittext-intent-extra.git)
  * [Checkbox, RadioButton and Switch](https://github.com/LukPle/checkbox-radiobutton-switch.git)
  * [Time and Date Picker](https://github.com/LukPle/time-and-date-picker.git)

* Output of Content
  * [Text To Speech](https://github.com/LukPle/text-to-speech.git)
  * [VideoView and RatingBar](https://github.com/LukPle/videoview-ratingbar.git)

* Screen Transitions
  * [Splashscreen](https://github.com/LukPle/splashscreen.git) 
  * [Animation and Transition](https://github.com/LukPle/animation-transition.git) 

* Navigation
  * [Bottom Navigation](https://github.com/LukPle/bottom-navigation.git)
  * [Navigation Drawer](https://github.com/LukPle/navigation-drawer.git)

* Lists
  * [ListView](https://github.com/LukPle/listview.git)
  * [RecyclerView](https://github.com/LukPle/recyclerview-adapter.git)
    * [RecyclerView with FloatingActionButton](https://github.com/LukPle/floating-action-button.git)
    * [RecyclerView with Swipe To Delete](https://github.com/LukPle/recyclerview-swipe-to-delete.git)
    * [RecyclerView with Update-Dialog](https://github.com/LukPle/recyclerview-update-dialog.git)
    * [RecyclerView with Update-Activity](https://github.com/LukPle/recyclerview-update-activity.git)
    * [RecyclerView with SearchView](https://github.com/LukPle/recyclerview-searchview.git)
    * [RecyclerView with Sorting](https://github.com/LukPle/recyclerview-sort-items.git)

* External Data and Permissions
  * [Location and MapView](https://github.com/LukPle/mapview-location.git)
  * [Camera, Gallery and ImageView](https://github.com/LukPle/imageview-camera-gallery.git)

* Notifications and Widgets 
  * [Foreground Notification](https://github.com/LukPle/android-notification-foreground.git)
  * [Background Notification](https://github.com/LukPle/android-notification-background.git)
  * [Widget](https://github.com/LukPle/android-widget.git)

* Database
  * [Room Database](https://github.com/LukPle/room-database.git)

## Feedback and Contribution
There is currently no option for contribution or providing any help. Community management will be available in the near future.

Please consider the [Code of Conduct](CODE_OF_CONDUCT.md) when interacting with other people and be nice to each other.

## Licensing
This project uses the [MIT](LICENSE) license.
