package springboot;

import java.io.File;
import java.net.InetAddress;

import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import cn.hutool.core.util.BooleanUtil;
import luckyclient.netty.NettyClient;
import luckyclient.utils.config.SysConfig;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 * @author seagull
 * @date 2018727 10:16:40
 */
@SpringBootApplication
public class RunService {
	/*
	 * ע⣺벻Ҫڴ˴ʹIDEAУRunͻˣͻ˵ʽչĵ
	 * IDEAʱ룬VM options,-Dfile.encoding=GBK
	 * */

	public  static final String APPLICATION_HOME = new ApplicationHome(RunService.class).getSource().getAbsolutePath();
	private static final Logger log = LoggerFactory.getLogger(RunService.class);
	private static final Boolean NETTY_MODEL= BooleanUtil.toBoolean(SysConfig.getConfiguration().getProperty("netty.model"));
	public static String CLIENT_IP = "";
	public static void main(String[] args) throws InterruptedException {
		// TODO Auto-generated method stub
		PropertyConfigurator.configure(APPLICATION_HOME + File.separator +"bootlog4j.conf");
		SpringApplication.run(RunService.class, args);
		try {
			CLIENT_IP = InetAddress.getLocalHost().getHostAddress();
			log.info("ͻ˼,Ժ......IP:{}",CLIENT_IP);
		} catch (Exception e) {
			log.error("ȡIP쳣......", e);
		}
		if(NETTY_MODEL){
			try {
				log.info("##################ͻnetty#################");
				NettyClient.start();
			} catch (Exception e) {
				log.error("ӷnetty쳣......");
				e.printStackTrace();
			}
		}else{
			HttpImpl.checkHostNet();
		}
	}

}
