package springboot;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import luckyclient.remote.entity.monitor.Server;
import luckyclient.utils.config.SysConfig;
import luckyclient.utils.httputils.HttpRequest;
import springboot.model.RunBatchCaseEntity;
import springboot.model.RunTaskEntity;
import springboot.model.WebDebugCaseEntity;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 * @author seagull
 * @date 2018727 10:28:32
 */
@RestController
public class HttpImpl {
	private static final Logger log = LoggerFactory.getLogger(HttpImpl.class);
	private static final String OS=System.getProperty("os.name").toLowerCase();
	/**
	 * Զ
	 * @param req HTTP
	 * @return 
	 */
	@PostMapping("/runTask")
	private String runTask(HttpServletRequest req) {
		StringBuilder sb = new StringBuilder();
		try {
			BufferedReader reader = req.getReader();
			char[] buff = new char[1024];
			int len;
			while ((len = reader.read(buff)) != -1) {
				sb.append(buff, 0, len);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		log.info("ʼתRunTaskEntityִʵ...");
		RunTaskEntity runTaskEntity = JSONObject.parseObject(sb.toString(), RunTaskEntity.class);
		log.info("TaskId:{},SchedulingName:{},LoadPath:{}",runTaskEntity.getTaskId(),runTaskEntity.getSchedulingName(),runTaskEntity.getLoadPath());
		try{
			log.info("ʼȡͻ·...");
			File file =new File(RunService.APPLICATION_HOME+runTaskEntity.getLoadPath());
			log.info("ͻ·:{}",file.getAbsolutePath());
			if  (!file .isDirectory())      
			{       
				log.warn("ͻ˲׮·ڣ顾{}",file.getPath());
				return "ͻ˲׮·ڣ顾"+file.getPath()+"";
			}
			log.info("ʼRuntime...");
			Runtime run = Runtime.getRuntime();
			StringBuilder sbf=new StringBuilder();
			sbf.append(runTaskEntity.getTaskId()).append(" ");
			sbf.append(runTaskEntity.getLoadPath());
			log.info("ģʽԳ...:{}  ID:{}",runTaskEntity.getSchedulingName(),runTaskEntity.getTaskId());
			if(OS.startsWith("win")){
				log.info("ʼwindowsд...");
				run.exec("cmd.exe /k start " + "task.cmd" +" "+ sbf.toString(), null,new File(RunService.APPLICATION_HOME+File.separator));
				log.info("windowsд...");
			}else{
				log.info("ʼLinuxű...");
				Process ps = Runtime.getRuntime().exec(RunService.APPLICATION_HOME+File.separator+"task.sh"+ " " +sbf.toString());
		        ps.waitFor();
				log.info("Linuxű...");
			}			
		} catch (Exception e) {
			log.error("ģʽԳ쳣",e);
			return "ģʽԳ쳣";
		}
		return "ģʽԳ";
	}
	
	/**
	 * 
	 * @param req HTTP
	 * @return 
	 */
	@PostMapping("/runBatchCase")
	private String runBatchCase(HttpServletRequest req) {
		StringBuilder sbd = new StringBuilder();
		try {
			BufferedReader reader = req.getReader();
			char[] buff = new char[1024];
			int len;
			while ((len = reader.read(buff)) != -1) {
				sbd.append(buff, 0, len);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		log.info("ʼתRunBatchCaseEntityִʵ...");
		RunBatchCaseEntity runBatchCaseEntity = JSONObject.parseObject(sbd.toString(), RunBatchCaseEntity.class);
		
		String projectName = runBatchCaseEntity.getProjectname();
		String taskId = runBatchCaseEntity.getTaskid();
		String loadPath = runBatchCaseEntity.getLoadpath();
		String batchCase = runBatchCaseEntity.getBatchcase();
		log.info(":{}",batchCase);
		try{
			log.info("ʼȡͻ·...");
			File file =new File(RunService.APPLICATION_HOME+loadPath);
			log.info("ͻ·:{}",file.getAbsolutePath());
			if  (!file .isDirectory())      
			{    
				log.warn("ͻ˲׮·ڣ顾{}",file.getPath());
				return "ͻ˲׮·ڣ顾"+file.getPath()+"";
			}
			log.info("ʼRuntime...");
			Runtime run = Runtime.getRuntime();
			StringBuilder sb=new StringBuilder();
			sb.append(taskId).append(" ");
			sb.append(batchCase).append(" ");
			sb.append(loadPath);
			log.info("ģʽԳ...Ŀ:{}  ID:{}",projectName,taskId);
			if(OS.startsWith("win")){
				log.info("ʼwindowsд...");
				run.exec("cmd.exe /k start " + "task_batch.cmd" + " " +sb.toString(), null,new File(RunService.APPLICATION_HOME+File.separator));
				log.info("windowsд...");
			}else{
				log.info("ʼLinuxű...");
				Process ps = Runtime.getRuntime().exec(RunService.APPLICATION_HOME+File.separator+"task_batch.sh"+ " " +sb.toString());
		        ps.waitFor();
		        log.info("Linuxű...");
			}		
		} catch (Exception e) {		
			e.printStackTrace();
			log.error("ģʽԳ쳣",e);
			return "ģʽԳ쳣";
		} 
		return "ģʽԳ";
	}
	
	/**
	 * webȽӿ
	 * @param req HTTP
	 * @return صн
	 */
	@PostMapping("/webDebugCase")
	private String webDebugCase(HttpServletRequest req) {
		StringBuilder sbd = new StringBuilder();
		try {
			BufferedReader reader = req.getReader();
			char[] buff = new char[1024];
			int len;
			while ((len = reader.read(buff)) != -1) {
				sbd.append(buff, 0, len);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		WebDebugCaseEntity webDebugCaseEntity = JSONObject.parseObject(sbd.toString(), WebDebugCaseEntity.class);
		log.info("Web˵ID:{} ID:{} :{}",webDebugCaseEntity.getCaseId(),webDebugCaseEntity.getUserId(),webDebugCaseEntity.getCaseType());
		try{
			File file =new File(RunService.APPLICATION_HOME+webDebugCaseEntity.getLoadpath());
			if  (!file .isDirectory())      
			{    
				log.warn("ͻ˲׮·ڣ顾{}",file.getPath());
				return "ͻ˲׮·ڣ顾"+file.getPath()+"";
			}
			Runtime run = Runtime.getRuntime();
			StringBuilder sb=new StringBuilder();
			sb.append(webDebugCaseEntity.getCaseId()).append(" ");
			sb.append(webDebugCaseEntity.getUserId()).append(" ");
			sb.append(webDebugCaseEntity.getCaseType()).append(" ");//޸ĵ
			sb.append(webDebugCaseEntity.getLoadpath());
			if(webDebugCaseEntity.getCaseType().intValue()==0||webDebugCaseEntity.getCaseType().intValue()==2){
				if(OS.startsWith("win")){
					run.exec("cmd.exe /k start " + "web_debugcase.cmd" + " " +sb.toString(), null,new File(RunService.APPLICATION_HOME+File.separator));
				}else{
					Process ps = Runtime.getRuntime().exec(RunService.APPLICATION_HOME+File.separator+"web_debugcase.sh"+ " " +sb.toString());
					ps.waitFor();
				}
			}else if (webDebugCaseEntity.getCaseType().intValue()==1){
				if(OS.startsWith("win")){
					sb.append(" ").append(webDebugCaseEntity.getBrowserType());
					run.exec("cmd.exe /k start " + "web_debugcase_web.cmd" + " " +sb.toString(), null,new File(RunService.APPLICATION_HOME+File.separator));
				}else{
					log.error("ǰ");
				}
			}
		} catch (Exception e) {		
			e.printStackTrace();
			log.error("WebģʽԳ쳣",e);
			return "WebģʽԳ쳣";
		} 
		return "WebģʽԳ";
	}
	
	/**
	 * ȡͻ˱־
	 * @param req HTTP
	 * @return ־ȫϢ
	 */
	@GetMapping("/getLogdDetail")
	private String getLogdDetail(HttpServletRequest req) {
		String fileName=req.getParameter("filename");
		String ctxPath = RunService.APPLICATION_HOME+File.separator+"log";
		String downLoadPath = ctxPath +File.separator+ fileName;

		String str;
		InputStreamReader isr;
		try {
			isr = new InputStreamReader(new FileInputStream(downLoadPath), StandardCharsets.UTF_8);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error("ȡ־·ͻ־·Ƿ!downLoadPath: "+downLoadPath,e);
			return "ȡ־·ͻ־·Ƿ!downLoadPath: "+downLoadPath;
		}
		BufferedReader bos = new BufferedReader(isr);
		StringBuilder sb = new StringBuilder();
		try {
			while ((str = bos.readLine()) != null)
			{
				sb.append(str).append("##n##");
			}
			bos.close();
			log.info("˶ȡ־ɹ!");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error("ͻתBufferedReaderʧܣԭ",e);
			return "ͻתBufferedReaderʧܣԭ";
		}
		return sb.toString();
	}
	
	/**
	 * ȡͼ
	 * @param req HTTP
	 * @return ͼƬֽ
	 */
	@GetMapping("/getLogImg")
	private byte[] getLogImg(HttpServletRequest req) {
		String imgName=req.getParameter("imgName");
		String ctxPath = RunService.APPLICATION_HOME+File.separator+"log"+File.separator+"ScreenShot";
		String downLoadPath = ctxPath+File.separator+imgName;
        byte[] b = null;
        try {
            File file = new File(downLoadPath);
            b = new byte[(int) file.length()];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            //is.read(b);
            is.close();
        	log.info("˻ȡͼƬ:{}",downLoadPath);
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            log.error("ļڣ:{}",downLoadPath,e);
            return b;
        } catch (IOException e) {
            // TODO Auto-generated catch block
            return b;
        }     
        return b;
	}
	
	/**
	 * ϴļͻ
	 */
	@PostMapping("/uploadJar")
	private String uploadJar(HttpServletRequest req, @RequestParam("jarfile") MultipartFile jarfile) {
		if (!jarfile.isEmpty()){
            if (!Objects.requireNonNull(jarfile.getOriginalFilename()).endsWith(".jar")&&!jarfile.getOriginalFilename().endsWith(".py")) {
            	log.warn("ļʽ׺.jar.pyϴʧ");
                return "ļʽ׺.jar.pyϴʧ";
            }
		}else{
			log.warn("ϴļΪգ飡");
            return "ϴļΪգ飡";
		}

		String name = jarfile.getOriginalFilename();
		String loadpath = req.getParameter("loadpath");
		String path = RunService.APPLICATION_HOME+loadpath;
		if  (!new File(path) .isDirectory())      
		{    
			log.warn("ͻ˲׮·ڣ顾{}",path);
			return "ͻ˲׮·ڣ顾"+path+"";
		}	
		String pathName = path +File.separator+ name;

		File file = new File(pathName);
        try { 
            if (file.exists()){
            	file.deleteOnExit();
            }
			boolean newFile = file.createNewFile();
            if(newFile){
				BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
				byte[] jarfileByte = jarfile.getBytes();
				os.write(jarfileByte);
				os.flush();
				os.close();
				log.info("ϴ{}ͻĿ¼{}ɹ!",name,file.getAbsolutePath());
				return "ϴ"+name+"ͻĿ¼"+file.getAbsolutePath()+"ɹ!";
			}else{
				log.error("ϴ{}ͻĿ¼{}ʧ!",name,file.getAbsolutePath());
				return "ϴ"+name+"ͻĿ¼"+file.getAbsolutePath()+"ʧ!";
			}
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            log.error("ͻδҵȷ·ļϴʧܣļ·:{}",pathName,e);
            return "ͻδҵȷ·ļϴʧܣļ·ƣ"+pathName;
        } catch (IOException e) {
            // TODO Auto-generated catch block
            log.error("ͻIOExceptionaδҵ·ļ·:{}",pathName,e);
            return "ͻIOExceptionaδҵ·ļ·ƣ"+pathName;
        }
	}
	
	/**
	 * ͻ
	 * @return 
	 */
	@GetMapping("/getClientStatus")
	private String getClientStatus() {
		Properties properties = SysConfig.getConfiguration();
		String verison=properties.getProperty("client.verison");
		return "{\"status\":\"success\",\"version\":\""+verison+"\"}";
	}

	/**
	 * ȡͻԴ
	 * @return ؿͻԴ
	 * @author Seagull
	 * @date 201955
	 */
	@GetMapping("/getClientMonitorData")
	private String getClientMonitorData() {
        Server server = new Server();
        server.copyTo();
        return JSON.toJSONString(server);
	}
	
	/**
	 * ͻе
	 * @author Seagull
	 * @date 201956
	 */
	public static void checkHostNet() {
		log.info("ͻ,Ժ......");
		Properties properties = SysConfig.getConfiguration();
		String version="Version "+properties.getProperty("client.verison");
		String webip=properties.getProperty("server.web.ip");
		Integer webport=Integer.valueOf(properties.getProperty("server.web.port"));
        try {
        	String result = HttpRequest.loadJSON("/openGetApi/clientGetServerVersion.do");
        	if(version.equals(result)){
            	log.info("ͻ˷Web: {}:{} ͨ......",webip,webport);
        	}else{
        		if(result.startsWith("Version")){
        			log.warn("ͻ˰汾:{} ˰汾:{} ͻ˰汾һ£пܻᵼδ֪⣬...",version,result);
        		}else{
        			log.error("ͻãȡ˰汾Ϣ쳣");
        		}       		
        	}

        } catch (Exception e) {
        	log.error("ͻü쳣ȷĿĿ¼µĿͻļ(sys_config.properties)ǷѾȷá",e);
		}
	}

}
